/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.functions;

import de.lab4inf.math.Complex;
import de.lab4inf.math.functions.Zeta;
import de.lab4inf.math.sets.ComplexNumber;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.NumberTheory;
import org.matheclipse.core.builtin.functions.GammaJS;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.expression.S;

public class ZetaJS {
    private static final int MAX_VALUE_HALF = 0x3FFFFFFF;

    private ZetaJS() {
    }

    public static org.hipparchus.complex.Complex summation(Function<org.hipparchus.complex.Complex, org.hipparchus.complex.Complex> f, double a, double b, int iterationLimit) {
        org.hipparchus.complex.Complex s = org.hipparchus.complex.Complex.ZERO;
        int counter = 0;
        for (double i = a; i <= b; i += 1.0) {
            if (counter++ > iterationLimit && iterationLimit > 0) {
                IterationLimitExceeded.throwIt(counter, S.Sum);
            }
            s = s.add(f.apply(new org.hipparchus.complex.Complex(i)));
        }
        return s;
    }

    public static org.hipparchus.complex.Complex complexAverage(DoubleFunction<org.hipparchus.complex.Complex> f, double x) {
        double offset = 1.0E-5;
        org.hipparchus.complex.Complex arg1 = f.apply(x + offset);
        org.hipparchus.complex.Complex arg2 = f.apply(x - offset);
        return arg1.add(arg2).divide(2.0);
    }

    public static org.hipparchus.complex.Complex complexAverage(Function<org.hipparchus.complex.Complex, org.hipparchus.complex.Complex> f, org.hipparchus.complex.Complex x) {
        double offset = 1.0E-5;
        org.hipparchus.complex.Complex arg1 = f.apply(x.add(offset));
        org.hipparchus.complex.Complex arg2 = f.apply(x.subtract(offset));
        return arg1.add(arg2).divide(2.0);
    }

    public static org.hipparchus.complex.Complex complexSummation(DoubleFunction<org.hipparchus.complex.Complex> f, double a, double b, int iterationLimit) {
        org.hipparchus.complex.Complex s = org.hipparchus.complex.Complex.ZERO;
        int counter = 0;
        for (double i = a; i <= b; i += 1.0) {
            if (counter++ > iterationLimit && iterationLimit > 0) {
                IterationLimitExceeded.throwIt(counter, S.Sum);
            }
            s = s.add(f.apply(i));
        }
        return s;
    }

    public static double sumDouble(DoubleUnaryOperator f, double a, double b, int iterationLimit) {
        double s = 0.0;
        int counter = 0;
        for (double i = a; i <= b; i += 1.0) {
            if (counter++ > iterationLimit && iterationLimit > 0) {
                IterationLimitExceeded.throwIt(counter, S.Sum);
            }
            s += f.applyAsDouble(i);
        }
        return s;
    }

    public static double sumInt(IntToDoubleFunction f, int a, int b, int iterationLimit) {
        double s = 0.0;
        if (b - a > iterationLimit && iterationLimit > 0) {
            IterationLimitExceeded.throwIt(b - a, S.Sum);
        }
        for (int i = a; i <= b; ++i) {
            s += f.applyAsDouble(i);
        }
        return s;
    }

    public static double zeta(double x) {
        return Zeta.zeta((double)x);
    }

    public static org.hipparchus.complex.Complex zeta(org.hipparchus.complex.Complex x) {
        ComplexNumber c = new ComplexNumber(x.getReal(), x.getImaginary());
        c = Zeta.zeta((Complex)c);
        return new org.hipparchus.complex.Complex(c.real(), c.imag());
    }

    public static org.hipparchus.complex.Complex dirichletEta(double x) {
        return ZetaJS.dirichletEta(new org.hipparchus.complex.Complex(x));
    }

    public static org.hipparchus.complex.Complex dirichletEta(org.hipparchus.complex.Complex x) {
        return ZetaJS.zeta(x).multiply(org.hipparchus.complex.Complex.ONE.subtract(new org.hipparchus.complex.Complex(2.0).pow(org.hipparchus.complex.Complex.ONE.subtract(x))));
    }

    public static double bernoulliInt(int n) {
        return NumberTheory.bernoulliDouble(n);
    }

    public static org.hipparchus.complex.Complex bernoulli(int n, org.hipparchus.complex.Complex x) {
        if (n < 0) {
            throw new ArgumentTypeException("Unsupported index for Bernoulli number");
        }
        if (!x.equals((Object)org.hipparchus.complex.Complex.ZERO)) {
            return ZetaJS.hurwitzZeta(new org.hipparchus.complex.Complex((double)(1 - n)), x).multiply(-n);
        }
        if (n == 0) {
            return org.hipparchus.complex.Complex.ONE;
        }
        if (n == 1) {
            return new org.hipparchus.complex.Complex(-0.5);
        }
        if ((n & 1) == 1) {
            return org.hipparchus.complex.Complex.ZERO;
        }
        return new org.hipparchus.complex.Complex((double)(-n) * ZetaJS.zeta(1 - n));
    }

    public static org.hipparchus.complex.Complex hurwitzZeta(org.hipparchus.complex.Complex x, org.hipparchus.complex.Complex a) {
        if (x.getReal() == 1.0 && x.getImaginary() == 0.0) {
            throw new ArgumentTypeException("Hurwitz zeta pole");
        }
        int iterationLimit = EvalEngine.get().getIterationLimit();
        if (a.getReal() < 0.0) {
            double m = -Math.floor(a.getReal());
            return ZetaJS.hurwitzZeta(x, a.add(m)).add(ZetaJS.summation(i -> a.add(i).pow(x.negate()), 0.0, m - 1.0, iterationLimit));
        }
        int n = 15;
        boolean useArbitrary = x.getReal() < 0.0;
        double switchForms = -5.0;
        if (x.getReal() < switchForms) {
            throw new ArgumentTypeException("Currently unsuppported complex Hurwitz zeta");
        }
        org.hipparchus.complex.Complex S2 = ZetaJS.summation(i -> a.add(i).pow(x.negate()), 0.0, n - 1, iterationLimit);
        org.hipparchus.complex.Complex I2 = a.add((double)n).pow(org.hipparchus.complex.Complex.ONE.subtract(x)).divide(x.subtract(1.0));
        org.hipparchus.complex.Complex p = x.multiply(0.5).multiply(a.add((double)n).reciprocal());
        org.hipparchus.complex.Complex t = p.multiply(ZetaJS.bernoulliInt(2));
        int i2 = 1;
        while (Math.abs(p.getReal()) > Config.SPECIAL_FUNCTIONS_TOLERANCE || Math.abs(p.getImaginary()) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
            if (i2++ > iterationLimit && iterationLimit > 0) {
                IterationLimitExceeded.throwIt(i2, S.HurwitzZeta);
            }
            if (i2 > 0x3FFFFFFF) {
                throw new ArgumentTypeException("Hurwitz zeta: i > MAX_VALUE_HALF");
            }
            int iPlusi = i2 + i2;
            p = p.multiply(x.add((double)iPlusi - 2.0).multiply(x.add((double)iPlusi - 3.0)).multiply(a.add((double)n).pow(2.0).multiply(iPlusi * (iPlusi - 1)).reciprocal()));
            t = t.add(p.multiply(ZetaJS.bernoulliInt(iPlusi)));
        }
        org.hipparchus.complex.Complex T = t.add(0.5).divide(a.add((double)n).pow(x));
        return S2.add(I2).add(T);
    }

    public static double hurwitzZeta(double x, double a) {
        if (x == 1.0) {
            throw new ArgumentTypeException("Hurwitz zeta pole");
        }
        if (a < 0.0) {
            throw new ArgumentTypeException("Hurwitz zeta a < 0.0 ");
        }
        int iterationLimit = EvalEngine.get().getIterationLimit();
        double switchForms = -5.0;
        if (x < switchForms) {
            double t;
            double xValue = 1.0 - x;
            double s = t = Math.cos(Math.PI * xValue / 2.0 - Math.PI * 2 * a);
            int i2 = 1;
            while (Math.abs(t) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
                if (i2++ > iterationLimit && iterationLimit > 0) {
                    IterationLimitExceeded.throwIt(i2, S.HurwitzZeta);
                }
                t = Math.cos(Math.PI * xValue / 2.0 - 2.0 * (double)i2 * Math.PI * a) / Math.pow(i2, xValue);
                s += t;
            }
            return 2.0 * GammaJS.gamma(xValue) / Math.pow(Math.PI * 2, xValue) * s;
        }
        int n = 15;
        double S2 = ZetaJS.sumDouble(i -> 1.0 / Math.pow(a + i, x), 0.0, 14.0, iterationLimit);
        double I2 = Math.pow(a + 15.0, 1.0 - x) / (x - 1.0);
        double p = x / 2.0 / (a + 15.0);
        double t = ZetaJS.bernoulliInt(2) * p;
        int i3 = 1;
        while (Math.abs(p) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
            if (i3++ > iterationLimit && iterationLimit > 0) {
                IterationLimitExceeded.throwIt(i3, S.HurwitzZeta);
            }
            if (Double.isNaN(t)) {
                throw new ArgumentTypeException("Hurwitz zeta: t == NaN");
            }
            if (Double.isInfinite(p)) {
                throw new ArgumentTypeException("Hurwitz zeta: p == Infinity");
            }
            if (i3 > 0x3FFFFFFF) {
                throw new ArgumentTypeException("Hurwitz zeta: i > MAX_VALUE_HALF");
            }
            int iPlusi = i3 + i3;
            t += ZetaJS.bernoulliInt(iPlusi) * (p *= (x + (double)iPlusi - 2.0) * (x + (double)iPlusi - 3.0) / ((double)iPlusi * ((double)iPlusi - 1.0) * Math.pow(a + 15.0, 2.0)));
        }
        double T = (0.5 + t) / Math.pow(a + 15.0, x);
        return S2 + I2 + T;
    }

    public static org.hipparchus.complex.Complex polyLog(org.hipparchus.complex.Complex n, org.hipparchus.complex.Complex x) {
        if (x.equals((Object)org.hipparchus.complex.Complex.ONE)) {
            return ZetaJS.zeta(n);
        }
        if (x.equals((Object)org.hipparchus.complex.Complex.MINUS_ONE)) {
            return ZetaJS.dirichletEta(n).negate();
        }
        if (n.equals((Object)org.hipparchus.complex.Complex.ONE)) {
            return org.hipparchus.complex.Complex.ONE.subtract(x).log().negate();
        }
        if (n.equals((Object)org.hipparchus.complex.Complex.ZERO)) {
            return x.divide(org.hipparchus.complex.Complex.ONE.subtract(x));
        }
        if (n.equals((Object)org.hipparchus.complex.Complex.MINUS_ONE)) {
            return x.divide(org.hipparchus.complex.Complex.ONE.subtract(x).multiply(org.hipparchus.complex.Complex.ONE.subtract(x)));
        }
        if (x.norm() >= 1.0) {
            if (F.isZero(n.getImaginary()) && F.isNumIntValue(n.getReal()) && n.getReal() > 0.0) {
                int nInt = NumberUtil.toInt(n.getReal());
                org.hipparchus.complex.Complex twoPiI = new org.hipparchus.complex.Complex(0.0, Math.PI * 2);
                org.hipparchus.complex.Complex t1 = ZetaJS.polyLog(n, x.reciprocal()).multiply(Math.pow(-1.0, nInt));
                org.hipparchus.complex.Complex t2 = twoPiI.pow(nInt).divide(GammaJS.factorialInt(nInt)).multiply(ZetaJS.bernoulli(nInt, x.log().divide(twoPiI)));
                org.hipparchus.complex.Complex t3 = x.getImaginary() < 0.0 || F.isZero(x.getImaginary()) && x.getReal() >= 1.0 ? twoPiI.multiply(x.log().pow(nInt - 1).divide(GammaJS.factorialInt(nInt - 1))) : org.hipparchus.complex.Complex.ZERO;
                return t1.add(t2).add(t3).negate();
            }
            org.hipparchus.complex.Complex v = org.hipparchus.complex.Complex.ONE.subtract(n);
            org.hipparchus.complex.Complex I2 = org.hipparchus.complex.Complex.I;
            org.hipparchus.complex.Complex L = x.negate().log().divide(new org.hipparchus.complex.Complex(0.0, Math.PI * 2));
            org.hipparchus.complex.Complex z1 = I2.pow(v).multiply(ZetaJS.hurwitzZeta(v, L.add(0.5)));
            org.hipparchus.complex.Complex z2 = I2.pow(v.negate()).multiply(ZetaJS.hurwitzZeta(v, new org.hipparchus.complex.Complex(0.5).subtract(L)));
            return GammaJS.gamma(v).multiply(new org.hipparchus.complex.Complex(Math.PI * 2).pow(v.negate())).multiply(z1.add(z2));
        }
        org.hipparchus.complex.Complex s = x;
        org.hipparchus.complex.Complex p = org.hipparchus.complex.Complex.ONE;
        int i = 1;
        int iterationLimit = EvalEngine.get().getIterationLimit();
        while (Math.abs(p.getReal()) > Config.SPECIAL_FUNCTIONS_TOLERANCE || Math.abs(p.getImaginary()) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
            if (i++ > iterationLimit && iterationLimit > 0) {
                IterationLimitExceeded.throwIt(i, S.PolyLog);
            }
            p = x.pow(i).divide(new org.hipparchus.complex.Complex((double)i).pow(n));
            s = s.add(p);
        }
        return s;
    }

    public static org.hipparchus.complex.Complex polyLog(double n, double x) {
        if (F.isEqual(x, 1.0)) {
            return new org.hipparchus.complex.Complex(ZetaJS.zeta(n));
        }
        if (F.isEqual(x, -1.0)) {
            return ZetaJS.dirichletEta(n).negate();
        }
        double oneMinusX = 1.0 - x;
        if (F.isEqual(n, 1.0)) {
            return new org.hipparchus.complex.Complex(-Math.log(oneMinusX));
        }
        if (F.isEqual(n, 0.0)) {
            return new org.hipparchus.complex.Complex(x / oneMinusX);
        }
        if (F.isEqual(n, -1.0)) {
            return new org.hipparchus.complex.Complex(x / (oneMinusX * oneMinusX));
        }
        if (Math.abs(x) >= 1.0) {
            if (F.isNumIntValue(n) && n > 0.0) {
                int nInt = NumberUtil.toInt(n);
                org.hipparchus.complex.Complex twoPiI = new org.hipparchus.complex.Complex(0.0, Math.PI * 2);
                org.hipparchus.complex.Complex t1 = ZetaJS.polyLog(n, 1.0 / x).multiply(Math.pow(-1.0, nInt));
                org.hipparchus.complex.Complex t2 = twoPiI.pow(nInt).divide(GammaJS.factorialInt(n)).multiply(ZetaJS.bernoulli(nInt, new org.hipparchus.complex.Complex(x).log().divide(twoPiI)));
                org.hipparchus.complex.Complex y = new org.hipparchus.complex.Complex(x);
                org.hipparchus.complex.Complex t3 = y.getImaginary() < 0.0 || F.isZero(y.getImaginary()) && y.getReal() >= 1.0 ? twoPiI.multiply(Math.pow(Math.log(x), n - 1.0) / GammaJS.factorialInt(n - 1.0)) : org.hipparchus.complex.Complex.ZERO;
                org.hipparchus.complex.Complex result = t1.add(t2).add(t3).negate();
                if (x < 0.0) {
                    return new org.hipparchus.complex.Complex(result.getReal());
                }
                return result;
            }
            return ZetaJS.polyLog(new org.hipparchus.complex.Complex(n), new org.hipparchus.complex.Complex(x));
        }
        double s = x;
        double p = 1.0;
        int i = 1;
        int iterationLimit = EvalEngine.get().getIterationLimit();
        while (Math.abs(p) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
            if (i++ > iterationLimit && iterationLimit > 0) {
                IterationLimitExceeded.throwIt(i, S.PolyLog);
            }
            p = Math.pow(x, i) / Math.pow(i, n);
            s += p;
        }
        return new org.hipparchus.complex.Complex(s);
    }
}

