/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.functions;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.hipparchus.complex.Complex;
import org.hipparchus.special.Gamma;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Arithmetic;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.exception.ResultException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;

public class HypergeometricJS {
    private HypergeometricJS() {
    }

    public static Complex complexAverage(Function<Complex, Complex> f, Complex x) {
        return HypergeometricJS.complexAverage(f, x, 1.0E-5);
    }

    public static Complex complexAverage(Function<Complex, Complex> f, Complex x, double offset) {
        return f.apply(x.add(offset)).add(f.apply(x.subtract(offset))).divide(2.0);
    }

    public static Complex hypergeometricSeries(Complex[] A, Complex[] B, Complex x) {
        Complex s = Complex.ONE;
        Complex p = Complex.ONE;
        int i = 0;
        while (Math.abs(p.getReal()) > Config.SPECIAL_FUNCTIONS_TOLERANCE || Math.abs(p.getImaginary()) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
            int j;
            for (j = 0; j < A.length; ++j) {
                p = p.multiply(A[j]);
                A[j] = A[j].add(1.0);
            }
            for (j = 0; j < B.length; ++j) {
                p = p.divide(B[j]);
                B[j] = B[j].add(1.0);
            }
            p = p.multiply(x).divide((double)(++i));
            s = s.add(p);
            if (i <= 500) continue;
            throw new ArgumentTypeException("maximum iteration exceeded in hypergeometricSeries (Complex)");
        }
        return s;
    }

    public static double hypergeometricSeries(double[] A, double[] B, double x) {
        double sOld2;
        double sOld1 = 0.0;
        double s = 1.0;
        double p = 1.0;
        int i = 0;
        do {
            sOld2 = sOld1;
            sOld1 = s;
            int j = 0;
            while (j < A.length) {
                p *= A[j];
                int n = j++;
                A[n] = A[n] + 1.0;
            }
            j = 0;
            while (j < B.length) {
                p /= B[j];
                int n = j++;
                B[n] = B[n] + 1.0;
            }
            s += (p *= x / (double)(++i));
            if (i <= 500) continue;
            throw new ArgumentTypeException("maximum iteration exceeded in hypergeometricSeries (double)");
        } while (!HypergeometricJS.hasReachedAccuracy(s, sOld1, 1.0E-12) || !HypergeometricJS.hasReachedAccuracy(sOld1, sOld2, 1.0E-12));
        return s;
    }

    public static boolean hasReachedAccuracy(double xn, double xo, double eps) {
        double z = Math.abs(xn + xo) / 2.0;
        double error = Math.abs(xn - xo);
        if (z > 1.0) {
            error /= z;
        }
        return error <= eps;
    }

    public static double hypergeometric0F1(double a, double x) {
        if (F.isNumIntValue(a) && a <= 0.0) {
            throw new ArgumentTypeException("Hypergeometric function pole");
        }
        double useAsymptotic = 100.0;
        if (Math.abs(x) > 100.0) {
            return HypergeometricJS.hypergeometric0F1(new Complex(a), new Complex(x)).getReal();
        }
        double s = 1.0;
        double p = 1.0;
        long i = 1L;
        long iterationLimit = EvalEngine.get().getIterationLimit();
        while (Math.abs(p) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
            s += (p *= x / a / (double)i);
            a += 1.0;
            if (i++ <= iterationLimit || iterationLimit <= 0L) continue;
            IterationLimitExceeded.throwIt(i, S.Hypergeometric0F1);
        }
        return s;
    }

    public static Complex hypergeometric0F1(Complex a, Complex x) {
        double useAsymptotic = 100.0;
        if (a.isMathematicalInteger() && a.getReal() <= 0.0) {
            throw new ArgumentTypeException("hypergeometric function pole");
        }
        if (x.norm() > 100.0) {
            Complex b = a.multiply(2).subtract(1.0);
            a = a.subtract(0.5);
            x = x.sqrt().multiply(4.0);
            Complex t1 = Arithmetic.lanczosApproxGamma(b).multiply(x.negate().pow(a.negate())).multiply(Arithmetic.lanczosApproxGamma(b.subtract(a)).reciprocal());
            t1 = t1.multiply(HypergeometricJS.hypergeometric2F0(a, a.add(b.negate()).add(1.0), new Complex(-1.0).divide(x)));
            Complex t2 = Arithmetic.lanczosApproxGamma(b).multiply(x.pow(a.subtract(b))).multiply(x.exp()).multiply(Arithmetic.lanczosApproxGamma(a).reciprocal());
            t2 = t2.multiply(HypergeometricJS.hypergeometric2F0(b.subtract(a), Complex.ONE.subtract(a), Complex.ONE.divide(x)));
            return x.divide(-2.0).exp().multiply(t1.add(t2));
        }
        Complex s = Complex.ONE;
        Complex p = Complex.ONE;
        long i = 1L;
        long iterationLimit = EvalEngine.get().getIterationLimit();
        while (Math.abs(p.getReal()) > Config.SPECIAL_FUNCTIONS_TOLERANCE || Math.abs(p.getImaginary()) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
            p = p.multiply(x).multiply(a.reciprocal()).divide((double)i);
            s = s.add(p);
            a = a.add(1.0);
            if (i++ <= iterationLimit || iterationLimit <= 0L) continue;
            IterationLimitExceeded.throwIt(i, S.Hypergeometric0F1);
        }
        return s;
    }

    public static Complex hypergeometric1F1(Complex a, Complex b, Complex x) {
        double useAsymptotic = 30.0;
        if (b.isMathematicalInteger() && b.getReal() <= 0.0) {
            throw new ArgumentTypeException("hypergeometric function pole");
        }
        if (x.getReal() < 0.0) {
            return x.exp().multiply(HypergeometricJS.hypergeometric1F1(b.subtract(a), b, x.negate()));
        }
        if (x.norm() > 30.0) {
            Complex t1 = Arithmetic.lanczosApproxGamma(b).multiply(x.negate().pow(a.negate())).multiply(Arithmetic.lanczosApproxGamma(b.subtract(a)).reciprocal());
            t1 = t1.multiply(HypergeometricJS.hypergeometric2F0(a, a.add(b.negate()).add(1.0), new Complex(-1.0).divide(x)));
            Complex t2 = Arithmetic.lanczosApproxGamma(b).multiply(x.pow(a.subtract(b))).multiply(x.exp()).multiply(Arithmetic.lanczosApproxGamma(a).reciprocal());
            t2 = t2.multiply(HypergeometricJS.hypergeometric2F0(b.subtract(a), Complex.ONE.subtract(a), Complex.ONE.divide(x)));
            return t1.add(t2);
        }
        Complex s = Complex.ONE;
        Complex p = Complex.ONE;
        long i = 1L;
        long iterationLimit = EvalEngine.get().getIterationLimit();
        while (Math.abs(p.getReal()) > Config.SPECIAL_FUNCTIONS_TOLERANCE || Math.abs(p.getImaginary()) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
            p = p.multiply(x).multiply(a).multiply(b.reciprocal()).divide((double)i);
            s = s.add(p);
            a = a.add(1.0);
            b = b.add(1.0);
            if (i++ <= iterationLimit || iterationLimit <= 0L) continue;
            IterationLimitExceeded.throwIt(i, S.Hypergeometric1F1);
        }
        return s;
    }

    public static double hypergeometric1F1(double a, double b, double x) {
        double useAsymptotic = 30.0;
        if (F.isNumIntValue(b) && b <= 0.0) {
            throw new ArgumentTypeException("hypergeometric function pole");
        }
        if (x < 0.0) {
            return Math.exp(x) * HypergeometricJS.hypergeometric1F1(b - a, b, -x);
        }
        if (Math.abs(x) > 30.0) {
            return HypergeometricJS.hypergeometric1F1(new Complex(a), new Complex(b), new Complex(x)).getReal();
        }
        double s = 1.0;
        double p = 1.0;
        long i = 1L;
        long iterationLimit = EvalEngine.get().getIterationLimit();
        while (Math.abs(p) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
            s += (p *= x * a / b / (double)i);
            a += 1.0;
            b += 1.0;
            if (i++ <= iterationLimit || iterationLimit <= 0L) continue;
            IterationLimitExceeded.throwIt(i, S.Hypergeometric1F1);
        }
        return s;
    }

    public static Complex hypergeometric2F0(Complex a, Complex b, Complex x) {
        return HypergeometricJS.hypergeometric2F0(a, b, x, Config.SPECIAL_FUNCTIONS_TOLERANCE);
    }

    public static Complex hypergeometric2F0(Complex a, Complex b, Complex x, double tolerance) {
        Complex p;
        int terms = 50;
        Complex s = Complex.ONE;
        Complex pLast = p = Complex.ONE;
        boolean converging = false;
        int i = 1;
        while (!(!(Math.abs(p.getReal()) > tolerance) && !(Math.abs(p.getImaginary()) > tolerance) || (p = p.multiply(x).multiply(a).multiply(b).divide((double)i)).norm() > pLast.norm() && converging)) {
            if (p.norm() < pLast.norm()) {
                converging = true;
            }
            if (i > terms) {
                throw new ArgumentTypeException("not converging after " + terms + " terms");
            }
            s = s.add(p);
            a = a.add(1.0);
            b = b.add(1.0);
            ++i;
            pLast = p;
        }
        return s;
    }

    public static double hypergeometric2F0(double a, double b, double x) {
        return HypergeometricJS.hypergeometric2F0(a, b, x, Config.SPECIAL_FUNCTIONS_TOLERANCE);
    }

    public static double hypergeometric2F0(double a, double b, double x, double tolerance) {
        double p;
        int terms = 50;
        double s = 1.0;
        double pLast = p = 1.0;
        boolean converging = false;
        double i = 1.0;
        while (!(!(Math.abs(p) > tolerance) || Math.abs(p *= x * a * b / i) > Math.abs(pLast) && converging)) {
            if (Math.abs(p) < Math.abs(pLast)) {
                converging = true;
            }
            if (i > (double)terms) {
                throw new ArgumentTypeException("not converging after " + terms + " terms");
            }
            s += p;
            a += 1.0;
            b += 1.0;
            i += 1.0;
            pLast = p;
        }
        return s;
    }

    public static Complex hypergeometric2F1(Complex a, Complex b, Complex c, Complex x) {
        return HypergeometricJS.hypergeometric2F1(a, b, c, x, Config.SPECIAL_FUNCTIONS_TOLERANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Complex hypergeometric2F1(Complex a, Complex b, Complex c, Complex x, double tolerance) {
        if (F.isFuzzyEquals(a, c, tolerance)) {
            return Complex.ONE.subtract(x).pow(b.negate());
        }
        if (F.isFuzzyEquals(b, c, tolerance)) {
            return Complex.ONE.subtract(x).pow(a.negate());
        }
        EvalEngine engine = EvalEngine.get();
        int recursionLimit = engine.getRecursionLimit();
        try {
            int counter;
            if (recursionLimit > 0 && (counter = engine.incRecursionCounter()) > recursionLimit) {
                RecursionLimitExceeded.throwIt(counter, F.Hypergeometric2F1(F.complexNum(a), F.complexNum(b), F.complexNum(c), F.complexNum(x)));
            }
            double[] absArray = new double[]{x.norm(), x.divide(x.subtract(1.0)).norm(), new Complex(1.0).subtract(x).norm(), x.reciprocal().norm(), new Complex(1.0).subtract(x).reciprocal().norm(), new Complex(1.0).subtract(x.reciprocal()).norm()};
            double min = Double.POSITIVE_INFINITY;
            double newMin = Double.POSITIVE_INFINITY;
            int index = -1;
            for (int i = 0; i < absArray.length; ++i) {
                newMin = Math.min(min, absArray[i]);
                if (newMin == min) continue;
                min = newMin;
                index = i;
            }
            Complex subtractCA = c.subtract(a);
            Complex subtractCB = c.subtract(b);
            Complex af = a;
            Complex bf = b;
            Complex cf = c;
            Complex xf = x;
            switch (index) {
                case 0: {
                    break;
                }
                case 1: {
                    Complex complex = new Complex(1.0).subtract(x).pow(a.negate()).multiply(HypergeometricJS.hypergeometric2F1(a, c.subtract(b), c, x.divide(x.subtract(1.0))));
                    return complex;
                }
                case 2: {
                    if (c.subtract(a.add(b)).isMathematicalInteger() || subtractCA.isMathematicalInteger() && subtractCA.getReal() <= 0.0) {
                        Complex complex = HypergeometricJS.complexAverage(v -> HypergeometricJS.hypergeometric2F1(v, bf, cf, xf), af);
                        return complex;
                    }
                    if (subtractCB.isMathematicalInteger() && subtractCB.getReal() <= 0.0) {
                        Complex complex = HypergeometricJS.complexAverage(v -> HypergeometricJS.hypergeometric2F1(af, v, cf, xf), bf);
                        return complex;
                    }
                    Complex t1 = Arithmetic.lanczosApproxGamma(c).multiply(Arithmetic.lanczosApproxGamma(c.subtract(a.add(b)))).multiply(Arithmetic.lanczosApproxGamma(subtractCA).reciprocal()).multiply(Arithmetic.lanczosApproxGamma(c.subtract(b)).reciprocal()).multiply(HypergeometricJS.hypergeometric2F1(a, b, a.add(b).add(c.negate()).add(1.0), new Complex(1.0).subtract(x)));
                    Complex t2 = new Complex(1.0).subtract(x).pow(c.subtract(a.add(b))).multiply(Arithmetic.lanczosApproxGamma(c)).multiply(Arithmetic.lanczosApproxGamma(a.add(b).subtract(c))).multiply(Arithmetic.lanczosApproxGamma(a).reciprocal()).multiply(Arithmetic.lanczosApproxGamma(b).reciprocal()).multiply(HypergeometricJS.hypergeometric2F1(subtractCA, c.subtract(b), a.add(a.negate()).add(b.negate()).add(1.0), new Complex(1.0).subtract(x)));
                    Complex complex = t1.add(t2);
                    return complex;
                }
                case 3: {
                    if (a.subtract(b).isMathematicalInteger() || subtractCA.isMathematicalInteger() && subtractCA.getReal() <= 0.0) {
                        Complex t1 = HypergeometricJS.complexAverage(v -> HypergeometricJS.hypergeometric2F1(v, bf, cf, xf), af);
                        return t1;
                    }
                    if (subtractCB.isMathematicalInteger() && subtractCB.getReal() <= 0.0) {
                        Complex t1 = HypergeometricJS.complexAverage(v -> HypergeometricJS.hypergeometric2F1(af, v, cf, xf), bf);
                        return t1;
                    }
                    Complex t1 = Arithmetic.lanczosApproxGamma(c).multiply(Arithmetic.lanczosApproxGamma(b.subtract(a))).multiply(Arithmetic.lanczosApproxGamma(b).reciprocal()).multiply(Arithmetic.lanczosApproxGamma(subtractCA).reciprocal()).multiply(x.negate().pow(a.negate())).multiply(HypergeometricJS.hypergeometric2F1(a, a.add(1.0).add(c.negate()), a.add(1.0).add(b.negate()), x.reciprocal()));
                    Complex t2 = Arithmetic.lanczosApproxGamma(c).multiply(Arithmetic.lanczosApproxGamma(a.subtract(b))).multiply(Arithmetic.lanczosApproxGamma(a).reciprocal()).multiply(Arithmetic.lanczosApproxGamma(c.subtract(b)).reciprocal()).multiply(x.negate().pow(b.negate())).multiply(HypergeometricJS.hypergeometric2F1(b, b.add(1.0).add(c.negate()), b.add(1.0).add(a.negate()), x.reciprocal()));
                    Complex complex = t1.add(t2);
                    return complex;
                }
                case 4: {
                    if (a.subtract(b).isMathematicalInteger() || subtractCA.isMathematicalInteger() && subtractCA.getReal() <= 0.0) {
                        Complex t1 = HypergeometricJS.complexAverage(v -> HypergeometricJS.hypergeometric2F1(v, bf, cf, xf), af);
                        return t1;
                    }
                    if (subtractCB.isMathematicalInteger() && subtractCB.getReal() <= 0.0) {
                        Complex t1 = HypergeometricJS.complexAverage(v -> HypergeometricJS.hypergeometric2F1(af, v, cf, xf), bf);
                        return t1;
                    }
                    Complex t1 = new Complex(1.0).subtract(x).pow(a.negate()).multiply(Arithmetic.lanczosApproxGamma(c)).multiply(Arithmetic.lanczosApproxGamma(b.subtract(a))).multiply(Arithmetic.lanczosApproxGamma(b).reciprocal()).multiply(Arithmetic.lanczosApproxGamma(subtractCA).reciprocal()).multiply(HypergeometricJS.hypergeometric2F1(a, c.subtract(b), a.add(b.negate()).add(1.0), new Complex(1.0).subtract(x).reciprocal()));
                    Complex t2 = new Complex(1.0).subtract(x).pow(b.negate()).multiply(Arithmetic.lanczosApproxGamma(c)).multiply(Arithmetic.lanczosApproxGamma(a.subtract(b))).multiply(Arithmetic.lanczosApproxGamma(a).reciprocal()).multiply(Arithmetic.lanczosApproxGamma(c.subtract(b)).reciprocal()).multiply(HypergeometricJS.hypergeometric2F1(b, subtractCA, b.add(a.negate()).add(1.0), new Complex(1.0).subtract(x).reciprocal()));
                    Complex complex = t1.add(t2);
                    return complex;
                }
                case 5: {
                    if (c.subtract(a.add(b)).isMathematicalInteger() || subtractCA.isMathematicalInteger() && subtractCA.getReal() <= 0.0) {
                        Complex t1 = HypergeometricJS.complexAverage(v -> HypergeometricJS.hypergeometric2F1(v, bf, cf, xf), af);
                        return t1;
                    }
                    if (subtractCB.isMathematicalInteger() && subtractCB.getReal() <= 0.0) {
                        Complex t1 = HypergeometricJS.complexAverage(v -> HypergeometricJS.hypergeometric2F1(af, v, cf, xf), bf);
                        return t1;
                    }
                    Complex t1 = Arithmetic.lanczosApproxGamma(c).multiply(Arithmetic.lanczosApproxGamma(c.subtract(a.add(b)))).multiply(Arithmetic.lanczosApproxGamma(subtractCA).reciprocal()).multiply(Arithmetic.lanczosApproxGamma(c.subtract(b)).reciprocal()).multiply(x.pow(a.negate())).multiply(HypergeometricJS.hypergeometric2F1(a, a.add(c.negate()).add(1.0), a.add(b).add(c.negate()).add(1.0), new Complex(1.0).subtract(x.reciprocal())));
                    Complex t2 = Arithmetic.lanczosApproxGamma(c).multiply(Arithmetic.lanczosApproxGamma(a.add(b).subtract(c))).multiply(Arithmetic.lanczosApproxGamma(a).reciprocal()).multiply(Arithmetic.lanczosApproxGamma(b).reciprocal()).multiply(new Complex(1.0).subtract(x).pow(c.subtract(a.add(b)))).multiply(x.pow(a.subtract(c))).multiply(HypergeometricJS.hypergeometric2F1(subtractCA, new Complex(1.0).subtract(a), c.add(a.negate()).add(b.negate()).add(1.0), new Complex(1.0).subtract(x.reciprocal())));
                    Complex complex = t1.add(t2);
                    return complex;
                }
            }
            if (c.isMathematicalInteger() && c.getReal() <= 0.0) {
                throw new ResultException(F.CComplexInfinity);
            }
            Complex s = Complex.ONE;
            Complex p = Complex.ONE;
            int i = 1;
            long iterationLimit = engine.getIterationLimit();
            while (Math.abs(p.getReal()) > tolerance || Math.abs(p.getImaginary()) > tolerance) {
                p = p.multiply(x).multiply(a).multiply(b).multiply(c.reciprocal()).divide((double)i);
                s = s.add(p);
                a = a.add(1.0);
                b = b.add(1.0);
                c = c.add(1.0);
                if ((long)i++ <= iterationLimit || iterationLimit <= 0L) continue;
                IterationLimitExceeded.throwIt(i, S.Hypergeometric2F1);
            }
            Complex complex = s;
            return complex;
        }
        finally {
            if (recursionLimit > 0) {
                engine.decRecursionCounter();
            }
        }
    }

    public static double hypergeometric2F1(double a, double b, double c, double x) {
        return HypergeometricJS.hypergeometric2F1(a, b, c, x, Config.SPECIAL_FUNCTIONS_TOLERANCE);
    }

    public static double hypergeometric2F1(double a, double b, double c, double x, double tolerance) {
        if (F.isFuzzyEquals(a, c, tolerance)) {
            return Math.pow(1.0 - x, -b);
        }
        if (F.isFuzzyEquals(b, c, tolerance)) {
            return Math.pow(1.0 - x, -a);
        }
        if (F.isNumIntValue(c) && c <= 0.0) {
            throw new ResultException(F.CComplexInfinity);
        }
        if (x < -1.0) {
            double t1 = Gamma.gamma((double)c) * Gamma.gamma((double)(b - a)) / Gamma.gamma((double)b) / Gamma.gamma((double)(c - a)) * Math.pow(-x, -a) * HypergeometricJS.hypergeometric2F1(a, 1.0 - c + a, 1.0 - b + a, 1.0 / x);
            double t2 = Gamma.gamma((double)c) * Gamma.gamma((double)(a - b)) / Gamma.gamma((double)a) / Gamma.gamma((double)(c - b)) * Math.pow(-x, -b) * HypergeometricJS.hypergeometric2F1(b, 1.0 - c + b, 1.0 - a + b, 1.0 / x);
            return t1 + t2;
        }
        if (F.isNumIntValue(x, -1)) {
            return HypergeometricJS.hypergeometric2F1(new Complex(a), new Complex(b), new Complex(c), new Complex(x)).getReal();
        }
        if (F.isNumIntValue(x, 1)) {
            if (c - a - b > 0.0) {
                return Gamma.gamma((double)c) * Gamma.gamma((double)(c - a - b)) / Gamma.gamma((double)(c - a)) / Gamma.gamma((double)(c - b));
            }
            throw new ResultException(F.CComplexInfinity);
        }
        if (x > 1.0) {
            throw new ArgumentTypeException("unsupported real hypergeometric argument");
        }
        double s = 1.0;
        double p = 1.0;
        int i = 1;
        long iterationLimit = EvalEngine.get().getIterationLimit();
        while (Math.abs(p) > tolerance) {
            s += (p *= x * a * b / c / (double)i);
            a += 1.0;
            b += 1.0;
            c += 1.0;
            if ((long)i++ <= iterationLimit || iterationLimit <= 0L) continue;
            IterationLimitExceeded.throwIt(i, S.Hypergeometric2F1);
        }
        return s;
    }

    public static double hypergeometric1F2(double a, double b, double c, double x, double tolerance) {
        int useAsymptotic = 200;
        if (Math.abs(x) > (double)useAsymptotic) {
            return HypergeometricJS.hypergeometric1F2(new Complex(a), new Complex(b), new Complex(c), new Complex(x)).getReal();
        }
        return HypergeometricJS.hypergeometricSeries(new double[]{a}, new double[]{b, c}, x);
    }

    public static Complex hypergeometricPFQ(Complex[] A, Complex[] B, Complex x) {
        return HypergeometricJS.hypergeometricPFQ(A, B, x, Config.SPECIAL_FUNCTIONS_TOLERANCE);
    }

    public static Complex hypergeometricPFQ(Complex[] A, Complex[] B, Complex x, double tolerance) {
        if (x.norm() > 1.0) {
            throw new ArgumentTypeException("general hypergeometric argument currently restricted");
        }
        return HypergeometricJS.hypergeometricSeries(A, B, x);
    }

    public static Complex hypergeometric1F2(Complex a, Complex b, Complex c, Complex x) {
        int useAsymptotic = 200;
        if (x.norm() > 200.0) {
            Complex p = a.add(b.negate()).add(c.negate()).add(0.5).divide(2.0);
            ArrayList<Complex> ck = new ArrayList<Complex>();
            ck.add(Complex.ONE);
            ck.add(a.multiply(3.0).add(b).add(c).add(-2.0).multiply(a.subtract(b.add(c))).multiply(0.5).add(b.multiply(c).multiply(2)).add(-0.375));
            ck.add(a.multiply(3.0).add(b).add(c).add(-2.0).multiply(a.subtract(b.add(c))).multiply(0.25).add(b.multiply(c).add(-0.1875)).pow(2).multiply(2));
            ck.add(new Complex(-1.0).multiply(a.multiply(2.0).subtract(3.0)).multiply(b).multiply(c));
            ck.add(a.pow(2.0).multiply(-8.0).add(a.multiply(11.0)).add(b).add(c).add(-2.0).multiply(a.subtract(b.add(c))).multiply(0.25));
            ck.add(new Complex(-0.1875));
            IntFunction<Complex> w = k -> ((Complex)ck.get(k)).multiply(x.negate().pow((double)(-k) / 2.0)).divide(Math.pow(2.0, k));
            Complex u1 = Complex.I.multiply(p.multiply(Math.PI).add(x.negate().sqrt().multiply(2.0))).exp();
            Complex u2 = new Complex(0.0, -1.0).multiply(p.multiply(Math.PI).add(x.negate().sqrt().multiply(2.0))).exp();
            Complex wLast = w.apply(2);
            Complex w2Negate = wLast.negate();
            Complex s = u1.multiply(new Complex(0.0, -1.0).multiply(w.apply(1)).add(w2Negate).add(1.0)).add(u2.multiply(Complex.I.multiply(w.apply(1)).add(w2Negate).add(1.0)));
            int k2 = 3;
            while (wLast.norm() > w.apply(k2).norm()) {
                ck.add(a.multiply(-6.0).add(b.multiply(2)).add(c.multiply(2.0)).add(-4.0).multiply(k2).add(a.pow(a).multiply(3.0)).add(b.subtract(c).pow(2.0).negate()).add(a.multiply(b.add(c).add(-2.0)).multiply(2.0).negate()).add(0.25).add(3.0 * (double)k2 * (double)k2).multiply(1.0 / (2.0 * (double)k2)).multiply((Complex)ck.get(k2 - 1)).subtract(a.negate().add(b).add(c.negate()).add(-0.5).add((double)k2).multiply(a.negate().add(b.negate()).add(c).add(-0.5).add((double)k2)).multiply(a.negate().add(b).add(c).add(-2.5).add((double)k2)).multiply((Complex)ck.get(k2 - 2))));
                wLast = w.apply(k2);
                s = s.add(u1.multiply(new Complex(0.0, -1.0).pow(k2)).multiply(wLast).add(u2.multiply(Complex.I.pow(k2)).multiply(wLast)));
                ++k2;
            }
            Complex t1 = Arithmetic.lanczosApproxGamma(a).reciprocal().multiply(x.negate().pow(p)).multiply(s).divide(2.0 * Math.sqrt(Math.PI));
            Complex t2 = Arithmetic.lanczosApproxGamma(b.subtract(a)).reciprocal().multiply(Arithmetic.lanczosApproxGamma(c.subtract(a)).reciprocal()).multiply(x.negate().pow(a.negate())).multiply(HypergeometricJS.hypergeometricSeries(new Complex[]{a, a.add(b.negate()).add(1.0), a.add(c.negate().add(1.0))}, new Complex[0], x.reciprocal()));
            return Arithmetic.lanczosApproxGamma(b).multiply(Arithmetic.lanczosApproxGamma(c)).multiply(t1.add(t2));
        }
        return HypergeometricJS.hypergeometricSeries(new Complex[]{a}, new Complex[]{b, c}, x);
    }

    public static double hypergeometric1F2(double a, double b, double c, double x) {
        double useAsymptotic = 200.0;
        if (Math.abs(x) > 200.0) {
            return HypergeometricJS.hypergeometric1F2(new Complex(a), new Complex(b), new Complex(c), new Complex(x)).getReal();
        }
        return HypergeometricJS.hypergeometricSeries(new double[]{a}, new double[]{b, c}, x);
    }

    public static double hypergeometricPFQ(double[] A, double[] B, double x) {
        if (Math.abs(x) > 1.0) {
            throw new ArgumentTypeException("general hypergeometric argument currently restricted");
        }
        return HypergeometricJS.hypergeometricSeries(A, B, x);
    }

    public static Complex hypergeometricU(Complex a, Complex b, Complex x) {
        double useAsymptotic = 20.0;
        if (x.norm() > useAsymptotic) {
            return x.pow(a.negate()).multiply(HypergeometricJS.hypergeometric2F0(a, a.add(b.negate()).add(1.0), x.reciprocal().negate()));
        }
        if (b.equals((Object)Complex.ONE) || F.isNumIntValue(b.getReal(), 1) && F.isZero(b.getImaginary())) {
            return HypergeometricJS.complexAverage(arg -> HypergeometricJS.hypergeometricU(a, arg, x), b);
        }
        Complex t1 = Arithmetic.lanczosApproxGamma(b.subtract(1.0)).multiply(Arithmetic.lanczosApproxGamma(a).reciprocal()).multiply(x.pow(Complex.ONE.subtract(b)).multiply(HypergeometricJS.hypergeometric1F1(a.add(b.negate()).add(1.0), b.negate().add(2.0), x)));
        Complex t2 = Arithmetic.lanczosApproxGamma(Complex.ONE.subtract(b)).multiply(Arithmetic.lanczosApproxGamma(a.add(b.negate()).add(1.0)).reciprocal()).multiply(HypergeometricJS.hypergeometric1F1(a, b, x));
        return t1.add(t2);
    }

    public static Complex whittakerM(Complex k, Complex m, Complex x) {
        return x.multiply(-0.5).exp().multiply(x.pow(m.add(0.5))).multiply(HypergeometricJS.hypergeometric1F1(m.add(k.negate()).add(0.5), m.multiply(2.0).add(1.0), x));
    }

    public static Complex whittakerW(Complex k, Complex m, Complex x) {
        return x.multiply(-0.5).exp().multiply(x.pow(m.add(0.5))).multiply(HypergeometricJS.hypergeometricU(m.add(k.negate()).add(0.5), m.multiply(2.0).add(1.0), x));
    }
}

