/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.functions;

import com.google.common.math.DoubleMath;
import de.lab4inf.math.Function;
import de.lab4inf.math.gof.Visitable;
import de.lab4inf.math.gof.Visitor;
import de.lab4inf.math.util.Accuracy;
import de.lab4inf.math.util.ContinuedFraction;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.FiniteDifferencesDifferentiator;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.complex.Complex;
import org.hipparchus.special.Beta;
import org.hipparchus.special.Gamma;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Arithmetic;
import org.matheclipse.core.builtin.functions.HypergeometricJS;
import org.matheclipse.core.builtin.functions.ZetaJS;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.generic.UnaryNumerical;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;

public class GammaJS {
    private static final double DEFAULT_EPSILON = 1.0E-14;
    private static final int MAX_ITERATIONS = 1500;
    static final double[] c = new double[]{57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};

    private GammaJS() {
    }

    private static double regGammaP(double a, double x, double eps, int max) {
        double ret = 0.0;
        if (a <= 0.0 || x < 0.0) {
            throw new ArgumentTypeException(String.format("P(%f,%f)", a, x));
        }
        if (a >= 1.0 && x > a) {
            ret = 1.0 - GammaJS.regGammaQ(a, x, eps, max);
        } else if (x > 0.0) {
            double so;
            double an;
            int n = 1;
            double ea = Math.exp(-x + a * Math.log(x) - GammaJS.logGamma(a));
            double err = eps;
            double sn = an = 1.0 / a;
            while (!Accuracy.hasConverged((double)(sn += (an *= x / (a + (double)n))), (double)(so = sn), (double)err, (int)(++n), (int)max)) {
            }
            ret = ea * sn;
        }
        return ret;
    }

    private static double regGammaQ(double a, double x, double epsilon, int maxIterations) {
        double ret = 0.0;
        if (a <= 0.0 || x < 0.0) {
            throw new ArgumentTypeException(String.format("Q(%f,%f)", a, x));
        }
        if (x < a || a < 1.0) {
            ret = 1.0 - GammaJS.regGammaP(a, x, epsilon, maxIterations);
        } else if (x > 0.0) {
            double ea = Math.exp(-x + a * Math.log(x) - GammaJS.logGamma(a));
            double err = epsilon;
            RegularizedGammaFraction cf = new RegularizedGammaFraction(a);
            ret = 1.0 / cf.evaluate(x, err, maxIterations);
            ret *= ea;
        }
        return ret;
    }

    public static double factorialInt(double n) {
        if (n < 0.0) {
            throw new ArgumentTypeException("Factorial: n<0.0");
        }
        return DoubleMath.factorial((int)NumberUtil.toInt(n));
    }

    public static Complex beta(Complex x, Complex y) {
        return Arithmetic.lanczosApproxGamma(x).multiply(Arithmetic.lanczosApproxGamma(y)).divide(Arithmetic.lanczosApproxGamma(x.add(y)));
    }

    public static Complex beta(Complex x, Complex y, Complex z) {
        return x.pow(y).multiply(HypergeometricJS.hypergeometric2F1(y, new Complex(1.0).subtract(z), y.add(1.0), x)).divide(y);
    }

    public static Complex beta(Complex x, Complex y, Complex z, Complex w) {
        return GammaJS.beta(y, z, w).subtract(GammaJS.beta(x, z, w));
    }

    public static double beta(double x, double y) {
        return Gamma.gamma((double)x) * Gamma.gamma((double)y) / Gamma.gamma((double)(x + y));
    }

    public static double beta(double x, double y, double z) {
        return Math.pow(x, y) * HypergeometricJS.hypergeometric2F1(y, 1.0 - z, y + 1.0, x) / y;
    }

    public static double beta(double x, double y, double z, double w) {
        return GammaJS.beta(y, z, w) - GammaJS.beta(x, z, w);
    }

    public static Complex betaRegularized(Complex x, Complex y, Complex z) {
        return GammaJS.beta(x, y, z).divide(GammaJS.beta(y, z));
    }

    public static Complex betaRegularized(Complex x, Complex y, Complex z, Complex w) {
        return GammaJS.beta(x, y, z, w).divide(GammaJS.beta(z, w));
    }

    public static double betaRegularized(double x, double y, double z) {
        if (y < 0.0) {
            throw new ArgumentTypeException("y not positiv: " + y);
        }
        if (z < 0.0) {
            throw new ArgumentTypeException("z not positiv: " + z);
        }
        if (x < 0.0 || x > 1.0) {
            throw new ArgumentTypeException("x range wrong: " + x);
        }
        return Beta.regularizedBeta((double)x, (double)y, (double)z);
    }

    public static double betaRegularized(double x, double y, double z, double w) {
        return GammaJS.beta(x, y, z, w) / GammaJS.beta(z, w);
    }

    public static INumber incompleteBeta(double x, double y, double z) {
        if (x == -1.0 || x > 1.0) {
            return F.complexNum(GammaJS.beta(new Complex(x), new Complex(y), new Complex(z)));
        }
        return F.num(GammaJS.beta(x, y, z));
    }

    public static Complex fresnelS(Complex x) {
        Complex m1 = HypergeometricJS.hypergeometric1F1(new Complex(0.5), new Complex(1.5), new Complex(0.0, 1.5707963267948966).multiply(x.multiply(x)));
        Complex m2 = HypergeometricJS.hypergeometric1F1(new Complex(0.5), new Complex(1.5), new Complex(0.0, -1.5707963267948966).multiply(x.multiply(x)));
        Complex result = x.multiply(m1.subtract(m2)).multiply(new Complex(0.0, -0.5));
        return result;
    }

    public static Complex fresnelC(Complex x) {
        Complex m1 = HypergeometricJS.hypergeometric1F1(new Complex(0.5), new Complex(1.5), new Complex(0.0, 1.5707963267948966).multiply(x.multiply(x)));
        Complex m2 = HypergeometricJS.hypergeometric1F1(new Complex(0.5), new Complex(1.5), new Complex(0.0, -1.5707963267948966).multiply(x.multiply(x)));
        Complex result = x.multiply(m1.add(m2)).multiply(0.5);
        return result;
    }

    public static Complex gamma(Complex x) {
        return Arithmetic.lanczosApproxGamma(x);
    }

    public static double gamma(double x) {
        return Gamma.gamma((double)x);
    }

    public static double gamma(double x, double y) {
        return Gamma.gamma((double)x) * GammaJS.regGammaQ(x, y, 1.0E-14, 1500);
    }

    public static Complex gamma(Complex x, Complex y) {
        double xRe;
        if (F.isZero(x)) {
            if (F.isZero(y)) {
                throw new ArgumentTypeException("Gamma function pole");
            }
            Complex yLogNegate = y.log().negate();
            Complex result = GammaJS.expIntegralEi(y.negate()).negate().add(y.negate().log().subtract(y.reciprocal().negate().log()).multiply(0.5)).add(yLogNegate);
            if (F.isZero(y.getImaginary()) && y.getReal() > 0.0) {
                return new Complex(result.getReal());
            }
            return result;
        }
        double delta = 1.0E-5;
        if (x.norm() < delta) {
            // empty if block
        }
        if ((xRe = x.getReal()) < 0.0 && F.isNumIntValue(xRe) && F.isZero(x.getImaginary())) {
            double n = -xRe;
            int iterationLimit = EvalEngine.get().getIterationLimit();
            Complex t = y.negate().exp().multiply(ZetaJS.complexSummation(k -> new Complex(Math.pow(-1.0, k) * GammaJS.factorialInt(k)).divide(y.pow(k + 1.0)), 0.0, n - 1.0, iterationLimit));
            double plusMinusOne = Math.pow(-1.0, n);
            return GammaJS.gamma(Complex.ZERO, y).subtract(t).multiply(plusMinusOne / GammaJS.factorialInt(n));
        }
        return Arithmetic.lanczosApproxGamma(x).subtract(GammaJS.gamma(x, 0.0, y));
    }

    public static Complex gamma(Complex x, double y, Complex z) {
        if (!F.isZero(y, Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
            return GammaJS.gamma(x, 0.0, z).subtract(GammaJS.gamma(x, 0.0, new Complex(y)));
        }
        return z.pow(x).multiply(x.reciprocal()).multiply(HypergeometricJS.hypergeometric1F1(x, x.add(1.0), z.negate()));
    }

    public static double expIntegralEi(double x) {
        double useAsymptotic = 26.0;
        if (x < 0.0) {
            return GammaJS.expIntegralEi(new Complex(x)).getReal();
        }
        if (Math.abs(x) > useAsymptotic) {
            double s = 1.0;
            double p = 1.0;
            int i = 1;
            while (Math.abs(p) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
                s += (p *= (double)i / x);
                ++i;
            }
            return s * Math.exp(x) / x;
        }
        double s = 0.0;
        double p = 1.0;
        int i = 1;
        while (Math.abs(p / (double)i) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
            s += (p *= x / (double)i) / (double)i;
            ++i;
        }
        return s + 0.5772156649015329 + Math.log(x);
    }

    public static Complex expIntegralEi(Complex x) {
        double useAsymptotic = 26.0;
        if (x.norm() > useAsymptotic) {
            Complex s = Complex.ONE;
            Complex p = Complex.ONE;
            int i = 1;
            Complex xInverse = x.reciprocal();
            while (Math.abs(p.getReal()) > Config.SPECIAL_FUNCTIONS_TOLERANCE || Math.abs(p.getImaginary()) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
                p = p.multiply(i).multiply(xInverse);
                s = s.add(p);
                ++i;
            }
            int sign = x.getImaginary() > 0.0 ? 1 : (x.getImaginary() < 0.0 ? -1 : 0);
            return s.multiply(x.exp()).multiply(xInverse).add(new Complex(0.0, (double)sign * Math.PI));
        }
        Complex s = Complex.ZERO;
        Complex p = Complex.ONE;
        int i = 1;
        while (Math.abs(p.getReal() / (double)i) > Config.SPECIAL_FUNCTIONS_TOLERANCE || Math.abs(p.getImaginary() / (double)i) > Config.SPECIAL_FUNCTIONS_TOLERANCE) {
            p = p.multiply(x).divide((double)i);
            s = s.add(p.divide((double)i));
            ++i;
        }
        s = s.add(0.5772156649015329).add(x.log());
        if (x.getReal() < 0.0 && F.isZero(x.getImaginary())) {
            return new Complex(s.getReal(), 0.0);
        }
        return s;
    }

    public static double logIntegral(double x) {
        if (x <= 0.0) {
            throw new ArgumentTypeException("logIntegral: x<=0");
        }
        return GammaJS.expIntegralEi(Math.log(x));
    }

    public static Complex logIntegral(Complex x) {
        return GammaJS.expIntegralEi(x.log());
    }

    public static double polyGamma(double x) {
        ISymbol xSymbol = F.Dummy("x");
        FiniteDifferencesDifferentiator differentiator = new FiniteDifferencesDifferentiator(15, 0.01);
        UnivariateDifferentiableFunction f = differentiator.differentiate((UnivariateFunction)new UnaryNumerical(F.LogGamma(xSymbol), xSymbol, EvalEngine.get()));
        DSFactory factory = new DSFactory(1, 1);
        return ((DerivativeStructure)f.value((Derivative)factory.variable(0, x))).getPartialDerivative(new int[]{1});
    }

    public static double polyGamma(int n, double x) {
        if (n <= 0) {
            throw new ArgumentTypeException("PolyGamma: Unsupported polygamma index");
        }
        return Math.pow(-1.0, n + 1) * GammaJS.factorialInt(n) * ZetaJS.hurwitzZeta((double)n + 1.0, x);
    }

    public static Complex sinIntegral(Complex x) {
        if (Complex.equals((Complex)x, (Complex)Complex.ZERO, (double)Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
            return Complex.ZERO;
        }
        Complex ix = Complex.I.multiply(x);
        Complex result = new Complex(0.0, 0.5).multiply(GammaJS.gamma(Complex.ZERO, ix.negate()).add(GammaJS.gammaZero(ix).negate()).add(ix.negate().log()).add(ix.log().negate()));
        if (F.isZero(x.getImaginary())) {
            return new Complex(result.getReal());
        }
        return result;
    }

    public static Complex cosIntegral(Complex x) {
        Complex ix = Complex.I.multiply(x);
        Complex result = x.log().subtract(GammaJS.gammaZero(ix.negate()).add(GammaJS.gammaZero(ix)).add(ix.negate().log()).add(ix.log()).multiply(0.5));
        return result;
    }

    public static Complex sinhIntegral(Complex x) {
        if (Complex.equals((Complex)x, (Complex)Complex.ZERO, (double)Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
            return Complex.ZERO;
        }
        Complex result = GammaJS.gammaZero(x).add(GammaJS.gammaZero(x.negate()).negate()).add(x.log()).add(x.negate().log().negate()).multiply(0.5);
        if (F.isZero(x.getImaginary())) {
            return new Complex(result.getReal());
        }
        return result;
    }

    public static Complex coshIntegral(Complex x) {
        Complex xNegate = x.negate();
        Complex gamma1 = GammaJS.gammaZero(x);
        Complex gamma2 = GammaJS.gammaZero(xNegate);
        Complex result = gamma1.add(gamma2.add(x.log().negate()).add(xNegate.log())).multiply(-0.5);
        return result;
    }

    public static Complex gammaRegularized(Complex x, double y, Complex z) {
        return GammaJS.gamma(x, y, z).divide(GammaJS.gamma(x));
    }

    public static Complex gammaRegularized(Complex x, Complex y) {
        return GammaJS.gamma(x, y).divide(GammaJS.gamma(x));
    }

    public static double gammaRegularized(double x, double y, double z) {
        return Gamma.regularizedGammaQ((double)x, (double)y) - Gamma.regularizedGammaQ((double)x, (double)z);
    }

    public static double gammaRegularized(double x, double y) {
        return Gamma.regularizedGammaQ((double)x, (double)y);
    }

    private static Complex gammaZero(Complex x) {
        return GammaJS.gamma(Complex.ZERO, x);
    }

    public static Complex expIntegralE(Complex n, Complex x) {
        if (n.equals((Object)Complex.ZERO)) {
            return x.negate().exp().divide(x);
        }
        Complex nSubtract1 = n.subtract(1.0);
        if (Complex.equals((Complex)x, (Complex)Complex.ZERO, (double)Config.SPECIAL_FUNCTIONS_TOLERANCE) && n.getReal() > 1.0) {
            return nSubtract1.reciprocal();
        }
        return x.pow(nSubtract1).multiply(GammaJS.gamma(Complex.ONE.subtract(n), x));
    }

    public static Complex logGamma(Complex x) {
        if (F.isNumIntValue(x.getReal()) && x.getReal() <= 0.0 && F.isZero(x.getImaginary())) {
            throw new ArgumentTypeException("Gamma function pole");
        }
        if (x.getReal() < 0.0) {
            Complex t = new Complex(Math.PI).divide(x.multiply(Math.PI).sin()).log().subtract(GammaJS.logGamma(x.negate().add(1.0)));
            double s = x.getImaginary() < 0.0 ? -1.0 : 1.0;
            double d = F.isZero(x.getImaginary()) ? 0.25 : 0.0;
            double k = Math.ceil(x.getReal() / 2.0 - 0.75 + d);
            return t.add(new Complex(0.0, 2.0 * s * k * Math.PI));
        }
        Complex t = x.add(5.2421875);
        t = x.add(0.5).multiply(t.log()).subtract(t);
        Complex s = new Complex(0.9999999999999971);
        for (int j = 0; j < 14; ++j) {
            s = s.add(x.add((double)(j + 1)).reciprocal().multiply(c[j]));
        }
        Complex u = t.add(s.divide(x).multiply(2.5066282746310007).log());
        if (s.getReal() < 0.0) {
            if (x.getImaginary() < 0.0 && s.divide(x).getImaginary() < 0.0) {
                u = u.add(new Complex(0.0, Math.PI * 2));
            }
            if (x.getImaginary() > 0.0 && s.divide(x).getImaginary() > 0.0) {
                u = u.add(new Complex(0.0, 0.0));
            }
        }
        return u;
    }

    public static double logGamma(double x) {
        return Gamma.logGamma((double)x);
    }

    static class RegularizedGammaFraction
    extends ContinuedFraction {
        private final double a;

        public RegularizedGammaFraction(double a) {
            this.a = a;
        }

        protected double getA0(double x) {
            return this.getAn(0, x);
        }

        protected double getAn(int n, double x) {
            return 2.0 * (double)n + 1.0 - this.a + x;
        }

        protected double getBn(int n, double x) {
            return (double)n * (this.a - (double)n);
        }

        public void accept(Visitor<Function> visitor) {
            visitor.visit((Visitable)this);
        }
    }
}

