/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.functions;

import org.hipparchus.complex.Complex;
import org.hipparchus.special.elliptic.carlson.CarlsonEllipticIntegral;
import org.hipparchus.special.elliptic.legendre.LegendreEllipticIntegral;
import org.matheclipse.core.builtin.functions.EllipticFunctionsJS;
import org.matheclipse.core.eval.exception.ArgumentTypeException;

public class EllipticIntegralsJS {
    private EllipticIntegralsJS() {
    }

    public static Complex kleinJ(Complex x) {
        Complex q = new Complex(0.0, Math.PI).multiply(x).exp();
        Complex t2 = EllipticFunctionsJS.jacobiTheta(2, Complex.ZERO, q);
        Complex t3 = EllipticFunctionsJS.jacobiTheta(3, Complex.ZERO, q);
        Complex t4 = EllipticFunctionsJS.jacobiTheta(4, Complex.ZERO, q);
        Complex P = t2.pow(8.0).add(t3.pow(8.0)).add(t4.pow(8)).pow(3.0);
        Complex Q = t2.multiply(t3).multiply(t4).pow(8.0).multiply(54.0);
        return P.divide(Q);
    }

    public static Complex kleinJ(double x) {
        return EllipticIntegralsJS.kleinJ(new Complex(x));
    }

    public static Complex carlsonRC(Complex x, Complex y) {
        return CarlsonEllipticIntegral.rC((Complex)x, (Complex)y);
    }

    public static double carlsonRC(double x, double y) {
        return CarlsonEllipticIntegral.rC((double)x, (double)y);
    }

    public static Complex carlsonRD(Complex x, Complex y, Complex z) {
        return EllipticIntegralsJS.carlsonRJ(x, y, z, z);
    }

    public static double carlsonRD(double x, double y, double z) {
        return EllipticIntegralsJS.carlsonRJ(x, y, z, z);
    }

    public static Complex carlsonRF(Complex x, Complex y, Complex z) {
        return CarlsonEllipticIntegral.rF((Complex)x, (Complex)y, (Complex)z);
    }

    private static Complex carlsonRF(Complex x, Complex y, Complex z, double tolerance) {
        Complex A0;
        Complex xm = x;
        Complex ym = y;
        Complex zm = z;
        Complex Am = A0 = x.add(y).add(z).divide(3.0);
        double Q = Math.pow(3.0 * tolerance, -0.16666666666666666) * Math.max(A0.subtract(x).norm(), Math.max(A0.subtract(y).norm(), A0.subtract(z).norm()));
        double g = 0.25;
        double pow4 = 1.0;
        while (true) {
            double absAm;
            if (Double.isNaN(absAm = Am.norm()) || Double.isInfinite(absAm)) {
                throw new ArgumentTypeException("carlsonRF: Am is undefined");
            }
            Complex xs = xm.sqrt();
            Complex ys = ym.sqrt();
            Complex zs = zm.sqrt();
            Complex lm = xs.multiply(ys).add(xs.multiply(zs)).add(ys.multiply(zs));
            xm = xm.add(lm).multiply(g);
            ym = ym.add(lm).multiply(g);
            zm = zm.add(lm).multiply(g);
            if (pow4 * Q < absAm) break;
            Am = Am.add(lm).multiply(g);
            pow4 *= g;
        }
        Complex t = new Complex(pow4).divide(Am);
        Complex X = A0.subtract(x).multiply(t);
        Complex Y = A0.subtract(y).multiply(t);
        Complex Z = X.add(Y).negate();
        Complex E2 = X.multiply(Y).subtract(Z.multiply(Z));
        Complex E3 = X.multiply(Y).multiply(Z);
        Complex AmPow = Am.pow(-0.5);
        return AmPow.multiply(E2.multiply(-924.0).add(E2.multiply(E2).multiply(385.0)).add(E3.multiply(660.0)).add(E2.multiply(E3).multiply(-630.0)).add(9240.0)).multiply(1.0822510822510823E-4);
    }

    public static double carlsonRF(double x, double y, double z) {
        return CarlsonEllipticIntegral.rF((double)x, (double)y, (double)z);
    }

    private static double carlsonRF(double x, double y, double z, double tolerance) {
        double A0;
        if (y == z) {
            return EllipticIntegralsJS.carlsonRC(x, y);
        }
        if (x == z) {
            return EllipticIntegralsJS.carlsonRC(y, x);
        }
        if (x == y) {
            return EllipticIntegralsJS.carlsonRC(z, x);
        }
        double xm = x;
        double ym = y;
        double zm = z;
        double Am = A0 = (x + y + z) / 3.0;
        double Q = Math.pow(3.0 * tolerance, -0.16666666666666666) * Math.max(Math.max(Math.abs(A0 - x), Math.abs(A0 - y)), Math.abs(A0 - z));
        double g = 0.25;
        double pow4 = 1.0;
        while (true) {
            double xs = Math.sqrt(xm);
            double ys = Math.sqrt(ym);
            double zs = Math.sqrt(zm);
            double lm = xs * ys + xs * zs + ys * zs;
            double Am1 = (Am + lm) * g;
            xm = (xm + lm) * g;
            ym = (ym + lm) * g;
            zm = (zm + lm) * g;
            if (pow4 * Q < Math.abs(Am)) break;
            Am = Am1;
            pow4 *= g;
        }
        double t = pow4 / Am;
        double X = (A0 - x) * t;
        double Y = (A0 - y) * t;
        double Z = -X - Y;
        double E2 = X * Y - Z * Z;
        double E3 = X * Y * Z;
        return Math.pow(Am, -0.5) * (9240.0 - 924.0 * E2 + 385.0 * E2 * E2 + 660.0 * E3 - 630.0 * E2 * E3) / 9240.0;
    }

    public static double carlsonRG(double x, double y, double z) {
        return CarlsonEllipticIntegral.rG((double)x, (double)y, (double)z);
    }

    public static Complex carlsonRG(Complex x, Complex y, Complex z) {
        return CarlsonEllipticIntegral.rG((Complex)x, (Complex)y, (Complex)z);
    }

    public static Complex carlsonRJ(Complex x, Complex y, Complex z, Complex p) {
        return CarlsonEllipticIntegral.rJ((Complex)x, (Complex)y, (Complex)z, (Complex)p);
    }

    private static Complex carlsonRJ(Complex x, Complex y, Complex z, Complex p, double tolerance) {
        Complex Am;
        Complex xm = x;
        Complex ym = y;
        Complex zm = z;
        Complex pm = p;
        Complex A0 = Am = x.add(y).add(z).add(p.multiply(2)).divide(5.0);
        Complex delta = p.subtract(x).multiply(p.subtract(y)).multiply(p.subtract(z));
        double Q = Math.pow(0.25 * tolerance, -0.16666666666666666) * Math.max(A0.subtract(x).norm(), Math.max(A0.subtract(y).norm(), Math.max(A0.subtract(z).norm(), A0.subtract(p).norm())));
        double m = 0.0;
        double g = 0.25;
        double pow4 = 1.0;
        Complex S2 = Complex.ZERO;
        while (true) {
            Complex sx = xm.sqrt();
            Complex sy = ym.sqrt();
            Complex sz = zm.sqrt();
            Complex sp = pm.sqrt();
            Complex lm = sx.multiply(sy).add(sx.multiply(sz)).add(sy.multiply(sz));
            Complex Am1 = Am.add(lm).multiply(g);
            xm = xm.add(lm).multiply(g);
            ym = ym.add(lm).multiply(g);
            zm = zm.add(lm).multiply(g);
            pm = pm.add(lm).multiply(g);
            Complex dm = sp.add(sx).multiply(sp.add(sy)).multiply(sp.add(sz));
            Complex em = dm.reciprocal().multiply(dm.reciprocal()).multiply(delta).multiply(Math.pow(4.0, -3.0 * m));
            if (pow4 * Q < Am.norm()) break;
            Complex T = EllipticIntegralsJS.carlsonRC(Complex.ONE, em.add(1.0)).multiply(pow4).multiply(dm.reciprocal());
            S2 = S2.add(T);
            pow4 *= g;
            m += 1.0;
            Am = Am1;
        }
        Complex t = Am.reciprocal().multiply(Math.pow(2.0, -2.0 * m));
        Complex X = A0.subtract(x).multiply(t);
        Complex Y = A0.subtract(y).multiply(t);
        Complex Z = A0.subtract(z).multiply(t);
        Complex P = X.add(Y.add(Z)).divide(-2.0);
        Complex E2 = X.multiply(Y).add(X.multiply(Z)).add(Y.multiply(Z)).add(P.multiply(P).multiply(-3));
        Complex E3 = X.multiply(Y).multiply(Z).add(E2.multiply(P).multiply(2)).add(P.multiply(P).multiply(P).multiply(4));
        Complex E4 = X.multiply(Y).multiply(Z).multiply(2).add(E2.multiply(P)).add(P.multiply(P).multiply(P).multiply(3)).multiply(P);
        Complex E5 = X.multiply(Y).multiply(Z).multiply(P).multiply(P);
        P = E2.multiply(-5148).add(E2.multiply(E2).multiply(2457)).add(E3.multiply(4004)).add(E2.multiply(E3).multiply(-4158)).add(E4.multiply(-3276)).add(E5.multiply(2772)).add(24024.0);
        Complex v1 = Am.pow(-1.5).multiply(Math.pow(g, m)).multiply(P).multiply(4.1625041625041625E-5);
        return S2.multiply(6.0).add(v1);
    }

    public static double carlsonRJ(double x, double y, double z, double p) {
        return CarlsonEllipticIntegral.rJ((double)x, (double)y, (double)z, (double)p);
    }

    private static Complex carlsonRJ(double x, double y, double z, double p, double tolerance) {
        double Am;
        double xm = x;
        double ym = y;
        double zm = z;
        double pm = p;
        double A0 = Am = (x + y + z + 2.0 * p) / 5.0;
        double delta = (p - x) * (p - y) * (p - z);
        double Q = Math.pow(0.25 * tolerance, -0.16666666666666666) * Math.max(Math.abs(A0 - x), Math.max(Math.abs(A0 - y), Math.max(Math.abs(A0 - z), Math.abs(A0 - p))));
        double m = 0.0;
        double g = 0.25;
        double pow4 = 1.0;
        Complex S2 = Complex.ZERO;
        while (true) {
            double sx = Math.sqrt(xm);
            double sy = Math.sqrt(ym);
            double sz = Math.sqrt(zm);
            double sp = Math.sqrt(pm);
            double lm = sx * sy + sx * sz + sy * sz;
            double Am1 = (Am + lm) * g;
            xm = (xm + lm) * g;
            ym = (ym + lm) * g;
            zm = (zm + lm) * g;
            pm = (pm + lm) * g;
            double dm = (sp + sx) * (sp + sy) * (sp + sz);
            double em = delta * Math.pow(4.0, -3.0 * m) / Math.pow(dm, 2.0);
            if (pow4 * Q < Math.abs(Am)) break;
            Complex T = Complex.valueOf((double)EllipticIntegralsJS.carlsonRC(1.0, 1.0 + em)).multiply(pow4 / dm);
            S2 = S2.add(T);
            pow4 *= g;
            m += 1.0;
            Am = Am1;
        }
        double t = Math.pow(2.0, -2.0 * m) / Am;
        double X = (A0 - x) * t;
        double Y = (A0 - y) * t;
        double Z = (A0 - z) * t;
        double P = (-X - Y - Z) / 2.0;
        double E2 = X * Y + X * Z + Y * Z - 3.0 * Math.pow(P, 2.0);
        double E3 = X * Y * Z + 2.0 * E2 * P + 4.0 * Math.pow(P, 3.0);
        double E4 = (2.0 * X * Y * Z + E2 * P + 3.0 * Math.pow(P, 3.0)) * P;
        double E5 = X * Y * Z * Math.pow(P, 2.0);
        P = 24024.0 - 5148.0 * E2 + 2457.0 * Math.pow(E2, 2.0) + 4004.0 * E3 - 4158.0 * E2 * E3 - 3276.0 * E4 + 2772.0 * E5;
        double v1 = Math.pow(g, m) * Math.pow(Am, -1.5) * P / 24024.0;
        return S2.multiply(6.0).add(v1);
    }

    public static Complex ellipticF(Complex x, Complex m) {
        Complex period = Complex.ZERO;
        if (Math.abs(x.getReal()) > 1.5707963267948966) {
            long p = Math.round(x.getReal() / Math.PI);
            x = new Complex(x.getReal() - (double)p * Math.PI, x.getImaginary());
            period = EllipticIntegralsJS.ellipticK(m).multiply((double)(p + p));
        }
        Complex sinX = x.sin();
        Complex cosX = x.cos();
        if (cosX.getImaginary() == 0.0) {
            cosX = new Complex(cosX.getReal());
        }
        Complex sqrSinX = sinX.multiply(sinX);
        Complex sqrCosX = cosX.multiply(cosX);
        return sinX.multiply(EllipticIntegralsJS.carlsonRF(sqrCosX, Complex.ONE.subtract(m.multiply(sqrSinX)), Complex.ONE)).add(period);
    }

    public static Complex ellipticF(double x, double m) {
        if (m > 1.0 && Math.abs(x) > Math.asin(1.0 / Math.sqrt(m))) {
            return EllipticIntegralsJS.ellipticF(new Complex(x), new Complex(m));
        }
        Complex period = Complex.ZERO;
        if (Math.abs(x) > 1.5707963267948966) {
            long p = Math.round(x / Math.PI);
            x -= (double)p * Math.PI;
            period = EllipticIntegralsJS.ellipticK(m).multiply((double)(p + p));
        }
        double sinX = Math.sin(x);
        double cosX = Math.cos(x);
        double sqrSinX = sinX * sinX;
        double sqrCosX = cosX * cosX;
        double mSqrSinX = 1.0 - m * sqrSinX;
        return Complex.valueOf((double)EllipticIntegralsJS.carlsonRF(sqrCosX, mSqrSinX, 1.0)).multiply(sinX).add(period);
    }

    public static Complex ellipticK(double m) {
        return EllipticIntegralsJS.ellipticF(1.5707963267948966, m);
    }

    public static Complex ellipticK(Complex m) {
        return EllipticIntegralsJS.ellipticF(new Complex(1.5707963267948966), m);
    }

    public static Complex ellipticE(Complex x, Complex m) {
        return LegendreEllipticIntegral.bigE((Complex)x, (Complex)m);
    }

    public static Complex ellipticE(double x, double m) {
        if (m > 1.0 && Math.abs(x) > Math.asin(1.0 / Math.sqrt(m))) {
            return EllipticIntegralsJS.ellipticE(new Complex(x), new Complex(m));
        }
        return Complex.valueOf((double)LegendreEllipticIntegral.bigE((double)x, (double)m));
    }

    public static Complex ellipticPi(Complex n, Complex x, Complex m) {
        Complex period = Complex.ZERO;
        if (Math.abs(x.getReal()) > 1.5707963267948966) {
            long p = Math.round(x.getReal() / Math.PI);
            x = new Complex(x.getReal() - (double)p * Math.PI, x.getImaginary());
            period = EllipticIntegralsJS.ellipticPi(n, new Complex(1.5707963267948966), m).multiply((double)(p + p));
        }
        Complex sinX = x.sin();
        Complex cosX = x.cos();
        Complex sqrSinX = sinX.multiply(sinX);
        Complex sqrCosX = cosX.multiply(cosX);
        Complex p3SinX = sqrSinX.multiply(sinX);
        Complex a2 = sinX.equals((Object)Complex.ZERO) ? Complex.ONE : Complex.ONE.subtract(m.multiply(sqrSinX));
        return sinX.multiply(EllipticIntegralsJS.carlsonRF(sqrCosX, a2, Complex.ONE)).add(n.multiply(0.3333333333333333).multiply(p3SinX).multiply(EllipticIntegralsJS.carlsonRJ(sqrCosX, Complex.ONE.subtract(m.multiply(sqrSinX)), Complex.ONE, Complex.ONE.subtract(n.multiply(sqrSinX))))).add(period);
    }

    public static Complex ellipticPi(double n, double x, double m) {
        if (n > 1.0 && Math.abs(x) > Math.asin(1.0 / Math.sqrt(n))) {
            return EllipticIntegralsJS.ellipticPi(new Complex(n), new Complex(x), new Complex(m));
        }
        if (m > 1.0 && Math.abs(x) > Math.asin(1.0 / Math.sqrt(m))) {
            return EllipticIntegralsJS.ellipticPi(new Complex(n), new Complex(x), new Complex(m));
        }
        Complex period = Complex.ZERO;
        if (Math.abs(x) > 1.5707963267948966) {
            long p = Math.round(x / Math.PI);
            x -= (double)p * Math.PI;
            period = EllipticIntegralsJS.ellipticPi(n, 1.5707963267948966, m).multiply((double)(p + p));
        }
        double sinX = Math.sin(x);
        double cosX = Math.cos(x);
        double sqrSinX = sinX * sinX;
        double sqrCosX = cosX * cosX;
        double p3SqrSinX = sqrSinX * sinX;
        double mSqrSinX = 1.0 - m * sqrSinX;
        double nSqrSinX = 1.0 - n * sqrSinX;
        if (mSqrSinX < 0.0) {
            return EllipticIntegralsJS.carlsonRF(new Complex(sqrCosX), new Complex(mSqrSinX), Complex.ONE).multiply(sinX).add(EllipticIntegralsJS.carlsonRJ(new Complex(sqrCosX), new Complex(mSqrSinX), Complex.ONE, new Complex(nSqrSinX)).multiply(n / 3.0 * p3SqrSinX)).add(period);
        }
        return Complex.valueOf((double)EllipticIntegralsJS.carlsonRF(sqrCosX, mSqrSinX, 1.0)).multiply(sinX).add(Complex.valueOf((double)EllipticIntegralsJS.carlsonRJ(sqrCosX, mSqrSinX, 1.0, nSqrSinX)).multiply(n / 3.0 * p3SqrSinX)).add(period);
    }

    public static Complex jacobiZeta(Complex x, Complex m) {
        return EllipticIntegralsJS.ellipticE(x, m).subtract(EllipticIntegralsJS.ellipticF(x, m).multiply(EllipticIntegralsJS.ellipticE(new Complex(1.5707963267948966), m)).multiply(EllipticIntegralsJS.ellipticK(m).reciprocal()));
    }
}

