/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.functions;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.complex.Complex;
import org.hipparchus.special.elliptic.jacobi.CopolarC;
import org.hipparchus.special.elliptic.jacobi.CopolarD;
import org.hipparchus.special.elliptic.jacobi.CopolarN;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarC;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarD;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarN;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.JacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.JacobiEllipticBuilder;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.functions.EllipticIntegralsJS;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;

public class EllipticFunctionsJS {
    private EllipticFunctionsJS() {
    }

    public static double trunc(double value) {
        return value < 0.0 ? Math.ceil(value) : Math.floor(value);
    }

    public static Complex jacobiTheta(int n, double x, double q) {
        return EllipticFunctionsJS.jacobiTheta(n, x, q, Config.SPECIAL_FUNCTIONS_TOLERANCE);
    }

    public static Complex jacobiTheta(int n, double x, double q, double tolerance) {
        if (Math.abs(q) >= 1.0) {
            throw new ArgumentTypeException("unsupported elliptic nome");
        }
        if (n < 1 || n > 4) {
            throw new ArgumentTypeException("undefined Jacobi theta index");
        }
        if (F.isZero(q)) {
            switch (n) {
                case 1: 
                case 2: {
                    return Complex.ZERO;
                }
                case 3: 
                case 4: {
                    return Complex.ONE;
                }
            }
        }
        if (Math.abs(x) > Math.PI) {
            double p = EllipticFunctionsJS.trunc(x / Math.PI);
            x -= p * Math.PI;
            switch (n) {
                case 1: 
                case 2: {
                    return new Complex(Math.pow(-1.0, p)).multiply(EllipticFunctionsJS.jacobiTheta(n, x, q));
                }
                case 3: 
                case 4: {
                    return EllipticFunctionsJS.jacobiTheta(n, x, q);
                }
            }
        }
        long iterationLimit = EvalEngine.get().getIterationLimit();
        switch (n) {
            case 1: {
                if (q < 0.0) {
                    return EllipticFunctionsJS.jacobiTheta(n, new Complex(x), new Complex(q));
                }
                double s = 0.0;
                double p = 1.0;
                int i = 0;
                while (Math.abs(p) > tolerance) {
                    p = Math.pow(-1.0, i) * Math.pow(q, i * i + i) * Math.sin((double)(2 * i + 1) * x);
                    s += p;
                    if ((long)i++ <= iterationLimit || iterationLimit <= 0L) continue;
                    IterationLimitExceeded.throwIt(i, S.EllipticTheta);
                }
                return new Complex(2.0 * Math.pow(q, 0.25) * s);
            }
            case 2: {
                if (q < 0.0) {
                    return EllipticFunctionsJS.jacobiTheta(n, new Complex(x), new Complex(q));
                }
                double s = 0.0;
                double p = 1.0;
                int i = 0;
                while (Math.abs(p) > tolerance) {
                    p = Math.pow(q, i * i + i) * Math.cos((double)(2 * i + 1) * x);
                    s += p;
                    if ((long)i++ <= iterationLimit || iterationLimit <= 0L) continue;
                    IterationLimitExceeded.throwIt(i, S.EllipticTheta);
                }
                return new Complex(2.0 * Math.pow(q, 0.25) * s);
            }
            case 3: {
                double s = 0.0;
                double p = 1.0;
                int i = 1;
                while (Math.abs(p) > tolerance) {
                    p = Math.pow(q, i * i) * Math.cos((double)(2 * i) * x);
                    s += p;
                    if ((long)i++ <= iterationLimit || iterationLimit <= 0L) continue;
                    IterationLimitExceeded.throwIt(i, S.EllipticTheta);
                }
                return new Complex(1.0 + 2.0 * s);
            }
            case 4: {
                double s = 0.0;
                double p = 1.0;
                int i = 1;
                while (Math.abs(p) > tolerance) {
                    p = Math.pow(-q, i * i) * Math.cos((double)(2 * i) * x);
                    s += p;
                    if ((long)i++ <= iterationLimit || iterationLimit <= 0L) continue;
                    IterationLimitExceeded.throwIt(i, S.EllipticTheta);
                }
                return new Complex(1.0 + 2.0 * s);
            }
        }
        throw new ArgumentTypeException("undefined Jacobi theta index");
    }

    public static Complex jacobiTheta(int n, Complex x, Complex q) {
        return EllipticFunctionsJS.jacobiTheta(n, x, q, Config.SPECIAL_FUNCTIONS_TOLERANCE);
    }

    public static Complex jacobiTheta(int n, Complex x, Complex q, double tolerance) {
        if (q.norm() >= 1.0) {
            throw new ArgumentTypeException("unsupported elliptic nome");
        }
        if (n < 1 || n > 4) {
            throw new ArgumentTypeException("undefined Jacobi theta index");
        }
        if (F.isZero(q)) {
            switch (n) {
                case 1: 
                case 2: {
                    return Complex.ZERO;
                }
                case 3: 
                case 4: {
                    return Complex.ONE;
                }
            }
        }
        Complex piTau = q.log().divide(Complex.I);
        if (Math.abs(x.getImaginary()) > Math.abs(piTau.getImaginary()) || Math.abs(x.getReal()) > Math.PI) {
            double pt = EllipticFunctionsJS.trunc(x.getImaginary() / piTau.getImaginary());
            x = x.subtract(piTau.multiply(pt));
            double p = EllipticFunctionsJS.trunc(x.getReal() / Math.PI);
            x = x.subtract(p * Math.PI);
            Complex qFactor = q.pow(-pt * pt);
            Complex eFactor = x.multiply(Complex.I).multiply(-2.0 * pt).exp();
            switch (n) {
                case 1: {
                    return qFactor.multiply(eFactor).multiply(F.chopComplex(EllipticFunctionsJS.jacobiTheta(n, x, q), tolerance)).multiply(Math.pow(-1.0, p + pt));
                }
                case 2: {
                    return qFactor.multiply(eFactor).multiply(F.chopComplex(EllipticFunctionsJS.jacobiTheta(n, x, q), tolerance)).multiply(Math.pow(-1.0, p));
                }
                case 3: {
                    return qFactor.multiply(eFactor).multiply(F.chopComplex(EllipticFunctionsJS.jacobiTheta(n, x, q), tolerance));
                }
                case 4: {
                    return qFactor.multiply(eFactor).multiply(F.chopComplex(EllipticFunctionsJS.jacobiTheta(n, x, q), tolerance)).multiply(Math.pow(-1.0, pt));
                }
            }
        }
        Complex s = Complex.ZERO;
        Complex p = Complex.ONE;
        long iterationLimit = EvalEngine.get().getIterationLimit();
        int i = 0;
        switch (n) {
            case 1: {
                while (Math.abs(p.getReal()) > tolerance || Math.abs(p.getImaginary()) > tolerance) {
                    p = q.pow(i * i + i).multiply(x.multiply(2 * i + 1).sin()).multiply(Math.pow(-1.0, i));
                    s = s.add(p);
                    if ((long)i++ <= iterationLimit || iterationLimit <= 0L) continue;
                    IterationLimitExceeded.throwIt(i, S.EllipticTheta);
                }
                return q.pow(0.25).multiply(s).multiply(2);
            }
            case 2: {
                while (Math.abs(p.getReal()) > tolerance || Math.abs(p.getImaginary()) > tolerance) {
                    p = q.pow(i * i + i).multiply(x.multiply(2 * i + 1).cos());
                    s = s.add(p);
                    if ((long)i++ <= iterationLimit || iterationLimit <= 0L) continue;
                    IterationLimitExceeded.throwIt(i, S.EllipticTheta);
                }
                return q.pow(0.25).multiply(s).multiply(2);
            }
            case 3: {
                i = 1;
                while (Math.abs(p.getReal()) > tolerance || Math.abs(p.getImaginary()) > tolerance) {
                    p = q.pow(i * i).multiply(x.multiply(2 * i).cos());
                    s = s.add(p);
                    if ((long)i++ <= iterationLimit || iterationLimit <= 0L) continue;
                    IterationLimitExceeded.throwIt(i, S.EllipticTheta);
                }
                return s.multiply(2.0).add(1.0);
            }
            case 4: {
                i = 1;
                while (Math.abs(p.getReal()) > tolerance || Math.abs(p.getImaginary()) > tolerance) {
                    p = q.negate().pow(i * i).multiply(x.multiply(2 * i).cos());
                    s = s.add(p);
                    if ((long)i++ <= iterationLimit || iterationLimit <= 0L) continue;
                    IterationLimitExceeded.throwIt(i, S.EllipticTheta);
                }
                return s.multiply(2.0).add(1.0);
            }
        }
        throw new ArgumentTypeException("undefined Jacobi theta index");
    }

    public static Complex ellipticNome(Complex m) {
        return EllipticIntegralsJS.ellipticK(m.negate().add(1.0)).multiply(-Math.PI).divide(EllipticIntegralsJS.ellipticK(m)).exp();
    }

    public static Complex ellipticNome(double m) {
        if (m > 1.0) {
            return EllipticFunctionsJS.ellipticNome(new Complex(m));
        }
        if (m < 0.0) {
            return EllipticIntegralsJS.ellipticK(1.0 / (1.0 - m)).divide(EllipticIntegralsJS.ellipticK(m / (m - 1.0))).multiply(-Math.PI).exp().negate();
        }
        return EllipticIntegralsJS.ellipticK(1.0 - m).divide(EllipticIntegralsJS.ellipticK(m)).multiply(-Math.PI).exp();
    }

    public static Complex jacobiSC(Complex x, Complex m) {
        FieldJacobiElliptic je = JacobiEllipticBuilder.build((Complex)m);
        FieldCopolarC valuesC = je.valuesC((CalculusFieldElement)x);
        return (Complex)valuesC.sc();
    }

    public static double jacobiSC(double x, double m) {
        JacobiElliptic je = JacobiEllipticBuilder.build((double)m);
        CopolarC valuesC = je.valuesC(x);
        return valuesC.sc();
    }

    public static Complex jacobiSD(Complex x, Complex m) {
        FieldJacobiElliptic je = JacobiEllipticBuilder.build((Complex)m);
        FieldCopolarD valuesD = je.valuesD((CalculusFieldElement)x);
        return (Complex)valuesD.sd();
    }

    public static double jacobiSD(double x, double m) {
        JacobiElliptic je = JacobiEllipticBuilder.build((double)m);
        CopolarD valuesD = je.valuesD(x);
        return valuesD.sd();
    }

    public static Complex jacobiSN(Complex x, Complex m) {
        FieldJacobiElliptic je = JacobiEllipticBuilder.build((Complex)m);
        FieldCopolarN valuesN = je.valuesN((CalculusFieldElement)x);
        return (Complex)valuesN.sn();
    }

    public static double jacobiSN(double x, double m) {
        JacobiElliptic je = JacobiEllipticBuilder.build((double)m);
        CopolarN valuesN = je.valuesN(x);
        return valuesN.sn();
    }

    public static Complex jacobiCN(Complex x, Complex m) {
        FieldJacobiElliptic je = JacobiEllipticBuilder.build((Complex)m);
        FieldCopolarN valuesN = je.valuesN((CalculusFieldElement)x);
        return (Complex)valuesN.cn();
    }

    public static double jacobiCN(double x, double m) {
        JacobiElliptic je = JacobiEllipticBuilder.build((double)m);
        CopolarN valuesN = je.valuesN(x);
        return valuesN.cn();
    }

    public static Complex jacobiCD(Complex x, Complex m) {
        FieldJacobiElliptic je = JacobiEllipticBuilder.build((Complex)m);
        FieldCopolarD valuesD = je.valuesD((CalculusFieldElement)x);
        return (Complex)valuesD.cd();
    }

    public static double jacobiCD(double x, double m) {
        JacobiElliptic je = JacobiEllipticBuilder.build((double)m);
        CopolarD valuesD = je.valuesD(x);
        return valuesD.cd();
    }

    public static Complex jacobiDN(Complex x, Complex m) {
        FieldJacobiElliptic je = JacobiEllipticBuilder.build((Complex)m);
        FieldCopolarN valuesN = je.valuesN((CalculusFieldElement)x);
        return (Complex)valuesN.dn();
    }

    public static double jacobiDN(double x, double m) {
        JacobiElliptic je = JacobiEllipticBuilder.build((double)m);
        CopolarN valuesN = je.valuesN(x);
        return valuesN.dn();
    }

    public static Complex jacobiAmplitude(Complex x, Complex m) {
        if (m.getImaginary() == 0.0 && m.getReal() <= 1.0) {
            Complex K = EllipticIntegralsJS.ellipticK(m.getReal());
            long n = Math.round(x.getReal() / 2.0 / K.getReal());
            x = x.subtract(2.0 * (double)n * K.getReal());
            if (m.getReal() < 0.0) {
                Complex Kp = EllipticIntegralsJS.ellipticK(1.0 - m.getReal());
                long p = Math.round(x.getImaginary() / 2.0 / Kp.getReal());
                if ((p & 1L) == 1L) {
                    return EllipticFunctionsJS.jacobiSN(x, m).asin().negate().add((double)n * Math.PI);
                }
            }
            return EllipticFunctionsJS.jacobiSN(x, m).asin().add((double)n * Math.PI);
        }
        return EllipticFunctionsJS.jacobiSN(x, m).asin();
    }

    public static Complex jacobiAmplitude(double x, double m) {
        if (m > 1.0) {
            return EllipticFunctionsJS.jacobiAmplitude(new Complex(x), new Complex(m));
        }
        Complex K = EllipticIntegralsJS.ellipticK(m);
        long n = Math.round(x / 2.0 / K.getReal());
        return Complex.valueOf((double)(Math.asin(EllipticFunctionsJS.jacobiSN(x -= (double)(2L * n) * K.getReal(), m)) + (double)n * Math.PI));
    }

    private static Complex cubicTrigSolution(Complex p, Complex q, int n) {
        return p.sqrt().multiply(q.multiply(p.pow(-1.5)).multiply(3.0 * Math.sqrt(3.0) / 2.0).acos().divide(3.0).subtract(Math.PI * 2 * (double)n / 3.0).cos()).multiply(2.0 / Math.sqrt(3.0));
    }

    public static Complex[] weierstrassRoots(Complex g2, Complex g3) {
        g2 = g2.divide(4.0);
        g3 = g3.divide(4.0);
        Complex e1 = EllipticFunctionsJS.cubicTrigSolution(g2, g3, 0);
        Complex e2 = EllipticFunctionsJS.cubicTrigSolution(g2, g3, 1);
        Complex e3 = EllipticFunctionsJS.cubicTrigSolution(g2, g3, 2);
        return new Complex[]{e1, e2, e3};
    }

    public static Complex[] weierstrassHalfPeriods(Complex g2, Complex g3) {
        Complex[] sol = EllipticFunctionsJS.weierstrassRoots(g2, g3);
        Complex e1 = sol[0];
        Complex e2 = sol[1];
        Complex e3 = sol[2];
        Complex lambda = e1.subtract(e3).sqrt();
        Complex m = e2.subtract(e3).divide(e1.subtract(e3));
        Complex w1 = EllipticIntegralsJS.ellipticK(m).divide(lambda);
        Complex w3 = Complex.I.multiply(EllipticIntegralsJS.ellipticK(Complex.ONE.subtract(m))).divide(lambda);
        return new Complex[]{w1, w3};
    }

    public static Complex[] weierstrassInvariants(Complex w1, Complex w3) {
        if (w3.getImaginary() / w3.getReal() < w1.getImaginary() / w1.getReal()) {
            Complex temp = w1;
            w1 = w3;
            w3 = temp;
        }
        Complex ratio = w3.divide(w1);
        boolean conjugate = false;
        if (ratio.getImaginary() < 0.0) {
            ratio = ratio.conjugate();
            conjugate = true;
        }
        Complex q = Complex.I.multiply(Math.PI).multiply(ratio).exp();
        Complex a = EllipticFunctionsJS.jacobiTheta(2, Complex.ZERO, q);
        Complex b = EllipticFunctionsJS.jacobiTheta(3, Complex.ZERO, q);
        Complex aPow4 = a.multiply(a);
        aPow4 = aPow4.multiply(aPow4);
        Complex aPow8 = aPow4.multiply(aPow4);
        Complex bPow4 = b.multiply(b);
        bPow4 = bPow4.multiply(bPow4);
        Complex bPow8 = bPow4.multiply(bPow4);
        Complex g2 = w1.multiply(2).pow(-4).multiply(aPow8.add(aPow4.multiply(bPow4).negate()).add(bPow8)).multiply(1.3333333333333333 * Math.pow(Math.PI, 4.0));
        Complex g3 = w1.multiply(2.0).pow(-6.0).multiply(0.2962962962962963 * Math.pow(Math.PI, 6.0)).multiply(a.pow(12).add(aPow8.multiply(bPow4).multiply(-1.5)).add(aPow4.multiply(bPow8).multiply(-1.5)).add(b.pow(12)));
        if (conjugate) {
            g2 = g2.conjugate();
            g3 = g3.conjugate();
        }
        return new Complex[]{g2, g3};
    }

    public static Complex weierstrassP(Complex x, Complex g2, Complex g3) {
        Complex[] sol = EllipticFunctionsJS.weierstrassRoots(g2, g3);
        Complex e1 = sol[0];
        Complex e2 = sol[1];
        Complex e3 = sol[2];
        Complex m = e2.subtract(e3).divide(e1.subtract(e3));
        Complex pow = EllipticFunctionsJS.jacobiSN(x.multiply(e1.subtract(e3).sqrt()), m).reciprocal();
        pow = pow.multiply(pow);
        return e3.add(e1.subtract(e3).multiply(pow));
    }

    public static Complex weierstrassPPrime(Complex x, Complex g2, Complex g3) {
        Complex[] sol = EllipticFunctionsJS.weierstrassRoots(g2, g3);
        Complex e1 = sol[0];
        Complex e2 = sol[1];
        Complex e3 = sol[2];
        Complex m = e2.subtract(e3).divide(e1.subtract(e3));
        Complex argument = x.multiply(e1.subtract(e3).sqrt());
        return e1.subtract(e3).pow(1.5).multiply(EllipticFunctionsJS.jacobiCN(argument, m)).multiply(EllipticFunctionsJS.jacobiDN(argument, m)).multiply(EllipticFunctionsJS.jacobiSN(argument, m).pow(-3)).multiply(-2);
    }

    public static Complex inverseWeierstrassP(Complex x, Complex g2, Complex g3) {
        Complex[] sol = EllipticFunctionsJS.weierstrassRoots(g2, g3);
        Complex e1 = sol[0];
        Complex e2 = sol[1];
        Complex e3 = sol[2];
        return EllipticIntegralsJS.carlsonRF(x.subtract(e1), x.subtract(e2), x.subtract(e3));
    }
}

