/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.functions;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.FiniteDifferencesDifferentiator;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.analysis.solvers.BisectionSolver;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.builtin.Arithmetic;
import org.matheclipse.core.builtin.functions.GammaJS;
import org.matheclipse.core.builtin.functions.HypergeometricJS;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.UnaryNumerical;
import org.matheclipse.core.interfaces.ISymbol;

public class BesselJS {
    private BesselJS() {
    }

    public static Complex besselJ(double n, double x) {
        if (!F.isNumIntValue(n) && x < 0.0) {
            return BesselJS.besselJ(new Complex(n), new Complex(x));
        }
        return new Complex(BesselJS.besselJDouble(n, x));
    }

    public static double besselJDouble(double n, double x) {
        if (F.isNumIntValue(n) && n < 0.0) {
            return BesselJS.besselJDouble(-n, x) * Math.pow(-1.0, Math.rint(n));
        }
        if (!F.isNumIntValue(n) && x < 0.0) {
            throw new ArgumentTypeException(x + " is less than 0.0");
        }
        return Math.pow(x / 2.0, n) * HypergeometricJS.hypergeometric0F1(n + 1.0, -0.25 * x * x) / GammaJS.gamma(n + 1.0);
    }

    public static Complex besselJ(double n, Complex x) {
        return BesselJS.besselJ(new Complex(n), x);
    }

    public static Complex besselJ(Complex n, Complex x) {
        if (F.isNumIntValue(n.getReal()) && n.getReal() < 0.0 && F.isZero(n.getImaginary())) {
            return new Complex(-1.0).pow(n).multiply(BesselJS.besselJ(n.negate(), x));
        }
        Complex product = x.divide(2.0).pow(n).divide(Arithmetic.lanczosApproxGamma(n.add(1.0)));
        Complex sqrX = x.multiply(x);
        return product.multiply(HypergeometricJS.hypergeometric0F1(n.add(1.0), sqrX.multiply(-0.25)));
    }

    public static double besselJZero(double n, int m) {
        if (n < 0.0) {
            throw new ArgumentTypeException(n + " is less than 0 (negative order)");
        }
        double delta = 0.7853981633974483;
        double a = ((double)m + n / 2.0 - 0.25) * Math.PI;
        double e = a - (4.0 * (n * n) - 1.0) / (8.0 * a);
        BisectionSolver solver = new BisectionSolver();
        ISymbol x = F.Dummy("x");
        UnaryNumerical f = new UnaryNumerical(F.BesselJ(F.num(n), x), x, EvalEngine.get(), true);
        return solver.solve(100, (UnivariateFunction)f, e - delta, e + delta);
    }

    public static Complex besselY(double n, double x) {
        if (x < 0.0) {
            return BesselJS.besselY(new Complex(n), new Complex(x));
        }
        return new Complex(BesselJS.besselYDouble(n, x));
    }

    public static double besselYDouble(double n, double x) {
        if (x < 0.0) {
            throw new ArgumentTypeException(x + " < 0.0");
        }
        if (F.isNumIntValue(n)) {
            FiniteDifferencesDifferentiator differentiator = new FiniteDifferencesDifferentiator(15, 0.01);
            ISymbol nSymbol = F.Dummy("n");
            UnivariateDifferentiableFunction f = differentiator.differentiate((UnivariateFunction)new UnaryNumerical(F.BesselJ(nSymbol, F.num(x)), nSymbol, EvalEngine.get()));
            DSFactory factory = new DSFactory(1, 1);
            double d1 = ((DerivativeStructure)f.value((Derivative)factory.variable(0, n))).getPartialDerivative(new int[]{1});
            double d2 = ((DerivativeStructure)f.value((Derivative)factory.variable(0, -n))).getPartialDerivative(new int[]{1});
            return (d1 + Math.pow(-1.0, Math.rint(n)) * d2) / Math.PI;
        }
        return (BesselJS.besselJDouble(n, x) * Math.cos(n * Math.PI) - BesselJS.besselJDouble(-n, x)) / Math.sin(n * Math.PI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Complex besselY(Complex n, Complex x) {
        if (n.isMathematicalInteger()) {
            EvalEngine engine = EvalEngine.get();
            int recursionLimit = engine.getRecursionLimit();
            try {
                int counter;
                if (recursionLimit > 0 && (counter = engine.incRecursionCounter()) > recursionLimit) {
                    RecursionLimitExceeded.throwIt(counter, F.BesselY(F.complexNum(n), F.complexNum(x)));
                }
                double delta = 1.0E-5;
                Complex complex = BesselJS.besselY(new Complex(n.getReal() + delta), x).add(BesselJS.besselY(new Complex(n.getReal() - delta), x).divide(2.0));
                return complex;
            }
            finally {
                if (recursionLimit > 0) {
                    engine.decRecursionCounter();
                }
            }
        }
        Complex sum = n.multiply(Math.PI).cos().multiply(BesselJS.besselJ(n, x)).subtract(BesselJS.besselJ(n.negate(), x));
        return sum.divide(n.multiply(Math.PI).sin());
    }

    public static double besselYZero(double n, int m) {
        if (n < 0.0) {
            throw new ArgumentTypeException(n + " < 0 (negative order)");
        }
        double delta = 0.7853981633974483;
        double a = ((double)m + n / 2.0 - 0.75) * Math.PI;
        double e = a - (4.0 * (n * n) - 1.0) / (8.0 * a);
        BisectionSolver solver = new BisectionSolver();
        ISymbol x = F.Dummy("x");
        UnaryNumerical f = new UnaryNumerical(F.BesselY(F.num(n), x), x, EvalEngine.get(), true);
        return solver.solve(100, (UnivariateFunction)f, e - delta, e + delta);
    }

    public static Complex besselI(double n, double x) {
        if (!F.isNumIntValue(n) && x < 0.0) {
            return BesselJS.besselI(new Complex(n), new Complex(x));
        }
        return new Complex(BesselJS.besselIDouble(n, x));
    }

    public static double besselIDouble(double n, double x) {
        if (F.isNumIntValue(n) && n < 0.0) {
            return BesselJS.besselIDouble(-n, x);
        }
        if (!F.isNumIntValue(n) && x < 0.0) {
            throw new ArgumentTypeException(x + " < 0.0");
        }
        return Math.pow(x / 2.0, n) * HypergeometricJS.hypergeometric0F1(n + 1.0, 0.25 * x * x) / GammaJS.gamma(n + 1.0);
    }

    public static Complex besselI(double n, Complex x) {
        return BesselJS.besselI(new Complex(n), x);
    }

    public static Complex besselI(Complex n, Complex x) {
        if (F.isNumIntValue(n.getReal()) && n.getReal() < 0.0 && n.getImaginary() == 0.0) {
            return BesselJS.besselI(n.negate(), x);
        }
        Complex product = x.divide(2.0).pow(n).divide(Arithmetic.lanczosApproxGamma(n.add(1.0)));
        Complex sqrX = x.multiply(x);
        return product.multiply(HypergeometricJS.hypergeometric0F1(n.add(1.0), sqrX.multiply(0.25)));
    }

    public static Complex besselK(double n, double x) {
        if (x < 0.0) {
            return BesselJS.besselK(new Complex(n), new Complex(x));
        }
        return new Complex(BesselJS.besselKDouble(n, x));
    }

    public static double besselKDouble(double n, double x) {
        int useAsymptotic = 10;
        if (x > 10.0) {
            return Math.sqrt(1.5707963267948966 / x) * Math.exp(-x) * HypergeometricJS.hypergeometric2F0(n + 0.5, 0.5 - n, -0.5 / x);
        }
        if (x < 0.0) {
            throw new ArgumentTypeException(x + " < 0.0");
        }
        if (F.isNumIntValue(n)) {
            FiniteDifferencesDifferentiator differentiator = new FiniteDifferencesDifferentiator(15, 0.01);
            ISymbol nSymbol = F.Dummy("n");
            UnivariateDifferentiableFunction f = differentiator.differentiate((UnivariateFunction)new UnaryNumerical(F.BesselI(nSymbol, F.num(x)), nSymbol, EvalEngine.get()));
            DSFactory factory = new DSFactory(1, 1);
            double d1 = ((DerivativeStructure)f.value((Derivative)factory.variable(0, n))).getPartialDerivative(new int[]{1});
            double d2 = ((DerivativeStructure)f.value((Derivative)factory.variable(0, -n))).getPartialDerivative(new int[]{1});
            return (d1 + d2) / 2.0 * Math.pow(-1.0, Math.rint(n + 1.0));
        }
        return (BesselJS.besselIDouble(-n, x) - BesselJS.besselIDouble(n, x)) * Math.PI / (2.0 * Math.sin(n * Math.PI));
    }

    public static Complex besselK(double n, Complex x) {
        return BesselJS.besselK(new Complex(n), x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Complex besselK(Complex n, Complex x) {
        int useAsymptotic = 10;
        double delta = 1.0E-5;
        if (x.norm() > 10.0) {
            Complex t1 = new Complex(1.5707963267948966).divide(x).sqrt().multiply(x.negate().exp());
            Complex t2 = HypergeometricJS.hypergeometric2F0(n.add(0.5), new Complex(0.5).subtract(n), new Complex(-0.5).divide(x));
            return t1.multiply(t2);
        }
        EvalEngine engine = EvalEngine.get();
        int recursionLimit = engine.getRecursionLimit();
        try {
            int counter;
            if (recursionLimit > 0 && (counter = engine.incRecursionCounter()) > recursionLimit) {
                RecursionLimitExceeded.throwIt(counter, S.BesselK);
            }
            if (n.isMathematicalInteger()) {
                double nRe = n.getReal();
                Complex complex = BesselJS.besselK(new Complex(nRe + delta), x).add(BesselJS.besselK(new Complex(nRe - delta), x)).divide(2.0);
                return complex;
            }
            Complex product = new Complex(1.5707963267948966).divide(n.multiply(Math.PI).sin());
            Complex complex = product.multiply(BesselJS.besselI(n.negate(), x).subtract(BesselJS.besselI(n, x)));
            return complex;
        }
        finally {
            if (recursionLimit > 0) {
                engine.decRecursionCounter();
            }
        }
    }

    public static Complex hankelH1(double n, double x) {
        return BesselJS.besselJ(n, x).add(Complex.I.multiply(BesselJS.besselY(n, x)));
    }

    public static Complex hankelH1(Complex n, Complex x) {
        return BesselJS.besselJ(n, x).add(Complex.I.multiply(BesselJS.besselY(n, x)));
    }

    public static Complex hankelH2(double n, double x) {
        return BesselJS.besselJ(n, x).add(Complex.I.multiply(BesselJS.besselY(n, x).negate()));
    }

    public static Complex hankelH2(Complex n, Complex x) {
        return BesselJS.besselJ(n, x).add(Complex.I.multiply(BesselJS.besselY(n, x).negate()));
    }

    public static Complex airyAi(double x) {
        if (F.isZero(x)) {
            return new Complex(1.0 / Math.pow(3.0, 0.6666666666666666) / GammaJS.gamma(0.6666666666666666));
        }
        if (x < 0.0) {
            Complex xMinus = new Complex(-x);
            Complex z = xMinus.pow(1.5).multiply(0.6666666666666666);
            return xMinus.sqrt().divide(3.0).multiply(BesselJS.besselJ(0.3333333333333333, z).add(BesselJS.besselJ(-0.3333333333333333, z)));
        }
        Complex xc = new Complex(x);
        Complex z = xc.pow(1.5).multiply(0.6666666666666666);
        return BesselJS.besselK(0.3333333333333333, z).multiply(0.3183098861837907).multiply(xc.divide(3.0).sqrt());
    }

    public static Complex airyAi(Complex x) {
        if (F.isZero(x)) {
            return new Complex(1.0 / Math.pow(3.0, 0.6666666666666666) / GammaJS.gamma(0.6666666666666666));
        }
        if (x.getReal() < 0.0) {
            Complex xMinus = x.negate();
            Complex z = xMinus.pow(1.5).multiply(0.6666666666666666);
            return xMinus.sqrt().divide(3.0).multiply(BesselJS.besselJ(0.3333333333333333, z).add(BesselJS.besselJ(-0.3333333333333333, z)));
        }
        Complex z = x.pow(1.5).multiply(0.6666666666666666);
        return BesselJS.besselK(0.3333333333333333, z).multiply(x.divide(3.0).sqrt()).multiply(0.3183098861837907);
    }

    public static Complex airyAiPrime(double x) {
        return BesselJS.airyAiPrime(new Complex(x));
    }

    public static Complex airyAiPrime(Complex x) {
        if (F.isZero(x)) {
            return new Complex(-1.0 / Math.pow(3.0, 0.3333333333333333) / GammaJS.gamma(0.3333333333333333));
        }
        if (x.getReal() < 0.0) {
            Complex xMinus = x.negate();
            Complex z = xMinus.pow(1.5).multiply(0.6666666666666666);
            return x.divide(3.0).multiply(BesselJS.besselJ(-0.6666666666666666, z).subtract(BesselJS.besselJ(0.6666666666666666, z)));
        }
        Complex z = x.pow(1.5).multiply(0.6666666666666666);
        return BesselJS.besselK(0.6666666666666666, z).multiply(x).multiply(-0.3183098861837907 / Math.sqrt(3.0));
    }

    public static Complex airyBi(double x) {
        if (F.isZero(x)) {
            return new Complex(1.0 / Math.pow(3.0, 0.16666666666666666) / GammaJS.gamma(0.6666666666666666));
        }
        if (x < 0.0) {
            Complex xMinus = new Complex(-x);
            Complex z = xMinus.pow(1.5).multiply(0.6666666666666666);
            return xMinus.divide(3.0).sqrt().multiply(BesselJS.besselJ(-0.3333333333333333, z).subtract(BesselJS.besselJ(0.3333333333333333, z)));
        }
        Complex xc = new Complex(x);
        Complex z = xc.pow(1.5).multiply(0.6666666666666666);
        return xc.divide(3.0).sqrt().multiply(BesselJS.besselI(0.3333333333333333, z).add(BesselJS.besselI(-0.3333333333333333, z)));
    }

    public static Complex airyBi(Complex x) {
        if (F.isZero(x)) {
            return new Complex(1.0 / Math.pow(3.0, 0.16666666666666666) / GammaJS.gamma(0.6666666666666666));
        }
        if (x.getReal() < 0.0) {
            Complex xMinus = x.negate();
            Complex z = xMinus.pow(1.5).multiply(0.6666666666666666);
            return xMinus.divide(3.0).sqrt().multiply(BesselJS.besselJ(-0.3333333333333333, z).subtract(BesselJS.besselJ(0.3333333333333333, z)));
        }
        Complex z = x.pow(1.5).multiply(0.6666666666666666);
        return x.divide(3.0).sqrt().multiply(BesselJS.besselI(0.3333333333333333, z).add(BesselJS.besselI(-0.3333333333333333, z)));
    }

    public static Complex airyBiPrime(double x) {
        return BesselJS.airyBiPrime(new Complex(x));
    }

    public static Complex airyBiPrime(Complex x) {
        if (F.isZero(x)) {
            return new Complex(Math.pow(3.0, 1.6) / GammaJS.gamma(0.3333333333333333));
        }
        if (x.getReal() < 0.0) {
            Complex xMinus = x.negate();
            Complex z = xMinus.pow(1.5).multiply(0.6666666666666666);
            return xMinus.multiply(1.0 / Math.sqrt(3.0)).multiply(BesselJS.besselJ(0.6666666666666666, z).add(BesselJS.besselJ(-0.6666666666666666, z)));
        }
        Complex z = x.pow(1.5).multiply(0.6666666666666666);
        return x.multiply(1.0 / Math.sqrt(3.0)).multiply(BesselJS.besselI(0.6666666666666666, z).add(BesselJS.besselI(-0.6666666666666666, z)));
    }

    public static Complex sphericalBesselJ(double n, double x) {
        return BesselJS.besselJ(n + 0.5, x).multiply(new Complex(Math.sqrt(1.5707963267948966)).divide(new Complex(x).sqrt()));
    }

    public static Complex sphericalBesselJ(Complex n, Complex x) {
        return BesselJS.besselJ(n.add(0.5), x).multiply(x.sqrt().reciprocal().multiply(Math.sqrt(1.5707963267948966)));
    }

    public static Complex sphericalBesselY(double n, double x) {
        Complex besselY = BesselJS.besselY(n + 0.5, x);
        return new Complex(Math.sqrt(1.5707963267948966)).divide(new Complex(x).sqrt()).multiply(besselY);
    }

    public static Complex sphericalBesselY(Complex n, Complex x) {
        Complex besselY = BesselJS.besselY(n.add(0.5), x);
        return besselY.multiply(x.sqrt().reciprocal().multiply(Math.sqrt(1.5707963267948966)));
    }

    public static Complex sphericalHankel1(double n, double x) {
        return BesselJS.sphericalBesselJ(n, x).add(Complex.I.multiply(BesselJS.sphericalBesselY(n, x)));
    }

    public static Complex sphericalHankel2(double n, double x) {
        return BesselJS.sphericalBesselJ(n, x).add(Complex.I.multiply(BesselJS.sphericalBesselY(n, x).negate()));
    }

    public static double struveH(double n, double x) {
        return Math.pow(x, n + 1.0) / (Math.pow(2.0, n) * Math.sqrt(Math.PI) * GammaJS.gamma(n + 1.5)) * HypergeometricJS.hypergeometric1F2(1.0, 1.5, n + 1.5, -0.25 * x * x);
    }

    public static Complex struveH(Complex n, Complex x) {
        return x.pow(n.add(1.0)).divide(Complex.valueOf((double)2.0).pow(n).multiply(Math.sqrt(Math.PI)).multiply(Arithmetic.lanczosApproxGamma(n.add(1.5)))).multiply(HypergeometricJS.hypergeometric1F2(Complex.ONE, new Complex(1.5), n.add(1.5), x.multiply(x).multiply(-0.25)));
    }

    public static double struveL(double n, double x) {
        return Math.pow(x, n + 1.0) * 1.0 / (Math.pow(2.0, n) * Math.sqrt(Math.PI) * GammaJS.gamma(n + 1.5)) * HypergeometricJS.hypergeometric1F2(1.0, 1.5, n + 1.5, 0.25 * x * x);
    }

    public static Complex struveL(Complex n, Complex x) {
        return x.pow(n.add(1.0)).multiply(Complex.valueOf((double)2.0).pow(n).multiply(Math.sqrt(Math.PI)).multiply(Arithmetic.lanczosApproxGamma(n.add(1.5))).reciprocal()).multiply(HypergeometricJS.hypergeometric1F2(Complex.ONE, new Complex(1.5), n.add(1.5), x.multiply(x).multiply(0.25)));
    }
}

