/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.function.Function;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class WindowFunctions {
    public static IExpr bartlettWindow(IExpr x) {
        return F.Piecewise(F.list(F.list(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN2, x)), F.LessEqual(F.C0, x, F.C1D2)), F.list(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C2, x)), F.And((IExpr)F.LessEqual((IExpr)F.CN1D2, x), (IExpr)F.Less(x, F.C0)))), F.C0);
    }

    public static IExpr blackmanHarrisWindow(IExpr x) {
        return F.Piecewise(F.list(F.list(F.Times((IExpr)F.QQ(1L, 100000L), (IExpr)F.Plus(F.ZZ(35875L), F.Times((IExpr)F.ZZ(48829L), (IExpr)F.Cos(F.Times((IExpr)F.C2, (IExpr)F.Pi, x))), F.Times((IExpr)F.ZZ(14128L), (IExpr)F.Cos(F.Times((IExpr)F.C4, (IExpr)F.Pi, x))), F.Times((IExpr)F.ZZ(1168L), (IExpr)F.Cos(F.Times((IExpr)F.C6, (IExpr)F.Pi, x))))), F.LessEqual(F.CN1D2, x, F.C1D2))), F.C0);
    }

    public static IExpr blackmanNuttallWindow(IExpr x) {
        return F.Piecewise(F.list(F.list(F.Times((IExpr)F.QQ(1L, 10000000L), (IExpr)F.Plus(F.Times((IExpr)F.ZZ(4891775L), (IExpr)F.Cos(F.Times((IExpr)F.C2, (IExpr)F.Pi, x))), F.Times((IExpr)F.ZZ(1365995L), (IExpr)F.Cos(F.Times((IExpr)F.C4, (IExpr)F.Pi, x))), F.Times((IExpr)F.ZZ(106411L), (IExpr)F.Cos(F.Times((IExpr)F.C6, (IExpr)F.Pi, x))), F.ZZ(3635819L))), F.LessEqual(F.CN1D2, x, F.C1D2))), F.C0);
    }

    public static IExpr blackmanWindow(IExpr x) {
        return F.Piecewise(F.list(F.list(F.Times((IExpr)F.QQ(1L, 50L), (IExpr)F.Plus((IExpr)F.ZZ(21L), (IExpr)F.Times((IExpr)F.ZZ(25L), (IExpr)F.Cos(F.Times((IExpr)F.C2, (IExpr)F.Pi, x))), (IExpr)F.Times((IExpr)F.C4, (IExpr)F.Cos(F.Times((IExpr)F.C4, (IExpr)F.Pi, x))))), F.LessEqual(F.CN1D2, x, F.C1D2))), F.C0);
    }

    public static IExpr dirichletWindow(IExpr x) {
        return F.Piecewise(F.list(F.list(F.C1, F.LessEqual(F.CN1D2, x, F.C1D2))), F.C0);
    }

    public static IExpr flatTopWindow(IExpr x) {
        return F.Piecewise(F.list(F.list(F.Times((IExpr)F.QQ(1L, 1000000000L), (IExpr)F.Plus(F.ZZ(215578947L), F.Times((IExpr)F.ZZ(416631580L), (IExpr)F.Cos(F.Times((IExpr)F.C2, (IExpr)F.Pi, x))), F.Times((IExpr)F.ZZ(277263158L), (IExpr)F.Cos(F.Times((IExpr)F.C4, (IExpr)F.Pi, x))), F.Times((IExpr)F.ZZ(83578947L), (IExpr)F.Cos(F.Times((IExpr)F.C6, (IExpr)F.Pi, x))), F.Times((IExpr)F.ZZ(6947368L), (IExpr)F.Cos(F.Times((IExpr)F.C8, (IExpr)F.Pi, x))))), F.LessEqual(F.CN1D2, x, F.C1D2))), F.C0);
    }

    public static IExpr gaussianWindow(IExpr x) {
        return F.Piecewise(F.list(F.list(F.Exp(F.Times(F.CN1, F.QQ(1L, 9L), F.ZZ(50L), F.Sqr(x))), F.LessEqual(F.CN1D2, x, F.C1D2))), F.C0);
    }

    public static IExpr hammingWindow(IExpr x) {
        return F.Piecewise(F.list(F.list(F.Plus((IExpr)F.QQ(25L, 46L), (IExpr)F.Times((IExpr)F.QQ(21L, 46L), (IExpr)F.Cos(F.Times((IExpr)F.C2, (IExpr)F.Pi, x)))), F.LessEqual(F.CN1D2, x, F.C1D2))), F.C0);
    }

    public static IExpr hannWindow(IExpr x) {
        return F.Piecewise(F.list(F.list(F.Plus((IExpr)F.C1D2, (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Cos(F.Times((IExpr)F.C2, (IExpr)F.Pi, x)))), F.LessEqual(F.CN1D2, x, F.C1D2))), F.C0);
    }

    public static IExpr nuttallWindow(IExpr x) {
        return F.Piecewise(F.list(F.list(F.Times((IExpr)F.QQ(1L, 250000L), (IExpr)F.Plus(F.ZZ(88942L), F.Times((IExpr)F.ZZ(121849L), (IExpr)F.Cos(F.Times((IExpr)F.C2, (IExpr)F.Pi, x))), F.Times((IExpr)F.ZZ(36058L), (IExpr)F.Cos(F.Times((IExpr)F.C4, (IExpr)F.Pi, x))), F.Times((IExpr)F.ZZ(3151L), (IExpr)F.Cos(F.Times((IExpr)F.C6, (IExpr)F.Pi, x))))), F.LessEqual(F.CN1D2, x, F.C1D2))), F.C0);
    }

    public static IExpr parzenWindow(IExpr x) {
        return F.Piecewise(F.List(F.list(F.Times((IExpr)F.CN2, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Times((IExpr)F.C2, x)), F.C3)), F.And((IExpr)F.Less((IExpr)F.C1D4, x), (IExpr)F.LessEqual(x, F.C1D2))), F.list(F.Times((IExpr)F.C2, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C2, x)), F.C3)), F.And((IExpr)F.LessEqual((IExpr)F.CN1D2, x), (IExpr)F.Less(x, F.CN1D4))), F.list(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.ZZ(-24L), (IExpr)F.Sqr(x)), (IExpr)F.Times((IExpr)F.ZZ(-48L), (IExpr)F.Power(x, F.C3))), F.And((IExpr)F.LessEqual((IExpr)F.CN1D4, x), (IExpr)F.Less(x, F.C0))), F.list(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.ZZ(-24L), (IExpr)F.Sqr(x)), (IExpr)F.Times((IExpr)F.ZZ(48L), (IExpr)F.Power(x, F.C3))), F.LessEqual(F.C0, x, F.C1D4))), F.C0);
    }

    public static IExpr tukeyWindow(IExpr x) {
        return F.Piecewise(F.list(F.list(F.C1, F.And((IExpr)F.LessEqual((IExpr)F.Plus((IExpr)F.CN1D3, (IExpr)F.Times((IExpr)F.CN2, x)), F.C0), (IExpr)F.LessEqual((IExpr)F.Plus((IExpr)F.CN1D3, (IExpr)F.Times((IExpr)F.C2, x)), F.C0))), F.list(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Cos(F.Times((IExpr)F.C3, (IExpr)F.Pi, (IExpr)F.Plus((IExpr)F.QQ(1L, 6L), x))))), F.And((IExpr)F.GreaterEqual(x, F.CN1D2), (IExpr)F.Greater((IExpr)F.Plus((IExpr)F.CN1D3, (IExpr)F.Times((IExpr)F.CN2, x)), F.C0))), F.list(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Cos(F.Times((IExpr)F.C3, (IExpr)F.Pi, (IExpr)F.Plus((IExpr)F.QQ(-1L, 6L), x))))), F.And((IExpr)F.Greater((IExpr)F.Plus((IExpr)F.CN1D3, (IExpr)F.Times((IExpr)F.C2, x)), F.C0), (IExpr)F.LessEqual(x, F.C1D2)))), F.C0);
    }

    public static void initialize() {
        Initializer.init();
    }

    private WindowFunctions() {
    }

    private static class WindowFunction
    extends AbstractTrigArg1 {
        private final Function<IExpr, IExpr> function;

        public WindowFunction(Function<IExpr, IExpr> f) {
            this.function = f;
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isRealResult()) {
                return this.function.apply(arg1);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.BartlettWindow.setEvaluator(new WindowFunction(WindowFunctions::bartlettWindow));
            S.BlackmanHarrisWindow.setEvaluator(new WindowFunction(WindowFunctions::blackmanHarrisWindow));
            S.BlackmanNuttallWindow.setEvaluator(new WindowFunction(WindowFunctions::blackmanNuttallWindow));
            S.BlackmanWindow.setEvaluator(new WindowFunction(WindowFunctions::blackmanWindow));
            S.DirichletWindow.setEvaluator(new WindowFunction(WindowFunctions::dirichletWindow));
            S.FlatTopWindow.setEvaluator(new WindowFunction(WindowFunctions::flatTopWindow));
            S.GaussianWindow.setEvaluator(new WindowFunction(WindowFunctions::gaussianWindow));
            S.HammingWindow.setEvaluator(new WindowFunction(WindowFunctions::hammingWindow));
            S.HannWindow.setEvaluator(new WindowFunction(WindowFunctions::hannWindow));
            S.NuttallWindow.setEvaluator(new WindowFunction(WindowFunctions::nuttallWindow));
            S.ParzenWindow.setEvaluator(new WindowFunction(WindowFunctions::parzenWindow));
            S.TukeyWindow.setEvaluator(new WindowFunction(WindowFunctions::tukeyWindow));
        }
    }
}

