/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.Base64;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeStopException;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.WL;
import org.matheclipse.core.expression.data.ByteArrayExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IDataExpr;
import org.matheclipse.core.interfaces.IExpr;

public class WXFFunctions {
    public static boolean isByteArray(IExpr arg1) {
        return arg1 instanceof ByteArrayExpr;
    }

    public static void initialize() {
        Initializer.init();
    }

    private WXFFunctions() {
    }

    private static class BinaryDeserialize
    extends AbstractCoreFunctionEvaluator {
        private BinaryDeserialize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            byte[] bArray;
            IExpr arg1;
            if (ast.isAST1() && WXFFunctions.isByteArray(arg1 = engine.evaluate(ast.arg1())) && (bArray = (byte[])((IDataExpr)arg1).toData()).length > 2) {
                IExpr temp = WL.deserialize(bArray);
                return temp;
            }
            return F.NIL;
        }
    }

    private static class ByteArray
    extends AbstractCoreFunctionEvaluator {
        private ByteArray() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isList()) {
                    if (arg1.isEmptyList()) {
                        return F.CEmptyList;
                    }
                    byte[] bArray = WL.toByteArray((IAST)arg1);
                    if (bArray == null) {
                        throw new ArgumentTypeStopException("lend", F.list(F.C1, ast));
                    }
                    return ByteArrayExpr.newInstance(bArray);
                }
                if (arg1.isString()) {
                    String str = arg1.toString();
                    if (str.isEmpty()) {
                        return F.CEmptyList;
                    }
                    try {
                        byte[] bArray = Base64.getDecoder().decode(str);
                        return ByteArrayExpr.newInstance(bArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                throw new ArgumentTypeStopException("lend", F.list(F.C1, ast));
            }
            return F.NIL;
        }
    }

    private static class BinarySerialize
    extends AbstractCoreFunctionEvaluator {
        private BinarySerialize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1;
            byte[] bArray;
            if (ast.isAST1() && (bArray = WL.serialize(arg1 = engine.evaluate(ast.arg1()))) != null) {
                return ByteArrayExpr.newInstance(bArray);
            }
            return F.NIL;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.BinarySerialize.setEvaluator(new BinarySerialize());
            S.BinaryDeserialize.setEvaluator(new BinaryDeserialize());
            S.ByteArray.setEvaluator(new ByteArray());
        }
    }
}

