/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.function.Consumer;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;

public class VectorAnalysisFunctions {
    public static void initialize() {
        Initializer.init();
    }

    private VectorAnalysisFunctions() {
    }

    private static final class RotationMatrix
    extends AbstractFunctionEvaluator {
        private RotationMatrix() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                IExpr theta = ast.arg1();
                return F.list(F.list(F.Cos(theta), F.Negate(F.Sin(theta))), F.list(F.Sin(theta), F.Cos(theta)));
            }
            if (ast.isAST2() && ast.arg2().isAST(S.List, 4)) {
                IExpr theta = ast.arg1();
                IAST vector = (IAST)ast.arg2();
                IExpr x = vector.arg1();
                IExpr y = vector.arg2();
                IExpr z = vector.arg3();
                if (z.isZero()) {
                    if (y.isZero()) {
                        return F.list(F.list(F.Times((IExpr)F.Power(x, F.C3), (IExpr)F.Power((IExpr)F.Abs(x), F.CN6), (IExpr)F.Power((IExpr)F.Conjugate(x), F.C3)), F.C0, F.C0), F.list(F.C0, F.Cos(theta), F.Times(F.CN1, F.Sqr(x), F.Power((IExpr)F.Abs(x), F.CN3), F.Conjugate(x), F.Sin(theta))), F.list(F.C0, F.Times(x, F.Power((IExpr)F.Abs(x), F.CN3), F.Sqr(F.Conjugate(x)), F.Sin(theta)), F.Times(F.Power(x, F.C3), F.Power((IExpr)F.Abs(x), F.CN6), F.Power((IExpr)F.Conjugate(x), F.C3), F.Cos(theta))));
                    }
                    if (x.isZero()) {
                        return F.list(F.list(F.Cos(theta), F.C0, F.Times(F.Sqr(y), F.Power((IExpr)F.Abs(y), F.CN3), F.Conjugate(y), F.Sin(theta))), F.list(F.C0, F.Times((IExpr)F.Power(y, F.C3), (IExpr)F.Power((IExpr)F.Abs(y), F.CN6), (IExpr)F.Power((IExpr)F.Conjugate(y), F.C3)), F.C0), F.list(F.Times(F.CN1, y, F.Power((IExpr)F.Abs(y), F.CN3), F.Sqr(F.Conjugate(y)), F.Sin(theta)), F.C0, F.Times(F.Power(y, F.C3), F.Power((IExpr)F.Abs(y), F.CN6), F.Power((IExpr)F.Conjugate(y), F.C3), F.Cos(theta))));
                    }
                    return F.NIL;
                }
                if (x.isZero() && y.isZero()) {
                    return F.list(F.list(F.Cos(theta), F.Times(F.CN1, z, F.Power((IExpr)F.Abs(z), F.CN1), F.Sin(theta)), F.C0), F.list(F.Times((IExpr)F.Power((IExpr)F.Abs(z), F.CN1), (IExpr)F.Conjugate(z), (IExpr)F.Sin(theta)), F.Times(z, F.Power((IExpr)F.Abs(z), F.CN2), F.Conjugate(z), F.Cos(theta)), F.C0), F.list(F.C0, F.C0, F.Times(z, (IExpr)F.Power((IExpr)F.Abs(z), F.CN2), (IExpr)F.Conjugate(z))));
                }
                return F.NIL;
            }
            return F.NIL;
        }
    }

    private static final class Grad
    extends AbstractFunctionEvaluator {
        private Grad() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr function = ast.arg1();
            if (ast.arg2().isList() && ast.arg2().size() > 1) {
                IAST variables = (IAST)ast.arg2();
                IASTAppendable dList = F.ListAlloc(variables.argSize());
                variables.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> dList.append(engine.evaluate(F.D(function, x)))));
                return dList;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class Div
    extends AbstractFunctionEvaluator {
        private Div() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isVector() == ast.arg2().isVector() && ast.arg1().isVector() >= 0) {
                IAST vector = (IAST)ast.arg1().normal(false);
                IAST variables = (IAST)ast.arg2().normal(false);
                int size = vector.size();
                IASTAppendable divergenceValue = F.PlusAlloc(size);
                return divergenceValue.appendArgs(size, i -> F.D(vector.get(i), variables.get(i)));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class Curl
    extends AbstractFunctionEvaluator {
        private Curl() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isVector() >= 3 && ast.arg2().isVector() == 3) {
                IAST variables = (IAST)ast.arg2().normal(false);
                IAST vector = (IAST)ast.arg1().normal(false);
                IASTAppendable curlVector = F.ListAlloc(vector.size());
                curlVector.append(F.Subtract(F.D(vector.arg3(), variables.arg2()), F.D(vector.arg2(), variables.arg3())));
                curlVector.append(F.Subtract(F.D(vector.arg1(), variables.arg3()), F.D(vector.arg3(), variables.arg1())));
                curlVector.append(F.Subtract(F.D(vector.arg2(), variables.arg1()), F.D(vector.arg1(), variables.arg2())));
                for (int i = 4; i < vector.size(); ++i) {
                    curlVector.append(vector.get(i));
                }
                return curlVector;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Curl.setEvaluator(new Curl());
            S.Div.setEvaluator(new Div());
            S.Grad.setEvaluator(new Grad());
            S.RotationMatrix.setEvaluator(new RotationMatrix());
        }
    }
}

