/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.FileFunctions;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.TestReportObjectExpr;
import org.matheclipse.core.expression.data.TestResultObjectExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.ast.ASTNode;

public class UnitTestingFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IAST readFile(EvalEngine engine, String str) {
        List<ASTNode> node = FileFunctions.parseReader(str, engine);
        int i = 0;
        AST2Expr ast2Expr = new AST2Expr(engine.isRelaxedSyntax(), engine);
        IASTAppendable list = F.ListAlloc(node.size());
        while (i < node.size()) {
            IExpr temp = ast2Expr.convert(node.get(i++));
            list.append(temp);
        }
        return list;
    }

    public static void initialize() {
        Initializer.init();
    }

    private UnitTestingFunctions() {
    }

    private static class VerificationTest
    extends AbstractEvaluator {
        private VerificationTest() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr option;
            IExpr sameTest = S.SameQ;
            IExpr testID = S.None;
            IExpr actualOutput = S.None;
            IExpr expectedOutput = S.True;
            int size = ast.size();
            OptionArgs options = new OptionArgs(ast.topHead(), ast, 2, engine);
            if (options.isInvalidPosition()) {
                size = options.getInvalidPosition() + 1;
            }
            if ((option = options.getOption(S.SameTest)).isPresent()) {
                sameTest = option;
            }
            if ((option = options.getOption(S.TestID)).isPresent()) {
                testID = engine.evaluate(option);
                LOGGER.debug("\n\n>>>{}", (Object)testID);
            }
            IExpr input = ast.arg1();
            Consumer<IExpr> out = Config.PRINT_OUT;
            try {
                out.accept(input);
                actualOutput = engine.evaluate(input);
            }
            catch (Exception ex) {
                LOGGER.debug("VerificationTest.evaluate", (Throwable)ex);
                actualOutput = S.None;
            }
            if (size > 2) {
                expectedOutput = ast.arg2();
            }
            try {
                IExpr tempActualOutput = engine.evaluate(actualOutput);
                IExpr tempExpectedOutput = engine.evaluate(expectedOutput);
                IExpr result = engine.evaluate(F.binaryAST2(sameTest, tempActualOutput, tempExpectedOutput));
                IAssociation assoc = F.assoc();
                if (result.isTrue()) {
                    VerificationTest.success(assoc);
                } else if (sameTest.equals(S.SameQ)) {
                    String expectedOutputFullForm;
                    String actualOutputFullForm = tempActualOutput.fullFormString();
                    if (actualOutputFullForm.equals(expectedOutputFullForm = expectedOutput.fullFormString())) {
                        VerificationTest.success(assoc);
                    } else {
                        boolean test = tempActualOutput.equals(tempExpectedOutput);
                        if (!test) {
                            VerificationTest.failure(assoc);
                        } else {
                            VerificationTest.success(assoc);
                        }
                    }
                } else {
                    VerificationTest.failure(assoc);
                }
                assoc.appendRule(F.Rule("Input", (IExpr)F.HoldForm(input)));
                assoc.appendRule(F.Rule("ExpectedOutput", (IExpr)F.HoldForm(expectedOutput)));
                assoc.appendRule(F.Rule("ActualOutput", (IExpr)F.HoldForm(actualOutput)));
                assoc.appendRule(F.Rule("TestID", testID));
                return TestResultObjectExpr.newInstance(assoc);
            }
            catch (Exception ex) {
                LOGGER.debug("VerificationTest.evaluate() failed", (Throwable)ex);
                return F.NIL;
            }
        }

        private static void failure(IAssociation assoc) {
            assoc.appendRule(F.Rule("Outcome", "Failure"));
            LOGGER.debug(" - Failure");
        }

        private static void success(IAssociation assoc) {
            assoc.appendRule(F.Rule("Outcome", "Success"));
            LOGGER.debug(" - Success");
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262624);
        }
    }

    private static class TestReport
    extends AbstractEvaluator {
        private TestReport() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                if (ast.arg1().isList()) {
                    IAST listOfVerificationTest = (IAST)ast.arg1();
                    if (listOfVerificationTest.forAll(x -> x.isAST(S.VerificationTest))) {
                        IAssociation testResults = F.assoc();
                        int testCounter = 1;
                        for (int j = 1; j < listOfVerificationTest.size(); ++j) {
                            IAST verificationTest = (IAST)listOfVerificationTest.get(j);
                            IExpr result = engine.evaluate(verificationTest);
                            if (!(result instanceof TestResultObjectExpr)) continue;
                            testResults.appendRule(F.Rule((IExpr)F.ZZ(testCounter++), result));
                        }
                        IAssociation testReportObject = F.assoc();
                        testReportObject.appendRule(F.Rule("TestResults", (IExpr)testResults));
                        return TestReportObjectExpr.newInstance(testReportObject);
                    }
                    return F.NIL;
                }
                if (!(ast.arg1() instanceof IStringX)) {
                    return IOFunctions.printMessage(ast.topHead(), "string", F.CEmptyList, engine);
                }
                String arg1 = ast.arg1().toString();
                if (arg1.startsWith("https://") || arg1.startsWith("http://")) {
                    try {
                        URL url = new URL(arg1);
                        return TestReport.getURL(url, ast, engine);
                    }
                    catch (MalformedURLException mue) {
                        LOGGER.debug("TestReport.evaluate() failed", (Throwable)mue);
                        return IOFunctions.printMessage(ast.topHead(), "noopen", F.list(ast.arg1()), engine);
                    }
                }
                File file = new File(arg1);
                if (file.exists()) {
                    return TestReport.getFile(file, ast, engine);
                }
                file = FileSystems.getDefault().getPath(arg1.toString(), new String[0]).toAbsolutePath().toFile();
                if (file.exists()) {
                    return TestReport.getFile(file, ast, engine);
                }
                return IOFunctions.printMessage(ast.topHead(), "noopen", F.list(ast.arg1()), engine);
            }
            return F.NIL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static IExpr getFile(File file, IAST ast, EvalEngine engine) {
            try {
                String str = Files.asCharSource((File)file, (Charset)Charset.defaultCharset()).read();
                IExpr iExpr = TestReport.runTests(engine, str);
                return iExpr;
            }
            catch (IOException e) {
                LOGGER.debug("TestReport.getFile() failed", (Throwable)e);
                IAST iAST = IOFunctions.printMessage(ast.topHead(), "noopen", F.list(ast.arg1()), engine);
                return iAST;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static IExpr getURL(URL url, IAST ast, EvalEngine engine) {
            try {
                String str = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
                IExpr iExpr = TestReport.runTests(engine, str);
                return iExpr;
            }
            catch (IOException e) {
                LOGGER.debug("TestReport.getURL() failed", (Throwable)e);
                IAST iAST = IOFunctions.printMessage(ast.topHead(), "noopen", F.list(ast.arg1()), engine);
                return iAST;
            }
        }

        private static IExpr runTests(EvalEngine engine, String str) {
            List<ASTNode> node = FileFunctions.parseReader(str, engine);
            IAssociation testResults = TestReport.evaluatePackage(node, engine);
            IAssociation testResultObject = F.assoc();
            testResultObject.appendRule(F.Rule("TestResults", (IExpr)testResults));
            return TestReportObjectExpr.newInstance(testResultObject);
        }

        public static IAssociation evaluatePackage(List<ASTNode> node, EvalEngine engine) {
            int i = 0;
            AST2Expr ast2Expr = new AST2Expr(engine.isRelaxedSyntax(), engine);
            IExpr result = S.Null;
            IAssociation assoc = F.assoc();
            int testCounter = 1;
            while (i < node.size()) {
                IExpr temp;
                if ((temp = ast2Expr.convert(node.get(i++))).isAST(S.CompoundExpression)) {
                    IAST compoundExpression = (IAST)temp;
                    for (int j = 1; j < compoundExpression.size(); ++j) {
                        temp = compoundExpression.get(j);
                        result = engine.evaluate(temp);
                        if (!(result instanceof TestResultObjectExpr)) continue;
                        assoc.appendRule(F.Rule((IExpr)F.ZZ(testCounter++), result));
                    }
                    continue;
                }
                result = engine.evaluate(temp);
                if (!(result instanceof TestResultObjectExpr)) continue;
                assoc.appendRule(F.Rule((IExpr)F.ZZ(testCounter++), result));
            }
            return assoc;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(32);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.TestReport.setEvaluator(new TestReport());
            S.VerificationTest.setEvaluator(new VerificationTest());
        }
    }
}

