/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.LinearAlgebra;
import org.matheclipse.core.builtin.ListFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.util.Assumptions;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.SparseArrayExpr;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISparseArray;
import org.matheclipse.core.interfaces.ISymbol;

public class TensorFunctions {
    private static Map<IExpr, IAST> tensorProperties(IAssumptions oldAssumptions, IExpr assumptionExpr) {
        if (assumptionExpr.isPresent() && assumptionExpr.isAST()) {
            IAssumptions assumptions = Assumptions.getInstance(assumptionExpr);
            if (assumptions != null) {
                return assumptions.getTensorsMap();
            }
        } else if (oldAssumptions != null) {
            return oldAssumptions.getTensorsMap();
        }
        return null;
    }

    public static void initialize() {
        Initializer.init();
    }

    private TensorFunctions() {
    }

    private static class TensorRank
    extends AbstractEvaluator {
        private TensorRank() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isList()) {
                IAST list = (IAST)arg1;
                IntArrayList intList = LinearAlgebra.dimensions((IAST)arg1, list.head());
                return F.ZZ(intList.size());
            }
            if (arg1.isNumber()) {
                return F.C0;
            }
            if (arg1.isNumericFunction()) {
                if (engine.evalN(arg1).isNumber()) {
                    return F.C0;
                }
            } else if (arg1.isSparseArray()) {
                return F.ZZ(((ISparseArray)arg1).getDimension().length);
            }
            IAssumptions oldAssumptions = engine.getAssumptions();
            OptionArgs options = null;
            if (ast.size() > 2) {
                options = new OptionArgs(ast.topHead(), ast, ast.argSize(), engine);
            }
            IExpr assumptionExpr = OptionArgs.determineAssumptions(ast, 2, options);
            try {
                IAST tensorArg1;
                Map<IExpr, IAST> tensorProperties = TensorFunctions.tensorProperties(oldAssumptions, assumptionExpr);
                if (tensorProperties != null && (tensorArg1 = tensorProperties.get(arg1)) != null) {
                    if (tensorArg1.isAST(S.Vectors)) {
                        IInteger iInteger = F.C1;
                        return iInteger;
                    }
                    if (tensorArg1.isAST(S.Matrices)) {
                        IInteger iInteger = F.C2;
                        return iInteger;
                    }
                    if (tensorArg1.isAST(S.Arrays)) {
                        int size = tensorArg1.arg1().argSize();
                        IInteger iInteger = F.ZZ(size);
                        return iInteger;
                    }
                }
            }
            finally {
                engine.setAssumptions(oldAssumptions);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Assumptions, (IExpr)S.$Assumptions)));
        }
    }

    private static class TensorProduct
    extends AbstractEvaluator {
        private TensorProduct() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST tensor1;
            IntArrayList dim1;
            int argSize = ast.argSize();
            if (argSize == 0) {
                return F.C0;
            }
            if (argSize == 1) {
                return ast.arg1();
            }
            if (ast.arg1().isList() && ast.arg2().isList() && (dim1 = LinearAlgebra.dimensions(tensor1 = (IAST)ast.arg1(), S.List)).size() > 0) {
                for (int i = 2; i < ast.size(); ++i) {
                    IExpr temp;
                    IAST tensor2 = (IAST)ast.get(i);
                    IntArrayList dim2 = LinearAlgebra.dimensions(tensor2, S.List);
                    if (dim2.size() > 0 && (temp = TensorProduct.tensorProduct(tensor1, tensor2, dim1.size(), engine)).isPresent()) {
                        if (temp.isList() && (dim1 = LinearAlgebra.dimensions(tensor1 = (IAST)temp, S.List)).size() > 0) {
                            if (i < argSize) {
                                if (ast.get(i + 1).isList()) {
                                    continue;
                                }
                            } else {
                                return tensor1;
                            }
                        }
                        IASTAppendable result = F.ast(S.TensorProduct);
                        result.append(temp);
                        result.appendAll(ast, i + 1, ast.size());
                        return result;
                    }
                    if (i == 2) {
                        return F.NIL;
                    }
                    IASTAppendable result = F.ast(S.TensorProduct);
                    result.append(tensor1);
                    result.appendAll(ast, i, ast.size());
                    return result;
                }
                return tensor1;
            }
            return F.NIL;
        }

        private static IExpr tensorProduct(IAST tensor1, IAST tensor2, int tensor1Depth, EvalEngine engine) {
            return engine.evaluate(F.Map(F.Function(F.Times((IExpr)F.Slot1, (IExpr)tensor2)), tensor1, F.List(tensor1Depth)));
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(9);
        }
    }

    private static class TensorSymmetry
    extends AbstractEvaluator {
        private TensorSymmetry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST tensor;
            IntArrayList dims;
            int dimsSize2;
            IExpr option;
            IAssumptions oldAssumptions = engine.getAssumptions();
            OptionArgs options = null;
            IExpr sameTest = S.SameQ;
            if (ast.size() > 2 && (option = (options = new OptionArgs(ast.topHead(), ast, ast.argSize(), engine)).getOption(S.SameTest)).isPresent()) {
                sameTest = option;
            }
            IExpr assumptionExpr = OptionArgs.determineAssumptions(ast, 2, options);
            IExpr arg1 = ast.arg1().normal(false);
            if (arg1.isAST() && (dimsSize2 = (dims = LinearAlgebra.dimensions(tensor = (IAST)arg1, tensor.head())).size()) > 0 && dimsSize2 == 2 && dims.getInt(0) == dims.getInt(1)) {
                int rowColumnSize = dims.getInt(0) + 1;
                if (rowColumnSize == 2) {
                    if (tensor.getPart(1, 1).isZero()) {
                        return F.ZeroSymmetric(F.CEmptyList);
                    }
                    return F.Symmetric(F.list(F.C1, F.C2));
                }
                return TensorSymmetry.tensorSymmetrySquareMatrix(tensor, rowColumnSize, sameTest, engine);
            }
            try {
                IAST tensorArg1;
                Map<IExpr, IAST> tensorProperties = TensorFunctions.tensorProperties(oldAssumptions, assumptionExpr);
                if (tensorProperties != null && (tensorArg1 = tensorProperties.get(arg1)) != null) {
                    IAST arg3;
                    if (tensorArg1.isAST(S.Vectors)) {
                        IAST dimsSize2 = F.CEmptyList;
                        return dimsSize2;
                    }
                    if ((tensorArg1.isAST(S.Arrays, 3) || tensorArg1.isAST(S.Matrices, 3)) && tensorArg1.last().isAST() && ((arg3 = (IAST)tensorArg1.last()).isAST(S.Symmetric, 2) || arg3.isAST(S.AntiSymmetric, 2) || arg3.isAST(S.ZeroSymmetric, 2))) {
                        IAST iAST = arg3;
                        return iAST;
                    }
                }
            }
            finally {
                engine.setAssumptions(oldAssumptions);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private static IExpr tensorSymmetrySquareMatrix(IAST squareMatrix, int rowColumnSize, IExpr sameTest, EvalEngine engine) {
            IExpr temp = TensorSymmetry.isZeroSymmetricSquareMatrix(squareMatrix, rowColumnSize);
            if (temp.isPresent()) {
                return temp;
            }
            boolean isAntiSymmetric = true;
            boolean isSymmetric = true;
            for (int i = 1; i < rowColumnSize; ++i) {
                int j;
                if (isSymmetric) {
                    if (sameTest == S.SameQ) {
                        j = i + 1;
                        while (j < rowColumnSize) {
                            if (squareMatrix.getPart(i, j).equals(squareMatrix.getPart(j++, i))) continue;
                            isSymmetric = false;
                            break;
                        }
                    } else {
                        j = i + 1;
                        while (j < rowColumnSize) {
                            if (engine.evalTrue(sameTest, squareMatrix.getPart(i, j), squareMatrix.getPart(j++, i))) continue;
                            isSymmetric = false;
                            break;
                        }
                    }
                }
                if (isSymmetric) {
                    isAntiSymmetric = false;
                } else if (isAntiSymmetric) {
                    if (sameTest == S.SameQ) {
                        j = i + 1;
                        while (j < rowColumnSize) {
                            temp = squareMatrix.getPart(j, i).negate();
                            if (squareMatrix.getPart(i, j++).equals(temp)) continue;
                            isAntiSymmetric = false;
                            break;
                        }
                    } else {
                        j = i + 1;
                        while (j < rowColumnSize) {
                            temp = squareMatrix.getPart(j, i).negate();
                            if (engine.evalTrue(sameTest, squareMatrix.getPart(i, j++), temp)) continue;
                            isAntiSymmetric = false;
                            break;
                        }
                    }
                }
                if (isAntiSymmetric || isSymmetric) continue;
                return F.CEmptyList;
            }
            if (isSymmetric) {
                return F.Symmetric(F.list(F.C1, F.C2));
            }
            if (isAntiSymmetric) {
                return F.AntiSymmetric(F.list(F.C1, F.C2));
            }
            return F.CEmptyList;
        }

        private static IExpr isZeroSymmetricSquareMatrix(IAST squareMatrix, int rowColumnSize) {
            boolean isZero = true;
            for (int i = 1; i < rowColumnSize; ++i) {
                int j = 1;
                while (j < rowColumnSize) {
                    if (squareMatrix.getPart(i, j++).isZero()) continue;
                    isZero = false;
                    break;
                }
                if (!isZero) break;
            }
            if (isZero) {
                return F.ZeroSymmetric(F.List());
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Assumptions, (IExpr)S.$Assumptions), F.Rule((IExpr)S.SameTest, (IExpr)S.Automatic)));
        }
    }

    private static class TensorDimensions
    extends AbstractEvaluator {
        private TensorDimensions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isList() || arg1.isSparseArray()) {
                return F.Dimensions(arg1);
            }
            IAssumptions oldAssumptions = engine.getAssumptions();
            OptionArgs options = null;
            if (ast.size() > 2) {
                options = new OptionArgs(ast.topHead(), ast, ast.argSize(), engine);
            }
            IExpr assumptionExpr = OptionArgs.determineAssumptions(ast, 2, options);
            try {
                Map<IExpr, IAST> tensorProperties = TensorFunctions.tensorProperties(oldAssumptions, assumptionExpr);
                if (tensorProperties != null) {
                    if (arg1.isASTSizeGE(S.Dot, 3)) {
                        IExpr iExpr = TensorDimensions.dotDimensions(ast, tensorProperties, engine);
                        return iExpr;
                    }
                    IAST tensorArg1 = tensorProperties.get(arg1);
                    if (tensorArg1 != null) {
                        if (tensorArg1.isAST(S.Vectors)) {
                            IAST iAST = F.list(tensorArg1.arg1());
                            return iAST;
                        }
                        IExpr iExpr = tensorArg1.arg1();
                        return iExpr;
                    }
                }
            }
            finally {
                engine.setAssumptions(oldAssumptions);
            }
            return F.NIL;
        }

        private static IExpr dotDimensions(IAST tensorDimensions, Map<IExpr, IAST> tensorAssumptions, EvalEngine engine) {
            IAST dotAST = (IAST)tensorDimensions.arg1();
            IExpr lastArg = dotAST.arg1();
            IAST property1 = tensorAssumptions.get(lastArg);
            if (property1 != null && property1.isAST(S.Matrices)) {
                IASTMutable dims = F.binaryAST2((IExpr)S.List, property1.arg1().first(), property1.arg1().second());
                for (int i = 2; i < dotAST.size(); ++i) {
                    IAST iDims;
                    IExpr tempArg = dotAST.get(i);
                    IAST property = tensorAssumptions.get(tempArg);
                    if (property == null) {
                        return F.NIL;
                    }
                    if (property.isAST(S.Matrices)) {
                        iDims = (IAST)property.arg1();
                        if (!dims.second().equals(iDims.first())) {
                            return IOFunctions.printMessage(tensorDimensions.topHead(), "dotdim", F.List(lastArg, tempArg, dims.second(), iDims.first()), engine);
                        }
                    } else {
                        return F.NIL;
                    }
                    dims.set(2, iDims.second());
                    lastArg = tempArg;
                }
                return dims;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Assumptions, (IExpr)S.$Assumptions)));
        }
    }

    private static class Ordering
    extends AbstractEvaluator {
        private Ordering() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAST()) {
                IExpr arg2;
                IAST list = (IAST)ast.arg1();
                ArrayIndexComparator comparator = ast.size() >= 4 ? new PredicateComparator(list, new Predicates.IsBinaryFalse(ast.arg3())) : new ArrayIndexComparator(list);
                Integer[] indexes = comparator.createIndexArray();
                Arrays.sort(indexes, comparator);
                int n = indexes.length;
                if (ast.size() >= 3 && !(arg2 = ast.arg2()).equals(S.All) && arg2.isReal()) {
                    ISignedNumber sn = (ISignedNumber)arg2;
                    n = sn.toIntDefault();
                }
                if (n == Integer.MIN_VALUE) {
                    return F.NIL;
                }
                return F.tensorList(n, indexes);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }

        private static class PredicateComparator
        extends ArrayIndexComparator {
            final Comparator<IExpr> comparator;

            public PredicateComparator(IAST ast, Comparator<IExpr> comparator) {
                super(ast);
                this.comparator = comparator;
            }

            @Override
            public int compare(Integer index1, Integer index2) {
                return this.comparator.compare(this.ast.get(index1), this.ast.get(index2));
            }
        }

        private static class ArrayIndexComparator
        implements Comparator<Integer> {
            protected final IAST ast;

            public ArrayIndexComparator(IAST ast) {
                this.ast = ast;
            }

            public Integer[] createIndexArray() {
                int size = this.ast.size();
                Integer[] indexes = new Integer[size - 1];
                for (int i = 1; i < size; ++i) {
                    indexes[i - 1] = i;
                }
                return indexes;
            }

            @Override
            public int compare(Integer index1, Integer index2) {
                return this.ast.get(index1).compareTo(this.ast.get(index2));
            }
        }
    }

    private static class ListCorrelate
    extends AbstractEvaluator {
        private ListCorrelate() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2() && ast.arg1().isAST() && ast.arg2().isAST()) {
                int tensorSize;
                IAST kernel = (IAST)ast.arg1();
                IAST tensor = (IAST)ast.arg2();
                int kernelSize = kernel.size();
                if (kernelSize <= (tensorSize = tensor.size())) {
                    return ListCorrelate.listCorrelate(kernel, kernelSize, tensor, tensorSize);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        public static IExpr listCorrelate(IAST kernel, int kernelSize, IAST tensor, int tensorSize) {
            IBuiltInSymbol fFunction = S.Plus;
            IBuiltInSymbol gFunction = S.Times;
            int diff = tensorSize - kernelSize;
            IASTAppendable resultList = F.ListAlloc(tensorSize - 1);
            int[] fi = new int[1];
            int i = 0;
            while (i <= diff) {
                IASTAppendable plus = F.ast((IExpr)fFunction, kernelSize);
                fi[0] = i++;
                plus.appendArgs(kernelSize, k -> F.binaryAST2((IExpr)gFunction, kernel.get(k), tensor.get(k + fi[0])));
                resultList.append(plus);
            }
            return resultList;
        }
    }

    private static class ListConvolve
    extends AbstractEvaluator {
        private ListConvolve() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2() && ast.arg1().isAST() && ast.arg2().isAST()) {
                int tensorSize;
                IAST kernel = (IAST)ast.arg1();
                IAST tensor = (IAST)ast.arg2();
                int kernelSize = kernel.size();
                if (kernelSize <= (tensorSize = tensor.size())) {
                    return ListCorrelate.listCorrelate(ListFunctions.reverse(kernel), kernelSize, tensor, tensorSize);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class LeviCivitaTensor
    extends AbstractEvaluator {
        private LeviCivitaTensor() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            int n = arg1.toIntDefault();
            if (n <= 0) {
                if (!arg1.isInteger()) {
                    return F.NIL;
                }
                return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast, F.C1), engine);
            }
            double value = n;
            double max = Math.pow(value, value);
            if (Double.isNaN(max) || Double.isInfinite(max)) {
                ASTElementLimitExceeded.throwIt(Config.MAX_AST_SIZE);
            }
            if ((double)Config.MAX_AST_SIZE < max) {
                ASTElementLimitExceeded.throwIt((int)max);
            }
            IASTAppendable nCopies = F.constantArray(F.ZZ(n), n);
            IExpr leviCivitaNormalForm = S.Array.of(engine, F.Function(F.Signature(F.list(F.SlotSequence(1)))), nCopies);
            if (leviCivitaNormalForm.isList()) {
                return SparseArrayExpr.newDenseList((IAST)leviCivitaNormalForm, F.C0);
            }
            return leviCivitaNormalForm;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class HodgeDual
    extends AbstractEvaluator {
        private HodgeDual() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IntArrayList dims;
            int dimsSize;
            IExpr tensor = ast.arg1();
            if (tensor.isList() && (dimsSize = (dims = LinearAlgebra.dimensions((IAST)tensor)).size()) > 0) {
                IInteger d = F.ZZ(dims.getInt(dimsSize - 1));
                int rank = S.TensorRank.of(engine, tensor).toIntDefault();
                if (rank == 1) {
                    IExpr dotProduct = engine.evaluate(F.Dot(tensor, (IExpr)F.LeviCivitaTensor(d)));
                    return dotProduct;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class ArrayReshape
    extends AbstractEvaluator {
        private ArrayReshape() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (!arg1.isList()) {
                arg1 = arg1.normal(false);
            }
            if (arg1.isList() && ast.arg2().isList()) {
                int[] dimension;
                IAST list = (IAST)arg1;
                IAST dims = (IAST)ast.arg2();
                if (dims.size() == 1) {
                    if (list.isEmpty()) {
                        return F.C0;
                    }
                    if (list.size() > 1) {
                        return list.arg1();
                    }
                }
                if ((dimension = Validate.checkListOfInts(ast, (IExpr)dims, 1, Integer.MAX_VALUE, engine)) == null) {
                    return F.NIL;
                }
                IExpr padding = F.C0;
                if (ast.size() == 4) {
                    padding = ast.arg3();
                }
                Reshaper reshaper = new Reshaper(list, dimension, padding);
                return reshaper.recursiveCall(0);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        static class Reshaper {
            final IAST list;
            final int[] dimension;
            final IExpr padding;
            int listPosition;

            public Reshaper(IAST list, int[] dimension, IExpr padding) {
                this.list = list;
                this.dimension = dimension;
                this.padding = padding;
                this.listPosition = 1;
            }

            public IAST recursiveCall(int dimensionIndex) {
                int dim = this.dimension[dimensionIndex];
                if (this.dimension.length == dimensionIndex + 1) {
                    IASTAppendable result = F.ListAlloc(dim);
                    for (int i = 0; i < dim; ++i) {
                        if (this.list.size() <= this.listPosition) {
                            result.append(this.padding);
                            continue;
                        }
                        result.append(this.list.get(this.listPosition++));
                    }
                    return result;
                }
                IASTAppendable result = F.ListAlloc(dim);
                for (int i = 0; i < dim; ++i) {
                    IAST subList = this.recursiveCall(dimensionIndex + 1);
                    result.append(subList);
                }
                return result;
            }
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.ArrayReshape.setEvaluator(new ArrayReshape());
            S.Ordering.setEvaluator(new Ordering());
            S.HodgeDual.setEvaluator(new HodgeDual());
            S.LeviCivitaTensor.setEvaluator(new LeviCivitaTensor());
            S.ListConvolve.setEvaluator(new ListConvolve());
            S.ListCorrelate.setEvaluator(new ListCorrelate());
            S.TensorDimensions.setEvaluator(new TensorDimensions());
            S.TensorProduct.setEvaluator(new TensorProduct());
            S.TensorRank.setEvaluator(new TensorRank());
            S.TensorSymmetry.setEvaluator(new TensorSymmetry());
        }
    }
}

