/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.LinearAlgebra;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.EvalHistory;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Lambda;
import org.matheclipse.core.eval.util.OpenFixedSizeMap;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTDataset;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISparseArray;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMap;
import org.matheclipse.core.patternmatching.PatternMatcherAndEvaluator;
import org.matheclipse.core.visit.AbstractVisitorLong;
import org.matheclipse.core.visit.IndexedLevel;
import org.matheclipse.core.visit.ModuleReplaceAll;
import org.matheclipse.core.visit.VisitorLevelSpecification;

public class StructureFunctions {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<ISymbol> LOGIC_EQUATION_HEADS = Collections.newSetFromMap(new IdentityHashMap(29));
    private static final Set<ISymbol> PLUS_LOGIC_EQUATION_HEADS = Collections.newSetFromMap(new IdentityHashMap(29));
    private static final Set<ISymbol> LIST_LOGIC_EQUATION_HEADS = Collections.newSetFromMap(new IdentityHashMap(29));

    public static IAST threadLogicEquationOperators(IExpr expr, IAST replacement, int position) {
        IAST ast;
        if (expr.size() > 1 && expr.isAST() && LOGIC_EQUATION_HEADS.contains((ast = (IAST)expr).head())) {
            return ast.mapThread(replacement, position);
        }
        return F.NIL;
    }

    public static IAST threadPlusLogicEquationOperators(IExpr expr, IAST replacement, int position) {
        IAST ast;
        if (expr.size() > 1 && expr.isAST() && PLUS_LOGIC_EQUATION_HEADS.contains((ast = (IAST)expr).head())) {
            return ast.mapThread(replacement, position);
        }
        return F.NIL;
    }

    public static IAST threadListLogicEquationOperators(IExpr expr, IAST replacement, int position) {
        IAST ast;
        if (expr.size() > 1 && expr.isAST() && LIST_LOGIC_EQUATION_HEADS.contains((ast = (IAST)expr).head())) {
            return ast.mapThread(replacement, position);
        }
        return F.NIL;
    }

    public static AbstractVisitorLong leafCountVisitor() {
        return new LeafCount.LeafCountVisitor(0);
    }

    public static void initialize() {
        Initializer.init();
    }

    private StructureFunctions() {
    }

    private static class Through
    extends AbstractFunctionEvaluator {
        private Through() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAST()) {
                IAST arg1AST = (IAST)ast.arg1();
                IExpr arg1Head = arg1AST.head();
                if (arg1Head.isAST()) {
                    IAST arg1HeadAST = (IAST)arg1Head;
                    if (ast.isAST2() && !arg1HeadAST.head().equals(ast.arg2())) {
                        return arg1AST;
                    }
                    IASTAppendable result = F.ast(arg1HeadAST.head());
                    return result.appendArgs(arg1HeadAST.size(), i -> arg1AST.apply(arg1HeadAST.get(i)));
                }
                return arg1AST;
            }
            return ast.arg1();
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Thread
    extends AbstractFunctionEvaluator {
        private Thread() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST list;
            if (!ast.arg1().isAST()) {
                return F.NIL;
            }
            IExpr head = S.List;
            if (ast.isAST2()) {
                head = ast.arg2();
            }
            if ((list = (IAST)ast.arg1()).size() > 1) {
                return Thread.threadList(list, head, list.head()).orElse(list);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        public static IAST threadList(IAST list, IExpr head, IExpr mapHead) {
            int listLength = -1;
            for (int i = 1; i < list.size(); ++i) {
                if (!list.get(i).isAST() || !((IAST)list.get(i)).head().equals(head)) continue;
                if (listLength == -1) {
                    listLength = ((IAST)list.get(i)).argSize();
                    continue;
                }
                if (listLength == ((IAST)list.get(i)).argSize()) continue;
                IOFunctions.printMessage(S.Thread, "tdlen", F.list(list), EvalEngine.get());
                listLength = -1;
                return F.NIL;
            }
            if (listLength == -1) {
                return list;
            }
            return EvalAttributes.threadList(list, head, mapHead, listLength);
        }
    }

    private static class SymbolName
    extends AbstractFunctionEvaluator {
        private SymbolName() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isSymbol()) {
                return F.stringx(ast.arg1().toString());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class Symbol
    extends AbstractFunctionEvaluator {
        private Symbol() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isString()) {
                return F.symbol(ast.arg1().toString(), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class SortBy
    extends AbstractFunctionEvaluator {
        private SortBy() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2()) {
                try {
                    if (ast.arg1().isDataset()) {
                        List<String> listOfStrings = Convert.toStringList(ast.arg2());
                        if (listOfStrings != null) {
                            return ((IASTDataset)ast.arg1()).groupBy(listOfStrings);
                        }
                        return F.NIL;
                    }
                    if (ast.arg1().isASTOrAssociation()) {
                        IAST arg1 = (IAST)ast.arg1();
                        IExpr arg2 = ast.arg2();
                        IASTAppendable sortAST = F.ListAlloc(arg1.size());
                        for (int i = 1; i < arg1.size(); ++i) {
                            IExpr unary = F.unaryAST1(arg2, arg1.get(i));
                            unary = engine.evaluate(unary);
                            sortAST.append(F.binaryAST2((IExpr)S.List, unary, (IExpr)F.ZZ(i)));
                        }
                        EvalAttributes.sort(sortAST);
                        IASTAppendable result = F.ast(arg1.head(), arg1.size());
                        for (int i = 1; i < arg1.size(); ++i) {
                            int sortedIndex = sortAST.get(i).second().toIntDefault(-1);
                            if (sortedIndex < 0) {
                                return F.NIL;
                            }
                            result.append(arg1.get(sortedIndex));
                        }
                        return result;
                    }
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2_1;
        }
    }

    private static class Sort
    extends AbstractFunctionEvaluator {
        private Sort() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isASTOrAssociation()) {
                IASTMutable shallowCopy;
                IAST arg1 = (IAST)ast.arg1();
                if (ast.isAST1()) {
                    if (arg1.isEvalFlagOn(512)) {
                        return arg1;
                    }
                    if (arg1.isAssociation()) {
                        return ((IAssociation)arg1).sort();
                    }
                } else if (arg1.isAssociation()) {
                    return ((IAssociation)arg1).sort(new Predicates.IsBinaryFalse(ast.arg2()));
                }
                if ((shallowCopy = ((IAST)ast.arg1()).copy()).size() <= 2) {
                    return shallowCopy;
                }
                try {
                    if (ast.isAST1()) {
                        EvalAttributes.sort(shallowCopy);
                    } else {
                        EvalAttributes.sort(shallowCopy, new Predicates.IsBinaryFalse(ast.arg2()));
                    }
                    return shallowCopy;
                }
                catch (RuntimeException rex) {
                    LOGGER.error("Sort.evaluate() failed", (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Scan
    extends Map {
        private Scan() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int argSize = ast.argSize();
            if (argSize >= 2) {
                OptionArgs options;
                IExpr option;
                int lastIndex = argSize;
                boolean heads = false;
                if (argSize > 2 && (option = (options = new OptionArgs(ast.topHead(), ast, lastIndex, engine)).getOption(S.Heads)).isPresent()) {
                    --lastIndex;
                    if (option.isTrue()) {
                        heads = true;
                    }
                }
                try {
                    IExpr arg1 = ast.arg1();
                    IExpr arg2 = ast.arg2();
                    if (lastIndex == 3) {
                        IASTAppendable result = F.ListAlloc(10);
                        java.util.function.Function<IExpr, IExpr> sf = x -> {
                            IASTMutable a = F.unaryAST1(arg1, x);
                            result.append(a);
                            return F.NIL;
                        };
                        VisitorLevelSpecification level = new VisitorLevelSpecification(sf, ast.get(lastIndex), heads, engine);
                        arg2.accept(level);
                        result.forEach(result.size(), x -> engine.evaluate((IExpr)x));
                    } else if (arg2.isAST()) {
                        ((IAST)arg2).forEach(x -> engine.evaluate(F.unaryAST1(arg1, x)), heads ? 0 : 1);
                    }
                    return S.Null;
                }
                catch (ReturnException e) {
                    return e.getValue();
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4_2;
        }
    }

    private static final class QuitExit
    extends AbstractFunctionEvaluator {
        private QuitExit() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return QuitExit.quitEngine(ast, engine);
        }

        private static IExpr quitEngine(IAST ast, EvalEngine engine) {
            EvalEngine newEngine = new EvalEngine("", engine.getRecursionLimit(), engine.getIterationLimit(), null, null, engine.isRelaxedSyntax());
            engine.setPrintStreamsOf(engine);
            EvalHistory lch = engine.getEvalHistory();
            if (lch != null) {
                newEngine.setOutListDisabled(false, lch.getHistoryLength());
            }
            EvalEngine.setReset(newEngine);
            if (ast.isAST1()) {
                int value = ast.arg1().toIntDefault();
                if (value < 0) {
                    return IOFunctions.printMessage(ast.topHead(), "intnn", F.CEmptyList, newEngine);
                }
                if (value > 0) {
                    return F.ZZ(value);
                }
            }
            return S.Null;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class PatternOrder
    extends AbstractFunctionEvaluator {
        private PatternOrder() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 3) {
                IExpr arg1 = ast.arg1();
                IExpr arg2 = ast.arg2();
                PatternMatcherAndEvaluator pmEvaluator1 = new PatternMatcherAndEvaluator(arg1, S.Null);
                PatternMatcherAndEvaluator pmEvaluator2 = new PatternMatcherAndEvaluator(arg2, S.Null);
                int[] priority1 = new int[]{Integer.MAX_VALUE};
                IPatternMap.determinePatterns(arg1, priority1, null);
                int[] priority2 = new int[]{Integer.MAX_VALUE};
                IPatternMap.determinePatterns(arg2, priority2, null);
                if (pmEvaluator1.isRuleWithoutPatterns()) {
                    if (pmEvaluator2.isRuleWithoutPatterns()) {
                        return F.ZZ(-1 * arg1.compareTo(arg2));
                    }
                    return F.C1;
                }
                if (pmEvaluator2.isRuleWithoutPatterns()) {
                    return F.CN1;
                }
                if (priority1[0] > priority2[0]) {
                    return F.C1;
                }
                if (priority1[0] < priority2[0]) {
                    return F.CN1;
                }
                return F.ZZ(pmEvaluator1.equivalentLHS(pmEvaluator2));
            }
            return F.NIL;
        }
    }

    private static final class Operate
    extends AbstractFunctionEvaluator {
        private Operate() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IASTAppendable result;
            int headDepth = 1;
            if (ast.isAST3()) {
                if (!ast.arg3().isInteger()) {
                    return F.NIL;
                }
                IInteger depth = (IInteger)ast.arg3();
                if (depth.isNegative()) {
                    return IOFunctions.printMessage(ast.topHead(), "intnn", F.CEmptyList, engine);
                }
                headDepth = depth.toIntDefault();
                if (headDepth == Integer.MIN_VALUE) {
                    return F.NIL;
                }
            }
            IExpr p = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (headDepth == 0) {
                return F.unaryAST1(p, arg2);
            }
            if (!arg2.isAST()) {
                return arg2;
            }
            IExpr expr = arg2;
            for (int i = 1; i < headDepth; ++i) {
                if ((expr = expr.head()).isAST()) continue;
                return arg2;
            }
            IASTAppendable last = result = ((IAST)arg2).copyAppendable();
            IASTAppendable head = result;
            for (int i = 1; i < headDepth; ++i) {
                head = ((IAST)head.head()).copyAppendable();
                last.set(0, head);
                last = head;
            }
            head.set(0, F.unaryAST1(p, head.head()));
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }
    }

    private static final class OrderedQ
    extends AbstractFunctionEvaluator
    implements Predicate<IAST> {
        private OrderedQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST arg1AST = Validate.checkASTOrAssociationType(ast, ast.arg1(), 1, engine);
            if (arg1AST.isPresent()) {
                return F.bool(this.test(arg1AST));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public boolean test(IAST ast) {
            return ast.compareAdjacent((x, y) -> x.isLEOrdered((IExpr)y));
        }
    }

    private static final class Order
    extends AbstractFunctionEvaluator {
        private Order() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int cp = ast.arg1().compareTo(ast.arg2());
            if (cp < 0) {
                return F.C1;
            }
            if (cp > 0) {
                return F.CN1;
            }
            return F.C0;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class MapThread
    extends AbstractFunctionEvaluator {
        private MapThread() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg2().isAST()) {
                int level = 1;
                if (ast.isAST3() && (level = ast.arg3().toIntDefault(-1)) < 0) {
                    return F.NIL;
                }
                IAST tensor = (IAST)ast.arg2();
                IntArrayList dims = LinearAlgebra.dimensions(tensor, tensor.head());
                if (dims.size() > level) {
                    if (level == 0) {
                        return tensor.apply(ast.arg1());
                    }
                    return new MapThreadLevel(ast.arg1(), level).mapThreadRecursive(0, tensor, null);
                }
                if (tensor.isEmptyList()) {
                    return tensor;
                }
                LOGGER.log(engine.getLogLevel(), "MapThread: argument 2 dimensions less than level.");
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3_2;
        }

        private static class MapThreadLevel {
            final int level;
            final IExpr constant;

            private MapThreadLevel(IExpr constant, int level) {
                this.constant = constant;
                this.level = level;
            }

            private IAST mapThreadRecursive(int recursionLevel, IAST lst, IASTAppendable resultList) {
                IASTMutable list;
                if (recursionLevel >= this.level) {
                    return lst;
                }
                int size = lst.first().size() - 1;
                if (this.level == recursionLevel + 1) {
                    list = EvalAttributes.threadList(lst, S.List, this.constant, size);
                    if (resultList != null) {
                        resultList.append(list);
                    }
                } else {
                    IASTMutable list2 = EvalAttributes.threadList(lst, S.List, S.List, size);
                    IASTAppendable result = F.ListAlloc(size);
                    int level = recursionLevel + 1;
                    list2.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> this.mapThreadRecursive(level, (IAST)x, result)));
                    if (resultList != null) {
                        resultList.append(result);
                    }
                    return result;
                }
                return list;
            }
        }
    }

    private static final class MapIndexed
    extends AbstractFunctionEvaluator {
        private MapIndexed() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int lastIndex = ast.argSize();
            boolean heads = false;
            OptionArgs options = new OptionArgs(ast.topHead(), ast, lastIndex, engine);
            IExpr option = options.getOption(S.Heads);
            if (option.isPresent()) {
                --lastIndex;
                if (option.isTrue()) {
                    heads = true;
                }
            }
            try {
                IExpr arg1 = ast.arg1();
                IndexedLevel level = lastIndex == 3 ? new IndexedLevel((x, y) -> F.binaryAST2(arg1, x, y), ast.get(lastIndex), heads, engine) : new IndexedLevel((x, y) -> F.binaryAST2(arg1, x, y), 1, heads);
                IExpr arg2 = ast.arg2();
                if (arg2.isAST()) {
                    return level.visitAST((IAST)arg2, new int[0]).orElse(arg2);
                }
                return arg2;
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), "MapIndexed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3_2;
        }
    }

    private static class MapAt
    extends AbstractFunctionEvaluator {
        private MapAt() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2;
            if (ast.isAST1()) {
                if (ast.head().isAST2() && ast.isAST1()) {
                    IAST headAST = (IAST)ast.head();
                    ast = F.ternaryAST3(headAST.topHead(), headAST.arg1(), ast.arg1(), headAST.arg2());
                } else {
                    return F.NIL;
                }
            }
            if (ast.isAST3() && (arg2 = ast.arg2()).isASTOrAssociation()) {
                try {
                    IExpr arg1 = ast.arg1();
                    IExpr arg3 = ast.arg3();
                    if (arg3.isInteger() || arg3.isString() || arg3.isAST(S.Key, 2) || arg3.equals(S.All)) {
                        arg3 = F.list(arg3);
                    }
                    if (arg3.isListOfLists()) {
                        IAST listOfLists = (IAST)arg3;
                        IAST result = (IAST)arg2;
                        for (int i = 1; i < listOfLists.size(); ++i) {
                            IExpr temp = MapAt.mapAtRecursive(x -> F.unaryAST1(arg1, x), result, listOfLists.getAST(i), 1);
                            if (!temp.isPresent() || !temp.isAST()) continue;
                            result = (IAST)temp;
                        }
                        return result;
                    }
                    if (arg3.isList()) {
                        IExpr temp = MapAt.mapAtRecursive(x -> F.unaryAST1(arg1, x), (IAST)arg2, (IAST)arg3, 1);
                        if (temp.isPresent()) {
                            return temp;
                        }
                        return arg2;
                    }
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException ae) {
                    LOGGER.debug("MapAt.evaluate() failed", (Throwable)ae);
                }
            }
            return F.NIL;
        }

        private static IExpr mapAtRecursive(java.util.function.Function<IExpr, IExpr> f, IAST result, IAST positions, int index) {
            IExpr pos = positions.get(index);
            if (pos.equals(S.All)) {
                IASTMutable subResult;
                if (index == positions.size() - 1) {
                    subResult = result.copy();
                    for (int i = 1; i < result.size(); ++i) {
                        IExpr temp = f.apply(result.get(i));
                        if (!temp.isPresent()) continue;
                        subResult.set(i, temp);
                    }
                } else {
                    subResult = result.copy();
                    for (int i = 1; i < result.size(); ++i) {
                        IExpr temp = MapAt.mapAtRecursive(f, subResult.getAST(i), positions, index + 1);
                        if (!temp.isPresent()) continue;
                        subResult.set(i, temp);
                    }
                }
                return subResult;
            }
            if ((pos.isString() || pos.isAST(S.Key, 2)) && result.isAssociation()) {
                IExpr key = pos.isString() ? pos : pos.first();
                IAST rule = ((IAssociation)result).getRule(key);
                if (rule.isPresent()) {
                    if (index == positions.size() - 1) {
                        IExpr temp = f.apply(rule.second());
                        if (temp.isPresent()) {
                            rule = rule.setAtCopy(2, temp);
                            IASTAppendable association = result.copyAppendable();
                            association.appendRule(rule);
                            return association;
                        }
                    } else {
                        IExpr temp;
                        IExpr arg = rule.second();
                        if (arg.isASTOrAssociation() && (temp = MapAt.mapAtRecursive(f, (IAST)arg, positions, index + 1)).isPresent()) {
                            rule = rule.setAtCopy(2, temp);
                            IASTAppendable association = result.copyAppendable();
                            association.appendRule(rule);
                            return association;
                        }
                    }
                }
                throw new ArgumentTypeException("partw", F.list(F.list(pos), result));
            }
            int p = pos.toIntDefault();
            if (p == Integer.MIN_VALUE) {
                throw new ArgumentTypeException("partw", F.list(F.list(pos), result));
            }
            if (p < 0) {
                p = result.size() + p;
            }
            if (p >= 0 && p < result.size()) {
                if (index == positions.size() - 1) {
                    IExpr temp = f.apply(result.get(p));
                    if (temp.isPresent()) {
                        if (result.isAssociation()) {
                            IASTMutable rule = ((IAST)result.getRule(p)).setAtCopy(2, temp);
                            return result.setAtCopy(p, rule);
                        }
                        return result.setAtCopy(p, temp);
                    }
                } else {
                    IExpr temp;
                    IExpr arg = result.get(p);
                    if (arg.isASTOrAssociation() && (temp = MapAt.mapAtRecursive(f, (IAST)arg, positions, index + 1)).isPresent()) {
                        return result.setAtCopy(p, temp);
                    }
                }
            }
            throw new ArgumentTypeException("partw", F.list(F.list(pos), result));
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3_0;
        }
    }

    private static class MapAll
    extends AbstractFunctionEvaluator {
        private MapAll() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            VisitorLevelSpecification level = new VisitorLevelSpecification(x -> F.unaryAST1(arg1, x), 0, Integer.MAX_VALUE, false);
            IExpr result = ast.arg2().accept(level);
            return result.isPresent() ? result : ast.arg2();
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class Map
    extends AbstractFunctionEvaluator {
        private Map() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int lastIndex = ast.argSize();
            boolean heads = false;
            OptionArgs options = new OptionArgs(ast.topHead(), ast, lastIndex, engine);
            if (options.isInvalidPosition(3)) {
                return options.printNonopt(ast, 3, engine);
            }
            IExpr option = options.getOption(S.Heads);
            if (option.isPresent()) {
                --lastIndex;
                heads = option.isTrue();
            }
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (ast.isAST2() && arg2.isSparseArray()) {
                return ((ISparseArray)arg2).map(x -> F.unaryAST1(arg1, x));
            }
            VisitorLevelSpecification level = lastIndex == 3 ? new VisitorLevelSpecification(x -> F.unaryAST1(arg1, x), ast.get(lastIndex), heads, engine) : new VisitorLevelSpecification(x -> F.unaryAST1(arg1, x), 1, heads);
            return arg2.accept(level).orElse(arg2);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_4_2;
        }
    }

    public static class LeafCount
    extends AbstractCoreFunctionEvaluator {
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.ZZ(engine.evaluate(ast.arg1()).leafCount());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        private static class LeafCountVisitor
        extends AbstractVisitorLong {
            int fHeadOffset;

            public LeafCountVisitor() {
                this(1);
            }

            public LeafCountVisitor(int hOffset) {
                this.fHeadOffset = hOffset;
            }

            @Override
            public long visit(IAST list) {
                long sum = 0L;
                for (int i = this.fHeadOffset; i < list.size(); ++i) {
                    sum += list.get(i).accept(this);
                }
                return sum;
            }

            @Override
            public long visit(IComplex element) {
                return element.leafCount();
            }

            @Override
            public long visit(IComplexNum element) {
                return element.leafCount();
            }

            @Override
            public long visit(IFraction element) {
                return element.leafCount();
            }
        }
    }

    private static class Head
    extends AbstractCoreFunctionEvaluator {
        private Head() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2()) {
                return F.unaryAST1(engine.evaluate(ast.arg2()), engine.evaluate(ast.arg1()).head());
            }
            return engine.evaluate(ast.arg1()).head();
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Function
    extends AbstractCoreFunctionEvaluator {
        private Function() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST function;
            if (ast.head().equals(S.Function)) {
                IExpr temp = engine.evalHoldPattern(ast, true, false);
                if (temp.isPresent() && !temp.equals(ast)) {
                    return temp;
                }
                return F.NIL;
            }
            if (ast.head().isAST() && (function = (IAST)ast.head()).size() > 1) {
                IExpr arg1 = function.arg1();
                if (function.isAST1()) {
                    return Lambda.replaceSlotsOrElse(arg1, ast, arg1);
                }
                if (function.isAST2()) {
                    IExpr arg2 = function.arg2();
                    IAST symbolSlots = arg1.isList() ? (IAST)arg1 : F.list(arg1);
                    if (symbolSlots.size() > ast.size()) {
                        return IOFunctions.printMessage(S.Function, "fpct", F.list(symbolSlots, function), engine);
                    }
                    IdentityHashMap moduleVariables = new IdentityHashMap();
                    IExpr subst = arg2.accept(new ModuleReplaceAll(moduleVariables, engine, EvalEngine.uniqueName("$")));
                    if (subst.isPresent()) {
                        arg2 = subst;
                    }
                    return arg2.replaceAll(x -> {
                        IExpr temp = Function.getRulesMap(symbolSlots, ast).get(x);
                        return temp != null ? temp : F.NIL;
                    }).orElse(arg2);
                }
            }
            return F.NIL;
        }

        private static java.util.Map<IExpr, IExpr> getRulesMap(IAST symbolSlots, IAST ast) {
            int size = symbolSlots.argSize();
            AbstractMap rulesMap = size <= 5 ? new OpenFixedSizeMap(size * 3 - 1) : new HashMap();
            for (int i = 1; i <= size; ++i) {
                rulesMap.put((IExpr)symbolSlots.get(i), (IExpr)ast.get(i));
            }
            return rulesMap;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class FlattenAt
    extends AbstractCoreFunctionEvaluator {
        private FlattenAt() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            IExpr arg2 = engine.evaluate(ast.arg2());
            if (arg1.isAST()) {
                IAST arg1AST = (IAST)arg1;
                int[] positions = null;
                if (arg2.isInteger()) {
                    positions = new int[]{((IInteger)arg2).toIntDefault()};
                    if (positions[0] == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                }
                if (positions != null) {
                    int size = arg1AST.size();
                    for (int i = 0; i < positions.length; ++i) {
                        if (positions[i] >= 0) continue;
                        positions[i] = size + positions[i];
                    }
                    IASTAppendable resultList = EvalAttributes.flattenAt(arg1AST.topHead(), arg1AST, positions);
                    if (resultList.isPresent()) {
                        return resultList;
                    }
                    return arg1AST;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Flatten
    extends AbstractCoreFunctionEvaluator {
        private Flatten() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            if (ast.isAST1() && arg1.isSparseArray()) {
                ISparseArray sparseArray = (ISparseArray)arg1;
                return sparseArray.flatten();
            }
            if (arg1.isSparseArray()) {
                arg1 = arg1.normal(false);
            }
            if (arg1.isAST()) {
                IAST arg1AST = (IAST)arg1;
                if (ast.isAST1()) {
                    IASTAppendable resultList = EvalAttributes.flattenDeep(arg1AST.topHead(), (IAST)arg1);
                    if (resultList.isPresent()) {
                        return resultList;
                    }
                    return arg1AST;
                }
                if (ast.isAST2()) {
                    IExpr arg2 = engine.evaluate(ast.arg2());
                    int level = Validate.checkIntLevelType(arg2);
                    if (level > 0) {
                        IASTAppendable resultList = F.ast((IExpr)arg1AST.topHead(), arg1AST.size());
                        if (EvalAttributes.flatten(arg1AST.topHead(), (IAST)arg1, resultList, 0, level)) {
                            return resultList;
                        }
                    }
                    return arg1;
                }
                if (ast.isAST3() && ast.arg3().isSymbol()) {
                    IExpr arg2 = engine.evaluate(ast.arg2());
                    int level = Validate.checkIntLevelType(arg2);
                    if (level > 0) {
                        IASTAppendable resultList = F.ast(arg1AST.topHead());
                        if (EvalAttributes.flatten((ISymbol)ast.arg3(), (IAST)arg1, resultList, 0, level)) {
                            return resultList;
                        }
                    }
                    return arg1;
                }
                return F.NIL;
            }
            return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C1, ast), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Depth
    extends AbstractCoreFunctionEvaluator {
        private Depth() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            return F.ZZ(arg1.depth());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class ByteCount
    extends AbstractCoreFunctionEvaluator {
        private ByteCount() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class Apply
    extends AbstractCoreFunctionEvaluator {
        private Apply() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.argSize() < 2 || ast.argSize() > 4) {
                return IOFunctions.printArgMessage(ast, ARGS_2_4, engine);
            }
            IASTAppendable evaledAST = ast.copyAppendable();
            evaledAST.setArgs(evaledAST.size(), i -> engine.evaluate(evaledAST.get(i)));
            int lastIndex = evaledAST.argSize();
            boolean heads = false;
            OptionArgs options = new OptionArgs(evaledAST.topHead(), evaledAST, lastIndex, engine);
            IExpr option = options.getOption(S.Heads);
            if (option.isPresent()) {
                --lastIndex;
                if (option.isTrue()) {
                    heads = true;
                }
            } else if (ast.argSize() == 4) {
                return IOFunctions.printArgMessage(ast, ARGS_2_3, engine);
            }
            IExpr arg1 = evaledAST.arg1();
            IExpr arg2 = evaledAST.arg2();
            if (arg1.isQuantity() || arg2.isQuantity()) {
                return F.NIL;
            }
            return Apply.evalApply(arg1, arg2, evaledAST, lastIndex, heads, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4_2;
        }

        public static IExpr evalApply(IExpr f, IExpr expr, IAST evaledAST, int lastIndex, boolean heads, EvalEngine engine) {
            java.util.function.Function<IExpr, IExpr> af = x -> x.isAST() ? ((IAST)x).setAtCopy(0, f) : F.NIL;
            try {
                VisitorLevelSpecification level = null;
                level = lastIndex == 3 ? new VisitorLevelSpecification(af, evaledAST.get(lastIndex), heads, engine) : new VisitorLevelSpecification(af, 0);
                if (expr.isAST()) {
                    return ((IAST)expr).acceptChecked(level).orElse(expr);
                }
                if (evaledAST.size() >= 3) {
                    if (f.isFunction()) {
                        return F.unaryAST1(f, expr);
                    }
                    return expr;
                }
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage((ISymbol)S.Apply, ve, engine);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Apply.setEvaluator(new Apply());
            S.ByteCount.setEvaluator(new ByteCount());
            S.Depth.setEvaluator(new Depth());
            S.Exit.setEvaluator(new QuitExit());
            S.Flatten.setEvaluator(new Flatten());
            S.FlattenAt.setEvaluator(new FlattenAt());
            S.Function.setEvaluator(new Function());
            S.Head.setEvaluator(new Head());
            S.LeafCount.setEvaluator(new LeafCount());
            S.Map.setEvaluator(new Map());
            S.MapAll.setEvaluator(new MapAll());
            S.MapAt.setEvaluator(new MapAt());
            S.MapIndexed.setEvaluator(new MapIndexed());
            S.MapThread.setEvaluator(new MapThread());
            S.Order.setEvaluator(new Order());
            S.OrderedQ.setEvaluator(new OrderedQ());
            S.Operate.setEvaluator(new Operate());
            S.PatternOrder.setEvaluator(new PatternOrder());
            S.Quit.setEvaluator(new QuitExit());
            S.Scan.setEvaluator(new Scan());
            S.Sort.setEvaluator(new Sort());
            S.SortBy.setEvaluator(new SortBy());
            S.Symbol.setEvaluator(new Symbol());
            S.SymbolName.setEvaluator(new SymbolName());
            S.Thread.setEvaluator(new Thread());
            S.Through.setEvaluator(new Through());
            ISymbol[] logicEquationHeads = new ISymbol[]{S.And, S.Or, S.Xor, S.Nand, S.Nor, S.Not, S.Implies, S.Equivalent, S.Equal, S.Unequal, S.Less, S.Greater, S.LessEqual, S.GreaterEqual};
            for (int i = 0; i < logicEquationHeads.length; ++i) {
                LOGIC_EQUATION_HEADS.add(logicEquationHeads[i]);
            }
            PLUS_LOGIC_EQUATION_HEADS.addAll(LOGIC_EQUATION_HEADS);
            PLUS_LOGIC_EQUATION_HEADS.add(S.Plus);
            LIST_LOGIC_EQUATION_HEADS.addAll(LOGIC_EQUATION_HEADS);
            LIST_LOGIC_EQUATION_HEADS.add(S.List);
        }
    }
}

