/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import com.google.common.base.CharMatcher;
import com.ibm.icu.text.Transliterator;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionOptionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionOptionEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.PatternNested;
import org.matheclipse.core.expression.PatternSequence;
import org.matheclipse.core.expression.RepeatedPattern;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.expression.data.ByteArrayExpr;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.form.tex.TeXParser;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IDataExpr;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPredicate;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.parser.ExprParser;
import org.matheclipse.parser.client.ParserConfig;

public final class StringFunctions {
    private static final Logger LOGGER = LogManager.getLogger();
    static final int PLUS_Q = 0;
    static final int ASTERISK_Q = 1;
    static final String[] REGEX_LONGEST = new String[]{"+", "*"};
    static final String[] REGEX_SHORTEST = new String[]{"+?", "*?"};
    private static final String LATIN_ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    private static final String CYRILLIC_ALPHABET = "\u0430\u0431\u0432\u0433\u0491\u0434\u0452\u0453\u0435\u0451\u0454\u0436\u0437\u0437\u0301\u0455\u0438\u0456\u0457\u0439\u0458\u043a\u043b\u0459\u043c\u043d\u045a\u043e\u043f\u0440\u0441\u0441\u0301\u0442\u045b\u045c\u0443\u045e\u0444\u0445\u0446\u0447\u045f\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f";
    private static final String[] ALPHABETS = new String[]{"Arabic", "\u0627\u0628\u062a\u062b\u062c\u062d\u062e\u062f\u0630\u0631\u0632\u0633\u0634\u0635\u0636\u0637\u0638\u0639\u063a\u0641\u0642\u0643\u0644\u0645\u0646\u0647\u0648\u064a", "Belarusian", "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0456\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u045e\u0444\u0445\u0446\u0447\u0448\u044b\u044c\u044d\u044e\u044f'", "Bulgarian", "\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044c\u044e\u044f", "Catalan", "abc\u00e7defghijklmnopqrstuvwxyz", "Cyrillic", "\u0430\u0431\u0432\u0433\u0491\u0434\u0452\u0453\u0435\u0451\u0454\u0436\u0437\u0437\u0301\u0455\u0438\u0456\u0457\u0439\u0458\u043a\u043b\u0459\u043c\u043d\u045a\u043e\u043f\u0440\u0441\u0441\u0301\u0442\u045b\u045c\u0443\u045e\u0444\u0445\u0446\u0447\u045f\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f", "Danish", "abcdefghijklmnopqrstuvwxyz\u00e6\u00f8\u00e5", "English", "abcdefghijklmnopqrstuvwxyz", "Esperanto", "abc\u0109defg\u011dh\u0125ij\u0135klmnoprs\u015dtu\u016dvz", "Estonian", "abdefghijklmnoprs\u0161z\u017etuv\u00f5\u00e4\u00f6\u00fc", "Finnish", "abcdefghijklmnopqrstuvwxyz\u00e5\u00e4\u00f6", "French", "abcdefghijklmnopqrstuvwxyz", "German", "abcdefghijklmnopqrstuvwxyz", "Greek", "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9", "Hebrew", "\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5\u05d6\u05d7\u05d8\u05d9\u05db\u05dc\u05de\u05e0\u05e1\u05e2\u05e4\u05e6\u05e7\u05e8\u05e9\u05ea", "Hindi", "\u0905\u0906\u0907\u0908\u0909\u090a\u090b\u090f\u0910\u0913\u0914\u0915\u0916\u0917\u0918\u0919\u091a\u091b\u091c\u091d\u091e\u091f\u0920\u0921\u0922\u0923\u0924\u0925\u0926\u0927\u0928\u092a\u092b\u092c\u092d\u092e\u092f\u0930\u0932\u0935\u0936\u0937\u0938\u0939", "Icelandic", "a\u00e1bd\u00f0e\u00e9fghi\u00edjklmno\u00f3prstu\u00favxy\u00fd\u00fe\u00e6\u00f6", "Indonesian", "abcdefghijklmnopqrstuvwxyz", "Irish", "abcdefghilmnoprstu", "Italian", "abcdefghilmnopqrstuvz", "Korean", "\u3131\u3132\u3134\u3137\u3138\u3139\u3141\u3142\u3143\u3145\u3146\u3147\u3148\u3149\u314a\u314b\u314c\u314d\u314e\u314f\u3150\u3151\u3152\u3153\u3154\u3155\u3156\u3157\u3158\u3159\u315a\u315b\u315c\u315d\u315e\u315f\u3160\u3161\u3162\u3163", "Latin", "abcdefghijklmnopqrstuvwxyz", "Latvian", "a\u0101bc\u010dde\u0113fg\u0123hi\u012bjk\u0137l\u013cmn\u0146oprs\u0161tu\u016bvz\u017e", "Lithuanian", "a\u0105bc\u010dde\u0119\u0117fghi\u012fyjklmnoprs\u0161tu\u0173\u016bvz\u017e", "Macedonian", "\u0430\u0431\u0432\u0433\u0434\u0453\u0435\u0436\u0437\u0455\u0438\u0458\u043a\u043b\u0459\u043c\u043d\u045a\u043e\u043f\u0440\u0441\u0442\u045c\u0443\u0444\u0445\u0446\u0447\u045f\u0448", "Malay", "abcdefghijklmnopqrstuvwxyz", "Norwegian", "abcdefghijklmnopqrstuvwxyz\u00e6\u00f8\u00e5", "Polish", "a\u0105bc\u0107de\u0119fghijkl\u0142mn\u0144o\u00f3prs\u015btuwyz\u017a\u017c", "Portuguese", "abcdefghijklmnopqrstuvwxyz", "Romanian", "a\u0103\u00e2bcdefghi\u00eejklmnopqrs\u0219t\u021buvwxyz", "Russian", "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f", "Slovenian", "abc\u010ddefghijklmnoprs\u0161tuvz\u017e", "Spanish", "abcdefghijklmn\u00f1opqrstuvwxyz", "Swedish", "abcdefghijklmnopqrstuvwxyz\u00e5\u00e4\u00f6", "Turkish", "abc\u00e7defg\u011fh\u0131ijklmno\u00f6prs\u015ftu\u00fcvyz", "Ukrainian", "\u0430\u0431\u0432\u0433\u0491\u0434\u0435\u0454\u0436\u0437\u0438\u0456\u0457\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044c\u044e\u044f", "Vietnamese", "a\u0103\u00e2bcd\u0111e\u00eafghiklmno\u00f4\u01a1pqrstu\u01b0vxy"};
    private static final String[] ALPHABETS_CSV = new String[]{"Albanian", "a,b,c,\u00e7,d,dh,e,\u00eb,f,g,gj,h,i,j,k,l,ll,m,n,nj,o,p,q,r,rr,s,sh,t,th,u,v,x,xh,y,z,zh", "Croatian", "a,b,c,\u010d,\u0107,d,d\u017e,\u0111,e,f,g,h,i,j,k,l,lj,m,n,nj,o,p,r,s,\u0161,t,u,v,z,\u017e", "Czech", "a,\u00e1,b,c,\u010d,d,\u010f,e,\u00e9,\u011b,f,g,h,ch,i,\u00ed,j,k,l,m,n,\u0148,o,\u00f3,p,q,r,\u0159,s,\u0161,t,\u0165,u,\u00fa,\u016f,v,w,x,y,\u00fd,z,\u017e", "Dutch", "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,ij,z", "Hungarian", "a,\u00e1,b,c,cs,d,dz,dzs,e,\u00e9,f,g,gy,h,i,\u00ed,j,k,l,ly,m,n,ny,o,\u00f3,\u00f6,\u0151,p,q,r,s,sz,t,ty,u,\u00fa,\u00fc,\u0171,v,w,x,y,z,zs", "Maltese", "a,b,\u010b,d,e,f,\u0121,g,g\u0127,h,\u0127,i,ie,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,\u017c,z", "Slovak", "a,\u00e1,\u00e4,b,c,\u010d,d,\u010f,dz,d\u017e,e,\u00e9,f,g,h,ch,i,\u00ed,j,k,l,\u013a,\u013e,m,n,\u0148,o,\u00f3,\u00f4,p,q,r,\u0155,s,\u0161,t,\u0165,u,\u00fa,v,w,x,y,\u00fd,z,\u017e"};
    private static final String[] LANGUAGES = new String[]{"Albanian", "sq", "Arabic", "ar", "Belarusian", "be", "Bulgarian", "bg", "Catalan", "ca", "Chinese", "zh", "Croatian", "hr", "Czech", "cs", "Danish", "da", "Dutch", "nl", "English", "en", "Estonian", "et", "Finnish", "fi", "French", "fr", "German", "de", "Greek", "el", "Hebrew", "iw", "Hindi", "hi", "Hungarian", "hu", "Icelandic", "is", "Indonesian", "in", "Irish", "ga", "Italian", "it", "Japanese", "ja", "Korean", "ko", "Latvian", "lv", "Lithuanian", "lt", "Macedonian", "mk", "Malay", "ms", "Maltese", "mt", "Norwegian", "no", "Polish", "pl", "Portuguese", "pt", "Romanian", "ro", "Russian", "ru", "Serbian", "sr", "Slovak", "sk", "Slovenian", "sl", "Spanish", "es", "Swedish", "sv", "Thai", "th", "Turkish", "tr", "Ukrainian", "uk", "Vietnamese", "vi"};
    private static final Map<String, String> ALPHABET_MAP = new HashMap<String, String>();
    private static final Map<String, String[]> ALPHABET_CSV_MAP = new HashMap<String, String[]>();
    private static final Map<String, String> TRANSLITERATE_MAP = new HashMap<String, String>();

    public static String inputForm(IExpr expression, boolean relaxedSyntax) {
        try {
            StringBuilder buf = new StringBuilder();
            OutputFormFactory off = OutputFormFactory.get(relaxedSyntax, false);
            off.setIgnoreNewLine(true);
            off.setInputForm(true);
            if (off.convert(buf, expression)) {
                return buf.toString();
            }
        }
        catch (RuntimeException rex) {
            LOGGER.debug("StringFunctions.inputForm() failed", (Throwable)rex);
        }
        return null;
    }

    public static String inputForm(IExpr expression) {
        return StringFunctions.inputForm(expression, ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS);
    }

    private static IExpr regexErrorHandling(IAST ast, IllegalArgumentException iae, EvalEngine engine) {
        if (iae instanceof PatternSyntaxException) {
            PatternSyntaxException pse = (PatternSyntaxException)iae;
            return IOFunctions.printMessage(S.RegularExpression, "zzregex", F.list(F.$str(pse.getPattern()), F.$str(pse.getMessage())), engine);
        }
        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)iae);
        return F.NIL;
    }

    public static Pattern toRegexPattern(IExpr partOfRegex, boolean abbreviatedPatterns, boolean ignoreCase, IAST stringFunction, Map<ISymbol, String> namedRegexGroups, EvalEngine engine) {
        String regex = StringFunctions.toRegexString(partOfRegex, abbreviatedPatterns, stringFunction, REGEX_LONGEST, namedRegexGroups, engine);
        if (regex != null) {
            try {
                Pattern pattern = ignoreCase ? Pattern.compile(regex, 258) : Pattern.compile(regex, 256);
                return pattern;
            }
            catch (IllegalArgumentException iae) {
                LOGGER.debug("StringFunctions.toRegexPattern() failed", (Throwable)iae);
                StringFunctions.regexErrorHandling(stringFunction, iae, engine);
            }
        }
        return null;
    }

    private static String toRegexString(IExpr partOfRegex, boolean abbreviatedPatterns, IAST stringFunction, String[] shortestLongest, Map<ISymbol, String> groups, EvalEngine engine) {
        if (partOfRegex.isString()) {
            String str = partOfRegex.toString();
            if (abbreviatedPatterns) {
                StringBuilder pieces = new StringBuilder();
                int beginIndex = 0;
                int endIndex = 0;
                int len = str.length();
                while (endIndex < len) {
                    char c = str.charAt(endIndex);
                    if (c == '\\' && endIndex + 1 < len) {
                        pieces.append(Pattern.quote(str.substring(beginIndex, endIndex)));
                        pieces.append(Pattern.quote(str.substring(endIndex + 1, endIndex + 2)));
                        beginIndex = endIndex += 2;
                        continue;
                    }
                    if (c == '*') {
                        pieces.append(Pattern.quote(str.substring(beginIndex, endIndex)));
                        pieces.append("(.*)");
                        beginIndex = ++endIndex;
                        continue;
                    }
                    if (c == '@') {
                        pieces.append(Pattern.quote(str.substring(beginIndex, endIndex)));
                        pieces.append("([^A-Z]+)");
                        beginIndex = ++endIndex;
                        continue;
                    }
                    ++endIndex;
                }
                pieces.append(Pattern.quote(str.substring(beginIndex, endIndex)));
                return pieces.toString();
            }
            return Pattern.quote(str);
        }
        if (partOfRegex.isAST(S.Characters, 2) && partOfRegex.first().isString()) {
            String str = ((IStringX)partOfRegex.first()).toString();
            return "[" + str + "]";
        }
        if (partOfRegex.isAST(S.RegularExpression, 2) && partOfRegex.first().isString()) {
            return ((IStringX)partOfRegex.first()).toString();
        }
        if (partOfRegex instanceof RepeatedPattern) {
            RepeatedPattern repeated = (RepeatedPattern)partOfRegex;
            IExpr expr = repeated.getRepeatedExpr();
            if (expr == null) {
                return null;
            }
            if (expr.isAST(S.Pattern, 3) && expr.first().isSymbol()) {
                ISymbol symbol = (ISymbol)expr.first();
                String str = StringFunctions.toRegexString(expr.second(), abbreviatedPatterns, stringFunction, shortestLongest, groups, engine);
                if (str != null) {
                    String groupName = symbol.toString();
                    groups.put(symbol, groupName);
                    if (repeated.isNullSequence()) {
                        return "(?<" + groupName + ">(" + str + ")" + shortestLongest[1] + ")";
                    }
                    return "(?<" + groupName + ">(" + str + ")" + shortestLongest[0] + ")";
                }
            } else {
                String str = StringFunctions.toRegexString(expr, abbreviatedPatterns, stringFunction, shortestLongest, groups, engine);
                if (str != null) {
                    if (repeated.isNullSequence()) {
                        return "(" + str + ")" + shortestLongest[1];
                    }
                    return "(" + str + ")" + shortestLongest[0];
                }
            }
        } else {
            if (partOfRegex.isAST(S.StringExpression)) {
                IAST stringExpression = (IAST)partOfRegex;
                return StringFunctions.toRegexString(stringFunction, stringExpression, abbreviatedPatterns, shortestLongest, groups, engine);
            }
            if (partOfRegex.isBlank()) {
                return "(.|\\n)";
            }
            if (partOfRegex.isPattern()) {
                IPattern pattern = (IPattern)partOfRegex;
                ISymbol symbol = pattern.getSymbol();
                if (symbol != null && pattern.getHeadTest() == null) {
                    String groupName = symbol.toString();
                    groups.put(symbol, groupName);
                    if (pattern instanceof PatternNested) {
                        PatternNested pn = (PatternNested)pattern;
                        IExpr subPattern = pn.getPatternExpr();
                        String subPatternRegex = StringFunctions.toRegexString(subPattern, abbreviatedPatterns, stringFunction, shortestLongest, groups, engine);
                        return "(?<" + groupName + ">" + subPatternRegex + ")";
                    }
                    return "(?<" + groupName + ">(.|\\n))";
                }
            } else if (partOfRegex.isAST(S.Pattern, 3) && partOfRegex.first().isSymbol()) {
                ISymbol symbol = (ISymbol)partOfRegex.first();
                String str = StringFunctions.toRegexString(partOfRegex.second(), abbreviatedPatterns, stringFunction, shortestLongest, groups, engine);
                if (str != null) {
                    String groupName = symbol.toString();
                    groups.put(symbol, groupName);
                    return "(?<" + groupName + ">" + str + ")";
                }
            } else {
                if (partOfRegex.isPatternSequence(false)) {
                    PatternSequence ps = (PatternSequence)partOfRegex;
                    ISymbol symbol = ps.getSymbol();
                    String str = ps.isNullSequence() ? "(.|\\n)" + shortestLongest[1] : "(.|\\n)" + shortestLongest[0];
                    if (symbol == null) {
                        return str;
                    }
                    String groupName = symbol.toString();
                    groups.put(symbol, groupName);
                    return "(?<" + groupName + ">" + str + ")";
                }
                if (partOfRegex.isAST(S.CharacterRange, 3)) {
                    String[] characterRange = StringFunctions.characterRange((IAST)partOfRegex);
                    if (characterRange != null) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("[");
                        buf.append(Pattern.quote(characterRange[0]));
                        buf.append("-");
                        buf.append(Pattern.quote(characterRange[1]));
                        buf.append("]");
                        return buf.toString();
                    }
                } else {
                    if (partOfRegex.isAlternatives()) {
                        IAST alternatives = (IAST)partOfRegex;
                        StringBuilder pieces = new StringBuilder();
                        for (int i = 1; i < alternatives.size(); ++i) {
                            String str = StringFunctions.toRegexString(alternatives.get(i), abbreviatedPatterns, stringFunction, shortestLongest, groups, engine);
                            if (str == null) {
                                IOFunctions.printMessage(stringFunction.topHead(), "unsupported", F.list(alternatives.get(i), stringFunction.topHead()), engine);
                                return null;
                            }
                            pieces.append(str);
                            if (i >= alternatives.size() - 1) continue;
                            pieces.append('|');
                        }
                        return pieces.toString();
                    }
                    if (partOfRegex.isAST(S.Shortest, 2)) {
                        String str = StringFunctions.toRegexString(partOfRegex.first(), abbreviatedPatterns, stringFunction, REGEX_SHORTEST, groups, engine);
                        return str;
                    }
                    if (partOfRegex.isAST(S.Longest, 2)) {
                        return StringFunctions.toRegexString(partOfRegex.first(), abbreviatedPatterns, stringFunction, REGEX_LONGEST, groups, engine);
                    }
                    if (partOfRegex.isBuiltInSymbol()) {
                        int ordinal = ((IBuiltInSymbol)partOfRegex).ordinal();
                        switch (ordinal) {
                            case 934: {
                                return "[0-9]{1,13}(\\.[0-9]+)?";
                            }
                            case 1437: {
                                return "(?u)\\s+";
                            }
                            case 349: {
                                return "\\d";
                            }
                            case 1438: {
                                return "(?u)\\s";
                            }
                            case 1444: {
                                return "(?u)[^\\W_]";
                            }
                            case 1228: {
                                return "\\R";
                            }
                            case 417: {
                                return "$";
                            }
                            case 1229: {
                                return "\\A";
                            }
                            case 418: {
                                return "\\Z";
                            }
                            case 1443: {
                                return "\\b";
                            }
                            case 757: {
                                return "(?u)[^\\W_0-9]";
                            }
                            case 594: {
                                return "[0-9a-fA-F]";
                            }
                        }
                        IOFunctions.printMessage(stringFunction.topHead(), "unsupported", F.list(partOfRegex, stringFunction.topHead()), engine);
                        return null;
                    }
                }
            }
        }
        IOFunctions.printMessage(stringFunction.topHead(), "unsupported", F.list(partOfRegex, stringFunction.topHead()), engine);
        return null;
    }

    private static String toRegexString(IAST ast, IAST stringExpression, boolean abbreviatedPatterns, String[] shortestLongest, Map<ISymbol, String> groups, EvalEngine engine) {
        StringBuilder regex = new StringBuilder();
        for (int i = 1; i < stringExpression.size(); ++i) {
            IExpr arg = stringExpression.get(i);
            String str = StringFunctions.toRegexString(arg, abbreviatedPatterns, ast, shortestLongest, groups, engine);
            if (str == null) {
                return null;
            }
            regex.append(str);
        }
        return regex.toString();
    }

    private static String[] characterRange(IAST characterRangeAST) {
        if (!(characterRangeAST.arg1() instanceof IStringX) || !(characterRangeAST.arg2() instanceof IStringX)) {
            if (!characterRangeAST.arg1().isInteger() || !characterRangeAST.arg2().isInteger()) {
                return null;
            }
            int from = characterRangeAST.arg1().toIntDefault();
            int to = characterRangeAST.arg2().toIntDefault();
            if (from < 0 || to < 0) {
                return null;
            }
            return new String[]{String.valueOf((char)from), String.valueOf((char)to)};
        }
        String str1 = characterRangeAST.arg1().toString();
        String str2 = characterRangeAST.arg2().toString();
        if (str1.length() != 1 || str2.length() != 1) {
            return null;
        }
        char from = str1.charAt(0);
        char to = str2.charAt(0);
        return new String[]{String.valueOf(from), String.valueOf(to)};
    }

    public static void initialize() {
        Initializer.init();
    }

    private StringFunctions() {
    }

    private static final class UpperCaseQ
    extends AbstractCoreFunctionEvaluator
    implements Predicate<IExpr>,
    IPredicate {
        private UpperCaseQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            IExpr temp = Validate.checkStringType(ast, 1, engine);
            if (temp.isPresent()) {
                return F.bool(this.test(arg1));
            }
            return F.NIL;
        }

        @Override
        public boolean test(IExpr obj) {
            String str = obj.toString();
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (Character.isUpperCase(ch)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class Transliterate
    extends AbstractFunctionEvaluator {
        private Transliterate() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            if (!arg1.isString()) {
                return F.NIL;
            }
            if (ast.isAST2()) {
                IExpr arg2 = ast.arg2();
                if (arg2.isRuleAST()) {
                    if (arg2.first().isString() && arg2.second().isString()) {
                        try {
                            String str1 = Transliterate.mapToICU4J(arg2.first().toString());
                            String str2 = Transliterate.mapToICU4J(arg2.second().toString());
                            String str = ast.arg1().toString();
                            Transliterator transform = Transliterator.getInstance((String)(str1 + "-" + str2));
                            String result = transform.transliterate(str);
                            return F.$str(result);
                        }
                        catch (IllegalArgumentException str1) {}
                    }
                } else if (arg2.isString()) {
                    try {
                        String str1 = "Latin";
                        String str2 = Transliterate.mapToICU4J(arg2.toString());
                        String str = ast.arg1().toString();
                        Transliterator transform = Transliterator.getInstance((String)(str1 + "-" + str2));
                        String result = transform.transliterate(str);
                        return F.$str(result);
                    }
                    catch (IllegalArgumentException str1) {
                        // empty catch block
                    }
                }
                return F.NIL;
            }
            if (ast.isAST1()) {
                String str = ast.arg1().toString();
                Transliterator transform = Transliterator.getInstance((String)"Any-Latin");
                String latin = transform.transliterate(str);
                transform = Transliterator.getInstance((String)"Latin-ASCII");
                String ascii = transform.transliterate(latin);
                return F.$str(ascii);
            }
            return F.NIL;
        }

        private static String mapToICU4J(String language) {
            String temp = TRANSLITERATE_MAP.get(language);
            if (temp != null) {
                language = temp;
            }
            return language;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class ToUpperCase
    extends AbstractFunctionEvaluator {
        private ToUpperCase() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (!arg1.isString()) {
                return F.NIL;
            }
            return F.stringx(((IStringX)arg1).toUpperCase());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class ToUnicode
    extends AbstractFunctionEvaluator {
        private static final String UNICODE_PREFIX = "\\u";

        private ToUnicode() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            if (!arg1.isString()) {
                return F.NIL;
            }
            return StringX.valueOf(ToUnicode.toUnicodeString(ast.arg1().toString(), StandardCharsets.UTF_8));
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        public static String toUnicodeString(String unicodeInput, Charset inputEncoding) {
            StringBuilder unicodeStringBuilder = new StringBuilder();
            String unicodeString = null;
            String utf8String = new String(unicodeInput.getBytes(inputEncoding), StandardCharsets.UTF_8);
            Object hexValueString = null;
            int hexValueLength = 0;
            for (int i = 0; i < utf8String.length(); ++i) {
                hexValueString = Integer.toHexString(utf8String.charAt(i));
                hexValueLength = ((String)hexValueString).length();
                if (hexValueLength < 4) {
                    for (int j = 0; j < 4 - hexValueLength; ++j) {
                        hexValueString = "0" + (String)hexValueString;
                    }
                }
                unicodeStringBuilder.append(UNICODE_PREFIX);
                unicodeStringBuilder.append((String)hexValueString);
            }
            unicodeString = unicodeStringBuilder.toString();
            return unicodeString;
        }
    }

    private static class ToLowerCase
    extends AbstractFunctionEvaluator {
        private ToLowerCase() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (!arg1.isString()) {
                return F.NIL;
            }
            return F.stringx(((IStringX)arg1).toLowerCase());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class ToString
    extends AbstractFunctionEvaluator {
        private ToString() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isString()) {
                return ast.arg1();
            }
            return F.stringx(StringFunctions.inputForm(ast.arg1()));
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class ToExpression
    extends AbstractFunctionEvaluator {
        private ToExpression() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            block13: {
                IExpr arg1 = ast.arg1();
                IExpr head = F.NIL;
                if (arg1.isString()) {
                    IBuiltInSymbol form = S.InputForm;
                    if (ast.size() == 3) {
                        IExpr arg2 = ast.arg2();
                        if (arg2.equals(S.InputForm)) {
                            form = S.InputForm;
                        } else if (arg2.equals(S.TeXForm)) {
                            form = S.TeXForm;
                        } else {
                            return F.NIL;
                        }
                    }
                    if (ast.size() == 4) {
                        head = ast.arg3();
                    }
                    try {
                        if (form.equals(S.InputForm)) {
                            ExprParser parser = new ExprParser(engine);
                            IExpr temp = parser.parse(arg1.toString());
                            if (head.isPresent()) {
                                return F.unaryAST1(head, temp);
                            }
                            return temp;
                        }
                        if (form.equals(S.TeXForm)) {
                            TeXParser texParser = new TeXParser(engine);
                            IExpr temp = texParser.toExpression(arg1.toString());
                            if (head.isPresent()) {
                                return F.unaryAST1(head, temp);
                            }
                            return temp;
                        }
                        break block13;
                    }
                    catch (RuntimeException rex) {
                        LOGGER.debug("ToExpression.evaluate() failed", (Throwable)rex);
                        return S.$Aborted;
                    }
                }
                return IOFunctions.printMessage(ast.topHead(), "nostr", F.list(ast.arg1()), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class ToCharacterCode
    extends AbstractFunctionEvaluator {
        private ToCharacterCode() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            if (!arg1.isString()) {
                return F.NIL;
            }
            return ToCharacterCode.toCharacterCode(ast.arg1().toString(), StandardCharsets.UTF_8);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        public static IAST toCharacterCode(String unicodeInput, Charset inputEncoding) {
            String utf8String = new String(unicodeInput.getBytes(inputEncoding), StandardCharsets.UTF_8);
            int length = utf8String.length();
            IASTAppendable list = F.ListAlloc(length);
            for (int i = 0; i < length; ++i) {
                char characterCode = utf8String.charAt(i);
                list.append((long)characterCode);
            }
            return list;
        }
    }

    private static class TextString
    extends AbstractFunctionEvaluator {
        private TextString() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            return TextString.of(arg1);
        }

        private static IExpr of(IExpr arg1) {
            if (arg1.isString()) {
                return arg1;
            }
            return F.stringx(arg1.toString());
        }

        protected static void of(IExpr arg1, StringBuilder buf) {
            if (arg1.isString()) {
                buf.append(((IStringX)arg1).toString());
                return;
            }
            buf.append(arg1.toString());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class TemplateSlot
    extends AbstractFunctionEvaluator {
        private TemplateSlot() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class TemplateIf
    extends AbstractFunctionEvaluator {
        private TemplateIf() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class TemplateApply
    extends AbstractFunctionEvaluator {
        private TemplateApply() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = F.NIL;
            if (ast.isAST2()) {
                arg2 = ast.arg2();
            }
            if (arg1.isString()) {
                return IOFunctions.templateApply(arg1.toString(), arg2);
            }
            if (arg1.isAST(S.StringTemplate, 2) && arg1.first().isString()) {
                return IOFunctions.templateApply(arg1.first().toString(), arg2);
            }
            return TemplateApply.templateApplyTemplateSlot(arg1, arg2);
        }

        private static IExpr templateApplyTemplateSlot(IExpr templateExpr, IExpr args) {
            HashMap<IExpr, IExpr> context;
            block2: {
                block3: {
                    context = new HashMap<IExpr, IExpr>();
                    if (!args.isListOrAssociation()) break block2;
                    if (!args.isAssociation()) break block3;
                    IAssociation assoc = (IAssociation)args;
                    for (int i = 1; i < assoc.size(); ++i) {
                        IAST rule = assoc.getRule(i);
                        IExpr lhs = rule.arg1();
                        IExpr rhs = rule.arg2();
                        context.put(lhs, rhs);
                    }
                    break block2;
                }
                if (!args.isList()) break block2;
                IAST list = (IAST)args;
                for (int i = 1; i < list.size(); ++i) {
                    IExpr expr = list.get(i);
                    context.put(F.ZZ(i), expr);
                }
            }
            return templateExpr.replaceAll(x -> TemplateApply.replaceTemplateSlotFunction(x, context)).orElse(templateExpr);
        }

        private static IExpr replaceTemplateSlotFunction(IExpr expr, Map<IExpr, IExpr> map) {
            if (expr.isASTSizeGE(S.TemplateIf, 3)) {
                IAST templateIf = (IAST)expr;
                IExpr condition = templateIf.arg1();
                IExpr thenExpr = templateIf.arg2();
                IExpr elseExpr = F.CEmptySequence;
                if (templateIf.size() > 3) {
                    elseExpr = templateIf.arg3();
                }
                condition = condition.replaceAll(x -> TemplateApply.replaceTemplateSlotFunction(x, map)).orElse(condition);
                boolean b = EvalEngine.get().evalTrue(condition);
                if (b) {
                    return thenExpr.replaceAll(x -> TemplateApply.replaceTemplateSlotFunction(x, map)).orElse(thenExpr);
                }
                return elseExpr.replaceAll(x -> TemplateApply.replaceTemplateSlotFunction(x, map)).orElse(elseExpr);
            }
            if (expr.isASTSizeGE(S.TemplateSlot, 2)) {
                IAST templateSlot = (IAST)expr;
                return TemplateApply.replaceSingleTemplateSlot(map, templateSlot);
            }
            return F.NIL;
        }

        private static IExpr replaceSingleTemplateSlot(Map<IExpr, IExpr> map, IAST templateSlot) {
            IExpr result;
            IExpr defaultValue = F.Missing(S.SlotAbsent, templateSlot.first());
            if (templateSlot.size() > 2) {
                IExpr insertionFunction;
                OptionArgs options = new OptionArgs((ISymbol)S.TemplateSlot, templateSlot, 2, EvalEngine.get(), true);
                IExpr option = options.getOption(S.DefaultValue);
                if (option.isPresent()) {
                    defaultValue = option;
                }
                if ((insertionFunction = options.getOption(S.InsertionFunction)).isPresent()) {
                    IExpr result2 = map.get(templateSlot.first());
                    if (result2 == null) {
                        if (defaultValue.isPresent()) {
                            return F.unaryAST1(insertionFunction, defaultValue);
                        }
                        return F.NIL;
                    }
                    return F.unaryAST1(insertionFunction, result2);
                }
            }
            return (result = map.get(templateSlot.first())) == null ? defaultValue : result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class StringTemplate
    extends AbstractFunctionEvaluator {
        private StringTemplate() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr head;
            if (ast.isAST1() && (head = ast.head()).isAST(S.StringTemplate, 2)) {
                return S.TemplateApply.of(engine, head, ast.arg1());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return null;
        }
    }

    private static class SyntaxLength
    extends AbstractFunctionEvaluator {
        private SyntaxLength() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            if (!arg1.isString()) {
                return F.NIL;
            }
            String str = arg1.toString();
            return F.ZZ(ExprParser.syntaxLength(str, engine));
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class StringTrim
    extends AbstractFunctionEvaluator {
        private StringTrim() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            if (arg1.isString()) {
                if (ast.isAST1()) {
                    return F.$str(arg1.toString().trim());
                }
                if (ast.isAST2()) {
                    if (!ast.arg1().isString()) {
                        return F.NIL;
                    }
                    String str = ((IStringX)ast.arg1()).toString();
                    try {
                        HashMap<ISymbol, String> groups = new HashMap<ISymbol, String>();
                        String regex = StringFunctions.toRegexString(ast.arg2(), true, ast, REGEX_LONGEST, groups, engine);
                        if (regex != null) {
                            Pattern pattern = Pattern.compile("\\A" + regex);
                            str = pattern.matcher(str).replaceAll("");
                            pattern = Pattern.compile(regex + "\\Z");
                            str = pattern.matcher(str).replaceAll("");
                            return F.$str(str);
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        LOGGER.debug("StringTrim.evaluate() failed", (Throwable)iae);
                        return StringFunctions.regexErrorHandling(ast, iae, engine);
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class StringToByteArray
    extends AbstractFunctionEvaluator {
        private StringToByteArray() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            if (!arg1.isString()) {
                return F.NIL;
            }
            String str = ast.arg1().toString();
            try {
                byte[] bArray = str.getBytes(StandardCharsets.UTF_8);
                return ByteArrayExpr.newInstance(bArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class StringTake
    extends AbstractFunctionEvaluator {
        private StringTake() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int from = 1;
            int to = 1;
            IExpr arg1 = ast.arg1();
            try {
                if (!arg1.isString()) {
                    if (arg1.isListOfStrings()) {
                        return ((IAST)arg1).mapThread(ast, 1);
                    }
                    return IOFunctions.printMessage(ast.topHead(), "strse", F.list(F.C1, ast), engine);
                }
                String s = arg1.toString();
                IExpr arg2 = ast.arg2();
                if (arg2.isAST(S.UpTo, 2)) {
                    int upTo = Validate.checkUpTo((IAST)arg2, engine);
                    if (upTo == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    upTo = s.length() > upTo ? upTo : s.length();
                    return F.$str(s.substring(0, upTo));
                }
                if (arg2.equals(S.All)) {
                    return arg1;
                }
                if (arg2.isList()) {
                    int[] sequ = Validate.checkListOfInts(ast, arg2, Integer.MIN_VALUE, Integer.MAX_VALUE, engine);
                    if (sequ == null || sequ.length == 0) {
                        return F.NIL;
                    }
                    switch (sequ.length) {
                        case 1: {
                            from = sequ[0];
                            if (from < 0) {
                                from = s.length() + from + 1;
                            }
                            to = from;
                            return F.$str(s.substring(from - 1, to));
                        }
                        case 2: {
                            from = sequ[0];
                            if (from < 0) {
                                from = s.length() + from + 1;
                            }
                            if ((to = sequ[1]) < 0) {
                                to = s.length() + to + 1;
                            }
                            return F.$str(s.substring(from - 1, to));
                        }
                        case 3: {
                            int step;
                            from = sequ[0];
                            if (from < 0) {
                                from = s.length() + from + 1;
                            }
                            if ((to = sequ[1]) < 0) {
                                to = s.length() + to + 1;
                            }
                            if ((step = sequ[2]) < 0) {
                                return F.NIL;
                            }
                            if (step == 0) {
                                return ((IAST)arg2).mapThread(ast, 2);
                            }
                            StringBuilder buf = new StringBuilder();
                            while (from <= to) {
                                buf.append(s.substring(from - 1, from));
                                from += step;
                            }
                            return F.$str(buf.toString());
                        }
                    }
                    return ((IAST)arg2).mapThread(ast, 2);
                }
                to = Validate.checkIntType(ast, 2, Integer.MIN_VALUE);
                if (to < 0) {
                    from = s.length() + to + 1;
                    to = s.length();
                }
                return F.$str(s.substring(from - 1, to));
            }
            catch (IndexOutOfBoundsException iob) {
                return IOFunctions.printMessage(ast.topHead(), "take", F.list(F.ZZ(from), F.ZZ(to), arg1), engine);
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class StringSplit
    extends AbstractCoreFunctionOptionEvaluator {
        private StringSplit() {
        }

        @Override
        protected IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            if (!arg1.isString()) {
                if (arg1.isListOfStrings()) {
                    return ((IAST)arg1).mapThread(ast, 1);
                }
                return IOFunctions.printMessage(ast.topHead(), "strse", F.list(F.C1, ast), engine);
            }
            String str1 = ((IStringX)arg1).toString().trim();
            if (ast.isAST1()) {
                return StringSplit.splitList(str1, str1.split("\\s+"));
            }
            boolean ignoreCase = option[0].isTrue();
            if (ast.isAST2()) {
                HashMap<ISymbol, String> groups;
                IExpr arg2 = ast.arg2();
                Pattern pattern = StringFunctions.toRegexPattern(arg2, true, ignoreCase, ast, groups = new HashMap<ISymbol, String>(), engine);
                if (pattern == null) {
                    return F.NIL;
                }
                return StringSplit.splitList(str1, pattern.split(str1));
            }
            return F.NIL;
        }

        private static IExpr splitList(String str, String[] result) {
            if (result == null || str.length() == 0) {
                return F.CEmptyList;
            }
            IASTAppendable list = F.ListAlloc(result.length);
            for (int i = 0; i < result.length; ++i) {
                list.append(result[i]);
            }
            return list;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, S.IgnoreCase, S.False);
        }
    }

    private static class StringRiffle
    extends AbstractFunctionEvaluator {
        private StringRiffle() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST list1;
            StringBuilder buf;
            IExpr arg1 = ast.arg1();
            String sep1 = " ";
            String sep2 = "\n";
            String left = "";
            String right = "";
            boolean isListOfLists = arg1.isListOfLists();
            if (isListOfLists) {
                sep1 = "\n";
                sep2 = " ";
            }
            if (ast.size() >= 3) {
                IExpr arg2 = ast.arg2();
                if (arg2.isString()) {
                    sep1 = arg2.toString();
                } else if (arg2.isAST(S.List, 4)) {
                    IAST list = (IAST)arg2;
                    left = list.arg1().toString();
                    sep1 = list.arg2().toString();
                    right = list.arg3().toString();
                } else {
                    return IOFunctions.printMessage(ast.topHead(), "string", F.list(F.C2, ast), engine);
                }
            }
            if (ast.isAST3()) {
                IExpr arg3 = ast.arg3();
                if (arg3.isString()) {
                    sep2 = arg3.toString();
                } else {
                    return IOFunctions.printMessage(ast.topHead(), "string", F.list(F.C3, ast), engine);
                }
            }
            if (isListOfLists) {
                buf = new StringBuilder();
                list1 = (IAST)arg1;
                buf.append(left);
                for (int i = 1; i < list1.size(); ++i) {
                    IAST row = (IAST)list1.get(i);
                    for (int j = 1; j < row.size(); ++j) {
                        TextString.of(row.get(j), buf);
                        if (j >= row.size() - 1) continue;
                        buf.append(sep2);
                    }
                    if (i >= list1.size() - 1) continue;
                    buf.append(sep1);
                }
                buf.append(right);
                return F.stringx(buf.toString());
            }
            if (arg1.isList()) {
                buf = new StringBuilder();
                list1 = (IAST)arg1;
                buf.append(left);
                for (int j = 1; j < list1.size(); ++j) {
                    TextString.of(list1.get(j), buf);
                    if (j >= list1.size() - 1) continue;
                    buf.append(sep1);
                }
                buf.append(right);
                return F.stringx(buf.toString());
            }
            LOGGER.log(engine.getLogLevel(), "StringRiffle: list expected as first argument");
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }
    }

    private static class StringReverse
    extends AbstractFunctionEvaluator {
        private StringReverse() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            String str = arg1.toString();
            return F.stringx(new StringBuilder(str).reverse().toString());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class StringReplace
    extends AbstractCoreFunctionOptionEvaluator {
        private StringReplace() {
        }

        @Override
        protected IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            if (argSize >= 2) {
                boolean ignoreCase = option[0].isTrue();
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isList()) {
                    return ((IAST)arg1).mapThread(ast, 1);
                }
                if (!arg1.isString()) {
                    return F.NIL;
                }
                String str = ((IStringX)arg1).toString();
                IExpr arg2 = ast.arg2();
                if (!arg2.isListOfRules(false)) {
                    if (arg2.isRuleAST()) {
                        arg2 = F.list(arg2);
                    } else {
                        return F.NIL;
                    }
                }
                IAST list = (IAST)arg2;
                for (int i = 1; i < list.size(); ++i) {
                    IAST rule = (IAST)list.get(i);
                    IExpr ruleLHS = rule.arg1();
                    IExpr ruleRHS = rule.arg2();
                    HashMap<ISymbol, String> namedRegexGroups = new HashMap<ISymbol, String>();
                    if (ruleLHS.isCondition()) {
                        IAST condition = (IAST)ruleLHS;
                        IExpr conditionPattern = condition.arg1();
                        IExpr conditionTest = condition.arg2();
                        Pattern pattern = StringFunctions.toRegexPattern(conditionPattern, true, ignoreCase, ast, namedRegexGroups, engine);
                        if (pattern == null) {
                            return F.NIL;
                        }
                        str = StringReplace.stringReplaceCondition(str, conditionTest, ruleRHS, pattern, namedRegexGroups, engine);
                        continue;
                    }
                    Pattern pattern = StringFunctions.toRegexPattern(ruleLHS, true, ignoreCase, ast, namedRegexGroups, engine);
                    if (pattern == null) {
                        return F.NIL;
                    }
                    str = StringReplace.stringReplace(str, ruleRHS, pattern, namedRegexGroups, engine);
                }
                return F.$str(str);
            }
            return F.NIL;
        }

        private static String stringReplace(String str, IExpr ruleRHS, Pattern pattern, Map<ISymbol, String> namedRegexGroups, EvalEngine engine) {
            Matcher matcher = pattern.matcher(str);
            if (!ruleRHS.isString() && namedRegexGroups.size() > 0 && matcher.find()) {
                StringBuffer buf = new StringBuffer(str.length() + 16);
                do {
                    IExpr replacedRHS = ruleRHS;
                    replacedRHS = StringReplace.replaceGroups(replacedRHS, matcher, namedRegexGroups);
                    IExpr temp = engine.evaluate(replacedRHS);
                    matcher.appendReplacement(buf, temp.toString());
                } while (matcher.find());
                matcher.appendTail(buf);
                return buf.toString();
            }
            IExpr temp = engine.evaluate(ruleRHS);
            return pattern.matcher(str).replaceAll(temp.toString());
        }

        private static String stringReplaceCondition(String str, IExpr conditionTest, IExpr ruleRHS, Pattern pattern, Map<ISymbol, String> namedRegexGroups, EvalEngine engine) {
            Matcher matcher = pattern.matcher(str);
            if (!ruleRHS.isString() && namedRegexGroups.size() > 0 && matcher.find()) {
                StringBuffer buf = new StringBuffer(str.length() + 16);
                do {
                    IExpr replacedTest = conditionTest;
                    if (!engine.evalTrue(replacedTest = StringReplace.replaceGroups(replacedTest, matcher, namedRegexGroups))) continue;
                    IExpr replacedRHS = ruleRHS;
                    replacedRHS = StringReplace.replaceGroups(replacedRHS, matcher, namedRegexGroups);
                    IExpr temp = engine.evaluate(replacedRHS);
                    matcher.appendReplacement(buf, temp.toString());
                } while (matcher.find());
                matcher.appendTail(buf);
                return buf.toString();
            }
            IExpr temp = engine.evaluate(ruleRHS);
            return pattern.matcher(str).replaceAll(temp.toString());
        }

        private static IExpr replaceGroups(IExpr expr, Matcher matcher, Map<ISymbol, String> namedRegexGroups) {
            for (Map.Entry<ISymbol, String> group : namedRegexGroups.entrySet()) {
                String groupValue = matcher.group(group.getValue());
                if (groupValue == null) continue;
                expr = F.subs(expr, group.getKey(), F.stringx(groupValue));
            }
            return expr;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, S.IgnoreCase, S.False);
        }
    }

    private static class StringPosition
    extends AbstractCoreFunctionOptionEvaluator {
        private StringPosition() {
        }

        @Override
        protected IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            if (argSize >= 2) {
                IExpr arg1;
                int maxOccurences = Integer.MAX_VALUE;
                boolean ignoreCase = option[0].isTrue();
                if (argSize > 2 && (maxOccurences = ast.arg3().toIntDefault()) < 0) {
                    maxOccurences = Integer.MAX_VALUE;
                }
                if ((arg1 = engine.evaluate(ast.arg1())).isList()) {
                    return ((IAST)arg1).mapThread(ast, 1);
                }
                IExpr arg2 = ast.arg2();
                IASTAppendable result = F.ListAlloc();
                try {
                    if (arg2.isList()) {
                        IAST list = (IAST)arg2;
                        for (int i = 1; i < list.size(); ++i) {
                            IExpr temp = StringPosition.stringPosition(ast, arg1, list.get(i), maxOccurences, ignoreCase, result, engine);
                            if (!temp.isPresent()) {
                                return F.NIL;
                            }
                            if (maxOccurences >= result.size()) continue;
                            return result;
                        }
                        return result;
                    }
                    return StringPosition.stringPosition(ast, arg1, arg2, maxOccurences, ignoreCase, result, engine);
                }
                catch (StackOverflowError soe) {
                    return F.NIL;
                }
            }
            return F.NIL;
        }

        private static IExpr stringPosition(IAST ast, IExpr arg1, IExpr arg2, int maxOccurences, boolean ignoreCase, IASTAppendable result, EvalEngine engine) {
            HashMap<ISymbol, String> groups = new HashMap<ISymbol, String>();
            Pattern pattern = StringFunctions.toRegexPattern(arg2, true, ignoreCase, ast, groups, engine);
            if (pattern == null) {
                return F.NIL;
            }
            String s1 = arg1.toString();
            Matcher matcher = pattern.matcher(s1);
            while (matcher.find()) {
                if (maxOccurences < result.size()) {
                    return result;
                }
                result.append(F.list(F.ZZ(matcher.start() + 1), F.ZZ(matcher.end())));
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, S.IgnoreCase, S.False);
        }
    }

    private static class StringPart
    extends AbstractFunctionEvaluator {
        private StringPart() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!ast.arg1().isString()) {
                return F.NIL;
            }
            IExpr arg2 = ast.arg2();
            if (arg2.isList()) {
                return ((IAST)arg2).mapThread(ast, 2);
            }
            String str = ((IStringX)ast.arg1()).toString();
            int part = arg2.toIntDefault();
            if (part > 0) {
                if (part > str.length()) {
                    return IOFunctions.printMessage(ast.topHead(), "partw", F.list(F.ZZ(part), ast.arg1()), engine);
                }
                return F.stringx(str.charAt(part - 1));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class StringMatchQ
    extends AbstractCoreFunctionOptionEvaluator {
        private StringMatchQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            if (argSize >= 2) {
                HashMap<ISymbol, String> groups;
                boolean ignoreCase = option[0].isTrue();
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isList()) {
                    return ((IAST)arg1).mapThread(ast, 1);
                }
                IExpr arg2 = ast.arg2();
                Pattern pattern = StringFunctions.toRegexPattern(arg2, true, ignoreCase, ast, groups = new HashMap<ISymbol, String>(), engine);
                if (pattern == null) {
                    return F.NIL;
                }
                String s1 = arg1.toString();
                Matcher matcher = pattern.matcher(s1);
                if (matcher.matches()) {
                    return S.True;
                }
                return S.False;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_4_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, S.IgnoreCase, S.False);
        }
    }

    private static class StringLength
    extends AbstractFunctionEvaluator {
        private StringLength() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isString()) {
                return F.ZZ(ast.arg1().toString().length());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class StringJoin
    extends AbstractFunctionEvaluator {
        private StringJoin() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST list = ast;
            if (ast.size() > 1) {
                if (ast.isAST1()) {
                    IExpr arg1 = ast.arg1();
                    if (arg1.isList()) {
                        list = (IAST)arg1;
                    } else {
                        if (arg1.isString()) {
                            return arg1;
                        }
                        return IOFunctions.printMessage(ast.topHead(), "string", F.list(F.C1, ast), engine);
                    }
                }
                StringBuilder buf = new StringBuilder();
                for (int i = 1; i < list.size(); ++i) {
                    if (!list.get(i).isString()) {
                        return IOFunctions.printMessage(ast.topHead(), "string", F.list(F.ZZ(i), ast), engine);
                    }
                    buf.append(list.get(i).toString());
                }
                return F.$str(buf.toString());
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(9);
        }
    }

    private static class StringInsert
    extends AbstractFunctionEvaluator {
        private StringInsert() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int[] listOfInts;
            IExpr arg1 = ast.arg1();
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            if (!arg1.isString()) {
                return F.NIL;
            }
            IExpr arg2 = ast.arg2();
            if (!arg2.isString()) {
                return F.NIL;
            }
            String str1 = ((IStringX)arg1).toString();
            String str2 = ((IStringX)arg2).toString();
            if (ast.arg3().isList()) {
                listOfInts = Validate.checkListOfInts(ast, ast.arg3(), -str1.length() - 1, str1.length() + 1, engine);
            } else {
                int pos = ast.arg3().toIntDefault();
                if (Math.abs(pos) > str1.length() + 1) {
                    return IOFunctions.printMessage(ast.topHead(), "ins", F.list(ast.arg3(), arg1), engine);
                }
                listOfInts = new int[]{pos};
            }
            if (listOfInts == null) {
                return F.NIL;
            }
            try {
                StringBuilder buf = new StringBuilder(str1.length() + str2.length() * listOfInts.length);
                for (int i = 0; i < listOfInts.length; ++i) {
                    if (listOfInts[i] < 0) {
                        listOfInts[i] = str1.length() + listOfInts[i] + 2;
                        continue;
                    }
                    if (listOfInts[i] != 0) continue;
                    return IOFunctions.printMessage(ast.topHead(), "ins", F.list(F.C0, arg1), engine);
                }
                Arrays.sort(listOfInts);
                int lastPos = 0;
                for (int i = 0; i < listOfInts.length; ++i) {
                    buf.append(str1.substring(lastPos, listOfInts[i] - 1));
                    lastPos = listOfInts[i] - 1;
                    buf.append(str2);
                }
                buf.append(str1.substring(lastPos));
                return F.$str(buf.toString());
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }
    }

    private static class StringFreeQ
    extends AbstractCoreFunctionOptionEvaluator {
        private StringFreeQ() {
        }

        @Override
        protected IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            if (argSize >= 2) {
                boolean ignoreCase = option[0].isTrue();
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isList()) {
                    return ((IAST)arg1).mapThread(ast, 1);
                }
                if (!arg1.isString()) {
                    return IOFunctions.printMessage(ast.topHead(), "strse", F.list(F.C1, ast), engine);
                }
                IExpr arg2 = ast.arg2();
                if (arg2.isList()) {
                    IAST list = (IAST)arg2;
                    for (int i = 1; i < list.size(); ++i) {
                        IExpr temp = StringFreeQ.stringFreeQ(ast, arg1, list.get(i), ignoreCase, engine);
                        if (temp.isTrue()) continue;
                        return temp;
                    }
                    return S.True;
                }
                return StringFreeQ.stringFreeQ(ast, arg1, arg2, ignoreCase, engine);
            }
            return F.NIL;
        }

        private static IExpr stringFreeQ(IAST ast, IExpr arg1, IExpr arg2, boolean ignoreCase, EvalEngine engine) {
            HashMap<ISymbol, String> groups = new HashMap<ISymbol, String>();
            Pattern pattern = StringFunctions.toRegexPattern(arg2, true, ignoreCase, ast, groups, engine);
            if (pattern == null) {
                return F.NIL;
            }
            String s1 = arg1.toString();
            Matcher matcher = pattern.matcher(s1);
            if (matcher.find()) {
                return S.False;
            }
            return S.True;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, S.IgnoreCase, S.False);
        }
    }

    private static class StringFormat
    extends AbstractFunctionEvaluator {
        private StringFormat() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isString()) {
                String input = arg1.toString();
                CsvParserSettings settings = new CsvParserSettings();
                settings.detectFormatAutomatically();
                CsvParser parser = new CsvParser(settings);
                parser.beginParsing((Reader)new StringReader(input));
                CsvFormat format = parser.getDetectedFormat();
                parser.stopParsing();
                char delimiter = format.getDelimiter();
                switch (delimiter) {
                    case ',': {
                        return F.stringx("CSV");
                    }
                    case '\t': {
                        return F.stringx("TSV");
                    }
                    case ' ': {
                        int index = input.indexOf(10);
                        if (index >= 0) {
                            return F.stringx("Table");
                        }
                        return F.stringx("Text");
                    }
                }
                return F.stringx(delimiter);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class StringExpression
    extends AbstractFunctionEvaluator {
        private StringExpression() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            StringBuilder buf = new StringBuilder();
            for (int i = 1; i < ast.size(); ++i) {
                IExpr arg = ast.get(i);
                if (!arg.isString()) {
                    return F.NIL;
                }
                buf.append(arg.toString());
            }
            return F.$str(buf.toString());
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(9);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }
    }

    private static class StringDrop
    extends AbstractFunctionEvaluator {
        private StringDrop() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int from = 1;
            int to = 1;
            try {
                if (ast.arg1().isString()) {
                    String s = ast.arg1().toString();
                    from = Validate.checkIntType(ast, 2, Integer.MIN_VALUE);
                    if (from >= 0) {
                        ++from;
                        to = s.length();
                    } else {
                        to = s.length() + from;
                        from = 1;
                    }
                    return F.$str(s.substring(from - 1, to));
                }
            }
            catch (IndexOutOfBoundsException iob) {
                return IOFunctions.printMessage(ast.topHead(), "drop", F.list(F.ZZ(from - 1), F.ZZ(to), ast.arg1()), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class StringContainsQ
    extends AbstractCoreFunctionOptionEvaluator {
        private StringContainsQ() {
        }

        @Override
        protected IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            if (argSize >= 2) {
                boolean ignoreCase = option[0].isTrue();
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isList()) {
                    return ((IAST)arg1).mapThread(ast, 1);
                }
                if (arg1.isString() && !ast.arg2().isRuleAST()) {
                    HashMap<ISymbol, String> groups;
                    IExpr arg2 = ast.arg2();
                    Pattern pattern = StringFunctions.toRegexPattern(arg2, true, ignoreCase, ast, groups = new HashMap<ISymbol, String>(), engine);
                    if (pattern == null) {
                        return F.NIL;
                    }
                    String s1 = arg1.toString();
                    Matcher matcher = pattern.matcher(s1);
                    if (matcher.find()) {
                        return S.True;
                    }
                    return S.False;
                }
                return F.NIL;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, S.IgnoreCase, S.False);
        }
    }

    private static class StringCount
    extends AbstractCoreFunctionOptionEvaluator {
        private StringCount() {
        }

        @Override
        protected IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            if (argSize >= 2) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isList()) {
                    return ((IAST)arg1).mapThread(ast, 1);
                }
                if (arg1.isString()) {
                    boolean ignoreCase = option[0].isTrue();
                    String str = ((IStringX)arg1).toString();
                    IExpr arg2 = ast.arg2();
                    if (!arg2.isList()) {
                        arg2 = F.list(arg2);
                    }
                    IAST list = (IAST)arg2;
                    int counter = 0;
                    for (int i = 1; i < list.size(); ++i) {
                        HashMap<ISymbol, String> groups;
                        IExpr arg = list.get(i);
                        Pattern pattern = StringFunctions.toRegexPattern(arg, true, ignoreCase, ast, groups = new HashMap<ISymbol, String>(), engine);
                        if (pattern == null) {
                            return F.NIL;
                        }
                        Matcher m = pattern.matcher(str);
                        while (m.find()) {
                            ++counter;
                        }
                    }
                    return F.ZZ(counter);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, S.IgnoreCase, S.False);
        }
    }

    private static class StringCases
    extends AbstractCoreFunctionOptionEvaluator {
        private StringCases() {
        }

        @Override
        protected IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            if (argSize >= 2) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isList()) {
                    return ((IAST)arg1).mapThread(ast, 1);
                }
                if (arg1.isString()) {
                    boolean ignoreCase = option[0].isTrue();
                    String str = ((IStringX)arg1).toString();
                    IExpr arg2 = ast.arg2();
                    if (!arg2.isList()) {
                        arg2 = F.list(arg2);
                    }
                    IAST list = (IAST)arg2;
                    IASTAppendable result = F.ListAlloc();
                    for (int i = 1; i < list.size(); ++i) {
                        HashMap<ISymbol, String> groups;
                        IExpr arg = list.get(i);
                        Pattern pattern = StringFunctions.toRegexPattern(arg, true, ignoreCase, ast, groups = new HashMap<ISymbol, String>(), engine);
                        if (pattern == null) {
                            return F.NIL;
                        }
                        Matcher m = pattern.matcher(str);
                        while (m.find()) {
                            String s = m.group();
                            result.append(F.$str(s));
                        }
                    }
                    return result;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, S.IgnoreCase, S.False);
        }
    }

    private static class RemoveDiacritics
    extends AbstractFunctionEvaluator {
        private RemoveDiacritics() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!(ast.arg1() instanceof IStringX)) {
                return F.NIL;
            }
            String str = ast.arg1().toString();
            Transliterator transform = Transliterator.getInstance((String)"NFD; [:Nonspacing Mark:] Remove; NFC");
            String value = transform.transliterate(str);
            return F.$str(value);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class PrintableASCIIQ
    extends AbstractFunctionEvaluator
    implements Predicate<IExpr> {
        private PrintableASCIIQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = Validate.checkStringType(ast, 1, engine);
            if (arg1.isPresent()) {
                return F.bool(this.test(arg1));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }

        @Override
        public boolean test(IExpr obj) {
            String str = obj.toString();
            if (str.length() == 0) {
                return true;
            }
            return CharMatcher.inRange((char)' ', (char)'~').matchesAllOf((CharSequence)str);
        }
    }

    private static final class EditDistance
    extends AbstractFunctionOptionEvaluator {
        private EditDistance() {
        }

        @Override
        public IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg1.isString() && arg2.isString()) {
                boolean ignoreCase = option[0].isTrue();
                LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
                if (ignoreCase) {
                    return F.ZZ(levenshteinDistance.apply((CharSequence)arg1.toString().toLowerCase(), (CharSequence)arg2.toString().toLowerCase()));
                }
                return F.ZZ(levenshteinDistance.apply((CharSequence)arg1.toString(), (CharSequence)arg2.toString()));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, S.IgnoreCase, S.False);
        }
    }

    private static class LowerCaseQ
    extends AbstractFunctionEvaluator
    implements Predicate<IExpr> {
        private LowerCaseQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = Validate.checkStringType(ast, 1, engine);
            if (arg1.isPresent()) {
                return F.bool(this.test(arg1));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public boolean test(IExpr obj) {
            String str = obj.toString();
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (Character.isLowerCase(ch)) continue;
                return false;
            }
            return true;
        }
    }

    private static class LetterQ
    extends AbstractFunctionEvaluator
    implements Predicate<IExpr> {
        private LetterQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isString()) {
                return F.bool(this.test(ast.arg1()));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public boolean test(IExpr obj) {
            String str = obj.toString();
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (Character.isLetter(ch)) continue;
                return false;
            }
            return true;
        }
    }

    private static class LetterNumber
    extends AbstractFunctionEvaluator {
        private LetterNumber() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList()) {
                return ((IAST)ast.arg1()).mapThread(ast, 1);
            }
            if (ast.arg1().isString()) {
                String str;
                String characters = ast.arg1().toString().toLowerCase();
                String alphabet = StringFunctions.LATIN_ALPHABET;
                if (ast.isAST2() && (alphabet = ALPHABET_MAP.get(str = ast.arg2().toString())) == null) {
                    String[] strs = ALPHABET_CSV_MAP.get(str);
                    if (strs == null) {
                        IOFunctions.printMessage(ast.topHead(), "nalph", F.list(ast.arg2()), engine);
                        return F.C0;
                    }
                    for (int i = 0; i < strs.length; ++i) {
                        if (!strs[i].equals(characters)) continue;
                        return F.ZZ(i + 1);
                    }
                    return F.C0;
                }
                if (characters.length() > 1) {
                    IASTAppendable result = F.ListAlloc(characters.length());
                    for (int i = 0; i < characters.length(); ++i) {
                        int indx = alphabet.indexOf(characters.charAt(i));
                        if (indx >= 0) {
                            result.append(F.ZZ(indx + 1));
                            continue;
                        }
                        result.append(F.C0);
                    }
                    return result;
                }
                int indx = alphabet.indexOf(characters);
                if (indx >= 0) {
                    return F.ZZ(indx + 1);
                }
                return F.C0;
            }
            return IOFunctions.printMessage(ast.topHead(), "nas", F.list(ast.arg1()), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class Alphabet
    extends AbstractFunctionEvaluator {
        private Alphabet() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            String str;
            String alphabet = StringFunctions.LATIN_ALPHABET;
            if (ast.isAST1() && (alphabet = ALPHABET_MAP.get(str = ast.arg1().toString())) == null) {
                String[] strs = ALPHABET_CSV_MAP.get(str);
                if (strs == null) {
                    return IOFunctions.printMessage(ast.topHead(), "nalph", F.list(ast.arg1()), engine);
                }
                return F.List(strs);
            }
            if (alphabet.length() > 2) {
                IASTAppendable result = F.ListAlloc(alphabet.length());
                for (int i = 0; i < alphabet.length(); ++i) {
                    result.append(F.stringx(alphabet.charAt(i)));
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }
    }

    private static final class HammingDistance
    extends AbstractFunctionOptionEvaluator {
        private HammingDistance() {
        }

        @Override
        public IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg1.isString() && arg2.isString()) {
                boolean ignoreCase = option[0].isTrue();
                org.apache.commons.text.similarity.HammingDistance hammingDistance = new org.apache.commons.text.similarity.HammingDistance();
                String str1 = arg1.toString();
                String str2 = arg2.toString();
                if (str1.length() != str2.length()) {
                    return IOFunctions.printMessage(ast.topHead(), "idim", F.list(arg1, arg2), engine);
                }
                if (ignoreCase) {
                    return F.ZZ(hammingDistance.apply((CharSequence)str1.toLowerCase(), (CharSequence)str2.toLowerCase()));
                }
                return F.ZZ(hammingDistance.apply((CharSequence)str1, (CharSequence)str2));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, S.IgnoreCase, S.False);
        }
    }

    private static class FromLetterNumber
    extends AbstractFunctionEvaluator {
        private FromLetterNumber() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList()) {
                return ((IAST)ast.arg1()).mapThread(ast, 1);
            }
            int number = ast.arg1().toIntDefault();
            if (number != Integer.MIN_VALUE) {
                String alphabet = StringFunctions.LATIN_ALPHABET;
                if (ast.isAST2()) {
                    IExpr arg2 = ast.arg2();
                    if (arg2.isList()) {
                        return ((IAST)arg2).mapThread(ast, 2);
                    }
                    if (arg2.isString()) {
                        String str = ast.arg2().toString();
                        alphabet = ALPHABET_MAP.get(str);
                        if (alphabet == null) {
                            String[] strs = ALPHABET_CSV_MAP.get(str);
                            if (strs == null) {
                                IOFunctions.printMessage(ast.topHead(), "nalph", F.list(ast.arg2()), engine);
                                return F.Missing(S.NotAvailable);
                            }
                            int length = strs.length;
                            if (number > 0 && number <= length) {
                                return F.stringx(strs[number - 1]);
                            }
                            if (number < 0 && length + number >= 0) {
                                return F.stringx(strs[length + number]);
                            }
                            return F.Missing(S.NotApplicable);
                        }
                    } else {
                        return F.NIL;
                    }
                }
                int length = alphabet.length();
                if (number > 0 && number <= length) {
                    return F.stringx(alphabet.charAt(number - 1));
                }
                if (number < 0 && length + number >= 0) {
                    return F.stringx(alphabet.charAt(length + number));
                }
                return F.Missing(S.NotApplicable);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class FromCharacterCode
    extends AbstractFunctionEvaluator {
        private FromCharacterCode() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() != 2) {
                return F.NIL;
            }
            if (ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                return FromCharacterCode.fromCharacterCode(list, ast, engine);
            }
            if (ast.arg1().isInteger()) {
                return FromCharacterCode.fromCharacterCode(ast, ast, engine);
            }
            return F.NIL;
        }

        private static IExpr fromCharacterCode(IAST charList, IAST fromCharacterCodeAST, EvalEngine engine) {
            StringBuilder buffer = new StringBuilder(charList.size());
            for (int i = 1; i < charList.size(); ++i) {
                int unicode;
                if (charList.get(i).isInteger()) {
                    unicode = charList.get(i).toIntDefault();
                    if (unicode < 0 || unicode >= 0x110000) {
                        return IOFunctions.printMessage(S.FromCharacterCode, "notunicode", F.list(charList, F.ZZ(i)), engine);
                    }
                } else {
                    return F.NIL;
                }
                char ch = (char)unicode;
                buffer.append(ch);
            }
            return StringX.valueOf(buffer);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class FileNameTake
    extends AbstractFunctionEvaluator {
        private FileNameTake() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int from = 1;
            int to = 1;
            IExpr arg1 = ast.arg1();
            try {
                if (arg1.isString()) {
                    String fileName = ((IStringX)arg1).toString();
                    String separator = "/";
                    if (ast.isAST1()) {
                        int index = fileName.lastIndexOf(separator);
                        if (index >= 0) {
                            return F.stringx(fileName.substring(index + separator.length()));
                        }
                        separator = File.separator;
                        if (separator != null && (index = fileName.lastIndexOf(separator)) >= 0) {
                            return F.stringx(fileName.substring(index + separator.length()));
                        }
                        return arg1;
                    }
                }
            }
            catch (IndexOutOfBoundsException iob) {
                return IOFunctions.printMessage(ast.topHead(), "take", F.list(F.ZZ(from), F.ZZ(to), arg1), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class FileNameJoin
    extends AbstractFunctionEvaluator {
        private FileNameJoin() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int from = 1;
            int to = 1;
            IExpr arg1 = ast.arg1();
            try {
                if (arg1.isListOfStrings()) {
                    IAST list = (IAST)arg1;
                    if (list.isAST1()) {
                        return list.get(1);
                    }
                    char separator = File.separatorChar;
                    StringBuilder buf = new StringBuilder();
                    for (int i = 1; i < list.size(); ++i) {
                        String arg = list.get(i).toString();
                        if (arg.length() <= 0) continue;
                        buf.append(arg);
                        if (i >= list.size() - 1 || arg.charAt(arg.length() - 1) == separator) continue;
                        buf.append(separator);
                    }
                    return F.stringx(buf.toString());
                }
            }
            catch (IndexOutOfBoundsException iob) {
                return IOFunctions.printMessage(ast.topHead(), "take", F.list(F.ZZ(from), F.ZZ(to), arg1), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class CharacterRange
    extends AbstractFunctionEvaluator {
        private CharacterRange() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!(ast.arg1() instanceof IStringX) || !(ast.arg2() instanceof IStringX)) {
                if (!ast.arg1().isInteger() || !ast.arg2().isInteger()) {
                    return IOFunctions.printMessage(ast.topHead(), "argtype", F.list(ast.arg1(), ast.arg2(), ast.topHead()), engine);
                }
                int from = ast.arg1().toIntDefault();
                int to = ast.arg2().toIntDefault();
                if (from < 0 || to < 0) {
                    return IOFunctions.printMessage(ast.topHead(), "argtype", F.list(ast.arg1(), ast.arg2(), ast.topHead()), engine);
                }
                int size = to - from + 1;
                if (size <= 0) {
                    return F.CEmptyList;
                }
                IASTAppendable result = F.ListAlloc(size);
                for (int i = from; i <= to; ++i) {
                    result.append(F.$str((char)i));
                }
                return result;
            }
            String str1 = ast.arg1().toString();
            String str2 = ast.arg2().toString();
            if (str1.length() != 1 || str2.length() != 1) {
                return IOFunctions.printMessage(ast.topHead(), "argtype", F.list(ast.arg1(), ast.arg2(), ast.topHead()), engine);
            }
            char from = str1.charAt(0);
            char to = str2.charAt(0);
            int size = to - from + 1;
            if (size <= 0) {
                return F.CEmptyList;
            }
            IASTAppendable result = F.ListAlloc(size);
            for (char i = from; i <= to; i = (char)(i + '\u0001')) {
                result.append(F.$str(i));
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class Characters
    extends AbstractFunctionEvaluator {
        private Characters() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!(ast.arg1() instanceof IStringX)) {
                return F.NIL;
            }
            String str = ast.arg1().toString();
            IASTAppendable result = F.ListAlloc(str.length());
            for (int i = 0; i < str.length(); ++i) {
                result.append(F.$str(str.charAt(i)));
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class ByteArrayToString
    extends AbstractFunctionEvaluator {
        private ByteArrayToString() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1 instanceof ByteArrayExpr) {
                byte[] bArray = (byte[])((IDataExpr)arg1).toData();
                if (bArray.length == 0) {
                    return F.$str("");
                }
                String str = new String(bArray, StandardCharsets.UTF_8);
                return F.$str(str);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class BaseEncode
    extends AbstractFunctionEvaluator {
        private BaseEncode() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1 instanceof ByteArrayExpr) {
                byte[] bArray = (byte[])((IDataExpr)arg1).toData();
                if (bArray.length == 0) {
                    return F.$str("");
                }
                String str = Base64.getEncoder().encodeToString(bArray);
                return F.$str(str);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class BaseDecode
    extends AbstractFunctionEvaluator {
        private BaseDecode() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!(ast.arg1() instanceof IStringX)) {
                return F.NIL;
            }
            String str = ast.arg1().toString();
            try {
                byte[] bArray = Base64.getDecoder().decode(str.toString());
                return ByteArrayExpr.newInstance(bArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            int i;
            for (i = 0; i < ALPHABETS.length; i += 2) {
                ALPHABET_MAP.put(ALPHABETS[i], ALPHABETS[i + 1]);
            }
            for (i = 0; i < ALPHABETS_CSV.length; i += 2) {
                String alphabetCSV = ALPHABETS_CSV[i + 1];
                String[] result = alphabetCSV.split(",");
                ALPHABET_CSV_MAP.put(ALPHABETS_CSV[i], result);
            }
            TRANSLITERATE_MAP.put("English", "Latin");
            S.Alphabet.setEvaluator(new Alphabet());
            S.BaseDecode.setEvaluator(new BaseDecode());
            S.BaseEncode.setEvaluator(new BaseEncode());
            S.ByteArrayToString.setEvaluator(new ByteArrayToString());
            S.Characters.setEvaluator(new Characters());
            S.CharacterRange.setEvaluator(new CharacterRange());
            S.EditDistance.setEvaluator(new EditDistance());
            S.FileNameJoin.setEvaluator(new FileNameJoin());
            S.FileNameTake.setEvaluator(new FileNameTake());
            S.FromCharacterCode.setEvaluator(new FromCharacterCode());
            S.FromLetterNumber.setEvaluator(new FromLetterNumber());
            S.HammingDistance.setEvaluator(new HammingDistance());
            S.LetterNumber.setEvaluator(new LetterNumber());
            S.LetterQ.setEvaluator(new LetterQ());
            S.LowerCaseQ.setEvaluator(new LowerCaseQ());
            S.PrintableASCIIQ.setEvaluator(new PrintableASCIIQ());
            S.RemoveDiacritics.setEvaluator(new RemoveDiacritics());
            S.StringCases.setEvaluator(new StringCases());
            S.StringCount.setEvaluator(new StringCount());
            S.StringContainsQ.setEvaluator(new StringContainsQ());
            S.StringDrop.setEvaluator(new StringDrop());
            S.StringExpression.setEvaluator(new StringExpression());
            S.StringFreeQ.setEvaluator(new StringFreeQ());
            S.StringFormat.setEvaluator(new StringFormat());
            S.StringInsert.setEvaluator(new StringInsert());
            S.StringJoin.setEvaluator(new StringJoin());
            S.StringLength.setEvaluator(new StringLength());
            S.StringMatchQ.setEvaluator(new StringMatchQ());
            S.StringPart.setEvaluator(new StringPart());
            S.StringPosition.setEvaluator(new StringPosition());
            S.StringReplace.setEvaluator(new StringReplace());
            S.StringReverse.setEvaluator(new StringReverse());
            S.StringRiffle.setEvaluator(new StringRiffle());
            S.StringSplit.setEvaluator(new StringSplit());
            S.StringTake.setEvaluator(new StringTake());
            S.StringTemplate.setEvaluator(new StringTemplate());
            S.StringToByteArray.setEvaluator(new StringToByteArray());
            S.StringTrim.setEvaluator(new StringTrim());
            S.SyntaxLength.setEvaluator(new SyntaxLength());
            S.TemplateApply.setEvaluator(new TemplateApply());
            S.TemplateIf.setEvaluator(new TemplateIf());
            S.TemplateSlot.setEvaluator(new TemplateSlot());
            S.TextString.setEvaluator(new TextString());
            S.ToCharacterCode.setEvaluator(new ToCharacterCode());
            S.ToLowerCase.setEvaluator(new ToLowerCase());
            S.ToString.setEvaluator(new ToString());
            S.ToUnicode.setEvaluator(new ToUnicode());
            S.ToUpperCase.setEvaluator(new ToUpperCase());
            S.Transliterate.setEvaluator(new Transliterate());
            S.UpperCaseQ.setEvaluator(new UpperCaseQ());
            TeXParser.initialize();
            if (!Config.FUZZY_PARSER) {
                S.ToExpression.setEvaluator(new ToExpression());
            }
        }
    }
}

