/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.hipparchus.distribution.IntegerDistribution;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.distribution.continuous.ChiSquaredDistribution;
import org.hipparchus.distribution.continuous.FDistribution;
import org.hipparchus.distribution.continuous.TDistribution;
import org.hipparchus.distribution.continuous.UniformRealDistribution;
import org.hipparchus.distribution.discrete.UniformIntegerDistribution;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.correlation.PearsonsCorrelation;
import org.hipparchus.util.MathUtils;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractArg2;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractMatrix1Expr;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IContinuousDistribution;
import org.matheclipse.core.interfaces.IDiscreteDistribution;
import org.matheclipse.core.interfaces.IDistribution;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.InterquartileRangeRules;
import org.matheclipse.core.reflection.system.rules.QuantileRules;
import org.matheclipse.core.reflection.system.rules.StandardDeviationRules;

public class StatisticsFunctions {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final double NEXTDOWNONE = Math.nextDown(1.0);

    private static IDistribution getDistribution(IExpr arg1) {
        return (IDistribution)((Object)((IBuiltInSymbol)arg1.head()).getEvaluator());
    }

    private static IDiscreteDistribution getDiscreteDistribution(IExpr arg1) {
        return (IDiscreteDistribution)((Object)((IBuiltInSymbol)arg1.head()).getEvaluator());
    }

    private static double[] nextDeviates(Random random, DoubleUnaryOperator function, int size) {
        double[] out = new double[size];
        for (int i = 0; i < size; ++i) {
            double p = random.nextDouble();
            out[i] = function.applyAsDouble(p);
        }
        return out;
    }

    public static void initialize() {
        Initializer.init();
    }

    private StatisticsFunctions() {
    }

    private static final class WeibullDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDistribution,
    IPDF,
    IStatistics,
    IRandomVariate {
        private WeibullDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST2()) {
                return F.Times(dist.arg2(), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Power(dist.arg1(), F.CN1))));
            }
            if (dist.isAST3()) {
                return F.Plus(dist.arg3(), (IExpr)F.Times(dist.arg2(), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Power(dist.arg1(), F.CN1)))));
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST2()) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                return F.Times(b, (IExpr)F.Power((IExpr)F.Log(F.C2), F.Power(a, -1L)));
            }
            if (dist.isAST3()) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                IExpr m = dist.arg3();
                return F.Plus(m, (IExpr)F.Times(b, (IExpr)F.Power((IExpr)F.Log(F.C2), F.Power(a, -1L))));
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.WeibullDistribution(n.evalDouble(), m.evalDouble()).cumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Subtract(F.C1, F.Exp(F.Negate(F.Power((IExpr)F.Times((IExpr)F.Power(m, F.CN1), (IExpr)F.Slot1), n)))), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.WeibullDistribution(n.evalDouble(), m.evalDouble()).inverseCumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Times(m, (IExpr)F.Power(F.Negate(F.Log(F.Subtract(F.C1, F.Slot1))), F.Power(n, F.CN1))), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.C0, F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.WeibullDistribution(n.evalDouble(), m.evalDouble()).density(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Times((IExpr)F.Exp(F.Power((IExpr)F.Times((IExpr)F.Power(m, F.CN1), (IExpr)F.Slot1), n)), m), F.CN1), n, (IExpr)F.Power((IExpr)F.Times((IExpr)F.Power(m, F.CN1), (IExpr)F.Slot1), F.Plus((IExpr)F.CN1, n))), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Times((IExpr)F.Sqr(m), (IExpr)F.Plus(F.Negate(F.Sqr(F.Gamma(F.Plus((IExpr)F.C1, F.Power(n, -1L))))), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C2, F.Power(n, -1L))))));
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            if (dist.isAST2()) {
                double n = dist.arg1().evalDouble();
                double m = dist.arg2().evalDouble();
                RandomDataGenerator rdg = new RandomDataGenerator();
                double[] vector = rdg.nextDeviates((RealDistribution)new org.hipparchus.distribution.continuous.WeibullDistribution(n, m), size);
                return new ASTRealVector(vector, false);
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                return F.Times((IExpr)F.Power((IExpr)F.Plus(F.Negate(F.Sqr(F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Power(n, F.CN1))))), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power(n, F.CN1))))), F.QQ(-3L, 2L)), (IExpr)F.Plus((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power((IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Power(n, F.CN1))), F.C3)), (IExpr)F.Times((IExpr)F.CN3, (IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Power(n, F.CN1))), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power(n, F.CN1))))), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C3, (IExpr)F.Power(n, F.CN1))))));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Variance
    extends AbstractFunctionEvaluator {
        private Variance() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAST()) {
                try {
                    IEvaluator evaluator;
                    ISymbol head;
                    IAST dist;
                    IAST arg1 = (IAST)ast.arg1();
                    int[] matrixDimensions = arg1.isMatrix();
                    if (matrixDimensions != null) {
                        if (arg1.isRealMatrix()) {
                            double[][] matrix = arg1.toDoubleMatrix();
                            if (matrix == null) {
                                return F.NIL;
                            }
                            matrix = Convert.toDoubleTransposed(matrix);
                            double[] result = new double[matrixDimensions[1]];
                            for (int i = 0; i < matrix.length; ++i) {
                                result[i] = StatUtils.variance((double[])matrix[i]);
                            }
                            return new ASTRealVector(result, false);
                        }
                        IASTAppendable result = F.ListAlloc(matrixDimensions[0] + 1);
                        int i = 1;
                        while (i < matrixDimensions[1] + 1) {
                            int ii = i++;
                            IASTAppendable list = F.ListAlloc(matrixDimensions[1]);
                            IAST variance = F.Variance(list);
                            list.appendArgs(matrixDimensions[0] + 1, j -> arg1.getPart(j, ii));
                            result.append(variance);
                        }
                        return result;
                    }
                    int dim = arg1.isVector();
                    if (dim >= 0) {
                        if (arg1.isRealVector()) {
                            double[] values = arg1.toDoubleVector();
                            if (values == null) {
                                return F.NIL;
                            }
                            return F.num(StatUtils.variance((double[])values));
                        }
                        return Covariance.vectorCovarianceSymbolic(arg1, arg1, dim);
                    }
                    if (arg1.isAST() && (dist = arg1).head().isSymbol() && (head = (ISymbol)dist.head()) instanceof IBuiltInSymbol && (evaluator = ((IBuiltInSymbol)head).getEvaluator()) instanceof IStatistics) {
                        IStatistics distribution = (IStatistics)((Object)evaluator);
                        return distribution.variance(dist);
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Variance.evaluate() failed", (Throwable)ex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class UniformDistribution
    extends AbstractEvaluator
    implements IDistribution,
    IStatistics,
    ICDF,
    IPDF,
    IRandomVariate {
        private UniformDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public IExpr mean(IAST dist) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                return F.Times((IExpr)F.C1D2, (IExpr)F.Plus(minMax[0], minMax[1]));
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                IExpr l = minMax[0];
                IExpr r = minMax[1];
                return F.Times((IExpr)F.C1D2, (IExpr)F.Plus(l, r));
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                IExpr l = minMax[0];
                IExpr r = minMax[1];
                return F.Times((IExpr)F.QQ(1L, 12L), (IExpr)F.Sqr(F.Subtract(l, r)));
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                return F.C0;
            }
            return F.NIL;
        }

        public IExpr[] minmax(IAST dist) {
            if (dist.size() == 2 && dist.arg1().isList()) {
                IAST list = (IAST)dist.arg1();
                if (list.isAST2()) {
                    IExpr l = list.arg1();
                    IExpr r = list.arg2();
                    return new IExpr[]{l, r};
                }
            } else if (dist.isAST0()) {
                return new IExpr[]{F.C0, F.C1};
            }
            return null;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                IExpr a = minMax[0];
                IExpr b = minMax[1];
                if (!engine.isArbitraryMode() && (a.isNumericArgument() || b.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new UniformRealDistribution(a.evalDouble(), b.evalDouble()).cumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Plus(F.Negate(a), b), F.CN1), (IExpr)F.Plus(F.Negate(a), (IExpr)F.Slot1)), F.LessEqual(a, F.Slot1, b)), F.list(F.C1, F.Greater((IExpr)F.Slot1, b))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                IExpr a = minMax[0];
                IExpr b = minMax[1];
                if (!engine.isArbitraryMode() && (a.isNumericArgument() || b.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new UniformRealDistribution(a.evalDouble(), b.evalDouble()).inverseCumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Plus((IExpr)F.Times((IExpr)F.Subtract(F.C1, F.Slot1), a), (IExpr)F.Times((IExpr)F.Slot1, b)), F.Less(F.C0, F.Slot1, F.C1)), F.list(a, F.LessEqual((IExpr)F.Slot1, F.C0))), b), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                IExpr a = minMax[0];
                IExpr b = minMax[1];
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Power((IExpr)F.Plus(F.Negate(a), b), F.CN1), F.LessEqual(a, F.Slot1, b))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                double min = minMax[0].evalDouble();
                double max = minMax[1].evalDouble();
                RandomDataGenerator rdg = new RandomDataGenerator();
                double[] vector = rdg.nextDeviates((RealDistribution)new UniformRealDistribution(min, max), size);
                return new ASTRealVector(vector, false);
            }
            return F.NIL;
        }
    }

    private static final class TTest
    extends AbstractEvaluator {
        private TTest() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            double[] vector;
            IExpr arg1 = ast.arg1();
            if (arg1.isList2()) {
                double[] vector2;
                double[] vector1;
                int dimension2;
                IAST list = (IAST)arg1;
                int dimension1 = list.first().isVector();
                if (dimension1 > 0 && (dimension2 = list.second().isVector()) > 0 && (vector1 = list.first().toDoubleVector()) != null && (vector2 = list.second().toDoubleVector()) != null) {
                    if (vector1.length <= 1 || vector2.length <= 1) {
                        return IOFunctions.printMessage(ast.topHead(), "rctndm1", F.list(arg1, F.C1), engine);
                    }
                    org.hipparchus.stat.inference.TTest tTest = new org.hipparchus.stat.inference.TTest();
                    double value = tTest.homoscedasticTTest(vector1, vector2);
                    return F.num(value);
                }
                return F.NIL;
            }
            int dimension = arg1.isVector();
            if (dimension > 0 && (vector = arg1.toDoubleVector()) != null) {
                if (vector.length <= 1) {
                    return IOFunctions.printMessage(ast.topHead(), "rctndm1", F.list(arg1, F.C1), engine);
                }
                org.hipparchus.stat.inference.TTest tTest = new org.hipparchus.stat.inference.TTest();
                double value = tTest.tTest(0.0, vector);
                return F.num(value);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class SurvivalFunction
    extends AbstractFunctionEvaluator {
        private SurvivalFunction() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1() && ast.first().isAST()) {
                IAST dist = (IAST)ast.arg1();
                if (SurvivalFunction.isDistribution(dist)) {
                    return F.Expand(F.Subtract(F.C1, F.CDF(dist)));
                }
                return F.NIL;
            }
            if (ast.isAST2() && ast.first().isAST()) {
                IAST dist = (IAST)ast.arg1();
                if (SurvivalFunction.isDistribution(dist)) {
                    if (ast.arg2().isList()) {
                        return ((IAST)ast.arg2()).mapThread(ast, 2);
                    }
                    return F.Expand(F.Subtract(F.C1, F.CDF(dist, ast.arg2())));
                }
                return F.NIL;
            }
            return F.NIL;
        }

        private static boolean isDistribution(IAST dist) {
            IEvaluator evaluator;
            ISymbol head;
            return dist.head().isSymbol() && (head = (ISymbol)dist.head()) instanceof IBuiltInSymbol && (evaluator = ((IBuiltInSymbol)head).getEvaluator()) instanceof IDistribution;
        }
    }

    private static final class StudentTDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDistribution,
    IPDF,
    IStatistics {
        private StudentTDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST1()) {
                return F.Piecewise(F.list(F.list(F.C0, F.Greater(dist.arg1(), F.C1))), S.Indeterminate);
            }
            if (dist.isAST3()) {
                return F.Piecewise(F.list(F.list(dist.arg1(), F.Greater(dist.arg3(), F.C1))), S.Indeterminate);
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST1()) {
                return F.C0;
            }
            if (dist.isAST3()) {
                return dist.arg1();
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new TDistribution(n.evalDouble()).cumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.C1D2, (IExpr)F.BetaRegularized(F.Times(n, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Sqr(F.Slot1), n), F.CN1)), F.Times((IExpr)F.C1D2, n), F.C1D2)), F.LessEqual((IExpr)F.Slot1, F.C0))), F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.C1, (IExpr)F.BetaRegularized(F.Times((IExpr)F.Power((IExpr)F.Plus((IExpr)F.Sqr(F.Slot1), n), F.CN1), (IExpr)F.Sqr(F.Slot1)), F.C1D2, F.Times((IExpr)F.C1D2, n))))));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new TDistribution(n.evalDouble()).inverseCumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.List(F.list(F.Times((IExpr)F.CN1, (IExpr)F.Sqrt(n), (IExpr)F.Sqrt(F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.InverseBetaRegularized(F.Times((IExpr)F.C2, (IExpr)F.Slot1), F.Times((IExpr)F.C1D2, n), F.C1D2), F.CN1)))), F.Less(F.C0, F.Slot1, F.C1D2)), F.list(F.C0, F.Equal((IExpr)F.Slot1, (IExpr)F.C1D2)), F.list(F.Times((IExpr)F.Sqrt(n), (IExpr)F.Sqrt(F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.InverseBetaRegularized(F.Times((IExpr)F.C2, (IExpr)F.Subtract(F.C1, F.Slot1)), F.Times((IExpr)F.C1D2, n), F.C1D2), F.CN1)))), F.Less(F.C1D2, F.Slot1, F.C1)), F.list(F.Negate(F.oo), F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new TDistribution(n.evalDouble()).density(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Times((IExpr)F.Power((IExpr)F.Times(n, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Sqr(F.Slot1), n), F.CN1)), F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.C1, n))), (IExpr)F.Power((IExpr)F.Times((IExpr)F.Sqrt(n), (IExpr)F.Beta(F.Times((IExpr)F.C1D2, n), F.C1D2)), F.CN1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                return F.Piecewise(F.list(F.list(F.Divide(n, F.Plus((IExpr)F.CN2, n)), F.Greater(n, F.C2))), S.Indeterminate);
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                return F.Piecewise(F.list(F.list(F.C0, F.Greater(n, F.C3))), S.Indeterminate);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Standardize
    extends AbstractEvaluator {
        private Standardize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            int[] dim = arg1.isMatrix();
            if (dim == null && arg1.isListOfLists()) {
                return F.NIL;
            }
            if (dim != null) {
                IExpr temp = arg1.mapMatrixColumns(dim, v -> F.Standardize(v));
                return temp.ifPresent(x -> F.Transpose(x));
            }
            IExpr sd = S.StandardDeviation.of(engine, arg1);
            if (!sd.isZero()) {
                return engine.evaluate(F.Divide(F.Subtract(arg1, F.Mean(arg1)), sd));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class StandardDeviation
    extends AbstractFunctionEvaluator
    implements StandardDeviationRules {
        private StandardDeviation() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList()) {
                IAST arg1 = (IAST)ast.arg1();
                int[] dim = arg1.isMatrix();
                if (dim == null) {
                    int length = arg1.isVector();
                    if (length > 0) {
                        if (arg1.isRealVector()) {
                            double[] values = arg1.toDoubleVector();
                            if (values == null) {
                                return F.NIL;
                            }
                            org.hipparchus.stat.descriptive.moment.StandardDeviation sd = new org.hipparchus.stat.descriptive.moment.StandardDeviation();
                            return F.num(sd.evaluate(values));
                        }
                    } else {
                        return F.NIL;
                    }
                }
                if (dim != null) {
                    return arg1.mapMatrixColumns(dim, x -> F.StandardDeviation(x));
                }
            }
            return F.Sqrt(F.Variance(ast.arg1()));
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            super.setUp(newSymbol);
        }
    }

    private static final class Skewness
    extends AbstractEvaluator {
        private Skewness() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IEvaluator evaluator;
            ISymbol head;
            IAST dist;
            IExpr arg1 = ast.arg1();
            if (arg1.isList()) {
                IAST list = (IAST)ast.arg1();
                return F.Divide(F.CentralMoment(list, F.C3), F.Power((IExpr)F.CentralMoment(list, F.C2), F.C3D2));
            }
            if (arg1.isAST() && (dist = (IAST)arg1).head().isSymbol() && (head = (ISymbol)dist.head()) instanceof IBuiltInSymbol && (evaluator = ((IBuiltInSymbol)head).getEvaluator()) instanceof IStatistics) {
                IStatistics distribution = (IStatistics)((Object)evaluator);
                return distribution.skewness(dist);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Rescale
    extends AbstractEvaluator {
        private Rescale() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr x = ast.arg1();
            if (ast.size() == 2 && x.isList()) {
                IExpr min = S.Min.of(engine, x);
                IExpr max = S.Max.of(engine, x);
                return Rescale.rescale(x, min, max, engine);
            }
            if (ast.size() >= 3) {
                if (ast.arg2().isAST(S.List, 3)) {
                    IAST list1 = (IAST)ast.arg2();
                    IExpr min = list1.first();
                    IExpr max = list1.second();
                    if (ast.size() == 4) {
                        if (ast.arg3().isAST(S.List, 3)) {
                            IAST list2 = (IAST)ast.arg3();
                            IExpr ymin = list2.first();
                            IExpr ymax = list2.second();
                            return engine.evaluate(F.Plus((IExpr)F.Times(x, F.Power((IExpr)F.Plus(max, F.Negate(min)), -1L), (IExpr)F.Plus(ymax, F.Negate(ymin))), (IExpr)F.Times((IExpr)F.CN1, F.Power((IExpr)F.Plus(max, F.Negate(min)), -1L), (IExpr)F.Plus((IExpr)F.Times(min, ymax), (IExpr)F.Times((IExpr)F.CN1, max, ymin)))));
                        }
                        return F.NIL;
                    }
                    return Rescale.rescale(x, min, max, engine);
                }
                return F.NIL;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        private static IExpr rescale(IExpr x, IExpr min, IExpr max, EvalEngine engine) {
            IExpr sum = engine.evaluate(F.Subtract(max, min));
            return engine.evaluate(F.Plus((IExpr)F.Times((IExpr)F.CN1, F.Power(sum, -1L), min), (IExpr)F.Times(F.Power(sum, -1L), x)));
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class RandomVariate
    extends AbstractEvaluator {
        private RandomVariate() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            block13: {
                IAST dist;
                if (ast.arg1().isAST() && (dist = (IAST)ast.arg1()).head().isSymbol()) {
                    try {
                        ISymbol head = (ISymbol)dist.head();
                        if (head instanceof IBuiltInSymbol) {
                            IEvaluator evaluator = ((IBuiltInSymbol)head).getEvaluator();
                            if (evaluator instanceof IRandomVariate) {
                                ThreadLocalRandom random = ThreadLocalRandom.current();
                                IRandomVariate variate = (IRandomVariate)((Object)evaluator);
                                if (ast.size() == 3) {
                                    IExpr arg2 = ast.arg2();
                                    if (arg2.isList()) {
                                        int[] indx = Validate.checkListOfInts(ast, arg2, 0, Integer.MAX_VALUE, engine);
                                        if (indx == null || indx.length == 0) {
                                            return F.NIL;
                                        }
                                        if (indx.length == 1) {
                                            if (indx[0] >= Config.MAX_AST_SIZE) {
                                                ASTElementLimitExceeded.throwIt(indx[0]);
                                            }
                                            return variate.randomVariate(random, dist, indx[0]);
                                        }
                                        int sampleSize = indx[indx.length - 1];
                                        System.arraycopy(indx, 0, indx, 1, indx.length - 1);
                                        IASTAppendable list = F.ListAlloc(indx[0]);
                                        return RandomVariate.createTensorRecursive(indx, 1, list, () -> variate.randomVariate(random, dist, sampleSize));
                                    }
                                    int n = arg2.toIntDefault();
                                    if (n >= 0) {
                                        if (n >= Config.MAX_AST_SIZE) {
                                            ASTElementLimitExceeded.throwIt(n);
                                        }
                                        return variate.randomVariate(random, dist, n);
                                    }
                                    return F.NIL;
                                }
                                return variate.randomVariate(random, dist, 1);
                            }
                            if (!(evaluator instanceof IDistribution)) {
                                return RandomVariate.printMessageUdist(head, ast, dist, engine);
                            }
                            break block13;
                        }
                        return RandomVariate.printMessageUdist(head, ast, dist, engine);
                    }
                    catch (RuntimeException ex) {
                        LOGGER.log(engine.getLogLevel(), "RandomVariate", (Throwable)ex);
                    }
                }
            }
            return F.NIL;
        }

        private static IExpr printMessageUdist(ISymbol head, IAST ast, IAST dist, EvalEngine engine) {
            if (head.getSymbolName().toLowerCase().endsWith("distribution")) {
                return IOFunctions.printMessage(ast.topHead(), "udist", F.list(dist), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private static IAST createTensorRecursive(int[] indx, int offset, IASTAppendable list, Supplier<IExpr> s) {
            if (indx.length <= offset) {
                list.append(s.get());
                return list;
            }
            if (indx[offset] >= Config.MAX_AST_SIZE) {
                ASTElementLimitExceeded.throwIt(indx[offset]);
            }
            IASTAppendable subList = F.ListAlloc(indx[offset]);
            for (int i = 1; i <= indx[offset]; ++i) {
                RandomVariate.createTensorRecursive(indx, offset + 1, subList, s);
            }
            list.append(subList);
            return subList;
        }
    }

    private static class Quartiles
    extends AbstractFunctionEvaluator {
        private static final IAST Q = F.list(F.C1D4, F.C1D2, F.C3D4);
        private static final IAST PARAMETER = F.list(F.list(F.C1D2, F.C0), F.list(F.C0, F.C1));

        private Quartiles() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isNonEmptyList() || arg1.isDistribution()) {
                IAST list = (IAST)arg1;
                if (ast.size() == 3) {
                    IExpr arg2 = ast.arg2();
                    int[] dimParameters = arg2.isMatrix();
                    if (dimParameters == null || dimParameters[0] != 2 || dimParameters[1] != 2) {
                        return F.NIL;
                    }
                    return F.Quantile(list, Q, arg2);
                }
                return F.Quantile(list, Q, PARAMETER);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Quantile
    extends AbstractFunctionEvaluator
    implements QuantileRules {
        private Quantile() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr function;
            IExpr arg1 = ast.arg1();
            int[] dim = arg1.isMatrix();
            if (dim == null && arg1.isListOfLists()) {
                return F.NIL;
            }
            if (dim != null) {
                return arg1.mapMatrixColumns(dim, x -> ast.setAtCopy(1, (IExpr)x));
            }
            int dimension = arg1.isVector();
            if (dimension >= 0 || arg1.isList()) {
                IExpr normal = arg1.normal(false);
                if (normal.isList()) {
                    IAST list = (IAST)normal;
                    IExpr a = F.C0;
                    IExpr b = F.C0;
                    IExpr c = F.C1;
                    IExpr d = F.C0;
                    if (ast.size() == 4) {
                        IExpr arg3 = ast.arg3();
                        int[] dimParameters = arg3.isMatrix();
                        if (dimParameters == null || dimParameters[0] != 2 || dimParameters[1] != 2) {
                            return F.NIL;
                        }
                        a = arg3.first().first();
                        b = arg3.first().second();
                        c = arg3.second().first();
                        d = arg3.second().second();
                    }
                    int dim1 = list.argSize();
                    try {
                        if (dim1 == 0) {
                            return IOFunctions.printMessage(ast.topHead(), "empt", F.list(list), engine);
                        }
                        if (dim1 > 0 && ast.size() >= 3) {
                            IAST s = EvalAttributes.copySortLess(list);
                            IInteger length = F.ZZ(s.argSize());
                            IExpr q = ast.arg2();
                            int dim2 = q.isVector();
                            if (dim2 >= 0 && q.isList()) {
                                IAST vector = (IAST)q;
                                return vector.mapThread(ast, 2);
                            }
                            if (q.isReal()) {
                                int index;
                                IExpr x2;
                                ISignedNumber qi = (ISignedNumber)q;
                                if (!qi.isRange(F.C0, F.C1)) {
                                    return IOFunctions.printMessage(ast.topHead(), "nquan", F.list(qi, F.C0, F.C1), engine);
                                }
                                IExpr iExpr = x2 = q.isZero() ? a : S.Plus.of(engine, a, F.Times((IExpr)F.Plus((IExpr)length, b), q));
                                if (x2.isNumIntValue() && (index = x2.toIntDefault()) != Integer.MIN_VALUE) {
                                    if (index < 1) {
                                        index = 1;
                                    } else if (index > s.argSize()) {
                                        index = s.argSize();
                                    }
                                    return s.get(index);
                                }
                                if (x2.isReal()) {
                                    ISignedNumber xi = (ISignedNumber)x2;
                                    int xFloor = xi.floorFraction().toIntDefault();
                                    int xCeiling = xi.ceilFraction().toIntDefault();
                                    if (xFloor != Integer.MIN_VALUE && xCeiling != Integer.MIN_VALUE) {
                                        if (xFloor < 1) {
                                            xFloor = 1;
                                        }
                                        if (xCeiling > s.argSize()) {
                                            xCeiling = s.argSize();
                                        }
                                        IExpr factor = d.isZero() || xi.isZero() ? c : S.Plus.of(engine, c, F.Times(d, (IExpr)xi.fractionalPart()));
                                        return F.Plus(s.get(xFloor), (IExpr)F.Times((IExpr)F.Subtract(s.get(xCeiling), s.get(xFloor)), factor));
                                    }
                                }
                            }
                        }
                    }
                    catch (ArithmeticException ae) {
                        LOGGER.debug("Quantile.evaluate() failed", (Throwable)ae);
                    }
                }
            } else if (arg1.isDistribution() && ast.size() >= 3 && (function = engine.evaluate(F.Quantile(arg1))).isFunction()) {
                if (ast.arg2().isList()) {
                    return ((IAST)ast.arg2()).map(x -> F.unaryAST1(function, x), 1);
                }
                return F.unaryAST1(function, ast.arg2());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            super.setUp(newSymbol);
        }
    }

    private static final class PoissonDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDiscreteDistribution,
    IPDF,
    IStatistics,
    IRandomVariate {
        private PoissonDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST1()) {
                return dist.arg1();
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr p = dist.arg1();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.GammaRegularized(F.Plus((IExpr)F.C1, (IExpr)F.Floor(F.Slot1)), p), F.GreaterEqual((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr p = dist.arg1();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power(p, F.Slot1), (IExpr)F.Power((IExpr)F.Times((IExpr)F.Exp(p), (IExpr)F.Factorial(F.Slot1)), F.CN1)), F.GreaterEqual((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST1()) {
                return dist.arg1();
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                return F.Divide(F.C1, F.Sqrt(n));
            }
            return F.NIL;
        }

        @Override
        public int getSupportUpperBound(IExpr discreteDistribution) {
            return 1950;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            if (dist.isAST1()) {
                double mean = dist.arg1().evalDouble();
                RandomDataGenerator rdg = new RandomDataGenerator();
                int[] vector = rdg.nextDeviates((IntegerDistribution)new org.hipparchus.distribution.discrete.PoissonDistribution(mean), size);
                return F.List(vector);
            }
            return F.NIL;
        }
    }

    private static final class ParetoDistribution
    extends AbstractEvaluator
    implements IContinuousDistribution,
    IStatistics,
    IPDF,
    ICDF {
        private ParetoDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IAST checkParameters(IAST dist) {
            if (dist.isAST2()) {
                return dist;
            }
            if (dist.isAST3()) {
                return dist;
            }
            if (dist.argSize() == 4) {
                return dist;
            }
            return F.NIL;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST2()) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IAST function = F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Plus((IExpr)F.CN1, a), F.CN1), a, k), F.Greater(a, F.C1))), F.Indeterminate);
                return function;
            }
            if (dist.isAST3()) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IExpr m = dist.arg3();
                IAST function = F.Piecewise(F.list(F.list(F.Plus((IExpr)F.Times((IExpr)F.Power((IExpr)F.Plus((IExpr)F.CN1, a), F.CN1), k), m), F.Greater(a, F.C1))), F.Indeterminate);
                return function;
            }
            if (dist.argSize() == 4) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IExpr g = dist.arg3();
                IExpr m = dist.arg4();
                IAST function = F.Piecewise(F.list(F.list(F.Plus(m, (IExpr)F.Times(k, F.Power((IExpr)F.Gamma(a), F.CN1), F.Gamma(F.Subtract(a, g)), F.Gamma(F.Plus((IExpr)F.C1, g)))), F.Greater(a, g))), F.Indeterminate);
                return function;
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST2()) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IASTMutable function = F.Times((IExpr)F.Power((IExpr)F.C2, F.Power(a, F.CN1)), k);
                return function;
            }
            if (dist.isAST3()) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IExpr m = dist.arg3();
                IAST function = F.Plus((IExpr)F.Times((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.C2, F.Power(a, F.CN1))), k), m);
                return function;
            }
            if (dist.argSize() == 4) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IExpr g = dist.arg3();
                IExpr m = dist.arg4();
                IAST function = F.Plus((IExpr)F.Times((IExpr)F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.C2, F.Power(a, F.CN1))), g), k), m);
                return function;
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST2() || dist.isAST3()) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IAST function = F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Times((IExpr)F.Plus((IExpr)F.CN2, a), (IExpr)F.Sqr(F.Plus((IExpr)F.CN1, a))), F.CN1), a, (IExpr)F.Sqr(k)), F.Greater(a, F.C2))), F.Indeterminate);
                return function;
            }
            if (dist.argSize() == 4) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IExpr g = dist.arg3();
                IAST function = F.Piecewise(F.list(F.list(F.Times((IExpr)F.Sqr(k), (IExpr)F.Power((IExpr)F.Gamma(a), F.CN2), (IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqr(F.Gamma(F.Subtract(a, g))), (IExpr)F.Sqr(F.Gamma(F.Plus((IExpr)F.C1, g)))), (IExpr)F.Times((IExpr)F.Gamma(a), (IExpr)F.Gamma(F.Plus(a, (IExpr)F.Times((IExpr)F.CN2, g))), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C2, g)))))), F.Greater(a, F.Times((IExpr)F.C2, g)))), F.Indeterminate);
                return function;
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST2() || dist.isAST3()) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IAST function = F.Piecewise(F.list(F.list(F.Times(F.C2, F.Power((IExpr)F.Plus((IExpr)F.CN3, a), F.CN1), F.Sqrt(F.Times((IExpr)F.Power(a, F.CN1), (IExpr)F.Plus((IExpr)F.CN2, a))), F.Plus((IExpr)F.C1, a)), F.Greater(a, F.C3))), F.Indeterminate);
                return function;
            }
            if (dist.argSize() == 4) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IExpr g = dist.arg3();
                IExpr m = dist.arg4();
                IAST function = F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power(k, F.C3), (IExpr)F.Power((IExpr)F.Times((IExpr)F.Sqr(k), (IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sqr(F.Gamma(F.Subtract(a, g))), (IExpr)F.Sqr(F.Gamma(F.Plus((IExpr)F.C1, g)))), (IExpr)F.Times((IExpr)F.Gamma(a), (IExpr)F.Gamma(F.Plus(a, (IExpr)F.Times((IExpr)F.CN2, g))), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C2, g)))))), F.QQ(-3L, 2L)), (IExpr)F.Plus((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power((IExpr)F.Gamma(F.Subtract(a, g)), F.C3), (IExpr)F.Power((IExpr)F.Gamma(F.Plus((IExpr)F.C1, g)), F.C3)), (IExpr)F.Times(F.CN3, F.Gamma(a), F.Gamma(F.Plus(a, (IExpr)F.Times((IExpr)F.CN2, g))), F.Gamma(F.Subtract(a, g)), F.Gamma(F.Plus((IExpr)F.C1, g)), F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C2, g)))), (IExpr)F.Times((IExpr)F.Sqr(F.Gamma(a)), (IExpr)F.Gamma(F.Plus(a, (IExpr)F.Times((IExpr)F.CN3, g))), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C3, g)))))), F.Greater(a, F.Times((IExpr)F.C3, g)))), F.Indeterminate);
                return function;
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr x, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Subtract(F.C1, F.Power((IExpr)F.Times(k, (IExpr)F.Power((IExpr)F.Slot1, F.CN1)), a)), F.GreaterEqual((IExpr)F.Slot1, k))), F.C0));
                return this.callFunction(function, x);
            }
            if (dist.isAST3()) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IExpr m = dist.arg3();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Subtract(F.C1, F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.Power(k, F.CN1), (IExpr)F.Plus(F.Negate(m), (IExpr)F.Slot1))), F.Negate(a))), F.GreaterEqual((IExpr)F.Slot1, m))), F.C0));
                return this.callFunction(function, x);
            }
            if (dist.argSize() == 4) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IExpr g = dist.arg3();
                IExpr m = dist.arg4();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Subtract(F.C1, F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Power((IExpr)F.Times((IExpr)F.Power(k, F.CN1), (IExpr)F.Plus(F.Negate(m), (IExpr)F.Slot1)), F.Power(g, F.CN1))), F.Negate(a))), F.GreaterEqual((IExpr)F.Slot1, m))), F.C0));
                return this.callFunction(function, x);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr x, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Times(k, (IExpr)F.Power((IExpr)F.Power((IExpr)F.Subtract(F.C1, F.Slot1), F.Power(a, F.CN1)), F.CN1)), F.Less((IExpr)F.Slot1, F.C1))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, x);
            }
            if (dist.isAST3()) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IExpr m = dist.arg3();
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Plus(m, (IExpr)F.Times(k, (IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Subtract(F.C1, F.Slot1), F.Negate(F.Power(a, F.CN1)))))), F.Less(F.C0, F.Slot1, F.C1)), F.list(m, F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, x);
            }
            if (dist.argSize() == 4) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IExpr g = dist.arg3();
                IExpr m = dist.arg4();
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Plus(m, (IExpr)F.Times(k, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Subtract(F.C1, F.Slot1), F.Negate(F.Power(a, F.CN1)))), g))), F.Less(F.C0, F.Slot1, F.C1)), F.list(m, F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, x);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr x, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times(a, (IExpr)F.Power(k, a), (IExpr)F.Power((IExpr)F.Slot1, F.Subtract(F.CN1, a))), F.GreaterEqual((IExpr)F.Slot1, k))), F.C0));
                return this.callFunction(function, x);
            }
            if (dist.isAST3()) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IExpr m = dist.arg3();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times(a, (IExpr)F.Power(k, F.CN1), (IExpr)F.Power((IExpr)F.Times((IExpr)F.Power(k, F.CN1), (IExpr)F.Plus(k, F.Negate(m), (IExpr)F.Slot1)), F.Subtract(F.CN1, a))), F.GreaterEqual((IExpr)F.Slot1, m))), F.C0));
                return this.callFunction(function, x);
            }
            if (dist.argSize() == 4) {
                IExpr k = dist.arg1();
                IExpr a = dist.arg2();
                IExpr g = dist.arg3();
                IExpr m = dist.arg4();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times(a, F.Power((IExpr)F.Times((IExpr)F.Power(k, F.Power(g, F.CN1)), g), F.CN1), F.Power((IExpr)F.Plus(F.Negate(m), (IExpr)F.Slot1), F.Plus((IExpr)F.CN1, (IExpr)F.Power(g, F.CN1))), F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Power((IExpr)F.Times(k, (IExpr)F.Power((IExpr)F.Plus(F.Negate(m), (IExpr)F.Slot1), F.CN1)), F.Negate(F.Power(g, F.CN1)))), F.Subtract(F.CN1, a))), F.GreaterEqual((IExpr)F.Slot1, m))), F.C0));
                return this.callFunction(function, x);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_4;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class PDF
    extends AbstractFunctionEvaluator {
        private PDF() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 2 || ast.size() == 3) {
                try {
                    if (ast.arg1().isAST()) {
                        IAST dist = (IAST)ast.arg1();
                        IExpr xArg = F.NIL;
                        if (ast.isAST2()) {
                            xArg = ast.arg2();
                        }
                        if (dist.head().isSymbol()) {
                            IPDF pdf;
                            IEvaluator evaluator;
                            ISymbol head = (ISymbol)dist.head();
                            if (dist.head().isSymbol() && head instanceof IBuiltInSymbol && (evaluator = ((IBuiltInSymbol)head).getEvaluator()) instanceof IPDF && (dist = (pdf = (IPDF)((Object)evaluator)).checkParameters(dist)).isPresent()) {
                                return pdf.pdf(dist, xArg, engine);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("PDF.evaluate() failed", (Throwable)ex);
                }
            }
            return F.NIL;
        }
    }

    private static class Probability
    extends AbstractFunctionEvaluator {
        private Probability() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 3) {
                try {
                    if (ast.arg2().isList()) {
                        IExpr predicate = ast.arg1();
                        IAST data = (IAST)ast.arg2();
                        if (predicate.isFunction()) {
                            int sum = 0;
                            for (int i = 1; i < data.size(); ++i) {
                                if (!engine.evalTrue(predicate, data.get(i))) continue;
                                ++sum;
                            }
                            return F.QQ(sum, data.argSize());
                        }
                    } else if (ast.arg2().isAST(S.Distributed, 3)) {
                        IDiscreteDistribution dist;
                        int[] interval;
                        IExpr predicate = ast.arg1();
                        IExpr x = ast.arg2().first();
                        IExpr distribution = ast.arg2().second();
                        if (distribution.isList()) {
                            IAST data = (IAST)distribution;
                            int sum = 0;
                            for (int i = 1; i < data.size(); ++i) {
                                if (!engine.evalTrue(F.subst(predicate, F.Rule(x, data.get(i))))) continue;
                                ++sum;
                            }
                            return F.QQ(sum, data.argSize());
                        }
                        if (distribution.isDiscreteDistribution() && (interval = (dist = StatisticsFunctions.getDiscreteDistribution(distribution)).range(distribution, predicate, x)) != null) {
                            IExpr pdf = S.PDF.of(engine, distribution, x);
                            IASTAppendable sum = F.PlusAlloc(10);
                            for (int i = interval[0]; i <= interval[1]; ++i) {
                                if (!engine.evalTrue(F.subst(predicate, F.Rule(x, (IExpr)F.ZZ(i))))) continue;
                                sum.append(F.subst(pdf, F.Rule(x, (IExpr)F.ZZ(i))));
                            }
                            return sum;
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Probability.evaluate() failed", (Throwable)ex);
                }
            }
            return F.NIL;
        }
    }

    private static final class NormalDistribution
    extends AbstractEvaluator
    implements ICentralMoment,
    IContinuousDistribution,
    IStatistics,
    IRandomVariate,
    IPDF,
    ICDF {
        private NormalDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                return IOFunctions.printMessage(ast.topHead(), "argr", F.List(S.NormalDistribution, F.C2), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }

        @Override
        public IExpr centralMoment(IAST dist, IExpr n, EvalEngine engine) {
            IExpr b = F.C1;
            if (dist.isAST0() || dist.isAST2()) {
                if (dist.isAST2()) {
                    b = dist.arg2();
                }
                IExpr function = engine.evaluate(F.Times((IExpr)F.Power(b, n), (IExpr)F.Factorial2(F.Plus((IExpr)F.CN1, n))));
                return F.Piecewise(F.List(F.List(function, F.And((IExpr)F.Equal(F.Mod(n, F.C2), (IExpr)F.C0), (IExpr)F.GreaterEqual(n, F.C0)))), F.C0);
            }
            return F.NIL;
        }

        @Override
        public RealDistribution dist() {
            return new org.hipparchus.distribution.continuous.NormalDistribution(0.0, 1.0);
        }

        @Override
        public IAST checkParameters(IAST dist) {
            if (dist.isAST0()) {
                return dist;
            }
            if (dist.isAST2()) {
                double v = dist.arg2().toDoubleDefault();
                if (v <= 0.0) {
                    if (v != Double.MIN_VALUE) {
                        return IOFunctions.printMessage(S.NormalDistribution, "posprm", F.list(dist.arg2(), F.C2, dist), EvalEngine.get());
                    }
                    return F.NIL;
                }
                return dist;
            }
            return F.NIL;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST0()) {
                return F.C0;
            }
            if (dist.isAST2()) {
                return dist.arg1();
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST0()) {
                return F.C0;
            }
            if (dist.isAST2()) {
                return dist.arg1();
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST0()) {
                IAST function = F.Function(F.Times((IExpr)F.C1D2, (IExpr)F.Erfc(F.Times((IExpr)F.CN1, (IExpr)F.C1DSqrt2, (IExpr)F.Slot1))));
                return this.callFunction(function, k);
            }
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.NormalDistribution(n.evalDouble(), m.evalDouble()).cumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Times((IExpr)F.C1D2, (IExpr)F.Erfc(F.Times((IExpr)F.Power((IExpr)F.Times((IExpr)F.CSqrt2, m), F.CN1), (IExpr)F.Plus(F.Negate(F.Slot1), n)))));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST0()) {
                IAST function = F.Function(F.ConditionalExpression(F.Times((IExpr)F.CN1, (IExpr)F.CSqrt2, (IExpr)F.InverseErfc(F.Times((IExpr)F.C2, (IExpr)F.Slot1))), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.NormalDistribution(n.evalDouble(), m.evalDouble()).inverseCumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.ConditionalExpression(F.Plus(n, (IExpr)F.Times(F.CN1, F.CSqrt2, m, F.InverseErfc(F.Times((IExpr)F.C2, (IExpr)F.Slot1)))), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST0()) {
                IAST function = F.Function(F.Power((IExpr)F.Times((IExpr)F.Exp(F.Times((IExpr)F.C1D2, (IExpr)F.Sqr(F.Slot1))), (IExpr)F.Sqrt(F.C2Pi)), F.CN1));
                return this.callFunction(function, k);
            }
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.NormalDistribution(n.evalDouble(), m.evalDouble()).density(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Power((IExpr)F.Times((IExpr)F.Exp(F.Times((IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Sqr(m)), F.CN1), (IExpr)F.Sqr(F.Plus(F.Negate(n), (IExpr)F.Slot1)))), m, (IExpr)F.Sqrt(F.C2Pi)), F.CN1));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST0()) {
                return F.C1;
            }
            if (dist.isAST2()) {
                return F.Sqr(dist.arg2());
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST0()) {
                return F.C0;
            }
            if (dist.isAST2()) {
                return F.C0;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            if (dist.isAST0()) {
                return F.num(random.nextGaussian());
            }
            if (dist.isAST2()) {
                double mean = dist.arg1().evalDouble();
                double sigma = dist.arg2().evalDouble();
                if (sigma > 0.0) {
                    RandomDataGenerator rdg = new RandomDataGenerator();
                    double[] vector = rdg.nextDeviates((RealDistribution)new org.hipparchus.distribution.continuous.NormalDistribution(mean, sigma), size);
                    return new ASTRealVector(vector, false);
                }
            }
            return F.NIL;
        }
    }

    private static final class NakagamiDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDistribution,
    IPDF,
    IStatistics {
        private NakagamiDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Divide(F.Times((IExpr)F.Sqrt(m), (IExpr)F.Pochhammer(n, F.C1D2)), F.Sqrt(n));
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Sqrt(F.Times(m, F.Power(n, -1L), (IExpr)F.InverseGammaRegularized(n, F.C0, F.C1D2)));
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.NakagamiDistribution(n.evalDouble(), m.evalDouble()).cumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.GammaRegularized(n, F.C0, F.Times((IExpr)F.Power(m, F.CN1), n, (IExpr)F.Sqr(F.Slot1))), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.NakagamiDistribution(n.evalDouble(), m.evalDouble()).inverseCumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Sqrt(F.Times(m, (IExpr)F.Power(n, F.CN1), (IExpr)F.InverseGammaRegularized(n, F.C0, F.Slot1))), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.C0, F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.NakagamiDistribution(n.evalDouble(), m.evalDouble()).density(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times(F.C2, F.Power((IExpr)F.Times((IExpr)F.Power(m, F.CN1), n), n), F.Power((IExpr)F.Times((IExpr)F.Exp(F.Times((IExpr)F.Power(m, F.CN1), n, (IExpr)F.Sqr(F.Slot1))), (IExpr)F.Gamma(n)), F.CN1), F.Power((IExpr)F.Slot1, F.Plus((IExpr)F.CN1, (IExpr)F.Times((IExpr)F.C2, n)))), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Subtract(m, F.Divide(F.Times(m, (IExpr)F.Sqr(F.Pochhammer(n, F.C1D2))), n));
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                return F.Times((IExpr)F.Pochhammer(n, F.C1D2), (IExpr)F.Plus((IExpr)F.C1D2, (IExpr)F.Times((IExpr)F.CN2, (IExpr)F.Subtract(n, F.Sqr(F.Pochhammer(n, F.C1D2))))), (IExpr)F.Power((IExpr)F.Subtract(n, F.Sqr(F.Pochhammer(n, F.C1D2))), F.QQ(-3L, 2L)));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Median
    extends AbstractTrigArg1 {
        private Median() {
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IAST list;
            IExpr normal;
            if (arg1.isRealVector()) {
                double[] values = arg1.toDoubleVector();
                if (values == null) {
                    return F.NIL;
                }
                return F.num(StatUtils.percentile((double[])values, (double)50.0));
            }
            if (arg1.isAST(S.WeightedData, 3) && arg1.first().isList() && arg1.second().isList()) {
                return Median.median((IAST)arg1, engine);
            }
            int[] dim = arg1.isMatrix();
            if (dim == null && arg1.isListOfLists()) {
                return F.NIL;
            }
            if (dim != null) {
                return arg1.mapMatrixColumns(dim, x -> F.Median(x));
            }
            int dimension = arg1.isVector();
            if ((dimension >= 0 || arg1.isList()) && (normal = arg1.normal(false)).isList() && (list = (IAST)normal).size() > 1) {
                IAST sortedList = EvalAttributes.copySortLess(list);
                int size = sortedList.size();
                if ((size & 1) == 1) {
                    return F.Times((IExpr)F.Plus(sortedList.get(size /= 2), sortedList.get(size + 1)), (IExpr)F.C1D2);
                }
                return sortedList.get(size / 2);
            }
            if (arg1.isDistribution()) {
                return StatisticsFunctions.getDistribution(arg1).median((IAST)arg1);
            }
            return F.NIL;
        }

        private static IExpr median(IAST weightedData, EvalEngine engine) {
            IAST data = (IAST)weightedData.arg1();
            IAST weights = (IAST)weightedData.arg2();
            int size = data.size();
            if (size > 1 && size == weights.size()) {
                IASTAppendable[] res = Median.sortWeightedData(data, weights, engine);
                data = res[0];
                weights = res[1];
                IExpr denominator = engine.evaluate(weights.apply((IExpr)S.Plus));
                IASTAppendable result = F.PlusAlloc(size);
                for (int i = 1; i < size; ++i) {
                    IASTAppendable rhs = F.PlusAlloc(size);
                    for (int j = 1; j <= i; ++j) {
                        rhs.append(F.Divide(weights.get(j), denominator));
                    }
                    IAST lhs = rhs.splice(rhs.argSize());
                    IExpr boole = engine.evaluate(F.Boole(F.Inequality(lhs, S.Less, F.C1D2, S.LessEqual, rhs)));
                    if (boole.isOne()) {
                        result.append(data.get(i));
                        continue;
                    }
                    if (boole.isZero()) continue;
                    result.append(F.Times(data.get(i), boole));
                }
                return result;
            }
            return F.NIL;
        }

        private static IASTAppendable[] sortWeightedData(IAST data, IAST weights, EvalEngine engine) {
            int size = data.size();
            ArrayIndexComparator comparator = new ArrayIndexComparator(data, engine);
            Integer[] indexes = comparator.createIndexArray();
            Arrays.sort(indexes, comparator);
            IASTAppendable newData = data.copyHead(size);
            IASTAppendable newWeights = weights.copyHead(size);
            IASTAppendable[] result = new IASTAppendable[]{newData, newWeights};
            for (int i = 0; i < indexes.length; ++i) {
                newData.append(data.get(indexes[i]));
                newWeights.append(weights.get(indexes[i]));
            }
            return result;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(0);
        }

        private static final class ArrayIndexComparator
        implements Comparator<Integer> {
            protected final IAST ast;
            protected EvalEngine engine;

            public ArrayIndexComparator(IAST ast, EvalEngine engine) {
                this.ast = ast;
                this.engine = engine;
            }

            public Integer[] createIndexArray() {
                int size = this.ast.size();
                Integer[] indexes = new Integer[size - 1];
                for (int i = 1; i < size; ++i) {
                    indexes[i - 1] = i;
                }
                return indexes;
            }

            @Override
            public int compare(Integer index1, Integer index2) {
                IExpr arg1 = this.ast.get(index1);
                IExpr arg2 = this.ast.get(index2);
                if (arg1.isNumericFunction(true) && arg2.isNumericFunction(true)) {
                    if (this.engine.evalGreater(arg1, arg2)) {
                        return 1;
                    }
                    if (this.engine.evalLess(arg1, arg2)) {
                        return -1;
                    }
                }
                return arg1.compareTo(arg2);
            }
        }
    }

    private static final class MeanDeviation
    extends AbstractFunctionEvaluator {
        private MeanDeviation() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            int[] dim = arg1.isMatrix();
            if (dim == null && arg1.isListOfLists()) {
                return F.NIL;
            }
            if (dim != null) {
                return arg1.mapMatrixColumns(dim, x -> F.MeanDeviation(x));
            }
            int length = arg1.isVector();
            if (length > 0) {
                if (arg1.isRealVector()) {
                    double[] values = arg1.toDoubleVector();
                    if (values == null) {
                        return F.NIL;
                    }
                    double mean = StatUtils.mean((double[])values);
                    double[] newValues = new double[length];
                    for (int i = 0; i < length; ++i) {
                        newValues[i] = Math.abs(values[i] - mean);
                    }
                    return F.num(StatUtils.mean((double[])newValues));
                }
                if ((arg1 = arg1.normal(false)).isList()) {
                    IAST vector = (IAST)arg1;
                    int size = vector.size();
                    IASTAppendable sum = F.PlusAlloc(size);
                    IExpr mean = S.Mean.of(engine, F.Negate(vector));
                    vector.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> sum.append(F.Abs(F.Plus(x, mean)))));
                    return F.Times(F.Power((IExpr)F.ZZ(size - 1), -1L), (IExpr)sum);
                }
                return F.NIL;
            }
            if (arg1.isNumber()) {
                return IOFunctions.printMessage(ast.topHead(), "rectt", F.list(F.C1, ast), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(0);
        }
    }

    private static final class Mean
    extends AbstractTrigArg1 {
        private Mean() {
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            try {
                if (arg1.isRealVector()) {
                    double[] values = arg1.toDoubleVector();
                    if (values == null) {
                        return F.NIL;
                    }
                    return F.num(StatUtils.mean((double[])values));
                }
                if (arg1.isList()) {
                    IAST list = (IAST)arg1;
                    return F.Times((IExpr)list.apply((IExpr)S.Plus), (IExpr)F.Power((IExpr)F.ZZ(list.argSize()), F.CN1));
                }
                if (arg1.isDistribution()) {
                    return StatisticsFunctions.getDistribution(arg1).mean((IAST)arg1);
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Mean.evaluateArg1() failed", (Throwable)ex);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(0);
        }
    }

    private static final class LogNormalDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDistribution,
    IPDF,
    IStatistics,
    IRandomVariate {
        private LogNormalDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST2()) {
                IExpr m = dist.arg1();
                IExpr s = dist.arg2();
                return F.Power((IExpr)S.E, F.Plus(m, (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Sqr(s))));
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST2()) {
                return F.Power((IExpr)S.E, dist.arg1());
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.LogNormalDistribution(n.evalDouble(), m.evalDouble()).cumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.C1D2, (IExpr)F.Erfc(F.Times((IExpr)F.Power((IExpr)F.Times((IExpr)F.CSqrt2, m), F.CN1), (IExpr)F.Subtract(n, F.Log(F.Slot1))))), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.LogNormalDistribution(n.evalDouble(), m.evalDouble()).inverseCumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Exp(F.Plus(n, (IExpr)F.Times(F.CN1, F.CSqrt2, m, F.InverseErfc(F.Times((IExpr)F.C2, (IExpr)F.Slot1))))), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.C0, F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.LogNormalDistribution(n.evalDouble(), m.evalDouble()).density(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Power((IExpr)F.Times(F.Exp(F.Times((IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Sqr(m)), F.CN1), (IExpr)F.Sqr(F.Plus(F.Negate(n), (IExpr)F.Log(F.Slot1))))), F.Slot1, m, F.Sqrt(F.C2Pi)), F.CN1), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST2()) {
                IExpr m = dist.arg1();
                IExpr s = dist.arg2();
                return F.Times((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)S.E, F.Sqr(s))), (IExpr)F.Power((IExpr)S.E, F.Plus((IExpr)F.Times((IExpr)F.C2, m), (IExpr)F.Sqr(s))));
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Times((IExpr)F.Sqrt(F.Plus((IExpr)F.CN1, (IExpr)F.Exp(F.Sqr(m)))), (IExpr)F.Plus((IExpr)F.C2, (IExpr)F.Exp(F.Sqr(m))));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            if (dist.isAST2()) {
                double mean = dist.arg1().evalDouble();
                double sigma = dist.arg2().evalDouble();
                if (sigma > 0.0) {
                    RandomDataGenerator rdg = new RandomDataGenerator();
                    double[] vector = rdg.nextDeviates((RealDistribution)new org.hipparchus.distribution.continuous.LogNormalDistribution(mean, sigma), size);
                    return new ASTRealVector(vector, false);
                }
            }
            return F.NIL;
        }
    }

    private static final class Kurtosis
    extends AbstractEvaluator {
        private Kurtosis() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                return F.Divide(F.CentralMoment(list, F.C4), F.Power((IExpr)F.CentralMoment(list, F.C2), F.C2));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class KolmogorovSmirnovTest
    extends AbstractFunctionEvaluator {
        private KolmogorovSmirnovTest() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    double[] data1 = ast.arg1().toDoubleVector();
                    if (data1 != null && data1.length > 0) {
                        org.hipparchus.stat.inference.KolmogorovSmirnovTest test = new org.hipparchus.stat.inference.KolmogorovSmirnovTest();
                        double d = test.kolmogorovSmirnovTest((RealDistribution)new org.hipparchus.distribution.continuous.NormalDistribution(), data1, false);
                        return F.num(d);
                    }
                } else if (ast.size() == 3 || ast.size() == 4) {
                    double[] data1;
                    int len1;
                    int property = 0;
                    if (ast.size() == 4) {
                        IExpr arg3 = ast.arg3();
                        if (!arg3.isString()) {
                            return F.NIL;
                        }
                        IStringX str = (IStringX)arg3;
                        if (str.toString().equals("PValue")) {
                            property = 0;
                        } else if (str.toString().equals("TestData")) {
                            property = 1;
                        } else {
                            return F.NIL;
                        }
                    }
                    if ((len1 = ast.arg1().isVector()) > 0 && (data1 = ast.arg1().toDoubleVector()) != null) {
                        RealDistribution dist;
                        IEvaluator evaluator;
                        int len2 = ast.arg2().isVector();
                        if (len2 > 0) {
                            double[] data2 = ast.arg2().toDoubleVector();
                            if (data2 != null) {
                                org.hipparchus.stat.inference.KolmogorovSmirnovTest test = new org.hipparchus.stat.inference.KolmogorovSmirnovTest();
                                switch (property) {
                                    case 0: {
                                        double p = test.kolmogorovSmirnovTest(data1, data2, false);
                                        return F.num(p);
                                    }
                                    case 1: {
                                        double p = test.kolmogorovSmirnovTest(data1, data2, false);
                                        double d = test.kolmogorovSmirnovStatistic(data1, data2);
                                        return new ASTRealVector(new double[]{d, p}, false);
                                    }
                                }
                            }
                            return F.NIL;
                        }
                        IExpr head = ast.arg2().head();
                        if (head instanceof IBuiltInSymbol && (evaluator = ((IBuiltInSymbol)head).getEvaluator()) instanceof IDistribution && (dist = ((IDistribution)((Object)evaluator)).dist()) != null) {
                            org.hipparchus.stat.inference.KolmogorovSmirnovTest test = new org.hipparchus.stat.inference.KolmogorovSmirnovTest();
                            switch (property) {
                                case 0: {
                                    double p = test.kolmogorovSmirnovTest(dist, data1, false);
                                    return F.num(p);
                                }
                                case 1: {
                                    double p = test.kolmogorovSmirnovTest(dist, data1, false);
                                    double d = test.kolmogorovSmirnovStatistic(dist, data1);
                                    return new ASTRealVector(new double[]{d, p}, false);
                                }
                            }
                        }
                    }
                }
            }
            catch (MathRuntimeException mre) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)mre);
            }
            return F.NIL;
        }
    }

    private static final class InterquartileRange
    extends AbstractFunctionEvaluator
    implements InterquartileRangeRules {
        private InterquartileRange() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            int length = arg1.isVector();
            if (length > 0) {
                IExpr resultQuartiles = engine.evaluate(F.Quartiles(arg1));
                if (resultQuartiles.isList3()) {
                    return F.Subtract(resultQuartiles.getAt(3), resultQuartiles.getAt(1));
                }
            } else if (arg1.isDistribution()) {
                return F.Subtract(F.Quantile(arg1, F.C3D4), F.Quantile(arg1, F.C1D4));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            super.setUp(newSymbol);
        }
    }

    private static final class ExponentialDistribution
    extends AbstractEvaluator
    implements ICDF,
    IContinuousDistribution,
    IPDF,
    IStatistics,
    IRandomVariate {
        private ExponentialDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST1()) {
                return F.Power(dist.arg1(), F.CN1);
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST1()) {
                return F.Times((IExpr)F.Log(F.C2), (IExpr)F.Power(dist.arg1(), F.CN1));
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST1()) {
                return F.Power(dist.arg1(), F.CN2);
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST1()) {
                return F.C2;
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        double x = k.evalDouble();
                        if (x <= 0.0) {
                            return F.CD0;
                        }
                        return F.num(1.0 - Math.exp(-x * n.evalDouble()));
                    }
                    catch (RuntimeException x) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Subtract(F.C1, F.Exp(F.Times((IExpr)F.CN1, (IExpr)F.Slot1, n))), F.GreaterEqual((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        double x = k.evalDouble();
                        if (F.isEqual(x, 1.0)) {
                            return F.CInfinity;
                        }
                        return F.num(-Math.log(1.0 - x) / n.evalDouble());
                    }
                    catch (RuntimeException x) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Times((IExpr)F.CN1, (IExpr)F.Power(n, F.CN1), (IExpr)F.Log(F.Subtract(F.C1, F.Slot1))), F.Less((IExpr)F.Slot1, F.C1))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Exp(F.Times((IExpr)F.Slot1, n)), F.CN1), n), F.GreaterEqual((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            double rate;
            if (dist.isAST1() && (rate = dist.arg1().evalDouble()) > 0.0) {
                RandomDataGenerator rdg = new RandomDataGenerator();
                double[] vector = rdg.nextDeviates((RealDistribution)new org.hipparchus.distribution.continuous.ExponentialDistribution(rate), size);
                return new ASTRealVector(vector, false);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Expectation
    extends AbstractFunctionEvaluator {
        private Expectation() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 3) {
                try {
                    IExpr xExpr = ast.arg1();
                    if (xExpr.isFunction() && ast.arg2().isList()) {
                        IAST data = (IAST)ast.arg2();
                        IASTAppendable sum = F.PlusAlloc(data.size());
                        for (int i = 1; i < data.size(); ++i) {
                            sum.append(F.unaryAST1(xExpr, data.get(i)));
                        }
                        return sum.divide(F.ZZ(data.argSize()));
                    }
                    if (ast.arg2().isAST(S.Distributed, 3)) {
                        IExpr pdf;
                        IExpr x = ast.arg2().first();
                        IExpr distribution = ast.arg2().second();
                        if (distribution.isList()) {
                            IAST data = (IAST)distribution;
                            IASTAppendable sum = F.PlusAlloc(data.size());
                            for (int i = 1; i < data.size(); ++i) {
                                sum.append(F.subst(xExpr, F.Rule(x, data.get(i))));
                            }
                            return sum.divide(F.ZZ(data.argSize()));
                        }
                        if (distribution.isContinuousDistribution() && (pdf = S.PDF.of(engine, distribution, x)).isFree(S.Piecewise)) {
                            return F.Integrate(F.Times(ast.arg1(), pdf), F.list(x, F.CNInfinity, F.CInfinity));
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Expectation.evaluate() failed", (Throwable)ex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class ErlangDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDistribution,
    IPDF,
    IStatistics {
        private ErlangDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST2()) {
                return F.Divide(dist.arg1(), dist.arg2());
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Times(F.Power(m, -1L), (IExpr)F.InverseGammaRegularized(n, F.C0, F.C1D2));
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.GammaRegularized(n, F.C0, F.Times((IExpr)F.Slot1, m)), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power(m, F.CN1), (IExpr)F.InverseGammaRegularized(n, F.C0, F.Slot1)), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.C0, F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power(m, n), (IExpr)F.Power((IExpr)F.Times((IExpr)F.Exp(F.Times((IExpr)F.Slot1, m)), (IExpr)F.Gamma(n)), F.CN1), (IExpr)F.Power((IExpr)F.Slot1, F.Plus((IExpr)F.CN1, n))), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST2()) {
                return F.Divide(dist.arg1(), F.Sqr(dist.arg2()));
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Divide(F.C2, F.Sqrt(n));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class DiscreteUniformDistribution
    extends AbstractEvaluator
    implements IDiscreteDistribution,
    IStatistics,
    ICDF,
    IPDF,
    IRandomVariate {
        private DiscreteUniformDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public IExpr mean(IAST dist) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                return F.Times((IExpr)F.C1D2, (IExpr)F.Plus(minMax[0], minMax[1]));
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                IExpr l = minMax[0];
                IExpr r = minMax[1];
                return F.Plus((IExpr)F.CN1, l, (IExpr)F.Max(F.C1, F.Ceiling(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.C1, F.Negate(l), r)))));
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                return F.Times((IExpr)F.QQ(1L, 12L), (IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Sqr(F.Plus((IExpr)F.C1, minMax[1], F.Negate(minMax[0])))));
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                return F.C0;
            }
            return F.NIL;
        }

        public IExpr[] minmax(IAST dist) {
            IAST list;
            if (dist.size() == 2 && dist.arg1().isList() && (list = (IAST)dist.arg1()).isAST2()) {
                IExpr min = list.arg1();
                IExpr max = list.arg2();
                return new IExpr[]{min, max};
            }
            return null;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                IExpr a = minMax[0];
                IExpr b = minMax[1];
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, F.Negate(a), b), F.CN1), (IExpr)F.Plus((IExpr)F.C1, F.Negate(a), (IExpr)F.Floor(F.Slot1))), F.And((IExpr)F.LessEqual(a, F.Slot1), (IExpr)F.Less((IExpr)F.Slot1, b))), F.list(F.C1, F.GreaterEqual((IExpr)F.Slot1, b))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                IExpr a = minMax[0];
                IExpr b = minMax[1];
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Plus((IExpr)F.CN1, a, (IExpr)F.Max(F.C1, F.Ceiling(F.Times((IExpr)F.Slot1, (IExpr)F.Plus((IExpr)F.C1, F.Negate(a), b))))), F.Less(F.C0, F.Slot1, F.C1)), F.list(a, F.LessEqual((IExpr)F.Slot1, F.C0))), b), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null) {
                IExpr a = minMax[0];
                IExpr b = minMax[1];
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Power((IExpr)F.Plus((IExpr)F.C1, F.Negate(a), b), F.CN1), F.LessEqual(a, F.Slot1, b))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            int max;
            int min;
            IExpr[] minMax = this.minmax(dist);
            if (minMax != null && (min = minMax[0].toIntDefault()) < (max = minMax[1].toIntDefault()) && min != Integer.MIN_VALUE) {
                RandomDataGenerator rdg = new RandomDataGenerator();
                int[] vector = rdg.nextDeviates((IntegerDistribution)new UniformIntegerDistribution(min, max), size);
                return F.List(vector);
            }
            return F.NIL;
        }
    }

    private static final class Covariance
    extends AbstractMatrix1Expr {
        private Covariance() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 2) {
                return super.evaluate(ast, engine);
            }
            try {
                if (ast.size() == 3 && ast.arg1().isAST() && ast.arg2().isAST()) {
                    IAST arg1 = (IAST)ast.arg1();
                    IAST arg2 = (IAST)ast.arg2();
                    return Covariance.evaluateArg2(arg1, arg2, engine);
                }
            }
            catch (MathRuntimeException mre) {
                LOGGER.log(engine.getLogLevel(), (Object)S.Covariance, (Throwable)mre);
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.debug("Covariance.evaluate() failed", (Throwable)e);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private static IExpr evaluateArg2(IAST arg1, IAST arg2, EvalEngine engine) {
            int arg2Length;
            int arg1Length = arg1.isVector();
            if (arg1Length > 1 && arg1Length == (arg2Length = arg2.isVector())) {
                if (engine.isNumericMode()) {
                    double[] arg1DoubleArray = arg1.toDoubleVector();
                    double[] arg2DoubleArray = arg2.toDoubleVector();
                    if (arg1DoubleArray != null && arg2DoubleArray != null) {
                        org.hipparchus.stat.correlation.Covariance cov = new org.hipparchus.stat.correlation.Covariance();
                        return F.num(cov.covariance(arg1DoubleArray, arg2DoubleArray, true));
                    }
                }
                return Covariance.vectorCovarianceSymbolic(arg1, arg2, arg1Length);
            }
            return F.NIL;
        }

        private static IExpr vectorCovarianceSymbolic(IAST arg1, IAST arg2, int arg1Length) {
            if (arg1Length == 2) {
                return F.Times((IExpr)F.C1D2, (IExpr)F.Subtract(arg1.arg1(), arg1.arg2()), (IExpr)F.Subtract(F.Conjugate(arg2.arg1()), F.Conjugate(arg2.arg2())));
            }
            IASTAppendable num1 = arg1.apply((IExpr)S.Plus);
            IInteger factor = F.ZZ(-1 * (arg1.size() - 2));
            IASTAppendable v1 = F.PlusAlloc(arg1.size());
            v1.appendArgs(arg1.size(), i -> F.Times((IExpr)F.CN1, (IExpr)num1.setAtCopy(i, F.Times(factor, arg1.get(i))), (IExpr)F.Conjugate(arg2.get(i))));
            return F.Divide(v1, F.ZZ((long)arg1.argSize() * ((long)arg1.size() - 2L)));
        }

        @Override
        public IExpr matrixEval(FieldMatrix<IExpr> matrix, Predicate<IExpr> zeroChecker) {
            return F.NIL;
        }

        @Override
        public IExpr numericEval(IAST ast, EvalEngine engine) {
            if (ast.size() == 2) {
                return super.numericEval(ast, engine);
            }
            if (ast.size() == 3 && ast.arg1().isAST() && ast.arg2().isAST()) {
                IAST arg1 = (IAST)ast.arg1();
                IAST arg2 = (IAST)ast.arg2();
                return Covariance.evaluateArg2(arg1, arg2, engine);
            }
            return F.NIL;
        }

        @Override
        public IExpr realMatrixEval(RealMatrix matrix) {
            org.hipparchus.stat.correlation.Covariance cov = new org.hipparchus.stat.correlation.Covariance(matrix);
            return new ASTRealMatrix(cov.getCovarianceMatrix(), false);
        }
    }

    private static final class HypergeometricDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDiscreteDistribution,
    IPDF,
    IStatistics,
    IRandomVariate {
        private HypergeometricDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        private int[] parameters(IAST hypergeometricDistribution) {
            if (hypergeometricDistribution.size() == 4) {
                int N2 = hypergeometricDistribution.arg1().toIntDefault(-1);
                int n = hypergeometricDistribution.arg2().toIntDefault(-1);
                int m_n = hypergeometricDistribution.arg3().toIntDefault(-1);
                if (N2 >= 0 && n >= 0 && m_n >= 0) {
                    int[] param = new int[]{N2, n, m_n};
                    return param;
                }
            }
            return null;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST3()) {
                int[] param = this.parameters(dist);
                if (param != null) {
                    return F.ZZ(param[0]).multiply(F.QQ(param[1], param[2]));
                }
                IExpr N2 = dist.arg1();
                IExpr n = dist.arg2();
                IExpr m_n = dist.arg3();
                return F.Divide(F.Times(N2, n), m_n);
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST3()) {
                IExpr n = dist.arg1();
                IExpr ns = dist.arg2();
                IExpr nt = dist.arg3();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Plus((IExpr)F.C1, (IExpr)F.Times(F.CN1, F.Factorial(ns), F.Factorial(F.Plus(F.Negate(ns), nt)), F.Power((IExpr)F.Times((IExpr)F.Binomial(nt, n), (IExpr)F.Factorial(F.Plus((IExpr)F.CN1, n, F.Negate(F.Floor(F.Slot1)))), (IExpr)F.Factorial(F.Plus((IExpr)F.CN1, ns, F.Negate(F.Floor(F.Slot1))))), F.CN1), F.HypergeometricPFQRegularized(F.list(F.C1, F.Plus((IExpr)F.C1, F.Negate(n), (IExpr)F.Floor(F.Slot1)), F.Plus((IExpr)F.C1, F.Negate(ns), (IExpr)F.Floor(F.Slot1))), F.list(F.Plus((IExpr)F.C2, (IExpr)F.Floor(F.Slot1)), F.Plus(F.C2, F.Negate(n), F.Negate(ns), nt, F.Floor(F.Slot1))), F.C1))), F.And(F.LessEqual((IExpr)F.C0, F.Slot1), F.LessEqual((IExpr)F.Plus(n, ns, F.Negate(nt)), F.Slot1), F.Less((IExpr)F.Slot1, n), F.Less((IExpr)F.Slot1, ns))), F.list(F.C1, F.Or((IExpr)F.GreaterEqual((IExpr)F.Slot1, n), (IExpr)F.GreaterEqual((IExpr)F.Slot1, ns)))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST3()) {
                IExpr n = dist.arg1();
                IExpr ns = dist.arg2();
                IExpr nt = dist.arg3();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Binomial(ns, F.Slot1), (IExpr)F.Power((IExpr)F.Binomial(nt, n), F.CN1), (IExpr)F.Binomial(F.Plus(F.Negate(ns), nt), F.Plus(F.Negate(F.Slot1), n))), F.And(F.LessEqual(F.C0, F.Slot1, n), F.LessEqual(F.Plus(n, ns, F.Negate(nt)), F.Slot1, n), F.LessEqual(F.C0, F.Slot1, ns), F.LessEqual(F.Plus(n, ns, F.Negate(nt)), F.Slot1, ns)))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST3()) {
                int[] param = this.parameters(dist);
                if (param != null) {
                    int N2 = param[0];
                    int n = param[1];
                    int m_n = param[2];
                    IFraction rd1 = F.QQ(m_n - n, m_n);
                    IFraction rd2 = F.QQ(m_n - N2, m_n);
                    IFraction rd3 = F.QQ(N2, m_n - 1);
                    IFraction rd4 = F.QQ(n, 1L);
                    return rd1.multiply(rd2).multiply(rd3).multiply(rd4);
                }
                IExpr N3 = dist.arg1();
                IExpr n = dist.arg2();
                IExpr mn = dist.arg3();
                return F.Times(F.Power((IExpr)F.Plus((IExpr)F.CN1, mn), -1L), F.Power(mn, -1L), n, F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, F.Power(mn, -1L), n)), F.Plus(mn, F.Negate(N3)), N3);
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            int[] param;
            if (dist.isAST3() && (param = this.parameters(dist)) != null) {
                return F.NIL;
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            int[] param;
            if (dist.isAST3() && (param = this.parameters(dist)) != null) {
                RandomDataGenerator rdg = new RandomDataGenerator();
                int[] vector = rdg.nextDeviates((IntegerDistribution)new org.hipparchus.distribution.discrete.HypergeometricDistribution(param[2], param[1], param[0]), size);
                return F.List(vector);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class HarmonicMean
    extends AbstractFunctionEvaluator {
        private HarmonicMean() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isNonEmptyList()) {
                IAST list = (IAST)arg1;
                int[] dim = list.isMatrix();
                if (dim == null && arg1.isListOfLists()) {
                    return F.NIL;
                }
                if (dim != null) {
                    return list.mapMatrixColumns(dim, x -> F.HarmonicMean(x));
                }
                IASTAppendable result = list.apply((IExpr)S.Plus);
                result.map((IASTMutable)result, x -> F.Divide(F.C1, x));
                return F.Times((IExpr)F.ZZ(list.argSize()), (IExpr)F.Power((IExpr)result, F.CN1));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class GumbelDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDistribution,
    IPDF,
    IStatistics,
    IRandomVariate {
        private GumbelDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST0()) {
                return S.EulerGamma.negate();
            }
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)S.EulerGamma, m), n);
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST0()) {
                return F.Log(F.Log(F.C2));
            }
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Plus(n, (IExpr)F.Times(m, (IExpr)F.Log(F.Log(F.C2))));
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        double z = (k.evalDouble() - n.evalDouble()) / m.evalDouble();
                        return F.num(1.0 - Math.exp(-Math.exp(z)));
                    }
                    catch (RuntimeException z) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Subtract(F.C1, F.Exp(F.Negate(F.Exp(F.Times((IExpr)F.Power(m, F.CN1), (IExpr)F.Plus(F.Negate(n), (IExpr)F.Slot1)))))));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        double p = k.evalDouble();
                        MathUtils.checkRangeInclusive((double)p, (double)0.0, (double)1.0);
                        if (F.isZero(p)) {
                            return F.CNInfinity;
                        }
                        if (F.isEqual(p, 1.0)) {
                            return F.CInfinity;
                        }
                        return F.num(n.evalDouble() + m.evalDouble() * Math.log(-Math.log(1.0 - p)));
                    }
                    catch (RuntimeException p) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Plus(n, (IExpr)F.Times(m, (IExpr)F.Log(F.Negate(F.Log(F.Subtract(F.C1, F.Slot1)))))), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.Negate(F.oo), F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                IAST function = F.Function(F.Times((IExpr)F.Exp(F.Plus(F.Negate(F.Exp(F.Times((IExpr)F.Power(m, F.CN1), (IExpr)F.Plus(F.Negate(n), (IExpr)F.Slot1)))), (IExpr)F.Times((IExpr)F.Power(m, F.CN1), (IExpr)F.Plus(F.Negate(n), (IExpr)F.Slot1)))), (IExpr)F.Power(m, F.CN1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST2()) {
                IExpr m = dist.arg2();
                return F.Times((IExpr)F.QQ(1L, 6L), (IExpr)F.Sqr(m), (IExpr)F.Sqr(S.Pi));
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST2()) {
                return F.Times(F.CN1, F.ZZ(12L), F.CSqrt6, F.Power((IExpr)F.Pi, F.CN3), F.Zeta(F.C3));
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            if (dist.isAST2()) {
                double n = dist.arg1().evalDouble();
                double m = dist.arg2().evalDouble();
                RandomDataGenerator rdg = new RandomDataGenerator();
                double[] vector = rdg.nextDeviates((RealDistribution)new org.hipparchus.distribution.continuous.GumbelDistribution(n, m), size);
                return new ASTRealVector(vector, false);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class GompertzMakehamDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDistribution,
    IPDF,
    IStatistics,
    IRandomVariate {
        private GompertzMakehamDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST2()) {
                IExpr m = dist.arg1();
                IExpr n = dist.arg2();
                return F.Times((IExpr)F.Exp(n), (IExpr)F.Power(m, F.CN1), (IExpr)F.Gamma(F.C0, n));
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST2()) {
                IExpr m = dist.arg1();
                IExpr n = dist.arg2();
                return F.Times((IExpr)F.Power(m, F.CN1), (IExpr)F.Log(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.Power(n, F.CN1), (IExpr)F.Log(F.C2)))));
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr m = dist.arg1();
                IExpr n = dist.arg2();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Subtract(F.C1, F.Exp(F.Times((IExpr)F.Subtract(F.C1, F.Exp(F.Times((IExpr)F.Slot1, m))), n))), F.GreaterEqual((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr m = dist.arg1();
                IExpr n = dist.arg2();
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power(m, F.CN1), (IExpr)F.Log(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power(n, F.CN1), (IExpr)F.Log(F.Subtract(F.C1, F.Slot1)))))), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.C0, F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr m = dist.arg1();
                IExpr n = dist.arg2();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Exp(F.Plus((IExpr)F.Times((IExpr)F.Slot1, m), (IExpr)F.Times((IExpr)F.Subtract(F.C1, F.Exp(F.Times((IExpr)F.Slot1, m))), n))), m, n), F.GreaterEqual((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST2()) {
                IExpr m = dist.arg1();
                IExpr n = dist.arg2();
                return F.Times(F.CN1, F.Exp(n), F.Power((IExpr)F.Times((IExpr)F.C6, (IExpr)F.Sqr(m)), F.CN1), F.Plus(F.Times((IExpr)F.CN6, (IExpr)F.Sqr(F.EulerGamma)), F.Negate(F.Sqr(F.Pi)), F.Times((IExpr)F.C6, (IExpr)F.Exp(n), (IExpr)F.Sqr(F.ExpIntegralEi(F.Negate(n)))), F.Times((IExpr)F.ZZ(12L), n, (IExpr)F.HypergeometricPFQ(F.list(F.C1, F.C1, F.C1), F.list(F.C2, F.C2, F.C2), F.Negate(n))), F.Times((IExpr)F.ZZ(-12L), (IExpr)F.EulerGamma, (IExpr)F.Log(n)), F.Times((IExpr)F.CN6, (IExpr)F.Sqr(F.Log(n)))));
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr iExpr = dist.arg2();
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            if (dist.isAST2()) {
                double lambda = dist.arg1().evalDouble();
                double xi = dist.arg2().evalDouble();
                double reference = random.nextDouble();
                double uniform = Math.nextUp(reference);
                double result = Math.log((xi - Math.log(uniform)) / xi) / lambda;
                return F.num(result);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class GeometricDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDiscreteDistribution,
    IPDF,
    IStatistics {
        private GeometricDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                return F.Plus((IExpr)F.CN1, (IExpr)F.Power(n, F.CN1));
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Subtract(F.C1, F.Power((IExpr)F.Subtract(F.C1, n), F.Plus((IExpr)F.C1, (IExpr)F.Floor(F.Slot1)))), F.GreaterEqual((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Subtract(F.C1, n), F.Slot1), n), F.GreaterEqual((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                return F.Times((IExpr)F.Subtract(F.C1, n), (IExpr)F.Power(n, F.CN2));
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST1()) {
                IExpr n = dist.arg1();
                return F.Times((IExpr)F.Power((IExpr)F.Subtract(F.C1, n), F.CN1D2), (IExpr)F.Subtract(F.C2, n));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class GeometricMean
    extends AbstractFunctionEvaluator {
        private GeometricMean() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isNonEmptyList()) {
                IAST list = (IAST)arg1;
                int[] dim = list.isMatrix();
                if (dim == null && arg1.isListOfLists()) {
                    return F.NIL;
                }
                if (dim != null) {
                    return list.mapMatrixColumns(dim, x -> F.GeometricMean(x));
                }
                if (arg1.isRealVector()) {
                    double[] arg1DoubleArray = arg1.toDoubleVector();
                    if (arg1DoubleArray == null) {
                        return F.NIL;
                    }
                    return F.num(StatUtils.geometricMean((double[])arg1DoubleArray));
                }
                return F.Power((IExpr)list.apply((IExpr)S.Times), F.fraction(1L, arg1.argSize()));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public IExpr numericEval(IAST ast, EvalEngine engine) {
            double[] values = ast.get(1).toDoubleVector();
            if (values == null) {
                return F.NIL;
            }
            return F.num(StatUtils.geometricMean((double[])values));
        }
    }

    private static final class GammaDistribution
    extends AbstractEvaluator
    implements ICentralMoment,
    IDistribution,
    IRandomVariate,
    IStatistics,
    IPDF,
    ICDF {
        private GammaDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr centralMoment(IAST dist, IExpr n, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                IExpr aMinus = a.negate();
                IExpr nMinus = n.negate();
                return F.Together(F.Times((IExpr)F.Power(b, n), (IExpr)F.Hypergeometric1F1(nMinus, F.Plus((IExpr)F.C1, aMinus, nMinus), aMinus), (IExpr)F.Pochhammer(a, n)));
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                if (!engine.isArbitraryMode() && (a.isNumericArgument() || b.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.GammaDistribution(a.evalDouble(), b.evalDouble()).cumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.GammaRegularized(a, F.C0, F.Times((IExpr)F.Power(b, F.CN1), (IExpr)F.Slot1)), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            if (dist.isAST(S.GammaDistribution, 5)) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                IExpr g = dist.arg3();
                IExpr d = dist.arg4();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.GammaRegularized(a, F.C0, F.Power((IExpr)F.Times((IExpr)F.Power(b, F.CN1), (IExpr)F.Plus(F.Negate(d), (IExpr)F.Slot1)), g)), F.Greater((IExpr)F.Slot1, d))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                if (!engine.isArbitraryMode() && (a.isNumericArgument() || b.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.GammaDistribution(a.evalDouble(), b.evalDouble()).inverseCumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Times(b, (IExpr)F.InverseGammaRegularized(a, F.C0, F.Slot1)), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.C0, F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            if (dist.isAST(S.GammaDistribution, 5)) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                IExpr g = dist.arg3();
                IExpr d = dist.arg4();
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Plus(d, (IExpr)F.Times(b, (IExpr)F.Power((IExpr)F.InverseGammaRegularized(a, F.C0, F.Slot1), F.Power(g, F.CN1)))), F.Less(F.C0, F.Slot1, F.C1)), F.list(d, F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Times(m, n);
            }
            if (dist.size() == 5) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                IExpr g = dist.arg3();
                IExpr d = dist.arg4();
                return F.Plus(d, (IExpr)F.Times(b, (IExpr)F.Power((IExpr)F.Gamma(a), F.CN1), (IExpr)F.Gamma(F.Plus(a, (IExpr)F.Power(g, F.CN1)))));
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Times(m, (IExpr)F.InverseGammaRegularized(n, F.C0, F.C1D2));
            }
            if (dist.size() == 5) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                IExpr g = dist.arg3();
                IExpr d = dist.arg4();
                return F.Plus(d, (IExpr)F.Times(b, (IExpr)F.Power((IExpr)F.InverseGammaRegularized(a, F.C1D2), F.Power(g, -1L))));
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            if (dist.isAST2()) {
                double a = dist.arg1().evalDouble();
                double b = dist.arg2().evalDouble();
                RandomDataGenerator rdg = new RandomDataGenerator();
                double[] vector = rdg.nextDeviates((RealDistribution)new org.hipparchus.distribution.continuous.GammaDistribution(a, b), size);
                return new ASTRealVector(vector, false);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Times((IExpr)F.Sqr(m), n);
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                return F.Divide(F.C2, F.Sqrt(n));
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                if (!engine.isArbitraryMode() && (a.isNumericArgument() || b.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.GammaDistribution(a.evalDouble(), b.evalDouble()).density(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Times((IExpr)F.Power(b, a), (IExpr)F.Exp(F.Times((IExpr)F.Power(b, F.CN1), (IExpr)F.Slot1)), (IExpr)F.Gamma(a)), F.CN1), (IExpr)F.Power((IExpr)F.Slot1, F.Plus((IExpr)F.CN1, a))), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            if (dist.isAST(S.GammaDistribution, 5)) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                IExpr g = dist.arg3();
                IExpr d = dist.arg4();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times(g, (IExpr)F.Power((IExpr)F.Times((IExpr)F.Exp(F.Power((IExpr)F.Times((IExpr)F.Power(b, F.CN1), (IExpr)F.Plus(F.Negate(d), (IExpr)F.Slot1)), g)), b, (IExpr)F.Gamma(a)), F.CN1), (IExpr)F.Power((IExpr)F.Times((IExpr)F.Power(b, F.CN1), (IExpr)F.Plus(F.Negate(d), (IExpr)F.Slot1)), F.Plus((IExpr)F.CN1, (IExpr)F.Times(a, g)))), F.Greater((IExpr)F.Slot1, d))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class FrechetDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDistribution,
    IPDF,
    IStatistics,
    IRandomVariate {
        private FrechetDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Piecewise(F.list(F.list(F.Times(m, (IExpr)F.Gamma(F.Subtract(F.C1, F.Power(n, F.CN1)))), F.Less((IExpr)F.C1, n))), F.CInfinity);
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Times(m, (IExpr)F.Power((IExpr)F.Log(F.C2), F.Negate(F.Power(n, -1L))));
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Exp(F.Negate(F.Power((IExpr)F.Times((IExpr)F.Power(m, F.CN1), (IExpr)F.Slot1), F.Negate(n)))), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Times(m, (IExpr)F.Power((IExpr)F.Power(F.Negate(F.Log(F.Slot1)), F.Power(n, F.CN1)), F.CN1)), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.C0, F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Times((IExpr)F.Exp(F.Power((IExpr)F.Times((IExpr)F.Power(m, F.CN1), (IExpr)F.Slot1), F.Negate(n))), m), F.CN1), n, (IExpr)F.Power((IExpr)F.Times((IExpr)F.Power(m, F.CN1), (IExpr)F.Slot1), F.Subtract(F.CN1, n))), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Piecewise(F.list(F.list(F.Times((IExpr)F.Sqr(m), (IExpr)F.Plus((IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN2, F.Power(n, -1L)))), F.Negate(F.Sqr(F.Gamma(F.Plus((IExpr)F.C1, F.Negate(F.Power(n, -1L)))))))), F.Greater(n, F.C2))), F.CInfinity);
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Piecewise(F.list(F.list(F.Times((IExpr)F.Plus((IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN3, (IExpr)F.Power(n, F.CN1)))), (IExpr)F.Times((IExpr)F.CN3, (IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN2, (IExpr)F.Power(n, F.CN1)))), (IExpr)F.Gamma(F.Subtract(F.C1, F.Power(n, F.CN1)))), (IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power((IExpr)F.Gamma(F.Subtract(F.C1, F.Power(n, F.CN1))), F.C3))), (IExpr)F.Power((IExpr)F.Subtract(F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN2, (IExpr)F.Power(n, F.CN1)))), F.Sqr(F.Gamma(F.Subtract(F.C1, F.Power(n, F.CN1))))), F.QQ(-3L, 2L))), F.Greater(n, F.C3))), F.oo);
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (n.isReal() && m.isReal()) {
                    double reference = random.nextDouble();
                    double uniform = reference >= NEXTDOWNONE ? NEXTDOWNONE : Math.nextUp(reference);
                    uniform = -Math.log(uniform);
                    return m.times(S.Power.of(F.num(uniform), n.reciprocal().negate()));
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class FRatioDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDistribution,
    IPDF,
    IStatistics {
        private FRatioDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Plus((IExpr)F.CN2, m), F.CN1), m), F.Greater(m, F.C2))), F.Indeterminate);
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                F.Times(m, (IExpr)F.Power(n, F.CN1), (IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.InverseBetaRegularized(F.C1, F.CN1D2, F.Times((IExpr)F.C1D2, m), F.Times((IExpr)F.C1D2, n)), F.CN1)));
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new FDistribution(n.evalDouble(), m.evalDouble()).cumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.BetaRegularized(F.Times(n, (IExpr)F.Power((IExpr)F.Plus(m, (IExpr)F.Times((IExpr)F.Slot1, n)), F.CN1), (IExpr)F.Slot1), F.Times((IExpr)F.C1D2, n), F.Times((IExpr)F.C1D2, m)), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new FDistribution(n.evalDouble(), m.evalDouble()).inverseCumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Times(m, (IExpr)F.Power(n, F.CN1), (IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.InverseBetaRegularized(F.C1, F.Negate(F.Slot1), F.Times((IExpr)F.C1D2, m), F.Times((IExpr)F.C1D2, n)), F.CN1))), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.C0, F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                if (!engine.isArbitraryMode() && (n.isNumericArgument() || m.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new FDistribution(n.evalDouble(), m.evalDouble()).density(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times(F.Power(m, F.Times((IExpr)F.C1D2, m)), F.Power(n, F.Times((IExpr)F.C1D2, n)), F.Power((IExpr)F.Plus(m, (IExpr)F.Times((IExpr)F.Slot1, n)), F.Times((IExpr)F.C1D2, (IExpr)F.Subtract(F.Negate(m), n))), F.Power((IExpr)F.Beta(F.Times((IExpr)F.C1D2, n), F.Times((IExpr)F.C1D2, m)), F.CN1), F.Power((IExpr)F.Slot1, F.Plus((IExpr)F.CN1, (IExpr)F.Times((IExpr)F.C1D2, n)))), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Piecewise(F.list(F.list(F.Times(F.C2, F.Sqr(m), F.Plus((IExpr)F.CN2, m, n), F.Power((IExpr)F.Times((IExpr)F.Plus((IExpr)F.CN4, m), (IExpr)F.Sqr(F.Plus((IExpr)F.CN2, m)), n), F.CN1)), F.Greater(m, F.C4))), F.Indeterminate);
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Piecewise(F.list(F.list(F.Times(F.C2, F.CSqrt2, F.Sqrt(F.Plus((IExpr)F.CN4, m)), F.Plus((IExpr)F.CN2, m, (IExpr)F.Times((IExpr)F.C2, n)), F.Power((IExpr)F.Times((IExpr)F.Plus((IExpr)F.CN6, m), (IExpr)F.Sqrt(n), (IExpr)F.Sqrt(F.Plus((IExpr)F.CN2, m, n))), F.CN1)), F.Greater(m, F.C6))), F.Indeterminate);
            }
            return F.NIL;
        }
    }

    private static final class FiveNum
    extends AbstractEvaluator {
        private FiveNum() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = ast.arg1().isVector();
            if (size >= 0) {
                IAST param = F.list(F.list(F.C1D2, F.C0), F.list(F.C0, F.C1));
                IExpr list = ast.arg1();
                IASTAppendable result = F.ListAlloc(5);
                result.append(F.Min(list));
                result.append(F.Quantile(list, F.C1D4, param));
                result.append(F.Median(list));
                result.append(F.Quantile(list, F.C3D4, param));
                result.append(F.Max(list));
                return result;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class CauchyDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDistribution,
    IPDF,
    IStatistics,
    IRandomVariate {
        private CauchyDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST0() || dist.isAST2()) {
                return S.Indeterminate;
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST0() || dist.isAST2()) {
                IExpr a = F.C0;
                if (dist.isAST2()) {
                    a = dist.arg1();
                }
                return a;
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST0() || dist.isAST2()) {
                IExpr a = F.C0;
                IExpr b = F.C1;
                if (dist.isAST2()) {
                    a = dist.arg1();
                    b = dist.arg2();
                }
                IAST function = F.Function(F.Plus((IExpr)F.C1D2, (IExpr)F.Times((IExpr)F.Power((IExpr)F.Pi, F.CN1), (IExpr)F.ArcTan(F.Times((IExpr)F.Power(b, F.CN1), (IExpr)F.Plus(F.Negate(a), (IExpr)F.Slot1))))));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST0() || dist.isAST2()) {
                IExpr a = F.C0;
                IExpr b = F.C1;
                if (dist.isAST2()) {
                    a = dist.arg1();
                    b = dist.arg2();
                }
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Plus(a, (IExpr)F.Times(b, (IExpr)F.Tan(F.Times((IExpr)F.Plus((IExpr)F.CN1D2, (IExpr)F.Slot1), (IExpr)F.Pi)))), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.Negate(F.oo), F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST0() || dist.isAST2()) {
                IExpr a = F.C0;
                IExpr b = F.C1;
                if (dist.isAST2()) {
                    a = dist.arg1();
                    b = dist.arg2();
                }
                IAST function = F.Function(F.Power((IExpr)F.Times(b, (IExpr)F.Pi, (IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.Power(b, F.CN2), (IExpr)F.Sqr(F.Plus(F.Negate(a), (IExpr)F.Slot1))))), F.CN1));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST0() || dist.isAST2()) {
                return S.Indeterminate;
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST0() || dist.isAST2()) {
                return S.Indeterminate;
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            if (dist.isAST0() || dist.isAST2()) {
                IExpr a = F.C0;
                IExpr b = F.C1;
                if (dist.isAST2()) {
                    a = dist.arg1();
                    b = dist.arg2();
                }
                double ad = a.evalDouble();
                double bd = b.evalDouble();
                RandomDataGenerator rdg = new RandomDataGenerator();
                double[] vector = rdg.nextDeviates((RealDistribution)new org.hipparchus.distribution.continuous.CauchyDistribution(ad, bd), size);
                return new ASTRealVector(vector, false);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Correlation
    extends AbstractFunctionEvaluator {
        private Correlation() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    RealMatrix matrix;
                    if (ast.arg1() instanceof ASTRealMatrix) {
                        PearsonsCorrelation pc = new PearsonsCorrelation(((ASTRealMatrix)ast.arg1()).getRealMatrix());
                        return new ASTRealMatrix(pc.getCorrelationMatrix(), false);
                    }
                    int[] dim = ast.arg1().isMatrix();
                    if (dim != null && dim[0] > 1 && dim[1] > 1 && (matrix = ast.arg1().toRealMatrix()) != null) {
                        PearsonsCorrelation pc = new PearsonsCorrelation(matrix);
                        return new ASTRealMatrix(pc.getCorrelationMatrix(), false);
                    }
                    return F.NIL;
                }
                IExpr arg1 = ast.arg1();
                IExpr arg2 = ast.arg2();
                int dim1 = arg1.isVector();
                int dim2 = arg2.isVector();
                if (dim1 >= 0 && dim1 == dim2) {
                    double[] b;
                    double[] a;
                    if ((engine.isDoubleMode() || arg1.isNumericAST() || arg2.isNumericAST()) && (a = arg1.toDoubleVector()) != null && (b = arg2.toDoubleVector()) != null) {
                        PearsonsCorrelation pc = new PearsonsCorrelation();
                        return F.num(pc.correlation(a, b));
                    }
                    return F.Divide(F.Covariance(arg1, arg2), F.Times((IExpr)F.StandardDeviation(arg1), (IExpr)F.StandardDeviation(arg2)));
                }
            }
            catch (MathRuntimeException mrex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)mrex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class ChiSquareDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDistribution,
    IPDF,
    IStatistics,
    IRandomVariate {
        private ChiSquareDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST1()) {
                return dist.arg1();
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST1()) {
                IExpr v = dist.arg1();
                F.Times((IExpr)F.C2, (IExpr)F.InverseGammaRegularized(F.Times((IExpr)F.C1D2, v), F.C0, F.C1D2));
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr v = dist.arg1();
                if (!engine.isArbitraryMode() && (v.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new ChiSquaredDistribution(v.evalDouble()).cumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.GammaRegularized(F.Times((IExpr)F.C1D2, v), F.C0, F.Times((IExpr)F.C1D2, (IExpr)F.Slot1)), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr v = dist.arg1();
                if (!engine.isArbitraryMode() && (v.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new ChiSquaredDistribution(v.evalDouble()).inverseCumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.Times((IExpr)F.C2, (IExpr)F.InverseGammaRegularized(F.Times((IExpr)F.C1D2, v), F.C0, F.Slot1)), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.C0, F.LessEqual((IExpr)F.Slot1, F.C0))), F.oo), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr v = dist.arg1();
                if (!engine.isArbitraryMode() && (v.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new ChiSquaredDistribution(v.evalDouble()).density(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Times((IExpr)F.Power((IExpr)F.C2, F.Times((IExpr)F.C1D2, v)), (IExpr)F.Exp(F.Times((IExpr)F.C1D2, (IExpr)F.Slot1)), (IExpr)F.Gamma(F.Times((IExpr)F.C1D2, v))), F.CN1), (IExpr)F.Power((IExpr)F.Slot1, F.Plus((IExpr)F.CN1, (IExpr)F.Times((IExpr)F.C1D2, v)))), F.Greater((IExpr)F.Slot1, F.C0))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST1()) {
                IExpr v = dist.arg1();
                return F.Times((IExpr)F.C2, v);
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            if (dist.isAST1()) {
                double v = dist.arg1().evalDouble();
                RandomDataGenerator rdg = new RandomDataGenerator();
                double[] vector = rdg.nextDeviates((RealDistribution)new ChiSquaredDistribution(v), size);
                return new ASTRealVector(vector, false);
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST1()) {
                IExpr s = dist.arg1();
                return F.Times((IExpr)F.C2, (IExpr)F.CSqrt2, (IExpr)F.Sqrt(F.Power(s, F.CN1)));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static interface ICentralMoment
    extends IDistribution {
        public IExpr centralMoment(IAST var1, IExpr var2, EvalEngine var3);
    }

    private static final class CentralMoment
    extends AbstractEvaluator {
        private CentralMoment() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                IExpr r = ast.arg2();
                return F.Divide(F.Total(F.Power((IExpr)F.Subtract(list, F.Mean(list)), r)), F.Length(list));
            }
            try {
                if (ast.arg1().isAST()) {
                    IAST dist = (IAST)ast.arg1();
                    IExpr order = ast.arg2();
                    if (dist.head().isSymbol()) {
                        ICentralMoment centralMoment;
                        IEvaluator evaluator;
                        ISymbol head = (ISymbol)dist.head();
                        if (dist.head().isSymbol() && head instanceof IBuiltInSymbol && (evaluator = ((IBuiltInSymbol)head).getEvaluator()) instanceof ICentralMoment && (dist = (centralMoment = (ICentralMoment)((Object)evaluator)).checkParameters(dist)).isPresent()) {
                            return centralMoment.centralMoment(dist, order, engine);
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.debug("PDF.evaluate() failed", (Throwable)ex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class BinomialDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDiscreteDistribution,
    IPDF,
    IStatistics,
    IRandomVariate {
        private BinomialDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST2()) {
                return F.Times(dist.arg1(), dist.arg2());
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.BetaRegularized(F.Subtract(F.C1, m), F.Subtract(n, F.Floor(F.Slot1)), F.Plus((IExpr)F.C1, (IExpr)F.Floor(F.Slot1))), F.And((IExpr)F.LessEqual((IExpr)F.C0, F.Slot1), (IExpr)F.Less((IExpr)F.Slot1, n))), F.list(F.C1, F.GreaterEqual((IExpr)F.Slot1, n))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Subtract(F.C1, m), F.Plus(F.Negate(F.Slot1), n)), (IExpr)F.Power(m, F.Slot1), (IExpr)F.Binomial(n, F.Slot1)), F.LessEqual(F.C0, F.Slot1, n))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST2()) {
                return F.Times(dist.arg1(), dist.arg2(), (IExpr)F.Subtract(F.C1, dist.arg2()));
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST2()) {
                IExpr n = dist.arg1();
                IExpr m = dist.arg2();
                return F.Divide(F.Subtract(F.C1, F.Times((IExpr)F.C2, m)), F.Sqrt(F.Times((IExpr)F.Subtract(F.C1, m), m, n)));
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            double p;
            int n;
            if (dist.isAST2() && (n = dist.arg1().toIntDefault(-1)) > 0 && 0.0 <= (p = dist.arg2().evalDouble()) && p <= 1.0) {
                RandomDataGenerator rdg = new RandomDataGenerator();
                int[] vector = rdg.nextDeviates((IntegerDistribution)new org.hipparchus.distribution.discrete.BinomialDistribution(n, p), size);
                return F.List(vector);
            }
            return F.NIL;
        }
    }

    private static final class BinCounts
    extends AbstractFunctionEvaluator {
        private BinCounts() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.arg1().isList()) {
                    IAST vector = (IAST)ast.arg1();
                    vector = BinCounts.dropNonReals(engine, vector);
                    if (ast.size() == 3) {
                        return BinCounts.binCounts(ast, vector, ast.arg2(), engine);
                    }
                    if (ast.size() == 2) {
                        return BinCounts.binCounts(ast, vector, F.C1, engine);
                    }
                }
            }
            catch (ArithmeticException rex) {
                LOGGER.debug("BinCounts.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private static IExpr binCounts(IAST ast, IAST vector, IExpr arg2, EvalEngine engine) {
            INum dxNum = F.CD1;
            int dx = 1;
            int xMin = 0;
            int xMax = Integer.MIN_VALUE;
            if (arg2.isList()) {
                IAST list = (IAST)arg2;
                if (list.size() == 4) {
                    dx = list.arg3().toIntDefault();
                    if (dx == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    if (dx < 0) {
                        return IOFunctions.printMessage(ast.topHead(), "step", F.list(list.arg3()), engine);
                    }
                    xMin = list.arg1().toIntDefault();
                    if (xMin == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    xMax = list.arg2().toIntDefault();
                    if (xMax == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    if (xMax <= xMin) {
                        return F.CEmptyList;
                    }
                    xMin /= dx;
                    xMax /= dx;
                }
            } else {
                dx = Integer.MIN_VALUE;
                dxNum = F.num(arg2.evalDouble());
                IExpr dXMax = S.Max.of(engine, vector);
                xMax = S.Floor.of(engine, F.Divide(F.Plus(dXMax, arg2), arg2)).toIntDefault();
                if (xMax < 0) {
                    return F.NIL;
                }
            }
            if (xMax >= xMin) {
                int capacity = xMax - xMin;
                if (capacity > Config.MAX_AST_SIZE) {
                    ASTElementLimitExceeded.throwIt(capacity);
                }
                int[] res = new int[capacity];
                for (int i = 1; i < vector.size(); ++i) {
                    IExpr temp = vector.get(i);
                    int index = -1;
                    if (dx != Integer.MIN_VALUE) {
                        index = ((ISignedNumber)temp).floorFraction().div(dx).toIntDefault();
                        if (dx > 1 && temp.isInteger() && ((IInteger)temp).mod(dx).isZero()) {
                            --index;
                        }
                    } else {
                        index = S.Floor.of(engine, ((ISignedNumber)temp).divide(dxNum)).toIntDefault();
                    }
                    if (index == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    int binIndex = index - xMin;
                    if (binIndex < 0 || binIndex >= res.length) continue;
                    int n = binIndex;
                    res[n] = res[n] + 1;
                }
                IASTAppendable result = F.ListAlloc(capacity + 1);
                for (int i = 0; i < res.length; ++i) {
                    result.append(res[i]);
                }
                return result;
            }
            return F.NIL;
        }

        private static IAST dropNonReals(EvalEngine engine, IAST vector) {
            IASTAppendable[] filter = vector.filterNIL(x -> {
                if (x.isReal()) {
                    return x;
                }
                IExpr d = engine.evalN((IExpr)x);
                if (d.isReal()) {
                    return d;
                }
                return F.NIL;
            });
            vector = filter[0];
            return vector;
        }
    }

    private static final class BetaDistribution
    extends AbstractEvaluator
    implements IDistribution,
    IRandomVariate,
    IStatistics,
    IPDF,
    ICDF {
        private BetaDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                if (!engine.isArbitraryMode() && (a.isNumericArgument() || b.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.BetaDistribution(a.evalDouble(), b.evalDouble()).cumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.BetaRegularized(F.Slot1, a, b), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.C1, F.GreaterEqual((IExpr)F.Slot1, F.C1))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                if (!engine.isArbitraryMode() && (a.isNumericArgument() || b.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.BetaDistribution(a.evalDouble(), b.evalDouble()).inverseCumulativeProbability(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.InverseBetaRegularized(F.Slot1, a, b), F.Less(F.C0, F.Slot1, F.C1)), F.list(F.C0, F.LessEqual((IExpr)F.Slot1, F.C0))), F.C1), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST2()) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                return F.Divide(a, F.Plus(a, b));
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST2()) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                return F.InverseBetaRegularized(F.C1D2, a, b);
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            if (dist.isAST2()) {
                ISignedNumber a = dist.arg1().evalReal();
                ISignedNumber b = dist.arg2().evalReal();
                if (a != null && b != null) {
                    RandomDataGenerator rdg = new RandomDataGenerator();
                    double[] vector = rdg.nextDeviates((RealDistribution)new org.hipparchus.distribution.continuous.BetaDistribution(a.doubleValue(), b.doubleValue()), size);
                    return new ASTRealVector(vector, false);
                }
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST2()) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                return F.Times(a, b, (IExpr)F.Power((IExpr)F.Times((IExpr)F.Sqr(F.Plus(a, b)), (IExpr)F.Plus((IExpr)F.C1, a, b)), F.CN1));
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST1()) {
                IExpr s = dist.arg1();
                return F.Divide(F.Subtract(F.C1, F.Times((IExpr)F.C2, s)), F.Sqrt(F.Times((IExpr)F.Subtract(F.C1, s), s)));
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST2()) {
                IExpr a = dist.arg1();
                IExpr b = dist.arg2();
                if (!engine.isArbitraryMode() && (a.isNumericArgument() || b.isNumericArgument() || k.isNumericArgument())) {
                    try {
                        return F.num(new org.hipparchus.distribution.continuous.BetaDistribution(a.evalDouble(), b.evalDouble()).density(k.evalDouble()));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power((IExpr)F.Beta(a, b), F.CN1), (IExpr)F.Power((IExpr)F.Subtract(F.C1, F.Slot1), F.Plus((IExpr)F.CN1, b)), (IExpr)F.Power((IExpr)F.Slot1, F.Plus((IExpr)F.CN1, a))), F.Less(F.C0, F.Slot1, F.C1))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class BernoulliDistribution
    extends AbstractEvaluator
    implements ICDF,
    IDistribution,
    IPDF,
    IStatistics,
    IRandomVariate {
        private BernoulliDistribution() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public IExpr mean(IAST dist) {
            if (dist.isAST1()) {
                return dist.arg1();
            }
            return F.NIL;
        }

        @Override
        public IExpr median(IAST dist) {
            if (dist.isAST1()) {
                return F.Piecewise(F.list(F.list(F.C1, F.Greater(dist.arg1(), F.C1D2))), F.C0);
            }
            return F.NIL;
        }

        @Override
        public IExpr cdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr p = dist.arg1();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.C0, F.Less((IExpr)F.Slot1, F.C0)), F.list(F.Subtract(F.C1, p), F.And((IExpr)F.LessEqual((IExpr)F.C0, F.Slot1), (IExpr)F.Less((IExpr)F.Slot1, F.C1)))), F.C1));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr inverseCDF(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr p = dist.arg1();
                IAST function = F.Function(F.ConditionalExpression(F.Piecewise(F.list(F.list(F.C1, F.Greater((IExpr)F.Slot1, F.Subtract(F.C1, p)))), F.C0), F.LessEqual(F.C0, F.Slot1, F.C1)));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr pdf(IAST dist, IExpr k, EvalEngine engine) {
            if (dist.isAST1()) {
                IExpr p = dist.arg1();
                IAST function = F.Function(F.Piecewise(F.list(F.list(F.Subtract(F.C1, p), F.Equal((IExpr)F.Slot1, (IExpr)F.C0)), F.list(p, F.Equal((IExpr)F.Slot1, (IExpr)F.C1))), F.C0));
                return this.callFunction(function, k);
            }
            return F.NIL;
        }

        @Override
        public IExpr variance(IAST dist) {
            if (dist.isAST1()) {
                IExpr N2 = dist.arg1();
                return F.Times(N2, (IExpr)F.Subtract(F.C1, N2));
            }
            return F.NIL;
        }

        @Override
        public IExpr skewness(IAST dist) {
            if (dist.isAST1()) {
                IExpr s = dist.arg1();
                return F.Divide(F.Subtract(F.C1, F.Times((IExpr)F.C2, s)), F.Sqrt(F.Times((IExpr)F.Subtract(F.C1, s), s)));
            }
            return F.NIL;
        }

        @Override
        public IExpr randomVariate(Random random, IAST dist, int size) {
            double p;
            if (dist.isAST1() && 0.0 <= (p = dist.arg1().evalDouble()) && p <= 1.0) {
                RandomDataGenerator rdg = new RandomDataGenerator();
                int[] vector = rdg.nextDeviates((IntegerDistribution)new org.hipparchus.distribution.discrete.BinomialDistribution(1, p), size);
                return F.List(vector);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class CDF
    extends AbstractFunctionEvaluator {
        private CDF() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 2 || ast.size() == 3) {
                try {
                    if (ast.arg1().isAST()) {
                        IAST dist = (IAST)ast.arg1();
                        IExpr xArg = F.NIL;
                        if (ast.isAST2()) {
                            xArg = ast.arg2();
                        }
                        if (dist.head().isSymbol()) {
                            IEvaluator evaluator;
                            ISymbol head = (ISymbol)dist.head();
                            if (dist.head().isSymbol() && head instanceof IBuiltInSymbol && (evaluator = ((IBuiltInSymbol)head).getEvaluator()) instanceof ICDF) {
                                ICDF cdf = (ICDF)((Object)evaluator);
                                return cdf.cdf(dist, xArg, engine);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("CDF.evaluate() failed", (Throwable)ex);
                }
            }
            return F.NIL;
        }
    }

    private static class ArithmeticGeometricMean
    extends AbstractArg2 {
        private ArithmeticGeometricMean() {
        }

        @Override
        public IExpr e2ApcomplexArg(ApcomplexNum a, ApcomplexNum b) {
            return F.complexNum(ApcomplexMath.agm((Apcomplex)a.apcomplexValue(), (Apcomplex)b.apcomplexValue()));
        }

        @Override
        public IExpr e2ApfloatArg(ApfloatNum a, ApfloatNum b) {
            return F.num(ApfloatMath.agm((Apfloat)a.apfloatValue(), (Apfloat)b.apfloatValue()));
        }

        @Override
        public IExpr e2DblComArg(IComplexNum a, IComplexNum b) {
            ApcomplexNum a1 = a.apcomplexNumValue();
            ApcomplexNum b1 = b.apcomplexNumValue();
            Apcomplex agm = ApcomplexMath.agm((Apcomplex)a1.apcomplexValue(), (Apcomplex)b1.apcomplexValue());
            return F.complex(agm.real().doubleValue(), agm.imag().doubleValue());
        }

        @Override
        public IExpr e2DblArg(INum a, INum b) {
            return F.num(ApfloatMath.agm((Apfloat)new Apfloat(a.doubleValue()), (Apfloat)new Apfloat(b.doubleValue())).doubleValue());
        }

        @Override
        public IExpr e2ObjArg(IAST ast, IExpr a, IExpr b) {
            if (a.isZero() || a.equals(b)) {
                return a;
            }
            if (b.isZero()) {
                return b;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1540);
            super.setUp(newSymbol);
        }
    }

    private static interface IPDF
    extends IDistribution {
        public IExpr pdf(IAST var1, IExpr var2, EvalEngine var3);

        default public IExpr callFunction(IExpr function, IExpr x) {
            EvalEngine engine;
            IExpr pureFunction = function;
            if (pureFunction.isFunction() && !(engine = EvalEngine.get()).isNumericMode()) {
                ((IASTMutable)pureFunction).set(1, engine.evaluateNonNumeric(pureFunction.first()));
            }
            if (x.isPresent()) {
                if (x.isList()) {
                    return ((IAST)x).map(v -> F.unaryAST1(pureFunction, v), 1);
                }
                return F.unaryAST1(pureFunction, x);
            }
            return pureFunction;
        }
    }

    private static class InverseCDF
    extends AbstractFunctionEvaluator {
        private InverseCDF() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 2 || ast.size() == 3) {
                try {
                    if (ast.arg1().isAST()) {
                        IAST dist = (IAST)ast.arg1();
                        IExpr xArg = F.NIL;
                        if (ast.isAST2()) {
                            xArg = ast.arg2();
                        }
                        if (dist.head().isSymbol()) {
                            IEvaluator evaluator;
                            ISymbol head = (ISymbol)dist.head();
                            if (dist.head().isSymbol() && head instanceof IBuiltInSymbol && (evaluator = ((IBuiltInSymbol)head).getEvaluator()) instanceof ICDF) {
                                ICDF inverseCDF = (ICDF)((Object)evaluator);
                                return inverseCDF.inverseCDF(dist, xArg, engine);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("InverseCDF.evaluate() failed", (Throwable)ex);
                }
            }
            return F.NIL;
        }
    }

    private static final class AbsoluteCorrelation
    extends AbstractFunctionEvaluator {
        private AbsoluteCorrelation() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr a = ast.arg1();
            IExpr b = ast.arg2();
            int dim1 = a.isVector();
            int dim2 = b.isVector();
            if (dim1 >= 0 && dim1 == dim2) {
                return F.Divide(F.Dot(a, (IExpr)F.Conjugate(b)), F.Length(a));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static interface ICDF
    extends IDistribution {
        public static final IExpr CDF_NUMERIC_THRESHOLD = F.num(1.0E-14);

        public IExpr cdf(IAST var1, IExpr var2, EvalEngine var3);

        public IExpr inverseCDF(IAST var1, IExpr var2, EvalEngine var3);
    }

    private static interface IStatistics {
        public IExpr mean(IAST var1);

        public IExpr variance(IAST var1);

        public IExpr skewness(IAST var1);

        default public IExpr standardDeviation(IAST distribution) {
            IExpr variance = this.variance(distribution);
            return variance.isPresent() ? F.Sqrt(variance) : F.NIL;
        }
    }

    private static interface IExpectationDiscreteDistribution
    extends IDiscreteDistribution {
        public IExpr lowerBound(IAST var1);

        public IExpr randomVariate(Random var1, IAST var2, int var3);

        public IExpr p_equals(IAST var1, IExpr var2);
    }

    static interface IRandomVariate {
        public IExpr randomVariate(Random var1, IAST var2, int var3);
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.AbsoluteCorrelation.setEvaluator(new AbsoluteCorrelation());
            S.ArithmeticGeometricMean.setEvaluator(new ArithmeticGeometricMean());
            S.CDF.setEvaluator(new CDF());
            S.PDF.setEvaluator(new PDF());
            S.BernoulliDistribution.setEvaluator(new BernoulliDistribution());
            S.BetaDistribution.setEvaluator(new BetaDistribution());
            S.BinCounts.setEvaluator(new BinCounts());
            S.BinomialDistribution.setEvaluator(new BinomialDistribution());
            S.CentralMoment.setEvaluator(new CentralMoment());
            S.ChiSquareDistribution.setEvaluator(new ChiSquareDistribution());
            S.Correlation.setEvaluator(new Correlation());
            S.Covariance.setEvaluator(new Covariance());
            S.CauchyDistribution.setEvaluator(new CauchyDistribution());
            S.DiscreteUniformDistribution.setEvaluator(new DiscreteUniformDistribution());
            S.ErlangDistribution.setEvaluator(new ErlangDistribution());
            S.Expectation.setEvaluator(new Expectation());
            S.ExponentialDistribution.setEvaluator(new ExponentialDistribution());
            S.FiveNum.setEvaluator(new FiveNum());
            S.FRatioDistribution.setEvaluator(new FRatioDistribution());
            S.FrechetDistribution.setEvaluator(new FrechetDistribution());
            S.GammaDistribution.setEvaluator(new GammaDistribution());
            S.GeometricMean.setEvaluator(new GeometricMean());
            S.GeometricDistribution.setEvaluator(new GeometricDistribution());
            S.GompertzMakehamDistribution.setEvaluator(new GompertzMakehamDistribution());
            S.GumbelDistribution.setEvaluator(new GumbelDistribution());
            S.HarmonicMean.setEvaluator(new HarmonicMean());
            S.HypergeometricDistribution.setEvaluator(new HypergeometricDistribution());
            S.InterquartileRange.setEvaluator(new InterquartileRange());
            S.InverseCDF.setEvaluator(new InverseCDF());
            S.KolmogorovSmirnovTest.setEvaluator(new KolmogorovSmirnovTest());
            S.Kurtosis.setEvaluator(new Kurtosis());
            S.LogNormalDistribution.setEvaluator(new LogNormalDistribution());
            S.Mean.setEvaluator(new Mean());
            S.MeanDeviation.setEvaluator(new MeanDeviation());
            S.Median.setEvaluator(new Median());
            S.NakagamiDistribution.setEvaluator(new NakagamiDistribution());
            S.NormalDistribution.setEvaluator(new NormalDistribution());
            S.ParetoDistribution.setEvaluator(new ParetoDistribution());
            S.PoissonDistribution.setEvaluator(new PoissonDistribution());
            S.Probability.setEvaluator(new Probability());
            S.Quantile.setEvaluator(new Quantile());
            S.Quartiles.setEvaluator(new Quartiles());
            S.RandomVariate.setEvaluator(new RandomVariate());
            S.Rescale.setEvaluator(new Rescale());
            S.Skewness.setEvaluator(new Skewness());
            S.StandardDeviation.setEvaluator(new StandardDeviation());
            S.Standardize.setEvaluator(new Standardize());
            S.StudentTDistribution.setEvaluator(new StudentTDistribution());
            S.SurvivalFunction.setEvaluator(new SurvivalFunction());
            S.TTest.setEvaluator(new TTest());
            S.UniformDistribution.setEvaluator(new UniformDistribution());
            S.Variance.setEvaluator(new Variance());
            S.WeibullDistribution.setEvaluator(new WeibullDistribution());
        }
    }
}

