/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import de.lab4inf.math.sets.ComplexNumber;
import java.math.BigDecimal;
import java.util.function.DoubleUnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.FixedPrecisionApfloatHelper;
import org.hipparchus.complex.Complex;
import org.hipparchus.distribution.continuous.BetaDistribution;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.functions.BesselJS;
import org.matheclipse.core.builtin.functions.GammaJS;
import org.matheclipse.core.builtin.functions.ZetaJS;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.PolynomialDegreeLimitExceeded;
import org.matheclipse.core.eval.exception.ThrowException;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractArg1;
import org.matheclipse.core.eval.interfaces.AbstractArg12;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.PolyGammaRules;
import org.matheclipse.core.reflection.system.rules.PolyLogRules;
import org.matheclipse.core.reflection.system.rules.ProductLogRules;
import org.matheclipse.core.reflection.system.rules.StieltjesGammaRules;
import org.matheclipse.core.reflection.system.rules.StruveHRules;
import org.matheclipse.core.reflection.system.rules.StruveLRules;

public class SpecialFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void initialize() {
        Initializer.init();
    }

    private SpecialFunctions() {
    }

    private static final class Zeta
    extends AbstractArg12 {
        private Zeta() {
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.NIL;
        }

        @Override
        public IExpr e1DblArg(INum num) {
            double d = de.lab4inf.math.functions.Zeta.zeta((double)num.doubleValue());
            return F.num(d);
        }

        @Override
        public IExpr e1DblComArg(IComplexNum cNum) {
            ComplexNumber c = new ComplexNumber(cNum.reDoubleValue(), cNum.imDoubleValue());
            c = de.lab4inf.math.functions.Zeta.zeta((de.lab4inf.math.Complex)c);
            return F.complexNum(c.real(), c.imag());
        }

        @Override
        public IExpr e1ObjArg(IExpr arg1) {
            if (arg1.isZero()) {
                return F.CN1D2;
            }
            if (arg1.isOne()) {
                return F.CComplexInfinity;
            }
            if (arg1.isMinusOne()) {
                return F.QQ(-1L, 12L);
            }
            if (arg1.isInteger()) {
                IInteger n = (IInteger)arg1;
                if (!n.isPositive()) {
                    if (n.isEven()) {
                        return F.C0;
                    }
                    n = n.negate();
                    IInteger n1 = n.add(F.C1);
                    return F.Times((IExpr)F.Power((IExpr)F.CN1, n), F.Power((IExpr)n1, -1L), (IExpr)F.BernoulliB(n1));
                }
                if (n.isEven()) {
                    n = n.shiftRight(1);
                    return F.Times(F.Power((IExpr)F.CN1, F.Plus((IExpr)F.CN1, (IExpr)n)), F.Power((IExpr)F.C2, F.Plus((IExpr)F.CN1, (IExpr)F.Times((IExpr)F.C2, (IExpr)n))), F.Power((IExpr)S.Pi, F.Times((IExpr)F.C2, (IExpr)n)), F.Power((IExpr)F.Factorial(F.Times((IExpr)F.C2, (IExpr)n)), -1L), F.BernoulliB(F.Times((IExpr)F.C2, (IExpr)n)));
                }
            } else if (arg1.isInfinity()) {
                return F.C1;
            }
            return F.NIL;
        }

        @Override
        public IExpr e2ObjArg(IExpr s, IExpr a) {
            int nInt;
            if (a.isZero()) {
                return F.Zeta(s);
            }
            if (a.isMinusOne()) {
                return F.Plus((IExpr)F.C1, (IExpr)F.Zeta(s));
            }
            if (s.isInteger() && a.isInteger() && (!s.isPositive() || ((IInteger)s).isEven()) && (nInt = ((IInteger)a).toIntDefault(0)) < 0) {
                return F.Plus((IExpr)F.sum(k -> F.Power((IExpr)F.Power(k, s), -1L), 1, nInt *= -1), (IExpr)F.Zeta(s));
            }
            if (a.isNumEqualRational(F.C2)) {
                return F.Plus((IExpr)F.CN1, (IExpr)F.Zeta(s));
            }
            if (a.isNumEqualRational(F.C1D2)) {
                return F.Times((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Sqr(s)), (IExpr)F.Zeta(s));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class StruveL
    extends AbstractFunctionEvaluator
    implements StruveLRules {
        private StruveL() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            try {
                if (arg2.isZero()) {
                    IExpr re = arg1.re();
                    if (re.isMinusOne()) {
                        return S.Indeterminate;
                    }
                    IExpr temp = re.greaterThan(F.CN1);
                    if (temp.isTrue()) {
                        return F.C0;
                    }
                    if (temp.isFalse()) {
                        return F.CComplexInfinity;
                    }
                } else {
                    if (arg1 instanceof INum && arg2 instanceof INum) {
                        return F.num(BesselJS.struveL(arg1.evalDouble(), arg2.evalDouble()));
                    }
                    if (arg1.isComplexNumeric() || arg2.isComplexNumeric()) {
                        return F.complexNum(BesselJS.struveL(arg1.evalComplex(), arg2.evalComplex()));
                    }
                    IExpr negArg2 = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg2);
                    if (negArg2.isPresent()) {
                        return F.Times(F.CN1, F.Power(arg2, arg1), F.Power(negArg2, F.Negate(arg1)), F.StruveL(arg1, negArg2));
                    }
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("StruveL.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class StruveH
    extends AbstractFunctionEvaluator
    implements StruveHRules {
        private StruveH() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            try {
                if (arg2.isZero()) {
                    IExpr re = arg1.re();
                    if (re.isMinusOne()) {
                        return S.Indeterminate;
                    }
                    IExpr temp = re.greaterThan(F.CN1);
                    if (temp.isTrue()) {
                        return F.C0;
                    }
                    if (temp.isFalse()) {
                        return F.CComplexInfinity;
                    }
                } else {
                    if (arg1 instanceof INum && arg2 instanceof INum) {
                        return F.num(BesselJS.struveH(arg1.evalDouble(), arg2.evalDouble()));
                    }
                    if (arg1.isComplexNumeric() || arg2.isComplexNumeric()) {
                        return F.complexNum(BesselJS.struveH(arg1.evalComplex(), arg2.evalComplex()));
                    }
                    IExpr negArg2 = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg2);
                    if (negArg2.isPresent()) {
                        return F.Times(F.CN1, F.Power(arg2, arg1), F.Power(negArg2, F.Negate(arg1)), F.StruveH(arg1, negArg2));
                    }
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("StruveH.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class StieltjesGamma
    extends AbstractFunctionEvaluator
    implements StieltjesGammaRules {
        private StieltjesGamma() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (!ast.isAST1()) {
                IExpr iExpr = ast.arg2();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class ProductLog
    extends AbstractArg12
    implements ProductLogRules {
        private ProductLog() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr e1DblArg(INum d) {
            if (d.isZero()) {
                return d;
            }
            try {
                return F.num(ApfloatMath.w((Apfloat)new Apfloat(d.doubleValue())).doubleValue());
            }
            catch (Exception exception) {
                Apcomplex c = ApcomplexMath.w((Apcomplex)new Apfloat(d.doubleValue()));
                return F.complexNum(c.real().doubleValue(), c.imag().doubleValue());
            }
        }

        @Override
        public IExpr e1DblComArg(IComplexNum arg1) {
            if (arg1.isZero()) {
                return arg1;
            }
            Apcomplex c = new Apcomplex(new Apfloat(new BigDecimal(arg1.getRealPart()), 16L), new Apfloat(new BigDecimal(arg1.getImaginaryPart()), 16L));
            c = ApcomplexMath.w((Apcomplex)c);
            return F.complexNum(c.real().doubleValue(), c.imag().doubleValue());
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            if (arg1.equals((Object)Apcomplex.ZERO)) {
                return F.C0;
            }
            FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
            try {
                return F.num(h.w(arg1));
            }
            catch (Exception exception) {
                return F.complexNum(h.w((Apcomplex)arg1, 0L));
            }
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            if (arg1.equals((Object)Apcomplex.ZERO)) {
                return F.C0;
            }
            FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
            return F.complexNum(h.w(arg1, 0L));
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr e1ObjArg(IExpr o) {
            if (o.isZero()) {
                return F.C0;
            }
            return F.NIL;
        }

        @Override
        public IExpr e2ObjArg(IExpr k, IExpr z) {
            int ki = Integer.MIN_VALUE;
            if (z.isZero() && k.isNonZeroComplexResult()) {
                return F.CNInfinity;
            }
            if (k.isNumber()) {
                ki = k.toIntDefault();
                if (ki == Integer.MIN_VALUE) {
                    return IOFunctions.printMessage(S.ProductLog, "intm", F.list(F.ProductLog(k, z), F.C1), EvalEngine.get());
                }
                if (ki == 0) {
                    if (z.isZero()) {
                        return F.C0;
                    }
                    return F.ProductLog(z);
                }
                if (ki == -1) {
                    if (z.equals(F.CNPiHalf)) {
                        return F.Times((IExpr)F.CC(0L, 1L, -1L, 2L), (IExpr)S.Pi);
                    }
                    if (z.equals(F.Negate(F.Power((IExpr)S.E, -1L)))) {
                        return F.CN1;
                    }
                }
                if (z.isNumber()) {
                    if (z instanceof IComplexNum) {
                        if (z instanceof ApcomplexNum) {
                            FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
                            ApcomplexNum acn = (ApcomplexNum)z;
                            return F.complexNum(h.w(acn.apcomplexValue(), (long)ki));
                        }
                        if (z instanceof ComplexNum) {
                            ComplexNum cn = (ComplexNum)z;
                            Apcomplex c = new Apcomplex(new Apfloat(cn.getRealPart()), new Apfloat(cn.getImaginaryPart()));
                            c = ApcomplexMath.w((Apcomplex)c, (long)ki);
                            return F.complexNum(c.real().doubleValue(), c.imag().doubleValue());
                        }
                    }
                    if (z instanceof ApfloatNum) {
                        FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
                        ApfloatNum an = (ApfloatNum)z;
                        return F.complexNum(h.w((Apcomplex)an.apfloatValue(), (long)ki));
                    }
                    if (z instanceof Num) {
                        Num n = (Num)z;
                        Apcomplex c = ApcomplexMath.w((Apcomplex)new Apfloat(n.doubleValue()), (long)ki);
                        return F.complexNum(c.real().doubleValue(), c.imag().doubleValue());
                    }
                }
            }
            return super.e2ObjArg(k, z);
        }
    }

    private static class PolyLog
    extends AbstractFunctionEvaluator
    implements PolyLogRules {
        private PolyLog() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg2.isZero()) {
                return F.C0;
            }
            if (arg2.isOne()) {
                if (arg1.isOne()) {
                    return F.CInfinity;
                }
                IExpr temp = arg1.re();
                if (temp.isReal()) {
                    ISignedNumber num = (ISignedNumber)temp;
                    if (num.isOne()) {
                        return S.Indeterminate;
                    }
                    if (num.isGT(F.C1)) {
                        return F.Zeta(arg1);
                    }
                    return F.CComplexInfinity;
                }
            } else if (arg2.isMinusOne()) {
                return F.Times((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.C2, F.Plus((IExpr)F.C1, F.Negate(arg1)))), (IExpr)F.Zeta(arg1));
            }
            if (arg1.isReal()) {
                if (arg1.isZero()) {
                    return F.Times(arg2, F.Power((IExpr)F.Plus((IExpr)F.C1, F.Negate(arg2)), -1L));
                }
                if (arg1.isOne()) {
                    return F.Negate(F.Log(F.Plus((IExpr)F.C1, F.Negate(arg2))));
                }
                if (arg1.isMinusOne()) {
                    return F.Times(arg2, F.Power((IExpr)F.Plus((IExpr)F.C1, F.Negate(arg2)), -2L));
                }
                if (arg1.equals(F.CN2)) {
                    return F.Times(F.CN1, arg2, F.Plus((IExpr)F.C1, arg2), F.Power((IExpr)F.Plus((IExpr)F.CN1, arg2), -3L));
                }
                if (arg1.equals(F.CN3)) {
                    return F.Times(arg2, (IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C4, arg2), (IExpr)F.Sqr(arg2)), F.Power((IExpr)F.Plus((IExpr)F.C1, F.Negate(arg2)), -4L));
                }
            }
            if (engine.isDoubleMode()) {
                try {
                    double nDouble = Double.NaN;
                    double xDouble = Double.NaN;
                    try {
                        nDouble = arg1.evalDouble();
                        xDouble = arg2.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(nDouble) || Double.isNaN(xDouble)) {
                        Complex nComplex = arg1.evalComplex();
                        Complex xComplex = arg2.evalComplex();
                        return F.complexNum(ZetaJS.polyLog(nComplex, xComplex));
                    }
                    return F.complexNum(ZetaJS.polyLog(nDouble, xDouble));
                }
                catch (ThrowException te) {
                    LOGGER.debug("PolyLog.evaluate() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class PolyGamma
    extends AbstractFunctionEvaluator
    implements PolyGammaRules {
        private PolyGamma() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            block15: {
                IExpr arg1 = ast.arg1();
                if (ast.isAST1()) {
                    if (arg1.isMinusOne()) {
                        return F.CComplexInfinity;
                    }
                    return F.PolyGamma(F.C0, arg1);
                }
                if (ast.isAST2()) {
                    IExpr nu;
                    int n;
                    IExpr arg2 = ast.arg2();
                    if (arg1.isMinusOne()) {
                        return F.LogGamma(arg2);
                    }
                    if (arg2.isOne() && (n = arg1.toIntDefault()) > 0 && (n & 1) == 1) {
                        return F.Times((IExpr)F.Factorial(F.ZZ(n)), (IExpr)F.Zeta(F.ZZ(n + 1)));
                    }
                    if (arg2.isIntegerResult() && arg2.isNegativeResult() && (nu = arg1.re()).isReal() && ((ISignedNumber)nu).isGT(F.CN1)) {
                        return F.CComplexInfinity;
                    }
                    if (engine.isDoubleMode()) {
                        try {
                            n = arg1.toIntDefault();
                            if (n < 0) break block15;
                            double xDouble = Double.NaN;
                            try {
                                xDouble = arg2.evalDouble();
                            }
                            catch (ValidateException validateException) {
                                // empty catch block
                            }
                            if (!Double.isNaN(xDouble)) {
                                if (n == 0) {
                                    return F.num(GammaJS.polyGamma(xDouble));
                                }
                                return F.num(GammaJS.polyGamma(n, xDouble));
                            }
                        }
                        catch (ValidateException ve) {
                            return IOFunctions.printMessage(ast.topHead(), ve, engine);
                        }
                        catch (ThrowException te) {
                            LOGGER.debug("PolyGamma.evaluate() failed", (Throwable)((Object)te));
                            return te.getValue();
                        }
                        catch (RuntimeException rex) {
                            LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                        }
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class MeijerG
    extends AbstractFunctionEvaluator
    implements StieltjesGammaRules {
        private MeijerG() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 4) {
                IExpr arg1 = ast.arg1();
                IExpr arg2 = ast.arg2();
                IExpr z = ast.arg3();
                if (z.isList()) {
                    return ((IAST)z).mapThread(ast.setAtCopy(3, F.Slot1), 3);
                }
                if (arg1.isList() && arg2.isList()) {
                    IAST list1 = (IAST)arg1;
                    IAST list2 = (IAST)arg2;
                    if (list1.size() == 3 && list1.arg1().isList() && list1.arg2().isList() && list2.size() == 3 && list2.arg1().isList() && list2.arg2().isList()) {
                        IAST k1 = (IAST)list1.arg1();
                        IAST k2 = (IAST)list1.arg2();
                        IAST l1 = (IAST)list2.arg1();
                        IAST l2 = (IAST)list2.arg2();
                        int n = k1.argSize();
                        int p = k2.argSize();
                        int m = l1.argSize();
                        int q = l2.argSize();
                        block0 : switch (n) {
                            case 0: {
                                switch (p) {
                                    case 0: {
                                        switch (m) {
                                            case 0: {
                                                switch (q) {
                                                    case 0: {
                                                        LOGGER.log(engine.getLogLevel(), "MeijerG: {} not available.", (Object)ast);
                                                        return F.NIL;
                                                    }
                                                }
                                                break;
                                            }
                                            case 1: {
                                                IExpr b1 = l1.arg1();
                                                switch (q) {
                                                    case 1: {
                                                        IExpr b2 = l2.arg1();
                                                        return F.Times((IExpr)F.Power(z, F.Plus(b1, (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Plus(F.Negate(b1), b2)))), (IExpr)F.BesselJ(F.Subtract(b1, b2), F.Times((IExpr)F.C2, (IExpr)F.Sqrt(z))));
                                                    }
                                                }
                                            }
                                        }
                                        break;
                                    }
                                    case 1: {
                                        IExpr a2 = k2.arg1();
                                        switch (m) {
                                            case 1: {
                                                IExpr b1 = l1.arg1();
                                                switch (q) {
                                                    case 1: {
                                                        IExpr b2 = l2.arg1();
                                                        return F.Times((IExpr)F.Power(z, b1), (IExpr)F.Power((IExpr)F.Gamma(F.Subtract(a2, b1)), F.CN1), (IExpr)F.Hypergeometric1F1Regularized(F.Plus((IExpr)F.C1, F.Negate(a2), b1), F.Plus((IExpr)F.C1, b1, F.Negate(b2)), z));
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                break;
                            }
                            case 1: {
                                IExpr a1 = k1.arg1();
                                switch (p) {
                                    case 0: {
                                        switch (m) {
                                            case 0: {
                                                switch (q) {
                                                    case 0: {
                                                        return F.Times((IExpr)F.Power((IExpr)F.Exp(F.Power(z, F.CN1)), F.CN1), (IExpr)F.Power(z, F.Plus((IExpr)F.CN1, a1)));
                                                    }
                                                    case 1: {
                                                        IExpr b2 = l2.arg1();
                                                        if (!z.isPositive()) break;
                                                        return F.Times(F.Power(z, b2), F.Power((IExpr)F.Gamma(F.Subtract(a1, b2)), F.CN1), F.Power((IExpr)F.Plus((IExpr)F.CN1, z), F.Plus((IExpr)F.CN1, a1, F.Negate(b2))), F.UnitStep(F.Plus((IExpr)F.CN1, z)));
                                                    }
                                                }
                                                break block0;
                                            }
                                            case 1: {
                                                IExpr b1 = l1.arg1();
                                                switch (q) {
                                                    case 1: {
                                                        IExpr b2 = l2.arg1();
                                                        return F.Times((IExpr)F.Power(z, b1), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, F.Negate(a1), b1)), (IExpr)F.Hypergeometric1F1Regularized(F.Plus((IExpr)F.C1, F.Negate(a1), b1), F.Plus((IExpr)F.C1, b1, F.Negate(b2)), F.Negate(z)));
                                                    }
                                                }
                                            }
                                        }
                                        break block0;
                                    }
                                    case 1: {
                                        IExpr a2 = k2.arg1();
                                        switch (m) {
                                            case 0: {
                                                switch (q) {
                                                    case 0: {
                                                        return F.Times((IExpr)F.Power(z, F.Plus((IExpr)F.CN1, a1, (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Plus(F.Negate(a1), a2)))), (IExpr)F.BesselJ(F.Plus(F.Negate(a1), a2), F.Times((IExpr)F.C2, (IExpr)F.Power(z, F.CN1D2))));
                                                    }
                                                    case 1: {
                                                        IExpr b2 = l2.arg1();
                                                        return F.Times((IExpr)F.Power(z, F.Plus((IExpr)F.CN1, a1)), (IExpr)F.Power((IExpr)F.Gamma(F.Subtract(a1, b2)), F.CN1), (IExpr)F.Hypergeometric1F1Regularized(F.Plus((IExpr)F.C1, F.Negate(a1), b2), F.Plus((IExpr)F.C1, F.Negate(a1), a2), F.Power(z, F.CN1)));
                                                    }
                                                }
                                                break block0;
                                            }
                                            case 1: {
                                                IExpr b1 = l1.arg1();
                                                switch (q) {
                                                    case 0: {
                                                        return F.Times((IExpr)F.Power(z, F.Plus((IExpr)F.CN1, a1)), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, F.Negate(a1), b1)), (IExpr)F.Hypergeometric1F1Regularized(F.Plus((IExpr)F.C1, F.Negate(a1), b1), F.Plus((IExpr)F.C1, F.Negate(a1), a2), F.Negate(F.Power(z, F.CN1))));
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static class LogGamma
    extends AbstractTrigArg1
    implements INumeric {
        private LogGamma() {
        }

        @Override
        public IExpr e1ComplexArg(Complex c) {
            return F.complexNum(GammaJS.logGamma(c));
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            try {
                if (F.isZero(arg1)) {
                    return F.CInfinity;
                }
                if (arg1 > 0.0) {
                    return Num.valueOf(GammaJS.logGamma(arg1));
                }
            }
            catch (MathIllegalStateException mathIllegalStateException) {
                // empty catch block
            }
            return F.NIL;
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            try {
                if (F.isZero(stack[top])) {
                    return Double.POSITIVE_INFINITY;
                }
                return GammaJS.logGamma(stack[top]);
            }
            catch (MathIllegalStateException mathIllegalStateException) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isInfinity() || arg1.isZero()) {
                return F.CInfinity;
            }
            if (arg1.isNegativeInfinity() || arg1.isDirectedInfinity(F.CI) || arg1.isDirectedInfinity(F.CNI) || arg1.isComplexInfinity()) {
                return F.CComplexInfinity;
            }
            if (arg1.isPositive()) {
                if (arg1.isInteger()) {
                    return F.Log(F.Factorial(arg1.dec()));
                }
                if (arg1.isFraction() && ((IFraction)arg1).denominator().equals(F.C2)) {
                    IInteger n = ((IFraction)arg1).numerator();
                    return F.Log(F.Times(F.Power((IExpr)F.C2, F.Subtract(F.C1, n)), F.Sqrt(S.Pi), F.Power((IExpr)F.Gamma(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)n, (IExpr)F.C1))), F.CN1), F.Gamma(n)));
                }
            } else if (arg1.isNegative() && arg1.isInteger()) {
                return F.CInfinity;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class InverseGammaRegularized
    extends AbstractFunctionEvaluator {
        private InverseGammaRegularized() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr a = ast.arg1();
            if (ast.isAST3()) {
                IExpr z1 = ast.arg2();
                IExpr z2 = ast.arg3();
                if (z1.isInfinity()) {
                    return F.InverseGammaRegularized(a, z2.negate());
                }
            } else {
                IExpr z = ast.arg2();
                if (a.isPositiveResult()) {
                    if (z.isZero()) {
                        return S.Infinity;
                    }
                    if (z.isOne()) {
                        return F.C0;
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class InverseBetaRegularized
    extends AbstractFunctionEvaluator {
        private InverseBetaRegularized() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST3()) {
                    IExpr z = ast.arg1();
                    IExpr a = ast.arg2();
                    IExpr b = ast.arg3();
                    if (a.isPositiveResult()) {
                        if (z.isZero()) {
                            return F.C0;
                        }
                        if (z.isOne()) {
                            return F.C1;
                        }
                    }
                    if (engine.isDoubleMode() && z.isNumericFunction(true) && a.isNumericFunction(true) && b.isNumericFunction(true)) {
                        BetaDistribution beta = new BetaDistribution(a.evalDouble(), b.evalDouble());
                        return F.num(beta.inverseCumulativeProbability(z.evalDouble()));
                    }
                } else {
                    IExpr z1 = ast.arg1();
                    IExpr z2 = ast.arg2();
                    if (z2.isZero()) {
                        return z1;
                    }
                    IExpr a = ast.arg3();
                    IExpr b = ast.arg4();
                    if (z1.isZero()) {
                        return F.InverseBetaRegularized(z2, a, b);
                    }
                }
            }
            catch (MathIllegalArgumentException miae) {
                return IOFunctions.printMessage(S.InverseBetaRegularized, "argillegal", F.list(F.stringx(miae.getMessage()), ast), engine);
            }
            catch (RuntimeException rex) {
                return IOFunctions.printMessage(S.InverseBetaRegularized, "argillegal", F.list(F.stringx(rex.getMessage()), ast), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_4;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class InverseErfc
    extends AbstractTrigArg1
    implements INumeric {
        private InverseErfc() {
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            if (arg1 >= 0.0 && arg1 <= 2.0) {
                try {
                    return Num.valueOf(org.hipparchus.special.Erf.erfcInv((double)arg1));
                }
                catch (MathIllegalStateException mathIllegalStateException) {
                    // empty catch block
                }
            }
            return F.NIL;
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            try {
                double arg1 = stack[top];
                if (arg1 >= 0.0 && arg1 <= 2.0) {
                    return org.hipparchus.special.Erf.erfcInv((double)arg1);
                }
            }
            catch (MathIllegalStateException mathIllegalStateException) {
                // empty catch block
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(x -> F.InverseErfc(x));
            }
            if (arg1.isReal()) {
                ISignedNumber z = (ISignedNumber)arg1;
                if (z.isZero()) {
                    return F.CInfinity;
                }
                if (z.isOne()) {
                    return F.C0;
                }
                if (z.equals(F.C2)) {
                    return F.CNInfinity;
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static final class InverseErf
    extends AbstractTrigArg1
    implements INumeric {
        private InverseErf() {
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            try {
                if (arg1 >= -1.0 && arg1 <= 1.0) {
                    return Num.valueOf(org.hipparchus.special.Erf.erfInv((double)arg1));
                }
            }
            catch (MathIllegalStateException mathIllegalStateException) {
                // empty catch block
            }
            return F.NIL;
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            try {
                double arg1 = stack[top];
                if (arg1 >= -1.0 && arg1 <= 1.0) {
                    return org.hipparchus.special.Erf.erfInv((double)arg1);
                }
            }
            catch (MathIllegalStateException mathIllegalStateException) {
                // empty catch block
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(x -> F.InverseErf(x));
            }
            if (arg1.isReal()) {
                if (arg1.isZero()) {
                    return F.C0;
                }
                if (arg1.isOne()) {
                    return F.CInfinity;
                }
                if (arg1.isMinusOne()) {
                    return F.CNInfinity;
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static final class HurwitzZeta
    extends AbstractFunctionEvaluator {
        private HurwitzZeta() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr s = ast.arg1();
            IExpr a = ast.arg2();
            if (s.isNumber()) {
                if (s.isZero()) {
                    return F.Subtract(F.C1D2, a);
                }
                if (s.isOne()) {
                    return F.CComplexInfinity;
                }
            }
            if (a.isNumber()) {
                IInteger sInt;
                if (a.isZero() && s.isInteger() && s.isNegative()) {
                    return F.Times((IExpr)F.CN1, (IExpr)F.Divide(F.BernoulliB(F.Plus(1L, s.negate())), F.Plus(1L, s.negate())));
                }
                if (a.isOne()) {
                    return F.Zeta(s);
                }
                if (a.isNumEqualInteger(F.C2)) {
                    return F.Plus((IExpr)F.CN1, (IExpr)F.Zeta(s));
                }
                if (a.isNumEqualRational(F.C1D2)) {
                    return F.Times((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.C2, s)), (IExpr)F.Zeta(s));
                }
                if (a.isNumEqualRational(F.C3D4) && a.isNumEqualRational(F.C3D4)) {
                    return F.Plus((IExpr)F.Times((IExpr)F.CN8, (IExpr)S.Catalan), (IExpr)F.Sqr(S.Pi));
                }
                if (s.isInteger() && a.isInteger() && a.isPositive() && ((sInt = (IInteger)s).isNegative() || sInt.isEven())) {
                    int n = a.toIntDefault();
                    int sNegate = sInt.negate().toIntDefault();
                    if (n > Integer.MIN_VALUE && sNegate > Integer.MIN_VALUE) {
                        return F.Subtract(F.Zeta(s), F.sum(k -> k.power(sNegate), 1, n - 1));
                    }
                }
            }
            if (engine.isDoubleMode()) {
                try {
                    double sDouble = Double.NaN;
                    double aDouble = Double.NaN;
                    try {
                        sDouble = s.evalDouble();
                        aDouble = a.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (aDouble < 0.0 || Double.isNaN(sDouble) || Double.isNaN(aDouble)) {
                        Complex sc = s.evalComplex();
                        Complex ac = a.evalComplex();
                        return F.complexNum(ZetaJS.hurwitzZeta(sc, ac));
                    }
                    if (aDouble >= 0.0 && sDouble != 1.0) {
                        return F.num(ZetaJS.hurwitzZeta(sDouble, aDouble));
                    }
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (ThrowException te) {
                    LOGGER.debug("HurwitzZeta.evaluate() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class HypergeometricPFQRegularized
    extends AbstractFunctionEvaluator {
        private HypergeometricPFQRegularized() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static class GammaRegularized
    extends AbstractFunctionEvaluator {
        private GammaRegularized() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IExpr a = ast.arg1();
                IExpr z1 = ast.arg2();
                if (ast.isAST3()) {
                    IExpr z2 = ast.arg3();
                    return GammaRegularized.gammaRegularzed3(a, z1, z2, ast, engine);
                }
                return GammaRegularized.gammaRegularized2(a, z1, ast, engine);
            }
            catch (MathIllegalArgumentException miae) {
                return IOFunctions.printMessage(S.GammaRegularized, "argillegal", F.list(F.stringx(miae.getMessage()), ast), engine);
            }
            catch (RuntimeException rex) {
                return IOFunctions.printMessage(S.GammaRegularized, "argillegal", F.list(F.stringx(rex.getMessage()), ast), engine);
            }
        }

        private static IExpr gammaRegularized2(IExpr a, IExpr z1, IAST ast, EvalEngine engine) {
            if (a.isZero()) {
                return F.C0;
            }
            if (a.isNumEqualRational(F.C1D2)) {
                return F.Erfc(F.Sqrt(z1));
            }
            if (a.isOne()) {
                return F.Power((IExpr)S.E, F.Negate(z1));
            }
            if (a.isInteger() && a.isNegative()) {
                return F.C0;
            }
            if (engine.isDoubleMode()) {
                try {
                    double aDouble = Double.NaN;
                    double z1Double = Double.NaN;
                    try {
                        aDouble = a.evalDouble();
                        z1Double = z1.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (!Double.isNaN(aDouble) && !Double.isNaN(z1Double)) {
                        return F.num(GammaJS.gammaRegularized(aDouble, z1Double));
                    }
                }
                catch (ThrowException te) {
                    LOGGER.debug("GammaRegularized.gammaRegularized2() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            if (z1.isZero()) {
                IExpr temp = a.re();
                if (temp.isPositive()) {
                    return F.C1;
                }
                if (temp.isNegative()) {
                    return F.CComplexInfinity;
                }
            } else if (z1.isMinusOne()) {
                return F.Times((IExpr)S.E, F.Power((IExpr)F.Gamma(a), -1L), (IExpr)F.Subfactorial(F.Plus((IExpr)F.CN1, a)));
            }
            return F.NIL;
        }

        private static IExpr gammaRegularzed3(IExpr a, IExpr z1, IExpr z2, IAST ast, EvalEngine engine) {
            if (engine.isDoubleMode()) {
                try {
                    double aDouble = Double.NaN;
                    double z1Double = Double.NaN;
                    double z2Double = Double.NaN;
                    try {
                        aDouble = a.evalDouble();
                        z1Double = z1.evalDouble();
                        z2Double = z2.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (!(Double.isNaN(aDouble) || Double.isNaN(z1Double) || Double.isNaN(z2Double))) {
                        return F.num(GammaJS.gammaRegularized(aDouble, z1Double, z2Double));
                    }
                }
                catch (ThrowException te) {
                    LOGGER.debug("GammaRegularized.gammaRegularzed3() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            if (a.isOne()) {
                return F.Subtract(F.Power((IExpr)S.E, F.Negate(z1)), F.Power((IExpr)S.E, F.Negate(z2)));
            }
            if (a.isInteger() && a.isNegative()) {
                return F.C0;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class Erfi
    extends AbstractFunctionEvaluator {
        private Erfi() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (z.isZero()) {
                return F.C0;
            }
            if (z.isNumber()) {
                INumber num = (INumber)((INumber)z).times(F.CI);
                return F.Times((IExpr)F.CI, (IExpr)F.Erf(F.Times((IExpr)num)));
            }
            if (z.isInfinity()) {
                return F.CInfinity;
            }
            if (z.isNegativeInfinity()) {
                return F.CNInfinity;
            }
            if (z.equals(F.CIInfinity)) {
                return F.CI;
            }
            if (z.equals(F.CNIInfinity)) {
                return F.CNI;
            }
            if (z.isComplexInfinity()) {
                return S.Indeterminate;
            }
            if (z.isTimes() && z.first().isComplex() && z.first().re().isZero()) {
                return F.Times((IExpr)S.I, (IExpr)F.Erf(F.Times((IExpr)F.CNI, z)));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(z);
            if (negExpr.isPresent()) {
                return F.Negate(F.Erfi(negExpr));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class Erfc
    extends AbstractTrigArg1
    implements INumeric {
        private Erfc() {
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            try {
                return Num.valueOf(de.lab4inf.math.functions.Erf.erfc((double)arg1));
            }
            catch (MathIllegalStateException mathIllegalStateException) {
                return F.NIL;
            }
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            try {
                double arg1 = stack[top];
                return de.lab4inf.math.functions.Erf.erfc((double)arg1);
            }
            catch (MathIllegalStateException mathIllegalStateException) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isReal()) {
                if (arg1.isZero()) {
                    return F.C1;
                }
                if (arg1.equals(F.CInfinity)) {
                    return F.C0;
                }
                if (arg1.equals(F.CNInfinity)) {
                    return F.C2;
                }
                if (arg1.isComplexInfinity()) {
                    return S.Indeterminate;
                }
                if (arg1.isDirectedInfinity(F.CI) || arg1.isDirectedInfinity(F.CNI)) {
                    return arg1.negate();
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class Erf
    extends AbstractTrigArg1
    implements INumeric,
    DoubleUnaryOperator {
        private Erf() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return de.lab4inf.math.functions.Erf.erf((double)operand);
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            try {
                return Num.valueOf(de.lab4inf.math.functions.Erf.erf((double)arg1));
            }
            catch (MathIllegalStateException mathIllegalStateException) {
                return F.NIL;
            }
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            try {
                return de.lab4inf.math.functions.Erf.erf((double)stack[top]);
            }
            catch (MathIllegalStateException mathIllegalStateException) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isZero()) {
                return F.C0;
            }
            if (arg1.equals(F.CInfinity)) {
                return F.C1;
            }
            if (arg1.equals(F.CNInfinity)) {
                return F.CN1;
            }
            if (arg1.isComplexInfinity()) {
                return S.Indeterminate;
            }
            if (arg1.isDirectedInfinity(F.CI) || arg1.isDirectedInfinity(F.CNI)) {
                return arg1;
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.Erf(negExpr));
            }
            return F.NIL;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 3) {
                return F.Subtract(F.Erf(ast.arg2()), F.Erf(ast.arg1()));
            }
            return super.evaluate(ast, engine);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class DirichletEta
    extends AbstractArg1 {
        private DirichletEta() {
        }

        @Override
        public IExpr e1DblArg(double d) {
            return F.complexNum(ZetaJS.dirichletEta(d));
        }

        @Override
        public IExpr e1ComplexArg(Complex c) {
            return F.complexNum(ZetaJS.dirichletEta(c));
        }

        @Override
        public IExpr e1ObjArg(IExpr arg1) {
            if (arg1.isMinusOne()) {
                return F.C1D4;
            }
            if (arg1.isZero()) {
                return F.C1D2;
            }
            if (arg1.isOne()) {
                return F.Log(F.C2);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class BetaRegularized
    extends AbstractFunctionEvaluator {
        private BetaRegularized() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST3()) {
                return BetaRegularized.betaRegularized3(ast, engine);
            }
            if (ast.argSize() == 4) {
                return BetaRegularized.betaRegularized4(ast, engine);
            }
            return F.NIL;
        }

        private static IExpr betaRegularized3(IAST ast, EvalEngine engine) {
            try {
                int ni;
                IExpr z = ast.arg1();
                IExpr a = ast.arg2();
                IExpr n = ast.arg3();
                if (a.isZero() || a.isInteger() && a.isNegative()) {
                    if (n.isZero() || n.isInteger() && n.isNegative()) {
                        return S.Indeterminate;
                    }
                    return F.C1;
                }
                if (n.isZero() || n.isInteger() && n.isNegative()) {
                    return F.C0;
                }
                if (z.isZero()) {
                    if (engine.evalGreater(F.Re(a), F.C0)) {
                        return F.C0;
                    }
                    if (engine.evalLess(F.Re(a), F.C0)) {
                        return F.CComplexInfinity;
                    }
                } else if (z.isOne() && engine.evalGreater(F.Re(n), F.C0)) {
                    return F.C1;
                }
                if (engine.isDoubleMode()) {
                    try {
                        int nInt;
                        double zn = engine.evalDouble(z);
                        double an = engine.evalDouble(a);
                        double nn = engine.evalDouble(n);
                        int iterationLimit = EvalEngine.get().getIterationLimit();
                        int aInt = (int)an;
                        if (aInt > iterationLimit && iterationLimit > 0) {
                            IterationLimitExceeded.throwIt(aInt, ast.topHead());
                        }
                        if ((nInt = (int)nn) > iterationLimit && iterationLimit > 0) {
                            IterationLimitExceeded.throwIt(nInt, ast.topHead());
                        }
                        return F.num(GammaJS.betaRegularized(zn, an, nn));
                    }
                    catch (ValidateException zn) {
                        // empty catch block
                    }
                }
                if ((ni = n.toIntDefault()) != Integer.MIN_VALUE) {
                    if (ni < 0) {
                        return F.C0;
                    }
                    if (ni > Config.MAX_POLYNOMIAL_DEGREE) {
                        PolynomialDegreeLimitExceeded.throwIt(ni);
                    }
                    IASTAppendable sum = F.PlusAlloc(ni);
                    for (int k = 0; k < ni; ++k) {
                        IInteger kk = F.ZZ(k);
                        sum.append(F.Times((IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, F.Negate(z)), kk), F.Power((IExpr)F.Factorial(kk), -1L), (IExpr)F.Pochhammer(a, kk)));
                    }
                    return F.Times((IExpr)F.Power(z, a), (IExpr)sum);
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("BetaRegularized.betaRegularized3() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        private static IExpr betaRegularized4(IAST ast, EvalEngine engine) {
            try {
                IExpr z = ast.arg1();
                IExpr a = ast.arg2();
                IExpr n = ast.arg3();
                IExpr w = ast.arg4();
                if (engine.isDoubleMode()) {
                    try {
                        int nInt;
                        double zn = engine.evalDouble(z);
                        double an = engine.evalDouble(a);
                        double nn = engine.evalDouble(n);
                        double wn = engine.evalDouble(w);
                        int iterationLimit = EvalEngine.get().getIterationLimit();
                        int aInt = (int)an;
                        if (aInt > iterationLimit && iterationLimit > 0) {
                            IterationLimitExceeded.throwIt(aInt, ast.topHead());
                        }
                        if ((nInt = (int)nn) > iterationLimit && iterationLimit > 0) {
                            IterationLimitExceeded.throwIt(nInt, ast.topHead());
                        }
                        return F.num(GammaJS.betaRegularized(zn, an, nn, wn));
                    }
                    catch (IllegalArgumentException | ValidateException object) {}
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("BetaRegularized.betaRegularized4() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class Beta
    extends AbstractFunctionEvaluator {
        private Beta() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 4) {
                IExpr z = ast.arg1();
                IExpr a = ast.arg2();
                IExpr b = ast.arg3();
                try {
                    if (engine.isDoubleMode()) {
                        double aDouble = Double.NaN;
                        double bDouble = Double.NaN;
                        double zDouble = Double.NaN;
                        try {
                            zDouble = z.evalDouble();
                            aDouble = a.evalDouble();
                            bDouble = b.evalDouble();
                        }
                        catch (ValidateException validateException) {
                            // empty catch block
                        }
                        if (Double.isNaN(aDouble) || Double.isNaN(bDouble) || Double.isNaN(zDouble)) {
                            Complex zc = z.evalComplex();
                            Complex ac = a.evalComplex();
                            Complex bc = b.evalComplex();
                            return F.complexNum(GammaJS.beta(zc, ac, bc));
                        }
                        return GammaJS.incompleteBeta(zDouble, aDouble, bDouble);
                    }
                    int bInt = b.toIntDefault();
                    if (bInt > 0) {
                        IInteger n = F.ZZ(bInt);
                        if (a.isOne()) {
                            return F.Times((IExpr)F.Power((IExpr)n, F.CN1), (IExpr)F.Subtract(F.C1, F.Power((IExpr)F.Subtract(F.C1, z), n)));
                        }
                    }
                }
                catch (ThrowException te) {
                    LOGGER.debug("Beta.evaluate() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
                return F.NIL;
            }
            IExpr a = ast.arg1();
            IExpr b = ast.arg2();
            if (a.isZero() || b.isZero()) {
                return F.CComplexInfinity;
            }
            try {
                if (engine.isDoubleMode()) {
                    double aDouble = Double.NaN;
                    double bDouble = Double.NaN;
                    try {
                        aDouble = a.evalDouble();
                        bDouble = b.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(aDouble) || Double.isNaN(bDouble)) {
                        Complex ac = a.evalComplex();
                        Complex bc = b.evalComplex();
                        return F.complexNum(GammaJS.beta(ac, bc));
                    }
                    return F.num(GammaJS.beta(aDouble, bDouble));
                }
                if (a.isNumber() && b.isNumber()) {
                    if (a.isInteger() && a.isPositive() && b.isInteger() && b.isPositive()) {
                        return F.Times((IExpr)F.Factorial(F.Plus((IExpr)F.CN1, a)), (IExpr)F.Factorial(F.Plus((IExpr)F.CN1, b)), F.Power((IExpr)F.Factorial(F.Plus((IExpr)F.CN1, a, b)), -1L));
                    }
                    return F.Times((IExpr)F.Gamma(a), (IExpr)F.Gamma(b), F.Power((IExpr)F.Gamma(F.Plus(a, b)), -1L));
                }
                IExpr s = a.inc().subtract(b);
                if (s.isZero()) {
                    return F.Power((IExpr)F.Times(a, b, (IExpr)F.CatalanNumber(a)), -1L);
                }
                IExpr sum = a.plus(b);
                if (sum.isInteger() && sum.isNegative()) {
                    return F.C0;
                }
            }
            catch (ThrowException te) {
                LOGGER.debug("Beta.evaluate() failed", (Throwable)((Object)te));
                return te.getValue();
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Beta.setEvaluator(new Beta());
            S.BetaRegularized.setEvaluator(new BetaRegularized());
            S.DirichletEta.setEvaluator(new DirichletEta());
            S.Erf.setEvaluator(new Erf());
            S.Erfc.setEvaluator(new Erfc());
            S.Erfi.setEvaluator(new Erfi());
            S.GammaRegularized.setEvaluator(new GammaRegularized());
            S.HurwitzZeta.setEvaluator(new HurwitzZeta());
            S.HypergeometricPFQRegularized.setEvaluator(new HypergeometricPFQRegularized());
            S.InverseErf.setEvaluator(new InverseErf());
            S.InverseErfc.setEvaluator(new InverseErfc());
            S.InverseBetaRegularized.setEvaluator(new InverseBetaRegularized());
            S.InverseGammaRegularized.setEvaluator(new InverseGammaRegularized());
            S.LogGamma.setEvaluator(new LogGamma());
            S.MeijerG.setEvaluator(new MeijerG());
            S.PolyGamma.setEvaluator(new PolyGamma());
            S.PolyLog.setEvaluator(new PolyLog());
            S.ProductLog.setEvaluator(new ProductLog());
            S.StieltjesGamma.setEvaluator(new StieltjesGamma());
            S.StruveH.setEvaluator(new StruveH());
            S.StruveL.setEvaluator(new StruveL());
            S.Zeta.setEvaluator(new Zeta());
        }
    }
}

