/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.SparseArrayExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISparseArray;
import org.matheclipse.core.interfaces.ISymbol;

public class SparseArrayFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void initialize() {
        Initializer.init();
    }

    private SparseArrayFunctions() {
    }

    private static class SparseArray
    extends AbstractFunctionEvaluator {
        private SparseArray() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isSparseArray()) {
                return F.NIL;
            }
            IExpr arg1 = ast.arg1();
            IExpr defaultValue = F.NIL;
            if (ast.size() >= 4) {
                defaultValue = ast.arg3();
            }
            int defaultDimension = -1;
            int[] dimension = null;
            if (ast.size() >= 3) {
                IExpr arg2 = ast.arg2();
                if (!arg2.equals(S.Automatic)) {
                    if (arg2.isList()) {
                        dimension = Validate.checkListOfInts(ast, arg2, 1, Integer.MAX_VALUE, engine);
                    } else {
                        defaultDimension = arg2.toIntDefault();
                        if (defaultDimension < 0) {
                            return F.NIL;
                        }
                    }
                }
                if (ast.size() == 5 && dimension != null && arg1.equals(S.Automatic) && ast.arg4().isList3()) {
                    IAST list = (IAST)ast.arg4();
                    int version = list.arg1().toIntDefault();
                    if (version == 1 && list.arg2().isList2() && list.arg3().isList()) {
                        IAST nonZeroValues;
                        IAST columnIndices;
                        int[] rowPointers;
                        SparseArrayExpr result;
                        IAST second = (IAST)list.arg2();
                        int[] columnIndicesDimension = second.arg2().isMatrix(false);
                        if (second.arg1().isList() && columnIndicesDimension != null && (result = SparseArrayExpr.newInputForm(dimension, defaultValue, rowPointers = Validate.checkListOfInts(ast, second.arg1(), 0, Integer.MAX_VALUE, engine), columnIndices = (IAST)second.arg2(), nonZeroValues = (IAST)list.arg3())) != null) {
                            return result;
                        }
                    }
                    return F.NIL;
                }
            }
            SparseArrayExpr result = null;
            if (arg1.isListOfRules()) {
                if (arg1.size() < 2) {
                    return IOFunctions.printMessage(ast.topHead(), "exdims", F.list(arg1), engine);
                }
                result = SparseArrayExpr.newArrayRules((IAST)arg1, dimension, defaultDimension, defaultValue);
            } else if (arg1.isList()) {
                if (arg1.size() < 2) {
                    return IOFunctions.printMessage(ast.topHead(), "exdims", F.list(arg1), engine);
                }
                result = SparseArrayExpr.newDenseList((IAST)arg1.normal(false), defaultValue);
            } else if (arg1.isSparseArray()) {
                IASTMutable list;
                SparseArrayExpr sparseArray = (SparseArrayExpr)arg1;
                boolean checkedDimensions = true;
                if (dimension != null) {
                    int[] dims = sparseArray.getDimension();
                    checkedDimensions = Arrays.equals(dimension, dims);
                }
                if (checkedDimensions) {
                    if (!defaultValue.isPresent() || defaultValue.equals(sparseArray.getDefaultValue())) {
                        return sparseArray;
                    }
                    if (defaultValue.isPresent() && (list = sparseArray.normal(false)).isPresent()) {
                        result = SparseArrayExpr.newDenseList(list, defaultValue);
                    }
                }
                if (dimension != null && (list = sparseArray.normal(dimension)).isPresent()) {
                    result = SparseArrayExpr.newDenseList(list, defaultValue);
                }
            } else if (arg1.isRule()) {
                result = SparseArrayExpr.newArrayRules(F.list(arg1), dimension, defaultDimension, defaultValue);
            }
            if (result != null) {
                return result;
            }
            return IOFunctions.printMessage(ast.topHead(), "list", F.list(F.C1, ast), engine);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4;
        }
    }

    private static class ArrayRules
    extends AbstractFunctionEvaluator {
        private ArrayRules() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr defaultValue = F.C0;
            if (ast.isAST2()) {
                defaultValue = ast.arg2();
            }
            if (arg1.isSparseArray()) {
                ISparseArray sparseArray = (ISparseArray)arg1;
                IExpr d = sparseArray.getDefaultValue();
                if (ast.isAST1()) {
                    defaultValue = d;
                } else if (ast.isAST2() && !d.equals(defaultValue)) {
                    LOGGER.log(engine.getLogLevel(), "{}: Sparse array default value: {} unequals default value {}", (Object)ast.topHead(), (Object)d, (Object)defaultValue);
                    return F.NIL;
                }
                return sparseArray.arrayRules();
            }
            if (arg1.isList()) {
                return SparseArrayExpr.arrayRules((IAST)arg1, defaultValue);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.ArrayRules.setEvaluator(new ArrayRules());
            S.SparseArray.setEvaluator(new SparseArray());
        }
    }
}

