/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.expression.BuiltInSymbol;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.ID;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class SourceCodeFunctions {
    static final String GITHUB = "https://github.com/";
    static final String CORE_POM_PATH = "axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/";
    static final String IO_POM_PATH = "axkr/symja_android_library/blob/master/symja_android_library/matheclipse-io/";
    static final String SRC_PATH = "src/main/java/";

    private static String buildURL(Class<?> clazz, int line) {
        String canonicalName = clazz.getCanonicalName();
        String packageName = clazz.getPackage().getName();
        String parentClass = canonicalName.substring(packageName.length() + 1);
        StringBuilder buf = new StringBuilder(512);
        buf.append(GITHUB);
        if (packageName.startsWith("org.matheclipse.io")) {
            buf.append(IO_POM_PATH);
        } else {
            buf.append(CORE_POM_PATH);
        }
        buf.append(SRC_PATH);
        int index = parentClass.indexOf(46);
        if (index > 0) {
            parentClass = parentClass.substring(0, index);
        }
        String packagePath = packageName.replace('.', '/');
        buf.append(packagePath);
        buf.append('/');
        buf.append(parentClass);
        buf.append(".java#L");
        buf.append(line);
        return buf.toString();
    }

    public static String functionURL(ISymbol builtin) {
        IEvaluator evaluator;
        int line;
        int ordinal = builtin.ordinal();
        if (ordinal > 0 && ordinal < ID.LINE_NUMBER_OF_JAVA_CLASS.length && (line = ID.LINE_NUMBER_OF_JAVA_CLASS[ordinal]) > 0 && (evaluator = ((IBuiltInSymbol)builtin).getEvaluator()) != null && evaluator != BuiltInSymbol.DUMMY_EVALUATOR) {
            Class<?> clazz = evaluator.getClass();
            return SourceCodeFunctions.buildURL(clazz, line);
        }
        return null;
    }

    public static void initialize() {
        Initializer.init();
    }

    private SourceCodeFunctions() {
    }

    private static class FunctionURL
    extends AbstractEvaluator {
        private FunctionURL() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IBuiltInSymbol builtin;
            String url;
            if (ast.arg1().isBuiltInSymbol() && (url = SourceCodeFunctions.functionURL(builtin = (IBuiltInSymbol)ast.arg1())) != null) {
                return F.stringx(url);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.FunctionURL.setEvaluator(new FunctionURL());
        }
    }
}

