/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.builtin.AssumptionFunctions;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Assumptions;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.hash.HashedOrderlessMatcherPlus;
import org.matheclipse.core.patternmatching.hash.HashedPatternRules;
import org.matheclipse.core.visit.AbstractVisitorBoolean;
import org.matheclipse.core.visit.VisitorExpr;

public class SimplifyFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void initialize() {
        Initializer.init();
    }

    private SimplifyFunctions() {
    }

    private static class FullSimplify
    extends Simplify {
        private FullSimplify() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return super.evaluate(ast, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public boolean isFullSimplifyMode() {
            return true;
        }
    }

    private static class Simplify
    extends AbstractFunctionEvaluator {
        private static HashedOrderlessMatcherPlus PLUS_ORDERLESS_MATCHER = new HashedOrderlessMatcherPlus();

        private Simplify() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr result;
            IExpr arg1 = ast.arg1();
            if (arg1.isAtom() && ast.isAST1()) {
                return arg1;
            }
            if (arg1.isAST()) {
                IAST list1 = (IAST)arg1;
                int headID = list1.headID();
                switch (headID) {
                    case 786: {
                        return list1.mapThread(ast, 1);
                    }
                    case 1153: {
                        if (list1.size() != 3) break;
                        return F.Rule((IExpr)ast.setAtClone(1, list1.arg1()), (IExpr)ast.setAtClone(1, list1.arg2()));
                    }
                    case 423: 
                    case 571: 
                    case 572: 
                    case 753: 
                    case 754: 
                    case 1381: {
                        if (list1.size() != 3 || list1.arg2().isZero()) break;
                        IASTAppendable sub = ast.setAtClone(1, F.Subtract(list1.arg1(), list1.arg2()));
                        return F.binaryAST2(list1.head(), sub, (IExpr)F.C0);
                    }
                }
            }
            if ((result = engine.getCache(ast)) != null) {
                return result;
            }
            IExpr complexityFunctionHead = F.NIL;
            OptionArgs options = null;
            if (ast.size() > 2) {
                options = new OptionArgs(ast.topHead(), ast, ast.argSize(), engine);
                complexityFunctionHead = options.getOptionAutomatic(S.ComplexityFunction);
            }
            IExpr assumptionExpr = OptionArgs.determineAssumptions(ast, 2, options);
            IAssumptions oldAssumptions = engine.getAssumptions();
            try {
                IExpr temp;
                IAssumptions assumptions;
                Function<IExpr, Long> complexityFunction = Simplify.createComplexityFunction(complexityFunctionHead, engine);
                long minCounter = complexityFunction.apply(arg1);
                result = arg1;
                long count = 0L;
                if (assumptionExpr.isPresent() && assumptionExpr.isAST() && (assumptions = Assumptions.getInstance(assumptionExpr)) != null) {
                    engine.setAssumptions(assumptions);
                    arg1 = AssumptionFunctions.refineAssumptions(arg1, assumptions, engine);
                    count = complexityFunction.apply(arg1);
                    if (count < minCounter) {
                        minCounter = count;
                        result = arg1;
                    }
                }
                if ((temp = arg1.replaceAll(F.list(F.Rule((IExpr)S.GoldenAngle, (IExpr)F.Times((IExpr)F.Subtract(F.C3, F.CSqrt5), (IExpr)S.Pi)), F.Rule((IExpr)S.GoldenRatio, (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.C1, (IExpr)F.CSqrt5))), F.Rule((IExpr)S.Degree, (IExpr)F.Divide(S.Pi, F.ZZ(180)))))).isPresent()) {
                    arg1 = temp;
                }
                temp = Simplify.simplifyStep(arg1, complexityFunction, minCounter, result, engine, this.isFullSimplifyMode());
                engine.putCache(ast, temp);
                IExpr iExpr = temp;
                return iExpr;
            }
            catch (ArithmeticException arithmeticException) {
            }
            finally {
                engine.setAssumptions(oldAssumptions);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Assumptions, (IExpr)S.$Assumptions), F.Rule((IExpr)S.ComplexityFunction, (IExpr)S.Automatic)));
        }

        private static IExpr simplifyStep(IExpr arg1, Function<IExpr, Long> complexityFunction, long minCounter, IExpr result, EvalEngine engine, boolean fullSimplify) {
            IExpr temp = arg1.accept(new SimplifyVisitor(complexityFunction, engine, fullSimplify));
            while (temp.isPresent()) {
                long count = complexityFunction.apply(temp);
                if (count == minCounter) {
                    return temp;
                }
                if (count < minCounter) {
                    minCounter = count;
                    result = temp;
                    temp = result.accept(new SimplifyVisitor(complexityFunction, engine, fullSimplify));
                    continue;
                }
                return result;
            }
            return result;
        }

        public boolean isFullSimplifyMode() {
            return false;
        }

        private static Function<IExpr, Long> createComplexityFunction(IExpr complexityFunctionHead, EvalEngine engine) {
            Function<IExpr, Long> complexityFunction = x -> x.leafCountSimplify();
            if (complexityFunctionHead.isPresent()) {
                IExpr head = complexityFunctionHead;
                complexityFunction = x -> {
                    IExpr temp = engine.evaluate(F.unaryAST1(head, x));
                    if (temp.isInteger() && !temp.isNegative()) {
                        return ((IInteger)temp).toLong();
                    }
                    return Long.MAX_VALUE;
                };
            }
            return complexityFunction;
        }

        static {
            PLUS_ORDERLESS_MATCHER.defineHashRule(new HashedPatternRules(F.Cosh(F.x_), F.Sinh(F.x_), F.Exp(S.x), false, null, true));
        }

        private static class SimplifyVisitor
        extends VisitorExpr {
            final IsBasicExpressionVisitor isBasicAST = new IsBasicExpressionVisitor();
            final Function<IExpr, Long> fComplexityFunction;
            final boolean fFullSimplify;
            final EvalEngine fEngine;
            private static final int UNDEFINED = -1;
            private static final int SQR_ARG = 1;
            private static final int NEGATIVE_SQR_ARG = 2;

            public SimplifyVisitor(Function<IExpr, Long> complexityFunction, EvalEngine engine, boolean fullSimplify) {
                this.fEngine = engine;
                this.fComplexityFunction = complexityFunction;
                this.fFullSimplify = fullSimplify;
            }

            private IExpr tryExpandTransformation(IAST plusAST, IExpr test) {
                IExpr result = F.NIL;
                long minCounter = this.fComplexityFunction.apply(plusAST);
                try {
                    IExpr temp = F.evalExpand(test);
                    long count = this.fComplexityFunction.apply(temp);
                    if (count < minCounter) {
                        result = temp;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return result;
            }

            private IExpr tryTransformations(IExpr expr) {
                IExpr temp;
                if (!expr.isAST()) {
                    return F.NIL;
                }
                SimplifiedResult sResult = new SimplifiedResult(expr, this.fComplexityFunction.apply(expr));
                long expandAllCounter = 0L;
                if (expr.isTimes()) {
                    temp = SimplifyVisitor.tryTimesLog((IAST)expr);
                    if (temp.isPresent()) {
                        sResult.checkLessEqual(temp, this.fComplexityFunction.apply(temp));
                    }
                } else if (expr.isPlus()) {
                    IExpr[] commonFactors;
                    temp = Algebra.factorTermsPlus((IAST)expr, EvalEngine.get());
                    if (temp.isPresent()) {
                        sResult.checkLessEqual(temp, this.fComplexityFunction.apply(temp));
                    }
                    if ((commonFactors = Algebra.InternalFindCommonFactorPlus.findCommonFactors((IAST)expr, true)) != null) {
                        temp = this.fEngine.evaluate(F.Times(commonFactors[0], commonFactors[1]));
                        sResult.checkLessEqual(temp, this.fComplexityFunction.apply(temp));
                    }
                    if ((temp = sResult.result.isPlus() ? SimplifyVisitor.tryPlusLog((IAST)sResult.result) : SimplifyVisitor.tryPlusLog((IAST)expr)).isPresent()) {
                        temp = this.fEngine.evaluate(temp);
                        sResult.checkLessEqual(temp, this.fComplexityFunction.apply(temp));
                    }
                }
                if (sResult.result.isAST()) {
                    expr = sResult.result;
                }
                try {
                    temp = F.evalExpandAll(expr);
                    expandAllCounter = this.fComplexityFunction.apply(temp);
                    sResult.checkLess(temp, expandAllCounter);
                }
                catch (RuntimeException commonFactors) {
                    // empty catch block
                }
                if (sResult.result.isAST()) {
                    expr = sResult.result;
                }
                if (((IAST)expr).hasTrigonometricFunction()) {
                    try {
                        temp = F.eval(F.TrigExpand(expr));
                        sResult.checkLess(temp, this.fComplexityFunction.apply(temp));
                    }
                    catch (ValidateException commonFactors) {
                        // empty catch block
                    }
                    try {
                        temp = F.eval(F.TrigToExp(expr));
                        if (!sResult.checkLess(temp, this.fComplexityFunction.apply(temp)) && this.fFullSimplify) {
                            temp = F.eval(F.Factor(temp));
                            sResult.checkLess(temp, this.fComplexityFunction.apply(temp));
                        }
                    }
                    catch (ValidateException commonFactors) {
                        // empty catch block
                    }
                    try {
                        temp = F.eval(F.TrigReduce(expr));
                        sResult.checkLess(temp, this.fComplexityFunction.apply(temp));
                    }
                    catch (ValidateException commonFactors) {
                        // empty catch block
                    }
                }
                try {
                    temp = F.eval(F.ExpToTrig(expr));
                    sResult.checkLess(temp, this.fComplexityFunction.apply(temp));
                }
                catch (ValidateException commonFactors) {
                    // empty catch block
                }
                try {
                    IExpr together = expr;
                    if (sResult.minCounter < 65L) {
                        together = F.eval(F.Together(expr));
                        sResult.checkLess(together, this.fComplexityFunction.apply(together));
                    }
                    if (this.fFullSimplify && together.isTimes()) {
                        IExpr[] parts = Algebra.getNumeratorDenominator((IAST)together, EvalEngine.get());
                        IExpr numerator = parts[0];
                        IExpr denominator = parts[1];
                        if (!numerator.isOne() && !denominator.isOne()) {
                            this.tryPolynomialQuotientRemainder(numerator, denominator, sResult);
                        }
                    }
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
                try {
                    temp = F.NIL;
                    if (this.fFullSimplify && expandAllCounter < 50L) {
                        temp = F.eval(F.Factor(expr));
                        sResult.checkLess(temp, this.fComplexityFunction.apply(temp));
                    }
                    if (expandAllCounter < 100L) {
                        temp = F.eval(F.FactorSquareFree(expr));
                        sResult.checkLess(temp, this.fComplexityFunction.apply(temp));
                    }
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
                try {
                    if (sResult.minCounter < 100L) {
                        temp = F.eval(F.Apart(expr));
                        sResult.checkLess(temp, this.fComplexityFunction.apply(temp));
                    }
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
                return sResult.result;
            }

            private void tryPolynomialQuotientRemainder(IExpr numerator, IExpr denominator, SimplifiedResult sResult) {
                IExpr arg1;
                IExpr temp;
                int i;
                VariablesSet variables = new VariablesSet(numerator);
                variables.addVarList(denominator);
                List<IExpr> vars = variables.getArrayList();
                boolean evaled = false;
                for (i = 0; i < vars.size(); ++i) {
                    temp = EvalEngine.get().evaluate(F.PolynomialQuotientRemainder(numerator, denominator, vars.get(i)));
                    if (!temp.isAST(S.List, 3) || !temp.second().isZero() || !sResult.checkLess(arg1 = temp.first(), this.fComplexityFunction.apply(arg1))) continue;
                    evaled = true;
                    break;
                }
                if (!evaled) {
                    for (i = 0; !(i >= vars.size() || (temp = EvalEngine.get().evaluate(F.PolynomialQuotientRemainder(denominator, numerator, vars.get(i)))).isAST(S.List, 3) && temp.second().isZero() && sResult.checkLess(arg1 = temp.first().reciprocal(), this.fComplexityFunction.apply(arg1))); ++i) {
                    }
                }
            }

            @Override
            public IExpr visit(IASTMutable ast) {
                SimplifiedResult sResult = new SimplifiedResult(F.NIL, this.fComplexityFunction.apply(ast));
                IExpr temp = this.visitAST(ast);
                if (temp.isPresent() && sResult.checkLessEqual(temp = this.fEngine.evaluate(temp), this.fComplexityFunction.apply(temp))) {
                    if (temp.isAST()) {
                        ast = (IASTMutable)temp;
                    } else {
                        return temp;
                    }
                }
                if (ast.isPower() ? (temp = this.visitPower(ast, sResult)).isPresent() : (ast.isTimes() ? (temp = this.visitTimes(ast, sResult)).isPresent() : ast.isPlus() && (temp = this.visitPlus(ast, sResult)).isPresent())) {
                    return temp;
                }
                temp = sResult.result;
                if (temp.isPresent()) {
                    if (temp.isAST()) {
                        ast = (IASTMutable)temp;
                    } else {
                        return temp;
                    }
                }
                temp = F.evalExpandAll(ast);
                sResult.checkLess(temp, this.fComplexityFunction.apply(temp));
                this.functionExpand(ast, sResult);
                return sResult.result;
            }

            private IExpr visitPower(IASTMutable powerAST, SimplifiedResult sResult) {
                if (powerAST.isPowerReciprocal() && powerAST.base().isPlus() && powerAST.base().size() == 3) {
                    IExpr powerSimplified;
                    IASTMutable plus2;
                    IAST plus1 = (IAST)powerAST.base();
                    IExpr expr = F.eval(F.Expand(F.Times((IExpr)plus1, (IExpr)(plus2 = plus1.setAtCopy(2, plus1.arg2().negate())))));
                    if (expr.isNumber() && !expr.isZero() && sResult.checkLess(powerSimplified = S.Times.of(expr.inverse(), plus2), this.fComplexityFunction.apply(powerSimplified))) {
                        return powerSimplified;
                    }
                } else if (powerAST.base().isE() && powerAST.exponent().isPlus()) {
                    IAST plusAST = (IAST)powerAST.exponent();
                    IASTAppendable plusResult = F.NIL;
                    IASTAppendable logFactor = F.NIL;
                    for (int i = 1; i < plusAST.size(); ++i) {
                        IExpr plusArg = plusAST.get(i);
                        if (plusArg.isTimes()) {
                            int indx2;
                            IAST timesAST = (IAST)plusArg;
                            int indx1 = timesAST.indexOf(x -> x.isLog());
                            if (indx1 > 0 && (indx2 = timesAST.indexOf(x -> x.isLog(), indx1 + 1)) < 0) {
                                if (!plusResult.isPresent()) {
                                    plusResult = plusAST.copyUntil(plusAST.size() - 1, i);
                                    logFactor = F.TimesAlloc(10);
                                }
                                logFactor.append(F.Power(timesAST.get(indx1).first(), timesAST.removeAtCopy(indx1)));
                                continue;
                            }
                        } else if (plusArg.isLog()) {
                            if (!plusResult.isPresent()) {
                                plusResult = plusAST.copyUntil(plusAST.size() - 1, i);
                                logFactor = F.TimesAlloc(10);
                            }
                            logFactor.append(plusArg.first());
                            continue;
                        }
                        if (!plusResult.isPresent()) continue;
                        plusResult.append(plusArg);
                    }
                    if (plusResult.isPresent()) {
                        logFactor.append(F.Power((IExpr)S.E, plusResult));
                        IExpr temp = this.fEngine.evaluate(logFactor);
                        sResult.checkLessEqual(temp, this.fComplexityFunction.apply(temp));
                    }
                }
                return F.NIL;
            }

            private IExpr visitTimes(IASTMutable timesAST, SimplifiedResult sResult) {
                IExpr denom;
                IExpr numer;
                IAST numerator;
                IExpr denominator = S.Denominator.of(timesAST);
                if (!denominator.isNumber() && ((numerator = F.Numerator(timesAST)).isTimes() || denominator.isTimes()) && S.PossibleZeroQ.ofQ(F.Subtract(numer = F.evalExpandAll(numerator), denom = F.evalExpandAll(denominator)))) {
                    return F.C1;
                }
                IExpr temp = this.reduceNumberFactor(timesAST);
                if (temp.isPresent()) {
                    sResult.result = temp;
                    sResult.minCounter = this.fComplexityFunction.apply(temp);
                }
                IASTAppendable newTimes = F.NIL;
                int i = 1;
                int lastIndex = -1;
                while (i < timesAST.size()) {
                    IExpr negExpr;
                    IExpr rhs;
                    IASTMutable plus2;
                    IAST plus1;
                    IExpr expr;
                    IExpr timesArg = timesAST.get(i);
                    if (timesArg.isPowerReciprocal() && timesArg.base().isPlus() && timesArg.base().size() == 3 && (expr = F.eval(F.Expand(F.Times((IExpr)(plus1 = (IAST)timesArg.base()), (IExpr)(plus2 = plus1.setAtCopy(2, plus1.arg2().negate())))))).isNumber() && !expr.isZero()) {
                        IASTMutable powerSimplified = F.Times(expr.inverse(), (IExpr)plus2);
                        if (newTimes.isPresent()) {
                            newTimes.set(i, powerSimplified);
                        } else {
                            newTimes = timesAST.setAtClone(i, powerSimplified);
                        }
                        ++i;
                        continue;
                    }
                    if (i + 1 < timesAST.size() && timesArg.isPower() && (this.fFullSimplify && timesArg.base().isAST() || timesArg.base().isPlus() && timesArg.base().first().isReal()) && (rhs = timesAST.get(i + 1)).isPower() && rhs.exponent().equals(timesArg.exponent()) && (this.fFullSimplify && rhs.base().isAST() || rhs.base().isPlus() && rhs.base().first().equals(timesArg.base().first()))) {
                        IAST powerSimplified;
                        if (this.fFullSimplify) {
                            long minCounter;
                            IASTMutable test = F.Times(timesArg.base(), rhs.base());
                            temp = Simplify.simplifyStep(test, this.fComplexityFunction, minCounter = this.fComplexityFunction.apply(test).longValue(), F.NIL, this.fEngine, this.fFullSimplify);
                            if (temp.isPresent()) {
                                powerSimplified = F.Power(temp, rhs.exponent());
                                if (newTimes.isPresent()) {
                                    newTimes.set(i, powerSimplified);
                                    newTimes.remove(i + 1);
                                } else {
                                    newTimes = timesAST.setAtClone(i, powerSimplified);
                                    newTimes.remove(i + 1);
                                }
                                ++i;
                                continue;
                            }
                        } else {
                            IAST rhsRest;
                            IAST lhsRest = timesArg.base().rest();
                            IExpr zeroCandidate = this.fEngine.evaluate(F.Plus((IExpr)lhsRest, (IExpr)(rhsRest = rhs.base().rest())));
                            if (zeroCandidate.isZero()) {
                                powerSimplified = F.Power((IExpr)F.Subtract(F.Sqr(rhs.base().first()), F.Sqr(lhsRest)), rhs.exponent());
                                if (newTimes.isPresent()) {
                                    newTimes.set(i, powerSimplified);
                                    newTimes.remove(i + 1);
                                } else {
                                    newTimes = timesAST.setAtClone(i, powerSimplified);
                                    newTimes.remove(i + 1);
                                }
                                ++i;
                                continue;
                            }
                        }
                    }
                    if (timesArg.isPlus() && (negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(timesArg.first())).isPresent()) {
                        if (lastIndex < 0) {
                            lastIndex = i;
                        } else {
                            if (!newTimes.isPresent()) {
                                newTimes = timesAST.copyAppendable();
                            }
                            newTimes.set(lastIndex, timesAST.get(lastIndex).negate());
                            newTimes.set(i, timesArg.negate());
                            lastIndex = -1;
                            ++i;
                            continue;
                        }
                    }
                    ++i;
                }
                if (newTimes.isPresent()) {
                    sResult.result = timesAST;
                    try {
                        temp = F.eval(newTimes);
                        if (sResult.checkLessEqual(temp, this.fComplexityFunction.apply(temp)) && temp.isAtom()) {
                            return temp;
                        }
                        if (sResult.checkLess(temp = F.eval(F.Expand(temp)), this.fComplexityFunction.apply(temp)) && temp.isAtom()) {
                            return temp;
                        }
                    }
                    catch (RuntimeException rex) {
                        LOGGER.debug("SimplifyVisitor.visitTimes() failed", (Throwable)rex);
                    }
                }
                if ((temp = this.tryTransformations(sResult.result.orElse(timesAST))).isPresent()) {
                    sResult.result = temp;
                }
                temp = sResult.result.orElse(timesAST);
                sResult.minCounter = this.fComplexityFunction.apply(temp);
                this.functionExpand(temp, sResult);
                return F.NIL;
            }

            private IExpr visitPlus(IASTMutable plusAST, SimplifiedResult sResult) {
                IExpr temp = this.tryArg1IsOnePlus(plusAST, sResult);
                if (temp.isPresent()) {
                    return temp;
                }
                temp = sResult.result;
                if (temp.isPlus()) {
                    plusAST = (IASTMutable)sResult.result;
                }
                IASTAppendable basicPlus = F.PlusAlloc(plusAST.size());
                IASTAppendable restPlus = F.PlusAlloc(plusAST.size());
                plusAST.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> {
                    if (x.accept(this.isBasicAST)) {
                        basicPlus.append((IExpr)x);
                    } else {
                        restPlus.append((IExpr)x);
                    }
                }));
                if (basicPlus.size() > 1 && (temp = this.tryTransformations(basicPlus.oneIdentity0())).isPresent()) {
                    if (!restPlus.isAST0()) {
                        temp = this.fEngine.evaluate(F.Plus(temp, (IExpr)restPlus));
                    }
                    if (!temp.isPlus()) {
                        return temp;
                    }
                    if (sResult.checkLess(temp, this.fComplexityFunction.apply(temp)) && (temp = sResult.result).isPlus()) {
                        plusAST = (IASTMutable)sResult.result;
                    }
                }
                if ((temp = this.tryTransformations(plusAST)).isPresent() && sResult.checkLessEqual(temp, this.fComplexityFunction.apply(temp))) {
                    temp = sResult.result;
                    if (temp.isPlus()) {
                        plusAST = (IASTMutable)sResult.result;
                    } else {
                        return temp;
                    }
                }
                if (this.fFullSimplify) {
                    HashedOrderlessMatcherPlus hashRuleMap = PLUS_ORDERLESS_MATCHER;
                    if (hashRuleMap != null) {
                        plusAST.setEvalFlags(plusAST.getEvalFlags() ^ 0x4000);
                        temp = hashRuleMap.evaluateRepeated(plusAST, this.fEngine);
                        if (temp.isPresent()) {
                            return this.fEngine.evaluate(temp);
                        }
                    }
                    this.functionExpand(plusAST, sResult);
                }
                return sResult.result;
            }

            private IExpr tryArg1IsOnePlus(IASTMutable plusAST, SimplifiedResult sResult) {
                IExpr plusArg1 = plusAST.arg1();
                if (plusArg1.isOne() || plusArg1.isMinusOne()) {
                    int iterIndx = 2;
                    while (iterIndx > 0) {
                        int[] indx = SimplifyVisitor.plusASTIndexOf(plusAST, iterIndx);
                        if (indx[0] > 0) {
                            IExpr arg1;
                            int id;
                            IAST trigFunction;
                            IAST power;
                            IAST transformResult = F.NIL;
                            boolean negate = false;
                            if (indx[1] == 1) {
                                power = (IAST)plusAST.get(indx[0]);
                                trigFunction = (IAST)power.base();
                                id = trigFunction.headID();
                                arg1 = trigFunction.arg1();
                                if (plusArg1.isOne()) {
                                    switch (id) {
                                        case 294: {
                                            transformResult = F.Csc(arg1);
                                            break;
                                        }
                                        case 304: {
                                            transformResult = F.Coth(arg1);
                                            break;
                                        }
                                        case 1195: {
                                            transformResult = F.Cosh(arg1);
                                            break;
                                        }
                                        case 1310: {
                                            transformResult = F.Sec(arg1);
                                        }
                                    }
                                } else {
                                    switch (id) {
                                        case 289: {
                                            transformResult = F.Sin(arg1);
                                            negate = true;
                                            break;
                                        }
                                        case 303: {
                                            transformResult = F.Cot(arg1);
                                            break;
                                        }
                                        case 291: {
                                            transformResult = F.Sinh(arg1);
                                            break;
                                        }
                                        case 295: {
                                            transformResult = F.Csch(arg1);
                                            break;
                                        }
                                        case 1165: {
                                            transformResult = F.Tan(arg1);
                                            break;
                                        }
                                        case 1166: {
                                            transformResult = F.Tanh(arg1);
                                            negate = true;
                                            break;
                                        }
                                        case 1190: {
                                            transformResult = F.Cos(arg1);
                                            negate = true;
                                            break;
                                        }
                                        case 1311: {
                                            transformResult = F.Sech(arg1);
                                            negate = true;
                                        }
                                    }
                                }
                            } else if (indx[1] == 2) {
                                power = (IAST)plusAST.get(indx[0]).second();
                                trigFunction = (IAST)power.base();
                                id = trigFunction.headID();
                                arg1 = trigFunction.arg1();
                                if (plusArg1.isOne()) {
                                    switch (id) {
                                        case 289: {
                                            transformResult = F.Sin(arg1);
                                            break;
                                        }
                                        case 291: {
                                            transformResult = F.Sinh(arg1);
                                            negate = true;
                                            break;
                                        }
                                        case 295: {
                                            transformResult = F.Csch(arg1);
                                            negate = true;
                                            break;
                                        }
                                        case 303: {
                                            transformResult = F.Cot(arg1);
                                            negate = true;
                                            break;
                                        }
                                        case 1165: {
                                            transformResult = F.Tan(arg1);
                                            negate = true;
                                            break;
                                        }
                                        case 1166: {
                                            transformResult = F.Tanh(arg1);
                                            break;
                                        }
                                        case 1190: {
                                            transformResult = F.Cos(arg1);
                                            break;
                                        }
                                        case 1311: {
                                            transformResult = F.Sech(arg1);
                                        }
                                    }
                                } else {
                                    switch (id) {
                                        case 294: {
                                            transformResult = F.Csc(arg1);
                                            negate = true;
                                            break;
                                        }
                                        case 304: {
                                            transformResult = F.Coth(arg1);
                                            negate = true;
                                            break;
                                        }
                                        case 1310: {
                                            transformResult = F.Sec(arg1);
                                            negate = true;
                                            break;
                                        }
                                        case 1195: {
                                            transformResult = F.Cosh(arg1);
                                            negate = true;
                                        }
                                    }
                                }
                            }
                            if (transformResult.isPresent()) {
                                IASTMutable result = plusAST.removeAtCopy(1);
                                if (negate) {
                                    result.set(indx[0] - 1, F.Power((IExpr)transformResult, F.C2).negate());
                                } else {
                                    result.set(indx[0] - 1, F.Power((IExpr)transformResult, F.C2));
                                }
                                IExpr temp = result.oneIdentity0();
                                if (temp.isPlus()) {
                                    sResult.checkLess(temp, this.fComplexityFunction.apply(temp));
                                    return F.NIL;
                                }
                                return temp;
                            }
                            iterIndx = indx[0] + 1;
                            continue;
                        }
                        return F.NIL;
                    }
                }
                return F.NIL;
            }

            private static int[] plusASTIndexOf(IASTMutable plusAST, int fromPosition) {
                for (int i = fromPosition; i < plusAST.size(); ++i) {
                    IExpr x = plusAST.get(i);
                    if (x.isPower() && x.exponent().isNumEqualInteger(F.C2) && x.base().size() == 2 && (x.base().isTrigFunction() || x.base().isHyperbolicFunction())) {
                        return new int[]{i, 1};
                    }
                    if (!x.isAST(S.Times, 3) || !x.first().isMinusOne() || !x.second().isPower() || !x.second().exponent().isNumEqualInteger(F.C2) || x.second().base().size() != 2 || !x.second().base().isTrigFunction() && !x.second().base().isHyperbolicFunction()) continue;
                    return new int[]{i, 2};
                }
                return new int[]{-1, -1};
            }

            private static IExpr tryPlusLog(IAST plusAST) {
                if (plusAST.size() > 2) {
                    IASTAppendable logPlus = F.PlusAlloc(plusAST.size());
                    IExpr a1 = F.NIL;
                    boolean evaled = false;
                    for (int i = 1; i < plusAST.size(); ++i) {
                        IExpr a2 = plusAST.get(i);
                        IExpr arg = F.NIL;
                        if (a2.isAST(S.Times, 3) && a2.first().isInteger() && a2.second().isLog() && a2.second().first().isReal()) {
                            arg = S.Power.of(a2.second().first(), a2.first());
                        } else if (a2.isLog() && a2.first().isReal()) {
                            arg = a2.first();
                        }
                        if (arg.isReal()) {
                            if (a1.isPresent()) {
                                a1 = a1.multiply(arg);
                                evaled = true;
                                continue;
                            }
                            a1 = arg;
                            continue;
                        }
                        logPlus.append(a2);
                    }
                    if (evaled) {
                        if (logPlus.isEmpty()) {
                            return F.Log.of(a1);
                        }
                        logPlus.append(F.Log(a1));
                        return logPlus;
                    }
                }
                return F.NIL;
            }

            private static IExpr tryTimesLog(IAST timesAST) {
                if (timesAST.size() > 2 && timesAST.first().isInteger() && !timesAST.first().isMinusOne()) {
                    for (int i = 2; i < timesAST.size(); ++i) {
                        IExpr temp = timesAST.get(i);
                        if (!temp.isLog() || !temp.first().isReal()) continue;
                        IAST result = timesAST.splice(i, 1, F.Log(S.Power.of(temp.first(), timesAST.first())));
                        return result.splice(1).oneIdentity0();
                    }
                }
                return F.NIL;
            }

            private void functionExpand(IExpr expr, SimplifiedResult sResult) {
                if (expr.isBooleanFunction()) {
                    try {
                        expr = F.eval(F.BooleanMinimize(expr));
                        sResult.checkLess(expr, this.fComplexityFunction.apply(expr));
                        return;
                    }
                    catch (RuntimeException runtimeException) {}
                } else if (this.fFullSimplify) {
                    try {
                        expr = F.eval(F.FunctionExpand(expr));
                        sResult.checkLess(expr, this.fComplexityFunction.apply(expr));
                    }
                    catch (RuntimeException runtimeException) {}
                } else if (expr.isLog() || expr.isPower() && expr.first().isAbs()) {
                    try {
                        expr = F.eval(F.FunctionExpand(expr));
                        sResult.checkLessEqual(expr, this.fComplexityFunction.apply(expr));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            }

            private IExpr reduceNumberFactor(IASTMutable timesAST) {
                IExpr temp;
                IASTAppendable basicTimes = F.TimesAlloc(timesAST.size());
                IASTAppendable restTimes = F.TimesAlloc(timesAST.size());
                INumber number = null;
                IExpr arg1 = timesAST.arg1();
                if (arg1.isNumber()) {
                    if (!arg1.isZero()) {
                        number = (INumber)arg1;
                    }
                } else if (arg1.isPlus()) {
                    long count;
                    IExpr negativeAST;
                    long minCounter = this.fComplexityFunction.apply(arg1);
                    IExpr imPart = AbstractFunctionEvaluator.getComplexExpr(arg1.first(), F.CI);
                    if (imPart.isPresent()) {
                        negativeAST = this.fEngine.evaluate(F.Distribute(F.Times((IExpr)F.CI, arg1)));
                        count = this.fComplexityFunction.apply(negativeAST);
                        if (count <= minCounter) {
                            return this.fEngine.evaluate(F.Times(negativeAST, (IExpr)F.Distribute(F.Times((IExpr)F.CNI, (IExpr)timesAST.rest()))));
                        }
                    } else {
                        negativeAST = this.fEngine.evaluate(F.Distribute(F.Times((IExpr)F.CN1, arg1)));
                        count = this.fComplexityFunction.apply(negativeAST);
                        if (count <= minCounter) {
                            IASTAppendable result = F.TimesAlloc(timesAST.size());
                            result.append(F.CN1);
                            result.append(negativeAST);
                            result.appendAll(timesAST, 2, timesAST.size());
                            return result;
                        }
                    }
                }
                IExpr reduced = F.NIL;
                for (int i = 1; i < timesAST.size(); ++i) {
                    temp = timesAST.get(i);
                    if (temp.accept(this.isBasicAST)) {
                        if (i != 1 && number != null) {
                            if (temp.isPlus()) {
                                reduced = this.tryExpand(timesAST, (IAST)temp, number, i, false);
                            } else if (temp.isPowerReciprocal() && temp.base().isPlus()) {
                                reduced = this.tryExpand(timesAST, (IAST)temp.base(), number.inverse(), i, true);
                            }
                            if (reduced.isPresent()) {
                                return reduced;
                            }
                        }
                        basicTimes.append(temp);
                        continue;
                    }
                    restTimes.append(temp);
                }
                if (basicTimes.size() > 1 && (temp = this.tryTransformations(basicTimes.oneIdentity0())).isPresent()) {
                    if (restTimes.isAST0()) {
                        return temp;
                    }
                    return F.Times(temp, (IExpr)restTimes);
                }
                return F.NIL;
            }

            private IExpr tryExpand(IAST timesAST, IAST plusAST, IExpr arg1, int i, boolean isPowerReciprocal) {
                IExpr expandedAst = this.tryExpandTransformation(plusAST, F.Times(arg1, (IExpr)plusAST));
                if (expandedAst.isPresent()) {
                    IASTAppendable result = F.TimesAlloc(timesAST.size());
                    result.appendAll(timesAST, 2, timesAST.size());
                    if (isPowerReciprocal) {
                        result.set(i - 1, F.Power(expandedAst, F.CN1));
                    } else {
                        result.set(i - 1, expandedAst);
                    }
                    return result;
                }
                return F.NIL;
            }
        }

        private static class IsBasicExpressionVisitor
        extends AbstractVisitorBoolean {
            @Override
            public boolean visit(IAST ast) {
                if (ast.isTimes() || ast.isPlus()) {
                    return ast.forAll(x -> x.accept(this));
                }
                if (ast.isPower() && ast.exponent().isInteger()) {
                    return ast.base().accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(IComplex element) {
                return true;
            }

            @Override
            public boolean visit(IComplexNum element) {
                return true;
            }

            @Override
            public boolean visit(IFraction element) {
                return true;
            }

            @Override
            public boolean visit(IInteger element) {
                return true;
            }

            @Override
            public boolean visit(INum element) {
                return true;
            }

            @Override
            public boolean visit(ISymbol symbol) {
                return true;
            }
        }

        private static class SimplifiedResult {
            IExpr result;
            long minCounter;

            public SimplifiedResult(IExpr result, long minCounter) {
                this.result = result;
                this.minCounter = minCounter;
            }

            public boolean checkLessEqual(IExpr expr, long counter) {
                if (counter <= this.minCounter) {
                    this.minCounter = counter;
                    this.result = expr;
                    return true;
                }
                return false;
            }

            public boolean checkLess(IExpr expr, long counter) {
                if (counter < this.minCounter) {
                    this.minCounter = counter;
                    this.result = expr;
                    return true;
                }
                return false;
            }
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.FullSimplify.setEvaluator(new FullSimplify());
            S.Simplify.setEvaluator(new Simplify());
        }
    }
}

