/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.function.Function;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class SidesFunctions {
    private static IExpr piecewiseComparator(IAST comparator, IExpr value, Function<IExpr, IExpr> function) {
        IAST list1 = comparator.map(function);
        IAST list2 = comparator.mapReverse(function);
        IAST listOfConditions = F.list(F.list(list1, F.Greater(value, F.C0)), F.list(list2, F.Less(value, F.C0)));
        return F.Piecewise(listOfConditions, comparator);
    }

    public static void initialize() {
        Initializer.init();
    }

    private SidesFunctions() {
    }

    private static class SubtractSides
    extends AbstractCoreFunctionEvaluator {
        private SubtractSides() {
        }

        private static IExpr function(IExpr x, IExpr y) {
            return F.Subtract(x, y);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr a1;
            IExpr arg1 = ast.arg1();
            if (!arg1.isComparatorFunction()) {
                arg1 = engine.evaluate(arg1);
            }
            if (arg1.isTrue() || arg1.isFalse()) {
                return arg1;
            }
            IExpr arg2 = F.NIL;
            if (ast.isAST1()) {
                if (arg1.size() != 3) {
                    return F.NIL;
                }
                if (arg1.isConditionalExpression()) {
                    a1 = arg1.first();
                    if (a1.isComparatorFunction()) {
                        int headID = a1.headID();
                        switch (headID) {
                            case 423: 
                            case 571: 
                            case 572: 
                            case 753: 
                            case 754: 
                            case 1381: {
                                arg2 = a1.last();
                            }
                        }
                    }
                } else {
                    arg2 = arg1.second();
                }
            } else {
                arg2 = engine.evaluate(ast.arg2());
            }
            if (arg2.isPresent()) {
                IAST comparator;
                IExpr temp;
                if (arg1.isConditionalExpression() && arg1.first().isAST()) {
                    a1 = (IAST)arg1.first();
                    IExpr temp2 = this.subtractSides((IAST)a1, arg2);
                    if (temp2.isPresent()) {
                        return F.ConditionalExpression(temp2, arg1.second());
                    }
                } else if (arg1.isComparatorFunction() && !arg2.isComparatorFunction() && (temp = this.subtractSides(comparator = (IAST)arg1, arg2)).isPresent()) {
                    return temp;
                }
            }
            return IOFunctions.printMessage(ast.topHead(), "eqin", F.list(arg1), engine);
        }

        private IExpr subtractSides(IAST comparator, IExpr arg2) {
            int headID = comparator.headID();
            switch (headID) {
                case 423: 
                case 571: 
                case 572: 
                case 753: 
                case 754: 
                case 1381: {
                    return comparator.map(x -> SubtractSides.function(x, arg2));
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class MultiplySides
    extends AbstractCoreFunctionEvaluator {
        private MultiplySides() {
        }

        private static IExpr function(IExpr x, IExpr y) {
            return F.Times(x, y);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2 = engine.evaluate(ast.arg2());
            IExpr arg1 = ast.arg1();
            if (!arg2.isComparatorFunction()) {
                IAST comparator;
                IExpr temp;
                if (!arg1.isComparatorFunction()) {
                    arg1 = engine.evaluate(arg1);
                }
                if (arg1.isTrue() || arg1.isFalse()) {
                    return arg1;
                }
                if (arg1.isConditionalExpression() && arg1.first().isAST()) {
                    IAST a1 = (IAST)arg1.first();
                    IExpr temp2 = this.multiplySides(a1, arg2);
                    if (temp2.isPresent()) {
                        temp2 = engine.evaluate(temp2);
                        IAST piecewise = F.Piecewise(F.list(F.list(temp2), F.Unequal(arg2, F.C0)), a1);
                        return F.ConditionalExpression(piecewise, arg1.second());
                    }
                } else if (arg1.isComparatorFunction() && (temp = this.multiplySides(comparator = (IAST)arg1, arg2)).isPresent()) {
                    return temp;
                }
            }
            return IOFunctions.printMessage(ast.topHead(), "eqin", F.list(arg1), engine);
        }

        private IExpr multiplySides(IAST comparator, IExpr arg2) {
            int headID = comparator.headID();
            switch (headID) {
                case 423: {
                    return comparator.map(x -> MultiplySides.function(x, arg2));
                }
                case 1381: {
                    return comparator.map(x -> MultiplySides.function(x, arg2));
                }
                case 753: {
                    if (arg2.isNegative()) {
                        return comparator.mapReverse(x -> MultiplySides.function(x, arg2));
                    }
                    if (arg2.isPositive()) {
                        return comparator.map(x -> MultiplySides.function(x, arg2));
                    }
                    return SidesFunctions.piecewiseComparator(comparator, arg2, x -> MultiplySides.function(x, arg2));
                }
                case 754: {
                    if (arg2.isNegative()) {
                        return comparator.mapReverse(x -> MultiplySides.function(x, arg2));
                    }
                    if (arg2.isPositive()) {
                        return comparator.map(x -> MultiplySides.function(x, arg2));
                    }
                    return SidesFunctions.piecewiseComparator(comparator, arg2, x -> MultiplySides.function(x, arg2));
                }
                case 571: {
                    if (arg2.isNegative()) {
                        return comparator.mapReverse(x -> MultiplySides.function(x, arg2));
                    }
                    if (arg2.isPositive()) {
                        return comparator.map(x -> MultiplySides.function(x, arg2));
                    }
                    return SidesFunctions.piecewiseComparator(comparator, arg2, x -> MultiplySides.function(x, arg2));
                }
                case 572: {
                    if (arg2.isNegative()) {
                        return comparator.mapReverse(x -> MultiplySides.function(x, arg2));
                    }
                    if (arg2.isPositive()) {
                        return comparator.map(x -> MultiplySides.function(x, arg2));
                    }
                    return SidesFunctions.piecewiseComparator(comparator, arg2, x -> MultiplySides.function(x, arg2));
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class DivideSides
    extends AbstractCoreFunctionEvaluator {
        private DivideSides() {
        }

        private static IExpr function(IExpr x, IExpr y) {
            return F.Divide(x, y);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr a1;
            IExpr arg1 = ast.arg1();
            if (!arg1.isComparatorFunction()) {
                arg1 = engine.evaluate(arg1);
            }
            if (arg1.isTrue() || arg1.isFalse()) {
                return arg1;
            }
            IExpr arg2 = F.NIL;
            if (ast.isAST1()) {
                if (arg1.size() != 3) {
                    return F.NIL;
                }
                if (arg1.isConditionalExpression()) {
                    a1 = arg1.first();
                    if (a1.isComparatorFunction()) {
                        int headID = a1.headID();
                        switch (headID) {
                            case 423: 
                            case 571: 
                            case 572: 
                            case 753: 
                            case 754: 
                            case 1381: {
                                arg2 = a1.last();
                            }
                        }
                    }
                } else {
                    arg2 = arg1.second();
                }
            } else {
                arg2 = engine.evaluate(ast.arg2());
            }
            if (arg2.isPresent()) {
                if (arg1.isConditionalExpression() && arg1.first().isAST()) {
                    a1 = (IAST)arg1.first();
                    IExpr temp = this.divideSides((IAST)a1, arg2);
                    if (temp.isPresent()) {
                        temp = engine.evaluate(temp);
                        IAST piecewise = F.Piecewise(F.list(F.list(temp), F.Unequal(arg2, F.C0)), a1);
                        return F.ConditionalExpression(piecewise, arg1.second());
                    }
                } else if (arg1.isComparatorFunction()) {
                    IAST comparator;
                    IExpr temp;
                    if (arg2.isZero()) {
                        return IOFunctions.printMessage(ast.topHead(), "arg2", F.CEmptyList, engine);
                    }
                    if (!arg2.isComparatorFunction() && (temp = this.divideSides(comparator = (IAST)arg1, arg2)).isPresent()) {
                        return temp;
                    }
                }
            }
            return IOFunctions.printMessage(ast.topHead(), "eqin", F.list(arg1), engine);
        }

        private IExpr divideSides(IAST comparator, IExpr arg2) {
            int headID = comparator.headID();
            switch (headID) {
                case 423: {
                    return comparator.map(x -> DivideSides.function(x, arg2));
                }
                case 1381: {
                    return comparator.map(x -> DivideSides.function(x, arg2));
                }
                case 753: {
                    if (arg2.isNegative()) {
                        return comparator.mapReverse(x -> DivideSides.function(x, arg2));
                    }
                    if (arg2.isPositive()) {
                        return comparator.map(x -> DivideSides.function(x, arg2));
                    }
                    return SidesFunctions.piecewiseComparator(comparator, arg2, x -> DivideSides.function(x, arg2));
                }
                case 754: {
                    if (arg2.isNegative()) {
                        return comparator.mapReverse(x -> DivideSides.function(x, arg2));
                    }
                    if (arg2.isPositive()) {
                        return comparator.map(x -> DivideSides.function(x, arg2));
                    }
                    return SidesFunctions.piecewiseComparator(comparator, arg2, x -> DivideSides.function(x, arg2));
                }
                case 571: {
                    if (arg2.isNegative()) {
                        return comparator.mapReverse(x -> DivideSides.function(x, arg2));
                    }
                    if (arg2.isPositive()) {
                        return comparator.map(x -> DivideSides.function(x, arg2));
                    }
                    return SidesFunctions.piecewiseComparator(comparator, arg2, x -> DivideSides.function(x, arg2));
                }
                case 572: {
                    if (arg2.isNegative()) {
                        return comparator.mapReverse(x -> DivideSides.function(x, arg2));
                    }
                    if (arg2.isPositive()) {
                        return comparator.map(x -> DivideSides.function(x, arg2));
                    }
                    return SidesFunctions.piecewiseComparator(comparator, arg2, x -> DivideSides.function(x, arg2));
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class ApplySides
    extends AbstractCoreFunctionEvaluator {
        private ApplySides() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            IExpr arg2 = ast.arg2();
            if (!arg2.isComparatorFunction()) {
                arg2 = engine.evaluate(arg2);
            }
            if (arg2.isTrue() || arg2.isFalse()) {
                return arg2;
            }
            if (arg2.isComparatorFunction()) {
                IAST comparator = (IAST)arg2;
                int headID = comparator.headID();
                switch (headID) {
                    case 423: 
                    case 571: 
                    case 572: 
                    case 753: 
                    case 754: 
                    case 1381: {
                        return comparator.map(x -> F.unaryAST1(arg1, x));
                    }
                }
            }
            return IOFunctions.printMessage(ast.topHead(), "eqin", F.list(arg2), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class AddSides
    extends AbstractCoreFunctionEvaluator {
        private AddSides() {
        }

        private static IExpr function(IExpr x, IExpr y) {
            return F.Plus(x, y);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2 = engine.evaluate(ast.arg2());
            IExpr arg1 = ast.arg1();
            if (!arg2.isComparatorFunction()) {
                IAST comparator;
                IExpr temp;
                if (!arg1.isComparatorFunction()) {
                    arg1 = engine.evaluate(arg1);
                }
                if (arg1.isTrue() || arg1.isFalse()) {
                    return arg1;
                }
                if (arg1.isConditionalExpression() && arg1.first().isAST()) {
                    IAST a1 = (IAST)arg1.first();
                    IExpr temp2 = this.addSides(a1, arg2);
                    if (temp2.isPresent()) {
                        return F.ConditionalExpression(temp2, arg1.second());
                    }
                } else if (arg1.isComparatorFunction() && (temp = this.addSides(comparator = (IAST)arg1, arg2)).isPresent()) {
                    return temp;
                }
            }
            return IOFunctions.printMessage(ast.topHead(), "eqin", F.list(arg1), engine);
        }

        private IExpr addSides(IAST comparator, IExpr arg2) {
            int headID = comparator.headID();
            switch (headID) {
                case 423: 
                case 571: 
                case 572: 
                case 753: 
                case 754: 
                case 1381: {
                    return comparator.map(x -> AddSides.function(x, arg2));
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.AddSides.setEvaluator(new AddSides());
            S.ApplySides.setEvaluator(new ApplySides());
            S.DivideSides.setEvaluator(new DivideSides());
            S.MultiplySides.setEvaluator(new MultiplySides());
            S.SubtractSides.setEvaluator(new SubtractSides());
        }
    }
}

