/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.basic.ToggleFeature;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.NumberTheory;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.ASTSeriesData;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomial;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomialRing;
import org.matheclipse.core.reflection.system.rules.LimitRules;
import org.matheclipse.core.reflection.system.rules.SeriesCoefficientRules;

public class SeriesFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void initialize() {
        Initializer.init();
    }

    private SeriesFunctions() {
    }

    private static final class SeriesData
    extends AbstractFunctionEvaluator {
        private SeriesData() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int denominator = 1;
            if (ast.size() == 6 || ast.size() == 7) {
                if (ast.arg1().isNumber()) {
                    return S.Indeterminate;
                }
                IExpr x = ast.arg1();
                IExpr x0 = ast.arg2();
                if (ast.arg3().isVector() < 0 || !ast.arg3().isAST()) {
                    return F.NIL;
                }
                IAST coefficients = (IAST)ast.arg3();
                int nMin = ast.arg4().toIntDefault();
                if (nMin == Integer.MIN_VALUE) {
                    return F.NIL;
                }
                int truncate = ast.arg5().toIntDefault();
                if (truncate == Integer.MIN_VALUE) {
                    return F.NIL;
                }
                if (ast.size() == 7) {
                    denominator = ast.get(6).toIntDefault();
                    if (!ToggleFeature.SERIES_DENOMINATOR && denominator != 1) {
                        return IOFunctions.printMessage(ast.topHead(), "toggle", F.list(F.stringx("SERIES_DENOMINATOR")), engine);
                    }
                }
                return new ASTSeriesData(x, x0, coefficients, nMin, truncate, denominator);
            }
            return F.NIL;
        }
    }

    private static final class SeriesCoefficient
    extends AbstractFunctionEvaluator
    implements SeriesCoefficientRules {
        private SeriesCoefficient() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2()) {
                if (ast.arg1() instanceof ASTSeriesData && ast.arg2().isInteger()) {
                    ASTSeriesData series = (ASTSeriesData)ast.arg1();
                    int n = ast.arg2().toIntDefault();
                    if (n >= 0) {
                        int order = series.order();
                        if (order > n) {
                            return series.coefficient(n);
                        }
                        return S.Indeterminate;
                    }
                    return F.NIL;
                }
                if (ast.arg2().isVector() == 3 && !(ast.arg1() instanceof ASTSeriesData)) {
                    IExpr function = ast.arg1();
                    IAST list = (IAST)ast.arg2();
                    IExpr x = list.arg1();
                    IExpr x0 = list.arg2();
                    IExpr n = list.arg3();
                    return SeriesCoefficient.functionCoefficient(ast, function, x, x0, n, engine);
                }
            }
            return F.NIL;
        }

        private static IExpr functionCoefficient(IAST ast, IExpr function, IExpr x, IExpr x0, IExpr n, EvalEngine engine) {
            int degree;
            if (n.isReal()) {
                if (n.isFraction() && !((IFraction)n).denominator().isOne()) {
                    return F.C0;
                }
                if (!n.isInteger()) {
                    return F.NIL;
                }
            }
            if (function.isFree(x)) {
                if (n.isZero()) {
                    return function;
                }
                return F.Piecewise(F.list(F.list(function, F.Equal(n, (IExpr)F.C0))), F.C0);
            }
            IExpr temp = SeriesCoefficient.polynomialSeriesCoefficient(function, x, x0, n, ast, engine);
            if (temp.isPresent()) {
                return temp;
            }
            if (function.isPower()) {
                IExpr b = function.base();
                IExpr exponent = function.exponent();
                if (b.equals(x)) {
                    IExpr exp;
                    if (exponent.isNumber() && (exp = (INumber)exponent).isInteger()) {
                        if (x0.isZero()) {
                            return F.Piecewise(F.list(F.list(F.C1, F.Equal(n, exp))), F.C0);
                        }
                        return F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power(x0, F.Plus(exp, n.negate())), (IExpr)F.Binomial(exp, n)), F.LessEqual(F.C0, n, exp))), F.C0);
                    }
                    if (!x0.isZero() && exponent.isFree(x)) {
                        exp = exponent;
                        return F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power(x0, F.Plus(exp, n.negate())), (IExpr)F.Binomial(exp, n)), F.GreaterEqual(n, F.C0))), F.C0);
                    }
                }
                if (b.isFree(x)) {
                    IExpr[] linear = exponent.linear(x);
                    if (linear != null) {
                        if (x0.isZero()) {
                            IExpr a = linear[0];
                            IExpr c = linear[1];
                            return F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power(b, a), (IExpr)F.Power((IExpr)F.Factorial(n), F.CN1), (IExpr)F.Power((IExpr)F.Times(c, (IExpr)F.Log(b)), n)), F.GreaterEqual(n, F.C0))), F.C0);
                        }
                        if (linear[0].isZero() && linear[1].isOne()) {
                            return F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power(b, x0), (IExpr)F.Power((IExpr)F.Factorial(n), F.CN1), (IExpr)F.Power((IExpr)F.Log(b), n)), F.GreaterEqual(n, F.C0))), F.C0);
                        }
                    }
                } else if (b.equals(exponent) && x0.isZero() && exponent.equals(x)) {
                    return F.Piecewise(F.list(F.list(F.Times((IExpr)F.Power(b, x0), (IExpr)F.Power((IExpr)F.Factorial(n), F.CN1), (IExpr)F.Power((IExpr)F.Log(b), n)), F.GreaterEqual(n, F.C0))), F.C0);
                }
            }
            if (x0.isReal()) {
                int lowerLimit = x0.toIntDefault();
                if (lowerLimit != 0) {
                    return F.NIL;
                }
                x0 = F.ZZ(lowerLimit);
            }
            if ((degree = n.toIntDefault()) < 0) {
                return F.NIL;
            }
            if (degree == 0) {
                return F.ReplaceAll(function, F.Rule(x, x0));
            }
            IExpr derivedFunction = S.D.of(engine, function, F.list(x, n));
            return F.Times((IExpr)F.Power((IExpr)F.Factorial(n), F.CN1), (IExpr)F.ReplaceAll(derivedFunction, F.Rule(x, x0)));
        }

        public static IExpr polynomialSeriesCoefficient(IExpr univariatePolynomial, IExpr x, IExpr x0, IExpr n, IAST seriesTemplate, EvalEngine engine) {
            try {
                HashMap<IExpr, IExpr> coefficientMap = new HashMap<IExpr, IExpr>();
                IASTAppendable rest = F.ListAlloc(4);
                ExprPolynomialRing.create(univariatePolynomial, x, coefficientMap, rest);
                IASTAppendable coefficientPlus = F.PlusAlloc(2);
                if (coefficientMap.size() > 0) {
                    IInteger defaultValue = F.C0;
                    IASTAppendable piecewiseAST = F.ast(S.Piecewise);
                    IASTAppendable rules = F.ListAlloc(2);
                    IASTAppendable plus = F.PlusAlloc(coefficientMap.size());
                    IAST comparator = F.GreaterEqual(n, F.C0);
                    for (Map.Entry entry : coefficientMap.entrySet()) {
                        IAST bin;
                        IExpr exp = (IExpr)entry.getKey();
                        if (exp.isZero()) continue;
                        if (exp.isNegative() && x0.isZero()) {
                            if (!exp.equals(n)) continue;
                            defaultValue = F.C1;
                            continue;
                        }
                        IExpr coefficient = (IExpr)entry.getValue();
                        if (coefficient.isZero()) continue;
                        IAST powerPart = F.Power(x0, exp);
                        comparator = F.Greater(n, F.C0);
                        int k = exp.toIntDefault();
                        if (k != Integer.MIN_VALUE) {
                            if (k < 0) {
                                x0 = x0.negate();
                                int nk = -k;
                                IASTAppendable binomial = F.TimesAlloc(nk + 1);
                                for (int i = 1; i < nk; ++i) {
                                    binomial.append(F.Plus(n, (IExpr)F.ZZ(i)));
                                }
                                binomial.append(F.Power((IExpr)F.Factorial(F.ZZ(nk - 1)), -1L));
                                bin = binomial;
                                comparator = F.GreaterEqual(n, F.C0);
                            } else {
                                comparator = F.LessEqual(F.C0, n, exp);
                                bin = F.Binomial(exp, n);
                            }
                        } else {
                            bin = F.Binomial(exp, n);
                        }
                        if (coefficient.isOne()) {
                            plus.append(F.Times((IExpr)powerPart, (IExpr)bin));
                            continue;
                        }
                        plus.append(F.Times(coefficient, (IExpr)powerPart, (IExpr)bin));
                    }
                    IExpr temp = engine.evaluate(plus);
                    if (!temp.isZero()) {
                        rules.append(F.list(engine.evaluate(F.Times((IExpr)F.Power(x0, n.negate()), (IExpr)plus)), comparator));
                    }
                    if (comparator.isAST(S.Greater)) {
                        plus = F.PlusAlloc(coefficientMap.size());
                        for (Map.Entry entry : coefficientMap.entrySet()) {
                            IExpr exp = (IExpr)entry.getKey();
                            IExpr coefficient = (IExpr)entry.getValue();
                            if (coefficient.isZero()) continue;
                            if (coefficient.isOne()) {
                                plus.append(F.Times((IExpr)F.Power(x0, exp)));
                                continue;
                            }
                            plus.append(F.Times(coefficient, (IExpr)F.Power(x0, exp)));
                        }
                        rules.append(F.list(engine.evaluate(plus), F.Equal(n, (IExpr)F.C0)));
                    }
                    piecewiseAST.append(rules);
                    piecewiseAST.append(defaultValue);
                    coefficientPlus.append(piecewiseAST);
                } else if (!univariatePolynomial.isPlus()) {
                    return F.NIL;
                }
                for (int i = 1; i < rest.size(); ++i) {
                    IASTAppendable term = seriesTemplate.copyAppendable();
                    term.set(1, rest.get(i));
                    coefficientPlus.append(term);
                }
                return coefficientPlus.oneIdentity0();
            }
            catch (RuntimeException re) {
                LOGGER.debug("SeriesCoefficient.polynomialSeriesCoefficient() failed", (Throwable)re);
                return F.NIL;
            }
        }
    }

    private static final class Series
    extends AbstractFunctionEvaluator {
        private Series() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2() && ast.arg2().isVector() == 3) {
                IExpr function = ast.arg1();
                IAST list = (IAST)ast.arg2();
                IExpr x = list.arg1();
                IExpr x0 = list.arg2();
                int n = list.arg3().toIntDefault();
                if (n == Integer.MIN_VALUE) {
                    return F.NIL;
                }
                if (function.isFree(x)) {
                    return function;
                }
                ASTSeriesData series = Series.seriesDataRecursive(function, x, x0, n, engine);
                if (series != null) {
                    return series;
                }
            }
            return F.NIL;
        }

        private static ASTSeriesData seriesDataRecursive(IExpr function, IExpr x, IExpr x0, int n, EvalEngine engine) {
            ASTSeriesData temp;
            boolean denominator = true;
            if (function.isFree(x) || function.equals(x)) {
                HashMap<IExpr, IExpr> coefficientMap = new HashMap<IExpr, IExpr>();
                IASTAppendable rest = F.PlusAlloc(4);
                return Series.polynomialSeries(function, x, x0, n, coefficientMap, rest);
            }
            if (function.isPlus() ? (temp = Series.plusSeriesData((IAST)function, x, x0, n, engine)) != null : function.isTimes() && (temp = Series.timesSeriesData((IAST)function, x, x0, n, engine)) != null) {
                return temp;
            }
            ASTSeriesData sd = Series.simpleSeries(function, x, x0, n, 1, engine);
            if (sd != null) {
                return sd;
            }
            if (function.isPower()) {
                ASTSeriesData temp2 = Series.powerSeriesData(function, x, x0, n, engine);
                if (temp2 != null) {
                    return temp2;
                }
            } else if (function.isLog() && function.first().equals(x) && x0.isZero() && n >= 0) {
                return new ASTSeriesData(x, x0, F.list(function), 0, n + 1, 1);
            }
            return null;
        }

        private static ASTSeriesData simpleSeries(IExpr function, IExpr x, IExpr x0, int n, int denominator, EvalEngine engine) {
            VariablesSet varSet = new VariablesSet(function);
            varSet.add(x);
            varSet.addVarList(x0);
            ASTSeriesData sd = Series.seriesCoefficient(function, x, x0, n, denominator, varSet, engine);
            if (sd != null) {
                return sd;
            }
            return Series.taylorSeries(function, x, x0, n, denominator, varSet, engine);
        }

        private static ASTSeriesData seriesCoefficient(IExpr function, IExpr x, IExpr x0, int n, int denominator, VariablesSet varSet, EvalEngine engine) {
            ISymbol power = F.Dummy("$$$n");
            IExpr temp = engine.evalQuiet(F.SeriesCoefficient(function, F.list(x, x0, power)));
            if (temp.isNumericFunction(varSet)) {
                int end = n;
                if (n < 0) {
                    end = 0;
                }
                ASTSeriesData ps = new ASTSeriesData(x, x0, end + 1, end + denominator, denominator);
                for (int i = 0; i <= end; ++i) {
                    ps.setCoeff(i, engine.evalQuiet(F.subst(temp, F.Rule((IExpr)power, (IExpr)F.ZZ(i)))));
                }
                return ps;
            }
            int end = n;
            if (n < 0) {
                end = 0;
            }
            if ((temp = engine.evalQuiet(F.SeriesCoefficient(function, F.list(x, x0, F.C0)))).isNumericFunction(varSet)) {
                boolean evaled = true;
                ASTSeriesData ps = new ASTSeriesData(x, x0, end + 1, end + denominator, denominator);
                ps.setCoeff(0, temp);
                for (int i = 1; i <= end; ++i) {
                    temp = engine.evalQuiet(F.SeriesCoefficient(function, F.list(x, x0, F.ZZ(i))));
                    if (!temp.isNumericFunction(varSet)) {
                        evaled = false;
                        break;
                    }
                    ps.setCoeff(i, temp);
                }
                if (evaled) {
                    return ps;
                }
            }
            return null;
        }

        private static ASTSeriesData taylorSeries(IExpr function, IExpr x, IExpr x0, int n, int denominator, VariablesSet varSet, EvalEngine engine) {
            ASTSeriesData ps = new ASTSeriesData(x, x0, 0, n + denominator, denominator);
            IExpr derivedFunction = function;
            for (int i = 0; i <= n; ++i) {
                IExpr functionPart = engine.evalQuiet(F.ReplaceAll(derivedFunction, F.Rule(x, x0)));
                if (functionPart.isIndeterminate() && !(functionPart = engine.evalQuiet(F.Limit(derivedFunction, F.Rule(x, x0)))).isNumericFunction(varSet)) {
                    return null;
                }
                IExpr coefficient = engine.evalQuiet(F.Times((IExpr)F.Power((IExpr)NumberTheory.factorial(i), F.CN1), functionPart));
                if (coefficient.isIndeterminate() || coefficient.isComplexInfinity()) {
                    return null;
                }
                ps.setCoeff(i, coefficient);
                derivedFunction = engine.evalQuiet(F.D(derivedFunction, x));
            }
            return ps;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static ASTSeriesData timesSeriesData(IAST timesAST, IExpr x, IExpr x0, int n, EvalEngine engine) {
            void var8_10;
            ASTSeriesData series;
            ASTSeriesData arg;
            Map<IExpr, IExpr> coefficientMap = new HashMap<IExpr, IExpr>();
            IASTAppendable rest = F.PlusAlloc(4);
            coefficientMap = new HashMap();
            rest = F.TimesAlloc(4);
            coefficientMap = ExprPolynomialRing.createTimes(timesAST, x, coefficientMap, rest);
            int shift = 0;
            IInteger iInteger = F.C1;
            if (coefficientMap.size() == 1 && (shift = coefficientMap.keySet().iterator().next().toIntDefault(0)) != 0) {
                timesAST = rest;
                IExpr iExpr = coefficientMap.values().iterator().next();
            }
            int ni = n + Math.abs(shift);
            if (timesAST.isEmpty()) {
                ASTSeriesData temp = Series.seriesFromMap(x, x0, n, coefficientMap, rest);
                if (temp != null && rest.isEmpty()) {
                    return temp;
                }
                if (rest.isEmpty()) {
                    return null;
                }
                timesAST = rest;
                if (temp != null) {
                    arg = Series.seriesDataRecursive(timesAST.arg1(), x, x0, ni, engine);
                    if (!(arg instanceof ASTSeriesData)) return null;
                    series = temp.timesPS(arg);
                } else {
                    arg = Series.seriesDataRecursive(timesAST.arg1(), x, x0, ni, engine);
                    if (!(arg instanceof ASTSeriesData)) return null;
                    series = arg;
                }
            } else {
                arg = Series.seriesDataRecursive(timesAST.arg1(), x, x0, ni, engine);
                if (!(arg instanceof ASTSeriesData)) return null;
                series = arg;
            }
            if (timesAST.size() == 1) return null;
            if (!(arg instanceof ASTSeriesData)) return null;
            for (int i = 2; i < timesAST.size(); ++i) {
                int exp;
                IExpr timesArg = timesAST.get(i);
                if (timesArg.isPower() && (exp = timesArg.exponent().toIntDefault()) != Integer.MIN_VALUE && exp == -1) {
                    arg = Series.seriesDataRecursive(timesArg.base(), x, x0, ni, engine);
                    if (!(arg instanceof ASTSeriesData)) return null;
                    series = series.dividePS(arg);
                    continue;
                }
                arg = Series.seriesDataRecursive(timesArg, x, x0, ni, engine);
                if (!(arg instanceof ASTSeriesData)) return null;
                series = series.timesPS(arg);
            }
            if (shift == 0) return series;
            return series.shift(shift, (IExpr)var8_10, n + 1);
        }

        private static ASTSeriesData plusSeriesData(IAST plusAST, IExpr x, IExpr x0, int n, EvalEngine engine) {
            ASTSeriesData arg;
            HashMap<IExpr, IExpr> coefficientMap = new HashMap<IExpr, IExpr>();
            IASTAppendable rest = F.PlusAlloc(4);
            ASTSeriesData temp = Series.polynomialSeries(plusAST, x, x0, n, coefficientMap, rest);
            if (temp != null && rest.isEmpty()) {
                return temp;
            }
            ASTSeriesData series = null;
            int start = 1;
            if (temp != null) {
                series = temp;
            } else {
                arg = Series.seriesDataRecursive(rest.arg1(), x, x0, n, engine);
                if (arg instanceof ASTSeriesData) {
                    series = arg;
                    start = 2;
                }
            }
            if (series != null) {
                for (int i = start; i < rest.size(); ++i) {
                    arg = Series.seriesDataRecursive(rest.get(i), x, x0, n, engine);
                    if (!(arg instanceof ASTSeriesData)) {
                        series = null;
                        break;
                    }
                    series = series.plusPS(arg);
                }
                if (series != null) {
                    return series;
                }
            }
            return null;
        }

        private static ASTSeriesData powerSeriesData(IExpr powerAST, IExpr x, IExpr x0, int n, EvalEngine engine) {
            ASTSeriesData series;
            int exp;
            IASTAppendable rest;
            HashMap<IExpr, IExpr> coefficientMap;
            ASTSeriesData temp;
            IExpr base = powerAST.base();
            IExpr exponent = powerAST.exponent();
            if (base.isFree(x)) {
                IRational rat;
                if (exponent.isPower() && exponent.base().equals(x) && exponent.exponent().isRational() && (rat = (IRational)exponent.exponent()).isPositive()) {
                    ASTSeriesData temp2;
                    int numerator = rat.numerator().toIntDefault();
                    int denominator = rat.denominator().toIntDefault();
                    if (denominator != Integer.MIN_VALUE && (temp2 = Series.seriesDataRecursive(F.Power(base, x), x, x0, n * denominator, engine)) instanceof ASTSeriesData) {
                        ASTSeriesData series2 = temp2;
                        if (numerator != 1) {
                            series2 = series2.shiftTimes(numerator, F.C1, series2.order());
                        }
                        series2.setDenominator(denominator);
                        return series2;
                    }
                }
            } else if (!(base instanceof ASTSeriesData) && (temp = Series.polynomialSeries(powerAST, x, x0, n, coefficientMap = new HashMap<IExpr, IExpr>(), rest = F.PlusAlloc(4))) != null) {
                return temp;
            }
            if ((exp = exponent.toIntDefault()) != Integer.MIN_VALUE && (series = Series.seriesDataRecursive(base, x, x0, n, engine)) instanceof ASTSeriesData) {
                return series.powerSeries(exp);
            }
            return null;
        }

        private static ASTSeriesData polynomialSeries(IExpr function, IExpr x, IExpr x0, int n, Map<IExpr, IExpr> coefficientMap, IASTAppendable rest) {
            ExprPolynomialRing.create(function, x, coefficientMap, rest);
            if (coefficientMap.size() > 0) {
                return Series.seriesFromMap(x, x0, n, coefficientMap, rest);
            }
            return null;
        }

        private static ASTSeriesData seriesFromMap(IExpr x, IExpr x0, int n, Map<IExpr, IExpr> coefficientMap, IASTAppendable rest) {
            ASTSeriesData series = new ASTSeriesData(x, x0, 0, n + 1, 1);
            boolean evaled = false;
            for (Map.Entry<IExpr, IExpr> entry : coefficientMap.entrySet()) {
                IExpr coefficient = entry.getValue();
                if (coefficient.isZero()) continue;
                IExpr exp = entry.getKey();
                int exponent = exp.toIntDefault();
                if (exponent == Integer.MIN_VALUE) {
                    rest.append(F.Times(coefficient, (IExpr)F.Power(x, exp)));
                    continue;
                }
                series.setCoeff(exponent, coefficient);
                evaled = true;
            }
            if (evaled) {
                return series;
            }
            return null;
        }
    }

    private static final class InverseSeries
    extends AbstractFunctionEvaluator {
        private InverseSeries() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1() && ast.arg1() instanceof ASTSeriesData) {
                ASTSeriesData ps = (ASTSeriesData)ast.arg1();
                if ((ps = ps.reversion()) != null) {
                    return ps;
                }
            }
            return F.NIL;
        }
    }

    private static final class ComposeSeries
    extends AbstractFunctionEvaluator {
        private ComposeSeries() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() > 2 && ast.arg1() instanceof ASTSeriesData) {
                ASTSeriesData result = (ASTSeriesData)ast.arg1();
                for (int i = 2; i < ast.size(); ++i) {
                    ASTSeriesData s2;
                    if (!(ast.get(i) instanceof ASTSeriesData) || (result = result.compose(s2 = (ASTSeriesData)ast.get(i))) != null) continue;
                    return F.NIL;
                }
                return result;
            }
            return F.NIL;
        }
    }

    private static final class Normal
    extends AbstractFunctionEvaluator {
        private Normal() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST heads = F.CEmptyList;
            if (ast.isAST2()) {
                heads = ast.arg2().isList() ? (IAST)ast.arg2() : F.list(ast.arg2());
            }
            IExpr arg1 = ast.arg1();
            IExpr result = arg1.replaceAll(this.normal(heads));
            return result.orElse(arg1);
        }

        private Function<IExpr, IExpr> normal(IAST heads) {
            return x -> {
                int size = heads.size();
                if (size == 1) {
                    return x.normal(true);
                }
                IExpr head = x.head();
                if (heads.exists(y -> y.equals(head))) {
                    return x.normal(true);
                }
                return F.NIL;
            };
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Limit
    extends AbstractFunctionEvaluator
    implements LimitRules {
        private Limit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static IExpr evalLimitQuiet(IExpr expr, LimitData data) {
            EvalEngine engine = EvalEngine.get();
            boolean quiet = engine.isQuietMode();
            try {
                IBuiltInSymbol direction = data.direction() == Direction.TWO_SIDED ? S.Reals : F.ZZ(data.direction().toInt());
                IExpr iExpr = engine.evaluate(F.Limit(expr, data.rule(), F.Rule((IExpr)S.Direction, (IExpr)direction)));
                return iExpr;
            }
            finally {
                engine.setQuietMode(quiet);
            }
        }

        private static IExpr evalLimit(IExpr expr, LimitData data) {
            IExpr temp;
            IExpr expression = expr;
            IExpr limitValue = data.limitValue();
            EvalEngine engine = EvalEngine.get();
            IExpr result = engine.evalQuiet(expression);
            if (result.isNumericFunction(true)) {
                return result;
            }
            if (!result.equals(S.Indeterminate)) {
                expression = result;
            }
            if (result.isFree(data.variable(), true)) {
                return expression;
            }
            if (result.equals(data.variable())) {
                return limitValue;
            }
            if (limitValue.isNumericFunction(true)) {
                temp = Limit.evalReplaceAll(expression, data);
                if (temp.isPresent()) {
                    return temp;
                }
            } else if ((limitValue.isInfinity() || limitValue.isNegativeInfinity()) && expression.isAST() && expression.size() > 1) {
                if (limitValue.isInfinity() || limitValue.isNegativeInfinity()) {
                    temp = Limit.evalReplaceAll(expression, data);
                    if (temp.isNumericFunction(true)) {
                        return temp;
                    }
                    if (expression.isNumericFunction(data.variable()) && expression.size() > 1 && !expression.isPlusTimesPower() && (temp = Limit.limitNumericFunctionArgs((IAST)expression, data, engine)).isPresent()) {
                        return temp;
                    }
                }
                if ((temp = Limit.limitInfinityZero((IAST)expression, data, (IAST)limitValue)).isPresent()) {
                    return temp;
                }
            }
            if (expression.isAST()) {
                if (!limitValue.isNumericFunction(true) && limitValue.isFree(S.DirectedInfinity) && limitValue.isFree(data.variable())) {
                    return expr.replaceAll(data.rule()).orElse(expr);
                }
                IAST arg1 = (IAST)expression;
                if (arg1.isSin() || arg1.isCos()) {
                    return F.unaryAST1(arg1.head(), data.limit(arg1.arg1()));
                }
                if (arg1.isPlus()) {
                    return Limit.plusLimit(arg1, data);
                }
                if (arg1.isTimes()) {
                    return Limit.timesLimit(arg1, data);
                }
                if (arg1.isLog()) {
                    return Limit.logLimit(arg1, data);
                }
                if (arg1.isPower()) {
                    return Limit.powerLimit(arg1, data);
                }
            }
            return F.NIL;
        }

        private static IExpr limitNumericFunctionArgs(IAST function, LimitData data, EvalEngine engine) {
            IExpr temp;
            IASTMutable functionLimitArgs = F.NIL;
            for (int i = 1; i < function.size(); ++i) {
                IExpr temp2;
                IExpr arg = function.get(i);
                if (arg.isFree(data.variable()) || !(temp2 = Limit.evalLimitQuiet(arg, data)).isPresent() || !temp2.isFree(data.variable()) || !temp2.isNumericFunction(true)) continue;
                if (!functionLimitArgs.isPresent()) {
                    functionLimitArgs = function.copy();
                }
                functionLimitArgs.set(i, temp2);
            }
            if (functionLimitArgs.isPresent() && !(temp = engine.evaluate(functionLimitArgs)).isIndeterminate() && !temp.isComplexInfinity()) {
                return temp;
            }
            return F.NIL;
        }

        private static IExpr evalReplaceAll(IExpr expression, LimitData data) {
            IExpr result = expression.replaceAll(data.rule());
            if (result.isPresent() && ((result = EvalEngine.get().evalQuiet(result)).isNumericFunction(true) || result.isInfinity() || result.isNegativeInfinity())) {
                return result;
            }
            return F.NIL;
        }

        private static IExpr limitInfinityZero(IAST ast, LimitData data, IAST limitValue) {
            Direction direction = limitValue.isNegativeInfinity() ? Direction.FROM_BELOW : Direction.FROM_ABOVE;
            Direction dataDirection = data.direction();
            if (dataDirection == Direction.TWO_SIDED || dataDirection == direction) {
                IExpr arg1;
                int variableArgPosition = -1;
                for (int i = 1; i < ast.size(); ++i) {
                    if (ast.get(i).isFree(data.variable())) continue;
                    if (variableArgPosition == -1) {
                        variableArgPosition = i;
                        continue;
                    }
                    return F.NIL;
                }
                if (variableArgPosition > 0 && (arg1 = Limit.evalLimitQuiet(ast.get(variableArgPosition), data)).isZero()) {
                    LimitData tempData = new LimitData(data.variable(), F.C0, F.Rule((IExpr)data.variable(), (IExpr)F.C0), direction);
                    return Limit.evalLimitQuiet(ast.setAtCopy(variableArgPosition, data.variable()), tempData);
                }
            }
            return F.NIL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static IExpr lHospitalesRule(IExpr numerator, IExpr denominator, LimitData data) {
            EvalEngine engine = EvalEngine.get();
            ISymbol x = data.variable();
            int recursionLimit = engine.getRecursionLimit();
            try {
                IExpr frac;
                if (recursionLimit <= 0 || recursionLimit > Config.LIMIT_LHOSPITAL_RECURSION_LIMIT) {
                    engine.setRecursionLimit(Config.LIMIT_LHOSPITAL_RECURSION_LIMIT);
                }
                if ((data.limitValue.isInfinity() || data.limitValue.isNegativeInfinity()) && !numerator.isPower() && denominator.isPower() && denominator.exponent().equals(F.C1D2) && (frac = (IFraction)denominator.exponent()).numerator().isOne()) {
                    IInteger exp = frac.denominator();
                    IExpr expr = engine.evalQuiet(F.Times((IExpr)F.D(F.Power(numerator, exp), x), (IExpr)F.Power((IExpr)F.D(denominator.base(), x), F.CN1)));
                    if ((expr = Limit.evalLimit(expr, data)).isNumber()) {
                        IAST iAST = F.Power(expr, frac);
                        return iAST;
                    }
                }
                if (numerator.isPower() && numerator.exponent().isFraction()) {
                    frac = Limit.lHospitalesRuleWithNumeratorRoot(numerator, denominator, data, engine);
                    return frac;
                }
                IExpr expr = engine.evalQuiet(F.Times((IExpr)F.D(numerator, x), (IExpr)F.Power((IExpr)F.D(denominator, x), F.CN1)));
                IExpr iExpr = Limit.evalLimit(expr, data);
                return iExpr;
            }
            catch (RecursionLimitExceeded rle) {
                engine.setRecursionLimit(recursionLimit);
            }
            finally {
                engine.setRecursionLimit(recursionLimit);
            }
            return F.NIL;
        }

        private static IExpr lHospitalesRuleWithNumeratorRoot(IExpr numerator, IExpr denominator, LimitData data, EvalEngine engine) {
            ISymbol x = data.variable();
            IFraction exponentFraction = (IFraction)numerator.exponent();
            IInteger n = exponentFraction.numerator();
            IInteger root = exponentFraction.denominator();
            IExpr newNumerator = engine.evalQuiet(F.Power(numerator.base(), n));
            IExpr newDenominator = engine.evalQuiet(F.Power(denominator, root));
            IExpr expr = engine.evalQuiet(F.Times((IExpr)F.D(newNumerator, x), (IExpr)F.Power((IExpr)F.D(newDenominator, x), F.CN1)));
            IExpr temp = Limit.evalLimit(expr, data);
            if (temp.isPresent()) {
                return F.Power(temp, F.QQ(F.C1, root));
            }
            return F.NIL;
        }

        private static IExpr limitsInfinityOfRationalFunctions(ExprPolynomial numeratorPoly, ExprPolynomial denominatorPoly, ISymbol symbol, IExpr limit, LimitData data) {
            long denomDegree;
            long numDegree = numeratorPoly.degree();
            if (numDegree > (denomDegree = denominatorPoly.degree())) {
                long oddDegree = (numDegree + denomDegree) % 2L;
                if (oddDegree == 1L) {
                    return data.limit(F.Times((IExpr)F.Divide(numeratorPoly.leadingBaseCoefficient(), denominatorPoly.leadingBaseCoefficient()), limit));
                }
                return data.limit(F.Times((IExpr)F.Divide(numeratorPoly.leadingBaseCoefficient(), denominatorPoly.leadingBaseCoefficient()), (IExpr)F.CInfinity));
            }
            if (numDegree < denomDegree) {
                return F.C0;
            }
            return F.Divide(numeratorPoly.leadingBaseCoefficient(), denominatorPoly.leadingBaseCoefficient());
        }

        private static IExpr numeratorDenominatorLimit(IExpr numerator, IExpr denominator, LimitData data) {
            IExpr limitValue = data.limitValue();
            EvalEngine engine = EvalEngine.get();
            if (denominator.isOne() && numerator.isTimes()) {
                return data.mapLimit((IAST)numerator);
            }
            if (!denominator.isNumber() || denominator.isZero()) {
                IExpr result = F.NIL;
                ISymbol x = data.variable();
                IExpr denValue = engine.evalModuleDummySymbol(denominator, x, limitValue, true);
                if (denValue.isIndeterminate()) {
                    return F.NIL;
                }
                if (denValue.isZero()) {
                    IExpr numValue = engine.evalModuleDummySymbol(numerator, x, limitValue, true);
                    if (numValue.isZero()) {
                        return Limit.lHospitalesRule(numerator, denominator, data);
                    }
                    return F.NIL;
                }
                if (denValue.isInfinity()) {
                    IExpr numValue = engine.evalModuleDummySymbol(numerator, x, limitValue, true);
                    if (numValue.isInfinity()) {
                        return Limit.lHospitalesRule(numerator, denominator, data);
                    }
                    if (numValue.isNegativeInfinity() && (numValue = engine.evalModuleDummySymbol(numerator = engine.evaluate(numerator.negate()), x, limitValue, true)).isInfinity() && (result = Limit.lHospitalesRule(numerator, denominator, data)).isPresent()) {
                        return result.negate();
                    }
                    return F.NIL;
                }
                if (denValue.isNegativeInfinity()) {
                    denValue = engine.evalModuleDummySymbol(denominator = engine.evaluate(denominator.negate()), x, limitValue, true);
                    if (denValue.isInfinity()) {
                        IExpr numValue = engine.evalModuleDummySymbol(numerator, x, limitValue, true);
                        if (numValue.isInfinity()) {
                            result = Limit.lHospitalesRule(numerator, denominator, data);
                            if (result.isPresent()) {
                                return result.negate();
                            }
                        } else if (numValue.isNegativeInfinity() && (numValue = engine.evalModuleDummySymbol(numerator = engine.evaluate(numerator.negate()), x, limitValue, true)).isInfinity()) {
                            return Limit.lHospitalesRule(numerator, denominator, data);
                        }
                        return F.NIL;
                    }
                    return F.NIL;
                }
            }
            return F.Times(data.limit(numerator), (IExpr)F.Power(data.limit(denominator), F.CN1));
        }

        private static IExpr plusLimit(IAST arg1, LimitData data) {
            IExpr limit = data.limitValue();
            if (limit.isInfinity() || limit.isNegativeInfinity()) {
                ISymbol symbol = data.variable();
                try {
                    ExprPolynomialRing ring = new ExprPolynomialRing(symbol);
                    ExprPolynomial poly = ring.create(arg1);
                    IExpr coeff = poly.leadingBaseCoefficient();
                    long oddDegree = poly.degree() % 2L;
                    if (oddDegree == 1L) {
                        return Limit.evalLimitQuiet(F.Times(coeff, limit), data);
                    }
                    return Limit.evalLimitQuiet(F.Times(coeff, (IExpr)F.CInfinity), data);
                }
                catch (RuntimeException e) {
                    LOGGER.debug("Limit.plusLimit() failed", (Throwable)e);
                }
            }
            return data.mapLimit(arg1);
        }

        private static IExpr powerLimit(IAST powerAST, LimitData data) {
            IExpr temp;
            IExpr base = powerAST.arg1();
            IExpr exponent = powerAST.arg2();
            if (exponent.equals(data.variable())) {
                boolean isInfinityLimit;
                if (data.limitValue().isZero() && !base.isZero()) {
                    return F.C1;
                }
                if (base.isFree(data.variable()) && !base.isZero() && ((isInfinityLimit = data.limitValue().isInfinity()) || data.limitValue().isNegativeInfinity())) {
                    if (base.isNumericFunction(true)) {
                        if (S.Greater.ofQ(F.Log(base), F.C0)) {
                            return isInfinityLimit ? F.CInfinity : F.C0;
                        }
                    } else if (base.isNumericFunction(s -> s.isSymbol() ? "" : null)) {
                        return F.ConditionalExpression(isInfinityLimit ? F.CInfinity : F.C0, F.Greater((IExpr)F.Log(base), F.C0));
                    }
                }
            }
            if (base.isRealResult() && !base.isZero() && (temp = Limit.evalReplaceAll(powerAST, data)).isPresent()) {
                return temp;
            }
            if (exponent.isFree(data.variable())) {
                IAST isFreeResult;
                temp = Limit.evalLimitQuiet(base, data);
                if (temp.isPresent()) {
                    if (temp.isZero() && !exponent.isNumericFunction(true)) {
                        return F.ConditionalExpression(F.C0, F.Greater(exponent, F.C0));
                    }
                    if (!temp.isZero() && temp.isFree(data.variable())) {
                        return F.Power(temp, exponent);
                    }
                }
                if (base.isTimes() && !(isFreeResult = ((IAST)base).partitionTimes(x -> x.isFree(data.variable(), true), F.C1, F.C1, S.List)).arg2().isOne()) {
                    return F.Times((IExpr)F.Power(isFreeResult.arg1(), exponent), data.limit(F.Power(isFreeResult.arg2(), exponent)));
                }
            }
            if (exponent.isNumericFunction(true)) {
                IInteger n;
                temp = Limit.evalLimitQuiet(base, data);
                if (temp.isNumericFunction(true)) {
                    if (temp.isZero()) {
                        if (exponent.isPositive()) {
                            return F.C0;
                        }
                        if (exponent.isNegative()) {
                            if (exponent.isInteger()) {
                                n = (IInteger)exponent;
                                if (n.isEven()) {
                                    return F.CInfinity;
                                }
                                if (data.direction() == Direction.TWO_SIDED) {
                                    return S.Indeterminate;
                                }
                                if (data.direction() == Direction.FROM_BELOW) {
                                    return F.CNInfinity;
                                }
                                if (data.direction() == Direction.FROM_ABOVE) {
                                    return F.CInfinity;
                                }
                            } else if (exponent.isFraction()) {
                                if (data.direction() == Direction.TWO_SIDED) {
                                    return S.Indeterminate;
                                }
                                if (data.direction() == Direction.FROM_ABOVE) {
                                    return F.CInfinity;
                                }
                            }
                        }
                        return F.NIL;
                    }
                    return F.Power(temp, exponent);
                }
                if (!temp.isPresent()) {
                    temp = base;
                }
                if (exponent.isInteger()) {
                    n = (IInteger)exponent;
                    if (temp.isInfinity()) {
                        if (n.isPositive()) {
                            return temp;
                        }
                        if (n.isNegative()) {
                            return F.C0;
                        }
                        return F.NIL;
                    }
                    if (temp.isNegativeInfinity()) {
                        if (n.isPositive()) {
                            if (n.isEven()) {
                                return F.CInfinity;
                            }
                            return F.CNInfinity;
                        }
                        if (n.isNegative()) {
                            return F.C0;
                        }
                        return F.NIL;
                    }
                    if (temp.equals(S.Indeterminate) || temp.isAST(S.Limit)) {
                        return F.NIL;
                    }
                    if (n.isPositive()) {
                        return F.Power(temp, n);
                    }
                    if (n.isNegative() && n.isEven()) {
                        return F.Power(temp, n);
                    }
                }
            }
            return F.NIL;
        }

        private static IExpr substituteInfinity(IAST arg1, LimitData data) {
            LimitData ndData;
            IExpr[] parts;
            IAST y;
            ISymbol x = data.variable();
            IExpr temp = F.evalQuiet(F.subst(arg1, x, y = F.Power((IExpr)x, F.CN1)));
            if (temp.isTimes() && (parts = Algebra.fractionalPartsTimesPower((IAST)temp, false, false, true, true, true, true)) != null && !parts[1].isOne() && (temp = Limit.numeratorDenominatorLimit(parts[0], parts[1], ndData = new LimitData(x, F.C0, F.Rule((IExpr)x, (IExpr)F.C0), data.direction()))).isPresent()) {
                return temp;
            }
            return F.NIL;
        }

        private static IExpr timesLimit(IAST timesAST, LimitData data) {
            EvalEngine engine = EvalEngine.get();
            IAST isFreeResult = timesAST.partitionTimes(x -> x.isFree(data.variable(), true), F.C1, F.C1, S.List);
            if (!isFreeResult.arg1().isOne()) {
                return F.Times(isFreeResult.arg1(), data.limit(isFreeResult.arg2()));
            }
            IExpr[] parts = Algebra.fractionalPartsTimesPower(timesAST, false, false, true, true, true, true);
            if (parts == null) {
                IAST[] timesPolyFiltered = timesAST.filter(x -> x.isPolynomial(data.variable));
                if (timesPolyFiltered[0].size() > 1 && timesPolyFiltered[1].size() > 1) {
                    IExpr first = engine.evaluate(data.limit(timesPolyFiltered[0].oneIdentity1()));
                    if (first.isIndeterminate()) {
                        return S.Indeterminate;
                    }
                    IExpr second = engine.evaluate(data.limit(timesPolyFiltered[1].oneIdentity1()));
                    if (second.isIndeterminate()) {
                        return S.Indeterminate;
                    }
                    if (first.isReal() || second.isReal()) {
                        IAST infinityExpr;
                        LimitData copy;
                        IExpr newTimes;
                        IExpr temp = engine.evaluate(F.Times(first, second));
                        if (!temp.isIndeterminate()) {
                            return temp;
                        }
                        if (data.limitValue().isZero() && (newTimes = timesAST.replaceAll(F.Rule((IExpr)data.variable, (IExpr)F.Power((IExpr)data.variable, F.CN1)))).isPresent() && !(temp = engine.evaluate((copy = new LimitData(data.variable, infinityExpr = data.direction == Direction.FROM_BELOW ? F.CNInfinity : F.CInfinity, F.Rule((IExpr)data.variable, (IExpr)infinityExpr), data.direction)).limit(newTimes))).isIndeterminate()) {
                            return temp;
                        }
                    }
                }
            } else {
                IExpr temp;
                IExpr plusResult;
                IExpr numerator = parts[0];
                IExpr denominator = parts[1];
                IExpr limit = data.limitValue();
                ISymbol symbol = data.variable();
                if (limit.isInfinity() || limit.isNegativeInfinity()) {
                    try {
                        ExprPolynomialRing ring = new ExprPolynomialRing(symbol);
                        ExprPolynomial denominatorPoly = ring.create(denominator);
                        ExprPolynomial numeratorPoly = ring.create(numerator);
                        return Limit.limitsInfinityOfRationalFunctions(numeratorPoly, denominatorPoly, symbol, limit, data);
                    }
                    catch (RuntimeException e) {
                        LOGGER.debug("Limit.timesLimit() failed", (Throwable)e);
                    }
                }
                if ((plusResult = Algebra.partsApart(parts, symbol, engine)).isPlus()) {
                    return data.mapLimit((IAST)plusResult);
                }
                if (denominator.isOne() && (limit.isInfinity() || limit.isNegativeInfinity()) && (temp = Limit.substituteInfinity(timesAST, data)).isPresent()) {
                    return temp;
                }
                temp = Limit.numeratorDenominatorLimit(numerator, denominator, data);
                if (temp.isPresent()) {
                    return temp;
                }
            }
            return data.mapLimit(timesAST);
        }

        private static IExpr logLimit(IAST logAST, LimitData data) {
            IAST isFreeResult;
            if (logAST.isAST2() && !logAST.isFree(data.variable())) {
                return F.NIL;
            }
            IExpr firstArg = logAST.arg1();
            if (firstArg.isPower() && firstArg.exponent().isFree(data.variable())) {
                IASTMutable arg1 = logAST.setAtCopy(1, firstArg.base());
                return F.Times(firstArg.exponent(), data.limit(arg1));
            }
            if (firstArg.isTimes() && !(isFreeResult = firstArg.partitionTimes(x -> x.isFree(data.variable(), true), F.C1, F.C1, S.List)).arg1().isOne()) {
                IASTMutable arg1 = logAST.setAtCopy(1, isFreeResult.arg1());
                IASTMutable arg2 = logAST.setAtCopy(1, isFreeResult.arg2());
                return F.Plus((IExpr)arg1, data.limit(arg2));
            }
            return F.NIL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (!arg2.isRuleAST()) {
                LOGGER.log(engine.getLogLevel(), "{}: rule definition expected at position 2!", (Object)ast.topHead());
                return F.NIL;
            }
            IAST rule = (IAST)arg2;
            if (!rule.arg1().isSymbol()) {
                LOGGER.log(engine.getLogLevel(), "{}: variable symbol for rule definition expected at position 2!", (Object)ast.topHead());
                return F.NIL;
            }
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            boolean numericMode = engine.isNumericMode();
            try {
                IExpr temp;
                engine.setNumericMode(false);
                Direction direction = Direction.TWO_SIDED;
                if (ast.isAST3()) {
                    OptionArgs options = new OptionArgs(ast.topHead(), ast, 2, engine);
                    IExpr option = options.getOption(S.Direction);
                    if (!option.isPresent()) {
                        LOGGER.log(engine.getLogLevel(), "{}: direction option expected at position 2!", (Object)ast.topHead());
                        IAssociation iAssociation = F.NIL;
                        return iAssociation;
                    }
                    if (option.isOne()) {
                        direction = Direction.FROM_BELOW;
                    } else if (option.isMinusOne()) {
                        direction = Direction.FROM_ABOVE;
                    } else {
                        if (!option.equals(S.Automatic) && !option.equals(S.Reals)) {
                            LOGGER.log(engine.getLogLevel(), "{}: direction option expected at position 2!", (Object)ast.topHead());
                            IAssociation iAssociation = F.NIL;
                            return iAssociation;
                        }
                        direction = Direction.TWO_SIDED;
                    }
                    if (direction == Direction.TWO_SIDED && (temp = S.Limit.evalDownRule(engine, F.Limit(arg1, arg2))).isPresent()) {
                        IExpr iExpr = temp;
                        return iExpr;
                    }
                }
                ISymbol symbol = (ISymbol)rule.arg1();
                IExpr limit = null;
                if (rule.isFreeAt(2, symbol)) {
                    limit = rule.arg2();
                    LimitData data = new LimitData(symbol, limit, rule, direction);
                    IExpr iExpr = Limit.evalLimit(arg1, data);
                    return iExpr;
                }
                LOGGER.log(engine.getLogLevel(), "{}: limit value is not free of variable symbol at position 2!", (Object)ast.topHead());
                temp = F.NIL;
                return temp;
            }
            finally {
                engine.setNumericMode(numericMode);
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(24576);
            super.setUp(newSymbol);
        }

        private static class LimitData {
            private final ISymbol variable;
            private final IExpr limitValue;
            private final IAST rule;
            private Direction direction;

            public LimitData(ISymbol variable, IExpr limitValue, IAST rule, Direction direction) {
                this.variable = variable;
                this.limitValue = limitValue;
                this.rule = rule;
                this.direction = direction;
            }

            public Direction direction() {
                return this.direction;
            }

            public IExpr limitValue() {
                return this.limitValue;
            }

            public IAST rule() {
                return this.rule;
            }

            public ISymbol variable() {
                return this.variable;
            }

            public IExpr limit(IExpr arg1) {
                return Limit.evalLimitQuiet(arg1, this);
            }

            public IAST mapLimit(IAST ast) {
                IASTMutable result = ast.copy();
                boolean isIndeterminate = false;
                boolean isLimit = false;
                for (int i = 1; i < ast.size(); ++i) {
                    IExpr temp = Limit.evalLimitQuiet(ast.get(i), this);
                    if (!temp.isFree(S.Limit)) {
                        isLimit = true;
                    } else if (temp.isIndeterminate()) {
                        isIndeterminate = true;
                    }
                    result.set(i, temp);
                }
                if (isLimit && isIndeterminate) {
                    return F.NIL;
                }
                return result;
            }
        }

        private static enum Direction {
            FROM_ABOVE(-1),
            TWO_SIDED(0),
            FROM_BELOW(1);

            private int direction;

            int toInt() {
                return this.direction;
            }

            private Direction(int direction) {
                this.direction = direction;
            }
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Limit.setEvaluator(new Limit());
            if (ToggleFeature.SERIES) {
                S.ComposeSeries.setEvaluator(new ComposeSeries());
                S.InverseSeries.setEvaluator(new InverseSeries());
                S.Normal.setEvaluator(new Normal());
                S.Series.setEvaluator(new Series());
                S.SeriesCoefficient.setEvaluator(new SeriesCoefficient());
                S.SeriesData.setEvaluator(new SeriesData());
            }
        }
    }
}

