/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import edu.jas.arith.BigRational;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.Rectangle;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.analysis.solvers.LaguerreSolver;
import org.hipparchus.complex.Complex;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.EigenDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.Expr2Object;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.convert.Object2Expr;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IEvalStepListener;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.QuarticSolver;
import org.matheclipse.core.polynomials.longexponent.ExprMonomial;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomial;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomialRing;
import org.matheclipse.core.polynomials.longexponent.ExprRingFactory;

public class RootsFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IAST roots(IExpr arg1, IAST variables, EvalEngine engine) {
        IExpr variable;
        if (variables.size() != 2) {
            LOGGER.log(engine.getLogLevel(), "NRoots: factorization only possible for univariate polynomials");
            return F.NIL;
        }
        IExpr expr = F.evalExpandAll(arg1, engine);
        double[] coefficients = Expr2Object.toPolynomial(expr, variable = variables.arg1());
        if (coefficients != null) {
            try {
                IASTMutable list;
                if (coefficients.length <= 4) {
                    int i;
                    IASTAppendable p = F.PlusAlloc(coefficients.length);
                    for (i = 0; i < coefficients.length; ++i) {
                        p.append(F.Times((IExpr)F.num(coefficients[i]), F.Power(variable, i)));
                    }
                    expr = engine.evaluate(p);
                    list = QuarticSolver.solve(p, variables.arg1());
                    for (i = 1; i < list.size(); ++i) {
                        expr = engine.evaluate(list.get(i));
                        if (!expr.isInexactNumber()) continue;
                        list.set(i, F.chopNumber((INumber)expr, Config.DEFAULT_ROOTS_CHOP_DELTA));
                    }
                } else {
                    LaguerreSolver solver = new LaguerreSolver(Config.DEFAULT_ROOTS_CHOP_DELTA);
                    Complex[] roots = solver.solveAllComplex(coefficients, 1.0);
                    list = Object2Expr.convertComplex(true, roots);
                }
                EvalAttributes.sort(list);
                return list;
            }
            catch (MathRuntimeException mrex) {
                LOGGER.debug("RootsFunctions.roots() failed", (Throwable)mrex);
                return F.NIL;
            }
        }
        IExpr denom = F.C1;
        if (expr.isAST() && !(denom = engine.evaluate(F.Denominator(expr = Algebra.together((IAST)expr, engine)))).isOne()) {
            expr = engine.evaluate(F.Numerator(expr));
        }
        return RootsFunctions.rootsOfVariable(expr, denom);
    }

    private static IAST rootsOfVariable(IExpr expr, IExpr denom) {
        IAST resultList = RootIntervals.croots(expr, true, EvalEngine.get());
        if (resultList.isPresent()) {
            return resultList;
        }
        return F.NIL;
    }

    protected static IAST roots(IExpr arg1, boolean numericSolutions, IAST variables, EvalEngine engine) {
        IExpr expr = F.evalExpandAll(arg1, engine);
        IExpr denom = F.C1;
        if (expr.isAST()) {
            expr = Algebra.together((IAST)expr, engine);
            denom = S.Denominator.of(engine, expr);
            if (!denom.isOne()) {
                expr = S.Numerator.of(engine, expr);
            }
        }
        return RootsFunctions.rootsOfVariable(expr, denom, variables, numericSolutions, engine);
    }

    private static IAST findRoots(double ... coefficients) {
        int i2;
        int N2 = coefficients.length - 1;
        Array2DRowRealMatrix c = new Array2DRowRealMatrix(N2, N2);
        double a = coefficients[N2];
        for (i2 = 0; i2 < N2; ++i2) {
            c.setEntry(i2, N2 - 1, -coefficients[i2] / a);
        }
        for (i2 = 1; i2 < N2; ++i2) {
            c.setEntry(i2, i2 - 1, 1.0);
        }
        EigenDecomposition ed = new EigenDecomposition((RealMatrix)c);
        double[] realValues = ed.getRealEigenvalues();
        double[] imagValues = ed.getImagEigenvalues();
        IASTAppendable roots = F.ListAlloc(N2);
        return roots.appendArgs(0, N2, i -> F.chopExpr(F.complexNum(realValues[i], imagValues[i]), Config.DEFAULT_ROOTS_CHOP_DELTA));
    }

    public static IASTMutable rootsOfExprPolynomial(IExpr expr, IAST varList, boolean rootsOfQuartic) {
        IASTMutable result = F.NIL;
        try {
            ExprPolynomialRing ring = new ExprPolynomialRing(ExprRingFactory.CONST, varList);
            ExprPolynomial ePoly = ring.create(expr, false, false, false);
            ePoly = ePoly.multiplyByMinimumNegativeExponents();
            if (ePoly.degree(0) >= Integer.MAX_VALUE) {
                return F.NIL;
            }
            if (ePoly.degree(0) >= 3L && (result = RootsFunctions.unitPolynomial((int)ePoly.degree(0), ePoly)).isPresent()) {
                result = QuarticSolver.sortASTArguments(result);
                return result;
            }
            if (!rootsOfQuartic && ePoly.degree(0) > 2L) {
                return F.NIL;
            }
            result = RootsFunctions.rootsOfQuarticPolynomial(ePoly);
            if (result.isPresent()) {
                if (expr.isNumericMode()) {
                    for (int i = 1; i < result.size(); ++i) {
                        result.set(i, F.chopExpr(result.get(i), Config.DEFAULT_ROOTS_CHOP_DELTA));
                    }
                }
                result = QuarticSolver.sortASTArguments(result);
                return result;
            }
        }
        catch (JASConversionException e2) {
            LOGGER.debug("RootsFunctions.rootsOfExprPolynomial() failed", (Throwable)((Object)e2));
        }
        return F.NIL;
    }

    private static IAST rootsOfQuadraticExprPolynomial(IExpr expr, IAST varList) {
        IASTMutable result = F.NIL;
        try {
            ExprPolynomialRing ring = new ExprPolynomialRing(ExprRingFactory.CONST, varList);
            ExprPolynomial ePoly = ring.create(expr, false, false, false);
            ePoly = ePoly.multiplyByMinimumNegativeExponents();
            result = RootsFunctions.rootsOfQuadraticPolynomial(ePoly);
            if (result.isPresent() && expr.isNumericMode()) {
                for (int i = 1; i < result.size(); ++i) {
                    result.set(i, F.chopExpr(result.get(i), Config.DEFAULT_ROOTS_CHOP_DELTA));
                }
            }
            result = QuarticSolver.sortASTArguments(result);
            return result;
        }
        catch (JASConversionException e2) {
            LOGGER.debug("RootsFunctions.rootsOfQuadraticExprPolynomial() failed", (Throwable)((Object)e2));
            return result;
        }
    }

    private static IASTAppendable rootsOfQuarticPolynomial(ExprPolynomial polynomial) {
        long varDegree = polynomial.degree(0);
        if (polynomial.isConstant()) {
            return F.ListAlloc(0);
        }
        if (varDegree <= 4L) {
            IExpr a = F.C0;
            IExpr b = F.C0;
            IExpr c = F.C0;
            IExpr d = F.C0;
            IExpr e = F.C0;
            for (ExprMonomial monomial : polynomial) {
                IExpr coeff = monomial.coefficient();
                long lExp = monomial.exponent().getVal(0);
                if (lExp == 4L) {
                    a = coeff;
                    continue;
                }
                if (lExp == 3L) {
                    b = coeff;
                    continue;
                }
                if (lExp == 2L) {
                    c = coeff;
                    continue;
                }
                if (lExp == 1L) {
                    d = coeff;
                    continue;
                }
                if (lExp == 0L) {
                    e = coeff;
                    continue;
                }
                return F.NIL;
            }
            IASTAppendable result = QuarticSolver.quarticSolve(a, b, c, d, e);
            if (result.isPresent()) {
                return (IASTAppendable)QuarticSolver.sortASTArguments(result);
            }
        }
        return F.NIL;
    }

    private static IASTAppendable nthComplexRoot(int n, ExprPolynomial polynomial) {
        IExpr coefficientN = F.C0;
        IExpr coefficient0 = F.C0;
        for (ExprMonomial monomial : polynomial) {
            IExpr coefficient = monomial.coefficient();
            long lExp = monomial.exponent().getVal(0);
            if (lExp == (long)n) {
                coefficientN = coefficient;
                continue;
            }
            if (lExp == 0L) {
                coefficient0 = coefficient;
                continue;
            }
            return F.NIL;
        }
        if (coefficientN.isZero() || coefficient0.isZero()) {
            return F.NIL;
        }
        EvalEngine engine = EvalEngine.get();
        IExpr a = engine.evaluate(F.Divide(F.Negate(coefficient0), coefficientN));
        if (a.isNumber()) {
            IAST z = ((INumber)a).toPolarCoordinates();
            IExpr r = z.arg1();
            IExpr theta = z.arg2();
            IRational fraction = F.fraction(1L, n);
            IAST f1 = F.Power(r, fraction);
            IASTAppendable result = F.ListAlloc(n);
            for (int k = 0; k < n; ++k) {
                IASTMutable argCosSin = F.Times((IExpr)fraction, (IExpr)F.Plus(theta, (IExpr)F.Times((IExpr)F.ZZ(k + k), (IExpr)S.Pi)));
                IAST f2 = F.Plus((IExpr)F.Cos(argCosSin), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Sin(argCosSin)));
                result.append(F.Times((IExpr)f1, (IExpr)f2));
            }
            return result;
        }
        return F.NIL;
    }

    private static IASTAppendable unitPolynomial(int varDegree, ExprPolynomial polynomial) {
        IExpr zDenominator;
        IExpr zNumerator;
        IExpr a = F.C0;
        IExpr b = F.C0;
        for (ExprMonomial monomial : polynomial) {
            IExpr coeff = monomial.coefficient();
            long lExp = monomial.exponent().getVal(0);
            if (lExp == (long)varDegree) {
                a = coeff;
                continue;
            }
            if (lExp == 0L) {
                b = coeff;
                continue;
            }
            return F.NIL;
        }
        if (a.isZero() || b.isZero()) {
            return F.NIL;
        }
        boolean isNegative = false;
        IExpr rhsNumerator = EvalEngine.get().evaluate(b.negate());
        IExpr rhsDenominator = a;
        if ((varDegree & 1) == 1) {
            IExpr zDenominator2;
            IExpr zNumerator2;
            if (rhsNumerator.isTimes()) {
                IASTMutable temp = ((IAST)rhsNumerator).mapThread(F.Power((IExpr)F.Slot1, F.fraction(1L, varDegree)), 1);
                if (rhsNumerator.first().isNegative()) {
                    isNegative = true;
                    temp.set(1, rhsNumerator.first().negate());
                }
                zNumerator2 = EvalEngine.get().evaluate(temp);
            } else {
                if (rhsNumerator.isNegative()) {
                    isNegative = true;
                    rhsNumerator = rhsNumerator.negate();
                }
                zNumerator2 = EvalEngine.get().evaluate(F.Power(rhsNumerator, F.fraction(1L, varDegree)));
            }
            if (rhsDenominator.isTimes()) {
                IASTMutable temp = ((IAST)rhsDenominator).mapThread(F.Power((IExpr)F.Slot1, F.fraction(-1L, varDegree)), 1);
                if (rhsDenominator.first().isNegative()) {
                    isNegative = !isNegative;
                    temp.set(1, rhsDenominator.first().negate());
                }
                zDenominator2 = EvalEngine.get().evaluate(temp);
            } else {
                if (rhsDenominator.isNegative()) {
                    isNegative = !isNegative;
                    rhsDenominator = rhsDenominator.negate();
                }
                zDenominator2 = EvalEngine.get().evaluate(F.Power(rhsDenominator, F.fraction(-1L, varDegree)));
            }
            IASTAppendable result = F.ListAlloc(varDegree);
            for (int i = 0; i < varDegree; ++i) {
                if (isNegative) {
                    result.append(F.Times(F.Power((IExpr)F.CN1, i + 1), F.Power((IExpr)F.CN1, F.fraction(i, varDegree)), zNumerator2, zDenominator2));
                    continue;
                }
                result.append(F.Times(F.Power((IExpr)F.CN1, i), F.Power((IExpr)F.CN1, F.fraction(i, varDegree)), zNumerator2, zDenominator2));
            }
            return result;
        }
        if (rhsNumerator.isTimes()) {
            IASTMutable temp = ((IAST)rhsNumerator).mapThread(F.Power((IExpr)F.Slot1, F.fraction(1L, varDegree)), 1);
            zNumerator = EvalEngine.get().evaluate(temp);
        } else {
            zNumerator = EvalEngine.get().evaluate(F.Power(rhsNumerator, F.fraction(1L, varDegree)));
        }
        if (rhsDenominator.isTimes()) {
            IASTMutable temp = ((IAST)rhsDenominator).mapThread(F.Power((IExpr)F.Slot1, F.fraction(-1L, varDegree)), 1);
            zDenominator = EvalEngine.get().evaluate(temp);
        } else {
            zDenominator = EvalEngine.get().evaluate(F.Power(rhsDenominator, F.fraction(-1L, varDegree)));
        }
        IASTAppendable result = F.ListAlloc(varDegree);
        long size = varDegree / 2;
        int k = 0;
        int i = 1;
        while ((long)i <= size) {
            result.append(F.Times(F.CN1, F.Power((IExpr)F.CN1, F.fraction(k, varDegree)), zNumerator, zDenominator));
            result.append(F.Times((IExpr)F.Power((IExpr)F.CN1, F.fraction(k, varDegree)), zNumerator, zDenominator));
            k += 2;
            ++i;
        }
        return result;
    }

    private static IASTAppendable rootsOfQuadraticPolynomial(ExprPolynomial polynomial) {
        long varDegree = polynomial.degree(0);
        if (polynomial.isConstant()) {
            return F.ListAlloc(1);
        }
        if (varDegree <= 2L) {
            Object temp;
            IEvalStepListener listener = EvalEngine.get().getStepListener();
            if (listener != null && (temp = listener.rootsOfQuadraticPolynomial(polynomial)).isPresent()) {
                return temp;
            }
            IExpr a = F.C0;
            IExpr b = F.C0;
            IExpr c = F.C0;
            IExpr d = F.C0;
            IExpr e = F.C0;
            for (ExprMonomial monomial : polynomial) {
                IExpr coeff = monomial.coefficient();
                long lExp = monomial.exponent().getVal(0);
                if (lExp == 4L) {
                    a = coeff;
                    continue;
                }
                if (lExp == 3L) {
                    b = coeff;
                    continue;
                }
                if (lExp == 2L) {
                    c = coeff;
                    continue;
                }
                if (lExp == 1L) {
                    d = coeff;
                    continue;
                }
                if (lExp == 0L) {
                    e = coeff;
                    continue;
                }
                throw new ArithmeticException("Roots::Unexpected exponent value: " + lExp);
            }
            IASTAppendable result = QuarticSolver.quarticSolve(a, b, c, d, e);
            if (result.isPresent()) {
                result = (IASTAppendable)QuarticSolver.sortASTArguments(result);
                return result;
            }
        }
        return F.NIL;
    }

    public static IAST rootsOfVariable(IExpr expr, IExpr denominator, IAST variables, boolean numericSolutions, EvalEngine engine) {
        IASTMutable result = F.NIL;
        List<IExpr> varList = variables.copyTo();
        try {
            IAST list = RootsFunctions.rootsOfQuadraticExprPolynomial(expr, variables);
            if (list.isPresent()) {
                return list;
            }
            JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, (RingFactory<BigRational>)BigRational.ZERO);
            Object polyRat = jas.expr2JAS(expr, numericSolutions);
            result = RootsFunctions.rootsOfExprPolynomial(expr, variables, false);
            if (result.isPresent()) {
                return result;
            }
            IASTAppendable newResult = F.ListAlloc(8);
            IAST factorRational = Algebra.factorRational(polyRat, jas, S.List);
            for (int i = 1; i < factorRational.size(); ++i) {
                IExpr temp = F.evalExpand(factorRational.get(i));
                IASTMutable quarticResultList = QuarticSolver.solve(temp, variables.arg1());
                if (quarticResultList.isPresent()) {
                    for (int j = 1; j < quarticResultList.size(); ++j) {
                        if (numericSolutions) {
                            newResult.append(F.chopExpr(engine.evalN(quarticResultList.get(j)), Config.DEFAULT_ROOTS_CHOP_DELTA));
                            continue;
                        }
                        newResult.append(quarticResultList.get(j));
                    }
                    continue;
                }
                polyRat = jas.expr2JAS(temp, numericSolutions);
                IAST factorComplex = Algebra.factorRational(polyRat, jas, S.List);
                for (int k = 1; k < factorComplex.size(); ++k) {
                    temp = F.evalExpand(factorComplex.get(k));
                    quarticResultList = QuarticSolver.solve(temp, variables.arg1());
                    if (quarticResultList.isPresent()) {
                        for (int j = 1; j < quarticResultList.size(); ++j) {
                            if (numericSolutions) {
                                newResult.append(F.chopExpr(engine.evalN(quarticResultList.get(j)), Config.DEFAULT_ROOTS_CHOP_DELTA));
                                continue;
                            }
                            newResult.append(quarticResultList.get(j));
                        }
                        continue;
                    }
                    double[] coefficients = RootsFunctions.coefficients(temp, (ISymbol)variables.arg1());
                    if (coefficients == null) {
                        return F.NIL;
                    }
                    IAST resultList = RootsFunctions.findRoots(coefficients);
                    if (resultList.size() <= 0) continue;
                    newResult.appendArgs(resultList);
                }
            }
            newResult = QuarticSolver.createSet(newResult);
            return newResult;
        }
        catch (RuntimeException rex) {
            result = RootsFunctions.rootsOfExprPolynomial(expr, variables, true);
            if (result.isPresent()) {
                if (!denominator.isNumber()) {
                    int i = 1;
                    IASTAppendable appendable = F.NIL;
                    while (i < result.size()) {
                        IExpr temp = denominator.replaceAll(F.Rule(variables.arg1(), result.get(i)));
                        if (temp.isPresent() && engine.evaluate(temp).isZero()) {
                            if (!appendable.isPresent()) {
                                appendable = result.removeAtClone(i);
                                continue;
                            }
                            appendable.remove(i);
                            continue;
                        }
                        ++i;
                    }
                }
                return result;
            }
            return F.NIL;
        }
    }

    public static double[] coefficients(IExpr polynomial, ISymbol variable) throws JASConversionException {
        try {
            ExprPolynomialRing ring = new ExprPolynomialRing(F.list(variable));
            ExprPolynomial poly = ring.create(polynomial);
            IAST list = poly.coefficientList();
            int degree = list.size() - 2;
            double[] result = new double[degree + 1];
            for (int i = 1; i < list.size(); ++i) {
                ISignedNumber temp = list.get(i).evalReal();
                if (temp == null) {
                    return null;
                }
                result[i - 1] = temp.doubleValue();
            }
            return result;
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public static void initialize() {
        Initializer.init();
    }

    private RootsFunctions() {
    }

    private static class Roots
    extends AbstractFunctionEvaluator {
        private Roots() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isEqual()) {
                IAST equalAST = (IAST)arg1;
                arg1 = equalAST.arg2().isZero() ? equalAST.arg1() : engine.evaluate(F.Subtract(equalAST.arg1(), equalAST.arg2()));
            } else {
                LOGGER.log(engine.getLogLevel(), "{}: Equal() expression expected at position 1 instead of {}", (Object)ast.topHead(), (Object)ast.arg1());
                return F.NIL;
            }
            VariablesSet eVar = null;
            if (ast.arg2().isList()) {
                eVar = new VariablesSet(ast.arg2());
            } else {
                eVar = new VariablesSet();
                eVar.add(ast.arg2());
            }
            if (!eVar.isSize(1)) {
                LOGGER.log(engine.getLogLevel(), "{}: factorization only possible for univariate polynomials at position 2 instead of {}", (Object)ast.topHead(), (Object)ast.arg2());
                return F.NIL;
            }
            IASTAppendable variables = eVar.getVarList();
            IExpr variable = variables.arg1();
            IAST list = RootsFunctions.roots(arg1, false, variables, engine);
            if (list.isPresent()) {
                IASTAppendable or = F.ast((IExpr)S.Or, list.size());
                for (int i = 1; i < list.size(); ++i) {
                    or.append(F.Equal(variable, list.get(i)));
                }
                return or;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class NRoots
    extends AbstractFunctionEvaluator {
        private NRoots() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST variables;
            IExpr arg1 = ast.arg1();
            if (arg1.isEqual()) {
                IAST equalAST = (IAST)arg1;
                arg1 = equalAST.arg2().isZero() ? equalAST.arg1() : engine.evaluate(F.Subtract(equalAST.arg1(), equalAST.arg2()));
            } else if (!arg1.isPolynomialStruct()) {
                LOGGER.log(engine.getLogLevel(), "{}: Equal() expression expected at position 1 instead of {}", (Object)ast.topHead(), (Object)ast.arg1());
                return F.NIL;
            }
            if (ast.size() == 2) {
                VariablesSet eVar = new VariablesSet(ast.arg1());
                if (!eVar.isSize(1)) {
                    LOGGER.log(engine.getLogLevel(), "NRoots: factorization only possible for univariate polynomials");
                    return F.NIL;
                }
                variables = eVar.getVarList();
            } else {
                variables = Validate.checkIsVariableOrVariableList(ast, 2, ast.topHead(), engine);
                if (!variables.isPresent()) {
                    return F.NIL;
                }
            }
            if (variables.size() <= 1) {
                return F.NIL;
            }
            IAST temp = RootsFunctions.roots(arg1, variables, engine);
            if (!temp.isList()) {
                return F.NIL;
            }
            IAST list = temp;
            int size = list.size();
            IASTAppendable result = F.ListAlloc(size);
            return result.appendArgs(size, i -> engine.evalN(list.get(i)));
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private static IAST rootsUp2Degree3(double[] coefficients) {
            if (coefficients.length == 0) {
                return F.NIL;
            }
            if (coefficients.length == 1) {
                return NRoots.quadratic(0.0, 0.0, coefficients[0]);
            }
            if (coefficients.length == 2) {
                return NRoots.quadratic(0.0, coefficients[1], coefficients[0]);
            }
            if (coefficients.length == 3) {
                return NRoots.quadratic(coefficients[2], coefficients[1], coefficients[0]);
            }
            IAST result = F.NIL;
            if (coefficients.length == 4) {
                result = NRoots.cubic(coefficients[3], coefficients[2], coefficients[1], coefficients[0]);
            }
            return result;
        }

        private static IAST quadratic(double a, double b, double c) {
            IASTAppendable result = F.ListAlloc(2);
            double discriminant = b * b - 4.0 * a * c;
            if (F.isZero(discriminant)) {
                double bothEqual = -b / (2.0 * a);
                result.append(bothEqual);
                result.append(bothEqual);
            } else if (discriminant < 0.0) {
                double imaginaryPart = Math.sqrt(-discriminant) / (2.0 * a);
                double realPart = -b / (2.0 * a);
                result.append(F.complex(realPart, imaginaryPart));
                result.append(F.complex(realPart, -imaginaryPart));
            } else {
                double real1 = (-b + Math.sqrt(discriminant)) / (2.0 * a);
                double real2 = (-b - Math.sqrt(discriminant)) / (2.0 * a);
                result.append(real1);
                result.append(real2);
            }
            return result;
        }

        private static IAST cubic(double a, double b, double c, double d) {
            if (F.isZero(a)) {
                return F.NIL;
            }
            if (F.isZero(d)) {
                return F.NIL;
            }
            IASTAppendable result = F.ListAlloc(3);
            double q = (3.0 * (c /= a) - (b /= a) * b) / 9.0;
            double r = -(27.0 * (d /= a)) + b * (9.0 * c - 2.0 * (b * b));
            double discriminant = q * q * q + (r /= 54.0) * r;
            double term1 = b / 3.0;
            if (discriminant > 0.0) {
                double s = r + Math.sqrt(discriminant);
                s = s < 0.0 ? -Math.pow(-s, 0.3333333333333333) : Math.pow(s, 0.3333333333333333);
                double t = r - Math.sqrt(discriminant);
                t = t < 0.0 ? -Math.pow(-t, 0.3333333333333333) : Math.pow(t, 0.3333333333333333);
                result.append(-term1 + s + t);
                double realPart = -(term1 += (s + t) / 2.0);
                term1 = Math.sqrt(3.0) * (-t + s) / 2.0;
                result.append(F.complex(realPart, term1));
                result.append(F.complex(realPart, -term1));
                return result;
            }
            if (F.isZero(discriminant)) {
                double r13 = r < 0.0 ? -Math.pow(-r, 0.3333333333333333) : Math.pow(r, 0.3333333333333333);
                result.append(-term1 + 2.0 * r13);
                result.append(-(r13 + term1));
                result.append(-(r13 + term1));
                return result;
            }
            q = -q;
            double dum1 = q * q * q;
            dum1 = Math.acos(r / Math.sqrt(dum1));
            double r13 = 2.0 * Math.sqrt(q);
            result.append(-term1 + r13 * Math.cos(dum1 / 3.0));
            result.append(-term1 + r13 * Math.cos((dum1 + Math.PI * 2) / 3.0));
            result.append(-term1 + r13 * Math.cos((dum1 + Math.PI * 4) / 3.0));
            return result;
        }
    }

    private static class RootIntervals
    extends AbstractFunctionEvaluator {
        private RootIntervals() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return RootIntervals.croots(ast.arg1(), false, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        public static IAST croots(IExpr arg, boolean numeric, EvalEngine engine) {
            try {
                VariablesSet eVar = new VariablesSet(arg);
                if (!eVar.isSize(1)) {
                    return IOFunctions.printMessage(S.RootIntervals, "nupr", F.List(arg), engine);
                }
                IExpr expr = F.evalExpandAll(arg);
                List<IExpr> varList = eVar.getVarList().copyTo();
                ComplexRing cfac = new ComplexRing((RingFactory)new BigRational(1L));
                ComplexRootsSturm cr = new ComplexRootsSturm((RingFactory)cfac);
                JASConvert jas = new JASConvert((List<? extends IExpr>)varList, cfac);
                GenPolynomial poly = jas.numericExpr2JAS(expr);
                SquarefreeAbstract squarefreeEngine = SquarefreeFactory.getImplementation((RingFactory)cfac);
                poly = squarefreeEngine.squarefreePart(poly);
                List roots = cr.complexRoots(poly);
                BigRational len = new BigRational(1L, 100000L);
                IASTAppendable resultList = F.ListAlloc(roots.size());
                if (numeric) {
                    for (Rectangle root : roots) {
                        Rectangle refine = cr.complexRootRefinement(root, poly, len);
                        resultList.append(JASConvert.jas2Numeric((edu.jas.poly.Complex<BigRational>)refine.getCenter(), Config.DEFAULT_ROOTS_CHOP_DELTA));
                    }
                } else {
                    for (Rectangle root : roots) {
                        IASTAppendable rectangleList = F.ListAlloc(4);
                        Rectangle refine = cr.complexRootRefinement(root, poly, len);
                        rectangleList.append(JASConvert.jas2Complex((edu.jas.poly.Complex<BigRational>)refine.getNW()));
                        rectangleList.append(JASConvert.jas2Complex((edu.jas.poly.Complex<BigRational>)refine.getSW()));
                        rectangleList.append(JASConvert.jas2Complex((edu.jas.poly.Complex<BigRational>)refine.getSE()));
                        rectangleList.append(JASConvert.jas2Complex((edu.jas.poly.Complex<BigRational>)refine.getNE()));
                        resultList.append(rectangleList);
                    }
                }
                EvalAttributes.sort(resultList);
                return resultList;
            }
            catch (InvalidBoundaryException | IllegalArgumentException | JASConversionException e) {
                return IOFunctions.printMessage(S.RootIntervals, "argillegal", F.List(arg), engine);
            }
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.NRoots.setEvaluator(new NRoots());
            S.Roots.setEvaluator(new Roots());
            S.RootIntervals.setEvaluator(new RootIntervals());
        }
    }
}

