/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.complex.Complex;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.util.MathArrays;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.StatisticsFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.Tensors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public final class RandomFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void initialize() {
        Initializer.init();
    }

    private RandomFunctions() {
    }

    private static final class RandomSample
    extends AbstractFunctionEvaluator {
        private RandomSample() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList()) {
                int n;
                int n2 = n = ast.isAST2() ? ast.arg2().toIntDefault() : Integer.MAX_VALUE;
                if (n >= 0) {
                    return RandomSample.shuffle((IAST)ast.arg1(), n);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        public static IAST shuffle(IAST list, int n) {
            int len = list.argSize();
            int[] indexList = MathArrays.natural((int)len);
            MathArrays.shuffle((int[])indexList);
            if (n < len) {
                IASTAppendable result = list.copyHead();
                for (int j = 0; j < n; ++j) {
                    result.append(list.get(indexList[j] + 1));
                }
                return result;
            }
            return list.copy().setArgs(1, len + 1, i -> list.get(indexList[i - 1] + 1));
        }
    }

    private static final class RandomReal
    extends AbstractFunctionEvaluator {
        private RandomReal() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                ThreadLocalRandom tlr = ThreadLocalRandom.current();
                double r = tlr.nextDouble();
                return F.num(r);
            }
            IExpr arg1 = ast.arg1();
            if (ast.isAST1()) {
                return RandomReal.randomReal(arg1, engine);
            }
            if (ast.isAST2()) {
                if (ast.arg2().isList()) {
                    if (ast.arg2().argSize() == 1) {
                        int n = ast.arg2().first().toIntDefault();
                        if (n <= 0) {
                            return F.NIL;
                        }
                        return RandomReal.randomASTRealVector(arg1, n, engine);
                    }
                    IAST list = (IAST)ast.arg2();
                    int[] dimension = Validate.checkListOfInts(ast, (IExpr)list, 1, Integer.MAX_VALUE, engine);
                    if (dimension == null) {
                        return F.NIL;
                    }
                    return Tensors.build(() -> RandomReal.randomReal(arg1, engine), dimension);
                }
                int n = ast.arg2().toIntDefault();
                if (n > 0) {
                    return RandomReal.randomASTRealVector(arg1, n, engine);
                }
            }
            return F.NIL;
        }

        private static IExpr randomReal(IExpr arg1, EvalEngine engine) {
            if (arg1.isList2()) {
                double temp;
                double max;
                double min = engine.evalDouble(arg1.first());
                if (min >= (max = engine.evalDouble(arg1.second())) && (min = max) == (max = (temp = min))) {
                    return F.num(min);
                }
                ThreadLocalRandom tlr = ThreadLocalRandom.current();
                return F.num(tlr.nextDouble(min, max));
            }
            boolean isNegative = false;
            double max = engine.evalDouble(arg1);
            if (max < 0.0) {
                isNegative = true;
                max = Math.abs(max);
            }
            if (F.isZero(max)) {
                return F.CD0;
            }
            ThreadLocalRandom tlr = ThreadLocalRandom.current();
            double nextDouble = tlr.nextDouble(max);
            if (isNegative) {
                nextDouble *= -1.0;
            }
            return F.num(nextDouble);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }

        private static IExpr randomASTRealVector(IExpr arg1, int n, EvalEngine engine) {
            if (Config.MAX_AST_SIZE < n) {
                ASTElementLimitExceeded.throwIt(n);
            }
            double[] array = new double[n];
            if (arg1.isList2()) {
                double temp;
                double max;
                double min = engine.evalDouble(arg1.first());
                if (min >= (max = engine.evalDouble(arg1.second())) && (min = max) == (max = (temp = min))) {
                    return F.num(min);
                }
                ThreadLocalRandom tlr = ThreadLocalRandom.current();
                for (int i = 0; i < array.length; ++i) {
                    array[i] = tlr.nextDouble(min, max);
                }
            } else {
                IEvaluator evaluator;
                ISymbol head;
                IAST dist;
                if (arg1.isAST() && (dist = (IAST)arg1).head().isSymbol() && (head = (ISymbol)dist.head()) instanceof IBuiltInSymbol && (evaluator = ((IBuiltInSymbol)head).getEvaluator()) instanceof StatisticsFunctions.IRandomVariate) {
                    return S.RandomVariate.ofNIL(engine, arg1, F.ZZ(n));
                }
                boolean isNegative = false;
                double max = engine.evalDouble(arg1);
                if (max < 0.0) {
                    isNegative = true;
                    max = Math.abs(max);
                }
                ThreadLocalRandom tlr = ThreadLocalRandom.current();
                for (int i = 0; i < array.length; ++i) {
                    if (F.isZero(max)) {
                        int n2 = i;
                        array[n2] = array[n2] * 0.0;
                        continue;
                    }
                    array[i] = tlr.nextDouble(max);
                    if (!isNegative) continue;
                    int n3 = i;
                    array[n3] = array[n3] * -1.0;
                }
            }
            return new ASTRealVector(array, false);
        }
    }

    private static final class RandomPrime
    extends AbstractFunctionEvaluator {
        private RandomPrime() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            BigInteger TWO;
            IExpr arg1 = ast.arg1();
            boolean parametersChecked = false;
            BigInteger lowerLimit = TWO = BigInteger.valueOf(2L);
            BigInteger upperLimit = BigInteger.ONE;
            if (arg1.isInteger()) {
                upperLimit = ((IInteger)arg1).toBigNumerator();
                if (upperLimit.compareTo(TWO) < 0) {
                    return IOFunctions.printMessage(ast.topHead(), "intp", F.CEmptyList, engine);
                }
                if (upperLimit.compareTo(TWO) < 0) {
                    return IOFunctions.printMessage(ast.topHead(), "noprime", F.CEmptyList, engine);
                }
                parametersChecked = true;
            } else if (arg1.isList2() && arg1.first().isInteger() && arg1.second().isInteger()) {
                lowerLimit = ((IInteger)arg1.first()).toBigNumerator();
                upperLimit = ((IInteger)arg1.second()).toBigNumerator();
                if (lowerLimit.compareTo(TWO) < 0) {
                    return IOFunctions.printMessage(ast.topHead(), "intp", F.CEmptyList, engine);
                }
                if (upperLimit.compareTo(TWO) < 0) {
                    return IOFunctions.printMessage(ast.topHead(), "intp", F.CEmptyList, engine);
                }
                if (upperLimit.compareTo(lowerLimit) < 0) {
                    return IOFunctions.printMessage(ast.topHead(), "noprime", F.CEmptyList, engine);
                }
                if (!lowerLimit.isProbablePrime(32) && upperLimit.compareTo(lowerLimit.nextProbablePrime()) < 0) {
                    return IOFunctions.printMessage(ast.topHead(), "noprime", F.CEmptyList, engine);
                }
                parametersChecked = true;
            } else {
                IOFunctions.printMessage(ast.topHead(), "intp", F.CEmptyList, engine);
                return F.NIL;
            }
            if (parametersChecked) {
                try {
                    if (ast.isAST2()) {
                        int[] dimension = Validate.checkDimension(ast, ast.arg2(), engine);
                        if (dimension == null) {
                            return F.NIL;
                        }
                        BigInteger lowLimit = lowerLimit;
                        BigInteger highLimit = upperLimit;
                        return Tensors.build(() -> RandomPrime.randomPrime(lowLimit, highLimit, ast, engine), dimension);
                    }
                    return RandomPrime.randomPrime(lowerLimit, upperLimit, ast, engine);
                }
                catch (ValidateException ve) {
                    IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("RandomPrime.evaluate() failed", (Throwable)rex);
                    return IOFunctions.printMessage(ast.topHead(), "noprime", F.CEmptyList, engine);
                }
            }
            return F.NIL;
        }

        private static IExpr randomPrime(BigInteger lowerLimit, BigInteger upperLimit, IAST ast, EvalEngine engine) {
            BigInteger randomNumber;
            if (lowerLimit.isProbablePrime(32) && upperLimit.compareTo(lowerLimit.nextProbablePrime()) < 0) {
                return F.ZZ(lowerLimit);
            }
            int llen = lowerLimit.bitLength();
            int ulen = upperLimit.bitLength();
            ThreadLocalRandom tlr = ThreadLocalRandom.current();
            long counter = 0L;
            do {
                int blen = tlr.nextInt(llen, ulen + 1);
                randomNumber = new BigInteger(blen, 32, tlr);
                if (counter++ <= 100000L) continue;
                randomNumber = lowerLimit.nextProbablePrime();
                break;
            } while (randomNumber.compareTo(upperLimit) > 0 || randomNumber.compareTo(lowerLimit) < 0);
            return F.ZZ(randomNumber);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class RandomPermutation
    extends AbstractFunctionEvaluator {
        private RandomPermutation() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int d = ast.arg1().toIntDefault();
            if (d > 0) {
                IAST randomVariate = F.RandomVariate(F.UniformDistribution(F.list(F.C0, F.C1)), F.ZZ(d));
                if (ast.isAST1()) {
                    IExpr ordering = S.Ordering.of(engine, randomVariate);
                    return F.Cycles(F.list(ordering));
                }
                int n = ast.arg2().toIntDefault();
                if (n > 0) {
                    IASTAppendable list = F.ListAlloc(n);
                    for (int i = 0; i < n; ++i) {
                        IExpr ordering = S.Ordering.of(engine, randomVariate);
                        list.append(F.Cycles(F.list(ordering)));
                    }
                    return list;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class RandomInteger
    extends AbstractFunctionEvaluator {
        private RandomInteger() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                ThreadLocalRandom tlr = ThreadLocalRandom.current();
                return this.randomBigInteger(BigInteger.ONE, false, tlr);
            }
            if (ast.arg1().isAST(S.List, 3)) {
                int min = ast.arg1().first().toIntDefault();
                int max = ast.arg1().second().toIntDefault();
                if (min != Integer.MIN_VALUE && max != Integer.MIN_VALUE) {
                    int temp;
                    if (min >= max && (min = max) == (max = (temp = min))) {
                        return F.ZZ(min);
                    }
                    if (max == Integer.MAX_VALUE) {
                        return F.NIL;
                    }
                    ThreadLocalRandom tlr = ThreadLocalRandom.current();
                    if (ast.isAST2()) {
                        IExpr arg2 = ast.arg2();
                        if (arg2.isList()) {
                            int[] dimension = Validate.checkListOfInts(ast, arg2, 1, Integer.MAX_VALUE, engine);
                            if (dimension == null) {
                                return F.NIL;
                            }
                            int min2 = min;
                            int max2 = max;
                            return Tensors.build(() -> F.ZZ(tlr.nextInt(max2 - min2 + 1) + min2), dimension);
                        }
                        int size = arg2.toIntDefault();
                        if (size >= 0) {
                            IASTAppendable list = F.ListAlloc(size);
                            for (int i = 0; i < size; ++i) {
                                list.append(tlr.nextInt(max - min + 1) + min);
                            }
                            return list;
                        }
                        return F.NIL;
                    }
                    return F.ZZ(tlr.nextInt(max - min + 1) + min);
                }
                return F.NIL;
            }
            if (ast.arg1().isInteger()) {
                ThreadLocalRandom tlr = ThreadLocalRandom.current();
                BigInteger upperLimit = ((IInteger)ast.arg1()).toBigNumerator();
                boolean negative = false;
                if (upperLimit.compareTo(BigInteger.ZERO) < 0) {
                    upperLimit = upperLimit.negate();
                    negative = true;
                }
                if (ast.isAST2() && !ast.arg2().isEmptyList()) {
                    IExpr arg2 = ast.arg2();
                    if (arg2.isList()) {
                        int[] dimension = Validate.checkListOfInts(ast, arg2, 1, Integer.MAX_VALUE, engine);
                        if (dimension == null) {
                            return F.NIL;
                        }
                        BigInteger upperLimit2 = upperLimit;
                        boolean negative2 = negative;
                        return Tensors.build(() -> this.randomBigInteger(upperLimit2, negative2, tlr), dimension);
                    }
                    int size = arg2.toIntDefault();
                    if (size >= 0) {
                        IASTAppendable list = F.ListAlloc(size);
                        for (int i = 0; i < size; ++i) {
                            list.append(this.randomBigInteger(upperLimit, negative, tlr));
                        }
                        return list;
                    }
                } else {
                    return this.randomBigInteger(upperLimit, negative, tlr);
                }
            }
            return F.NIL;
        }

        private IExpr randomBigInteger(BigInteger upperLimit, boolean negative, ThreadLocalRandom tlr) {
            BigInteger r;
            int nlen = upperLimit.bitLength();
            while ((r = new BigInteger(nlen, tlr)).compareTo(upperLimit) > 0) {
            }
            return F.ZZ(negative ? r.negate() : r);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }
    }

    private static final class RandomComplex
    extends AbstractFunctionEvaluator {
        private RandomComplex() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST0()) {
                    ThreadLocalRandom tlr = ThreadLocalRandom.current();
                    double re = tlr.nextDouble();
                    double im = tlr.nextDouble();
                    return F.complexNum(re, im);
                }
                if (ast.isAST1()) {
                    if (ast.arg1().isAST(S.List, 3)) {
                        double temp;
                        Complex min = engine.evalComplex(ast.arg1().first());
                        Complex max = engine.evalComplex(ast.arg1().second());
                        double minRe = min.getReal();
                        double minIm = min.getImaginary();
                        double maxRe = max.getReal();
                        double maxIm = max.getImaginary();
                        if (!(minRe >= maxRe) || (minRe = maxRe) == (maxRe = (temp = minRe))) {
                            // empty if block
                        }
                        if (minIm >= maxIm && (minIm = maxIm) == (maxIm = (temp = minIm)) && minRe == maxRe) {
                            F.complexNum(minRe, minIm);
                        }
                        ThreadLocalRandom tlr = ThreadLocalRandom.current();
                        return F.complexNum(tlr.nextDouble(minRe, maxRe), tlr.nextDouble(minIm, maxIm));
                    }
                    Complex max = engine.evalComplex(ast.arg1());
                    ThreadLocalRandom tlr = ThreadLocalRandom.current();
                    return F.complexNum(tlr.nextDouble(max.getReal()), tlr.nextDouble(max.getImaginary()));
                }
                if (ast.isAST2() && ast.arg2().isList()) {
                    IAST list = (IAST)ast.arg2();
                    int[] dimension = Validate.checkListOfInts(ast, (IExpr)list, 1, Integer.MAX_VALUE, engine);
                    if (dimension == null) {
                        return F.NIL;
                    }
                    IExpr[] arr = new IExpr[list.size()];
                    arr[0] = F.RandomComplex(ast.arg1());
                    for (int i = 1; i < list.size(); ++i) {
                        arr[i] = F.list(list.get(i));
                    }
                    return F.ast(arr, S.Table);
                }
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }
    }

    private static final class RandomChoice
    extends AbstractFunctionEvaluator {
        private RandomChoice() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isRuleAST() && arg1.first().isList() && arg1.second().isList() && arg1.first().size() == arg1.second().size()) {
                IAST weights = (IAST)arg1.first();
                IAST items = (IAST)arg1.second();
                double[] itemWeights = weights.toDoubleVector();
                if (itemWeights != null) {
                    EnumeratedDistributionSampler sampler = new EnumeratedDistributionSampler(itemWeights);
                    if (ast.size() == 2) {
                        int[] chosen = sampler.sample(1);
                        return items.get(chosen[0] + 1);
                    }
                    if (ast.isAST2()) {
                        IExpr arg2 = ast.arg2();
                        if (arg2.isList()) {
                            int[] dimension = Validate.checkListOfInts(ast, arg2, 1, Integer.MAX_VALUE, engine);
                            if (dimension == null) {
                                return F.NIL;
                            }
                            return Tensors.build(() -> items.get(sampler.sample(1)[0] + 1), dimension);
                        }
                        int n = arg2.toIntDefault();
                        if (n > 0) {
                            IASTAppendable result = F.ListAlloc(n);
                            int[] chosen = sampler.sample(n);
                            for (int i = 0; i < n; ++i) {
                                result.append(items.get(chosen[i] + 1));
                            }
                            return result;
                        }
                    }
                }
            } else if (arg1.isList()) {
                IAST list = (IAST)arg1;
                ThreadLocalRandom random = ThreadLocalRandom.current();
                int listSize = list.argSize();
                if (listSize == 0) {
                    return F.NIL;
                }
                int randomIndex = random.nextInt(listSize);
                if (ast.size() == 2) {
                    return list.get(randomIndex + 1);
                }
                if (ast.isAST2()) {
                    IExpr arg2 = ast.arg2();
                    if (arg2.isList()) {
                        int[] dimension = Validate.checkListOfInts(ast, arg2, 1, Integer.MAX_VALUE, engine);
                        if (dimension == null) {
                            return F.NIL;
                        }
                        int[] randomValue = new int[1];
                        return Tensors.build(() -> {
                            randomValue[0] = random.nextInt(listSize);
                            return list.get(randomValue[0] + 1);
                        }, dimension);
                    }
                    int n = arg2.toIntDefault();
                    if (n > 0) {
                        IASTAppendable result = F.ListAlloc(n);
                        for (int i = 0; i < n; ++i) {
                            result.append(list.get(randomIndex + 1));
                            randomIndex = random.nextInt(listSize);
                        }
                        return result;
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private final class EnumeratedDistributionSampler {
            private final double[] weights;

            EnumeratedDistributionSampler(double[] weights) {
                this.weights = weights;
            }

            public int[] sample(int sampleSize) {
                RandomDataGenerator rg = new RandomDataGenerator();
                return rg.nextSampleWithReplacement(sampleSize, this.weights);
            }
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.RandomInteger.setEvaluator(new RandomInteger());
            S.RandomPrime.setEvaluator(new RandomPrime());
            S.RandomChoice.setEvaluator(new RandomChoice());
            S.RandomComplex.setEvaluator(new RandomComplex());
            S.RandomPermutation.setEvaluator(new RandomPermutation());
            S.RandomReal.setEvaluator(new RandomReal());
            S.RandomSample.setEvaluator(new RandomSample());
        }
    }
}

