/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.DateObjectExpr;
import org.matheclipse.core.expression.data.TimeObjectExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.tensor.qty.IQuantity;
import org.matheclipse.core.tensor.qty.IUnit;
import org.matheclipse.core.tensor.qty.UnitSystem;

public class QuantityFunctions {
    private static final Logger LOGGER = LogManager.getLogger();
    static final HashMap<String, Function<LocalDateTime, IExpr>> DATEVALUE_MAP = new HashMap();

    public static void initialize() {
        Initializer.init();
    }

    private QuantityFunctions() {
    }

    public static IExpr unitConvert(IQuantity arg1, IUnit unit) {
        org.matheclipse.core.tensor.qty.UnitConvert unitConvert = org.matheclipse.core.tensor.qty.UnitConvert.SI();
        return (IExpr)unitConvert.to(unit).apply(arg1);
    }

    private static final class UnitConvert
    extends AbstractCoreFunctionEvaluator {
        private UnitConvert() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.size() == 2) {
                    IExpr arg1 = engine.evaluate(ast.arg1());
                    if (arg1.isQuantity()) {
                        return (IExpr)UnitSystem.SI().apply(arg1);
                    }
                } else if (ast.size() == 3) {
                    IExpr arg1 = engine.evaluate(ast.arg1());
                    IExpr arg2 = engine.evaluate(ast.arg2());
                    if (arg1.isQuantity()) {
                        IUnit unit = IUnit.of(arg2.toString());
                        if (unit == null) {
                            return F.NIL;
                        }
                        return QuantityFunctions.unitConvert((IQuantity)arg1, unit);
                    }
                }
            }
            catch (RuntimeException e) {
                LOGGER.log(engine.getLogLevel(), "UnitConvert", (Throwable)e);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class QuantityMagnitude
    extends AbstractCoreFunctionEvaluator {
        private QuantityMagnitude() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.size() == 2) {
                    IExpr arg1 = engine.evaluate(ast.arg1());
                    if (arg1.isQuantity()) {
                        return ((IQuantity)arg1).value();
                    }
                } else if (ast.size() == 3) {
                    IExpr arg1 = engine.evaluate(ast.arg1());
                    IExpr arg2 = engine.evaluate(ast.arg2());
                    if (arg1.isQuantity()) {
                        org.matheclipse.core.tensor.qty.QuantityMagnitude quantityMagnitude = org.matheclipse.core.tensor.qty.QuantityMagnitude.SI();
                        IUnit unit = IUnit.of(arg2.toString());
                        if (unit == null) {
                            return F.NIL;
                        }
                        UnaryOperator<IExpr> suo = quantityMagnitude.in(unit);
                        return (IExpr)suo.apply(arg1);
                    }
                }
            }
            catch (RuntimeException e) {
                LOGGER.log(engine.getLogLevel(), "QuantityMagnitude", (Throwable)e);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Quantity
    extends AbstractCoreFunctionEvaluator {
        private Quantity() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IExpr arg1;
                if (ast.size() == 2 && (arg1 = engine.evaluate(ast.arg1())).isString()) {
                    IUnit unit = IUnit.of(arg1.toString());
                    if (unit == null) {
                        return F.NIL;
                    }
                    return IQuantity.of(F.C1, unit);
                }
                if (ast.size() == 3) {
                    arg1 = engine.evaluate(ast.arg1());
                    IExpr arg2 = engine.evaluate(ast.arg2());
                    if (arg2.isString()) {
                        IUnit unit = IUnit.of(arg2.toString());
                        if (unit == null) {
                            return F.NIL;
                        }
                        return IQuantity.of(arg1, unit);
                    }
                }
            }
            catch (RuntimeException e) {
                LOGGER.log(engine.getLogLevel(), "Quantity", (Throwable)e);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class TimeObject
    extends AbstractFunctionEvaluator {
        private TimeObject() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.size() == 1) {
                    LocalTime now = LocalTime.now();
                    return TimeObjectExpr.newInstance(LocalTime.of(now.getHour(), now.getMinute(), now.getSecond()));
                }
                if (ast.size() == 2) {
                    IAST list;
                    IExpr arg1 = ast.arg1();
                    if (arg1.isList() && (list = (IAST)arg1).size() >= 2 && list.size() <= 4) {
                        int hour = list.arg1().toIntDefault();
                        int minute = 0;
                        if (list.size() >= 3) {
                            minute = list.arg2().toIntDefault();
                        }
                        int second = 0;
                        if (list.size() == 4) {
                            second = list.arg3().toIntDefault();
                        }
                        if (hour >= 0 && minute >= 0 && second >= 0) {
                            return TimeObjectExpr.newInstance(LocalTime.of(hour, minute, second));
                        }
                    }
                    return F.NIL;
                }
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }
    }

    private static final class DateValue
    extends AbstractFunctionEvaluator {
        private DateValue() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    String str;
                    Function<LocalDateTime, IExpr> function;
                    IExpr arg1 = ast.arg1();
                    if (ast.arg1().isList()) {
                        return ((IAST)ast.arg1()).mapThread(ast, 1);
                    }
                    if (arg1.isString() && (function = DATEVALUE_MAP.get(str = ((IStringX)arg1).toString())) != null) {
                        return function.apply(LocalDateTime.now());
                    }
                    return F.NIL;
                }
                if (ast.isAST2()) {
                    IExpr arg1 = ast.arg1();
                    IExpr arg2 = ast.arg2();
                    if (arg2.isList()) {
                        return ((IAST)ast.arg2()).mapThread(ast, 2);
                    }
                    if (arg1 instanceof DateObjectExpr && arg2.isString()) {
                        LocalDateTime ldt = (LocalDateTime)((DateObjectExpr)arg1).toData();
                        String str = ((IStringX)arg2).toString();
                        Function<LocalDateTime, IExpr> function = DATEVALUE_MAP.get(str);
                        if (function != null) {
                            return function.apply(ldt);
                        }
                    }
                    return F.NIL;
                }
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }
    }

    private static final class DateString
    extends AbstractFunctionEvaluator {
        private DateString() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                long secondsSince1900;
                if (ast.isAST0()) {
                    LocalDateTime now = LocalDateTime.now();
                    String dateString = now.format(DateTimeFormatter.ofPattern("EEE dd MMM yyyy HH:mm:ss"));
                    return F.stringx(dateString);
                }
                if (ast.isAST1() && (secondsSince1900 = ast.arg1().toLongDefault()) >= 0L) {
                    Instant base = LocalDate.of(1900, Month.JANUARY, 1).atStartOfDay(ZoneOffset.UTC).toInstant();
                    LocalDateTime date = LocalDateTime.ofInstant(base.plusSeconds(secondsSince1900), ZoneOffset.UTC);
                    String dateString = date.format(DateTimeFormatter.ofPattern("EEE dd MMM yyyy HH:mm:ss"));
                    return F.stringx(dateString);
                }
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }
    }

    private static final class DateObject
    extends AbstractFunctionEvaluator {
        private DateObject() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.size() == 1) {
                    return DateObjectExpr.newInstance(LocalDateTime.now());
                }
                if (ast.size() == 2) {
                    IAST list;
                    IExpr arg1 = ast.arg1();
                    if (arg1.isList() && (list = (IAST)arg1).size() == 4) {
                        int year = list.arg1().toIntDefault();
                        int month = list.arg2().toIntDefault();
                        int day = list.arg3().toIntDefault();
                        if (year != Integer.MIN_VALUE && month != Integer.MIN_VALUE && day != Integer.MIN_VALUE) {
                            return DateObjectExpr.newInstance(LocalDateTime.of(year, month, day, 0, 0));
                        }
                    }
                    return F.NIL;
                }
                if (ast.size() == 3 && ast.arg1() instanceof DateObjectExpr && ast.arg2() instanceof TimeObjectExpr) {
                    LocalDate ld = ((LocalDateTime)((DateObjectExpr)ast.arg1()).toData()).toLocalDate();
                    LocalTime lt = (LocalTime)((TimeObjectExpr)ast.arg2()).toData();
                    return DateObjectExpr.newInstance(LocalDateTime.of(ld, lt));
                }
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.DateObject.setEvaluator(new DateObject());
            S.DateString.setEvaluator(new DateString());
            S.DateValue.setEvaluator(new DateValue());
            S.TimeObject.setEvaluator(new TimeObject());
            S.Quantity.setEvaluator(new Quantity());
            S.QuantityMagnitude.setEvaluator(new QuantityMagnitude());
            S.UnitConvert.setEvaluator(new UnitConvert());
            DATEVALUE_MAP.put("Year", x -> F.ZZ(x.getYear()));
            DATEVALUE_MAP.put("ISOYearDay", x -> F.ZZ(x.getDayOfYear()));
            DATEVALUE_MAP.put("ISOYearDayShort", x -> F.ZZ(x.getDayOfYear()));
            DATEVALUE_MAP.put("Month", x -> F.ZZ(x.getMonthValue()));
            DATEVALUE_MAP.put("MonthShort", x -> F.ZZ(x.getMonthValue()));
            DATEVALUE_MAP.put("Day", x -> F.ZZ(x.getDayOfMonth()));
            DATEVALUE_MAP.put("Hour", x -> F.ZZ(x.getHour()));
            DATEVALUE_MAP.put("HourShort", x -> F.ZZ(x.getHour()));
            DATEVALUE_MAP.put("Minute", x -> F.ZZ(x.getMinute()));
            DATEVALUE_MAP.put("MinuteShort", x -> F.ZZ(x.getMinute()));
            DATEVALUE_MAP.put("Second", x -> F.ZZ(x.getSecond()));
            DATEVALUE_MAP.put("SecondShort", x -> F.ZZ(x.getSecond()));
            DATEVALUE_MAP.put("MonthName", x -> F.stringx(x.getMonth().getDisplayName(TextStyle.FULL, Locale.US)));
            DATEVALUE_MAP.put("MonthNameShort", x -> F.stringx(x.getMonth().getDisplayName(TextStyle.SHORT, Locale.US)));
            DATEVALUE_MAP.put("MonthNameInitial", x -> F.stringx(x.getMonth().getDisplayName(TextStyle.NARROW, Locale.US)));
            DATEVALUE_MAP.put("DayName", x -> F.stringx(x.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.US)));
            DATEVALUE_MAP.put("DayNameShort", x -> F.stringx(x.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.US)));
        }
    }
}

