/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.stat.descriptive.DescriptiveStatistics;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.AbortException;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.BreakException;
import org.matheclipse.core.eval.exception.ConditionException;
import org.matheclipse.core.eval.exception.ContinueException;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.NoEvalException;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.eval.exception.SymjaMathException;
import org.matheclipse.core.eval.exception.ThrowException;
import org.matheclipse.core.eval.exception.TimeoutException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.ISetEvaluator;
import org.matheclipse.core.eval.util.Iterator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.SparseArrayExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IIterator;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISparseArray;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.RulesData;
import org.matheclipse.core.visit.ModuleReplaceAll;

public final class Programming {
    private static final Logger LOGGER = LogManager.getLogger();

    private static boolean rememberWithVariables(IAST variablesList, Map<ISymbol, IExpr> variablesMap, EvalEngine engine) {
        for (int i = 1; i < variablesList.size(); ++i) {
            IExpr rightHandSide;
            ISymbol oldSymbol;
            IAST setFun;
            if (variablesList.get(i).isAST(S.Set, 3)) {
                setFun = (IAST)variablesList.get(i);
                if (setFun.arg1().isSymbol()) {
                    oldSymbol = (ISymbol)setFun.arg1();
                    rightHandSide = setFun.arg2();
                    IExpr temp = engine.evaluate(rightHandSide);
                    VariablesSet set = new VariablesSet(temp);
                    set.putAllSymbols(variablesMap);
                    variablesMap.put(oldSymbol, temp);
                    continue;
                }
                IOFunctions.printMessage(S.With, "lvset", F.list(variablesList, variablesList.get(i), setFun.arg1()), engine);
                return false;
            }
            if (variablesList.get(i).isAST(S.SetDelayed, 3)) {
                setFun = (IAST)variablesList.get(i);
                if (setFun.arg1().isSymbol()) {
                    oldSymbol = (ISymbol)setFun.arg1();
                    rightHandSide = setFun.arg2();
                    VariablesSet set = new VariablesSet(rightHandSide);
                    set.putAllSymbols(variablesMap);
                    variablesMap.put(oldSymbol, rightHandSide);
                    continue;
                }
                IOFunctions.printMessage(S.With, "lvset", F.list(variablesList, variablesList.get(i), setFun.arg1()), engine);
                return false;
            }
            IOFunctions.printMessage(S.With, "lvws", F.list(variablesList.get(i), variablesList), engine);
            return false;
        }
        return true;
    }

    public static boolean rememberModuleVariables(IAST variablesList, String varAppend, Map<ISymbol, IExpr> variablesMap, EvalEngine engine) {
        for (int i = 1; i < variablesList.size(); ++i) {
            ISymbol newSymbol;
            ISymbol oldSymbol;
            if (variablesList.get(i).isSymbol()) {
                oldSymbol = (ISymbol)variablesList.get(i);
                newSymbol = F.Dummy(oldSymbol.toString() + varAppend);
                variablesMap.put(oldSymbol, newSymbol);
                continue;
            }
            if (variablesList.get(i).isAST(S.Set, 3)) {
                IAST setFun = (IAST)variablesList.get(i);
                if (setFun.arg1().isSymbol()) {
                    oldSymbol = (ISymbol)setFun.arg1();
                    newSymbol = F.Dummy(oldSymbol.toString() + varAppend);
                    variablesMap.put(oldSymbol, newSymbol);
                    newSymbol.assignValue(engine.evaluate(setFun.arg2()));
                    continue;
                }
                LOGGER.log(engine.getLogLevel(), "Module: expression requires symbol variable: {}", (Object)setFun);
                return false;
            }
            LOGGER.log(engine.getLogLevel(), "Module: expression requires symbol variable: {}", (Object)variablesList.get(i));
            return false;
        }
        return true;
    }

    public static void rememberBlockVariables(IAST variablesList, ISymbol[] symbolList, IExpr[] assignedValues, RulesData[] assignedRules, EvalEngine engine) {
        IAST setFun;
        ISymbol variableSymbol;
        int i;
        for (i = 1; i < variablesList.size(); ++i) {
            ISymbol substitute;
            if (variablesList.get(i).isSymbol()) {
                ISymbol substitute2;
                variableSymbol = (ISymbol)variablesList.get(i);
                if (variableSymbol.isBuiltInSymbol() && (substitute2 = ((IBuiltInSymbol)variableSymbol).mapToGlobal(engine)) != null) {
                    variableSymbol = substitute2;
                }
                symbolList[i] = variableSymbol;
                assignedValues[i] = variableSymbol.assignedValue();
                assignedRules[i] = variableSymbol.getRulesData();
                continue;
            }
            if (!variablesList.get(i).isAST(S.Set, 3) || !(setFun = (IAST)variablesList.get(i)).arg1().isSymbol()) continue;
            variableSymbol = (ISymbol)setFun.arg1();
            if (variableSymbol.isBuiltInSymbol() && (substitute = ((IBuiltInSymbol)variableSymbol).mapToGlobal(engine)) != null) {
                variableSymbol = substitute;
            }
            symbolList[i] = variableSymbol;
            assignedValues[i] = variableSymbol.assignedValue();
            assignedRules[i] = variableSymbol.getRulesData();
        }
        for (i = 1; i < variablesList.size(); ++i) {
            if (variablesList.get(i).isSymbol()) {
                variableSymbol = symbolList[i];
                variableSymbol.assignValue(null, false);
                variableSymbol.setRulesData(null);
                continue;
            }
            if (!variablesList.get(i).isAST(S.Set, 3) || !(setFun = (IAST)variablesList.get(i)).arg1().isSymbol()) continue;
            variableSymbol = symbolList[i];
            IExpr temp = engine.evaluate(setFun.arg2());
            variableSymbol.assignValue(temp, false);
            variableSymbol.setRulesData(null);
        }
    }

    private static IExpr moduleSubstVariables(IAST intializerList, IExpr moduleBlock, EvalEngine engine) {
        IdentityHashMap<ISymbol, IExpr> moduleVariables;
        String varAppend = EvalEngine.uniqueName("$");
        if (Programming.rememberModuleVariables(intializerList, varAppend, moduleVariables = new IdentityHashMap<ISymbol, IExpr>(), engine)) {
            IExpr result = moduleBlock.accept(new ModuleReplaceAll(moduleVariables, engine, varAppend));
            return result.orElse(moduleBlock);
        }
        return F.NIL;
    }

    private static IExpr withSubstVariables(IAST intializerList, IExpr withBlock, EvalEngine engine) {
        IdentityHashMap<ISymbol, IExpr> moduleVariables = new IdentityHashMap<ISymbol, IExpr>();
        if (Programming.rememberWithVariables(intializerList, moduleVariables, engine)) {
            IExpr result = withBlock.accept(new ModuleReplaceAll(moduleVariables, engine, EvalEngine.uniqueName("$")));
            return result.orElse(withBlock);
        }
        return F.NIL;
    }

    private static IExpr getIndex(IAST ast, int pos, EvalEngine engine) {
        int position = pos;
        if (position < 0) {
            position = ast.size() + position;
        }
        if (position < 0 || position >= ast.size()) {
            return IOFunctions.printMessage(S.Part, "partw", F.list(F.ZZ(pos), ast), engine);
        }
        return ast.get(position);
    }

    private static IExpr getIndexRule(IAST ast, int pos, EvalEngine engine) {
        int position = pos;
        if (position < 0) {
            position = ast.size() + position;
        }
        if (position < 0 || position >= ast.size()) {
            return IOFunctions.printMessage(S.Part, "partw", F.list(F.ZZ(pos), ast), engine);
        }
        return ast.getRule(position);
    }

    public static IExpr part(IAST arg1, IAST ast, int pos, EvalEngine engine) {
        IExpr arg2 = engine.evaluate(ast.get(pos));
        int p1 = pos + 1;
        int[] span = arg2.isSpan(arg1.size());
        if (span != null) {
            int start = span[0];
            int last = span[1];
            int step = span[2];
            return Programming.spanPart(ast, pos, arg1, arg2, start, last, step, p1, engine);
        }
        if (arg2.equals(S.All)) {
            return Programming.spanPart(ast, pos, arg1, arg2, 1, arg1.size() - 1, 1, p1, engine);
        }
        if (arg2.isReal()) {
            int indx = ast.get(pos).toIntDefault();
            if (indx == Integer.MIN_VALUE) {
                return IOFunctions.printMessage(S.Part, "partw", F.list(ast.get(pos), arg1), engine);
            }
            IExpr result = Programming.getIndex(arg1, indx, engine);
            if (result.isPresent()) {
                if (p1 < ast.size()) {
                    if (result.isASTOrAssociation()) {
                        return Programming.part((IAST)result, ast, p1, engine);
                    }
                    return IOFunctions.printMessage(S.Part, "partd", F.list(result), engine);
                }
                return result;
            }
            return F.NIL;
        }
        if (arg1.isAssociation()) {
            IAssociation assoc = (IAssociation)arg1;
            if (arg2.isList()) {
                IExpr temp = null;
                IAST list = (IAST)arg2;
                IAssociation result = F.assoc();
                for (int i = 1; i < list.size(); ++i) {
                    IExpr listArg = list.get(i);
                    if (listArg.isReal()) {
                        int indx = listArg.toIntDefault();
                        if (indx == Integer.MIN_VALUE) {
                            return IOFunctions.printMessage(S.Part, "partw", F.list(listArg, arg1), engine);
                        }
                        IExpr ires = Programming.getIndexRule(arg1, indx, engine);
                        if (ires.isPresent()) {
                            if (p1 < ast.size()) {
                                if (ires.isASTOrAssociation()) {
                                    temp = Programming.part((IAST)ires, ast, p1, engine);
                                    if (temp.isPresent()) {
                                        try {
                                            result.appendRule(temp);
                                            continue;
                                        }
                                        catch (IndexOutOfBoundsException ioobex) {
                                            return IOFunctions.printMessage(S.Part, "pkspec1", F.list(temp), engine);
                                        }
                                    }
                                    return F.NIL;
                                }
                                return IOFunctions.printMessage(S.Part, "partd", F.list(ires), engine);
                            }
                            try {
                                result.appendRule(ires);
                                continue;
                            }
                            catch (IndexOutOfBoundsException ioobex) {
                                return IOFunctions.printMessage(S.Part, "pkspec1", F.list(ires), engine);
                            }
                        }
                        return F.NIL;
                    }
                    if (listArg.isAST(S.Key, 2)) {
                        result.appendRule(assoc.getRule(listArg.first()));
                        continue;
                    }
                    if (listArg.isString()) {
                        result.appendRule(assoc.getRule(listArg));
                        continue;
                    }
                    if (!listArg.isNumber()) continue;
                    return IOFunctions.printMessage(S.Part, "pkspec1", F.list(list), engine);
                }
                return result;
            }
            IExpr result = F.NIL;
            if (arg2.isAST(S.Key, 2)) {
                result = assoc.getValue(arg2.first());
            } else if (arg2.isString()) {
                result = assoc.getValue(arg2);
            }
            if (result.isPresent()) {
                if (p1 < ast.size()) {
                    if (result.isASTOrAssociation()) {
                        return Programming.part((IAST)result, ast, p1, engine);
                    }
                    return IOFunctions.printMessage(S.Part, "partd", F.list(result), engine);
                }
                return result;
            }
        } else if (arg2.isList()) {
            IExpr temp = null;
            IAST list = (IAST)arg2;
            IASTAppendable result = F.ast(arg1.head(), list.size());
            for (int i = 1; i < list.size(); ++i) {
                IExpr listArg = list.get(i);
                if (listArg.isReal()) {
                    int indx = listArg.toIntDefault();
                    if (indx == Integer.MIN_VALUE) {
                        return IOFunctions.printMessage(S.Part, "partw", F.list(listArg, arg1), engine);
                    }
                    IExpr ires = Programming.getIndex(arg1, indx, engine);
                    if (ires.isPresent()) {
                        if (p1 < ast.size()) {
                            if (ires.isASTOrAssociation()) {
                                temp = Programming.part((IAST)ires, ast, p1, engine);
                                if (temp.isPresent()) {
                                    result.append(temp);
                                    continue;
                                }
                                return F.NIL;
                            }
                            return IOFunctions.printMessage(S.Part, "partd", F.list(ires), engine);
                        }
                        result.append(ires);
                        continue;
                    }
                    return F.NIL;
                }
                if (!listArg.isNumber() && !listArg.isString()) continue;
                return IOFunctions.printMessage(S.Part, "pkspec1", F.list(list), engine);
            }
            return result;
        }
        return IOFunctions.printMessage(S.Part, "pkspec1", F.list(arg2), engine);
    }

    public static IExpr sparsePart(ISparseArray arg1, IAST ast, int pos, EvalEngine engine) {
        SparseArrayExpr sparseArray;
        IExpr res;
        if (ast.forAll(x -> x.isInteger() && x.isPositive() || x.equals(S.All), 2)) {
            return arg1.getPart(ast, 2);
        }
        IASTMutable temp = arg1.normal(false);
        if (temp.isList() && (res = Programming.part(temp, ast, pos, engine)).isList() && (sparseArray = SparseArrayExpr.newDenseList((IAST)res, arg1.getDefaultValue())) != null) {
            return sparseArray;
        }
        return IOFunctions.printMessage(S.Part, "pkspec1", F.list(ast), engine);
    }

    private static IExpr spanPart(IAST ast, int pos, IAST arg1, IExpr arg2, int start, int last, int step, int p1, EvalEngine engine) {
        int size = arg1.size();
        if (step < 0 && start >= last) {
            IASTAppendable result = arg1.copyHead((last - start) / step + 2);
            for (int i = start; i >= last; i += step) {
                IExpr temp;
                if (p1 >= ast.size()) {
                    temp = Programming.getIndexRule(arg1, i, engine);
                    if (temp.isPresent()) {
                        result.appendRule(temp);
                        continue;
                    }
                    return F.NIL;
                }
                if (arg1.get(i).isASTOrAssociation()) {
                    if (i >= size) {
                        return IOFunctions.printMessage(S.Part, "take", F.list(F.ZZ(start), F.ZZ(last), arg1), engine);
                    }
                    temp = Programming.part((IAST)arg1.get(i), ast, p1, engine);
                    if (temp.isPresent()) {
                        result.append(temp);
                        continue;
                    }
                }
                return IOFunctions.printMessage(S.Part, "partd", F.list(arg1.get(i)), engine);
            }
            return result;
        }
        if (step > 0 && (last != 1 || start <= last)) {
            IASTAppendable result = arg1.copyHead((last - start) / step + 2);
            for (int i = start; i <= last; i += step) {
                if (p1 >= ast.size()) {
                    IExpr temp = Programming.getIndexRule(arg1, i, engine);
                    if (temp.isPresent()) {
                        result.appendRule(temp);
                        continue;
                    }
                    return F.NIL;
                }
                if (arg1.get(i).isASTOrAssociation()) {
                    if (i >= size) {
                        return IOFunctions.printMessage(S.Part, "take", F.list(F.ZZ(start), F.ZZ(last), arg1), engine);
                    }
                    if (arg1.isAssociation()) {
                        IAST rule = (IAST)arg1.getRule(i);
                        IAST argAST = (IAST)rule.second();
                        IExpr temp = Programming.part(argAST, ast, p1, engine);
                        if (temp.isPresent()) {
                            result.appendRule(rule.setAtCopy(2, temp));
                            continue;
                        }
                    } else {
                        IAST argAST = (IAST)arg1.get(i);
                        IExpr temp = Programming.part(argAST, ast, p1, engine);
                        if (temp.isPresent()) {
                            result.append(temp);
                            continue;
                        }
                    }
                }
                return IOFunctions.printMessage(S.Part, "partd", F.list(arg1.get(i)), engine);
            }
            return result;
        }
        return IOFunctions.printMessage(S.Part, "pkspec1", F.list(arg2), engine);
    }

    private static IExpr assignPart(IExpr assignedExpr, IAST part, int partPosition, IExpr value, EvalEngine engine) {
        if (partPosition >= part.size()) {
            return value;
        }
        if (!assignedExpr.isASTOrAssociation()) {
            return IOFunctions.printMessage(S.Part, "partd", F.list(part), engine);
        }
        IAST assignedAST = (IAST)assignedExpr;
        IExpr arg2 = engine.evaluate(part.get(partPosition));
        int partPositionPlus1 = partPosition + 1;
        int[] span = arg2.isSpan(assignedAST.size());
        if (span != null) {
            int start = span[0];
            int last = span[1];
            int step = span[2];
            IASTAppendable result = F.NIL;
            if (step < 0 && start >= last) {
                for (int i = start; i >= last; i += step) {
                    IExpr element = assignedAST.get(i);
                    result = Programming.assignPartSpanValue(assignedAST, element, part, partPositionPlus1, result, i, value, engine);
                }
            } else if (step > 0 && (last != 1 || start <= last)) {
                for (int i = start; i <= last; i += step) {
                    IExpr element = assignedAST.get(i);
                    result = Programming.assignPartSpanValue(assignedAST, element, part, partPositionPlus1, result, i, value, engine);
                }
            } else {
                return IOFunctions.printMessage(S.Part, "partw", F.list(F.ZZ(partPosition), arg2), engine);
            }
            return result;
        }
        if (arg2.isReal()) {
            int indx = Validate.throwIntType(arg2, Integer.MIN_VALUE, engine);
            if (indx < 0) {
                indx = assignedAST.size() + indx;
            }
            if (indx < 0 || indx >= assignedAST.size()) {
                return IOFunctions.printMessage(S.Part, "partw", F.list(F.ZZ(indx), assignedAST), engine);
            }
            IASTAppendable result = F.NIL;
            IExpr temp = Programming.assignPart(assignedAST.get(indx), part, partPositionPlus1, value, engine);
            if (temp.isPresent()) {
                if (!result.isPresent()) {
                    result = assignedAST.copyAppendable();
                }
                result.set(indx, temp);
            }
            return result;
        }
        if (arg2.isList()) {
            IExpr temp = null;
            IAST list = (IAST)arg2;
            IASTAppendable result = F.ListAlloc(list.size());
            for (int i = 1; i < list.size(); ++i) {
                IExpr listArg = list.get(i);
                if (!listArg.isInteger()) continue;
                IExpr ires = null;
                int indx = Validate.throwIntType(listArg, Integer.MIN_VALUE, engine);
                ires = Programming.assignPartValue(assignedAST, indx, value);
                if (ires == null) {
                    return F.NIL;
                }
                if (partPositionPlus1 < part.size()) {
                    if (ires.isASTOrAssociation()) {
                        temp = Programming.assignPart(ires, part, partPositionPlus1, value, engine);
                        result.append(temp);
                        continue;
                    }
                    return IOFunctions.printMessage(S.Part, "partw", F.list(F.ZZ(partPosition), assignedAST), engine);
                }
                result.append(ires);
            }
            return result;
        }
        return IOFunctions.printMessage(S.Part, "partw", F.list(arg2, assignedAST), engine);
    }

    private static IExpr assignPart(IExpr assignedExpr, IAST part, int partPosition, IAST rhs, int rhsPos, EvalEngine engine) {
        if (!assignedExpr.isASTOrAssociation() || partPosition >= part.size()) {
            return assignedExpr;
        }
        IAST assignedAST = (IAST)assignedExpr;
        IExpr arg2 = part.get(partPosition);
        int partPositionPlus1 = partPosition + 1;
        int[] span = arg2.isSpan(assignedAST.size());
        if (span != null) {
            int start = span[0];
            int last = span[1];
            int step = span[2];
            IASTAppendable result = F.NIL;
            if (step < 0 && start >= last) {
                int rhsIndx = 1;
                for (int i = start; i >= last; i += step) {
                    IExpr temp;
                    if (!(temp = !(temp = rhs.get(rhsIndx++)).isList() ? Programming.assignPart(assignedAST.get(i), part, partPositionPlus1, temp, engine) : Programming.assignPart(assignedAST.get(i), part, partPositionPlus1, (IAST)temp, 1, engine)).isPresent()) continue;
                    if (!result.isPresent()) {
                        result = assignedAST.copyAppendable();
                    }
                    result.set(i, temp);
                }
            } else if (step > 0 && (last != 1 || start <= last)) {
                int rhsIndx = 1;
                for (int i = start; i <= last; i += step) {
                    IExpr temp;
                    if (!(temp = !(temp = rhs.get(rhsIndx++)).isList() ? Programming.assignPart(assignedAST.get(i), part, partPositionPlus1, temp, engine) : Programming.assignPart(assignedAST.get(i), part, partPositionPlus1, (IAST)temp, 1, engine)).isPresent()) continue;
                    if (!result.isPresent()) {
                        result = assignedAST.copyAppendable();
                    }
                    result.set(i, temp);
                }
            } else {
                return IOFunctions.printMessage(S.Part, "partw", F.list(arg2, assignedAST), engine);
            }
            return result;
        }
        if (arg2.isReal()) {
            int indx = Validate.checkIntType(part, partPosition, Integer.MIN_VALUE);
            IExpr ires = null;
            ires = Programming.assignPartValue(assignedAST, indx, rhs);
            if (partPositionPlus1 < part.size()) {
                if (ires.isASTOrAssociation()) {
                    return Programming.assignPart(ires, part, partPositionPlus1, rhs, rhsPos++, engine);
                }
                return IOFunctions.printMessage(S.Part, "partw", F.list(F.ZZ(partPosition), assignedAST), engine);
            }
            return ires;
        }
        if (arg2.isList()) {
            IExpr temp = null;
            IAST list = (IAST)arg2;
            IASTAppendable result = F.ListAlloc(list.size());
            for (int i = 1; i < list.size(); ++i) {
                IExpr listArg = list.get(i);
                if (!listArg.isInteger()) continue;
                IExpr ires = null;
                int indx = Validate.throwIntType(listArg, Integer.MIN_VALUE, engine);
                ires = Programming.assignPartValue(assignedAST, indx, list);
                if (ires == null) {
                    return F.NIL;
                }
                if (partPositionPlus1 < part.size()) {
                    if (ires.isASTOrAssociation()) {
                        temp = Programming.assignPart(ires, part, partPositionPlus1, rhs, rhsPos++, engine);
                        result.append(temp);
                        continue;
                    }
                    return IOFunctions.printMessage(S.Part, "partw", F.list(F.ZZ(partPosition), assignedAST), engine);
                }
                result.append(ires);
            }
            return result;
        }
        return IOFunctions.printMessage(S.Part, "partw", F.list(arg2, assignedAST), engine);
    }

    private static IExpr assignPartValue(IAST lhs, int partPosition, IExpr value) {
        if (partPosition < 0) {
            partPosition = lhs.size() + partPosition;
        }
        if (partPosition < 0 || partPosition >= lhs.size()) {
            throw new ArgumentTypeException("Part: index " + partPosition + " of " + lhs.toString() + " is out of bounds.");
        }
        return lhs.setAtCopy(partPosition, value);
    }

    private static IASTAppendable assignPartSpanValue(IAST expr, IExpr element, IAST part, int partPosition, IASTAppendable result, int position, IExpr value, EvalEngine engine) {
        IExpr resultValue = Programming.assignPart(element, part, partPosition, value, engine);
        if (resultValue.isPresent()) {
            if (!result.isPresent()) {
                result = expr.copyAppendable();
            }
            result.set(position, resultValue);
        }
        return result;
    }

    public static void initialize() {
        Initializer.init();
    }

    private Programming() {
    }

    private static final class With
    extends AbstractCoreFunctionEvaluator {
        private With() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr lastArg;
            IExpr temp;
            IAST moduleVariablesList = Validate.checkLocalVariableList(ast, 1, engine);
            if (moduleVariablesList.isPresent() && (temp = Programming.withSubstVariables(moduleVariablesList, lastArg = ast.argSize() > 2 ? ast.rest() : ast.arg2(), engine)).isPresent()) {
                return engine.evaluate(temp);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class While
    extends AbstractCoreFunctionEvaluator {
        private While() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr test = ast.arg1();
            IExpr body = ast.isAST2() ? ast.arg2() : F.NIL;
            long iterationCounter = 0L;
            while (engine.evalTrue(test)) {
                try {
                    if (body.isPresent()) {
                        engine.evaluate(body);
                    }
                    if (Config.MAX_LOOP_COUNT > ++iterationCounter) continue;
                    IterationLimitExceeded.throwIt(iterationCounter, ast);
                }
                catch (BreakException e) {
                    return S.Null;
                }
                catch (ContinueException e) {
                }
                catch (ReturnException e) {
                    return e.getValue();
                }
            }
            return S.Null;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Which
    extends AbstractCoreFunctionEvaluator {
        private Which() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if ((ast.argSize() & 1) == 1) {
                LOGGER.log(engine.getLogLevel(), "Which: number of arguments must be even");
                return F.NIL;
            }
            for (int i = 1; i < ast.size(); i += 2) {
                IExpr temp = engine.evaluate(ast.get(i));
                if (temp.isFalse()) continue;
                if (temp.isTrue()) {
                    if (i + 1 >= ast.size()) continue;
                    return engine.evaluate(ast.get(i + 1));
                }
                if (i == 1) {
                    return F.NIL;
                }
                return F.ast(ast, ast.head(), true, i, ast.size());
            }
            return S.Null;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class Unevaluated
    extends AbstractCoreFunctionEvaluator {
        private Unevaluated() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return ast.arg1();
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262624);
        }
    }

    private static class TraceForm
    extends AbstractCoreFunctionEvaluator {
        private TraceForm() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head() == S.TraceForm) {
                try {
                    IASTMutable trace = ast.copy();
                    trace.set(0, S.Trace);
                    IExpr temp = engine.evaluate(trace);
                    StringBuilder jsControl = new StringBuilder();
                    TraceForm.createTree(jsControl, temp);
                    return F.JSFormData(jsControl.toString(), "traceform");
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("TraceForm.evaluate() failed", (Throwable)rex);
                }
            }
            return F.NIL;
        }

        private static IExpr createTree(StringBuilder jsControl, IExpr traceExpr) {
            if (traceExpr.isList()) {
                IExpr l = F.NIL;
                IAST list = (IAST)traceExpr;
                jsControl.append("<ul>");
                for (int i = 1; i < list.size(); ++i) {
                    String html;
                    IExpr arg = list.get(i);
                    if (arg.isAST(S.HoldForm, 2)) {
                        jsControl.append("<li>\n");
                        html = StringEscapeUtils.escapeHtml4((String)arg.first().toString());
                        jsControl.append(html);
                        jsControl.append("</li>\n");
                        continue;
                    }
                    if (arg.isList()) {
                        IExpr last = arg.last();
                        if (last.isAST(S.HoldForm, 2)) {
                            jsControl.append("<li>\n");
                            l = last.first();
                            String html2 = StringEscapeUtils.escapeHtml4((String)l.toString());
                            jsControl.append(html2);
                            TraceForm.createTree(jsControl, arg);
                            jsControl.append("</li>\n");
                            continue;
                        }
                        jsControl.append("<li>{\n");
                        TraceForm.createTree(jsControl, arg);
                        jsControl.append("}</li>\n");
                        continue;
                    }
                    jsControl.append("<li>\n");
                    html = StringEscapeUtils.escapeHtml4((String)arg.toString());
                    jsControl.append(html);
                    jsControl.append("</li>\n");
                }
                jsControl.append("</ul>");
                return l;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class Trace
    extends AbstractCoreFunctionEvaluator {
        private Trace() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IExpr temp = ast.arg1();
                IPatternMatcher matcher = null;
                if (ast.isAST2()) {
                    matcher = engine.evalPatternMatcher(ast.arg2());
                }
                return engine.evalTrace(temp, matcher);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("Trace.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Throw
    extends AbstractCoreFunctionEvaluator {
        private Throw() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast == F.CThrowFalse) {
                throw ThrowException.THROW_FALSE;
            }
            if (ast == F.CThrowTrue) {
                throw ThrowException.THROW_TRUE;
            }
            if (ast.isAST1()) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isFalse()) {
                    throw ThrowException.THROW_FALSE;
                }
                if (arg1.isTrue()) {
                    throw ThrowException.THROW_TRUE;
                }
                throw new ThrowException(arg1);
            }
            if (ast.isAST2()) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                throw new ThrowException(arg1, ast.arg2());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class Timing
    extends AbsoluteTiming {
        private Timing() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            if (bean.isCurrentThreadCpuTimeSupported()) {
                long begin = bean.getCurrentThreadCpuTime();
                IExpr result = engine.evaluate(ast.arg1());
                long end = bean.getCurrentThreadCpuTime();
                double value = (double)(end - begin) / 1.0E9;
                return F.list(F.num(value), F.HoldForm(result));
            }
            return super.evaluate(ast, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class TimeRemaining
    extends AbstractCoreFunctionEvaluator {
        private TimeRemaining() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            double timeRemaining = engine.getRemainingSeconds();
            if (timeRemaining < 0.0) {
                return F.CInfinity;
            }
            return F.num(timeRemaining);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_0;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class TimeConstrained
    extends AbstractCoreFunctionEvaluator {
        private TimeConstrained() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            long s = engine.getSeconds();
            if (s > 0L || Config.TIMECONSTRAINED_NO_THREAD) {
                if (ast.isAST3()) {
                    return ast.arg3();
                }
                return engine.evaluate(ast.arg1());
            }
            IExpr arg2 = engine.evaluate(ast.arg2());
            long seconds = 0L;
            try {
                if (!arg2.isReal()) {
                    return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(F.C2, ast), engine);
                }
                arg2 = ((ISignedNumber)arg2).ceilFraction();
                seconds = ((ISignedNumber)arg2).toLong();
            }
            catch (ArithmeticException ae) {
                return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(F.C2, ast), engine);
            }
            ExecutorService executor = Executors.newSingleThreadExecutor();
            SimpleTimeLimiter timeLimiter = SimpleTimeLimiter.create((ExecutorService)executor);
            EvalControlledCallable work = new EvalControlledCallable(engine);
            try {
                seconds = seconds > 1L ? seconds - 1L : seconds;
                work.setExpr(ast.arg1(), seconds);
                IExpr iExpr = (IExpr)timeLimiter.callWithTimeout((Callable)work, seconds, TimeUnit.SECONDS);
                return iExpr;
            }
            catch (UncheckedTimeoutException | java.util.concurrent.TimeoutException | TimeoutException e) {
                LOGGER.debug("TimeConstrained.evaluate() timed out: {}", (Object)ast.arg1(), e);
                if (ast.isAST3()) {
                    IExpr iExpr = ast.arg3();
                    return iExpr;
                }
                IBuiltInSymbol iBuiltInSymbol = S.$Aborted;
                return iBuiltInSymbol;
            }
            catch (Exception e) {
                LOGGER.debug("TimeConstrained.evaluate() failed: {}", (Object)ast.arg1(), (Object)e);
                if (ast.isAST3()) {
                    IExpr iExpr = ast.arg3();
                    return iExpr;
                }
                IBuiltInSymbol iBuiltInSymbol = S.Null;
                return iBuiltInSymbol;
            }
            finally {
                work.cancel();
                executor.shutdown();
                try {
                    if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                        executor.shutdownNow();
                        if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                            LOGGER.log(engine.getLogLevel(), "TimeConstrained: pool did not terminate");
                        }
                    }
                }
                catch (InterruptedException ie) {
                    executor.shutdownNow();
                }
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }

        static class EvalControlledCallable
        implements Callable<IExpr> {
            private final EvalEngine fEngine;
            private IExpr fExpr;
            private long fSeconds;

            public EvalControlledCallable(EvalEngine engine) {
                this.fEngine = engine.copy();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IExpr call() throws Exception {
                EvalEngine.set(this.fEngine);
                try {
                    long timeConstrainedMillis = System.currentTimeMillis() + this.fSeconds * 1000L;
                    this.fEngine.setTimeConstrainedMillis(timeConstrainedMillis);
                    IExpr iExpr = this.fEngine.evaluate(this.fExpr);
                    return iExpr;
                }
                catch (TimeoutException e) {
                    IBuiltInSymbol iBuiltInSymbol = S.$Aborted;
                    return iBuiltInSymbol;
                }
                catch (ASTElementLimitExceeded | RecursionLimitExceeded re) {
                    throw re;
                }
                catch (Exception | OutOfMemoryError | StackOverflowError e) {
                    LOGGER.log(this.fEngine.getLogLevel(), "TimeConstrained", e);
                }
                finally {
                    this.fEngine.setTimeConstrainedMillis(-1L);
                    EvalEngine.remove();
                }
                return S.$Aborted;
            }

            public void cancel() {
                this.fEngine.stopRequest();
            }

            public void setExpr(IExpr fExpr, long seconds) {
                this.fExpr = fExpr;
                this.fSeconds = seconds;
            }
        }
    }

    private static final class Switch
    extends AbstractCoreFunctionEvaluator {
        private Switch() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if ((ast.size() & 1) != 0) {
                LOGGER.log(engine.getLogLevel(), "Switch: number of arguments must be odd");
                return F.NIL;
            }
            if (ast.size() > 3) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                for (int i = 2; i < ast.size(); i += 2) {
                    IPatternMatcher matcher = engine.evalPatternMatcher(ast.get(i));
                    if (!matcher.test(arg1, engine) || i + 1 >= ast.size()) continue;
                    return engine.evaluate(ast.get(i + 1));
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class StackBegin
    extends AbstractCoreFunctionEvaluator {
        private StackBegin() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            Deque<IExpr> stack = engine.getStack();
            try {
                engine.stackBegin();
                IExpr iExpr = engine.evaluate(ast.arg1());
                return iExpr;
            }
            finally {
                engine.setStack(stack);
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Stack
    extends AbstractCoreFunctionEvaluator {
        private Stack() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            Deque<IExpr> stack = engine.getStack();
            java.util.Iterator<IExpr> iter = stack.descendingIterator();
            IASTAppendable result = F.ListAlloc(stack.size());
            if (ast.isAST1()) {
                IExpr arg1 = ast.arg1();
                if (arg1.isBlank()) {
                    while (iter.hasNext()) {
                        IExpr expr = iter.next();
                        if (expr == ast) continue;
                        result.append(F.HoldForm(expr));
                    }
                } else {
                    IPatternMatcher matcher = engine.evalPatternMatcher(arg1);
                    while (iter.hasNext()) {
                        IExpr expr = iter.next();
                        if (expr == ast || !matcher.test(expr, engine)) continue;
                        result.append(F.HoldForm(expr));
                    }
                }
            } else {
                while (iter.hasNext()) {
                    IExpr expr = iter.next();
                    if (expr == ast) continue;
                    result.append(F.HoldForm(expr.head()));
                }
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Sow
    extends AbstractCoreFunctionEvaluator {
        private Sow() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            List<IExpr> reapList = engine.getReapList();
            if (reapList != null) {
                if (ast.isAST1()) {
                    IExpr arg1 = engine.evaluate(ast.arg1());
                    Sow.appendReapList(arg1, S.None, reapList);
                    return arg1;
                }
                if (ast.isAST2()) {
                    IExpr arg1 = engine.evaluate(ast.arg1());
                    IExpr tags = engine.evaluate(ast.arg2());
                    if (tags.isList()) {
                        ((IAST)tags).forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> Sow.appendReapList(arg1, x, reapList)));
                    } else {
                        Sow.appendReapList(arg1, tags, reapList);
                        return arg1;
                    }
                }
            }
            return F.NIL;
        }

        private static void appendReapList(IExpr expr, IExpr tag, List<IExpr> reapList) {
            for (int i = 0; i < reapList.size(); i += 2) {
                IExpr currentTag = reapList.get(i);
                if (!tag.equals(currentTag)) continue;
                IASTAppendable temp = (IASTAppendable)reapList.get(i + 1);
                temp.append(expr);
                return;
            }
            IASTAppendable temp = F.ListAlloc(10);
            temp.append(expr);
            reapList.add(tag);
            reapList.add(temp);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Return
    extends AbstractCoreFunctionEvaluator {
        private Return() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast == F.CReturnFalse) {
                throw ReturnException.RETURN_FALSE;
            }
            if (ast == F.CReturnTrue) {
                throw ReturnException.RETURN_TRUE;
            }
            if (ast.isAST1()) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isFalse()) {
                    throw ReturnException.RETURN_FALSE;
                }
                if (arg1.isTrue()) {
                    throw ReturnException.RETURN_TRUE;
                }
                throw new ReturnException(arg1);
            }
            throw new ReturnException();
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class RepeatedTiming
    extends AbstractCoreFunctionEvaluator {
        private RepeatedTiming() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                int n = 10;
                IExpr result = F.Null;
                double[] r = new double[n];
                for (int i = 0; i < n; ++i) {
                    long begin = System.currentTimeMillis();
                    result = engine.evaluate(ast.arg1());
                    r[i] = (double)(System.currentTimeMillis() - begin) / 1000.0;
                }
                DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics(r);
                return F.list(F.num(descriptiveStatistics.getMean()), F.HoldForm(result));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262240);
        }
    }

    private static final class Reap
    extends AbstractCoreFunctionEvaluator {
        private Reap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            List<IExpr> oldList = engine.getReapList();
            try {
                ArrayList<IExpr> reapList = new ArrayList<IExpr>();
                engine.setReapList(reapList);
                if (ast.isAST1()) {
                    IExpr expr = engine.evaluate(ast.arg1());
                    if (reapList.isEmpty()) {
                        IAST iAST = F.list(expr, F.CEmptyList);
                        return iAST;
                    }
                    IASTAppendable result = F.ListAlloc(reapList.size() / 2);
                    for (int i = 1; i < reapList.size(); i += 2) {
                        result.append((IExpr)reapList.get(i));
                    }
                    IAST i = F.list(expr, result);
                    return i;
                }
                if (ast.isAST2() || ast.isAST3()) {
                    int i;
                    IPatternMatcher[] matcher;
                    IAST matcherAST;
                    IExpr expr = engine.evaluate(ast.arg1());
                    IExpr arg2 = ast.arg2();
                    IExpr head = null;
                    if (ast.isAST3()) {
                        head = engine.evaluate(ast.arg3());
                    }
                    if (arg2.isList()) {
                        matcherAST = (IAST)arg2;
                        matcher = new IPatternMatcher[matcherAST.size() - 1];
                        for (i = 1; i < matcherAST.size(); ++i) {
                            matcher[i - 1] = engine.evalPatternMatcher(matcherAST.get(i));
                        }
                    } else {
                        matcher = new IPatternMatcher[]{engine.evalPatternMatcher(arg2)};
                    }
                    if (reapList.isEmpty()) {
                        matcherAST = F.list(expr, F.CEmptyList);
                        return matcherAST;
                    }
                    IASTAppendable result = F.ListAlloc(reapList.size() / 2);
                    block8: for (i = 1; i < reapList.size(); i += 2) {
                        for (int j = 0; j < matcher.length; ++j) {
                            if (!matcher[j].test((IExpr)reapList.get(i - 1))) continue;
                            if (head == null) {
                                result.append((IExpr)reapList.get(i));
                                continue block8;
                            }
                            result.append(F.binaryAST2(head, (IExpr)reapList.get(i - 1), (IExpr)reapList.get(i)));
                            continue block8;
                        }
                    }
                    IAST iAST = F.list(expr, result);
                    return iAST;
                }
            }
            finally {
                engine.setReapList(oldList);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(32);
        }
    }

    private static class Quiet
    extends AbstractCoreFunctionEvaluator {
        private Quiet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            boolean oldQuietMode = engine.isQuietMode();
            try {
                engine.setQuietMode(true);
                IExpr iExpr = engine.evaluate(ast.arg1());
                return iExpr;
            }
            finally {
                engine.setQuietMode(oldQuietMode);
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Pause
    extends AbstractFunctionEvaluator {
        private Pause() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int pause = ast.arg1().toIntDefault();
            if (pause > 0) {
                try {
                    TimeUnit.SECONDS.sleep(pause);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return S.Null;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class Part
    extends AbstractFunctionEvaluator
    implements ISetEvaluator {
        private Part() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                return ast.arg1();
            }
            if (ast.size() >= 3) {
                if (ast.isEvalFlagOn(262144)) {
                    return F.NIL;
                }
                IASTMutable evaledAST = F.NIL;
                IExpr arg1 = engine.evaluateNIL(ast.arg1());
                if (arg1.isPresent()) {
                    evaledAST = ast.setAtCopy(1, arg1);
                    if (!arg1.isASTOrAssociation()) {
                        if (arg1.isSparseArray()) {
                            return this.sparseEvaluate(evaledAST, (ISparseArray)arg1, engine).orElse(evaledAST);
                        }
                        if (ast.size() == 3 && ast.arg2().isZero()) {
                            return arg1.head();
                        }
                        IOFunctions.printMessage(S.Part, "partd", F.list(evaledAST), engine);
                        return evaledAST;
                    }
                } else {
                    arg1 = ast.arg1();
                    if (!arg1.isASTOrAssociation()) {
                        if (arg1.isSparseArray()) {
                            return this.sparseEvaluate(ast, (ISparseArray)arg1, engine);
                        }
                        if (ast.size() == 3 && ast.arg2().isZero()) {
                            return arg1.head();
                        }
                        return IOFunctions.printMessage(S.Part, "partd", F.list(ast), engine);
                    }
                }
                IAST arg1AST = (IAST)arg1;
                int astSize = ast.size();
                for (int i = 2; i < astSize; ++i) {
                    IExpr temp = engine.evaluateNIL(ast.get(i));
                    if (!temp.isPresent()) continue;
                    if (evaledAST.isPresent()) {
                        evaledAST.set(i, temp);
                        continue;
                    }
                    evaledAST = ast.setAtCopy(i, temp);
                    evaledAST.addEvalFlags(ast.getEvalFlags() & 0x60);
                }
                if (evaledAST.isPresent()) {
                    return Programming.part(arg1AST, evaledAST, 2, engine);
                }
                return Programming.part(arg1AST, ast, 2, engine);
            }
            return F.NIL;
        }

        public IExpr sparseEvaluate(IAST ast, ISparseArray arg1, EvalEngine engine) {
            ast.addEvalFlags(262144);
            if (ast.size() >= 3) {
                IASTMutable evaledAST = F.NIL;
                int astSize = ast.size();
                for (int i = 2; i < astSize; ++i) {
                    IExpr temp = engine.evaluateNIL(ast.get(i));
                    if (!temp.isPresent()) continue;
                    if (evaledAST.isPresent()) {
                        evaledAST.set(i, temp);
                        continue;
                    }
                    evaledAST = ast.setAtCopy(i, temp);
                    evaledAST.addEvalFlags(ast.getEvalFlags() & 0x60);
                }
                if (evaledAST.isPresent()) {
                    return Programming.sparsePart(arg1, evaledAST, 2, engine);
                }
                return Programming.sparsePart(arg1, ast, 2, engine);
            }
            return F.NIL;
        }

        @Override
        public IExpr evaluateSet(IExpr leftHandSide, IExpr rightHandSide, IBuiltInSymbol builtinSymbol, EvalEngine engine) {
            if (leftHandSide.size() > 1) {
                IAST part = (IAST)leftHandSide;
                if (part.arg1().isSymbol()) {
                    ISymbol symbol = (ISymbol)part.arg1();
                    IExpr temp = symbol.assignedValue();
                    if (temp == null) {
                        return IOFunctions.printMessage(builtinSymbol, "rvalue", F.list(symbol), engine);
                    }
                    if (symbol.isProtected()) {
                        return IOFunctions.printMessage(builtinSymbol, "write", F.list(symbol), EvalEngine.get());
                    }
                    try {
                        if (rightHandSide.isList()) {
                            IExpr res = Programming.assignPart(temp, part, 2, (IAST)rightHandSide, 1, engine);
                            if (res.isPresent()) {
                                symbol.assignValue(res, false);
                            }
                            return rightHandSide;
                        }
                        IExpr res = Programming.assignPart(temp, part, 2, rightHandSide, engine);
                        if (res.isPresent()) {
                            symbol.assignValue(res, false);
                        }
                        return rightHandSide;
                    }
                    catch (SymjaMathException sme) {
                        LOGGER.log(engine.getLogLevel(), (Object)builtinSymbol, (Throwable)((Object)sme));
                        return F.NIL;
                    }
                }
                IOFunctions.printMessage(builtinSymbol, "setps", F.list(part), engine);
                return rightHandSide;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(16384);
        }
    }

    private static final class On
    extends AbstractCoreFunctionEvaluator {
        private On() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                engine.setOnOffMode(true, null, false);
                return S.Null;
            }
            IExpr arg1 = ast.first();
            if (ast.isAST2() && ast.second().equals(S.Unique)) {
                IdentityHashMap<ISymbol, ISymbol> map = null;
                this.enableOnOffTrace(arg1, map, engine);
                engine.setOnOffMode(true, map, true);
                return S.Null;
            }
            IdentityHashMap map = null;
            ast.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> this.enableOnOffTrace((IExpr)x, map, engine)));
            engine.setOnOffMode(true, map, false);
            return F.NIL;
        }

        private void enableOnOffTrace(IExpr arg1, IdentityHashMap<ISymbol, ISymbol> map, EvalEngine engine) {
            if (!arg1.equals(S.All)) {
                IAST list = F.list(arg1);
                if (arg1.isList()) {
                    list = (IAST)arg1;
                }
                map = new IdentityHashMap();
                for (int i = 1; i < list.size(); ++i) {
                    if (list.get(i).isSymbol()) {
                        map.put((ISymbol)list.get(i), S.Null);
                        continue;
                    }
                    map.put(list.get(i).topHead(), S.Null);
                }
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Off
    extends AbstractCoreFunctionEvaluator {
        private Off() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                engine.setOnOffMode(false, null, false);
                return S.Null;
            }
            if (ast.isAST1()) {
                LOGGER.log(engine.getLogLevel(), "Off: {} - disabling messages currently not supported", (Object)ast);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class NestWhileList
    extends AbstractCoreFunctionEvaluator {
        private NestWhileList() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr n = F.C1;
            if (ast.argSize() == 4) {
                n = ast.arg4();
            }
            return NestWhileList.nestList(ast.arg2(), engine.evaluate(ast.arg3()), n, x -> F.unaryAST1(arg1, x), F.ListAlloc(15), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_4;
        }

        public static IAST nestList(IExpr expr, IExpr test, IExpr n, Function<IExpr, IExpr> fn, IASTAppendable resultList, EvalEngine engine) {
            if (n == S.All) {
                IExpr temp = expr;
                IASTAppendable testFunction = F.ast(test);
                testFunction.append(temp);
                while (engine.evalTrue(testFunction)) {
                    resultList.append(temp);
                    temp = engine.evaluate(fn.apply(temp));
                    testFunction.append(temp);
                }
                resultList.append(temp);
                return resultList;
            }
            int extraTimes = n.toIntDefault();
            if (extraTimes <= 0) {
                return F.NIL;
            }
            if (Config.MAX_AST_SIZE < extraTimes) {
                return IOFunctions.printMessage(S.NestWhileList, "zzmaxast", F.List(extraTimes), engine);
            }
            IExpr temp = expr;
            IExpr[] args = new IExpr[extraTimes];
            args[0] = temp;
            for (int i = 1; i < extraTimes; ++i) {
                args[i] = temp = engine.evaluate(fn.apply(temp));
            }
            while (engine.evalTrue(F.ast(args, test))) {
                resultList.append(temp);
                temp = engine.evaluate(fn.apply(temp));
                IExpr[] argsTemp = new IExpr[extraTimes];
                System.arraycopy(args, 1, argsTemp, 0, extraTimes - 1);
                argsTemp[extraTimes - 1] = temp;
                args = argsTemp;
            }
            resultList.append(temp);
            return resultList;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class NestWhile
    extends NestWhileList {
        private NestWhile() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = F.C1;
            if (ast.argSize() == 4) {
                n = ast.arg4();
            }
            return NestWhile.nestWhile(ast.arg2(), engine.evaluate(ast.arg3()), x -> F.unaryAST1(ast.arg1(), x), n, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_4;
        }

        public static IExpr nestWhile(IExpr expr, IExpr test, Function<IExpr, IExpr> fn, IExpr n, EvalEngine engine) {
            if (n == S.All) {
                IExpr temp = expr;
                IASTAppendable testFunction = F.ast(test);
                testFunction.append(temp);
                while (engine.evalTrue(testFunction)) {
                    temp = engine.evaluate(fn.apply(temp));
                    testFunction.append(temp);
                }
                return temp;
            }
            int extraTimes = n.toIntDefault();
            if (extraTimes <= 0) {
                return F.NIL;
            }
            IExpr temp = expr;
            if (Config.MAX_AST_SIZE < extraTimes) {
                return IOFunctions.printMessage(S.NestWhile, "zzmaxast", F.List(extraTimes), engine);
            }
            IExpr[] args = new IExpr[extraTimes];
            args[0] = temp;
            for (int i = 1; i < extraTimes; ++i) {
                args[i] = temp = engine.evaluate(fn.apply(temp));
            }
            while (engine.evalTrue(F.ast(args, test))) {
                temp = engine.evaluate(fn.apply(temp));
                IExpr[] argsTemp = new IExpr[extraTimes];
                System.arraycopy(args, 1, argsTemp, 0, extraTimes - 1);
                argsTemp[extraTimes - 1] = temp;
                args = argsTemp;
            }
            return temp;
        }
    }

    private static final class NestList
    extends AbstractCoreFunctionEvaluator {
        private NestList() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg3 = engine.evaluate(ast.arg3());
            if (arg3.isInteger()) {
                int n = arg3.toIntDefault();
                if (n < 0) {
                    return IOFunctions.printMessage(S.Nest, "intpm", F.list(ast, F.C3), engine);
                }
                int iterationLimit = engine.getIterationLimit();
                if (iterationLimit >= 0 && iterationLimit <= n) {
                    IterationLimitExceeded.throwIt(n, ast);
                }
                IExpr arg1 = engine.evaluate(ast.arg1());
                IExpr arg2 = engine.evaluate(ast.arg2());
                return NestList.nestList(arg2, n, x -> F.unaryAST1(arg1, x), S.List, engine);
            }
            return F.NIL;
        }

        public static IAST nestList(IExpr expr, int n, Function<IExpr, IExpr> fn, IExpr resultHead, EvalEngine engine) {
            IASTAppendable resultList = F.ast(resultHead, n + 1);
            IExpr temp = expr;
            resultList.append(temp);
            for (int i = 0; i < n; ++i) {
                temp = fn.apply(temp);
                resultList.append(temp);
            }
            return resultList;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Nest
    extends AbstractCoreFunctionEvaluator {
        private Nest() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg3 = engine.evaluate(ast.arg3());
            if (arg3.isInteger()) {
                int n = arg3.toIntDefault();
                if (n < 0) {
                    return IOFunctions.printMessage(S.Nest, "intpm", F.list(ast, F.C3), engine);
                }
                int iterationLimit = engine.getIterationLimit();
                if (iterationLimit >= 0 && iterationLimit <= n) {
                    IterationLimitExceeded.throwIt(n, ast);
                }
                return ast.arg2().nest(ast.arg1(), n);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Module
    extends AbstractCoreFunctionEvaluator {
        private Module() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr temp;
            IAST moduleVariablesList = Validate.checkLocalVariableList(ast, 1, engine);
            if (moduleVariablesList.isPresent() && (temp = Programming.moduleSubstVariables(moduleVariablesList, ast.arg2(), engine)).isPresent()) {
                return engine.evaluate(temp);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class MemoryInUse
    extends AbstractCoreFunctionEvaluator {
        private MemoryInUse() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                long freeMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                return F.ZZ(freeMemory);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }
    }

    private static class MemoryAvailable
    extends AbstractCoreFunctionEvaluator {
        private MemoryAvailable() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            long freeMemory = Runtime.getRuntime().freeMemory();
            return F.ZZ(freeMemory);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_0;
        }
    }

    private static class MaxMemoryUsed
    extends AbstractCoreFunctionEvaluator {
        private MaxMemoryUsed() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                long freeMemory = Runtime.getRuntime().totalMemory();
                return F.ZZ(freeMemory);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }
    }

    private static final class ListFunction
    extends AbstractFunctionEvaluator
    implements ISetEvaluator {
        private ListFunction() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr evaluateSet(IExpr leftHandSide, IExpr rightHandSide, IBuiltInSymbol builtinSymbol, EvalEngine engine) {
            IASTMutable temp;
            if (leftHandSide.isList() && (temp = engine.threadASTListArgs(F.Set(leftHandSide, rightHandSide), S.Thread, "tdlen")).isPresent()) {
                return engine.evaluate(temp);
            }
            return F.NIL;
        }
    }

    private static final class Interrupt
    extends AbstractCoreFunctionEvaluator {
        private Interrupt() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            throw new AbortException();
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_0;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class If
    extends AbstractCoreFunctionEvaluator {
        private If() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr temp = engine.evaluate(ast.arg1());
            if (temp.isFalse()) {
                if (ast.size() >= 4) {
                    return ast.arg3();
                }
                return S.Null;
            }
            if (temp.equals(S.True)) {
                return ast.arg2();
            }
            if (ast.size() == 5) {
                return ast.arg4();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_4;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class For
    extends AbstractCoreFunctionEvaluator {
        private For() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int iterationLimit = engine.getIterationLimit();
            int iterationCounter = 1;
            engine.evaluate(ast.arg1());
            IExpr test = ast.arg2();
            IExpr incr = ast.arg3();
            IExpr body = S.Null;
            if (ast.size() == 5) {
                body = ast.arg4();
            }
            while (true) {
                try {
                    if (!engine.evalTrue(test)) {
                        return S.Null;
                    }
                    if (ast.size() == 5) {
                        engine.evaluate(body);
                    }
                }
                catch (BreakException e) {
                    return S.Null;
                }
                catch (ContinueException e) {
                    if (iterationLimit > 0 && iterationLimit <= ++iterationCounter) {
                        IterationLimitExceeded.throwIt(iterationCounter, ast);
                    }
                }
                catch (ReturnException e) {
                    return e.getValue();
                }
                if (iterationLimit > 0 && iterationLimit <= ++iterationCounter) {
                    IterationLimitExceeded.throwIt(iterationCounter, ast);
                }
                engine.evaluate(incr);
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_4;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class FixedPointList
    extends AbstractCoreFunctionEvaluator {
        private FixedPointList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            boolean numericMode = engine.isNumericMode();
            try {
                IExpr last;
                IExpr f = ast.arg1();
                if (f.isNumber()) {
                    IAST iAST = IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C1, ast), engine);
                    return iAST;
                }
                IExpr current = ast.arg2();
                int iterations = Integer.MAX_VALUE;
                if (ast.isAST3()) {
                    iterations = ast.arg3().isInfinity() ? Integer.MAX_VALUE : (ast.arg3().isNegativeInfinity() ? Integer.MIN_VALUE : Validate.checkNonNegativeIntType(ast, 3));
                }
                if (iterations < 0) {
                    IAST iAST = IOFunctions.printMessage(ast.topHead(), "intnm", F.list(ast, F.ZZ(3)), EvalEngine.get());
                    return iAST;
                }
                if (iterations == 0) {
                    IAST iAST = F.list(ast.arg2());
                    return iAST;
                }
                IASTAppendable list = F.ListAlloc(iterations < 100 ? iterations : 32);
                list.append(current);
                int iterationLimit = engine.getIterationLimit();
                int iterationCounter = 1;
                do {
                    last = current;
                    current = engine.evaluate(F.Apply(f, F.list(current)));
                    list.append(current);
                    if (iterationLimit < 0 || iterationLimit > ++iterationCounter) continue;
                    IterationLimitExceeded.throwIt(iterationCounter, ast);
                } while (!current.isSame(last) && --iterations > 0);
                IASTAppendable iASTAppendable = list;
                return iASTAppendable;
            }
            finally {
                engine.setNumericMode(numericMode);
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }
    }

    private static final class FixedPoint
    extends AbstractCoreFunctionEvaluator {
        private FixedPoint() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            boolean numericMode = engine.isNumericMode();
            try {
                IExpr last;
                IExpr arg3;
                IExpr f = ast.arg1();
                if (f.isAtom() && !f.isSymbol()) {
                    IAST iAST = IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C1, ast), engine);
                    return iAST;
                }
                int maxIterations = Integer.MAX_VALUE;
                if (ast.isAST3()) {
                    arg3 = ast.arg3();
                    maxIterations = arg3.isInfinity() ? Integer.MAX_VALUE : (arg3.isNegativeInfinity() ? Integer.MIN_VALUE : Validate.checkNonNegativeIntType(ast, 3));
                }
                if (maxIterations < 0) {
                    arg3 = IOFunctions.printMessage(ast.topHead(), "intnm", F.list(ast, F.ZZ(3)), EvalEngine.get());
                    return arg3;
                }
                if (maxIterations == 0) {
                    arg3 = ast.arg2();
                    return arg3;
                }
                IExpr current = ast.arg2();
                int iterationLimit = engine.getIterationLimit();
                int iterationCounter = 1;
                do {
                    last = current;
                    current = engine.evaluate(F.Apply(f, F.list(current)));
                    if (iterationLimit < 0 || iterationLimit > ++iterationCounter) continue;
                    IterationLimitExceeded.throwIt(iterationCounter, ast);
                } while (!current.isSame(last) && --maxIterations > 0);
                IExpr iExpr = current;
                return iExpr;
            }
            finally {
                engine.setNumericMode(numericMode);
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }
    }

    public static class DoIterator {
        final List<? extends IIterator<IExpr>> fIterList;
        final EvalEngine fEngine;
        int fIndex;

        public DoIterator(List<? extends IIterator<IExpr>> iterList, EvalEngine engine) {
            this.fIterList = iterList;
            this.fEngine = engine;
            this.fIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IExpr doIt(IExpr input) {
            if (this.fIndex < this.fIterList.size()) {
                IIterator<IExpr> iter = this.fIterList.get(this.fIndex);
                if (!iter.setUp()) return S.Null;
                try {
                    int iterationLimit = this.fEngine.getIterationLimit();
                    int iterationCounter = 1;
                    ++this.fIndex;
                    while (iter.hasNext()) {
                        try {
                            iter.next();
                            this.doIt(input);
                            if (iterationLimit < 0 || iterationLimit > ++iterationCounter) continue;
                            IterationLimitExceeded.throwIt(iterationCounter, input);
                        }
                        catch (ReturnException e) {
                            IExpr iExpr = e.getValue();
                            --this.fIndex;
                            iter.tearDown();
                            return iExpr;
                        }
                        catch (BreakException e) {
                            IBuiltInSymbol iBuiltInSymbol = S.Null;
                            --this.fIndex;
                            iter.tearDown();
                            return iBuiltInSymbol;
                        }
                        catch (ContinueException continueException) {
                            continue;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                    return S.Null;
                                }
                            }
                        }
                    }
                }
                finally {
                    --this.fIndex;
                    iter.tearDown();
                }
            }
            this.fEngine.evaluate(input);
            return F.NIL;
        }
    }

    private static final class Do
    extends AbstractCoreFunctionEvaluator {
        private Do() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                ArrayList iterList = new ArrayList();
                ast.forEach(2, ast.size(), (x, i) -> iterList.add(Iterator.create((IAST)x, i, engine)));
                DoIterator generator = new DoIterator(iterList, engine);
                return generator.doIt(ast.arg1());
            }
            catch (ClassCastException | NoEvalException object) {
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class Defer
    extends AbstractCoreFunctionEvaluator {
        private Defer() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Continue
    extends AbstractCoreFunctionEvaluator {
        private Continue() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            throw ContinueException.CONST;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Condition
    extends AbstractCoreFunctionEvaluator {
        private Condition() {
        }

        @Override
        public final IExpr evaluate(IAST ast, EvalEngine engine) {
            if (engine.isEvalRHSMode()) {
                if (engine.evalTrue(ast.arg2())) {
                    return ast.arg1();
                }
                throw ConditionException.CONDITION_NIL;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class CompoundExpression
    extends AbstractCoreFunctionEvaluator {
        private CompoundExpression() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() > 1) {
                IExpr[] result = new IExpr[]{S.Null};
                ast.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> {
                    result[0] = engine.evaluate((IExpr)x);
                }));
                return result[0];
            }
            return S.Null;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class CheckAbort
    extends AbstractCoreFunctionEvaluator {
        private CheckAbort() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                return engine.evaluate(ast.arg1());
            }
            catch (AbortException aex) {
                return ast.arg2();
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Check
    extends AbstractCoreFunctionEvaluator {
        private Check() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            String messageShortcut = engine.getMessageShortcut();
            try {
                engine.setMessageShortcut(null);
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (engine.getMessageShortcut() != null) {
                    IExpr iExpr = ast.arg2();
                    return iExpr;
                }
                IExpr iExpr = arg1;
                return iExpr;
            }
            finally {
                engine.setMessageShortcut(messageShortcut);
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Catch
    extends AbstractCoreFunctionEvaluator {
        private Catch() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                return engine.evaluate(ast.arg1());
            }
            catch (ThrowException e) {
                int size = ast.size();
                switch (size) {
                    case 2: {
                        return e.getValue();
                    }
                    case 3: {
                        IPatternMatcher matcher = engine.evalPatternMatcher(ast.arg2());
                        IExpr tag = engine.evaluate(e.getTag());
                        if (matcher.test(tag)) {
                            return e.getValue();
                        }
                        throw e;
                    }
                    case 4: {
                        IPatternMatcher matcher = engine.evalPatternMatcher(ast.arg2());
                        IExpr tag = engine.evaluate(e.getTag());
                        if (matcher.test(tag)) {
                            IExpr head = engine.evaluate(ast.arg3());
                            return F.binaryAST2(head, e.getValue(), tag);
                        }
                        throw e;
                    }
                }
                return e.getValue();
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(32);
        }
    }

    private static final class Block
    extends AbstractCoreFunctionEvaluator {
        private Block() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST blockVariablesList = Validate.checkLocalVariableList(ast, 1, engine);
            if (blockVariablesList.isPresent()) {
                return engine.evalBlock(ast.arg2(), blockVariablesList);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Break
    extends AbstractCoreFunctionEvaluator {
        private Break() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            throw BreakException.CONST;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_0;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class AbsoluteTiming
    extends AbstractCoreFunctionEvaluator {
        private AbsoluteTiming() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 2) {
                long begin = System.currentTimeMillis();
                IExpr result = engine.evaluate(ast.arg1());
                double value = (double)(System.currentTimeMillis() - begin) / 1000.0;
                return F.list(F.num(value), F.HoldForm(result));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262240);
        }
    }

    private static final class Abort
    extends AbstractCoreFunctionEvaluator {
        private Abort() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            throw AbortException.ABORTED;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_0;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Abort.setEvaluator(new Abort());
            S.AbsoluteTiming.setEvaluator(new AbsoluteTiming());
            S.Break.setEvaluator(new Break());
            S.Block.setEvaluator(new Block());
            S.Catch.setEvaluator(new Catch());
            S.Check.setEvaluator(new Check());
            S.CheckAbort.setEvaluator(new CheckAbort());
            S.CompoundExpression.setEvaluator(new CompoundExpression());
            S.Condition.setEvaluator(new Condition());
            S.Continue.setEvaluator(new Continue());
            S.Defer.setEvaluator(new Defer());
            S.Do.setEvaluator(new Do());
            S.FixedPoint.setEvaluator(new FixedPoint());
            S.FixedPointList.setEvaluator(new FixedPointList());
            S.For.setEvaluator(new For());
            S.If.setEvaluator(new If());
            S.Interrupt.setEvaluator(new Interrupt());
            S.List.setEvaluator(new ListFunction());
            S.Module.setEvaluator(new Module());
            S.Nest.setEvaluator(new Nest());
            S.NestList.setEvaluator(new NestList());
            S.NestWhile.setEvaluator(new NestWhile());
            S.NestWhileList.setEvaluator(new NestWhileList());
            S.Part.setEvaluator(new Part());
            S.Pause.setEvaluator(new Pause());
            S.Quiet.setEvaluator(new Quiet());
            S.Reap.setEvaluator(new Reap());
            S.RepeatedTiming.setEvaluator(new RepeatedTiming());
            S.Return.setEvaluator(new Return());
            S.Sow.setEvaluator(new Sow());
            S.Stack.setEvaluator(new Stack());
            S.StackBegin.setEvaluator(new StackBegin());
            S.Switch.setEvaluator(new Switch());
            S.TimeConstrained.setEvaluator(new TimeConstrained());
            S.TimeRemaining.setEvaluator(new TimeRemaining());
            S.Timing.setEvaluator(new Timing());
            S.Throw.setEvaluator(new Throw());
            S.Unevaluated.setEvaluator(new Unevaluated());
            S.Which.setEvaluator(new Which());
            S.While.setEvaluator(new While());
            S.With.setEvaluator(new With());
            if (!Config.FUZZY_PARSER) {
                S.On.setEvaluator(new On());
                S.Off.setEvaluator(new Off());
                S.MaxMemoryUsed.setEvaluator(new MaxMemoryUsed());
                S.MemoryAvailable.setEvaluator(new MemoryAvailable());
                S.MemoryInUse.setEvaluator(new MemoryInUse());
                S.Trace.setEvaluator(new Trace());
                S.TraceForm.setEvaluator(new TraceForm());
            }
        }
    }
}

