/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldVector;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.WXFFunctions;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractCorePredicateEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPredicate;
import org.matheclipse.core.interfaces.ISparseArray;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.parser.ExprParser;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.visit.VisitorBooleanLevelSpecification;

public class PredicateQ {
    private static final Logger LOGGER = LogManager.getLogger();

    private static boolean isZeroTogether(IExpr expr, EvalEngine engine) {
        long leafCount = expr.leafCount();
        if (leafCount > 1000L) {
            return false;
        }
        if (expr.isPlusTimesPower()) {
            IExpr numerator;
            IExpr denominator;
            if (leafCount > 333L) {
                return false;
            }
            if ((expr = engine.evaluate(F.Together(expr))).isNumber()) {
                return expr.isZero();
            }
            if (expr.isTimes() && !(denominator = engine.evaluate(F.Denominator(expr))).isOne() && (numerator = engine.evaluate(F.Numerator(expr))).isAST()) {
                return PredicateQ.isPossibleZeroQ((IAST)numerator, false, engine);
            }
        }
        return false;
    }

    public static boolean isPossibleZeroQ(IAST function, boolean fastTest, EvalEngine engine) {
        try {
            IExpr temp;
            VariablesSet varSet = new VariablesSet(function);
            IASTAppendable variables = varSet.getVarList();
            if (function.leafCount() < 200L) {
                IExpr expr = F.TrigExpand.of(engine, function);
                expr = F.expandAll(expr, true, true);
                if (!(expr = engine.evaluate(expr)).isAST()) {
                    return expr.isZero();
                }
                function = (IAST)expr;
            }
            if (variables.isEmpty()) {
                INumber num;
                INumber iNumber = num = function.isNumericFunction(true) ? function.evalNumber() : null;
                return num != null && F.isZero(num.reDoubleValue(), Config.SPECIAL_FUNCTIONS_TOLERANCE) && F.isZero(num.imDoubleValue(), Config.SPECIAL_FUNCTIONS_TOLERANCE);
            }
            if (function.isNumericFunction(varSet) && function.isFreeAST(h -> PredicateQ.isSpecialNumericFunction(h))) {
                int trueCounter = 0;
                IExpr.COMPARE_TERNARY possibeZero = PredicateQ.isPossibeZeroFixedValues(F.C0, function, variables, engine);
                if (possibeZero == IExpr.COMPARE_TERNARY.FALSE) {
                    return false;
                }
                if (possibeZero == IExpr.COMPARE_TERNARY.TRUE) {
                    ++trueCounter;
                }
                if ((possibeZero = PredicateQ.isPossibeZeroFixedValues(F.C1, function, variables, engine)) == IExpr.COMPARE_TERNARY.FALSE) {
                    return false;
                }
                if (possibeZero == IExpr.COMPARE_TERNARY.TRUE) {
                    ++trueCounter;
                }
                if ((possibeZero = PredicateQ.isPossibeZeroFixedValues(F.CN1, function, variables, engine)) == IExpr.COMPARE_TERNARY.FALSE) {
                    return false;
                }
                if (possibeZero == IExpr.COMPARE_TERNARY.TRUE) {
                    ++trueCounter;
                }
                if ((possibeZero = PredicateQ.isPossibeZeroFixedValues(F.CI, function, variables, engine)) == IExpr.COMPARE_TERNARY.FALSE) {
                    return false;
                }
                if (possibeZero == IExpr.COMPARE_TERNARY.TRUE) {
                    ++trueCounter;
                }
                if ((possibeZero = PredicateQ.isPossibeZeroFixedValues(F.CNI, function, variables, engine)) == IExpr.COMPARE_TERNARY.FALSE) {
                    return false;
                }
                if (possibeZero == IExpr.COMPARE_TERNARY.TRUE) {
                    ++trueCounter;
                }
                if (trueCounter == 5) {
                    for (int i = 0; i < 36; ++i) {
                        possibeZero = PredicateQ.isPossibeZero(function, variables, engine);
                        if (possibeZero == IExpr.COMPARE_TERNARY.FALSE) {
                            return false;
                        }
                        if (possibeZero != IExpr.COMPARE_TERNARY.TRUE) continue;
                        ++trueCounter;
                    }
                    if (trueCounter > 28) {
                        return true;
                    }
                }
                if (fastTest) {
                    return false;
                }
            }
            if ((temp = function.replaceAll(x -> x.isNumericFunction(true) ? IExpr.ofNullable(x.evalNumber()) : F.NIL)).isPresent() && (temp = engine.evaluate(temp)).isZero()) {
                return true;
            }
            return PredicateQ.isZeroTogether(function, engine);
        }
        catch (ValidateException ve) {
            LOGGER.debug("PredicateQ.isPossibleZeroQ() failed", (Throwable)((Object)ve));
            return false;
        }
    }

    private static boolean isSpecialNumericFunction(IExpr head) {
        if (head.isPower()) {
            return head.exponent().isNumber();
        }
        int h = head.headID();
        return h == 73 || h == 236 || h == 304 || h == 294 || h == 303 || h == 535 || h == 583 || h == 584 || h == 611 || h == 612 || h == 614 || h == 613 || h == 616 || h == 617 || h == 618 || h == 698 || h == 699 || h == 700 || h == 701 || h == 702 || h == 705 || h == 706 || h == 707 || h == 708 || h == 709 || h == 711 || h == 731 || h == 799 || h == 1004 || h == 1059 || h == 1260 || h == 1261 || h == 1310 || h == 1426 || h == 1427 || h == 1428 || h == 1429 || h == 693;
    }

    private static IExpr.COMPARE_TERNARY isPossibeZero(IAST function, IAST variables, EvalEngine engine) {
        IASTAppendable listOfRules = F.ListAlloc(variables.size());
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        for (int i = 1; i < variables.size(); ++i) {
            double re = tlr.nextDouble(-100.0, 100.0);
            double im = tlr.nextDouble(-100.0, 100.0);
            listOfRules.append(F.Rule(variables.get(i), (IExpr)F.complexNum(re, im)));
        }
        IExpr temp = function.replaceAll(listOfRules);
        return PredicateQ.isPossibleZeroApproximate(temp, engine);
    }

    private static IExpr.COMPARE_TERNARY isPossibeZeroFixedValues(INumber number, IAST function, IAST variables, EvalEngine engine) {
        IASTAppendable listOfRules = F.ListAlloc(variables.size());
        for (int i = 1; i < variables.size(); ++i) {
            listOfRules.append(F.Rule(variables.get(i), (IExpr)number));
        }
        IExpr temp = function.replaceAll(listOfRules);
        return PredicateQ.isPossibleZeroExact(temp, engine);
    }

    private static IExpr.COMPARE_TERNARY isPossibleZeroExact(IExpr temp, EvalEngine engine) {
        try {
            if (temp.isPresent()) {
                IExpr result = engine.evalQuiet(temp);
                if (result.isNumber()) {
                    return result.isZero() ? IExpr.COMPARE_TERNARY.TRUE : IExpr.COMPARE_TERNARY.FALSE;
                }
                if (result.isDirectedInfinity()) {
                    return IExpr.COMPARE_TERNARY.FALSE;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return IExpr.COMPARE_TERNARY.UNDECIDABLE;
    }

    private static IExpr.COMPARE_TERNARY isPossibleZeroApproximate(IExpr temp, EvalEngine engine) {
        try {
            if (temp.isPresent()) {
                IExpr result = engine.evalQuiet(F.N(temp));
                if (result.isZero()) {
                    return IExpr.COMPARE_TERNARY.TRUE;
                }
                if (result.isNumber() && !result.isZero()) {
                    double realPart = ((INumber)result).reDoubleValue();
                    double imaginaryPart = ((INumber)result).imDoubleValue();
                    if (!F.isZero(realPart, Config.SPECIAL_FUNCTIONS_TOLERANCE) || !F.isZero(imaginaryPart, Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                        if (Double.isNaN(realPart) || Double.isNaN(imaginaryPart) || Double.isInfinite(realPart) || Double.isInfinite(imaginaryPart)) {
                            return IExpr.COMPARE_TERNARY.UNDECIDABLE;
                        }
                        return IExpr.COMPARE_TERNARY.FALSE;
                    }
                    return IExpr.COMPARE_TERNARY.TRUE;
                }
                if (result.isDirectedInfinity()) {
                    return IExpr.COMPARE_TERNARY.FALSE;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return IExpr.COMPARE_TERNARY.UNDECIDABLE;
    }

    public static void initialize() {
        Initializer.init();
    }

    private PredicateQ() {
    }

    private static final class VectorQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate {
        private VectorQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            int dim = arg1.isVector();
            if (dim == -1) {
                return S.False;
            }
            if (ast.isAST1()) {
                return S.True;
            }
            if (ast.isAST2()) {
                IExpr arg2 = engine.evaluate(ast.arg2());
                if (arg2.isSparseArray()) {
                    return F.NIL;
                }
                IASTAppendable temp = F.ast(arg2);
                temp.append(F.Slot1);
                if (arg1.isAST()) {
                    IAST vector = (IAST)arg1;
                    if (!vector.forAll(x -> {
                        temp.set(1, (IExpr)x);
                        return engine.evalTrue(temp);
                    })) {
                        return S.False;
                    }
                    return S.True;
                }
                FieldVector<IExpr> vector = Convert.list2Vector(arg1);
                if (vector != null) {
                    for (int i = 0; i < dim; ++i) {
                        IExpr expr = (IExpr)vector.getEntry(i);
                        temp.set(1, expr);
                        if (engine.evalTrue(temp)) continue;
                        return S.False;
                    }
                    return S.True;
                }
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class ValueQ
    extends AbstractCoreFunctionEvaluator
    implements Predicate<IExpr>,
    IPredicate {
        private ValueQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.bool(ast.arg1().isValue());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public boolean test(IExpr expr) {
            return expr.isValue();
        }
    }

    private static final class SyntaxQ
    extends AbstractCorePredicateEvaluator
    implements IPredicate {
        private SyntaxQ() {
        }

        @Override
        public boolean evalArg1Boole(IExpr arg1, EvalEngine engine) {
            return arg1.isString() ? ExprParser.test(arg1.toString(), engine) : false;
        }
    }

    private static class SymmetricMatrixQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate {
        private SymmetricMatrixQ() {
        }

        protected boolean compareElements(IExpr expr1, IExpr expr2, EvalEngine engine) {
            if (expr1.isNumber() && expr2.isNumber()) {
                return expr1.equals(expr2);
            }
            return S.Equal.ofQ(engine, expr1, expr2);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            int[] dims = arg1.isMatrix();
            if (dims == null || dims[0] != dims[1]) {
                return S.False;
            }
            if (arg1.isAST()) {
                IAST matrix = (IAST)arg1;
                for (int i = 1; i <= dims[0]; ++i) {
                    IAST row = matrix.getAST(i);
                    int j = i + 1;
                    while (j <= dims[1]) {
                        IExpr symmetricExpr;
                        IExpr expr = row.get(j);
                        if (this.compareElements(expr, symmetricExpr = matrix.getPart(j++, i), engine)) continue;
                        return S.False;
                    }
                }
                return S.True;
            }
            FieldMatrix<IExpr> matrix = Convert.list2Matrix(arg1);
            if (matrix != null) {
                for (int i = 0; i < dims[0]; ++i) {
                    for (int j = i + 1; j < dims[1]; ++j) {
                        IExpr symmetricExpr;
                        IExpr expr = (IExpr)matrix.getEntry(i, j);
                        if (this.compareElements(expr, symmetricExpr = (IExpr)matrix.getEntry(j, i), engine)) continue;
                        return S.False;
                    }
                }
                return S.True;
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class SquareMatrixQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate {
        private SquareMatrixQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            int[] dims = arg1.isMatrix();
            if (dims == null || dims[0] != dims[1]) {
                return S.False;
            }
            return S.True;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class RealNumberQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate {
        private RealNumberQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            if (arg1.isNumber()) {
                if (arg1.isComplex() || arg1.isComplexNumeric()) {
                    return S.False;
                }
                return F.bool(arg1.isReal());
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class PrimeQ
    extends AbstractCorePredicateEvaluator
    implements Predicate<IInteger>,
    IPredicate {
        private PrimeQ() {
        }

        @Override
        public boolean evalArg1Boole(IExpr arg1, EvalEngine engine) {
            if (!arg1.isInteger()) {
                return false;
            }
            return ((IInteger)arg1).isProbablePrime();
        }

        @Override
        public boolean evalArg1Boole(IExpr arg1, EvalEngine engine, OptionArgs options) {
            IExpr option = options.getOption(S.GaussianIntegers);
            if (!option.isTrue()) {
                return this.evalArg1Boole(arg1, engine);
            }
            IInteger[] reImParts = arg1.gaussianIntegers();
            if (reImParts == null) {
                return false;
            }
            if (reImParts[1].isZero()) {
                if (reImParts[0].isProbablePrime()) {
                    return reImParts[0].abs().mod(F.C4).equals(F.C3);
                }
                return false;
            }
            if (reImParts[0].isZero()) {
                if (reImParts[1].isProbablePrime()) {
                    return reImParts[1].abs().mod(F.C4).equals(F.C3);
                }
                return false;
            }
            return reImParts[0].powerRational(2L).add(reImParts[1].powerRational(2L)).isProbablePrime();
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }

        @Override
        public boolean test(IInteger obj) {
            return obj.isProbablePrime();
        }
    }

    private static final class PossibleZeroQ
    extends AbstractCorePredicateEvaluator
    implements IPredicate {
        private PossibleZeroQ() {
        }

        @Override
        public boolean evalArg1Boole(IExpr arg1, EvalEngine engine) {
            IExpr expr = arg1;
            if (expr.isNumber()) {
                return expr.isZero();
            }
            if (expr.isAST()) {
                return PredicateQ.isPossibleZeroQ((IAST)expr, false, engine);
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static final class OrthogonalMatrixQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate {
        private OrthogonalMatrixQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            int[] dims = arg1.isMatrix();
            if (dims == null) {
                return S.False;
            }
            IExpr identityMatrix = F.NIL;
            int[] identityMatrixDims = null;
            if (dims[0] >= dims[1] ? (identityMatrixDims = (identityMatrix = S.Dot.of(engine, F.Transpose(arg1), arg1)).isMatrix()) == null || identityMatrixDims[0] != dims[1] || identityMatrixDims[1] != dims[1] : (identityMatrixDims = (identityMatrix = S.Dot.of(engine, arg1, F.Transpose(arg1))).isMatrix()) == null || identityMatrixDims[0] != dims[0] || identityMatrixDims[1] != dims[0]) {
                return S.False;
            }
            if (identityMatrix.isAST()) {
                IAST matrix = (IAST)identityMatrix;
                for (int i = 1; i <= identityMatrixDims[0]; ++i) {
                    IAST row = (IAST)matrix.get(i);
                    for (int j = 1; j <= identityMatrixDims[1]; ++j) {
                        IExpr expr = row.get(j);
                        if (!(i == j ? !S.PossibleZeroQ.ofQ(engine, F.Plus((IExpr)F.CN1, expr)) : !S.PossibleZeroQ.ofQ(engine, expr))) continue;
                        return S.False;
                    }
                }
            } else {
                FieldMatrix<IExpr> matrix = Convert.list2Matrix(identityMatrix);
                if (matrix != null) {
                    for (int i = 0; i < dims[0]; ++i) {
                        for (int j = 1; j < dims[1]; ++j) {
                            IExpr expr = (IExpr)matrix.getEntry(i, j);
                            if (!(i == j ? !S.PossibleZeroQ.ofQ(engine, F.Plus((IExpr)F.CN1, expr)) : !S.PossibleZeroQ.ofQ(engine, expr))) continue;
                            return S.False;
                        }
                    }
                    return S.True;
                }
            }
            return S.True;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class QuantityQ
    extends AbstractCorePredicateEvaluator
    implements Predicate<IExpr>,
    IPredicate {
        private QuantityQ() {
        }

        @Override
        public boolean evalArg1Boole(IExpr arg1, EvalEngine engine) {
            return arg1.isQuantity();
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }

        @Override
        public boolean test(IExpr expr) {
            return expr.isQuantity();
        }
    }

    private static final class OddQ
    extends AbstractCorePredicateEvaluator
    implements Predicate<IExpr>,
    IPredicate {
        private OddQ() {
        }

        @Override
        public boolean evalArg1Boole(IExpr arg1, EvalEngine engine) {
            return arg1.isInteger() && ((IInteger)arg1).isOdd();
        }

        @Override
        public boolean evalArg1Boole(IExpr arg1, EvalEngine engine, OptionArgs options) {
            IExpr option = options.getOption(S.GaussianIntegers);
            if (!option.isTrue()) {
                return this.evalArg1Boole(arg1, engine);
            }
            IInteger[] reImParts = arg1.gaussianIntegers();
            if (reImParts == null) {
                return false;
            }
            if (reImParts[1].isZero()) {
                return reImParts[0].isOdd();
            }
            if (reImParts[0].isZero()) {
                return reImParts[1].isOdd();
            }
            if (reImParts[0].isOdd() && reImParts[1].isOdd()) {
                return false;
            }
            return reImParts[0].isOdd() || reImParts[1].isOdd();
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }

        @Override
        public boolean test(IExpr expr) {
            return expr.isInteger() && ((IInteger)expr).isOdd();
        }
    }

    private static final class NameQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate {
        private NameQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (!arg1.isString()) {
                arg1 = engine.evaluate(ast.arg1());
            }
            if (arg1.isString()) {
                return F.bool(F.hasSymbol(arg1.toString(), engine));
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class MemberQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate {
        private MemberQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            boolean heads = false;
            int size = ast.size();
            if (ast.size() > 3) {
                int pos;
                OptionArgs options = new OptionArgs(ast.topHead(), ast, 3, size, engine);
                if (options.isTrue(S.Heads)) {
                    heads = true;
                }
                if ((pos = options.getLastPosition()) != -1) {
                    size = pos;
                }
            }
            if (size >= 3) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isAST()) {
                    IExpr arg2 = engine.evaluate(ast.arg2());
                    if (size == 3) {
                        return F.bool(arg1.isMember(arg2, heads, null));
                    }
                    Predicate<IExpr> predicate = Predicates.toMemberQ(arg2);
                    VisitorBooleanLevelSpecification level = new VisitorBooleanLevelSpecification(predicate, ast.arg3(), heads, engine);
                    return F.bool(arg1.accept(level));
                }
                return S.False;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY_1;
        }
    }

    private static final class MatrixQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate {
        private MatrixQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            int[] dims = arg1.isMatrix();
            if (dims == null) {
                return S.False;
            }
            if (ast.isAST1()) {
                return S.True;
            }
            if (ast.isAST2()) {
                IExpr arg2 = engine.evaluate(ast.arg2());
                if (arg2.isSparseArray()) {
                    return F.NIL;
                }
                IASTAppendable temp = F.ast(arg2);
                temp.append(F.Slot1);
                if (arg1.isAST()) {
                    IAST matrix = (IAST)arg1;
                    for (int i = 1; i < dims[0]; ++i) {
                        if (((IAST)matrix.get(i)).forAll(x -> {
                            temp.set(1, (IExpr)x);
                            return engine.evalTrue(temp);
                        })) continue;
                        return S.False;
                    }
                    return S.True;
                }
                FieldMatrix<IExpr> matrix = Convert.list2Matrix(arg1);
                if (matrix != null) {
                    for (int i = 0; i < dims[0]; ++i) {
                        for (int j = 1; j < dims[1]; ++j) {
                            IExpr expr = (IExpr)matrix.getEntry(i, j);
                            temp.set(1, expr);
                            if (engine.evalTrue(temp)) continue;
                            return S.False;
                        }
                    }
                    return S.True;
                }
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class MatchQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate {
        private MatchQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2()) {
                IExpr arg1Evaled;
                IExpr arg1 = ast.arg1();
                IPatternMatcher matcher = engine.evalPatternMatcher(ast.arg2());
                if (matcher.test(arg1Evaled = engine.evaluate(arg1), engine)) {
                    return S.True;
                }
                if (arg1Evaled.isAST()) {
                    return F.bool(matcher.test(arg1, engine));
                }
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2_1;
        }
    }

    private static final class HermitianMatrixQ
    extends SymmetricMatrixQ {
        private HermitianMatrixQ() {
        }

        @Override
        protected boolean compareElements(IExpr expr1, IExpr expr2, EvalEngine engine) {
            if (expr1.isReal() && expr2.isReal()) {
                return expr1.equals(expr2);
            }
            if (expr1.isNumber() && expr2.isNumber()) {
                return expr1.conjugate().equals(expr2);
            }
            return S.Equal.ofQ(engine, F.Conjugate(expr1), expr2);
        }
    }

    private static final class FreeQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate {
        private FreeQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 3) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                IExpr arg2 = engine.evalPattern(ast.arg2());
                return F.bool(arg1.isFree(arg2, true));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2_1;
        }
    }

    private static final class EvenQ
    extends AbstractCorePredicateEvaluator
    implements Predicate<IExpr>,
    IPredicate {
        private EvenQ() {
        }

        @Override
        public boolean evalArg1Boole(IExpr arg1, EvalEngine engine) {
            return arg1.isEvenResult();
        }

        @Override
        public boolean evalArg1Boole(IExpr arg1, EvalEngine engine, OptionArgs options) {
            IExpr option = options.getOption(S.GaussianIntegers);
            if (!option.isTrue()) {
                return this.evalArg1Boole(arg1, engine);
            }
            IInteger[] reImParts = arg1.gaussianIntegers();
            if (reImParts == null) {
                return false;
            }
            if (reImParts[1].isZero()) {
                return reImParts[0].isEven();
            }
            if (reImParts[0].isZero()) {
                return reImParts[1].isEven();
            }
            return reImParts[0].isEven() && reImParts[1].isEven();
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }

        @Override
        public boolean test(IExpr expr) {
            return expr.isInteger() && ((IInteger)expr).isEven();
        }
    }

    private static final class DigitQ
    extends AbstractCorePredicateEvaluator
    implements Predicate<IExpr>,
    IPredicate {
        private DigitQ() {
        }

        @Override
        public boolean evalArg1Boole(IExpr arg1, EvalEngine engine) {
            if (arg1 instanceof IStringX) {
                return this.test(arg1);
            }
            return false;
        }

        @Override
        public boolean test(IExpr obj) {
            if (obj instanceof IStringX) {
                String str = obj.toString();
                for (int i = 0; i < str.length(); ++i) {
                    char ch = str.charAt(i);
                    if (ch >= '0' && ch <= '9') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class DiagonalMatrixQ
    extends AbstractFunctionEvaluator {
        private DiagonalMatrixQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            int[] dims = arg1.isMatrix();
            if (dims == null) {
                return S.False;
            }
            int diagonal = 0;
            if (ast.isAST2()) {
                int k = ast.arg2().toIntDefault();
                if (k == Integer.MIN_VALUE) {
                    return F.NIL;
                }
                diagonal = k;
            }
            IAST matrix = (IAST)arg1.normal(false);
            for (int i = 1; i <= dims[0]; ++i) {
                IAST row = matrix.getAST(i);
                for (int j = 1; j <= dims[1]; ++j) {
                    IExpr element = row.get(j);
                    if (i + diagonal == j || element.isZero()) continue;
                    return S.False;
                }
            }
            return S.True;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class ArrayQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate {
        private ArrayQ() {
        }

        private static int determineDepth(IExpr expr, int depth, Predicate<IExpr> predicate) {
            int resultDepth = depth;
            if (expr.isSparseArray()) {
                int[] dims = ((ISparseArray)expr).getDimension();
                if (dims == null) {
                    return -1;
                }
                return depth + dims.length;
            }
            if (expr.isList()) {
                IAST ast = (IAST)expr;
                int size = ast.size();
                if (size == 1) {
                    return depth;
                }
                IExpr arg1AST = ast.arg1();
                boolean isList = arg1AST.isList();
                int arg1Size = 0;
                if (isList) {
                    arg1Size = ((IAST)ast.arg1()).size();
                }
                if ((resultDepth = ArrayQ.determineDepth(arg1AST, depth + 1, predicate)) < 0) {
                    return -1;
                }
                for (int i = 2; i < size; ++i) {
                    if (isList) {
                        if (!ast.get(i).isList()) {
                            return -1;
                        }
                        if (arg1Size != ((IAST)ast.get(i)).size()) {
                            return -1;
                        }
                        int tempDepth = ArrayQ.determineDepth(ast.get(i), depth + 1, predicate);
                        if (tempDepth >= 0 && tempDepth == resultDepth) continue;
                        return -1;
                    }
                    if (ast.get(i).isList()) {
                        return -1;
                    }
                    if (predicate == null || predicate.test(ast.get(i))) continue;
                    return -1;
                }
                return resultDepth;
            }
            if (predicate != null && !predicate.test(expr)) {
                return -1;
            }
            return resultDepth;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int depth;
            IExpr arg1 = engine.evaluate(ast.arg1());
            Predicate<IExpr> test = null;
            if (ast.size() >= 4) {
                IExpr testArg3 = engine.evaluate(ast.arg3());
                test = x -> engine.evalTrue(testArg3, (IExpr)x);
            }
            if ((depth = ArrayQ.determineDepth(arg1, 0, test)) >= 0) {
                IPatternMatcher matcher;
                if (ast.size() >= 3 && !(matcher = engine.evalPatternMatcher(ast.arg2())).test(F.ZZ(depth), engine)) {
                    return S.False;
                }
                return S.True;
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }
    }

    private static final class AntisymmetricMatrixQ
    extends SymmetricMatrixQ {
        private AntisymmetricMatrixQ() {
        }

        @Override
        protected boolean compareElements(IExpr expr1, IExpr expr2, EvalEngine engine) {
            if (expr1.isNumber() && expr2.isNumber()) {
                return expr1.negate().equals(expr2);
            }
            return S.Equal.ofQ(engine, F.Times((IExpr)F.CN1, expr1), expr2);
        }
    }

    private static final class AntihermitianMatrixQ
    extends SymmetricMatrixQ {
        private AntihermitianMatrixQ() {
        }

        @Override
        protected boolean compareElements(IExpr expr1, IExpr expr2, EvalEngine engine) {
            if (expr1.isNumber() && expr2.isNumber()) {
                return expr1.conjugate().negate().equals(expr2);
            }
            return S.Equal.ofQ(engine, F.Times((IExpr)F.CN1, (IExpr)F.Conjugate(expr1)), expr2);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.AntisymmetricMatrixQ.setEvaluator(new AntisymmetricMatrixQ());
            S.AntihermitianMatrixQ.setEvaluator(new AntihermitianMatrixQ());
            S.ArrayQ.setEvaluator(new ArrayQ());
            S.AssociationQ.setPredicateQ(x -> x.isAssociation());
            S.AtomQ.setPredicateQ(x -> x.isAtom());
            S.BooleanQ.setPredicateQ(x -> x.isTrue() || x.isFalse());
            S.ByteArrayQ.setPredicateQ(WXFFunctions::isByteArray);
            S.DiagonalMatrixQ.setEvaluator(new DiagonalMatrixQ());
            S.DigitQ.setEvaluator(new DigitQ());
            S.EvenQ.setEvaluator(new EvenQ());
            S.ExactNumberQ.setPredicateQ(x -> x.isExactNumber());
            S.FreeQ.setEvaluator(new FreeQ());
            S.HermitianMatrixQ.setEvaluator(new HermitianMatrixQ());
            S.InexactNumberQ.setPredicateQ(x -> x.isInexactNumber());
            S.IntegerQ.setPredicateQ(x -> x.isInteger());
            S.ListQ.setPredicateQ(x -> x.isList());
            S.MachineNumberQ.setPredicateQ(x -> x.isMachineNumber());
            S.MatchQ.setEvaluator(new MatchQ());
            S.MatrixQ.setEvaluator(new MatrixQ());
            S.MemberQ.setEvaluator(new MemberQ());
            S.MissingQ.setPredicateQ(x -> x.isAST(S.Missing, 2));
            S.NotListQ.setPredicateQ(x -> !x.isList());
            S.NameQ.setEvaluator(new NameQ());
            S.NumberQ.setPredicateQ(x -> x.isNumber());
            S.NumericQ.setPredicateQ(x -> x.isNumericFunction());
            S.OddQ.setEvaluator(new OddQ());
            S.OrthogonalMatrixQ.setEvaluator(new OrthogonalMatrixQ());
            S.PossibleZeroQ.setEvaluator(new PossibleZeroQ());
            S.PrimeQ.setEvaluator(new PrimeQ());
            S.QuantityQ.setEvaluator(new QuantityQ());
            S.RealNumberQ.setEvaluator(new RealNumberQ());
            S.SquareMatrixQ.setEvaluator(new SquareMatrixQ());
            S.StringQ.setPredicateQ(x -> x.isString());
            S.SymbolQ.setPredicateQ(x -> x.isSymbol());
            S.SymmetricMatrixQ.setEvaluator(new SymmetricMatrixQ());
            S.SyntaxQ.setEvaluator(new SyntaxQ());
            S.ValueQ.setEvaluator(new ValueQ());
            S.VectorQ.setEvaluator(new VectorQ());
        }
    }
}

