/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import com.google.common.math.LongMath;
import edu.jas.application.GBAlgorithmBuilder;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gbufd.GroebnerBasePartial;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Algebra;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.convert.JASIExpr;
import org.matheclipse.core.convert.JASModInteger;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.exception.PolynomialDegreeLimitExceeded;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.numbertheory.Primality;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.polynomials.PolynomialsUtils;
import org.matheclipse.core.polynomials.longexponent.ExpVectorLong;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomial;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomialRing;
import org.matheclipse.core.polynomials.longexponent.ExprRingFactory;
import org.matheclipse.core.polynomials.longexponent.ExprTermOrder;
import org.matheclipse.core.polynomials.symbolicexponent.ExpVectorSymbolic;
import org.matheclipse.core.polynomials.symbolicexponent.SymbolicPolynomial;
import org.matheclipse.core.polynomials.symbolicexponent.SymbolicPolynomialRing;
import org.matheclipse.core.reflection.system.rules.LegendrePRules;
import org.matheclipse.core.reflection.system.rules.LegendreQRules;
import org.matheclipse.core.reflection.system.rules.SphericalHarmonicYRules;

public class PolynomialFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IExpr bellY(int n, int k, IAST symbols, IAST ast, EvalEngine engine) {
        int recursionLimit = engine.getRecursionLimit();
        try {
            int counter2;
            if (recursionLimit > 0 && (counter2 = engine.incRecursionCounter()) > recursionLimit) {
                RecursionLimitExceeded.throwIt(counter2, ast);
            }
            if (n == 0 && k == 0) {
                IInteger counter2 = F.C1;
                return counter2;
            }
            if (n == 0 || k == 0) {
                IInteger counter2 = F.C0;
                return counter2;
            }
            IExpr s = F.C0;
            int a = 1;
            int max = n - k + 2;
            int iterationLimit = engine.getIterationLimit();
            if (iterationLimit >= 0 && iterationLimit <= max) {
                IterationLimitExceeded.throwIt(max, ast);
            }
            for (int m = 1; m < max; ++m) {
                if (m < symbols.size() && !symbols.get(m).isZero()) {
                    IExpr bellY = PolynomialFunctions.bellY(n - m, k - 1, symbols, ast, engine);
                    bellY = bellY.isPlus() ? ((IAST)bellY).mapThread(F.Times(a, F.Slot1, symbols.get(m)), 2) : F.Times(a, bellY, symbols.get(m));
                    s = s.plus(bellY);
                }
                a = a * (n - m) / m;
            }
            IInteger iInteger = s;
            return iInteger;
        }
        finally {
            if (recursionLimit > 0) {
                engine.decRecursionCounter();
            }
        }
    }

    public static IAST coefficientList(IExpr expr, IAST listOfVariables) {
        try {
            ExprPolynomialRing ring = new ExprPolynomialRing(listOfVariables);
            ExprPolynomial poly = ring.create(expr, true, false, true);
            if (poly.isZero()) {
                return F.CEmptyList;
            }
            return poly.coefficientList();
        }
        catch (LimitException le) {
            throw le;
        }
        catch (RuntimeException ex) {
            LOGGER.debug("PolynomialFunctions.coefficientList() failed", (Throwable)ex);
            if (listOfVariables.argSize() > 0) {
                return F.Nest((IExpr)S.List, expr, listOfVariables.argSize());
            }
            return F.NIL;
        }
    }

    public static IASTAppendable solveGroebnerBasis(IAST listOfPolynomials, IAST listOfVariables) {
        ArrayList<IExpr> varList = new ArrayList<IExpr>(listOfVariables.argSize());
        for (int i = 1; i < listOfVariables.size(); ++i) {
            varList.add(listOfVariables.get(i));
        }
        ArrayList polyList = new ArrayList(listOfPolynomials.argSize());
        TermOrder termOrder = TermOrderByName.IGRLEX;
        JASConvert jas = new JASConvert((List<? extends IExpr>)((List<IExpr>)varList), BigRational.ZERO, termOrder);
        IASTAppendable rest = F.ListAlloc(8);
        for (int i = 1; i < listOfPolynomials.size(); ++i) {
            IExpr expr = F.evalExpandAll(listOfPolynomials.get(i));
            try {
                GenPolynomial poly = jas.expr2JAS(expr, false);
                polyList.add(poly);
                continue;
            }
            catch (JASConversionException e) {
                rest.append(expr);
            }
        }
        if (polyList.size() == 0) {
            return F.NIL;
        }
        GroebnerBaseAbstract engine = GBAlgorithmBuilder.polynomialRing(jas.getPolynomialRingFactory()).fractionFree().syzygyPairlist().build();
        List opl = engine.GB(polyList);
        IASTAppendable resultList = F.ListAlloc(opl.size() + rest.size());
        for (GenPolynomial p : opl) {
            resultList.append(jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)((GenPolynomial)jas.factorTerms((GenPolynomial<BigRational>)p)[2])));
        }
        resultList.appendArgs(rest);
        return resultList;
    }

    public static void initialize() {
        Initializer.init();
    }

    private PolynomialFunctions() {
    }

    private static final class MonomialList
    extends AbstractFunctionEvaluator {
        private MonomialList() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST symbolList;
            List<IExpr> varList;
            IExpr expr = F.evalExpandAll(ast.arg1(), engine);
            if (ast.isAST1()) {
                VariablesSet eVar = new VariablesSet(ast.arg1());
                varList = eVar.getArrayList();
                symbolList = eVar.getVarList();
            } else {
                symbolList = Validate.checkIsVariableOrVariableList(ast, 2, ast.topHead(), engine);
                if (!symbolList.isPresent()) {
                    return F.NIL;
                }
                varList = new ArrayList<IExpr>(symbolList.argSize());
                symbolList.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> varList.add((IExpr)x)));
            }
            TermOrder termOrder = TermOrderByName.Lexicographic;
            if (ast.size() > 3) {
                if (ast.arg3().isSymbol()) {
                    termOrder = JASIExpr.monomialOrder((ISymbol)ast.arg3(), termOrder);
                } else {
                    OptionArgs options = new OptionArgs(ast.topHead(), ast, 2, engine);
                    IExpr option = options.getOption(S.Modulus);
                    if (option.isPresent()) {
                        try {
                            if (option.isInteger()) {
                                return MonomialList.monomialListModulus(expr, varList, termOrder, option);
                            }
                        }
                        catch (RuntimeException rex) {
                            LOGGER.debug("MonomialList.evaluate() failed", (Throwable)rex);
                        }
                    }
                    return F.NIL;
                }
            }
            try {
                ExprPolynomialRing ring = new ExprPolynomialRing(symbolList, new ExprTermOrder(termOrder.getEvord()));
                ExprPolynomial poly = ring.create(expr, false, true, true);
                return poly.monomialList();
            }
            catch (RuntimeException rex) {
                LOGGER.debug("MonomialList.evaluate() failed", (Throwable)rex);
                return F.list(expr);
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4;
        }

        private static IAST monomialListModulus(IExpr polynomial, List<IExpr> variablesList, TermOrder termOrder, IExpr option) throws JASConversionException {
            try {
                ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
                JASModInteger jas = new JASModInteger(variablesList, modIntegerRing);
                GenPolynomial<ModLong> polyExpr = jas.expr2JAS(polynomial);
                IASTAppendable list = F.ListAlloc(polyExpr.length());
                for (Monomial monomial : polyExpr) {
                    ModLong coeff = (ModLong)monomial.coefficient();
                    ExpVector exp = monomial.exponent();
                    IASTAppendable monomTimes = F.TimesAlloc(exp.length() + 1);
                    jas.monomialToExpr(F.ZZ(coeff.getVal()), exp, monomTimes);
                    list.append(monomTimes);
                }
                return list;
            }
            catch (ArithmeticException ae) {
                LOGGER.debug("MonomialList.monomialListModulus() failed", (Throwable)ae);
                return F.NIL;
            }
        }
    }

    static final class LegendreQ
    extends AbstractFunctionEvaluator
    implements LegendreQRules {
        LegendreQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            int arg1;
            if (ast != null && ast.size() > 1 && Math.abs(arg1 = ast.arg1().toIntDefault()) > Config.MAX_POLYNOMIAL_DEGREE) {
                PolynomialDegreeLimitExceeded.throwIt(arg1);
            }
            return ARGS_2_3;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
            super.setUp(newSymbol);
        }
    }

    private static final class LegendreP
    extends AbstractFunctionEvaluator
    implements LegendrePRules {
        private LegendreP() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int degree = ast.arg1().toIntDefault();
            if (degree >= 0) {
                if (degree > Config.MAX_POLYNOMIAL_DEGREE) {
                    PolynomialDegreeLimitExceeded.throwIt(degree);
                }
                return PolynomialsUtils.createLegendrePolynomial(degree, ast.arg2());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
            super.setUp(newSymbol);
        }
    }

    private static final class LaguerreL
    extends AbstractFunctionEvaluator {
        private LaguerreL() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int degree = ast.arg1().toIntDefault();
            if (degree != Integer.MIN_VALUE) {
                if (degree > Config.MAX_POLYNOMIAL_DEGREE) {
                    PolynomialDegreeLimitExceeded.throwIt(degree);
                }
                if (ast.size() == 4) {
                    IExpr n = ast.arg1();
                    IExpr l = ast.arg2();
                    IExpr z = ast.arg3();
                    return this.laguerreLRecursive(n, degree, l, z, engine);
                }
                if (degree == 0) {
                    return F.C1;
                }
                if (degree > 0) {
                    IExpr z = ast.arg2();
                    return PolynomialsUtils.createLaguerrePolynomial(degree, z);
                }
            }
            return F.NIL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IExpr laguerreLRecursive(IExpr n, int degree, IExpr l, IExpr z, EvalEngine engine) {
            if (degree == 0) {
                return F.C1;
            }
            if (degree == 1) {
                return F.Plus((IExpr)F.C1, l, F.Negate(z));
            }
            if (degree == 2) {
                return F.Times((IExpr)F.C1D2, (IExpr)F.Plus(F.C2, F.Times((IExpr)F.C3, l), F.Sqr(l), F.Times((IExpr)F.CN4, z), F.Times((IExpr)F.CN2, l, z), F.Sqr(z)));
            }
            if (degree < 0) {
                return F.NIL;
            }
            try {
                IExpr laguerre2;
                IExpr laguerre1;
                int recursionCounter = engine.incRecursionCounter();
                int recursionLimit = engine.getRecursionLimit();
                if (recursionCounter > recursionLimit) {
                    RecursionLimitExceeded.throwIt(recursionCounter, S.LaguerreL);
                }
                if ((laguerre1 = this.laguerreLRecursive(F.ZZ(degree - 2), degree - 2, l, z, engine)).isIndeterminate()) {
                    throw new ArgumentTypeException("Indeterminate expression detected");
                }
                long leafCount1 = laguerre1.leafCount();
                if (leafCount1 > (long)Config.MAX_AST_SIZE) {
                    ASTElementLimitExceeded.throwIt(leafCount1);
                }
                if ((laguerre2 = this.laguerreLRecursive(F.ZZ(degree - 1), degree - 1, l, z, engine)).isIndeterminate()) {
                    throw new ArgumentTypeException("Indeterminate expression detected");
                }
                long leafCount2 = leafCount1 + laguerre2.leafCount();
                if (leafCount2 > (long)Config.MAX_AST_SIZE) {
                    ASTElementLimitExceeded.throwIt(leafCount2);
                }
                IASTMutable iASTMutable = F.Times((IExpr)F.Power(n, F.CN1), (IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Plus((IExpr)F.CN1, l, n), laguerre1), (IExpr)F.Times((IExpr)F.Plus(F.CN1, l, F.Times((IExpr)F.C2, n), F.Negate(z)), laguerre2)));
                return iASTMutable;
            }
            finally {
                engine.decRecursionCounter();
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
            super.setUp(newSymbol);
        }
    }

    private static final class HermiteH
    extends AbstractFunctionEvaluator {
        private HermiteH() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int degree = ast.arg1().toIntDefault();
            if (degree >= 0) {
                return PolynomialsUtils.createHermitePolynomial(degree, ast.arg2());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class GroebnerBasis
    extends AbstractFunctionEvaluator {
        private GroebnerBasis() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() >= 3) {
                if (!ast.arg1().isList() || !ast.arg2().isList()) {
                    return F.NIL;
                }
                TermOrder termOrder = TermOrderByName.Lexicographic;
                if (ast.size() > 3) {
                    OptionArgs options = new OptionArgs(ast.topHead(), ast, ast.argSize(), engine);
                    termOrder = JASIExpr.monomialOrder(options, termOrder);
                }
                IAST polys = (IAST)ast.arg1();
                IAST vars = (IAST)ast.arg2();
                if (vars.size() <= 1) {
                    return F.NIL;
                }
                return GroebnerBasis.computeGroebnerBasis(polys, vars, termOrder);
            }
            return F.NIL;
        }

        private static IAST computeGroebnerBasis(IAST listOfPolynomials, IAST listOfVariables, TermOrder termOrder) {
            ArrayList<ISymbol> varList = new ArrayList<ISymbol>(listOfVariables.argSize());
            String[] pvars = new String[listOfVariables.argSize()];
            for (int i = 1; i < listOfVariables.size(); ++i) {
                if (!listOfVariables.get(i).isSymbol()) {
                    return F.NIL;
                }
                varList.add((ISymbol)listOfVariables.get(i));
                pvars[i - 1] = ((ISymbol)listOfVariables.get(i)).toString();
            }
            ArrayList polyList = new ArrayList(listOfPolynomials.argSize());
            JASConvert jas = new JASConvert((List<? extends IExpr>)((List<IExpr>)varList), BigRational.ZERO, termOrder);
            for (int i = 1; i < listOfPolynomials.size(); ++i) {
                IExpr expr = F.evalExpandAll(listOfPolynomials.get(i));
                try {
                    GenPolynomial poly = jas.expr2JAS(expr, false);
                    polyList.add(poly);
                    continue;
                }
                catch (JASConversionException e) {
                    return F.NIL;
                }
            }
            if (polyList.size() == 0) {
                return F.NIL;
            }
            GroebnerBasePartial gbp = new GroebnerBasePartial();
            OptimizedPolynomialList opl = gbp.partialGB(polyList, pvars);
            List list = OrderedPolynomialList.sort((List)opl.list);
            IASTAppendable resultList = F.ListAlloc(list.size());
            for (GenPolynomial p : list) {
                resultList.append(jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)((GenPolynomial)jas.factorTerms((GenPolynomial<BigRational>)p)[2])));
            }
            return resultList;
        }
    }

    private static final class BellY
    extends AbstractFunctionEvaluator {
        private BellY() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.isAST1()) {
                int[] dim = arg1.isMatrix();
                if (dim != null && arg1.isAST()) {
                    if (dim[0] == 0 && dim[1] == 0) {
                        return F.C0;
                    }
                    IAST matrixArg1 = (IAST)arg1;
                    if (dim[0] == 1) {
                        if (dim[1] == 1) {
                            IAST row = (IAST)matrixArg1.arg1();
                            return row.arg1();
                        }
                        if (dim[1] >= 2) {
                            IAST row = (IAST)matrixArg1.arg1();
                            return row.apply((IExpr)S.Times);
                        }
                    }
                }
                return F.NIL;
            }
            if (ast.isAST2()) {
                return F.NIL;
            }
            if (arg1.isInteger() && ast.arg2().isInteger()) {
                int max;
                int n = arg1.toIntDefault();
                int k = ast.arg2().toIntDefault();
                if (n < 0 || k < 0 || !ast.arg3().isList() || ast.arg3().isMatrix() != null) {
                    return F.NIL;
                }
                if (n == 0 && k == 0) {
                    return F.C1;
                }
                if (n == 0 || k == 0) {
                    return F.C0;
                }
                if (n < k) {
                    return F.C0;
                }
                if (n > Config.MAX_POLYNOMIAL_DEGREE) {
                    PolynomialDegreeLimitExceeded.throwIt(n);
                }
                if ((max = n - k + 2) >= 0) {
                    return PolynomialFunctions.bellY(n, k, (IAST)ast.arg3(), ast, engine);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            super.setUp(newSymbol);
        }
    }

    private static final class ChebyshevU
    extends AbstractFunctionEvaluator {
        private ChebyshevU() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (engine.isNumericMode() && n.isNumber() && z.isNumber()) {
                return F.Times.of(engine, F.Power((IExpr)F.Plus((IExpr)F.C1, F.Negate(F.Sqr(z))), F.CN1D2), F.Sin(F.Times((IExpr)F.Plus((IExpr)F.C1, n), (IExpr)F.ArcCos(z))));
            }
            int degree = n.toIntDefault();
            if (degree != Integer.MIN_VALUE) {
                if (degree < 0) {
                    if (degree == -1) {
                        return F.C0;
                    }
                    if (degree == -2) {
                        return F.CN1;
                    }
                    return F.NIL;
                }
                if (degree == 0) {
                    return F.C1;
                }
                if (degree == 1) {
                    return F.Times((IExpr)F.C2, z);
                }
                if (degree > Config.MAX_POLYNOMIAL_DEGREE) {
                    PolynomialDegreeLimitExceeded.throwIt(degree);
                }
                return F.sum(k -> F.Times(F.Power((IExpr)F.CN1, k), F.Power((IExpr)F.Times((IExpr)F.C2, z), F.Plus((IExpr)F.Times((IExpr)F.CN2, k), n)), F.Power((IExpr)F.Times((IExpr)F.Factorial(k), (IExpr)F.Factorial(F.Plus((IExpr)F.Times((IExpr)F.CN2, k), n))), -1L), F.Factorial(F.Plus(F.Negate(k), n))), 0, degree / 2);
            }
            if (n.isNumEqualRational(F.CN1D2)) {
                return F.Times((IExpr)F.C1DSqrt2, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, z), F.CN1D2));
            }
            if (n.isNumEqualRational(F.C1D2)) {
                return F.Times((IExpr)F.C1DSqrt2, (IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C2, z)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, z), F.CN1D2));
            }
            if (z.isZero()) {
                return F.Cos(F.Times((IExpr)F.C1D2, n, (IExpr)S.Pi));
            }
            if (z.isOne()) {
                return F.Plus((IExpr)F.C1, n);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class ChebyshevT
    extends AbstractFunctionEvaluator {
        private ChebyshevT() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (engine.isNumericMode() && n.isNumber() && z.isNumber()) {
                return F.Cos.of(engine, F.Times(n, (IExpr)F.ArcCos(z)));
            }
            int degree = n.toIntDefault();
            if (degree != Integer.MIN_VALUE) {
                if (degree < 0) {
                    degree *= -1;
                }
                if (degree > Config.MAX_POLYNOMIAL_DEGREE) {
                    PolynomialDegreeLimitExceeded.throwIt(degree);
                }
                return PolynomialsUtils.createChebyshevPolynomial(degree, ast.arg2());
            }
            if (n.isNumEqualRational(F.C1D2) || n.isNumEqualRational(F.CN1D2)) {
                return F.Cos(F.Times((IExpr)F.C1D2, (IExpr)F.ArcCos(z)));
            }
            if (z.isZero()) {
                return F.Cos(F.Times((IExpr)F.C1D2, (IExpr)S.Pi, n));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class SphericalHarmonicY
    extends AbstractFunctionEvaluator
    implements SphericalHarmonicYRules {
        private SphericalHarmonicY() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_4_4;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class Resultant
    extends AbstractFunctionEvaluator {
        private Resultant() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg1.isZero() || arg2.isZero()) {
                return F.C0;
            }
            IExpr arg3 = Validate.checkIsVariable(ast, 3, engine);
            if (arg3.isPresent()) {
                IExpr x = arg3;
                IExpr a = F.evalExpandAll(arg1, engine);
                IExpr b = F.evalExpandAll(arg2, engine);
                ExprPolynomialRing ring = new ExprPolynomialRing(F.list(x));
                try {
                    ring.create(a);
                }
                catch (RuntimeException ex) {
                    return IOFunctions.printMessage(ast.topHead(), "polynomial", F.list(ast.get(1), F.C1), engine);
                }
                try {
                    ring.create(b);
                    IExpr resultant = this.resultant(a, b, x, engine);
                    if (resultant.isPresent()) {
                        return F.Together(resultant);
                    }
                }
                catch (RuntimeException ex) {
                    return IOFunctions.printMessage(ast.topHead(), "polynomial", F.list(ast.get(2), F.C2), engine);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        private IExpr resultant(IExpr a, IExpr b, IExpr x, EvalEngine engine) {
            IExpr aExp = S.Exponent.ofNIL(engine, a, x);
            IExpr bExp = S.Exponent.ofNIL(engine, b, x);
            if (aExp.isPresent() && bExp.isPresent()) {
                if (S.Less.ofQ(engine, aExp, bExp)) {
                    IExpr resultant = this.resultant(b, a, x, engine);
                    if (!resultant.isPresent()) {
                        return F.NIL;
                    }
                    return resultant;
                }
                IExpr r = Resultant.jasResultant(a, b, x, engine);
                if (r.isPresent()) {
                    return r;
                }
            }
            return F.NIL;
        }

        private static IExpr jasResultant(IExpr a, IExpr b, IExpr x, EvalEngine engine) {
            VariablesSet eVar = new VariablesSet();
            eVar.addVarList(x);
            try {
                List<IExpr> varList = eVar.getVarList().copyTo();
                JASConvert jas = new JASConvert((List<? extends IExpr>)varList, edu.jas.arith.BigInteger.ZERO);
                GenPolynomial p1 = jas.expr2JAS(a, false);
                GenPolynomial p2 = jas.expr2JAS(b, false);
                GreatestCommonDivisorAbstract factory = GCDFactory.getImplementation((edu.jas.arith.BigInteger)edu.jas.arith.BigInteger.ZERO);
                p1 = factory.resultant(p1, p2);
                return jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)p1);
            }
            catch (ClassCastException | JASConversionException e) {
                try {
                    if (eVar.size() == 0) {
                        return F.NIL;
                    }
                    IASTAppendable vars = eVar.getVarList();
                    ExprPolynomialRing ring = new ExprPolynomialRing(vars);
                    ExprPolynomial pol1 = ring.create(a);
                    ExprPolynomial pol2 = ring.create(b);
                    List<IExpr> varList = eVar.getVarList().copyTo();
                    JASIExpr jas = new JASIExpr(varList, true);
                    GenPolynomial p1 = jas.expr2IExprJAS(pol1);
                    GenPolynomial<IExpr> p2 = jas.expr2IExprJAS(pol2);
                    GreatestCommonDivisorAbstract factory = GCDFactory.getImplementation((RingFactory)ExprRingFactory.CONST);
                    p1 = factory.resultant(p1, p2);
                    return jas.exprPoly2Expr((GenPolynomial<IExpr>)p1);
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("Resultant.jasResultant() failed", (Throwable)rex);
                    return F.NIL;
                }
            }
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Exponent
    extends AbstractFunctionEvaluator {
        private Exponent() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr cached = engine.getCache(ast);
            if (cached != null) {
                return cached;
            }
            IExpr form = engine.evalPattern(ast.arg2());
            if (form.isList()) {
                return ((IAST)form).mapThread(ast, 2);
            }
            IExpr sym = S.Max;
            if (ast.isAST3()) {
                IExpr arg3 = engine.evaluate(ast.arg3());
                sym = arg3;
            }
            TreeSet<IExpr> collector = new TreeSet<IExpr>();
            IExpr expr = F.evalExpandAll(ast.arg1(), engine).normal(false);
            IAST subst = Algebra.substituteVariablesInPolynomial(expr, F.list(form), "\u00a7Exponent");
            expr = subst.arg1();
            form = subst.arg2().first();
            if (expr.isZero()) {
                collector.add(F.CNInfinity);
            } else if (expr.isAST()) {
                IAST arg1 = (IAST)expr;
                IPatternMatcher matcher = engine.evalPatternMatcher(form);
                if (arg1.isPower()) {
                    IExpr pEx = Exponent.powerExponent(arg1, form, matcher, engine);
                    collector.add(pEx);
                } else if (arg1.isPlus()) {
                    for (int i = 1; i < arg1.size(); ++i) {
                        if (arg1.get(i).isAtom()) {
                            if (arg1.get(i).isSymbol()) {
                                if (matcher.test(arg1.get(i), engine)) {
                                    collector.add(F.C1);
                                    continue;
                                }
                                collector.add(F.C0);
                                continue;
                            }
                            collector.add(F.C0);
                            continue;
                        }
                        if (arg1.get(i).isPower()) {
                            IExpr pEx = Exponent.powerExponent((IAST)arg1.get(i), form, matcher, engine);
                            collector.add(pEx);
                            continue;
                        }
                        if (arg1.get(i).isTimes()) {
                            Exponent.timesExponent((IAST)arg1.get(i), form, matcher, collector, engine);
                            continue;
                        }
                        collector.add(F.C0);
                    }
                } else if (arg1.isTimes()) {
                    Exponent.timesExponent(arg1, form, matcher, collector, engine);
                }
            } else if (expr.isSymbol()) {
                IPatternMatcher matcher = engine.evalPatternMatcher(form);
                if (matcher.test(expr)) {
                    collector.add(F.C1);
                } else {
                    collector.add(F.C0);
                }
            } else {
                collector.add(F.C0);
            }
            if (collector.size() == 0) {
                collector.add(F.C0);
            }
            IASTAppendable result = F.ast(sym, collector);
            engine.putCache(ast, result);
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        private static IExpr powerExponent(IAST powerAST, IExpr form, IPatternMatcher matcher, EvalEngine engine) {
            if (matcher.test(powerAST.base(), engine)) {
                return powerAST.exponent();
            }
            if (matcher.isRuleWithoutPatterns() && form.isPower() && form.base().equals(powerAST.base()) && form.exponent().isRational()) {
                return form.exponent().reciprocal().times(powerAST.exponent());
            }
            return F.C0;
        }

        private static void timesExponent(IAST timesAST, IExpr form, IPatternMatcher matcher, Set<IExpr> collector, EvalEngine engine) {
            boolean evaled = false;
            for (int i = 1; i < timesAST.size(); ++i) {
                IExpr argi = timesAST.get(i);
                if (argi.isPower()) {
                    IExpr pEx = Exponent.powerExponent((IAST)argi, form, matcher, engine);
                    if (pEx.isZero()) continue;
                    collector.add(pEx);
                    evaled = true;
                    break;
                }
                if (!argi.isSymbol() || !matcher.test(argi, engine)) continue;
                collector.add(F.C1);
                evaled = true;
                break;
            }
            if (!evaled) {
                collector.add(F.C0);
            }
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Discriminant
    extends AbstractFunctionEvaluator {
        private static final IExpr QUADRATIC = F.Plus((IExpr)F.Sqr(F.b), (IExpr)F.Times((IExpr)F.CN4, (IExpr)F.a, (IExpr)F.c));
        private static final IExpr CUBIC = F.Plus(F.Times((IExpr)F.Sqr(F.b), (IExpr)F.Sqr(F.c)), F.Times((IExpr)F.CN4, (IExpr)F.a, (IExpr)F.Power((IExpr)F.c, F.C3)), F.Times((IExpr)F.CN4, (IExpr)F.Power((IExpr)F.b, F.C3), (IExpr)F.d), F.Times(F.ZZ(18L), F.a, F.b, F.c, F.d), F.Times((IExpr)F.ZZ(-27L), (IExpr)F.Sqr(F.a), (IExpr)F.Sqr(F.d)));
        private static final IExpr QUARTIC = F.Plus(F.Times((IExpr)F.Sqr(F.b), (IExpr)F.Sqr(F.c), (IExpr)F.Sqr(F.d)), F.Times(F.CN4, F.a, F.Power((IExpr)F.c, F.C3), F.Sqr(F.d)), F.Times((IExpr)F.CN4, (IExpr)F.Power((IExpr)F.b, F.C3), (IExpr)F.Power((IExpr)F.d, F.C3)), F.Times(F.ZZ(18L), F.a, F.b, F.c, F.Power((IExpr)F.d, F.C3)), F.Times((IExpr)F.ZZ(-27L), (IExpr)F.Sqr(F.a), (IExpr)F.Power((IExpr)F.d, F.C4)), F.Times(F.CN4, F.Sqr(F.b), F.Power((IExpr)F.c, F.C3), F.e), F.Times(F.ZZ(16L), F.a, F.Power((IExpr)F.c, F.C4), F.e), F.Times(F.ZZ(18L), F.Power((IExpr)F.b, F.C3), F.c, F.d, F.e), F.Times(F.ZZ(-80L), F.a, F.b, F.Sqr(F.c), F.d, F.e), F.Times(F.CN6, F.a, F.Sqr(F.b), F.Sqr(F.d), F.e), F.Times(F.ZZ(144L), F.Sqr(F.a), F.c, F.Sqr(F.d), F.e), F.Times((IExpr)F.ZZ(-27L), (IExpr)F.Power((IExpr)F.b, F.C4), (IExpr)F.Sqr(F.e)), F.Times(F.ZZ(144L), F.a, F.Sqr(F.b), F.c, F.Sqr(F.e)), F.Times(F.ZZ(-128L), F.Sqr(F.a), F.Sqr(F.c), F.Sqr(F.e)), F.Times(F.ZZ(-192L), F.Sqr(F.a), F.b, F.d, F.Sqr(F.e)), F.Times((IExpr)F.ZZ(256L), (IExpr)F.Power((IExpr)F.a, F.C3), (IExpr)F.Power((IExpr)F.e, F.C3)));
        private static final IExpr QUINTIC = F.Plus(F.Times(F.Sqr(F.b), F.Sqr(F.c), F.Sqr(F.d), F.Sqr(F.e)), F.Times(F.CN4, F.a, F.Power((IExpr)F.c, F.C3), F.Sqr(F.d), F.Sqr(F.e)), F.Times(F.CN4, F.Power((IExpr)F.b, F.C3), F.Power((IExpr)F.d, F.C3), F.Sqr(F.e)), F.Times(F.ZZ(18L), F.a, F.b, F.c, F.Power((IExpr)F.d, F.C3), F.Sqr(F.e)), F.Times(F.ZZ(-27L), F.Sqr(F.a), F.Power((IExpr)F.d, F.C4), F.Sqr(F.e)), F.Times(F.CN4, F.Sqr(F.b), F.Power((IExpr)F.c, F.C3), F.Power((IExpr)F.e, F.C3)), F.Times(F.ZZ(16L), F.a, F.Power((IExpr)F.c, F.C4), F.Power((IExpr)F.e, F.C3)), F.Times(F.ZZ(18L), F.Power((IExpr)F.b, F.C3), F.c, F.d, F.Power((IExpr)F.e, F.C3)), F.Times(F.ZZ(-80L), F.a, F.b, F.Sqr(F.c), F.d, F.Power((IExpr)F.e, F.C3)), F.Times(F.CN6, F.a, F.Sqr(F.b), F.Sqr(F.d), F.Power((IExpr)F.e, F.C3)), F.Times(F.ZZ(144L), F.Sqr(F.a), F.c, F.Sqr(F.d), F.Power((IExpr)F.e, F.C3)), F.Times((IExpr)F.ZZ(-27L), (IExpr)F.Power((IExpr)F.b, F.C4), (IExpr)F.Power((IExpr)F.e, F.C4)), F.Times(F.ZZ(144L), F.a, F.Sqr(F.b), F.c, F.Power((IExpr)F.e, F.C4)), F.Times(F.ZZ(-128L), F.Sqr(F.a), F.Sqr(F.c), F.Power((IExpr)F.e, F.C4)), F.Times(F.ZZ(-192L), F.Sqr(F.a), F.b, F.d, F.Power((IExpr)F.e, F.C4)), F.Times((IExpr)F.ZZ(256L), (IExpr)F.Power((IExpr)F.a, F.C3), (IExpr)F.Power((IExpr)F.e, F.C5)), F.Times(F.CN4, F.Sqr(F.b), F.Sqr(F.c), F.Power((IExpr)F.d, F.C3), F.f), F.Times(F.ZZ(16L), F.a, F.Power((IExpr)F.c, F.C3), F.Power((IExpr)F.d, F.C3), F.f), F.Times(F.ZZ(16L), F.Power((IExpr)F.b, F.C3), F.Power((IExpr)F.d, F.C4), F.f), F.Times(F.ZZ(-72L), F.a, F.b, F.c, F.Power((IExpr)F.d, F.C4), F.f), F.Times(F.ZZ(108L), F.Sqr(F.a), F.Power((IExpr)F.d, F.C5), F.f), F.Times(F.ZZ(18L), F.Sqr(F.b), F.Power((IExpr)F.c, F.C3), F.d, F.e, F.f), F.Times(F.ZZ(-72L), F.a, F.Power((IExpr)F.c, F.C4), F.d, F.e, F.f), F.Times(F.ZZ(-80L), F.Power((IExpr)F.b, F.C3), F.c, F.Sqr(F.d), F.e, F.f), F.Times(F.ZZ(356L), F.a, F.b, F.Sqr(F.c), F.Sqr(F.d), F.e, F.f), F.Times(F.ZZ(24L), F.a, F.Sqr(F.b), F.Power((IExpr)F.d, F.C3), F.e, F.f), F.Times(F.ZZ(-630L), F.Sqr(F.a), F.c, F.Power((IExpr)F.d, F.C3), F.e, F.f), F.Times(F.CN6, F.Power((IExpr)F.b, F.C3), F.Sqr(F.c), F.Sqr(F.e), F.f), F.Times(F.ZZ(24L), F.a, F.b, F.Power((IExpr)F.c, F.C3), F.Sqr(F.e), F.f), F.Times(F.ZZ(144L), F.Power((IExpr)F.b, F.C4), F.d, F.Sqr(F.e), F.f), F.Times(F.ZZ(-746L), F.a, F.Sqr(F.b), F.c, F.d, F.Sqr(F.e), F.f), F.Times(F.ZZ(560L), F.Sqr(F.a), F.Sqr(F.c), F.d, F.Sqr(F.e), F.f), F.Times(F.ZZ(1020L), F.Sqr(F.a), F.b, F.Sqr(F.d), F.Sqr(F.e), F.f), F.Times(F.ZZ(-36L), F.a, F.Power((IExpr)F.b, F.C3), F.Power((IExpr)F.e, F.C3), F.f), F.Times(F.ZZ(160L), F.Sqr(F.a), F.b, F.c, F.Power((IExpr)F.e, F.C3), F.f), F.Times(F.ZZ(-1600L), F.Power((IExpr)F.a, F.C3), F.d, F.Power((IExpr)F.e, F.C3), F.f), F.Times(F.ZZ(-27L), F.Sqr(F.b), F.Power((IExpr)F.c, F.C4), F.Sqr(F.f)), F.Times(F.ZZ(108L), F.a, F.Power((IExpr)F.c, F.C5), F.Sqr(F.f)), F.Times(F.ZZ(144L), F.Power((IExpr)F.b, F.C3), F.Sqr(F.c), F.d, F.Sqr(F.f)), F.Times(F.ZZ(-630L), F.a, F.b, F.Power((IExpr)F.c, F.C3), F.d, F.Sqr(F.f)), F.Times(F.ZZ(-128L), F.Power((IExpr)F.b, F.C4), F.Sqr(F.d), F.Sqr(F.f)), F.Times(F.ZZ(560L), F.a, F.Sqr(F.b), F.c, F.Sqr(F.d), F.Sqr(F.f)), F.Times(F.ZZ(825L), F.Sqr(F.a), F.Sqr(F.c), F.Sqr(F.d), F.Sqr(F.f)), F.Times(F.ZZ(-900L), F.Sqr(F.a), F.b, F.Power((IExpr)F.d, F.C3), F.Sqr(F.f)), F.Times(F.ZZ(-192L), F.Power((IExpr)F.b, F.C4), F.c, F.e, F.Sqr(F.f)), F.Times(F.ZZ(1020L), F.a, F.Sqr(F.b), F.Sqr(F.c), F.e, F.Sqr(F.f)), F.Times(F.ZZ(-900L), F.Sqr(F.a), F.Power((IExpr)F.c, F.C3), F.e, F.Sqr(F.f)), F.Times(F.ZZ(160L), F.a, F.Power((IExpr)F.b, F.C3), F.d, F.e, F.Sqr(F.f)), F.Times(F.ZZ(-2050L), F.Sqr(F.a), F.b, F.c, F.d, F.e, F.Sqr(F.f)), F.Times(F.ZZ(2250L), F.Power((IExpr)F.a, F.C3), F.Sqr(F.d), F.e, F.Sqr(F.f)), F.Times(F.ZZ(-50L), F.Sqr(F.a), F.Sqr(F.b), F.Sqr(F.e), F.Sqr(F.f)), F.Times(F.ZZ(2000L), F.Power((IExpr)F.a, F.C3), F.c, F.Sqr(F.e), F.Sqr(F.f)), F.Times((IExpr)F.ZZ(256L), (IExpr)F.Power((IExpr)F.b, F.C5), (IExpr)F.Power((IExpr)F.f, F.C3)), F.Times(F.ZZ(-1600L), F.a, F.Power((IExpr)F.b, F.C3), F.c, F.Power((IExpr)F.f, F.C3)), F.Times(F.ZZ(2250L), F.Sqr(F.a), F.b, F.Sqr(F.c), F.Power((IExpr)F.f, F.C3)), F.Times(F.ZZ(2000L), F.Sqr(F.a), F.Sqr(F.b), F.d, F.Power((IExpr)F.f, F.C3)), F.Times(F.ZZ(-3750L), F.Power((IExpr)F.a, F.C3), F.c, F.d, F.Power((IExpr)F.f, F.C3)), F.Times(F.ZZ(-2500L), F.Power((IExpr)F.a, F.C3), F.b, F.e, F.Power((IExpr)F.f, F.C3)), F.Times((IExpr)F.ZZ(3125L), (IExpr)F.Power((IExpr)F.a, F.C4), (IExpr)F.Power((IExpr)F.f, F.C4)));
        private ISymbol[] vars = new ISymbol[]{F.a, F.b, F.c, F.d, F.e, F.f};

        private Discriminant() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2 = ast.arg2();
            if (!arg2.isSymbol()) {
                return F.NIL;
            }
            IExpr expr = F.evalExpandAll(ast.arg1(), engine);
            try {
                IAST univariateVariables = F.list(arg2);
                ExprPolynomialRing ring = new ExprPolynomialRing(univariateVariables);
                ExprPolynomial poly = ring.create(expr);
                long n = poly.degree();
                if (n >= 2L && n <= 5L) {
                    IAST result = poly.coefficientList();
                    IASTAppendable rules = F.ListAlloc(result.size());
                    rules.appendArgs(result.size(), i -> F.Rule((IExpr)this.vars[i - 1], result.get(i)));
                    switch ((int)n) {
                        case 2: {
                            return QUADRATIC.replaceAll(rules);
                        }
                        case 3: {
                            return CUBIC.replaceAll(rules);
                        }
                        case 4: {
                            return QUARTIC.replaceAll(rules);
                        }
                        case 5: {
                            return QUINTIC.replaceAll(rules);
                        }
                    }
                }
                IExpr fN = poly.leadingBaseCoefficient();
                ExprPolynomial polyDiff = poly.derivativeUnivariate();
                return F.Divide(F.Times(F.Power((IExpr)F.CN1, n * (n - 1L) / 2L), (IExpr)F.Resultant(poly.getExpr(), polyDiff.getExpr(), arg2)), fN);
            }
            catch (RuntimeException ex) {
                LOGGER.log(engine.getLogLevel(), "{}: polynomial expected at position 1 instead of {}", (Object)ast.topHead(), (Object)ast.arg1());
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol symbol) {
            symbol.setAttributes(512);
        }
    }

    private static final class Cyclotomic
    extends AbstractFunctionEvaluator {
        private Cyclotomic() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int n = ast.arg1().toIntDefault(-1);
            if (n >= 0) {
                if (n / 100 > Config.MAX_POLYNOMIAL_DEGREE) {
                    PolynomialDegreeLimitExceeded.throwIt(n);
                }
                return Cyclotomic.cyclotomic(n, ast.arg2());
            }
            if (ast.arg1().isNumber()) {
                IOFunctions.printMessage(ast.topHead(), "intnm", F.list(F.C1, ast), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        private static IExpr cyclotomic(int n, IExpr x) {
            int nHalf;
            switch (n) {
                case 0: {
                    return F.C1;
                }
                case 1: {
                    return F.Plus((IExpr)F.CN1, x);
                }
                case 2: {
                    return F.Plus((IExpr)F.C1, x);
                }
                case 3: {
                    return F.Plus((IExpr)F.C1, x, (IExpr)F.Sqr(x));
                }
            }
            if (x.isZero()) {
                return F.C1;
            }
            if (LongMath.isPrime((long)n)) {
                if (x.isRational()) {
                    return F.sumRational(i -> ((IRational)x).powerRational(i), 0, n - 1);
                }
                return F.sum(i -> x.power((IExpr)i), 0, n - 1);
            }
            if ((n & 1) == 0 && ((nHalf = n / 2) & 1) == 1) {
                if (LongMath.isPrime((long)nHalf)) {
                    return F.sum(i -> x.negate().power((IExpr)i), 0, nHalf - 1);
                }
                return Cyclotomic.cyclotomic(nHalf, x.negate());
            }
            BigInteger bigN = BigInteger.valueOf(n);
            Object[] primePower = Primality.primePower(bigN);
            if (primePower != null) {
                int p = ((BigInteger)primePower[0]).intValue();
                int pPowerm = n / p;
                return Cyclotomic.cyclotomic(p, x.power(F.ZZ(pPowerm)));
            }
            IInteger ni = F.ZZ(n);
            IAST divisorList = ni.divisors();
            return F.Together(F.intIterator(S.Times, d -> F.Power((IExpr)F.Plus((IExpr)F.C1, F.Negate(F.Power(x, d))), F.MoebiusMu(F.Times(F.Power(d, -1L), (IExpr)ni))), divisorList));
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
            super.setUp(newSymbol);
        }
    }

    private static class CoefficientRules
    extends AbstractFunctionEvaluator {
        private CoefficientRules() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST symbolList;
            List<IExpr> varList;
            IExpr arg1 = ast.arg1();
            if (ast.arg1().isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            IExpr expr = F.evalExpandAll(ast.arg1(), engine);
            if (ast.isAST1()) {
                VariablesSet eVar = new VariablesSet(ast.arg1());
                varList = eVar.getArrayList();
                symbolList = eVar.getVarList();
            } else {
                symbolList = Validate.checkIsVariableOrVariableList(ast, 2, ast.topHead(), engine);
                if (!symbolList.isPresent()) {
                    return F.NIL;
                }
                varList = new ArrayList<IExpr>(symbolList.argSize());
                symbolList.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> varList.add((IExpr)x)));
            }
            TermOrder termOrder = TermOrderByName.Lexicographic;
            if (ast.size() > 3) {
                if (ast.arg3().isSymbol()) {
                    termOrder = JASIExpr.monomialOrder((ISymbol)ast.arg3(), termOrder);
                } else {
                    OptionArgs options = new OptionArgs(ast.topHead(), ast, 2, engine);
                    IExpr option = options.getOption(S.Modulus);
                    if (option.isPresent()) {
                        try {
                            if (option.isInteger()) {
                                return CoefficientRules.coefficientRulesModulus(expr, varList, termOrder, option);
                            }
                        }
                        catch (RuntimeException rex) {
                            LOGGER.debug("CoefficientRules.evaluate() failed", (Throwable)rex);
                        }
                    }
                    return F.NIL;
                }
            }
            try {
                ExprPolynomialRing ring = new ExprPolynomialRing(symbolList, new ExprTermOrder(termOrder.getEvord()));
                ExprPolynomial poly = ring.create(expr, false, true, true);
                return poly.coefficientRules();
            }
            catch (RuntimeException rex) {
                LOGGER.debug("CoefficientRules.evaluate() failed", (Throwable)rex);
                IASTAppendable ruleList = F.ListAlloc(symbolList.size());
                for (int j = 1; j < symbolList.size(); ++j) {
                    ruleList.append(F.C0);
                }
                return F.list(F.Rule((IExpr)ruleList, expr));
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4;
        }

        private static IAST coefficientRulesModulus(IExpr polynomial, List<IExpr> variablesList, TermOrder termOrder, IExpr option) throws JASConversionException {
            try {
                ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
                JASModInteger jas = new JASModInteger(variablesList, modIntegerRing);
                GenPolynomial<ModLong> polyExpr = jas.expr2JAS(polynomial);
                IASTAppendable resultList = F.ListAlloc(polyExpr.length());
                for (Monomial monomial : polyExpr) {
                    ModLong coeff = (ModLong)monomial.coefficient();
                    ExpVector exp = monomial.exponent();
                    int len = exp.length();
                    IASTAppendable ruleList = F.ListAlloc(len);
                    for (int i = 0; i < len; ++i) {
                        ruleList.append(exp.getVal(len - i - 1));
                    }
                    resultList.append(F.Rule((IExpr)ruleList, (IExpr)F.ZZ(coeff.getVal())));
                }
                return resultList;
            }
            catch (ArithmeticException ae) {
                LOGGER.debug("CoefficientRules.coefficientRulesModulus() failed", (Throwable)ae);
                return F.NIL;
            }
        }
    }

    private static class CoefficientList
    extends AbstractFunctionEvaluator {
        private CoefficientList() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.arg1().isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            IExpr expr = F.evalExpandAll(arg1, engine).normal(false);
            IAST list = ast.arg2().orNewList();
            return PolynomialFunctions.coefficientList(expr, list);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    @Deprecated
    private static class CoefficientArrays
    extends AbstractFunctionEvaluator {
        private CoefficientArrays() {
        }

        @Override
        @Deprecated
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST symbolList;
            List<IExpr> varList;
            IExpr expr = F.evalExpandAll(ast.arg1(), engine);
            if (ast.isAST1()) {
                VariablesSet eVar = new VariablesSet(ast.arg1());
                varList = eVar.getArrayList();
                symbolList = eVar.getVarList();
            } else {
                symbolList = Validate.checkIsVariableOrVariableList(ast, 2, ast.topHead(), engine);
                if (!symbolList.isPresent()) {
                    return F.NIL;
                }
                varList = new ArrayList<IExpr>(symbolList.argSize());
                symbolList.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> varList.add((IExpr)x)));
            }
            TermOrder termOrder = TermOrderByName.Lexicographic;
            if (ast.size() > 3 && ast.arg3().isSymbol()) {
                termOrder = JASIExpr.monomialOrder((ISymbol)ast.arg3(), termOrder);
            }
            try {
                ExprPolynomialRing ring = new ExprPolynomialRing(symbolList, new ExprTermOrder(termOrder.getEvord()));
                ExprPolynomial poly = ring.create(expr, false, true, true);
                return poly.coefficientArrays((int)poly.degree());
            }
            catch (RuntimeException rex) {
                LOGGER.debug("CoefficientArrays.evaluate() failed", (Throwable)rex);
                IASTAppendable ruleList = F.ListAlloc(symbolList.size());
                for (int j = 1; j < symbolList.size(); ++j) {
                    ruleList.append(F.C0);
                }
                return F.list(F.Rule((IExpr)ruleList, expr));
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4;
        }
    }

    private static class Coefficient
    extends AbstractFunctionEvaluator {
        private Coefficient() {
        }

        private boolean setExponent(IAST list, IExpr expr, long[] exponents, long value) {
            for (int j = 1; j < list.size(); ++j) {
                if (!list.get(j).equals(expr)) continue;
                int ix = ExpVectorLong.indexVar(expr, list);
                exponents[ix] = value;
                return true;
            }
            return false;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr cached = engine.getCache(ast);
            if (cached != null) {
                return cached;
            }
            IExpr arg2 = ast.arg2();
            IASTAppendable listOfVariables = null;
            IExpr[] exponents = null;
            listOfVariables = F.ListAlloc();
            listOfVariables.append(arg2);
            exponents = new IExpr[]{F.C1};
            try {
                IExpr n = F.C1;
                if (ast.isAST3()) {
                    if (ast.arg3().isNegativeInfinity()) {
                        return F.C0;
                    }
                    n = ast.arg3();
                    for (int i = 0; i < exponents.length; ++i) {
                        exponents[i] = exponents[i].multiply(n);
                    }
                }
                ExpVectorSymbolic expArr = new ExpVectorSymbolic(exponents);
                IExpr expr = F.evalExpandAll(ast.arg1(), engine).normal(false);
                IAST subst = Algebra.substituteVariablesInPolynomial(expr, listOfVariables, "\u00a7Coefficient");
                expr = subst.arg1();
                listOfVariables = (IASTAppendable)subst.arg2();
                SymbolicPolynomialRing ring = new SymbolicPolynomialRing(ExprRingFactory.CONST, listOfVariables);
                SymbolicPolynomial poly = ring.create(expr, true, false, false);
                IExpr temp = poly.coefficient(expArr);
                engine.putCache(ast, temp);
                return temp;
            }
            catch (LimitException le) {
                throw le;
            }
            catch (RuntimeException ae) {
                LOGGER.debug("Coefficient.evaluate() failed", (Throwable)ae);
                return F.C0;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.BellY.setEvaluator(new BellY());
            S.ChebyshevT.setEvaluator(new ChebyshevT());
            S.ChebyshevU.setEvaluator(new ChebyshevU());
            S.Coefficient.setEvaluator(new Coefficient());
            S.CoefficientList.setEvaluator(new CoefficientList());
            S.CoefficientRules.setEvaluator(new CoefficientRules());
            S.Cyclotomic.setEvaluator(new Cyclotomic());
            S.Discriminant.setEvaluator(new Discriminant());
            S.Exponent.setEvaluator(new Exponent());
            S.GroebnerBasis.setEvaluator(new GroebnerBasis());
            S.HermiteH.setEvaluator(new HermiteH());
            S.LaguerreL.setEvaluator(new LaguerreL());
            S.LegendreP.setEvaluator(new LegendreP());
            S.LegendreQ.setEvaluator(new LegendreQ());
            S.MonomialList.setEvaluator(new MonomialList());
            S.Resultant.setEvaluator(new Resultant());
            S.SphericalHarmonicY.setEvaluator(new SphericalHarmonicY());
        }
    }
}

