/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.AttributeFunctions;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ConditionException;
import org.matheclipse.core.eval.exception.FailedException;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.ISetEvaluator;
import org.matheclipse.core.eval.interfaces.ISetValueEvaluator;
import org.matheclipse.core.eval.util.Lambda;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.PatternNested;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.Documentation;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcherEquals;
import org.matheclipse.core.patternmatching.RulesData;

public final class PatternMatching {
    private static final Logger LOGGER = LogManager.getLogger();

    private static IExpr setDownRule(IExpr leftHandSide, int flags, IExpr rightHandSide, boolean packageMode) {
        if (leftHandSide.isAST()) {
            ISymbol lhsSymbol = PatternMatching.determineRuleTag(leftHandSide);
            if (lhsSymbol.isProtected()) {
                IOFunctions.printMessage(S.Set, "wrsym", F.list(lhsSymbol), EvalEngine.get());
                return rightHandSide;
            }
            lhsSymbol.putDownRule(1, false, leftHandSide, rightHandSide, packageMode);
            return rightHandSide;
        }
        if (leftHandSide.isSymbol()) {
            ISymbol lhsSymbol = (ISymbol)leftHandSide;
            if (lhsSymbol.isProtected()) {
                IOFunctions.printMessage(S.Set, "wrsym", F.list(lhsSymbol), EvalEngine.get());
                return rightHandSide;
            }
            lhsSymbol.assignValue(rightHandSide, false);
            return rightHandSide;
        }
        throw new RuleCreationError(leftHandSide);
    }

    private static ISymbol determineRuleTag(IExpr leftHandSide) {
        while (leftHandSide.isCondition() && leftHandSide.first().isAST()) {
            leftHandSide = leftHandSide.first();
        }
        if (leftHandSide.isSymbol()) {
            return (ISymbol)leftHandSide;
        }
        return leftHandSide.topHead();
    }

    public static IExpr setDownRule(int flags, IExpr leftHandSide, IExpr rightHandSide, boolean packageMode) {
        if (leftHandSide.isAST()) {
            ISymbol lhsSymbol = ((IAST)leftHandSide).topHead();
            lhsSymbol.putDownRule(1, false, leftHandSide, rightHandSide, packageMode);
            return rightHandSide;
        }
        if (leftHandSide.isSymbol()) {
            ((ISymbol)leftHandSide).assignValue(rightHandSide, false);
            return rightHandSide;
        }
        throw new RuleCreationError(leftHandSide);
    }

    private static void setDelayedDownRule(IExpr leftHandSide, int flags, IExpr rightHandSide, boolean packageMode) {
        ISymbol lhsSymbol = null;
        if (leftHandSide instanceof PatternNested) {
            PatternNested pn = (PatternNested)leftHandSide;
            IExpr pattern = pn.getPatternExpr();
            lhsSymbol = PatternMatching.determineRuleTag(pattern);
        }
        if (leftHandSide.isAST()) {
            lhsSymbol = PatternMatching.determineRuleTag(leftHandSide);
        }
        if (lhsSymbol != null) {
            if (lhsSymbol.isProtected()) {
                IOFunctions.printMessage(S.SetDelayed, "wrsym", F.list(lhsSymbol), EvalEngine.get());
                throw new FailedException();
            }
            lhsSymbol.putDownRule(flags | 2, false, leftHandSide, rightHandSide, packageMode);
            return;
        }
        if (leftHandSide.isSymbol()) {
            lhsSymbol = (ISymbol)leftHandSide;
            if (lhsSymbol.isProtected()) {
                IOFunctions.printMessage(S.SetDelayed, "wrsym", F.list(lhsSymbol), EvalEngine.get());
                throw new FailedException();
            }
            ((ISymbol)leftHandSide).assignValue(rightHandSide, true);
            return;
        }
        throw new RuleCreationError(leftHandSide);
    }

    public static void setDelayedDownRule(int priority, IExpr leftHandSide, IExpr rightHandSide, boolean packageMode) {
        if (leftHandSide.isAST()) {
            ISymbol lhsSymbol = ((IAST)leftHandSide).topHead();
            lhsSymbol.putDownRule(2, false, leftHandSide, rightHandSide, priority, packageMode);
            return;
        }
        if (leftHandSide.isSymbol()) {
            ((ISymbol)leftHandSide).assignValue(rightHandSide, true);
            return;
        }
        throw new RuleCreationError(leftHandSide);
    }

    private static IExpr evalLHS(IExpr leftHandSide, int[] flags, EvalEngine engine) {
        if (leftHandSide.isAST() && (((IAST)leftHandSide).getEvalFlags() & 0x300) == 0) {
            if (leftHandSide.isHoldPatternOrLiteral()) {
                flags[0] = leftHandSide.isAST(S.HoldPattern, 2) ? 8192 : 4096;
                return leftHandSide.first();
            }
            return engine.evalHoldPattern((IAST)leftHandSide);
        }
        return leftHandSide;
    }

    public static void extractRules(IExpr x, IASTAppendable optionsPattern) {
        if (x != null) {
            if (x.isSequence() || x.isList()) {
                ((IAST)x).forEach((Consumer<? super IExpr>)((Consumer<IExpr>)arg -> PatternMatching.extractRules(arg, optionsPattern)));
            } else if (x.isRuleAST()) {
                if (x.first().isSymbol()) {
                    String name = ((ISymbol)x.first()).getSymbolName();
                    optionsPattern.append(F.binaryAST2((IExpr)x.topHead(), name, x.second()));
                } else {
                    optionsPattern.append(x);
                }
            }
        }
    }

    public static IAST optionsList(ISymbol symbol, boolean optionValueRules) {
        Map<IExpr, PatternMatcherEquals> map;
        PatternMatcherEquals matcher;
        RulesData rules = symbol.getRulesData();
        if (rules != null && (matcher = (map = rules.getEqualDownRules()).get(F.Options(symbol))) != null) {
            IExpr temp = matcher.getRHS();
            if (optionValueRules) {
                IASTAppendable result = F.ListAlloc(10);
                PatternMatching.extractRules(temp, result);
                return result;
            }
            if (temp.isList()) {
                return (IAST)temp;
            }
            return F.list(temp);
        }
        return F.CEmptyList;
    }

    public static IExpr optionValueReplace(IAST ast, boolean quiet, EvalEngine engine) {
        IASTAppendable optionsPattern = null;
        IExpr arg1 = engine.evaluate(ast.arg1());
        IExpr rhsRuleValue = F.NIL;
        IAST optionsList = null;
        if (ast.size() > 2 && arg1.isSymbol()) {
            optionsList = PatternMatching.optionsList((ISymbol)arg1, true);
        }
        if (ast.isAST3()) {
            IExpr arg2 = ast.arg2();
            IExpr arg3 = ast.arg3();
            if (arg3.isList()) {
                return ((IAST)arg3).mapThread(ast, 3);
            }
            optionsPattern = F.ListAlloc(10);
            PatternMatching.extractRules(arg2, optionsPattern);
            PatternMatching.extractRules(optionsList, optionsPattern);
            IExpr optionValue = arg3;
            if (arg3.isSymbol()) {
                optionValue = F.$str(((ISymbol)arg3).getSymbolName());
            }
            if (optionsPattern != null) {
                rhsRuleValue = PatternMatching.optionsRHSRuleValue(optionValue, optionsPattern);
                if (rhsRuleValue.isPresent()) {
                    return rhsRuleValue;
                }
                if (!quiet) {
                    IOFunctions.printMessage(ast.topHead(), "optnf", F.list(optionsPattern, optionValue), engine);
                }
                return optionValue;
            }
            return F.NIL;
        }
        if (ast.isAST2()) {
            IExpr arg2 = ast.arg2();
            if (arg2.isList()) {
                return ((IAST)arg2).mapThread(ast, 2);
            }
            IExpr optionValue = arg2;
            if (arg2.isSymbol()) {
                optionValue = F.$str(((ISymbol)arg2).getSymbolName());
            }
            if (arg1.isSymbol()) {
                Iterator<IdentityHashMap<ISymbol, IASTAppendable>> iter = engine.optionsStackIterator();
                while (iter.hasNext()) {
                    IdentityHashMap<ISymbol, IASTAppendable> map = iter.next();
                    if (map == null || (optionsPattern = map.get(arg1)) == null || !(rhsRuleValue = PatternMatching.optionsRHSRuleValue(optionValue, optionsPattern)).isPresent()) continue;
                    return rhsRuleValue;
                }
            } else if (arg1.isAST()) {
                optionsList = (IAST)arg1;
            }
            if (optionsPattern == null) {
                optionsPattern = F.ListAlloc(10);
            }
            PatternMatching.extractRules(optionsList, optionsPattern);
            if (optionsPattern != null) {
                rhsRuleValue = PatternMatching.optionsRHSRuleValue(optionValue, optionsPattern);
                if (rhsRuleValue.isPresent()) {
                    return rhsRuleValue;
                }
                if (!quiet) {
                    IOFunctions.printMessage(ast.topHead(), "optnf", F.list(optionsPattern, optionValue), engine);
                }
                return optionValue;
            }
            return F.NIL;
        }
        IExpr optionValue = arg1;
        if (arg1.isSymbol()) {
            optionValue = F.$str(((ISymbol)arg1).getSymbolName());
        }
        Iterator<IdentityHashMap<ISymbol, IASTAppendable>> iter = engine.optionsStackIterator();
        while (iter.hasNext()) {
            ISymbol lhsHead;
            IdentityHashMap<ISymbol, IASTAppendable> map = iter.next();
            if (map == null || (optionsPattern = map.get(S.LHS_HEAD)) == null || !(rhsRuleValue = PatternMatching.optionsRHSRuleValue(optionValue, optionsPattern = map.get(lhsHead = optionsPattern.topHead()))).isPresent()) continue;
            return rhsRuleValue;
        }
        if (optionsPattern != null) {
            if (!quiet) {
                IOFunctions.printMessage(ast.topHead(), "optnf", F.list(optionsPattern, optionValue), engine);
            }
            return optionValue;
        }
        return F.NIL;
    }

    private static IExpr optionsRHSRuleValue(IExpr lhsOptionValue, IASTAppendable optionsPattern) {
        if (optionsPattern != null) {
            for (int i = 1; i < optionsPattern.size(); ++i) {
                IAST rule = (IAST)optionsPattern.get(i);
                if (!rule.arg1().equals(lhsOptionValue)) continue;
                return rule.arg2();
            }
        }
        return F.NIL;
    }

    public static IExpr messageName(ISymbol symbol, IExpr expr) {
        Map<IExpr, PatternMatcherEquals> map;
        PatternMatcherEquals matcher;
        RulesData rules = symbol.getRulesData();
        if (rules != null && (matcher = (map = rules.getEqualDownRules()).get(F.MessageName((IExpr)symbol, expr))) != null) {
            return matcher.getRHS();
        }
        return F.NIL;
    }

    public static void initialize() {
        Initializer.init();
    }

    private PatternMatching() {
    }

    private static final class UpValues
    extends AbstractCoreFunctionEvaluator {
        private UpValues() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = Validate.checkSymbolType(ast, 1, engine);
            if (arg1.isPresent()) {
                ISymbol symbol = (ISymbol)arg1;
                RulesData rulesData = symbol.getRulesData();
                if (rulesData == null) {
                    return F.CEmptyList;
                }
                return rulesData.upValues();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class UpSetDelayed
    extends AbstractCoreFunctionEvaluator {
        private UpSetDelayed() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr leftHandSide = ast.arg1();
            IExpr rightHandSide = ast.arg2();
            try {
                UpSetDelayed.createPatternMatcher(leftHandSide, rightHandSide, false, engine);
                return S.Null;
            }
            catch (ValidateException ve) {
                IOFunctions.printMessage(ast.topHead(), ve, engine);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        private static Object[] createPatternMatcher(IExpr leftHandSide, IExpr rightHandSide, boolean packageMode, EvalEngine engine) throws RuleCreationError {
            Object[] result = new Object[2];
            int[] flags = new int[]{0};
            leftHandSide = PatternMatching.evalLHS(leftHandSide, flags, engine);
            result[0] = null;
            result[1] = rightHandSide;
            IAST lhsAST = Validate.checkASTUpRuleType(leftHandSide);
            for (int i = 1; i < lhsAST.size(); ++i) {
                IExpr temp = lhsAST.get(i);
                if (temp instanceof IPatternObject) {
                    IExpr headTest = ((IPatternObject)temp).getHeadTest();
                    if (headTest == null || !headTest.isSymbol()) continue;
                    ISymbol lhsSymbol = (ISymbol)headTest;
                    result[0] = lhsSymbol.putUpRule(flags[0] | 0x20, false, lhsAST, rightHandSide);
                    continue;
                }
                ISymbol lhsSymbol = null;
                lhsSymbol = temp.isSymbol() ? (ISymbol)temp : lhsAST.get(i).topHead();
                result[0] = lhsSymbol.putUpRule(flags[0] | 0x20, false, lhsAST, rightHandSide);
            }
            return result;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class UpSet
    extends AbstractCoreFunctionEvaluator {
        private UpSet() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr leftHandSide = ast.arg1();
            IExpr rightHandSide = ast.arg2();
            try {
                if (leftHandSide.isList()) {
                    try {
                        rightHandSide = engine.evaluate(rightHandSide);
                    }
                    catch (ReturnException e) {
                        rightHandSide = e.getValue();
                    }
                    IASTMutable temp = engine.threadASTListArgs(F.UpSet(leftHandSide, rightHandSide), S.UpSet, "tdlen");
                    if (temp.isPresent()) {
                        return engine.evaluate(temp);
                    }
                }
                Object[] result = UpSet.createPatternMatcher(leftHandSide, rightHandSide, false, engine);
                return (IExpr)result[1];
            }
            catch (ValidateException ve) {
                IOFunctions.printMessage(ast.topHead(), ve, engine);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        private static Object[] createPatternMatcher(IExpr leftHandSide, IExpr rightHandSide, boolean packageMode, EvalEngine engine) throws RuleCreationError {
            Object[] result = new Object[2];
            int[] flags = new int[]{0};
            leftHandSide = PatternMatching.evalLHS(leftHandSide, flags, engine);
            try {
                rightHandSide = engine.evaluate(rightHandSide);
            }
            catch (ConditionException conditionException) {
            }
            catch (ReturnException e) {
                rightHandSide = e.getValue();
            }
            result[0] = null;
            result[1] = rightHandSide;
            IAST lhsAST = Validate.checkASTUpRuleType(leftHandSide);
            for (int i = 1; i < lhsAST.size(); ++i) {
                IExpr temp = lhsAST.get(i);
                if (temp instanceof IPatternObject) {
                    IExpr headTest = ((IPatternObject)temp).getHeadTest();
                    if (headTest == null || !headTest.isSymbol()) continue;
                    ISymbol lhsSymbol = (ISymbol)headTest;
                    result[0] = lhsSymbol.putUpRule(flags[0] | 0x10, false, lhsAST, rightHandSide);
                    continue;
                }
                ISymbol lhsSymbol = null;
                lhsSymbol = temp.isSymbol() ? (ISymbol)temp : lhsAST.get(i).topHead();
                result[0] = lhsSymbol.putUpRule(flags[0] | 0x10, false, lhsAST, rightHandSide);
            }
            return result;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Unset
    extends AbstractCoreFunctionEvaluator {
        private Unset() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr leftHandSide = ast.arg1();
            try {
                ISymbol lhsSymbol;
                if (leftHandSide.isList()) {
                    IASTMutable temp = engine.threadASTListArgs(F.Unset(leftHandSide), S.Unset, "tdlen");
                    if (temp.isPresent()) {
                        return engine.evaluate(temp);
                    }
                    return F.NIL;
                }
                if (leftHandSide.isAST() && (lhsSymbol = PatternMatching.determineRuleTag(leftHandSide)).isProtected()) {
                    IOFunctions.printMessage(ast.topHead(), "wrsym", F.list(lhsSymbol), EvalEngine.get());
                    throw new FailedException();
                }
                if (leftHandSide.isSymbol() && (lhsSymbol = (ISymbol)leftHandSide).isProtected()) {
                    IOFunctions.printMessage(ast.topHead(), "wrsym", F.list(lhsSymbol), EvalEngine.get());
                    throw new FailedException();
                }
                Unset.removePatternMatcher(leftHandSide, engine.isPackageMode(), engine);
                return S.Null;
            }
            catch (RuleCreationError rce) {
                IOFunctions.printMessage(ast.topHead(), "usraw", F.list(leftHandSide), engine);
                return S.$Failed;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        private static void removePatternMatcher(IExpr leftHandSide, boolean packageMode, EvalEngine engine) throws RuleCreationError {
            if (leftHandSide.isAST()) {
                leftHandSide = engine.evalHoldPattern((IAST)leftHandSide);
            }
            Unset.removeRule(leftHandSide, packageMode);
        }

        private static void removeRule(IExpr leftHandSide, boolean packageMode) {
            if (leftHandSide.isAST()) {
                ISymbol lhsSymbol = ((IAST)leftHandSide).topHead();
                if (!lhsSymbol.removeRule(1, false, leftHandSide, packageMode)) {
                    Unset.printAssignmentNotFound(leftHandSide);
                }
                return;
            }
            if (leftHandSide.isSymbol()) {
                ISymbol lhsSymbol = (ISymbol)leftHandSide;
                if (!lhsSymbol.removeRule(1, true, leftHandSide, packageMode)) {
                    Unset.printAssignmentNotFound(leftHandSide);
                }
                return;
            }
            throw new RuleCreationError(leftHandSide);
        }

        private static void printAssignmentNotFound(IExpr leftHandSide) {
            LOGGER.log(EvalEngine.get().getLogLevel(), "Assignment not found for: {}", (Object)leftHandSide);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Unique
    extends AbstractCoreFunctionEvaluator {
        private Unique() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                if (ast.arg1().isSymbol()) {
                    String varAppend = ast.arg1().toString() + EvalEngine.uniqueName("$");
                    return F.symbol(varAppend, engine);
                }
                if (ast.arg1() instanceof IStringX) {
                    String varAppend = EvalEngine.uniqueName(ast.arg1().toString());
                    return F.symbol(varAppend, engine);
                }
            }
            return F.symbol(EvalEngine.uniqueName("$"), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class TagSetDelayed
    extends TagSet {
        private TagSetDelayed() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isSymbol()) {
                ISymbol symbol = (ISymbol)arg1;
                IExpr leftHandSide = ast.arg2();
                IExpr rightHandSide = ast.arg3();
                if (symbol.isProtected()) {
                    IOFunctions.printMessage(ast.topHead(), "write", F.list(symbol, leftHandSide), EvalEngine.get());
                    throw new FailedException();
                }
                try {
                    TagSetDelayed.createPatternMatcher(symbol, leftHandSide, rightHandSide, false, S.TagSetDelayed, engine);
                    return S.Null;
                }
                catch (ValidateException ve) {
                    IOFunctions.printMessage(ast.topHead(), ve, engine);
                    return S.Null;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262240);
        }
    }

    private static class TagSet
    extends AbstractCoreFunctionEvaluator {
        private TagSet() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isSymbol()) {
                ISymbol symbol = (ISymbol)arg1;
                IExpr leftHandSide = ast.arg2();
                IExpr rightHandSide = ast.arg3();
                try {
                    rightHandSide = engine.evaluate(rightHandSide);
                }
                catch (ConditionException conditionException) {
                }
                catch (ReturnException e) {
                    rightHandSide = e.getValue();
                }
                if (symbol.isProtected()) {
                    IOFunctions.printMessage(S.TagSet, "write", F.list(symbol, leftHandSide), EvalEngine.get());
                    throw new FailedException();
                }
                if (leftHandSide.isList()) {
                    try {
                        rightHandSide = engine.evaluate(rightHandSide);
                    }
                    catch (ReturnException e) {
                        rightHandSide = e.getValue();
                    }
                    IASTMutable temp = engine.threadASTListArgs(F.TagSet(symbol, leftHandSide, rightHandSide), S.TagSet, "tdlen");
                    if (temp.isPresent()) {
                        return engine.evaluate(temp);
                    }
                }
                try {
                    Object[] result = TagSet.createPatternMatcher(symbol, leftHandSide, rightHandSide, false, S.TagSet, engine);
                    return (IExpr)result[1];
                }
                catch (ValidateException ve) {
                    IOFunctions.printMessage(ast.topHead(), ve, engine);
                    return rightHandSide;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        protected static Object[] createPatternMatcher(ISymbol tagSetSymbol, IExpr leftHandSide, IExpr rightHandSide, boolean packageMode, IBuiltInSymbol tagSymbol, EvalEngine engine) throws RuleCreationError {
            Object[] result = new Object[2];
            int[] flags = new int[]{0};
            leftHandSide = PatternMatching.evalLHS(leftHandSide, flags, engine);
            result[0] = null;
            result[1] = rightHandSide;
            IAST lhsAST = Validate.checkASTUpRuleType(leftHandSide);
            boolean found = false;
            found = lhsAST.head().equals(tagSetSymbol) ? true : (lhsAST.isCondition() && lhsAST.first().isAST() ? TagSet.isTagAvailable(tagSetSymbol, (IAST)lhsAST.first()) : TagSet.isTagAvailable(tagSetSymbol, lhsAST));
            if (found) {
                result[0] = tagSetSymbol.putUpRule(flags[0] | 4, false, lhsAST, rightHandSide);
                return result;
            }
            IOFunctions.printMessage(tagSymbol, "tagnf", F.list(tagSetSymbol, lhsAST), engine);
            return result;
        }

        private static boolean isTagAvailable(ISymbol tagSetSymbol, IAST lhsAST) {
            for (int i = 1; i < lhsAST.size(); ++i) {
                IPatternObject pObject;
                IExpr arg = lhsAST.get(i);
                if (arg.equals(tagSetSymbol) || arg.topHead().equals(tagSetSymbol)) {
                    return true;
                }
                if (!(arg instanceof IPatternObject) || !tagSetSymbol.equals((pObject = (IPatternObject)arg).getHeadTest())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262240);
        }
    }

    private static final class SystemOptions
    extends AbstractFunctionEvaluator {
        private SystemOptions() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            String str;
            if (ast.isAST1() && ast.arg1().isString() && (str = ast.arg1().toString()).equals("DifferentiationOptions")) {
                IAST list = F.List(S.Hold, S.HoldComplete, S.Less, S.LessEqual, S.Greater, S.GreaterEqual, S.Inequality, S.Unequal, S.Nand, S.Nor, S.Xor, S.Not, S.Element, S.Exists, S.ForAll, S.Implies, S.Positive, S.Negative, S.NonPositive, S.NonNegative, S.Replace, S.ReplaceAll, S.ReplaceRepeated);
                IAST excludedFunctions = F.Rule("ExcludedFunctions", (IExpr)list);
                return F.list(F.Rule("DifferentiationOptions", (IExpr)F.list(excludedFunctions)));
            }
            return F.CEmptyList;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class SetSystemOptions
    extends AbstractFunctionEvaluator {
        private SetSystemOptions() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!ast.isAST1() || ast.arg1().isString()) {
                // empty if block
            }
            return S.Null;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class SetDelayed
    extends AbstractCoreFunctionEvaluator {
        private SetDelayed() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr leftHandSide = ast.arg1();
            IExpr head = engine.evaluate(leftHandSide.head());
            if (head.isAssociation()) {
                head = S.Association;
            }
            try {
                IBuiltInSymbol symbol;
                IEvaluator eval;
                IExpr rightHandSide = ast.arg2();
                if (leftHandSide.isAST()) {
                    IExpr temp;
                    IBuiltInSymbol symbol2;
                    IEvaluator eval2;
                    if (head.isBuiltInSymbol() && (eval2 = (symbol2 = (IBuiltInSymbol)head).getEvaluator()) instanceof ISetEvaluator && (temp = ((ISetEvaluator)eval2).evaluateSet(leftHandSide, rightHandSide, S.SetDelayed, engine)).isPresent()) {
                        return temp;
                    }
                } else if (leftHandSide.isBuiltInSymbol() && (eval = (symbol = (IBuiltInSymbol)leftHandSide).getEvaluator()) instanceof ISetValueEvaluator) {
                    ((ISetValueEvaluator)eval).evaluateSet(rightHandSide, true, engine);
                    return S.Null;
                }
                SetDelayed.createPatternMatcher(leftHandSide, rightHandSide, engine.isPackageMode(), engine);
                return S.Null;
            }
            catch (RuleCreationError rce) {
                IOFunctions.printMessage(ast.topHead(), "usraw", F.list(leftHandSide), engine);
                return S.$Failed;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        private static void createPatternMatcher(IExpr leftHandSide, IExpr rightHandSide, boolean packageMode, EvalEngine engine) throws RuleCreationError {
            int[] flags = new int[]{0};
            leftHandSide = PatternMatching.evalLHS(leftHandSide, flags, engine);
            PatternMatching.setDelayedDownRule(leftHandSide, flags[0], rightHandSide, packageMode);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262240);
        }
    }

    private static final class Set
    extends AbstractCoreFunctionEvaluator {
        private Set() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr leftHandSide = ast.arg1();
            IExpr head = engine.evaluate(leftHandSide.head());
            if (head.topHead().equals(S.Association)) {
                head = S.Association;
            }
            IExpr rightHandSide = ast.arg2();
            try {
                rightHandSide = engine.evaluate(rightHandSide);
            }
            catch (ConditionException conditionException) {
            }
            catch (ReturnException e) {
                rightHandSide = e.getValue();
            }
            try {
                IEvaluator eval;
                IBuiltInSymbol symbol;
                if (leftHandSide.isAST()) {
                    IEvaluator eval2;
                    if (head.isBuiltInSymbol() && (eval2 = (symbol = (IBuiltInSymbol)head).getEvaluator()) instanceof ISetEvaluator) {
                        return ((ISetEvaluator)eval2).evaluateSet(leftHandSide, rightHandSide, S.Set, engine);
                    }
                } else if (leftHandSide.isBuiltInSymbol() && (eval = (symbol = (IBuiltInSymbol)leftHandSide).getEvaluator()) instanceof ISetValueEvaluator) {
                    return ((ISetValueEvaluator)eval).evaluateSet(rightHandSide, false, engine);
                }
                return Set.createPatternMatcher(leftHandSide, rightHandSide, engine.isPackageMode(), engine);
            }
            catch (RuleCreationError rce) {
                IOFunctions.printMessage(ast.topHead(), "usraw", F.list(leftHandSide), engine);
                return rightHandSide;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        private static IExpr createPatternMatcher(IExpr leftHandSide, IExpr rightHandSide, boolean packageMode, EvalEngine engine) throws RuleCreationError {
            int[] flags = new int[]{0};
            leftHandSide = PatternMatching.evalLHS(leftHandSide, flags, engine);
            return PatternMatching.setDownRule(leftHandSide, flags[0], rightHandSide, packageMode);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262176);
        }
    }

    private static final class Sequence
    extends AbstractFunctionEvaluator {
        private Sequence() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            Deque<IExpr> stack = engine.getStack();
            if (stack.size() == 1 && ast.head() == S.Sequence) {
                return ast.setAtClone(0, S.Identity);
            }
            return F.NIL;
        }
    }

    private static final class RuleDelayed
    extends AbstractCoreFunctionEvaluator {
        private RuleDelayed() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr leftHandSide = ast.arg1();
            if (!(leftHandSide = engine.evaluate(leftHandSide)).equals(ast.arg1())) {
                return F.RuleDelayed(leftHandSide, ast.arg2());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262208);
        }
    }

    private static final class Rule
    extends AbstractCoreFunctionEvaluator {
        private Rule() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr leftHandSide = ast.arg1();
            leftHandSide = engine.evaluate(leftHandSide);
            IExpr arg2 = engine.evaluateNIL(ast.arg2());
            if (!arg2.isPresent()) {
                if (leftHandSide.equals(ast.arg1())) {
                    return F.NIL;
                }
                return F.Rule(leftHandSide, ast.arg2());
            }
            return F.Rule(leftHandSide, arg2);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262144);
        }
    }

    public static final class RepeatedNull
    extends Repeated {
        public static final RepeatedNull CONST = new RepeatedNull();

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head().equals(S.RepeatedNull)) {
                IExpr arg1 = ast.arg1();
                if (ast.isAST1()) {
                    return F.$Repeated(arg1, 0, Integer.MAX_VALUE, engine);
                }
                if (ast.isAST2() && ast.isAST2()) {
                    IExpr arg2 = ast.arg2();
                    return RepeatedNull.repeatedLimit(arg1, arg2, 0, engine);
                }
            }
            return F.NIL;
        }
    }

    public static class Repeated
    extends AbstractCoreFunctionEvaluator {
        public static final Repeated CONST = new Repeated();

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head().equals(S.Repeated)) {
                IExpr arg1 = ast.arg1();
                if (ast.isAST1()) {
                    return F.$Repeated(arg1, 1, Integer.MAX_VALUE, engine);
                }
                if (ast.isAST2()) {
                    IExpr arg2 = ast.arg2();
                    return Repeated.repeatedLimit(arg1, arg2, 1, engine);
                }
            }
            return F.NIL;
        }

        protected static IExpr repeatedLimit(IExpr arg1, IExpr arg2, int defaultMin, EvalEngine engine) {
            if (arg2.isList1()) {
                IExpr first = arg2.first();
                int min = first.isNegativeInfinity() ? -2147483647 : (first.isInfinity() ? Integer.MAX_VALUE : first.toIntDefault());
                return F.$Repeated(arg1, min, min, engine);
            }
            if (arg2.isList2()) {
                IExpr first = arg2.first();
                IExpr second = arg2.second();
                int min = first.isNegativeInfinity() ? -2147483647 : (first.isInfinity() ? Integer.MAX_VALUE : first.toIntDefault());
                int max = second.isNegativeInfinity() ? -2147483647 : (second.isInfinity() ? Integer.MAX_VALUE : second.toIntDefault());
                if (min == Integer.MIN_VALUE || max == Integer.MIN_VALUE) {
                    return F.NIL;
                }
                return F.$Repeated(arg1, min, max, engine);
            }
            int max = arg2.isNegativeInfinity() ? -2147483647 : (arg2.isInfinity() ? Integer.MAX_VALUE : arg2.toIntDefault());
            if (max == Integer.MIN_VALUE) {
                return F.NIL;
            }
            return F.$Repeated(arg1, defaultMin, max, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class ReleaseHold
    extends AbstractCoreFunctionEvaluator {
        private ReleaseHold() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isAST()) {
                return arg1.replaceAll(ReleaseHold::releaseHold);
            }
            return arg1;
        }

        private static IExpr releaseHold(IExpr expr) {
            IASTMutable result = F.NIL;
            if (expr.isAST()) {
                if (expr.isAST(S.Hold, 2) || expr.isAST(S.HoldForm, 2) || expr.isAST(S.HoldComplete, 2) || expr.isAST(S.HoldPattern, 2)) {
                    return expr.first();
                }
                IAST list = (IAST)expr;
                for (int i = 1; i < list.size(); ++i) {
                    IExpr temp;
                    IExpr arg = list.get(i);
                    if (!arg.isAST() || !(temp = arg.replaceAll(ReleaseHold::releaseHold)).isPresent()) continue;
                    if (!result.isPresent()) {
                        result = list.setAtCopy(i, arg.first());
                        continue;
                    }
                    result.set(i, arg.first());
                }
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class PatternTest
    extends AbstractCoreFunctionEvaluator {
        private PatternTest() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IPatternObject po;
            IExpr arg1 = ast.arg1();
            if (arg1 instanceof IPatternObject && ((po = (IPatternObject)arg1).isPatternOptional() || po.isPatternDefault())) {
                return IOFunctions.printMessage(S.PatternTest, "patop", F.list(ast), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    public static final class Pattern
    extends AbstractCoreFunctionEvaluator {
        public static final Pattern CONST = new Pattern();

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head().equals(S.Pattern) && ast.size() == 3) {
                if (ast.arg1().isSymbol()) {
                    ISymbol symbol = (ISymbol)ast.arg1();
                    IExpr arg2 = ast.arg2();
                    if (arg2.isBlank()) {
                        return F.$p(symbol, ((IPattern)arg2).getHeadTest());
                    }
                    if (arg2.isAST()) {
                        if (arg2.size() == 1) {
                            if (arg2.isAST(S.Blank)) {
                                return F.$p(symbol);
                            }
                            if (arg2.isAST(S.BlankSequence)) {
                                return F.$ps(symbol, null, false, false);
                            }
                            if (arg2.isAST(S.BlankNullSequence)) {
                                return F.$ps(symbol, null, false, true);
                            }
                            if (arg2.isAST(S.OptionsPattern)) {
                                return F.$OptionsPattern(symbol);
                            }
                        } else if (arg2.size() == 2) {
                            IExpr first = arg2.first();
                            if (first.isAST()) {
                                first = engine.evalHoldPattern((IAST)first);
                            }
                            if (arg2.isAST(S.Blank)) {
                                return F.$p(symbol, first);
                            }
                            if (arg2.isAST(S.BlankSequence)) {
                                return F.$ps(symbol, first, false, false);
                            }
                            if (arg2.isAST(S.BlankNullSequence)) {
                                return F.$ps(symbol, first, false, true);
                            }
                            if (arg2.isAST(S.OptionsPattern)) {
                                return F.$OptionsPattern(symbol, first);
                            }
                        }
                        arg2 = engine.evalHoldPattern((IAST)arg2);
                    }
                    return PatternNested.valueOf(symbol, arg2);
                }
                return IOFunctions.printMessage(ast.topHead(), "patvar", F.list(ast), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    public static final class OptionsPattern
    extends AbstractCoreFunctionEvaluator {
        public static final OptionsPattern CONST = new OptionsPattern();

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head().equals(S.OptionsPattern)) {
                if (ast.isAST0()) {
                    return F.$OptionsPattern();
                }
                if (ast.isAST1()) {
                    return F.$OptionsPattern(null, ast.arg1());
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class OwnValues
    extends AbstractCoreFunctionEvaluator {
        private OwnValues() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = Validate.checkSymbolType(ast, 1, engine);
            if (arg1.isPresent()) {
                ISymbol symbol = (ISymbol)arg1;
                IExpr value = symbol.assignedValue();
                if (value == null) {
                    return F.CEmptyList;
                }
                return F.list(F.RuleDelayed(F.HoldPattern(symbol), value));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    public static class OptionValue
    extends AbstractCoreFunctionEvaluator {
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head().equals(S.OptionValue)) {
                return PatternMatching.optionValueReplace(ast, false, engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Options
    extends AbstractFunctionEvaluator
    implements ISetEvaluator {
        private Options() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1() && ast.arg1().isSymbol()) {
                ISymbol arg1 = (ISymbol)ast.arg1();
                return PatternMatching.optionsList(arg1, false);
            }
            return F.NIL;
        }

        @Override
        public IExpr evaluateSet(IExpr leftHandSide, IExpr rightHandSide, IBuiltInSymbol builtinSymbol, EvalEngine engine) {
            ISymbol symbol;
            if (leftHandSide.isAST(S.Options, 2) && leftHandSide.first().isSymbol() && !(symbol = (ISymbol)leftHandSide.first()).isProtected()) {
                try {
                    if (!builtinSymbol.equals(S.SetDelayed)) {
                        rightHandSide = engine.evaluate(rightHandSide);
                    }
                }
                catch (ReturnException e) {
                    rightHandSide = e.getValue();
                }
                symbol.putDownRule(1, true, leftHandSide, rightHandSide, engine.isPackageMode());
                if (builtinSymbol.equals(S.Set)) {
                    return rightHandSide;
                }
                return S.Null;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.addAttributes(96);
        }
    }

    public static class Optional
    extends AbstractCoreFunctionEvaluator {
        public static final Optional CONST = new Optional();

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head().equals(S.Optional) && ast.size() == 2) {
                IPattern patt;
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isBlank() && (patt = (IPattern)arg1).getHeadTest() == null) {
                    return F.$b(patt.getHeadTest(), true);
                }
                if (arg1.isPattern() && (patt = (IPattern)arg1).getHeadTest() == null) {
                    return F.$p(patt.getSymbol(), patt.getHeadTest(), true);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Nothing
    extends AbstractFunctionEvaluator {
        private Nothing() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return S.Nothing;
        }
    }

    private static final class MessageName
    extends AbstractFunctionEvaluator
    implements ISetEvaluator {
        private MessageName() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            String str;
            if (!ast.arg1().isSymbol()) {
                LOGGER.log(engine.getLogLevel(), "{}: symbol expected at position 1 instead of {}", (Object)ast.topHead(), (Object)ast.arg1());
                return F.NIL;
            }
            if (ast.arg2().isString()) {
                return F.NIL;
            }
            IExpr arg2 = engine.evaluateNIL(ast.arg2());
            if (arg2.isString()) {
                return F.MessageName(ast.arg1(), arg2);
            }
            if (arg2.isPresent() && (str = Validate.checkMessageNameTag(arg2, ast, engine)) != null) {
                return F.MessageName(ast.arg1(), F.$str(str));
            }
            return F.NIL;
        }

        @Override
        public IExpr evaluateSet(IExpr leftHandSide, IExpr rightHandSide, IBuiltInSymbol builtinSymbol, EvalEngine engine) {
            ISymbol symbol;
            if (leftHandSide.isAST((IExpr)S.MessageName, 3, 4) && leftHandSide.first().isSymbol() && !(symbol = (ISymbol)leftHandSide.first()).isProtected()) {
                String messageName = leftHandSide.second().toString();
                IStringX message = (rightHandSide = engine.evaluate(rightHandSide)) instanceof IStringX ? (IStringX)rightHandSide : F.stringx(rightHandSide.toString());
                symbol.putMessage(1, messageName, message);
                if (builtinSymbol.equals(S.Set)) {
                    return message;
                }
                return S.Null;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Information
    extends AbstractCoreFunctionEvaluator {
        private Information() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 2 || ast.size() == 3) {
                try {
                    OptionArgs options;
                    boolean longForm = true;
                    if (ast.size() == 3 && (options = new OptionArgs(ast.topHead(), ast, 2, engine)).isFalse(S.LongForm)) {
                        longForm = false;
                    }
                    ISymbol symbol = null;
                    if (!ast.arg1().isSymbol()) {
                        IExpr arg1 = engine.evaluate(ast.arg1());
                        if (arg1.isEmptyList()) {
                            return arg1;
                        }
                        if (!arg1.isSymbol()) {
                            LOGGER.log(engine.getLogLevel(), "{}: symbol expected at position 1 instead of {}", (Object)ast.topHead(), (Object)arg1);
                            return F.NIL;
                        }
                        symbol = (ISymbol)arg1;
                    } else {
                        symbol = (ISymbol)ast.arg1();
                    }
                    PrintStream stream = engine.getOutPrintStream();
                    IExpr temp = symbol.evalMessage("usage");
                    if (temp.isPresent()) {
                        stream.println(temp.toString());
                    }
                    if (longForm) {
                        try {
                            Documentation.printDocumentation(stream, symbol.getSymbolName());
                            IAST function = F.Attributes(symbol);
                            temp = engine.evaluate(F.Attributes(symbol));
                            if (temp.isPresent()) {
                                stream.println(function.toString() + " = " + temp.toString());
                            }
                            stream.println(symbol.definitionToString());
                        }
                        catch (IOException ioe) {
                            LOGGER.debug("Information.evaluate() failed", (Throwable)ioe);
                        }
                    }
                    return S.Null;
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("Information.evaluate() failed", (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Identity
    extends AbstractCoreFunctionEvaluator {
        private Identity() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return ast.arg1();
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    @Deprecated
    private static final class Literal
    extends HoldPattern {
        private Literal() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1;
            if (ast.size() == 2 && (arg1 = ast.arg1()).isAST()) {
                IExpr temp = engine.evalHoldPattern((IAST)arg1, true, false);
                if (temp == arg1) {
                    return F.NIL;
                }
                return F.Literal(temp);
            }
            return F.NIL;
        }
    }

    private static class HoldPattern
    extends AbstractCoreFunctionEvaluator {
        private HoldPattern() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1;
            if (ast.size() == 2 && (arg1 = ast.arg1()).isAST()) {
                IExpr temp = engine.evalHoldPattern((IAST)arg1, true, false);
                if (temp == arg1) {
                    return F.NIL;
                }
                return F.HoldPattern(temp);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class HoldComplete
    extends AbstractCoreFunctionEvaluator {
        private HoldComplete() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262624);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }
    }

    private static final class Hold
    extends AbstractCoreFunctionEvaluator {
        private Hold() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return engine.evalUpRules(ast);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }
    }

    private static final class FilterRules
    extends AbstractFunctionEvaluator {
        private FilterRules() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isListOfRules()) {
                IAST listOfRules = (IAST)ast.arg1();
                if (ast.arg2().isList()) {
                    IAST list2 = (IAST)ast.arg2();
                    IASTAppendable result = F.ListAlloc(listOfRules.size());
                    block0: for (int i = 1; i < listOfRules.size(); ++i) {
                        IExpr listOfRulesArg = listOfRules.get(i);
                        if (!listOfRulesArg.isRuleAST()) continue;
                        IAST rule = (IAST)listOfRulesArg;
                        for (int j = 1; j < list2.size(); ++j) {
                            IExpr list2Arg = list2.get(j);
                            if (list2Arg.isRuleAST()) {
                                if (!rule.first().equals(list2Arg.first())) continue;
                                result.append(rule);
                                continue block0;
                            }
                            if (!rule.first().equals(list2Arg)) continue;
                            result.append(rule);
                            continue block0;
                        }
                    }
                    return result;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class Evaluate
    extends AbstractCoreFunctionEvaluator {
        private Evaluate() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 2) {
                return engine.evaluate(ast.arg1());
            }
            IASTMutable sequence = ast.copy();
            sequence.set(0, S.Identity);
            return engine.evaluate(sequence);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class DownValues
    extends AbstractCoreFunctionEvaluator {
        private DownValues() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = Validate.checkSymbolType(ast, 1, engine);
            if (arg1.isPresent()) {
                ISymbol symbol = (ISymbol)arg1;
                RulesData rulesData = symbol.getRulesData();
                if (rulesData == null) {
                    return F.CEmptyList;
                }
                return rulesData.downValues();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Definition
    extends AbstractCoreFunctionEvaluator {
        private Definition() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = Validate.checkSymbolType(ast, 1, engine);
            if (arg1.isPresent()) {
                ISymbol symbol = (ISymbol)arg1;
                try {
                    String definitionString;
                    if (symbol.equals(S.In)) {
                        IAST list = engine.getEvalHistory().definitionIn();
                        definitionString = Definition.definitionToString(S.In, list);
                    } else if (symbol.equals(S.Out)) {
                        IAST list = engine.getEvalHistory().definitionOut();
                        definitionString = Definition.definitionToString(S.Out, list);
                    } else {
                        definitionString = symbol.definitionToString();
                    }
                    return F.stringx(definitionString);
                }
                catch (IOException e) {
                    LOGGER.error("Definition.evaluate()", (Throwable)e);
                }
            }
            return S.Null;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }

        public static String definitionToString(ISymbol symbol, IAST list) {
            StringWriter buf = new StringWriter();
            IAST attributesList = AttributeFunctions.attributesList(symbol);
            if (attributesList.size() > 1) {
                buf.append("Attributes(");
                buf.append(symbol.toString());
                buf.append(")=");
                buf.append(attributesList.toString());
                buf.append("\n");
            }
            EvalEngine engine = EvalEngine.get();
            OutputFormFactory off = OutputFormFactory.get(engine.isRelaxedSyntax());
            off.setIgnoreNewLine(true);
            for (int i = 1; i < list.size(); ++i) {
                if (!off.convert(buf, list.get(i))) {
                    return "ERROR-IN-OUTPUTFORM";
                }
                if (i >= list.size() - 1) continue;
                buf.append("\n");
                off.setColumnCounter(0);
            }
            return buf.toString();
        }
    }

    private static final class Default
    extends AbstractFunctionEvaluator
    implements ISetEvaluator {
        private Default() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = Validate.checkSymbolType(ast, 1, engine);
            if (arg1.isPresent()) {
                ISymbol symbol = (ISymbol)arg1;
                if (ast.size() > 2) {
                    int pos = ast.arg2().toIntDefault();
                    if (pos > 0) {
                        return symbol.getDefaultValue(pos);
                    }
                } else {
                    return symbol.getDefaultValue();
                }
            }
            return F.NIL;
        }

        @Override
        public IExpr evaluateSet(IExpr leftHandSide, IExpr rightHandSide, IBuiltInSymbol builtinSymbol, EvalEngine engine) {
            if (leftHandSide.isAST(S.Default) && leftHandSide.size() > 1) {
                int pos;
                if (!leftHandSide.first().isSymbol()) {
                    IOFunctions.printMessage(builtinSymbol, "setps", F.list(leftHandSide.first()), engine);
                    return rightHandSide;
                }
                ISymbol symbol = (ISymbol)leftHandSide.first();
                if (symbol.isProtected()) {
                    IOFunctions.printMessage(S.Default, "write", F.list(symbol, leftHandSide), EvalEngine.get());
                    throw new FailedException();
                }
                if (leftHandSide.size() == 2 && leftHandSide.first().isSymbol()) {
                    symbol.setDefaultValue(rightHandSide);
                    return rightHandSide;
                }
                if (leftHandSide.size() == 3 && leftHandSide.first().isSymbol() && (pos = leftHandSide.second().toIntDefault()) > 1) {
                    symbol.setDefaultValue(rightHandSide);
                    return rightHandSide;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Context
    extends AbstractCoreFunctionEvaluator {
        private Context() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                IExpr x = Validate.checkIdentifierHoldPattern(ast.arg1(), ast, engine);
                if (!x.isPresent()) {
                    return F.NIL;
                }
                return F.stringx(((ISymbol)x).getContext().getContextName());
            }
            if (ast.isAST0()) {
                return F.stringx(EvalEngine.get().getContext().completeContextName());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class ClearAll
    extends AbstractCoreFunctionEvaluator {
        private ClearAll() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IASTMutable mutable = ast.copyAST();
            for (int i = 1; i < ast.size(); ++i) {
                IExpr x2 = Validate.checkIdentifierHoldPattern(ast.get(i), ast, engine);
                if (!x2.isPresent()) {
                    return F.NIL;
                }
                if (((ISymbol)x2).isProtected()) {
                    IOFunctions.printMessage(ast.topHead(), "wrsym", F.list(x2), engine);
                    return S.Null;
                }
                mutable.set(i, x2);
            }
            Lambda.forEach(mutable, x -> x.isSymbol(), x -> ((ISymbol)x).clearAll(engine));
            return S.Null;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Clear
    extends AbstractCoreFunctionEvaluator {
        private Clear() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IASTMutable mutable = ast.copyAST();
            for (int i = 1; i < ast.size(); ++i) {
                IExpr x2 = Validate.checkIdentifierHoldPattern(ast.get(i), ast, engine);
                if (!x2.isPresent()) {
                    return F.NIL;
                }
                if (((ISymbol)x2).isProtected()) {
                    IOFunctions.printMessage(ast.topHead(), "wrsym", F.list(x2), engine);
                    return S.Null;
                }
                mutable.set(i, x2);
            }
            Lambda.forEach(ast, x -> x.isSymbol(), x -> ((ISymbol)x).clear(engine));
            return S.Null;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    public static final class BlankNullSequence
    extends AbstractCoreFunctionEvaluator {
        public static final BlankNullSequence CONST = new BlankNullSequence();

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head().equals(S.BlankNullSequence)) {
                if (ast.isAST0()) {
                    return F.$ps((ISymbol)null, true);
                }
                if (ast.isAST1() && ast.arg1().isSymbol()) {
                    return F.$ps((ISymbol)ast.arg1(), true);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    public static final class BlankSequence
    extends AbstractCoreFunctionEvaluator {
        public static final BlankSequence CONST = new BlankSequence();

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head().equals(S.BlankSequence)) {
                if (ast.isAST0()) {
                    return F.$ps((ISymbol)null);
                }
                if (ast.isAST1() && ast.arg1().isSymbol()) {
                    return F.$ps((ISymbol)ast.arg1());
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    public static final class Blank
    extends AbstractCoreFunctionEvaluator {
        public static final Blank CONST = new Blank();

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head().equals(S.Blank)) {
                if (ast.isAST0()) {
                    return F.$b();
                }
                if (ast.isAST1()) {
                    return F.$b(ast.arg1());
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Default.setEvaluator(new Default());
            S.Evaluate.setEvaluator(new Evaluate());
            S.FilterRules.setEvaluator(new FilterRules());
            S.Hold.setEvaluator(new Hold());
            S.HoldComplete.setEvaluator(new HoldComplete());
            S.HoldPattern.setEvaluator(new HoldPattern());
            S.Identity.setEvaluator(new Identity());
            S.Information.setEvaluator(new Information());
            S.Literal.setEvaluator(new Literal());
            S.MessageName.setEvaluator(new MessageName());
            S.Nothing.setEvaluator(new Nothing());
            S.Optional.setEvaluator(Optional.CONST);
            S.Options.setEvaluator(new Options());
            S.OptionValue.setEvaluator(new OptionValue());
            S.ReleaseHold.setEvaluator(new ReleaseHold());
            S.Rule.setEvaluator(new Rule());
            S.RuleDelayed.setEvaluator(new RuleDelayed());
            S.Sequence.setEvaluator(new Sequence());
            S.Set.setEvaluator(new Set());
            S.SetDelayed.setEvaluator(new SetDelayed());
            S.SetSystemOptions.setEvaluator(new SetSystemOptions());
            S.SystemOptions.setEvaluator(new SystemOptions());
            S.Unique.setEvaluator(new Unique());
            if (!Config.FUZZY_PARSER) {
                S.Blank.setEvaluator(Blank.CONST);
                S.BlankSequence.setEvaluator(BlankSequence.CONST);
                S.BlankNullSequence.setEvaluator(BlankNullSequence.CONST);
                S.DownValues.setEvaluator(new DownValues());
                S.Pattern.setEvaluator(Pattern.CONST);
                S.PatternTest.setEvaluator(new PatternTest());
                S.Clear.setEvaluator(new Clear());
                S.ClearAll.setEvaluator(new ClearAll());
                S.Context.setEvaluator(new Context());
                S.Definition.setEvaluator(new Definition());
                S.OptionsPattern.setEvaluator(OptionsPattern.CONST);
                S.OwnValues.setEvaluator(new OwnValues());
                S.Repeated.setEvaluator(Repeated.CONST);
                S.RepeatedNull.setEvaluator(RepeatedNull.CONST);
                S.TagSet.setEvaluator(new TagSet());
                S.TagSetDelayed.setEvaluator(new TagSetDelayed());
                S.Unset.setEvaluator(new Unset());
                S.UpSet.setEvaluator(new UpSet());
                S.UpSetDelayed.setEvaluator(new UpSetDelayed());
                S.UpValues.setEvaluator(new UpValues());
            }
        }
    }
}

