/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import com.baeldung.algorithms.romannumerals.RomanArabicConverter;
import com.ibm.icu.text.RuleBasedNumberFormat;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldVector;
import org.matheclipse.core.builtin.GraphFunctions;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.StringFunctions;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.MathMLUtilities;
import org.matheclipse.core.eval.TeXUtilities;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionOptionEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.Blank;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.GraphExpr;
import org.matheclipse.core.form.output.JavaComplexFormFactory;
import org.matheclipse.core.form.output.JavaDoubleFormFactory;
import org.matheclipse.core.form.output.JavaScriptFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTDataset;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.HornerScheme;

public final class OutputFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IAST[] checkIsVariableOrVariableList(IAST ast, EvalEngine engine) {
        IAST[] result = new IASTMutable[2];
        IExpr arg1 = ast.arg1();
        if (arg1.isList()) {
            IAST list = (IAST)arg1;
            result[0] = list.copy();
            result[1] = F.constantArray(S.Real, list.argSize());
            for (int i = 1; i < list.size(); ++i) {
                if (OutputFunctions.checkVariable(list.get(i), i, (IASTMutable)result[0], (IASTMutable)result[1], engine)) continue;
                IOFunctions.printMessage(ast.topHead(), "ivar", F.list(list.get(i)), engine);
                return null;
            }
        } else {
            result[0] = F.unaryAST1(S.List, arg1);
            result[1] = F.unaryAST1(S.List, S.Real);
            if (!OutputFunctions.checkVariable(arg1, 1, result[0], result[1], engine)) {
                IOFunctions.printMessage(ast.topHead(), "ivar", F.list(arg1), engine);
                return null;
            }
        }
        return result;
    }

    private static boolean checkVariable(IExpr arg, int variablesIndex, IASTMutable variables, IASTMutable types, EvalEngine engine) {
        IExpr sym = arg;
        IExpr headTest = S.Real;
        if (arg.isList1() || arg.isList2()) {
            sym = arg.first();
            if (arg.isList2()) {
                headTest = null;
                if (arg.second().isBlank()) {
                    Blank blank = (Blank)arg.second();
                    headTest = blank.getHeadTest();
                    if (headTest == null) {
                        return false;
                    }
                    if (!(headTest.equals(S.Integer) || headTest.equals(S.Complex) || headTest.equals(S.Real))) {
                        headTest = null;
                    }
                }
                if (headTest == null) {
                    return false;
                }
            }
        }
        variables.set(variablesIndex, sym);
        types.set(variablesIndex, headTest);
        return true;
    }

    public static void initialize() {
        Initializer.init();
    }

    public static boolean markdownTable(StringBuilder result, IExpr expr, Function<IExpr, String> function, boolean fillUpWithSPACE) {
        int[] dim = expr.isMatrix();
        if (dim != null && dim[0] > 0 && dim[1] > 0) {
            int i;
            int j;
            IAST matrix = (IAST)expr;
            int rowDimension = dim[0];
            int columnDimension = dim[1];
            String[][] texts = new String[rowDimension][columnDimension];
            for (int i2 = 0; i2 < rowDimension; ++i2) {
                for (j = 0; j < columnDimension; ++j) {
                    String str;
                    texts[i2][j] = str = function.apply(matrix.getPart(i2 + 1, j + 1));
                }
            }
            StringBuilder[] sb = new StringBuilder[rowDimension];
            for (j = 0; j < rowDimension; ++j) {
                sb[j] = new StringBuilder();
            }
            int rowLength = 0;
            for (i = 0; i < columnDimension; ++i) {
                int j2;
                int columnLength = 0;
                for (j2 = 0; j2 < rowDimension; ++j2) {
                    String str = texts[j2][i];
                    if (str.length() > columnLength) {
                        columnLength = str.length();
                    }
                    sb[j2].append('|');
                    sb[j2].append(str);
                }
                rowLength = i < columnDimension - 1 ? (rowLength += columnLength + 1) : (rowLength += columnLength);
                if (!fillUpWithSPACE) continue;
                for (j2 = 0; j2 < rowDimension; ++j2) {
                    int rest = rowLength - sb[j2].length();
                    for (int k = 0; k < rest; ++k) {
                        sb[j2].append(' ');
                    }
                }
            }
            for (i = 0; i < rowDimension; ++i) {
                result.append((CharSequence)sb[i]);
                result.append("|");
                if (i >= rowDimension - 1) continue;
                result.append("\n");
            }
            return true;
        }
        return false;
    }

    public static boolean plaintextTable(StringBuilder result, IExpr expr, String delimiter, Function<IExpr, String> function, boolean fillUpWithSPACE) {
        int[] dim = expr.isMatrix();
        if (dim != null && dim[0] > 0 && dim[1] > 0) {
            int j;
            int columnLength;
            int i;
            int rowLength;
            FieldMatrix<IExpr> matrix;
            int rowDimension = dim[0];
            int columnDimension = dim[1];
            StringBuilder[] sb = new StringBuilder[rowDimension];
            for (int j2 = 0; j2 < rowDimension; ++j2) {
                sb[j2] = new StringBuilder();
            }
            if (expr.isAST()) {
                matrix = (FieldMatrix<IExpr>)expr;
                rowLength = 0;
                for (i = 0; i < columnDimension; ++i) {
                    columnLength = 0;
                    for (j = 0; j < rowDimension; ++j) {
                        String str = function.apply(matrix.getPart(new int[]{j + 1, i + 1}));
                        if (str.length() > columnLength) {
                            columnLength = str.length();
                        }
                        sb[j].append(str);
                        if (i >= columnDimension - 1) continue;
                        sb[j].append(delimiter);
                    }
                    rowLength = i < columnDimension - 1 ? (rowLength += columnLength + 1) : (rowLength += columnLength);
                    if (!fillUpWithSPACE) continue;
                    for (j = 0; j < rowDimension; ++j) {
                        int rest = rowLength - sb[j].length();
                        for (int k = 0; k < rest; ++k) {
                            sb[j].append(' ');
                        }
                    }
                }
            } else {
                matrix = Convert.list2Matrix(expr);
                rowLength = 0;
                if (matrix == null) {
                    return false;
                }
                for (i = 0; i < columnDimension; ++i) {
                    columnLength = 0;
                    for (j = 0; j < rowDimension; ++j) {
                        IExpr arg = (IExpr)matrix.getEntry(j, i);
                        String str = function.apply(arg);
                        if (str.length() > columnLength) {
                            columnLength = str.length();
                        }
                        sb[j].append(str);
                        if (i >= columnDimension - 1) continue;
                        sb[j].append(delimiter);
                    }
                    rowLength = i < columnDimension - 1 ? (rowLength += columnLength + 1) : (rowLength += columnLength);
                    if (!fillUpWithSPACE) continue;
                    for (j = 0; j < rowDimension; ++j) {
                        int rest = rowLength - sb[j].length();
                        for (int k = 0; k < rest; ++k) {
                            sb[j].append(' ');
                        }
                    }
                }
            }
            for (int i2 = 0; i2 < rowDimension; ++i2) {
                result.append((CharSequence)sb[i2]);
                if (i2 >= rowDimension - 1) continue;
                result.append("\n");
            }
            return true;
        }
        return false;
    }

    public static String toJavaDouble(IExpr arg1) {
        JavaDoubleFormFactory factory = JavaDoubleFormFactory.get(true, false);
        StringBuilder buf = new StringBuilder();
        factory.convert(buf, arg1);
        return buf.toString();
    }

    public static String toJavaComplex(IExpr arg1) {
        JavaComplexFormFactory factory = JavaComplexFormFactory.get(true, false);
        StringBuilder buf = new StringBuilder();
        factory.convert(buf, arg1);
        return buf.toString();
    }

    public static String toJavaScript(IExpr arg1, int javascriptFlavor) {
        JavaScriptFormFactory factory = new JavaScriptFormFactory(true, false, -1, -1, javascriptFlavor);
        StringBuilder buf = new StringBuilder();
        factory.convert(buf, arg1);
        return buf.toString();
    }

    private OutputFunctions() {
    }

    public static class VariableManager
    implements Function<IExpr, String> {
        ArrayDeque<Map<IExpr, String>> varStack = new ArrayDeque();

        public void put(IExpr key, String variable) {
            this.varStack.peek().put(key, variable);
        }

        public Map<IExpr, String> peek() {
            return this.varStack.peek();
        }

        public void push() {
            HashMap map = new HashMap();
            this.varStack.push(map);
        }

        public void push(Map<IExpr, String> map) {
            this.varStack.push(map);
        }

        public Map<IExpr, String> pop() {
            return this.varStack.pop();
        }

        public VariableManager(Map<IExpr, String> map) {
            this.varStack.add(map);
        }

        @Override
        public String apply(IExpr expr) {
            Iterator<Map<IExpr, String>> iterator = this.varStack.descendingIterator();
            while (iterator.hasNext()) {
                Map<IExpr, String> map = iterator.next();
                String temp = map.get(expr);
                if (temp == null) continue;
                return temp;
            }
            return null;
        }
    }

    private static class TreeForm
    extends AbstractCoreFunctionEvaluator {
        private TreeForm() {
        }

        private static void edgesToVisjs(StringBuilder buf, List<AbstractMap.SimpleImmutableEntry<Integer, Integer>> edgeSet) {
            boolean first = true;
            buf.append("var edges = new vis.DataSet([\n");
            for (AbstractMap.SimpleImmutableEntry<Integer, Integer> edge : edgeSet) {
                if (first) {
                    buf.append("  {from: ");
                } else {
                    buf.append(", {from: ");
                }
                buf.append(edge.getKey());
                buf.append(", to: ");
                buf.append(edge.getValue());
                buf.append(" , arrows: { to: { enabled: true, type: 'arrow'}}");
                buf.append("}\n");
                first = false;
            }
            buf.append("]);\n");
        }

        private static void treeToGraph(IAST tree, int level, int maxLevel, int[] currentCount, List<AbstractMap.SimpleImmutableEntry<String, Integer>> vertexList, List<AbstractMap.SimpleImmutableEntry<Integer, Integer>> edgeList) {
            vertexList.add(new AbstractMap.SimpleImmutableEntry<String, Integer>(tree.head().toString(), level));
            int currentNode = vertexList.size();
            int nextLevel = level + 1;
            for (int i = 1; i < tree.size(); ++i) {
                currentCount[0] = currentCount[0] + 1;
                edgeList.add(new AbstractMap.SimpleImmutableEntry<Integer, Integer>(currentNode, currentCount[0]));
                IExpr arg = tree.get(i);
                if (nextLevel >= maxLevel || !arg.isAST()) {
                    vertexList.add(new AbstractMap.SimpleImmutableEntry<String, Integer>(arg.toString(), nextLevel));
                    continue;
                }
                TreeForm.treeToGraph((IAST)arg, nextLevel, maxLevel, currentCount, vertexList, edgeList);
            }
        }

        private static void vertexToVisjs(StringBuilder buf, List<AbstractMap.SimpleImmutableEntry<String, Integer>> vertexSet) {
            buf.append("var nodes = new vis.DataSet([\n");
            boolean first = true;
            int counter = 1;
            for (AbstractMap.SimpleImmutableEntry<String, Integer> expr : vertexSet) {
                if (first) {
                    buf.append("  {id: ");
                } else {
                    buf.append(", {id: ");
                }
                buf.append(counter++);
                buf.append(", label: '");
                buf.append(expr.getKey().toString());
                buf.append("', level: ");
                buf.append(expr.getValue().toString());
                buf.append("}\n");
                first = false;
            }
            buf.append("]);\n");
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                int maxLevel = Integer.MAX_VALUE;
                if (ast.isAST2() && (maxLevel = ast.arg2().toIntDefault()) < 0) {
                    return F.NIL;
                }
                IExpr arg1 = engine.evaluate(ast.arg1());
                ArrayList<AbstractMap.SimpleImmutableEntry<String, Integer>> vertexList = new ArrayList<AbstractMap.SimpleImmutableEntry<String, Integer>>();
                ArrayList<AbstractMap.SimpleImmutableEntry<Integer, Integer>> edgeList = new ArrayList<AbstractMap.SimpleImmutableEntry<Integer, Integer>>();
                StringBuilder jsControl = new StringBuilder();
                if (maxLevel > 0 && arg1.isAST()) {
                    IAST tree = (IAST)arg1;
                    int[] currentCount = new int[]{1};
                    TreeForm.treeToGraph(tree, 0, maxLevel, currentCount, vertexList, edgeList);
                    TreeForm.vertexToVisjs(jsControl, vertexList);
                    TreeForm.edgesToVisjs(jsControl, edgeList);
                    return F.JSFormData(jsControl.toString(), "treeform");
                }
                vertexList.add(new AbstractMap.SimpleImmutableEntry<String, Integer>(arg1.toString(), 0));
                TreeForm.vertexToVisjs(jsControl, vertexList);
                TreeForm.edgesToVisjs(jsControl, edgeList);
                return F.JSFormData(jsControl.toString(), "treeform");
            }
            catch (Exception rex) {
                LOGGER.log(engine.getLogLevel(), "TreeForm", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class TeXForm
    extends AbstractCoreFunctionEvaluator {
        private TeXForm() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            TeXUtilities texUtil = new TeXUtilities(engine, engine.isRelaxedSyntax());
            IExpr arg1 = engine.evaluate(ast.arg1());
            StringWriter stw = new StringWriter();
            texUtil.toTeX(arg1, stw);
            return F.$str(stw.toString(), (short)4);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class TableForm
    extends AbstractFunctionOptionEvaluator {
        private TableForm() {
        }

        @Override
        public IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            if (argSize >= 1) {
                FieldVector<IExpr> vector;
                IExpr tableHeadings = option[0];
                StringBuilder tableForm = new StringBuilder();
                IExpr arg1 = ast.arg1();
                if (OutputFunctions.plaintextTable(tableForm, arg1, " ", x -> x.toString(), true)) {
                    return F.stringx(tableForm.toString(), (short)1);
                }
                if (arg1.isList()) {
                    IAST list = (IAST)arg1;
                    StringBuilder sb = new StringBuilder();
                    for (int i = 1; i < list.size(); ++i) {
                        sb.append(list.get(i).toString());
                        sb.append("\n");
                    }
                    return F.stringx(sb.toString(), (short)1);
                }
                int dim = arg1.isVector();
                if (dim >= 0 && (vector = Convert.list2Vector(arg1)) != null) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < dim; ++i) {
                        sb.append(((IExpr)vector.getEntry(i)).toString());
                        sb.append("\n");
                    }
                    return F.stringx(sb.toString(), (short)1);
                }
                return F.stringx(arg1.toString(), (short)1);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            IBuiltInSymbol[] lhsOptionSymbols = new IBuiltInSymbol[]{S.TableAlignments, S.TableDepth, S.TableDirections, S.TableHeadings, S.TableSpacing};
            IExpr[] rhsValues = new IExpr[]{S.Automatic, F.CInfinity, S.Column, S.None, S.Automatic};
            this.setOptions(newSymbol, lhsOptionSymbols, rhsValues);
        }
    }

    private static class RomanNumeral
    extends AbstractFunctionEvaluator {
        private RomanNumeral() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            if (arg1.isInteger()) {
                try {
                    int value = arg1.toIntDefault();
                    if (value < 0 || value > 4000) {
                        return IOFunctions.printMessage(ast.topHead(), "intrange", F.List(F.ZZ(0), F.ZZ(4000)), engine);
                    }
                    String result = RomanArabicConverter.arabicToRoman((int)value);
                    return F.stringx(result);
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("RomanNumeral.evaluate() failed", (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class MathMLForm
    extends AbstractCoreFunctionEvaluator {
        private MathMLForm() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            MathMLUtilities mathMLUtil = new MathMLUtilities(engine, false, engine.isRelaxedSyntax());
            IExpr arg1 = ast.arg1();
            StringWriter stw = new StringWriter();
            mathMLUtil.toMathML(arg1, (Writer)stw);
            return F.stringx(stw.toString(), (short)3);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class JSForm
    extends AbstractCoreFunctionEvaluator {
        private JSForm() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IExpr arg1;
                int javascriptFlavor = 1;
                if (ast.isAST2() && ast.arg2().isStringIgnoreCase("mathcell")) {
                    javascriptFlavor = 2;
                }
                if ((arg1 = engine.evaluate(ast.arg1())).isAST(S.JSFormData, 3)) {
                    String manipulateStr = ((IAST)arg1).arg1().toString();
                    return F.$str(manipulateStr, (short)7);
                }
                if (arg1.isDataset()) {
                    return F.$str(((IASTDataset)arg1).datasetToJSForm(), (short)2);
                }
                if (arg1 instanceof GraphExpr) {
                    return F.$str(GraphFunctions.graphToJSForm((GraphExpr)arg1), (short)7);
                }
                return F.$str(OutputFunctions.toJavaScript(arg1, javascriptFlavor), (short)7);
            }
            catch (Exception rex) {
                LOGGER.log(engine.getLogLevel(), "JSForm", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class JavaForm
    extends AbstractCoreFunctionEvaluator {
        private JavaForm() {
        }

        public static CharSequence javaForm(IExpr arg1, boolean strictJava, boolean usePrefix) {
            IExpr.SourceCodeProperties p = IExpr.SourceCodeProperties.of(strictJava, false, usePrefix ? IExpr.SourceCodeProperties.Prefix.CLASS_NAME : IExpr.SourceCodeProperties.Prefix.NONE, false);
            return arg1.internalJavaString(p, 0, x -> null);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IExpr newExpr;
                IExpr optimized;
                IExpr arg1 = engine.evaluate(ast.arg1());
                boolean floatJava = false;
                boolean complexJava = false;
                boolean strictJava = false;
                boolean usePrefix = false;
                if (ast.isAST2()) {
                    IExpr arg2 = engine.evaluate(ast.arg2());
                    if (arg2 == S.Float || arg2 == S.Real) {
                        floatJava = true;
                    } else if (arg2 == S.Complex) {
                        complexJava = true;
                    } else if (arg2 == S.Strict) {
                        strictJava = true;
                    } else if (arg2 == S.Prefix) {
                        usePrefix = true;
                    } else {
                        OptionArgs options = new OptionArgs(ast.topHead(), arg2, engine);
                        floatJava = options.isTrue(S.Float);
                        strictJava = options.isTrue(S.Strict);
                        usePrefix = options.isTrue(S.Prefix);
                    }
                }
                if (floatJava) {
                    optimized = S.OptimizeExpression.of(engine, arg1);
                    if (optimized.isList2() && optimized.second().isListOfRules()) {
                        int i;
                        newExpr = optimized.first();
                        IAST listOfRules = (IAST)optimized.second();
                        VariablesSet varSet = new VariablesSet(arg1);
                        List<IExpr> functionsParameters = varSet.getArrayList();
                        StringBuilder buf = new StringBuilder();
                        long functionCounter = EvalEngine.incModuleCounter();
                        buf.append("double f");
                        buf.append(functionCounter);
                        buf.append("(");
                        for (i = 0; i < functionsParameters.size(); ++i) {
                            buf.append("double ");
                            buf.append(functionsParameters.get(i));
                            if (i >= functionsParameters.size() - 1) continue;
                            buf.append(", ");
                        }
                        buf.append(") {\n");
                        for (i = 1; i < listOfRules.size(); ++i) {
                            IAST rule = (IAST)listOfRules.get(i);
                            buf.append("double ");
                            buf.append(OutputFunctions.toJavaDouble(rule.first()));
                            buf.append(" = ");
                            buf.append(OutputFunctions.toJavaDouble(rule.second()));
                            buf.append(";\n");
                        }
                        buf.append("return ");
                        buf.append(OutputFunctions.toJavaDouble(newExpr));
                        buf.append(";\n");
                        buf.append("}\n");
                        return F.$str(buf.toString(), (short)6);
                    }
                    return F.$str(OutputFunctions.toJavaDouble(arg1), (short)6);
                }
                if (complexJava) {
                    optimized = S.OptimizeExpression.of(engine, arg1);
                    if (optimized.isList2() && optimized.second().isListOfRules()) {
                        int i;
                        newExpr = optimized.first();
                        IAST listOfRules = (IAST)optimized.second();
                        VariablesSet varSet = new VariablesSet(arg1);
                        List<IExpr> functionsParameters = varSet.getArrayList();
                        StringBuilder buf = new StringBuilder();
                        long functionCounter = EvalEngine.incModuleCounter();
                        buf.append("Complex f");
                        buf.append(functionCounter);
                        buf.append("(");
                        for (i = 0; i < functionsParameters.size(); ++i) {
                            buf.append("Complex ");
                            buf.append(functionsParameters.get(i));
                            if (i >= functionsParameters.size() - 1) continue;
                            buf.append(", ");
                        }
                        buf.append(") {\n");
                        for (i = 1; i < listOfRules.size(); ++i) {
                            IAST rule = (IAST)listOfRules.get(i);
                            buf.append("Complex ");
                            buf.append(OutputFunctions.toJavaComplex(rule.first()));
                            buf.append(" = ");
                            buf.append(OutputFunctions.toJavaComplex(rule.second()));
                            buf.append(";\n");
                        }
                        buf.append("return ");
                        buf.append(OutputFunctions.toJavaComplex(newExpr));
                        buf.append(";\n");
                        buf.append("}\n");
                        return F.$str(buf.toString(), (short)6);
                    }
                    return F.$str(OutputFunctions.toJavaComplex(arg1), (short)6);
                }
                String resultStr = JavaForm.javaForm(arg1, strictJava, usePrefix).toString();
                return F.$str(resultStr, (short)6);
            }
            catch (Exception rex) {
                LOGGER.log(engine.getLogLevel(), "JavaForm", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class IntegerName
    extends AbstractFunctionEvaluator {
        private IntegerName() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.arg1().isList()) {
                return ((IAST)ast.arg1()).mapThread(ast, 1);
            }
            if (arg1.isInteger()) {
                RuleBasedNumberFormat formatter = null;
                try {
                    String textNumber;
                    long value = ((IInteger)arg1).toLong();
                    if (value != Integer.MIN_VALUE && ast.isAST1() && (textNumber = (formatter = new RuleBasedNumberFormat(1)).format(value)) != null) {
                        return F.stringx(textNumber);
                    }
                    IStringX language = F.stringx("English");
                    IStringX qual = F.stringx("Words");
                    if (ast.isAST2()) {
                        if (!ast.arg2().isString()) {
                            return F.NIL;
                        }
                        IStringX arg2 = (IStringX)ast.arg2();
                        if (arg2.isString("Dutch") || arg2.isString("Finnish") || arg2.isString("English") || arg2.isString("Esperanto") || arg2.isString("French") || arg2.isString("German") || arg2.isString("Hungarian") || arg2.isString("Italian") || arg2.isString("Latin") || arg2.isString("Polish") || arg2.isString("Portuguese") || arg2.isString("Romanian") || arg2.isString("Russian") || arg2.isString("Spanish") || arg2.isString("Swedish") || arg2.isString("Tongan") || arg2.isString("Turkish")) {
                            language = arg2;
                        } else {
                            qual = arg2;
                        }
                    }
                    if (qual.isString("Words")) {
                        String textNumber2;
                        if (language.isString("Dutch")) {
                            formatter = new RuleBasedNumberFormat(new Locale("nl"), 1);
                        } else if (language.isString("English")) {
                            formatter = new RuleBasedNumberFormat(Locale.ENGLISH, 1);
                        } else if (language.isString("Esperanto")) {
                            formatter = new RuleBasedNumberFormat(new Locale("eo"), 1);
                        } else if (language.isString("Finnish")) {
                            formatter = new RuleBasedNumberFormat(new Locale("fi"), 1);
                        } else if (language.isString("French")) {
                            formatter = new RuleBasedNumberFormat(Locale.FRENCH, 1);
                        } else if (language.isString("German")) {
                            formatter = new RuleBasedNumberFormat(Locale.GERMAN, 1);
                        } else if (language.isString("Hungarian")) {
                            formatter = new RuleBasedNumberFormat(new Locale("hu"), 1);
                        } else if (language.isString("Italian")) {
                            formatter = new RuleBasedNumberFormat(Locale.ITALIAN, 1);
                        } else if (language.isString("Latin")) {
                            formatter = new RuleBasedNumberFormat(new Locale("vai"), 1);
                        } else if (language.isString("Polish")) {
                            formatter = new RuleBasedNumberFormat(new Locale("pl"), 1);
                        } else if (language.isString("Portuguese")) {
                            formatter = new RuleBasedNumberFormat(new Locale("pt"), 1);
                        } else if (language.isString("Romanian")) {
                            formatter = new RuleBasedNumberFormat(new Locale("ro"), 1);
                        } else if (language.isString("Russian")) {
                            formatter = new RuleBasedNumberFormat(new Locale("ru"), 1);
                        } else if (language.isString("Spanish")) {
                            formatter = new RuleBasedNumberFormat(new Locale("es"), 1);
                        } else if (language.isString("Swedish")) {
                            formatter = new RuleBasedNumberFormat(new Locale("sv"), 1);
                        } else if (language.isString("Tongan")) {
                            formatter = new RuleBasedNumberFormat(new Locale("sv"), 1);
                        } else if (language.isString("Turkish")) {
                            formatter = new RuleBasedNumberFormat(new Locale("tr"), 1);
                        }
                        if (formatter != null && (textNumber2 = formatter.format(value)) != null) {
                            return F.stringx(textNumber2);
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("IntegerName.evaluate() failed", (Throwable)ex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class InputForm
    extends AbstractCoreFunctionEvaluator {
        private InputForm() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                return F.stringx(StringFunctions.inputForm(arg1), (short)5);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class HornerForm
    extends AbstractFunctionEvaluator {
        private HornerForm() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isAST()) {
                IAST variables;
                IAST poly = (IAST)arg1;
                if (ast.isAST2()) {
                    variables = Validate.checkIsVariableOrVariableList(ast, 2, ast.topHead(), engine);
                } else {
                    VariablesSet eVar = new VariablesSet(ast.arg1());
                    variables = eVar.getVarList();
                }
                if (variables.isPresent() && variables.size() >= 2 && poly.isPlus()) {
                    HornerScheme scheme = new HornerScheme();
                    return scheme.generate(engine.isNumericMode(), poly, variables.arg1());
                }
            }
            return arg1;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class HoldForm
    extends AbstractCoreFunctionEvaluator {
        private HoldForm() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class FullForm
    extends AbstractCoreFunctionEvaluator {
        private FullForm() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            String fullForm = engine.evaluate(ast.arg1()).fullFormString();
            return F.stringx(fullForm, (short)5);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class CForm
    extends AbstractCoreFunctionEvaluator {
        private CForm() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class BaseForm
    extends AbstractCoreFunctionEvaluator {
        private BaseForm() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int base;
            IExpr arg1 = engine.evaluate(ast.arg1());
            IExpr arg2 = engine.evaluate(ast.arg2());
            if (arg1.isInteger() && arg2.isInteger() && (base = arg2.toIntDefault()) > 0 && base <= 36) {
                BigInteger big = ((IInteger)arg1).toBigNumerator();
                String str = big.toString(base);
                return F.Subscript(F.$str(str), arg2);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.BaseForm.setEvaluator(new BaseForm());
            S.CForm.setEvaluator(new CForm());
            S.FullForm.setEvaluator(new FullForm());
            S.HoldForm.setEvaluator(new HoldForm());
            S.HornerForm.setEvaluator(new HornerForm());
            S.InputForm.setEvaluator(new InputForm());
            S.IntegerName.setEvaluator(new IntegerName());
            S.JavaForm.setEvaluator(new JavaForm());
            S.JSForm.setEvaluator(new JSForm());
            S.MathMLForm.setEvaluator(new MathMLForm());
            S.RomanNumeral.setEvaluator(new RomanNumeral());
            S.TableForm.setEvaluator(new TableForm());
            S.TeXForm.setEvaluator(new TeXForm());
            S.TreeForm.setEvaluator(new TreeForm());
        }
    }
}

