/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import com.google.common.math.BigIntegerMath;
import com.google.common.math.LongMath;
import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.FixedPrecisionApfloatHelper;
import org.hipparchus.complex.Complex;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.special.Gamma;
import org.hipparchus.util.CombinatoricsUtils;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Arithmetic;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.BigIntegerLimitExceeded;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.exception.PolynomialDegreeLimitExceeded;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractArg2;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.util.AbstractAssumptions;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.AbstractFractionSym;
import org.matheclipse.core.expression.AbstractIntegerSym;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.FractionSym;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.numbertheory.GaussianInteger;
import org.matheclipse.core.numbertheory.Primality;
import org.matheclipse.core.visit.VisitorExpr;

public final class NumberTheory {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int[] FIBONACCI_45 = new int[]{0, 1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946, 17711, 28657, 46368, 75025, 121393, 196418, 317811, 514229, 832040, 1346269, 2178309, 3524578, 5702887, 0x8CCCC9, 14930352, 24157817, 39088169, 63245986, 102334155, 165580141, 267914296, 433494437, 701408733, 1134903170};
    private static final long[] BELLB_25 = new long[]{1L, 1L, 2L, 5L, 15L, 52L, 203L, 877L, 4140L, 21147L, 115975L, 678570L, 4213597L, 27644437L, 190899322L, 1382958545L, 10480142147L, 82864869804L, 682076806159L, 5832742205057L, 51724158235372L, 474869816156751L, 4506715738447323L, 44152005855084346L, 445958869294805289L, 4638590332229999353L};
    private static final long[] PN_8 = new long[]{6L, 28L, 496L, 8128L, 0x1FFF000L, 0x1FFFF0000L, 137438691328L, 2305843008139952128L};
    private static final int[] MPE_47 = new int[]{2, 3, 5, 7, 13, 17, 19, 31, 61, 89, 107, 127, 521, 607, 1279, 2203, 2281, 3217, 4253, 4423, 9689, 9941, 11213, 19937, 21701, 23209, 44497, 86243, 110503, 132049, 216091, 756839, 859433, 0x13313B, 1398269, 2976221, 3021377, 6972593, 13466917, 20996011, 24036583, 25964951, 30402457, 32582657, 37156667, 42643801, 43112609};

    public static IInteger factorial(IInteger x) {
        return x.factorial();
    }

    public static boolean check(IExpr n, IExpr k, IExpr delta, EvalEngine engine) {
        return engine.evalEqual(n, k.plus(delta));
    }

    public static IInteger factorial(int ni) {
        BigInteger result;
        if (ni < 0) {
            int positiveN = -1 * ni;
            int iterationLimit = EvalEngine.get().getIterationLimit();
            if (iterationLimit >= 0 && iterationLimit < positiveN) {
                IterationLimitExceeded.throwIt(positiveN, F.Factorial(F.ZZ(ni)));
            }
            result = BigIntegerMath.factorial((int)positiveN);
            if ((ni & 1) == 1) {
                result = result.multiply(BigInteger.valueOf(-1L));
            }
        } else {
            int iterationLimit = EvalEngine.get().getIterationLimit();
            if (iterationLimit >= 0 && iterationLimit < ni) {
                IterationLimitExceeded.throwIt(ni, F.Factorial(F.ZZ(ni)));
            }
            if (ni <= 20) {
                return AbstractIntegerSym.valueOf(LongMath.factorial((int)ni));
            }
            result = BigIntegerMath.factorial((int)ni);
        }
        return AbstractIntegerSym.valueOf(result);
    }

    public static IInteger risingFactorial(int n, int k) {
        if (k == 0) {
            return F.C1;
        }
        IInteger result = AbstractIntegerSym.valueOf(n);
        for (int i = n + 1; i < n + k; ++i) {
            result = result.multiply(i);
        }
        return result;
    }

    public static IInteger fibonacci(int iArg) {
        int temp = iArg;
        if (temp < 0) {
            temp *= -1;
        }
        if (temp < FIBONACCI_45.length) {
            int result = FIBONACCI_45[temp];
            if (iArg < 0 && (iArg & 1) == 0) {
                return F.ZZ(-result);
            }
            return F.ZZ(result);
        }
        BigInteger a = BigInteger.ONE;
        BigInteger b = BigInteger.ZERO;
        BigInteger c = BigInteger.ONE;
        BigInteger d = BigInteger.ZERO;
        BigInteger result = BigInteger.ZERO;
        while (temp != 0) {
            if ((temp & 1) == 1) {
                d = result.multiply(c);
                result = a.multiply(c).add(result.multiply(b).add(d));
                if (result.bitLength() > Config.MAX_AST_SIZE * 8) {
                    IterationLimitExceeded.throwIt(result.bitLength(), F.Fibonacci(F.ZZ(iArg)));
                }
                a = a.multiply(b).add(d);
            }
            d = c.multiply(c);
            c = b.multiply(c).shiftLeft(1).add(d);
            b = b.multiply(b).add(d);
            temp >>= 1;
        }
        if (iArg < 0 && (iArg & 1) == 0) {
            return F.ZZ(result.negate());
        }
        return F.ZZ(result);
    }

    public static void initialize() {
        Initializer.init();
    }

    public static IInteger binomial(IInteger n, IInteger k) {
        if (n.isZero() && k.isZero()) {
            return F.C1;
        }
        if (!n.isNegative() && !k.isNegative()) {
            int ki;
            if (k.isNegative() || k.compareTo(n) > 0) {
                return F.C0;
            }
            if (k.isZero() || k.equals(n)) {
                return F.C1;
            }
            int ni = n.toIntDefault(-1);
            if (ni >= 0 && (ki = k.toIntDefault(-1)) >= 0) {
                if (ki > ni) {
                    return F.C0;
                }
                return AbstractIntegerSym.valueOf(BigIntegerMath.binomial((int)ni, (int)ki));
            }
            IInteger bin = F.C1;
            IInteger i = F.C1;
            while (i.compareTo(k) <= 0) {
                bin = bin.multiply(n.subtract(i).add(F.C1)).div(i);
                i = i.add(F.C1);
            }
            return bin;
        }
        if (n.isNegative()) {
            if (!k.isNegative()) {
                IInteger factor = k.isOdd() ? F.CN1 : F.C1;
                return NumberTheory.binomial(n.negate().add(k).add(F.CN1), k).multiply(factor);
            }
            if (n.compareTo(k) >= 0) {
                IInteger factor = n.subtract(k).isOdd() ? F.CN1 : F.C1;
                return NumberTheory.binomial(k.add(F.C1).negate(), n.subtract(k)).multiply(factor);
            }
        }
        return F.C0;
    }

    public static IRational bernoulliNumber(int n) {
        if (n == 0) {
            return F.C1;
        }
        if (n == 1) {
            return F.CN1D2;
        }
        if (n < 0) {
            throw new ArithmeticException("BernoulliB(n): n is not a positive int number");
        }
        if (n % 2 != 0) {
            return F.C0;
        }
        IFraction[] bernoulli = new IFraction[n + 1];
        bernoulli[0] = FractionSym.ONE;
        bernoulli[1] = AbstractFractionSym.valueOf(-1L, 2L);
        int iterationLimit = EvalEngine.get().getIterationLimit();
        if (iterationLimit > 0 && iterationLimit < 0x3FFFFFFF) {
            iterationLimit *= 2;
        }
        int iterationCounter = 0;
        for (int k = 2; k <= n; ++k) {
            bernoulli[k] = FractionSym.ZERO;
            for (int i = 0; i < k; ++i) {
                if (bernoulli[i].isZero()) continue;
                if (iterationLimit > 0 && iterationLimit <= iterationCounter++) {
                    IterationLimitExceeded.throwIt(iterationCounter, F.BernoulliB(F.ZZ(n)));
                }
                IFraction bin = AbstractFractionSym.valueOf(BigIntegerMath.binomial((int)(k + 1), (int)(k + 1 - i)));
                bernoulli[k] = bernoulli[k].sub(bin.mul(bernoulli[i]));
            }
            bernoulli[k] = bernoulli[k].div(AbstractFractionSym.valueOf(k + 1));
        }
        return bernoulli[n].normalize();
    }

    public static double bernoulliDouble(int n) {
        return NumberTheory.bernoulliNumber(n).doubleValue();
    }

    public static IRational bernoulliNumber(IInteger n) {
        int bn = n.toIntDefault(-1);
        if (bn >= 0) {
            return NumberTheory.bernoulliNumber(bn);
        }
        throw new ArithmeticException("BernoulliB(n): n is not a positive int number");
    }

    public static IInteger catalanNumber(IInteger n) {
        if (n.equals(F.CN1)) {
            return F.CN1;
        }
        if ((n = n.add(F.C1)).compareInt(0) <= 0) {
            return F.C0;
        }
        IInteger i = F.C1;
        IInteger c = F.C1;
        IInteger temp1 = n.shiftLeft(1).subtract(F.C1);
        while (i.compareTo(n) < 0) {
            c = c.multiply(temp1.subtract(i)).div(i);
            i = i.add(F.C1);
        }
        return c.div(n);
    }

    public static BigInteger divisorSigma(int exponent, int n) {
        IAST list = F.ZZ(n).divisors();
        if (list.isList()) {
            if (exponent == 1) {
                IInteger sum = F.C0;
                for (int i = 1; i < list.size(); ++i) {
                    sum = sum.add((IInteger)list.get(i));
                }
                return sum.toBigNumerator();
            }
            long kl = exponent;
            IInteger sum = F.C0;
            for (int i = 1; i < list.size(); ++i) {
                sum = sum.add(((IInteger)list.get(i)).powerRational(kl));
            }
            return sum.toBigNumerator();
        }
        return null;
    }

    public static IInteger multinomial(int[] k, int n) {
        IInteger bn = AbstractIntegerSym.valueOf(n);
        IInteger result = NumberTheory.factorial(bn);
        for (int i = 0; i < k.length; ++i) {
            if (k[i] == 0) continue;
            result = result.div(NumberTheory.factorial(k[i]));
        }
        return result;
    }

    public static IInteger multinomial(IInteger[] k) {
        IInteger n = F.C0;
        for (int i = 0; i < k.length; ++i) {
            n = n.add(k[i]);
        }
        int ni = n.toIntDefault();
        if (ni > 0) {
            int[] ki = new int[k.length];
            boolean evaled = true;
            for (int i = 0; i < k.length; ++i) {
                ki[i] = k[i].toIntDefault();
                if (ki[i] >= 0) continue;
                evaled = false;
                break;
            }
            if (evaled) {
                return NumberTheory.multinomial(ki, ni);
            }
        }
        IInteger result = NumberTheory.factorial(n);
        for (int i = 0; i < k.length; ++i) {
            result = result.div(NumberTheory.factorial(k[i]));
        }
        return result;
    }

    public static IInteger stirlingS2(int n, IInteger k, int ki) throws MathRuntimeException {
        if (n != 0 && n <= 25) {
            return F.ZZ(CombinatoricsUtils.stirlingS2((int)n, (int)ki));
        }
        IInteger sum = F.C0;
        for (int i = 0; i < ki; ++i) {
            IInteger bin = NumberTheory.binomial(k, F.ZZ(i));
            IInteger pow = k.add(F.ZZ(-i)).powerRational(n);
            sum = (i & 1) == 1 ? sum.add(bin.negate().multiply(pow)) : sum.add(bin.multiply(pow));
        }
        return sum.div(NumberTheory.factorial(k));
    }

    private NumberTheory() {
    }

    public static IExpr rationalize(IExpr arg1) {
        return NumberTheory.rationalize(arg1, Config.DOUBLE_EPSILON, true);
    }

    public static IExpr rationalize(IExpr arg1, boolean useConvergenceMethod) {
        return NumberTheory.rationalize(arg1, Config.DOUBLE_EPSILON, useConvergenceMethod);
    }

    public static IExpr rationalize(IExpr arg1, double epsilon, boolean useConvergenceMethod) {
        Rationalize.RationalizeNumericsVisitor rationalizeVisitor = new Rationalize.RationalizeNumericsVisitor(epsilon, useConvergenceMethod);
        return arg1.accept(rationalizeVisitor);
    }

    public static IAST quadraticIrrational(IExpr expr) {
        if (expr.isAST()) {
            IFraction frac;
            IASTMutable resultList = F.List(0, 1, 0, 1);
            if (expr.isSqrt() && expr.first().isInteger() && expr.first().isNonNegativeResult()) {
                resultList.set(3, expr.first());
                return resultList;
            }
            if (expr.isPlus2()) {
                return NumberTheory.quadraticIrrationalPlus((IAST)expr, resultList);
            }
            if (expr.isTimes2() && expr.first().isInteger() && expr.second().isSqrt()) {
                resultList.set(4, expr.first());
                IAST sqrt = (IAST)expr.second();
                if (sqrt.arg1().isInteger() && sqrt.arg1().isPositive()) {
                    resultList.set(3, sqrt.first());
                    return resultList;
                }
            } else if (expr.isTimes2() && expr.first().isFraction() && ((frac = (IFraction)expr.first()).numerator().isOne() || frac.numerator().isMinusOne())) {
                if (frac.numerator().isOne()) {
                    resultList.set(2, frac.denominator());
                } else {
                    resultList.set(2, frac.denominator().negate());
                }
                IExpr arg2 = expr.second();
                if (arg2.isSqrt() && arg2.first().isInteger() && arg2.first().isPositive()) {
                    resultList.set(3, arg2.first());
                    return resultList;
                }
                if (arg2.isPlus2()) {
                    return NumberTheory.quadraticIrrationalPlus((IAST)arg2, resultList);
                }
            }
        }
        return F.NIL;
    }

    private static IAST quadraticIrrationalPlus(IAST plusAST, IASTMutable resultList) {
        if (plusAST.arg1().isInteger()) {
            resultList.set(1, plusAST.arg1());
            IExpr arg2 = plusAST.arg2();
            if (arg2.isSqrt() && arg2.first().isInteger()) {
                resultList.set(3, arg2.first());
                return resultList;
            }
            if (arg2.isTimes2() && arg2.first().isInteger() && arg2.second().isSqrt()) {
                resultList.set(4, arg2.first());
                IAST sqrt = (IAST)arg2.second();
                if (sqrt.arg1().isInteger() && sqrt.arg1().isPositive()) {
                    resultList.set(3, sqrt.first());
                    return resultList;
                }
            }
        }
        return F.NIL;
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.BellB.setEvaluator(new BellB());
            S.BernoulliB.setEvaluator(new BernoulliB());
            S.Binomial.setEvaluator(new Binomial());
            S.CarmichaelLambda.setEvaluator(new CarmichaelLambda());
            S.CatalanNumber.setEvaluator(new CatalanNumber());
            S.ChineseRemainder.setEvaluator(new ChineseRemainder());
            S.Convergents.setEvaluator(new Convergents());
            S.ContinuedFraction.setEvaluator(new ContinuedFraction());
            S.CoprimeQ.setEvaluator(new CoprimeQ());
            S.DiracDelta.setEvaluator(new DiracDelta());
            S.DiscreteDelta.setEvaluator(new DiscreteDelta());
            S.Divisible.setEvaluator(new Divisible());
            S.Divisors.setEvaluator(new Divisors());
            S.DivisorSum.setEvaluator(new DivisorSum());
            S.DivisorSigma.setEvaluator(new DivisorSigma());
            S.EulerE.setEvaluator(new EulerE());
            S.EulerPhi.setEvaluator(new EulerPhi());
            S.ExtendedGCD.setEvaluator(new ExtendedGCD());
            S.Factorial.setEvaluator(new Factorial());
            S.FactorialPower.setEvaluator(new FactorialPower());
            S.Factorial2.setEvaluator(new Factorial2());
            S.FactorInteger.setEvaluator(new FactorInteger());
            S.Fibonacci.setEvaluator(new Fibonacci());
            S.FrobeniusNumber.setEvaluator(new FrobeniusNumber());
            S.FromContinuedFraction.setEvaluator(new FromContinuedFraction());
            S.JacobiSymbol.setEvaluator(new JacobiSymbol());
            S.KroneckerDelta.setEvaluator(new KroneckerDelta());
            S.LinearRecurrence.setEvaluator(new LinearRecurrence());
            S.LiouvilleLambda.setEvaluator(new LiouvilleLambda());
            S.LucasL.setEvaluator(new LucasL());
            S.MangoldtLambda.setEvaluator(new MangoldtLambda());
            S.MersennePrimeExponent.setEvaluator(new MersennePrimeExponent());
            S.MersennePrimeExponentQ.setEvaluator(new MersennePrimeExponentQ());
            S.MoebiusMu.setEvaluator(new MoebiusMu());
            S.Multinomial.setEvaluator(new Multinomial());
            S.MultiplicativeOrder.setEvaluator(new MultiplicativeOrder());
            S.NextPrime.setEvaluator(new NextPrime());
            S.PartitionsP.setEvaluator(new PartitionsP());
            S.PartitionsQ.setEvaluator(new PartitionsQ());
            S.PerfectNumber.setEvaluator(new PerfectNumber());
            S.PerfectNumberQ.setEvaluator(new PerfectNumberQ());
            S.Prime.setEvaluator(new Prime());
            S.PrimePi.setEvaluator(new PrimePi());
            S.PrimeOmega.setEvaluator(new PrimeOmega());
            S.PrimePowerQ.setEvaluator(new PrimePowerQ());
            S.PrimitiveRoot.setEvaluator(new PrimitiveRoot());
            S.PrimitiveRootList.setEvaluator(new PrimitiveRootList());
            S.QuadraticIrrationalQ.setEvaluator(new QuadraticIrrationalQ());
            S.Rationalize.setEvaluator(new Rationalize());
            S.RootReduce.setEvaluator(new RootReduce());
            S.SquareFreeQ.setEvaluator(new SquareFreeQ());
            S.StirlingS1.setEvaluator(new StirlingS1());
            S.StirlingS2.setEvaluator(new StirlingS2());
            S.Subfactorial.setEvaluator(new Subfactorial());
            S.Unitize.setEvaluator(new Unitize());
        }
    }

    private static class Unitize
    extends AbstractEvaluator {
        private Unitize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isNumber()) {
                return arg1.isZero() ? F.C0 : F.C1;
            }
            if (S.PossibleZeroQ.ofQ(engine, arg1)) {
                return F.C0;
            }
            IExpr temp = arg1.evalNumber();
            if (temp == null) {
                temp = arg1;
            }
            if (temp.isNumber()) {
                return temp.isZero() ? F.C0 : F.C1;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Subfactorial
    extends AbstractTrigArg1 {
        private Subfactorial() {
        }

        private static IInteger subFactorial(long n) {
            if (0L <= n && n <= 2L) {
                return n != 1L ? F.C1 : F.C0;
            }
            IInteger result = F.C1;
            boolean isOdd = true;
            for (long i = 3L; i <= n; ++i) {
                result = AbstractIntegerSym.valueOf(i).multiply(result);
                if (isOdd) {
                    result = result.subtract(F.C1);
                    isOdd = false;
                    continue;
                }
                result = result.add(F.C1);
                isOdd = true;
            }
            return result;
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isInteger() && arg1.isPositive()) {
                try {
                    long n = ((IInteger)arg1).toLong();
                    return Subfactorial.subFactorial(n);
                }
                catch (ArithmeticException ae) {
                    LOGGER.log(engine.getLogLevel(), "Subfactorial: argument n is to big.");
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class StirlingS2
    extends AbstractFunctionEvaluator {
        private StirlingS2() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IExpr nArg1 = ast.arg1();
                IExpr kArg2 = ast.arg2();
                if (nArg1.isNegativeResult() || kArg2.isNegativeResult()) {
                    return F.NIL;
                }
                if (nArg1.isZero() && kArg2.isZero()) {
                    return F.C1;
                }
                if (nArg1.isInteger() && kArg2.isInteger()) {
                    IInteger ki = (IInteger)kArg2;
                    if (ki.greaterThan(nArg1).isTrue()) {
                        return F.C0;
                    }
                    if (ki.equals(nArg1)) {
                        return F.C1;
                    }
                    if (ki.isZero()) {
                        return F.C0;
                    }
                    if (ki.isOne()) {
                        return F.C1;
                    }
                    if (ki.equals(F.C2)) {
                        return F.Subtract(F.Power((IExpr)F.C2, F.Subtract(nArg1, F.C1)), F.C1);
                    }
                    int n = Validate.checkNonNegativeIntType(ast, 1);
                    int k = ki.toIntDefault(0);
                    if (k != 0) {
                        return NumberTheory.stirlingS2(n, ki, k);
                    }
                }
            }
            catch (MathRuntimeException mre) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)mre);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class StirlingS1
    extends AbstractFunctionEvaluator {
        private StirlingS1() {
        }

        private static IExpr stirlingS1(IInteger n, IInteger m) {
            IInteger nSubtract1 = n.subtract(F.C1);
            if (n.isPositive() && m.isOne()) {
                return F.Times((IExpr)F.Power((IExpr)F.CN1, nSubtract1), (IExpr)F.Factorial(nSubtract1));
            }
            if (n.isPositive() && m.equals(F.C2)) {
                IInteger factorPlusMinus1 = n.isOdd() ? F.CN1 : F.C1;
                return F.Times((IExpr)factorPlusMinus1, (IExpr)F.Factorial(nSubtract1), (IExpr)F.HarmonicNumber(nSubtract1));
            }
            IInteger nSubtractm = n.subtract(m);
            IInteger nTimes2Subtractm = n.add(n.subtract(m));
            int counter = nSubtractm.toIntDefault();
            if (counter > Integer.MIN_VALUE) {
                IASTAppendable temp = F.PlusAlloc(++counter >= 0 ? counter : 0);
                long leafCount = 0L;
                for (int i = 0; i < counter; ++i) {
                    IInteger value = F.ZZ(i);
                    IInteger factorPlusMinus1 = (i & 1) == 1 ? F.CN1 : F.C1;
                    temp.append(F.Times(factorPlusMinus1, F.Binomial(F.Plus((IExpr)value, (IExpr)nSubtract1), F.Plus((IExpr)value, (IExpr)nSubtractm)), F.Binomial(nTimes2Subtractm, F.Subtract(nSubtractm, value)), F.StirlingS2(F.Plus((IExpr)value, (IExpr)nSubtractm), value)));
                    if ((leafCount += temp.leafCount()) <= (long)Config.MAX_AST_SIZE) continue;
                    ASTElementLimitExceeded.throwIt(leafCount);
                }
                return temp;
            }
            throw new ArgumentTypeException("intm", F.list(F.ZZ(1), F.StirlingS1(n, m)));
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr m = ast.arg2();
            if (n.isNegativeResult() || m.isNegativeResult()) {
                return F.NIL;
            }
            if (n.isZero() && m.isZero()) {
                return F.C1;
            }
            if (n.isZero() && m.isPositiveResult()) {
                return F.C0;
            }
            if (n.equals(m)) {
                return F.C1;
            }
            if (n.isInteger() && m.isInteger()) {
                return StirlingS1.stirlingS1((IInteger)n, (IInteger)m);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static final class SquareFreeQ
    extends AbstractFunctionEvaluator {
        private SquareFreeQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            VariablesSet eVar = new VariablesSet(ast.arg1());
            if (eVar.isSize(0)) {
                IExpr arg1 = ast.arg1();
                if (arg1.isZero()) {
                    return S.False;
                }
                if (arg1.isInteger()) {
                    return F.bool(Primality.isSquareFree(((IInteger)arg1).toBigNumerator()));
                }
                if (arg1.isAtom()) {
                    return S.False;
                }
            }
            if (!eVar.isSize(1)) {
                LOGGER.log(engine.getLogLevel(), "{}: only implemented for univariate polynomials at position 1", (Object)ast.topHead());
                return F.NIL;
            }
            try {
                IExpr expr = F.evalExpandAll(ast.arg1(), engine);
                List<IExpr> varList = eVar.getVarList().copyTo();
                if (ast.isAST2()) {
                    return F.bool(SquareFreeQ.isSquarefreeWithOption(ast, expr, varList, engine));
                }
                return F.bool(SquareFreeQ.isSquarefree(expr, varList));
            }
            catch (RuntimeException e) {
                LOGGER.debug("SquareFreeQ.evaluate() failed", (Throwable)e);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        public static boolean isSquarefree(IExpr expr, List<IExpr> varList) throws JASConversionException {
            JASConvert jas = new JASConvert((List<? extends IExpr>)varList, BigRational.ZERO);
            GenPolynomial poly = jas.expr2JAS(expr, false);
            FactorAbstract factorAbstract = FactorFactory.getImplementation((BigRational)BigRational.ONE);
            return factorAbstract.isSquarefree(poly);
        }

        public static boolean isSquarefreeWithOption(IAST lst, IExpr expr, List<IExpr> varList, EvalEngine engine) throws JASConversionException {
            OptionArgs options = new OptionArgs(lst.topHead(), lst, 2, engine);
            IExpr option = options.getOption(S.Modulus);
            if (option.isReal()) {
                ModIntegerRing modIntegerRing = JASConvert.option2ModIntegerRing((ISignedNumber)option);
                JASConvert jas = new JASConvert((List<? extends IExpr>)varList, modIntegerRing);
                GenPolynomial poly = jas.expr2JAS(expr, false);
                FactorAbstract factorAbstract = FactorFactory.getImplementation((ModIntegerRing)modIntegerRing);
                return factorAbstract.isSquarefree(poly);
            }
            return false;
        }
    }

    private static class RootReduce
    extends AbstractFunctionEvaluator {
        private RootReduce() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr base;
            IExpr arg1 = ast.arg1();
            if (arg1.isPowerReciprocal() && (base = arg1.base()).isPlus() && base.size() == 3) {
                IExpr p1 = base.first();
                IExpr p2 = base.second();
                if (base.size() == 3 && (p1.isRational() || p1.isFactorSqrtExpr()) && p2.isFactorSqrtExpr()) {
                    IRational denominator = (IRational)F.Subtract.of(F.Sqr(p1), F.Sqr(p2));
                    IAST numerator = F.Subtract(p1, p2);
                    return F.Divide(numerator, denominator);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static final class Rationalize
    extends AbstractCoreFunctionEvaluator {
        private Rationalize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            double epsilon = Config.DOUBLE_EPSILON;
            boolean useConvergenceMethod = true;
            try {
                if (ast.isAST2()) {
                    ISignedNumber epsilonExpr = ast.arg2().evalReal();
                    if (epsilonExpr == null) {
                        return F.NIL;
                    }
                    useConvergenceMethod = false;
                    epsilon = epsilonExpr.doubleValue();
                    if (arg1.isNumericFunction(true)) {
                        arg1 = engine.evalN(arg1);
                    }
                }
                return NumberTheory.rationalize(arg1, epsilon, useConvergenceMethod).orElse(arg1);
            }
            catch (Exception ex) {
                LOGGER.debug("Rationalize.evaluate() failed", (Throwable)ex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }

        static class RationalizeNumericsVisitor
        extends VisitorExpr {
            double epsilon;
            boolean useConvergenceMethod;

            public RationalizeNumericsVisitor(double epsilon, boolean useConvergenceMethod) {
                this.epsilon = epsilon;
                this.useConvergenceMethod = useConvergenceMethod;
            }

            @Override
            public IExpr visit(IASTMutable ast) {
                return super.visitAST(ast);
            }

            @Override
            public IExpr visit(IComplexNum element) {
                if (this.useConvergenceMethod) {
                    return F.complexConvergent(element.getRealPart(), element.getImaginaryPart());
                }
                return F.complex(element.getRealPart(), element.getImaginaryPart(), this.epsilon);
            }

            @Override
            public IExpr visit(INum element) {
                if (this.useConvergenceMethod) {
                    return F.fractionConvergent(element.getRealPart());
                }
                return F.fraction(element.getRealPart(), this.epsilon);
            }
        }
    }

    private static class QuadraticIrrationalQ
    extends AbstractFunctionEvaluator {
        private QuadraticIrrationalQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST result = NumberTheory.quadraticIrrational(ast.arg1());
            return F.bool(result.isPresent());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class PrimitiveRootList
    extends AbstractTrigArg1 {
        private PrimitiveRootList() {
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isInteger()) {
                try {
                    IInteger[] roots = ((IInteger)arg1).primitiveRootList();
                    if (roots != null) {
                        int size = roots.length;
                        IASTAppendable list = F.ListAlloc(size);
                        return list.appendArgs(0, size, i -> roots[i]);
                    }
                }
                catch (LimitException le) {
                    throw le;
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("PrimitiveRootList.evaluateArg1() failed", (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class PrimitiveRoot
    extends AbstractFunctionEvaluator {
        private PrimitiveRoot() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isInteger()) {
                try {
                    IInteger ii = (IInteger)arg1;
                    if (ii.isEven() && !ii.equals(F.C2) && !ii.equals(F.C4) && ii.quotient(F.C2).isEven()) {
                        return F.NIL;
                    }
                }
                catch (LimitException le) {
                    throw le;
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("PrimitiveRoot.evaluate() failed", (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class PrimePowerQ
    extends AbstractFunctionEvaluator {
        private PrimePowerQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isInteger()) {
                return F.bool(Primality.isPrimePower(((IInteger)arg1).toBigNumerator()));
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class PrimeOmega
    extends AbstractFunctionEvaluator {
        private PrimeOmega() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.arg1().isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            if (arg1.isZero()) {
                return F.NIL;
            }
            if (arg1.isOne()) {
                return F.C0;
            }
            if (arg1.isInteger()) {
                if (arg1.isNegative()) {
                    arg1 = arg1.negate();
                }
                SortedMap<BigInteger, Integer> map = Config.PRIME_FACTORS.factorInteger(((IInteger)arg1).toBigNumerator());
                BigInteger sum = BigInteger.ZERO;
                for (Map.Entry<BigInteger, Integer> entry : map.entrySet()) {
                    sum = sum.add(BigInteger.valueOf(entry.getValue().intValue()));
                }
                return F.ZZ(sum);
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.PrimeOmega(negExpr);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class PrimePi
    extends AbstractFunctionEvaluator {
        private PrimePi() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int maxK;
            IExpr arg1 = ast.arg1();
            if (arg1.isNegative() || arg1.isOne() || arg1.isZero()) {
                return F.C0;
            }
            IExpr x = F.NIL;
            if (arg1.isInteger()) {
                x = arg1;
            } else if (arg1.isReal() && arg1.isPositive()) {
                x = engine.evaluate(((ISignedNumber)arg1).floorFraction());
            } else {
                ISignedNumber sn = arg1.evalReal();
                if (sn != null) {
                    x = engine.evaluate(sn.floorFraction());
                }
            }
            if (x.isInteger() && x.isPositive() && (maxK = ((IInteger)x).toIntDefault()) >= 0) {
                int result = 0;
                BigInteger max = BigInteger.valueOf(maxK);
                BigInteger temp = BigInteger.ONE;
                int iterationLimit = engine.getIterationLimit();
                if (iterationLimit >= 0 && iterationLimit < maxK / 100) {
                    IterationLimitExceeded.throwIt(maxK, ast);
                }
                for (int i = 2; i <= maxK && (temp = temp.nextProbablePrime()).compareTo(max) <= 0; ++i) {
                    ++result;
                }
                return F.ZZ(result);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Prime
    extends AbstractFunctionEvaluator {
        private Prime() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isInteger()) {
                int nthPrime = ((IInteger)ast.arg1()).toIntDefault();
                if (nthPrime <= 0) {
                    return IOFunctions.printMessage(ast.topHead(), "intpp", F.list(ast), engine);
                }
                if (nthPrime > 103000000) {
                    return IOFunctions.printMessage(ast.topHead(), "zzprime", F.list(ast.arg1()), engine);
                }
                try {
                    return F.ZZ(Primality.prime(nthPrime));
                }
                catch (RuntimeException ae) {
                    LOGGER.debug("Prime.evaluate() failed", (Throwable)ae);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
            super.setUp(newSymbol);
        }
    }

    private static class PerfectNumberQ
    extends AbstractFunctionEvaluator {
        private PerfectNumberQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (!arg1.isInteger() || arg1.isZero() || arg1.isOne() || arg1.isNegative()) {
                return S.False;
            }
            IInteger n = (IInteger)arg1;
            try {
                long value = n.toLong();
                if (value > 0L && value <= PN_8[PN_8.length - 1]) {
                    for (int i = 0; i < PN_8.length; ++i) {
                        if (PN_8[i] != value) continue;
                        return S.True;
                    }
                    return S.False;
                }
            }
            catch (ArithmeticException ae) {
                return F.NIL;
            }
            IAST list = n.divisors();
            if (list.isList()) {
                IInteger sum = F.C0;
                int size = list.argSize();
                for (int i = 1; i < size; ++i) {
                    sum = sum.add((IInteger)list.get(i));
                }
                return F.bool(sum.equals(n));
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class PerfectNumber
    extends AbstractTrigArg1 {
        private PerfectNumber() {
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            int n;
            if (arg1.isInteger() && arg1.isPositive() && (n = ((IInteger)arg1).toIntDefault()) >= 0) {
                if (n > MPE_47.length) {
                    return F.NIL;
                }
                if (n <= PN_8.length) {
                    return F.ZZ(PN_8[n - 1]);
                }
                BigInteger b2p = BigInteger.ONE.shiftLeft(MPE_47[n - 1]);
                BigInteger b2pm1 = b2p.shiftRight(1);
                return F.ZZ(b2p.subtract(BigInteger.ONE).multiply(b2pm1));
            }
            return F.NIL;
        }
    }

    private static class PartitionsQ
    extends AbstractFunctionEvaluator {
        private PartitionsQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, final EvalEngine engine) {
            final IExpr arg1 = ast.arg1();
            if (arg1.isZero()) {
                return F.C1;
            }
            if (arg1.isInteger()) {
                if (arg1.isPositive()) {
                    if (arg1.isOne()) {
                        return F.C1;
                    }
                    if (arg1.equals(F.C2)) {
                        return F.C1;
                    }
                    if (arg1.equals(F.C3)) {
                        return F.C2;
                    }
                    try {
                        IExpr result;
                        IInteger n = (IInteger)arg1;
                        if (n.isLT(F.ZZ(201)) && (result = (IExpr)F.REMEMBER_INTEGER_CACHE.get((Object)ast, (Callable)new Callable<IExpr>(){

                            @Override
                            public IExpr call() {
                                return PartitionsQ.partitionsQ(engine, (IInteger)arg1);
                            }
                        })) != null) {
                            return result;
                        }
                    }
                    catch (UncheckedExecutionException e) {
                        Throwable th = e.getCause();
                        if (th instanceof LimitException) {
                            throw (LimitException)((Object)th);
                        }
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    return F.NIL;
                }
                return F.C0;
            }
            if (arg1.isInfinity()) {
                return F.CInfinity;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        private static IExpr partitionsQ(EvalEngine engine, IInteger n) {
            IFraction nInverse = F.QQ(F.C1, n);
            IExpr sum1 = PartitionsQ.sumPartitionsQ1(engine, n);
            if (!sum1.isPresent()) {
                return F.NIL;
            }
            IExpr sum2 = PartitionsQ.sumPartitionsQ2(engine, n);
            if (!sum2.isPresent()) {
                return F.NIL;
            }
            return engine.evaluate(F.Plus((IExpr)F.Times((IExpr)nInverse, sum1), (IExpr)F.Times((IExpr)F.CN2, (IExpr)nInverse, sum2)));
        }

        private static IExpr sumPartitionsQ1(EvalEngine engine, IInteger n) {
            int nInt = n.toIntDefault();
            if (nInt >= 0) {
                int iterationLimit = EvalEngine.get().getIterationLimit();
                if (iterationLimit >= 0 && iterationLimit <= nInt) {
                    IterationLimitExceeded.throwIt(nInt, F.PartitionsQ(F.ZZ(nInt)));
                }
                IInteger sum = F.C0;
                for (int k = 1; k <= nInt; ++k) {
                    IExpr temp = PartitionsQ.termPartitionsQ1(engine, n, k);
                    if (!temp.isInteger()) {
                        return F.NIL;
                    }
                    sum = sum.add((IInteger)temp);
                }
                return sum;
            }
            return F.NIL;
        }

        private static IExpr termPartitionsQ1(EvalEngine engine, IInteger n, int k) {
            IInteger k2 = F.ZZ(k);
            return engine.evaluate(F.Times((IExpr)F.DivisorSigma(F.C1, k2), (IExpr)F.PartitionsQ(F.Plus(F.Negate(k2), (IExpr)n))));
        }

        private static IExpr sumPartitionsQ2(EvalEngine engine, IInteger n) {
            int floorND2 = n.div(F.C2).toIntDefault();
            if (floorND2 >= 0) {
                int iterationLimit = EvalEngine.get().getIterationLimit();
                if (iterationLimit >= 0 && iterationLimit <= floorND2) {
                    IterationLimitExceeded.throwIt(floorND2, F.PartitionsQ(n));
                }
                IInteger sum = F.C0;
                for (int k = 1; k <= floorND2; ++k) {
                    IExpr temp = PartitionsQ.termPartitionsQ2(engine, n, k);
                    if (!temp.isInteger()) {
                        return F.NIL;
                    }
                    sum = sum.add((IInteger)temp);
                }
                return sum;
            }
            return F.NIL;
        }

        private static IExpr termPartitionsQ2(EvalEngine engine, IInteger n, int k) {
            IInteger k2 = F.ZZ(k);
            return engine.evaluate(F.Times((IExpr)F.DivisorSigma(F.C1, k2), (IExpr)F.PartitionsQ(F.Plus((IExpr)F.Times((IExpr)F.CN2, (IExpr)k2), (IExpr)n))));
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class PartitionsP
    extends AbstractFunctionEvaluator {
        private PartitionsP() {
        }

        @Override
        public IExpr evaluate(IAST ast, final EvalEngine engine) {
            final IExpr arg1 = ast.arg1();
            if (arg1.isZero()) {
                return F.C1;
            }
            if (arg1.isInteger()) {
                if (arg1.isPositive()) {
                    if (arg1.isOne()) {
                        return F.C1;
                    }
                    if (arg1.equals(F.C2)) {
                        return F.C2;
                    }
                    if (arg1.equals(F.C3)) {
                        return F.C3;
                    }
                    try {
                        IExpr result = (IExpr)F.REMEMBER_INTEGER_CACHE.get((Object)ast, (Callable)new Callable<IExpr>(){

                            @Override
                            public IExpr call() {
                                return PartitionsP.sumPartitionsP(engine, (IInteger)arg1);
                            }
                        });
                        if (result != null) {
                            return result;
                        }
                    }
                    catch (UncheckedExecutionException e) {
                        Throwable th = e.getCause();
                        if (th instanceof LimitException) {
                            throw (LimitException)((Object)th);
                        }
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    return F.NIL;
                }
                return F.C0;
            }
            if (arg1.isInfinity()) {
                return F.CInfinity;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        private static IExpr sumPartitionsP(EvalEngine engine, IInteger n) {
            int i = n.toIntDefault();
            if (i >= 0 && i < 0x7FFFFFFC) {
                BigIntegerPartitionsP bipp = new BigIntegerPartitionsP();
                return F.ZZ(bipp.sumPartitionsP(i, i + 3));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }

        private static class BigIntegerPartitionsP {
            protected ArrayList<BigInteger> fList = new ArrayList();

            public BigIntegerPartitionsP() {
                this.fList.add(BigInteger.valueOf(1L));
                this.fList.add(BigInteger.valueOf(1L));
                this.fList.add(BigInteger.valueOf(2L));
                this.fList.add(BigInteger.valueOf(3L));
                this.fList.add(BigInteger.valueOf(5L));
                this.fList.add(BigInteger.valueOf(7L));
            }

            private BigInteger sumPartitionsP(int n, int capacity) {
                int iterationLimit = EvalEngine.get().getIterationLimit();
                long maxIterations = capacity;
                if (iterationLimit >= 0 && (long)iterationLimit <= maxIterations) {
                    IterationLimitExceeded.throwIt(capacity, F.PartitionsP(F.ZZ(n)));
                }
                this.fList.ensureCapacity(capacity);
                while (this.fList.size() <= capacity) {
                    BigInteger per = BigInteger.ZERO;
                    BigInteger cursiz = BigInteger.valueOf(this.fList.size());
                    for (int k = 0; k < this.fList.size(); ++k) {
                        BigInteger tmp = this.fList.get(k).multiply(NumberTheory.divisorSigma(1, this.fList.size() - k));
                        per = per.add(tmp);
                    }
                    this.fList.add(per.divide(cursiz));
                }
                return this.fList.get(n);
            }
        }
    }

    private static class NextPrime
    extends AbstractFunctionEvaluator {
        private NextPrime() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1() && ast.arg1().isInteger()) {
                BigInteger primeBase = ((IInteger)ast.arg1()).toBigNumerator();
                if (primeBase.compareTo(BigInteger.ZERO) < 0) {
                    return IOFunctions.printMessage(S.NextPrime, "intnn", F.CEmptyList, engine);
                }
                return F.ZZ(primeBase.nextProbablePrime());
            }
            if (ast.isAST2() && ast.arg1().isInteger() && ast.arg2().isInteger()) {
                BigInteger primeBase = ((IInteger)ast.arg1()).toBigNumerator();
                if (primeBase.compareTo(BigInteger.ZERO) < 0) {
                    return IOFunctions.printMessage(S.NextPrime, "intnn", F.CEmptyList, engine);
                }
                int n = ast.arg2().toIntDefault();
                if (n < 0) {
                    return IOFunctions.printMessage(S.NextPrime, "intpm", F.list(ast, F.C2), engine);
                }
                int iterationLimit = EvalEngine.get().getIterationLimit();
                if (iterationLimit >= 0 && iterationLimit <= n) {
                    IterationLimitExceeded.throwIt(n, ast);
                }
                BigInteger temp = primeBase;
                for (int i = 0; i < n; ++i) {
                    temp = temp.nextProbablePrime();
                }
                return F.ZZ(temp);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class MultiplicativeOrder
    extends AbstractFunctionEvaluator {
        private MultiplicativeOrder() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isInteger() && ast.arg2().isInteger()) {
                try {
                    IInteger k = ast.getInt(1);
                    IInteger n = ast.getInt(2);
                    if (!n.isPositive()) {
                        return F.NIL;
                    }
                    if (!k.gcd(n).isOne()) {
                        return F.NIL;
                    }
                    return F.ZZ(Primality.multiplicativeOrder(k.toBigNumerator(), n.toBigNumerator()));
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class Multinomial
    extends AbstractFunctionEvaluator {
        private Multinomial() {
        }

        private static IExpr multinomial(IAST ast) {
            IInteger[] k = new IInteger[ast.argSize()];
            for (int i = 1; i < ast.size(); ++i) {
                IExpr temp = ast.get(i);
                int value = temp.toIntDefault();
                if (value != Integer.MIN_VALUE) {
                    k[i - 1] = F.ZZ(value);
                    continue;
                }
                if (!temp.isInteger()) {
                    return F.NIL;
                }
                k[i - 1] = (IInteger)temp;
            }
            return NumberTheory.multinomial(k);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                return F.C1;
            }
            if (ast.isAST2()) {
                return F.Binomial(F.Plus(ast.arg1(), ast.arg2()), ast.arg2());
            }
            int position = ast.indexOf(x -> !x.isInteger() || x.isNegative());
            if (position < 0) {
                return Multinomial.multinomial(ast);
            }
            int argSize = ast.size() - 1;
            if (position == argSize && !ast.get(argSize).isNumber()) {
                IAST reducedMultinomial = ast.removeFromEnd(argSize);
                IASTAppendable reducedPlus = reducedMultinomial.apply((IExpr)S.Plus);
                return F.Times((IExpr)F.Multinomial(reducedPlus, ast.get(argSize)), Multinomial.multinomial(reducedMultinomial));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return null;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1540);
        }
    }

    private static class MoebiusMu
    extends AbstractTrigArg1 {
        private MoebiusMu() {
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isInteger()) {
                try {
                    return ((IInteger)arg1).moebiusMu();
                }
                catch (ArithmeticException arithmeticException) {
                }
            } else {
                if (AbstractAssumptions.assumePrime(arg1).isTrue()) {
                    return F.CN1;
                }
                IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
                if (negExpr.isPresent()) {
                    return F.MoebiusMu(negExpr);
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class MersennePrimeExponentQ
    extends AbstractFunctionEvaluator {
        private MersennePrimeExponentQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (!arg1.isInteger() || arg1.isZero() || arg1.isOne() || arg1.isNegative()) {
                return S.False;
            }
            try {
                long n = ((IInteger)arg1).toLong();
                if (n <= (long)MPE_47[MPE_47.length - 1]) {
                    for (int i = 0; i < MPE_47.length; ++i) {
                        if ((long)MPE_47[i] != n) continue;
                        return S.True;
                    }
                    return S.False;
                }
                if (n < Integer.MAX_VALUE) {
                    BigInteger b2nm1 = BigInteger.ONE.shiftLeft((int)n).subtract(BigInteger.ONE);
                    return F.bool(b2nm1.isProbablePrime(32));
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class MersennePrimeExponent
    extends AbstractTrigArg1 {
        private MersennePrimeExponent() {
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            int n;
            if (arg1.isInteger() && arg1.isPositive() && (n = ((IInteger)arg1).toIntDefault()) > 0) {
                if (n > MPE_47.length) {
                    return F.NIL;
                }
                return F.ZZ(MPE_47[n - 1]);
            }
            return F.NIL;
        }
    }

    private static class MangoldtLambda
    extends AbstractFunctionEvaluator {
        private MangoldtLambda() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.arg1().isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            if (arg1.isInteger()) {
                if (arg1.isZero() || arg1.isOne() || arg1.isNegative()) {
                    return F.C0;
                }
                IExpr expr = S.FactorInteger.of(engine, arg1);
                if (expr.isList()) {
                    IAST list = (IAST)expr;
                    if (list.size() == 2) {
                        IInteger temp = (IInteger)list.arg1().first();
                        return F.Log(temp);
                    }
                    return F.C0;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class LucasL
    extends AbstractFunctionEvaluator {
        private LucasL() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isInteger()) {
                int n = ((IInteger)arg1).toIntDefault();
                if (n > Integer.MIN_VALUE) {
                    if (ast.isAST2()) {
                        return LucasL.lucasLPolynomialIterative(n, ast.arg2(), ast, engine);
                    }
                    int iArg = n;
                    if (n < 0) {
                        n *= -1;
                    }
                    IInteger lucalsL = NumberTheory.fibonacci(n - 1).add(NumberTheory.fibonacci(n + 1));
                    if (iArg < 0 && (iArg & 1) == 1) {
                        return F.Negate(lucalsL);
                    }
                    return lucalsL;
                }
            } else if (arg1.isInexactNumber()) {
                INumber n = ((INumber)arg1).evaluatePrecision(engine);
                if (ast.isAST2() && ast.arg2().isInexactNumber()) {
                    INumber x = ((INumber)ast.arg2()).evaluatePrecision(engine);
                    return F.Plus((IExpr)F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)x), (IExpr)F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C1D4, (IExpr)F.Sqr(x))))), n), (IExpr)F.Times((IExpr)F.Power((IExpr)F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)x), (IExpr)F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C1D4, (IExpr)F.Sqr(x))))), n), F.CN1), (IExpr)F.Cos(F.Times((IExpr)n, (IExpr)S.Pi))));
                }
                return F.Plus((IExpr)F.Power((IExpr)S.GoldenRatio, n), (IExpr)F.Times((IExpr)F.Cos(F.Times((IExpr)S.Pi, (IExpr)n)), (IExpr)F.Power((IExpr)S.GoldenRatio, F.Negate(n))));
            }
            return F.NIL;
        }

        private static IExpr lucasLPolynomialIterative(int n, IExpr x, IAST ast, EvalEngine engine) {
            int iArg = n;
            if (n < 0) {
                n *= -1;
            }
            if (n > Config.MAX_POLYNOMIAL_DEGREE) {
                PolynomialDegreeLimitExceeded.throwIt(n);
            }
            IExpr previousLucasL = F.C2;
            IExpr lucalsL = x;
            if (n == 0) {
                return previousLucasL;
            }
            if (n == 1) {
                if (iArg < 0) {
                    return F.Negate(lucalsL);
                }
                return lucalsL;
            }
            int iterationLimit = engine.getIterationLimit();
            if (iterationLimit >= 0 && iterationLimit <= n) {
                IterationLimitExceeded.throwIt(n, ast);
            }
            for (int i = 1; i < n; ++i) {
                IExpr temp = lucalsL;
                lucalsL = lucalsL.isPlus() ? ((IAST)lucalsL).mapThread(F.Times(x, (IExpr)F.Slot1), 2) : F.Times(x, lucalsL);
                lucalsL = S.Expand.of(engine, F.Plus(lucalsL, previousLucasL));
                previousLucasL = temp;
            }
            if (iArg < 0 && (iArg & 1) == 1) {
                return F.Negate(lucalsL);
            }
            return lucalsL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static class LiouvilleLambda
    extends AbstractFunctionEvaluator {
        private LiouvilleLambda() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr expr;
            IExpr arg1 = ast.arg1();
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(ast, 1);
            }
            if (arg1.isOne()) {
                return F.C1;
            }
            if (arg1.isInteger() && arg1.isPositive() && (expr = S.FactorInteger.of(engine, arg1)).isList()) {
                IAST list = (IAST)expr;
                int result = 1;
                for (int i = 1; i < list.size(); ++i) {
                    IInteger temp = (IInteger)list.get(i).second();
                    if (!temp.isOdd()) continue;
                    result = result == -1 ? 1 : -1;
                }
                if (result == -1) {
                    return F.CN1;
                }
                return F.C1;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class LinearRecurrence
    extends AbstractFunctionEvaluator {
        private LinearRecurrence() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            IExpr arg3 = ast.arg3();
            if (arg1.isList() && arg2.isList()) {
                int n;
                IAST result;
                IAST list1 = (IAST)arg1;
                IAST list2 = (IAST)arg2;
                if (arg3.isReal() && arg3.isPositive()) {
                    int n2 = arg3.toIntDefault(-1);
                    return this.linearRecurrence(list1, list2, n2, ast, engine);
                }
                if (arg3.isList() && arg3.size() == 2 && arg3.first().isReal() && (result = this.linearRecurrence(list1, list2, n = arg3.first().toIntDefault(-1), ast, engine)).isPresent()) {
                    return result.get(n);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        private IAST linearRecurrence(IAST list1, IAST list2, int n, IAST ast, EvalEngine engine) {
            if (n < 0) {
                return F.NIL;
            }
            int size1 = list1.size();
            int size2 = list2.size();
            if (size2 >= size1) {
                int i;
                int iterationLimit;
                int counter = 0;
                if (Config.MAX_AST_SIZE < n) {
                    ASTElementLimitExceeded.throwIt(n);
                }
                int loopCounter = n;
                if (size1 > 0) {
                    loopCounter = n * size1;
                }
                if ((iterationLimit = engine.getIterationLimit()) >= 0 && iterationLimit <= loopCounter) {
                    IterationLimitExceeded.throwIt(loopCounter, ast);
                }
                IASTAppendable result = F.ListAlloc(n);
                int start = size2 - size1 + 1;
                boolean isNumber = true;
                for (i = start; i < list2.size(); ++i) {
                    IExpr x = list2.get(i);
                    if (!x.isNumber()) {
                        isNumber = false;
                    }
                    result.append(x);
                    if (counter++ != n) continue;
                    return result;
                }
                if (isNumber) {
                    for (i = 1; i < list1.size(); ++i) {
                        if (list1.get(i).isNumber()) continue;
                        isNumber = false;
                    }
                }
                if (isNumber) {
                    while (counter < n) {
                        int size = result.size();
                        INumber num = F.C0;
                        int k = size - 1;
                        for (int i2 = 1; i2 < size1; ++i2) {
                            num = (INumber)num.plus(((INumber)list1.get(i2)).times(result.get(k--)));
                        }
                        result.append(num);
                        ++counter;
                    }
                } else {
                    long numberOfLeaves = n;
                    while (counter < n) {
                        int size = result.size();
                        IASTAppendable plusAST = F.PlusAlloc(size1);
                        int k = size - 1;
                        for (int i3 = 1; i3 < size1; ++i3) {
                            plusAST.append(F.Times(list1.get(i3), result.get(k--)));
                        }
                        IExpr temp = engine.evaluate(F.Expand(plusAST));
                        if ((numberOfLeaves += temp.leafCount()) >= (long)Config.MAX_AST_SIZE) {
                            ASTElementLimitExceeded.throwIt(numberOfLeaves);
                        }
                        result.append(temp);
                        ++counter;
                    }
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class KroneckerDelta
    extends AbstractEvaluator {
        private KroneckerDelta() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = ast.size();
            if (size == 1) {
                return F.C1;
            }
            if (size > 1) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                IExpr temp = arg1.evalNumber();
                if (temp == null) {
                    temp = arg1;
                }
                if (size == 2) {
                    if (temp.isZero()) {
                        return F.C1;
                    }
                    if (temp.isNonZeroComplexResult()) {
                        return F.C0;
                    }
                    return F.NIL;
                }
                arg1 = temp;
                for (int i = 2; i < size; ++i) {
                    IExpr expr = engine.evaluate(ast.get(i));
                    if (expr.equals(arg1)) continue;
                    temp = expr.evalNumber();
                    if (temp == null) {
                        return F.NIL;
                    }
                    if (temp.equals(arg1)) continue;
                    return F.C0;
                }
                return F.C1;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1124);
        }
    }

    private static class JacobiSymbol
    extends AbstractArg2 {
        private JacobiSymbol() {
        }

        @Override
        public IExpr e2IntArg(IInteger i0, IInteger i1) {
            try {
                if (i0.isNegative() || i1.isNegative()) {
                    return F.NIL;
                }
                return i0.jacobiSymbol(i1);
            }
            catch (ArithmeticException arithmeticException) {
                return F.NIL;
            }
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static final class FromContinuedFraction
    extends AbstractEvaluator {
        private FromContinuedFraction() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST list;
            if (ast.arg1().isList() && (list = (IAST)ast.arg1()).size() > 1) {
                try {
                    IExpr period = list.last();
                    if (period.isNonEmptyList()) {
                        IExpr[] solutions;
                        if (!((IAST)period).forAll(x -> x.isInteger())) {
                            return IOFunctions.printMessage(S.FromContinuedFraction, "root", F.CEmptyList, engine);
                        }
                        boolean nonNegative = ((IAST)period).forAll(x -> x.isNonNegativeResult());
                        ISymbol y = F.Dummy();
                        IASTAppendable periodicPart = ((IAST)period).copyAppendable(1);
                        periodicPart.append(y);
                        IExpr periodReduced = FromContinuedFraction.continuedFractionReduce(periodicPart, engine);
                        if (periodReduced.isPresent() && (solutions = F.solve(F.Equal((IExpr)F.Subtract(periodReduced, y), (IExpr)F.C0), y)).length > 0) {
                            IExpr solution = nonNegative ? solutions[solutions.length - 1] : solutions[0];
                            ISymbol x2 = F.Dummy();
                            IASTMutable nonPeriodicPart = list.setAtCopy(list.argSize(), x2);
                            IExpr nonPeriodReduced = FromContinuedFraction.continuedFractionReduce(nonPeriodicPart, engine);
                            if (nonPeriodReduced.isPresent()) {
                                return FromContinuedFraction.radSimplify(F.subst(nonPeriodReduced, arg -> arg.equals(x2) ? solution : F.NIL), engine);
                            }
                        }
                        return IOFunctions.printMessage(S.FromContinuedFraction, "root", F.CEmptyList, engine);
                    }
                    return FromContinuedFraction.continuedFractionReduce(list, engine);
                }
                catch (ArithmeticException aex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)aex);
                }
            }
            return F.NIL;
        }

        private static IExpr radSimplify(IExpr expr, EvalEngine engine) {
            expr = S.Together.of(engine, expr);
            IExpr numerator = S.Numerator.of(engine, expr);
            IExpr denominator = S.Expand.of(engine, F.Denominator(expr));
            if (!denominator.isFree(x -> x.isSqrt(), false)) {
                if (denominator.isPlus2()) {
                    IASTMutable plus = ((IAST)denominator).setAtCopy(2, denominator.second().negate());
                    IExpr squared = S.Expand.of(plus.times(denominator));
                    IExpr newNumerator = S.Expand.of(plus.times(numerator));
                    expr = F.Times(newNumerator, (IExpr)F.Power(squared, F.CN1));
                } else if (denominator.isTimes() || denominator.isSqrt()) {
                    IAST timesAST = (IAST)denominator;
                    IExpr squared = timesAST.times(timesAST);
                    expr = F.Times(numerator, (IExpr)timesAST, (IExpr)F.Power(squared, F.CN1));
                }
            }
            return S.Simplify.of(engine, expr);
        }

        private static IExpr continuedFractionReduce(IAST continuedFractionList, EvalEngine engine) {
            try {
                int size = continuedFractionList.argSize();
                if (continuedFractionList.forAll(x -> x.isReal())) {
                    IExpr result = continuedFractionList.get(size--);
                    for (int i = size; i >= 1; --i) {
                        result = continuedFractionList.get(i).plus(result.power(-1L));
                    }
                    return result;
                }
                IExpr result = continuedFractionList.get(size--);
                for (int i = size; i >= 1; --i) {
                    result = F.Plus(continuedFractionList.get(i), (IExpr)F.Power(result, F.CN1));
                }
                return result;
            }
            catch (ValidateException ve) {
                IOFunctions.printMessage((ISymbol)S.FromContinuedFraction, ve, engine);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class FrobeniusNumber
    extends AbstractFunctionEvaluator {
        private FrobeniusNumber() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            BigInteger[] array = Validate.checkListOfBigIntegers(ast, ast.arg1(), true, engine);
            if (array != null && array.length > 0) {
                BigInteger result = org.matheclipse.core.frobenius.FrobeniusNumber.frobeniusNumber(array);
                return F.ZZ(result);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Fibonacci
    extends AbstractFunctionEvaluator {
        private Fibonacci() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isInteger()) {
                int n = ((IInteger)arg1).toIntDefault();
                if (n > Integer.MIN_VALUE) {
                    if (ast.isAST2()) {
                        if (ast.arg2().isSymbol() || ast.arg2().isNumber() || ast.arg2().isAST()) {
                            return this.fibonacciPolynomialIterative(n, ast.arg2(), ast, engine);
                        }
                        return F.NIL;
                    }
                    return NumberTheory.fibonacci(n);
                }
            } else if (arg1.isInexactNumber()) {
                INumber n = ((INumber)arg1).evaluatePrecision(engine);
                if (ast.isAST2() && ast.arg2().isInexactNumber()) {
                    INumber x = ((INumber)ast.arg2()).evaluatePrecision(engine);
                    return F.Times((IExpr)F.Power((IExpr)F.Plus((IExpr)F.C4, (IExpr)F.Sqr(x)), F.CN1D2), (IExpr)F.Plus((IExpr)F.Times((IExpr)F.Power((IExpr)F.Power((IExpr)F.C2, n), F.CN1), (IExpr)F.Power((IExpr)F.Plus((IExpr)x, (IExpr)F.Sqrt(F.Plus((IExpr)F.C4, (IExpr)F.Sqr(x)))), n)), (IExpr)F.Times(F.CN1, F.Power((IExpr)F.C2, n), F.Power((IExpr)F.Power((IExpr)F.Plus((IExpr)x, (IExpr)F.Sqrt(F.Plus((IExpr)F.C4, (IExpr)F.Sqr(x)))), n), F.CN1), F.Cos(F.Times((IExpr)n, (IExpr)S.Pi)))));
                }
                return F.Times((IExpr)F.C1DSqrt5, (IExpr)F.Plus((IExpr)F.Power((IExpr)S.GoldenRatio, n), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)S.GoldenRatio, F.Negate(n)), (IExpr)F.Cos(F.Times((IExpr)S.Pi, (IExpr)n)))));
            }
            return F.NIL;
        }

        public IExpr fibonacciPolynomialIterative(int n, IExpr x, IAST ast, EvalEngine engine) {
            int iArg = n;
            if (n < 0) {
                n *= -1;
            }
            if (n > Config.MAX_POLYNOMIAL_DEGREE) {
                PolynomialDegreeLimitExceeded.throwIt(n);
            }
            IInteger previousFibonacci = F.C0;
            IExpr fibonacci = F.C1;
            if (n == 0) {
                return previousFibonacci;
            }
            if (n == 1) {
                return fibonacci;
            }
            int iterationLimit = engine.getIterationLimit();
            if (iterationLimit >= 0 && iterationLimit <= n) {
                IterationLimitExceeded.throwIt(n, ast);
            }
            for (int i = 1; i < n; ++i) {
                IInteger temp = fibonacci;
                fibonacci = fibonacci.isPlus() ? ((IAST)fibonacci).mapThread(F.Times(x, (IExpr)F.Slot1), 2) : F.Times(x, fibonacci);
                fibonacci = S.Expand.of(engine, F.Plus(fibonacci, (IExpr)previousFibonacci));
                previousFibonacci = temp;
            }
            if (iArg < 0 && (iArg & 1) == 0) {
                return F.Negate(fibonacci);
            }
            return fibonacci;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static class FactorInteger
    extends AbstractEvaluator {
        private FactorInteger() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() >= 2 && ast.size() <= 3) {
                OptionArgs options;
                IExpr option;
                IExpr arg1 = ast.arg1();
                if (ast.size() == 2) {
                    if (arg1.isRational()) {
                        return ((IRational)arg1).factorInteger();
                    }
                    return F.NIL;
                }
                if (ast.size() == 3 && (option = (options = new OptionArgs(ast.topHead(), ast, 2, engine)).getOption(S.GaussianIntegers)).isTrue()) {
                    BigInteger re = BigInteger.ONE;
                    if (arg1.isInteger()) {
                        re = ((IInteger)arg1).toBigNumerator();
                        return GaussianInteger.factorize(re, BigInteger.ZERO, arg1);
                    }
                    if (arg1.isComplex()) {
                        IComplex c = (IComplex)arg1;
                        IRational rer = c.getRealPart();
                        IRational imr = c.getImaginaryPart();
                        if (rer.isInteger() && imr.isInteger()) {
                            re = ((IInteger)rer).toBigNumerator();
                            BigInteger im = ((IInteger)imr).toBigNumerator();
                            return GaussianInteger.factorize(re, im, arg1);
                        }
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Factorial2
    extends AbstractTrigArg1 {
        private Factorial2() {
        }

        public static IInteger factorial2(IInteger iArg) {
            IInteger result = F.C1;
            IInteger biggi = iArg;
            if (biggi.compareTo(F.C0) == -1) {
                result = F.CN1;
                IInteger start = biggi.isOdd() ? F.CN3 : F.CN2;
                IInteger i = start;
                while (i.compareTo(biggi) >= 0) {
                    result = result.multiply(i);
                    i = i.add(F.CN2);
                }
            } else {
                IInteger start = biggi.isOdd() ? F.C3 : F.C2;
                IInteger i = start;
                while (i.compareTo(biggi) <= 0) {
                    result = result.multiply(i);
                    i = i.add(F.C2);
                }
            }
            return result;
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isInteger()) {
                if (!arg1.isNegative()) {
                    return Factorial2.factorial2((IInteger)arg1);
                }
                int n = ((IInteger)arg1).toIntDefault(0);
                if (n < 0) {
                    switch (n) {
                        case -1: {
                            return F.C1;
                        }
                        case -2: {
                            return F.CComplexInfinity;
                        }
                        case -3: {
                            return F.CN1;
                        }
                        case -4: {
                            return F.CComplexInfinity;
                        }
                        case -5: {
                            return F.C1D3;
                        }
                        case -6: {
                            return F.CComplexInfinity;
                        }
                        case -7: {
                            return F.fraction(-1L, 15L);
                        }
                    }
                }
            }
            if (arg1.isInfinity()) {
                return F.CInfinity;
            }
            if (arg1.isNegativeInfinity()) {
                return S.Indeterminate;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static class FactorialPower
    extends AbstractEvaluator {
        private FactorialPower() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int ni;
            IExpr x = ast.arg1();
            IExpr n = ast.arg2();
            if (ast.isAST2() && x.isInteger() && n.isInteger() && x.isNonNegativeResult() && n.isNonNegativeResult()) {
                if (((IInteger)x).isLT((IInteger)n)) {
                    return F.C0;
                }
                if (((IInteger)x).equals(n)) {
                    if (x.isZero()) {
                        return F.C1;
                    }
                    return x;
                }
            }
            if ((ni = n.toIntDefault()) >= 0) {
                int iterationLimit;
                if (Config.MAX_AST_SIZE < ni) {
                    ASTElementLimitExceeded.throwIt(ni);
                }
                if ((iterationLimit = EvalEngine.get().getIterationLimit()) <= ni) {
                    IterationLimitExceeded.throwIt(ni, ast);
                }
            } else if (n.isInteger()) {
                return F.NIL;
            }
            if (ast.isAST2()) {
                IExpr result = F.C1;
                if (engine.evalLess(n, F.C0)) {
                    return F.NIL;
                }
                if (n.isZero()) {
                    return F.C1;
                }
                if (n.isOne()) {
                    return x;
                }
                if (engine.isDoubleMode()) {
                    double real = Double.NaN;
                    try {
                        real = x.evalDouble();
                    }
                    catch (ArgumentTypeException ate) {
                        Complex temp = x.evalComplex();
                        if (temp == null) {
                            return F.NIL;
                        }
                        real = temp.getReal();
                    }
                    if (Double.isNaN(real)) {
                        return F.NIL;
                    }
                    double dN = n.evalDouble();
                    double i = real - dN + 1.0;
                    while (real >= i) {
                        result = result.multiply(x);
                        x = x.dec();
                        real -= 1.0;
                    }
                    return result;
                }
                if (x.isExactNumber() && n.isRational()) {
                    IRational real = (IRational)((INumber)x).re();
                    IRational dN = (IRational)n;
                    IRational i = real.subtract(dN).inc();
                    while (real.isGE(i)) {
                        result = result.multiply(x);
                        x = x.dec();
                        real = real.dec();
                    }
                    return result;
                }
                return F.NIL;
            }
            if (ast.isAST3()) {
                IExpr result = F.C1;
                IExpr h = ast.arg3();
                if (engine.evalTrue(F.Less(n, F.C0))) {
                    return F.NIL;
                }
                if (n.isZero()) {
                    return F.C1;
                }
                if (n.isOne()) {
                    return x;
                }
                if (engine.isDoubleMode()) {
                    double real = Double.NaN;
                    try {
                        real = x.evalDouble();
                    }
                    catch (ArgumentTypeException ate) {
                        Complex temp = x.evalComplex();
                        if (temp == null) {
                            return F.NIL;
                        }
                        real = temp.getReal();
                    }
                    if (Double.isNaN(real)) {
                        return F.NIL;
                    }
                    double dN = n.evalDouble();
                    double doubleH = h.evalDouble();
                    if (h.isZero()) {
                        while (engine.evalTrue(F.Greater(n, F.C0))) {
                            result = result.multiply(x);
                            n = n.dec();
                        }
                        return result;
                    }
                    if (engine.evalTrue(F.Greater(h, F.C0))) {
                        double i = real - (dN - 1.0) * doubleH;
                        while (real >= i) {
                            result = result.multiply(x);
                            x = x.minus(h);
                            real -= doubleH;
                        }
                        return result;
                    }
                    double i = real - (dN - 1.0) * doubleH;
                    while (real <= i) {
                        result = result.multiply(x);
                        x = x.minus(h);
                        real -= doubleH;
                    }
                    return result;
                }
                if (x.isExactNumber() && n.isRational() && h.isRational()) {
                    IRational real = (IRational)((INumber)x).re();
                    IRational dN = (IRational)n;
                    IRational H = (IRational)h;
                    if (H.isZero()) {
                        while (dN.isGT(F.C0)) {
                            result = result.multiply(x);
                            dN = dN.dec();
                        }
                        return result;
                    }
                    if (H.isGT(F.C0)) {
                        IRational i = real.subtract(dN.dec().multiply(H));
                        while (real.isGE(i)) {
                            result = result.multiply(x);
                            x = x.minus(H);
                            real = real.subtract(H);
                        }
                        return result;
                    }
                    IRational i = real.subtract(dN.dec().multiply(H));
                    while (real.isLE(i)) {
                        result = result.multiply(x);
                        x = x.minus(H);
                        real = real.subtract(H);
                    }
                    return result;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static class Factorial
    extends AbstractTrigArg1 {
        private Factorial() {
        }

        @Override
        public IExpr e1ComplexArg(Complex c) {
            return F.complexNum(Arithmetic.lanczosApproxGamma(c.add(1.0)));
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex c) {
            FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
            return F.complexNum(h.gamma(h.add(c, (Apcomplex)Apfloat.ONE)));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat d) {
            FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
            return F.num(h.gamma(h.add(d, (Apfloat)Apfloat.ONE)));
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            double d = Gamma.gamma((double)(arg1 + 1.0));
            return F.num(d);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isInteger()) {
                if (arg1.isNegative()) {
                    return F.CComplexInfinity;
                }
                return NumberTheory.factorial((IInteger)arg1);
            }
            if (arg1.isFraction()) {
                IFraction frac = (IFraction)arg1;
                if (arg1.equals(F.C1D2)) {
                    return F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(S.Pi));
                }
                if (arg1.equals(F.CN1D2)) {
                    return F.Sqrt(S.Pi);
                }
                if (frac.denominator().equals(F.C2)) {
                    return F.Gamma(frac.inc());
                }
            }
            if (arg1.isInfinity()) {
                return F.CInfinity;
            }
            if (arg1.isNegativeInfinity()) {
                return S.Indeterminate;
            }
            if (arg1.isDirectedInfinity()) {
                if (arg1.isComplexInfinity()) {
                    return S.Indeterminate;
                }
                if (arg1.isAST1() && (arg1.first().equals(F.CI) || arg1.first().equals(F.CNI))) {
                    return F.C0;
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static class ExtendedGCD
    extends AbstractFunctionEvaluator {
        private ExtendedGCD() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                return F.NIL;
            }
            BigInteger[] gcdArgs = new BigInteger[ast.argSize()];
            for (int i2 = 1; i2 < ast.size(); ++i2) {
                IExpr arg = ast.get(i2);
                if (!arg.isInteger()) {
                    return F.NIL;
                }
                if (!((IInteger)arg).isPositive()) {
                    return F.NIL;
                }
                gcdArgs[i2 - 1] = ((IInteger)ast.get(i2)).toBigNumerator();
            }
            try {
                BigInteger[] bezoutCoefficients = new BigInteger[ast.argSize()];
                BigInteger gcd = ExtendedGCD.extendedGCD(gcdArgs, bezoutCoefficients);
                IASTAppendable subList = F.ListAlloc(bezoutCoefficients.length);
                subList.appendArgs(0, bezoutCoefficients.length, i -> F.ZZ(bezoutCoefficients[i]));
                return F.list(F.ZZ(gcd), subList);
            }
            catch (ArithmeticException ae) {
                LOGGER.debug("ExtendedGCD.evaluate() failed", (Throwable)ae);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }

        public static BigInteger extendedGCD(BigInteger[] gcdArgs, BigInteger[] bezoutsCoefficients) {
            BigInteger gcd = gcdArgs[0];
            Object[] stepResult = ExtendedGCD.extendedGCD(gcdArgs[1], gcd);
            gcd = (BigInteger)stepResult[0];
            bezoutsCoefficients[0] = ((BigInteger[])stepResult[1])[0];
            bezoutsCoefficients[1] = ((BigInteger[])stepResult[1])[1];
            for (int i = 2; i < gcdArgs.length; ++i) {
                stepResult = ExtendedGCD.extendedGCD(gcdArgs[i], gcd);
                gcd = (BigInteger)stepResult[0];
                BigInteger factor = ((BigInteger[])stepResult[1])[0];
                for (int j = 0; j < i; ++j) {
                    bezoutsCoefficients[j] = bezoutsCoefficients[j].multiply(factor);
                }
                bezoutsCoefficients[i] = ((BigInteger[])stepResult[1])[1];
            }
            return gcd;
        }

        public static Object[] extendedGCD(BigInteger numberOne, BigInteger numberTwo) throws ArithmeticException {
            Object[] results = new Object[2];
            BigInteger gcd = BigInteger.ONE;
            BigInteger mValue = BigInteger.ONE;
            BigInteger nValue = BigInteger.ONE;
            BigInteger remainder = BigInteger.ONE;
            BigInteger xValue = BigInteger.ZERO;
            BigInteger lastxValue = BigInteger.ONE;
            BigInteger yValue = BigInteger.ONE;
            BigInteger lastyValue = BigInteger.ZERO;
            if (numberOne.compareTo(BigInteger.ZERO) != 0 && numberTwo.compareTo(BigInteger.ZERO) != 0 && numberOne.compareTo(BigInteger.ZERO) == 1 && numberTwo.compareTo(BigInteger.ZERO) == 1) {
                BigInteger divisor;
                BigInteger dividend;
                boolean exchange;
                if (numberOne.compareTo(numberTwo) == 1) {
                    exchange = false;
                    dividend = numberOne;
                    divisor = numberTwo;
                } else {
                    exchange = true;
                    dividend = numberTwo;
                    divisor = numberOne;
                }
                BigInteger[] divisionResult = null;
                while (remainder.compareTo(BigInteger.ZERO) != 0) {
                    divisionResult = dividend.divideAndRemainder(divisor);
                    BigInteger quotient = divisionResult[0];
                    remainder = divisionResult[1];
                    dividend = divisor;
                    divisor = remainder;
                    BigInteger tempValue = xValue;
                    xValue = lastxValue.subtract(quotient.multiply(xValue));
                    lastxValue = tempValue;
                    tempValue = yValue;
                    yValue = lastyValue.subtract(quotient.multiply(yValue));
                    lastyValue = tempValue;
                }
                gcd = dividend;
                if (exchange) {
                    mValue = lastyValue;
                    nValue = lastxValue;
                } else {
                    mValue = lastxValue;
                    nValue = lastyValue;
                }
            } else {
                throw new ArithmeticException("ExtendedGCD contains wrong arguments");
            }
            results[0] = gcd;
            BigInteger[] values = new BigInteger[]{nValue, mValue};
            results[1] = values;
            return results;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class EulerPhi
    extends AbstractTrigArg1 {
        private EulerPhi() {
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isInteger()) {
                try {
                    return ((IInteger)arg1).eulerPhi();
                }
                catch (ArithmeticException arithmeticException) {
                }
            } else {
                if (arg1.isPower() && arg1.exponent().isIntegerResult() && AbstractAssumptions.assumePrime(arg1.base()).isTrue()) {
                    IExpr p = arg1.base();
                    IExpr n = arg1.exponent();
                    return F.Subtract(arg1, F.Power(p, F.Subtract(n, F.C1)));
                }
                IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
                if (negExpr.isPresent()) {
                    return F.EulerPhi(negExpr);
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class EulerE
    extends AbstractTrigArg1 {
        private EulerE() {
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            int n;
            if (arg1.isInteger() && (n = ((IInteger)arg1).toIntDefault(-1)) >= 0) {
                if ((n & 1) == 1) {
                    return F.C0;
                }
                n /= 2;
                ArrayList<IInteger> a = new ArrayList<IInteger>();
                a.add(F.C1);
                a.add(F.C1);
                a.add(F.C5);
                a.add(AbstractIntegerSym.valueOf(61));
                IInteger eulerE = this.eulerE(a, n);
                if (n > 0) {
                    --n;
                    if ((n %= 2) == 0) {
                        eulerE = eulerE.negate();
                    }
                }
                return eulerE;
            }
            return F.NIL;
        }

        protected void set(List<IInteger> a, int n) {
            while (n >= a.size()) {
                IInteger val = F.C0;
                boolean sigPos = true;
                int thisn = a.size();
                for (int i = thisn - 1; i > 0; --i) {
                    IInteger f = a.get(i);
                    f = f.multiply(AbstractIntegerSym.valueOf(BigIntegerMath.binomial((int)(2 * thisn), (int)(2 * i))));
                    val = sigPos ? val.add(f) : val.subtract(f);
                    sigPos = !sigPos;
                }
                val = thisn % 2 == 0 ? val.subtract(F.C1) : val.add(F.C1);
                a.add(val);
            }
        }

        public IInteger eulerE(List<IInteger> a, int n) {
            this.set(a, n);
            return a.get(n);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class DivisorSigma
    extends AbstractFunctionEvaluator {
        private DivisorSigma() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg1.isOne() && arg2.isOne()) {
                return F.C1;
            }
            if (arg2.isInteger() && arg2.isPositive()) {
                IInteger n = (IInteger)arg2;
                return DivisorSigma.divisorSigma(arg1, n);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        private static IExpr divisorSigma(IExpr arg1, IInteger n) {
            IAST list = n.divisors();
            if (list.isList()) {
                int size = list.size();
                if (arg1.isOne()) {
                    IInteger sum = F.C0;
                    for (int i2 = 1; i2 < size; ++i2) {
                        sum = sum.add((IInteger)list.get(i2));
                    }
                    return sum;
                }
                if (arg1.isInteger()) {
                    IInteger k = (IInteger)arg1;
                    try {
                        long kl = k.toLong();
                        IInteger sum = F.C0;
                        for (int i3 = 1; i3 < size; ++i3) {
                            sum = sum.add(((IInteger)list.get(i3)).powerRational(kl));
                        }
                        return sum;
                    }
                    catch (ArithmeticException arithmeticException) {
                        // empty catch block
                    }
                }
                IASTAppendable sum = F.PlusAlloc(size);
                return sum.appendArgs(size, i -> F.Power(list.get(i), arg1));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class DivisorSum
    extends AbstractFunctionEvaluator {
        private DivisorSum() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST list;
            IInteger n;
            IExpr arg1 = ast.arg1();
            IExpr head = ast.arg2();
            IExpr condition = F.NIL;
            if (arg1.isInteger() && (n = (IInteger)arg1).isPositive() && (list = n.divisors()).isList()) {
                if (ast.isAST3()) {
                    condition = ast.arg3();
                }
                IASTAppendable sum = F.PlusAlloc(list.size());
                for (int i = 1; i < list.size(); ++i) {
                    IExpr divisor = list.get(i);
                    if (condition.isPresent() && !engine.evalTrue(condition, divisor)) continue;
                    sum.append(F.unaryAST1(head, divisor));
                }
                return sum;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Divisors
    extends AbstractTrigArg1 {
        private Divisors() {
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isInteger() && !arg1.isZero()) {
                IInteger i = (IInteger)arg1;
                if (i.isNegative()) {
                    i = i.negate();
                }
                return i.divisors();
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Divisible
    extends AbstractFunctionEvaluator {
        private Divisible() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                return list.mapThreadEvaled(engine, F.ListAlloc(list.size()), ast, 1);
            }
            IExpr result = engine.evaluate(F.Divide(ast.arg1(), ast.arg2()));
            if (result.isNumber()) {
                if (result.isComplex()) {
                    IComplex comp = (IComplex)result;
                    if (this.isSignedNumberDivisible(comp.re()).isTrue() && this.isSignedNumberDivisible(comp.im()).isTrue()) {
                        return S.True;
                    }
                    return S.False;
                }
                if (result.isReal()) {
                    return this.isSignedNumberDivisible((ISignedNumber)result);
                }
                return S.False;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }

        private IExpr isSignedNumberDivisible(ISignedNumber result) {
            if (result.isInteger()) {
                return S.True;
            }
            if (result.isNumIntValue()) {
                try {
                    result.toLong();
                    return S.True;
                }
                catch (ArithmeticException ae) {
                    return F.NIL;
                }
            }
            return S.False;
        }
    }

    private static class DiscreteDelta
    extends AbstractFunctionEvaluator {
        private DiscreteDelta() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = ast.size();
            if (size == 1) {
                return F.C1;
            }
            if (size > 1) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (size == 2) {
                    INumber temp = arg1.evalNumber();
                    if (temp != null) {
                        if (temp.isZero()) {
                            return F.C1;
                        }
                        if (temp.isNumber()) {
                            return F.C0;
                        }
                    }
                    if (arg1.isNonZeroComplexResult()) {
                        return F.C0;
                    }
                    return F.NIL;
                }
                IExpr result = DiscreteDelta.removeEval(ast, engine);
                if (result.isPresent()) {
                    if (result.isAST()) {
                        if (result.isAST() && ((IAST)result).size() > 1) {
                            return result;
                        }
                        return F.C1;
                    }
                    return result;
                }
            }
            return F.NIL;
        }

        private static IExpr removeEval(IAST ast, EvalEngine engine) {
            IASTAppendable result = F.NIL;
            int size = ast.size();
            int j = 1;
            for (int i = 1; i < size; ++i) {
                IExpr expr = engine.evaluate(ast.get(i));
                INumber temp = expr.evalNumber();
                if (temp != null) {
                    if (temp.isZero()) {
                        if (!result.isPresent()) {
                            result = ast.removeAtClone(i);
                            continue;
                        }
                        result.remove(j);
                        continue;
                    }
                    if (temp.isNumber()) {
                        return F.C0;
                    }
                }
                if (expr.isNonZeroComplexResult()) {
                    return F.C0;
                }
                ++j;
            }
            return result;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1124);
        }
    }

    private static class DiracDelta
    extends AbstractEvaluator {
        private DiracDelta() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = ast.size();
            IASTAppendable result = F.NIL;
            if (size > 1) {
                for (int i = 1; i < size; ++i) {
                    IExpr expr = ast.get(i);
                    ISignedNumber temp = expr.evalReal();
                    if (temp != null) {
                        if (temp.isZero()) {
                            return F.NIL;
                        }
                        return F.C0;
                    }
                    if (expr.isNonZeroRealResult()) {
                        return F.C0;
                    }
                    IExpr negated = AbstractFunctionEvaluator.getNormalizedNegativeExpression(expr);
                    if (negated.isPresent()) {
                        if (!result.isPresent()) {
                            result = F.ast(S.DiracDelta);
                        }
                        result.append(negated);
                        continue;
                    }
                    if (!result.isPresent()) continue;
                    result.append(expr);
                }
            }
            return result;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(516);
        }
    }

    private static class CoprimeQ
    extends AbstractFunctionEvaluator {
        private CoprimeQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = ast.size();
            if (size >= 3) {
                for (int i = 1; i < size - 1; ++i) {
                    IExpr expr = ast.get(i);
                    for (int j = i + 1; j < size; ++j) {
                        if (S.GCD.of(engine, expr, ast.get(j)).isOne()) continue;
                        return S.False;
                    }
                }
                return S.True;
            }
            return S.False;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static final class ContinuedFraction
    extends AbstractEvaluator {
        private ContinuedFraction() {
        }

        private IAST continuedFractionPeriodic(IInteger p, IInteger q, IInteger d, IInteger s, boolean negate, int maxIterations, EvalEngine engine) {
            IInteger x2;
            IExpr n;
            IExpr sd = F.Sqrt(d);
            if (q.isNegative()) {
                p = p.negate();
                q = q.negate();
                s = s.negate();
            }
            if ((n = S.Times.of(engine, F.Plus((IExpr)p, (IExpr)F.Times((IExpr)s, sd)))).isNegativeResult()) {
                IAST resultList = this.continuedFractionPeriodic(p.negate(), q, d, s.negate(), true, maxIterations, engine);
                if (resultList.isList()) {
                    return resultList;
                }
                return F.NIL;
            }
            d = d.multiply(s.multiply(s));
            sd = F.Times((IExpr)s, sd);
            if (!d.subtract(p.multiply(p)).mod(q).isZero()) {
                d = d.multiply(q.multiply(q));
                sd = S.Times.of(engine, sd, q);
                p = p.multiply(q);
                q = q.multiply(q);
            }
            IASTAppendable integerTerms = F.ListAlloc();
            HashMap<IAST, Integer> pqPeriodic2Index = new HashMap<IAST, Integer>();
            IAST key = F.list(p, q);
            do {
                pqPeriodic2Index.put(key, integerTerms.size() - 1);
                IExpr quotient = S.Quotient.of(engine, F.Plus((IExpr)p, sd), q);
                if (!quotient.isInteger()) {
                    return F.NIL;
                }
                x2 = (IInteger)quotient;
                integerTerms.append(x2);
            } while (!pqPeriodic2Index.containsKey(key = F.list(p = x2.multiply(q).subtract(p), q = d.subtract(p.multiply(p)).quotient(q))));
            int i = (Integer)pqPeriodic2Index.get(key);
            IAST tempList = integerTerms;
            if (negate) {
                tempList = tempList.map(x -> x.negate());
            }
            if (maxIterations < Integer.MAX_VALUE && maxIterations > 0) {
                IASTAppendable resultList = F.ListAlloc(maxIterations);
                for (int j = 1; j < i + 1; ++j) {
                    resultList.append(tempList.get(j));
                    if (--maxIterations != 0) continue;
                    return resultList;
                }
                IASTAppendable periodic = tempList.copyFrom(i + 1);
                block2: while (true) {
                    int j = 1;
                    while (true) {
                        if (j >= periodic.size()) continue block2;
                        resultList.append(periodic.get(j));
                        if (--maxIterations == 0) {
                            return resultList;
                        }
                        ++j;
                    }
                    break;
                }
            }
            IASTAppendable resultList = F.ListAlloc(i + 1);
            resultList.appendAll(tempList, 1, i + 1);
            resultList.append(tempList.copyFrom(i + 1));
            return resultList;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr num;
            IAST list4;
            IExpr arg1 = ast.arg1();
            if (arg1.isComplex() || arg1.isComplexNumeric()) {
                return IOFunctions.printMessage(S.ContinuedFraction, "realx", F.list(arg1), engine);
            }
            int maxIterations = Integer.MAX_VALUE;
            if (ast.isAST2()) {
                if (ast.arg2().isNumber()) {
                    maxIterations = ast.arg2().toIntDefault();
                    if (maxIterations <= 0) {
                        return IOFunctions.printMessage(S.ContinuedFraction, "intpm", F.list(ast, F.C2), engine);
                    }
                } else {
                    return F.NIL;
                }
            }
            if ((list4 = NumberTheory.quadraticIrrational(ast.arg1())).isPresent()) {
                return this.continuedFractionPeriodic((IInteger)list4.arg1(), (IInteger)list4.arg2(), (IInteger)list4.arg3(), (IInteger)list4.arg4(), false, maxIterations, engine);
            }
            if (arg1 instanceof INum) {
                return ContinuedFraction.realToContinuedFraction((INum)arg1, maxIterations, engine);
            }
            if ((arg1.isAST() || arg1.isSymbol() && arg1.isNumericFunction(true)) && (num = engine.evalN(arg1)) instanceof INum) {
                return ContinuedFraction.realToContinuedFraction((INum)num, maxIterations, engine);
            }
            if (arg1.isRational()) {
                IASTAppendable continuedFractionList;
                IRational rat = (IRational)arg1;
                if (rat.denominator().isOne()) {
                    continuedFractionList = F.ListAlloc(1);
                    continuedFractionList.append(rat.numerator());
                } else if (rat.numerator().isOne()) {
                    continuedFractionList = F.ListAlloc(2);
                    continuedFractionList.append(F.C0);
                    continuedFractionList.append(rat.denominator());
                } else {
                    IFraction temp = F.fraction(rat.numerator(), rat.denominator());
                    continuedFractionList = F.ListAlloc(10);
                    while (temp.denominator().compareInt(1) > 0 && 0 < maxIterations--) {
                        IInteger quotient = temp.numerator().div(temp.denominator());
                        IInteger remainder = temp.numerator().mod(temp.denominator());
                        continuedFractionList.append(quotient);
                        if (!(temp = F.fraction(temp.denominator(), remainder)).denominator().isOne()) continue;
                        continuedFractionList.append(temp.numerator());
                    }
                }
                return continuedFractionList;
            }
            return F.NIL;
        }

        private static IAST realToContinuedFraction(INum value, int iterationLimit, EvalEngine engine) {
            double doubleValue = value.getRealPart();
            if (value.isNumIntValue()) {
                return F.list(F.ZZ((int)Math.rint(doubleValue)));
            }
            IASTAppendable continuedFractionList = F.ListAlloc(iterationLimit > 0 && iterationLimit < 1000 ? iterationLimit + 10 : 100);
            int aNow = (int)doubleValue;
            double tNow = doubleValue - (double)aNow;
            continuedFractionList.append(aNow);
            for (int i = 0; i < iterationLimit - 1; ++i) {
                if (i >= 99) {
                    LOGGER.log(engine.getLogLevel(), "ContinuedFraction: calculations of double number values require a iteration limit less equal 100.");
                    return F.NIL;
                }
                double rec = 1.0 / tNow;
                int aNext = (int)rec;
                if (aNext == Integer.MAX_VALUE) break;
                double tNext = rec - (double)aNext;
                continuedFractionList.append(aNext);
                tNow = tNext;
            }
            return continuedFractionList;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static final class Convergents
    extends AbstractEvaluator {
        private Convergents() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                if (list.exists(x -> x.isList())) {
                    return F.NIL;
                }
                if (list.size() > 1) {
                    IASTAppendable plus;
                    int size = list.argSize();
                    IASTAppendable resultList = F.ListAlloc(list.size());
                    IASTAppendable result = plus = F.binary(S.Plus, F.C0, list.arg1());
                    for (int i = 2; i <= size; ++i) {
                        IExpr temp = result.isAST() ? engine.evaluate(F.Together(result.copy())) : engine.evaluate(result);
                        resultList.append(temp);
                        IASTAppendable plusAST = F.binary(S.Plus, F.C0, list.get(i));
                        plus.set(1, F.Power((IExpr)plusAST, F.CN1));
                        plus = plusAST;
                    }
                    resultList.append(engine.evaluate(F.Together(result)));
                    return resultList;
                }
                if (list.size() == 1) {
                    return F.CListC0;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(16384);
        }
    }

    private static class ChineseRemainder
    extends AbstractFunctionEvaluator {
        private ChineseRemainder() {
        }

        private static long bezout0(long a, long b) {
            long s = 0L;
            long old_s = 1L;
            long r = b;
            long old_r = a;
            while (r != 0L) {
                long q = old_r / r;
                long tmp = old_r;
                old_r = r;
                r = Math.subtractExact(tmp, Math.multiplyExact(q, r));
                tmp = old_s;
                old_s = s;
                s = Math.subtractExact(tmp, Math.multiplyExact(q, s));
            }
            if (old_r != 1L) {
                throw new ArithmeticException();
            }
            return old_s;
        }

        private static BigInteger bezout0(BigInteger a, BigInteger b) {
            BigInteger s = BigInteger.ZERO;
            BigInteger old_s = BigInteger.ONE;
            BigInteger r = b;
            BigInteger old_r = a;
            while (!r.equals(BigInteger.ZERO)) {
                BigInteger q = old_r.divide(r);
                BigInteger tmp = old_r;
                old_r = r;
                r = tmp.subtract(q.multiply(r));
                tmp = old_s;
                old_s = s;
                s = tmp.subtract(q.multiply(s));
            }
            if (!old_r.equals(BigInteger.ONE)) {
                throw new ArithmeticException();
            }
            return old_s;
        }

        private static long chineseRemaindersInt(int[] primes, int[] remainders) {
            if (primes.length != remainders.length) {
                String message = IOFunctions.getMessage("pilist", F.list(S.ChineseRemainder), EvalEngine.get());
                throw new ArgumentTypeException(message);
            }
            long modulus = primes[0];
            for (int i = 1; i < primes.length; ++i) {
                if (primes[i] <= 0) {
                    String message = IOFunctions.getMessage("pilist", F.list(S.ChineseRemainder), EvalEngine.get());
                    throw new ArgumentTypeException(message);
                }
                modulus = Math.multiplyExact((long)primes[i], modulus);
            }
            long result = 0L;
            for (int i = 0; i < primes.length; ++i) {
                long iModulus = modulus / (long)primes[i];
                long bezout = ChineseRemainder.bezout0(iModulus, primes[i]);
                result = Math.floorMod(Math.addExact(result, Math.floorMod(Math.multiplyExact(iModulus, Math.floorMod(Math.multiplyExact(bezout, remainders[i]), primes[i])), modulus)), modulus);
            }
            return result;
        }

        private static BigInteger chineseRemainders(BigInteger[] primes, BigInteger[] remainders) {
            if (primes.length != remainders.length) {
                String message = IOFunctions.getMessage("pilist", F.list(S.ChineseRemainder), EvalEngine.get());
                throw new ArgumentTypeException(message);
            }
            BigInteger m = primes[0];
            for (int i = 1; i < primes.length; ++i) {
                if (primes[i].signum() <= 0) {
                    String message = IOFunctions.getMessage("pilist", F.list(S.ChineseRemainder), EvalEngine.get());
                    throw new ArgumentTypeException(message);
                }
                m = primes[i].multiply(m);
            }
            BigInteger result = BigInteger.ZERO;
            for (int i = 0; i < primes.length; ++i) {
                BigInteger mi = m.divide(primes[i]);
                BigInteger eea = ChineseRemainder.bezout0(mi, primes[i]);
                result = result.add(mi.multiply(eea.multiply(remainders[i]).mod(primes[i]))).mod(m);
            }
            return result;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList() && ast.arg2().isList()) {
                int[] n;
                int[] a;
                block9: {
                    a = Validate.checkListOfInts(ast, ast.arg1(), false, true, engine);
                    if (a == null) {
                        return ChineseRemainder.chineseRemainderBigInteger(ast, engine);
                    }
                    n = Validate.checkListOfInts(ast, ast.arg2(), false, true, engine);
                    if (n == null) {
                        return ChineseRemainder.chineseRemainderBigInteger(ast, engine);
                    }
                    if (a.length != n.length) {
                        return F.NIL;
                    }
                    if (a.length != 0) break block9;
                    return F.NIL;
                }
                try {
                    return F.ZZ(ChineseRemainder.chineseRemaindersInt(n, a));
                }
                catch (ArithmeticException aex) {
                    try {
                        return ChineseRemainder.chineseRemainderBigInteger(ast, engine);
                    }
                    catch (ArithmeticException ae) {
                        LOGGER.debug("ChineseRemainder.evaluate() failed", (Throwable)ae);
                    }
                }
            }
            return F.NIL;
        }

        private static IExpr chineseRemainderBigInteger(IAST ast, EvalEngine engine) {
            BigInteger[] aBig = Validate.checkListOfBigIntegers(ast, ast.arg1(), false, engine);
            if (aBig == null) {
                return F.NIL;
            }
            BigInteger[] nBig = Validate.checkListOfBigIntegers(ast, ast.arg2(), false, engine);
            if (nBig == null) {
                return F.NIL;
            }
            if (aBig.length != nBig.length) {
                return F.NIL;
            }
            try {
                return F.ZZ(ChineseRemainder.chineseRemainders(nBig, aBig));
            }
            catch (ArithmeticException ae) {
                LOGGER.debug("ChineseRemainder.chineseRemainderBigInteger() failed", (Throwable)ae);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class CatalanNumber
    extends AbstractTrigArg1 {
        private CatalanNumber() {
        }

        @Override
        public IExpr evaluateArg1(IExpr n, EvalEngine engine) {
            if (n.isInteger()) {
                return NumberTheory.catalanNumber((IInteger)n);
            }
            return F.NIL;
        }

        @Override
        public IExpr numericEval(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            try {
                if (arg1.isInexactNumber()) {
                    return CatalanNumber.functionExpand(arg1);
                }
            }
            catch (LimitException le) {
                throw le;
            }
            catch (RuntimeException rex) {
                LOGGER.log(EvalEngine.get().getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                return F.NIL;
            }
            return this.evaluateArg1(arg1, engine);
        }

        private static IExpr functionExpand(IExpr n) {
            return F.Times((IExpr)F.Power((IExpr)F.C2, F.Times((IExpr)F.C2, n)), (IExpr)F.Gamma(F.Plus(n, (IExpr)F.C1D2)), (IExpr)F.Power((IExpr)F.Times((IExpr)F.Sqrt(S.Pi), (IExpr)F.Gamma(F.Plus(n, (IExpr)F.C2))), F.CN1));
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static class CarmichaelLambda
    extends AbstractTrigArg1 {
        private CarmichaelLambda() {
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isInteger()) {
                try {
                    return ((IInteger)arg1).charmichaelLambda();
                }
                catch (ArithmeticException arithmeticException) {
                }
            } else {
                IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
                if (negExpr.isPresent()) {
                    return F.CarmichaelLambda(negExpr);
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Binomial
    extends AbstractArg2 {
        private Binomial() {
        }

        @Override
        public IExpr e2IntArg(IInteger n, IInteger k) {
            return NumberTheory.binomial(n, k);
        }

        @Override
        public IExpr e2ObjArg(IAST ast, IExpr n, IExpr k) {
            int diff;
            int ki;
            if (n.isInteger() && k.isInteger()) {
                return F.NIL;
            }
            int ni = n.toIntDefault();
            if (ni != Integer.MIN_VALUE && (ki = k.toIntDefault()) != Integer.MIN_VALUE) {
                return NumberTheory.binomial(F.ZZ(ni), F.ZZ(ki));
            }
            if (n.isZero() && k.isZero()) {
                return F.C1;
            }
            if (k.isOne()) {
                return n;
            }
            if (k.isMinusOne()) {
                return F.C0;
            }
            if (k.isInteger()) {
                if (n.isInfinity()) {
                    if (k.isNegative()) {
                        return F.C0;
                    }
                    ki = k.toIntDefault();
                    if (ki >= 1 && ki <= 5) {
                        return S.Infinity;
                    }
                } else if (n.isNegativeInfinity()) {
                    if (k.isNegative()) {
                        return F.C0;
                    }
                    ki = k.toIntDefault();
                    if (ki >= 1 && ki <= 5) {
                        if (ki % 2 == 0) {
                            return F.CInfinity;
                        }
                        return F.CNInfinity;
                    }
                }
                if (k.isOne()) {
                    return n;
                }
                if (k.isZero()) {
                    return F.C1;
                }
                if (n.isDirectedInfinity()) {
                    return F.NIL;
                }
                IInteger ki2 = (IInteger)k;
                if (ki2.compareInt(6) < 0 && ki2.compareInt(1) > 0 && !n.isNumber()) {
                    int kInt = ki2.intValue();
                    IASTAppendable result = F.TimesAlloc(kInt);
                    IExpr nTemp = n;
                    for (int i = 1; i <= kInt; ++i) {
                        IAST temp = F.Divide(nTemp, F.ZZ(i));
                        result.append(temp);
                        nTemp = F.eval(F.Subtract(nTemp, F.C1));
                    }
                    return result;
                }
            }
            if (n.equals(k)) {
                return F.C1;
            }
            if (n.isNumber() && k.isNumber()) {
                IExpr n1 = ((INumber)n).add(F.C1);
                return F.Times((IExpr)F.Gamma(n1), F.Power((IExpr)F.Gamma(F.Plus((IExpr)F.C1, k)), -1L), F.Power((IExpr)F.Gamma(F.Plus(n1, F.Negate(k))), -1L));
            }
            IExpr difference = F.eval(F.Subtract(n, F.C1));
            if (difference.equals(k)) {
                return n;
            }
            difference = F.eval(F.Subtract(k, n));
            if (difference.isIntegerResult() && difference.isPositiveResult()) {
                return F.C0;
            }
            if (!n.isNumber() && !k.isNumber() && (diff = F.eval(F.Subtract(n, k)).toIntDefault(-1)) > 0 && diff <= 5) {
                IASTAppendable result = F.TimesAlloc(diff + 1);
                result.append(F.Power((IExpr)NumberTheory.factorial(diff), -1L));
                for (int i = 1; i <= diff; ++i) {
                    IAST temp = F.Plus((IExpr)F.ZZ(i), k);
                    result.append(temp);
                }
                return result;
            }
            IExpr boole = F.eval(F.Greater((IExpr)F.Times((IExpr)F.C2, k), n));
            if (boole.isTrue()) {
                return F.Binomial(n, F.Subtract(n, k));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static class BernoulliB
    extends AbstractFunctionEvaluator {
        private BernoulliB() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                try {
                    int bn = ast.arg1().toIntDefault();
                    if (bn >= 0) {
                        return NumberTheory.bernoulliNumber(bn);
                    }
                    IExpr temp = engine.evaluate(F.Subtract(ast.arg1(), F.C3));
                    if (temp.isIntegerResult() && temp.isPositiveResult() && temp.isEvenResult()) {
                        return F.C0;
                    }
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("BernoulliB.evaluate() failed", (Throwable)rex);
                }
                return F.NIL;
            }
            if (ast.isAST2()) {
                try {
                    IExpr n = ast.arg1();
                    IExpr x = ast.arg2();
                    int xInt = x.toIntDefault();
                    if (xInt != Integer.MIN_VALUE) {
                        if (xInt == 0) {
                            return F.BernoulliB(ast.arg1());
                        }
                        if (xInt == 1 && n.isIntegerResult()) {
                            return F.Times((IExpr)F.Power((IExpr)F.CN1, n), (IExpr)F.BernoulliB(n));
                        }
                    }
                    if (n.isInteger() && n.isNonNegativeResult()) {
                        if (x.isNumEqualRational(F.C1D2)) {
                            return F.Times((IExpr)F.Subtract(F.Power((IExpr)F.C2, F.Subtract(F.C1, n)), F.C1), (IExpr)F.BernoulliB(n));
                        }
                        int bn = n.toIntDefault();
                        if (bn >= 0) {
                            return F.sum(k -> F.Times((IExpr)F.Binomial(n, k), (IExpr)F.BernoulliB(F.Subtract(n, k)), (IExpr)F.Power(x, k)), 0, bn);
                        }
                    }
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("BernoulliB.evaluate() failed", (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static class BellB
    extends AbstractFunctionEvaluator {
        private BellB() {
        }

        private static IInteger bellNumber(int index) {
            if (index < BELLB_25.length) {
                return AbstractIntegerSym.valueOf(BELLB_25[index]);
            }
            IInteger sum = F.C1;
            for (int ki = 0; ki < index; ++ki) {
                if ((sum = sum.add(NumberTheory.stirlingS2(index, F.ZZ(ki), ki))).bitLength() <= (long)(Config.MAX_BIT_LENGTH / 100)) continue;
                BigIntegerLimitExceeded.throwIt(Config.MAX_BIT_LENGTH / 100);
            }
            return sum;
        }

        private static IExpr bellBPolynomial(int n, IExpr z) {
            if (n == 0) {
                return F.C1;
            }
            if (z.isZero()) {
                return F.C0;
            }
            if (n == 1) {
                return z;
            }
            IASTAppendable sum = F.PlusAlloc(n + 1);
            for (int k = 0; k <= n; ++k) {
                sum.append(F.Times((IExpr)F.StirlingS2(F.ZZ(n), F.ZZ(k)), F.Power(z, k)));
            }
            return sum;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IExpr arg1 = ast.arg1();
                int n = arg1.toIntDefault();
                if (n < 0 && arg1.isNumber()) {
                    return IOFunctions.printMessage(S.BellB, "intnm", F.list(ast, F.C1), engine);
                }
                if (ast.isAST2()) {
                    IExpr z = ast.arg2();
                    if (n == 0) {
                        return F.C1;
                    }
                    if (n == 1) {
                        return z;
                    }
                    if (z.isOne()) {
                        return F.BellB(arg1);
                    }
                    if (n > 1) {
                        if (z.isZero()) {
                            return F.C0;
                        }
                        if (n > Config.MAX_POLYNOMIAL_DEGREE) {
                            PolynomialDegreeLimitExceeded.throwIt(n);
                        }
                        if (!z.isOne()) {
                            return BellB.bellBPolynomial(n, z);
                        }
                    }
                } else {
                    if (n == 0) {
                        return F.C1;
                    }
                    if (n > 0) {
                        return BellB.bellNumber(n);
                    }
                }
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }
}

