/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.optim.OptimizationData;
import org.hipparchus.optim.PointValuePair;
import org.hipparchus.optim.linear.LinearConstraint;
import org.hipparchus.optim.linear.LinearConstraintSet;
import org.hipparchus.optim.linear.LinearObjectiveFunction;
import org.hipparchus.optim.linear.NonNegativeConstraint;
import org.hipparchus.optim.linear.PivotSelectionRule;
import org.hipparchus.optim.linear.SimplexSolver;
import org.hipparchus.optim.nonlinear.scalar.GoalType;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.Expr2LP;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.Matcher;
import org.matheclipse.core.polynomials.longexponent.ExprMonomial;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomial;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomialRing;
import org.matheclipse.core.polynomials.longexponent.ExprRingFactory;
import org.matheclipse.core.reflection.system.rules.FunctionRangeRules;
import org.matheclipse.core.visit.VisitorExpr;

public class MinMaxFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    private static IExpr maximize(ISymbol head, IExpr function, IExpr x, EvalEngine engine) {
        try {
            IAST temp = MinMaxFunctions.maximizeExprPolynomial(function, F.list(x));
            if (temp.isPresent()) {
                return temp;
            }
            IExpr yNInf = S.Limit.of(function, F.Rule(x, (IExpr)F.CNInfinity));
            if (yNInf.isInfinity()) {
                LOGGER.log(engine.getLogLevel(), "{}: the maximum cannot be found.", (Object)head);
                return F.list(F.CInfinity, F.list(F.Rule(x, (IExpr)F.CNInfinity)));
            }
            IExpr yInf = S.Limit.of(function, F.Rule(x, (IExpr)F.CInfinity));
            if (yInf.isInfinity()) {
                LOGGER.log(engine.getLogLevel(), "{}: the maximum cannot be found.", (Object)head);
                return F.list(F.CInfinity, F.list(F.Rule(x, (IExpr)F.CInfinity)));
            }
            IExpr first_derivative = S.D.of(engine, function, x);
            IExpr second_derivative = S.D.of(engine, first_derivative, x);
            IExpr candidates = S.Solve.of(engine, F.Equal(first_derivative, (IExpr)F.C0), x, S.Reals);
            if (candidates.isFree(S.Solve)) {
                IExpr maxCandidate = F.NIL;
                IExpr maxValue = F.CNInfinity;
                if (candidates.isListOfLists()) {
                    for (int i = 1; i < candidates.size(); ++i) {
                        IExpr candidate = ((IAST)candidates).get(i).first().second();
                        IExpr value = engine.evaluate(F.subs(second_derivative, x, candidate));
                        if (!value.isNegative()) continue;
                        IExpr functionValue = engine.evaluate(F.subs(function, x, candidate));
                        if (!S.Greater.ofQ(functionValue, maxValue)) continue;
                        maxValue = functionValue;
                        maxCandidate = candidate;
                    }
                    if (maxCandidate.isPresent()) {
                        return F.list(maxValue, F.list(F.Rule(x, maxCandidate)));
                    }
                }
                return F.CEmptyList;
            }
        }
        catch (RuntimeException rex) {
            LOGGER.log(engine.getLogLevel(), (Object)head, (Throwable)rex);
        }
        return F.NIL;
    }

    private static IAST maximizeExprPolynomial(IExpr expr, IAST varList) {
        IAST result = F.NIL;
        try {
            ExprPolynomialRing ring = new ExprPolynomialRing(ExprRingFactory.CONST, varList);
            ExprPolynomial ePoly = ring.create(expr, false, false, false);
            ePoly = ePoly.multiplyByMinimumNegativeExponents();
            result = MinMaxFunctions.maximizeCubicPolynomial(ePoly, varList.arg1());
            return result;
        }
        catch (ArithmeticException | JASConversionException e2) {
            LOGGER.debug("MinMaxFunctions.maximizeExprPolynomial() failed", (Throwable)e2);
            return result;
        }
    }

    private static IAST maximizeCubicPolynomial(ExprPolynomial polynomial, IExpr x) {
        long varDegree = polynomial.degree(0);
        if (varDegree <= 3L) {
            IExpr a = F.C0;
            IExpr b = F.C0;
            IExpr c = F.C0;
            IExpr d = F.C0;
            IExpr e = F.C0;
            for (ExprMonomial monomial : polynomial) {
                IExpr coeff = monomial.coefficient();
                long lExp = monomial.exponent().getVal(0);
                if (lExp == 4L) {
                    a = coeff;
                    continue;
                }
                if (lExp == 3L) {
                    b = coeff;
                    continue;
                }
                if (lExp == 2L) {
                    c = coeff;
                    continue;
                }
                if (lExp == 1L) {
                    d = coeff;
                    continue;
                }
                if (lExp == 0L) {
                    e = coeff;
                    continue;
                }
                throw new ArithmeticException("Maximize::Unexpected exponent value: " + lExp);
            }
            if (a.isPossibleZero(false)) {
                if (b.isPossibleZero(false)) {
                    if (c.isPossibleZero(false)) {
                        if (d.isPossibleZero(false)) {
                            return F.list(e, F.CEmptyList);
                        }
                        return F.list(F.Piecewise(F.list(F.list(e, F.Equal(d, (IExpr)F.C0))), F.CInfinity), F.list(F.Rule(x, (IExpr)F.Piecewise(F.list(F.list(F.C0, F.Equal(d, (IExpr)F.C0))), S.Indeterminate))));
                    }
                    return F.List(F.Piecewise(F.list(F.list(e, F.And((IExpr)F.Equal(d, 0), (IExpr)F.LessEqual(c, 0))), F.list(F.Times((IExpr)F.C1D4, F.Power(c, -1L), (IExpr)F.Plus((IExpr)F.Times(-1L, F.Power(d, 2L)), (IExpr)F.Times(4L, c, e))), F.Or((IExpr)F.And((IExpr)F.Greater(d, 0), (IExpr)F.Less(c, 0)), (IExpr)F.And((IExpr)F.Less(d, 0), (IExpr)F.Less(c, 0))))), F.CInfinity), F.list(F.Rule(x, (IExpr)F.Piecewise(F.list(F.list(F.Times((IExpr)F.CN1D2, F.Power(c, -1L), d), F.Or((IExpr)F.And((IExpr)F.Greater(d, 0), (IExpr)F.Less(c, 0)), (IExpr)F.And((IExpr)F.Less(d, 0), (IExpr)F.Less(c, 0)))), F.list(F.C0, F.And((IExpr)F.Equal(d, 0), (IExpr)F.LessEqual(c, 0)))), S.Indeterminate))));
                }
                return F.list(F.Piecewise(F.list(F.list(e, F.Or((IExpr)F.And((IExpr)F.Equal(d, (IExpr)F.C0), (IExpr)F.Equal(c, (IExpr)F.C0), (IExpr)F.Equal(b, (IExpr)F.C0)), (IExpr)F.And((IExpr)F.Equal(d, (IExpr)F.C0), (IExpr)F.Less(c, F.C0), (IExpr)F.Equal(b, (IExpr)F.C0)))), F.list(F.Times((IExpr)F.C1D4, (IExpr)F.Power(c, F.CN1), (IExpr)F.Plus(F.Negate(F.Sqr(d)), (IExpr)F.Times((IExpr)F.C4, c, e))), F.Or((IExpr)F.And((IExpr)F.Greater(d, F.C0), (IExpr)F.Less(c, F.C0), (IExpr)F.Equal(b, (IExpr)F.C0)), (IExpr)F.And((IExpr)F.Less(d, F.C0), (IExpr)F.Less(c, F.C0), (IExpr)F.Equal(b, (IExpr)F.C0))))), F.oo), F.list(F.Rule(x, (IExpr)F.Piecewise(F.list(F.list(F.Times((IExpr)F.CN1D2, (IExpr)F.Power(c, F.CN1), d), F.Or((IExpr)F.And((IExpr)F.Greater(d, F.C0), (IExpr)F.Less(c, F.C0), (IExpr)F.Equal(b, (IExpr)F.C0)), (IExpr)F.And((IExpr)F.Less(d, F.C0), (IExpr)F.Less(c, F.C0), (IExpr)F.Equal(b, (IExpr)F.C0)))), F.list(F.C0, F.Or((IExpr)F.And((IExpr)F.Equal(d, (IExpr)F.C0), (IExpr)F.Equal(c, (IExpr)F.C0), (IExpr)F.Equal(b, (IExpr)F.C0)), (IExpr)F.And((IExpr)F.Equal(d, (IExpr)F.C0), (IExpr)F.Less(c, F.C0), (IExpr)F.Equal(b, (IExpr)F.C0))))), F.Indeterminate))));
            }
        }
        return F.NIL;
    }

    private static final IExpr minimize(ISymbol head, IExpr function, IExpr x, EvalEngine engine) {
        try {
            IAST temp = MinMaxFunctions.minimizeExprPolynomial(function, F.list(x));
            if (temp.isPresent()) {
                return temp;
            }
            IExpr yNInf = S.Limit.of(function, F.Rule(x, (IExpr)F.CNInfinity));
            if (yNInf.isNegativeInfinity()) {
                LOGGER.log(engine.getLogLevel(), "{}: the maximum cannot be found.", (Object)head);
                return F.list(F.CNInfinity, F.list(F.Rule(x, (IExpr)F.CNInfinity)));
            }
            IExpr yInf = S.Limit.of(function, F.Rule(x, (IExpr)F.CInfinity));
            if (yInf.isNegativeInfinity()) {
                LOGGER.log(engine.getLogLevel(), "{}: the maximum cannot be found.", (Object)head);
                return F.list(F.CNInfinity, F.list(F.Rule(x, (IExpr)F.CInfinity)));
            }
            IExpr first_derivative = S.D.of(engine, function, x);
            IExpr second_derivative = S.D.of(engine, first_derivative, x);
            IExpr candidates = S.Solve.of(engine, F.Equal(first_derivative, (IExpr)F.C0), x, S.Reals);
            if (candidates.isFree(S.Solve)) {
                IExpr minCandidate = F.NIL;
                IExpr minValue = F.CInfinity;
                if (candidates.isListOfLists()) {
                    for (int i = 1; i < candidates.size(); ++i) {
                        IExpr candidate = ((IAST)candidates).get(i).first().second();
                        IExpr value = engine.evaluate(F.subs(second_derivative, x, candidate));
                        if (!value.isPositiveResult()) continue;
                        IExpr functionValue = engine.evaluate(F.subs(function, x, candidate));
                        if (!S.Less.ofQ(functionValue, minValue)) continue;
                        minValue = functionValue;
                        minCandidate = candidate;
                    }
                    if (minCandidate.isPresent()) {
                        return F.list(minValue, F.list(F.Rule(x, minCandidate)));
                    }
                }
                return F.CEmptyList;
            }
        }
        catch (RuntimeException rex) {
            LOGGER.log(engine.getLogLevel(), (Object)head, (Throwable)rex);
        }
        return F.NIL;
    }

    private static IAST minimizeExprPolynomial(IExpr expr, IAST varList) {
        IAST result = F.NIL;
        try {
            ExprPolynomialRing ring = new ExprPolynomialRing(ExprRingFactory.CONST, varList);
            ExprPolynomial ePoly = ring.create(expr, false, false, false);
            ePoly = ePoly.multiplyByMinimumNegativeExponents();
            result = MinMaxFunctions.minimizeCubicPolynomial(ePoly, varList.arg1());
            return result;
        }
        catch (ArithmeticException | JASConversionException e2) {
            LOGGER.debug("MinMaxFunctions.minimizeExprPolynomial() failed", (Throwable)e2);
            return result;
        }
    }

    private static IAST minimizeCubicPolynomial(ExprPolynomial polynomial, IExpr x) {
        long varDegree = polynomial.degree(0);
        if (varDegree <= 3L) {
            IExpr a = F.C0;
            IExpr b = F.C0;
            IExpr c = F.C0;
            IExpr d = F.C0;
            IExpr e = F.C0;
            for (ExprMonomial monomial : polynomial) {
                IExpr coeff = monomial.coefficient();
                long lExp = monomial.exponent().getVal(0);
                if (lExp == 4L) {
                    a = coeff;
                    continue;
                }
                if (lExp == 3L) {
                    b = coeff;
                    continue;
                }
                if (lExp == 2L) {
                    c = coeff;
                    continue;
                }
                if (lExp == 1L) {
                    d = coeff;
                    continue;
                }
                if (lExp == 0L) {
                    e = coeff;
                    continue;
                }
                throw new ArithmeticException("Minimize::Unexpected exponent value: " + lExp);
            }
            if (a.isPossibleZero(false)) {
                if (b.isPossibleZero(false)) {
                    if (c.isPossibleZero(false)) {
                        if (d.isPossibleZero(false)) {
                            return F.list(e, F.CEmptyList);
                        }
                        return F.list(F.Piecewise(F.list(F.list(e, F.Equal(d, (IExpr)F.C0))), F.CNInfinity), F.list(F.Rule(x, (IExpr)F.Piecewise(F.list(F.list(F.C0, F.Equal(d, (IExpr)F.C0))), S.Indeterminate))));
                    }
                    return F.List(F.Piecewise(F.list(F.list(e, F.And((IExpr)F.Equal(d, 0), (IExpr)F.GreaterEqual(c, 0))), F.list(F.Times((IExpr)F.C1D4, F.Power(c, -1L), (IExpr)F.Plus((IExpr)F.Times(-1L, F.Power(d, 2L)), (IExpr)F.Times(4L, c, e))), F.Or((IExpr)F.And((IExpr)F.Greater(d, 0), (IExpr)F.Greater(c, 0)), (IExpr)F.And((IExpr)F.Less(d, 0), (IExpr)F.Greater(c, 0))))), F.CNInfinity), F.list(F.Rule(x, (IExpr)F.Piecewise(F.list(F.list(F.Times((IExpr)F.CN1D2, F.Power(c, -1L), d), F.Or((IExpr)F.And((IExpr)F.Greater(d, 0), (IExpr)F.Greater(c, 0)), (IExpr)F.And((IExpr)F.Less(d, 0), (IExpr)F.Greater(c, 0)))), F.list(F.C0, F.And((IExpr)F.Equal(d, 0), (IExpr)F.GreaterEqual(c, 0)))), S.Indeterminate))));
                }
                return F.list(F.Piecewise(F.list(F.list(e, F.Or((IExpr)F.And((IExpr)F.Equal(d, (IExpr)F.C0), (IExpr)F.Equal(c, (IExpr)F.C0), (IExpr)F.Equal(b, (IExpr)F.C0)), (IExpr)F.And((IExpr)F.Equal(d, (IExpr)F.C0), (IExpr)F.Greater(c, F.C0), (IExpr)F.Equal(b, (IExpr)F.C0)))), F.list(F.Times((IExpr)F.C1D4, (IExpr)F.Power(c, F.CN1), (IExpr)F.Plus(F.Negate(F.Sqr(d)), (IExpr)F.Times((IExpr)F.C4, c, e))), F.Or((IExpr)F.And((IExpr)F.Greater(d, F.C0), (IExpr)F.Greater(c, F.C0), (IExpr)F.Equal(b, (IExpr)F.C0)), (IExpr)F.And((IExpr)F.Less(d, F.C0), (IExpr)F.Greater(c, F.C0), (IExpr)F.Equal(b, (IExpr)F.C0))))), F.Noo), F.list(F.Rule(x, (IExpr)F.Piecewise(F.list(F.list(F.Times((IExpr)F.CN1D2, (IExpr)F.Power(c, F.CN1), d), F.Or((IExpr)F.And((IExpr)F.Greater(d, F.C0), (IExpr)F.Greater(c, F.C0), (IExpr)F.Equal(b, (IExpr)F.C0)), (IExpr)F.And((IExpr)F.Less(d, F.C0), (IExpr)F.Greater(c, F.C0), (IExpr)F.Equal(b, (IExpr)F.C0)))), F.list(F.C0, F.Or((IExpr)F.And((IExpr)F.Equal(d, (IExpr)F.C0), (IExpr)F.Equal(c, (IExpr)F.C0), (IExpr)F.Equal(b, (IExpr)F.C0)), (IExpr)F.And((IExpr)F.Equal(d, (IExpr)F.C0), (IExpr)F.Greater(c, F.C0), (IExpr)F.Equal(b, (IExpr)F.C0))))), F.Indeterminate))));
            }
        }
        return F.NIL;
    }

    public static void initialize() {
        Initializer.init();
    }

    private MinMaxFunctions() {
    }

    private static class NMinimize
    extends AbstractFunctionEvaluator {
        private NMinimize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return this.numericEval(ast, engine);
        }

        @Override
        public IExpr numericEval(IAST ast, EvalEngine engine) {
            try {
                if (ast.arg1().isList() && ast.arg2().isList()) {
                    IAST list1 = (IAST)ast.arg1();
                    IAST list2 = (IAST)ast.arg2();
                    VariablesSet vars = new VariablesSet(list2);
                    if (list1.isAST2()) {
                        IExpr function = list1.arg1();
                        IExpr listOfconstraints = list1.arg2();
                        if (listOfconstraints.isAnd()) {
                            LinearObjectiveFunction objectiveFunction = NMinimize.getObjectiveFunction(vars, function);
                            List<LinearConstraint> constraints = NMinimize.getConstraints(vars, (IAST)listOfconstraints);
                            return NMinimize.simplexSolver(vars, objectiveFunction, new OptimizationData[]{objectiveFunction, new LinearConstraintSet(constraints), GoalType.MINIMIZE, new NonNegativeConstraint(true), PivotSelectionRule.BLAND});
                        }
                    }
                }
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (MathRuntimeException e) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)e);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        protected static LinearObjectiveFunction getObjectiveFunction(VariablesSet vars, IExpr objectiveFunction) {
            Expr2LP x2LP = new Expr2LP(objectiveFunction, vars);
            return x2LP.expr2ObjectiveFunction();
        }

        protected static List<LinearConstraint> getConstraints(VariablesSet vars, IAST listOfconstraints) {
            ArrayList<LinearConstraint> constraints = new ArrayList<LinearConstraint>(listOfconstraints.size());
            listOfconstraints.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> {
                Expr2LP x2LP = new Expr2LP((IExpr)x, vars);
                constraints.add(x2LP.expr2Constraint());
            }));
            return constraints;
        }

        protected static IExpr simplexSolver(VariablesSet vars, LinearObjectiveFunction f, OptimizationData ... optData) throws MathRuntimeException {
            SimplexSolver solver = new SimplexSolver();
            PointValuePair solution = solver.optimize(optData);
            double[] values = solution.getPointRef();
            IASTAppendable list = F.ListAlloc(values.length);
            List<IExpr> varList = vars.getArrayList();
            for (int i = 0; i < values.length; ++i) {
                list.append(F.Rule(varList.get(i), (IExpr)F.num(values[i])));
            }
            IAST result = F.list(F.num(f.value(values)), list);
            return result;
        }
    }

    private static final class NMaximize
    extends NMinimize {
        private NMaximize() {
        }

        @Override
        public IExpr numericEval(IAST ast, EvalEngine engine) {
            try {
                if (ast.arg1().isList() && ast.arg2().isList()) {
                    IAST list1 = (IAST)ast.arg1();
                    IAST list2 = (IAST)ast.arg2();
                    VariablesSet vars = new VariablesSet(list2);
                    if (list1.isAST2()) {
                        IExpr function = list1.arg1();
                        IExpr listOfconstraints = list1.arg2();
                        if (listOfconstraints.isAnd()) {
                            LinearObjectiveFunction objectiveFunction = NMaximize.getObjectiveFunction(vars, function);
                            List<LinearConstraint> constraints = NMaximize.getConstraints(vars, (IAST)listOfconstraints);
                            return NMaximize.simplexSolver(vars, objectiveFunction, new OptimizationData[]{objectiveFunction, new LinearConstraintSet(constraints), GoalType.MAXIMIZE, new NonNegativeConstraint(true), PivotSelectionRule.BLAND});
                        }
                    }
                }
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (MathRuntimeException e) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)e);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class Minimize
    extends AbstractFunctionEvaluator {
        private Minimize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 3) {
                IExpr function = ast.arg1();
                IExpr x = ast.arg2();
                if (x.isAST(S.List, 2)) {
                    x = ast.arg2().first();
                }
                ISymbol head = ast.topHead();
                if (x.isSymbol() || x.isAST() && !x.isList()) {
                    return MinMaxFunctions.minimize(head, function, x, engine);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class Maximize
    extends AbstractFunctionEvaluator {
        private Maximize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 3) {
                IExpr function = ast.arg1();
                IExpr x = ast.arg2();
                if (x.isAST(S.List, 2)) {
                    x = ast.arg2().first();
                }
                ISymbol head = ast.topHead();
                if (x.isSymbol() || x.isAST() && !x.isList()) {
                    return MinMaxFunctions.maximize(head, function, x, engine);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class FunctionRange
    extends AbstractFunctionEvaluator
    implements FunctionRangeRules {
        private static Supplier<Matcher> LAZY_MATCHER;

        private FunctionRange() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr function = ast.arg1();
            IExpr xExpr = ast.arg2();
            IExpr yExpr = ast.arg3();
            IBuiltInSymbol domain = S.Reals;
            try {
                if (xExpr.isSymbol() && yExpr.isSymbol()) {
                    IExpr match = FunctionRange.callMatcher(ast, function, engine);
                    if (match.isPresent()) {
                        return match;
                    }
                    boolean evaled = true;
                    ISymbol x = (ISymbol)xExpr;
                    ISymbol y = (ISymbol)yExpr;
                    IExpr min = engine.evalQuiet(F.Minimize(function, xExpr));
                    IExpr max = engine.evalQuiet(F.Maximize(function, xExpr));
                    IASTMutable minMaxList = F.binaryAST2((IExpr)S.List, F.CNInfinity, (IExpr)F.CInfinity);
                    if (min.isAST(S.List, 3)) {
                        minMaxList.set(1, min.first());
                    } else {
                        evaled = false;
                    }
                    if (max.isAST(S.List, 3)) {
                        minMaxList.set(2, max.first());
                    } else {
                        evaled = false;
                    }
                    if (evaled) {
                        return this.convertMinMaxList(minMaxList, y);
                    }
                    IExpr f = function.replaceAll(F.Rule((IExpr)x, (IExpr)F.Interval(F.CNInfinity, F.CInfinity))).orElse(function);
                    IExpr result = engine.evaluate(f);
                    if (result.isInterval1()) {
                        return this.convertInterval(result, y);
                    }
                    if (domain.equals(S.Reals)) {
                        IExpr temp = result;
                        while (temp.isPresent()) {
                            if (!(temp = temp.accept(new FunctionRangeRealsVisitor(engine))).isPresent()) continue;
                            temp = result = engine.evaluate(temp);
                        }
                        if (result.isInterval1()) {
                            return this.convertInterval(result, y);
                        }
                    }
                }
            }
            catch (RuntimeException rex) {
                rex.printStackTrace();
                LOGGER.debug("FunctionRange.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        private IExpr convertInterval(IExpr result, ISymbol y) {
            IAST list = (IAST)result.first();
            return this.convertMinMaxList(list, y);
        }

        private IExpr convertMinMaxList(IAST list, ISymbol y) {
            if (list.arg1().isRealResult()) {
                if (list.arg2().isInfinity()) {
                    return F.GreaterEqual((IExpr)y, list.arg1());
                }
                if (list.arg2().isRealResult()) {
                    return F.LessEqual(list.arg1(), y, list.arg2());
                }
            } else if (list.arg2().isRealResult() && list.arg1().isNegativeInfinity() && !list.arg2().isInfinity()) {
                return F.LessEqual((IExpr)y, list.arg2());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        private static Matcher getMatcher() {
            return LAZY_MATCHER.get();
        }

        public static IExpr callMatcher(IAST ast, IExpr arg1, EvalEngine engine) {
            IExpr temp = FunctionRange.getMatcher().replaceAll(ast);
            if (temp.isPresent()) {
                engine.putCache(ast, temp);
            }
            return temp;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            LAZY_MATCHER = Suppliers.memoize(() -> Initializer.init());
        }

        private static final class FunctionRangeRealsVisitor
        extends VisitorExpr {
            final EvalEngine engine;

            public FunctionRangeRealsVisitor(EvalEngine engine) {
                this.engine = engine;
            }

            @Override
            public IExpr visit3(IExpr head, IExpr arg1, IExpr arg2) {
                boolean evaled = false;
                IExpr x1 = arg1;
                IExpr result = arg1.accept(this);
                if (result.isPresent()) {
                    evaled = true;
                    x1 = result;
                }
                IExpr x2 = arg2;
                result = arg2.accept(this);
                if (result.isPresent()) {
                    evaled = true;
                    x2 = result;
                }
                if (head.equals(S.Power) && x1.isInterval1()) {
                    IAST interval = (IAST)x1;
                    IExpr l = interval.lower();
                    IExpr u = interval.upper();
                    if (x2.isMinusOne() && S.GreaterEqual.ofQ(this.engine, l, F.C1)) {
                        return F.Interval(F.Power(u, x2), F.Power(l, x2));
                    }
                    if (l.isNegativeResult() && u.isPositiveResult()) {
                        if (x2.isPositiveResult()) {
                            return F.Interval(F.C0, F.Power(u, x2));
                        }
                        if (x2.isEvenResult() || x2.isFraction() && ((IFraction)x2).denominator().isEven()) {
                            return F.Interval(F.C0, F.Power(u, x2));
                        }
                    }
                }
                if (evaled) {
                    return F.binaryAST2(head, x1, x2);
                }
                return F.NIL;
            }
        }

        private static class Initializer {
            private Initializer() {
            }

            private static Matcher init() {
                Matcher MATCHER = new Matcher();
                IAST list = FunctionRangeRules.RULES;
                for (int i = 1; i < list.size(); ++i) {
                    IExpr arg = list.get(i);
                    if (arg.isAST(S.SetDelayed, 3)) {
                        MATCHER.caseOf(arg.first(), arg.second());
                        continue;
                    }
                    if (!arg.isAST(S.Set, 3)) continue;
                    MATCHER.caseOf(arg.first(), arg.second());
                }
                return MATCHER;
            }
        }
    }

    private static class ArgMin
    extends AbstractEvaluator {
        private ArgMin() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST subList;
            IExpr result;
            IExpr x = ast.arg2();
            if ((x.isSymbol() || x.isAST() && !x.isList()) && (result = MinMaxFunctions.minimize(ast.topHead(), ast.arg1(), x, engine)).isList() && result.last().isList() && (subList = (IAST)result.last()).last().isRule()) {
                return subList.last().second();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class ArgMax
    extends AbstractEvaluator {
        private ArgMax() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST subList;
            IExpr result;
            IExpr x = ast.arg2();
            if ((x.isSymbol() || x.isAST() && !x.isList()) && (result = MinMaxFunctions.maximize(ast.topHead(), ast.arg1(), x, engine)).isList() && result.last().isList() && (subList = (IAST)result.last()).last().isRule()) {
                return subList.last().second();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.ArgMax.setEvaluator(new ArgMax());
            S.ArgMin.setEvaluator(new ArgMin());
            S.FunctionRange.setEvaluator(new FunctionRange());
            S.Maximize.setEvaluator(new Maximize());
            S.Minimize.setEvaluator(new Minimize());
            S.NMaximize.setEvaluator(new NMaximize());
            S.NMinimize.setEvaluator(new NMinimize());
        }
    }
}

