/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.io.StringWriter;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.complex.Complex;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.hipparchus.stat.descriptive.moment.StandardDeviation;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.basic.ToggleFeature;
import org.matheclipse.core.builtin.GraphicsFunctions;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.convert.RGBColor;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.TeXUtilities;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.output.JavaScriptFormFactory;
import org.matheclipse.core.generic.UnaryNumerical;
import org.matheclipse.core.graphics.Dimensions2D;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import tech.tablesaw.plotly.components.Figure;
import tech.tablesaw.plotly.components.Layout;
import tech.tablesaw.plotly.traces.BarTrace;
import tech.tablesaw.plotly.traces.HeatmapTrace;
import tech.tablesaw.plotly.traces.Histogram2DTrace;
import tech.tablesaw.plotly.traces.HistogramTrace;
import tech.tablesaw.plotly.traces.PieTrace;
import tech.tablesaw.plotly.traces.Trace;

public class ManipulateFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean AUTOSIZE = true;
    public static int WIDTH = 600;
    public static int HEIGHT = 400;
    private static final int N = 100;
    private static final String JSXGRAPH = "`1`\n`2`\n`3`\n";
    private static final String MATHCELL = "var parent = document.currentScript.parentNode;\nvar id = generateId();\nparent.id = id;\nMathCell( id, [ `1` ] );\n\nparent.update = function( id ) {\n\n`2`\n`3`\n`4`\n}\nparent.update( id );\n";

    private static IExpr redirectToManipulate(IAST ast, EvalEngine engine) {
        IExpr temp;
        if (Config.USE_MANIPULATE_JS && (temp = S.Manipulate.of(engine, ast)).headID() == 696) {
            return temp;
        }
        return F.NIL;
    }

    private static void realRange(StringBuilder graphicControl, IAST plotRange, int steps, JavaScriptFormFactory toJS) {
        graphicControl.append("[");
        toJS.convert(graphicControl, plotRange.arg2());
        graphicControl.append(", ");
        toJS.convert(graphicControl, plotRange.arg3());
        if (steps > 0) {
            graphicControl.append(", ");
            graphicControl.append(steps);
        }
        graphicControl.append("]");
    }

    private static double[] complexRange(StringBuilder graphicControl, IAST plotRange, int steps, JavaScriptFormFactory toJS) {
        double[] result = new double[2];
        IExpr zMin = plotRange.arg2();
        IExpr zMax = plotRange.arg3();
        Complex cMin = zMin.evalComplex();
        Complex cMax = zMax.evalComplex();
        if (cMin != null && cMax != null) {
            double reMin = cMin.getReal();
            double imMin = cMin.getImaginary();
            double reMax = cMax.getReal();
            double imMax = cMax.getImaginary();
            if (reMin > reMax) {
                double r = reMax;
                reMax = reMin;
                reMin = r;
            }
            if (imMin > imMax) {
                double i = imMax;
                imMax = imMin;
                imMin = i;
            }
            result[0] = reMax - reMin;
            result[1] = imMax - imMin;
            graphicControl.append(", [");
            toJS.convert(graphicControl, F.num(reMin));
            graphicControl.append(", ");
            toJS.convert(graphicControl, F.num(reMax));
            if (steps > 0) {
                graphicControl.append(", ");
                graphicControl.append(steps);
            }
            graphicControl.append("], [");
            toJS.convert(graphicControl, F.num(imMin));
            graphicControl.append(", ");
            toJS.convert(graphicControl, F.num(imMax));
            if (steps > 0) {
                graphicControl.append(", ");
                graphicControl.append(steps);
            }
            graphicControl.append("]");
        }
        return result;
    }

    private static void sequencePointListPlot(IAST ast, int arg, IAST pointList, JavaScriptFormFactory toJS, StringBuilder function, double[] boundingbox, int[] colour, EvalEngine engine) {
        block7: {
            RGBColor color;
            block6: {
                IAST point;
                int i;
                int n = colour[0];
                colour[0] = n + 1;
                color = GraphicsFunctions.plotStyleColor(n, F.NIL);
                if (!ast.arg1().isAST(S.ListLinePlot) || pointList.size() <= 2) break block6;
                IAST lastPoint = F.NIL;
                boolean isConnected = false;
                int start = Integer.MAX_VALUE;
                for (i = 1; i < pointList.size(); ++i) {
                    point = (IAST)pointList.get(i);
                    if (ManipulateFunction.isNonReal(point.arg1(), point.arg2())) continue;
                    lastPoint = point;
                    start = i + 1;
                    break;
                }
                if (start >= Integer.MAX_VALUE) break block7;
                ManipulateFunction.xBoundingBox(engine, boundingbox, lastPoint.arg1());
                ManipulateFunction.yBoundingBox(engine, boundingbox, lastPoint.arg2());
                for (i = start; i < pointList.size(); ++i) {
                    point = (IAST)pointList.get(i);
                    if (ManipulateFunction.isNonReal(point.arg1(), point.arg2())) {
                        if (!isConnected && lastPoint.isPresent()) {
                            ManipulateFunction.xBoundingBox(engine, boundingbox, lastPoint.arg1());
                            ManipulateFunction.yBoundingBox(engine, boundingbox, lastPoint.arg2());
                            function.append("board.create('point', [");
                            function.append("function() {return ");
                            toJS.convert(function, lastPoint.arg1());
                            function.append(";}");
                            function.append(",");
                            function.append("function() {return ");
                            toJS.convert(function, lastPoint.arg2());
                            function.append(";}");
                            function.append("], ");
                            function.append(" {color:'");
                            function.append(Convert.toHex(color));
                            function.append("' ,name:'', face:'o', size: 2 } );\n");
                        }
                        lastPoint = F.NIL;
                        isConnected = false;
                        continue;
                    }
                    if (lastPoint.isPresent()) {
                        function.append("board.create('line',");
                        ManipulateFunction.xBoundingBox(engine, boundingbox, point.arg1());
                        ManipulateFunction.yBoundingBox(engine, boundingbox, point.arg2());
                        function.append("[[");
                        function.append("function() {return ");
                        toJS.convert(function, lastPoint.arg1());
                        function.append(";}");
                        function.append(",");
                        function.append("function() {return ");
                        toJS.convert(function, lastPoint.arg2());
                        function.append(";}");
                        function.append("],");
                        function.append("[");
                        function.append("function() {return ");
                        toJS.convert(function, point.arg1());
                        function.append(";}");
                        function.append(",");
                        function.append("function() {return ");
                        toJS.convert(function, point.arg2());
                        function.append(";}");
                        function.append("]],");
                        function.append(" {color:'");
                        function.append(Convert.toHex(color));
                        function.append("', straightFirst:false, straightLast:false, strokeWidth:2});\n");
                        isConnected = true;
                    }
                    lastPoint = point;
                }
                break block7;
            }
            for (int i = 1; i < pointList.size(); ++i) {
                IAST point = (IAST)pointList.get(i);
                if (ManipulateFunction.isNonReal(point.arg1(), point.arg2())) continue;
                ManipulateFunction.xBoundingBox(engine, boundingbox, point.arg1());
                ManipulateFunction.yBoundingBox(engine, boundingbox, point.arg2());
                function.append("board.create('point', [");
                function.append("function() {return ");
                toJS.convert(function, point.arg1());
                function.append(";}");
                function.append(",");
                function.append("function() {return ");
                toJS.convert(function, point.arg2());
                function.append(";}");
                function.append("], ");
                function.append(" {color:'");
                function.append(Convert.toHex(color));
                function.append("' ,name:'', face:'o', size: 2 } );\n");
            }
        }
    }

    private static void sequenceYValuesListPlot(IAST ast, int arg, IAST pointList, JavaScriptFormFactory toJS, StringBuilder function, double[] boundingbox, int[] colour, EvalEngine engine) {
        block7: {
            RGBColor color;
            block6: {
                IExpr currentPointY;
                int i;
                int n = colour[0];
                colour[0] = n + 1;
                color = GraphicsFunctions.plotStyleColor(n, F.NIL);
                ManipulateFunction.xBoundingBox(engine, boundingbox, F.C0);
                ManipulateFunction.xBoundingBox(engine, boundingbox, F.ZZ(pointList.size()));
                if (!ast.arg1().isAST(S.ListLinePlot)) break block6;
                IExpr lastPoint = F.NIL;
                int lastPosition = -1;
                boolean isConnected = false;
                int start = Integer.MAX_VALUE;
                for (i = 1; i < pointList.size(); ++i) {
                    currentPointY = pointList.get(i);
                    if (ManipulateFunction.isNonReal(currentPointY)) continue;
                    lastPoint = currentPointY;
                    lastPosition = i;
                    start = i + 1;
                    break;
                }
                if (start >= Integer.MAX_VALUE) break block7;
                ManipulateFunction.yBoundingBox(engine, boundingbox, lastPoint);
                for (i = start; i < pointList.size(); ++i) {
                    currentPointY = pointList.get(i);
                    if (ManipulateFunction.isNonReal(currentPointY)) {
                        if (!isConnected && lastPoint.isPresent()) {
                            ManipulateFunction.yBoundingBox(engine, boundingbox, lastPoint);
                            function.append("board.create('point', [");
                            function.append("function() {return " + lastPosition + ";}");
                            function.append(",");
                            function.append("function() {return ");
                            toJS.convert(function, lastPoint);
                            function.append(";}");
                            function.append("],");
                            function.append(" {color:'");
                            function.append(Convert.toHex(color));
                            function.append("' ,name:'', face:'o', size: 2 } );\n");
                        }
                        lastPoint = F.NIL;
                        lastPosition = -1;
                        isConnected = false;
                        continue;
                    }
                    if (lastPoint.isPresent()) {
                        ManipulateFunction.yBoundingBox(engine, boundingbox, currentPointY);
                        function.append("board.create('line',");
                        function.append("[[");
                        function.append("function() {return " + lastPosition + ";}");
                        function.append(",");
                        function.append("function() {return ");
                        toJS.convert(function, lastPoint);
                        function.append(";}");
                        function.append("],");
                        function.append("[");
                        function.append("function() {return " + i + ";}");
                        function.append(",");
                        function.append("function() {return ");
                        toJS.convert(function, currentPointY);
                        function.append(";}");
                        function.append("]],");
                        function.append(" {color:'");
                        function.append(Convert.toHex(color));
                        function.append("' ,straightFirst:false, straightLast:false, strokeWidth:2});\n");
                        isConnected = true;
                    }
                    lastPoint = currentPointY;
                    lastPosition = i;
                }
                break block7;
            }
            for (int i = 1; i < pointList.size(); ++i) {
                IExpr currentPointY = pointList.get(i);
                if (ManipulateFunction.isNonReal(currentPointY)) continue;
                ManipulateFunction.yBoundingBox(engine, boundingbox, currentPointY);
                function.append("board.create('point', [");
                function.append("function() {return " + i + ";}");
                function.append(",");
                function.append("function() {return ");
                toJS.convert(function, pointList.get(i));
                function.append(";}");
                function.append("], ");
                function.append(" {color:'");
                function.append(Convert.toHex(color));
                function.append("' ,name:'', face:'o', size: 2 } );\n");
            }
        }
    }

    private static boolean isNonReal(IExpr lastPoint) {
        return lastPoint == S.Indeterminate || lastPoint == S.None || lastPoint.isAST(S.Missing);
    }

    private static boolean isNonReal(IExpr lastPointX, IExpr lastPointY) {
        return ManipulateFunction.isNonReal(lastPointX) || ManipulateFunction.isNonReal(lastPointY);
    }

    private static void unaryJSFunction(JavaScriptFormFactory toJS, StringBuilder function, ISymbol plotSymbolX, IAST listOfFunctions, int i) {
        toJS.setVariables(plotSymbolX);
        function.append("{ try { return [");
        toJS.convert(function, listOfFunctions.get(i));
        function.append("];} catch(e) { return Number.NaN;} }\n");
    }

    public static void unaryPlotParameters(ISymbol xVariable, double xMin, double xMax, IExpr yFunction, Dimensions2D autoPlotRange, EvalEngine engine) {
        double step = (xMax - xMin) / 100.0;
        UnaryNumerical f1 = yFunction.isList() && yFunction.isAST1() ? new UnaryNumerical(yFunction.first(), xVariable, engine) : new UnaryNumerical(yFunction, xVariable, engine);
        double[][] data = new double[2][101];
        double x = xMin;
        for (int i = 0; i < 101; ++i) {
            double y = f1.value(x);
            data[0][i] = x;
            data[1][i] = y;
            x += step;
        }
        double[] vMinMax = ManipulateFunction.automaticPlotRange(data[1]);
        autoPlotRange.minMax(xMin, x, vMinMax[0], vMinMax[1]);
    }

    public static void binaryPlotParameters(ISymbol timeVariable, double timeMin, double timeMax, IExpr xFunction, IExpr yFunction, Dimensions2D plotRange, EvalEngine engine) {
        double step = (timeMax - timeMin) / 100.0;
        UnaryNumerical f1Unary = new UnaryNumerical(xFunction, timeVariable, engine);
        UnaryNumerical f2Unary = new UnaryNumerical(yFunction, timeVariable, engine);
        double[][] data = new double[2][101];
        double t = timeMin;
        for (int i = 0; i < 101; ++i) {
            data[0][i] = f1Unary.value(t);
            data[1][i] = f2Unary.value(t);
            t += step;
        }
        double[] xMinMax = ManipulateFunction.automaticPlotRange(data[0]);
        double[] yMinMax = ManipulateFunction.automaticPlotRange(data[1]);
        plotRange.minMax(xMinMax[0], xMinMax[1], yMinMax[0], yMinMax[1]);
    }

    public static void polarPlotParameters(ISymbol xVariable, double xMin, double xMax, IExpr yFunction, Dimensions2D plotRange, EvalEngine engine) {
        double step = (xMax - xMin) / 100.0;
        UnaryNumerical f1 = new UnaryNumerical(yFunction, xVariable, engine);
        double[][] data = new double[2][101];
        double x = xMin;
        for (int i = 0; i < 101; ++i) {
            double y = f1.value(x);
            data[0][i] = y * Math.cos(x);
            data[1][i] = y * Math.sin(x);
            x += step;
        }
        double[] xMinMax = ManipulateFunction.automaticPlotRange(data[0]);
        double[] yMinMax = ManipulateFunction.automaticPlotRange(data[1]);
        plotRange.minMax(xMinMax[0], xMinMax[1], yMinMax[0], yMinMax[1]);
    }

    private static double[] automaticPlotRange(double[] values) {
        double v;
        int i;
        double thresh = 2.0;
        double[] yValues = new double[values.length];
        System.arraycopy(values, 0, yValues, 0, values.length);
        Arrays.sort(yValues);
        if (Math.abs(yValues[0]) < 100.0 && Math.abs(yValues[values.length - 1]) < 100.0) {
            return new double[]{yValues[0], yValues[values.length - 1]};
        }
        double valavg = new Mean().evaluate(yValues);
        double valdev = new StandardDeviation().evaluate(yValues, valavg);
        if (Double.isFinite(valavg) && Double.isFinite(valdev)) {
            int n1 = 0;
            int n2 = values.length - 1;
            if (valdev != 0.0) {
                for (double v2 : yValues) {
                    if (!Double.isFinite(v2)) continue;
                    if (Math.abs(v2 - valavg) / valdev < thresh) break;
                    ++n1;
                }
                for (int i2 = yValues.length - 1; i2 >= 0; --i2) {
                    double v3 = yValues[i2];
                    if (!Double.isFinite(v3)) continue;
                    if (Math.abs(v3 - valavg) / valdev < thresh) break;
                    --n2;
                }
            }
            double vrange = yValues[n2] - yValues[n1];
            double vmin = yValues[n1] - 0.05 * vrange;
            double vmax = yValues[n2] + 0.05 * vrange;
            return new double[]{vmin, vmax};
        }
        double vmin = -5.0;
        double vmax = 5.0;
        for (i = 0; i < yValues.length; ++i) {
            v = yValues[i];
            if (!Double.isFinite(v) || !(v >= -5.0) || !(v <= 5.0)) continue;
            vmin = v;
            break;
        }
        for (i = yValues.length - 1; i >= 0; --i) {
            v = yValues[i];
            if (!Double.isFinite(v) || !(v >= -5.0) || !(v <= 5.0)) continue;
            vmax = v;
            break;
        }
        return new double[]{vmin, vmax};
    }

    private static int[] calcHistogram(double[] data, double min, double max, int numBins) {
        int[] result = new int[numBins];
        double binSize = (max - min) / (double)numBins;
        for (double d : data) {
            int bin = (int)((d - min) / binSize);
            if (bin < 0 || bin >= numBins) continue;
            int n = bin;
            result[n] = result[n] + 1;
        }
        return result;
    }

    @Deprecated
    private static IExpr sequenceBarChart(IAST ast, IAST pointList, JavaScriptFormFactory toJS, EvalEngine engine) {
        StringBuilder function = new StringBuilder();
        double[] boundingbox = new double[]{0.0, 0.0, (double)pointList.size() - 0.5, 0.0};
        if (ast.arg1().isAST(S.Histogram)) {
            function.append("var dataArr = [");
            double[] dData = pointList.toDoubleVector();
            if (dData == null) {
                return F.NIL;
            }
            double min = StatUtils.min((double[])dData);
            double max = StatUtils.max((double[])dData);
            double defaultRange = (max - min) / 0.5;
            int nRanges = (int)Math.ceil(defaultRange);
            if (nRanges < 10) {
                nRanges = 10;
            }
            if (nRanges > 100) {
                nRanges = 100;
            }
            defaultRange = (max - min) / (double)nRanges;
            int[] buckets = ManipulateFunction.calcHistogram(dData, min, max, nRanges);
            boundingbox = new double[]{min, 0.0, max, 0.0};
            for (int i = 0; i < buckets.length; ++i) {
                IInteger value = F.ZZ(buckets[i]);
                toJS.convert(function, value);
                ManipulateFunction.yBoundingBox(engine, boundingbox, value);
                if (i >= buckets.length - 1) continue;
                function.append(",");
            }
            function.append("];\n");
        } else if (ast.arg1().isAST(S.BarChart)) {
            function.append("var dataArr = [");
            boundingbox = new double[]{0.0, 0.0, (double)pointList.size() - 0.5, 0.0};
            for (int i = 1; i < pointList.size(); ++i) {
                IExpr currentPointY = pointList.get(i);
                if (ManipulateFunction.isNonReal(currentPointY)) continue;
                toJS.convert(function, currentPointY);
                ManipulateFunction.yBoundingBox(engine, boundingbox, currentPointY);
                if (i >= pointList.size() - 1) continue;
                function.append(",");
            }
            function.append("];\n");
        }
        function.append("board.create('chart', dataArr,");
        if (ast.arg1().isAST(S.Histogram)) {
            function.append(" {chartStyle:'bar',width:1.0,labels:dataArr} );\n");
            return JSXGraph.boundingBox(ast, boundingbox, function.toString(), toJS, true, true);
        }
        function.append(" {chartStyle:'bar',width:0.6,labels:dataArr} );\n");
        return JSXGraph.boundingBox(ast, boundingbox, function.toString(), toJS, false, true);
    }

    private static void xBoundingBox(EvalEngine engine, double[] boundingbox, IExpr xExpr) {
        try {
            double xValue = engine.evalDouble(xExpr);
            if (Double.isFinite(xValue)) {
                if (xValue < boundingbox[0]) {
                    boundingbox[0] = xValue;
                }
                if (xValue > boundingbox[2]) {
                    boundingbox[2] = xValue;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static void xBoundingBoxFunctionRange(double[] boundingbox, Dimensions2D plotRange) {
        if (plotRange != null) {
            double xValue = plotRange.xMin;
            if (Double.isFinite(xValue) && xValue < boundingbox[0]) {
                boundingbox[0] = xValue;
            }
            if (Double.isFinite(xValue = plotRange.xMax) && xValue > boundingbox[2]) {
                boundingbox[2] = xValue;
            }
        }
    }

    private static void yBoundingBoxFunctionRange(double[] boundingbox, Dimensions2D plotRange) {
        if (plotRange != null) {
            double yValue = plotRange.yMin;
            if (Double.isFinite(yValue) && yValue < boundingbox[3]) {
                boundingbox[3] = yValue;
            }
            if (Double.isFinite(yValue = plotRange.yMax) && yValue > boundingbox[1]) {
                boundingbox[1] = yValue;
            }
        }
    }

    private static void xBoundingBoxFunctionRange(EvalEngine engine, double[] boundingbox, IExpr functionRange) {
        if (functionRange.isPresent()) {
            double xValue2;
            IExpr l = F.NIL;
            IExpr u = F.NIL;
            if ((functionRange.isAST(S.LessEqual, 4) || functionRange.isAST(S.Less, 4)) && functionRange.second().isSymbol()) {
                l = functionRange.first();
                u = functionRange.last();
            } else if ((functionRange.isAST(S.GreaterEqual, 4) || functionRange.isAST(S.Greater, 4)) && functionRange.second().isSymbol()) {
                u = functionRange.first();
                l = functionRange.last();
            } else if ((functionRange.isAST(S.LessEqual, 3) || functionRange.isAST(S.Less, 4)) && functionRange.first().isSymbol()) {
                u = functionRange.second();
            } else if ((functionRange.isAST(S.GreaterEqual, 3) || functionRange.isAST(S.Greater, 4)) && functionRange.first().isSymbol()) {
                l = functionRange.second();
            }
            if (l.isPresent()) {
                try {
                    xValue2 = engine.evalDouble(l);
                    if (Double.isFinite(xValue2) && xValue2 < boundingbox[0]) {
                        boundingbox[0] = xValue2;
                    }
                }
                catch (RuntimeException xValue2) {
                    // empty catch block
                }
            }
            if (u.isPresent()) {
                try {
                    xValue2 = engine.evalDouble(u);
                    if (Double.isFinite(xValue2) && xValue2 > boundingbox[2]) {
                        boundingbox[2] = xValue2;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    private static void yBoundingBoxFunctionRange(EvalEngine engine, double[] boundingbox, IExpr functionRange) {
        if (functionRange.isPresent()) {
            double yValue2;
            IExpr l = F.NIL;
            IExpr u = F.NIL;
            if ((functionRange.isAST(S.LessEqual, 4) || functionRange.isAST(S.Less, 4)) && functionRange.second().isSymbol()) {
                l = functionRange.first();
                u = functionRange.last();
            } else if ((functionRange.isAST(S.GreaterEqual, 4) || functionRange.isAST(S.Greater, 4)) && functionRange.second().isSymbol()) {
                u = functionRange.first();
                l = functionRange.last();
            } else if ((functionRange.isAST(S.LessEqual, 3) || functionRange.isAST(S.Less, 4)) && functionRange.first().isSymbol()) {
                u = functionRange.second();
            } else if ((functionRange.isAST(S.GreaterEqual, 3) || functionRange.isAST(S.Greater, 4)) && functionRange.first().isSymbol()) {
                l = functionRange.second();
            }
            if (l.isPresent()) {
                try {
                    yValue2 = engine.evalDouble(l);
                    if (Double.isFinite(yValue2) && yValue2 < boundingbox[3]) {
                        boundingbox[3] = yValue2;
                    }
                }
                catch (RuntimeException yValue2) {
                    // empty catch block
                }
            }
            if (u.isPresent()) {
                try {
                    yValue2 = engine.evalDouble(u);
                    if (Double.isFinite(yValue2) && yValue2 > boundingbox[1]) {
                        boundingbox[1] = yValue2;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    private static void yBoundingBox(EvalEngine engine, double[] boundingbox, IExpr yExpr) {
        try {
            double yValue = engine.evalDouble(yExpr);
            if (Double.isFinite(yValue)) {
                if (yValue > boundingbox[1]) {
                    boundingbox[1] = yValue;
                }
                if (yValue < boundingbox[3]) {
                    boundingbox[3] = yValue;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void initialize() {
        if (ToggleFeature.MANIPULATE) {
            Initializer.init();
        }
    }

    private ManipulateFunction() {
    }

    private static class Manipulate
    extends AbstractEvaluator {
        private Manipulate() {
        }

        private static IAST checkJSXGraphPlots(IExpr expr, EvalEngine engine) {
            if (expr.isList()) {
                IAST listOfSymbols = (IAST)expr;
                for (int i = 1; i < listOfSymbols.size(); ++i) {
                    IExpr arg = listOfSymbols.get(i);
                    if (arg.isAST(S.ListLinePlot) || arg.isAST(S.ListPlot) || arg.isAST(S.Plot) || arg.isAST(S.ParametricPlot) || arg.isAST(S.PolarPlot)) continue;
                    return F.NIL;
                }
                return listOfSymbols;
            }
            if (expr.isAST(S.ListLinePlot) || expr.isAST(S.ListPlot) || expr.isAST(S.Plot) || expr.isAST(S.ParametricPlot) || expr.isAST(S.PolarPlot)) {
                return F.list(expr);
            }
            return F.NIL;
        }

        @Override
        public IExpr evaluate(IAST manipulateAST, EvalEngine engine) {
            try {
                IExpr arg1 = manipulateAST.arg1();
                IAST plots = Manipulate.checkJSXGraphPlots(arg1, engine);
                if (plots.isPresent()) {
                    return JSXGraph.showPlots(manipulateAST, engine, plots);
                }
                if (arg1.isAST(S.BarChart) || arg1.isAST(S.BoxWhiskerChart) || arg1.isAST(S.DensityHistogram) || arg1.isAST(S.Histogram) || arg1.isAST(S.MatrixPlot) || arg1.isAST(S.PieChart)) {
                    return Plotly.plot((IAST)arg1, manipulateAST, engine);
                }
                if (arg1.isAST(S.Plot3D) || arg1.isAST(S.ComplexPlot3D) || arg1.isAST(S.ContourPlot) || arg1.isAST(S.DensityPlot)) {
                    IAST plot = (IAST)arg1;
                    if (plot.size() >= 3) {
                        if (!plot.arg2().isList3() || !plot.arg2().first().isSymbol()) {
                            return IOFunctions.printMessage(plot.topHead(), "pllim", F.list(plot.arg2()), engine);
                        }
                        IAST plotRangeX = (IAST)plot.arg2();
                        IAST plotRangeY = F.NIL;
                        if (plot.size() >= 4) {
                            if (plot.arg3().isList3()) {
                                plotRangeY = (IAST)plot.arg3();
                            } else if (!(arg1.isAST(S.ComplexPlot3D) || plot.arg3().isList3() && plot.arg3().first().isSymbol())) {
                                return IOFunctions.printMessage(plot.topHead(), "pllim", F.list(plot.arg3()), engine);
                            }
                        }
                        return Mathcell.sliderWithPlot(plot, plotRangeX, plotRangeY, manipulateAST, engine);
                    }
                } else {
                    if (arg1.isAST(S.ListPointPlot3D)) {
                        return Mathcell.plot((IAST)arg1, manipulateAST, engine);
                    }
                    if (manipulateAST.isAST2() && manipulateAST.arg2().isList()) {
                        IExpr formula = arg1;
                        IAST sliderRange = (IAST)manipulateAST.arg2();
                        if ((sliderRange.size() == 4 || sliderRange.size() == 5) && sliderRange.arg1().isSymbol()) {
                            return Mathcell.sliderWithFormulas(formula, sliderRange, engine);
                        }
                    }
                }
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(manipulateAST.topHead(), ve, engine);
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)S.Manipulate, (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class PieChart
    extends AbstractEvaluator {
        private PieChart() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return ManipulateFunction.redirectToManipulate(ast, engine);
        }
    }

    private static final class MatrixPlot
    extends AbstractEvaluator {
        private MatrixPlot() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return ManipulateFunction.redirectToManipulate(ast, engine);
        }
    }

    private static final class Histogram
    extends AbstractEvaluator {
        private Histogram() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return ManipulateFunction.redirectToManipulate(ast, engine);
        }
    }

    private static final class DensityHistogram
    extends AbstractEvaluator {
        private DensityHistogram() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return ManipulateFunction.redirectToManipulate(ast, engine);
        }
    }

    private static final class DensityPlot
    extends AbstractEvaluator {
        private DensityPlot() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return IOFunctions.printMessage(ast.topHead(), "zznotimpl", F.list(ast.topHead()), engine);
        }
    }

    private static final class ContourPlot
    extends AbstractEvaluator {
        private ContourPlot() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return IOFunctions.printMessage(ast.topHead(), "zznotimpl", F.list(ast.topHead()), engine);
        }
    }

    private static final class ComplexPlot3D
    extends AbstractEvaluator {
        private ComplexPlot3D() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return ManipulateFunction.redirectToManipulate(ast, engine);
        }
    }

    private static final class BoxWhiskerChart
    extends AbstractEvaluator {
        private BoxWhiskerChart() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return ManipulateFunction.redirectToManipulate(ast, engine);
        }
    }

    private static final class BarChart
    extends AbstractEvaluator {
        private BarChart() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return ManipulateFunction.redirectToManipulate(ast, engine);
        }
    }

    private static final class Plotly {
        private Plotly() {
        }

        private static IExpr plot(IAST plot, IAST manipulateAST, EvalEngine engine) {
            if (plot.size() < 2) {
                return F.NIL;
            }
            IExpr arg1 = plot.arg1();
            if (!arg1.isList()) {
                arg1 = engine.evaluate(arg1);
            }
            if (plot.isAST(S.DensityHistogram)) {
                return Plotly.densityHistogram(arg1);
            }
            if (plot.isAST(S.Histogram)) {
                return Plotly.histogram(arg1);
            }
            if (plot.isAST(S.BarChart)) {
                return Plotly.barChart(arg1, plot, engine);
            }
            if (plot.isAST(S.BoxWhiskerChart)) {
                return Plotly.boxWhiskerChart(arg1);
            }
            if (plot.isAST(S.PieChart)) {
                return Plotly.pieChart(arg1);
            }
            if (plot.isAST(S.MatrixPlot)) {
                return Plotly.matrixPlot(arg1);
            }
            return F.NIL;
        }

        private static IExpr matrixPlot(IExpr arg) {
            double[][] matrix = arg.toDoubleMatrix();
            if (matrix != null && matrix.length > 0) {
                int rowCount = matrix.length;
                Object[] yStrs = new String[rowCount];
                for (int i = 0; i < rowCount; ++i) {
                    yStrs[i] = Integer.toString(i + 1);
                }
                int colCount = matrix[0].length;
                Object[] xStrs = new String[colCount];
                for (int i = 0; i < colCount; ++i) {
                    xStrs[i] = Integer.toString(i + 1);
                }
                Layout layout = Plotly.buildLayout("MatrixPlot").build();
                HeatmapTrace trace = HeatmapTrace.builder((Object[])xStrs, (Object[])yStrs, (double[][])matrix).build();
                Figure figure = new Figure(layout, new Trace[]{trace});
                return F.JSFormData(figure.asJavascript("plotly"), "plotly");
            }
            return F.NIL;
        }

        private static IExpr pieChart(IExpr arg) {
            double[] vector = arg.toDoubleVector();
            if (vector != null && vector.length > 0) {
                Object[] strs = new String[vector.length];
                for (int i = 0; i < vector.length; ++i) {
                    strs[i] = Integer.toString(i + 1);
                }
                Layout layout = Plotly.buildLayout("PieChart").build();
                PieTrace trace = PieTrace.builder((Object[])strs, (double[])vector).build();
                Figure figure = new Figure(layout, new Trace[]{trace});
                return F.JSFormData(figure.asJavascript("plotly"), "plotly");
            }
            return F.NIL;
        }

        private static IExpr boxWhiskerChart(IExpr arg) {
            if (arg.isListOfLists()) {
                int i;
                IAST listOfLists = (IAST)arg;
                StringBuilder buf = new StringBuilder();
                for (i = 1; i < listOfLists.size(); ++i) {
                    buf.append("var y" + i);
                    buf.append("=[");
                    double[] vector = listOfLists.get(i).toDoubleVector();
                    if (vector == null || vector.length <= 0) {
                        return F.NIL;
                    }
                    Convert.joinToString(vector, buf, ",");
                    buf.append("];\n");
                    buf.append("var trace" + i);
                    buf.append(" = {y: y" + i);
                    buf.append(", type: 'box'};\n");
                }
                buf.append("var data = [");
                for (i = 1; i < listOfLists.size(); ++i) {
                    buf.append("trace" + i);
                    if (i >= listOfLists.size() - 1) continue;
                    buf.append(",");
                }
                buf.append("];\n");
                buf.append("Plotly.newPlot('plotly', data);");
                return F.JSFormData(buf.toString(), "plotly");
            }
            double[] vector = arg.toDoubleVector();
            if (vector != null && vector.length > 0) {
                StringBuilder buf = new StringBuilder();
                buf.append("var y1=[");
                Convert.joinToString(vector, buf, ",");
                buf.append("];\n");
                buf.append("var trace1 = {y: y1, type: 'box'};\nvar data = [trace1];\nPlotly.newPlot('plotly', data);");
                return F.JSFormData(buf.toString(), "plotly");
            }
            return F.NIL;
        }

        private static IExpr barChart(IExpr arg, IAST plot, EvalEngine engine) {
            double[] vector = arg.toDoubleVector();
            if (vector != null && vector.length > 0) {
                BarTrace.Orientation orientation = BarTrace.Orientation.VERTICAL;
                OptionArgs options = new OptionArgs(S.BarChart, plot, 2, engine);
                IExpr orientExpr = options.getOption(S.BarOrigin);
                if (orientExpr == S.Bottom) {
                    orientation = BarTrace.Orientation.VERTICAL;
                } else if (orientExpr == S.Left) {
                    orientation = BarTrace.Orientation.HORIZONTAL;
                }
                Object[] strs = new String[vector.length];
                for (int i = 0; i < vector.length; ++i) {
                    strs[i] = Integer.toString(i + 1);
                }
                Layout layout = Plotly.buildLayout("BarChart").build();
                BarTrace trace = BarTrace.builder((Object[])strs, (double[])vector).orientation(orientation).build();
                Figure figure = new Figure(layout, new Trace[]{trace});
                return F.JSFormData(figure.asJavascript("plotly"), "plotly");
            }
            return F.NIL;
        }

        private static Layout.LayoutBuilder buildLayout(String chartType) {
            if (AUTOSIZE) {
                return Layout.builder((String)chartType).autosize(true).width(WIDTH).height(HEIGHT);
            }
            return Layout.builder((String)chartType).autosize(false);
        }

        private static Layout.LayoutBuilder buildLayout(String chartType, String xTitle, String yTitle) {
            if (AUTOSIZE) {
                return Layout.builder((String)chartType, (String)xTitle, (String)yTitle).autosize(true).width(WIDTH).height(HEIGHT);
            }
            return Layout.builder((String)chartType, (String)xTitle, (String)yTitle).autosize(false);
        }

        private static IExpr histogram(IExpr arg1) {
            double[] vector = arg1.toDoubleVectorIgnore();
            if (vector != null && vector.length > 0) {
                Layout layout = Plotly.buildLayout("Histogram").build();
                HistogramTrace trace = HistogramTrace.builder((double[])vector).build();
                Figure figure = new Figure(layout, new Trace[]{trace});
                return F.JSFormData(figure.asJavascript("plotly"), "plotly");
            }
            return F.NIL;
        }

        private static IExpr densityHistogram(IExpr arg) {
            RealMatrix m;
            int[] dims = arg.isMatrixIgnore();
            if (dims != null && dims[1] == 2 && (m = arg.toRealMatrixIgnore()) != null) {
                double[] vector1 = m.getColumn(0);
                double[] vector2 = m.getColumn(1);
                if (vector1 != null && vector1.length > 0 && vector2 != null && vector2.length > 0) {
                    Histogram2DTrace.Histogram2DBuilder builder = Histogram2DTrace.builder((double[])vector1, (double[])vector2);
                    Layout layout = Plotly.buildLayout("DensityHistogram", "x", "y").build();
                    Figure figure = new Figure(layout, new Trace[]{builder.build()});
                    return F.JSFormData(figure.asJavascript("plotly"), "plotly");
                }
            }
            return F.NIL;
        }
    }

    static final class JSXGraph {
        JSXGraph() {
        }

        private static boolean plot(IAST plot, IAST manipulateAST, JavaScriptFormFactory toJS, StringBuilder function, double[] boundingbox, int[] colour, EvalEngine engine) {
            if (plot.size() < 2) {
                return false;
            }
            JSXGraph.sliderNamesFromList(manipulateAST, toJS);
            IExpr arg1 = plot.arg1();
            if (!arg1.isList()) {
                arg1 = engine.evaluate(arg1);
            }
            if (arg1.isAssociation()) {
                IAssociation assoc = (IAssociation)arg1;
                arg1 = assoc.matrixOrList();
            }
            if (arg1.isNonEmptyList()) {
                IAST pointList = (IAST)arg1;
                if (pointList.isListOfLists()) {
                    int[] dimension = pointList.isMatrix(false);
                    if (dimension != null && dimension[1] == 2) {
                        ManipulateFunction.sequencePointListPlot(manipulateAST, 1, pointList, toJS, function, boundingbox, colour, engine);
                        return true;
                    }
                    IAST listOfLists = pointList;
                    for (int i = 1; i < listOfLists.size(); ++i) {
                        pointList = (IAST)listOfLists.get(i);
                        dimension = pointList.isMatrix(false);
                        if (dimension != null) {
                            if (dimension[1] == 2) {
                                ManipulateFunction.sequencePointListPlot(manipulateAST, i, pointList, toJS, function, boundingbox, colour, engine);
                                continue;
                            }
                            return false;
                        }
                        ManipulateFunction.sequenceYValuesListPlot(manipulateAST, i, pointList, toJS, function, boundingbox, colour, engine);
                    }
                } else {
                    ManipulateFunction.sequenceYValuesListPlot(manipulateAST, 1, pointList, toJS, function, boundingbox, colour, engine);
                }
                return true;
            }
            return false;
        }

        public static IExpr showPlots(IAST manipulateAST, EvalEngine engine, IAST plots) {
            double[] boundingbox = new double[]{Double.MAX_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Double.MAX_VALUE};
            StringBuilder function = new StringBuilder();
            JavaScriptFormFactory toJS = new JavaScriptFormFactory(true, false, -1, -1, 2);
            int[] colour = new int[]{1};
            for (int i = 1; i < plots.size(); ++i) {
                IAST sliderRange;
                IAST plot = (IAST)plots.get(i);
                if (plot.isAST(S.ListLinePlot) || plot.isAST(S.ListPlot)) {
                    if (JSXGraph.plot(plot, manipulateAST, toJS, function, boundingbox, colour, engine)) continue;
                    return F.NIL;
                }
                if (!plot.isAST(S.Plot) && !plot.isAST(S.ParametricPlot) && !plot.isAST(S.PolarPlot)) continue;
                if (plot.size() < 3 || !plot.arg2().isList3() || !plot.arg2().first().isSymbol()) {
                    IExpr arg2 = plot.size() >= 3 ? plot.arg2() : F.CEmptyString;
                    return IOFunctions.printMessage(plot.topHead(), "pllim", F.list(arg2), engine);
                }
                if (plot.size() < 3 || !plot.arg2().isList()) continue;
                IAST plotRangeX = (IAST)plot.arg2();
                IAST plotRangeY = F.NIL;
                if (plot.size() >= 4 && plot.arg3().isList()) {
                    plotRangeY = (IAST)plot.arg3();
                }
                if (manipulateAST.size() >= 3 && manipulateAST.arg2().isList() && (sliderRange = (IAST)manipulateAST.arg2()).isAST2() && sliderRange.arg2().isList()) {
                    if (plots.size() == 2) {
                        return Mathcell.sliderWithPlot(plot, plotRangeX, plotRangeY, manipulateAST, engine);
                    }
                    return F.NIL;
                }
                if (!plotRangeX.isAST3() || !plotRangeX.arg1().isSymbol() || JSXGraph.sliderWithPlot(plot, plotRangeX, manipulateAST, toJS, function, boundingbox, colour, engine)) continue;
                return F.NIL;
            }
            return JSXGraph.boundingBox(manipulateAST, boundingbox, function.toString(), toJS, false, true);
        }

        private static boolean sliderWithPlot(IAST plot, IAST plotRangeX, IAST manipulateAST, JavaScriptFormFactory toJS, StringBuilder function, double[] boundingbox, int[] colour, EvalEngine engine) {
            int i;
            IExpr plotRangeY;
            int plotID = plot.headID();
            OptionArgs options = plotID == 1010 || plotID == 260 || plotID == 283 || plotID == 335 ? new OptionArgs(plot.topHead(), plot, 4, engine) : new OptionArgs(plot.topHead(), plot, 3, engine);
            double plotRangeYMax = Double.MIN_VALUE;
            double plotRangeYMin = Double.MAX_VALUE;
            double plotRangeXMax = Double.MIN_VALUE;
            double plotRangeXMin = Double.MAX_VALUE;
            if (plotRangeX.isAST(S.List, 4)) {
                try {
                    plotRangeXMin = engine.evalDouble(plotRangeX.arg2());
                    plotRangeXMax = engine.evalDouble(plotRangeX.arg3());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            IExpr option = options.getOption(S.PlotStyle);
            IAST plotStyle = F.NIL;
            if (option.isPresent()) {
                if (!option.isList()) {
                    option = F.list(option);
                }
                if ((option = engine.evaluate(option)).isList()) {
                    plotStyle = (IAST)option;
                }
            }
            if ((plotRangeY = options.getOption(S.PlotRange)).isPresent()) {
                boolean plotRangeEvaled = false;
                if (plotRangeY.isAST(S.List, 3)) {
                    try {
                        if (plotRangeY.first().isAST(S.List, 3) && plotRangeY.second().isAST(S.List, 3)) {
                            IAST list = (IAST)plotRangeY.first();
                            plotRangeXMin = engine.evalDouble(list.first());
                            plotRangeXMax = engine.evalDouble(list.second());
                            list = (IAST)plotRangeY.second();
                            plotRangeYMin = engine.evalDouble(list.first());
                            plotRangeYMax = engine.evalDouble(list.second());
                        } else {
                            plotRangeYMin = engine.evalDouble(plotRangeY.first());
                            plotRangeYMax = engine.evalDouble(plotRangeY.second());
                        }
                        plotRangeEvaled = true;
                    }
                    catch (RuntimeException list) {}
                } else if (plotRangeY.isReal() && (plotID == 1009 || plotID == 976 || plotID == 1019)) {
                    try {
                        plotRangeYMin = engine.evalDouble(plotRangeY.negate());
                        plotRangeYMax = engine.evalDouble(plotRangeY);
                        plotRangeEvaled = true;
                    }
                    catch (RuntimeException list) {
                        // empty catch block
                    }
                }
                if (!plotRangeEvaled) {
                    IOFunctions.printMessage(plot.topHead(), "prng", F.list(F.Rule((IExpr)S.PlotRange, plotRangeY)), engine);
                }
            }
            JSXGraph.sliderNamesFromList(manipulateAST, toJS);
            IExpr arg1 = engine.evaluate(plot.arg1());
            if (!arg1.isList()) {
                arg1 = F.list(arg1);
            }
            ISymbol plotSymbolX = (ISymbol)plotRangeX.arg1();
            if ((plotID == 976 || plotID == 1019) && plotRangeYMax != Double.MIN_VALUE && plotRangeYMin != Double.MAX_VALUE) {
                try {
                    plotRangeXMin = plotRangeYMin;
                    plotRangeXMax = plotRangeYMax;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (plotID == 976) {
                return JSXGraph.parametricPlot(plotRangeX, manipulateAST, engine, plotID, plotRangeYMax, plotRangeYMin, plotRangeXMax, plotRangeXMin, plotStyle, boundingbox, toJS, arg1, plotSymbolX, function, colour);
            }
            if (plotID == 1019) {
                return JSXGraph.polarPlot(plotRangeX, manipulateAST, engine, plotID, plotRangeYMax, plotRangeYMin, plotRangeXMax, plotRangeXMin, plotStyle, boundingbox, toJS, arg1, plotSymbolX, function, colour);
            }
            IAST listOfFunctions = (IAST)arg1;
            String[] functionNames = new String[listOfFunctions.size() - 1];
            for (i = 0; i < functionNames.length; ++i) {
                functionNames[i] = EvalEngine.uniqueName("$f");
            }
            for (i = 1; i < listOfFunctions.size(); ++i) {
                function.append("function ");
                function.append(functionNames[i - 1]);
                function.append("(");
                toJS.convert(function, plotSymbolX);
                function.append(") ");
                ManipulateFunction.unaryJSFunction(toJS, function, plotSymbolX, listOfFunctions, i);
                IAST variables = VariablesSet.getVariables(listOfFunctions.get(i));
                if (variables.size() <= 2) {
                    Dimensions2D plotRange = new Dimensions2D();
                    ManipulateFunction.unaryPlotParameters(plotSymbolX, plotRangeXMin, plotRangeXMax, listOfFunctions.get(i), plotRange, engine);
                    ManipulateFunction.xBoundingBoxFunctionRange(boundingbox, plotRange);
                    ManipulateFunction.yBoundingBoxFunctionRange(boundingbox, plotRange);
                    continue;
                }
                ISymbol sym = F.Dummy("$z" + i);
                IExpr functionRange = S.FunctionRange.of(engine, listOfFunctions.get(i), plotSymbolX, sym);
                ManipulateFunction.yBoundingBoxFunctionRange(engine, boundingbox, functionRange);
            }
            for (i = 1; i < listOfFunctions.size(); ++i) {
                function.append("board.create('functiongraph',[");
                function.append(functionNames[i - 1]);
                function.append(", ");
                JSXGraph.rangeArgs(function, plotRangeX, -1, toJS);
                function.append("]");
                int n = colour[0];
                colour[0] = n + 1;
                RGBColor color = GraphicsFunctions.plotStyleColor(n, plotStyle);
                function.append(",{strokecolor:'");
                function.append(Convert.toHex(color));
                function.append("'}");
                function.append(");\n");
            }
            if (!F.isFuzzyEquals(Double.MAX_VALUE, plotRangeXMin, Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                boundingbox[0] = plotRangeXMin;
            }
            if (!F.isFuzzyEquals(Double.MIN_VALUE, plotRangeYMax, Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                boundingbox[1] = plotRangeYMax;
            }
            if (!F.isFuzzyEquals(Double.MIN_VALUE, plotRangeXMax, Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                boundingbox[2] = plotRangeXMax;
            }
            if (!F.isFuzzyEquals(Double.MAX_VALUE, plotRangeYMin, Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                boundingbox[3] = plotRangeYMin;
            }
            return true;
        }

        private static boolean parametricPlot(IAST plotRangeX, IAST manipulateAST, EvalEngine engine, int plotID, double plotRangeYMax, double plotRangeYMin, double plotRangeXMax, double plotRangeXMin, IAST plotStyle, double[] boundingbox, JavaScriptFormFactory toJS, IExpr arg, ISymbol plotSymbolX, StringBuilder function, int[] colour) {
            int i;
            IAST list;
            int[] dim = arg.isMatrix(false);
            if (dim == null) {
                int vectorDim = arg.isVector();
                if (vectorDim != 2) {
                    return false;
                }
                list = F.list(arg);
            } else {
                if (dim[1] != 2) {
                    return false;
                }
                list = (IAST)arg;
            }
            String[] functionNames = new String[list.size() - 1];
            for (i = 0; i < functionNames.length; ++i) {
                functionNames[i] = EvalEngine.uniqueName("$f");
            }
            for (i = 1; i < list.size(); ++i) {
                IAST listOfFunctions = (IAST)list.get(i);
                if (!listOfFunctions.isAST2()) continue;
                for (int j = 1; j < listOfFunctions.size(); ++j) {
                    function.append("function ");
                    function.append(functionNames[i - 1]);
                    function.append(j);
                    function.append("(");
                    toJS.convert(function, plotSymbolX);
                    function.append(") ");
                    ManipulateFunction.unaryJSFunction(toJS, function, plotSymbolX, listOfFunctions, j);
                }
                IAST variables1 = VariablesSet.getVariables(listOfFunctions.get(1));
                IAST variables2 = VariablesSet.getVariables(listOfFunctions.get(2));
                if (variables1.size() <= 2 && variables2.size() <= 2) {
                    Dimensions2D plotRange = new Dimensions2D();
                    ManipulateFunction.binaryPlotParameters(plotSymbolX, plotRangeXMin, plotRangeXMax, listOfFunctions.get(1), listOfFunctions.get(2), plotRange, engine);
                    ManipulateFunction.xBoundingBoxFunctionRange(boundingbox, plotRange);
                    ManipulateFunction.yBoundingBoxFunctionRange(boundingbox, plotRange);
                } else {
                    ISymbol sym = F.Dummy("$z" + i);
                    IExpr functionRange = S.FunctionRange.of(engine, listOfFunctions.get(1), plotSymbolX, sym);
                    ManipulateFunction.xBoundingBoxFunctionRange(engine, boundingbox, functionRange);
                    functionRange = S.FunctionRange.of(engine, listOfFunctions.get(2), plotSymbolX, sym);
                    ManipulateFunction.yBoundingBoxFunctionRange(engine, boundingbox, functionRange);
                }
                function.append("board.create('curve',[");
                for (int j = 1; j < listOfFunctions.size(); ++j) {
                    function.append("function(");
                    toJS.convert(function, plotSymbolX);
                    function.append("){return ");
                    function.append(functionNames[i - 1]);
                    function.append(j);
                    function.append("(");
                    toJS.convert(function, plotSymbolX);
                    function.append(");}");
                    if (j >= listOfFunctions.size() - 1) continue;
                    function.append(",");
                }
                function.append(", ");
                JSXGraph.rangeArgs(function, plotRangeX, -1, toJS);
                function.append("]");
                int n = colour[0];
                colour[0] = n + 1;
                RGBColor color = GraphicsFunctions.plotStyleColor(n, plotStyle);
                function.append(",{strokecolor:'");
                function.append(Convert.toHex(color));
                function.append("'}");
                function.append(");\n");
            }
            if (!F.isFuzzyEquals(Double.MAX_VALUE, plotRangeXMin, Config.SPECIAL_FUNCTIONS_TOLERANCE) && F.isFuzzyEquals(Double.MAX_VALUE, boundingbox[0], Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                boundingbox[0] = plotRangeXMin;
            }
            if (!F.isFuzzyEquals(Double.MIN_VALUE, plotRangeYMax, Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                boundingbox[1] = plotRangeYMax;
            }
            if (!F.isFuzzyEquals(Double.MIN_VALUE, plotRangeXMax, Config.SPECIAL_FUNCTIONS_TOLERANCE) && F.isFuzzyEquals(Double.MIN_VALUE, boundingbox[2], Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                boundingbox[2] = plotRangeXMax;
            }
            if (!F.isFuzzyEquals(Double.MAX_VALUE, plotRangeYMin, Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                boundingbox[3] = plotRangeYMin;
            }
            return true;
        }

        private static boolean polarPlot(IAST plotRangeX, IAST manipulateAST, EvalEngine engine, int plotID, double plotRangeYMax, double plotRangeYMin, double plotRangeXMax, double plotRangeXMin, IAST plotStyle, double[] boundingbox, JavaScriptFormFactory toJS, IExpr arg1, ISymbol plotSymbolX, StringBuilder function, int[] colour) {
            int i;
            IAST listOfFunctions = (IAST)arg1;
            int[] dim = arg1.isMatrix(false);
            if (dim != null) {
                if (dim[1] != 2) {
                    return false;
                }
                listOfFunctions = (IAST)listOfFunctions.arg1();
            }
            String[] functionNames = new String[listOfFunctions.size() - 1];
            for (i = 0; i < functionNames.length; ++i) {
                functionNames[i] = EvalEngine.uniqueName("$f");
            }
            for (i = 1; i < listOfFunctions.size(); ++i) {
                function.append("function ");
                function.append(functionNames[i - 1]);
                function.append("(");
                toJS.convert(function, plotSymbolX);
                function.append(") ");
                ManipulateFunction.unaryJSFunction(toJS, function, plotSymbolX, listOfFunctions, i);
                IAST variables = VariablesSet.getVariables(listOfFunctions.get(i));
                if (variables.size() <= 2) {
                    Dimensions2D plotRange = new Dimensions2D();
                    ManipulateFunction.polarPlotParameters(plotSymbolX, plotRangeXMin, plotRangeXMax, listOfFunctions.get(i), plotRange, engine);
                    ManipulateFunction.xBoundingBoxFunctionRange(boundingbox, plotRange);
                    ManipulateFunction.yBoundingBoxFunctionRange(boundingbox, plotRange);
                    continue;
                }
                ISymbol sym = F.Dummy("$z" + i);
                IExpr functionRange = S.FunctionRange.of(engine, listOfFunctions.get(i), plotSymbolX, sym);
                ManipulateFunction.yBoundingBoxFunctionRange(engine, boundingbox, functionRange);
            }
            for (i = 1; i < listOfFunctions.size(); ++i) {
                function.append("board.create('curve', [");
                function.append("function(");
                toJS.convert(function, plotSymbolX);
                function.append("){return ");
                function.append(functionNames[i - 1]);
                function.append("(");
                toJS.convert(function, plotSymbolX);
                function.append(");}");
                function.append(",[0,0], ");
                toJS.convert(function, plotRangeX.arg2());
                function.append(", ");
                toJS.convert(function, plotRangeX.arg3());
                function.append("]");
                function.append(", {curveType:'polar'");
                int n = colour[0];
                colour[0] = n + 1;
                RGBColor color = GraphicsFunctions.plotStyleColor(n, plotStyle);
                function.append(",strokeWidth:2, strokecolor:'");
                function.append(Convert.toHex(color));
                function.append("'");
                function.append("} );\n");
            }
            if (!F.isFuzzyEquals(Double.MAX_VALUE, plotRangeXMin, Config.SPECIAL_FUNCTIONS_TOLERANCE) && F.isFuzzyEquals(Double.MAX_VALUE, boundingbox[0], Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                boundingbox[0] = plotRangeXMin;
            }
            if (!F.isFuzzyEquals(Double.MIN_VALUE, plotRangeYMax, Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                boundingbox[1] = plotRangeYMax;
            }
            if (!F.isFuzzyEquals(Double.MIN_VALUE, plotRangeXMax, Config.SPECIAL_FUNCTIONS_TOLERANCE) && F.isFuzzyEquals(Double.MIN_VALUE, boundingbox[2], Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                boundingbox[2] = plotRangeXMax;
            }
            if (!F.isFuzzyEquals(Double.MAX_VALUE, plotRangeYMin, Config.SPECIAL_FUNCTIONS_TOLERANCE)) {
                boundingbox[3] = plotRangeYMin;
            }
            return true;
        }

        private static IExpr boundingBox(IAST ast, double[] boundingbox, String function, JavaScriptFormFactory toJS, boolean fixedBounds, boolean axes) {
            String js = ManipulateFunction.JSXGRAPH;
            if (!fixedBounds) {
                boundingbox[0] = F.isFuzzyEquals(Double.MAX_VALUE, boundingbox[0], Config.SPECIAL_FUNCTIONS_TOLERANCE) ? -5.0 : boundingbox[0] - 0.5;
                boundingbox[1] = F.isFuzzyEquals(Double.MIN_VALUE, boundingbox[1], Config.SPECIAL_FUNCTIONS_TOLERANCE) ? 5.0 : boundingbox[1] + 0.5;
                boundingbox[2] = F.isFuzzyEquals(Double.MIN_VALUE, boundingbox[2], Config.SPECIAL_FUNCTIONS_TOLERANCE) ? 5.0 : boundingbox[2] + 0.5;
                boundingbox[3] = F.isFuzzyEquals(Double.MAX_VALUE, boundingbox[3], Config.SPECIAL_FUNCTIONS_TOLERANCE) ? -5.0 : boundingbox[3] - 0.5;
            }
            double xPadding = (boundingbox[2] - boundingbox[0]) / 20.0;
            double yPadding = (boundingbox[1] - boundingbox[3]) / 20.0;
            if (F.isZero(xPadding)) {
                xPadding = 5.0;
            }
            if (F.isZero(yPadding)) {
                yPadding = 5.0;
            }
            boundingbox[0] = boundingbox[0] - xPadding;
            boundingbox[2] = boundingbox[2] + xPadding;
            boundingbox[1] = boundingbox[1] + yPadding;
            boundingbox[3] = boundingbox[3] - yPadding;
            js = JSXGraph.slidersFromList(ast, js, boundingbox, toJS);
            js = js.replace("`2`", function);
            StringBuilder graphicControl = new StringBuilder();
            js = js.replace("`3`", graphicControl.toString());
            StringBuilder jsControl = new StringBuilder();
            if (axes) {
                jsControl.append("var board = JXG.JSXGraph.initBoard('jxgbox', {axis:true,boundingbox:[");
            } else {
                jsControl.append("var board = JXG.JSXGraph.initBoard('jxgbox', {axis:false,boundingbox:[");
            }
            for (int i = 0; i < boundingbox.length; ++i) {
                jsControl.append(boundingbox[i]);
                if (i >= 3) continue;
                jsControl.append(",");
            }
            jsControl.append("]});\n");
            jsControl.append("board.suspendUpdate();\n");
            jsControl.append(js);
            jsControl.append("board.unsuspendUpdate();\n");
            return F.JSFormData(jsControl.toString(), "jsxgraph");
        }

        private static void rangeArgs(StringBuilder graphicControl, IAST plotRange, int steps, JavaScriptFormFactory toJS) {
            toJS.convert(graphicControl, plotRange.arg2());
            graphicControl.append(", ");
            toJS.convert(graphicControl, plotRange.arg3());
            if (steps > 0) {
                graphicControl.append(", ");
                graphicControl.append(steps);
            }
        }

        static boolean singleSlider(IAST sliderRange, StringBuilder slider, double xPos1Slider, double xPos2Slider, double yPosSlider, JavaScriptFormFactory toJS) {
            if (sliderRange.isAST3() || sliderRange.size() == 5) {
                String label;
                String sliderSymbol;
                IExpr step = null;
                if (sliderRange.size() == 5) {
                    step = sliderRange.arg4();
                }
                String defaultValue = null;
                if (sliderRange.arg1().isList()) {
                    IAST sliderParameters = (IAST)sliderRange.arg1();
                    if (sliderParameters.size() < 4) {
                        return false;
                    }
                    sliderSymbol = sliderParameters.arg1().toString();
                    defaultValue = toJS.toString(sliderRange.arg2());
                    label = toJS.toString(sliderParameters.arg3());
                } else {
                    label = sliderSymbol = sliderRange.arg1().toString();
                }
                slider.append("var ");
                slider.append(sliderSymbol);
                slider.append(" = board.create('slider',");
                slider.append("[[");
                slider.append(xPos1Slider);
                slider.append(",");
                slider.append(yPosSlider);
                slider.append("],[");
                slider.append(xPos2Slider);
                slider.append(",");
                slider.append(yPosSlider);
                slider.append("],[");
                toJS.convert(slider, sliderRange.arg2());
                slider.append(",");
                if (defaultValue != null) {
                    slider.append(defaultValue);
                } else {
                    toJS.convert(slider, sliderRange.arg2());
                }
                slider.append(",");
                toJS.convert(slider, sliderRange.arg3());
                slider.append("]],");
                slider.append("{name:'");
                slider.append(label);
                slider.append("'");
                if (step != null) {
                    slider.append(",snapWidth:");
                    toJS.convert(slider, step);
                }
                slider.append("});\n");
                return true;
            }
            return false;
        }

        static boolean singleSliderName(IAST sliderRange, JavaScriptFormFactory toJS) {
            if (sliderRange.isAST3() || sliderRange.size() == 5) {
                String sliderSymbol;
                if (sliderRange.arg1().isList()) {
                    IAST sliderParameters = (IAST)sliderRange.arg1();
                    if (sliderParameters.size() < 4) {
                        return false;
                    }
                    sliderSymbol = sliderParameters.arg1().toString();
                    toJS.appendSlider(sliderSymbol);
                } else {
                    sliderSymbol = sliderRange.arg1().toString();
                }
                toJS.appendSlider(sliderSymbol);
                return true;
            }
            return false;
        }

        private static void sliderNamesFromList(IAST ast, JavaScriptFormFactory toJS) {
            if (ast.size() >= 3 && ast.arg2().isList()) {
                for (int i = 2; i < ast.size() && ast.get(i).isList(); ++i) {
                    if (JSXGraph.singleSliderName((IAST)ast.get(i), toJS)) continue;
                    return;
                }
            }
        }

        private static String slidersFromList(IAST ast, String js, double[] boundingbox, JavaScriptFormFactory toJS) {
            if (ast.size() >= 3) {
                if (ast.arg2().isList()) {
                    double xDelta = (boundingbox[2] - boundingbox[0]) / 10.0;
                    double yDelta = (boundingbox[1] - boundingbox[3]) / 10.0;
                    double xPos1Slider = boundingbox[0] + xDelta;
                    double xPos2Slider = boundingbox[2] - xDelta;
                    double yPosSlider = boundingbox[1] - yDelta;
                    StringBuilder slider = new StringBuilder();
                    for (int i = 2; i < ast.size() && ast.get(i).isList(); ++i) {
                        if (!JSXGraph.singleSlider(ast.getAST(i), slider, xPos1Slider, xPos2Slider, yPosSlider, toJS)) {
                            return null;
                        }
                        yPosSlider -= yDelta;
                    }
                    js = StringUtils.replace((String)js, (String)"`1`", (String)slider.toString());
                }
            } else {
                js = StringUtils.replace((String)js, (String)"`1`", (String)"");
            }
            return js;
        }
    }

    static final class Mathcell {
        Mathcell() {
        }

        private static IExpr plot(IAST plot, IAST manipulateAST, EvalEngine engine) {
            JavaScriptFormFactory toJS = new JavaScriptFormFactory(true, false, -1, -1, 2);
            String js = ManipulateFunction.MATHCELL;
            if ((js = Mathcell.slidersFromList(manipulateAST, js, toJS)) == null) {
                return F.NIL;
            }
            if (plot.size() < 2) {
                return F.NIL;
            }
            IExpr arg1 = plot.arg1();
            if (!arg1.isList()) {
                arg1 = engine.evaluate(arg1);
            }
            if (arg1.isList()) {
                int i;
                IAST pointList = (IAST)arg1;
                int[] dimension = pointList.isMatrix(false);
                if (dimension != null) {
                    if (dimension[1] == 2) {
                        int i2;
                        StringBuilder function = new StringBuilder();
                        if (manipulateAST.arg1().isAST(S.ListLinePlot)) {
                            function.append("var data = [ listPlot( [\n");
                            for (i2 = 1; i2 < pointList.size(); ++i2) {
                                IAST rowList = (IAST)pointList.get(i2);
                                function.append("[ ");
                                toJS.convert(function, rowList.arg1());
                                function.append(",");
                                toJS.convert(function, rowList.arg2());
                                function.append("] ");
                                if (i2 < pointList.size() - 1) {
                                    function.append(",");
                                }
                                function.append("\n");
                            }
                            function.append("], { })];");
                        } else {
                            function.append("var data = [\n");
                            for (i2 = 1; i2 < pointList.size(); ++i2) {
                                IAST rowList = (IAST)pointList.get(i2);
                                function.append("point( [ ");
                                toJS.convert(function, rowList.arg1());
                                function.append(",");
                                toJS.convert(function, rowList.arg2());
                                function.append("], ");
                                function.append(" {size: 2 } )");
                                if (i2 < pointList.size() - 1) {
                                    function.append(",");
                                }
                                function.append("\n");
                            }
                            function.append("];");
                        }
                        js = js.replace("`3`", function.toString());
                        StringBuilder graphicControl = new StringBuilder();
                        graphicControl.append("var config = { type: 'svg' };\n");
                        graphicControl.append("evaluate( id, data, config );\n");
                        js = js.replace("`4`", graphicControl.toString());
                        return F.JSFormData(js, "mathcell");
                    }
                    if (dimension[1] == 3) {
                        StringBuilder function = new StringBuilder();
                        function.append("var data = [\n");
                        for (int i3 = 1; i3 < pointList.size(); ++i3) {
                            IAST rowList = (IAST)pointList.get(i3);
                            function.append("point( [ ");
                            toJS.convert(function, rowList.arg1());
                            function.append(",");
                            toJS.convert(function, rowList.arg2());
                            function.append(",");
                            toJS.convert(function, rowList.arg3());
                            function.append("], ");
                            function.append(" {size: 2 } )");
                            if (i3 < pointList.size() - 1) {
                                function.append(",");
                            }
                            function.append("\n");
                        }
                        function.append("];");
                        js = js.replace("`3`", function.toString());
                        StringBuilder graphicControl = new StringBuilder();
                        graphicControl.append("var config = { type: 'threejs' };\n");
                        graphicControl.append("evaluate( id, data, config );\n");
                        js = js.replace("`4`", graphicControl.toString());
                        return F.JSFormData(js, "mathcell");
                    }
                    if (dimension[0] > 3 && dimension[1] > 3 && manipulateAST.arg1().isAST(S.ListPointPlot3D)) {
                        return Mathcell.listPointPlot3DHeightValues(pointList, js, toJS);
                    }
                    return F.NIL;
                }
                StringBuilder function = new StringBuilder();
                if (manipulateAST.arg1().isAST(S.ListLinePlot)) {
                    function.append("var data = [ listPlot( [\n");
                    for (i = 1; i < pointList.size(); ++i) {
                        function.append("[ ");
                        function.append(i);
                        function.append(",");
                        toJS.convert(function, pointList.get(i));
                        function.append("] ");
                        if (i < pointList.size() - 1) {
                            function.append(",");
                        }
                        function.append("\n");
                    }
                    function.append("], { })];");
                } else {
                    function.append("var data = [\n");
                    for (i = 1; i < pointList.size(); ++i) {
                        function.append("point( [ ");
                        function.append(i);
                        function.append(",");
                        toJS.convert(function, pointList.get(i));
                        function.append("], ");
                        function.append(" {size: 2 } )");
                        if (i < pointList.size() - 1) {
                            function.append(",");
                        }
                        function.append("\n");
                    }
                    function.append("];");
                }
                js = js.replace("`3`", function.toString());
                StringBuilder graphicControl = new StringBuilder();
                graphicControl.append("var config = { type: 'svg' };\n");
                graphicControl.append("evaluate( id, data, config );\n");
                js = js.replace("`4`", graphicControl.toString());
                return F.JSFormData(js, "mathcell");
            }
            return F.NIL;
        }

        private static IExpr listPointPlot3DHeightValues(IAST heightValueMatrix, String js, JavaScriptFormFactory toJS) {
            StringBuilder function = new StringBuilder();
            function.append("var data = [\n");
            for (int i = 1; i < heightValueMatrix.size(); ++i) {
                IAST rowList = (IAST)heightValueMatrix.get(i);
                for (int j = 1; j < rowList.size(); ++j) {
                    function.append("point( [ ");
                    toJS.convert(function, F.ZZ(i));
                    function.append(",");
                    toJS.convert(function, F.ZZ(j));
                    function.append(",");
                    toJS.convert(function, rowList.get(j));
                    function.append("], {size: 4 } )");
                    if (j >= rowList.size() - 1) continue;
                    function.append(", ");
                }
                if (i < heightValueMatrix.size() - 1) {
                    function.append(",");
                }
                function.append("\n");
            }
            function.append("];");
            js = js.replace("`3`", function.toString());
            StringBuilder graphicControl = new StringBuilder();
            graphicControl.append("var config = { type: 'threejs' };\n");
            graphicControl.append("evaluate( id, data, config );\n");
            js = js.replace("`4`", graphicControl.toString());
            return F.JSFormData(js, "mathcell");
        }

        private static IExpr sliderWithPlot(IAST plot, IAST plotRangeX, IAST plotRangeY, IAST manipulateAST, EvalEngine engine) {
            int i;
            OptionArgs options;
            JavaScriptFormFactory toJS = new JavaScriptFormFactory(true, false, -1, -1, 2);
            int plotID = plot.headID();
            String colorMap = "hot";
            if (plotID == 1010 || plotID == 260 || plotID == 283 || plotID == 335) {
                IExpr colorFunction;
                if (plotID == 260) {
                    options = new OptionArgs(plot.topHead(), plot, 3, engine);
                    if (plot.size() > 3 && options.isInvalidPosition(plot, 2)) {
                        return F.NIL;
                    }
                } else {
                    options = new OptionArgs(plot.topHead(), plot, 4, engine);
                    if (plot.size() > 4 && options.isInvalidPosition(plot, 3)) {
                        return F.NIL;
                    }
                }
                if ((colorFunction = options.getOption(S.ColorFunction)) != S.Automatic) {
                    if (colorFunction.isString()) {
                        String newColorMap = colorFunction.toString();
                        if (newColorMap.equals("CherryTones")) {
                            colorMap = "cherry";
                        } else if (newColorMap.equals("Rainbow")) {
                            colorMap = "rainbow2";
                        } else if (newColorMap.equals("RustTones")) {
                            colorMap = "rust";
                        } else if (newColorMap.equals("SunsetColors")) {
                            colorMap = "sunset";
                        } else if (newColorMap.equals("TemperatureMap")) {
                            colorMap = "temperature";
                        } else if (newColorMap.equals("ThermometerColors")) {
                            colorMap = "thermometer";
                        } else if (newColorMap.equals("WatermelonColors")) {
                            colorMap = "watermelon";
                        } else {
                            IOFunctions.printMessage(S.ColorData, "notent", F.list(S.ColorData, colorFunction), engine);
                        }
                    } else if (colorFunction.isPresent()) {
                        IOFunctions.printMessage(S.ColorData, "notent", F.list(S.ColorData, colorFunction), engine);
                    }
                }
            } else {
                options = new OptionArgs(plot.topHead(), plot, 3, engine);
            }
            IExpr plotRange = options.getOption(S.PlotRange);
            IAST optionPlotRange = F.NIL;
            if (plotRange.isPresent()) {
                if (plotRange.isAST(S.List, 3)) {
                    optionPlotRange = F.list(S.Full, F.list(plotRange.first(), plotRange.second()));
                } else if (plotRange.isReal()) {
                    if (plotID == 1009) {
                        optionPlotRange = F.list(S.Full, F.list(plotRange.negate(), plotRange));
                    } else if (plotID == 792 || plotID == 790) {
                        optionPlotRange = F.list(S.Full, F.list(F.C0, plotRange));
                    } else if (plotID == 1019 || plotID == 976) {
                        optionPlotRange = F.list(F.list(plotRange.negate(), plotRange), F.list(plotRange.negate(), plotRange));
                    }
                }
                if (!optionPlotRange.isPresent()) {
                    IOFunctions.printMessage(plot.topHead(), "prng", F.list(F.Rule((IExpr)S.PlotRange, plotRange)), engine);
                }
            }
            String js = ManipulateFunction.MATHCELL;
            if ((js = Mathcell.slidersFromList(manipulateAST, js, toJS)) == null) {
                return F.NIL;
            }
            ISymbol plotSymbolX = (ISymbol)plotRangeX.arg1();
            StringBuilder function = new StringBuilder();
            IExpr plotFunction = engine.evaluate(plot.arg1());
            IAST listOfFunctions = plotFunction.isList() ? (IAST)plotFunction : F.unaryAST1(S.List, plotFunction);
            if (plotID == 1010 || plotID == 283 || plotID == 335) {
                if (!plotRangeY.isPresent()) {
                    return F.NIL;
                }
                for (i = 1; i < listOfFunctions.size(); ++i) {
                    function.append("function z" + i + "(");
                    ISymbol plotSymbolY = (ISymbol)plotRangeY.arg1();
                    toJS.convert(function, plotSymbolX);
                    function.append(",");
                    toJS.convert(function, plotSymbolY);
                    function.append(") { return [ ");
                    toJS.convert(function, plotSymbolX);
                    function.append(", ");
                    toJS.convert(function, plotSymbolY);
                    function.append(", ");
                    toJS.convert(function, listOfFunctions.get(i));
                    function.append(" ]; }\n");
                }
            } else if (manipulateAST.arg1().isAST(S.ComplexPlot3D)) {
                for (i = 1; i < listOfFunctions.size(); ++i) {
                    function.append("function z" + i + "(");
                    toJS.convert(function, plotSymbolX);
                    function.append(") { try { return  ");
                    toJS.convert(function, listOfFunctions.get(i));
                    function.append(";}catch(e){return complex(Number.NaN);} }\n");
                }
            } else {
                for (i = 1; i < listOfFunctions.size(); ++i) {
                    function.append("function z");
                    function.append(i);
                    function.append("(");
                    toJS.convert(function, plotSymbolX);
                    function.append(") { try { return ");
                    toJS.convert(function, listOfFunctions.get(i));
                    function.append(";}catch(e){return complex(Number.NaN);} }\n");
                }
            }
            js = js.replace("`3`", function.toString());
            StringBuilder graphicControl = new StringBuilder();
            if (plotID == 283 || plotID == 335) {
                if (!plotRangeY.isPresent()) {
                    return F.NIL;
                }
                Mathcell.contourPlot(listOfFunctions, plotRangeX, plotRangeY, graphicControl, plotID, toJS);
            } else if (plotID == 1010) {
                if (!plotRangeY.isPresent()) {
                    return F.NIL;
                }
                Mathcell.plot3D(listOfFunctions, plotRangeX, plotRangeY, graphicControl, colorMap, toJS);
            } else if (manipulateAST.arg1().isAST(S.ComplexPlot3D)) {
                if (plotRangeY.isPresent()) {
                    return F.NIL;
                }
                Mathcell.complexPlot3D(listOfFunctions, plotRangeX, graphicControl, optionPlotRange, toJS);
            } else {
                if (plotID == 976 || plotID == 1019) {
                    Mathcell.parametricPlot(listOfFunctions, plotRangeX, plotSymbolX, graphicControl, toJS);
                } else {
                    int i2;
                    for (i2 = 1; i2 < listOfFunctions.size(); ++i2) {
                        graphicControl.append("var p" + i2 + " = plot( z" + i2 + ", ");
                        ManipulateFunction.realRange(graphicControl, plotRangeX, -1, toJS);
                        graphicControl.append(", { color: 'hsl(");
                        graphicControl.append(72 * (i2 - 1));
                        graphicControl.append(",100%,50%)' }");
                        graphicControl.append(" );\n");
                    }
                    graphicControl.append("var data = [ ");
                    for (i2 = 1; i2 < listOfFunctions.size(); ++i2) {
                        graphicControl.append("p");
                        graphicControl.append(i2);
                        if (i2 >= listOfFunctions.size() - 1) continue;
                        graphicControl.append(", ");
                    }
                    graphicControl.append(" ];\n");
                }
                graphicControl.append("var config = { type: 'svg' ");
                if (optionPlotRange.isPresent()) {
                    // empty if block
                }
                if (optionPlotRange.isPresent() && optionPlotRange.second().isAST(S.List, 3)) {
                    IAST list = (IAST)optionPlotRange.second();
                    graphicControl.append(", yMin: ");
                    toJS.convert(graphicControl, list.arg1());
                    graphicControl.append(", yMax: ");
                    toJS.convert(graphicControl, list.arg2());
                }
                graphicControl.append(" };\n");
            }
            graphicControl.append("evaluate( id, data, config );\n");
            js = js.replace("`4`", graphicControl.toString());
            return F.JSFormData(js, "mathcell");
        }

        public static void contourPlot(IAST listOfFunctions, IAST plotRangeX, IAST plotRangeY, StringBuilder graphicControl, int plotID, JavaScriptFormFactory toJS) {
            int i;
            for (i = 1; i < listOfFunctions.size(); ++i) {
                graphicControl.append("var p" + i + " = ");
                if (plotID == 335) {
                    graphicControl.append("isoline( z" + i + ", ");
                } else {
                    graphicControl.append("isoband( z" + i + ", ");
                }
                ManipulateFunction.realRange(graphicControl, plotRangeX, -1, toJS);
                graphicControl.append(", ");
                ManipulateFunction.realRange(graphicControl, plotRangeY, -1, toJS);
                graphicControl.append(" );\n");
            }
            graphicControl.append("\n  var config = { type: 'threejs' };\n");
            graphicControl.append("  var data = [");
            for (i = 1; i < listOfFunctions.size(); ++i) {
                graphicControl.append("p" + i);
                if (i >= listOfFunctions.size() - 1) continue;
                graphicControl.append(",");
            }
            graphicControl.append("];\n");
        }

        public static void plot3D(IAST listOfFunctions, IAST plotRangeX, IAST plotRangeY, StringBuilder graphicControl, String colorMap, JavaScriptFormFactory toJS) {
            int i;
            for (i = 1; i < listOfFunctions.size(); ++i) {
                graphicControl.append("var p" + i + " = ");
                graphicControl.append("parametric( z" + i + ", ");
                ManipulateFunction.realRange(graphicControl, plotRangeX, -1, toJS);
                graphicControl.append(", ");
                ManipulateFunction.realRange(graphicControl, plotRangeY, -1, toJS);
                graphicControl.append(", { colormap: '");
                graphicControl.append(colorMap);
                graphicControl.append("' } );\n");
            }
            graphicControl.append("\n  var config = { type: 'threejs' };\n");
            graphicControl.append("  var data = [");
            for (i = 1; i < listOfFunctions.size(); ++i) {
                graphicControl.append("p" + i);
                if (i >= listOfFunctions.size() - 1) continue;
                graphicControl.append(",");
            }
            graphicControl.append("];\n");
        }

        public static void parametricPlot(IAST listOfFunctions, IAST plotRangeX, ISymbol plotSymbolX, StringBuilder graphicControl, JavaScriptFormFactory toJS) {
            graphicControl.append("var data = [ parametric( ");
            toJS.convert(graphicControl, plotSymbolX);
            graphicControl.append(" => [");
            for (int i = 1; i < listOfFunctions.size(); ++i) {
                graphicControl.append("z" + i + "(");
                toJS.convert(graphicControl, plotSymbolX);
                graphicControl.append(")");
                if (i >= listOfFunctions.size() - 1) continue;
                graphicControl.append(",");
            }
            graphicControl.append("], ");
            ManipulateFunction.realRange(graphicControl, plotRangeX, 1500, toJS);
            graphicControl.append(" )];\n");
        }

        public static void complexPlot3D(IAST listOfFunctions, IAST plotRangeX, StringBuilder graphicControl, IAST optionPlotRange, JavaScriptFormFactory toJS) {
            int i;
            double[] rangeXY = null;
            for (i = 1; i < listOfFunctions.size(); ++i) {
                graphicControl.append("var p" + i + " = ");
                graphicControl.append("parametric( (re,im) => [ re, im, z" + i + "(complex(re,im)) ]");
                rangeXY = ManipulateFunction.complexRange(graphicControl, plotRangeX, -1, toJS);
                graphicControl.append(", { complexFunction: 'abs', colormap: 'complexArgument");
                graphicControl.append("' } );\n");
            }
            graphicControl.append("\n  var config = { type: 'threejs',");
            if (rangeXY != null) {
                Mathcell.setBoxRatios(graphicControl, rangeXY);
            }
            if (optionPlotRange.isPresent() && optionPlotRange.second().isAST(S.List, 3)) {
                IAST list = (IAST)optionPlotRange.second();
                graphicControl.append(", zMin: ");
                toJS.convert(graphicControl, list.arg1());
                graphicControl.append(", zMax: ");
                toJS.convert(graphicControl, list.arg2());
            }
            graphicControl.append(" };\n");
            graphicControl.append("  var data = [");
            for (i = 1; i < listOfFunctions.size(); ++i) {
                graphicControl.append("p" + i);
                if (i >= listOfFunctions.size() - 1) continue;
                graphicControl.append(",");
            }
            graphicControl.append("];\n");
        }

        private static void setBoxRatios(StringBuilder graphicControl, double[] rangeXY) {
            graphicControl.append(" aspectRatio: [");
            if (rangeXY[0] > rangeXY[1]) {
                double aspectRatio = rangeXY[0] / rangeXY[1];
                graphicControl.append("1,");
                graphicControl.append(Double.toString(aspectRatio));
                graphicControl.append(",1]");
            } else {
                double aspectRatio = rangeXY[1] / rangeXY[0];
                graphicControl.append(Double.toString(aspectRatio));
                graphicControl.append(",1,1]");
            }
        }

        private static IExpr sliderWithFormulas(IExpr formula, IAST sliderRange, EvalEngine engine) {
            JavaScriptFormFactory toJS = new JavaScriptFormFactory(true, false, -1, -1, 2);
            IASTAppendable newsliderRange = sliderRange.copyAppendable();
            double stepValue = 1.0;
            double minValue = sliderRange.arg2().evalDouble();
            double maxValue = sliderRange.arg3().evalDouble();
            if (sliderRange.size() == 5) {
                stepValue = sliderRange.arg4().evalDouble();
            } else {
                stepValue = (maxValue - minValue) / 100.0;
                newsliderRange.append(stepValue);
            }
            IExpr list = engine.evaluate(F.Table(formula, newsliderRange));
            if (list.isNonEmptyList()) {
                IAST listOfFormulas = (IAST)list;
                String sliderSymbol = toJS.toString(newsliderRange.arg1());
                String min = Double.toString(minValue);
                String max = Double.toString(maxValue);
                String step = Double.toString(stepValue);
                String js = ManipulateFunction.MATHCELL;
                StringBuilder slider = new StringBuilder();
                slider.append("{ type: 'slider', min: ");
                slider.append(min);
                slider.append(", max: ");
                slider.append(max);
                slider.append(", step: ");
                slider.append(step);
                slider.append(", name: '");
                slider.append(sliderSymbol);
                slider.append("', label: '");
                slider.append(sliderSymbol);
                slider.append("' }\n");
                js = StringUtils.replace((String)js, (String)"`1`", (String)slider.toString());
                StringBuilder variable = new StringBuilder();
                variable.append("var ");
                variable.append(sliderSymbol);
                variable.append(" = getVariable(id, '");
                variable.append(sliderSymbol);
                variable.append("');\n");
                js = StringUtils.replace((String)js, (String)"`2`", (String)variable.toString());
                js = StringUtils.replace((String)js, (String)"`3`", (String)"");
                TeXUtilities texUtil = new TeXUtilities(engine, true);
                StringBuilder graphicControl = new StringBuilder();
                graphicControl.append("var expressions = [ ");
                for (int i = 1; i < listOfFormulas.size(); ++i) {
                    StringWriter stw = new StringWriter();
                    texUtil.toTeX(listOfFormulas.get(i), stw);
                    graphicControl.append("'");
                    String texForm = stw.toString();
                    texForm = texForm.replace("\\", "\\\\\\\\");
                    graphicControl.append(texForm);
                    graphicControl.append("'");
                    if (i >= listOfFormulas.size() - 1) continue;
                    graphicControl.append(",\n");
                }
                graphicControl.append(" ];\n\n");
                graphicControl.append("  var data = '\\\\\\\\[' + expressions[Math.trunc((");
                graphicControl.append(sliderSymbol);
                graphicControl.append("-");
                graphicControl.append(min);
                graphicControl.append(")/");
                graphicControl.append(step);
                graphicControl.append(")] + '\\\\\\\\]';\n\n");
                graphicControl.append("  data = data.replace( /\\\\\\\\/g, '&#92;' );\n\n");
                graphicControl.append("  var config = {type: 'text', center: true };\n\n");
                graphicControl.append("  evaluate( id, data, config );\n\n");
                graphicControl.append("  MathJax.Hub.Queue( [ 'Typeset', MathJax.Hub, id ] );\n");
                js = js.replace("`4`", graphicControl.toString());
                return F.JSFormData(js, "mathcell");
            }
            return F.NIL;
        }

        static boolean singleSlider(IAST ast, int i, StringBuilder slider, StringBuilder variable, JavaScriptFormFactory toJS) {
            IAST sliderRange = (IAST)ast.get(i);
            if (sliderRange.isAST2() && sliderRange.arg2().isList()) {
                int j;
                String label;
                String sliderSymbol;
                IAST listOfButtons = (IAST)sliderRange.arg2();
                String defaultValue = null;
                if (sliderRange.arg1().isList()) {
                    IAST sliderParameters = (IAST)sliderRange.arg1();
                    if (sliderParameters.size() < 4) {
                        return false;
                    }
                    sliderSymbol = toJS.toString(sliderParameters.arg1());
                    defaultValue = toJS.toString(sliderRange.arg2());
                    label = toJS.toString(sliderParameters.arg3());
                } else {
                    label = sliderSymbol = toJS.toString(sliderRange.arg1());
                }
                if (i > 2) {
                    slider.append(", ");
                }
                slider.append("{ type: 'buttons', values: [");
                for (j = 1; j < listOfButtons.size(); ++j) {
                    if (listOfButtons.get(j).isFalse() || listOfButtons.get(j).isTrue()) {
                        if (listOfButtons.get(j).isFalse()) {
                            slider.append("0");
                        } else {
                            slider.append("1");
                        }
                    } else {
                        slider.append("'");
                        toJS.convert(slider, listOfButtons.get(j));
                        slider.append("'");
                    }
                    if (j >= listOfButtons.size() - 1) continue;
                    slider.append(",");
                }
                slider.append("]");
                slider.append(", labels: [");
                for (j = 1; j < listOfButtons.size(); ++j) {
                    slider.append("'");
                    slider.append(listOfButtons.get(j).toString());
                    slider.append("'");
                    if (j >= listOfButtons.size() - 1) continue;
                    slider.append(",");
                }
                slider.append("]");
                if (defaultValue != null) {
                    slider.append(", default: ");
                    slider.append(defaultValue);
                }
                slider.append(", name: '");
                slider.append(sliderSymbol);
                slider.append("', label: '");
                slider.append(label);
                slider.append("' }\n");
                variable.append("var ");
                variable.append(sliderSymbol);
                variable.append(" = getVariable(id, '");
                variable.append(sliderSymbol);
                variable.append("');\n");
                return true;
            }
            if (sliderRange.isAST3() || sliderRange.size() == 5) {
                String label;
                String sliderSymbol;
                IExpr step = null;
                if (sliderRange.size() == 5) {
                    step = sliderRange.arg4();
                }
                String defaultValue = null;
                if (sliderRange.arg1().isList()) {
                    IAST sliderParameters = (IAST)sliderRange.arg1();
                    if (sliderParameters.size() < 4) {
                        return false;
                    }
                    sliderSymbol = toJS.toString(sliderParameters.arg1());
                    defaultValue = toJS.toString(sliderRange.arg2());
                    label = toJS.toString(sliderParameters.arg3());
                } else {
                    label = sliderSymbol = toJS.toString(sliderRange.arg1());
                }
                if (i > 2) {
                    slider.append(", ");
                }
                slider.append("{ type: 'slider', min: ");
                toJS.convert(slider, sliderRange.arg2());
                slider.append(", max: ");
                toJS.convert(slider, sliderRange.arg3());
                if (step != null) {
                    slider.append(", step: ");
                    toJS.convert(slider, step);
                }
                if (defaultValue != null) {
                    slider.append(", default: ");
                    slider.append(defaultValue);
                }
                slider.append(", name: '");
                slider.append(sliderSymbol);
                slider.append("', label: '");
                slider.append(label);
                slider.append("' }\n");
                variable.append("var ");
                variable.append(sliderSymbol);
                variable.append(" = getVariable(id, '");
                variable.append(sliderSymbol);
                variable.append("');\n");
                return true;
            }
            return false;
        }

        private static String slidersFromList(IAST ast, String js, JavaScriptFormFactory toJS) {
            if (ast.size() >= 3) {
                if (ast.arg2().isList()) {
                    StringBuilder slider = new StringBuilder();
                    StringBuilder variable = new StringBuilder();
                    for (int i = 2; i < ast.size() && ast.get(i).isList(); ++i) {
                        if (Mathcell.singleSlider(ast, i, slider, variable, toJS)) continue;
                        return null;
                    }
                    js = StringUtils.replace((String)js, (String)"`1`", (String)slider.toString());
                    js = StringUtils.replace((String)js, (String)"`2`", (String)variable.toString());
                }
            } else {
                js = StringUtils.replace((String)js, (String)"`1`", (String)"");
                js = StringUtils.replace((String)js, (String)"`2`", (String)"");
            }
            return js;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            if (Config.USE_MANIPULATE_JS) {
                S.BarChart.setEvaluator(new BarChart());
                S.BoxWhiskerChart.setEvaluator(new BoxWhiskerChart());
                S.ComplexPlot3D.setEvaluator(new ComplexPlot3D());
                S.ContourPlot.setEvaluator(new ContourPlot());
                S.DensityPlot.setEvaluator(new DensityPlot());
                S.DensityHistogram.setEvaluator(new DensityHistogram());
                S.Histogram.setEvaluator(new Histogram());
                S.PieChart.setEvaluator(new PieChart());
                S.Manipulate.setEvaluator(new Manipulate());
                S.MatrixPlot.setEvaluator(new MatrixPlot());
            }
        }
    }
}

