/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.stat.StatUtils;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.basic.ToggleFeature;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.AbortException;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.NoEvalException;
import org.matheclipse.core.eval.exception.ResultException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionOptionEvaluator;
import org.matheclipse.core.eval.util.ISequence;
import org.matheclipse.core.eval.util.Iterator;
import org.matheclipse.core.eval.util.LevelSpec;
import org.matheclipse.core.eval.util.LevelSpecification;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.eval.util.Sequence;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.DispatchExpr;
import org.matheclipse.core.generic.Comparators;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTDataset;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IIterator;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISparseArray;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.visit.VisitorLevelSpecification;
import org.matheclipse.core.visit.VisitorRemoveLevelSpecification;
import org.matheclipse.core.visit.VisitorReplaceAll;

public final class ListFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IAST foldLeft(IExpr expr, IAST list, int start, int end, BiFunction<IExpr, IExpr, ? extends IExpr> binaryFunction, IASTAppendable resultCollection) {
        if (start < end) {
            int from = start;
            IExpr elem = expr != null ? expr : list.get(from++);
            resultCollection.append(elem);
            IExpr[] temp = new IExpr[]{elem};
            resultCollection.appendArgs(from, end, i -> {
                temp[0] = (IExpr)binaryFunction.apply(temp[0], list.get(i));
                return temp[0];
            });
        }
        return resultCollection;
    }

    private static IExpr assignPartTo(ISymbol symbol, IAST part, IBuiltInSymbol header, IAST ast, EvalEngine engine) {
        if (symbol.hasAssignedSymbolValue()) {
            IExpr arg2 = engine.evaluate(ast.arg2());
            IExpr partAppend = engine.evaluate(F.binaryAST2((IExpr)header, part, arg2));
            engine.evaluate(F.Set(part, partAppend));
            return partAppend;
        }
        return IOFunctions.printMessage(ast.topHead(), "rvalue", F.list(symbol), engine);
    }

    private static IAST cleanList(IAST list) {
        return list.select(x -> !x.equals(S.Indeterminate) && !x.equals(S.Null) && !x.equals(S.None) && !x.isAST(S.Missing));
    }

    private static IExpr rankedMin(IAST listOrAssociation, int n, IAST ast, EvalEngine engine) {
        int quantities = 0;
        for (int i = 1; i < listOrAssociation.size(); ++i) {
            IExpr element = listOrAssociation.getValue(i);
            if (element.isQuantity()) {
                ++quantities;
                continue;
            }
            ISignedNumber r = element.evalReal();
            if (r != null || element.isInfinity() || element.isNegativeInfinity()) continue;
            for (int j = i; j < listOrAssociation.size(); ++j) {
                element = listOrAssociation.get(j);
                if (!element.isComplexNumeric() && !element.isComplex()) continue;
                return IOFunctions.printMessage(ast.topHead(), "rvec", F.list(listOrAssociation), engine);
            }
            return F.NIL;
        }
        if (quantities > 0 && quantities != listOrAssociation.argSize()) {
            return F.NIL;
        }
        IASTMutable orderedList = listOrAssociation.copyAST();
        return EvalAttributes.copySortLess(orderedList).get(n);
    }

    public static IAST reverse(IAST list) {
        return list.reverse(F.ast(list.head(), list.size()));
    }

    public static void initialize() {
        Initializer.init();
    }

    private ListFunctions() {
    }

    private static final class Union
    extends AbstractFunctionEvaluator {
        private Union() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() > 1) {
                if (ast.isAST1()) {
                    IAST arg1;
                    Set<IExpr> set;
                    if (ast.arg1().isASTOrAssociation() && (set = (arg1 = (IAST)ast.arg1()).asSet()) != null) {
                        IASTAppendable result = F.ListAlloc(set.size());
                        for (IExpr IExpr2 : set) {
                            result.append(IExpr2);
                        }
                        EvalAttributes.sort(result, Comparators.CANONICAL_COMPARATOR);
                        return result;
                    }
                    return F.NIL;
                }
                if (ast.arg1().isASTOrAssociation()) {
                    if (ast.exists(x -> !x.isASTOrAssociation(), 2)) {
                        return F.NIL;
                    }
                    IAST result = (IAST)ast.arg1();
                    for (int i = 2; i < ast.size(); ++i) {
                        IAST expr = (IAST)ast.get(i);
                        result = Union.union(result, expr);
                    }
                    if (result.size() > 2) {
                        EvalAttributes.sort((IASTMutable)result, Comparators.CANONICAL_COMPARATOR);
                    }
                    return result;
                }
            }
            return F.NIL;
        }

        public static IASTMutable union(IAST ast1, IAST ast2) {
            int i;
            TreeSet<IExpr> resultSet = new TreeSet<IExpr>();
            int size = ast1.size();
            for (i = 1; i < size; ++i) {
                resultSet.add(ast1.get(i));
            }
            size = ast2.size();
            for (i = 1; i < size; ++i) {
                resultSet.add(ast2.get(i));
            }
            return F.ListAlloc(resultSet);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(9);
        }
    }

    private static final class Total
    extends AbstractFunctionEvaluator {
        private Total() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            TotalLevelSpecification level = null;
            Function<IExpr, IExpr> tf = x -> x.isASTOrAssociation() ? ((IAST)x).setAtCopy(0, S.Plus) : x;
            level = ast.isAST2() ? new TotalLevelSpecification(tf, ast.arg2(), false, engine) : new TotalLevelSpecification(tf, 1, false);
            IExpr arg1 = ast.arg1();
            if (arg1.isSparseArray()) {
                ISparseArray sparseArray = (ISparseArray)arg1;
                if (ast.isAST2()) {
                    int[] dims = sparseArray.getDimension();
                    IExpr arg2 = ast.arg2();
                    if (arg2.isInfinity() || arg2.toIntDefault() >= dims.length) {
                        return sparseArray.total(S.Plus);
                    }
                }
                arg1 = sparseArray.normal(false);
            }
            if (arg1.isASTOrAssociation()) {
                level.incCurrentLevel();
                IExpr temp = ((IAST)arg1).copyAST().accept(level);
                if (temp.isPresent()) {
                    try {
                        if (temp.isListableAST() && temp.exists(x -> x.isList())) {
                            IAST total = (IAST)temp;
                            IASTMutable resultList = engine.threadASTListArgs(total, S.Total, "tllen");
                            if (resultList.isPresent()) {
                                return engine.evaluate(resultList);
                            }
                            return F.NIL;
                        }
                        return engine.evaluate(temp);
                    }
                    catch (RuntimeException rex) {
                        LOGGER.debug("Total.evaluate() failed", (Throwable)rex);
                        return F.NIL;
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private static class TotalLevelSpecification
        extends VisitorLevelSpecification {
            public TotalLevelSpecification(Function<IExpr, IExpr> function, IExpr unevaledLevelExpr, boolean includeHeads, EvalEngine engine) {
                super(function, unevaledLevelExpr, includeHeads, engine);
            }

            public TotalLevelSpecification(Function<IExpr, IExpr> function, int level, boolean includeHeads) {
                super(function, level, includeHeads);
            }

            @Override
            public IASTMutable createResult(IASTMutable ast, IExpr x) {
                if (x.isASTOrAssociation()) {
                    return ast.copy();
                }
                return ast.setAtCopy(0, S.Plus);
            }
        }
    }

    private static final class TakeWhile
    extends AbstractFunctionEvaluator {
        private TakeWhile() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg1.isAST()) {
                IAST list = (IAST)arg1;
                IASTAppendable result = F.ast(list.head());
                list.forAll(x -> {
                    if (engine.evalTrue(arg2, (IExpr)x)) {
                        result.append((IExpr)x);
                        return true;
                    }
                    return false;
                }, 1);
                return result;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class TakeSmallestBy
    extends AbstractEvaluator {
        private TakeSmallestBy() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2() && !(ast = F.operatorForm1Append(ast)).isPresent()) {
                return F.NIL;
            }
            if (ast.isAST3()) {
                try {
                    if (ast.arg1().isASTOrAssociation()) {
                        IAST cleanedList = ListFunctions.cleanList((IAST)ast.arg1());
                        int n = ast.arg3().toIntDefault();
                        if (n > 0 && n <= cleanedList.size()) {
                            IASTMutable list = cleanedList.mapThreadEvaled(engine, F.unary(ast.arg2(), F.Slot1), 1);
                            try {
                                SmallestIndexComparator comparator = new SmallestIndexComparator(list, engine);
                                Integer[] indexes = comparator.createIndexArray();
                                Arrays.sort(indexes, comparator);
                                int[] smallestIndexes = new int[n];
                                for (int i = 0; i < n; ++i) {
                                    smallestIndexes[i] = indexes[i];
                                }
                                return cleanedList.getItems(smallestIndexes, smallestIndexes.length);
                            }
                            catch (NoEvalException neex) {
                                return IOFunctions.printMessage(ast.topHead(), "tbnval", F.list(list, ast.arg2()), engine);
                            }
                        }
                    }
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3_0;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class TakeSmallest
    extends AbstractEvaluator {
        private TakeSmallest() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            block7: {
                if (ast.isAST2()) {
                    try {
                        if (!ast.arg1().isASTOrAssociation()) break block7;
                        IAST cleanedList = ListFunctions.cleanList((IAST)ast.arg1());
                        try {
                            int n = ast.arg2().toIntDefault();
                            if (n > 0 && n <= cleanedList.size()) {
                                SmallestIndexComparator comparator = new SmallestIndexComparator(cleanedList, engine);
                                Integer[] indexes = comparator.createIndexArray();
                                Arrays.sort(indexes, comparator);
                                int[] smallestIndexes = new int[n];
                                for (int i = 0; i < n; ++i) {
                                    smallestIndexes[i] = indexes[i];
                                }
                                return cleanedList.getItems(smallestIndexes, smallestIndexes.length);
                            }
                        }
                        catch (NoEvalException neex) {
                            return IOFunctions.printMessage(ast.topHead(), "rvec2", F.list(cleanedList), engine);
                        }
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class TakeLargestBy
    extends AbstractEvaluator {
        private TakeLargestBy() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2() && !(ast = F.operatorForm1Append(ast)).isPresent()) {
                return F.NIL;
            }
            if (ast.isAST3()) {
                try {
                    if (ast.arg1().isASTOrAssociation()) {
                        IAST cleanedList = ListFunctions.cleanList((IAST)ast.arg1());
                        int n = ast.arg3().toIntDefault();
                        if (n > 0 && n <= cleanedList.size()) {
                            IASTMutable list = cleanedList.mapThreadEvaled(engine, F.unary(ast.arg2(), F.Slot1), 1);
                            try {
                                LargestIndexComparator comparator = new LargestIndexComparator(list, engine);
                                Integer[] indexes = comparator.createIndexArray();
                                Arrays.sort(indexes, comparator);
                                int[] largestIndexes = new int[n];
                                for (int i = 0; i < n; ++i) {
                                    largestIndexes[i] = indexes[i];
                                }
                                return cleanedList.getItems(largestIndexes, largestIndexes.length);
                            }
                            catch (NoEvalException neex) {
                                return IOFunctions.printMessage(ast.topHead(), "tbnval", F.list(list, ast.arg2()), engine);
                            }
                        }
                    }
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3_0;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class TakeLargest
    extends AbstractEvaluator {
        private TakeLargest() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            block7: {
                if (ast.isAST2()) {
                    try {
                        if (!ast.arg1().isASTOrAssociation()) break block7;
                        IAST cleanedList = ListFunctions.cleanList((IAST)ast.arg1());
                        try {
                            int n = ast.arg2().toIntDefault();
                            if (n > 0 && n <= cleanedList.size()) {
                                LargestIndexComparator comparator = new LargestIndexComparator(cleanedList, engine);
                                Integer[] indexes = comparator.createIndexArray();
                                Arrays.sort(indexes, comparator);
                                int[] largestIndexes = new int[n];
                                for (int i = 0; i < n; ++i) {
                                    largestIndexes[i] = indexes[i];
                                }
                                return cleanedList.getItems(largestIndexes, largestIndexes.length);
                            }
                        }
                        catch (NoEvalException neex) {
                            return IOFunctions.printMessage(ast.topHead(), "rvec2", F.list(cleanedList), engine);
                        }
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Take
    extends AbstractFunctionEvaluator {
        private Take() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.arg1().isASTOrAssociation()) {
                    ISequence[] sequ = Sequence.createSequences(ast, 2, "take", engine);
                    if (sequ == null) {
                        return F.NIL;
                    }
                    IAST arg1 = (IAST)ast.arg1();
                    if (arg1.isAssociation()) {
                        return Take.take((IAssociation)arg1, 0, sequ);
                    }
                    return Take.take(arg1, 0, sequ);
                }
                LOGGER.log(engine.getLogLevel(), "Take: Nonatomic expression expected at position 1");
                return F.NIL;
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("Take.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_INFINITY;
        }

        private static IAST take(IAST list, int level, ISequence[] sequenceSpecifications) {
            ISequence sequ = sequenceSpecifications[level];
            int size = list.size();
            sequ.setListSize(size);
            IASTAppendable resultList = list.copyHead(10 > size ? size : 10);
            int newLevel = level + 1;
            int start = sequ.getStart();
            int end = sequ.getEnd();
            int step = sequ.getStep();
            if (step < 0) {
                if (start < --end || end <= 0 || start >= list.size()) {
                    String str = IOFunctions.getMessage("take", F.list(F.ZZ(start), F.ZZ(end), list), EvalEngine.get());
                    throw new ArgumentTypeException(str);
                }
                for (int i = start; i >= end; i += step) {
                    IExpr arg = list.get(i);
                    if (sequenceSpecifications.length > newLevel) {
                        if (arg.isAssociation()) {
                            resultList.append(Take.take((IAssociation)arg, newLevel, sequenceSpecifications));
                            continue;
                        }
                        if (arg.isASTOrAssociation()) {
                            resultList.append(Take.take((IAST)arg, newLevel, sequenceSpecifications));
                            continue;
                        }
                        throw new ArgumentTypeException("cannot execute take for argument: " + arg.toString());
                    }
                    resultList.append(arg);
                }
            } else {
                if (start == 0) {
                    return resultList;
                }
                if (end > list.size()) {
                    String str = IOFunctions.getMessage("take", F.list(F.ZZ(start), F.ZZ(end - 1), list), EvalEngine.get());
                    throw new ArgumentTypeException(str);
                }
                for (int i = start; i < end; i += step) {
                    IExpr arg = list.get(i);
                    if (sequenceSpecifications.length > newLevel) {
                        if (arg.isAssociation()) {
                            resultList.append(Take.take((IAssociation)arg, newLevel, sequenceSpecifications));
                            continue;
                        }
                        if (arg.isASTOrAssociation()) {
                            resultList.append(Take.take((IAST)arg, newLevel, sequenceSpecifications));
                            continue;
                        }
                        String str = IOFunctions.getMessage("list", F.list(F.ZZ(i), list), EvalEngine.get());
                        throw new ArgumentTypeException(str);
                    }
                    resultList.append(arg);
                }
            }
            return resultList;
        }

        private static IAST take(IAssociation assoc2, int level, ISequence[] sequenceSpecifications) {
            ISequence sequ = sequenceSpecifications[level];
            int size = assoc2.size();
            sequ.setListSize(size);
            IASTAppendable resultAssoc = assoc2.copyHead(10 > size ? size : 10);
            int newLevel = level + 1;
            int start = sequ.getStart();
            int end = sequ.getEnd();
            int step = sequ.getStep();
            if (step < 0) {
                if (start < --end || end <= 0 || start >= assoc2.size()) {
                    String str = IOFunctions.getMessage("take", F.list(F.ZZ(start), F.ZZ(end), assoc2), EvalEngine.get());
                    throw new ArgumentTypeException(str);
                }
                for (int i = start; i >= end; i += step) {
                    IAST rule = assoc2.getRule(i);
                    IExpr arg = rule.second();
                    if (sequenceSpecifications.length > newLevel) {
                        if (arg.isAssociation()) {
                            resultAssoc.appendRule(F.Rule(rule.first(), (IExpr)Take.take((IAssociation)arg, newLevel, sequenceSpecifications)));
                            continue;
                        }
                        if (arg.isASTOrAssociation()) {
                            resultAssoc.appendRule(F.Rule(rule.first(), (IExpr)Take.take((IAST)arg, newLevel, sequenceSpecifications)));
                            continue;
                        }
                        throw new ArgumentTypeException("cannot execute take for argument: " + arg.toString());
                    }
                    resultAssoc.appendRule(rule);
                }
            } else {
                if (start == 0) {
                    return resultAssoc;
                }
                if (end > assoc2.size()) {
                    String str = IOFunctions.getMessage("take", F.list(F.ZZ(start), F.ZZ(end - 1), assoc2), EvalEngine.get());
                    throw new ArgumentTypeException(str);
                }
                for (int i = start; i < end; i += step) {
                    IAST rule = assoc2.getRule(i);
                    IExpr arg = rule.second();
                    if (sequenceSpecifications.length > newLevel) {
                        if (arg.isAssociation()) {
                            resultAssoc.appendRule(F.Rule(rule.first(), (IExpr)Take.take((IAssociation)arg, newLevel, sequenceSpecifications)));
                            continue;
                        }
                        if (arg.isASTOrAssociation()) {
                            resultAssoc.appendRule(F.Rule(rule.first(), (IExpr)Take.take((IAST)arg, newLevel, sequenceSpecifications)));
                            continue;
                        }
                        String str = IOFunctions.getMessage("list", F.list(F.ZZ(i), assoc2), EvalEngine.get());
                        throw new ArgumentTypeException(str);
                    }
                    resultAssoc.appendRule(rule);
                }
            }
            return resultAssoc;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(16384);
        }
    }

    private static final class Tally
    extends AbstractEvaluator {
        private Tally() {
        }

        private static IASTAppendable createResultList(Map<IExpr, Integer> map) {
            IASTAppendable result = F.ListAlloc(map.size());
            for (Map.Entry<IExpr, Integer> entry : map.entrySet()) {
                result.append(F.list(entry.getKey(), F.ZZ(entry.getValue())));
            }
            return result;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST list = Validate.checkListType(ast, 1, engine);
            if (list.isPresent()) {
                int size = ast.size();
                if (size == 2) {
                    return Tally.tally1Arg(list);
                }
                if (size == 3) {
                    BiPredicate<IExpr, IExpr> biPredicate = Predicates.isBinaryTrue(ast.arg2());
                    return Tally.tally2Args(list, biPredicate);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }

        public static IASTAppendable tally1Arg(IAST list) {
            LinkedHashMap<IExpr, Integer> map = new LinkedHashMap<IExpr, Integer>();
            for (int i = 1; i < list.size(); ++i) {
                IExpr arg;
                Integer value = (Integer)map.get(arg = list.get(i));
                map.put(arg, value == null ? 1 : value + 1);
            }
            return Tally.createResultList(map);
        }

        private static IAST tally2Args(IAST list, BiPredicate<IExpr, IExpr> test) {
            LinkedHashMap<IExpr, Integer> map = new LinkedHashMap<IExpr, Integer>();
            block0: for (int i = 1; i < list.size(); ++i) {
                IExpr arg = list.get(i);
                for (Map.Entry entry : map.entrySet()) {
                    if (!test.test((IExpr)entry.getKey(), arg)) continue;
                    map.put((IExpr)entry.getKey(), (Integer)entry.getValue() + 1);
                    continue block0;
                }
                map.put(arg, 1);
            }
            return Tally.createResultList(map);
        }
    }

    public static class Table
    extends AbstractFunctionEvaluator {
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return Table.evaluateTable(ast, F.CEmptyList, F.CEmptyList, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_INFINITY;
        }

        protected static IExpr evaluateTable(IAST ast, IAST resultList, IExpr defaultValue, EvalEngine engine) {
            try {
                if (ast.size() > 2) {
                    ArrayList<IIterator<IExpr>> iterList = new ArrayList<IIterator<IExpr>>();
                    for (int i = 2; i < ast.size(); ++i) {
                        IExpr arg = ast.get(i);
                        if (arg.isList()) {
                            iterList.add(Iterator.create((IAST)arg, i, engine));
                            continue;
                        }
                        IExpr evaledArg = engine.evaluate(arg);
                        if (evaledArg.isReal()) {
                            iterList.add(Iterator.create(F.list(evaledArg), i, engine));
                            continue;
                        }
                        return IOFunctions.printMessage(ast.topHead(), "nliter", F.list(arg, F.ZZ(i)), engine);
                    }
                    TableGenerator generator = new TableGenerator(iterList, resultList, new TableFunction(engine, ast.arg1()), defaultValue);
                    return generator.table();
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.debug("Table.evaluateTable() failed", (Throwable)e);
            }
            catch (ArithmeticException | ClassCastException | NoEvalException object) {
                // empty catch block
            }
            return F.NIL;
        }

        protected static IExpr evaluateTableThrow(IAST ast, IAST resultList, IExpr defaultValue, EvalEngine engine) {
            try {
                if (ast.size() > 2) {
                    ArrayList<IIterator<IExpr>> iterList = new ArrayList<IIterator<IExpr>>();
                    for (int i = 2; i < ast.size(); ++i) {
                        IExpr arg = ast.get(i);
                        iterList.add(Iterator.create(arg.isList() ? (IAST)arg : F.list(arg), i, engine));
                    }
                    TableGenerator generator = new TableGenerator(iterList, resultList, new TableFunction(engine, ast.arg1()), defaultValue);
                    return generator.tableThrow();
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.debug("Table.evaluateTableThrow() failed", (Throwable)e);
            }
            catch (ArithmeticException | ClassCastException | NoEvalException object) {
                // empty catch block
            }
            return F.NIL;
        }

        protected static IExpr evaluateLast(IExpr expr, IIterator<IExpr> iter, IAST resultList, IExpr defaultValue) {
            try {
                ArrayList<IIterator<IExpr>> iterList = new ArrayList<IIterator<IExpr>>();
                iterList.add(iter);
                TableGenerator generator = new TableGenerator(iterList, resultList, new TableFunction(EvalEngine.get(), expr), defaultValue);
                return generator.table();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.debug("Table.evaluateLast() failed", (Throwable)e);
            }
            catch (ArithmeticException | ClassCastException | NoEvalException object) {
                // empty catch block
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }

        public IAST determineIteratorVariables(IAST ast) {
            int size = ast.size();
            IASTAppendable variableList = F.ListAlloc(size);
            for (int i = 2; i < size; ++i) {
                IExpr arg = ast.get(i);
                if (arg.isVariable()) {
                    variableList.append(arg);
                    continue;
                }
                if (!arg.isList() || arg.size() < 2 || !arg.first().isVariable()) continue;
                variableList.append(arg.first());
            }
            return variableList;
        }

        public static VariablesSet determineIteratorExprVariables(IAST ast) {
            VariablesSet variableList = new VariablesSet();
            for (int i = 2; i < ast.size(); ++i) {
                IExpr arg = ast.get(i);
                if (arg.isVariable()) {
                    variableList.add(arg);
                    continue;
                }
                if (!arg.isList() || arg.size() < 2 || !arg.first().isVariable()) continue;
                variableList.add(arg.first());
            }
            return variableList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IExpr evalBlockWithoutReap(IExpr expr, IAST localVariablesList) {
            EvalEngine engine = EvalEngine.get();
            List<IExpr> reapList = engine.getReapList();
            boolean quietMode = engine.isQuietMode();
            try {
                engine.setQuietMode(true);
                engine.setReapList(null);
                IExpr iExpr = engine.evalBlock(expr, localVariablesList);
                return iExpr;
            }
            catch (RuntimeException runtimeException) {
            }
            finally {
                engine.setReapList(reapList);
                engine.setQuietMode(quietMode);
            }
            return expr;
        }
    }

    private static final class Subdivide
    extends AbstractEvaluator {
        private Subdivide() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.isAST1()) {
                int n = arg1.toIntDefault(-1);
                if (n <= 0) {
                    return IOFunctions.printMessage(S.Subdivide, "sdmint", F.list(F.C1, ast), engine);
                }
                return Range.range(0, n + 1).map(x -> x.divide(arg1), 1);
            }
            IExpr arg2 = ast.arg2();
            if (ast.isAST2()) {
                int n = arg2.toIntDefault(-1);
                if (n <= 0) {
                    return IOFunctions.printMessage(S.Subdivide, "sdmint", F.list(F.C2, ast), engine);
                }
                IAST factorList = Range.range(0, n + 1).map(x -> x.divide(arg2), 1);
                return factorList.map(x -> arg1.times((IExpr)x), 1);
            }
            if (arg1.isList() && arg2.isList() && arg1.size() != arg2.size()) {
                return F.NIL;
            }
            IExpr arg3 = ast.arg3();
            int n = arg3.toIntDefault(-1);
            if (n <= 0) {
                return IOFunctions.printMessage(S.Subdivide, "sdmint", F.list(F.C3, ast), engine);
            }
            IAST factorList = Range.range(0, n + 1).map(x -> x.divide(arg3), 1);
            return factorList.map(x -> arg1.plus(arg2.times((IExpr)x).subtract(arg1.times((IExpr)x))), 1);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class SplitBy
    extends AbstractEvaluator {
        private SplitBy() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isASTOrAssociation()) {
                return this.splitByFunction(ast.arg2().orNewList(), 1, (IAST)ast.arg1(), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        private IExpr splitByFunction(IAST functorList, int pos, IAST list, EvalEngine engine) {
            if (pos >= functorList.size()) {
                return F.NIL;
            }
            IExpr functorHead = functorList.get(pos);
            Function<IExpr, IExpr> function = x -> engine.evaluate(F.unaryAST1(functorHead, x));
            IASTAppendable result = F.ListAlloc(8);
            if (list.size() > 1) {
                IExpr last = function.apply(list.arg1());
                IASTAppendable temp = F.ListAlloc(8);
                temp.append(list.arg1());
                for (int i = 2; i < list.size(); ++i) {
                    IExpr listElement = list.get(i);
                    IExpr current = function.apply(listElement);
                    if (!current.equals(last)) {
                        IExpr subList = this.splitByFunction(functorList, pos + 1, temp, engine);
                        if (subList.isPresent()) {
                            result.append(subList);
                        } else {
                            result.append(temp);
                        }
                        temp = F.ListAlloc(8);
                    }
                    temp.append(listElement);
                    last = current;
                }
                IExpr subList = this.splitByFunction(functorList, pos + 1, temp, engine);
                if (subList.isPresent()) {
                    result.append(subList);
                } else {
                    result.append(temp);
                }
            }
            return result;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Split
    extends AbstractEvaluator {
        private Split() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isASTOrAssociation()) {
                IExpr predicateHead = S.Equal;
                if (ast.isAST2()) {
                    predicateHead = ast.arg2();
                }
                BiPredicate<IExpr, IExpr> pred = Predicates.isBinaryTrue(predicateHead);
                IAST list = (IAST)ast.arg1();
                IASTAppendable result = F.ListAlloc(8);
                if (list.size() > 1) {
                    IExpr current = list.arg1();
                    IASTAppendable subResultList = F.ListAlloc(8);
                    result.append(subResultList);
                    subResultList.append(current);
                    for (int i = 2; i < list.size(); ++i) {
                        IExpr listElement = list.get(i);
                        if (!pred.test(current, listElement)) {
                            subResultList = F.ListAlloc(8);
                            result.append(subResultList);
                        }
                        subResultList.append(listElement);
                        current = listElement;
                    }
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class SelectFirst
    extends AbstractEvaluator {
        private SelectFirst() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int argSize = ast.argSize();
            if (argSize > 1 && ast.arg1().isASTOrAssociation()) {
                int index;
                IAST list = (IAST)ast.arg1();
                IExpr predicateHead = ast.arg2();
                IExpr defaultValue = F.CMissingNotFound;
                if (argSize == 3) {
                    defaultValue = ast.arg3();
                }
                if ((index = list.indexOf(x -> engine.evalTrue(predicateHead, (IExpr)x))) > 0) {
                    return list.get(index);
                }
                return defaultValue;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(64);
        }
    }

    private static final class Select
    extends AbstractEvaluator {
        private Select() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = ast.size();
            if (size >= 3) {
                try {
                    if (ast.arg1().isASTOrAssociation()) {
                        IAST list = (IAST)ast.arg1();
                        IExpr predicateHead = ast.arg2();
                        if (size == 3) {
                            return list.select(x -> engine.evalTrue(predicateHead, (IExpr)x));
                        }
                        if (size == 4 && ast.arg3().isInteger()) {
                            int resultLimit = Validate.checkIntType(ast, 3);
                            if (resultLimit == 0) {
                                return F.CEmptyList;
                            }
                            return list.select(x -> engine.evalTrue(predicateHead, (IExpr)x), resultLimit);
                        }
                    }
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.log(engine.getLogLevel(), "{}: {}", (Object)ast.topHead(), (Object)iae.getMessage());
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class RotateRight
    extends AbstractCoreFunctionEvaluator {
        private RotateRight() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            if (arg1.isASTOrAssociation()) {
                int argSize = arg1.argSize();
                if (argSize == 0) {
                    return arg1;
                }
                IAST list = (IAST)arg1;
                if (ast.isAST1()) {
                    IASTAppendable result = F.ast(list.head(), list.size() + 1);
                    list.rotateRight(result, 1);
                    return result;
                }
                IExpr arg2 = engine.evaluate(ast.arg2());
                if (arg2.isInteger()) {
                    int n = Validate.checkIntType(S.RotateRight, arg2, 0, engine);
                    if (n == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    IASTAppendable result = F.ast(list.head(), list.size() + (n %= argSize));
                    list.rotateRight(result, n);
                    return result;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class RotateLeft
    extends AbstractCoreFunctionEvaluator {
        private RotateLeft() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            if (arg1.isASTOrAssociation()) {
                int argSize = arg1.argSize();
                if (argSize == 0) {
                    return arg1;
                }
                IAST list = (IAST)arg1;
                if (ast.isAST1()) {
                    IASTAppendable result = F.ast(list.head(), list.size() + 1);
                    list.rotateLeft(result, 1);
                    return result;
                }
                IExpr arg2 = engine.evaluate(ast.arg2());
                if (arg2.isInteger()) {
                    int n = Validate.checkIntType(S.RotateLeft, arg2, 0, engine);
                    if (n == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    IASTAppendable result = F.ast(list.head(), list.size() + (n %= argSize));
                    list.rotateLeft(result, n);
                    return result;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Riffle
    extends AbstractCoreFunctionEvaluator {
        private Riffle() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            if (!arg1.isList()) {
                return IOFunctions.printMessage(ast.topHead(), "list", F.list(F.C1, ast), engine);
            }
            IExpr arg2 = engine.evaluate(ast.arg2());
            IAST list = (IAST)arg1;
            if (arg2.isASTOrAssociation()) {
                return Riffle.riffleAST(list, (IAST)arg2);
            }
            return Riffle.riffleAtom(list, arg2);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        public static IExpr riffleAtom(IAST arg1, IExpr arg2) {
            if (arg1.size() < 2) {
                return arg1;
            }
            IASTAppendable result = arg1.copyHead(arg1.argSize() * 2 + 1);
            for (int i = 1; i < arg1.argSize(); ++i) {
                result.append(arg1.get(i));
                result.append(arg2);
            }
            result.append(arg1.last());
            return result;
        }

        public static IAST riffleAST(IAST arg1, IAST arg2) {
            if (arg1.size() < 2) {
                return arg1;
            }
            IASTAppendable result = arg1.copyHead(arg1.size() * 2);
            if (arg2.size() < 2) {
                return arg1;
            }
            int j = 1;
            for (int i = 1; i < arg1.argSize(); ++i) {
                result.append(arg1.get(i));
                if (j < arg2.size()) {
                    result.append(arg2.get(j++));
                    continue;
                }
                j = 1;
                result.append(arg2.get(j++));
            }
            result.append(arg1.last());
            if (j < arg2.size()) {
                result.append(arg2.get(j++));
            }
            return result;
        }
    }

    private static final class RightComposition
    extends AbstractFunctionEvaluator {
        private RightComposition() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST headList;
            if (ast.head().equals(S.RightComposition)) {
                if (ast.isAST0()) {
                    return S.Identity;
                }
                return ast.remove(x -> x.equals(S.Identity));
            }
            if (ast.head().isAST() && (headList = (IAST)ast.head()).size() > 1) {
                IASTAppendable inner;
                IASTAppendable result = inner = F.ast(headList.last());
                for (int i = headList.size() - 2; i >= 1; --i) {
                    IASTAppendable temp = F.ast(headList.get(i));
                    inner.append(temp);
                    inner = temp;
                }
                inner.appendArgs(ast);
                return result;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(9);
        }
    }

    private static final class Reverse
    extends AbstractFunctionEvaluator {
        private Reverse() {
        }

        @Override
        public IExpr evaluate(IAST functionList, EvalEngine engine) {
            if (functionList.size() != 2) {
                return F.NIL;
            }
            IExpr arg1 = functionList.arg1();
            if (arg1.isAssociation()) {
                IAssociation assoc = (IAssociation)arg1;
                return assoc.reverse(F.assoc());
            }
            if (arg1.isASTOrAssociation()) {
                IAST list = (IAST)arg1;
                return ListFunctions.reverse(list);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class Rest
    extends AbstractFunctionEvaluator {
        private Rest() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST rest = ast.arg1().rest();
            if (rest.isPresent()) {
                return rest;
            }
            return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C1, ast), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class ReplaceRepeated
    extends AbstractEvaluator {
        private ReplaceRepeated() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            OptionArgs options;
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg2.isListOfLists()) {
                return ((IAST)arg2).mapThread(ast, 2);
            }
            int maxIterations = -1;
            if (ast.isAST3() && (maxIterations = (options = new OptionArgs(ast.topHead(), ast, 3, engine)).getOptionMaxIterations(S.MaxIterations)) == Integer.MIN_VALUE) {
                return F.NIL;
            }
            VisitorReplaceAll visitor = VisitorReplaceAll.createVisitor(arg2);
            return arg1.replaceRepeated(visitor, maxIterations);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class ReplacePart
    extends AbstractEvaluator {
        private ReplacePart() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr result;
            IExpr.COMPARE_TERNARY heads = IExpr.COMPARE_TERNARY.UNDECIDABLE;
            if (ast.size() > 3) {
                OptionArgs options = new OptionArgs(ast.topHead(), ast, 3, engine);
                IExpr option = options.getOption(S.Heads);
                if (option.isTrue()) {
                    heads = IExpr.COMPARE_TERNARY.TRUE;
                } else if (option.isFalse()) {
                    heads = IExpr.COMPARE_TERNARY.FALSE;
                } else {
                    IExpr result2 = ast.arg1();
                    if (ast.arg3().isList()) {
                        for (IExpr subList : (IAST)ast.arg3()) {
                            IExpr expr = result2.replacePart(F.Rule(subList, ast.arg2()), heads);
                            if (!expr.isPresent()) continue;
                            result2 = expr;
                        }
                        return result2;
                    }
                    return result2.replacePart(F.Rule(ast.arg3(), ast.arg2()), heads).orElse(result2);
                }
            }
            if (ast.arg2().isListOfRules()) {
                result = ast.arg1();
                IExpr expr = result.replacePart((IAST)ast.arg2(), heads);
                if (expr.isPresent()) {
                    result = expr;
                }
                return result;
            }
            result = ast.arg1();
            if (ast.arg2().isRuleAST()) {
                return ast.arg1().replacePart((IAST)ast.arg2(), heads).orElse(ast.arg1());
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_4_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class ReplaceList
    extends AbstractEvaluator {
        private ReplaceList() {
        }

        private static IExpr replaceExpr(IAST ast, IExpr arg1, IExpr rules, IASTAppendable result, int maxNumberOfResults, EvalEngine engine) {
            if (rules.isList()) {
                IAST rulesList = (IAST)rules;
                for (IExpr element : rulesList) {
                    if (element.isRuleAST()) {
                        IAST rule = (IAST)element;
                        Function<IExpr, IExpr> function = Functors.listRules(rule, result, engine);
                        function.apply(arg1);
                        continue;
                    }
                    throw new ArgumentTypeException("rule expressions (x->y) expected instead of " + element.toString());
                }
                return result;
            }
            if (rules.isRuleAST()) {
                Function<IExpr, IExpr> function = Functors.listRules((IAST)rules, result, engine);
                IExpr temp = function.apply(arg1);
                if (temp.isPresent()) {
                    return temp;
                }
            } else {
                throw new ArgumentTypeException("rule expressions (x->y) expected instead of " + rules.toString());
            }
            return result;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!ToggleFeature.REPLACE_LIST) {
                return F.NIL;
            }
            if (ast.size() == 2 && ast.head().isAST(S.ReplaceList, 2)) {
                return F.ReplaceList(ast.first(), ast.head().first());
            }
            if (ast.size() >= 3 && ast.size() <= 4) {
                try {
                    IExpr arg3;
                    int maxNumberOfResults = Integer.MAX_VALUE;
                    IExpr arg1 = ast.arg1();
                    IExpr rules = ast.arg2();
                    if (ast.isAST3() && (arg3 = engine.evaluate(ast.arg3())).isReal()) {
                        maxNumberOfResults = ((ISignedNumber)arg3).toInt();
                    }
                    IASTAppendable result = F.ListAlloc();
                    return ReplaceList.replaceExpr(ast, arg1, rules, result, maxNumberOfResults, engine);
                }
                catch (ArithmeticException ae) {
                    LOGGER.log(engine.getLogLevel(), "ReplaceList", (Throwable)ae);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            if (!ToggleFeature.REPLACE_LIST) {
                // empty if block
            }
        }
    }

    private static class ReplaceAll
    extends AbstractEvaluator {
        private ReplaceAll() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 3) {
                IExpr arg1 = ast.arg1();
                IExpr arg2 = ast.arg2();
                if (arg2.isListOfLists()) {
                    return ((IAST)arg2).mapThread(ast, 2);
                }
                VisitorReplaceAll visitor = VisitorReplaceAll.createVisitor(arg2);
                return arg1.accept(visitor).orElse(arg1);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Replace
    extends AbstractEvaluator {
        private Replace() {
        }

        private static IExpr replaceExpr(IAST ast, IExpr arg1, IExpr rules, EvalEngine engine) {
            if (rules.isList()) {
                for (IExpr element : (IAST)rules) {
                    if (element.isRuleAST()) {
                        IAST rule = (IAST)element;
                        Function<IExpr, IExpr> function = Functors.rules(rule, engine);
                        IExpr temp = function.apply(arg1);
                        if (!temp.isPresent()) continue;
                        return temp;
                    }
                    throw new ArgumentTypeException("rule expressions (x->y) expected instead of " + element.toString());
                }
                return arg1;
            }
            if (rules.isRuleAST()) {
                return Replace.replaceRule(arg1, (IAST)rules, engine);
            }
            throw new ArgumentTypeException("rule expressions (x->y) expected instead of " + rules.toString());
        }

        private static IExpr replaceExprWithLevelSpecification(IAST ast, IExpr arg1, IExpr rules, IExpr exprLevelSpecification, EvalEngine engine) {
            ReplaceFunction replaceFunction = new ReplaceFunction(F.CEmptyList, engine);
            VisitorLevelSpecification level = new VisitorLevelSpecification((Function<IExpr, IExpr>)replaceFunction, exprLevelSpecification, false, engine);
            replaceFunction.setRule(rules);
            return arg1.accept(level).orElse(arg1);
        }

        private static IExpr replaceRule(IExpr arg1, IAST rule, EvalEngine engine) {
            Function<IExpr, IExpr> function = Functors.rules(rule, engine);
            IExpr temp = function.apply(arg1);
            if (temp.isPresent()) {
                return temp;
            }
            return arg1;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() < 3 || ast.size() > 4) {
                return F.NIL;
            }
            IExpr arg1 = ast.arg1();
            IExpr rules = engine.evaluate(ast.arg2());
            if (rules.isListOfLists()) {
                return ((IAST)rules).mapThread(ast, 2);
            }
            if (ast.isAST3()) {
                return Replace.replaceExprWithLevelSpecification(ast, arg1, rules, ast.arg3(), engine);
            }
            return Replace.replaceExpr(ast, arg1, rules, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(64);
        }

        private static final class ReplaceFunction
        implements Function<IExpr, IExpr> {
            private final EvalEngine engine;
            private IExpr rules;

            public ReplaceFunction(IExpr rules, EvalEngine engine) {
                this.rules = rules;
                this.engine = engine;
            }

            @Override
            public IExpr apply(IExpr input) {
                if (this.rules.isList()) {
                    for (IExpr element : (IAST)this.rules) {
                        if (element.isRuleAST()) {
                            IAST rule = (IAST)element;
                            Function<IExpr, IExpr> function = Functors.rules(rule, this.engine);
                            IExpr temp = function.apply(input);
                            if (!temp.isPresent()) continue;
                            return temp;
                        }
                        throw new ArgumentTypeException("rule expressions (x->y) expected instead of " + element.toString());
                    }
                    return input;
                }
                if (this.rules.isRuleAST()) {
                    return Replace.replaceRule(input, (IAST)this.rules, this.engine);
                }
                throw new ArgumentTypeException("rule expressions (x->y) expected instead of " + this.rules.toString());
            }

            public void setRule(IExpr rules) {
                this.rules = rules;
            }
        }
    }

    private static class RankedMin
    extends AbstractFunctionEvaluator {
        private RankedMin() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg1.isListOrAssociation()) {
                IAST list = (IAST)arg1;
                int argSize = list.argSize();
                int n = arg2.toIntDefault();
                if (n != Integer.MIN_VALUE) {
                    if (n == 1) {
                        return list.setAtCopy(0, S.Min);
                    }
                    if (n == -1 || n == argSize) {
                        return list.setAtCopy(0, S.Max);
                    }
                    if (n < 0) {
                        int pn = -n;
                        if (pn < 1 || pn > argSize) {
                            return IOFunctions.printMessage(ast.topHead(), "rank", F.list(F.ZZ(n), F.C1, F.ZZ(argSize)), engine);
                        }
                        return ListFunctions.rankedMin(list, list.size() + n, ast, engine);
                    }
                    if (n < 1 || n > argSize) {
                        return IOFunctions.printMessage(ast.topHead(), "rank", F.list(F.ZZ(n), F.C1, F.ZZ(argSize)), engine);
                    }
                    return ListFunctions.rankedMin(list, n, ast, engine);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class RankedMax
    extends AbstractFunctionEvaluator {
        private RankedMax() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg1.isList()) {
                IAST list = (IAST)arg1;
                int argSize = list.argSize();
                int n = arg2.toIntDefault();
                if (n != Integer.MIN_VALUE) {
                    if (n == 1) {
                        return list.setAtCopy(0, S.Max);
                    }
                    if (n == -1 || n == argSize) {
                        return list.setAtCopy(0, S.Min);
                    }
                    if (n < 0) {
                        int pn = -n;
                        if (pn < 1 || pn > argSize) {
                            return IOFunctions.printMessage(ast.topHead(), "rank", F.list(F.ZZ(n), F.C1, F.ZZ(argSize)), engine);
                        }
                        return ListFunctions.rankedMin(list, pn, ast, engine);
                    }
                    if (n < 1 || n > argSize) {
                        return IOFunctions.printMessage(ast.topHead(), "rank", F.list(F.ZZ(n), F.C1, F.ZZ(argSize)), engine);
                    }
                    return ListFunctions.rankedMin(list, list.size() - n, ast, engine);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class Range
    extends AbstractEvaluator {
        private Range() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isEmptyList()) {
                return ast.arg1();
            }
            if (ast.isAST1() && ast.arg1().isReal()) {
                int size = ast.arg1().toIntDefault();
                if (size != Integer.MIN_VALUE) {
                    return Range.range(size);
                }
                LOGGER.log(engine.getLogLevel(), "Range: argument {} is greater than Javas Integer.MAX_VALUE or no integer number.", (Object)ast.arg1());
                return F.NIL;
            }
            if (ast.isAST3()) {
                if (ast.arg3().isZero()) {
                    return IOFunctions.printMessage(ast.topHead(), "infy", F.list(F.Divide(ast.arg2(), F.C0)), engine);
                }
                if (ast.arg3().isDirectedInfinity()) {
                    return ast.arg1();
                }
            }
            return this.evaluateTable(ast, F.List(), engine);
        }

        public static IAST range(int size) {
            if (size > 0x7FFFFFFC) {
                LOGGER.log(EvalEngine.get().getLogLevel(), "Range: argument {} is greater than Javas Integer.MAX_VALUE-3", (Object)size);
                return F.NIL;
            }
            return Range.range(1, size + 1);
        }

        public static IAST range(int startInclusive, int endExclusive) {
            int size = endExclusive - startInclusive;
            if (size >= 0) {
                IASTAppendable result = F.ListAlloc(size + 1);
                return result.appendArgs(startInclusive, endExclusive, i -> F.ZZ(i));
            }
            return F.CEmptyList;
        }

        public IExpr evaluateTable(IAST ast, IAST resultList, EvalEngine engine) {
            ArrayList<IIterator<IExpr>> iterList = null;
            try {
                if (ast.size() > 1 && ast.size() <= 4) {
                    iterList = new ArrayList<IIterator<IExpr>>();
                    iterList.add(Iterator.create(ast, null, engine));
                    TableGenerator generator = new TableGenerator(iterList, resultList, new UnaryRangeFunction(), F.CEmptyList);
                    return generator.table();
                }
            }
            catch (NoEvalException nev) {
                return IOFunctions.printMessage(ast.topHead(), "range", F.list(ast), engine);
            }
            catch (ArithmeticException | ClassCastException runtimeException) {
                // empty catch block
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }

        private static class UnaryRangeFunction
        implements IVariablesFunction {
            @Override
            public IExpr evaluate(ISymbol[] variables, IExpr[] index) {
                return index[0];
            }
        }
    }

    private static final class PrependTo
    extends AbstractCoreFunctionEvaluator {
        private PrependTo() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2;
            PrependToFunction function;
            IExpr[] results;
            IExpr arg1 = ast.arg1();
            if (arg1.isASTSizeGE(S.Part, 3) && arg1.first().isSymbol()) {
                ISymbol sym = (ISymbol)arg1.first();
                return ListFunctions.assignPartTo(sym, (IAST)arg1, S.Prepend, ast, engine);
            }
            IExpr sym = Validate.checkIsVariable(ast, 1, engine);
            if (sym.isSymbol() && (results = ((ISymbol)sym).reassignSymbolValue(function = new PrependToFunction(arg2 = engine.evaluate(ast.arg2())), (ISymbol)S.PrependTo, engine)) != null) {
                return results[1];
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(32);
        }

        private static class PrependToFunction
        implements Function<IExpr, IExpr> {
            private final IExpr value;

            public PrependToFunction(IExpr value) {
                this.value = value;
            }

            @Override
            public IExpr apply(IExpr symbolValue) {
                if (symbolValue.isAssociation()) {
                    if (this.value.isRuleAST() || this.value.isListOfRules() || this.value.isAssociation()) {
                        IAssociation result = (IAssociation)symbolValue;
                        result.prependRules((IAST)this.value);
                        return result;
                    }
                    return IOFunctions.printMessage(S.PrependTo, "invdt", F.CEmptyList, EvalEngine.get());
                }
                if (!symbolValue.isASTOrAssociation()) {
                    return F.NIL;
                }
                return ((IAST)symbolValue).appendAtClone(1, this.value);
            }
        }
    }

    private static final class Prepend
    extends AbstractCoreFunctionEvaluator {
        private Prepend() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            IAST arg1AST = Validate.checkASTOrAssociationType(ast, arg1, 1, engine);
            if (!arg1AST.isPresent()) {
                return F.NIL;
            }
            IExpr arg2 = engine.evaluate(ast.arg2());
            if (arg1.isAssociation()) {
                if (arg2.isRuleAST() || arg2.isListOfRules() || arg2.isAssociation()) {
                    IAssociation result = ((IAssociation)arg1).copy();
                    result.prependRules((IAST)arg2);
                    return result;
                }
                return IOFunctions.printMessage(ast.topHead(), "invdt", F.CEmptyList, EvalEngine.get());
            }
            return arg1AST.appendAtClone(1, arg2);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2_1;
        }
    }

    private static final class Position
    extends AbstractFunctionEvaluator {
        private Position() {
        }

        private static IAST position(IAST ast, IExpr pattern, LevelSpec level, int maxResults, EvalEngine engine) {
            IPatternMatcher matcher = engine.evalPatternMatcher(pattern);
            PositionConverter positionConverter = new PositionConverter();
            IAST cloneList = F.CEmptyList;
            IASTAppendable resultList = F.ListAlloc(F.allocMax32(ast));
            int headOffset = 1;
            if (level.isIncludeHeads()) {
                headOffset = 0;
            }
            RecursionData recursionData = new RecursionData(resultList, maxResults, level, matcher, positionConverter, headOffset);
            recursionData.positionRecursive(ast, cloneList);
            return resultList;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() < 3) {
                return F.NIL;
            }
            int maxResults = Integer.MAX_VALUE;
            if (ast.size() >= 5 && (maxResults = engine.evaluate(ast.arg4()).toIntDefault()) < 0) {
                LOGGER.log(engine.getLogLevel(), "Position: non-negative integer for maximum number of objects expected.");
                return F.NIL;
            }
            IExpr arg1 = ast.arg1();
            if (arg1.isASTOrAssociation()) {
                IExpr arg2 = engine.evalPattern(ast.arg2());
                if (ast.isAST2()) {
                    LevelSpec level = new LevelSpec(0, Integer.MAX_VALUE);
                    return Position.position((IAST)arg1, arg2, level, Integer.MAX_VALUE, engine);
                }
                if (ast.size() >= 4) {
                    IExpr option = S.True;
                    OptionArgs options = OptionArgs.createOptionArgs(ast, engine);
                    if (options != null && (option = options.getOption(S.Heads)).isPresent()) {
                        if (option.isTrue()) {
                            LevelSpec level = new LevelSpec(0, Integer.MAX_VALUE, true);
                            return Position.position((IAST)arg1, arg2, level, Integer.MAX_VALUE, engine);
                        }
                        if (option.isFalse()) {
                            LevelSpec level = new LevelSpec(0, Integer.MAX_VALUE, false);
                            return Position.position((IAST)arg1, arg2, level, maxResults, engine);
                        }
                        return F.NIL;
                    }
                    IExpr arg3 = engine.evaluate(ast.arg3());
                    LevelSpecification level = new LevelSpecification(arg3, true);
                    return Position.position((IAST)arg1, arg2, level, maxResults, engine);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(64);
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Heads, (IExpr)S.True)));
        }

        private static class RecursionData {
            final IASTAppendable resultCollection;
            final int maxResults;
            final LevelSpec level;
            final Predicate<? super IExpr> matcher;
            final PositionConverter positionConverter;
            final int headOffset;

            private RecursionData(IASTAppendable resultCollection, int maxResults, LevelSpec level, Predicate<? super IExpr> matcher, PositionConverter positionConverter, int headOffset) {
                this.resultCollection = resultCollection;
                this.maxResults = maxResults;
                this.level = level;
                this.matcher = matcher;
                this.positionConverter = positionConverter;
                this.headOffset = headOffset;
            }

            private IAST positionRecursive(IAST ast, IAST prototypeList) {
                int minDepth = 0;
                this.level.incCurrentLevel();
                IASTAppendable clone = null;
                int size = ast.size();
                for (int i = this.headOffset; i < size; ++i) {
                    IExpr arg = ast.get(i);
                    if (arg.isASTOrAssociation()) {
                        clone = prototypeList.copyAppendable(1);
                        if (ast.isAssociation()) {
                            clone.append(((IAssociation)ast).getKey(i));
                        } else {
                            clone.append(this.positionConverter.toObject(i));
                        }
                        this.positionRecursive((IAST)arg, clone);
                        if (this.level.getCurrentDepth() < minDepth) {
                            minDepth = this.level.getCurrentDepth();
                        }
                    }
                    if (!this.matcher.test(arg) || !this.level.isInRange()) continue;
                    clone = prototypeList.copyAppendable(1);
                    if (ast.isAssociation() && i > 0) {
                        clone.append(((IAssociation)ast).getKey(i));
                    } else {
                        clone.append(this.positionConverter.toObject(i));
                    }
                    if (this.maxResults < this.resultCollection.size()) break;
                    this.resultCollection.append(clone);
                }
                this.level.setCurrentDepth(--minDepth);
                this.level.decCurrentLevel();
                return this.resultCollection;
            }
        }
    }

    private static final class Pick
    extends AbstractEvaluator {
        private Pick() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IPatternMatcher matcher;
            IExpr list = ast.arg1();
            IExpr selection = ast.arg2();
            IExpr pattern = S.True;
            if (ast.isAST3()) {
                pattern = ast.arg3();
            }
            if ((matcher = engine.evalPatternMatcher(pattern)).test(selection)) {
                return list;
            }
            if ((list.isASTOrAssociation() || list.isSparseArray()) && (selection.isASTOrAssociation() || selection.isSparseArray())) {
                IAST arg1AST = (IAST)list.normal(false);
                IAST arg2AST = (IAST)selection.normal(false);
                if (arg1AST.size() != arg2AST.size()) {
                    return IOFunctions.printMessage(ast.topHead(), "incomp", F.list(list, selection), engine);
                }
                try {
                    IASTAppendable result = arg1AST.copyHead();
                    IExpr temp = Pick.recursePick(arg1AST, arg2AST, matcher, result);
                    return temp;
                }
                catch (AbortException aex) {
                    return IOFunctions.printMessage(ast.topHead(), "incomp", F.list(list, selection), engine);
                }
            }
            return F.CEmptySequence;
        }

        private static IExpr recursePick(IAST list, IAST selection, IPatternMatcher matcher, IASTAppendable result) {
            for (int i = 1; i < list.size(); ++i) {
                IExpr arg1 = list.getRule(i);
                IExpr arg2 = selection.getRule(i);
                if (matcher.test(arg2)) {
                    result.append(arg1);
                    continue;
                }
                if (!arg1.isASTOrAssociation() || !arg2.isASTOrAssociation()) continue;
                if (arg1.size() != arg2.size()) {
                    throw AbortException.ABORTED;
                }
                IASTAppendable appendable = ((IAST)arg1).copyHead();
                IExpr temp = Pick.recursePick((IAST)arg1, (IAST)arg2, matcher, appendable);
                result.append(temp);
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }
    }

    private static final class PadRight
    extends AbstractFunctionEvaluator {
        private PadRight() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAtom()) {
                return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C1, ast), engine);
            }
            IAST list = (IAST)ast.arg1();
            if (ast.isAST1()) {
                if (list.isListOfLists()) {
                    int maxSize = -1;
                    for (int i2 = 1; i2 < list.size(); ++i2) {
                        IAST subList = (IAST)list.get(i2);
                        if (subList.size() <= maxSize) continue;
                        maxSize = subList.size();
                    }
                    if (maxSize > 0) {
                        IASTAppendable result = F.ListAlloc(list.size());
                        int mSize = maxSize;
                        return result.appendArgs(list.size(), i -> PadRight.padRightAtom(list.getAST(i), mSize - 1, F.C0));
                    }
                }
                return ast.arg1();
            }
            if (ast.argSize() > 1 && ast.arg2().isList()) {
                int[] levels = Validate.checkListOfInts(ast, ast.arg2(), true, false, engine);
                if (levels != null && levels.length > 0) {
                    int listLevel = list.depth() - 1;
                    if (levels.length > listLevel) {
                        return IOFunctions.printMessage(ast.topHead(), "levelpad", F.List(ast.arg2(), F.ZZ(levels.length), list, F.ZZ(listLevel)), engine);
                    }
                    IExpr defaultValue = F.C0;
                    if (ast.argSize() > 2) {
                        defaultValue = ast.arg3();
                    }
                    IASTAppendable result = list.copyHead(levels[0]);
                    if (PadRight.padRightASTList(list, list.head(), (IAST)ast.arg1(), defaultValue, levels, 1, levels[0], result)) {
                        return result;
                    }
                }
                return F.NIL;
            }
            int n = Validate.checkIntType(ast, 2);
            if (ast.size() > 3) {
                if (ast.arg3().isList()) {
                    IAST arg3 = (IAST)ast.arg3();
                    return PadRight.padRightAST(list, n, arg3);
                }
                return PadRight.padRightAtom(list, n, ast.arg3());
            }
            return PadRight.padRightAtom(list, n, F.C0);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        public static IExpr padRightAtom(IAST ast, int n, IExpr atom) {
            int length = n - ast.size() + 1;
            if (length > 0) {
                long intialCapacity = (long)length + (long)ast.argSize();
                if ((long)Config.MAX_AST_SIZE < intialCapacity) {
                    ASTElementLimitExceeded.throwIt(intialCapacity);
                }
                IASTAppendable result = ast.copyHead((int)intialCapacity);
                result.appendArgs(ast);
                return result.appendArgs(0, length, i -> atom);
            }
            if (n > 0 && n < ast.size()) {
                return ast.removeFromEnd(n + 1);
            }
            return ast;
        }

        public static IAST padRightAST(IAST ast, int n, IAST arg2) {
            int length = n - ast.size() + 1;
            if (length > 0) {
                long intialCapacity = (long)length + (long)ast.argSize();
                if ((long)Config.MAX_AST_SIZE < intialCapacity) {
                    ASTElementLimitExceeded.throwIt(intialCapacity);
                }
                IASTAppendable result = ast.copyHead((int)intialCapacity);
                result.appendArgs(ast);
                if (arg2.size() < 2) {
                    return ast;
                }
                int j = 1;
                for (int i = 0; i < length; ++i) {
                    if (j < arg2.size()) {
                        result.append(arg2.get(j++));
                        continue;
                    }
                    j = 1;
                    result.append(arg2.get(j++));
                }
                return result;
            }
            return ast;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean padRightASTList(IAST originalAST, IExpr mainHead, IAST list, IExpr x, int[] levels, int position, int length, IASTAppendable result) {
            if (position >= levels.length) {
                if (list.isPresent()) {
                    int astLength;
                    int n = astLength = list.argSize() > length ? length : list.argSize();
                    if (astLength > 0) {
                        void var9_11;
                        boolean bl = false;
                        while (var9_11 < astLength) {
                            result.append(list.get((int)(var9_11 + true)));
                            ++var9_11;
                        }
                    }
                    length -= astLength;
                }
                for (int i = 0; i < length; ++i) {
                    result.append(x);
                }
                return true;
            }
            int subLength = levels[position];
            ++position;
            for (int i = 0; i < length; ++i) {
                void var9_12;
                if (i < list.size() - 1) {
                    if (!list.isPresent() || !list.get(i + 1).isASTOrAssociation()) throw new ArgumentTypeException(IOFunctions.getMessage("padlevel", F.List(F.List(levels), F.ZZ(levels.length), originalAST, F.ZZ(position - 1)), EvalEngine.get()));
                    IAST iAST = (IAST)list.get(i + 1);
                } else {
                    IAssociation iAssociation = F.NIL;
                }
                IASTAppendable subResult = var9_12.isPresent() ? var9_12.copyHead(subLength) : F.ast(mainHead, subLength);
                if (!PadRight.padRightASTList(originalAST, mainHead, (IAST)var9_12, x, levels, position, subLength, subResult)) {
                    return false;
                }
                result.append(subResult);
            }
            return true;
        }
    }

    private static final class PadLeft
    extends AbstractFunctionEvaluator {
        private PadLeft() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!ast.arg1().isAST()) {
                return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C1, ast), engine);
            }
            IAST list = (IAST)ast.arg1();
            if (ast.isAST1()) {
                if (list.isListOfLists()) {
                    int maxSize = -1;
                    for (int i2 = 1; i2 < list.size(); ++i2) {
                        IAST subList = (IAST)list.get(i2);
                        if (subList.size() <= maxSize) continue;
                        maxSize = subList.size();
                    }
                    if (maxSize > 0) {
                        IASTAppendable result = F.ListAlloc(list.size());
                        int mSize = maxSize - 1;
                        return result.appendArgs(list.size(), i -> PadLeft.padLeftAtom(list.getAST(i), mSize, F.C0));
                    }
                }
                return ast.arg1();
            }
            if (ast.argSize() > 1 && ast.arg2().isList()) {
                int[] levels = Validate.checkListOfInts(ast, ast.arg2(), true, false, engine);
                if (levels != null && levels.length > 0) {
                    int listLevel = list.depth() - 1;
                    if (levels.length > listLevel) {
                        return IOFunctions.printMessage(ast.topHead(), "levelpad", F.List(ast.arg2(), F.ZZ(levels.length), list, F.ZZ(listLevel)), engine);
                    }
                    IExpr defaultValue = F.C0;
                    if (ast.argSize() > 2) {
                        defaultValue = ast.arg3();
                    }
                    IASTAppendable result = list.copyHead(levels[0]);
                    if (PadLeft.padLeftASTList(list, list.head(), (IAST)ast.arg1(), defaultValue, levels, 1, levels[0], result)) {
                        return result;
                    }
                }
                return F.NIL;
            }
            int n = Validate.checkIntType(ast, 2);
            if (ast.size() > 3) {
                if (ast.arg3().isList()) {
                    IAST arg3 = (IAST)ast.arg3();
                    return PadLeft.padLeftAST(list, n, arg3);
                }
                return PadLeft.padLeftAtom(list, n, ast.arg3());
            }
            return PadLeft.padLeftAtom(list, n, F.C0);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        public static IExpr padLeftAtom(IAST ast, int n, IExpr atom) {
            int length = n - ast.size() + 1;
            if (length > 0) {
                long intialCapacity = (long)length + (long)ast.argSize();
                if ((long)Config.MAX_AST_SIZE < intialCapacity) {
                    ASTElementLimitExceeded.throwIt(intialCapacity);
                }
                IASTAppendable result = ast.copyHead((int)intialCapacity);
                result.appendArgs(0, length, i -> atom);
                result.appendArgs(ast);
                return result;
            }
            if (n > 0 && n < ast.size()) {
                return ast.removeFromStart(ast.size() - n);
            }
            return ast;
        }

        public static IAST padLeftAST(IAST ast, int n, IAST arg2) {
            int length = n - ast.size() + 1;
            if (length > 0) {
                long intialCapacity = (long)length + (long)ast.argSize();
                if ((long)Config.MAX_AST_SIZE < intialCapacity) {
                    ASTElementLimitExceeded.throwIt(intialCapacity);
                }
                IASTAppendable result = ast.copyHead((int)intialCapacity);
                if (arg2.size() < 2) {
                    return ast;
                }
                int j = 1;
                if (arg2.argSize() < n) {
                    int temp = n % arg2.argSize();
                    j = arg2.size() - temp;
                }
                for (int i = 0; i < length; ++i) {
                    if (j < arg2.size()) {
                        result.append(arg2.get(j++));
                        continue;
                    }
                    j = 1;
                    result.append(arg2.get(j++));
                }
                result.appendArgs(ast);
                return result;
            }
            return ast;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean padLeftASTList(IAST originalAST, IExpr mainHead, IAST list, IExpr x, int[] levels, int position, int length, IASTAppendable result) {
            if (position >= levels.length) {
                void var9_11;
                int padSize = length;
                if (list.isPresent()) {
                    padSize = length > list.argSize() ? length - list.argSize() : 0;
                }
                boolean bl = false;
                while (var9_11 < padSize) {
                    result.append(x);
                    ++var9_11;
                }
                boolean bl2 = true;
                if (list.isPresent() && list.argSize() > length) {
                    int n = list.size() - length;
                }
                for (int i = padSize; i < length; ++i) {
                    void var9_14;
                    result.append(list.get((int)(++var9_14)));
                }
                return true;
            }
            int subLength = levels[position];
            ++position;
            int padSize = length;
            if (list.isPresent() && length > list.argSize()) {
                padSize = length - list.size();
            }
            int j = 1;
            for (int i = 0; i < length; ++i) {
                void var9_15;
                if (i > padSize) {
                    if (!list.isPresent() || !list.get(j).isASTOrAssociation()) throw new ArgumentTypeException(IOFunctions.getMessage("padlevel", F.List(F.List(levels), F.ZZ(levels.length), originalAST, F.ZZ(position - 1)), EvalEngine.get()));
                    IAST iAST = (IAST)list.get(j++);
                } else {
                    IAssociation iAssociation = F.NIL;
                }
                IASTAppendable subResult = var9_15.isPresent() ? var9_15.copyHead(subLength) : F.ast(mainHead, subLength);
                if (!PadLeft.padLeftASTList(originalAST, mainHead, (IAST)var9_15, x, levels, position, subLength, subResult)) {
                    return false;
                }
                result.append(subResult);
            }
            return true;
        }
    }

    private static class NearestTo
    extends AbstractFunctionEvaluator {
        IBuiltInSymbol operatorHead = S.NearestTo;
        IBuiltInSymbol comparatorHead = S.Nearest;

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                IExpr head = ast.head();
                if (head.isAST(this.operatorHead, 2)) {
                    return F.binaryAST2((IExpr)this.comparatorHead, ast.arg1(), head.first());
                }
                if (head.isAST(this.operatorHead, 3)) {
                    return F.ternaryAST3(this.comparatorHead, ast.arg1(), head.first(), head.second());
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2_0;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Nearest
    extends AbstractFunctionEvaluator {
        private Nearest() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST listArg1;
            if (ast.arg1().isASTOrAssociation() && ast.isAST2() && ast.arg2().isNumber() && (listArg1 = (IAST)ast.arg1()).argSize() > 0) {
                INumber arg2 = (INumber)ast.arg2();
                IAST distanceFunction = F.Function(F.Norm(F.Subtract(F.Slot1, F.Slot2)));
                return Nearest.numericalNearest(listArg1, arg2, distanceFunction, engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        private static IAST numericalNearest(IAST inputList, INumber x, IExpr distanceFunction, EvalEngine engine) {
            try {
                IASTAppendable nearest = null;
                IASTAppendable distance = F.NIL;
                for (int i = 1; i < inputList.size(); ++i) {
                    IASTAppendable temp = F.ast(distanceFunction);
                    temp.append(x);
                    temp.append(inputList.get(i));
                    if (nearest == null) {
                        nearest = F.ListAlloc(8);
                        nearest.append(inputList.get(i));
                        distance = temp;
                        continue;
                    }
                    IExpr comparisonResult = engine.evaluate(F.Greater((IExpr)distance, temp));
                    if (comparisonResult.isTrue()) {
                        nearest = F.ListAlloc(8);
                        nearest.append(inputList.get(i));
                        distance = temp;
                        continue;
                    }
                    if (comparisonResult.isFalse()) {
                        if (!S.Equal.ofQ(engine, distance, temp)) continue;
                        nearest.append(inputList.get(i));
                        continue;
                    }
                    return F.NIL;
                }
                return nearest;
            }
            catch (RuntimeException runtimeException) {
                return F.NIL;
            }
        }
    }

    private static final class Most
    extends AbstractFunctionEvaluator {
        private Most() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isASTOrAssociation()) {
                if (arg1.argSize() > 0) {
                    return ((IAST)arg1).most();
                }
                return IOFunctions.printMessage(ast.topHead(), "nomost", F.list(arg1), engine);
            }
            return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C1, ast), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class LevelQ
    extends AbstractCoreFunctionEvaluator {
        private LevelQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            try {
                new VisitorLevelSpecification(null, arg1, false, engine);
                return S.True;
            }
            catch (RuntimeException runtimeException) {
                return S.False;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class Level
    extends AbstractFunctionOptionEvaluator {
        private Level() {
        }

        @Override
        public IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            boolean heads = option[0].isTrue();
            if (ast.arg1().isASTOrAssociation()) {
                IAST arg1 = (IAST)ast.arg1();
                int allocSize = F.allocMin32(arg1.argSize() * 8);
                IExpr head = argSize == 3 ? ast.arg3() : S.List;
                IASTAppendable resultList = F.ast(head, allocSize);
                VisitorLevelSpecification level = new VisitorLevelSpecification(x -> {
                    resultList.append((IExpr)x);
                    return F.NIL;
                }, ast.arg2(), heads, engine);
                arg1.accept(level);
                return resultList;
            }
            return F.CEmptyList;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, S.Heads, S.False);
        }
    }

    private static final class LengthWhile
    extends AbstractFunctionEvaluator {
        private LengthWhile() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg1.isAST()) {
                IAST list = (IAST)arg1;
                int[] n = new int[]{0};
                list.forAll(x -> {
                    if (engine.evalTrue(arg2, (IExpr)x)) {
                        n[0] = n[0] + 1;
                        return true;
                    }
                    return false;
                }, 1);
                return F.ZZ(n[0]);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class Length
    extends AbstractCoreFunctionEvaluator {
        private Length() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            return arg1.isASTOrAssociation() ? F.ZZ(arg1.argSize()) : F.C0;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class Last
    extends AbstractFunctionEvaluator {
        private Last() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr last = ast.arg1().last();
            if (last.isPresent()) {
                return last;
            }
            if (ast.isAST2()) {
                return ast.arg2();
            }
            if (ast.arg1().size() == 1) {
                return IOFunctions.printMessage(ast.topHead(), "nolast", F.list(ast.arg1()), engine);
            }
            return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C1, ast), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(64);
        }
    }

    private static final class Join
    extends AbstractFunctionEvaluator {
        private Join() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int index = ast.indexOf(x -> x.isAtom() && !x.isAssociation() && !x.isSparseArray());
            if (index > 0) {
                return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.ZZ(index), ast), engine);
            }
            if (ast.size() == 2) {
                return ast.arg1();
            }
            int astSize = ast.size();
            int size = 0;
            IExpr head = null;
            boolean isAssociation = false;
            boolean isSparseArray = false;
            boolean useNormal = false;
            for (int i = 1; i < astSize; ++i) {
                IExpr arg = ast.get(i);
                if (arg.isSparseArray()) {
                    isSparseArray = true;
                    if (head == S.List || useNormal) {
                        useNormal = true;
                        continue;
                    }
                    if (i <= 1 || isSparseArray) continue;
                    return IOFunctions.printMessage(ast.topHead(), "incpt", F.list(ast), engine);
                }
                useNormal = true;
                IAST temp = (IAST)arg;
                size += temp.argSize();
                if (head == null) {
                    head = temp.head();
                    isAssociation = temp.isAssociation();
                    continue;
                }
                if (!head.equals(temp.head())) {
                    return IOFunctions.printMessage(ast.topHead(), "incpt", F.list(ast), engine);
                }
                if (temp.isAssociation() == isAssociation) continue;
                return IOFunctions.printMessage(ast.topHead(), "incpt", F.list(ast), engine);
            }
            if (isAssociation) {
                if (isSparseArray) {
                    return IOFunctions.printMessage(ast.topHead(), "incpt", F.list(ast), engine);
                }
                IAssociation result = F.assoc(F.CEmptyList);
                for (int i = 1; i < ast.size(); ++i) {
                    IExpr arg = ast.get(i);
                    result.appendRules((IAST)arg);
                }
                return result;
            }
            if (isSparseArray && !useNormal) {
                ISparseArray arg;
                int i;
                ISparseArray result = (ISparseArray)ast.arg1();
                int[] dim1 = result.getDimension();
                IExpr defaultValue1 = result.getDefaultValue();
                if (dim1.length != 2) {
                    return F.NIL;
                }
                for (i = 2; i < ast.size(); ++i) {
                    arg = (ISparseArray)ast.get(i);
                    int[] dim = arg.getDimension();
                    if (dim.length != dim1.length) {
                        return F.NIL;
                    }
                    if (dim[dim.length - 1] != dim1[dim.length - 1]) {
                        return F.NIL;
                    }
                    if (defaultValue1.equals(arg.getDefaultValue())) continue;
                    return F.NIL;
                }
                for (i = 2; i < ast.size(); ++i) {
                    arg = (ISparseArray)ast.get(i);
                    result = result.join(arg);
                }
                return result;
            }
            IASTAppendable result = F.ast(head, size);
            for (int i = 1; i < ast.size(); ++i) {
                IExpr arg = ast.get(i);
                if (arg.isSparseArray() && useNormal) {
                    arg = arg.normal(false);
                }
                result.appendArgs((IAST)arg);
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(9);
        }
    }

    private static class Insert
    extends AbstractCoreFunctionEvaluator {
        private Insert() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if ((ast.isAST1() || ast.isAST2()) && !(ast = F.operatorFormAppend2(ast)).isPresent()) {
                return F.NIL;
            }
            IExpr arg1 = engine.evaluate(ast.arg1());
            IAST arg1AST = Validate.checkASTOrAssociationType(ast, arg1, 1, engine);
            if (!arg1AST.isPresent()) {
                return F.NIL;
            }
            IExpr arg2 = engine.evaluate(ast.arg2());
            IExpr arg3 = engine.evaluate(ast.arg3());
            if (arg3.isInteger()) {
                try {
                    int i = Validate.checkIntType(S.Insert, arg3, Integer.MIN_VALUE, engine);
                    if (i == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    if (i < 0) {
                        i = 1 + arg1AST.size() + i;
                    }
                    if (i > 0 && i <= arg1AST.size()) {
                        return arg1AST.appendAtClone(i, arg2);
                    }
                    return IOFunctions.printMessage(ast.topHead(), "ins", F.list(arg3, arg1), engine);
                }
                catch (ArgumentTypeException ate) {
                    IOFunctions.printMessage(ast.topHead(), ate, engine);
                    return arg1;
                }
                catch (IndexOutOfBoundsException e) {
                    return IOFunctions.printMessage(ast.topHead(), "ins", F.list(arg3, arg1), engine);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3_0;
        }
    }

    private static final class Intersection
    extends AbstractFunctionEvaluator {
        private Intersection() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() > 1) {
                if (ast.isAST1()) {
                    IAST arg1;
                    Set<IExpr> set;
                    if (ast.arg1().isASTOrAssociation() && (set = (arg1 = (IAST)ast.arg1()).asSet()) != null) {
                        IASTMutable result = F.ListAlloc(set);
                        EvalAttributes.sort(result, Comparators.CANONICAL_COMPARATOR);
                        return result;
                    }
                    return F.NIL;
                }
                if (ast.arg1().isASTOrAssociation()) {
                    int i;
                    IAST result = (IAST)ast.arg1();
                    for (i = 2; i < ast.size(); ++i) {
                        if (ast.get(i).isASTOrAssociation()) continue;
                        return F.NIL;
                    }
                    for (i = 2; i < ast.size(); ++i) {
                        IAST expr = (IAST)ast.get(i);
                        result = Intersection.intersection(result, expr);
                    }
                    if (result.size() > 2) {
                        EvalAttributes.sort((IASTMutable)result, Comparators.CANONICAL_COMPARATOR);
                    }
                    return result;
                }
            }
            return F.NIL;
        }

        public static IAST intersection(IAST ast1, IAST ast2) {
            int i;
            if (ast1.isEmpty() || ast2.isEmpty()) {
                return F.CEmptyList;
            }
            HashSet<IExpr> set1 = new HashSet<IExpr>(ast1.size() + ast2.size() / 10);
            HashSet<IExpr> set2 = new HashSet<IExpr>(ast1.size() + ast2.size() / 10);
            TreeSet<IExpr> resultSet = new TreeSet<IExpr>();
            int size = ast1.size();
            for (i = 1; i < size; ++i) {
                set1.add(ast1.get(i));
            }
            size = ast2.size();
            for (i = 1; i < size; ++i) {
                set2.add(ast2.get(i));
            }
            for (IExpr expr : set1) {
                if (!set2.contains(expr)) continue;
                resultSet.add(expr);
            }
            return F.ListAlloc(resultSet);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(9);
        }
    }

    private static final class GroupBy
    extends AbstractEvaluator {
        private GroupBy() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() >= 3) {
                List<String> listOfStrings;
                IAST list2;
                IExpr arg1 = ast.arg1();
                IExpr arg2 = ast.arg2();
                IAST iAST = list2 = arg2.isList() ? (IAST)ast.arg2() : F.list(arg2);
                if (list2.isEmptyList()) {
                    return arg1;
                }
                if (arg1.isListOrAssociation()) {
                    return this.recurseGroupBy((IAST)arg1, list2, 1, ast, engine);
                }
                if (arg1.isDataset() && (listOfStrings = Convert.toStringList(arg2)) != null) {
                    return ((IASTDataset)arg1).groupBy(listOfStrings);
                }
            }
            return F.NIL;
        }

        private IExpr recurseGroupBy(IAST list, IAST listOfHeads, int positionOfHeads, IAST ast, EvalEngine engine) {
            IExpr arg;
            IExpr first = arg = listOfHeads.get(positionOfHeads);
            IExpr last = F.NIL;
            if (arg.isRuleAST()) {
                first = arg.first();
                last = arg.second();
            }
            TreeMap<IExpr, IASTAppendable> map = new TreeMap<IExpr, IASTAppendable>();
            for (int i = 1; i < list.size(); ++i) {
                arg = list.get(i);
                IExpr rule = list.getRule(i);
                IExpr group = engine.evaluate(F.unaryAST1(first, arg));
                IASTAppendable rhs = (IASTAppendable)map.get(group);
                if (rhs == null) {
                    rhs = list.copyHead(F.allocMin32(list));
                    map.put(group, rhs);
                }
                if (last.isPresent()) {
                    IExpr temp = engine.evaluate(F.unaryAST1(last, arg));
                    if (rhs.isAssociation() || rhs.head().equals(S.Association)) {
                        rhs.appendRule(F.Rule(rule.first(), temp));
                        continue;
                    }
                    rhs.append(temp);
                    continue;
                }
                rhs.appendRule(rule);
            }
            IAssociation result = F.assoc();
            IAssociation reduce = ast.isAST3() && ++positionOfHeads >= listOfHeads.size() ? ast.arg3() : F.NIL;
            for (Map.Entry entry : map.entrySet()) {
                IExpr temp = reduce.isPresent() ? engine.evaluate(F.unaryAST1(reduce, (IExpr)entry.getValue())) : engine.evaluate((IExpr)entry.getValue());
                if (positionOfHeads < listOfHeads.size()) {
                    if (temp.isListOrAssociation() && (temp = this.recurseGroupBy((IAST)temp, listOfHeads, positionOfHeads, ast, engine)).isPresent()) {
                        result.appendRule(F.Rule((IExpr)entry.getKey(), temp));
                        continue;
                    }
                    return F.NIL;
                }
                result.appendRule(F.Rule((IExpr)entry.getKey(), temp));
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class GatherBy
    extends AbstractEvaluator {
        private GatherBy() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!ast.arg1().isList()) {
                return IOFunctions.printMessage(ast.topHead(), "list", F.CEmptyList, engine);
            }
            IAST list1 = (IAST)ast.arg1();
            if (ast.isAST1()) {
                return F.GatherBy(list1, S.Identity);
            }
            IExpr arg2 = ast.arg2();
            if (arg2.isList()) {
                IAST list2 = (IAST)arg2;
                int size2 = list2.argSize();
                switch (size2) {
                    case 0: {
                        return F.GatherBy(ast.arg1(), S.Identity);
                    }
                    case 1: {
                        return F.GatherBy(ast.arg1(), list2.arg1());
                    }
                    case 2: {
                        return F.Map(F.Function(F.GatherBy(F.Slot1, list2.arg2())), F.GatherBy(list1, list2.arg1()));
                    }
                }
                IASTAppendable r = list2.copyUntil(size2);
                IExpr f = list2.last();
                return F.Map(F.Function(F.GatherBy(F.Slot1, f)), F.GatherBy(list1, r), F.list(F.ZZ(r.argSize())));
            }
            TreeMap<IExpr, IASTAppendable> map = new TreeMap<IExpr, IASTAppendable>();
            IASTAppendable result = F.ListAlloc(F.allocMin8(list1.size()));
            for (int i = 1; i < list1.size(); ++i) {
                IExpr list1Element = list1.get(i);
                IExpr temp = engine.evaluate(F.unaryAST1(arg2, list1Element));
                IASTAppendable subResult = (IASTAppendable)map.get(temp);
                if (subResult == null) {
                    IASTAppendable subList = F.ListAlloc(F.allocMin8(list1.size()));
                    subList.append(list1Element);
                    map.put(temp, subList);
                    result.append(subList);
                    continue;
                }
                subResult.append(list1Element);
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Gather
    extends AbstractEvaluator {
        private Gather() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = ast.size();
            if (ast.arg1().isAST()) {
                TreeMap<Object, IASTAppendable> map;
                IAST arg1AST = (IAST)ast.arg1();
                if (size > 2) {
                    IExpr arg2 = ast.arg2();
                    map = new TreeMap(Comparators.binaryPredicateComparator(arg2));
                } else {
                    map = new TreeMap();
                }
                IASTAppendable result = F.ListAlloc(arg1AST.size());
                for (int i = 1; i < arg1AST.size(); ++i) {
                    IExpr arg = arg1AST.get(i);
                    IASTAppendable subResult = (IASTAppendable)map.get(arg);
                    if (subResult == null) {
                        IASTAppendable subList = F.ListAlloc();
                        subList.append(arg);
                        map.put(arg, subList);
                        result.append(subList);
                        continue;
                    }
                    subResult.append(arg);
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class FoldList
    extends AbstractFunctionEvaluator {
        private FoldList() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IExpr arg2 = ast.arg2();
                if (ast.size() == 3) {
                    if (arg2.size() <= 1 && !arg2.isAST()) {
                        return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C2, ast), engine);
                    }
                    return FoldList.evaluateNestList3(ast, engine);
                }
                if (ast.size() == 4) {
                    return FoldList.evaluateNestList4(ast, engine);
                }
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
            return F.NIL;
        }

        private static IAST evaluateNestList3(IAST ast, EvalEngine engine) {
            IExpr temp = ast.arg2();
            if (temp.isAST()) {
                IAST list = (IAST)temp;
                IExpr arg1 = ast.arg1();
                if (list.isEmpty() || list.size() == 2) {
                    return list;
                }
                IASTAppendable resultList = F.ast(list.head(), list.size());
                IExpr arg2 = list.arg1();
                list = list.rest();
                return ListFunctions.foldLeft(arg2, list, 1, list.size(), (x, y) -> F.binaryAST2(arg1, x, y), resultList);
            }
            return F.NIL;
        }

        private static IAST evaluateNestList4(IAST ast, EvalEngine engine) {
            IExpr temp = ast.arg3();
            if (temp.isAST()) {
                IAST list = (IAST)temp;
                IExpr arg1 = ast.arg1();
                IExpr arg2 = ast.arg2();
                if (list.isEmpty()) {
                    return F.unaryAST1(list.head(), arg2);
                }
                IASTAppendable resultList = F.ast(list.head(), list.size());
                return ListFunctions.foldLeft(arg2, list, 1, list.size(), (x, y) -> F.binaryAST2(arg1, x, y), resultList);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Fold
    extends AbstractFunctionEvaluator {
        private Fold() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IExpr arg1 = ast.arg1();
                IExpr arg2 = ast.arg2();
                if (ast.isAST2()) {
                    if (arg2.size() <= 1) {
                        if (!arg2.isAST()) {
                            return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C2, ast), engine);
                        }
                        return F.NIL;
                    }
                    return F.Fold(ast.arg1(), F.First(arg2), F.Rest(arg2));
                }
                IExpr temp = engine.evaluate(ast.arg3());
                if (temp.isAST()) {
                    IAST list = (IAST)temp;
                    return list.foldLeft((x, y) -> F.binaryAST2(arg1, x, y), arg2, 1);
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class FirstPosition
    extends AbstractFunctionOptionEvaluator {
        private FirstPosition() {
        }

        private static void position(IAST ast, IExpr pattern, LevelSpec level, EvalEngine engine) {
            IPatternMatcher matcher = engine.evalPatternMatcher(pattern);
            PositionConverter positionConverter = new PositionConverter();
            IAST cloneList = F.CEmptyList;
            int headOffset = 1;
            if (level.isIncludeHeads()) {
                headOffset = 0;
            }
            RecursionData recursionData = new RecursionData(level, matcher, positionConverter, headOffset);
            recursionData.positionRecursive(ast, cloneList);
        }

        @Override
        public IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            boolean heads = option[0].isTrue();
            if (argSize < 2) {
                return F.NIL;
            }
            IExpr arg1 = ast.arg1();
            IExpr defaultValue = F.CMissingNotFound;
            try {
                if (arg1.isASTOrAssociation()) {
                    IExpr arg2 = engine.evalPattern(ast.arg2());
                    if (argSize == 2) {
                        LevelSpec level = new LevelSpec(0, Integer.MAX_VALUE, heads);
                        FirstPosition.position((IAST)arg1, arg2, level, engine);
                        return defaultValue;
                    }
                    defaultValue = ast.arg3();
                    if (argSize == 3) {
                        LevelSpec level = new LevelSpec(0, Integer.MAX_VALUE, heads);
                        FirstPosition.position((IAST)arg1, arg2, level, engine);
                        return defaultValue;
                    }
                    IExpr arg4 = engine.evaluate(ast.arg4());
                    LevelSpecification level = new LevelSpecification(arg4, heads);
                    FirstPosition.position((IAST)arg1, arg2, level, engine);
                    return defaultValue;
                }
            }
            catch (ResultException frex) {
                return frex.getValue();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_4_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(64);
            this.setOptions(newSymbol, S.Heads, S.True);
        }

        private static class RecursionData {
            final LevelSpec level;
            final Predicate<? super IExpr> matcher;
            final PositionConverter positionConverter;
            int headOffset;

            private RecursionData(LevelSpec level, Predicate<? super IExpr> matcher, PositionConverter positionConverter, int headOffset) {
                this.level = level;
                this.matcher = matcher;
                this.positionConverter = positionConverter;
                this.headOffset = headOffset;
            }

            private void positionRecursive(IAST ast, IAST prototypeList) {
                int minDepth = 0;
                this.level.incCurrentLevel();
                IASTAppendable clone = null;
                int size = ast.size();
                for (int i = this.headOffset; i < size; ++i) {
                    if (ast.get(i).isASTOrAssociation()) {
                        clone = prototypeList.copyAppendable(1);
                        if (ast.isAssociation()) {
                            clone.append(((IAssociation)ast).getKey(i));
                        } else {
                            clone.append(this.positionConverter.toObject(i));
                        }
                        this.positionRecursive((IAST)ast.get(i), clone);
                        if (this.level.getCurrentDepth() < minDepth) {
                            minDepth = this.level.getCurrentDepth();
                        }
                    }
                    if (!this.matcher.test(ast.get(i)) || !this.level.isInRange()) continue;
                    clone = prototypeList.copyAppendable(1);
                    if (ast.isAssociation() && i > 0) {
                        clone.append(((IAssociation)ast).getKey(i));
                    } else {
                        clone.append(this.positionConverter.toObject(i));
                    }
                    throw new ResultException(clone);
                }
                this.level.setCurrentDepth(--minDepth);
                this.level.decCurrentLevel();
            }
        }
    }

    private static final class FirstCase
    extends AbstractFunctionOptionEvaluator {
        private FirstCase() {
        }

        @Override
        public IExpr evaluate(IAST ast, int argSize, IExpr[] option, EvalEngine engine) {
            boolean heads = option[0].isTrue();
            try {
                IExpr defaultValue = F.CMissingNotFound;
                if (argSize >= 2 && argSize <= 4) {
                    IExpr arg1 = ast.arg1();
                    if (arg1.isASTOrAssociation()) {
                        IExpr arg2 = engine.evalPattern(ast.arg2());
                        if (argSize == 3 || argSize == 4) {
                            defaultValue = ast.arg3();
                            IExpr levelValue = F.CListC1;
                            if (argSize == 4) {
                                levelValue = engine.evaluate(ast.arg4());
                            }
                            if (arg2.isRuleAST()) {
                                Function<IExpr, IExpr> function = Functors.rules((IAST)arg2, engine);
                                FirstCaseRulesFunctor fcrf = new FirstCaseRulesFunctor(function);
                                VisitorLevelSpecification level = new VisitorLevelSpecification((Function<IExpr, IExpr>)fcrf, levelValue, heads, engine);
                                arg1.accept(level);
                            } else {
                                IPatternMatcher matcher = engine.evalPatternMatcher(arg2);
                                matcher.throwExceptionArgIfMatched(true);
                                FirstCasePatternMatcherFunctor cpmf = new FirstCasePatternMatcherFunctor(matcher);
                                VisitorLevelSpecification level = new VisitorLevelSpecification((Function<IExpr, IExpr>)cpmf, levelValue, heads, engine);
                                arg1.accept(level);
                            }
                            return defaultValue;
                        }
                        return FirstCase.firstCase((IAST)arg1, arg2, defaultValue, heads, engine);
                    }
                    return defaultValue;
                }
            }
            catch (ResultException frex) {
                return frex.getValue();
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("FirstCase.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4_1;
        }

        private static IExpr firstCase(IAST list, IExpr pattern, IExpr defaultValue, boolean heads, EvalEngine engine) {
            if (pattern.isRuleAST()) {
                IExpr[] result;
                Function<IExpr, IExpr> function = Functors.rules((IAST)pattern, engine);
                int index = list.indexOf(arg_0 -> FirstCase.lambda$firstCase$0(function, result = new IExpr[]{F.NIL}, arg_0));
                if (index > 0 && result[0].isPresent()) {
                    return result[0];
                }
                return defaultValue;
            }
            IPatternMatcher matcher = engine.evalPatternMatcher(pattern);
            int index = list.indexOf(matcher, heads ? 0 : 1);
            if (index >= 0) {
                return list.get(index);
            }
            return defaultValue;
        }

        private static boolean ruleEval(IExpr x, Function<IExpr, IExpr> function, IExpr[] result) {
            result[0] = function.apply(x);
            return result[0].isPresent();
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(64);
            this.setOptions(newSymbol, S.Heads, S.False);
        }

        private static /* synthetic */ boolean lambda$firstCase$0(Function function, IExpr[] result, IExpr x) {
            return FirstCase.ruleEval(x, function, result);
        }

        private static class FirstCaseRulesFunctor
        implements Function<IExpr, IExpr> {
            protected final Function<IExpr, IExpr> function;

            public FirstCaseRulesFunctor(Function<IExpr, IExpr> function) {
                this.function = function;
            }

            @Override
            public IExpr apply(IExpr arg) throws AbortException {
                IExpr temp = this.function.apply(arg);
                if (temp.isPresent()) {
                    throw new ResultException(temp);
                }
                return F.NIL;
            }
        }

        private static class FirstCasePatternMatcherFunctor
        implements Function<IExpr, IExpr> {
            protected final IPatternMatcher matcher;

            public FirstCasePatternMatcherFunctor(IPatternMatcher matcher) {
                this.matcher = matcher;
            }

            @Override
            public IExpr apply(IExpr arg) throws AbortException {
                if (this.matcher.test(arg)) {
                    throw new ResultException(arg);
                }
                return F.NIL;
            }
        }
    }

    private static final class First
    extends AbstractFunctionEvaluator {
        private First() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr first = ast.arg1().first();
            if (first.isPresent()) {
                return first;
            }
            if (ast.isAST2()) {
                return ast.arg2();
            }
            if (ast.arg1().size() == 1) {
                return IOFunctions.printMessage(ast.topHead(), "nofirst", F.list(ast.arg1()), engine);
            }
            return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C1, ast), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(64);
        }
    }

    private static final class Extract
    extends AbstractFunctionEvaluator {
        private Extract() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isASTOrAssociation()) {
                IAST list = (IAST)ast.arg1();
                IExpr arg3 = F.NIL;
                if (ast.isAST3()) {
                    arg3 = ast.arg3();
                }
                if (ast.arg2().isInteger()) {
                    int indx = ast.arg2().toIntDefault();
                    if (indx == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    if (indx < 0 && (indx = list.size() + indx) <= 0) {
                        return F.NIL;
                    }
                    if (indx < list.size()) {
                        if (arg3.isPresent()) {
                            return F.unaryAST1(arg3, list.get(indx));
                        }
                        return list.get(indx);
                    }
                } else if (ast.arg2().isList()) {
                    IAST arg2 = (IAST)ast.arg2();
                    if (arg2.isListOfLists()) {
                        int arg2Size = arg2.size();
                        IASTAppendable result = F.ListAlloc(arg2Size);
                        for (int i = 1; i < arg2Size; ++i) {
                            IAST positions = arg2.getAST(i);
                            if (!this.checkPositions(ast, positions, engine)) {
                                return F.NIL;
                            }
                            IExpr temp = Extract.extract(list, positions, engine);
                            if (!temp.isPresent()) {
                                return F.NIL;
                            }
                            if (arg3.isPresent()) {
                                result.append(F.unaryAST1(arg3, temp));
                                continue;
                            }
                            result.append(temp);
                        }
                        return result;
                    }
                    if (arg2.isEmptyList()) {
                        return F.CEmptyList;
                    }
                    if (!this.checkPositions(ast, arg2, engine)) {
                        return F.NIL;
                    }
                    return Extract.extract(list, arg2, engine);
                }
            }
            return F.NIL;
        }

        private boolean checkPositions(IAST ast, IAST positions, EvalEngine engine) {
            for (int j = 1; j < positions.size(); ++j) {
                int intValue;
                IExpr arg = positions.get(j);
                if (arg.isAST(S.Key) || (intValue = arg.toIntDefault()) != Integer.MIN_VALUE) continue;
                IOFunctions.printMessage(ast.topHead(), "psl1", F.list(ast.arg2(), ast), engine);
                return false;
            }
            return true;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3_1;
        }

        private static IExpr extract(IAST list, IAST position, EvalEngine engine) {
            IASTAppendable part = F.Part(position.argSize(), list);
            part.appendAll(position, 1, position.size());
            return engine.evaluate(part);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(16384);
        }

        private static IExpr extract(IAST list, IAST positions, int headOffset) {
            int p = 0;
            IAST temp = list;
            if (!temp.isPresent()) {
                return F.NIL;
            }
            int posSize = positions.argSize();
            IExpr expr = list;
            for (int i = headOffset; i <= posSize; ++i) {
                p = positions.get(i).toIntDefault();
                if (p >= 0) {
                    if (temp.size() <= p) {
                        return F.NIL;
                    }
                    expr = temp.get(p);
                    if (expr.isASTOrAssociation()) {
                        temp = (IAST)expr;
                        continue;
                    }
                    if (i >= positions.size()) continue;
                    temp = F.NIL;
                    continue;
                }
                if (!positions.get(i).isAST(S.Key, 2)) continue;
                expr = temp.get(p);
                if (expr.isASTOrAssociation()) {
                    temp = (IAST)expr;
                    continue;
                }
                if (i >= positions.size()) continue;
                temp = F.NIL;
            }
            return expr;
        }
    }

    private static final class Entropy
    extends AbstractEvaluator {
        private Entropy() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST list = F.NIL;
            if (ast.isAST1()) {
                list = Validate.checkListType(ast, 1, engine);
            } else if (ast.isAST2()) {
                list = Validate.checkListType(ast, 2, engine);
            }
            if (list.isPresent()) {
                if (ast.isAST1()) {
                    return Entropy.entropy(list, F.Log(F.Slot1), 1);
                }
                IExpr shannonBase = ast.arg1();
                return Entropy.entropy(list, F.Log(shannonBase, F.Slot1), 2);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private static IExpr entropy(IAST list, IAST logAST, int logASTIndex) {
            LinkedHashMap<IExpr, Integer> map = new LinkedHashMap<IExpr, Integer>();
            for (int i = 1; i < list.size(); ++i) {
                Integer value = (Integer)map.get(list.get(i));
                if (value == null) {
                    map.put(list.get(i), 1);
                    continue;
                }
                map.put(list.get(i), value + 1);
            }
            IASTAppendable result = F.PlusAlloc(map.size());
            int n = list.size() - 1;
            for (Map.Entry entry : map.entrySet()) {
                int count = (Integer)entry.getValue();
                IRational p = F.fraction(count, n);
                IASTMutable times = F.Times((IExpr)p, (IExpr)logAST.setAtCopy(logASTIndex, p));
                result.append(times);
            }
            return result.negate();
        }
    }

    private static final class Drop
    extends AbstractFunctionEvaluator {
        private Drop() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            try {
                if (arg1.isASTOrAssociation()) {
                    ISequence[] sequ = Sequence.createSequences(ast, 2, "drop", engine);
                    if (sequ == null) {
                        return F.NIL;
                    }
                    IAST list = (IAST)arg1;
                    IASTAppendable resultList = list.copyAppendable();
                    Drop.drop(resultList, 0, sequ);
                    return resultList;
                }
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (IndexOutOfBoundsException | NullPointerException e) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)e);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(16384);
        }

        private static IAST drop(IASTAppendable list, int level, ISequence[] sequenceSpecifications) {
            int i;
            sequenceSpecifications[level].setListSize(list.size());
            int newLevel = level + 1;
            int j = sequenceSpecifications[level].getStart();
            int end = sequenceSpecifications[level].getEnd();
            int step = sequenceSpecifications[level].getStep();
            if (step < 0) {
                if (j < --end || end <= 0) {
                    throw new ArgumentTypeException("cannot drop positions " + sequenceSpecifications[level].getStartOffset() + " through " + sequenceSpecifications[level].getEndOffset() + " in " + list);
                }
                for (i = j; i >= end; i += step) {
                    if (j >= list.size()) {
                        throw new ArgumentTypeException("cannot drop positions " + sequenceSpecifications[level].getStartOffset() + " through " + sequenceSpecifications[level].getEndOffset() + " in " + list);
                    }
                    list.remove(j);
                    j += step;
                }
            } else {
                if (j == 0) {
                    throw new ArgumentTypeException("cannot drop positions " + sequenceSpecifications[level].getStartOffset() + " through " + sequenceSpecifications[level].getEndOffset() + " in " + list);
                }
                for (i = j; i < end; i += step) {
                    if (j >= list.size()) {
                        throw new ArgumentTypeException("cannot drop positions " + sequenceSpecifications[level].getStartOffset() + " through " + sequenceSpecifications[level].getEndOffset() + " in " + list);
                    }
                    list.remove(j);
                    j += step - 1;
                }
            }
            for (int j2 = 1; j2 < list.size(); ++j2) {
                if (sequenceSpecifications.length <= newLevel) continue;
                if (list.get(j2).isAST()) {
                    IASTAppendable tempList = ((IAST)list.get(j2)).copyAppendable();
                    list.set(j2, Drop.drop(tempList, newLevel, sequenceSpecifications));
                    continue;
                }
                throw new ArgumentTypeException("Cannot execute drop for argument: " + list.get(j2).toString());
            }
            return list;
        }
    }

    private static final class DuplicateFreeQ
    extends AbstractFunctionEvaluator {
        private DuplicateFreeQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr test = S.Equal;
            if (ast.isAST2()) {
                test = ast.arg2();
            }
            if (ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                BiPredicate<IExpr, IExpr> biPredicate = Predicates.isBinaryTrue(test);
                int size = list.size();
                for (int i = 1; i < size; ++i) {
                    IExpr listElement = list.get(i);
                    for (int j = i + 1; j < list.size(); ++j) {
                        if (!biPredicate.test(list.get(j), listElement)) continue;
                        return S.False;
                    }
                }
                return S.True;
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class Dispatch
    extends AbstractCoreFunctionEvaluator {
        private Dispatch() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast instanceof DispatchExpr) {
                return F.NIL;
            }
            if (ast.isAST1()) {
                try {
                    IExpr evaledArg1 = engine.evaluate(ast.arg1());
                    if (evaledArg1.isListOfRules(false)) {
                        return DispatchExpr.newInstance((IAST)evaledArg1);
                    }
                    if (evaledArg1.isRuleAST()) {
                        return DispatchExpr.newInstance(F.list(evaledArg1));
                    }
                    if (evaledArg1.isAssociation()) {
                        return DispatchExpr.newInstance((IAssociation)evaledArg1);
                    }
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class DeleteDuplicatesBy
    extends AbstractFunctionEvaluator {
        private DeleteDuplicatesBy() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2() && (ast.arg1().isList() || ast.arg1().isAssociation())) {
                IExpr test = ast.arg2();
                HashSet<IExpr> set = new HashSet<IExpr>();
                if (ast.arg1().isList()) {
                    IAST list = (IAST)ast.arg1();
                    int size = list.size();
                    IASTAppendable result = list.copyHead(size);
                    for (int i = 1; i < size; ++i) {
                        IExpr listElement = list.get(i);
                        IExpr x = engine.evaluate(F.unaryAST1(test, listElement));
                        if (set.contains(x)) continue;
                        result.append(listElement);
                        set.add(x);
                    }
                    return result;
                }
                IAssociation assoc = (IAssociation)ast.arg1();
                int size = assoc.size();
                IASTAppendable result = assoc.copyHead(size);
                for (int i = 1; i < size; ++i) {
                    IAST assocRule = assoc.getRule(i);
                    IExpr x = engine.evaluate(F.unaryAST1(test, assocRule.second()));
                    if (set.contains(x)) continue;
                    result.append(assocRule);
                    set.add(x);
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2_1;
        }
    }

    private static final class DeleteDuplicates
    extends AbstractFunctionEvaluator {
        private DeleteDuplicates() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr test = S.Equal;
            if (ast.isAST2()) {
                test = ast.arg2();
            }
            if (ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                BiPredicate<IExpr, IExpr> biPredicate = Predicates.isBinaryTrue(test);
                int size = list.size();
                IASTAppendable result = F.ListAlloc(size);
                block0: for (int i = 1; i < size; ++i) {
                    IExpr listElement = list.get(i);
                    for (int j = 1; j < result.size(); ++j) {
                        if (biPredicate.test(result.get(j), listElement)) continue block0;
                    }
                    result.append(listElement);
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class DeleteCases
    extends AbstractCoreFunctionEvaluator {
        private DeleteCases() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            if (arg1.isASTOrAssociation()) {
                IPatternMatcher matcher = engine.evalPatternMatcher(ast.arg2());
                if (ast.isAST3() || ast.size() == 5) {
                    IExpr arg3 = engine.evaluate(ast.arg3());
                    int maximumRemoveOperations = -1;
                    IASTAppendable arg1RemoveClone = ((IAST)arg1).copyAppendable();
                    try {
                        if (ast.size() == 5) {
                            maximumRemoveOperations = ast.arg4().isInfinity() ? Integer.MAX_VALUE : Validate.checkIntType(ast, 4);
                        }
                        DeleteCasesPatternMatcherFunctor cpmf = new DeleteCasesPatternMatcherFunctor(matcher);
                        VisitorRemoveLevelSpecification level = new VisitorRemoveLevelSpecification(cpmf, arg3, maximumRemoveOperations, false, engine);
                        arg1RemoveClone.accept(level);
                        if (level.getRemovedCounter() == 0) {
                            return arg1;
                        }
                        return arg1RemoveClone;
                    }
                    catch (VisitorRemoveLevelSpecification.StopException stopException) {
                        return arg1RemoveClone;
                    }
                }
                return DeleteCases.deleteCases((IAST)arg1, matcher);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_4;
        }

        public static IAST deleteCases(IAST ast, IPatternMatcher matcher) {
            return ast.removeIf(matcher);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }

        private static class DeleteCasesPatternMatcherFunctor
        implements Function<IExpr, IExpr> {
            private final IPatternMatcher matcher;

            public DeleteCasesPatternMatcherFunctor(IPatternMatcher matcher) {
                this.matcher = matcher;
            }

            @Override
            public IExpr apply(IExpr arg) {
                if (this.matcher.test(arg)) {
                    return S.Null;
                }
                return F.NIL;
            }
        }
    }

    private static class Delete
    extends AbstractCoreFunctionEvaluator {
        private Delete() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            IExpr arg2 = engine.evaluate(ast.arg2());
            if (arg1.isASTOrAssociation()) {
                IAST indxList;
                IAST list = (IAST)arg1;
                if (arg2.isInteger()) {
                    int indx = 0;
                    try {
                        indx = Validate.checkIntType(ast, 2, Integer.MIN_VALUE);
                        if (indx < 0) {
                            indx = list.size() + indx;
                        }
                        if (indx == 0) {
                            return list.setAtCopy(0, S.Sequence);
                        }
                        if (indx >= list.size()) {
                            return IOFunctions.printMessage(ast.topHead(), "partw", F.list(F.list(ast.arg2()), list), engine);
                        }
                        return list.splice(indx);
                    }
                    catch (ValidateException ve) {
                        return IOFunctions.printMessage(ast.topHead(), ve, engine);
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), "Cannot delete position {} in {}", (Object)arg2, (Object)arg1, (Object)rex);
                    }
                } else if (arg2.isList() && !(indxList = (IAST)arg2).isListOfLists()) {
                    return this.deleteListOfPositions(list, indxList, engine);
                }
            }
            return F.NIL;
        }

        private IAST deleteListOfPositions(IAST list, IAST listOfIntPositions, EvalEngine engine) {
            try {
                int[] indx = Validate.checkListOfInts(list, (IExpr)listOfIntPositions, Integer.MIN_VALUE, Integer.MAX_VALUE, engine);
                if (indx == null) {
                    return F.NIL;
                }
                return this.deletePartRecursive(list, indx, 0);
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), "Cannot delete position {} in {}", (Object)listOfIntPositions, (Object)list, (Object)rex);
                return F.NIL;
            }
        }

        private IAST deletePartRecursive(IAST list, int[] indx, int indxPosition) {
            IAST subResult;
            int position = indx[indxPosition];
            if (position < 0 && (position = list.size() + position) <= 0) {
                return F.NIL;
            }
            if (indxPosition == indx.length - 1) {
                if (position == 0) {
                    return list.setAtCopy(0, S.Sequence);
                }
                return list.splice(position);
            }
            IExpr temp = list.get(position);
            if (temp.isASTOrAssociation() && (subResult = this.deletePartRecursive((IAST)temp, indx, indxPosition + 1)).isPresent()) {
                return list.setAtCopy(position, subResult);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2_1;
        }
    }

    private static final class CountDistinct
    extends AbstractCoreFunctionEvaluator {
        private CountDistinct() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            if (arg1.isASTOrAssociation()) {
                HashSet map = new HashSet();
                ((IAST)arg1).forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> map.add(x)));
                return F.ZZ(map.size());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class Count
    extends AbstractFunctionEvaluator {
        private Count() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            VisitorLevelSpecification level;
            IExpr arg1 = ast.arg1();
            CountFunctor mf = new CountFunctor(engine.evalPatternMatcher(ast.arg2()));
            if (ast.isAST3()) {
                IExpr arg3 = engine.evaluate(ast.arg3());
                level = new VisitorLevelSpecification((Function<IExpr, IExpr>)mf, arg3, false, engine);
            } else {
                level = new VisitorLevelSpecification((Function<IExpr, IExpr>)mf, 1, false);
            }
            arg1.accept(level);
            return F.ZZ(mf.getCounter());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        private static class CountFunctor
        implements Function<IExpr, IExpr> {
            protected final IPatternMatcher matcher;
            protected int counter;

            public int getCounter() {
                return this.counter;
            }

            public CountFunctor(IPatternMatcher patternMatcher) {
                this.matcher = patternMatcher;
                this.counter = 0;
            }

            @Override
            public IExpr apply(IExpr arg) {
                if (this.matcher.test(arg)) {
                    ++this.counter;
                }
                return F.NIL;
            }
        }
    }

    private static final class ConstantArray
    extends AbstractEvaluator {
        private ConstantArray() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.size() >= 3 && ast.size() <= 5) {
                    ArrayList<ArrayIterator> iterList = new ArrayList<ArrayIterator>();
                    IExpr constantExpr = ast.arg1();
                    if (ast.isAST2() && ast.arg2().isInteger()) {
                        int indx1 = Validate.checkIntType(ast, 2);
                        return constantExpr.constantArray(S.List, 0, indx1);
                    }
                    if (ast.isAST2() && ast.arg2().isList()) {
                        IAST dimensions = (IAST)ast.arg2();
                        int[] dim = new int[dimensions.size() - 1];
                        for (int i = 1; i < dimensions.size(); ++i) {
                            int indx1;
                            dim[i - 1] = indx1 = Validate.checkIntType(dimensions, i);
                        }
                        if (dim.length == 0) {
                            return F.CEmptyList;
                        }
                        return constantExpr.constantArray(S.List, 0, dim);
                    }
                    if (ast.size() >= 4) {
                        if (ast.arg2().isInteger() && ast.arg3().isInteger()) {
                            int indx1 = Validate.checkIntType(ast, 3);
                            int indx2 = Validate.checkIntType(ast, 2);
                            iterList.add(new ArrayIterator(indx1, indx2));
                        } else if (ast.arg2().isList() && ast.arg3().isList()) {
                            IAST dimIter = (IAST)ast.arg2();
                            IAST originIter = (IAST)ast.arg3();
                            for (int i = 1; i < dimIter.size(); ++i) {
                                int indx1 = Validate.checkIntType(originIter, i);
                                int indx2 = Validate.checkIntType(dimIter, i);
                                iterList.add(new ArrayIterator(indx1, indx2));
                            }
                        }
                    }
                    if (iterList.size() > 0) {
                        IAST resultList = F.CEmptyList;
                        if (ast.size() == 5) {
                            resultList = F.ast(ast.arg4());
                        }
                        TableGenerator generator = new TableGenerator(iterList, resultList, new MultipleConstArrayFunction(constantExpr));
                        return generator.table();
                    }
                }
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (ArithmeticException | ClassCastException runtimeException) {
                // empty catch block
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class ComposeList
    extends AbstractEvaluator {
        private ComposeList() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return ComposeList.evaluateComposeList(ast, F.ListAlloc(8));
        }

        public static IExpr evaluateComposeList(IAST ast, IASTAppendable resultList) {
            try {
                if (ast.isAST2() && ast.arg1().isAST()) {
                    IAST list = (IAST)ast.arg1();
                    IASTAppendable constant = F.ast(ast.arg1());
                    ListFunctions.foldLeft(ast.arg2(), list, 1, list.size(), (x, y) -> {
                        IASTAppendable a = constant.apply((IExpr)y);
                        a.append((IExpr)x);
                        return a;
                    }, resultList);
                    return resultList;
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Composition
    extends AbstractFunctionEvaluator {
        private Composition() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST headList;
            if (ast.head().equals(S.Composition)) {
                if (ast.isAST0()) {
                    return S.Identity;
                }
                return ast.remove(x -> x.equals(S.Identity));
            }
            if (ast.head().isAST() && (headList = (IAST)ast.head()).size() > 1) {
                IASTAppendable inner;
                IASTAppendable result = inner = F.ast(headList.arg1());
                for (int i = 2; i < headList.size(); ++i) {
                    IASTAppendable temp = F.ast(headList.get(i));
                    inner.append(temp);
                    inner = temp;
                }
                inner.appendArgs(ast);
                return result;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(9);
        }
    }

    private static final class Complement
    extends AbstractFunctionEvaluator {
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST arg2;
            IAST arg1;
            IAST result;
            if (ast.arg1().isASTOrAssociation() && ast.arg2().isASTOrAssociation() && (result = Complement.complement(arg1 = (IAST)ast.arg1(), arg2 = (IAST)ast.arg2())).isPresent()) {
                for (int i = 3; i < ast.size(); ++i) {
                    IExpr arg = ast.get(i);
                    if (!arg.isASTOrAssociation()) {
                        return F.NIL;
                    }
                    result = Complement.complement(result, (IAST)arg);
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_INFINITY;
        }

        public static IAST complement(IAST arg1, IAST arg2) {
            Set<IExpr> set2 = arg2.asSet();
            if (set2 != null) {
                HashSet set3 = new HashSet();
                arg1.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> {
                    if (!set2.contains(x)) {
                        set3.add(x);
                    }
                }));
                IASTMutable result = F.ListAlloc(set3);
                EvalAttributes.sort(result);
                return result;
            }
            return F.NIL;
        }
    }

    private static final class Commonest
    extends AbstractEvaluator {
        private Commonest() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isRealVector()) {
                double[] values = arg1.toDoubleVector();
                if (values == null) {
                    return F.NIL;
                }
                return new ASTRealVector(StatUtils.mode((double[])values), false);
            }
            if (arg1.isList()) {
                IAST list = (IAST)arg1;
                int n = -1;
                if (ast.isAST2() && (n = Validate.checkIntType(S.Commonest, ast.arg2(), 0, engine)) == Integer.MIN_VALUE) {
                    return F.NIL;
                }
                IASTAppendable tallyResult = Tally.tally1Arg(list);
                EvalAttributes.sort(tallyResult, new Comparator<IExpr>(){

                    @Override
                    public int compare(IExpr o1, IExpr o2) {
                        return o2.second().compareTo(o1.second());
                    }
                });
                int size = tallyResult.size();
                if (size > 1) {
                    if (n == -1) {
                        IInteger max = (IInteger)((IAST)tallyResult.arg1()).arg2();
                        IASTAppendable result = F.ListAlloc(size);
                        result.append(((IAST)tallyResult.arg1()).arg1());
                        tallyResult.exists(x -> {
                            if (max.equals(x.second())) {
                                result.append(x.first());
                                return false;
                            }
                            return true;
                        }, 2);
                        return result;
                    }
                    int counter = 0;
                    IASTAppendable result = F.ListAlloc(size);
                    for (int i = 1; i < size && counter < n; ++counter, ++i) {
                        result.append(((IAST)tallyResult.get(i)).arg1());
                    }
                    return result;
                }
                return F.CEmptyList;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Catenate
    extends AbstractEvaluator {
        private Catenate() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                int[] calculatedAllocSize = new int[]{1};
                if (list.forAll(Catenate.isListOrAssociation(calculatedAllocSize))) {
                    IASTAppendable resultList = F.ast((IExpr)S.List, calculatedAllocSize[0]);
                    list.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> resultList.appendArgs((IAST)x)));
                    return resultList;
                }
            }
            return F.NIL;
        }

        private static Predicate<? super IExpr> isListOrAssociation(int[] calculatedAllocSize) {
            return x -> {
                if (x.isList() || x.isAssociation()) {
                    calculatedAllocSize[0] = calculatedAllocSize[0] + x.argSize();
                    return true;
                }
                return false;
            };
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class Cases
    extends AbstractCoreFunctionEvaluator {
        private Cases() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            block13: {
                try {
                    IExpr arg1;
                    boolean heads = false;
                    if (ast.size() < 3 || ast.size() > 5) break block13;
                    OptionArgs options = OptionArgs.createOptionArgs(ast, engine);
                    if (options != null) {
                        IExpr option = options.getOption(S.Heads);
                        if (option.isPresent() && option.isTrue()) {
                            heads = true;
                        }
                        ast = ast.most();
                    }
                    if ((arg1 = engine.evaluate(ast.arg1())).isASTOrAssociation()) {
                        IExpr arg2 = engine.evalPattern(ast.arg2());
                        if (ast.isAST3() || ast.size() == 5) {
                            IExpr arg3 = engine.evaluate(ast.arg3());
                            int maximumResults = -1;
                            if (ast.size() == 5) {
                                maximumResults = Validate.checkIntType(ast, 4);
                            }
                            IASTAppendable result = F.ListAlloc(8);
                            if (arg2.isRuleAST()) {
                                try {
                                    Function<IExpr, IExpr> function = Functors.rules((IAST)arg2, engine);
                                    CasesRulesFunctor crf = new CasesRulesFunctor(function, result, maximumResults);
                                    VisitorLevelSpecification level = new VisitorLevelSpecification((Function<IExpr, IExpr>)crf, arg3, heads, engine);
                                    arg1.accept(level);
                                }
                                catch (AbortException function) {
                                    // empty catch block
                                }
                                return result;
                            }
                            try {
                                IPatternMatcher matcher = engine.evalPatternMatcher(arg2);
                                CasesPatternMatcherFunctor cpmf = new CasesPatternMatcherFunctor(matcher, result, maximumResults);
                                VisitorLevelSpecification level = new VisitorLevelSpecification((Function<IExpr, IExpr>)cpmf, arg3, heads, engine);
                                arg1.accept(level);
                            }
                            catch (AbortException abortException) {
                                // empty catch block
                            }
                            return result;
                        }
                        return Cases.cases((IAST)arg1, arg2, heads, engine);
                    }
                    return F.CEmptyList;
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("Cases.evaluate() failed", (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_4_1;
        }

        public static IAST cases(IAST ast, IExpr pattern, boolean heads, EvalEngine engine) {
            if (pattern.isRuleAST()) {
                Function<IExpr, IExpr> function = Functors.rules((IAST)pattern, engine);
                IASTAppendable[] results = ast.filterNIL(function);
                return results[0];
            }
            IPatternMatcher matcher = engine.evalPatternMatcher(pattern);
            IASTAppendable resultAST = F.ListAlloc(ast.size());
            ast.forEach(heads ? 0 : 1, ast.size(), Cases.appendIfMatched(matcher, resultAST));
            return resultAST;
        }

        private static Consumer<? super IExpr> appendIfMatched(IPatternMatcher matcher, IASTAppendable resultAST) {
            return x -> {
                if (matcher.test((IExpr)x)) {
                    resultAST.append((IExpr)x);
                }
            };
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Heads, (IExpr)S.False)));
        }

        private static class CasesRulesFunctor
        implements Function<IExpr, IExpr> {
            protected final Function<IExpr, IExpr> function;
            protected IASTAppendable resultCollection;
            final int maximumResults;
            private int resultsCounter;

            public CasesRulesFunctor(Function<IExpr, IExpr> function, IASTAppendable resultCollection, int maximumResults) {
                this.function = function;
                this.resultCollection = resultCollection;
                this.maximumResults = maximumResults;
            }

            @Override
            public IExpr apply(IExpr arg) throws AbortException {
                IExpr temp = this.function.apply(arg);
                if (temp.isPresent()) {
                    this.resultCollection.append(temp);
                    if (this.maximumResults >= 0) {
                        ++this.resultsCounter;
                        if (this.resultsCounter >= this.maximumResults) {
                            throw AbortException.ABORTED;
                        }
                    }
                }
                return F.NIL;
            }
        }

        private static class CasesPatternMatcherFunctor
        implements Function<IExpr, IExpr> {
            protected final IPatternMatcher matcher;
            protected IASTAppendable resultCollection;
            final int maximumResults;
            private int resultsCounter;

            public CasesPatternMatcherFunctor(IPatternMatcher matcher, IASTAppendable resultCollection, int maximumResults) {
                this.matcher = matcher;
                this.resultCollection = resultCollection;
                this.maximumResults = maximumResults;
                this.resultsCounter = 0;
            }

            @Override
            public IExpr apply(IExpr arg) throws AbortException {
                if (this.matcher.test(arg)) {
                    this.resultCollection.append(arg);
                    if (this.maximumResults >= 0) {
                        ++this.resultsCounter;
                        if (this.resultsCounter >= this.maximumResults) {
                            throw AbortException.ABORTED;
                        }
                    }
                }
                return F.NIL;
            }
        }
    }

    private static final class ArrayPad
    extends AbstractFunctionEvaluator {
        private ArrayPad() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAST()) {
                IAST arg1 = (IAST)ast.arg1();
                int m = -1;
                int n = -1;
                if (ast.arg2().isAST(S.List, 3)) {
                    IAST list = (IAST)ast.arg2();
                    m = list.arg1().toIntDefault(-1);
                    n = list.arg2().toIntDefault(-1);
                } else {
                    m = n = ast.arg2().toIntDefault(-1);
                }
                if (m > 0 && n > 0) {
                    int[] dim = arg1.isMatrix();
                    if (dim != null) {
                        return ArrayPad.arrayPadMatrixAtom(arg1, dim, m, n, ast.size() > 3 ? ast.arg3() : F.C0);
                    }
                    return ArrayPad.arrayPadAtom(arg1, m, n, ast.size() > 3 ? ast.arg3() : F.C0);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        private static IExpr arrayPadMatrixAtom(IAST matrix, int[] dim, int m, int n, IExpr atom) {
            long rowDim;
            long columnDim = (long)dim[1] + (long)m + (long)n;
            if ((long)Config.MAX_AST_SIZE < columnDim) {
                ASTElementLimitExceeded.throwIt(columnDim);
            }
            if ((long)Config.MAX_AST_SIZE < (rowDim = (long)(dim[0] + m + n))) {
                ASTElementLimitExceeded.throwIt(rowDim);
            }
            IASTAppendable result = matrix.copyHead((int)rowDim);
            result.appendArgs(0, m, i -> atom.constantArray(S.List, 0, (int)columnDim));
            result.appendArgs(1, dim[0] + 1, i -> ArrayPad.arrayPadAtom(matrix.getAST(i), m, n, atom));
            result.appendArgs(0, n, i -> atom.constantArray(S.List, 0, (int)columnDim));
            return result;
        }

        private static IExpr arrayPadAtom(IAST ast, int m, int n, IExpr atom) {
            long intialCapacity = (long)m + (long)n + (long)ast.argSize();
            if ((long)Config.MAX_AST_SIZE < intialCapacity) {
                ASTElementLimitExceeded.throwIt(intialCapacity);
            }
            IASTAppendable result = ast.copyHead((int)intialCapacity);
            result.appendArgs(0, m, i -> atom);
            result.appendArgs(ast);
            result.appendArgs(0, n, i -> atom);
            return result;
        }
    }

    private static final class Array
    extends AbstractCoreFunctionEvaluator {
        private Array() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IAST prototypeList;
                IExpr head = S.List;
                if (ast.size() == 5) {
                    head = ast.arg4();
                    prototypeList = F.ast(head);
                } else {
                    prototypeList = F.CEmptyList;
                }
                IExpr arg1 = ast.arg1();
                IExpr arg2 = ast.arg2();
                ArrayList<IIterator<IExpr>> iterList = new ArrayList<IIterator<IExpr>>();
                if (ast.size() >= 4) {
                    IExpr arg3 = ast.arg3();
                    if (arg2.isInteger() && !arg3.isList()) {
                        int length = arg2.toIntDefault();
                        if (length <= 0) {
                            return IOFunctions.printMessage(ast.topHead(), "ilsmn", F.list(F.C2, ast), engine);
                        }
                        IExpr indexOrigin = arg3;
                        int origin = indexOrigin.toIntDefault();
                        if (origin != Integer.MIN_VALUE) {
                            iterList.add(new ArrayIterator(origin, length));
                        } else {
                            iterList.add(new ExprArrayIterator(indexOrigin, length));
                        }
                    } else if (arg2.isList() && arg3.isInteger()) {
                        IAST dimIter = (IAST)arg2;
                        int indx1 = Validate.checkIntType(ast, 3, -2147483647);
                        for (int i = 1; i < dimIter.size(); ++i) {
                            int indx2 = Validate.checkIntType(dimIter, i);
                            iterList.add(new ArrayIterator(indx1, indx2));
                        }
                    } else {
                        if (arg2.isInteger() && arg3.isList2()) {
                            IExpr to;
                            int n = arg2.toIntDefault();
                            if (n <= 0) {
                                return IOFunctions.printMessage(ast.topHead(), "ilsmn", F.list(F.C2, ast), engine);
                            }
                            IAST interval = (IAST)arg3;
                            IExpr from = interval.arg1();
                            IExpr subdivideResult = engine.evaluate(F.Subdivide(from, to = interval.arg2(), F.ZZ(n - 1)));
                            if (subdivideResult.isList()) {
                                IAST list = (IAST)subdivideResult;
                                if (head != S.List) {
                                    list = list.setAtCopy(0, head);
                                }
                                return list.mapThread(F.unaryAST1(arg1, F.Slot1), 1);
                            }
                            return F.NIL;
                        }
                        if (arg2.isList() && arg3.isList()) {
                            IAST dimIter = (IAST)arg2;
                            IAST originIter = (IAST)arg3;
                            if (dimIter.size() != originIter.size()) {
                                return IOFunctions.printMessage(ast.topHead(), "plen", F.list(dimIter, originIter), engine);
                            }
                            for (int i = 1; i < dimIter.size(); ++i) {
                                int indx1 = Validate.checkIntType(originIter, i);
                                int indx2 = Validate.checkIntType(dimIter, i);
                                iterList.add(new ArrayIterator(indx1, indx2));
                            }
                        }
                    }
                } else if (ast.size() >= 3 && arg2.isInteger()) {
                    int indx1 = Validate.checkIntType(ast, 2);
                    iterList.add(new ArrayIterator(indx1));
                } else if (ast.size() >= 3 && arg2.isList()) {
                    IAST dimIter = (IAST)arg2;
                    for (int i = 1; i < dimIter.size(); ++i) {
                        int indx1 = Validate.checkIntType(dimIter, i);
                        iterList.add(new ArrayIterator(indx1));
                    }
                }
                if (iterList.size() > 0) {
                    IASTAppendable list = F.ast(arg1);
                    TableGenerator generator = new TableGenerator(iterList, prototypeList, new MultipleArrayFunction(engine, list));
                    return generator.table();
                }
            }
            catch (ArithmeticException | ClassCastException runtimeException) {
                // empty catch block
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_4;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }

        private static class MultipleArrayFunction
        implements IVariablesFunction {
            final EvalEngine fEngine;
            final IAST fHeadAST;

            public MultipleArrayFunction(EvalEngine engine, IAST headAST) {
                this.fEngine = engine;
                this.fHeadAST = headAST;
            }

            @Override
            public IExpr evaluate(ISymbol[] variables, IExpr[] index) {
                IASTAppendable ast = this.fHeadAST.copyAppendable();
                return this.fEngine.evaluate(ast.appendArgs(0, index.length, i -> index[i]));
            }
        }

        private static class ExprArrayIterator
        implements IIterator<IExpr> {
            private final IExpr fOrigin;
            private int fCounter;
            private final int fLength;

            public ExprArrayIterator(IExpr origin, int length) {
                this.fOrigin = origin;
                this.fCounter = 0;
                this.fLength = length;
            }

            @Override
            public boolean setUp() {
                return true;
            }

            @Override
            public void tearDown() {
                this.fCounter = 0;
            }

            @Override
            public boolean hasNext() {
                return this.fCounter < this.fLength;
            }

            @Override
            public IExpr next() {
                return F.Plus(this.fOrigin, (IExpr)F.ZZ(this.fCounter++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int allocHint() {
                return this.fLength + 2;
            }
        }
    }

    private static final class AppendTo
    extends AbstractCoreFunctionEvaluator {
        private AppendTo() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2;
            AppendToFunction function;
            IExpr[] results;
            IExpr arg1 = ast.arg1();
            if (arg1.isASTSizeGE(S.Part, 3) && arg1.first().isSymbol()) {
                ISymbol sym = (ISymbol)arg1.first();
                return ListFunctions.assignPartTo(sym, (IAST)arg1, S.Append, ast, engine);
            }
            IExpr sym = Validate.checkIsVariable(ast, 1, engine);
            if (sym.isSymbol() && (results = ((ISymbol)sym).reassignSymbolValue(function = new AppendToFunction(arg2 = engine.evaluate(ast.arg2())), ast.topHead(), engine)) != null) {
                return results[1];
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(32);
        }

        private static class AppendToFunction
        implements Function<IExpr, IExpr> {
            private final IExpr value;

            public AppendToFunction(IExpr value) {
                this.value = value;
            }

            @Override
            public IExpr apply(IExpr symbolValue) {
                if (symbolValue.isAssociation()) {
                    if (this.value.isRuleAST() || this.value.isListOfRules() || this.value.isAssociation()) {
                        IAssociation result = (IAssociation)symbolValue;
                        result.appendRules((IAST)this.value);
                        return result;
                    }
                    return IOFunctions.printMessage(S.AppendTo, "invdt", F.CEmptyList, EvalEngine.get());
                }
                if (!symbolValue.isASTOrAssociation()) {
                    return F.NIL;
                }
                return ((IAST)symbolValue).appendClone(this.value);
            }
        }
    }

    private static final class Append
    extends AbstractCoreFunctionEvaluator {
        private Append() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            IAST arg1AST = Validate.checkASTOrAssociationType(ast, arg1, 1, engine);
            if (!arg1AST.isPresent()) {
                return F.NIL;
            }
            IExpr arg2 = engine.evaluate(ast.arg2());
            if (arg1.isAssociation()) {
                if (arg2.isRuleAST() || arg2.isListOfRules() || arg2.isAssociation()) {
                    IAssociation result = ((IAssociation)arg1).copy();
                    result.appendRules((IAST)arg2);
                    return result;
                }
                return IOFunctions.printMessage(ast.topHead(), "invdt", F.CEmptyList, EvalEngine.get());
            }
            return arg1AST.appendClone(arg2);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2_1;
        }
    }

    private static final class Accumulate
    extends AbstractEvaluator {
        private Accumulate() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isASTOrAssociation()) {
                IAST list = (IAST)arg1;
                int size = list.size();
                IASTAppendable resultList = F.ast(list.head(), size);
                return ListFunctions.foldLeft(null, list, 1, size, (x, y) -> F.binaryAST2((IExpr)S.Plus, x, y), resultList);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    public static class TableGenerator {
        final List<? extends IIterator<IExpr>> fIterList;
        final IExpr fDefaultValue;
        final IAST fPrototypeList;
        final IVariablesFunction fFunction;
        int fIndex;
        private IExpr[] fCurrentIndex;
        private ISymbol[] fCurrentVariable;

        public TableGenerator(List<? extends IIterator<IExpr>> iterList, IAST prototypeList, IVariablesFunction function) {
            this(iterList, prototypeList, function, F.NIL);
        }

        public TableGenerator(List<? extends IIterator<IExpr>> iterList, IAST prototypeList, IVariablesFunction function, IExpr defaultValue) {
            this.fIterList = iterList;
            this.fPrototypeList = prototypeList;
            this.fFunction = function;
            this.fIndex = 0;
            this.fCurrentIndex = new IExpr[iterList.size()];
            this.fCurrentVariable = new ISymbol[iterList.size()];
            this.fDefaultValue = defaultValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IExpr table() {
            if (this.fIndex < this.fIterList.size()) {
                IIterator<IExpr> iter = this.fIterList.get(this.fIndex);
                if (iter.setUp()) {
                    try {
                        int index = this.fIndex++;
                        if (this.fPrototypeList.head().equals(S.Plus) || this.fPrototypeList.head().equals(S.Times)) {
                            if (iter.hasNext()) {
                                this.fCurrentIndex[index] = (IExpr)iter.next();
                                this.fCurrentVariable[index] = iter.getVariable();
                                IExpr temp = this.table();
                                if (temp == null || !temp.isPresent()) {
                                    temp = this.fDefaultValue;
                                }
                                if (temp.isNumber()) {
                                    if (this.fPrototypeList.head().equals(S.Plus)) {
                                        IExpr iExpr = this.tablePlus(temp, iter, index);
                                        return iExpr;
                                    }
                                    IExpr iExpr = this.tableTimes(temp, iter, index);
                                    return iExpr;
                                }
                                IExpr iExpr = this.createGenericTable(iter, index, iter.allocHint(), temp, null);
                                return iExpr;
                            }
                            if (iter.isInvalidNumeric()) {
                                IExpr iExpr = this.fDefaultValue;
                                return iExpr;
                            }
                            IAssociation iAssociation = F.NIL;
                            return iAssociation;
                        }
                        IExpr iExpr = this.createGenericTable(iter, index, iter.allocHint(), null, null);
                        return iExpr;
                    }
                    finally {
                        --this.fIndex;
                        iter.tearDown();
                    }
                }
                return this.fDefaultValue;
            }
            return this.fFunction.evaluate(this.fCurrentVariable, this.fCurrentIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IExpr tableThrow() {
            if (this.fIndex < this.fIterList.size()) {
                IIterator<IExpr> iter = this.fIterList.get(this.fIndex);
                try {
                    if (iter.setUpThrow()) {
                        int index = this.fIndex++;
                        if ((this.fPrototypeList.head().equals(S.Plus) || this.fPrototypeList.head().equals(S.Times)) && iter.hasNext()) {
                            this.fCurrentIndex[index] = (IExpr)iter.next();
                            this.fCurrentVariable[index] = iter.getVariable();
                            IExpr temp = this.table();
                            if (temp == null || !temp.isPresent()) {
                                temp = this.fDefaultValue;
                            }
                            if (temp.isNumber()) {
                                if (this.fPrototypeList.head().equals(S.Plus)) {
                                    IExpr iExpr = this.tablePlus(temp, iter, index);
                                    return iExpr;
                                }
                                IExpr iExpr = this.tableTimes(temp, iter, index);
                                return iExpr;
                            }
                            IExpr iExpr = this.createGenericTable(iter, index, iter.allocHint(), temp, null);
                            return iExpr;
                        }
                        IExpr iExpr = this.createGenericTable(iter, index, iter.allocHint(), null, null);
                        return iExpr;
                    }
                }
                finally {
                    --this.fIndex;
                    iter.tearDown();
                }
                return this.fDefaultValue;
            }
            return this.fFunction.evaluate(this.fCurrentVariable, this.fCurrentIndex);
        }

        private IExpr tablePlus(IExpr temp, IIterator<IExpr> iter, int index) {
            int counter = 0;
            INumber num = (INumber)temp;
            while (iter.hasNext()) {
                this.fCurrentIndex[index] = (IExpr)iter.next();
                this.fCurrentVariable[index] = iter.getVariable();
                temp = this.table();
                if (temp == null) {
                    temp = this.fDefaultValue;
                }
                if (!temp.isNumber()) {
                    return this.createGenericTable(iter, index, iter.allocHint() - counter, num, temp);
                }
                num = (INumber)num.plus(temp);
                ++counter;
            }
            return num;
        }

        private IExpr tableTimes(IExpr temp, IIterator<IExpr> iter, int index) {
            int counter = 0;
            INumber num = (INumber)temp;
            while (iter.hasNext()) {
                this.fCurrentIndex[index] = (IExpr)iter.next();
                this.fCurrentVariable[index] = iter.getVariable();
                temp = this.table();
                if (temp == null) {
                    temp = this.fDefaultValue;
                }
                if (!temp.isNumber()) {
                    return this.createGenericTable(iter, index, iter.allocHint() - counter, num, temp);
                }
                num = (INumber)num.times(temp);
                ++counter;
            }
            return num;
        }

        private IExpr createGenericTable(IIterator<IExpr> iter, int index, int allocationHint, IExpr arg1, IExpr arg2) {
            IASTAppendable result = this.fPrototypeList.copyHead(this.fPrototypeList.size() + (allocationHint > 0 ? allocationHint + 8 : 8));
            result.appendArgs(this.fPrototypeList);
            if (arg1 != null) {
                result.append(arg1);
            }
            if (arg2 != null) {
                result.append(arg2);
            }
            while (iter.hasNext()) {
                this.fCurrentIndex[index] = (IExpr)iter.next();
                this.fCurrentVariable[index] = iter.getVariable();
                IExpr temp = this.table();
                if (temp == null || !temp.isPresent()) {
                    result.append(this.fDefaultValue);
                    continue;
                }
                result.append(temp);
            }
            return result;
        }
    }

    private static class ArrayIterator
    implements IIterator<IExpr> {
        private final IInteger fOrigin;
        private final int fLength;
        private int fCounter;

        public ArrayIterator(int to) {
            this(1, to);
        }

        public ArrayIterator(int origin, int length) {
            this.fOrigin = F.ZZ(origin);
            this.fLength = length;
            this.fCounter = 0;
        }

        @Override
        public boolean setUp() {
            return true;
        }

        @Override
        public void tearDown() {
            this.fCounter = 0;
        }

        @Override
        public boolean hasNext() {
            return this.fCounter < this.fLength;
        }

        @Override
        public IExpr next() {
            return this.fOrigin.add(F.ZZ(this.fCounter++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int allocHint() {
            return this.fLength + 2;
        }
    }

    public static class MultipleConstArrayFunction
    implements IVariablesFunction {
        final IExpr fConstantExpr;

        public MultipleConstArrayFunction(IExpr expr) {
            this.fConstantExpr = expr;
        }

        @Override
        public IExpr evaluate(ISymbol[] variables, IExpr[] index) {
            return this.fConstantExpr;
        }
    }

    private static class PositionConverter {
        private PositionConverter() {
        }

        public IExpr toObject(int position) {
            return F.ZZ(position);
        }

        public int toInt(IExpr position) {
            int val = position.toIntDefault();
            if (val < 0) {
                return -1;
            }
            return val;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Accumulate.setEvaluator(new Accumulate());
            S.Append.setEvaluator(new Append());
            S.AppendTo.setEvaluator(new AppendTo());
            S.Array.setEvaluator(new Array());
            S.ArrayPad.setEvaluator(new ArrayPad());
            S.Cases.setEvaluator(new Cases());
            S.Catenate.setEvaluator(new Catenate());
            S.Commonest.setEvaluator(new Commonest());
            S.Complement.setEvaluator(new Complement());
            S.Composition.setEvaluator(new Composition());
            S.ComposeList.setEvaluator(new ComposeList());
            S.ConstantArray.setEvaluator(new ConstantArray());
            S.Count.setEvaluator(new Count());
            S.CountDistinct.setEvaluator(new CountDistinct());
            S.Delete.setEvaluator(new Delete());
            S.DeleteDuplicates.setEvaluator(new DeleteDuplicates());
            S.DeleteDuplicatesBy.setEvaluator(new DeleteDuplicatesBy());
            S.DeleteCases.setEvaluator(new DeleteCases());
            S.Dispatch.setEvaluator(new Dispatch());
            S.DuplicateFreeQ.setEvaluator(new DuplicateFreeQ());
            S.Drop.setEvaluator(new Drop());
            S.Entropy.setEvaluator(new Entropy());
            S.Extract.setEvaluator(new Extract());
            S.First.setEvaluator(new First());
            S.FirstCase.setEvaluator(new FirstCase());
            S.FirstPosition.setEvaluator(new FirstPosition());
            S.Fold.setEvaluator(new Fold());
            S.FoldList.setEvaluator(new FoldList());
            S.Gather.setEvaluator(new Gather());
            S.GatherBy.setEvaluator(new GatherBy());
            S.GroupBy.setEvaluator(new GroupBy());
            S.Insert.setEvaluator(new Insert());
            S.Intersection.setEvaluator(new Intersection());
            S.Join.setEvaluator(new Join());
            S.Last.setEvaluator(new Last());
            S.Length.setEvaluator(new Length());
            S.LengthWhile.setEvaluator(new LengthWhile());
            S.LevelQ.setEvaluator(new LevelQ());
            S.Level.setEvaluator(new Level());
            S.Most.setEvaluator(new Most());
            S.Nearest.setEvaluator(new Nearest());
            S.NearestTo.setEvaluator(new NearestTo());
            S.PadLeft.setEvaluator(new PadLeft());
            S.PadRight.setEvaluator(new PadRight());
            S.Pick.setEvaluator(new Pick());
            S.Position.setEvaluator(new Position());
            S.Prepend.setEvaluator(new Prepend());
            S.PrependTo.setEvaluator(new PrependTo());
            S.Range.setEvaluator(new Range());
            S.RankedMax.setEvaluator(new RankedMax());
            S.RankedMin.setEvaluator(new RankedMin());
            S.Rest.setEvaluator(new Rest());
            S.Reverse.setEvaluator(new Reverse());
            S.Replace.setEvaluator(new Replace());
            S.ReplaceAll.setEvaluator(new ReplaceAll());
            S.ReplaceList.setEvaluator(new ReplaceList());
            S.ReplacePart.setEvaluator(new ReplacePart());
            S.ReplaceRepeated.setEvaluator(new ReplaceRepeated());
            S.RightComposition.setEvaluator(new RightComposition());
            S.Riffle.setEvaluator(new Riffle());
            S.RotateLeft.setEvaluator(new RotateLeft());
            S.RotateRight.setEvaluator(new RotateRight());
            S.Select.setEvaluator(new Select());
            S.SelectFirst.setEvaluator(new SelectFirst());
            S.Split.setEvaluator(new Split());
            S.SplitBy.setEvaluator(new SplitBy());
            S.Subdivide.setEvaluator(new Subdivide());
            S.Table.setEvaluator(new Table());
            S.Take.setEvaluator(new Take());
            S.TakeLargest.setEvaluator(new TakeLargest());
            S.TakeLargestBy.setEvaluator(new TakeLargestBy());
            S.TakeSmallest.setEvaluator(new TakeSmallest());
            S.TakeSmallestBy.setEvaluator(new TakeSmallestBy());
            S.TakeWhile.setEvaluator(new TakeWhile());
            S.Tally.setEvaluator(new Tally());
            S.Total.setEvaluator(new Total());
            S.Union.setEvaluator(new Union());
        }
    }

    private static class TableFunction
    implements IVariablesFunction {
        final EvalEngine fEngine;
        final IExpr fValue;

        public TableFunction(EvalEngine engine, IExpr value) {
            this.fEngine = engine;
            this.fValue = value;
        }

        @Override
        public IExpr evaluate(ISymbol[] variables, IExpr[] index) {
            HashMap<ISymbol, IExpr> map = new HashMap<ISymbol, IExpr>();
            for (int i = 0; i < variables.length; ++i) {
                ISymbol variable = variables[i];
                if (variable == null) continue;
                map.put(variable, index[i]);
            }
            IExpr temp = map.size() == 0 ? this.fValue : this.fValue.replaceAll(map).orElse(this.fValue);
            return this.fEngine.evaluate(temp);
        }
    }

    private static interface IVariablesFunction {
        public IExpr evaluate(ISymbol[] var1, IExpr[] var2);
    }

    private static final class SmallestIndexComparator
    extends LargestIndexComparator {
        public SmallestIndexComparator(IAST ast, EvalEngine engine) {
            super(ast, engine);
        }

        @Override
        public int compare(Integer index1, Integer index2) {
            IExpr arg1 = this.ast.get(index1);
            IExpr arg2 = this.ast.get(index2);
            if (arg1.isNumericFunction(false) && arg2.isNumericFunction(false)) {
                if (this.engine.evalLess(arg1, arg2)) {
                    return -1;
                }
                if (this.engine.evalGreater(arg1, arg2)) {
                    return 1;
                }
                if (this.engine.evalEqual(arg1, arg2)) {
                    return 0;
                }
            }
            throw NoEvalException.CONST;
        }
    }

    private static class LargestIndexComparator
    implements Comparator<Integer> {
        protected final IAST ast;
        protected EvalEngine engine;

        public LargestIndexComparator(IAST ast, EvalEngine engine) {
            this.ast = ast;
            this.engine = engine;
        }

        public Integer[] createIndexArray() {
            int size = this.ast.size();
            Integer[] indexes = new Integer[size - 1];
            for (int i = 1; i < size; ++i) {
                indexes[i - 1] = i;
            }
            return indexes;
        }

        @Override
        public int compare(Integer index1, Integer index2) {
            IExpr arg1 = this.ast.get(index1);
            IExpr arg2 = this.ast.get(index2);
            if (arg1.isNumericFunction(false) && arg2.isNumericFunction(false)) {
                if (this.engine.evalGreater(arg1, arg2)) {
                    return -1;
                }
                if (this.engine.evalLess(arg1, arg2)) {
                    return 1;
                }
                if (this.engine.evalEqual(arg1, arg2)) {
                    return 0;
                }
            }
            throw NoEvalException.CONST;
        }
    }
}

