/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.FieldElement;
import org.hipparchus.complex.Complex;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.BlockFieldMatrix;
import org.hipparchus.linear.ComplexEigenDecomposition;
import org.hipparchus.linear.DecompositionSolver;
import org.hipparchus.linear.EigenDecomposition;
import org.hipparchus.linear.FieldDecompositionSolver;
import org.hipparchus.linear.FieldLUDecomposition;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldQRDecomposition;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.linear.RiccatiEquationSolverImpl;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractMatrix1Expr;
import org.matheclipse.core.eval.interfaces.AbstractMatrix1Matrix;
import org.matheclipse.core.eval.interfaces.AbstractNonOrderlessArgMultiple;
import org.matheclipse.core.eval.util.IndexFunctionDiagonal;
import org.matheclipse.core.eval.util.IndexTableGenerator;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.LinearSolveFunctionExpr;
import org.matheclipse.core.generic.Comparators;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.INumericArray;
import org.matheclipse.core.interfaces.ISparseArray;
import org.matheclipse.core.interfaces.ISymbol;

public final class LinearAlgebra {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IAST cramersRule2x3(FieldMatrix<IExpr> matrix, boolean quiet, EvalEngine engine) {
        IASTAppendable list = F.ListAlloc(2);
        IExpr denominator = LinearAlgebra.determinant2x2(matrix);
        if (denominator.isZero()) {
            if (!quiet) {
                LOGGER.log(engine.getLogLevel(), "Row reduced linear equations have no solution.");
                return F.NIL;
            }
            return F.NIL;
        }
        IAST xNumerator = F.Subtract(F.Times((IExpr)matrix.getEntry(0, 2), (IExpr)matrix.getEntry(1, 1)), F.Times((IExpr)matrix.getEntry(0, 1), (IExpr)matrix.getEntry(1, 2)));
        list.append(F.Divide(xNumerator, denominator));
        IAST yNumerator = F.Subtract(F.Times((IExpr)matrix.getEntry(0, 0), (IExpr)matrix.getEntry(1, 2)), F.Times((IExpr)matrix.getEntry(0, 2), (IExpr)matrix.getEntry(1, 0)));
        list.append(F.Divide(yNumerator, denominator));
        return list;
    }

    public static IAST cramersRule3x4(FieldMatrix<IExpr> matrix, boolean quiet, EvalEngine engine) {
        IASTAppendable list = F.ListAlloc(3);
        FieldMatrix denominatorMatrix = matrix.getSubMatrix(0, 2, 0, 2);
        IExpr denominator = LinearAlgebra.determinant3x3((FieldMatrix<IExpr>)denominatorMatrix);
        if (denominator.isZero()) {
            if (!quiet) {
                LOGGER.log(engine.getLogLevel(), "Row reduced linear equations have no solution.");
                return F.NIL;
            }
            return F.NIL;
        }
        FieldMatrix xMatrix = denominatorMatrix.copy();
        xMatrix.setColumn(0, (FieldElement[])new IExpr[]{(IExpr)matrix.getEntry(0, 3), (IExpr)matrix.getEntry(1, 3), (IExpr)matrix.getEntry(2, 3)});
        IExpr xNumerator = LinearAlgebra.determinant3x3((FieldMatrix<IExpr>)xMatrix);
        list.append(F.Divide(xNumerator, denominator));
        FieldMatrix yMatrix = denominatorMatrix.copy();
        yMatrix.setColumn(1, (FieldElement[])new IExpr[]{(IExpr)matrix.getEntry(0, 3), (IExpr)matrix.getEntry(1, 3), (IExpr)matrix.getEntry(2, 3)});
        IExpr yNumerator = LinearAlgebra.determinant3x3((FieldMatrix<IExpr>)yMatrix);
        list.append(F.Divide(yNumerator, denominator));
        FieldMatrix zMatrix = denominatorMatrix.copy();
        zMatrix.setColumn(2, (FieldElement[])new IExpr[]{(IExpr)matrix.getEntry(0, 3), (IExpr)matrix.getEntry(1, 3), (IExpr)matrix.getEntry(2, 3)});
        IExpr zNumerator = LinearAlgebra.determinant3x3((FieldMatrix<IExpr>)zMatrix);
        list.append(F.Divide(zNumerator, denominator));
        return list;
    }

    public static IExpr determinant2x2(FieldMatrix<IExpr> matrix) {
        IExpr[] row1 = (IExpr[])matrix.getRow(0);
        IExpr[] row2 = (IExpr[])matrix.getRow(1);
        return F.evalExpand(row1[0].times(row2[1]).subtract(row1[1].times(row2[0])));
    }

    public static IExpr determinant3x3(FieldMatrix<IExpr> matrix) {
        IExpr[] row1 = (IExpr[])matrix.getRow(0);
        IExpr[] row2 = (IExpr[])matrix.getRow(1);
        IExpr[] row3 = (IExpr[])matrix.getRow(2);
        return F.evalExpand(row1[0].times(row2[1].times(row3[2])).subtract(row1[0].times(row2[2].times(row3[1]))).subtract(row1[1].times(row2[0].times(row3[2]))).plus(row1[1].times(row2[2].times(row3[0]))).plus(row1[2].times(row2[0].times(row3[1]))).subtract(row1[2].times(row2[1].times(row3[0]))));
    }

    private static IAST diagonalMatrix(IExpr[] valueArray, int dimension) {
        int[] indexArray = new int[]{dimension, dimension};
        IndexTableGenerator generator = new IndexTableGenerator(indexArray, S.List, new IndexFunctionDiagonal(valueArray));
        IAST matrix = (IAST)generator.table();
        matrix.isMatrix(true);
        return matrix;
    }

    public static IntArrayList dimensions(IAST ast) {
        return LinearAlgebra.dimensionsRecursive(ast, ast.head(), Integer.MAX_VALUE, false, new IntArrayList());
    }

    public static IntArrayList dimensions(IAST ast, IExpr header) {
        return LinearAlgebra.dimensions(ast, header, Integer.MAX_VALUE);
    }

    public static IntArrayList dimensions(IAST ast, IExpr header, int maxLevel) {
        return LinearAlgebra.dimensionsRecursive(ast, header, maxLevel, false, new IntArrayList());
    }

    public static IntArrayList dimensions(IExpr expr, IExpr header, int maxLevel, boolean throwIllegalArgumentException) {
        if (expr.isAST()) {
            return LinearAlgebra.dimensionsRecursive((IAST)expr, header, maxLevel, throwIllegalArgumentException, new IntArrayList());
        }
        if (expr.isSparseArray()) {
            int[] dims = ((ISparseArray)expr).getDimension();
            if (dims.length > maxLevel) {
                IntArrayList list = new IntArrayList(maxLevel);
                if (throwIllegalArgumentException) {
                    throw new IllegalArgumentException();
                }
                for (int i = 0; i < maxLevel; ++i) {
                    list.add(dims[i]);
                }
                return list;
            }
            IntArrayList list = new IntArrayList(dims.length);
            for (int i = 0; i < dims.length; ++i) {
                list.add(dims[i]);
            }
            return list;
        }
        return new IntArrayList();
    }

    private static IntArrayList dimensionsRecursive(IAST ast, IExpr header, int maxLevel, boolean throwIllegalArgumentException, IntArrayList dims) throws IllegalArgumentException {
        int size = ast.size();
        if (header.equals(ast.head())) {
            dims.add(size - 1);
            if (size > 1) {
                if (ast.arg1().isAST()) {
                    IAST arg1AST = (IAST)ast.arg1();
                    int arg1Size = arg1AST.size();
                    if (header.equals(S.List) ? !arg1AST.isSparseArray() && !header.equals(arg1AST.head()) : !header.equals(arg1AST.head())) {
                        return LinearAlgebra.checkRectangularDimensions(ast, header, throwIllegalArgumentException, dims);
                    }
                    if (maxLevel > 0) {
                        for (int i = 2; i < size; ++i) {
                            IExpr arg = ast.get(i);
                            if (header.equals(S.List) ? !arg.isSparseArray() && !header.equals(arg.head()) : !header.equals(arg.head())) {
                                return LinearAlgebra.checkRectangularDimensions(ast, header, throwIllegalArgumentException, dims);
                            }
                            if ((arg.isAST() || arg.isSparseArray()) && arg1Size == arg.size()) continue;
                            return LinearAlgebra.checkRectangularDimensions(ast, header, throwIllegalArgumentException, dims);
                        }
                        return LinearAlgebra.dimensionsRecursive(arg1AST, header, maxLevel - 1, throwIllegalArgumentException, dims);
                    }
                }
                return LinearAlgebra.checkRectangularDimensions(ast, header, throwIllegalArgumentException, dims);
            }
        }
        return dims;
    }

    private static IntArrayList checkRectangularDimensions(IAST ast, IExpr header, boolean throwIllegalArgumentException, IntArrayList dims) throws IllegalArgumentException {
        if (throwIllegalArgumentException) {
            for (int i = 1; i < ast.size(); ++i) {
                IExpr arg = ast.get(i);
                if (arg.isSparseArray() && arg.isList() || arg.isNumericArray()) {
                    throw new IllegalArgumentException();
                }
                if (!header.equals(arg.head())) continue;
                throw new IllegalArgumentException();
            }
        }
        return dims;
    }

    public static void initialize() {
        Initializer.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IExpr linearSolve(LinearSolveFunctionExpr<?> linearSolveFunction, IExpr vectorOrMatrix, IAST ast, EvalEngine engine) {
        int vectorSize = vectorOrMatrix.isVector();
        if (vectorSize < 1) {
            int[] dims = vectorOrMatrix.isMatrix();
            if (dims == null) {
                return F.NIL;
            }
            if (linearSolveFunction.isComplexNumeric()) {
                FieldDecompositionSolver data = (FieldDecompositionSolver)linearSolveFunction.toData();
                if (data.isNonSingular()) {
                    if (dims[0] != data.getRowDimension()) {
                        return IOFunctions.printMessage(ast.topHead(), "lslc", F.CEmptyList, engine);
                    }
                    FieldMatrix<Complex> matrix = Convert.list2ComplexMatrix(vectorOrMatrix);
                    if (matrix == null) {
                        return F.NIL;
                    }
                    FieldMatrix resultVector = data.solve(matrix);
                    return Convert.complexMatrix2List((FieldMatrix<Complex>)resultVector);
                }
            } else {
                long oldPrecision = engine.getNumericPrecision();
                long precision = linearSolveFunction.getNumericPrecision();
                try {
                    FieldDecompositionSolver data2;
                    if (precision > oldPrecision) {
                        engine.setNumericPrecision(precision);
                    }
                    if ((data2 = (FieldDecompositionSolver)linearSolveFunction.toData()).isNonSingular()) {
                        if (dims[0] != data2.getRowDimension()) {
                            IAST iAST = IOFunctions.printMessage(ast.topHead(), "lslc", F.CEmptyList, engine);
                            return iAST;
                        }
                        FieldMatrix<IExpr> matrix = Convert.list2Matrix(vectorOrMatrix);
                        if (matrix == null) {
                            IAssociation iAssociation = F.NIL;
                            return iAssociation;
                        }
                        FieldMatrix resultVector = data2.solve(matrix);
                        IASTAppendable iASTAppendable = Convert.matrix2List((FieldMatrix<IExpr>)resultVector);
                        return iASTAppendable;
                    }
                }
                finally {
                    engine.setNumericPrecision(oldPrecision);
                }
            }
            return F.NIL;
        }
        if (linearSolveFunction.isComplexNumeric()) {
            FieldDecompositionSolver data = (FieldDecompositionSolver)linearSolveFunction.toData();
            if (data.isNonSingular()) {
                if (vectorSize != data.getRowDimension()) {
                    return IOFunctions.printMessage(ast.topHead(), "lslc", F.CEmptyList, engine);
                }
                FieldVector<Complex> vector = Convert.list2ComplexVector(vectorOrMatrix);
                if (vector == null) {
                    return F.NIL;
                }
                FieldVector resultVector = data.solve(vector);
                return Convert.complexVector2List((FieldVector<Complex>)resultVector);
            }
        } else {
            long oldPrecision = engine.getNumericPrecision();
            long precision = linearSolveFunction.getNumericPrecision();
            try {
                FieldDecompositionSolver data;
                if (precision > oldPrecision) {
                    engine.setNumericPrecision(precision);
                }
                if ((data = (FieldDecompositionSolver)linearSolveFunction.toData()).isNonSingular()) {
                    if (vectorSize != data.getRowDimension()) {
                        IAST data2 = IOFunctions.printMessage(ast.topHead(), "lslc", F.CEmptyList, engine);
                        return data2;
                    }
                    FieldVector<IExpr> vector = Convert.list2Vector(vectorOrMatrix);
                    if (vector == null) {
                        IAssociation matrix = F.NIL;
                        return matrix;
                    }
                    FieldVector resultVector = data.solve(vector);
                    IAST iAST = Convert.vector2List((FieldVector<IExpr>)resultVector);
                    return iAST;
                }
            }
            finally {
                engine.setNumericPrecision(oldPrecision);
            }
        }
        return F.NIL;
    }

    public static IAST rowReduced2List(FieldMatrix<IExpr> matrix, boolean quiet, EvalEngine engine) {
        IAST list;
        int rows = matrix.getRowDimension();
        int cols = matrix.getColumnDimension();
        if (rows == 2 && cols == 3 ? (list = LinearAlgebra.cramersRule2x3(matrix, quiet, engine)).isPresent() : rows == 3 && cols == 4 && (list = LinearAlgebra.cramersRule3x4(matrix, quiet, engine)).isPresent()) {
            return list;
        }
        FieldReducedRowEchelonForm ref = new FieldReducedRowEchelonForm(matrix, AbstractMatrix1Expr.POSSIBLE_ZEROQ_TEST);
        FieldMatrix<IExpr> rowReduced = ref.getRowReducedMatrix();
        IExpr lastVarCoefficient = (IExpr)rowReduced.getEntry(rows - 1, cols - 2);
        if (lastVarCoefficient.isZero() && !((IExpr)rowReduced.getEntry(rows - 1, cols - 1)).isZero()) {
            LOGGER.log(engine.getLogLevel(), "Row reduced linear equations have no solution.");
            return F.NIL;
        }
        IASTAppendable list2 = F.ListAlloc(rows < cols - 1 ? cols - 1 : rows);
        list2.appendArgs(0, rows, j -> S.Together.of(engine, (IExpr)rowReduced.getEntry(j, cols - 1)));
        if (rows < cols - 1) {
            list2.appendArgs(rows, cols - 1, i -> F.C0);
        }
        return list2;
    }

    public static IAST rowReduced2RulesList(FieldMatrix<IExpr> matrix, IAST listOfVariables, IASTAppendable resultList, EvalEngine engine) {
        int rows = matrix.getRowDimension();
        int cols = matrix.getColumnDimension();
        IExpr smallList = null;
        if (rows == 2 && cols == 3) {
            smallList = LinearAlgebra.cramersRule2x3(matrix, true, engine);
        } else if (rows == 3 && cols == 4) {
            smallList = LinearAlgebra.cramersRule3x4(matrix, true, engine);
        }
        if (smallList != null) {
            if (!smallList.isPresent()) {
                return F.CEmptyList;
            }
            IExpr sList = smallList;
            int size = smallList.size();
            IASTAppendable list = F.ListAlloc(size);
            list.appendArgs(size, arg_0 -> LinearAlgebra.lambda$rowReduced2RulesList$2(listOfVariables, engine, (IAST)sList, arg_0));
            resultList.append(list);
            return resultList;
        }
        FieldReducedRowEchelonForm ref = new FieldReducedRowEchelonForm(matrix, AbstractMatrix1Expr.POSSIBLE_ZEROQ_TEST);
        FieldMatrix<IExpr> rowReduced = ref.getRowReducedMatrix();
        int size = listOfVariables.argSize();
        IExpr lastVarCoefficient = (IExpr)rowReduced.getEntry(rows - 1, cols - 2);
        if (lastVarCoefficient.isZero() && !((IExpr)rowReduced.getEntry(rows - 1, cols - 1)).isZero()) {
            return F.CEmptyList;
        }
        IASTAppendable list = F.ListAlloc(rows);
        for (int j = 1; j < rows + 1; ++j) {
            IExpr diagonal;
            if (j >= size + 1 || (diagonal = (IExpr)rowReduced.getEntry(j - 1, j - 1)).isZero()) continue;
            IASTAppendable plus = F.PlusAlloc(cols);
            plus.append((IExpr)rowReduced.getEntry(j - 1, cols - 1));
            for (int i = j; i < cols - 1; ++i) {
                if (((IExpr)rowReduced.getEntry(j - 1, i)).isZero()) continue;
                plus.append(F.Times(((IExpr)rowReduced.getEntry(j - 1, i)).negate(), listOfVariables.get(i + 1)));
            }
            IAST rule = F.Rule(listOfVariables.get(j), S.Together.of(engine, plus.oneIdentity0()));
            list.append(rule);
        }
        resultList.append(list);
        return resultList;
    }

    private LinearAlgebra() {
    }

    private static /* synthetic */ IExpr lambda$rowReduced2RulesList$2(IAST listOfVariables, EvalEngine engine, IAST sList, int j) {
        return F.Rule(listOfVariables.get(j), engine.evaluate(sList.get(j)));
    }

    private static class VectorAngle
    extends AbstractFunctionEvaluator {
        private VectorAngle() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            int dim1 = arg1.isVector();
            int dim2 = arg2.isVector();
            if (dim1 > -1 && dim2 > -1) {
                return F.ArcCos(F.Divide(F.Dot(arg1, (IExpr)F.Conjugate(arg2)), F.Times((IExpr)F.Norm(arg1), (IExpr)F.Norm(arg2))));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class VandermondeMatrix
    extends AbstractFunctionEvaluator {
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList()) {
                IAST lst = (IAST)ast.arg1();
                int len0 = lst.argSize();
                int[] indexArray = new int[]{len0, len0};
                IndexTableGenerator generator = new IndexTableGenerator(indexArray, S.List, indx -> F.Power(lst.get(indx[0] + 1), F.ZZ(indx[1])));
                IAST matrix = (IAST)generator.table();
                matrix.isMatrix(true);
                return matrix;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class UpperTriangularize
    extends AbstractFunctionEvaluator {
        private UpperTriangularize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int[] dim = ast.arg1().isMatrix(false);
            if (dim == null) {
                return IOFunctions.printMessage(ast.topHead(), "matrix", F.list(ast.arg1(), F.C1), engine);
            }
            int k = ast.size() == 3 ? Validate.checkIntType(ast, 2, Integer.MIN_VALUE) : 0;
            int m = dim[0];
            int n = dim[1];
            FieldMatrix<IExpr> matrix = Convert.list2Matrix(ast.arg1());
            return F.matrix((i, j) -> i <= j - k ? (IExpr)matrix.getEntry(i, j) : F.C0, m, n);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class UnitVector
    extends AbstractFunctionEvaluator {
        private UnitVector() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.isAST2()) {
                int n = arg1.toIntDefault();
                if (n <= 0) {
                    if (n == Integer.MIN_VALUE && !arg1.isInteger()) {
                        return F.NIL;
                    }
                    return IOFunctions.printMessage(S.UnitVector, "intpm", F.list(ast, F.C1), engine);
                }
                int k = ast.arg2().toIntDefault();
                if (k <= 0) {
                    if (k == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    return IOFunctions.printMessage(S.UnitVector, "intpm", F.list(ast, F.C2), engine);
                }
                if (k <= n) {
                    IASTAppendable vector = F.ListAlloc(n);
                    vector.appendArgs(0, n, i -> F.C0);
                    vector.set(k, F.C1);
                    return vector;
                }
                return F.NIL;
            }
            if (arg1.isInteger()) {
                int k = arg1.toIntDefault();
                if (k <= 0) {
                    return IOFunctions.printMessage(S.UnitVector, "intpm", F.list(ast, F.C1), engine);
                }
                if (k == 1) {
                    return F.list(F.C1, F.C0);
                }
                if (k == 2) {
                    return F.list(F.C0, F.C1);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class Transpose
    extends AbstractEvaluator {
        private Transpose() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 3) {
                if (ast.arg1().isList() && ast.arg2().isList()) {
                    IAST tensor = (IAST)ast.arg1();
                    IntArrayList dims = LinearAlgebra.dimensions(tensor, tensor.head(), Integer.MAX_VALUE);
                    int[] permutation = Validate.checkListOfInts(ast, ast.arg2(), 1, dims.size(), engine);
                    if (permutation == null) {
                        return F.NIL;
                    }
                    return new TransposePermute(tensor, (IntList)dims, permutation).transposeRecursive();
                }
                return F.NIL;
            }
            int[] dim = ast.arg1().isMatrix();
            if (dim != null) {
                FieldMatrix<IExpr> matrix = Convert.list2Matrix(ast.arg1());
                if (matrix != null) {
                    FieldMatrix transposed = matrix.transpose();
                    IExpr transposedMatrix = Convert.matrix2Expr((FieldMatrix<IExpr>)transposed).mapExpr(x -> this.transform((IExpr)x));
                    transposedMatrix.isMatrix(true);
                    return transposedMatrix;
                }
                if (dim[1] == 0) {
                    return F.CEmptyList;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        protected IExpr transform(IExpr expr) {
            return expr;
        }

        private IAST transpose(IAST matrix, int rows, int cols) {
            IASTMutable transposedMatrix = F.astMutable(S.List, cols);
            transposedMatrix.setArgs(cols + 1, i -> F.astMutable(S.List, rows));
            for (int i2 = 1; i2 <= rows; ++i2) {
                IAST originalRow = (IAST)matrix.get(i2);
                for (int j = 1; j <= cols; ++j) {
                    IASTMutable transposedResultRow = (IASTMutable)transposedMatrix.get(j);
                    transposedResultRow.set(i2, this.transform(originalRow.get(j)));
                }
            }
            transposedMatrix.isMatrix(true);
            return transposedMatrix;
        }

        private static class TransposePermute {
            final IAST tensor;
            final int[] dimensions;
            final int[] permutation;
            int[] positions;

            private TransposePermute(IAST tensor, IntList tensorDimensions, int[] permutation) {
                this.tensor = tensor;
                this.dimensions = new int[tensorDimensions.size()];
                for (int i = 0; i < tensorDimensions.size(); ++i) {
                    this.dimensions[i] = tensorDimensions.getInt(i);
                }
                this.permutation = permutation;
                this.positions = new int[this.dimensions.length];
            }

            private IAST transposeRecursive() {
                return this.transposeRecursive(0, null);
            }

            private IAST transposeRecursive(int permutationIndex, IASTAppendable resultList) {
                if (permutationIndex >= this.permutation.length) {
                    if (resultList != null) {
                        resultList.append(this.tensor.getPart(this.positions));
                    }
                } else {
                    int size = this.dimensions[this.permutation[permutationIndex] - 1];
                    IASTAppendable list = F.ListAlloc(size);
                    if (resultList != null) {
                        resultList.append(list);
                    }
                    for (int i = 0; i < size; ++i) {
                        this.positions[this.permutation[permutationIndex] - 1] = i + 1;
                        this.transposeRecursive(permutationIndex + 1, list);
                    }
                    return list;
                }
                return F.NIL;
            }
        }
    }

    private static class Tr
    extends AbstractEvaluator {
        private Tr() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr header = S.Plus;
            int level = -1;
            if (ast.size() > 2) {
                header = ast.arg2();
            }
            try {
                IntArrayList dimensions = LinearAlgebra.dimensions(arg1, S.List, Integer.MAX_VALUE, true);
                int dimsSize = dimensions.size();
                if (dimsSize == 0) {
                    return F.NIL;
                }
                if (ast.isAST3()) {
                    level = ast.arg3().toIntDefault();
                    if (level == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    return F.NIL;
                }
                int minLength = Integer.MAX_VALUE;
                for (int i = 0; i < dimsSize; ++i) {
                    if (minLength <= dimensions.getInt(i)) continue;
                    minLength = dimensions.getInt(i);
                }
                if (arg1.isSparseArray()) {
                    ISparseArray tensor = (ISparseArray)arg1;
                    int[] part = new int[dimsSize];
                    IASTMutable tr = F.astMutable(header, minLength++);
                    for (int d = 1; d < minLength; ++d) {
                        for (int i = 0; i < dimsSize; ++i) {
                            part[i] = d;
                        }
                        tr.set(d, tensor.getIndex(part));
                    }
                    return tr;
                }
                IAST tensor = (IAST)arg1.normal(false);
                int[] part = new int[dimsSize];
                IASTMutable tr = F.astMutable(header, minLength++);
                for (int d = 1; d < minLength; ++d) {
                    for (int i = 0; i < dimsSize; ++i) {
                        part[i] = d;
                    }
                    tr.set(d, tensor.getPart(part));
                }
                return tr;
            }
            catch (IllegalArgumentException iae) {
                return IOFunctions.printMessage(ast.topHead(), "rect", F.list(ast), engine);
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class ToPolarCoordinates
    extends AbstractEvaluator {
        private ToPolarCoordinates() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            int dim = arg1.isVector();
            if (dim > 0) {
                if (arg1.isAST()) {
                    IAST list = (IAST)arg1;
                    if (dim == 2) {
                        IExpr x = list.arg1();
                        IExpr y = list.arg2();
                        return F.list(F.Sqrt(F.Plus((IExpr)F.Sqr(x), (IExpr)F.Sqr(y))), F.ArcTan(x, y));
                    }
                    if (dim == 3) {
                        IExpr x = list.arg1();
                        IExpr y = list.arg2();
                        IExpr z = list.arg3();
                        IAST sqrtExpr = F.Sqrt(F.Plus((IExpr)F.Sqr(x), (IExpr)F.Sqr(y), (IExpr)F.Sqr(z)));
                        return F.list(sqrtExpr, F.ArcCos(F.Divide(x, sqrtExpr)), F.ArcTan(y, z));
                    }
                } else {
                    FieldVector<IExpr> vector = Convert.list2Vector(arg1);
                    if (dim == 2) {
                        IExpr x = (IExpr)vector.getEntry(0);
                        IExpr y = (IExpr)vector.getEntry(1);
                        return F.list(F.Sqrt(F.Plus((IExpr)F.Sqr(x), (IExpr)F.Sqr(y))), F.ArcTan(x, y));
                    }
                    if (dim == 3) {
                        IExpr x = (IExpr)vector.getEntry(0);
                        IExpr y = (IExpr)vector.getEntry(1);
                        IExpr z = (IExpr)vector.getEntry(2);
                        IAST sqrtExpr = F.Sqrt(F.Plus((IExpr)F.Sqr(x), (IExpr)F.Sqr(y), (IExpr)F.Sqr(z)));
                        return F.list(sqrtExpr, F.ArcCos(F.Divide(x, sqrtExpr)), F.ArcTan(y, z));
                    }
                }
            } else if (arg1.isList()) {
                IAST list = (IAST)arg1;
                return list.mapThreadEvaled(engine, F.ListAlloc(list.size()), ast, 1);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class ToeplitzMatrix
    extends AbstractFunctionEvaluator {
        private ToeplitzMatrix() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2()) {
                if (ast.arg1().isList() && ast.arg2().isList()) {
                    IAST vector1 = (IAST)ast.arg1();
                    IAST vector2 = (IAST)ast.arg2();
                    int numberOfRows = vector1.argSize();
                    int numberOfColumns = vector2.argSize();
                    return F.matrix((i, j) -> i <= j ? vector2.get(j - i + 1) : vector1.get(i - j + 1), numberOfRows, numberOfColumns);
                }
                return F.NIL;
            }
            if (ast.arg1().isList()) {
                IAST vector = (IAST)ast.arg1();
                int m = vector.argSize();
                return F.matrix((i, j) -> i <= j ? vector.get(j - i + 1) : vector.get(i - j + 1), m, m);
            }
            if (ast.arg1().isInteger()) {
                int m = ast.arg1().toIntDefault();
                if (m < 0) {
                    return IOFunctions.printMessage(S.ToeplitzMatrix, "intpm", F.list(ast, F.C1), engine);
                }
                int[] count = new int[]{1};
                return F.matrix((i, j) -> i <= j ? F.ZZ(j - i + 1) : F.ZZ(i - j + 1), m, m);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class SingularValueList
    extends AbstractFunctionEvaluator {
        private SingularValueList() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr m;
            IExpr singularValueList;
            int vectorLength;
            int[] dim = ast.arg1().isMatrix();
            if (dim != null && dim[0] > 0 && dim[1] > 0 && (vectorLength = (singularValueList = engine.evaluate(F.Sqrt(F.Eigenvalues(F.Dot((IExpr)F.ConjugateTranspose(m = ast.arg1()), m))))).isVector()) > 0) {
                singularValueList = ((IAST)singularValueList).filter(x -> this.keepSingularValue((IExpr)x, engine))[0];
                int n = singularValueList.argSize();
                if (ast.isAST2() && (n = ast.arg2().toIntDefault()) <= 0) {
                    return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast, F.C2), engine);
                }
                return S.TakeLargestBy.of(engine, singularValueList, S.Abs, F.ZZ(n));
            }
            return F.NIL;
        }

        private boolean keepSingularValue(IExpr singularValue, EvalEngine engine) {
            double y = engine.evalDouble(F.Abs(singularValue));
            return !F.isZero(y, Config.DEFAULT_ROOTS_CHOP_DELTA);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class SingularValueDecomposition
    extends AbstractFunctionEvaluator {
        private SingularValueDecomposition() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                RealMatrix matrix = ast.arg1().toRealMatrix();
                if (matrix != null) {
                    org.hipparchus.linear.SingularValueDecomposition svd = new org.hipparchus.linear.SingularValueDecomposition(matrix);
                    return F.list(new ASTRealMatrix(svd.getU(), false), new ASTRealMatrix(svd.getS(), false), new ASTRealMatrix(svd.getV(), false));
                }
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.debug("SingularValueDecomposition.evaluate() failed", (Throwable)e);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class RowReduce
    extends AbstractFunctionEvaluator {
        private RowReduce() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            boolean togetherMode = engine.isTogetherMode();
            try {
                FieldMatrix<IExpr> matrix;
                engine.setTogetherMode(true);
                int[] dims = ast.arg1().isMatrix();
                if (dims != null && (matrix = Convert.list2Matrix(ast.arg1())) != null) {
                    Predicate<IExpr> zeroChecker = AbstractMatrix1Expr.optionZeroTest(ast, 2, engine);
                    FieldReducedRowEchelonForm fmw = new FieldReducedRowEchelonForm(matrix, zeroChecker);
                    IASTAppendable iASTAppendable = Convert.matrix2List(fmw.getRowReducedMatrix());
                    return iASTAppendable;
                }
            }
            catch (ClassCastException | IndexOutOfBoundsException e) {
                LOGGER.debug("RowReduce.evaluate() failed", (Throwable)e);
            }
            finally {
                engine.setTogetherMode(togetherMode);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class RiccatiSolve
    extends AbstractEvaluator {
        private RiccatiSolve() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().argSize() == 2 && ast.arg1().isListOfMatrices() && ast.arg2().argSize() == 2 && ast.arg2().isListOfMatrices()) {
                try {
                    RealMatrix R;
                    RealMatrix Q;
                    RealMatrix B;
                    IAST list1 = (IAST)ast.arg1();
                    IAST list2 = (IAST)ast.arg2();
                    RealMatrix A = list1.arg1().toRealMatrix();
                    if (A != null && (B = list1.arg2().toRealMatrix()) != null && (Q = list2.arg1().toRealMatrix()) != null && (R = list2.arg2().toRealMatrix()) != null) {
                        RiccatiEquationSolverImpl solver = new RiccatiEquationSolverImpl(A, B, Q, R);
                        RealMatrix result = solver.getP();
                        return new ASTRealMatrix(result, false);
                    }
                }
                catch (MathRuntimeException mrex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)mrex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class QRDecomposition
    extends AbstractFunctionEvaluator {
        private QRDecomposition() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            boolean togetherMode = engine.isTogetherMode();
            try {
                engine.setTogetherMode(true);
                IExpr arg1 = ast.arg1();
                int[] dim = arg1.isMatrix();
                if (dim != null) {
                    FieldMatrix<IExpr> matrix;
                    if (engine.isSymbolicMode(S.QRDecomposition.getAttributes()) && (matrix = Convert.list2Matrix(arg1)) != null) {
                        IAssociation r;
                        engine.setTogetherMode(true);
                        FieldQRDecomposition ed = new FieldQRDecomposition(matrix);
                        FieldMatrix q = ed.getQ();
                        if (Convert.matrix2List((FieldMatrix<IExpr>)q) != null) {
                            q = q.transpose();
                            r = ed.getR();
                            if (Convert.matrix2List((FieldMatrix<IExpr>)r) != null) {
                                IAST iAST = F.list(Convert.matrix2List((FieldMatrix<IExpr>)q), Convert.matrix2List((FieldMatrix<IExpr>)r));
                                return iAST;
                            }
                        }
                        r = F.NIL;
                        return r;
                    }
                    if (engine.isArbitraryMode() && (matrix = Convert.list2Matrix(arg1)) != null) {
                        Object r;
                        engine.setTogetherMode(true);
                        FieldQRDecomposition ed = new FieldQRDecomposition(matrix);
                        FieldMatrix q = ed.getQ();
                        if (Convert.matrix2List((FieldMatrix<IExpr>)q) != null && Convert.matrix2List((FieldMatrix<IExpr>)(r = ed.getR())) != null) {
                            IAST iAST = F.list(Convert.matrix2List((FieldMatrix<IExpr>)q), Convert.matrix2List((FieldMatrix<IExpr>)r));
                            return iAST;
                        }
                        r = F.NIL;
                        return r;
                    }
                    FieldMatrix<Complex> complexMatrix = Convert.list2ComplexMatrix(arg1);
                    if (complexMatrix != null) {
                        FieldMatrix r;
                        FieldQRDecomposition ed = new FieldQRDecomposition(complexMatrix);
                        FieldMatrix q = ed.getQ();
                        if (Convert.complexMatrix2List((FieldMatrix<Complex>)q) != null && Convert.complexMatrix2List((FieldMatrix<Complex>)(r = ed.getR())) != null) {
                            IAST iAST = F.list(Convert.complexMatrix2List((FieldMatrix<Complex>)q), Convert.complexMatrix2List((FieldMatrix<Complex>)r));
                            return iAST;
                        }
                        IAssociation iAssociation = F.NIL;
                        return iAssociation;
                    }
                }
            }
            catch (ClassCastException | IndexOutOfBoundsException e) {
                LOGGER.debug("QRDecomposition.evaluate() failed", (Throwable)e);
            }
            finally {
                engine.setTogetherMode(togetherMode);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class PseudoInverse
    extends AbstractMatrix1Matrix {
        protected static final PseudoInverse CONST = new PseudoInverse();

        private PseudoInverse() {
        }

        @Override
        public int[] checkMatrixDimensions(IExpr arg1) {
            return Convert.checkNonEmptyRectangularMatrix(S.PseudoInverse, arg1);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return this.numericEval(ast, engine);
        }

        @Override
        public FieldMatrix<IExpr> matrixEval(FieldMatrix<IExpr> matrix, Predicate<IExpr> zeroChecker) {
            return null;
        }

        @Override
        public RealMatrix realMatrixEval(RealMatrix matrix) {
            org.hipparchus.linear.SingularValueDecomposition lu = new org.hipparchus.linear.SingularValueDecomposition(matrix);
            DecompositionSolver solver = lu.getSolver();
            return solver.getInverse();
        }
    }

    private static class Projection
    extends AbstractEvaluator {
        private Projection() {
        }

        private static IExpr dotProduct(IExpr head, IExpr u, IExpr v, EvalEngine engine) {
            return engine.evaluate(F.binaryAST2(head, u, v));
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int dim1 = ast.arg1().isVector();
            int dim2 = ast.arg2().isVector();
            if (ast.size() == 4) {
                FieldVector<IExpr> v;
                FieldVector<IExpr> u;
                IExpr head = ast.arg3();
                if (dim1 >= 0 && dim1 == dim2) {
                    if (dim1 == 0) {
                        return F.CEmptyList;
                    }
                    if (head.equals(S.Dot)) {
                        u = Convert.list2Vector(ast.arg1());
                        v = Convert.list2Vector(ast.arg2());
                        if (u != null && v != null) {
                            return Convert.vector2List((FieldVector<IExpr>)u.projection(v));
                        }
                    }
                }
                u = ast.arg1();
                v = ast.arg2();
                return v.times(Projection.dotProduct(head, (IExpr)u, (IExpr)v, engine).divide(Projection.dotProduct(head, v, v, engine)));
            }
            if (dim1 >= 0 && dim1 == dim2) {
                if (dim1 == 0) {
                    return F.CEmptyList;
                }
                FieldVector<IExpr> u = Convert.list2Vector(ast.arg1());
                FieldVector<IExpr> v = Convert.list2Vector(ast.arg2());
                FieldVector vConjugate = v.copy();
                for (int i = 0; i < dim2; ++i) {
                    vConjugate.setEntry(i, (FieldElement)((IExpr)vConjugate.getEntry(i)).conjugate());
                }
                return Convert.vector2List((FieldVector<IExpr>)v.mapMultiply((FieldElement)((IExpr)u.dotProduct(vConjugate)).divide((IExpr)v.dotProduct(vConjugate))));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class PauliMatrix
    extends AbstractFunctionEvaluator {
        private PauliMatrix() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isInteger()) {
                int m = ast.arg1().toIntDefault();
                if (m < 0) {
                    return F.NIL;
                }
                switch (m) {
                    case 0: {
                        return F.list(F.list(F.C1, F.C0), F.list(F.C0, F.C1));
                    }
                    case 1: {
                        return F.list(F.list(F.C0, F.C1), F.list(F.C1, F.C0));
                    }
                    case 2: {
                        return F.list(F.list(F.C0, F.CNI), F.list(F.CI, F.C0));
                    }
                    case 3: {
                        return F.list(F.list(F.C1, F.C0), F.list(F.C0, F.CN1));
                    }
                    case 4: {
                        return F.list(F.list(F.C1, F.C0), F.list(F.C0, F.C1));
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Orthogonalize
    extends AbstractEvaluator {
        static IBuiltInSymbol oneStep = F.localBiFunction("oneStep", (vec, vecmat) -> {
            if (vecmat.isEmptyList()) {
                return vec;
            }
            IAST function = F.Function(F.Plus((IExpr)F.Slot1, (IExpr)F.Times(F.CN1, F.Dot(vec, (IExpr)F.Slot2), F.Power((IExpr)F.Dot((IExpr)F.Slot2, (IExpr)F.Slot2), F.CN1), F.Slot2)));
            return F.eval(F.Fold(function, vec, vecmat));
        });

        private Orthogonalize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            int[] dim = arg1.isMatrix();
            if (dim != null) {
                IAST result = F.Map(F.Function(F.Normalize(F.Slot1)), F.Fold(F.Function(F.Append(F.Slot1, F.binaryAST2((IExpr)oneStep, F.Slot2, (IExpr)F.Slot1))), F.CEmptyList, arg1));
                return engine.evaluate(result);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class NullSpace
    extends AbstractFunctionEvaluator {
        private NullSpace() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            boolean togetherMode = engine.isTogetherMode();
            try {
                FieldMatrix<IExpr> matrix;
                engine.setTogetherMode(true);
                int[] dims = ast.arg1().isMatrix();
                if (dims != null && (matrix = Convert.list2Matrix(ast.arg1())) != null) {
                    FieldReducedRowEchelonForm fmw = new FieldReducedRowEchelonForm(matrix, AbstractMatrix1Expr.POSSIBLE_ZEROQ_TEST);
                    FieldMatrix<IExpr> nullspace = fmw.getNullSpace(F.CN1);
                    if (nullspace == null) {
                        IAST iAST = F.CEmptyList;
                        return iAST;
                    }
                    IASTAppendable list2 = Convert.matrix2List(nullspace);
                    EvalAttributes.sort(list2, Comparators.REVERSE_CANONICAL_COMPARATOR);
                    IASTAppendable iASTAppendable = list2;
                    return iASTAppendable;
                }
            }
            catch (ClassCastException | IndexOutOfBoundsException | MathRuntimeException e) {
                LOGGER.debug("NullSpace.evaluate() failed", e);
            }
            finally {
                engine.setTogetherMode(togetherMode);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class Normalize
    extends AbstractEvaluator {
        private Normalize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1;
            IExpr normFunction = S.Norm;
            if (ast.isAST2()) {
                normFunction = ast.arg2();
            }
            if ((arg1 = ast.arg1()).isEmptyList() && ast.isAST1()) {
                return arg1;
            }
            IExpr norm = engine.evaluate(F.unaryAST1(normFunction, ast.arg1()));
            if (norm.isZero()) {
                return arg1;
            }
            return F.Divide(ast.arg1(), norm);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Norm
    extends AbstractEvaluator {
        private Norm() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            int dim = arg1.isVector();
            if (dim > -1) {
                if (dim == 0) {
                    return IOFunctions.printMessage(ast.topHead(), "nvm", F.CEmptyList, engine);
                }
                if ((arg1 = arg1.normal(false)).isList()) {
                    IAST vector = (IAST)arg1;
                    if (ast.isAST2()) {
                        IExpr p = ast.arg2();
                        if (p.isString("Frobenius")) {
                            return F.Norm(vector);
                        }
                        if (p.isInfinity()) {
                            return vector.map(S.Max, x -> F.Abs(x));
                        }
                        if (p.isSymbol() || p.isReal()) {
                            if (p.isZero()) {
                                LOGGER.log(engine.getLogLevel(), "Norm: 0 not allowed as second argument!");
                                return F.NIL;
                            }
                            if (p.isReal() && p.lessThan(F.C1).isTrue()) {
                                LOGGER.log(engine.getLogLevel(), "Norm: Second argument is < 1!");
                                return F.NIL;
                            }
                            return F.Power((IExpr)vector.map(S.Plus, x -> F.Power((IExpr)F.Abs(x), p)), p.inverse());
                        }
                        return F.NIL;
                    }
                    return F.Sqrt(vector.map(S.Plus, x -> F.Sqr(F.Abs(x))));
                }
                return F.NIL;
            }
            int[] matrixDim = arg1.isMatrix();
            if (matrixDim != null) {
                if (matrixDim[1] == 0) {
                    return IOFunctions.printMessage(ast.topHead(), "nvm", F.CEmptyList, engine);
                }
                try {
                    RealMatrix matrix = arg1.toRealMatrix();
                    if (matrix != null) {
                        if (ast.isAST2() && ast.arg2().isString("Frobenius")) {
                            return F.Norm(F.Flatten(arg1));
                        }
                        if (matrixDim[0] < matrixDim[1]) {
                            int d = matrixDim[0];
                            matrixDim[0] = matrixDim[1];
                            matrixDim[1] = d;
                            matrix = matrix.transpose();
                        }
                        org.hipparchus.linear.SingularValueDecomposition svd = new org.hipparchus.linear.SingularValueDecomposition(matrix);
                        RealMatrix sSVD = svd.getS();
                        IASTAppendable result = F.ast((IExpr)S.Max, matrixDim[1]);
                        for (int i = 0; i < matrixDim[1]; ++i) {
                            result.append(sSVD.getEntry(i, i));
                        }
                        return result;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    LOGGER.debug("Norm.evaluate() failed", (Throwable)e);
                }
            }
            if (arg1.isNumber()) {
                if (ast.isAST2()) {
                    return F.NIL;
                }
                return ((INumber)arg1).abs();
            }
            if (arg1.isNumericFunction(true) && !arg1.isList()) {
                if (ast.isAST2()) {
                    return F.NIL;
                }
                return F.Abs(arg1);
            }
            return IOFunctions.printMessage(ast.topHead(), "nvm", F.CEmptyList, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Minors
    extends AbstractFunctionEvaluator {
        private Minors() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            int[] dims = arg1.isMatrix();
            if (dims != null) {
                if (dims[0] != dims[1]) {
                    return F.NIL;
                }
                if (dims[0] <= 1) {
                    return F.NIL;
                }
                if (arg1.isSparseArray()) {
                    arg1 = arg1.normal(false);
                }
                int n = dims[0];
                IAST matrix = (IAST)arg1;
                IASTAppendable result = F.ListAlloc(n + 1);
                for (int i = 1; i <= n; ++i) {
                    IASTAppendable row = F.ListAlloc(n + 1);
                    for (int j = 1; j <= n; ++j) {
                        IExpr det = engine.evaluate(F.Det(F.Drop(matrix, F.list(F.ZZ(n - i + 1)), F.list(F.ZZ(n - j + 1)))));
                        row.append(det);
                    }
                    result.append(row);
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class MatrixRank
    extends AbstractFunctionEvaluator {
        private MatrixRank() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                FieldMatrix<IExpr> matrix;
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isMatrix() != null && (matrix = Convert.list2Matrix(arg1)) != null) {
                    Predicate<IExpr> zeroChecker = AbstractMatrix1Expr.optionZeroTest(ast, 2, engine);
                    FieldReducedRowEchelonForm fmw = new FieldReducedRowEchelonForm(matrix, zeroChecker);
                    return F.ZZ(fmw.getMatrixRank());
                }
            }
            catch (ClassCastException | IndexOutOfBoundsException e) {
                LOGGER.debug("MatrixRank.evaluate() failed", (Throwable)e);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class MatrixPower
    extends AbstractFunctionEvaluator {
        private MatrixPower() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            boolean togetherMode = engine.isTogetherMode();
            try {
                engine.setTogetherMode(true);
                IExpr arg1 = ast.arg1();
                IExpr arg2 = ast.arg2();
                int[] dimensions = arg1.isMatrix(false);
                if (dimensions != null && dimensions[1] > 0 && dimensions[0] > 0) {
                    FieldMatrix resultMatrix;
                    FieldMatrix matrix = Convert.list2Matrix(arg1);
                    if (matrix == null) {
                        IAssociation iAssociation = F.NIL;
                        return iAssociation;
                    }
                    int p = arg2.toIntDefault();
                    if (p == Integer.MIN_VALUE) {
                        IAssociation iAssociation = F.NIL;
                        return iAssociation;
                    }
                    if (p == 1) {
                        ((IAST)arg1).addEvalFlags(32);
                        IExpr iExpr = arg1;
                        return iExpr;
                    }
                    if (p == 0) {
                        BlockFieldMatrix resultMatrix2 = new BlockFieldMatrix(F.EXPR_FIELD, matrix.getRowDimension(), matrix.getColumnDimension());
                        int min = matrix.getRowDimension();
                        if (min > matrix.getColumnDimension()) {
                            min = matrix.getColumnDimension();
                        }
                        for (int i = 0; i < min; ++i) {
                            resultMatrix2.setEntry(i, i, (FieldElement)F.C1);
                        }
                        IASTAppendable i = Convert.matrix2List((FieldMatrix<IExpr>)resultMatrix2);
                        return i;
                    }
                    int iterationLimit = engine.getIterationLimit();
                    if (iterationLimit >= 0 && iterationLimit <= p) {
                        IterationLimitExceeded.throwIt(p, ast);
                    }
                    if (matrix.getRowDimension() != matrix.getColumnDimension()) {
                        IAST i = IOFunctions.printMessage(ast.topHead(), "matsq", F.list(arg1, F.C1), engine);
                        return i;
                    }
                    if (p < 0) {
                        matrix = resultMatrix = Inverse.inverseMatrix(matrix, x -> x.isPossibleZero(false));
                        p *= -1;
                    } else {
                        resultMatrix = matrix;
                    }
                    for (int i = 1; i < p; ++i) {
                        resultMatrix = resultMatrix.multiply(matrix);
                    }
                    IASTAppendable iASTAppendable = Convert.matrix2List(resultMatrix);
                    return iASTAppendable;
                }
                IAssociation iAssociation = F.NIL;
                return iAssociation;
            }
            catch (RuntimeException e) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)e);
                IAssociation iAssociation = F.NIL;
                return iAssociation;
            }
            finally {
                engine.setTogetherMode(togetherMode);
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class MatrixMinimalPolynomial
    extends AbstractFunctionEvaluator {
        private MatrixMinimalPolynomial() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int[] dimensions = ast.arg1().isMatrix(false);
            if (dimensions != null && dimensions[0] == dimensions[1] && dimensions[0] > 0) {
                IExpr matrix = ast.arg1();
                IExpr variable = ast.arg2();
                if (!variable.isVariable()) {
                    return IOFunctions.printMessage(ast.topHead(), "ivar", F.list(variable), engine);
                }
                ISymbol i = F.Dummy("i");
                int n = 1;
                IAST qu = F.CEmptyList;
                IAST mnm = (IAST)engine.evaluate(F.list(F.Flatten(LinearAlgebra.diagonalMatrix(new IExpr[]{F.C0, F.C1}, dimensions[0]))));
                if (!(mnm instanceof IASTAppendable)) {
                    mnm = mnm.copyAppendable();
                }
                while (qu.isEmpty()) {
                    ((IASTAppendable)mnm).append(engine.evaluate(F.Flatten(F.MatrixPower(matrix, F.ZZ(n)))));
                    qu = (IAST)S.NullSpace.of(engine, F.Transpose(mnm));
                    ++n;
                }
                return S.Dot.of(engine, qu.arg1(), F.Table(F.Power(variable, i), F.list(i, F.C0, F.ZZ(--n))));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class MatrixLog
    extends AbstractFunctionEvaluator {
        private MatrixLog() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            RealMatrix matrix;
            int[] dim = ast.arg1().isMatrix();
            if (dim == null || dim[0] != dim[1] || dim[0] <= 0 || (matrix = ast.arg1().toRealMatrix()) != null) {
                // empty if block
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class MatrixFunction
    extends AbstractEvaluator {
        private MatrixFunction() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int[] dimensions = ast.arg2().isMatrix();
            if (dimensions != null && (dimensions[0] == 0 || dimensions[1] == 0)) {
                return ast.arg2();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class MatrixExp
    extends AbstractFunctionEvaluator {
        private MatrixExp() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            RealMatrix matrix;
            int[] dim = ast.arg1().isMatrix();
            if (dim != null && dim[0] == dim[1] && dim[0] > 0 && (matrix = ast.arg1().toRealMatrix()) != null) {
                try {
                    RealMatrix result = MatrixUtils.matrixExponential((RealMatrix)matrix);
                    return new ASTRealMatrix(result, false);
                }
                catch (MathIllegalArgumentException miae) {
                    return IOFunctions.printMessage(ast.topHead(), "error", F.list(F.stringx(miae.getMessage())), engine);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class LUDecomposition
    extends AbstractFunctionEvaluator {
        private LUDecomposition() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            boolean togetherMode = engine.isTogetherMode();
            try {
                engine.setTogetherMode(true);
                int[] dim = ast.arg1().isMatrix();
                if (dim != null && dim[0] > 0 && dim[1] > 0) {
                    if (dim[0] != dim[1]) {
                        IAST iAST = IOFunctions.printMessage(ast.topHead(), "matsq", F.CEmptyList, engine);
                        return iAST;
                    }
                    FieldMatrix<IExpr> matrix = Convert.list2Matrix(ast.arg1());
                    if (matrix != null) {
                        IASTAppendable m2;
                        Predicate<IExpr> zeroChecker = AbstractMatrix1Expr.optionZeroTest(ast, 2, engine);
                        FieldLUDecomposition lu = new FieldLUDecomposition(matrix, zeroChecker, false);
                        FieldMatrix lMatrix = lu.getL();
                        FieldMatrix uMatrix = lu.getU();
                        int[] iArr = lu.getPivot();
                        int size = iArr.length;
                        IASTAppendable iList = F.ListAlloc(size);
                        iList.appendArgs(0, size, i -> F.ZZ(iArr[i] + 1));
                        IASTAppendable m1 = Convert.matrix2List((FieldMatrix<IExpr>)lMatrix);
                        if (m1.isPresent() && (m2 = Convert.matrix2List((FieldMatrix<IExpr>)uMatrix)).isPresent()) {
                            IAST iAST = F.list(m1, m2, iList);
                            return iAST;
                        }
                    }
                }
            }
            catch (ClassCastException | IndexOutOfBoundsException e) {
                LOGGER.debug("LUDecomposition.evaluate() failed", (Throwable)e);
            }
            finally {
                engine.setTogetherMode(togetherMode);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class LowerTriangularize
    extends AbstractFunctionEvaluator {
        private LowerTriangularize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int[] dim = ast.arg1().isMatrix(false);
            if (dim == null) {
                return IOFunctions.printMessage(ast.topHead(), "matrix", F.list(ast.arg1(), F.C1), engine);
            }
            int k = ast.size() == 3 ? Validate.checkIntType(ast, 2, Integer.MIN_VALUE) : 0;
            int m = dim[0];
            int n = dim[1];
            FieldMatrix<IExpr> matrix = Convert.list2Matrix(ast.arg1());
            return F.matrix((i, j) -> i >= j - k ? (IExpr)matrix.getEntry(i, j) : F.C0, m, n);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class LinearSolveFunction
    extends AbstractFunctionEvaluator {
        private LinearSolveFunction() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head() instanceof LinearSolveFunctionExpr && ast.isAST1()) {
                LinearSolveFunctionExpr lsf = (LinearSolveFunctionExpr)ast.head();
                IExpr arg1 = ast.arg1();
                return LinearAlgebra.linearSolve(lsf, arg1, ast, engine);
            }
            return F.NIL;
        }
    }

    private static class LinearSolve
    extends AbstractFunctionEvaluator {
        private LinearSolve() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int[] matrixDims = ast.arg1().isMatrix();
            if (matrixDims != null) {
                boolean togetherMode = engine.isTogetherMode();
                engine.setTogetherMode(true);
                try {
                    LinearSolveFunctionExpr lsf = null;
                    IExpr temp = LinearSolve.createLinearSolveFunction(ast, matrixDims, engine);
                    if (temp instanceof LinearSolveFunctionExpr) {
                        lsf = (LinearSolveFunctionExpr)temp;
                    }
                    if (ast.isAST1()) {
                        IExpr iExpr = temp;
                        return iExpr;
                    }
                    if (lsf != null) {
                        IExpr iExpr = LinearAlgebra.linearSolve(lsf, ast.arg2(), ast, engine);
                        return iExpr;
                    }
                }
                catch (RuntimeException e) {
                    LOGGER.debug("LinearSolve.evaluate() failed", (Throwable)e);
                }
                finally {
                    engine.setTogetherMode(togetherMode);
                }
                try {
                    FieldMatrix<IExpr> matrix = Convert.list2Matrix(ast.arg1());
                    if (ast.arg2().isVector() >= 0) {
                        FieldVector<IExpr> vector = Convert.list2Vector(ast.arg2());
                        if (matrix != null && vector != null) {
                            if (matrixDims[0] > matrixDims[1]) {
                                if (vector.getDimension() == matrix.getRowDimension() && vector.getDimension() <= matrix.getColumnDimension()) {
                                    return this.underdeterminedSystem(matrix, vector, engine);
                                }
                                LOGGER.log(engine.getLogLevel(), "LinearSolve: first argument is not a square matrix.");
                                return F.NIL;
                            }
                            if (vector.getDimension() != matrix.getRowDimension()) {
                                LOGGER.log(engine.getLogLevel(), "LinearSolve: matrix row and vector have different dimensions.");
                                return F.NIL;
                            }
                            if (matrixDims[0] == 1 && matrixDims[1] >= 1) {
                                IExpr temp = this.eval1x1Matrix(matrix, vector, engine);
                                if (temp.isPresent()) {
                                    return temp;
                                }
                                return this.underdeterminedSystem(matrix, vector, engine);
                            }
                            if (matrixDims[0] == 2 && matrixDims[1] == 2) {
                                IExpr temp = this.eval2x2Matrix(matrix, vector, engine);
                                if (temp.isPresent()) {
                                    return temp;
                                }
                                return this.underdeterminedSystem(matrix, vector, engine);
                            }
                            if (matrixDims[0] == 3 && matrixDims[1] == 3) {
                                IExpr temp = this.eval3x3Matrix(matrix, vector, engine);
                                if (temp.isPresent()) {
                                    return temp;
                                }
                                return this.underdeterminedSystem(matrix, vector, engine);
                            }
                            if (matrixDims[0] != matrixDims[1]) {
                                return this.underdeterminedSystem(matrix, vector, engine);
                            }
                            Predicate<IExpr> zeroChecker = AbstractMatrix1Expr.optionZeroTest(ast, 3, engine);
                            FieldDecompositionSolver solver = new FieldLUDecomposition(matrix, zeroChecker, false).getSolver();
                            if (solver.isNonSingular()) {
                                FieldVector resultVector = solver.solve(vector);
                                for (int i = 0; i < resultVector.getDimension(); ++i) {
                                    if (!((IExpr)resultVector.getEntry(i)).isIndeterminate() && !((IExpr)resultVector.getEntry(i)).isDirectedInfinity()) continue;
                                    return this.underdeterminedSystem(matrix, vector, engine);
                                }
                                return Convert.vector2List((FieldVector<IExpr>)resultVector);
                            }
                            return this.underdeterminedSystem(matrix, vector, engine);
                        }
                    }
                }
                catch (LimitException le) {
                    throw le;
                }
                catch (RuntimeException e) {
                    LOGGER.debug("LinearSolve.evaluate() failed", (Throwable)e);
                }
            }
            return F.NIL;
        }

        private static IExpr createLinearSolveFunction(IAST ast, int[] matrixDims, EvalEngine engine) {
            Predicate<Complex> zeroChecker;
            FieldDecompositionSolver solver;
            if (matrixDims[0] > matrixDims[1]) {
                LOGGER.log(engine.getLogLevel(), "LinearSolve: first argument is not a square matrix.");
                return F.NIL;
            }
            FieldMatrix<IExpr> matrix = Convert.list2Matrix(ast.arg1(), true);
            if (matrix != null) {
                Predicate<IExpr> zeroChecker2 = AbstractMatrix1Expr.optionZeroTest(ast, 2, engine);
                FieldDecompositionSolver solver2 = new FieldLUDecomposition(matrix, zeroChecker2, false).getSolver();
                if (solver2.isNonSingular()) {
                    return LinearSolveFunctionExpr.createIExpr((FieldDecompositionSolver<IExpr>)solver2, engine.getNumericPrecision());
                }
                if (ast.isAST1()) {
                    return IOFunctions.printMessage(ast.topHead(), "sing1", F.list(ast.arg1()), engine);
                }
                return F.NIL;
            }
            FieldMatrix<Complex> complexMatrix = Convert.list2ComplexMatrix(ast.arg1());
            if (complexMatrix != null && (solver = new FieldLUDecomposition(complexMatrix, zeroChecker = c -> F.isZero(c), true).getSolver()).isNonSingular()) {
                return LinearSolveFunctionExpr.createComplex((FieldDecompositionSolver<Complex>)solver);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        private IExpr underdeterminedSystem(FieldMatrix<IExpr> matrix, FieldVector<IExpr> vector, EvalEngine engine) {
            FieldMatrix<IExpr> augmentedMatrix = Convert.augmentedFieldMatrix(matrix, vector);
            if (augmentedMatrix != null) {
                return LinearAlgebra.rowReduced2List(augmentedMatrix, true, engine);
            }
            return F.NIL;
        }

        private IExpr eval1x1Matrix(FieldMatrix<IExpr> matrix, FieldVector<IExpr> vector, EvalEngine engine) {
            IExpr temp;
            IASTAppendable result = F.ListAlloc(matrix.getColumnDimension());
            IExpr a = (IExpr)matrix.getEntry(0, 0);
            IExpr x = (IExpr)vector.getEntry(0);
            IAST row = F.Divide(x, a);
            result.append(row);
            if (matrix.getColumnDimension() > 1) {
                for (int i = 1; i < matrix.getColumnDimension(); ++i) {
                    result.append(F.C0);
                }
            }
            if ((temp = engine.evalQuiet(result)).isAST()) {
                IAST ast = (IAST)temp;
                for (int k = 1; k < ast.size(); ++k) {
                    if (!ast.get(k).isIndeterminate() && !ast.get(k).isDirectedInfinity()) continue;
                    return F.NIL;
                }
            }
            return temp;
        }

        private IExpr eval2x2Matrix(FieldMatrix<IExpr> matrix, FieldVector<IExpr> vector, EvalEngine engine) {
            IExpr temp;
            IASTAppendable result = F.ListAlloc(matrix.getColumnDimension());
            IExpr a = (IExpr)matrix.getEntry(0, 0);
            IExpr b = (IExpr)matrix.getEntry(0, 1);
            IExpr c = (IExpr)matrix.getEntry(1, 0);
            IExpr d = (IExpr)matrix.getEntry(1, 1);
            IExpr x = (IExpr)vector.getEntry(0);
            IExpr y = (IExpr)vector.getEntry(1);
            IASTMutable row = F.Times(F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, b, c), (IExpr)F.Times(a, d)), -1L), (IExpr)F.Plus((IExpr)F.Times(d, x), (IExpr)F.Times((IExpr)F.CN1, b, y)));
            result.append(row);
            row = F.Times(F.Power((IExpr)F.Plus((IExpr)F.Times(b, c), (IExpr)F.Times((IExpr)F.CN1, a, d)), -1L), (IExpr)F.Plus((IExpr)F.Times(c, x), (IExpr)F.Times((IExpr)F.CN1, a, y)));
            result.append(row);
            if (matrix.getColumnDimension() > 2) {
                for (int i = 2; i < matrix.getColumnDimension(); ++i) {
                    result.append(F.C0);
                }
            }
            if ((temp = engine.evalQuiet(result)).isAST()) {
                IAST ast = (IAST)temp;
                for (int k = 1; k < ast.size(); ++k) {
                    if (!ast.get(k).isIndeterminate() && !ast.get(k).isDirectedInfinity()) continue;
                    return F.NIL;
                }
            }
            return temp;
        }

        private IExpr eval3x3Matrix(FieldMatrix<IExpr> matrix, FieldVector<IExpr> vector, EvalEngine engine) {
            IExpr temp;
            IASTAppendable result = F.ListAlloc(matrix.getColumnDimension());
            IExpr a = (IExpr)matrix.getEntry(0, 0);
            IExpr b = (IExpr)matrix.getEntry(0, 1);
            IExpr c = (IExpr)matrix.getEntry(0, 2);
            IExpr d = (IExpr)matrix.getEntry(1, 0);
            IExpr e = (IExpr)matrix.getEntry(1, 1);
            IExpr f = (IExpr)matrix.getEntry(1, 2);
            IExpr g = (IExpr)matrix.getEntry(2, 0);
            IExpr h = (IExpr)matrix.getEntry(2, 1);
            IExpr i = (IExpr)matrix.getEntry(2, 2);
            IExpr x = (IExpr)vector.getEntry(0);
            IExpr y = (IExpr)vector.getEntry(1);
            IExpr z = (IExpr)vector.getEntry(2);
            IASTMutable row = F.Times(F.Power((IExpr)F.Plus(F.Times(c, e, g), F.Times(F.CN1, b, f, g), F.Times(F.CN1, c, d, h), F.Times(a, f, h), F.Times(b, d, i), F.Times(F.CN1, a, e, i)), -1L), (IExpr)F.Plus(F.Times(f, h, x), F.Times(F.CN1, e, i, x), F.Times(F.CN1, c, h, y), F.Times(b, i, y), F.Times(c, e, z), F.Times(F.CN1, b, f, z)));
            result.append(row);
            row = F.Times(F.Power((IExpr)F.Plus(F.Times(c, e, g), F.Times(F.CN1, b, f, g), F.Times(F.CN1, c, d, h), F.Times(a, f, h), F.Times(b, d, i), F.Times(F.CN1, a, e, i)), -1L), (IExpr)F.Plus(F.Times(F.CN1, f, g, x), F.Times(d, i, x), F.Times(c, g, y), F.Times(F.CN1, a, i, y), F.Times(F.CN1, c, d, z), F.Times(a, f, z)));
            result.append(row);
            row = F.Times(F.Power((IExpr)F.Plus(F.Times(c, e, g), F.Times(F.CN1, b, f, g), F.Times(F.CN1, c, d, h), F.Times(a, f, h), F.Times(b, d, i), F.Times(F.CN1, a, e, i)), -1L), (IExpr)F.Plus(F.Times(e, g, x), F.Times(F.CN1, d, h, x), F.Times(F.CN1, b, g, y), F.Times(a, h, y), F.Times(b, d, z), F.Times(F.CN1, a, e, z)));
            result.append(row);
            if (matrix.getColumnDimension() > 3) {
                for (int k = 3; k < matrix.getColumnDimension(); ++k) {
                    result.append(F.C0);
                }
            }
            if ((temp = engine.evalQuiet(result)).isAST()) {
                IAST ast = (IAST)temp;
                for (int k = 1; k < ast.size(); ++k) {
                    if (!ast.get(k).isIndeterminate() && !ast.get(k).isDirectedInfinity()) continue;
                    return F.NIL;
                }
            }
            return temp;
        }
    }

    private static class LeastSquares
    extends AbstractFunctionEvaluator {
        private LeastSquares() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isMatrix() != null && ast.arg2().isVector() >= 0) {
                IAST matrix = (IAST)ast.arg1().normal(false);
                IAST vector = (IAST)ast.arg2().normal(false);
                if (matrix.isList() && vector.isList()) {
                    try {
                        if (matrix.isNumericMode() || vector.isNumericMode()) {
                            RealVector realVector;
                            RealMatrix realMatrix = ast.arg1().toRealMatrix();
                            if (realMatrix != null && (realVector = ast.arg2().toRealVector()) != null && (realMatrix = PseudoInverse.CONST.realMatrixEval(realMatrix)) != null) {
                                return new ASTRealVector(realMatrix.operate(realVector), false);
                            }
                            return F.NIL;
                        }
                    }
                    catch (MathIllegalArgumentException miae) {
                        return IOFunctions.printMessage(ast.topHead(), "error", F.list(F.$str(miae.getMessage())), engine);
                    }
                    catch (MathRuntimeException mre) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)mre);
                        return F.NIL;
                    }
                    catch (ClassCastException | IndexOutOfBoundsException e) {
                        LOGGER.debug("LeastSquares.evaluate() failed", (Throwable)e);
                    }
                    try {
                        IAST matrixTransposed = (IAST)S.ConjugateTranspose.of(engine, matrix);
                        return F.Expand(F.LinearSolve(F.ConjugateTranspose(F.Dot((IExpr)matrixTransposed, (IExpr)matrix)), F.Dot((IExpr)matrixTransposed, (IExpr)vector)));
                    }
                    catch (ClassCastException | IndexOutOfBoundsException e) {
                        LOGGER.debug("LeastSquares.evaluate() failed", (Throwable)e);
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class JacobiMatrix
    extends AbstractFunctionEvaluator {
        private JacobiMatrix() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isVector() >= 0) {
                IAST variables = F.NIL;
                if (ast.arg2().isSymbol()) {
                    variables = F.CEmptyList;
                } else if (ast.arg2().isList() && ast.arg2().size() > 1) {
                    variables = (IAST)ast.arg2();
                }
                if (variables.isPresent()) {
                    int variablesSize = variables.size();
                    if (ast.arg1().isAST()) {
                        IAST vector = (IAST)ast.arg1();
                        int vectorSize = vector.size();
                        IASTAppendable jacobiMatrix = F.ListAlloc(vectorSize);
                        IAST vars = variables;
                        return jacobiMatrix.appendArgs(vectorSize, i -> {
                            IASTAppendable jacobiRow = F.ListAlloc(variablesSize);
                            return jacobiRow.appendArgs(variablesSize, j -> F.D(vector.get(i), vars.get(j)));
                        });
                    }
                    FieldVector<IExpr> vector = Convert.list2Vector(ast.arg1());
                    if (vector != null) {
                        int vectorSize = vector.getDimension();
                        IASTAppendable jacobiMatrix = F.ListAlloc(vectorSize);
                        IAST vars = variables;
                        return jacobiMatrix.appendArgs(vectorSize, i -> {
                            IASTAppendable jacobiRow = F.ListAlloc(variablesSize);
                            return jacobiRow.appendArgs(variablesSize, j -> F.D((IExpr)vector.getEntry(i), vars.get(j)));
                        });
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class Inverse
    extends AbstractMatrix1Matrix {
        private Inverse() {
        }

        @Override
        public int[] checkMatrixDimensions(IExpr arg1) {
            return Convert.checkNonEmptySquareMatrix(S.Inverse, arg1);
        }

        public static FieldMatrix<IExpr> inverseMatrix(FieldMatrix<IExpr> matrix, Predicate<IExpr> zeroChecker) {
            FieldLUDecomposition lu = new FieldLUDecomposition(matrix, zeroChecker, false);
            FieldDecompositionSolver solver = lu.getSolver();
            if (!solver.isNonSingular()) {
                IOFunctions.printMessage(S.Inverse, "sing", F.list(Convert.matrix2List(matrix, false)), EvalEngine.get());
                return null;
            }
            return solver.getInverse();
        }

        @Override
        public FieldMatrix<IExpr> matrixEval(FieldMatrix<IExpr> matrix, Predicate<IExpr> zeroChecker) {
            return Inverse.inverseMatrix(matrix, zeroChecker);
        }

        @Override
        public RealMatrix realMatrixEval(RealMatrix matrix) {
            org.hipparchus.linear.LUDecomposition lu = new org.hipparchus.linear.LUDecomposition(matrix);
            DecompositionSolver solver = lu.getSolver();
            if (!solver.isNonSingular()) {
                IOFunctions.printMessage(S.Inverse, "sing", F.list(Convert.matrix2List(matrix, false)), EvalEngine.get());
                return null;
            }
            return solver.getInverse();
        }
    }

    private static class Inner
    extends AbstractFunctionEvaluator {
        private Inner() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2 = ast.arg2();
            IExpr arg3 = ast.arg3();
            if ((arg2.isAST() || arg2.isSparseArray()) && (arg3.isAST() || arg3.isSparseArray())) {
                int dimSize2;
                IExpr f = ast.arg1();
                IAST list1 = (IAST)arg2.normal(false);
                IAST list2 = (IAST)arg3.normal(false);
                IExpr g = ast.isAST3() ? S.Plus : ast.arg4();
                IExpr head2 = list2.head();
                if (!list1.head().equals(head2)) {
                    return F.NIL;
                }
                IntArrayList dim1 = LinearAlgebra.dimensions(list1);
                IntArrayList dim2 = LinearAlgebra.dimensions(list2);
                if (dim1.size() == 0) {
                    return IOFunctions.printMessage(S.Inner, "normal", F.list(F.C2, list1), EvalEngine.get());
                }
                if (dim2.size() == 0) {
                    return IOFunctions.printMessage(S.Inner, "normal", F.list(F.C3, list2), EvalEngine.get());
                }
                int dimSize1 = dim1.getInt(dim1.size() - 1);
                if (dimSize1 != (dimSize2 = dim2.getInt(0))) {
                    return IOFunctions.printMessage(S.Inner, "incom", F.List(F.ZZ(dimSize1), F.ZZ(dim1.size()), list1, F.C1, F.ZZ(dimSize2), list2), EvalEngine.get());
                }
                InnerAlgorithm ic = new InnerAlgorithm(f, list1, list2, g);
                return ic.inner();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_4;
        }

        private static class InnerAlgorithm {
            final IExpr f;
            final IExpr g;
            final IExpr head;
            final IAST list1;
            final IAST list2;
            int list2Dim0;

            private InnerAlgorithm(IExpr f, IAST list1, IAST list2, IExpr g) {
                this.f = f;
                this.list1 = list1;
                this.list2 = list2;
                this.g = g;
                this.head = list2.head();
            }

            private IAST inner() {
                IntArrayList list1Dimensions = LinearAlgebra.dimensions(this.list1, this.list1.head(), Integer.MAX_VALUE);
                IntArrayList list2Dimensions = LinearAlgebra.dimensions(this.list2, this.list2.head(), Integer.MAX_VALUE);
                this.list2Dim0 = list2Dimensions.getInt(0);
                return this.recursionInner((IntList)new IntArrayList(), (IntList)new IntArrayList(), list1Dimensions.subList(0, list1Dimensions.size() - 1), list2Dimensions.subList(1, list2Dimensions.size()));
            }

            private IAST recursionInner(IntList list1Cur, IntList list2Cur, IntList list1RestDimensions, IntList list2RestDimensions) {
                if (list1RestDimensions.size() > 0) {
                    int size = list1RestDimensions.getInt(0) + 1;
                    IASTAppendable newResult = F.ast(this.head, size);
                    for (int i2 = 1; i2 < size; ++i2) {
                        IntArrayList list1CurClone = new IntArrayList(list1Cur);
                        list1CurClone.add(i2);
                        IAST recursionInner = this.recursionInner((IntList)list1CurClone, list2Cur, list1RestDimensions.subList(1, list1RestDimensions.size()), list2RestDimensions);
                        if (!recursionInner.isPresent()) {
                            return F.NIL;
                        }
                        newResult.append(recursionInner);
                    }
                    return newResult;
                }
                if (list2RestDimensions.size() > 0) {
                    int size = list2RestDimensions.getInt(0) + 1;
                    IASTAppendable newResult = F.ast(this.head, size);
                    for (int i3 = 1; i3 < size; ++i3) {
                        IntArrayList list2CurClone = new IntArrayList(list2Cur);
                        list2CurClone.add(i3);
                        IAST recursionInner = this.recursionInner(list1Cur, (IntList)list2CurClone, list1RestDimensions, list2RestDimensions.subList(1, list2RestDimensions.size()));
                        if (!recursionInner.isPresent()) {
                            return F.NIL;
                        }
                        newResult.append(recursionInner);
                    }
                    return newResult;
                }
                try {
                    int size = this.list2Dim0 + 1;
                    IASTAppendable part = F.ast(this.g, size);
                    return part.appendArgs(size, i -> this.summand(list1Cur, list2Cur, i));
                }
                catch (IndexOutOfBoundsException ioobe) {
                    return IOFunctions.printMessage(S.Inner, "incom", F.CEmptyList, EvalEngine.get());
                }
            }

            private IAST summand(IntList list1Cur, IntList list2Cur, int i) {
                IASTAppendable result = F.ast(this.f, 2);
                IntArrayList list1CurClone = new IntArrayList(list1Cur);
                list1CurClone.add(i);
                result.append(this.list1.getPart((IntList)list1CurClone));
                IntArrayList list2CurClone = new IntArrayList(list2Cur);
                list2CurClone.add(0, i);
                result.append(this.list2.getPart((IntList)list2CurClone));
                return result;
            }
        }
    }

    private static class IdentityMatrix
    extends AbstractFunctionEvaluator {
        private IdentityMatrix() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isInteger()) {
                int m = ast.arg1().toIntDefault();
                if (m < 0) {
                    return IOFunctions.printMessage(S.IdentityMatrix, "intpm", F.list(ast, F.C1), engine);
                }
                if (ast.isAST2()) {
                    if (ast.arg2().equals(S.SparseArray)) {
                        int[] dimension = new int[]{m, m};
                        return F.sparseArray(F.list(F.Rule((IExpr)F.List(F.i_, F.i_), (IExpr)F.C1)), dimension);
                    }
                    return F.NIL;
                }
                return F.matrix((i, j) -> i == j ? F.C1 : F.C0, m, m);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class HilbertMatrix
    extends AbstractFunctionEvaluator {
        private HilbertMatrix() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int rowSize = 0;
            int columnSize = 0;
            if (ast.isAST1() && ast.arg1().isInteger()) {
                rowSize = ast.arg1().toIntDefault();
                if (rowSize < 0) {
                    return IOFunctions.printMessage(S.HilbertMatrix, "intpm", F.list(ast, F.C1), engine);
                }
                columnSize = rowSize;
            } else if (ast.isAST2() && ast.arg1().isInteger() && ast.arg2().isInteger()) {
                rowSize = ast.arg1().toIntDefault();
                if (rowSize < 0) {
                    return IOFunctions.printMessage(S.HilbertMatrix, "intpm", F.list(ast, F.C1), engine);
                }
                columnSize = ast.arg2().toIntDefault();
                if (columnSize < 0) {
                    return IOFunctions.printMessage(S.HilbertMatrix, "intpm", F.list(ast, F.C2), engine);
                }
            } else {
                return F.NIL;
            }
            return F.matrix((i, j) -> F.QQ(1L, i + j + 1), rowSize, columnSize);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class FromPolarCoordinates
    extends AbstractEvaluator {
        private FromPolarCoordinates() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            int dim = arg1.isVector();
            if (dim > 0) {
                if (arg1.isAST()) {
                    IAST list = (IAST)arg1;
                    if (dim == 2) {
                        IExpr r = list.arg1();
                        IExpr theta = list.arg2();
                        return F.list(F.Times(r, (IExpr)F.Cos(theta)), F.Times(r, (IExpr)F.Sin(theta)));
                    }
                    if (dim == 3) {
                        IExpr r = list.arg1();
                        IExpr theta = list.arg2();
                        IExpr phi = list.arg3();
                        return F.list(F.Times(r, (IExpr)F.Cos(theta)), F.Times(r, (IExpr)F.Cos(phi), (IExpr)F.Sin(theta)), F.Times(r, (IExpr)F.Sin(theta), (IExpr)F.Sin(phi)));
                    }
                } else {
                    FieldVector<IExpr> vector = Convert.list2Vector(arg1);
                    if (dim == 2) {
                        IExpr r = (IExpr)vector.getEntry(0);
                        IExpr theta = (IExpr)vector.getEntry(1);
                        return F.list(F.Times(r, (IExpr)F.Cos(theta)), F.Times(r, (IExpr)F.Sin(theta)));
                    }
                    if (dim == 3) {
                        IExpr r = (IExpr)vector.getEntry(0);
                        IExpr theta = (IExpr)vector.getEntry(1);
                        IExpr phi = (IExpr)vector.getEntry(2);
                        return F.list(F.Times(r, (IExpr)F.Cos(theta)), F.Times(r, (IExpr)F.Cos(phi), (IExpr)F.Sin(theta)), F.Times(r, (IExpr)F.Sin(theta), (IExpr)F.Sin(phi)));
                    }
                }
            } else if (arg1.isList()) {
                return ((IAST)arg1).mapThreadEvaled(engine, F.ListAlloc(ast.size()), ast, 1);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class FourierMatrix
    extends AbstractFunctionEvaluator {
        private FourierMatrix() {
        }

        private static IExpr unit(IExpr arg) {
            return F.Plus((IExpr)F.Cos(arg), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Sin(arg)));
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isInteger()) {
                int m = ast.arg1().toIntDefault();
                if (m <= 0) {
                    return IOFunctions.printMessage(S.FourierMatrix, "intpm", F.list(ast, F.C1), engine);
                }
                IAST scalar = F.Sqrt(F.QQ(1L, m));
                return F.matrix((i, j) -> FourierMatrix.unit(F.QQ(2L * (long)i * (long)j, m).times(S.Pi)).times(scalar), m, m);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class Eigenvectors
    extends AbstractMatrix1Expr {
        private Eigenvectors() {
        }

        @Override
        public int[] checkMatrixDimensions(IExpr arg1) {
            return Convert.checkNonEmptySquareMatrix(S.Eigenvectors, arg1);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 2) {
                try {
                    int[] dim = ast.arg1().isMatrix();
                    if (dim != null) {
                        FieldMatrix<IExpr> matrix;
                        if (dim[0] == 1 && dim[1] == 1) {
                            return F.C1;
                        }
                        if (dim[0] == 2 && dim[1] == 2 && (matrix = Convert.list2Matrix(ast.arg1())) != null) {
                            if (((IExpr)matrix.getEntry(1, 0)).isZero()) {
                                if (((IExpr)matrix.getEntry(0, 0)).equals(matrix.getEntry(1, 1))) {
                                    return F.List(F.List(F.C1, F.C0), F.List(F.C0, F.C0));
                                }
                                return F.List(F.List(F.C1, F.C0), F.List(F.Divide(F.Negate((IExpr)matrix.getEntry(0, 1)), F.Subtract((IExpr)matrix.getEntry(0, 0), (IExpr)matrix.getEntry(1, 1))), F.C1));
                            }
                            IAST sqrtExpr = F.Sqrt(F.Plus(F.Sqr((IExpr)matrix.getEntry(0, 0)), F.Times((IExpr)F.C4, (IExpr)matrix.getEntry(0, 1), (IExpr)matrix.getEntry(1, 0)), F.Times((IExpr)F.CN2, (IExpr)matrix.getEntry(0, 0), (IExpr)matrix.getEntry(1, 1)), F.Sqr((IExpr)matrix.getEntry(1, 1))));
                            return F.List(F.List(F.Times((IExpr)F.CN1D2, (IExpr)F.Power((IExpr)matrix.getEntry(1, 0), F.CN1), (IExpr)F.Plus((IExpr)sqrtExpr, F.Negate((IExpr)matrix.getEntry(0, 0)), (IExpr)matrix.getEntry(1, 1))), F.C1), F.List(F.Times((IExpr)F.CN1D2, (IExpr)F.Power((IExpr)matrix.getEntry(1, 0), F.CN1), (IExpr)F.Plus(F.Negate(sqrtExpr), F.Negate((IExpr)matrix.getEntry(0, 0)), (IExpr)matrix.getEntry(1, 1))), F.C1));
                        }
                    }
                }
                catch (MathRuntimeException mre) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)mre);
                    return F.NIL;
                }
                catch (ClassCastException | IndexOutOfBoundsException e) {
                    LOGGER.debug("Eigenvectors.evaluate() failed", (Throwable)e);
                }
            }
            return this.numericEval(ast, engine);
        }

        @Override
        public IExpr matrixEval(FieldMatrix<IExpr> matrix, Predicate<IExpr> zeroChecker) {
            return F.NIL;
        }

        @Override
        public IAST realMatrixEval(RealMatrix matrix) {
            ComplexEigenDecomposition ced = new ComplexEigenDecomposition(matrix);
            int size = matrix.getColumnDimension();
            IASTAppendable list = F.ListAlloc(size);
            for (int j = 0; j < size; ++j) {
                FieldVector rv = ced.getEigenvector(j);
                System.out.println(rv);
                IASTAppendable complexVector2List = Convert.complexVector2List((FieldVector<Complex>)rv);
                list.append(F.Normalize(complexVector2List));
            }
            return list;
        }
    }

    private static class Eigenvalues
    extends AbstractMatrix1Expr {
        private Eigenvalues() {
        }

        @Override
        public int[] checkMatrixDimensions(IExpr arg1) {
            return Convert.checkNonEmptySquareMatrix(S.Eigenvalues, arg1);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr eigenValues;
            if (ast.isAST1() && !engine.isNumericMode()) {
                try {
                    IExpr arg1 = ast.arg1();
                    int[] dim = arg1.isMatrix();
                    if (dim != null) {
                        FieldMatrix<IExpr> matrix;
                        if (dim[0] == 1 && dim[1] == 1) {
                            return F.List(((IAST)arg1).getPart(1, 1));
                        }
                        if (dim[0] == 2 && dim[1] == 2 && (matrix = Convert.list2Matrix(arg1)) != null) {
                            IAST sqrtExpr = F.Sqrt(F.Plus(F.Sqr((IExpr)matrix.getEntry(0, 0)), F.Times((IExpr)F.C4, (IExpr)matrix.getEntry(0, 1), (IExpr)matrix.getEntry(1, 0)), F.Times((IExpr)F.CN2, (IExpr)matrix.getEntry(0, 0), (IExpr)matrix.getEntry(1, 1)), F.Sqr((IExpr)matrix.getEntry(1, 1))));
                            return F.List(F.Times((IExpr)F.C1D2, (IExpr)F.Plus(F.Negate(sqrtExpr), (IExpr)matrix.getEntry(0, 0), (IExpr)matrix.getEntry(1, 1))), F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)sqrtExpr, (IExpr)matrix.getEntry(0, 0), (IExpr)matrix.getEntry(1, 1))));
                        }
                    }
                }
                catch (RuntimeException e) {
                    LOGGER.debug("Eigenvalues.evaluate() failed", (Throwable)e);
                }
            }
            if ((eigenValues = this.numericEval(ast, engine)).isList()) {
                if (ast.isAST2()) {
                    int n = ast.arg2().toIntDefault();
                    if (n < 0) {
                        if (n == Integer.MIN_VALUE) {
                            return F.NIL;
                        }
                        return F.Reverse(F.TakeSmallestBy(eigenValues, S.Abs, F.ZZ(-n)));
                    }
                    return F.TakeLargestBy(eigenValues, S.Abs, F.ZZ(n));
                }
                return eigenValues;
            }
            return F.NIL;
        }

        @Override
        public IExpr matrixEval(FieldMatrix<IExpr> matrix, Predicate<IExpr> zeroChecker) {
            return F.NIL;
        }

        @Override
        public IAST realMatrixEval(RealMatrix matrix) {
            EigenDecomposition ed = new EigenDecomposition(matrix);
            double[] realValues = ed.getRealEigenvalues();
            double[] imagValues = ed.getImagEigenvalues();
            int size = realValues.length;
            IASTAppendable list = F.ListAlloc(size);
            return list.appendArgs(0, size, i -> {
                if (F.isZero(imagValues[i])) {
                    return F.num(realValues[i]);
                }
                return F.complexNum(realValues[i], imagValues[i]);
            });
        }
    }

    private static class Dot
    extends AbstractNonOrderlessArgMultiple {
        private Dot() {
        }

        @Override
        public IExpr evaluateAST1(IAST ast, EvalEngine engine) {
            return ast.arg1();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr e2ObjArg(IAST ast, IExpr arg1, IExpr arg2) {
            if (arg1.size() == 1 && arg2.size() == 1) {
                if (arg1.isList() && arg2.isList()) {
                    return F.C0;
                }
                return F.NIL;
            }
            EvalEngine engine = EvalEngine.get();
            boolean togetherMode = engine.isTogetherMode();
            engine.setTogetherMode(true);
            try {
                IExpr temp = this.numericalDot(arg1, arg2);
                if (temp.isPresent()) {
                    IExpr iExpr = temp;
                    return iExpr;
                }
                IntArrayList dimensions1 = LinearAlgebra.dimensions(arg1, S.List, Integer.MAX_VALUE, true);
                int dims1Size = dimensions1.size();
                if (dims1Size == 0) {
                    IAssociation iAssociation = F.NIL;
                    return iAssociation;
                }
                IntArrayList dimensions2 = LinearAlgebra.dimensions(arg2, S.List, Integer.MAX_VALUE, true);
                int dims2Size = dimensions2.size();
                if (dims2Size == 0) {
                    IAssociation iAssociation = F.NIL;
                    return iAssociation;
                }
                if (dimensions1.getInt(dims1Size - 1) != dimensions2.getInt(0)) {
                    IAST iAST = IOFunctions.printMessage(ast.topHead(), "dotsh", F.list(arg1, arg2), engine);
                    return iAST;
                }
                if (dims1Size == 2) {
                    FieldMatrix<IExpr> matrix0 = Convert.list2Matrix(arg1);
                    if (matrix0 != null) {
                        FieldVector<IExpr> vector1;
                        if (dims2Size == 2) {
                            FieldMatrix<IExpr> matrix1 = Convert.list2Matrix(arg2);
                            if (matrix1 != null) {
                                IExpr iExpr = Convert.matrix2Expr((FieldMatrix<IExpr>)matrix0.multiply(matrix1));
                                return iExpr;
                            }
                        } else if (dims2Size == 1 && (vector1 = Convert.list2Vector(arg2)) != null) {
                            IExpr iExpr = Convert.vector2Expr((FieldVector<IExpr>)matrix0.operate(vector1));
                            return iExpr;
                        }
                    }
                } else if (dims1Size == 1) {
                    int dim = dimensions1.getInt(0);
                    if (dim == 0) {
                        if (arg2.isVector() == 0) {
                            IInteger vector1 = F.C0;
                            return vector1;
                        }
                    } else {
                        FieldVector<IExpr> vector0 = Convert.list2Vector(arg1);
                        if (vector0 != null) {
                            FieldVector<IExpr> vector1;
                            if (dims2Size == 2) {
                                FieldMatrix<IExpr> matrix1 = Convert.list2Matrix(arg2);
                                if (matrix1 != null) {
                                    IExpr iExpr = Convert.vector2Expr((FieldVector<IExpr>)matrix1.preMultiply(vector0));
                                    return iExpr;
                                }
                            } else if (dims2Size == 1 && (vector1 = Convert.list2Vector(arg2)) != null) {
                                IExpr iExpr = (IExpr)vector0.dotProduct(vector1);
                                return iExpr;
                            }
                        }
                    }
                }
                IExpr iExpr = S.Inner.ofNIL(EvalEngine.get(), S.Times, arg1, arg2, S.Plus);
                return iExpr;
            }
            catch (IllegalArgumentException iae) {
                IAST iAST = IOFunctions.printMessage(ast.topHead(), "rect", F.list(ast), engine);
                return iAST;
            }
            catch (RuntimeException e) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)e);
            }
            finally {
                engine.setTogetherMode(togetherMode);
            }
            return F.NIL;
        }

        private IExpr numericalDot(IExpr o0, IExpr o1) throws MathIllegalArgumentException {
            RealVector v0;
            RealMatrix m0;
            RealMatrix m1;
            if (o0.isRealMatrix()) {
                if (o1.isMatrix() != null) {
                    m1 = o1.toRealMatrix();
                    if (m1 != null) {
                        RealMatrix m02 = o0.toRealMatrix();
                        return new ASTRealMatrix(m02.multiply(m1), false);
                    }
                } else if (o1.isVector() != -1 && (m1 = o1.toRealVector()) != null) {
                    RealMatrix m03 = o0.toRealMatrix();
                    return new ASTRealVector(m03.operate((RealVector)m1), false);
                }
            } else if (o0.isRealVector()) {
                RealVector v1;
                if (o1.isMatrix() != null) {
                    m1 = o1.toRealMatrix();
                    if (m1 != null) {
                        RealVector v02 = o0.toRealVector();
                        return new ASTRealVector(m1.preMultiply(v02), false);
                    }
                } else if (o1.isVector() != -1 && (v1 = o1.toRealVector()) != null) {
                    RealVector v03 = o0.toRealVector();
                    return F.num(v03.dotProduct(v1));
                }
            }
            if (o1.isRealMatrix()) {
                if (o0.isMatrix() != null) {
                    m0 = o0.toRealMatrix();
                    if (m0 != null) {
                        RealMatrix m12 = o1.toRealMatrix();
                        return new ASTRealMatrix(m0.multiply(m12), false);
                    }
                } else if (o0.isVector() != -1 && (v0 = o0.toRealVector()) != null) {
                    RealMatrix m13 = o1.toRealMatrix();
                    return new ASTRealVector(m13.preMultiply(v0), false);
                }
            } else if (o1.isRealVector()) {
                if (o0.isMatrix() != null) {
                    m0 = o0.toRealMatrix();
                    if (m0 != null) {
                        RealVector m14 = o1.toRealVector();
                        return new ASTRealVector(m0.operate(m14), false);
                    }
                } else if (o0.isVector() != -1 && (v0 = o0.toRealVector()) != null) {
                    RealVector v1 = o1.toRealVector();
                    if (v0.getDimension() == v1.getDimension()) {
                        return F.num(v0.dotProduct(v1));
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public IExpr numericEval(IAST ast, EvalEngine engine) {
            return this.evaluate(ast, engine);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(9);
        }
    }

    private static class Dimensions
    extends AbstractFunctionEvaluator {
        private Dimensions() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int maximumLevel = Integer.MAX_VALUE;
            if (ast.isAST2() && ast.arg2().isInteger() && (maximumLevel = ast.arg2().toIntDefault()) < 0) {
                return IOFunctions.printMessage(S.Dimensions, "intpm", F.list(ast, F.C2), engine);
            }
            IExpr arg1 = ast.arg1();
            if (arg1.isAST()) {
                if (maximumLevel > 0) {
                    return Dimensions.getDimensions(ast, maximumLevel);
                }
            } else if (arg1.isSparseArray()) {
                if (maximumLevel > 0) {
                    return this.getDimensions(((ISparseArray)arg1).getDimension(), maximumLevel);
                }
            } else if (arg1.isNumericArray() && maximumLevel > 0) {
                return this.getDimensions(((INumericArray)arg1).getDimension(), maximumLevel);
            }
            return F.CEmptyList;
        }

        private static IAST getDimensions(IAST ast, int maximumLevel) {
            IAST list = (IAST)ast.arg1();
            IExpr header = list.head();
            IntArrayList dims = LinearAlgebra.dimensions(list, header, maximumLevel - 1);
            int dimsSize = dims.size();
            IASTAppendable res = F.ListAlloc(dimsSize);
            return res.appendArgs(0, dimsSize, arg_0 -> Dimensions.lambda$getDimensions$0((IntList)dims, arg_0));
        }

        private IExpr getDimensions(int[] dims, int maximumLevel) {
            if (dims.length > maximumLevel) {
                int[] dest = new int[maximumLevel];
                System.arraycopy(dims, 0, dest, 0, maximumLevel);
                return F.ast((ISymbol)S.List, dest);
            }
            return F.ast((ISymbol)S.List, dims);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.AllowedHeads, (IExpr)S.Automatic)));
        }

        private static /* synthetic */ IExpr lambda$getDimensions$0(IntList dims, int i) {
            return F.ZZ(dims.getInt(i));
        }
    }

    private static class DiagonalMatrix
    extends AbstractFunctionEvaluator {
        private DiagonalMatrix() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST vector;
            IExpr arg1 = ast.arg1();
            int dimension = arg1.isVector();
            if (dimension >= 0) {
                if (arg1.isSparseArray()) {
                    ISparseArray sparseArray = (ISparseArray)arg1;
                    int m = sparseArray.getDimension()[0] + 1;
                    int offset = ast.isAST2() ? Validate.checkIntType(ast, 2, Integer.MIN_VALUE) : 0;
                    return F.sparseMatrix((i, j) -> i + offset == j ? sparseArray.get(i + 1) : F.C0, m - 1, m - 1);
                }
                IExpr normal = arg1.normal(false);
                vector = normal.isAST() ? (IAST)normal : F.NIL;
            } else {
                vector = arg1.isAST() ? (IAST)arg1 : F.NIL;
            }
            if (vector.isPresent()) {
                int m = vector.size();
                int offset = ast.isAST2() ? Validate.checkIntType(ast, 2, Integer.MIN_VALUE) : 0;
                return F.matrix((i, j) -> i + offset == j ? vector.get(i + 1) : F.C0, m - 1, m - 1);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Diagonal
    extends AbstractEvaluator {
        private Diagonal() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isList() || arg1.isSparseArray()) {
                int diff = 0;
                if (ast.size() > 2 && (diff = ast.arg2().toIntDefault()) == Integer.MIN_VALUE) {
                    return F.NIL;
                }
                if (arg1.isList()) {
                    IExpr arg;
                    IAST list = (IAST)arg1;
                    IASTAppendable result = F.ListAlloc(list.argSize());
                    for (int i = 1; i < list.size() && (arg = list.get(i)).isList(); ++i) {
                        IAST subList = (IAST)arg;
                        int indx = i + diff;
                        if (indx <= 0 || indx > subList.argSize()) continue;
                        result.append(subList.get(indx));
                    }
                    return result;
                }
                if (arg1.isSparseArray()) {
                    ISparseArray sparseArray = (ISparseArray)arg1;
                    int[] dims = sparseArray.getDimension();
                    if (dims.length == 1) {
                        return F.CEmptyList;
                    }
                    if (dims.length >= 2) {
                        IExpr arg;
                        int rowLength = dims[0];
                        int colLength = dims[1];
                        IASTAppendable result = F.ListAlloc(rowLength);
                        for (int i = 1; i <= rowLength && (arg = sparseArray.get(i)).isSparseArray(); ++i) {
                            ISparseArray subList = (ISparseArray)arg;
                            int indx = i + diff;
                            if (indx <= 0 || indx > colLength) continue;
                            result.append(subList.get(indx));
                        }
                        return result;
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Det
    extends AbstractMatrix1Expr {
        private Det() {
        }

        @Override
        public int[] checkMatrixDimensions(IExpr arg1) {
            return Convert.checkNonEmptySquareMatrix(S.Det, arg1);
        }

        @Override
        public IExpr matrixEval(FieldMatrix<IExpr> matrix, Predicate<IExpr> zeroChecker) {
            if (matrix.getRowDimension() == 2 && matrix.getColumnDimension() == 2) {
                return LinearAlgebra.determinant2x2(matrix);
            }
            if (matrix.getRowDimension() == 3 && matrix.getColumnDimension() == 3) {
                return LinearAlgebra.determinant3x3(matrix);
            }
            FieldLUDecomposition lu = new FieldLUDecomposition(matrix, zeroChecker, false);
            return F.evalExpand((IExpr)lu.getDeterminant());
        }

        @Override
        public IExpr realMatrixEval(RealMatrix matrix) {
            org.hipparchus.linear.LUDecomposition lu = new org.hipparchus.linear.LUDecomposition(matrix);
            return F.num(lu.getDeterminant());
        }
    }

    private static class DesignMatrix
    extends AbstractEvaluator {
        private DesignMatrix() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr m = ast.arg1();
            IExpr f = ast.arg2();
            IExpr x = ast.arg3();
            if (f.isList()) {
                if (x.isAtom()) {
                    return F.DesignMatrix(m, F.list(f), F.ConstantArray(x, F.ZZ(((IAST)f).argSize())));
                }
                if (x.isList()) {
                    return F.Map(F.Function(F.Prepend(F.MapThread(F.Function(F.List(S.g, S.y, S.r), F.ReplaceAll(S.g, F.Rule((IExpr)S.y, (IExpr)S.r))), F.List(f, x, F.Most(F.Slot1))), F.C1)), m);
                }
            } else if (x.isAtom()) {
                return F.DesignMatrix(m, F.list(f), F.list(x));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Cross
    extends AbstractFunctionEvaluator {
        private Cross() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.isAST2()) {
                IExpr arg2 = ast.arg2();
                int dim1 = arg1.isVector();
                int dim2 = arg2.isVector();
                if (dim1 == 2 && dim2 == 2) {
                    IAST v1 = (IAST)arg1.normal(false);
                    IAST v2 = (IAST)arg2.normal(false);
                    if (v1.isAST2() || v2.isAST2()) {
                        return F.Subtract(F.Times(v1.arg1(), v2.arg2()), F.Times(v1.arg2(), v2.arg1()));
                    }
                } else if (dim1 == 3 && dim2 == 3) {
                    IAST v1 = (IAST)arg1.normal(false);
                    IAST v2 = (IAST)arg2.normal(false);
                    if (v1.isAST3() || v2.isAST3()) {
                        return F.List(F.Plus((IExpr)F.Times(v1.arg2(), v2.arg3()), (IExpr)F.Times((IExpr)F.CN1, v1.arg3(), v2.arg2())), F.Plus((IExpr)F.Times(v1.arg3(), v2.arg1()), (IExpr)F.Times((IExpr)F.CN1, v1.arg1(), v2.arg3())), F.Plus((IExpr)F.Times(v1.arg1(), v2.arg2()), (IExpr)F.Times((IExpr)F.CN1, v1.arg2(), v2.arg1())));
                    }
                }
            } else {
                int dim1;
                if (ast.isAST1()) {
                    int dim12 = arg1.isVector();
                    if (dim12 == 2) {
                        IAST v1 = (IAST)arg1.normal(false);
                        return F.List(F.Negate(v1.arg2()), v1.arg1());
                    }
                    return IOFunctions.printMessage(ast.topHead(), "nonn1", F.CEmptyList, engine);
                }
                if (ast.size() > 3 && (dim1 = arg1.isVector()) == ast.size()) {
                    for (int i = 2; i < ast.size(); ++i) {
                        if (ast.get(i).isVector() == dim1) continue;
                        return F.NIL;
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }
    }

    private static final class Cofactor
    extends AbstractFunctionEvaluator {
        private Cofactor() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            int[] dims = arg1.isMatrix();
            if (dims != null && arg2.isList2()) {
                if (dims[0] == 0 || dims[1] == 0) {
                    return F.NIL;
                }
                if (arg1.isSparseArray()) {
                    arg1 = arg1.normal(false);
                }
                IAST matrix = (IAST)arg1;
                int i = arg2.first().toIntDefault();
                int j = arg2.second().toIntDefault();
                if (i <= 0 || j <= 0) {
                    return F.NIL;
                }
                if (i > dims[0] || j > dims[1]) {
                    return F.NIL;
                }
                if (i + j < 0) {
                    return F.NIL;
                }
                return F.Times((IExpr)F.Power((IExpr)F.CN1, F.ZZ(i + j)), (IExpr)F.Det(F.Drop(matrix, F.list(F.ZZ(i)), F.list(F.ZZ(j)))));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class ConjugateTranspose
    extends Transpose {
        private ConjugateTranspose() {
        }

        @Override
        protected IExpr transform(IExpr expr) {
            return expr.conjugate();
        }
    }

    private static final class CholeskyDecomposition
    extends AbstractFunctionEvaluator {
        private CholeskyDecomposition() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                RealMatrix matrix = ast.arg1().toRealMatrix();
                if (matrix != null) {
                    org.hipparchus.linear.CholeskyDecomposition dcomposition = new org.hipparchus.linear.CholeskyDecomposition(matrix);
                    return new ASTRealMatrix(dcomposition.getLT(), false);
                }
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (MathRuntimeException e) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)e);
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.debug("CholeskyDecomposition.evaluate() failed", (Throwable)e);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class CharacteristicPolynomial
    extends AbstractFunctionEvaluator {
        private CharacteristicPolynomial() {
        }

        public static IAST generateCharacteristicPolynomial(int dim, IAST matrix, IExpr variable) {
            IExpr[] valuesForIdentityMatrix = new IExpr[]{F.C0, variable};
            return F.Det(F.Subtract(matrix, LinearAlgebra.diagonalMatrix(valuesForIdentityMatrix, dim)));
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int[] dimensions = ast.arg1().isMatrix();
            if (dimensions != null && dimensions[0] == dimensions[1]) {
                IAST matrix = (IAST)ast.arg1().normal(false);
                IExpr variable = ast.arg2();
                if (!variable.isVariable()) {
                    return IOFunctions.printMessage(ast.topHead(), "ivar", F.list(variable), engine);
                }
                return CharacteristicPolynomial.generateCharacteristicPolynomial(dimensions[0], matrix, variable);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class ArrayDepth
    extends AbstractFunctionEvaluator {
        private ArrayDepth() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isAST()) {
                IAST list = (IAST)arg1;
                IExpr header = list.head();
                IntArrayList dims = LinearAlgebra.dimensions(list, header);
                return F.ZZ(dims.size());
            }
            if (arg1.isSparseArray()) {
                int[] dims = ((ISparseArray)arg1).getDimension();
                return F.ZZ(dims.length);
            }
            if (arg1.isNumericArray()) {
                int[] dims = ((INumericArray)arg1).getDimension();
                return F.ZZ(dims.length);
            }
            return F.C0;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.AllowedHeads, (IExpr)S.Automatic)));
        }
    }

    private static final class FieldReducedRowEchelonForm {
        private final FieldMatrix<IExpr> originalMatrix;
        private FieldMatrix<IExpr> rowReducedMatrix;
        private FieldMatrix<IExpr> nullSpaceCache;
        private int matrixRankCache;
        private final int numRows;
        private final int numCols;
        private final Predicate<IExpr> zeroChecker;

        public FieldReducedRowEchelonForm(FieldMatrix<IExpr> matrix, Predicate<IExpr> zeroChecker) {
            this.originalMatrix = matrix;
            this.zeroChecker = zeroChecker;
            this.numRows = matrix.getRowDimension();
            this.numCols = matrix.getColumnDimension();
            this.matrixRankCache = -1;
            this.nullSpaceCache = null;
            this.rowReducedMatrix = matrix.copy();
            if (zeroChecker instanceof AbstractMatrix1Expr.PossibleZeroQTest) {
                this.rowReduce();
            } else {
                this.rowReduceAdvancedZeroTest();
            }
        }

        private void rowReduce() {
            int pivotRow = 0;
            int numRows = this.rowReducedMatrix.getRowDimension();
            int numColumns = this.rowReducedMatrix.getColumnDimension();
            for (int k = 0; k < numRows && numColumns > pivotRow; ++pivotRow, ++k) {
                int i = k;
                while (this.isZero((IExpr)this.rowReducedMatrix.getEntry(i, pivotRow))) {
                    if (numRows != ++i) continue;
                    i = k;
                    if (numColumns != ++pivotRow) continue;
                    --pivotRow;
                    break;
                }
                this.rowSwap(i, k);
                if (!this.isZero((IExpr)this.rowReducedMatrix.getEntry(k, pivotRow)) && !this.isOne((IExpr)this.rowReducedMatrix.getEntry(k, pivotRow))) {
                    this.rowScale(k, ((IExpr)this.rowReducedMatrix.getEntry(k, pivotRow)).inverse());
                }
                for (i = 0; i < numRows; ++i) {
                    if (i == k) continue;
                    this.rowAddScale(k, i, ((IExpr)this.rowReducedMatrix.getEntry(i, pivotRow)).negate());
                }
            }
            EvalEngine.get().addTraceStep(() -> Convert.matrix2List(this.originalMatrix), () -> Convert.matrix2List(this.rowReducedMatrix), F.list(S.RowReduce, F.$str("ReducedRowEchelonForm")));
        }

        private void rowSwap(int rowIndex1, int rowIndex2) {
            if (rowIndex1 != rowIndex2) {
                int numColumns = this.rowReducedMatrix.getColumnDimension();
                for (int k = 0; k < numColumns; ++k) {
                    IExpr hold = (IExpr)this.rowReducedMatrix.getEntry(rowIndex2, k);
                    this.rowReducedMatrix.setEntry(rowIndex2, k, (FieldElement)((IExpr)this.rowReducedMatrix.getEntry(rowIndex1, k)));
                    this.rowReducedMatrix.setEntry(rowIndex1, k, (FieldElement)hold);
                }
            }
        }

        private void rowScale(int rowIndex, IExpr scalar) {
            if (!this.isZero(scalar)) {
                int numColumns = this.rowReducedMatrix.getColumnDimension();
                for (int k = 0; k < numColumns; ++k) {
                    this.rowReducedMatrix.setEntry(rowIndex, k, (FieldElement)((IExpr)this.rowReducedMatrix.getEntry(rowIndex, k)).multiply(scalar));
                }
            }
        }

        private void rowAddScale(int rowIndex1, int rowIndex2, IExpr scalar) {
            if (!this.isZero(scalar)) {
                int numColumns = this.rowReducedMatrix.getColumnDimension();
                for (int k = 0; k < numColumns; ++k) {
                    this.rowReducedMatrix.setEntry(rowIndex2, k, (FieldElement)((IExpr)this.rowReducedMatrix.getEntry(rowIndex2, k)).add(((IExpr)this.rowReducedMatrix.getEntry(rowIndex1, k)).multiply(scalar)));
                }
            }
        }

        final boolean isZero(IExpr expr) {
            return this.zeroChecker.test(expr);
        }

        final boolean isOne(IExpr expr) {
            return this.zeroChecker.test(F.C1.subtract(expr));
        }

        private RowColIndex findPivot(RowColIndex a) {
            int i;
            int first_row = a.row;
            RowColIndex pivot = new RowColIndex(a.row, a.col);
            RowColIndex current = new RowColIndex(a.row, a.col);
            for (i = a.row; i < this.numRows - first_row; ++i) {
                current.row = i;
                if (!this.isOne((IExpr)this.rowReducedMatrix.getEntry(current.row, current.col))) continue;
                this.swapRow(current, a);
            }
            i = current.row = a.row;
            while (i < this.numRows - first_row) {
                current.row = i++;
                if (this.isZero((IExpr)this.rowReducedMatrix.getEntry(current.row, current.col))) continue;
                pivot.row = i;
                break;
            }
            return pivot;
        }

        private IExpr getCoordinate(RowColIndex a) {
            return (IExpr)this.rowReducedMatrix.getEntry(a.row, a.col);
        }

        public FieldMatrix<IExpr> getRowReducedMatrix() {
            return this.rowReducedMatrix;
        }

        private void swapRow(RowColIndex a, RowColIndex b) {
            IExpr[] temp = (IExpr[])this.rowReducedMatrix.getRow(a.row);
            this.rowReducedMatrix.setRow(a.row, (FieldElement[])((IExpr[])this.rowReducedMatrix.getRow(b.row)));
            this.rowReducedMatrix.setRow(b.row, (FieldElement[])temp);
            int t = a.row;
            a.row = b.row;
            b.row = t;
        }

        private boolean isColumnZeroFromRow(RowColIndex a) {
            for (int i = 0; i < this.numRows; ++i) {
                if (this.isZero((IExpr)this.rowReducedMatrix.getEntry(i, a.col))) continue;
                return false;
            }
            return true;
        }

        private boolean isRowZeroes(int row) {
            IExpr[] temp = (IExpr[])this.rowReducedMatrix.getRow(row);
            for (int i = 0; i < this.numCols; ++i) {
                if (this.isZero(temp[i])) continue;
                return false;
            }
            return true;
        }

        private void multiplyAdd(RowColIndex to, RowColIndex from, IExpr factor) {
            IExpr[] row = (IExpr[])this.rowReducedMatrix.getRow(to.row);
            IExpr[] rowMultiplied = (IExpr[])this.rowReducedMatrix.getRow(from.row);
            for (int i = 0; i < this.numCols; ++i) {
                this.rowReducedMatrix.setEntry(to.row, i, (FieldElement)row[i].plus(rowMultiplied[i].times(factor)));
            }
        }

        public FieldMatrix<IExpr> getNullSpace(IExpr minusOneFactor) {
            int rank = this.getMatrixRank();
            int newRowDimension = this.rowReducedMatrix.getColumnDimension() - rank;
            if (newRowDimension == 0) {
                return null;
            }
            int newColumnDimension = this.rowReducedMatrix.getColumnDimension();
            if (this.nullSpaceCache != null) {
                return this.nullSpaceCache;
            }
            this.nullSpaceCache = this.rowReducedMatrix.createMatrix(newRowDimension, newColumnDimension);
            this.getResultOfNullspace(minusOneFactor, rank);
            return this.nullSpaceCache;
        }

        private void getResultOfNullspace(IExpr minusOneFactor, int rank) {
            int i;
            boolean[] columns = new boolean[this.nullSpaceCache.getColumnDimension()];
            int numberOfFreeColumns = 0;
            for (int i2 = 0; i2 < rank; ++i2) {
                if (columns[i2]) continue;
                for (int k = i2; k < this.rowReducedMatrix.getColumnDimension() && this.isZero((IExpr)this.rowReducedMatrix.getEntry(i2, k)); ++k) {
                    columns[k] = true;
                    int offset = 0;
                    for (int j = 0; j < rank; ++j) {
                        if (columns[j]) {
                            ++offset;
                        }
                        this.nullSpaceCache.setEntry(numberOfFreeColumns, j + offset, (FieldElement)((IExpr)this.rowReducedMatrix.getEntry(j, i2)));
                    }
                    ++numberOfFreeColumns;
                }
            }
            int start = rank + numberOfFreeColumns;
            int row = numberOfFreeColumns;
            for (i = start; i < this.nullSpaceCache.getColumnDimension(); ++i) {
                int offset = 0;
                for (int j = 0; j < rank; ++j) {
                    if (columns[j]) {
                        ++offset;
                    }
                    this.nullSpaceCache.setEntry(row, j + offset, (FieldElement)((IExpr)this.rowReducedMatrix.getEntry(j, i)));
                }
                ++row;
            }
            for (i = start; i < this.nullSpaceCache.getColumnDimension(); ++i) {
                columns[i] = true;
            }
            this.nullSpaceCache = this.nullSpaceCache.scalarMultiply((FieldElement)minusOneFactor);
            row = 0;
            for (i = 0; i < columns.length; ++i) {
                if (!columns[i]) continue;
                this.nullSpaceCache.setEntry(row++, i, (FieldElement)F.C1);
            }
        }

        private void rowReduceAdvancedZeroTest() {
            RowColIndex pivot = new RowColIndex(0, 0);
            int submatrix = 0;
            for (int x = 0; x < this.numCols; ++x) {
                pivot = new RowColIndex(pivot.row, x);
                int i = x;
                while (i < this.numCols && this.isColumnZeroFromRow(pivot)) {
                    pivot.col = i++;
                }
                if (this.isZero(this.getCoordinate(pivot = this.findPivot(pivot)))) {
                    ++pivot.row;
                    if (pivot.row + 1 > this.numRows) {
                        --pivot.row;
                        continue;
                    }
                }
                if (pivot.row != submatrix && !this.isRowZeroes(pivot.row)) {
                    this.swapRow(new RowColIndex(submatrix, pivot.col), pivot);
                }
                if (!this.isZero(this.getCoordinate(pivot))) {
                    IExpr complement;
                    if (!this.isOne(this.getCoordinate(pivot))) {
                        IExpr scalar = this.getCoordinate(pivot).inverse();
                        this.scaleRow(pivot, scalar);
                    }
                    for (i = pivot.row + 1; i < this.numRows; ++i) {
                        RowColIndex belowPivot = new RowColIndex(i, pivot.col);
                        complement = this.getCoordinate(belowPivot).negate().divide(this.getCoordinate(pivot));
                        this.multiplyAdd(belowPivot, pivot, complement);
                    }
                    for (i = pivot.row; i >= 0; --i) {
                        if (i == pivot.row) {
                            if (this.isOne(this.getCoordinate(pivot))) continue;
                            this.scaleRow(pivot, this.getCoordinate(pivot).inverse());
                            continue;
                        }
                        RowColIndex abovePivot = new RowColIndex(i, pivot.col);
                        complement = this.getCoordinate(abovePivot).negate().divide(this.getCoordinate(pivot));
                        this.multiplyAdd(abovePivot, pivot, complement);
                    }
                    ++submatrix;
                }
                if (pivot.row + 1 >= this.numRows) break;
                ++pivot.row;
            }
            EvalEngine.get().addTraceStep(() -> Convert.matrix2List(this.originalMatrix), () -> Convert.matrix2List(this.rowReducedMatrix), F.list(S.RowReduce, F.$str("ReducedRowEchelonForm")));
        }

        public int getMatrixRank() {
            if (this.rowReducedMatrix.getRowDimension() == 0 || this.rowReducedMatrix.getColumnDimension() == 0) {
                return 0;
            }
            if (this.matrixRankCache < 0) {
                int rows;
                this.matrixRankCache = 0;
                for (int i = rows = this.rowReducedMatrix.getRowDimension() - 1; i >= 0; --i) {
                    if (this.isRowZeroes(i)) continue;
                    this.matrixRankCache = i + 1;
                    return this.matrixRankCache;
                }
            }
            return this.matrixRankCache;
        }

        private void scaleRow(RowColIndex x, IExpr factor) {
            for (int i = 0; i < this.numCols; ++i) {
                this.rowReducedMatrix.multiplyEntry(x.row, i, (FieldElement)factor);
            }
        }

        private static class RowColIndex {
            int row;
            int col;

            RowColIndex(int r, int c) {
                this.row = r;
                this.col = c;
            }

            public String toString() {
                return "(" + this.row + ", " + this.col + ")";
            }
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.ArrayDepth.setEvaluator(new ArrayDepth());
            S.CharacteristicPolynomial.setEvaluator(new CharacteristicPolynomial());
            S.CholeskyDecomposition.setEvaluator(new CholeskyDecomposition());
            S.ConjugateTranspose.setEvaluator(new ConjugateTranspose());
            S.Cofactor.setEvaluator(new Cofactor());
            S.Cross.setEvaluator(new Cross());
            S.DesignMatrix.setEvaluator(new DesignMatrix());
            S.Det.setEvaluator(new Det());
            S.Diagonal.setEvaluator(new Diagonal());
            S.DiagonalMatrix.setEvaluator(new DiagonalMatrix());
            S.Dimensions.setEvaluator(new Dimensions());
            S.Dot.setEvaluator(new Dot());
            S.Eigenvalues.setEvaluator(new Eigenvalues());
            S.Eigenvectors.setEvaluator(new Eigenvectors());
            S.FourierMatrix.setEvaluator(new FourierMatrix());
            S.FromPolarCoordinates.setEvaluator(new FromPolarCoordinates());
            S.HilbertMatrix.setEvaluator(new HilbertMatrix());
            S.IdentityMatrix.setEvaluator(new IdentityMatrix());
            S.Inner.setEvaluator(new Inner());
            S.Inverse.setEvaluator(new Inverse());
            S.JacobiMatrix.setEvaluator(new JacobiMatrix());
            S.LeastSquares.setEvaluator(new LeastSquares());
            S.LinearSolve.setEvaluator(new LinearSolve());
            S.LinearSolveFunction.setEvaluator(new LinearSolveFunction());
            S.LowerTriangularize.setEvaluator(new LowerTriangularize());
            S.LUDecomposition.setEvaluator(new LUDecomposition());
            S.MatrixMinimalPolynomial.setEvaluator(new MatrixMinimalPolynomial());
            S.MatrixExp.setEvaluator(new MatrixExp());
            S.MatrixFunction.setEvaluator(new MatrixFunction());
            S.MatrixLog.setEvaluator(new MatrixLog());
            S.MatrixPower.setEvaluator(new MatrixPower());
            S.MatrixRank.setEvaluator(new MatrixRank());
            S.Minors.setEvaluator(new Minors());
            S.Norm.setEvaluator(new Norm());
            S.Normalize.setEvaluator(new Normalize());
            S.NullSpace.setEvaluator(new NullSpace());
            S.Orthogonalize.setEvaluator(new Orthogonalize());
            S.PauliMatrix.setEvaluator(new PauliMatrix());
            S.PseudoInverse.setEvaluator(PseudoInverse.CONST);
            S.Projection.setEvaluator(new Projection());
            S.QRDecomposition.setEvaluator(new QRDecomposition());
            S.RiccatiSolve.setEvaluator(new RiccatiSolve());
            S.RowReduce.setEvaluator(new RowReduce());
            S.SingularValueDecomposition.setEvaluator(new SingularValueDecomposition());
            S.SingularValueList.setEvaluator(new SingularValueList());
            S.ToeplitzMatrix.setEvaluator(new ToeplitzMatrix());
            S.ToPolarCoordinates.setEvaluator(new ToPolarCoordinates());
            S.Tr.setEvaluator(new Tr());
            S.Transpose.setEvaluator(new Transpose());
            S.UpperTriangularize.setEvaluator(new UpperTriangularize());
            S.UnitVector.setEvaluator(new UnitVector());
            S.VandermondeMatrix.setEvaluator(new VandermondeMatrix());
            S.VectorAngle.setEvaluator(new VectorAngle());
        }
    }
}

