/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.convert.Object2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.DataExpr;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.JavaClassExpr;
import org.matheclipse.core.expression.data.JavaObjectExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.ParserConfig;

public class JavaFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Object[] determineParameters(IAST ast, Parameter[] parameters, int offset) {
        try {
            Object[] params = new Object[parameters.length];
            for (int j = 0; j < parameters.length; ++j) {
                Object obj;
                Parameter p = parameters[j];
                IExpr arg = ast.get(j + offset);
                Class<?> clazz = p.getType();
                if (arg instanceof DataExpr && clazz.isInstance(obj = ((DataExpr)arg).toData())) {
                    params[j] = obj;
                    continue;
                }
                if (clazz.isInstance(arg)) {
                    params[j] = arg;
                    continue;
                }
                if (clazz.equals(Boolean.TYPE)) {
                    if (arg.isTrue()) {
                        params[j] = Boolean.TRUE;
                        continue;
                    }
                    if (arg.isFalse()) {
                        params[j] = Boolean.FALSE;
                        continue;
                    }
                    return null;
                }
                if (clazz.equals(Double.TYPE)) {
                    params[j] = arg.evalDouble();
                    continue;
                }
                if (clazz.equals(Float.TYPE)) {
                    params[j] = Float.valueOf((float)arg.evalDouble());
                    continue;
                }
                if (clazz.equals(Integer.TYPE)) {
                    int n = arg.toIntDefault();
                    if (n == Integer.MIN_VALUE) {
                        return null;
                    }
                    params[j] = n;
                    continue;
                }
                if (clazz.equals(Long.TYPE)) {
                    long l = arg.toLongDefault();
                    if (l == Long.MIN_VALUE) {
                        return null;
                    }
                    params[j] = l;
                    continue;
                }
                if (clazz.equals(Short.TYPE)) {
                    int s = arg.toIntDefault();
                    if (s < Short.MIN_VALUE || s > Short.MAX_VALUE) {
                        return null;
                    }
                    params[j] = (short)s;
                    continue;
                }
                if (clazz.equals(Byte.TYPE)) {
                    int b = arg.toIntDefault();
                    if (b < -128 || b > 127) {
                        return null;
                    }
                    params[j] = (byte)b;
                    continue;
                }
                if (clazz.equals(Character.TYPE)) {
                    if (!arg.isString()) {
                        return null;
                    }
                    String str = arg.toString();
                    if (str.length() != 1) {
                        return null;
                    }
                    params[j] = Character.valueOf(str.charAt(0));
                    continue;
                }
                if (clazz.equals(String.class)) {
                    if (!arg.isString()) {
                        return null;
                    }
                    params[j] = arg.toString();
                    continue;
                }
                if (clazz.equals(Complex.class)) {
                    Complex complex = arg.evalComplex();
                    if (complex == null) {
                        return null;
                    }
                    params[j] = complex;
                    continue;
                }
                params[j] = clazz.equals(Class.class) && arg instanceof JavaClassExpr ? ((JavaClassExpr)arg).toData() : arg;
            }
            return params;
        }
        catch (ArgumentTypeException argumentTypeException) {
            return null;
        }
    }

    public static void initialize() {
        Initializer.init();
    }

    private JavaFunctions() {
    }

    private static class SameObjectQ
    extends AbstractEvaluator {
        private SameObjectQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg1 instanceof JavaObjectExpr && arg2 instanceof JavaObjectExpr) {
                return F.bool(((JavaObjectExpr)arg1).toData() == ((JavaObjectExpr)arg2).toData());
            }
            return F.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class LoadJavaClass
    extends AbstractEvaluator {
        private LoadJavaClass() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                IExpr arg1 = ast.arg1();
                if (arg1.isString()) {
                    try {
                        String className = arg1.toString();
                        if (Config.URL_CLASS_LOADER == null) {
                            Config.URL_CLASS_LOADER = (URLClassLoader)ClassLoader.getSystemClassLoader();
                        }
                        JavaClassExpr jClazz = JavaClassExpr.newInstance(className, Config.URL_CLASS_LOADER);
                        Class clazz = (Class)jClazz.toData();
                        int indx = className.lastIndexOf(46);
                        if (indx > 0) {
                            String contextName = className.substring(indx + 1) + "`";
                            try {
                                Context context = engine.beginPackage(contextName);
                                context.setJavaClass(clazz);
                                Method[] methods = clazz.getMethods();
                                for (int i = 0; i < methods.length; ++i) {
                                    Method method = methods[i];
                                    if (!Modifier.isStatic(method.getModifiers())) continue;
                                    ISymbol iSymbol = F.symbol(context, method.getName(), engine);
                                }
                            }
                            finally {
                                engine.endPackage();
                            }
                        }
                        return jClazz;
                    }
                    catch (ClassNotFoundException cnfex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)cnfex);
                        return F.NIL;
                    }
                }
                if (arg1 instanceof JavaClassExpr) {
                    return arg1;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class JavaObjectQ
    extends AbstractEvaluator {
        private JavaObjectQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.bool(ast.arg1() instanceof JavaObjectExpr);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class JavaObject
    extends AbstractEvaluator {
        private JavaObject() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head() == S.JavaObject) {
                return F.NIL;
            }
            if (ast.head() instanceof JavaObjectExpr && ast.argSize() == 1 && ast.arg1().isAST()) {
                try {
                    IAST methodExpr = (IAST)ast.arg1();
                    if (methodExpr.head().isSymbol()) {
                        JavaObjectExpr joe = (JavaObjectExpr)ast.head();
                        Object obj = joe.toData();
                        Method[] method = obj.getClass().getMethods();
                        for (int i = 0; i < method.length; ++i) {
                            Object[] params;
                            Parameter[] parameters;
                            if (!methodExpr.head().isString(method[i].getName()) || (parameters = method[i].getParameters()).length != methodExpr.argSize() || (params = JavaFunctions.determineParameters(methodExpr, parameters, 1)) == null) continue;
                            Object result = method[i].invoke(obj, params);
                            if (result instanceof String) {
                                return F.stringx((String)result);
                            }
                            return Object2Expr.convert(result, false, true);
                        }
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    LOGGER.log(engine.getLogLevel(), (Object)S.JavaObject, (Throwable)ex);
                }
            }
            return F.NIL;
        }
    }

    private static class JavaNew
    extends AbstractEvaluator {
        private JavaNew() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                IExpr arg1 = ast.arg1();
                if (arg1.isString()) {
                    try {
                        if (Config.URL_CLASS_LOADER == null) {
                            Config.URL_CLASS_LOADER = (URLClassLoader)ClassLoader.getSystemClassLoader();
                        }
                        arg1 = JavaClassExpr.newInstance(arg1.toString(), Config.URL_CLASS_LOADER);
                    }
                    catch (ClassNotFoundException cnfex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)cnfex);
                        return F.NIL;
                    }
                }
                if (arg1 instanceof JavaClassExpr) {
                    try {
                        Constructor<?>[] constructors = ((Class)((JavaClassExpr)arg1).toData()).getConstructors();
                        for (int i = 0; i < constructors.length; ++i) {
                            Object[] params;
                            Parameter[] parameters = constructors[i].getParameters();
                            if (parameters.length != ast.argSize() - 1 || (params = JavaFunctions.determineParameters(ast, parameters, 2)) == null) continue;
                            Object obj = constructors[i].newInstance(params);
                            return JavaObjectExpr.newInstance(obj);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
                        return F.NIL;
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }
    }

    private static class InstanceOf
    extends AbstractEvaluator {
        private InstanceOf() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg2.isString()) {
                try {
                    if (Config.URL_CLASS_LOADER == null) {
                        Config.URL_CLASS_LOADER = (URLClassLoader)ClassLoader.getSystemClassLoader();
                    }
                    arg2 = JavaClassExpr.newInstance(arg2.toString(), Config.URL_CLASS_LOADER);
                }
                catch (ClassNotFoundException cnfex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)cnfex);
                    return F.False;
                }
            }
            if (arg1 instanceof JavaObjectExpr && arg2 instanceof JavaClassExpr) {
                return F.bool(((Class)((JavaClassExpr)arg2).toData()).isInstance(((JavaObjectExpr)arg1).toData()));
            }
            return F.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class AddToClassPath
    extends AbstractEvaluator {
        private AddToClassPath() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (Config.URL_CLASS_LOADER == null) {
                    Config.URL_CLASS_LOADER = (URLClassLoader)ClassLoader.getSystemClassLoader();
                }
                URLClassLoader child = Config.URL_CLASS_LOADER;
                for (int i = 1; i < ast.size(); ++i) {
                    IExpr arg = ast.get(i);
                    if (!arg.isString()) continue;
                    String path = arg.toString();
                    File file = new File(path);
                    child = new URLClassLoader(new URL[]{file.toURI().toURL()}, (ClassLoader)child);
                }
                if (child != null) {
                    Config.URL_CLASS_LOADER = child;
                }
            }
            catch (MalformedURLException ex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            if (!Config.FUZZY_PARSER && !ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS) {
                S.AddToClassPath.setEvaluator(new AddToClassPath());
                S.InstanceOf.setEvaluator(new InstanceOf());
                S.JavaNew.setEvaluator(new JavaNew());
                S.JavaObject.setEvaluator(new JavaObject());
                S.JavaObjectQ.setEvaluator(new JavaObjectQ());
                S.LoadJavaClass.setEvaluator(new LoadJavaClass());
                S.SameObjectQ.setEvaluator(new SameObjectQ());
            }
        }
    }
}

