/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntervalSym;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class IntervalFunctions {
    public static void initialize() {
        Initializer.init();
    }

    private IntervalFunctions() {
    }

    private static final class IntervalUnion
    extends AbstractEvaluator {
        private IntervalUnion() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = 2;
            for (int i = 1; i < ast.size(); ++i) {
                if (!ast.get(i).isInterval()) {
                    return F.NIL;
                }
                IAST interval = (IAST)ast.get(i);
                size += interval.argSize();
                for (int j = 1; j < interval.size(); ++j) {
                    if (!interval.get(j).isList2()) {
                        return F.NIL;
                    }
                    IAST list1 = (IAST)interval.get(j);
                    IExpr min1 = list1.arg1();
                    IExpr max1 = list1.arg2();
                    if (min1.isRealResult() && max1.isRealResult()) continue;
                    return F.NIL;
                }
            }
            IASTAppendable result = F.ast((IExpr)S.Interval, size);
            for (int i = 1; i < ast.size(); ++i) {
                IAST interval = (IAST)ast.get(i);
                for (int j = 1; j < interval.size(); ++j) {
                    result.append(interval.get(j));
                }
            }
            IAST normalized = IntervalSym.normalize(result, engine);
            return normalized.orElse(result);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }
    }

    private static final class IntervalIntersection
    extends AbstractEvaluator {
        private IntervalIntersection() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            for (int i = 1; i < ast.size(); ++i) {
                if (!ast.get(i).isInterval()) {
                    return F.NIL;
                }
                IAST interval = (IAST)ast.get(i);
                for (int j = 1; j < interval.size(); ++j) {
                    if (!interval.get(j).isList2()) {
                        return F.NIL;
                    }
                    IAST list1 = (IAST)interval.get(j);
                    IExpr min1 = list1.arg1();
                    IExpr max1 = list1.arg2();
                    if (min1.isRealResult() && max1.isRealResult()) continue;
                    return F.NIL;
                }
            }
            IAST result = (IAST)ast.arg1();
            result = IntervalSym.normalize(result, engine).orElse(result);
            for (int i = 2; i < ast.size(); ++i) {
                IAST interval = (IAST)ast.get(i);
                IAST normalizedArg = IntervalSym.normalize(interval, engine).orElse(interval);
                if ((result = this.intersection(result, normalizedArg, engine)).size() != 1) continue;
                return result;
            }
            IAST normalized = IntervalSym.normalize(result, engine);
            return normalized.orElse(result);
        }

        private IAST intersection(IAST interval1, IAST interval2, EvalEngine engine) {
            IASTAppendable result = F.ast((IExpr)S.Interval, 3);
            for (int i = 1; i < interval1.size(); ++i) {
                IAST list1 = (IAST)interval1.get(i);
                IExpr min1 = list1.arg1();
                IExpr max1 = list1.arg2();
                for (int j = 1; j < interval2.size(); ++j) {
                    IAST list2 = (IAST)interval2.get(j);
                    IExpr min2 = list2.arg1();
                    IExpr max2 = list2.arg2();
                    if (S.Less.ofQ(engine, max1, min2) || S.Less.ofQ(engine, max2, min1)) continue;
                    if (S.LessEqual.ofQ(engine, min1, min2)) {
                        min1 = min2;
                    }
                    if (S.GreaterEqual.ofQ(engine, max1, max2)) {
                        max1 = max2;
                    }
                    result.append(F.list(min1, max1));
                }
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }
    }

    private static final class IntervalMemberQ
    extends AbstractEvaluator {
        private IntervalMemberQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isInterval()) {
                IAST interval1 = IntervalSym.normalize((IAST)ast.arg1());
                if (ast.arg2().isInterval()) {
                    IAST interval2;
                    if (interval1.isPresent() && (interval2 = IntervalSym.normalize((IAST)ast.arg2())).isPresent()) {
                        IASTAppendable copyInterval2 = interval2.copyAppendable();
                        for (int i = 1; i < interval1.size(); ++i) {
                            IAST list1 = (IAST)interval1.get(i);
                            IExpr min1 = list1.arg1();
                            IExpr max1 = list1.arg2();
                            boolean included = false;
                            for (int j = 1; j < interval2.size(); ++j) {
                                IAST list2 = (IAST)interval2.get(j);
                                IExpr min2 = list2.arg1();
                                IExpr max2 = list2.arg2();
                                if (!S.LessEqual.ofQ(engine, min1, min2) || !S.GreaterEqual.ofQ(engine, max1, max2)) continue;
                                copyInterval2.remove(j);
                                if (copyInterval2.size() <= 1) {
                                    return S.True;
                                }
                                included = true;
                                break;
                            }
                            if (included) continue;
                            return S.False;
                        }
                        if (copyInterval2.size() <= 1) {
                            return S.True;
                        }
                    }
                } else {
                    IExpr arg2 = ast.arg2();
                    for (int i = 1; i < interval1.size(); ++i) {
                        IAST list1 = (IAST)interval1.get(i);
                        IExpr min1 = list1.arg1();
                        IExpr max1 = list1.arg2();
                        if (!S.LessEqual.ofQ(engine, min1, arg2) || !S.GreaterEqual.ofQ(engine, max1, arg2)) continue;
                        return S.True;
                    }
                }
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static final class Interval
    extends AbstractEvaluator {
        private Interval() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST result;
            if (ast.isEvalFlagOff(262144) && (result = IntervalSym.normalize(ast, engine)).isPresent()) {
                return result;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Interval.setEvaluator(new Interval());
            S.IntervalMemberQ.setEvaluator(new IntervalMemberQ());
            S.IntervalIntersection.setEvaluator(new IntervalIntersection());
            S.IntervalUnion.setEvaluator(new IntervalUnion());
        }
    }
}

