/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.math.BigInteger;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apfloat;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ComplexSym;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntervalSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class IntegerFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    private static IAST integerDigits(IInteger n, IInteger base, int padLeftZeros) {
        IASTAppendable list = F.ListAlloc(16);
        if (n.isZero()) {
            list.append(F.C0);
        } else {
            while (n.isPositive()) {
                IInteger mod = n.mod(base);
                list.append(mod);
                n = n.subtract(mod).div(base);
            }
        }
        int padSizeZeros = padLeftZeros - list.argSize();
        if (padSizeZeros < 0) {
            padSizeZeros = 0;
        }
        IASTAppendable result = F.ListAlloc(list.argSize() + padSizeZeros);
        for (int i = 0; i < padSizeZeros; ++i) {
            result.append(F.C0);
        }
        return list.reverse(result);
    }

    public static void initialize() {
        Initializer.init();
    }

    private IntegerFunctions() {
    }

    private static class UnitStep
    extends AbstractEvaluator
    implements INumeric {
        private UnitStep() {
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            for (int i = top - size + 1; i < top + 1; ++i) {
                if (!(stack[i] < 0.0)) continue;
                return 0.0;
            }
            return 1.0;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = ast.size();
            if (size > 1) {
                for (int i = 1; i < size; ++i) {
                    IExpr expr = ast.get(i);
                    ISignedNumber temp = expr.evalReal();
                    if (temp != null) {
                        if (temp.complexSign() >= 0) continue;
                        return F.C0;
                    }
                    if ((expr = engine.evaluate(expr)).isNegativeInfinity()) {
                        return F.C0;
                    }
                    if (expr.isInfinity()) continue;
                    if (expr.isNegativeResult()) {
                        return F.C0;
                    }
                    if (expr.isNonNegativeResult()) continue;
                    if (expr.isInterval1()) {
                        IExpr l = expr.lower();
                        IExpr u = expr.upper();
                        if (l.isReal() && u.isReal()) {
                            ISignedNumber min = (ISignedNumber)l;
                            ISignedNumber max = (ISignedNumber)u;
                            if (min.complexSign() < 0) {
                                if (max.complexSign() < 0) {
                                    return F.Interval(F.list(F.C0, F.C0));
                                }
                                if (size == 2) {
                                    return F.Interval(F.list(F.C0, F.C1));
                                }
                            } else if (max.complexSign() < 0) {
                                if (size == 2) {
                                    return F.Interval(F.list(F.C1, F.C0));
                                }
                            } else {
                                if (size != 2) continue;
                                return F.Interval(F.list(F.C1, F.C1));
                            }
                        }
                    }
                    return F.NIL;
                }
            }
            return F.C1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1540);
        }
    }

    private static class Round
    extends AbstractCoreFunctionEvaluator
    implements INumeric {
        private Round() {
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.round(stack[top]);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IASTMutable res = F.NIL;
            try {
                IASTAppendable[] result;
                IExpr arg1 = ast.arg1();
                IExpr temp = engine.evaluateNIL(arg1);
                if (temp.isPresent()) {
                    arg1 = temp;
                    res = ast.setAtCopy(1, temp);
                }
                if (arg1.isList()) {
                    return ((IAST)arg1).mapThread(ast.setAtCopy(1, F.Slot1), 1);
                }
                if (ast.isAST2()) {
                    ISignedNumber multiple;
                    IExpr arg2 = ast.arg2();
                    temp = engine.evaluateNIL(arg2);
                    if (temp.isPresent()) {
                        arg2 = temp;
                        if (!res.isPresent()) {
                            res = ast.setAtCopy(2, temp);
                        } else {
                            res.set(2, temp);
                        }
                    }
                    if ((multiple = arg2.evalReal()) != null) {
                        if (multiple.isZero()) {
                            return S.Indeterminate;
                        }
                        ISignedNumber signedNumber = arg1.evalReal();
                        if (signedNumber != null) {
                            return signedNumber.roundClosest(multiple);
                        }
                        if (arg1.isComplexNumeric()) {
                            IComplexNum cmp = (IComplexNum)arg1;
                            ISignedNumber re = cmp.re().roundClosest(multiple);
                            ISignedNumber im = cmp.im().roundClosest(multiple);
                            return F.Complex(re, im);
                        }
                        if (arg1.isComplex()) {
                            IComplex cmp = (IComplex)arg1;
                            IRational re = cmp.re().roundClosest(multiple);
                            IRational im = cmp.im().roundClosest(multiple);
                            return F.Complex(re, im);
                        }
                        if (arg1.isInfinity() || arg1.isNegativeInfinity()) {
                            return arg1;
                        }
                    }
                    return res;
                }
                if (arg1.isIntegerResult()) {
                    return arg1;
                }
                INumber number = arg1.evalNumber();
                if (number != null) {
                    return number.roundExpr();
                }
                if (arg1.isDirectedInfinity() && arg1.argSize() == 1) {
                    return arg1;
                }
                if (arg1.isComplexInfinity()) {
                    return arg1;
                }
                if (arg1.isPlus() && (result = ((IAST)arg1).filterNIL(new RoundPlusFunction()))[0].size() > 1) {
                    if (result[1].size() > 1) {
                        result[0].append(F.Round(result[1]));
                    }
                    return result[0];
                }
                IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
                if (negExpr.isPresent()) {
                    return F.Negate(F.Round(negExpr));
                }
                if (arg1.isInterval()) {
                    return IntervalSym.mapSymbol(S.Round, (IAST)arg1);
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            return res;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        private static final class RoundPlusFunction
        implements Function<IExpr, IExpr> {
            private RoundPlusFunction() {
            }

            @Override
            public IExpr apply(IExpr expr) {
                if (expr.isIntegerResult()) {
                    return expr;
                }
                return F.NIL;
            }
        }
    }

    private static class RealDigits
    extends AbstractFunctionEvaluator {
        private RealDigits() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isInteger()) {
                IInteger number = (IInteger)arg1;
                if (number.isNegative()) {
                    number = number.abs();
                }
                IAST list = IntegerFunctions.integerDigits(number, F.C10, 0);
                return F.list(list, F.ZZ(list.size() - 1));
            }
            try {
                ISignedNumber number = null;
                number = arg1.isReal() ? (ISignedNumber)arg1 : arg1.evalReal();
                if (number != null) {
                    if (number.isNegative()) {
                        number = number.abs();
                    }
                    if (number instanceof ApfloatNum) {
                        Apfloat apfloat = number.apfloatValue();
                        String str = apfloat.toString();
                        IASTAppendable list = F.ListAlloc(str.length() + 1);
                        int numberOfLeftDigits = 0;
                        for (int i = 0; i < str.length(); ++i) {
                            char ch = str.charAt(i);
                            if (ch == '.') {
                                numberOfLeftDigits = i;
                                continue;
                            }
                            if (ch == 'e' || ch == 'E') {
                                String exponentStr = str.substring(i + 1);
                                int exponent = Integer.parseInt(exponentStr);
                                numberOfLeftDigits += exponent;
                                break;
                            }
                            list.append(ch);
                        }
                        return F.list(list, F.ZZ(numberOfLeftDigits));
                    }
                    if (number instanceof Num) {
                        String str = Double.toString(number.doubleValue());
                        IASTAppendable list = F.ListAlloc(str.length() + 1);
                        int numberOfLeftDigits = 0;
                        for (int i = 0; i < str.length(); ++i) {
                            char ch = str.charAt(i);
                            if (ch == '.') {
                                numberOfLeftDigits = i;
                                continue;
                            }
                            if (ch == 'e' || ch == 'E') {
                                String exponentStr = str.substring(i + 1);
                                int exponent = Integer.parseInt(exponentStr);
                                numberOfLeftDigits += exponent;
                                break;
                            }
                            list.append(ch);
                        }
                        return F.list(list, F.ZZ(numberOfLeftDigits));
                    }
                }
            }
            catch (NumberFormatException | ArgumentTypeException atex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)atex);
                return F.NIL;
            }
            if (arg1.isNumber()) {
                return IOFunctions.printMessage(ast.topHead(), "realx", F.list(arg1), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class QuotientRemainder
    extends AbstractCoreFunctionEvaluator {
        private QuotientRemainder() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static class Quotient
    extends AbstractCoreFunctionEvaluator {
        private Quotient() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = engine.evaluate(ast.arg1());
            IExpr n = engine.evaluate(ast.arg2());
            if (n.isZero()) {
                LOGGER.log(engine.getLogLevel(), "Quotient: division by zero");
                return F.CComplexInfinity;
            }
            if (ast.isAST2()) {
                if (z.isInteger() && n.isInteger()) {
                    return ((IInteger)z).quotient((IInteger)n);
                }
                if (z.isReal() && n.isReal()) {
                    return ((ISignedNumber)z).divideBy((ISignedNumber)n).floorFraction();
                }
                if (z.isComplex() || n.isComplex()) {
                    IComplex c1 = null;
                    if (z.isComplex()) {
                        c1 = (IComplex)z;
                    } else if (z.isRational()) {
                        c1 = F.complex((IRational)z);
                    }
                    if (c1 != null) {
                        IComplex[] result;
                        IComplex c2 = null;
                        if (n.isComplex()) {
                            c2 = (ComplexSym)n;
                        } else if (n.isRational()) {
                            c2 = F.complex((IRational)n);
                        }
                        if (c2 != null && (result = c1.quotientRemainder(c2)) != null) {
                            return result[0];
                        }
                    }
                }
                if (z.isNumericFunction(true) && n.isNumericFunction(true)) {
                    try {
                        double zDouble = Double.NaN;
                        double nDouble = Double.NaN;
                        try {
                            zDouble = z.evalDouble();
                            nDouble = n.evalDouble();
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                        if (Double.isNaN(zDouble) || Double.isNaN(nDouble)) {
                            Complex zComplex = z.evalComplex();
                            Complex nComplex = n.evalComplex();
                            Complex[] qr = ComplexNum.quotientRemainder(zComplex, nComplex);
                            return F.complexNum(qr[0]).floorFraction();
                        }
                        return F.num(zDouble / nDouble).floorFraction();
                    }
                    catch (ValidateException ve) {
                        return IOFunctions.printMessage(ast.topHead(), ve, engine);
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    }
                }
                return F.NIL;
            }
            if (ast.isAST3()) {
                IExpr d = engine.evaluate(ast.arg3());
                if (!z.isInteger() || !n.isInteger() || d.isInteger()) {
                    // empty if block
                }
                return F.NIL;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static class PowerMod
    extends AbstractFunctionEvaluator {
        private PowerMod() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.exists(x -> !x.isInteger())) {
                return F.NIL;
            }
            IInteger arg1 = (IInteger)ast.arg1();
            IInteger arg2 = (IInteger)ast.arg2();
            IInteger arg3 = (IInteger)ast.arg3();
            try {
                if (arg1.isZero() && arg2.isNegativeResult()) {
                    return IOFunctions.printMessage(ast.topHead(), "ninv", F.list(arg1, arg3), engine);
                }
                if (arg3.isZero()) {
                    return IOFunctions.printMessage(ast.topHead(), "divz", F.list(arg3, ast), engine);
                }
                if (arg2.isMinusOne()) {
                    return arg1.modInverse(arg3);
                }
                return arg1.modPow(arg2, arg3);
            }
            catch (ArithmeticException ae) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ae);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
            super.setUp(newSymbol);
        }
    }

    private static class Mod
    extends AbstractFunctionEvaluator {
        private Mod() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr m = ast.arg1();
            IExpr n = ast.arg2();
            if (n.isZero()) {
                IOFunctions.printMessage(ast.topHead(), "indet", F.list(ast), engine);
                return S.Indeterminate;
            }
            if (ast.isAST3()) {
                IExpr d = ast.arg3();
                if (m.isNumber() && n.isNumber() && d.isNumber()) {
                    if (m.isInteger() && n.isInteger() && d.isInteger()) {
                        IInteger subExpr = ((ISignedNumber)m.subtract(d).divide(n)).floorFraction();
                        return m.plus(F.CN1.times(n).times(subExpr));
                    }
                    if (m.isComplex() || n.isComplex() || d.isComplex() || m.isComplexNumeric() || n.isComplexNumeric() || d.isComplexNumeric()) {
                        IExpr subExpr = engine.evaluate(F.Divide(F.Subtract(m, d), n));
                        IExpr re = S.Round.of(subExpr.re());
                        IExpr im = S.Round.of(subExpr.im());
                        return F.Plus(m, (IExpr)F.Times((IExpr)F.CN1, n, re), (IExpr)F.Times((IExpr)F.CI, im));
                    }
                }
                return F.NIL;
            }
            if (m.isInteger() && n.isInteger()) {
                IInteger i0 = (IInteger)m;
                IInteger i1 = (IInteger)n;
                if (i1.isNegative()) {
                    return i0.negate().mod(i1.negate()).negate();
                }
                return i0.mod(i1);
            }
            if (m.isReal() && n.isReal()) {
                return F.Subtract(m, F.Times(n, (IExpr)F.Floor(((ISignedNumber)m).divideBy((ISignedNumber)n))));
            }
            IExpr div = S.Divide.of(engine, m, n);
            if (div.isIndeterminate()) {
                return S.Indeterminate;
            }
            if (div.isNumericFunction(true) || div.isDirectedInfinity() || div.isComplexInfinity()) {
                return F.Subtract(m, F.Times(n, (IExpr)F.Floor(div)));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class IntegerPart
    extends AbstractFunctionEvaluator {
        private IntegerPart() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IExpr arg1 = ast.arg1();
                if (arg1.isNumber()) {
                    return ((INumber)arg1).integerPart();
                }
                if (arg1.isIntegerResult()) {
                    return arg1;
                }
                if (arg1.isInfinity() || arg1.isNegativeInfinity() || arg1.isDirectedInfinity(F.CI) || arg1.isDirectedInfinity(F.CNI) || arg1.isAST(S.IntegerPart, 2)) {
                    return arg1;
                }
                IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
                if (negExpr.isPresent()) {
                    return F.Negate(F.IntegerPart(negExpr));
                }
                if (arg1.isInterval()) {
                    return IntervalSym.mapSymbol(S.IntegerPart, (IAST)arg1);
                }
                ISignedNumber signedNumber = arg1.evalReal();
                if (signedNumber != null) {
                    return signedNumber.integerPart();
                }
                Complex complexNumber = arg1.evalComplex();
                if (complexNumber != null) {
                    return F.complexNum(complexNumber).integerPart();
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("IntegerPart.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(26112);
        }
    }

    private static class IntegerLength
    extends AbstractFunctionEvaluator {
        private IntegerLength() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isInteger()) {
                IInteger radix = F.C10;
                if (ast.isAST2()) {
                    if (ast.arg2().isInteger()) {
                        radix = (IInteger)ast.arg2();
                    } else {
                        return F.NIL;
                    }
                }
                if (radix.isLT(F.C2)) {
                    LOGGER.log(engine.getLogLevel(), "IntegerLength: The base must be greater than 1");
                    return F.NIL;
                }
                IInteger iArg1 = (IInteger)ast.arg1();
                if (iArg1.isZero()) {
                    return F.C1;
                }
                long l = iArg1.integerLength(radix);
                return F.ZZ(l);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class FromDigits
    extends AbstractFunctionEvaluator {
        private FromDigits() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1;
            IExpr base = F.C10;
            if (ast.size() >= 3) {
                base = ast.arg2();
            }
            if ((arg1 = ast.arg1()).isList()) {
                IAST list = (IAST)arg1;
                return this.fromDigits(list, base);
            }
            if (arg1.isString()) {
                StringX str = (StringX)arg1;
                int radix = base.toIntDefault(-1);
                if (radix > 0) {
                    try {
                        return F.ZZ(new BigInteger(str.toString(), radix));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                IASTAppendable digitsList = F.ListAlloc(str.length());
                for (int i = 0; i < str.length(); ++i) {
                    int digit = Integer.MIN_VALUE;
                    char ch = str.charAt(i);
                    if (ch >= '0' && ch <= '9') {
                        digit = Character.digit(ch, radix);
                    } else if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
                        digit = Character.digit(ch, 36);
                    } else {
                        return F.NIL;
                    }
                    if (digit == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    digitsList.append(digit);
                }
                return this.fromDigits(digitsList, base);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private IExpr fromDigits(IAST list, IExpr radix) {
            IASTAppendable result = F.PlusAlloc(list.size());
            int exp = 0;
            for (int i = list.size() - 1; i >= 1; --i) {
                result.append(list.get(i).abs().times(radix.power(exp++)));
            }
            return result;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class FractionalPart
    extends AbstractFunctionEvaluator {
        private FractionalPart() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isNumber()) {
                return ((INumber)arg1).fractionalPart();
            }
            if (arg1.isInfinity() || arg1.isComplexInfinity()) {
                return F.Interval(F.list(F.C0, F.C1));
            }
            if (arg1.isNegativeInfinity()) {
                return F.Interval(F.list(F.CN1, F.C0));
            }
            if (arg1.isDirectedInfinity(F.CI)) {
                return F.Times((IExpr)F.CI, (IExpr)F.Interval(F.list(F.C0, F.C1)));
            }
            if (arg1.isDirectedInfinity(F.CNI)) {
                return F.Times((IExpr)F.CNI, (IExpr)F.Interval(F.list(F.C0, F.C1)));
            }
            if (arg1.isIntegerResult()) {
                return F.C0;
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.FractionalPart(negExpr));
            }
            try {
                ISignedNumber signedNumber = arg1.evalReal();
                if (signedNumber != null) {
                    if (signedNumber.isRangeExclExcl(F.CN1, F.C1)) {
                        return arg1;
                    }
                    IInteger intValue = signedNumber.integerPart();
                    return F.Subtract(arg1, intValue);
                }
                Complex complexNumber = arg1.evalComplex();
                if (complexNumber != null) {
                    double re = complexNumber.getReal();
                    double im = complexNumber.getImaginary();
                    if (re > -1.0 && re < 1.0 && im > -1.0 && im < 1.0) {
                        return arg1;
                    }
                    INumber intValue = F.complexNum(complexNumber).integerPart();
                    return F.Subtract(arg1, intValue);
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("FractionalPart.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(26112);
        }
    }

    private static final class Floor
    extends AbstractFunctionEvaluator
    implements INumeric {
        private Floor() {
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.floor(stack[top]);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST2()) {
                    return F.Times((IExpr)F.Floor(F.Divide(ast.arg1(), ast.arg2())), ast.arg2());
                }
                IExpr arg1 = engine.evaluateNIL(ast.arg1());
                if (arg1.isPresent()) {
                    return this.evalFloor(arg1).orElseGet(() -> F.Floor(arg1));
                }
                return this.evalFloor(ast.arg1());
            }
            catch (ArithmeticException arithmeticException) {
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        public IExpr evalFloor(IExpr arg1) {
            IASTAppendable[] splittedPlus;
            if (arg1.isNumber()) {
                return ((INumber)arg1).floorFraction();
            }
            INumber number = arg1.evalNumber();
            if (number != null) {
                return number.floorFraction();
            }
            if (arg1.isIntegerResult()) {
                return arg1;
            }
            if (arg1.isDirectedInfinity() && arg1.argSize() == 1) {
                return arg1;
            }
            if (arg1.isComplexInfinity()) {
                return arg1;
            }
            if (arg1.isPlus() && (splittedPlus = ((IAST)arg1).filterNIL(new FloorPlusFunction()))[0].size() > 1) {
                if (splittedPlus[1].size() > 1) {
                    splittedPlus[0].append(F.Floor(splittedPlus[1].oneIdentity0()));
                }
                return splittedPlus[0];
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.Ceiling(negExpr));
            }
            if (arg1.isInterval()) {
                return IntervalSym.mapSymbol(S.Floor, (IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1632);
            super.setUp(newSymbol);
        }

        private static final class FloorPlusFunction
        implements Function<IExpr, IExpr> {
            private FloorPlusFunction() {
            }

            @Override
            public IExpr apply(IExpr expr) {
                if (expr.isInteger()) {
                    return expr;
                }
                return F.NIL;
            }
        }
    }

    private static class IntegerExponent
    extends AbstractFunctionEvaluator {
        private IntegerExponent() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1;
            IInteger base = F.C10;
            if (ast.isAST2()) {
                IExpr arg2 = ast.arg2();
                if (arg2.isInteger() && ((IInteger)arg2).compareInt(1) > 0) {
                    base = (IInteger)arg2;
                } else {
                    return F.NIL;
                }
            }
            if ((arg1 = ast.arg1()).isInteger()) {
                return ((IInteger)arg1).exponent(base);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class IntegerDigits
    extends AbstractFunctionEvaluator {
        private IntegerDigits() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IInteger base = F.C10;
            int padLeftZeros = 0;
            if (ast.size() >= 3) {
                IExpr arg2 = ast.arg2();
                if (arg2.isInteger() && ((IInteger)arg2).compareInt(1) > 0) {
                    base = (IInteger)arg2;
                } else {
                    return F.NIL;
                }
            }
            if (ast.size() >= 4 && (padLeftZeros = ast.arg3().toIntDefault()) < 0) {
                return F.NIL;
            }
            IExpr arg1 = ast.arg1();
            if (arg1.isInteger()) {
                IInteger n = ((IInteger)arg1).abs();
                return IntegerFunctions.integerDigits(n, base, padLeftZeros);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class DigitCount
    extends AbstractFunctionEvaluator {
        private DigitCount() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr result = F.NIL;
            int radix = 10;
            if (ast.isAST1()) {
                result = S.IntegerDigits.of(engine, ast.arg1());
            } else if (ast.size() >= 3) {
                if (ast.isAST3() && ast.arg3().isList()) {
                    return ((IAST)ast.arg3()).mapThread(ast, 3);
                }
                radix = ast.arg2().toIntDefault();
                if (radix <= 0) {
                    return F.NIL;
                }
                result = S.IntegerDigits.of(engine, ast.arg1(), ast.arg2());
            }
            if (result.isList()) {
                IAST list = result;
                Object2IntOpenHashMap map = new Object2IntOpenHashMap();
                for (int i = 1; i < list.size(); ++i) {
                    map.addTo((Object)list.get(i), 1);
                }
                if (ast.isAST3()) {
                    int index = ast.arg3().toIntDefault();
                    if (index > 0 && index < radix) {
                        int count = map.getInt((Object)F.ZZ(index));
                        return F.ZZ(count);
                    }
                    return F.NIL;
                }
                if (Config.MAX_AST_SIZE < radix) {
                    ASTElementLimitExceeded.throwIt(radix);
                }
                IExpr[] arr = new IExpr[radix];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = F.C0;
                }
                for (Object2IntMap.Entry element : map.object2IntEntrySet()) {
                    IExpr key = (IExpr)element.getKey();
                    int k = key.toIntDefault();
                    if (k == 0) {
                        arr[radix - 1] = F.ZZ(element.getIntValue());
                        continue;
                    }
                    if (k > 0 && k < radix) {
                        arr[k - 1] = F.ZZ(element.getIntValue());
                        continue;
                    }
                    return F.NIL;
                }
                return F.ast(arr, S.List);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }
    }

    private static final class Ceiling
    extends AbstractFunctionEvaluator
    implements INumeric {
        private Ceiling() {
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.ceil(stack[top]);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST2()) {
                    return F.Times((IExpr)F.Ceiling(F.Divide(ast.arg1(), ast.arg2())), ast.arg2());
                }
                IExpr arg1 = engine.evaluateNIL(ast.arg1());
                if (arg1.isPresent()) {
                    return this.evalCeiling(arg1).orElseGet(() -> F.Ceiling(arg1));
                }
                return this.evalCeiling(ast.arg1());
            }
            catch (ArithmeticException arithmeticException) {
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        public IExpr evalCeiling(IExpr arg1) {
            IASTAppendable[] splittedPlus;
            if (arg1.isNumber()) {
                return ((INumber)arg1).ceilFraction();
            }
            INumber number = arg1.evalNumber();
            if (number != null) {
                return number.ceilFraction();
            }
            if (arg1.isIntegerResult()) {
                return arg1;
            }
            if (arg1.isDirectedInfinity() && arg1.argSize() == 1) {
                return arg1;
            }
            if (arg1.isComplexInfinity()) {
                return arg1;
            }
            if (arg1.isPlus() && (splittedPlus = ((IAST)arg1).filterNIL(new CeilingPlusFunction()))[0].size() > 1) {
                if (splittedPlus[1].size() > 1) {
                    splittedPlus[0].append(F.Ceiling(splittedPlus[1].oneIdentity0()));
                }
                return splittedPlus[0];
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.Floor(negExpr));
            }
            if (arg1.isInterval()) {
                return IntervalSym.mapSymbol(S.Ceiling, (IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1632);
            super.setUp(newSymbol);
        }

        private static final class CeilingPlusFunction
        implements Function<IExpr, IExpr> {
            private CeilingPlusFunction() {
            }

            @Override
            public IExpr apply(IExpr expr) {
                if (expr.isInteger()) {
                    return expr;
                }
                return F.NIL;
            }
        }
    }

    private static class BitLength
    extends AbstractFunctionEvaluator {
        private BitLength() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isInteger()) {
                IInteger iArg1 = (IInteger)ast.arg1();
                BigInteger big = iArg1.toBigNumerator();
                return F.ZZ(big.bitLength());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.BitLength.setEvaluator(new BitLength());
            S.Ceiling.setEvaluator(new Ceiling());
            S.DigitCount.setEvaluator(new DigitCount());
            S.Floor.setEvaluator(new Floor());
            S.FractionalPart.setEvaluator(new FractionalPart());
            S.FromDigits.setEvaluator(new FromDigits());
            S.IntegerDigits.setEvaluator(new IntegerDigits());
            S.IntegerExponent.setEvaluator(new IntegerExponent());
            S.IntegerLength.setEvaluator(new IntegerLength());
            S.IntegerPart.setEvaluator(new IntegerPart());
            S.Mod.setEvaluator(new Mod());
            S.PowerMod.setEvaluator(new PowerMod());
            S.Quotient.setEvaluator(new Quotient());
            S.QuotientRemainder.setEvaluator(new QuotientRemainder());
            S.RealDigits.setEvaluator(new RealDigits());
            S.Round.setEvaluator(new Round());
            S.UnitStep.setEvaluator(new UnitStep());
        }
    }
}

