/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.cache.PebbleCache;
import com.mitchellbosecke.pebble.node.BodyNode;
import com.mitchellbosecke.pebble.node.PrintNode;
import com.mitchellbosecke.pebble.node.RenderableNode;
import com.mitchellbosecke.pebble.node.RootNode;
import com.mitchellbosecke.pebble.node.TextNode;
import com.mitchellbosecke.pebble.node.expression.ContextVariableExpression;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.exception.MathRuntimeException;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.StringFunctions;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.ContextPath;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.RulesData;
import org.matheclipse.parser.client.ParserConfig;
import org.matheclipse.parser.trie.SuggestTree;

public class IOFunctions {
    private static final Logger LOGGER = LogManager.getLogger();
    private static PebbleEngine PEBBLE_ENGINE = new PebbleEngine.Builder().build();
    private static final String[] MESSAGES = new String[]{"argillegal", "Illegal arguments: \"`1`\" in `2`", "argb", "`1` called with `2` arguments; between `3` and `4` arguments are expected.", "argct", "`1` called with `2` arguments.", "argctu", "`1` called with 1 argument.", "argm", "`1` called with `2` arguments; `3` or more arguments are expected.", "argr", "`1` called with 1 argument; `2` arguments are expected.", "argrx", "`1` called with `2` arguments; `3` arguments are expected.", "argx", "`1` called with `2` arguments; 1 argument is expected.", "argt", "`1` called with `2` arguments; `3` or `4` arguments are expected.", "argtu", "`1` called with 1 argument; `2` or `3` arguments are expected.", "argtype", "Arguments `1` and `2` of `3` should be either non-negative integers or one-character strings.", "arg2", "Cannot divide sides of an equation or inequality by 0.", "base", "Requested base `1` in `2` should be between 2 and `3`.", "boxfmt", "`1` is not a box formatting type.", "cfn", "Numerical error encountered, proceeding with uncompiled evaluation.", "coef", "The first argument `1` of `2` should be a non-empty list of positive integers.", "color", "`1` is not a valid color or gray-level specification.", "compat", "`1` and `2` are incompatible units", "cxt", "`1` is not a valid context name.", "divz", "The argument `1` should be nonzero.", "digit", "Digit at position `1` in `2` is too large to be used in base `3`.", "dmval", "Input value `1` lies outside the range of data in the interpolating function. Extrapolation will be used.", "dotdim", "Dot contraction of `1` and `2` is invalid because dimensions `3` and `4` are incompatible.", "dotsh", "Tensors `1` and `2` have incompatible shapes.", "drop", "Cannot drop positions `1` through `2` in `3`.", "dvar", "Multiple derivative specifier `1` does not have the form {variable, n} where n is a symbolic expression or a non-negative integer.", "empt", "Argument `1` should be a non-empty list.", "eqf", "`1` is not a well-formed equation.", "eqin", "`1` should be an equation or inequality.", "error", "`1`.", "exact", "Argument `1` is not an exact number.", "exdims", "The dimensions cannot be determined from the position `1`.", "experimental", "Experimental implementation (search in Github issues for identifier `1`).", "fdup", "Duplicate parameter `1` found in `2`.", "fftl", "Argument `1` is not a non-empty list or rectangular array of numeric quantities.", "fpct", "To many parameters in `1` to be filled from `2`.", "fnsym", "First argument in `1` is not a symbol or a string naming a symbol.", "heads", "Heads `1` and `2` are expected to be the same.", "idim", "`1` and `2` must have the same length.", "ifun", "Inverse functions are being used. Values may be lost for multivalued inverses.", "ilsmn", "Single or list of non-negative machine-sized integers expected at position `1` of `2`.", "ilsnn", "Single or list of non-negative integers expected at position `1`.", "incom", "Length `1` of dimension `2` in `3` is incommensurate with length `4` of dimension `5` in `6`.", "incomp", "Expressions `1` and `2` have incompatible shapes.", "incpt", "incompatible elements in `1` cannot be joined.", "indet", "Indeterminate expression `1` encountered.", "infy", "Infinite expression `1` encountered.", "innf", "Non-negative integer or Infinity expected at position `1` in `2`.", "ins", "Cannot insert at position `1` in `2`.", "int", "Integer expected at position `2` in `1`.", "intjava", "Java int value greater equal `1` expected instead of `2`.", "intlevel", "Level specification value greater equal `1` expected instead of `2`.", "intnn", "Non-negative integer expected.", "intnm", "Non-negative machine-sized integer expected at position `2` in `1`.", "intm", "Machine-sized integer expected at position `2` in `1`.", "intp", "Positive integer expected.", "intpm", "Positive machine-sized integer expected at position `2` in `1`.", "intpoint", "`1` is expected to contain a list of lists of integers.", "intpp", "Positive integer argument expected in `1`.", "intrange", "Integer expected in range `1` to `2`.", "inv", "The argument `2`  in  `1`  is not valid. 0 or 2 arguments expected.", "invak", "The argument is not a rule or a list of rules.", "invdt", "The argument `1` is not a valid Association.", "invdt2", "The argument `1` is not a rule or a list of rules.", "invidx2", "Index `1` should be a machine sized integer between `2` and `3`.", "invrl", "The argument `1` is not a valid Association or a list of rules.", "iopnf", "Value of option `1` should be a non-negative integer or Infinity.", "iterb", "Iterator does not have appropriate bounds.", "itform", "Argument `1` at position `2` does not have the correct form for an iterator.", "itlim", "Iteration limit of `1` exceeded.", "itlimpartial", "Iteration limit of `1` exceeded. Returning partial results.", "itendless", "Endless iteration detected in `1` in evaluation loop.", "itraw", "Raw object `1` cannot be used as an iterator.", "ivar", "`1` is not a valid variable.", "ldata", "`1` is not a valid dataset or a list of datasets.", "lend", "The argument at position `1` in `2` should be a vector of unsigned byte values or a Base64 encoded string.", "level", "Level specification `1` is not of the form n, {n}, or {m, n}.", "levelpad", "The padding specification `1` involves `2` levels, the list `3` has only `4` level.", "limset", "Cannot set $RecursionLimit to `1`; value must be Infinity or an integer at least 20.", "list", "List expected at position `1` in `2`.", "listofbigints", "List of Java BigInteger numbers expected in `1`.", "listofints", "List of Java int numbers expected in `1`.", "listoflongs", "List of Java long numbers expected in `1`.", "listrp", "List or SparseArray or structured array expected at position `1` in `2`.", "locked", "Symbol `1` is locked.", "lowlen", "Required length `1` is smaller than maximum `2` of support of `3`.", "lslc", "Coefficient matrix and target vector or matrix do not have the same dimensions.", "lvlist", "Local variable specification `1` is not a List.", "lvws", "Variable `1` in local variable specification `2` requires assigning a value", "lvset", "Local variable specification `1` contains `2`, which is an assignment to `3`; only assignments to symbols are allowed.", "lvsym", "Local variable specification `1` contains `2` which is not a symbol or an assignment to a symbol.", "matrix", "Argument `1` at position `2` is not a non-empty rectangular matrix.", "matsq", "Argument `1` at position `2` is not a non-empty square matrix.", "mseqs", "Sequence specification or a list of sequence specifications expected at position `1` in `2`.", "nalph", "The alphabet `1` is not known or not available.", "nas", "The argument `1` is not a string.", "needsjdk", "For compiling functions, Symja needs to be executed on a Java Development Kit with javax.tools.JavaCompiler installed.", "nconvss", "The argument `1` cannot be converted to a NumericArray of type `2` using method `3`", "nliter", "Non-list iterator `1` at position `2` does not evaluate to a real numeric value.", "nil", "unexpected NIL expression encountered.", "ninv", "`1` is not invertible modulo `2`.", "nocatch", "Uncaught `1` returned to top level.", "nofirst", "`1` has zero length and no first element.", "nofwd", "No enclosing For, While or Do found for `1`.", "noneg", "Argument `1` should be a real non-negative number.", "nonegs", "Surd is not defined for even roots of negative values.", "nolast", "`1` has zero length and no last element.", "nomost", "Cannot take Most of expression `1` with length zero.", "nonn1", "The arguments are expected to be vectors of equal length, and the number of arguments is expected to be 1 less than their length.", "noopen", "Cannot open `1`.", "nonopt", "Options expected (instead of `1`) beyond position `2` in `3`. An option must be a rule or a list of rules.", "nord", "Invalid comparison with `1` attempted.", "normal", "Nonatomic expression expected at position `1` in `2`.", "nostr", "`1` is not a string.", "notent", "`2` is not a known entity, class, or tag for `1`.", "nquan", "The Quantile specification `1` should be a number between `2` and `3`.", "nvld", "The expression `1` is not a valid interval.", "notunicode", "A character unicode, which should be a non-negative integer less than 1114112, is expected at position `2` in `1`.", "noprime", "There are no primes in the specified interval.", "norel", "Expressions `1` and `2` cannot be related by a permutation.", "noval", "Symbol `1` in part assignment does not have an immediate value.", "nupr", "`1` is not a univariate polynomial with rational number coefficients.", "nvm", "The first Norm argument should be a scalar, vector or matrix.", "openx", "`1` is not open.", "optb", "Optional object `1` in `2` is not a single blank.", "optnf", "Option name `2` not found in defaults for `1`.", "opttf", "Value of option `1`->`2` should be True or False.", "optx", "Unknown option `1` in `2`.", "ovfl", "Overflow occurred in computation.", "padlevel", "The padding specification `1` involves `2` levels; the list `3` has only `4` level.", "pairs", "The first argument `1` of `2` is not a list of pairs.", "partd", "Part specification `1` is longer than depth of object.", "partw", "Part `1` of `2` does not exist.", "patop", "Pattern `1` contains inappropriate optional object.", "patvar", "First element in `1` is not a valid pattern name.", "perm", "`1` is not a valid permutation.", "permlist", "Invalid permutation list `1`.", "pilist", "The arguments to `1` must be two lists of integers of identical length, with the second list only containing positive integers.", "plen", "`1` and `2` should have the same length.", "plld", "Endpoints in `1` must be distinct machine-size real numbers.", "pllim", "Range specification `1` is not of the form {x, xmin, xmax}.", "plln", "Limiting value `1` in `2` is not a machine-size real number.", "pkspec1", "The expression `1` cannot be used as a part specification.", "prng", "Value of option `1` is not All, Full, Automatic, a positive machine number, or an appropriate list of range specifications.", "psl1", "Position specification `1` in `2` is not applicable.", "pspec", "Part specification `1` is neither an integer nor a list of integer.", "poly", "`1` is not a polynomial.", "polynomial", "Polynomial expected at position `1` in `2`.", "posdim", "The dimension parameter `1` is expected to be a positive integer or a list of positive integers.", "pospoint", "`1` contains integers that are not positive.", "posprm", "Parameter `1` at position `2` in `3` is expected to be positive.", "posr", "The left hand side of `2` in `1` doesn't match an int-array of depth `3`.", "preal", "The parameter `1` should be real-valued.", "precsm", "Requested precision `1` is smaller than `2`.", "precgt", "Requested precision `1` is greater than `2`.", "pts", "`1` should be a non-empty list of points.", "range", "Range specification in `1` does not have appropriate bounds.", "rank", "The rank `1` is not an integer between `2` and  `3`.", "rankl", "The list `1` of dimensions must have length `2`.", "rctndm1", "The argument `1` at position `2` should be a rectangular array of real numbers with length greater than the dimension of the array or two such arrays with of equal dimension.", "realx", "The value `1` is not a real number.", "reclim2", "Recursion depth of `1` exceeded during evaluation of `2`.", "rect", "Nonrectangular tensor encountered", "rectt", "Rectangular array expected at position `1` in `2`.", "reppoint", "`1` contains repeated integers.", "reps", "(`1`) is neither a list of replacement nor a valid dispatch table and cannot be used for replacing.", "root", "Unable to determine the appropriate root for the periodic continued fraction.", "rrlim", "Exiting after `1` scanned `2` times.", "rvalue", "`1` is not a variable with a value, so its value cannot be changed.", "rvec", "Input `1` is not a vector of reals or integers.", "rvec2", "Input `1` is not a real-valued vector.", "rubiendless", "Endless iteration detected in `1` for Rubi pattern-matching rules.", "sdmint", "The number of subdivisions given in position `1` of `2` should be a positive machine-sized integer.", "seqs", "Sequence specification expected, but got `1`.", "setp", "Part assignment to `1` could not be made", "setraw", "Cannot assign to raw object `1`.", "setps", "`1` in the part assignment is not a symbol.", "sing", "Matrix `1` is singular.", "sing1", "The matrix `1` is singular; a factorization will not be saved.", "span", "`1` is not a valid Span specification.", "ssle", "Symbol, string or HoldPattern(symbol) expected at position `2` in `1`.", "step", "The step size `1` is expected to be positive", "stream", "`1` is not string, InputStream[], or OutputStream[]", "string", "String expected at position `1` in `2`.", "strse", "String or list of strings expected at position `1` in `2`.", "sym", "Argument `1` at position `2` is expected to be a symbol.", "tag", "Rule for `1` can only be attached to `2`.", "tagnf", "Tag `1` not found in `2`.", "take", "Cannot take positions `1` through `2` in `3`.", "tbnval", "Values `1` produced by the function `2` cannot be used for numerical sorting because they are not all real.", "tdlen", "Objects of unequal length in `1` cannot be combined.", "tllen", "Lists of unequal length in `1` cannot be added.", "toggle", "ToggleFeature `1` is disabled.", "udist", "The specification `1` is not a random distribution recognized by the system.", "unsupported", "`1` currently not supported in `2`.", "usraw", "Cannot unset object `1`.", "vloc", "The variable `1` cannot be localized so that it can be assigned to numerical values.", "vpow2", "Argument `1` is restricted to vectors with a length of power of 2.", "vrule", "Cannot set `1` to `2`, which is not a valid list of replacement rules.", "write", "Tag `1` in `2` is Protected.", "wrsym", "Symbol `1` is Protected.", "ucdec", "An invalid unicode sequence was encountered and ignored.", "zzdivzero", "Division by zero `1`.", "zzmaxast", "Maximum AST limit `1` exceeded.", "zznotimpl", "Function `1` not implemented.", "zzprime", "Maximum Prime limit `1` exceeded.", "zzregex", "Regex expression `1` error message: `2`.", "zzapfloatcld", "Complete loss of accurate digits (apfloat)."};

    public static void initialize() {
        Initializer.init();
    }

    public static IExpr message(ISymbol symbol, String messageShortcut, IAST list) {
        IExpr temp = symbol.evalMessage(messageShortcut);
        String message = null;
        if (temp.isPresent()) {
            message = temp.toString();
        } else {
            temp = S.General.evalMessage(messageShortcut);
            if (temp.isPresent()) {
                message = temp.toString();
            }
        }
        if (message != null) {
            message = IOFunctions.rawMessage(list, message);
            return F.stringx(symbol.toString() + ": " + message);
        }
        return F.NIL;
    }

    public static IAST printArgMessage(IAST ast, int[] expected, EvalEngine engine) {
        IExpr head = ast.head();
        ISymbol topHead = ast.topHead();
        int argSize = ast.argSize();
        if (expected[0] == expected[1]) {
            if (expected[0] == 1) {
                return IOFunctions.printMessage(topHead, "argx", F.list(head, F.ZZ(argSize), F.ZZ(expected[0])), engine);
            }
            if (argSize == 1) {
                return IOFunctions.printMessage(topHead, "argr", F.list(head, F.ZZ(expected[0])), engine);
            }
            return IOFunctions.printMessage(topHead, "argrx", F.list(head, F.ZZ(argSize), F.ZZ(expected[0])), engine);
        }
        if (expected[1] == Integer.MAX_VALUE) {
            return IOFunctions.printMessage(topHead, "argm", F.list(head, F.ZZ(argSize), F.ZZ(expected[0])), engine);
        }
        return IOFunctions.printMessage(topHead, "argt", F.List(head, F.ZZ(argSize), F.ZZ(expected[0]), F.ZZ(expected[1])), engine);
    }

    public static IExpr printMessage(ISymbol symbol, ValidateException ve, EvalEngine engine) {
        LOGGER.log(engine.getLogLevel(), "{}: {}", (Object)symbol, (Object)ve.getMessage());
        return F.NIL;
    }

    public static IExpr printMessage(ISymbol symbol, MathRuntimeException mex, EvalEngine engine) {
        LOGGER.log(engine.getLogLevel(), "{}: {}", (Object)symbol, (Object)mex.getMessage());
        return F.NIL;
    }

    public static IAST printExperimental(IBuiltInSymbol symbol) {
        EvalEngine engine = EvalEngine.get();
        if (!engine.containsExperimental(symbol)) {
            IOFunctions.printMessage(symbol, "experimental", F.list(symbol), EvalEngine.get());
            engine.incExperimentalCounter(symbol);
        }
        return F.NIL;
    }

    public static void printIfunMessage(ISymbol symbol) {
        IOFunctions.printMessage(symbol, "ifun", F.CEmptyList, EvalEngine.get());
    }

    public static IAST printMessage(ISymbol symbol, String messageShortcut, IAST listOfParameters, EvalEngine engine) {
        IExpr temp = symbol.evalMessage(messageShortcut);
        Object message = null;
        if (temp.isPresent()) {
            message = temp.toString();
        } else {
            temp = S.General.evalMessage(messageShortcut);
            if (temp.isPresent()) {
                message = temp.toString();
            }
        }
        if (message == null) {
            message = "Undefined message shortcut: " + messageShortcut;
            engine.setMessageShortcut(messageShortcut);
            LOGGER.log(engine.getLogLevel(), "{}: {}", (Object)symbol, message);
        } else {
            try {
                StringWriter writer = new StringWriter();
                HashMap<String, Object> context = new HashMap<String, Object>();
                if (listOfParameters != null) {
                    for (int i = 1; i < listOfParameters.size(); ++i) {
                        context.put(Integer.toString(i), IOFunctions.shorten(listOfParameters.get(i)));
                    }
                }
                IOFunctions.templateApply((String)message, writer, context);
                engine.setMessageShortcut(messageShortcut);
                LOGGER.log(engine.getLogLevel(), "{}: {}", (Object)symbol, (Object)writer);
            }
            catch (IOException e) {
                LOGGER.error("IOFunctions.printMessage() failed", (Throwable)e);
            }
        }
        return F.NIL;
    }

    public static String getMessage(String messageShortcut, IAST listOfArgs) {
        return IOFunctions.getMessage(messageShortcut, listOfArgs, EvalEngine.get());
    }

    public static String getMessage(String messageShortcut, IAST listOfArgs, EvalEngine engine) {
        IExpr temp = S.General.evalMessage(messageShortcut);
        Object message = null;
        if (temp.isPresent()) {
            message = temp.toString();
        }
        if (message == null) {
            message = "Undefined message shortcut: " + messageShortcut;
            engine.setMessageShortcut(messageShortcut);
            return message;
        }
        for (int i = 1; i < listOfArgs.size(); ++i) {
            message = StringUtils.replace((String)message, (String)("`" + i + "`"), (String)IOFunctions.shorten(listOfArgs.get(i)));
        }
        engine.setMessageShortcut(messageShortcut);
        return message;
    }

    private static String rawMessage(IAST list, String message) {
        for (int i = 2; i < list.size(); ++i) {
            message = StringUtils.replace((String)message, (String)("`" + (i - 1) + "`"), (String)IOFunctions.shorten(list.get(i)));
        }
        return message;
    }

    public static String shorten(IExpr expr) {
        return IOFunctions.shorten(expr, Config.SHORTEN_STRING_LENGTH);
    }

    public static String shorten(IExpr expr, int maximuLength) {
        String str = expr.toString();
        return IOFunctions.shorten(str, maximuLength);
    }

    public static String shorten(String str, int maximuLength) {
        if (str.length() > maximuLength) {
            StringBuilder buf = new StringBuilder(maximuLength);
            int halfLength = maximuLength / 2 - 14;
            buf.append(str.substring(0, halfLength));
            buf.append("<<SHORT>>");
            buf.append(str.substring(str.length() - halfLength));
            return buf.toString();
        }
        return str;
    }

    private static PebbleTemplate templateCompile(String templateStr) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        int length = templateStr.length();
        int currentPosition = 0;
        int counter = 1;
        int lastLineNumber = 0;
        int lineNumber = 0;
        int lastPosition = 0;
        while (currentPosition < length) {
            char ch;
            if ((ch = templateStr.charAt(currentPosition++)) == '\n') {
                ++lineNumber;
                continue;
            }
            if (ch != '`') continue;
            if (lastPosition < currentPosition - 1) {
                nodes.add(new TextNode(templateStr.substring(lastPosition, currentPosition - 1), lastLineNumber));
                lastPosition = currentPosition;
                lastLineNumber = lineNumber;
            }
            int j = currentPosition;
            StringBuilder nameBuf = new StringBuilder();
            while (j < length) {
                char nextCh;
                if ((nextCh = templateStr.charAt(j++)) == '`') {
                    if (j == currentPosition + 1) {
                        nameBuf.append(counter++);
                    }
                    currentPosition = j;
                    break;
                }
                nameBuf.append(nextCh);
            }
            ContextVariableExpression expression = new ContextVariableExpression(nameBuf.toString(), lineNumber);
            nodes.add(new PrintNode((Expression)expression, lineNumber));
            lastPosition = currentPosition;
            lastLineNumber = lineNumber;
        }
        if (lastPosition < length) {
            nodes.add(new TextNode(templateStr.substring(lastPosition, length), lineNumber));
            lastPosition = currentPosition;
        }
        BodyNode body = new BodyNode(0, nodes);
        RootNode rootNode = new RootNode(body);
        return new PebbleTemplateImpl(PEBBLE_ENGINE, (RenderableNode)rootNode, templateStr);
    }

    private static void templateApply(String templateString, Writer outputWriter, Map<String, Object> context) throws IOException {
        PebbleCache cache = PEBBLE_ENGINE.getTemplateCache();
        PebbleTemplate template = (PebbleTemplate)cache.computeIfAbsent((Object)templateString, x -> IOFunctions.templateCompile(templateString));
        template.evaluate(outputWriter, context);
    }

    public static IStringX templateApply(String templateStr, IExpr args) {
        String str = IOFunctions.templateRender(templateStr, args);
        return F.stringx(str);
    }

    public static String templateRender(String templateStr, IExpr args) {
        try {
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (args.isListOrAssociation()) {
                if (args.isList()) {
                    IAST list = (IAST)args;
                    for (int i = 1; i < list.size(); ++i) {
                        context.put(Integer.toString(i), list.get(i).toString());
                    }
                } else if (args.isAssociation()) {
                    IAssociation assoc = (IAssociation)args;
                    for (int i = 1; i < assoc.size(); ++i) {
                        IAST rule = assoc.getRule(i);
                        IExpr lhs = rule.arg1();
                        IExpr rhs = rule.arg2();
                        context.put(lhs.toString(), rhs.toString());
                    }
                }
            }
            StringWriter writer = new StringWriter();
            IOFunctions.templateApply(templateStr, writer, context);
            return ((Object)writer).toString();
        }
        catch (IOException e) {
            LOGGER.error("IOFunctions.templateRender()", (Throwable)e);
            return templateStr;
        }
    }

    public static String templateRender(String templateStr, String[] args) {
        try {
            HashMap<String, Object> context = new HashMap<String, Object>();
            int i = 1;
            for (String str : args) {
                context.put(Integer.toString(i++), str);
            }
            StringWriter writer = new StringWriter();
            IOFunctions.templateApply(templateStr, writer, context);
            return ((Object)writer).toString();
        }
        catch (IOException e) {
            LOGGER.error("IOFunctions.templateRender() failed", (Throwable)e);
            return templateStr;
        }
    }

    public static IAST getNamesByPattern(Pattern pattern, EvalEngine engine) {
        ISymbol value;
        String str;
        Matcher matcher;
        String fullName;
        ContextPath contextPath = engine.getContextPath();
        IASTAppendable list = F.ListAlloc(31);
        Map<String, Context> contextMap = contextPath.getContextMap();
        for (Map.Entry<String, Context> mapEntry : contextMap.entrySet()) {
            Context context = mapEntry.getValue();
            for (Map.Entry<String, ISymbol> entry : context.entrySet()) {
                fullName = context.completeContextName() + entry.getKey();
                matcher = pattern.matcher(fullName);
                if (!matcher.matches()) continue;
                if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && context.equals(Context.SYSTEM) && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(entry.getValue().getSymbolName())) != null) {
                    list.append(F.$str(str));
                    continue;
                }
                value = entry.getValue();
                if (context.isGlobal() || context.isSystem()) {
                    list.append(F.$str(value.toString()));
                    continue;
                }
                list.append(F.$str(fullName));
            }
        }
        for (Context context : contextPath) {
            String completeContextName = context.completeContextName();
            if (contextMap.containsKey(completeContextName)) continue;
            for (Map.Entry<String, ISymbol> entry : context.entrySet()) {
                fullName = completeContextName + entry.getKey();
                matcher = pattern.matcher(fullName);
                if (!matcher.matches()) continue;
                if (ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS && context.equals(Context.SYSTEM) && (str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(entry.getValue().getSymbolName())) != null) {
                    list.append(F.$str(str));
                    continue;
                }
                value = entry.getValue();
                if (context.isGlobal() || context.isSystem()) {
                    list.append(F.$str(value.toString()));
                    continue;
                }
                list.append(F.$str(fullName));
            }
        }
        return list;
    }

    public static IAST getNamesByPrefix(String name) {
        SuggestTree suggestTree;
        SuggestTree.Node n;
        if (name.length() == 0) {
            return F.CEmptyList;
        }
        boolean exact = true;
        if (name.charAt(name.length() - 1) == '*') {
            if ((name = name.substring(0, name.length() - 1)).length() == 0) {
                return IOFunctions.getAllNames();
            }
            exact = false;
        }
        if ((n = (suggestTree = AST2Expr.getSuggestTree()).getAutocompleteSuggestions(name = name.toLowerCase())) != null) {
            IASTAppendable list = F.ListAlloc(n.listLength());
            for (int i = 0; i < n.listLength(); ++i) {
                String identifierStr = n.getSuggestion(i).getTerm();
                String str = AST2Expr.PREDEFINED_SYMBOLS_MAP.get(identifierStr);
                if (str != null) {
                    identifierStr = str;
                }
                if (exact) {
                    if (!name.equals(identifierStr.toLowerCase())) continue;
                    list.append(F.$s(identifierStr));
                    continue;
                }
                list.append(F.$s(identifierStr));
            }
            return list;
        }
        return F.CEmptyList;
    }

    public static List<String> getAutoCompletionList(String namePrefix) {
        ArrayList<String> list = new ArrayList<String>();
        if (namePrefix.length() == 0) {
            return list;
        }
        SuggestTree suggestTree = AST2Expr.getSuggestTree();
        SuggestTree.Node n = suggestTree.getAutocompleteSuggestions(namePrefix = ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS ? namePrefix.toLowerCase() : namePrefix);
        if (n != null) {
            for (int i = 0; i < n.listLength(); ++i) {
                list.add(n.getSuggestion(i).getTerm());
            }
        }
        return list;
    }

    public static IAST getAllNames() {
        int size = AST2Expr.FUNCTION_STRINGS.length;
        IASTAppendable list = F.ListAlloc(size);
        return list.appendArgs(0, size, i -> F.$s(AST2Expr.FUNCTION_STRINGS[i]));
    }

    private IOFunctions() {
    }

    private static class Print
    extends AbstractCoreFunctionEvaluator {
        private Print() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            PrintStream stream = engine.getOutPrintStream();
            StringBuilder buf = new StringBuilder();
            OutputFormFactory out = OutputFormFactory.get(engine.isRelaxedSyntax());
            boolean[] convert = new boolean[]{true};
            ast.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> {
                IExpr temp = engine.evaluate((IExpr)x);
                Print.printExpression(temp, out, buf, convert, engine);
            }));
            if (!convert[0]) {
                stream.println("ERROR-IN-OUTPUTFORM");
                return S.Null;
            }
            stream.println(buf.toString());
            return S.Null;
        }

        protected static void printExpression(IExpr x, OutputFormFactory out, StringBuilder buf, boolean[] convert, EvalEngine engine) {
            if (x instanceof IStringX) {
                buf.append(x.toString());
            } else if (x.isASTSizeGE(S.Style, 2)) {
                Print.printExpression(x.first(), out, buf, convert, engine);
            } else if (convert[0] && !out.convert(buf, x)) {
                convert[0] = false;
            }
        }
    }

    private static final class Names
    extends AbstractFunctionEvaluator {
        private Names() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            HashMap<ISymbol, String> groups;
            Pattern pattern;
            int indx;
            OptionArgs options;
            IExpr option;
            if (ast.isAST0()) {
                return IOFunctions.getAllNames();
            }
            IExpr arg1 = ast.arg1();
            boolean ignoreCase = ParserConfig.PARSER_USE_LOWERCASE_SYMBOLS;
            if (ast.size() > 2 && (option = (options = new OptionArgs(ast.topHead(), ast, 2, engine, true)).getOption(S.IgnoreCase)).isTrue()) {
                ignoreCase = true;
            }
            if (arg1.isString() && (indx = arg1.toString().indexOf("`")) < 0) {
                arg1 = F.$str("System`" + arg1.toString());
            }
            if ((pattern = StringFunctions.toRegexPattern(arg1, true, ignoreCase, ast, groups = new HashMap<ISymbol, String>(), engine)) == null) {
                return F.NIL;
            }
            return IOFunctions.getNamesByPattern(pattern, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }
    }

    private static class StyleForm
    extends AbstractEvaluator {
        private StyleForm() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head() == S.StyleForm) {
                return ast.apply((IExpr)S.Style);
            }
            return F.NIL;
        }
    }

    private static class Short
    extends AbstractEvaluator {
        private Short() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.stringx(IOFunctions.shorten(ast.arg1()));
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class Messages
    extends AbstractCoreFunctionEvaluator {
        private Messages() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = Validate.checkIsVariable(ast, 1, engine);
            if (arg1.isSymbol()) {
                Map<String, IStringX> map;
                ISymbol symbol = (ISymbol)arg1;
                RulesData rulesData = symbol.getRulesData();
                if (rulesData != null && (map = rulesData.getMessages()) != null) {
                    IASTAppendable result = F.ListAlloc(map.size());
                    for (Map.Entry<String, IStringX> entry : map.entrySet()) {
                        result.append(F.RuleDelayed(F.HoldPattern(F.MessageName(symbol, entry.getKey())), entry.getValue()));
                    }
                    return result;
                }
                return F.CEmptyList;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class Message
    extends AbstractEvaluator {
        private Message() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() > 1) {
                if (ast.arg1().isString()) {
                    String message = ast.arg1().toString();
                    for (int i = 2; i < ast.size(); ++i) {
                        message = message.replaceAll("`" + (i - 1) + "`", ast.get(i).toString());
                    }
                    return F.stringx(": " + message);
                }
                if (ast.arg1().isAST(S.MessageName, 3)) {
                    IExpr temp;
                    IAST messageName = (IAST)ast.arg1();
                    String messageShortcut = messageName.arg2().toString();
                    if (messageName.arg1().isSymbol() && (temp = IOFunctions.message((ISymbol)messageName.arg1(), messageShortcut, ast)).isPresent()) {
                        return temp;
                    }
                    return IOFunctions.message(S.General, messageShortcut, ast);
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(32);
        }
    }

    private static final class EchoFunction
    extends Print {
        private EchoFunction() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1() && ast.head().isAST()) {
                int size = ast.head().size();
                switch (size) {
                    case 1: {
                        return F.unaryAST1(S.Echo, ast.arg1());
                    }
                    case 2: {
                        return EchoFunction.echo(ast.arg1(), ast.head().first(), engine);
                    }
                    case 3: {
                        return F.ternaryAST3(S.Echo, ast.arg1(), ast.head().first(), ast.head().second());
                    }
                }
            }
            return F.NIL;
        }

        private static IExpr echo(IExpr arg1, IExpr headFirst, EvalEngine engine) {
            PrintStream stream = engine.getOutPrintStream();
            StringBuilder buf = new StringBuilder();
            OutputFormFactory out = OutputFormFactory.get(engine.isRelaxedSyntax());
            boolean[] convert = new boolean[]{true};
            IExpr result = engine.evaluate(arg1);
            IExpr arg3 = engine.evaluate(F.unaryAST1(headFirst, arg1));
            EchoFunction.printExpression(arg3, out, buf, convert, engine);
            stream.println(buf.toString());
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2_0;
        }
    }

    private static class Echo
    extends Print {
        private Echo() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            PrintStream stream = engine.getOutPrintStream();
            StringBuilder buf = new StringBuilder();
            OutputFormFactory out = OutputFormFactory.get(engine.isRelaxedSyntax());
            boolean[] convert = new boolean[]{true};
            IExpr arg1 = ast.arg1();
            IExpr result = engine.evaluate(arg1);
            if (ast.argSize() >= 2) {
                IExpr arg2 = engine.evaluate(ast.arg2());
                Echo.printExpression(arg2, out, buf, convert, engine);
                if (ast.isAST3()) {
                    IExpr arg3 = engine.evaluate(F.unaryAST1(ast.arg3(), arg1));
                    Echo.printExpression(arg3, out, buf, convert, engine);
                } else {
                    Echo.printExpression(result, out, buf, convert, engine);
                }
            } else {
                Echo.printExpression(result, out, buf, convert, engine);
            }
            stream.println(buf.toString());
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Echo.setEvaluator(new Echo());
            S.EchoFunction.setEvaluator(new EchoFunction());
            S.Message.setEvaluator(new Message());
            S.Messages.setEvaluator(new Messages());
            S.Names.setEvaluator(new Names());
            S.Print.setEvaluator(new Print());
            S.Short.setEvaluator(new Short());
            S.StyleForm.setEvaluator(new StyleForm());
            for (int i = 0; i < MESSAGES.length; i += 2) {
                S.General.putMessage(1, MESSAGES[i], F.stringx(MESSAGES[i + 1]));
            }
        }
    }
}

