/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import de.lab4inf.math.functions.CosineIntegral;
import de.lab4inf.math.functions.SineIntegral;
import java.util.function.DoubleUnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.complex.Complex;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.functions.GammaJS;
import org.matheclipse.core.builtin.functions.HypergeometricJS;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ResultException;
import org.matheclipse.core.eval.exception.ThrowException;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.Hypergeometric0F1Rules;
import org.matheclipse.core.reflection.system.rules.Hypergeometric2F1Rules;
import org.matheclipse.core.reflection.system.rules.HypergeometricURules;
import org.matheclipse.core.reflection.system.rules.WhittakerMRules;
import org.matheclipse.core.reflection.system.rules.WhittakerWRules;

public class HypergeometricFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void initialize() {
        Initializer.init();
    }

    private HypergeometricFunctions() {
    }

    private static class WhittakerW
    extends AbstractFunctionEvaluator
    implements WhittakerWRules {
        private WhittakerW() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr k = ast.arg1();
            IExpr m = ast.arg2();
            IExpr z = ast.arg3();
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class WhittakerM
    extends AbstractFunctionEvaluator
    implements WhittakerMRules {
        private WhittakerM() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr k = ast.arg1();
            IExpr m = ast.arg2();
            IExpr z = ast.arg3();
            if (engine.isDoubleMode()) {
                try {
                    double kDouble = Double.NaN;
                    double mDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        kDouble = k.evalDouble();
                        mDouble = m.evalDouble();
                        zDouble = z.evalDouble();
                        return F.complexNum(HypergeometricJS.whittakerM(new Complex(kDouble), new Complex(mDouble), new Complex(zDouble)));
                    }
                    catch (ValidateException ve) {
                        IOFunctions.printMessage(ast.topHead(), ve, engine);
                        Complex kc = k.evalComplex();
                        Complex mc = m.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(HypergeometricJS.whittakerM(kc, mc, zc));
                    }
                }
                catch (ThrowException te) {
                    LOGGER.debug("WhittakerM.evaluate() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class SinhIntegral
    extends AbstractFunctionEvaluator {
        private SinhIntegral() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (z.isZero()) {
                return F.C0;
            }
            if (z.isInfinity()) {
                return F.CInfinity;
            }
            if (z.isNegativeInfinity()) {
                return F.CNInfinity;
            }
            if (z.isDirectedInfinity(F.CI)) {
                return F.Times((IExpr)F.CI, (IExpr)F.CPiHalf);
            }
            if (z.isComplexInfinity()) {
                return S.Indeterminate;
            }
            if (engine.isDoubleMode()) {
                try {
                    double zDouble = Double.NaN;
                    try {
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(zDouble)) {
                        Complex zc = z.evalComplex();
                        return F.complexNum(GammaJS.sinhIntegral(zc));
                    }
                    if (F.isZero(zDouble)) {
                        return F.C0;
                    }
                    return F.complexNum(GammaJS.sinhIntegral(new Complex(zDouble)));
                }
                catch (ThrowException te) {
                    LOGGER.debug("SinhIntegral.evaluate() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            if (z.isTimes() && z.first().isComplex() && z.first().re().isZero()) {
                return F.Times((IExpr)S.I, (IExpr)F.SinIntegral(F.Times((IExpr)F.CNI, z)));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(z);
            if (negExpr.isPresent()) {
                return F.Negate(F.SinhIntegral(negExpr));
            }
            IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(z);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CI, (IExpr)F.SinIntegral(imPart));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class SinIntegral
    extends AbstractFunctionEvaluator {
        private SinIntegral() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (z.isZero()) {
                return F.C0;
            }
            if (z.isInfinity()) {
                return F.CPiHalf;
            }
            if (z.isNegativeInfinity()) {
                return F.CNPiHalf;
            }
            if (z.isDirectedInfinity(F.CI)) {
                return z;
            }
            if (z.isComplexInfinity()) {
                return S.Indeterminate;
            }
            if (engine.isDoubleMode()) {
                try {
                    double zDouble = Double.NaN;
                    try {
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(zDouble)) {
                        Complex zc = z.evalComplex();
                        return F.complexNum(GammaJS.sinIntegral(zc));
                    }
                    if (F.isZero(zDouble)) {
                        return F.C0;
                    }
                    if (zDouble <= 0.0) {
                        return F.complexNum(GammaJS.sinIntegral(new Complex(zDouble)));
                    }
                    return F.num(SineIntegral.si((double)zDouble));
                }
                catch (ThrowException te) {
                    LOGGER.debug("SinIntegral.evaluate() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(z);
            if (negExpr.isPresent()) {
                return F.Negate(F.SinIntegral(negExpr));
            }
            if (z.isTimes() && z.first().isComplex() && z.first().re().isZero()) {
                return F.Times((IExpr)S.I, (IExpr)F.SinhIntegral(F.Times((IExpr)F.CNI, z)));
            }
            IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(z);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CI, (IExpr)F.SinhIntegral(imPart));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class LogIntegral
    extends AbstractFunctionEvaluator {
        private LogIntegral() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isZero()) {
                return F.C0;
            }
            if (arg1.isOne()) {
                return F.CNInfinity;
            }
            if (arg1.isInfinity()) {
                return F.CInfinity;
            }
            if (arg1.isComplexInfinity()) {
                return F.CComplexInfinity;
            }
            if (engine.isDoubleMode()) {
                try {
                    double zDouble = Double.NaN;
                    try {
                        zDouble = arg1.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(zDouble)) {
                        Complex zc = arg1.evalComplex();
                        return F.complexNum(GammaJS.logIntegral(zc));
                    }
                    if (F.isZero(zDouble)) {
                        return F.C0;
                    }
                    if (F.isEqual(zDouble, 1.0)) {
                        return F.CNInfinity;
                    }
                    if (zDouble > 0.0) {
                        return F.num(GammaJS.logIntegral(zDouble));
                    }
                    return F.complexNum(GammaJS.logIntegral(new Complex(zDouble)));
                }
                catch (ThrowException te) {
                    LOGGER.debug("LogIntegral.evaluate() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class HypergeometricU
    extends AbstractFunctionEvaluator
    implements HypergeometricURules {
        private HypergeometricU() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr a = ast.arg1();
            IExpr b = ast.arg2();
            IExpr z = ast.arg3();
            if (a.isZero()) {
                return F.C0;
            }
            if (z.isZero()) {
                IExpr bRe = b.re();
                if (bRe.greaterThan(F.C1).isTrue()) {
                    return F.CComplexInfinity;
                }
                if (bRe.lessThan(F.C1).isTrue()) {
                    return F.Divide(F.Gamma(F.Subtract(F.C1, b)), F.Gamma(F.Plus(a, F.Negate(b), (IExpr)F.C1)));
                }
            }
            if (a.equals(b)) {
                return F.Times((IExpr)F.Exp(z), (IExpr)F.Gamma(F.Subtract(F.C1, a), z));
            }
            try {
                IExpr n = engine.evaluate(F.Subtract(b, a));
                if (n.isInteger()) {
                    if (n.isOne()) {
                        return F.Power(z, a.negate());
                    }
                    int nInt = n.toIntDefault();
                    if (nInt > 0) {
                        int nMinus1 = nInt - 1;
                        return F.Times((IExpr)F.Power(z, a.negate()), (IExpr)F.intSum(k -> F.Times((IExpr)F.Binomial(nMinus1, nMinus1 - k), (IExpr)F.Pochhammer(a, F.ZZ(k)), F.Power(z, -k)), 0, nMinus1));
                    }
                }
                if (engine.isDoubleMode()) {
                    double aDouble = Double.NaN;
                    double bDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        aDouble = a.evalDouble();
                        bDouble = b.evalDouble();
                        zDouble = z.evalDouble();
                        return F.complexNum(HypergeometricJS.hypergeometricU(new Complex(aDouble), new Complex(bDouble), new Complex(zDouble)));
                    }
                    catch (ValidateException ve) {
                        IOFunctions.printMessage(ast.topHead(), ve, engine);
                        Complex ac = a.evalComplex();
                        Complex bc = b.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(HypergeometricJS.hypergeometricU(ac, bc, zc));
                    }
                }
            }
            catch (ThrowException te) {
                LOGGER.debug("HypergeometricU.evaluate() failed", (Throwable)((Object)te));
                return te.getValue();
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class HypergeometricPFQ
    extends AbstractFunctionEvaluator {
        private HypergeometricPFQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            block13: {
                IAST bVector;
                IAST aVector;
                IExpr a = ast.arg1();
                IExpr b = ast.arg2();
                IExpr c = ast.arg3();
                if (c.isList()) {
                    return ((IAST)c).mapThread(ast.setAtCopy(3, F.Slot1), 3);
                }
                if (a.isVector() > 0 && !(aVector = (IAST)a.normal(false)).isEvalFlagOn(512)) {
                    IASTMutable aResult = aVector.copy();
                    if (EvalAttributes.sortWithFlags(aResult)) {
                        return F.HypergeometricPFQ(aResult, b, c);
                    }
                    aVector.addEvalFlags(512);
                }
                if (b.isVector() > 0 && !(bVector = (IAST)b.normal(false)).isEvalFlagOn(512)) {
                    IASTMutable bResult = bVector.copy();
                    if (EvalAttributes.sortWithFlags(bResult)) {
                        return F.HypergeometricPFQ(a, bResult, c);
                    }
                    bVector.addEvalFlags(512);
                }
                if (engine.isDoubleMode() && a.isVector() > 0 && b.isVector() > 0) {
                    try {
                        double[] A = a.toDoubleVector();
                        double[] B = b.toDoubleVector();
                        double cDouble = Double.NaN;
                        try {
                            cDouble = c.evalDouble();
                        }
                        catch (ValidateException validateException) {
                            // empty catch block
                        }
                        if (A == null || B == null || Double.isNaN(cDouble)) {
                            Complex[] AC = a.toComplexVector();
                            Complex[] BC = b.toComplexVector();
                            if (AC != null && BC != null) {
                                return F.complexNum(HypergeometricJS.hypergeometricPFQ(AC, BC, c.evalComplex(), Config.DOUBLE_TOLERANCE));
                            }
                            break block13;
                        }
                        INum result = F.num(HypergeometricJS.hypergeometricPFQ(A, B, cDouble));
                        return result;
                    }
                    catch (ValidateException ve) {
                        return IOFunctions.printMessage(ast.topHead(), ve, engine);
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static class Hypergeometric2F1
    extends AbstractFunctionEvaluator
    implements Hypergeometric2F1Rules {
        private Hypergeometric2F1() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            block13: {
                IExpr a = ast.arg1();
                IExpr b = ast.arg2();
                IExpr c = ast.arg3();
                IExpr z = ast.arg4();
                if (a.isZero() || b.isZero() || z.isZero()) {
                    return F.C1;
                }
                if (a.compareTo(b) > 0) {
                    return F.Hypergeometric2F1(b, a, c, z);
                }
                if (c.isInteger() && c.isNegative() && a.isNumber() && b.isNumber()) {
                    return F.CComplexInfinity;
                }
                if (a.isInteger() && a.isNegative() && z.isOne()) {
                    IInteger n = (IInteger)a.negate();
                    return F.Divide(F.Expand(F.Pochhammer(F.Subtract(c, b), n)), F.Pochhammer(c, n));
                }
                if (a.equals(c)) {
                    return F.Power((IExpr)F.Subtract(F.C1, z), F.Negate(b));
                }
                if (b.equals(c)) {
                    return F.Power((IExpr)F.Subtract(F.C1, z), F.Negate(a));
                }
                try {
                    if (!engine.isDoubleMode()) break block13;
                    double aDouble = Double.NaN;
                    double bDouble = Double.NaN;
                    double cDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        aDouble = a.evalDouble();
                        bDouble = b.evalDouble();
                        cDouble = c.evalDouble();
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(aDouble) || Double.isNaN(bDouble) || Double.isNaN(cDouble) || Double.isNaN(zDouble) || zDouble > 1.0 || zDouble == -1.0) {
                        Complex ac = a.evalComplex();
                        Complex bc = b.evalComplex();
                        Complex cc = c.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(HypergeometricJS.hypergeometric2F1(ac, bc, cc, zc));
                    }
                    return F.num(HypergeometricJS.hypergeometric2F1(aDouble, bDouble, cDouble, zDouble));
                }
                catch (ResultException te) {
                    LOGGER.debug("Hypergeometric2F1.evaluate() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_4_4;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class Hypergeometric1F1
    extends AbstractFunctionEvaluator {
        private Hypergeometric1F1() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr a = ast.arg1();
            if (a.isZero()) {
                return F.C1;
            }
            IExpr b = ast.arg2();
            IExpr z = ast.arg3();
            if (b.isZero()) {
                if (z.isZero()) {
                    return S.Indeterminate;
                }
                return F.CComplexInfinity;
            }
            if (z.isZero()) {
                return F.C1;
            }
            if (b.isOne()) {
                return F.LaguerreL(a.negate(), z);
            }
            if (a.isInteger() && b.isInteger() && a.isNegative() && b.isNegative() && ((IInteger)b).isGT((IInteger)a)) {
                return F.CComplexInfinity;
            }
            try {
                IExpr bPlus1 = engine.evaluate(b.plus(F.C1));
                if (a.equals(bPlus1)) {
                    return F.Times((IExpr)F.Power((IExpr)S.E, z), (IExpr)F.Divide(F.Plus((IExpr)F.CN1, a, z), F.Plus(a, (IExpr)F.CN1)));
                }
                if (engine.isDoubleMode()) {
                    double aDouble = Double.NaN;
                    double bDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        aDouble = a.evalDouble();
                        bDouble = b.evalDouble();
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(aDouble) || Double.isNaN(bDouble) || Double.isNaN(zDouble)) {
                        Complex ac = a.evalComplex();
                        Complex bc = b.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(HypergeometricJS.hypergeometric1F1(ac, bc, zc));
                    }
                    return F.num(HypergeometricJS.hypergeometric1F1(aDouble, bDouble, zDouble));
                }
                if (a.equals(b)) {
                    return F.Power((IExpr)S.E, z);
                }
                if (a.isOne()) {
                    return F.Times(F.Plus((IExpr)F.CN1, b), F.Power((IExpr)S.E, z), F.Power(z, F.Plus((IExpr)F.C1, F.Negate(b))), F.Plus((IExpr)F.Gamma(F.Plus((IExpr)F.CN1, b)), F.Negate(F.Gamma(F.Plus((IExpr)F.CN1, b), z))));
                }
                if (a.isMinusOne()) {
                    return F.Subtract(F.C1, F.Divide(z, b));
                }
                if (a.isNumEqualInteger(F.C2)) {
                    return F.Times((IExpr)F.Plus((IExpr)F.CN1, b), (IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times(F.Plus((IExpr)F.C2, F.Negate(b)), F.Power((IExpr)S.E, z), F.Power(z, F.Plus((IExpr)F.C1, F.Negate(b))), F.Plus((IExpr)F.Gamma(F.Plus((IExpr)F.CN1, b)), F.Negate(F.Gamma(F.Plus((IExpr)F.CN1, b), z)))), (IExpr)F.Times((IExpr)F.Power((IExpr)S.E, z), (IExpr)F.Power(z, F.Plus((IExpr)F.C2, F.Negate(b))), (IExpr)F.Plus((IExpr)F.Gamma(F.Plus((IExpr)F.CN1, b)), F.Negate(F.Gamma(F.Plus((IExpr)F.CN1, b), z))))));
                }
                if (a.isNumEqualInteger(F.CN2)) {
                    return F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN2, F.Power(b, -1L), z), (IExpr)F.Times(F.Power(b, -1L), F.Power((IExpr)F.Plus((IExpr)F.C1, b), -1L), (IExpr)F.Sqr(z)));
                }
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static class Hypergeometric0F1
    extends AbstractFunctionEvaluator
    implements Hypergeometric0F1Rules {
        private Hypergeometric0F1() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr b = ast.arg1();
            IExpr z = ast.arg2();
            if (z.isZero()) {
                return F.C1;
            }
            if (z.isInfinity()) {
                return F.CComplexInfinity;
            }
            if (engine.isDoubleMode()) {
                try {
                    double bDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        bDouble = b.evalDouble();
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(bDouble) || Double.isNaN(zDouble)) {
                        Complex bc = b.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(HypergeometricJS.hypergeometric0F1(bc, zc));
                    }
                    return F.num(HypergeometricJS.hypergeometric0F1(bDouble, zDouble));
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class GegenbauerC
    extends AbstractFunctionEvaluator {
        private GegenbauerC() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int zInt;
            IExpr n = ast.arg1();
            if (ast.size() == 4) {
                IExpr l = ast.arg2();
                IExpr z = ast.arg3();
                if (l.isNumEqualRational(F.C1D2)) {
                    return F.LegendreP(n, z);
                }
                int lInt = l.toIntDefault();
                if (lInt >= 0) {
                    switch (lInt) {
                        case 0: {
                            return F.C0;
                        }
                        case 1: {
                            return F.ChebyshevU(n, z);
                        }
                        case 2: {
                            return F.Times((IExpr)F.C1D2, F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Sqr(z)), -1L), (IExpr)F.Plus((IExpr)F.Times((IExpr)F.Plus((IExpr)F.CN2, F.Negate(S.n)), (IExpr)F.ChebyshevU(n, z)), (IExpr)F.Times((IExpr)F.Plus((IExpr)F.C1, n), z, (IExpr)F.ChebyshevU(F.Plus((IExpr)F.C1, n), z))));
                        }
                    }
                }
                if (n.isZero()) {
                    return F.C1;
                }
                int nInt = n.toIntDefault();
                if (nInt > 0) {
                    return F.sum(k -> F.Times(F.Power((IExpr)F.CN1, k), F.Power((IExpr)F.Times((IExpr)F.C2, z), F.Plus((IExpr)F.Times((IExpr)F.CN2, k), n)), F.Power((IExpr)F.Factorial(k), -1L), F.Power((IExpr)F.Factorial(F.Plus((IExpr)F.Times((IExpr)F.CN2, k), n)), -1L), F.Pochhammer(l, F.Plus(F.Negate(k), n))), 0, nInt / 2);
                }
                return F.NIL;
            }
            IExpr z = ast.arg2();
            int nInt = n.toIntDefault();
            if (nInt > Integer.MIN_VALUE) {
                if (nInt == 0) {
                    return F.CComplexInfinity;
                }
                if (nInt == 1) {
                    return F.Times((IExpr)F.C2, z);
                }
                if (nInt == 2) {
                    return F.Plus((IExpr)F.CN1, (IExpr)F.Times((IExpr)F.C2, (IExpr)F.Sqr(z)));
                }
                if (nInt > 2) {
                    int floorND2 = nInt / 2;
                    return F.Plus((IExpr)F.Times((IExpr)F.Power((IExpr)F.C2, n), F.Power(n, -1L), (IExpr)F.Power(z, n)), (IExpr)F.sum(k -> F.Times(F.Power((IExpr)F.CN1, k), F.Power((IExpr)F.Times((IExpr)F.C2, z), F.Plus((IExpr)F.Times((IExpr)F.CN2, k), n)), F.Power((IExpr)F.Times((IExpr)F.Factorial(k), (IExpr)F.Factorial(F.Plus((IExpr)F.Times((IExpr)F.CN2, k), n))), -1L), F.Factorial(F.Plus((IExpr)F.CN1, F.Negate(k), n))), 1, floorND2));
                }
            }
            if ((zInt = z.toIntDefault()) > Integer.MIN_VALUE) {
                if (zInt == 0) {
                    return F.Times((IExpr)F.C2, (IExpr)F.Power(n, F.CN1), (IExpr)F.Cos(F.Times((IExpr)F.C1D2, (IExpr)S.Pi, n)));
                }
                if (zInt == 1) {
                    return F.Divide(F.C2, n);
                }
                if (zInt == -1) {
                    return F.Times((IExpr)F.C2, (IExpr)F.Power(n, F.CN1), (IExpr)F.Cos(F.Times((IExpr)S.Pi, n)));
                }
            }
            if (n.equals(F.C1D2)) {
                return F.Times((IExpr)F.C4, (IExpr)F.Sqrt(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.C1, z))));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(n);
            if (negExpr.isPresent()) {
                return F.GegenbauerC(negExpr, z).negate();
            }
            if (n.isInteger() && n.isPositive() && (negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(z)).isPresent()) {
                return F.Times((IExpr)F.Power((IExpr)F.CN1, n), (IExpr)F.GegenbauerC(n, negExpr));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class FresnelS
    extends AbstractTrigArg1
    implements INumeric,
    DoubleUnaryOperator {
        private FresnelS() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return de.lab4inf.math.functions.FresnelS.fresnelS((double)operand);
        }

        @Override
        public IExpr e1ComplexArg(Complex c) {
            return F.complexNum(GammaJS.fresnelS(c));
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(de.lab4inf.math.functions.FresnelS.fresnelS((double)arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return de.lab4inf.math.functions.FresnelS.fresnelS((double)stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isNumber() && arg1.isZero()) {
                return F.C0;
            }
            if (arg1.isInfinity()) {
                return F.C1D2;
            }
            if (arg1.isNegativeInfinity()) {
                return F.CN1D2;
            }
            if (arg1.equals(F.CIInfinity)) {
                return F.Divide(F.CNI, F.C2);
            }
            if (arg1.equals(F.CNIInfinity)) {
                return F.Divide(F.CI, F.C2);
            }
            if (arg1.equals(F.CComplexInfinity)) {
                return S.Indeterminate;
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.FresnelS(negExpr));
            }
            IExpr restExpr = AbstractFunctionEvaluator.extractFactorFromExpression(arg1, F.CI);
            if (restExpr.isPresent()) {
                return F.Times((IExpr)F.CNI, (IExpr)F.FresnelS(restExpr));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class FresnelC
    extends AbstractTrigArg1
    implements INumeric,
    DoubleUnaryOperator {
        private FresnelC() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return de.lab4inf.math.functions.FresnelC.fresnelC((double)operand);
        }

        @Override
        public IExpr e1ComplexArg(Complex c) {
            return F.complexNum(GammaJS.fresnelC(c));
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(de.lab4inf.math.functions.FresnelC.fresnelC((double)arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return de.lab4inf.math.functions.FresnelC.fresnelC((double)stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isNumber() && arg1.isZero()) {
                return F.C0;
            }
            if (arg1.isInfinity()) {
                return F.C1D2;
            }
            if (arg1.isNegativeInfinity()) {
                return F.CN1D2;
            }
            if (arg1.equals(F.CIInfinity)) {
                return F.Divide(F.CI, F.C2);
            }
            if (arg1.equals(F.CNIInfinity)) {
                return F.Divide(F.CNI, F.C2);
            }
            if (arg1.equals(F.CComplexInfinity)) {
                return S.Indeterminate;
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.FresnelC(negExpr));
            }
            IExpr restExpr = AbstractFunctionEvaluator.extractFactorFromExpression(arg1, F.CI);
            if (restExpr.isPresent()) {
                return F.Times((IExpr)F.CI, (IExpr)F.FresnelC(restExpr));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class ExpIntegralEi
    extends AbstractFunctionEvaluator {
        private ExpIntegralEi() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (z.isZero()) {
                return F.CNInfinity;
            }
            if (z.isInfinity()) {
                return F.CInfinity;
            }
            if (z.isNegativeInfinity()) {
                return F.C0;
            }
            if (z.isDirectedInfinity(F.CI)) {
                return F.Times((IExpr)F.CI, (IExpr)S.Pi);
            }
            if (z.isDirectedInfinity(F.CNI)) {
                return F.Times((IExpr)F.CNI, (IExpr)S.Pi);
            }
            if (z.isComplexInfinity()) {
                return S.Indeterminate;
            }
            if (engine.isDoubleMode()) {
                try {
                    double zDouble = Double.NaN;
                    try {
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(zDouble)) {
                        Complex zc = z.evalComplex();
                        return F.complexNum(GammaJS.expIntegralEi(zc));
                    }
                    if (F.isZero(zDouble)) {
                        return F.CNInfinity;
                    }
                    return F.complexNum(GammaJS.expIntegralEi(zDouble));
                }
                catch (ThrowException te) {
                    LOGGER.debug("ExpIntegralEi.evaluate() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class ExpIntegralE
    extends AbstractFunctionEvaluator {
        private ExpIntegralE() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (n.isZero()) {
                return F.Power((IExpr)F.Times(z, (IExpr)F.Power((IExpr)S.E, z)), -1L);
            }
            if (z.isZero()) {
                IExpr nRe = n.re();
                if (nRe.greaterThan(F.C1).isTrue()) {
                    return F.Power((IExpr)F.Plus(n, (IExpr)F.CN1), -1L);
                }
                if (nRe.lessThan(F.C1).isTrue()) {
                    return F.CComplexInfinity;
                }
            }
            if (engine.isDoubleMode()) {
                try {
                    double nDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        nDouble = n.evalDouble();
                        zDouble = z.evalDouble();
                        return F.complexNum(GammaJS.expIntegralE(new Complex(nDouble), new Complex(zDouble)));
                    }
                    catch (ValidateException validateException) {
                        if (Double.isNaN(nDouble) || Double.isNaN(zDouble)) {
                            Complex nc = n.evalComplex();
                            Complex zc = z.evalComplex();
                            return F.complexNum(GammaJS.expIntegralE(nc, zc));
                        }
                    }
                }
                catch (ThrowException te) {
                    LOGGER.debug("ExpIntegralE.evaluate() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class CoshIntegral
    extends AbstractFunctionEvaluator {
        private CoshIntegral() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (z.isZero()) {
                return F.CNInfinity;
            }
            if (z.isInfinity()) {
                return F.CInfinity;
            }
            if (z.isNegativeInfinity()) {
                return F.CInfinity;
            }
            if (z.isDirectedInfinity(F.CI)) {
                return F.Times((IExpr)F.CPiHalf, (IExpr)F.CI);
            }
            if (z.isDirectedInfinity(F.CNI)) {
                return F.Times((IExpr)F.CNPiHalf, (IExpr)F.CI);
            }
            if (z.isComplexInfinity()) {
                return S.Indeterminate;
            }
            if (engine.isDoubleMode()) {
                try {
                    double zDouble = Double.NaN;
                    try {
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(zDouble)) {
                        Complex zc = z.evalComplex();
                        return F.complexNum(GammaJS.coshIntegral(zc));
                    }
                    if (F.isZero(zDouble)) {
                        return F.CNInfinity;
                    }
                    return F.complexNum(GammaJS.coshIntegral(new Complex(zDouble)));
                }
                catch (ThrowException te) {
                    LOGGER.debug("CoshIntegral.evaluate() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class CosIntegral
    extends AbstractFunctionEvaluator {
        private CosIntegral() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (z.isZero()) {
                return F.CNInfinity;
            }
            if (z.isInfinity()) {
                return F.C0;
            }
            if (z.isNegativeInfinity()) {
                return F.Times((IExpr)F.CI, (IExpr)S.Pi);
            }
            if (z.isDirectedInfinity(F.CI) || z.isDirectedInfinity(F.CNI)) {
                return F.CInfinity;
            }
            if (z.isComplexInfinity()) {
                return S.Indeterminate;
            }
            if (engine.isDoubleMode()) {
                try {
                    double zDouble = Double.NaN;
                    try {
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(zDouble)) {
                        Complex zc = z.evalComplex();
                        return F.complexNum(GammaJS.cosIntegral(zc));
                    }
                    if (F.isZero(zDouble)) {
                        return F.CNInfinity;
                    }
                    if (zDouble <= 0.0) {
                        return F.complexNum(GammaJS.cosIntegral(new Complex(zDouble)));
                    }
                    return F.num(CosineIntegral.ci((double)zDouble));
                }
                catch (ThrowException te) {
                    LOGGER.debug("CosIntegral.evaluate() failed", (Throwable)((Object)te));
                    return te.getValue();
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class AppellF1
    extends AbstractFunctionEvaluator {
        private AppellF1() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr a = ast.arg1();
            IExpr b1 = ast.arg2();
            IExpr b2 = ast.arg3();
            IExpr c = ast.arg4();
            IExpr z1 = ast.arg5();
            IExpr z2 = ast.get(6);
            if (z1.isZero() && z2.isZero()) {
                return F.C1;
            }
            if (z1.isZero()) {
                return F.Hypergeometric2F1(a, b2, c, z2);
            }
            if (z2.isZero()) {
                return F.Hypergeometric2F1(a, b1, c, z1);
            }
            if (z2.isOne()) {
                return F.Times((IExpr)F.Hypergeometric2F1(a, b1, F.Subtract(c, b2), z1), (IExpr)F.Hypergeometric2F1(a, b2, c, F.C1));
            }
            if (z1.subtract(z2).isPossibleZero(true)) {
                return F.Hypergeometric2F1(a, F.Plus(b1, b2), c, z1);
            }
            if (b1.subtract(b2).isPossibleZero(true) && z1.plus(z2).isPossibleZero(true)) {
                return F.HypergeometricPFQ(F.list(F.Plus((IExpr)F.C1D2, (IExpr)F.Divide(a, F.C2)), F.Divide(a, F.C2), b1), F.list(F.Plus((IExpr)F.C1D2, (IExpr)F.Divide(c, F.C2)), F.Divide(c, F.C2)), F.Sqr(z1));
            }
            if (b1.plus(b2).subtract(c).isPossibleZero(true)) {
                return F.Times((IExpr)F.Hypergeometric2F1(a, b1, F.Plus(b1, b2), F.Divide(F.Subtract(z1, z2), F.Subtract(F.C1, z2))), (IExpr)F.Power((IExpr)F.Subtract(F.C1, z2), a));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_6_6;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.AppellF1.setEvaluator(new AppellF1());
            S.CosIntegral.setEvaluator(new CosIntegral());
            S.CoshIntegral.setEvaluator(new CoshIntegral());
            S.ExpIntegralE.setEvaluator(new ExpIntegralE());
            S.ExpIntegralEi.setEvaluator(new ExpIntegralEi());
            S.FresnelC.setEvaluator(new FresnelC());
            S.FresnelS.setEvaluator(new FresnelS());
            S.GegenbauerC.setEvaluator(new GegenbauerC());
            S.Hypergeometric0F1.setEvaluator(new Hypergeometric0F1());
            S.Hypergeometric1F1.setEvaluator(new Hypergeometric1F1());
            S.Hypergeometric2F1.setEvaluator(new Hypergeometric2F1());
            S.HypergeometricPFQ.setEvaluator(new HypergeometricPFQ());
            S.HypergeometricU.setEvaluator(new HypergeometricU());
            S.LogIntegral.setEvaluator(new LogIntegral());
            S.SinIntegral.setEvaluator(new SinIntegral());
            S.SinhIntegral.setEvaluator(new SinhIntegral());
            S.WhittakerM.setEvaluator(new WhittakerM());
            S.WhittakerW.setEvaluator(new WhittakerW());
        }
    }
}

