/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.convert.RGBColor;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.graphics.Dimensions2D;
import org.matheclipse.core.graphics.IGraphics3D;
import org.matheclipse.core.graphics.Show2SVG;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class GraphicsFunctions {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DecimalFormatSymbols US_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    protected static final DecimalFormat FORMATTER = new DecimalFormat("0.0####", US_SYMBOLS);
    static final RGBColor[] PLOT_COLORS = new RGBColor[]{new RGBColor(0.368417f, 0.506779f, 0.709798f), new RGBColor(0.880722f, 0.611041f, 0.142051f), new RGBColor(0.560181f, 0.691569f, 0.194885f), new RGBColor(0.922526f, 0.385626f, 0.209179f), new RGBColor(0.528488f, 0.470624f, 0.701351f), new RGBColor(0.772079f, 0.431554f, 0.102387f), new RGBColor(0.363898f, 0.618501f, 0.782349f), new RGBColor(1.0f, 0.75f, 0.0f), new RGBColor(0.647624f, 0.37816f, 0.614037f), new RGBColor(0.571589f, 0.586483f, 0.0f), new RGBColor(0.915f, 0.3325f, 0.2125f), new RGBColor(0.40082222f, 0.5220067f, 0.85f), new RGBColor(0.97282887f, 0.62164444f, 0.07336199f), new RGBColor(0.73678267f, 0.358f, 0.50302666f), new RGBColor(0.2802644f, 0.715f, 0.42920893f)};

    public static boolean exportGraphicsSVG(StringBuilder buf, IAST data2D, Dimensions2D dim) {
        if (data2D.isList()) {
            boolean first = true;
            IAST rgbColor = F.NIL;
            IExpr opacity = F.num(0.75);
            for (int i = 1; i < data2D.size(); ++i) {
                IBuiltInSymbol symbol;
                IEvaluator evaluator;
                IExpr arg = data2D.get(i);
                if (!arg.isAST()) continue;
                IAST primitive = (IAST)arg;
                if (primitive.isAST(S.RGBColor, 4)) {
                    rgbColor = primitive;
                    continue;
                }
                if (primitive.isAST(S.Opacity, 2)) {
                    opacity = primitive.arg1();
                    continue;
                }
                if (!primitive.head().isBuiltInSymbol() || !((evaluator = (symbol = (IBuiltInSymbol)primitive.head()).getEvaluator()) instanceof IGraphics3D)) continue;
                if (!first) {
                    buf.append(",");
                }
                first = false;
                if (((IGraphics3D)((Object)evaluator)).graphics2D(buf, primitive, dim, rgbColor, opacity)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean exportGraphics3DRecursive(StringBuilder buf, IAST data3D) {
        if (data3D.isList()) {
            boolean first = true;
            IAST rgbColor = F.NIL;
            IExpr opacity = F.NIL;
            IAST list = data3D;
            for (int i = 1; i < list.size(); ++i) {
                StringBuilder primitivesBuffer;
                IBuiltInSymbol symbol;
                IEvaluator evaluator;
                IExpr arg = list.get(i);
                if (!arg.isAST()) continue;
                IAST ast = (IAST)arg;
                if (ast.isList()) {
                    StringBuilder primitivesBuffer2 = new StringBuilder();
                    if (!GraphicsFunctions.exportGraphics3DRecursive(primitivesBuffer2, ast)) continue;
                    if (!first) {
                        buf.append(",");
                    }
                    first = false;
                    buf.append((CharSequence)primitivesBuffer2);
                    continue;
                }
                if (ast.isRGBColor()) {
                    rgbColor = ast;
                    continue;
                }
                if (ast.isAST(S.Opacity, 2)) {
                    opacity = ast.arg1();
                    continue;
                }
                if (!ast.head().isBuiltInSymbol() || !((evaluator = (symbol = (IBuiltInSymbol)ast.head()).getEvaluator()) instanceof IGraphics3D) || !((IGraphics3D)((Object)evaluator)).graphics3D(primitivesBuffer = new StringBuilder(), ast, rgbColor, opacity)) continue;
                if (!first) {
                    buf.append(",");
                }
                first = false;
                buf.append((CharSequence)primitivesBuffer);
            }
            return true;
        }
        return false;
    }

    private static boolean graphics3DCoords(StringBuilder buf, IAST ast) {
        return GraphicsFunctions.graphics3DCoords(buf, ast, "coords");
    }

    private static boolean graphics3DCoords(StringBuilder buf, IAST ast, String coordStr) {
        buf.append(coordStr + ": [");
        for (int i = 1; i < ast.size(); ++i) {
            IExpr arg = ast.get(i);
            if (!arg.isList3()) {
                return false;
            }
            IAST coords = (IAST)arg;
            buf.append("[[");
            coords.joinToString(buf, ",");
            buf.append("]]");
            if (i >= ast.size() - 1) continue;
            buf.append(",");
        }
        buf.append("]");
        return true;
    }

    private static boolean graphics3DCoordsOrListOfCoords(StringBuilder buf, IAST coordsOrListOfCoords, String coordStr) {
        buf.append(coordStr + ": ");
        buf.append("[");
        if (coordsOrListOfCoords.isListOfLists()) {
            int size = coordsOrListOfCoords.size();
            for (int i = 1; i < size; ++i) {
                buf.append("[");
                IAST subList = (IAST)coordsOrListOfCoords.get(i);
                subList.joinToString(buf, ",");
                buf.append("]");
                if (i >= size - 1) continue;
                buf.append(",");
            }
        } else {
            buf.append("[");
            coordsOrListOfCoords.joinToString(buf, ",");
            buf.append("]");
        }
        buf.append("]");
        return true;
    }

    public static void initialize() {
        Initializer.init();
    }

    public static boolean renderGraphics3D(StringBuilder graphics3DBuffer, IAST graphics3DAST, EvalEngine engine) {
        StringBuilder jsonPrimitives;
        IExpr data3D;
        IExpr arg1 = graphics3DAST.first();
        if (!arg1.isList()) {
            arg1 = F.list(arg1);
        }
        IExpr lighting = S.Automatic;
        OptionArgs options = OptionArgs.createOptionArgs(graphics3DAST, engine);
        if (options != null) {
            lighting = options.getOption(S.Lighting).orElse(lighting);
        }
        if ((data3D = engine.evaluate(F.N(arg1))).isAST() && data3D.head().isBuiltInSymbol() && GraphicsFunctions.exportGraphics3DRecursive(jsonPrimitives = new StringBuilder(), (IAST)data3D)) {
            try {
                graphics3DBuffer.append("drawGraphics3d(document.getElementById('graphics3d'),\n");
                graphics3DBuffer.append("{");
                graphics3DBuffer.append("\naxes: {},");
                graphics3DBuffer.append("\nelements: [");
                graphics3DBuffer.append(jsonPrimitives.toString());
                graphics3DBuffer.append("],");
                GraphicsFunctions.graphics3DLigthing(graphics3DBuffer, lighting);
                graphics3DBuffer.append("\nviewpoint: [1.3, -2.4, 2.0]");
                graphics3DBuffer.append("}\n");
                graphics3DBuffer.append(");");
                return true;
            }
            catch (Exception ex) {
                LOGGER.debug("GraphicsFunctions.renderGraphics3D() failed", (Throwable)ex);
            }
        }
        return false;
    }

    private static void graphics3DLigthing(StringBuilder graphics3DBuffer, IExpr lighting) {
        IAST automatic = F.List(F.AmbientLight(F.RGBColor(0.4, 0.2, 0.2)), F.DirectionalLight(F.RGBColor(0.0, 0.18, 0.5), F.List(2, 0, 2)), F.DirectionalLight(F.RGBColor(0.18, 0.5, 0.18), F.List(2, 2, 3)), F.DirectionalLight(F.RGBColor(0.5, 0.18, 0.0), F.List(0, 2, 2)), F.DirectionalLight(F.RGBColor(0.0, 0.0, 0.18), F.List(0, 0, 2)));
        IAST result = F.NIL;
        if (lighting.equals(S.Automatic)) {
            result = automatic;
        } else if (lighting.equals(F.$str("Neutral"))) {
            result = F.List(F.AmbientLight(F.RGBColor(0.35, 0.35, 0.35)), F.DirectionalLight(F.RGBColor(0.37, 0.37, 0.37), F.List(2, 0, 2)), F.DirectionalLight(F.RGBColor(0.37, 0.37, 0.37), F.List(2, 2, 3)), F.DirectionalLight(F.RGBColor(0.37, 0.37, 0.37), F.List(0, 2, 2)));
        } else if (lighting.isAST()) {
            result = (IAST)lighting;
        }
        boolean lightingDone = false;
        graphics3DBuffer.append("\nlighting: [");
        if (result.isPresent()) {
            if (result.isList()) {
                for (int i = 1; i < result.size(); ++i) {
                    if (!result.get(i).isAST()) continue;
                    if (lightingDone) {
                        graphics3DBuffer.append(",");
                    }
                    if (!GraphicsFunctions.graphics3DSingleLight(graphics3DBuffer, (IAST)result.get(i))) continue;
                    lightingDone = true;
                }
            } else {
                lightingDone = GraphicsFunctions.graphics3DSingleLight(graphics3DBuffer, result);
            }
        }
        if (!lightingDone) {
            lightingDone = GraphicsFunctions.graphics3DSingleLight(graphics3DBuffer, automatic);
        }
        graphics3DBuffer.append("\n],");
    }

    private static boolean graphics3DSingleLight(StringBuilder graphics3DBuffer, IAST result) {
        if (result.isAST1()) {
            IExpr color = result.arg1();
            if (color.isRGBColor() && result.head().equals(S.AmbientLight)) {
                graphics3DBuffer.append("\n{");
                graphics3DBuffer.append("type: 'ambient',");
                GraphicsFunctions.setColor(graphics3DBuffer, (IAST)color, F.RGBColor(F.C1, F.C1, F.C1), false);
                graphics3DBuffer.append("}");
                return true;
            }
        } else if (result.isAST2()) {
            String name = result.arg1().toString();
            if (name.equals("Ambient")) {
                IExpr color = result.arg2();
                if (color.isRGBColor()) {
                    graphics3DBuffer.append("\n{");
                    graphics3DBuffer.append("type: 'ambient',");
                    GraphicsFunctions.setColor(graphics3DBuffer, (IAST)color, F.NIL, false);
                    graphics3DBuffer.append("}");
                    return true;
                }
            } else {
                IExpr color = result.arg1();
                if (color.isRGBColor() && result.arg2().isList()) {
                    IAST list = (IAST)result.arg2();
                    if (result.head().equals(S.DirectionalLight) && list.isList()) {
                        graphics3DBuffer.append("\n{");
                        graphics3DBuffer.append("type: 'directional',");
                        GraphicsFunctions.setColor(graphics3DBuffer, (IAST)color, F.NIL, true);
                        GraphicsFunctions.graphics3DCoordsOrListOfCoords(graphics3DBuffer, list, "coords");
                        graphics3DBuffer.append("}");
                        return true;
                    }
                    if (result.head().equals(S.PointLight) && list.isList3()) {
                        graphics3DBuffer.append("\n{");
                        graphics3DBuffer.append("type: 'point',");
                        GraphicsFunctions.setColor(graphics3DBuffer, (IAST)color, F.NIL, true);
                        GraphicsFunctions.graphics3DCoordsOrListOfCoords(graphics3DBuffer, list, "coords");
                        graphics3DBuffer.append("}");
                        return true;
                    }
                    if (result.head().equals(S.SpotLight) && list.isList2() && list.isListOfLists()) {
                        IAST coords = (IAST)list.arg1();
                        IAST target = (IAST)list.arg2();
                        if (coords.isList3() && target.isList3()) {
                            double angle = 1.0;
                            if (result.size() == 5) {
                                angle = result.arg4().toDoubleDefault(1.0);
                            }
                            graphics3DBuffer.append("\n{");
                            graphics3DBuffer.append("type: 'spot',");
                            graphics3DBuffer.append("angle: " + angle + ",");
                            GraphicsFunctions.setColor(graphics3DBuffer, (IAST)color, F.NIL, true);
                            GraphicsFunctions.graphics3DCoordsOrListOfCoords(graphics3DBuffer, coords, "coords");
                            graphics3DBuffer.append(",");
                            GraphicsFunctions.graphics3DCoordsOrListOfCoords(graphics3DBuffer, target, "target");
                            graphics3DBuffer.append("}");
                            return true;
                        }
                    }
                }
            }
        } else if (result.isAST((IExpr)S.List, 4, 5) && result.arg3().isList() && result.size() > 2) {
            String name = result.arg1().toString();
            IExpr color = result.arg2();
            IAST list = (IAST)result.arg3();
            if (color.isRGBColor()) {
                if (name.equals("Directional") && list.isList()) {
                    graphics3DBuffer.append("\n{");
                    graphics3DBuffer.append("type: 'directional',");
                    GraphicsFunctions.setColor(graphics3DBuffer, (IAST)color, F.NIL, true);
                    GraphicsFunctions.graphics3DCoordsOrListOfCoords(graphics3DBuffer, list, "coords");
                    graphics3DBuffer.append("}");
                    return true;
                }
                if (name.equals("Point") && list.isList3()) {
                    graphics3DBuffer.append("\n{");
                    graphics3DBuffer.append("type: 'point',");
                    GraphicsFunctions.setColor(graphics3DBuffer, (IAST)color, F.NIL, true);
                    GraphicsFunctions.graphics3DCoordsOrListOfCoords(graphics3DBuffer, list, "coords");
                    graphics3DBuffer.append("}");
                    return true;
                }
                if (name.equals("Spot") && list.isList2() && list.isListOfLists()) {
                    IAST coords = (IAST)list.arg1();
                    IAST target = (IAST)list.arg2();
                    if (coords.isList3() && target.isList3()) {
                        double angle = 1.0;
                        if (result.size() == 5) {
                            angle = result.arg4().toDoubleDefault(1.0);
                        }
                        graphics3DBuffer.append("\n{");
                        graphics3DBuffer.append("type: 'spot',");
                        graphics3DBuffer.append("angle: " + angle + ",");
                        GraphicsFunctions.setColor(graphics3DBuffer, (IAST)color, F.NIL, true);
                        GraphicsFunctions.graphics3DCoordsOrListOfCoords(graphics3DBuffer, coords, "coords");
                        graphics3DBuffer.append(",");
                        GraphicsFunctions.graphics3DCoordsOrListOfCoords(graphics3DBuffer, target, "target");
                        graphics3DBuffer.append("}");
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static void setColor(StringBuilder buf, IAST color, IAST defaultColor, boolean setComma) {
        if (color.isPresent()) {
            if (color.isAST((IExpr)S.RGBColor, 4, 5)) {
                if (color.size() == 5) {
                    double opacity = color.arg4().toDoubleDefault(1.0);
                    buf.append("opacity: ");
                    buf.append(opacity);
                    buf.append(",");
                }
                double red = color.arg1().toDoubleDefault(0.0);
                double green = color.arg2().toDoubleDefault(0.0);
                double blue = color.arg3().toDoubleDefault(0.0);
                buf.append("color: [");
                buf.append(red);
                buf.append(",");
                buf.append(green);
                buf.append(",");
                buf.append(blue);
                buf.append("]");
                if (setComma) {
                    buf.append(",");
                }
                return;
            }
            if (color.isAST(S.RGBColor, 1) && color.arg1().isAST((IExpr)S.List, 4, 5)) {
                IAST list = (IAST)color.arg1();
                if (color.size() == 5) {
                    double opacity = list.arg4().toDoubleDefault(1.0);
                    buf.append("opacity: ");
                    buf.append(opacity);
                    buf.append(",");
                }
                double red = list.arg1().toDoubleDefault(0.0);
                double green = list.arg2().toDoubleDefault(0.0);
                double blue = list.arg3().toDoubleDefault(0.0);
                buf.append("color: [");
                buf.append(red);
                buf.append(",");
                buf.append(green);
                buf.append(",");
                buf.append(blue);
                buf.append("]");
                if (setComma) {
                    buf.append(",");
                }
                return;
            }
        }
        if (defaultColor.isAST(S.RGBColor, 4)) {
            double red = defaultColor.arg1().toDoubleDefault(0.0);
            double green = defaultColor.arg2().toDoubleDefault(0.0);
            double blue = defaultColor.arg3().toDoubleDefault(0.0);
            buf.append("color: [");
            buf.append(red);
            buf.append(",");
            buf.append(green);
            buf.append(",");
            buf.append(blue);
            buf.append("]");
        } else {
            buf.append("color: [1.0, 0.5, 0.0]");
        }
        if (setComma) {
            buf.append(",");
        }
    }

    private static void setOpacity(StringBuilder buf, IExpr opacityExpr) {
        double opacity = opacityExpr.toDoubleDefault(1.0);
        buf.append("opacity: ");
        buf.append(opacity);
        buf.append(",");
    }

    private GraphicsFunctions() {
    }

    public static boolean primitivesDimension(IAST list, Dimensions2D dim) {
        for (int i = 1; i < list.size(); ++i) {
            IBuiltInSymbol symbol;
            IEvaluator evaluator;
            IAST primitive;
            if (list.get(i).isAST() && (primitive = (IAST)list.get(i)).head().isBuiltInSymbol() && (evaluator = (symbol = (IBuiltInSymbol)primitive.head()).getEvaluator()) instanceof IGraphics3D && ((IGraphics3D)((Object)evaluator)).graphics2DDimension(primitive, dim)) continue;
        }
        return true;
    }

    public static void graphicsToSVG(IAST ast, StringBuilder buf) {
        EvalEngine engine = EvalEngine.get();
        IAST numericAST = (IAST)engine.evalN(ast);
        Dimensions2D dim = new Dimensions2D(350, 350);
        dim.color = RGBColor.BLUE;
        if (numericAST.size() > 2) {
            OptionArgs options = new OptionArgs(numericAST.topHead(), numericAST, 2, engine);
            IExpr option = options.getOption(S.PlotRange);
            if (option.isListOfLists() && option.size() == 3) {
                IAST list = (IAST)option;
                dim.setPlotRange(list.getAST(1), list.getAST(2));
            }
            if ((option = options.getOption(S.Axes)).isTrue()) {
                dim.setAxes(true);
            }
        }
        int width = dim.width;
        int height = dim.height;
        if (ast.size() > 1) {
            IExpr arg1 = ast.arg1();
            if (!arg1.isList()) {
                arg1 = F.list(arg1);
            }
            GraphicsFunctions.primitivesDimension((IAST)arg1, dim);
            GraphicsFunctions.exportGraphicsSVG(buf, (IAST)arg1, dim);
        }
        if (dim.isAxes()) {
            double xScale = (double)width / (dim.xMax - dim.xMin);
            double yScale = (double)height / (dim.yMax - dim.yMin);
            double x1 = 0.0;
            buf.append("<polyline points=\"");
            buf.append(Show2SVG.FORMATTER.format((x1 - dim.xMin) * xScale));
            buf.append(",");
            buf.append(Show2SVG.FORMATTER.format(0.0));
            buf.append(" ");
            buf.append(Show2SVG.FORMATTER.format((x1 - dim.xMin) * xScale));
            buf.append(",");
            buf.append(Show2SVG.FORMATTER.format(height));
            buf.append("\" style=\"stroke: rgb(0.000000%, 0.000000%, 0.000000%); stroke-opacity: 1; stroke-width: 0.666667px; fill: none\"/>\n");
            double y1 = -dim.yMin * yScale;
            buf.append("<polyline points=\"");
            buf.append(Show2SVG.FORMATTER.format(0L));
            buf.append(",");
            buf.append(Show2SVG.FORMATTER.format(y1));
            buf.append(" ");
            buf.append(Show2SVG.FORMATTER.format(width));
            buf.append(",");
            buf.append(Show2SVG.FORMATTER.format(y1));
            buf.append("\" style=\"stroke: rgb(0.000000%, 0.000000%, 0.000000%); stroke-opacity: 1; stroke-width: 0.666667px; fill: none\"/>\n");
        }
    }

    public static RGBColor plotStyleColor(int functionColorNumber, IAST plotStyle) {
        if (plotStyle.isList() && plotStyle.size() > functionColorNumber) {
            IExpr temp = plotStyle.get(functionColorNumber);
            if (temp.isASTSizeGE(S.Directive, 2)) {
                IAST directive = (IAST)temp;
                for (int j = 1; j < directive.size(); ++j) {
                    temp = directive.get(j);
                    RGBColor color = Convert.toAWTColor(temp);
                    if (color == null) continue;
                    return color;
                }
            } else {
                RGBColor color = Convert.toAWTColor(temp);
                if (color != null) {
                    return color;
                }
            }
        }
        return PLOT_COLORS[(functionColorNumber - 1) % PLOT_COLORS.length];
    }

    public static IAST plotStyleColorExpr(int functionColorNumber, IAST plotStyle) {
        RGBColor color = GraphicsFunctions.plotStyleColor(functionColorNumber, plotStyle);
        float[] rgbComponents = color.getRGBColorComponents(null);
        return F.RGBColor(rgbComponents[0], rgbComponents[1], rgbComponents[2]);
    }

    private static class Volume
    extends AbstractEvaluator {
        private Volume() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAST()) {
                IAST graphic = (IAST)ast.arg1();
                if (graphic.isAST((IExpr)S.Ball, 2, 3) && graphic.first().isList3()) {
                    IExpr radius = F.C1;
                    if (graphic.size() == 3) {
                        radius = graphic.second();
                    }
                    return F.Times((IExpr)F.C3D4, (IExpr)S.Pi, (IExpr)F.Power(radius, F.C3));
                }
                if (graphic.isAST(S.Cuboid, 3) && graphic.first().isList3() && graphic.second().isList3()) {
                    IAST v1 = (IAST)graphic.first();
                    IAST v2 = (IAST)graphic.second();
                    return F.Abs(F.Times((IExpr)F.Plus(v1.arg1().negate(), v2.arg1()), (IExpr)F.Plus(v1.arg2().negate(), v2.arg2()), (IExpr)F.Plus(v1.arg3().negate(), v2.arg3())));
                }
                if (graphic.isAST(S.Ellipsoid, 3) && graphic.first().isList3() && graphic.second().isList3()) {
                    IAST v2 = (IAST)graphic.second();
                    return F.Times(F.QQ(4L, 3L), S.Pi, v2.arg1(), v2.arg2(), v2.arg3());
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Tube
    extends AbstractEvaluator
    implements IGraphics3D {
        private Tube() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public boolean graphics3D(StringBuilder buf, IAST ast, IAST color, IExpr opacity) {
            if (ast.argSize() > 0 && ast.arg1().isList()) {
                double radius = 0.01;
                if (ast.argSize() == 2) {
                    radius = ast.arg2().toDoubleDefault(1.0);
                }
                IAST list = (IAST)ast.arg1();
                buf.append("{type: 'tube',");
                GraphicsFunctions.setColor(buf, color, F.NIL, true);
                GraphicsFunctions.setOpacity(buf, opacity.orElse(F.C1));
                buf.append("radius: " + radius + ",");
                if (list.isListOfLists() && GraphicsFunctions.graphics3DCoords(buf, list)) {
                    buf.append("}");
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Tetrahedron
    extends AbstractEvaluator
    implements IGraphics3D {
        private Tetrahedron() {
        }

        protected void addSubtypeThreejs(StringBuilder buf) {
            buf.append("subType: 'tetrahedron',");
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_INFINITY;
        }

        @Override
        public boolean graphics3D(StringBuilder buf, IAST ast, IAST color, IExpr opacity) {
            IAST list = F.list(F.list(F.C0, F.C0, F.C0));
            if (ast.argSize() > 0 && ast.arg1().isList()) {
                list = (IAST)ast.arg1();
            }
            buf.append("{type: 'uniformPolyhedron',");
            GraphicsFunctions.setColor(buf, color, F.NIL, true);
            GraphicsFunctions.setOpacity(buf, opacity.orElse(F.C1D2));
            this.addSubtypeThreejs(buf);
            if (list.isListOfLists() && GraphicsFunctions.graphics3DCoords(buf, list)) {
                buf.append("}");
                return true;
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Sphere
    extends AbstractEvaluator
    implements IGraphics3D {
        private Sphere() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                return F.Sphere(F.List(0, 0, 0), F.C1);
            }
            if (ast.isAST1()) {
                return F.Sphere(ast.arg1(), F.C1);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }

        private boolean sphere(StringBuilder buf, IAST sphereCoords, double sphereRadius, IAST color, IExpr opacity) {
            buf.append("{type: 'sphere',");
            GraphicsFunctions.setColor(buf, color, color, true);
            GraphicsFunctions.setOpacity(buf, opacity.orElse(F.C1D2));
            buf.append("radius: " + sphereRadius + ",");
            if (sphereCoords.isList3() && GraphicsFunctions.graphics3DCoords(buf, F.list(sphereCoords))) {
                buf.append("}");
                return true;
            }
            return false;
        }

        @Override
        public boolean graphics3D(StringBuilder buf, IAST ast, IAST color, IExpr opacity) {
            if (ast.argSize() > 0 && ast.arg1().isList()) {
                IAST list;
                double radius = 1.0;
                if (ast.argSize() == 2) {
                    radius = ast.arg2().toDoubleDefault(1.0);
                }
                if ((list = (IAST)ast.arg1()).isListOfLists()) {
                    for (int i = 1; i < list.size(); ++i) {
                        IExpr arg = list.get(i);
                        if (!arg.isList3()) {
                            return false;
                        }
                        if (!this.sphere(buf, (IAST)arg, radius, color, opacity)) {
                            return false;
                        }
                        if (i >= list.size() - 1) continue;
                        buf.append(",");
                    }
                    return true;
                }
                return this.sphere(buf, list, radius, color, opacity);
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Rectangle
    extends AbstractEvaluator
    implements IGraphics3D {
        private Rectangle() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }

        @Override
        public boolean graphics2DDimension(IAST ast, Dimensions2D dim) {
            if (ast.size() == 2) {
                if (ast.arg1().isList2()) {
                    IAST list1 = (IAST)ast.arg1();
                    double x1 = ((ISignedNumber)list1.arg1()).doubleValue();
                    double y1 = ((ISignedNumber)list1.arg2()).doubleValue();
                    double x2 = x1 + 1.0;
                    double y2 = y1 + 1.0;
                    dim.minMax(x1, x2, y1, y2);
                    return true;
                }
            } else if (ast.size() == 3 && ast.arg1().isList2() && ast.arg2().isList2()) {
                IAST list1 = (IAST)ast.arg1();
                IAST list2 = (IAST)ast.arg2();
                double x1 = ((ISignedNumber)list1.arg1()).doubleValue();
                double y1 = ((ISignedNumber)list1.arg2()).doubleValue();
                double x2 = ((ISignedNumber)list2.arg1()).doubleValue();
                double y2 = ((ISignedNumber)list2.arg2()).doubleValue();
                dim.minMax(x1, x2, y1, y2);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean graphics2D(StringBuilder buf, IAST ast, Dimensions2D dim, IAST color, IExpr opacity) {
            try {
                int width = dim.width;
                int height = dim.height;
                double xMin = dim.xMin;
                double xMax = dim.xMax;
                double yMin = dim.yMin;
                double yMax = dim.yMax;
                if (ast.size() == 2) {
                    if (ast.arg1().isAST(S.List, 3)) {
                        IAST list1 = (IAST)ast.arg1();
                        buf.append("<rect ");
                        double xAxisScalingFactor = (double)width / (xMax - xMin);
                        double yAxisScalingFactor = (double)height / (yMax - yMin);
                        double x1 = ((ISignedNumber)list1.arg1()).doubleValue();
                        double y1 = ((ISignedNumber)list1.arg2()).doubleValue();
                        double w = 1.0;
                        double h = 1.0;
                        buf.append("x=\"");
                        buf.append(FORMATTER.format((x1 - xMin) * xAxisScalingFactor));
                        buf.append("\" y=\"");
                        buf.append(FORMATTER.format((yMax - y1 - 1.0) * yAxisScalingFactor));
                        buf.append("\" width=\"");
                        buf.append(FORMATTER.format(w * xAxisScalingFactor));
                        buf.append("\" height=\"");
                        buf.append(FORMATTER.format(h * yAxisScalingFactor));
                        boolean bl = true;
                        return bl;
                    }
                } else if (ast.size() == 3 && ast.arg1().isAST(S.List, 3) && ast.arg2().isAST(S.List, 3)) {
                    IAST list1 = (IAST)ast.arg1();
                    IAST list2 = (IAST)ast.arg2();
                    buf.append("<rect ");
                    double xAxisScalingFactor = (double)width / (xMax - xMin);
                    double yAxisScalingFactor = (double)height / (yMax - yMin);
                    double x1 = ((ISignedNumber)list1.arg1()).doubleValue();
                    double y1 = ((ISignedNumber)list1.arg2()).doubleValue();
                    double x2 = ((ISignedNumber)list2.arg1()).doubleValue();
                    double y2 = ((ISignedNumber)list2.arg2()).doubleValue();
                    double w = x2 - x1;
                    double h = y2 - y1;
                    buf.append("x=\"");
                    buf.append(FORMATTER.format((x1 - xMin) * xAxisScalingFactor));
                    buf.append("\" y=\"");
                    buf.append(FORMATTER.format((yMax - y1 - h) * yAxisScalingFactor));
                    buf.append("\" width=\"");
                    buf.append(FORMATTER.format(w * xAxisScalingFactor));
                    buf.append("\" height=\"");
                    buf.append(FORMATTER.format(h * yAxisScalingFactor));
                    boolean bl = true;
                    return bl;
                }
            }
            catch (RuntimeException ex) {
                LOGGER.error("Rectangle.graphics2D() failed", (Throwable)ex);
            }
            finally {
                buf.append("\" \n      style=\"stroke: none; stroke-width: 0.000000px; ");
                buf.append("fill: rgb(");
                dim.getColorRGB(buf);
                buf.append("); ");
                buf.append("stroke-opacity: 1; stroke-width: 0.666667px; fill-opacity: 1\" />\n");
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Scaled
    extends AbstractEvaluator {
        private Scaled() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1() && ast.arg1().isList()) {
                return ast.arg1();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Polygon
    extends AbstractEvaluator
    implements IGraphics3D {
        private Polygon() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }

        @Override
        public boolean graphics3D(StringBuilder buf, IAST ast, IAST color, IExpr opacity) {
            if (ast.argSize() > 0 && ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                buf.append("{type: 'polygon',");
                GraphicsFunctions.setColor(buf, color, F.NIL, true);
                GraphicsFunctions.setOpacity(buf, opacity.orElse(F.C1));
                if (list.isListOfLists() && GraphicsFunctions.graphics3DCoords(buf, list)) {
                    buf.append("}");
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Point
    extends AbstractEvaluator
    implements IGraphics3D {
        private Point() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void singlePointToSVG(IAST point, StringBuilder buf, Dimensions2D dim) {
            try {
                double xMin = dim.xMin;
                double yMax = dim.yMax;
                buf.append("<circle ");
                double xAxisScalingFactor = dim.getXScale();
                double yAxisScalingFactor = dim.getYScale();
                double x1 = ((ISignedNumber)point.arg1()).doubleValue();
                double y1 = ((ISignedNumber)point.arg2()).doubleValue();
                double r = 2.166667;
                double cx = (x1 - xMin) * xAxisScalingFactor;
                double cy = (yMax - y1) * yAxisScalingFactor;
                buf.append("cx=\"");
                buf.append(FORMATTER.format(cx));
                buf.append("\" cy=\"");
                buf.append(FORMATTER.format(cy));
                buf.append("\" r=\"");
                buf.append(FORMATTER.format(r));
            }
            catch (RuntimeException ex) {
                LOGGER.error("Point.singlePointToSVG() failed", (Throwable)ex);
            }
            finally {
                buf.append("\" \n      style=\"stroke: none; stroke-width: 0.000000px; ");
                buf.append("fill: rgb(");
                dim.getColorRGB(buf);
                buf.append("); ");
                buf.append("fill-opacity: 1\" />\n");
            }
        }

        private static void singlePointDimensions(IAST point, Dimensions2D dim) {
            double x1 = ((ISignedNumber)point.arg1()).doubleValue();
            double y1 = ((ISignedNumber)point.arg2()).doubleValue();
            dim.minMax(x1 - Config.DOUBLE_TOLERANCE, x1 + Config.DOUBLE_TOLERANCE, y1 - Config.DOUBLE_TOLERANCE, y1 + Config.DOUBLE_TOLERANCE);
        }

        @Override
        public boolean graphics2DDimension(IAST ast, Dimensions2D dim) {
            if (ast.size() == 2) {
                IExpr arg1 = ast.arg1();
                if (arg1.isListOfLists()) {
                    IAST list = (IAST)arg1;
                    for (int i = 1; i < list.size(); ++i) {
                        if (!list.get(i).isAST(S.List, 3)) continue;
                        IAST point = (IAST)list.get(i);
                        Point.singlePointDimensions(point, dim);
                    }
                } else if (arg1.isAST(S.List, 3)) {
                    IAST point = (IAST)ast.arg1();
                    Point.singlePointDimensions(point, dim);
                }
            }
            return false;
        }

        @Override
        public boolean graphics2D(StringBuilder buf, IAST ast, Dimensions2D dim, IAST color, IExpr opacity) {
            if (ast.size() == 2) {
                IExpr arg1 = ast.arg1();
                if (arg1.isListOfLists()) {
                    IAST list = (IAST)arg1;
                    for (int i = 1; i < list.size(); ++i) {
                        if (!list.get(i).isAST(S.List, 3)) continue;
                        IAST point = (IAST)list.get(i);
                        Point.singlePointToSVG(point, buf, dim);
                        return true;
                    }
                } else if (arg1.isAST(S.List, 3)) {
                    IAST point = (IAST)arg1;
                    Point.singlePointToSVG(point, buf, dim);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean graphics3D(StringBuilder buf, IAST ast, IAST color, IExpr opacity) {
            if (ast.argSize() > 0 && ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                buf.append("{type: 'point',");
                GraphicsFunctions.setColor(buf, color, F.RGBColor(F.C0, F.C0, F.C0), true);
                GraphicsFunctions.setOpacity(buf, opacity.orElse(F.C1));
                if (list.isListOfLists() && GraphicsFunctions.graphics3DCoords(buf, list)) {
                    buf.append(",pointSize: 0.02}");
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Octahedron
    extends Tetrahedron {
        private Octahedron() {
        }

        @Override
        protected void addSubtypeThreejs(StringBuilder buf) {
            buf.append("subType: 'octahedron',");
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Line
    extends AbstractEvaluator
    implements IGraphics3D {
        private Line() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public boolean graphics2DDimension(IAST ast, Dimensions2D dim) {
            if (ast.arg1().isList()) {
                IAST pointList = (IAST)ast.arg1();
                int numberOfPoints = pointList.argSize();
                double xMin = Double.MAX_VALUE;
                double xMax = Double.MIN_VALUE;
                double yMin = Double.MAX_VALUE;
                double yMax = Double.MIN_VALUE;
                double[] x = new double[numberOfPoints];
                double[] y = new double[numberOfPoints];
                for (int i = 0; i < numberOfPoints; ++i) {
                    IExpr point = pointList.get(i + 1);
                    if (!point.isList() || !point.isAST2()) continue;
                    x[i] = ((ISignedNumber)point.first()).doubleValue();
                    if (x[i] < xMin) {
                        xMin = x[i];
                    }
                    if (x[i] > xMax) {
                        xMax = x[i];
                    }
                    y[i] = ((ISignedNumber)point.second()).doubleValue();
                    if (y[i] < yMin) {
                        yMin = y[i];
                    }
                    if (!(y[i] > yMax)) continue;
                    yMax = y[i];
                }
                dim.minMax(xMin, xMax, yMin, yMax);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean graphics2D(StringBuilder buf, IAST ast, Dimensions2D dim, IAST color, IExpr opacity) {
            try {
                if (ast.arg1().isList()) {
                    buf.append("<polyline points=\"");
                    IAST pointList = (IAST)ast.arg1();
                    int numberOfPoints = pointList.argSize();
                    int width = dim.width;
                    int height = dim.height;
                    double xMin = dim.xMin;
                    double xMax = dim.xMax;
                    double yMin = dim.yMin;
                    double yMax = dim.yMax;
                    double[] x = new double[numberOfPoints];
                    double[] y = new double[numberOfPoints];
                    for (int i = 0; i < numberOfPoints; ++i) {
                        IExpr point = pointList.get(i + 1);
                        if (!point.isList() || !((IAST)point).isAST2()) continue;
                        x[i] = ((ISignedNumber)point.first()).doubleValue();
                        y[i] = ((ISignedNumber)point.second()).doubleValue();
                    }
                    double xAxisScalingFactor = (double)width / (xMax - xMin);
                    double yAxisScalingFactor = (double)height / (yMax - yMin);
                    for (int i = 0; i < numberOfPoints; ++i) {
                        buf.append(FORMATTER.format((x[i] - xMin) * xAxisScalingFactor));
                        buf.append(",");
                        buf.append(FORMATTER.format((double)height - (y[i] - yMin) * yAxisScalingFactor));
                        if (i >= numberOfPoints - 1) continue;
                        buf.append(" ");
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            catch (RuntimeException ex) {
                LOGGER.error("Line.graphics2D() failed", (Throwable)ex);
            }
            finally {
                buf.append("\" \n style=\"stroke: rgb(0.000000%, 0.000000%, 0.000000%); stroke-opacity: 1; stroke-width: 0.666667px; fill: none\" />");
            }
            return false;
        }

        @Override
        public boolean graphics3D(StringBuilder buf, IAST ast, IAST color, IExpr opacity) {
            if (ast.argSize() > 0 && ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                buf.append("{type: 'line',");
                GraphicsFunctions.setColor(buf, color, F.NIL, true);
                GraphicsFunctions.setOpacity(buf, opacity.orElse(F.C1));
                if (list.isListOfLists() && GraphicsFunctions.graphics3DCoords(buf, list)) {
                    buf.append("}");
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Arrow.setEvaluator(new Arrow());
            S.BernsteinBasis.setEvaluator(new BernsteinBasis());
            S.Circle.setEvaluator(new Circle());
            S.Cone.setEvaluator(new Cone());
            S.Cuboid.setEvaluator(new Cuboid());
            S.Cylinder.setEvaluator(new Cylinder());
            S.Dodecahedron.setEvaluator(new Dodecahedron());
            S.Icosahedron.setEvaluator(new Icosahedron());
            S.Line.setEvaluator(new Line());
            S.Octahedron.setEvaluator(new Octahedron());
            S.Point.setEvaluator(new Point());
            S.Polygon.setEvaluator(new Polygon());
            S.Rectangle.setEvaluator(new Rectangle());
            S.Scaled.setEvaluator(new Scaled());
            S.Sphere.setEvaluator(new Sphere());
            S.Tetrahedron.setEvaluator(new Tetrahedron());
            S.Tube.setEvaluator(new Tube());
            S.Volume.setEvaluator(new Volume());
        }
    }

    private static class Icosahedron
    extends Tetrahedron {
        private Icosahedron() {
        }

        @Override
        protected void addSubtypeThreejs(StringBuilder buf) {
            buf.append("subType: 'icosahedron',");
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Dodecahedron
    extends Tetrahedron {
        private Dodecahedron() {
        }

        @Override
        protected void addSubtypeThreejs(StringBuilder buf) {
            buf.append("subType: 'dodecahedron',");
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Cylinder
    extends AbstractEvaluator
    implements IGraphics3D {
        private Cylinder() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                return F.Cylinder(F.list(F.List(0, 0, -1), F.List(0, 0, 1)), F.C1);
            }
            if (ast.isAST1()) {
                return F.Cylinder(ast.arg1(), F.C1);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }

        @Override
        public boolean graphics3D(StringBuilder buf, IAST ast, IAST color, IExpr opacity) {
            if (ast.argSize() > 0 && ast.arg1().isList()) {
                double radius = 1.0;
                if (ast.argSize() == 2) {
                    radius = ast.arg2().toDoubleDefault(1.0);
                }
                IAST list = (IAST)ast.arg1();
                buf.append("{type: 'cylinder',");
                GraphicsFunctions.setColor(buf, color, F.NIL, true);
                GraphicsFunctions.setOpacity(buf, opacity.orElse(F.C1D2));
                buf.append("radius: " + radius + ",");
                if (list.isListOfLists() && GraphicsFunctions.graphics3DCoords(buf, list)) {
                    buf.append("}");
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Cone
    extends AbstractEvaluator
    implements IGraphics3D {
        private Cone() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                return F.Cone(F.list(F.List(0, 0, -1), F.List(0, 0, 1)), F.C1);
            }
            if (ast.isAST1()) {
                return F.Cone(ast.arg1(), F.C1);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }

        @Override
        public boolean graphics3D(StringBuilder buf, IAST ast, IAST color, IExpr opacity) {
            if (ast.argSize() > 0 && ast.arg1().isList()) {
                double radius = 1.0;
                if (ast.argSize() == 2) {
                    radius = ast.arg2().toDoubleDefault(1.0);
                }
                IAST list = (IAST)ast.arg1();
                buf.append("{type: 'cone',");
                GraphicsFunctions.setColor(buf, color, F.NIL, true);
                GraphicsFunctions.setOpacity(buf, opacity.orElse(F.C1D2));
                buf.append("radius: " + radius + ",");
                if (list.isListOfLists() && GraphicsFunctions.graphics3DCoords(buf, list)) {
                    buf.append("}");
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Cuboid
    extends AbstractEvaluator
    implements IGraphics3D {
        private Cuboid() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                return F.Cuboid(F.List(0, 0, 0), F.List(1, 1, 1));
            }
            if (ast.isAST1() && ast.arg1().isList3()) {
                IASTMutable list2 = ((IAST)ast.arg1()).copy();
                for (int i = 1; i < list2.size(); ++i) {
                    list2.set(i, F.Plus((IExpr)F.C1, list2.get(i)));
                }
                return F.Cuboid(ast.arg1(), list2);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_INFINITY;
        }

        @Override
        public boolean graphics3D(StringBuilder buf, IAST ast, IAST color, IExpr opacity) {
            if (ast.argSize() > 0 && ast.arg1().isList()) {
                buf.append("{type: 'cuboid',");
                GraphicsFunctions.setColor(buf, color, F.NIL, true);
                GraphicsFunctions.setOpacity(buf, opacity.orElse(F.C1D2));
                if (GraphicsFunctions.graphics3DCoords(buf, ast)) {
                    buf.append("}");
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Circle
    extends AbstractEvaluator
    implements IGraphics3D {
        private Circle() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }

        @Override
        public boolean graphics2DDimension(IAST ast, Dimensions2D dim) {
            if (ast.size() == 1) {
                double cx = 1.0;
                double cy = 1.0;
                double rx = 1.0;
                double ry = 1.0;
                dim.minMax(cx - rx, cx + rx, cy - ry, cy + ry);
                return true;
            }
            if (ast.size() == 2) {
                if (ast.arg1().isAST(S.List, 3)) {
                    IAST list1 = (IAST)ast.arg1();
                    double cx = ((ISignedNumber)list1.arg1()).doubleValue();
                    double cy = ((ISignedNumber)list1.arg2()).doubleValue();
                    double rx = 1.0;
                    double ry = 1.0;
                    dim.minMax(cx - rx, cx + rx, cy - ry, cy + ry);
                    return true;
                }
            } else if (ast.size() == 3 && ast.arg1().isAST(S.List, 3) && ast.arg2().isAST(S.List, 3)) {
                IAST list1 = (IAST)ast.arg1();
                IAST list2 = (IAST)ast.arg2();
                double cx = ((ISignedNumber)list1.arg1()).doubleValue();
                double cy = ((ISignedNumber)list1.arg2()).doubleValue();
                double rx = ((ISignedNumber)list2.arg1()).doubleValue();
                double ry = ((ISignedNumber)list2.arg2()).doubleValue();
                dim.minMax(cx - rx, cx + rx, cy - ry, cy + ry);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean graphics2D(StringBuilder buf, IAST ast, Dimensions2D dim, IAST color, IExpr opacity) {
            try {
                int width = dim.width;
                int height = dim.height;
                double xMin = dim.xMin;
                double xMax = dim.xMax;
                double yMin = dim.yMin;
                double yMax = dim.yMax;
                if (ast.size() == 1) {
                    buf.append("<ellipse ");
                    double xAxisScalingFactor = (double)width / (xMax - xMin);
                    double yAxisScalingFactor = (double)height / (yMax - yMin);
                    double cx = 1.0;
                    double cy = 1.0;
                    double rx = 1.0;
                    double ry = 1.0;
                    buf.append("cx=\"");
                    buf.append(FORMATTER.format(cx * xAxisScalingFactor));
                    buf.append("\" cy=\"");
                    buf.append(FORMATTER.format(cy * yAxisScalingFactor));
                    buf.append("\" rx=\"");
                    buf.append(FORMATTER.format(rx * xAxisScalingFactor));
                    buf.append("\" ry=\"");
                    buf.append(FORMATTER.format(ry * yAxisScalingFactor));
                    boolean bl = true;
                    return bl;
                }
                if (ast.size() == 2) {
                    if (ast.arg1().isAST(S.List, 3)) {
                        IAST list1 = (IAST)ast.arg1();
                        buf.append("<ellipse ");
                        double xAxisScalingFactor = (double)width / (xMax - xMin);
                        double yAxisScalingFactor = (double)height / (yMax - yMin);
                        double cx = ((ISignedNumber)list1.arg1()).doubleValue();
                        double cy = ((ISignedNumber)list1.arg2()).doubleValue();
                        double rx = 1.0;
                        double ry = 1.0;
                        buf.append("cx=\"");
                        buf.append(FORMATTER.format(cx * xAxisScalingFactor));
                        buf.append("\" cy=\"");
                        buf.append(FORMATTER.format(cy * yAxisScalingFactor));
                        buf.append("\" rx=\"");
                        buf.append(FORMATTER.format(rx * xAxisScalingFactor));
                        buf.append("\" ry=\"");
                        buf.append(FORMATTER.format(ry * yAxisScalingFactor));
                        boolean bl = true;
                        return bl;
                    }
                } else if (ast.size() == 3 && ast.arg1().isAST(S.List, 3) && ast.arg2().isAST(S.List, 3)) {
                    IAST list1 = (IAST)ast.arg1();
                    IAST list2 = (IAST)ast.arg2();
                    buf.append("<ellipse ");
                    double xAxisScalingFactor = (double)width / (xMax - xMin);
                    double yAxisScalingFactor = (double)height / (yMax - yMin);
                    double cx = ((ISignedNumber)list1.arg1()).doubleValue();
                    double cy = ((ISignedNumber)list1.arg2()).doubleValue();
                    double rx = ((ISignedNumber)list2.arg1()).doubleValue();
                    double ry = ((ISignedNumber)list2.arg2()).doubleValue();
                    buf.append("cx=\"");
                    buf.append(FORMATTER.format(cx * xAxisScalingFactor));
                    buf.append("\" cy=\"");
                    buf.append(FORMATTER.format(cy * yAxisScalingFactor));
                    buf.append("\" rx=\"");
                    buf.append(FORMATTER.format(rx * xAxisScalingFactor));
                    buf.append("\" ry=\"");
                    buf.append(FORMATTER.format(ry * yAxisScalingFactor));
                    boolean bl = true;
                    return bl;
                }
            }
            catch (RuntimeException ex) {
                LOGGER.error("Circle.graphics2D() failed", (Throwable)ex);
            }
            finally {
                buf.append("\" \n      style=\"stroke: none; stroke-width: 0.000000px; ");
                buf.append("fill: rgb(");
                dim.getColorRGB(buf);
                buf.append("); ");
                buf.append("stroke-opacity: 1; stroke-width: 0.666667px; fill-opacity: 1\" />\n");
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class BernsteinBasis
    extends AbstractEvaluator {
        private BernsteinBasis() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr dArg1 = ast.arg1();
            IExpr nArg2 = ast.arg2();
            IExpr x = ast.arg3();
            if (dArg1.isReal() && nArg2.isReal() && x.isReal()) {
                int d = dArg1.toIntDefault();
                if (d < 0) {
                    return IOFunctions.printMessage(ast.topHead(), "intnm", F.list(ast, F.C1), engine);
                }
                IInteger di = F.ZZ(d);
                int n = nArg2.toIntDefault();
                if (n < 0) {
                    return IOFunctions.printMessage(ast.topHead(), "intnm", F.list(ast, F.C1), engine);
                }
                if (n > d) {
                    return IOFunctions.printMessage(ast.topHead(), "invidx2", F.list(nArg2, F.C0, di), engine);
                }
                if (engine.evalLess(F.C0, x, F.C1)) {
                    IInteger ni = F.ZZ(n);
                    return F.Times((IExpr)F.Binomial(di, ni), (IExpr)F.Power(x, ni), (IExpr)F.Power((IExpr)F.Subtract(F.C1, x), F.Subtract(di, ni)));
                }
                return F.C0;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(26112);
        }
    }

    private static class Arrow
    extends AbstractEvaluator
    implements IGraphics3D {
        private Arrow() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }

        @Override
        public boolean graphics3D(StringBuilder buf, IAST ast, IAST color, IExpr opacity) {
            if (ast.argSize() > 0 && ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                buf.append("{type: 'arrow',");
                GraphicsFunctions.setColor(buf, color, F.NIL, true);
                GraphicsFunctions.setOpacity(buf, opacity.orElse(F.C1));
                if (list.isListOfLists() && GraphicsFunctions.graphics3DCoords(buf, list)) {
                    buf.append("}");
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }
}

