/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticMeasurement;
import org.gavaghan.geodesy.GlobalPosition;
import org.hipparchus.util.MathArrays;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.GraphType;
import org.jgrapht.Graphs;
import org.jgrapht.alg.cycle.HierholzerEulerianCycle;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.interfaces.VertexCoverAlgorithm;
import org.jgrapht.alg.isomorphism.AHUUnrootedTreeIsomorphismInspector;
import org.jgrapht.alg.isomorphism.IsomorphicGraphMapping;
import org.jgrapht.alg.planar.BoyerMyrvoldPlanarityInspector;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.alg.shortestpath.GraphMeasurer;
import org.jgrapht.alg.spanning.BoruvkaMinimumSpanningTree;
import org.jgrapht.alg.tour.HeldKarpTSP;
import org.jgrapht.alg.vertexcover.GreedyVCImpl;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultUndirectedGraph;
import org.jgrapht.graph.DefaultUndirectedWeightedGraph;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.convert.Object2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.ExprEdge;
import org.matheclipse.core.expression.data.ExprWeightedEdge;
import org.matheclipse.core.expression.data.GeoPositionExpr;
import org.matheclipse.core.expression.data.GraphExpr;
import org.matheclipse.core.expression.data.SparseArrayExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.trie.Trie;

public class GraphFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    private static GraphExpr<?> createGraph(IExpr arg1) {
        if (arg1.head().equals(S.Graph) && arg1 instanceof GraphExpr) {
            return (GraphExpr)arg1;
        }
        GraphType t = arg1.isListOfEdges();
        if (t != null) {
            Object g = t.isDirected() ? new DefaultDirectedGraph(ExprEdge.class) : new DefaultUndirectedGraph(ExprEdge.class);
            IAST list = (IAST)arg1;
            for (int i = 1; i < list.size(); ++i) {
                IAST edge = list.getAST(i);
                g.addVertex((Object)edge.arg1());
                g.addVertex((Object)edge.arg2());
                g.addEdge((Object)edge.arg1(), (Object)edge.arg2());
            }
            return GraphExpr.newInstance(g);
        }
        return null;
    }

    private static GraphExpr<ExprWeightedEdge> createWeightedGraph(IAST vertices, IAST arg1, IAST edgeWeight) {
        if (arg1.size() != edgeWeight.size()) {
            return null;
        }
        GraphType t = arg1.isListOfEdges();
        if (t != null) {
            Object g = t.isDirected() ? new DefaultDirectedWeightedGraph(ExprWeightedEdge.class) : new DefaultUndirectedWeightedGraph(ExprWeightedEdge.class);
            IAST list = arg1;
            for (int i = 1; i < list.size(); ++i) {
                IAST edge = list.getAST(i);
                g.addVertex((Object)edge.arg1());
                g.addVertex((Object)edge.arg2());
                g.addEdge((Object)edge.arg1(), (Object)edge.arg2());
            }
            if (t.isDirected()) {
                DefaultDirectedWeightedGraph gw = g;
                for (int i = 1; i < list.size(); ++i) {
                    IAST edge = list.getAST(i);
                    gw.setEdgeWeight((Object)edge.arg1(), (Object)edge.arg2(), edgeWeight.get(i).evalDouble());
                }
            } else {
                DefaultUndirectedWeightedGraph gw = (DefaultUndirectedWeightedGraph)g;
                for (int i = 1; i < list.size(); ++i) {
                    IAST edge = list.getAST(i);
                    gw.setEdgeWeight((Object)edge.arg1(), (Object)edge.arg2(), edgeWeight.get(i).evalDouble());
                }
            }
            return GraphExpr.newInstance(g);
        }
        return null;
    }

    private static GraphExpr<ExprEdge> createGraph(IAST vertices, IAST edges) {
        GraphType t = edges.isListOfEdges();
        if (t != null) {
            int i;
            Object g = t.isDirected() ? new DefaultDirectedGraph(ExprEdge.class) : new DefaultUndirectedGraph(ExprEdge.class);
            if (vertices.isList()) {
                for (i = 1; i < vertices.size(); ++i) {
                    g.addVertex((Object)vertices.get(i));
                }
            }
            for (i = 1; i < edges.size(); ++i) {
                IAST edge = edges.getAST(i);
                g.addVertex((Object)edge.arg1());
                g.addVertex((Object)edge.arg2());
                g.addEdge((Object)edge.arg1(), (Object)edge.arg2());
            }
            return GraphExpr.newInstance(g);
        }
        return null;
    }

    private static GraphPath<IExpr, ?> eulerianCycle(GraphExpr<?> gex) {
        if (gex.isWeightedGraph()) {
            Graph g = (Graph)gex.toData();
            HierholzerEulerianCycle eca = new HierholzerEulerianCycle();
            try {
                return eca.getEulerianCycle(g);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        } else {
            Graph g = (Graph)gex.toData();
            HierholzerEulerianCycle eca = new HierholzerEulerianCycle();
            try {
                return eca.getEulerianCycle(g);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static GraphPath<IExpr, ?> hamiltonianCycle(GraphExpr<?> gex) {
        if (gex.isWeightedGraph()) {
            Graph g = (Graph)gex.toData();
            HeldKarpTSP eca = new HeldKarpTSP();
            try {
                return eca.getTour(g);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        } else {
            Graph g = (Graph)gex.toData();
            HeldKarpTSP eca = new HeldKarpTSP();
            try {
                return eca.getTour(g);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void initialize() {
        Initializer.init();
    }

    private GraphFunctions() {
    }

    public static IExpr graphToIExpr(AbstractBaseGraph<IExpr, ExprEdge> g) {
        IASTAppendable vertexes = GraphFunctions.vertexToIExpr(g);
        IASTAppendable[] edgeData = GraphFunctions.edgesToIExpr(g);
        if (edgeData[1] == null) {
            return F.Graph(vertexes, edgeData[0]);
        }
        return F.Graph(vertexes, edgeData[0], F.list(F.Rule((IExpr)S.EdgeWeight, (IExpr)edgeData[1])));
    }

    public static IExpr weightedGraphToIExpr(AbstractBaseGraph<IExpr, ExprWeightedEdge> g) {
        IASTAppendable vertexes = GraphFunctions.vertexToIExpr(g);
        IASTAppendable[] res = GraphFunctions.weightedEdgesToIExpr(g);
        IAST graph = F.Graph(vertexes, res[0], F.list(F.Rule((IExpr)S.EdgeWeight, (IExpr)res[1])));
        return graph;
    }

    private static IASTAppendable vertexToIExpr(Graph<IExpr, ?> g) {
        Set vertexSet = g.vertexSet();
        IASTAppendable vertexes = F.ListAlloc(vertexSet.size());
        for (IExpr expr : vertexSet) {
            vertexes.append(expr);
        }
        return vertexes;
    }

    private static IASTAppendable[] edgesToIExpr(Graph<IExpr, ?> g) {
        Set edgeSet = g.edgeSet();
        IASTAppendable edges = F.ListAlloc(edgeSet.size());
        IASTAppendable weights = null;
        GraphType type = g.getType();
        for (Object edge : edgeSet) {
            if (edge instanceof ExprWeightedEdge) {
                ExprWeightedEdge weightedEdge = (ExprWeightedEdge)((Object)edge);
                if (type.isDirected()) {
                    edges.append(F.DirectedEdge(weightedEdge.lhs(), weightedEdge.rhs()));
                } else {
                    edges.append(F.UndirectedEdge(weightedEdge.lhs(), weightedEdge.rhs()));
                }
                if (weights == null) {
                    weights = F.ListAlloc(edgeSet.size());
                }
                weights.append(weightedEdge.weight());
                continue;
            }
            if (!(edge instanceof ExprEdge)) continue;
            ExprEdge exprEdge = (ExprEdge)((Object)edge);
            if (type.isDirected()) {
                edges.append(F.DirectedEdge(exprEdge.lhs(), exprEdge.rhs()));
                continue;
            }
            edges.append(F.UndirectedEdge(exprEdge.lhs(), exprEdge.rhs()));
        }
        return new IASTAppendable[]{edges, weights};
    }

    private static IASTAppendable[] edgesToRules(Graph<IExpr, ?> g) {
        Set edgeSet = g.edgeSet();
        IASTAppendable edges = F.ListAlloc(edgeSet.size());
        IASTAppendable weights = null;
        GraphType type = g.getType();
        for (Object edge : edgeSet) {
            if (edge instanceof ExprWeightedEdge) {
                ExprWeightedEdge weightedEdge = (ExprWeightedEdge)((Object)edge);
                edges.append(F.Rule(weightedEdge.lhs(), weightedEdge.rhs()));
                if (weights == null) {
                    weights = F.ListAlloc(edgeSet.size());
                }
                weights.append(weightedEdge.weight());
                continue;
            }
            if (!(edge instanceof ExprEdge)) continue;
            ExprEdge exprEdge = (ExprEdge)((Object)edge);
            edges.append(F.Rule(exprEdge.lhs(), exprEdge.rhs()));
        }
        return new IASTAppendable[]{edges, weights};
    }

    private static IASTAppendable[] weightedEdgesToIExpr(Graph<IExpr, ExprWeightedEdge> graph) {
        Set edgeSet = graph.edgeSet();
        IASTAppendable edges = F.ListAlloc(edgeSet.size());
        IASTAppendable weights = F.ListAlloc(edgeSet.size());
        GraphType type = graph.getType();
        if (type.isDirected()) {
            for (ExprWeightedEdge edge : edgeSet) {
                edges.append(F.DirectedEdge(edge.lhs(), edge.rhs()));
                weights.append(edge.weight());
            }
        } else {
            for (ExprWeightedEdge edge : edgeSet) {
                edges.append(F.UndirectedEdge(edge.lhs(), edge.rhs()));
                weights.append(edge.weight());
            }
        }
        return new IASTAppendable[]{edges, weights};
    }

    public static IExpr graphToAdjacencyMatrix(Graph<IExpr, ExprEdge> g) {
        Set vertexSet = g.vertexSet();
        int size = vertexSet.size();
        HashMap<IExpr, Integer> map = new HashMap<IExpr, Integer>();
        int indx = 1;
        for (IExpr expr : vertexSet) {
            map.put(expr, indx++);
        }
        Trie trie = Config.TRIE_INT2EXPR_BUILDER.build();
        for (ExprEdge edge : g.edgeSet()) {
            IExpr lhs = edge.lhs();
            IExpr rhs = edge.rhs();
            int from = (Integer)map.get(lhs);
            int to = (Integer)map.get(rhs);
            trie.put((Object)new int[]{from, to}, (Object)F.C1);
            if (!g.containsEdge((Object)rhs, (Object)lhs)) continue;
            trie.put((Object)new int[]{to, from}, (Object)F.C1);
        }
        return new SparseArrayExpr((Trie<int[], IExpr>)trie, new int[]{size, size}, F.C0, false);
    }

    public static IExpr weightedGraphToAdjacencyMatrix(Graph<IExpr, ExprWeightedEdge> g) {
        Set vertexSet = g.vertexSet();
        int size = vertexSet.size();
        HashMap<IExpr, Integer> map = new HashMap<IExpr, Integer>();
        int indx = 1;
        for (IExpr expr : vertexSet) {
            map.put(expr, indx++);
        }
        Trie trie = Config.TRIE_INT2EXPR_BUILDER.build();
        for (ExprWeightedEdge edge : g.edgeSet()) {
            IExpr lhs = edge.lhs();
            IExpr rhs = edge.rhs();
            int from = (Integer)map.get(lhs);
            int to = (Integer)map.get(rhs);
            trie.put((Object)new int[]{from, to}, (Object)F.C1);
            if (!g.containsEdge((Object)rhs, (Object)lhs)) continue;
            trie.put((Object)new int[]{to, from}, (Object)F.C1);
        }
        return new SparseArrayExpr((Trie<int[], IExpr>)trie, new int[]{size, size}, F.C0, false);
    }

    public static IExpr weightedGraphToWeightedAdjacencyMatrix(Graph<IExpr, ExprWeightedEdge> g) {
        Set vertexSet = g.vertexSet();
        int size = vertexSet.size();
        HashMap<IExpr, Integer> map = new HashMap<IExpr, Integer>();
        int indx = 1;
        for (IExpr expr : vertexSet) {
            map.put(expr, indx++);
        }
        Trie trie = Config.TRIE_INT2EXPR_BUILDER.build();
        for (ExprWeightedEdge edge : g.edgeSet()) {
            IExpr lhs = edge.lhs();
            IExpr rhs = edge.rhs();
            int from = (Integer)map.get(lhs);
            int to = (Integer)map.get(rhs);
            trie.put((Object)new int[]{from, to}, (Object)F.num(edge.weight()));
            if (!g.containsEdge((Object)rhs, (Object)lhs)) continue;
            trie.put((Object)new int[]{to, from}, (Object)F.num(edge.weight()));
        }
        return new SparseArrayExpr((Trie<int[], IExpr>)trie, new int[]{size, size}, F.C0, false);
    }

    public static String graphToJSForm(GraphExpr graphExpr) {
        GraphExpr gex = graphExpr;
        AbstractBaseGraph g = (AbstractBaseGraph)gex.toData();
        HashMap<IExpr, Integer> map = new HashMap<IExpr, Integer>();
        StringBuilder buf = new StringBuilder();
        if (g.getType().isWeighted()) {
            GraphFunctions.weightedGraphToVisjs(map, buf, (AbstractBaseGraph<IExpr, ExprWeightedEdge>)g);
        } else {
            GraphFunctions.graphToVisjs(map, buf, (AbstractBaseGraph<IExpr, ExprEdge>)g);
        }
        return buf.toString();
    }

    public static void graphToVisjs(Map<IExpr, Integer> map, StringBuilder buf, AbstractBaseGraph<IExpr, ExprEdge> g) {
        GraphFunctions.vertexToVisjs(map, buf, g);
        GraphFunctions.edgesToVisjs(map, buf, g);
    }

    public static void weightedGraphToVisjs(Map<IExpr, Integer> map, StringBuilder buf, AbstractBaseGraph<IExpr, ExprWeightedEdge> g) {
        GraphFunctions.vertexToVisjs(map, buf, g);
        GraphFunctions.weightedEdgesToVisjs(map, buf, g);
    }

    private static void vertexToVisjs(Map<IExpr, Integer> map, StringBuilder buf, Graph<IExpr, ?> g) {
        Set vertexSet = g.vertexSet();
        IASTAppendable vertexes = F.ListAlloc(vertexSet.size());
        buf.append("var nodes = new vis.DataSet([\n");
        boolean first = true;
        int counter = 1;
        for (IExpr expr : vertexSet) {
            if (first) {
                buf.append("  {id: ");
            } else {
                buf.append(", {id: ");
            }
            buf.append(counter);
            map.put(expr, counter++);
            buf.append(", label: '");
            buf.append(expr.toString());
            buf.append("'}\n");
            first = false;
        }
        buf.append("]);\n");
    }

    private static void edgesToVisjs(Map<IExpr, Integer> map, StringBuilder buf, Graph<IExpr, ExprEdge> g) {
        Set edgeSet = g.edgeSet();
        GraphType type = g.getType();
        boolean first = true;
        if (type.isDirected()) {
            buf.append("var edges = new vis.DataSet([\n");
            for (Object object : edgeSet) {
                if (object instanceof ExprEdge) {
                    ExprEdge edge = (ExprEdge)((Object)object);
                    if (first) {
                        buf.append("  {from: ");
                    } else {
                        buf.append(", {from: ");
                    }
                    buf.append(map.get(edge.lhs()));
                    buf.append(", to: ");
                    buf.append(map.get(edge.rhs()));
                    buf.append(" , arrows: { to: { enabled: true, type: 'arrow'}}");
                    buf.append("}\n");
                    first = false;
                    continue;
                }
                if (!(object instanceof ExprWeightedEdge)) continue;
                ExprWeightedEdge weightedEdge = (ExprWeightedEdge)((Object)object);
                if (first) {
                    buf.append("  {from: ");
                } else {
                    buf.append(", {from: ");
                }
                buf.append(map.get(weightedEdge.lhs()));
                buf.append(", to: ");
                buf.append(map.get(weightedEdge.rhs()));
                buf.append(" , arrows: { to: { enabled: true, type: 'arrow'}}");
                buf.append("}\n");
                first = false;
            }
        } else {
            buf.append("var edges = new vis.DataSet([\n");
            for (Object object : edgeSet) {
                if (object instanceof ExprEdge) {
                    ExprEdge edge = (ExprEdge)((Object)object);
                    if (first) {
                        buf.append("  {from: ");
                    } else {
                        buf.append(", {from: ");
                    }
                    buf.append(map.get(edge.lhs()));
                    buf.append(", to: ");
                    buf.append(map.get(edge.rhs()));
                    buf.append("}\n");
                    first = false;
                    continue;
                }
                if (!(object instanceof ExprWeightedEdge)) continue;
                ExprWeightedEdge weightedEdge = (ExprWeightedEdge)((Object)object);
                if (first) {
                    buf.append("  {from: ");
                } else {
                    buf.append(", {from: ");
                }
                buf.append(map.get(weightedEdge.lhs()));
                buf.append(", to: ");
                buf.append(map.get(weightedEdge.rhs()));
                buf.append("}\n");
                first = false;
            }
        }
        buf.append("]);\n");
    }

    private static void weightedEdgesToVisjs(Map<IExpr, Integer> map, StringBuilder buf, Graph<IExpr, ExprWeightedEdge> graph) {
        Set edgeSet = graph.edgeSet();
        GraphType type = graph.getType();
        boolean first = true;
        if (type.isDirected()) {
            buf.append("var edges = new vis.DataSet([\n");
            for (Object object : edgeSet) {
                if (!(object instanceof ExprWeightedEdge)) continue;
                ExprWeightedEdge edge = (ExprWeightedEdge)((Object)object);
                if (first) {
                    buf.append("  {from: ");
                } else {
                    buf.append(", {from: ");
                }
                buf.append(map.get(edge.lhs()));
                buf.append(", to: ");
                buf.append(map.get(edge.rhs()));
                buf.append(", label: '");
                buf.append(edge.weight());
                buf.append("'");
                buf.append(" , arrows: { to: { enabled: true, type: 'arrow'}}");
                buf.append("}\n");
                first = false;
            }
        } else {
            buf.append("var edges = new vis.DataSet([\n");
            for (Object object : edgeSet) {
                if (!(object instanceof ExprWeightedEdge)) continue;
                ExprWeightedEdge edge = (ExprWeightedEdge)((Object)object);
                if (first) {
                    buf.append("  {from: ");
                } else {
                    buf.append(", {from: ");
                }
                buf.append(map.get(edge.lhs()));
                buf.append(", to: ");
                buf.append(map.get(edge.rhs()));
                buf.append(", label: '");
                buf.append(edge.weight());
                buf.append("'");
                buf.append("}\n");
                first = false;
            }
        }
        buf.append("]);\n");
    }

    private static class WeightedGraphQ
    extends AbstractEvaluator {
        private WeightedGraphQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                GraphExpr<?> gex;
                if (ast.isAST1() && (gex = GraphFunctions.createGraph(ast.arg1())) != null && gex.isWeightedGraph()) {
                    return S.True;
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("WeightedGraphQ.evaluate() failed", (Throwable)rex);
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class WeightedAdjacencyMatrix
    extends AbstractEvaluator {
        private WeightedAdjacencyMatrix() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex == null) {
                        return F.NIL;
                    }
                    if (gex.isWeightedGraph()) {
                        return GraphFunctions.weightedGraphToWeightedAdjacencyMatrix((Graph<IExpr, ExprWeightedEdge>)((Graph)gex.toData()));
                    }
                    return GraphFunctions.graphToAdjacencyMatrix((Graph<IExpr, ExprEdge>)((Graph)gex.toData()));
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("WeightedAdjacencyMatrix.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class VertexQ
    extends AbstractEvaluator {
        private VertexQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                GraphExpr<?> gex;
                if (ast.isAST2() && (gex = GraphFunctions.createGraph(ast.arg1())) != null) {
                    Graph g = (Graph)gex.toData();
                    return F.bool(g.containsVertex((Object)ast.arg2()));
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("VertexQ.evaluate() failed", (Throwable)rex);
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class VertexList
    extends AbstractEvaluator {
        private VertexList() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex == null) {
                        return F.NIL;
                    }
                    Graph g = (Graph)gex.toData();
                    return GraphFunctions.vertexToIExpr(g);
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("VertexList.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class VertexEccentricity
    extends AbstractEvaluator {
        private VertexEccentricity() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                if (gex == null) {
                    return F.NIL;
                }
                Graph g = (Graph)gex.toData();
                GraphMeasurer graphMeasurer = new GraphMeasurer(g);
                Map centerSet = graphMeasurer.getVertexEccentricityMap();
                Double dValue = (Double)centerSet.get(ast.arg2());
                if (dValue != null) {
                    INum vertexEccentricity = F.num(dValue);
                    if (gex.isWeightedGraph()) {
                        return vertexEccentricity;
                    }
                    int intVertexEccentricity = vertexEccentricity.toIntDefault();
                    if (intVertexEccentricity != Integer.MIN_VALUE) {
                        return F.ZZ(intVertexEccentricity);
                    }
                    return vertexEccentricity;
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("VertexEccentricity.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class PlanarGraphQ
    extends AbstractEvaluator {
        private PlanarGraphQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex == null) {
                        return S.False;
                    }
                    if (gex.isWeightedGraph()) {
                        Graph g = (Graph)gex.toData();
                        BoyerMyrvoldPlanarityInspector inspector = new BoyerMyrvoldPlanarityInspector(g);
                        return F.bool(inspector.isPlanar());
                    }
                    Graph g = (Graph)gex.toData();
                    BoyerMyrvoldPlanarityInspector inspector = new BoyerMyrvoldPlanarityInspector(g);
                    return F.bool(inspector.isPlanar());
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("PlanarGraphQ.evaluate() failed", (Throwable)rex);
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class LineGraph
    extends AbstractEvaluator {
        private LineGraph() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class FindShortestPath
    extends AbstractEvaluator {
        private FindShortestPath() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                if (gex == null) {
                    return F.NIL;
                }
                Graph g = (Graph)gex.toData();
                DijkstraShortestPath dijkstraAlg = new DijkstraShortestPath(g);
                ShortestPathAlgorithm.SingleSourcePaths iPaths = dijkstraAlg.getPaths((Object)ast.arg2());
                GraphPath path = iPaths.getPath((Object)ast.arg3());
                return Object2Expr.convertList(path.getVertexList(), true, false);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("FindShortestPath.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }
    }

    private static class FindVertexCover
    extends AbstractEvaluator {
        private FindVertexCover() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex == null) {
                        return F.NIL;
                    }
                    Graph g = (Graph)gex.toData();
                    GreedyVCImpl greedy = new GreedyVCImpl(g);
                    VertexCoverAlgorithm.VertexCover cover = greedy.getVertexCover();
                    if (cover == null) {
                        return F.List();
                    }
                    IASTAppendable result = F.ListAlloc(10);
                    cover.forEach(x -> result.append((IExpr)x));
                    return result;
                }
            }
            catch (IllegalArgumentException iae) {
                LOGGER.log(engine.getLogLevel(), "Graph must be undirected");
            }
            catch (RuntimeException rex) {
                LOGGER.debug("FindVertexCover.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class FindGraphIsomorphism
    extends AbstractEvaluator {
        private FindGraphIsomorphism() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                GraphExpr<?> gex1 = GraphFunctions.createGraph(ast.arg1());
                if (gex1 == null) {
                    return F.NIL;
                }
                GraphExpr<?> gex2 = GraphFunctions.createGraph(ast.arg2());
                if (gex2 == null) {
                    return F.NIL;
                }
                AHUUnrootedTreeIsomorphismInspector isomorphism = new AHUUnrootedTreeIsomorphismInspector((Graph)gex1.toData(), (Graph)gex2.toData());
                IsomorphicGraphMapping mapping = isomorphism.getMapping();
                if (mapping == null) {
                    return F.CEmptyList;
                }
                Map forwardMapping = mapping.getForwardMapping();
                IASTAppendable list = F.ListAlloc(forwardMapping.size());
                for (Map.Entry entry : forwardMapping.entrySet()) {
                    list.append(F.Rule((IExpr)entry.getKey(), (IExpr)entry.getValue()));
                }
                return F.list(F.assoc(list));
            }
            catch (RuntimeException rex) {
                LOGGER.debug("FindGraphIsomorphism.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class FindHamiltonianCycle
    extends AbstractEvaluator {
        private FindHamiltonianCycle() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex == null) {
                        return F.NIL;
                    }
                    GraphPath<IExpr, ?> path = GraphFunctions.hamiltonianCycle(gex);
                    if (path == null) {
                        return F.CEmptyList;
                    }
                    List iList = path.getVertexList();
                    IASTAppendable list = F.ListAlloc(iList.size());
                    for (int i = 0; i < iList.size() - 1; ++i) {
                        list.append(F.DirectedEdge((IExpr)iList.get(i), (IExpr)iList.get(i + 1)));
                    }
                    return list;
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("FindHamiltonianCycle.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class FindEulerianCycle
    extends AbstractEvaluator {
        private FindEulerianCycle() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex == null) {
                        return F.NIL;
                    }
                    GraphPath<IExpr, ?> path = GraphFunctions.eulerianCycle(gex);
                    if (path == null) {
                        return F.CEmptyList;
                    }
                    List iList = path.getVertexList();
                    IASTAppendable list = F.ListAlloc(iList.size());
                    for (int i = 0; i < iList.size() - 1; ++i) {
                        list.append(F.DirectedEdge((IExpr)iList.get(i), (IExpr)iList.get(i + 1)));
                    }
                    return list;
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("FindEulerianCycle.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class IsomorphicGraphQ
    extends AbstractEvaluator {
        private IsomorphicGraphQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                GraphExpr<?> gex1 = GraphFunctions.createGraph(ast.arg1());
                if (gex1 == null) {
                    return F.NIL;
                }
                GraphExpr<?> gex2 = GraphFunctions.createGraph(ast.arg2());
                if (gex2 == null) {
                    return F.NIL;
                }
                AHUUnrootedTreeIsomorphismInspector isomorphism = new AHUUnrootedTreeIsomorphismInspector((Graph)gex1.toData(), (Graph)gex2.toData());
                return F.bool(isomorphism.isomorphismExists());
            }
            catch (RuntimeException rex) {
                LOGGER.debug("IsomorphicGraphQ.evaluate() failed", (Throwable)rex);
                return S.False;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class HamiltonianGraphQ
    extends AbstractEvaluator {
        private HamiltonianGraphQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex == null) {
                        return F.NIL;
                    }
                    GraphPath<IExpr, ?> path = GraphFunctions.hamiltonianCycle(gex);
                    if (path != null) {
                        return S.True;
                    }
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("HamiltonianGraphQ.evaluate() failed", (Throwable)rex);
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class EulerianGraphQ
    extends AbstractEvaluator {
        private EulerianGraphQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex == null) {
                        return F.NIL;
                    }
                    GraphPath<IExpr, ?> path = GraphFunctions.eulerianCycle(gex);
                    if (path != null) {
                        return S.True;
                    }
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("EulerianGraphQ.evaluate() failed", (Throwable)rex);
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class BetweennessCentrality
    extends ClosenessCentrality {
        private BetweennessCentrality() {
        }

        @Override
        protected Map<IExpr, Double> getScores(Graph<IExpr, ExprEdge> g) {
            org.jgrapht.alg.scoring.BetweennessCentrality bc = new org.jgrapht.alg.scoring.BetweennessCentrality(g);
            Map scores = bc.getScores();
            return scores;
        }
    }

    private static class ClosenessCentrality
    extends AbstractEvaluator {
        private ClosenessCentrality() {
        }

        protected Map<IExpr, Double> getScores(Graph<IExpr, ExprEdge> g) {
            org.jgrapht.alg.scoring.ClosenessCentrality bc = new org.jgrapht.alg.scoring.ClosenessCentrality(g);
            Map scores = bc.getScores();
            return scores;
        }

        protected Map<IExpr, Double> getWeightedScores(Graph<IExpr, ExprWeightedEdge> g) {
            org.jgrapht.alg.scoring.ClosenessCentrality bc = new org.jgrapht.alg.scoring.ClosenessCentrality(g);
            Map scores = bc.getScores();
            return scores;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                if (gex == null) {
                    return F.NIL;
                }
                Graph g = (Graph)gex.toData();
                Map<IExpr, Double> scores = gex.isWeightedGraph() ? this.getWeightedScores((Graph<IExpr, ExprWeightedEdge>)g) : this.getScores((Graph<IExpr, ExprEdge>)g);
                IASTAppendable list = F.ListAlloc(scores.size());
                Set vertexSet = g.vertexSet();
                for (IExpr expr : vertexSet) {
                    Double value = scores.get(expr);
                    if (value == null) {
                        return F.NIL;
                    }
                    list.append(value);
                }
                return list;
            }
            catch (RuntimeException rex) {
                LOGGER.debug("ClosenessCentrality.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class EdgeRules
    extends AbstractEvaluator {
        private EdgeRules() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex == null) {
                        return F.NIL;
                    }
                    Graph g = (Graph)gex.toData();
                    return GraphFunctions.edgesToRules(g)[0];
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("EdgeList.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class EdgeQ
    extends AbstractEvaluator {
        private EdgeQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST2() && ast.arg2().isEdge()) {
                    IAST edge = (IAST)ast.arg2();
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex != null) {
                        Graph g = (Graph)gex.toData();
                        return F.bool(g.containsEdge((Object)edge.first(), (Object)edge.second()));
                    }
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("EdgeQ.evaluate() failed", (Throwable)rex);
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class EdgeList
    extends AbstractEvaluator {
        private EdgeList() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex == null) {
                        return F.NIL;
                    }
                    Graph g = (Graph)gex.toData();
                    return GraphFunctions.edgesToIExpr(g)[0];
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("EdgeList.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class AdjacencyMatrix
    extends AbstractEvaluator {
        private AdjacencyMatrix() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex == null) {
                        return F.NIL;
                    }
                    if (gex.isWeightedGraph()) {
                        return GraphFunctions.weightedGraphToAdjacencyMatrix((Graph<IExpr, ExprWeightedEdge>)((Graph)gex.toData()));
                    }
                    return GraphFunctions.graphToAdjacencyMatrix((Graph<IExpr, ExprEdge>)((Graph)gex.toData()));
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("AdjacencyMatrix.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class FindSpanningTree
    extends AbstractEvaluator {
        private FindSpanningTree() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex == null) {
                        return F.NIL;
                    }
                    if (gex.isWeightedGraph()) {
                        Graph g = (Graph)gex.toData();
                        BoruvkaMinimumSpanningTree k = new BoruvkaMinimumSpanningTree(g);
                        Set edgeSet = k.getSpanningTree().getEdges();
                        DefaultDirectedGraph gResult = new DefaultDirectedGraph(ExprWeightedEdge.class);
                        Graphs.addAllEdges((Graph)gResult, (Graph)g, (Collection)edgeSet);
                        return GraphExpr.newInstance(gResult);
                    }
                    Graph g = (Graph)gex.toData();
                    BoruvkaMinimumSpanningTree k = new BoruvkaMinimumSpanningTree(g);
                    Set edgeSet = k.getSpanningTree().getEdges();
                    DefaultDirectedGraph gResult = new DefaultDirectedGraph(ExprEdge.class);
                    Graphs.addAllEdges((Graph)gResult, (Graph)g, (Collection)edgeSet);
                    return GraphExpr.newInstance(gResult);
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("FindSpanningTree.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class FindShortestTour
    extends AbstractEvaluator {
        private FindShortestTour() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    IAST list;
                    if (ast.arg1().isListOfLists()) {
                        IAST m;
                        double[][] matrix;
                        int[] dim = ast.arg1().isMatrix();
                        if (dim != null && (matrix = (m = (IAST)ast.arg1()).toDoubleMatrix()) != null) {
                            int rowDim = dim[0];
                            int colDim = dim[1];
                            if (colDim == 2) {
                                int i;
                                DefaultUndirectedWeightedGraph g = new DefaultUndirectedWeightedGraph(ExprWeightedEdge.class);
                                for (i = 1; i <= rowDim; ++i) {
                                    g.addVertex((Object)F.ZZ(i));
                                }
                                for (i = 0; i < rowDim; ++i) {
                                    for (int j = i + 1; j < rowDim; ++j) {
                                        g.setEdgeWeight((Object)((ExprWeightedEdge)((Object)g.addEdge((Object)F.ZZ(i + 1), (Object)F.ZZ(j + 1)))), MathArrays.distance((double[])matrix[i], (double[])matrix[j]));
                                    }
                                }
                                GraphPath tour = new HeldKarpTSP().getTour((Graph)g);
                                List tourPositions = tour.getVertexList();
                                IASTAppendable shortestTourList = F.ListAlloc(tourPositions.size());
                                IASTAppendable sum = F.PlusAlloc(tourPositions.size());
                                IInteger lastPosition = (IInteger)tourPositions.get(tourPositions.size() - 1);
                                shortestTourList.append(lastPosition);
                                for (int i2 = tourPositions.size() - 2; i2 >= 0; --i2) {
                                    IInteger position = (IInteger)tourPositions.get(i2);
                                    shortestTourList.append(position);
                                    sum.append(F.EuclideanDistance(m.get(lastPosition), m.get(position)));
                                    lastPosition = position;
                                }
                                return F.list(sum, shortestTourList);
                            }
                        }
                    } else if (ast.arg1().isList() && (list = (IAST)ast.arg1()).size() > 2 && list.forAll(x -> x instanceof GeoPositionExpr)) {
                        int rowDim = list.size() - 1;
                        DefaultUndirectedWeightedGraph g = new DefaultUndirectedWeightedGraph(ExprWeightedEdge.class);
                        for (int i = 1; i <= rowDim; ++i) {
                            g.addVertex((Object)F.ZZ(i));
                        }
                        GeodeticCalculator geoCalc = new GeodeticCalculator();
                        Ellipsoid reference = Ellipsoid.WGS84;
                        for (int i = 0; i < rowDim - 1; ++i) {
                            GlobalPosition p1 = (GlobalPosition)((GeoPositionExpr)list.get(i + 1)).toData();
                            for (int j = i + 1; j < rowDim; ++j) {
                                GlobalPosition p2 = (GlobalPosition)((GeoPositionExpr)list.get(j + 1)).toData();
                                GeodeticMeasurement gm = geoCalc.calculateGeodeticMeasurement(reference, p1, p2);
                                g.setEdgeWeight((Object)((ExprWeightedEdge)((Object)g.addEdge((Object)F.ZZ(i + 1), (Object)F.ZZ(j + 1)))), gm.getPointToPointDistance());
                            }
                        }
                        GraphPath tour = new HeldKarpTSP().getTour((Graph)g);
                        List tourPositions = tour.getVertexList();
                        IASTAppendable shortestTourList = F.ListAlloc(tourPositions.size());
                        IASTAppendable sum = F.PlusAlloc(tourPositions.size());
                        IInteger lastPosition = (IInteger)tourPositions.get(tourPositions.size() - 1);
                        shortestTourList.append(lastPosition);
                        for (int i = tourPositions.size() - 2; i >= 0; --i) {
                            IInteger position = (IInteger)tourPositions.get(i);
                            shortestTourList.append(position);
                            sum.append(F.GeoDistance(list.get(lastPosition), list.get(position)));
                            lastPosition = position;
                        }
                        return F.list(sum, shortestTourList);
                    }
                }
            }
            catch (RuntimeException rex) {
                LOGGER.error("FindShortestTour..evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }
    }

    private static class GraphUnion
    extends AbstractEvaluator {
        private GraphUnion() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_INFINITY;
        }
    }

    private static class GraphRadius
    extends AbstractEvaluator {
        private GraphRadius() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                if (gex == null) {
                    return F.NIL;
                }
                Graph g = (Graph)gex.toData();
                GraphMeasurer graphMeasurer = new GraphMeasurer(g);
                INum radius = F.num(graphMeasurer.getRadius());
                if (gex.isWeightedGraph()) {
                    return radius;
                }
                int intRadius = radius.toIntDefault();
                if (intRadius != Integer.MIN_VALUE) {
                    return F.ZZ(intRadius);
                }
                return radius;
            }
            catch (RuntimeException rex) {
                LOGGER.debug("GraphRadius.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class GraphQ
    extends AbstractEvaluator {
        private GraphQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                GraphExpr<?> gex;
                if (ast.isAST1() && (gex = GraphFunctions.createGraph(ast.arg1())) != null) {
                    return S.True;
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("GraphQ.evaluate() failed", (Throwable)rex);
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class GraphPeriphery
    extends AbstractEvaluator {
        private GraphPeriphery() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                if (gex == null) {
                    return F.NIL;
                }
                Graph g = (Graph)gex.toData();
                GraphMeasurer graphMeasurer = new GraphMeasurer(g);
                Set centerSet = graphMeasurer.getGraphPeriphery();
                return F.ListAlloc(centerSet);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("GraphPeriphery.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class GraphDiameter
    extends AbstractEvaluator {
        private GraphDiameter() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                if (gex == null) {
                    return F.NIL;
                }
                Graph g = (Graph)gex.toData();
                GraphMeasurer graphMeasurer = new GraphMeasurer(g);
                INum diameter = F.num(graphMeasurer.getDiameter());
                if (gex.isWeightedGraph()) {
                    return diameter;
                }
                int intDiameter = diameter.toIntDefault();
                if (intDiameter != Integer.MIN_VALUE) {
                    return F.ZZ(intDiameter);
                }
                return diameter;
            }
            catch (RuntimeException rex) {
                LOGGER.debug("GraphDiameter.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class GraphCenter
    extends AbstractEvaluator {
        private GraphCenter() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                if (gex == null) {
                    return F.NIL;
                }
                Graph g = (Graph)gex.toData();
                GraphMeasurer graphMeasurer = new GraphMeasurer(g);
                Set centerSet = graphMeasurer.getGraphCenter();
                IASTMutable list = F.ListAlloc(centerSet);
                return list;
            }
            catch (RuntimeException rex) {
                LOGGER.debug("GraphCenter.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class GraphCTor
    extends AbstractEvaluator {
        private GraphCTor() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1()) {
                    GraphExpr<?> gex = GraphFunctions.createGraph(ast.arg1());
                    if (gex != null) {
                        return gex;
                    }
                } else if (ast.size() >= 3 && ast.arg1().isList()) {
                    GraphExpr<ExprEdge> g;
                    GraphType t;
                    IExpr edgeWeight = F.NIL;
                    OptionArgs options = new OptionArgs(S.Graph, ast, ast.argSize(), engine);
                    IExpr option = options.getOption(S.EdgeWeight);
                    if (option.isPresent() && !option.equals(S.Automatic)) {
                        edgeWeight = option;
                    }
                    if ((t = ast.arg1().isListOfEdges()) != null) {
                        if (edgeWeight.isList()) {
                            GraphExpr<ExprWeightedEdge> gex = GraphFunctions.createWeightedGraph(F.NIL, (IAST)ast.arg1(), (IAST)edgeWeight);
                            if (gex != null) {
                                return gex;
                            }
                        } else {
                            GraphExpr<ExprEdge> g2 = GraphFunctions.createGraph(F.NIL, (IAST)ast.arg1());
                            if (g2 != null) {
                                return g2;
                            }
                        }
                    } else if (edgeWeight.isList()) {
                        GraphExpr<ExprWeightedEdge> gex = GraphFunctions.createWeightedGraph((IAST)ast.arg1(), (IAST)ast.arg2(), (IAST)edgeWeight);
                        if (gex != null) {
                            return gex;
                        }
                    } else if (ast.arg2().isList() && (g = GraphFunctions.createGraph((IAST)ast.arg1(), (IAST)ast.arg2())) != null) {
                        return g;
                    }
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("GraphCTor.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.EdgeWeight, (IExpr)S.Automatic)));
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.BetweennessCentrality.setEvaluator(new BetweennessCentrality());
            S.ClosenessCentrality.setEvaluator(new ClosenessCentrality());
            S.Graph.setEvaluator(new GraphCTor());
            S.GraphCenter.setEvaluator(new GraphCenter());
            S.GraphDiameter.setEvaluator(new GraphDiameter());
            S.GraphPeriphery.setEvaluator(new GraphPeriphery());
            S.GraphRadius.setEvaluator(new GraphRadius());
            S.GraphUnion.setEvaluator(new GraphUnion());
            S.AdjacencyMatrix.setEvaluator(new AdjacencyMatrix());
            S.EdgeList.setEvaluator(new EdgeList());
            S.EdgeQ.setEvaluator(new EdgeQ());
            S.EdgeRules.setEvaluator(new EdgeRules());
            S.EulerianGraphQ.setEvaluator(new EulerianGraphQ());
            S.FindEulerianCycle.setEvaluator(new FindEulerianCycle());
            S.FindHamiltonianCycle.setEvaluator(new FindHamiltonianCycle());
            S.FindGraphIsomorphism.setEvaluator(new FindGraphIsomorphism());
            S.FindVertexCover.setEvaluator(new FindVertexCover());
            S.FindShortestPath.setEvaluator(new FindShortestPath());
            S.FindShortestTour.setEvaluator(new FindShortestTour());
            S.FindSpanningTree.setEvaluator(new FindSpanningTree());
            S.GraphQ.setEvaluator(new GraphQ());
            S.HamiltonianGraphQ.setEvaluator(new HamiltonianGraphQ());
            S.IsomorphicGraphQ.setEvaluator(new IsomorphicGraphQ());
            S.LineGraph.setEvaluator(new LineGraph());
            S.PlanarGraphQ.setEvaluator(new PlanarGraphQ());
            S.VertexEccentricity.setEvaluator(new VertexEccentricity());
            S.VertexList.setEvaluator(new VertexList());
            S.VertexQ.setEvaluator(new VertexQ());
            S.WeightedAdjacencyMatrix.setEvaluator(new WeightedAdjacencyMatrix());
            S.WeightedGraphQ.setEvaluator(new WeightedGraphQ());
        }
    }
}

