/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jgrapht.Graph;
import org.jgrapht.generate.CompleteGraphGenerator;
import org.jgrapht.generate.GeneralizedPetersenGraphGenerator;
import org.jgrapht.generate.GnmRandomGraphGenerator;
import org.jgrapht.generate.HyperCubeGraphGenerator;
import org.jgrapht.generate.RingGraphGenerator;
import org.jgrapht.generate.StarGraphGenerator;
import org.jgrapht.generate.WheelGraphGenerator;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.ExprEdge;
import org.matheclipse.core.expression.data.GraphExpr;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.trie.TrieBuilder;
import org.matheclipse.parser.trie.TrieMatch;

public class GraphDataFunctions {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final TrieBuilder<String, Supplier<Graph>, ArrayList<Supplier<Graph>>> TRIE_STRING2GRAPH_BUILDER = TrieBuilder.create();
    private static Map<String, Supplier<Graph>> GRAPH_MAP = TRIE_STRING2GRAPH_BUILDER.withMatch(TrieMatch.EXACT).build();

    public static void initialize() {
        Initializer.init();
    }

    private static Graph<IExpr, ExprEdge> pappusGraph() {
        int[][] edges;
        Graph g = GraphTypeBuilder.undirected().allowingMultipleEdges(false).allowingSelfLoops(false).vertexSupplier((Supplier)new IntegerSupplier(1)).edgeClass(ExprEdge.class).buildGraph();
        HashMap<IExpr, IExpr> vertexMap = new HashMap<IExpr, IExpr>();
        for (int[] edge : edges = new int[][]{{0, 1}, {0, 5}, {0, 6}, {1, 2}, {1, 7}, {2, 3}, {2, 8}, {3, 4}, {3, 9}, {4, 5}, {4, 10}, {5, 11}, {6, 13}, {6, 17}, {7, 12}, {7, 14}, {8, 13}, {8, 15}, {9, 14}, {9, 16}, {10, 15}, {10, 17}, {11, 12}, {11, 16}, {12, 15}, {13, 16}, {14, 17}}) {
            GraphDataFunctions.addEdge(vertexMap, (Graph<IExpr, ExprEdge>)g, edge[0], edge[1]);
        }
        return g;
    }

    private static IExpr addVertex(HashMap<IExpr, IExpr> vertexMap, Graph<IExpr, ExprEdge> targetGraph, int i) {
        IInteger intNumber = F.ZZ(i);
        if (!vertexMap.containsKey(intNumber)) {
            vertexMap.put(intNumber, (IExpr)targetGraph.addVertex());
        }
        return vertexMap.get(intNumber);
    }

    private static void addEdge(HashMap<IExpr, IExpr> vertexMap, Graph<IExpr, ExprEdge> targetGraph, int i, int j) {
        IExpr u = GraphDataFunctions.addVertex(vertexMap, targetGraph, i);
        IExpr v = GraphDataFunctions.addVertex(vertexMap, targetGraph, j);
        targetGraph.addEdge((Object)u, (Object)v);
    }

    private static void addCycle(HashMap<IExpr, IExpr> vertexMap, Graph<IExpr, ExprEdge> targetGraph, int[] array) {
        for (int i = 0; i < array.length; ++i) {
            GraphDataFunctions.addEdge(vertexMap, targetGraph, array[i], array[(i + 1) % array.length]);
        }
    }

    private GraphDataFunctions() {
    }

    private static class WheelGraph
    extends AbstractEvaluator {
        private WheelGraph() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int order = ast.arg1().toIntDefault();
            if (order <= 0) {
                return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast, F.C1), engine);
            }
            if (order > Config.MAX_GRAPH_VERTICES_SIZE) {
                ASTElementLimitExceeded.throwIt(order);
            }
            try {
                WheelGraphGenerator gen = new WheelGraphGenerator(order);
                Graph target = GraphTypeBuilder.undirected().allowingMultipleEdges(false).allowingSelfLoops(false).vertexSupplier((Supplier)new IntegerSupplier(1)).edgeClass(ExprEdge.class).buildGraph();
                gen.generateGraph(target);
                return GraphExpr.newInstance(target);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("WheelGraph.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class StarGraph
    extends AbstractEvaluator {
        private StarGraph() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int order = ast.arg1().toIntDefault();
            if (order <= 0) {
                return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast, F.C1), engine);
            }
            if (order > Config.MAX_GRAPH_VERTICES_SIZE) {
                ASTElementLimitExceeded.throwIt(order);
            }
            try {
                StarGraphGenerator gen = new StarGraphGenerator(order);
                Graph target = GraphTypeBuilder.undirected().allowingMultipleEdges(false).allowingSelfLoops(false).vertexSupplier((Supplier)new IntegerSupplier(1)).edgeClass(ExprEdge.class).buildGraph();
                gen.generateGraph(target);
                return GraphExpr.newInstance(target);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("StarGraph.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class RandomGraph
    extends AbstractEvaluator {
        private RandomGraph() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList2()) {
                int edges;
                int vertices = ast.arg1().first().toIntDefault();
                if (vertices <= 0) {
                    return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast.arg1(), F.C1), engine);
                }
                if (vertices > Config.MAX_GRAPH_VERTICES_SIZE) {
                    ASTElementLimitExceeded.throwIt(vertices);
                }
                if ((edges = ast.arg1().second().toIntDefault()) <= 0) {
                    return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast.arg1(), F.C2), engine);
                }
                if (edges > Config.MAX_AST_SIZE) {
                    ASTElementLimitExceeded.throwIt(edges);
                }
                try {
                    if (ast.isAST2()) {
                        int k = ast.arg2().toIntDefault();
                        if (k <= 0) {
                            return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast, F.C2), engine);
                        }
                        if (k > Config.MAX_AST_SIZE) {
                            ASTElementLimitExceeded.throwIt(k);
                        }
                        IASTAppendable result = F.ListAlloc(k);
                        for (int i = 0; i < k; ++i) {
                            result.append(this.randomGraph(vertices, edges));
                        }
                        return result;
                    }
                    return this.randomGraph(vertices, edges);
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("RandomGraph.evaluate() failed", (Throwable)rex);
                }
            }
            return F.NIL;
        }

        private IExpr randomGraph(int vertices, int edges) {
            GnmRandomGraphGenerator gen = new GnmRandomGraphGenerator(vertices, edges);
            Graph target = GraphTypeBuilder.undirected().allowingMultipleEdges(false).allowingSelfLoops(false).vertexSupplier((Supplier)new IntegerSupplier(1)).edgeClass(ExprEdge.class).buildGraph();
            gen.generateGraph(target);
            return GraphExpr.newInstance(target);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class PetersenGraph
    extends AbstractEvaluator {
        private PetersenGraph() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                return IOFunctions.printMessage(ast.topHead(), "inv", F.list(ast, ast.arg1()), engine);
            }
            if (ast.isAST0()) {
                Graph target = GraphTypeBuilder.undirected().allowingMultipleEdges(false).allowingSelfLoops(false).vertexSupplier((Supplier)new IntegerSupplier(1)).edgeClass(ExprEdge.class).buildGraph();
                GeneralizedPetersenGraphGenerator gpgg = new GeneralizedPetersenGraphGenerator(5, 2);
                gpgg.generateGraph(target);
                return GraphExpr.newInstance(target);
            }
            if (ast.isAST2()) {
                int k;
                int order = ast.arg1().toIntDefault();
                if (order <= 0) {
                    return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast, F.C1), engine);
                }
                if (order > Config.MAX_AST_SIZE / 2) {
                    ASTElementLimitExceeded.throwIt(order);
                }
                if ((k = ast.arg2().toIntDefault()) <= 0 || k > order) {
                    return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast, F.C2), engine);
                }
                try {
                    Graph target = GraphTypeBuilder.undirected().allowingMultipleEdges(false).allowingSelfLoops(false).vertexSupplier((Supplier)new IntegerSupplier(1)).edgeClass(ExprEdge.class).buildGraph();
                    GeneralizedPetersenGraphGenerator gpgg = new GeneralizedPetersenGraphGenerator(order, k);
                    gpgg.generateGraph(target);
                    return GraphExpr.newInstance(target);
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("PetersenGraph.evaluate() failed", (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }
    }

    private static class HypercubeGraph
    extends AbstractEvaluator {
        private HypercubeGraph() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int order = ast.arg1().toIntDefault();
            if (order <= 0) {
                return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast, F.C1), engine);
            }
            if (order > Config.MAX_GRAPH_VERTICES_SIZE / 10) {
                ASTElementLimitExceeded.throwIt(order);
            }
            try {
                HyperCubeGraphGenerator gen = new HyperCubeGraphGenerator(order);
                Graph target = GraphTypeBuilder.undirected().allowingMultipleEdges(false).allowingSelfLoops(false).vertexSupplier((Supplier)new IntegerSupplier(1)).edgeClass(ExprEdge.class).buildGraph();
                gen.generateGraph(target);
                return GraphExpr.newInstance(target);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("HypercubeGraph.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class CycleGraph
    extends AbstractEvaluator {
        private CycleGraph() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int order = ast.arg1().toIntDefault();
            if (order <= 0) {
                return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast, F.C1), engine);
            }
            if (order > Config.MAX_GRAPH_VERTICES_SIZE) {
                ASTElementLimitExceeded.throwIt(order);
            }
            try {
                RingGraphGenerator gen = new RingGraphGenerator(order);
                Graph target = GraphTypeBuilder.undirected().allowingMultipleEdges(false).allowingSelfLoops(false).vertexSupplier((Supplier)new IntegerSupplier(1)).edgeClass(ExprEdge.class).buildGraph();
                gen.generateGraph(target);
                return GraphExpr.newInstance(target);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("CycleGraph.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class CompleteGraph
    extends AbstractEvaluator {
        private CompleteGraph() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int order = ast.arg1().toIntDefault();
            if (order <= 0) {
                return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast, F.C1), engine);
            }
            if (order > Config.MAX_GRAPH_VERTICES_SIZE) {
                ASTElementLimitExceeded.throwIt(order);
            }
            try {
                CompleteGraphGenerator gen = new CompleteGraphGenerator(order);
                Graph target = GraphTypeBuilder.undirected().allowingMultipleEdges(false).allowingSelfLoops(false).vertexSupplier((Supplier)new IntegerSupplier(1)).edgeClass(ExprEdge.class).buildGraph();
                gen.generateGraph(target);
                return GraphExpr.newInstance(target);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("CompleteGraph.evaluate() failed", (Throwable)rex);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class GraphData
    extends AbstractEvaluator {
        private GraphData() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST1() && ast.arg1().isString()) {
                    String graphName = ((IStringX)ast.arg1()).toString();
                    Supplier<Graph> supplier = GRAPH_MAP.get(graphName);
                    if (supplier != null) {
                        Graph g = supplier.get();
                        return GraphExpr.newInstance(g);
                    }
                    LOGGER.log(engine.getLogLevel(), "GraphData: no value associated with the specified graph name: {}", (Object)graphName);
                }
            }
            catch (RuntimeException rex) {
                LOGGER.debug("GraphData.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.EdgeWeight, (IExpr)S.Automatic)));
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class IntegerSupplier
    implements Supplier<IExpr>,
    Serializable {
        private static final long serialVersionUID = -4714266728630636497L;
        private int i = 0;

        public IntegerSupplier(int start) {
            this.i = start;
        }

        @Override
        public IExpr get() {
            return F.ZZ(this.i++);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            GRAPH_MAP.put("PappusGraph", () -> GraphDataFunctions.pappusGraph());
            S.GraphData.setEvaluator(new GraphData());
            S.CompleteGraph.setEvaluator(new CompleteGraph());
            S.CycleGraph.setEvaluator(new CycleGraph());
            S.HypercubeGraph.setEvaluator(new HypercubeGraph());
            S.PetersenGraph.setEvaluator(new PetersenGraph());
            S.RandomGraph.setEvaluator(new RandomGraph());
            S.StarGraph.setEvaluator(new StarGraph());
            S.WheelGraph.setEvaluator(new WheelGraph());
        }
    }
}

