/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class FinancialFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void initialize() {
        Initializer.init();
    }

    private FinancialFunctions() {
    }

    private static class TimeValue
    extends AbstractEvaluator {
        private TimeValue() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr a = ast.arg1();
            IExpr b = ast.arg2();
            IExpr c = ast.arg3();
            if (a.isAST((IExpr)S.Annuity, 3, 4)) {
                IAST annuity = (IAST)a;
                try {
                    IExpr q = F.C1;
                    if (annuity.size() == 4) {
                        q = annuity.arg3();
                    }
                    IExpr p = annuity.arg1();
                    IExpr t = annuity.arg2();
                    if (c.isZero()) {
                        return F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Subtract(F.C1, F.Power((IExpr)F.Plus((IExpr)F.C1, b), q)), F.CN1), (IExpr)F.Plus(p, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Power((IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, b), q), F.Times((IExpr)F.Power(q, F.CN1), t)), F.CN1), p)));
                    }
                    return F.Times(F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, b), q)), F.CN1), F.Power((IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, b), q), F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power(q, F.CN1), t), (IExpr)F.Times(c, (IExpr)F.Power(q, F.CN1)))), F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, b), q), F.Times((IExpr)F.Power(q, F.CN1), t))), p);
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("TimeValue.evaluate() failed", (Throwable)rex);
                    return F.NIL;
                }
            }
            if (a.isAST((IExpr)S.AnnuityDue, 3, 4)) {
                IAST annuity = (IAST)a;
                try {
                    IExpr q = F.C1;
                    if (annuity.size() == 4) {
                        q = annuity.arg3();
                    }
                    IExpr p = annuity.arg1();
                    IExpr t = annuity.arg2();
                    if (c.isZero()) {
                        return F.Times(F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, b), q)), F.CN1), F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, b), q), F.Times((IExpr)F.Power(q, F.CN1), t))), F.Power((IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, b), q), F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power(q, F.CN1), t))), p);
                    }
                    return F.Times(F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, b), q)), F.CN1), F.Power((IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, b), q), F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power(q, F.CN1), t), (IExpr)F.Times(c, (IExpr)F.Power(q, F.CN1)))), F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, b), q), F.Times((IExpr)F.Power(q, F.CN1), t))), p);
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("TimeValue.evaluate() failed", (Throwable)rex);
                    return F.NIL;
                }
            }
            if (!(a.isAST() || b.isAST() || c.isAST())) {
                return F.Times(a, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, b), c));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }
    }

    private static class EffectiveInterest
    extends AbstractEvaluator {
        private EffectiveInterest() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr a = ast.arg1();
            if (ast.size() == 2) {
                IExpr normal;
                int dim = a.isVector();
                if (dim >= 0 && (normal = a.normal(false)).isList()) {
                    IAST l = ((IAST)normal).map(x -> x.inc(), 1);
                    return F.Plus((IExpr)F.CN1, (IExpr)F.GeometricMean(l));
                }
                return F.NIL;
            }
            if (ast.size() == 3) {
                IExpr b = ast.arg2();
                int length = a.isVector();
                if (length >= 0) {
                    IExpr normal = a.normal(false);
                    if (normal.isList()) {
                        return ((IAST)normal).map(x -> this.effectiveInterestFormula((IExpr)x, b));
                    }
                    return F.NIL;
                }
                int[] dim = a.isMatrix(false);
                if (dim != null) {
                    if (dim[1] == 2) {
                        IExpr iExpr = a.normal(false);
                    }
                    return F.NIL;
                }
                if (!a.isList()) {
                    return this.effectiveInterestFormula(a, b);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private IExpr effectiveInterestFormula(IExpr a, IExpr b) {
            if (b.isZero()) {
                return F.Plus((IExpr)F.CN1, (IExpr)F.Exp(a));
            }
            return F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times(a, b)), F.Power(b, F.CN1)));
        }
    }

    private static class AnnuityDue
    extends AbstractEvaluator {
        private AnnuityDue() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }
    }

    private static class Annuity
    extends AbstractEvaluator {
        private Annuity() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.EffectiveInterest.setEvaluator(new EffectiveInterest());
            S.TimeValue.setEvaluator(new TimeValue());
            S.Annuity.setEvaluator(new Annuity());
            S.AnnuityDue.setEvaluator(new AnnuityDue());
        }
    }
}

