/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import com.google.common.io.CharStreams;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.StringFunctions;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.Context;
import org.matheclipse.core.expression.ContextPath;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.FileExpr;
import org.matheclipse.core.expression.data.InputStreamExpr;
import org.matheclipse.core.expression.data.NumericArrayExpr;
import org.matheclipse.core.expression.data.OutputStreamExpr;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.parser.ExprParser;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FunctionNode;

public class FileFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IExpr evaluatePackage(List<ASTNode> node, EvalEngine engine) {
        AST2Expr ast2Expr = new AST2Expr(engine.isRelaxedSyntax(), engine);
        String compoundExpression = engine.isRelaxedSyntax() ? "compoundexpression" : "CompoundExpression";
        return FileFunctions.evaluatePackageRecursive(node, 0, compoundExpression, ast2Expr, engine);
    }

    private static IExpr evaluatePackageRecursive(List<ASTNode> node, int i, String compoundExpression, AST2Expr ast2Expr, EvalEngine engine) {
        IExpr result = S.Null;
        while (i < node.size()) {
            ASTNode astNode = node.get(i);
            if (astNode instanceof FunctionNode && ((FunctionNode)astNode).get(0).getString().equals(compoundExpression)) {
                result = FileFunctions.evaluatePackageRecursive((List<ASTNode>)((FunctionNode)astNode), 1, compoundExpression, ast2Expr, engine);
            } else {
                IExpr temp = ast2Expr.convert(astNode);
                result = engine.evaluate(temp);
            }
            ++i;
        }
        return result;
    }

    public static List<ASTNode> parseReader(String reader, EvalEngine engine) {
        Parser parser = new Parser(engine.isRelaxedSyntax(), true);
        List node = parser.parsePackage(reader);
        return node;
    }

    public static List<ASTNode> parseReader(BufferedReader reader, EvalEngine engine) throws IOException {
        StringBuilder builder = new StringBuilder(2048);
        String record = reader.readLine();
        if (record != null && !record.startsWith("!#")) {
            builder.append(record);
            builder.append('\n');
        }
        while ((record = reader.readLine()) != null) {
            builder.append(record);
            builder.append('\n');
        }
        Parser parser = new Parser(engine.isRelaxedSyntax(), true);
        List node = parser.parsePackage(builder.toString());
        return node;
    }

    public static void initialize() {
        Initializer.init();
    }

    private FileFunctions() {
    }

    private static final class WriteString
    extends AbstractFunctionEvaluator {
        private WriteString() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                if (!ast.arg1().isString()) {
                    return IOFunctions.printMessage(ast.topHead(), "string", F.list(F.C1, ast), engine);
                }
                if (!ast.arg2().isString()) {
                    return IOFunctions.printMessage(ast.topHead(), "string", F.list(F.C2, ast), engine);
                }
                IStringX fileName = (IStringX)ast.arg1();
                IStringX str = (IStringX)ast.arg2();
                try (FileWriter writer = new FileWriter(fileName.toString());){
                    writer.write(str.toString());
                }
                catch (IOException e) {
                    LOGGER.log(engine.getLogLevel(), "{}: file {} I/O exception", (Object)ast.topHead(), (Object)fileName, (Object)e);
                    return F.NIL;
                }
                return S.Null;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class Write
    extends AbstractFunctionEvaluator {
        private Write() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                try {
                    IExpr arg1 = ast.arg1();
                    IExpr arg2 = ast.arg2();
                    Writer writer = null;
                    if (arg1 instanceof FileExpr) {
                        File file = (File)((FileExpr)arg1).toData();
                        OutputStreamExpr out = OutputStreamExpr.newInstance(file, false);
                        writer = out.getWriter();
                    }
                    if (arg1 instanceof OutputStreamExpr) {
                        writer = ((OutputStreamExpr)arg1).getWriter();
                    }
                    if (writer != null) {
                        String arg2String = StringFunctions.inputForm(arg2);
                        writer.write(arg2String);
                        writer.flush();
                        return S.Null;
                    }
                }
                catch (IOException | RuntimeException ex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class URLFetch
    extends AbstractFunctionEvaluator {
        private URLFetch() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!(ast.arg1() instanceof IStringX)) {
                return IOFunctions.printMessage(ast.topHead(), "string", F.List(), engine);
            }
            String arg1Str = ((IStringX)ast.arg1()).toString();
            if (arg1Str.startsWith("https://") || arg1Str.startsWith("http://")) {
                try {
                    URL url = new URL(arg1Str);
                    String str = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
                    return F.$s(str);
                }
                catch (IOException e) {
                    LOGGER.debug("URLFetch.evaluate() failed", (Throwable)e);
                    return IOFunctions.printMessage(ast.topHead(), "noopen", F.list(ast.arg1()), engine);
                }
            }
            return IOFunctions.printMessage(ast.topHead(), "noopen", F.list(ast.arg1()), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class StringToStream
    extends AbstractFunctionEvaluator {
        private StringToStream() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                try {
                    IExpr arg1;
                    if (ast.isAST1() && (arg1 = ast.arg1()).isString()) {
                        StringReader stringReader = new StringReader(arg1.toString());
                        return InputStreamExpr.newInstance(stringReader);
                    }
                }
                catch (IOException | RuntimeException ex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }
    }

    private static final class ReadString
    extends AbstractFunctionEvaluator {
        private ReadString() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                if (!(ast.arg1() instanceof IStringX)) {
                    return IOFunctions.printMessage(ast.topHead(), "string", F.List(), engine);
                }
                String arg1 = ((IStringX)ast.arg1()).toString();
                if (arg1.startsWith("https://") || arg1.startsWith("http://")) {
                    try {
                        URL url = new URL(arg1);
                        String str = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
                        return F.stringx(str);
                    }
                    catch (IOException ioe) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ioe);
                        return F.NIL;
                    }
                }
                File file = new File(arg1);
                if (file.exists()) {
                    try {
                        String str = com.google.common.io.Files.asCharSource((File)file, (Charset)Charset.defaultCharset()).read();
                        return F.stringx(str);
                    }
                    catch (IOException e) {
                        LOGGER.log(engine.getLogLevel(), "ReadString exception", (Throwable)e);
                        return S.Null;
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class Read
    extends AbstractFunctionEvaluator {
        private Read() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                try {
                    IExpr arg1 = ast.arg1();
                    Reader reader = null;
                    if (arg1 instanceof FileExpr) {
                        InputStreamExpr in = InputStreamExpr.getFromFile((FileExpr)arg1, "String", engine);
                        reader = in.getReader();
                    } else if (arg1 instanceof InputStreamExpr) {
                        reader = ((InputStreamExpr)arg1).getReader();
                    }
                    if (reader != null) {
                        if (ast.isAST1()) {
                            String str = CharStreams.toString((Readable)reader);
                            return S.ToExpression.of(engine, F.stringx(str));
                        }
                        IExpr typeExpr = ast.arg2();
                        if (typeExpr.isList()) {
                            IAST list = (IAST)ast.arg2();
                            IASTAppendable result = F.ListAlloc(list.size());
                            for (int i = 1; i < list.size(); ++i) {
                                IExpr argTypeExpr = list.get(i);
                                IExpr temp = this.readTypeOrHold(argTypeExpr, reader, engine);
                                if (temp == S.$Failed) {
                                    return S.$Failed;
                                }
                                result.append(temp);
                            }
                            return result;
                        }
                        return this.readTypeOrHold(typeExpr, reader, engine);
                    }
                }
                catch (IOException | RuntimeException ex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
                    return S.$Failed;
                }
            }
            return F.NIL;
        }

        private IExpr readTypeOrHold(IExpr arg, Reader reader, EvalEngine engine) throws IOException {
            if (arg.isAST(S.Hold, 2)) {
                IExpr holdArg = arg.first();
                if (!holdArg.isBuiltInSymbol()) {
                    return F.$Failed;
                }
                IExpr temp = this.readType((IBuiltInSymbol)holdArg, reader, engine);
                if (temp.isPresent()) {
                    return F.Hold(temp);
                }
            } else if (!arg.isBuiltInSymbol()) {
                return F.$Failed;
            }
            return this.readType((IBuiltInSymbol)arg, reader, engine);
        }

        private IExpr readType(IBuiltInSymbol arg2, Reader reader, EvalEngine engine) throws IOException {
            int headID = arg2.ordinal();
            int numberOfChar = -1;
            if (headID > 0) {
                switch (headID) {
                    case 186: {
                        return F.$Failed;
                    }
                    case 215: {
                        char[] temp = new char[1];
                        numberOfChar = reader.read(temp);
                        if (numberOfChar < 0) {
                            return S.EndOfFile;
                        }
                        return F.$str(temp[0]);
                    }
                    case 452: {
                        StringBuilder buf = new StringBuilder();
                        char[] tempExpr = new char[1];
                        numberOfChar = reader.read(tempExpr);
                        if (numberOfChar < 0) {
                            return S.EndOfFile;
                        }
                        buf.append(tempExpr[0]);
                        while ((numberOfChar = reader.read(tempExpr)) >= 0) {
                            buf.append(tempExpr[0]);
                            if (tempExpr[0] != '\n') continue;
                            try {
                                String str = buf.toString();
                                ExprParser parser = new ExprParser(engine);
                                return parser.parse(str);
                            }
                            catch (SyntaxError se) {
                            }
                        }
                        try {
                            String str = buf.toString();
                            ExprParser parser = new ExprParser(engine);
                            return parser.parse(str);
                        }
                        catch (SyntaxError str) {
                            return F.$Failed;
                        }
                    }
                    case 931: {
                        IAST numberSeparators = F.List(F.stringx("0"), F.stringx("1"), F.stringx("2"), F.stringx("3"), F.stringx("4"), F.stringx("5"), F.stringx("6"), F.stringx("7"), F.stringx("8"), F.stringx("9"));
                        String tempNumber = Read.numberReader(reader, numberSeparators);
                        if (tempNumber == null) {
                            return S.EndOfFile;
                        }
                        return F.$str(tempNumber);
                    }
                    case 1105: {
                        return F.$Failed;
                    }
                    case 1112: {
                        IExpr recordSeparators = engine.evaluate(S.RecordSeparators);
                        if (recordSeparators.isAST()) {
                            String tempRecord = Read.separatorReader(reader, (IAST)recordSeparators);
                            if (tempRecord == null) {
                                return S.$Failed;
                            }
                            return F.$str(tempRecord);
                        }
                        return F.$Failed;
                    }
                    case 1235: {
                        BufferedReader sReader = new BufferedReader(reader);
                        String tempStr = sReader.readLine();
                        if (tempStr == null) {
                            return S.EndOfFile;
                        }
                        return F.$str(tempStr + "\n");
                    }
                    case 1442: {
                        IExpr wordSeparators = engine.evaluate(S.WordSeparators);
                        if (wordSeparators.isAST()) {
                            String tempWord = Read.separatorReader(reader, (IAST)wordSeparators);
                            if (tempWord == null) {
                                return S.$Failed;
                            }
                            return F.$str(tempWord);
                        }
                        return F.$Failed;
                    }
                }
            }
            return F.$Failed;
        }

        private static String numberReader(Reader reader, IAST wordSeparators) throws IOException {
            try {
                StringBuilder word;
                block5: {
                    word = new StringBuilder();
                    char[] temp = new char[1];
                    reader.mark(256);
                    int numberOfChar = reader.read(temp);
                    if (numberOfChar < 0) {
                        return null;
                    }
                    int indx = wordSeparators.indexOf(F.stringx(temp[0]));
                    if (indx <= 0) {
                        reader.reset();
                        return word.toString();
                    }
                    word.append(temp[0]);
                    while (true) {
                        reader.mark(256);
                        numberOfChar = reader.read(temp);
                        if (numberOfChar < 0) break block5;
                        indx = wordSeparators.indexOf(F.stringx(temp[0]));
                        if (indx <= 0) break;
                        word.append(temp[0]);
                    }
                    reader.reset();
                    return word.toString();
                }
                return word.toString();
            }
            catch (IOException ioex) {
                reader.reset();
                return null;
            }
        }

        private static String separatorReader(Reader reader, IAST wordSeparators) throws IOException {
            reader.mark(256);
            try {
                int indx;
                int numberOfChar;
                char[] temp;
                StringBuilder word;
                block6: {
                    word = new StringBuilder();
                    temp = new char[1];
                    numberOfChar = reader.read(temp);
                    if (numberOfChar < 0) {
                        return null;
                    }
                    do {
                        if ((indx = wordSeparators.indexOf(F.stringx(temp[0]))) >= 0) continue;
                        word.append(temp[0]);
                        break block6;
                    } while ((numberOfChar = reader.read(temp)) >= 0);
                    return word.toString();
                }
                while ((numberOfChar = reader.read(temp)) >= 0) {
                    indx = wordSeparators.indexOf(F.stringx(temp[0]));
                    if (indx < 0) {
                        word.append(temp[0]);
                        continue;
                    }
                    return word.toString();
                }
                return word.toString();
            }
            catch (IOException ioex) {
                reader.reset();
                return null;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Put
    extends AbstractFunctionEvaluator {
        private Put() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                int argSize = ast.argSize();
                if (!(ast.last() instanceof IStringX)) {
                    return IOFunctions.printMessage(S.Put, "string", F.List(), engine);
                }
                IStringX fileName = (IStringX)ast.last();
                StringBuilder buf = new StringBuilder();
                for (int i = 1; i < argSize; ++i) {
                    IExpr temp = engine.evaluate(ast.get(i));
                    if (!OutputFormFactory.get().convert(buf, temp)) {
                        LOGGER.log(engine.getLogLevel(), "Put: file {} ERROR-IN_OUTPUTFORM", (Object)fileName);
                        return F.NIL;
                    }
                    buf.append('\n');
                    if (i >= argSize - 1) continue;
                    buf.append('\n');
                }
                try (FileWriter writer = new FileWriter(fileName.toString());){
                    writer.write(buf.toString());
                }
                catch (IOException e) {
                    LOGGER.log(engine.getLogLevel(), "Put: file {} I/O exception !", (Object)fileName, (Object)e);
                    return F.NIL;
                }
                return S.Null;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_INFINITY;
        }
    }

    private static final class Needs
    extends Get {
        private Needs() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            String contextName = Validate.checkContextName(ast, 1);
            if (!ContextPath.PACKAGES.contains(contextName)) {
                return super.evaluate(ast, engine);
            }
            return S.Null;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class OutputStream
    extends AbstractFunctionEvaluator {
        private OutputStream() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                try {
                    IExpr arg1 = ast.arg1();
                    if (arg1.isString()) {
                        return OutputStreamExpr.newInstance(arg1.toString(), false);
                    }
                }
                catch (IOException | RuntimeException ex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class OpenWrite
    extends AbstractFunctionEvaluator {
        private OpenWrite() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return this.openOutputStream(ast, false, engine);
        }

        protected IExpr openOutputStream(IAST ast, boolean append, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                try {
                    IExpr arg1;
                    if (ast.isAST0()) {
                        return OutputStreamExpr.newInstance();
                    }
                    if (ast.isAST1() && (arg1 = ast.arg1()).isString()) {
                        return OutputStreamExpr.newInstance(arg1.toString(), append);
                    }
                }
                catch (IOException | RuntimeException ex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }
    }

    private static final class OpenRead
    extends AbstractFunctionEvaluator {
        private OpenRead() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(EvalEngine.get())) {
                try {
                    IExpr arg1;
                    if (ast.isAST1() && (arg1 = ast.arg1()).isString()) {
                        return InputStreamExpr.newInstance(arg1.toString(), "String");
                    }
                }
                catch (FileNotFoundException | RuntimeException ex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }
    }

    private static final class OpenAppend
    extends OpenWrite {
        private OpenAppend() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return this.openOutputStream(ast, true, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }
    }

    private static final class InputStream
    extends AbstractFunctionEvaluator {
        private InputStream() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                try {
                    IExpr arg1 = ast.arg1();
                    if (arg1.isString()) {
                        return InputStreamExpr.newInstance(arg1.toString(), "String");
                    }
                }
                catch (FileNotFoundException | RuntimeException ex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    public static class Get
    extends AbstractFunctionEvaluator {
        protected static IExpr loadPackage(EvalEngine engine, String is) {
            try {
                List<ASTNode> node = FileFunctions.parseReader(is, engine);
                return FileFunctions.evaluatePackage(node, engine);
            }
            catch (Exception e) {
                LOGGER.error("Get.loadPackage() failed", (Throwable)e);
                return S.Null;
            }
        }

        public static IExpr loadPackage(EvalEngine engine, File file) throws FileNotFoundException {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            return Get.loadPackage(engine, reader);
        }

        protected static IExpr loadPackage(EvalEngine engine, BufferedReader is) {
            IExpr iExpr;
            block8: {
                BufferedReader r = is;
                try {
                    List<ASTNode> node = FileFunctions.parseReader(r, engine);
                    iExpr = FileFunctions.evaluatePackage(node, engine);
                    if (r == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error("FileFunctions.Get.loadPackage", (Throwable)e);
                        return S.Null;
                    }
                }
                r.close();
            }
            return iExpr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static IExpr getFile(File file, IAST ast, String arg1Str, EvalEngine engine) {
            boolean packageMode = engine.isPackageMode();
            String input = engine.get$Input();
            String inputFileName = engine.get$InputFileName();
            try {
                engine.setPackageMode(true);
                engine.set$Input(arg1Str);
                engine.set$InputFileName(file.getAbsolutePath());
                String str = com.google.common.io.Files.asCharSource((File)file, (Charset)Charset.defaultCharset()).read();
                IExpr iExpr = Get.loadPackage(engine, str);
                return iExpr;
            }
            catch (IOException e) {
                LOGGER.debug("Get.getFile() failed", (Throwable)e);
                IAST iAST = IOFunctions.printMessage(ast.topHead(), "noopen", F.list(ast.arg1()), engine);
                return iAST;
            }
            finally {
                engine.setPackageMode(packageMode);
                engine.set$Input(input);
                engine.set$InputFileName(inputFileName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static IExpr getURL(URL url, IAST ast, String arg1Str, EvalEngine engine) {
            boolean packageMode = engine.isPackageMode();
            String input = engine.get$Input();
            String inputFileName = engine.get$InputFileName();
            try {
                engine.setPackageMode(true);
                engine.set$Input(arg1Str);
                engine.set$InputFileName(url.getPath());
                String str = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
                IExpr iExpr = Get.loadPackage(engine, str);
                return iExpr;
            }
            catch (IOException e) {
                LOGGER.debug("FileFunctions.Get.getURL() failed", (Throwable)e);
                IAST iAST = IOFunctions.printMessage(ast.topHead(), "noopen", F.list(ast.arg1()), engine);
                return iAST;
            }
            finally {
                engine.setPackageMode(packageMode);
                engine.set$Input(input);
                engine.set$InputFileName(inputFileName);
            }
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                try {
                    if (!(ast.arg1() instanceof IStringX)) {
                        return IOFunctions.printMessage(ast.topHead(), "string", F.List(), engine);
                    }
                    String arg1Str = ((IStringX)ast.arg1()).toString();
                    if (arg1Str.startsWith("https://") || arg1Str.startsWith("http://")) {
                        URL url = new URL(arg1Str);
                        return Get.getURL(url, ast, arg1Str, engine);
                    }
                    File file = new File(arg1Str);
                    if (file.exists()) {
                        return Get.getFile(file, ast, arg1Str, engine);
                    }
                    file = FileSystems.getDefault().getPath(arg1Str, new String[0]).toAbsolutePath().toFile();
                    if (file.exists()) {
                        return Get.getFile(file, ast, arg1Str, engine);
                    }
                    Validate.checkContextName(ast, 1);
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (MalformedURLException e) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)e);
                    return F.NIL;
                }
                return IOFunctions.printMessage(ast.topHead(), "noopen", F.list(ast.arg1()), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class FilePrint
    extends AbstractFunctionEvaluator {
        private FilePrint() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!Config.isFileSystemEnabled(engine)) return F.NIL;
            IExpr arg1 = ast.arg1();
            if (!arg1.isString()) return F.NIL;
            try (BufferedReader br = new BufferedReader(new FileReader(arg1.toString()));){
                PrintStream stream = engine.getOutPrintStream();
                int numberOfLines = Integer.MAX_VALUE;
                if (ast.isAST2() && (numberOfLines = ast.arg2().toIntDefault()) == Integer.MIN_VALUE) {
                    IAssociation iAssociation = F.NIL;
                    return iAssociation;
                }
                if (numberOfLines < 0) {
                    String line;
                    numberOfLines = -numberOfLines;
                    String[] lastLines = new String[numberOfLines];
                    int i = 0;
                    while ((line = br.readLine()) != null && i < numberOfLines) {
                        lastLines[i++] = line;
                    }
                    while ((line = br.readLine()) != null) {
                        System.arraycopy(lastLines, 1, lastLines, 0, numberOfLines - 1);
                        lastLines[numberOfLines - 1] = line;
                    }
                    i = 0;
                    while (i < lastLines.length && lastLines[i] != null) {
                        stream.println(lastLines[i++]);
                    }
                } else {
                    String line;
                    while ((line = br.readLine()) != null && numberOfLines-- > 0) {
                        stream.println(line);
                    }
                }
                IBuiltInSymbol iBuiltInSymbol = S.Null;
                return iBuiltInSymbol;
            }
            catch (IOException | RuntimeException ex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class FileEvaluator
    extends AbstractFunctionEvaluator {
        private FileEvaluator() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                try {
                    IExpr arg1 = ast.arg1();
                    if (arg1.isString()) {
                        return FileExpr.newInstance(arg1.toString());
                    }
                }
                catch (RuntimeException ex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class EndPackage
    extends AbstractCoreFunctionEvaluator {
        private EndPackage() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            engine.endPackage();
            return S.Null;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class End
    extends AbstractCoreFunctionEvaluator {
        private End() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            Context context = engine.end();
            if (context == null) {
                return F.NIL;
            }
            return F.stringx(context.completeContextName());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_0;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class CreateFile
    extends AbstractEvaluator {
        private CreateFile() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!Config.isFileSystemEnabled(engine)) return F.NIL;
            try {
                if (ast.isAST0()) {
                    Path tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
                    return F.stringx(tempFile.toString());
                }
                if (ast.isAST1() && !(ast.arg1() instanceof IStringX)) return F.NIL;
            }
            catch (IOException | RuntimeException ex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class CreateDirectory
    extends AbstractEvaluator {
        private CreateDirectory() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                try {
                    if (ast.isAST0()) {
                        Path tempDir = Files.createTempDirectory("", new FileAttribute[0]);
                        return F.stringx(tempDir.toString());
                    }
                    if (ast.isAST1() && ast.arg1() instanceof IStringX) {
                        Path path = Paths.get(ast.arg1().toString(), new String[0]);
                        if (!Files.exists(path, new LinkOption[0])) {
                            Files.createDirectory(path, new FileAttribute[0]);
                        }
                        return F.stringx(path.toString());
                    }
                }
                catch (IOException | RuntimeException ex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }
    }

    private static final class Close
    extends AbstractFunctionEvaluator {
        private Close() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IExpr arg1 = ast.arg1();
                if (arg1 instanceof OutputStreamExpr) {
                    OutputStreamExpr out = (OutputStreamExpr)arg1;
                    out.close();
                    return F.stringx(out.getStreamName());
                }
                if (arg1 instanceof InputStreamExpr) {
                    InputStreamExpr in = (InputStreamExpr)arg1;
                    in.close();
                    return F.stringx(in.getStreamName());
                }
            }
            catch (IOException | RuntimeException ex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class BinaryWrite
    extends AbstractFunctionEvaluator {
        private BinaryWrite() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                try {
                    IExpr arg1 = ast.arg1();
                    DataOutput dataOutput = null;
                    if (arg1 instanceof FileExpr) {
                        File file = (File)((FileExpr)arg1).toData();
                        OutputStreamExpr out = OutputStreamExpr.newInstance(file, false);
                        dataOutput = out.getDataOutput();
                    }
                    if (arg1 instanceof OutputStreamExpr) {
                        dataOutput = ((OutputStreamExpr)arg1).getDataOutput();
                    }
                    if (dataOutput != null) {
                        byte typeByte;
                        String typeStr;
                        IExpr arg2 = ast.arg2();
                        String string = typeStr = ast.isAST3() ? ast.arg3().toString() : "UnsignedInteger8";
                        if (typeStr.equals("Byte")) {
                            typeStr = "UnsignedInteger8";
                        }
                        if ((typeByte = NumericArrayExpr.toType(typeStr)) == -1) {
                            return S.$Failed;
                        }
                        if (arg2.isList()) {
                            IAST list = (IAST)arg2;
                            for (int i = 1; i < list.size(); ++i) {
                                if (BinaryWrite.writeType(dataOutput, list.get(i), typeByte)) continue;
                                return S.$Failed;
                            }
                            return S.Null;
                        }
                        BinaryWrite.writeType(dataOutput, arg2, typeByte);
                        return S.Null;
                    }
                }
                catch (IOException | RuntimeException | NumericArrayExpr.RangeException | NumericArrayExpr.TypeException e) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)e);
                    return F.$Failed;
                }
            }
            return F.NIL;
        }

        private static boolean writeType(DataOutput outputChannel, IExpr arg, byte typeByte) throws NumericArrayExpr.RangeException, NumericArrayExpr.TypeException, IllegalArgumentException, IOException {
            switch (typeByte) {
                case 0: {
                    outputChannel.writeByte(NumericArrayExpr.getByte(arg));
                    return true;
                }
                case 16: {
                    outputChannel.writeByte(NumericArrayExpr.getUnsignedByte(arg));
                    return true;
                }
            }
            return false;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }
    }

    private static final class BinaryRead
    extends AbstractFunctionEvaluator {
        private BinaryRead() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.isFileSystemEnabled(engine)) {
                try {
                    IExpr arg1 = ast.arg1();
                    DataInput reader = null;
                    if (arg1 instanceof FileExpr) {
                        InputStreamExpr stream = InputStreamExpr.getFromFile((FileExpr)arg1, "String", engine);
                        reader = stream.getDataInput();
                    } else if (arg1 instanceof InputStreamExpr) {
                        reader = ((InputStreamExpr)arg1).getDataInput();
                    }
                    if (reader != null) {
                        IExpr typeExpr;
                        if (ast.isAST2() && (typeExpr = ast.arg2()).isList()) {
                            IAST list = (IAST)ast.arg2();
                            IASTAppendable result = F.ListAlloc(list.size());
                            for (int i = 1; i < list.size(); ++i) {
                                String typeStr = list.get(i).toString();
                                IExpr temp = this.readType(reader, typeStr);
                                result.append(temp);
                            }
                            return result;
                        }
                        String typeStr = ast.isAST2() ? ast.arg2().toString() : "UnsignedInteger8";
                        return this.readType(reader, typeStr);
                    }
                }
                catch (EOFException ex) {
                    return S.EndOfFile;
                }
                catch (IOException | RuntimeException ex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)ex);
                    return S.$Failed;
                }
            }
            return F.NIL;
        }

        private IExpr readType(DataInput reader, String typeStr) throws IOException {
            byte typeByte;
            if (typeStr.equals("Byte")) {
                typeStr = "UnsignedInteger8";
            }
            if ((typeByte = NumericArrayExpr.toType(typeStr)) == -1) {
                if (typeStr.equals("Character8")) {
                    int uInt = Byte.toUnsignedInt(reader.readByte());
                    char ch = (char)uInt;
                    return F.stringx(ch);
                }
                return S.$Failed;
            }
            switch (typeByte) {
                case 0: {
                    byte sByte = reader.readByte();
                    return F.ZZ(sByte);
                }
                case 16: {
                    byte uByte = reader.readByte();
                    return F.ZZ(Byte.toUnsignedInt(uByte));
                }
            }
            return F.$Failed;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class BeginPackage
    extends AbstractFunctionEvaluator {
        private BeginPackage() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            String contextName = Validate.checkContextName(ast, 1);
            engine.beginPackage(contextName);
            if (ast.isAST2()) {
                IExpr arg2 = ast.arg2();
                if (arg2.isList()) {
                    IASTMutable needs = ((IAST)arg2).mapThread(F.Needs(F.Slot1), 1);
                    return engine.evaluate(needs);
                }
                return engine.evaluate(F.Needs(arg2));
            }
            if (Config.isFileSystemEnabled(engine)) {
                for (int j = 2; j < ast.size(); ++j) {
                    try (FileInputStream fis = new FileInputStream(ast.get(j).toString());
                         InputStreamReader r = new InputStreamReader((java.io.InputStream)fis, StandardCharsets.UTF_8);
                         BufferedReader reader = new BufferedReader(new InputStreamReader((java.io.InputStream)fis, StandardCharsets.UTF_8));){
                        Get.loadPackage(engine, reader);
                        continue;
                    }
                    catch (IOException e) {
                        LOGGER.debug("BeginPackage.evaluate() failed", (Throwable)e);
                    }
                }
            }
            return S.Null;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Begin
    extends AbstractCoreFunctionEvaluator {
        private Begin() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            String contextName = Validate.checkContextName(ast, 1);
            Context pack = EvalEngine.get().getContextPath().currentContext();
            Context context = engine.begin(contextName, pack);
            return F.stringx(context.completeContextName());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            if (!Config.FUZZY_PARSER) {
                S.BeginPackage.setEvaluator(new BeginPackage());
                S.BinaryRead.setEvaluator(new BinaryRead());
                S.BinaryWrite.setEvaluator(new BinaryWrite());
                S.EndPackage.setEvaluator(new EndPackage());
                S.Begin.setEvaluator(new Begin());
                S.Close.setEvaluator(new Close());
                S.CreateDirectory.setEvaluator(new CreateDirectory());
                S.CreateFile.setEvaluator(new CreateFile());
                S.End.setEvaluator(new End());
                S.File.setEvaluator(new FileEvaluator());
                S.FilePrint.setEvaluator(new FilePrint());
                S.Get.setEvaluator(new Get());
                S.InputStream.setEvaluator(new InputStream());
                S.Needs.setEvaluator(new Needs());
                S.OpenAppend.setEvaluator(new OpenAppend());
                S.OpenRead.setEvaluator(new OpenRead());
                S.OpenWrite.setEvaluator(new OpenWrite());
                S.OutputStream.setEvaluator(new OutputStream());
                S.Put.setEvaluator(new Put());
                S.Read.setEvaluator(new Read());
                S.ReadString.setEvaluator(new ReadString());
                S.StringToStream.setEvaluator(new StringToStream());
                S.URLFetch.setEvaluator(new URLFetch());
                S.Write.setEvaluator(new Write());
                S.WriteString.setEvaluator(new WriteString());
            }
        }
    }
}

