/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.util.function.DoubleUnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.Apint;
import org.apfloat.FixedPrecisionApfloatHelper;
import org.hipparchus.complex.Complex;
import org.hipparchus.util.FastMath;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractArg1;
import org.matheclipse.core.eval.interfaces.AbstractArg12;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.eval.interfaces.IRewrite;
import org.matheclipse.core.eval.util.AbstractAssumptions;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntervalSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.ArcCosRules;
import org.matheclipse.core.reflection.system.rules.ArcCoshRules;
import org.matheclipse.core.reflection.system.rules.ArcCotRules;
import org.matheclipse.core.reflection.system.rules.ArcCothRules;
import org.matheclipse.core.reflection.system.rules.ArcCscRules;
import org.matheclipse.core.reflection.system.rules.ArcCschRules;
import org.matheclipse.core.reflection.system.rules.ArcSecRules;
import org.matheclipse.core.reflection.system.rules.ArcSechRules;
import org.matheclipse.core.reflection.system.rules.ArcSinRules;
import org.matheclipse.core.reflection.system.rules.ArcSinhRules;
import org.matheclipse.core.reflection.system.rules.ArcTanRules;
import org.matheclipse.core.reflection.system.rules.ArcTanhRules;
import org.matheclipse.core.reflection.system.rules.CosRules;
import org.matheclipse.core.reflection.system.rules.CoshRules;
import org.matheclipse.core.reflection.system.rules.CotRules;
import org.matheclipse.core.reflection.system.rules.CothRules;
import org.matheclipse.core.reflection.system.rules.CscRules;
import org.matheclipse.core.reflection.system.rules.CschRules;
import org.matheclipse.core.reflection.system.rules.GudermannianRules;
import org.matheclipse.core.reflection.system.rules.LogRules;
import org.matheclipse.core.reflection.system.rules.SecRules;
import org.matheclipse.core.reflection.system.rules.SechRules;
import org.matheclipse.core.reflection.system.rules.SinRules;
import org.matheclipse.core.reflection.system.rules.SincRules;
import org.matheclipse.core.reflection.system.rules.SinhRules;
import org.matheclipse.core.reflection.system.rules.TanRules;
import org.matheclipse.core.reflection.system.rules.TanhRules;

public class ExpTrigsFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    private static IExpr arcTanArcCotInverse(IExpr arg1) {
        IExpr z = arg1.first();
        IExpr zRe = z.re();
        IExpr k = S.Quotient.of(F.Subtract(zRe, F.CPiHalf), S.Pi).inc();
        if (k.isInteger()) {
            IExpr min = S.Times.of(F.Plus((IExpr)F.CN1D2, k), S.Pi);
            IExpr max = S.Times.of(F.Plus((IExpr)F.C1D2, k), S.Pi);
            IAST result = F.Subtract(z, F.Times(k, (IExpr)S.Pi));
            if (S.Less.ofQ(min, zRe) && S.Greater.ofQ(max, zRe)) {
                return result;
            }
            IExpr zIm = z.im();
            if (zIm.isNegativeResult() && S.Equal.ofQ(zRe, min)) {
                return result;
            }
            if (arg1.isTan() ? zIm.isPositiveResult() && S.Equal.ofQ(zRe, max) : zIm.isNonNegativeResult() && S.Equal.ofQ(zRe, max)) {
                return result;
            }
        }
        return F.NIL;
    }

    private static IComplexNum log(IComplexNum val) {
        if (val instanceof ApcomplexNum) {
            return ApcomplexNum.valueOf(ApcomplexMath.log((Apcomplex)((ApcomplexNum)val).apcomplexValue()));
        }
        ComplexNum z = (ComplexNum)val;
        if (z.isNaN()) {
            return ComplexNum.NaN;
        }
        return ComplexNum.valueOf(Math.log(z.dabs()), Math.atan2(z.imDoubleValue(), z.reDoubleValue()));
    }

    private static IExpr arcSinSin(IExpr arg1) {
        IExpr z = arg1.first();
        IExpr zRe = z.re();
        IExpr k = S.Quotient.of(F.Subtract(zRe, F.CPiHalf), S.Pi).inc();
        if (k.isInteger()) {
            IExpr min = S.Times.of(F.Plus((IExpr)F.CN1D2, k), S.Pi);
            IExpr max = S.Times.of(F.Plus((IExpr)F.C1D2, k), S.Pi);
            IASTMutable result = F.Times((IExpr)F.Power((IExpr)F.CN1, k), (IExpr)F.Subtract(z, F.Times(k, (IExpr)S.Pi)));
            if (S.Less.ofQ(min, zRe) && S.Greater.ofQ(max, zRe)) {
                return result;
            }
            IExpr zIm = z.im();
            if (zIm.isNonNegativeResult() && S.Equal.ofQ(zRe, min)) {
                return result;
            }
            if ((zIm.isNegativeResult() || zIm.isZero()) && S.Equal.ofQ(zRe, max)) {
                return result;
            }
        }
        return F.NIL;
    }

    private static IExpr arcCosCos(IExpr arg1) {
        IExpr z = arg1.first();
        IExpr zRe = z.re();
        IExpr k = S.Quotient.of(F.Subtract(zRe, S.Pi), S.Pi).inc();
        if (k.isInteger()) {
            IExpr min = S.Times.of(k, S.Pi);
            IExpr max = S.Times.of(k.inc(), S.Pi);
            IAST result = F.Plus((IExpr)F.Times((IExpr)F.Power((IExpr)F.CN1, k), (IExpr)F.Plus(z, (IExpr)F.Times((IExpr)F.CN1, k, (IExpr)S.Pi), (IExpr)F.CNPiHalf)), (IExpr)F.CPiHalf);
            if (S.Less.ofQ(min, zRe) && S.Greater.ofQ(max, zRe)) {
                return result;
            }
            IExpr zIm = z.im();
            if (zIm.isNonNegativeResult() && S.Equal.ofQ(zRe, min)) {
                return result;
            }
            if ((zIm.isNegativeResult() || zIm.isZero()) && S.Equal.ofQ(zRe, max)) {
                return result;
            }
        }
        return F.NIL;
    }

    public static IExpr baseBLog(IInteger b, IInteger arg) {
        try {
            long l1 = b.toLong();
            long l2 = arg.toLong();
            if (l1 > 0L && l2 > 0L) {
                double numericResult;
                boolean inverse = false;
                if (l1 > l2) {
                    long t = l2;
                    l2 = l1;
                    l1 = t;
                    inverse = true;
                }
                if (F.isNumIntValue(numericResult = Math.log(l2) / Math.log(l1))) {
                    long symbolicResult = DoubleMath.roundToLong((double)numericResult, (RoundingMode)RoundingMode.HALF_UP);
                    if (inverse) {
                        if (b.equals(arg.powerRational(symbolicResult))) {
                            return F.QQ(1L, symbolicResult);
                        }
                    } else if (arg.equals(b.powerRational(symbolicResult))) {
                        return F.ZZ(symbolicResult);
                    }
                }
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return F.NIL;
    }

    public static void initialize() {
        Initializer.init();
    }

    private ExpTrigsFunctions() {
    }

    private static IRational integerPartFolded2(IRational r) {
        return r.integerPart().multiply(F.C1D2).integerPart().multiply(F.CN2);
    }

    private static final class Tanh
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    TanhRules,
    DoubleUnaryOperator {
        private Tanh() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return Math.tanh(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.tanh((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.tanh((Apfloat)arg1));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.tanh());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(Math.tanh(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.tanh(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IAST list;
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.Tanh(negExpr));
            }
            IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CI, (IExpr)F.Tan(imPart));
            }
            if (arg1.isZero()) {
                return F.C0;
            }
            if (arg1.isPlus() && (list = AbstractFunctionEvaluator.peelOffPlusI((IAST)arg1, engine)).isPresent()) {
                IExpr k = list.arg1();
                if (k.isRational()) {
                    IRational t = (IRational)k;
                    if (t.isLT(F.C0)) {
                        return F.Tanh(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CNI, (IExpr)S.Pi, (IExpr)t.integerPart()), (IExpr)F.Times((IExpr)F.CI, (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Coth(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)F.CI, (IExpr)S.Pi)));
                    }
                    return F.Tanh(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CNI, (IExpr)S.Pi, (IExpr)t.integerPart())));
                }
                if (k.isIntegerResult()) {
                    return F.Tanh(F.Subtract(arg1, list.arg2()));
                }
            }
            if (arg1.isInterval()) {
                return IntervalSym.tanh((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteExp(IExpr arg1, EvalEngine engine) {
            return F.Plus(F.Negate(F.Power((IExpr)F.Times((IExpr)F.Exp(arg1), (IExpr)F.Plus((IExpr)F.Exp(F.Negate(arg1)), (IExpr)F.Exp(arg1))), F.CN1)), (IExpr)F.Times((IExpr)F.Exp(arg1), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Exp(F.Negate(arg1)), (IExpr)F.Exp(arg1)), F.CN1)));
        }
    }

    private static final class Tan
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    TanRules,
    DoubleUnaryOperator {
        private Tan() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return Math.tan(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.tan((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.tan((Apfloat)arg1));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.tan());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(Math.tan(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.tan(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr imPart;
            IExpr k;
            if (arg1.isPlus() && (k = AbstractFunctionEvaluator.peelOffPlusRational((IAST)arg1, engine)) != null) {
                if (k.isRational()) {
                    IRational t = (IRational)k;
                    if (t.isLT(F.C0)) {
                        return F.Tan(F.Plus(arg1, (IExpr)S.Pi, (IExpr)F.Times((IExpr)F.CNPi, (IExpr)t.integerPart())));
                    }
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Negate(F.Cot(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)S.Pi))));
                    }
                    return F.Tan(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CNPi, (IExpr)t.integerPart())));
                }
                if (k.isIntegerResult()) {
                    return F.Tan(F.Subtract(arg1, F.Times(k, (IExpr)S.Pi)));
                }
            }
            if ((imPart = AbstractFunctionEvaluator.getComplexExpr(arg1, F.CNI)).isPresent()) {
                return F.Times((IExpr)F.CI, (IExpr)F.Tanh(imPart));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.Tan(negExpr));
            }
            if (arg1.isTimes()) {
                IAST timesAST = (IAST)arg1;
                if (timesAST.size() == 3 && timesAST.arg1().isRational() && timesAST.arg2().isPi()) {
                    IRational t = (IRational)timesAST.arg1();
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.equals(F.C1D2)) {
                        return F.CComplexInfinity;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Negate(F.Tan(F.Times((IExpr)F.Subtract(F.C1, t), (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C2)) {
                        return F.Tan(F.Times((IExpr)F.Subtract(t, F.C1), (IExpr)S.Pi));
                    }
                    return F.Tan(F.Times((IExpr)S.Pi, (IExpr)F.Plus((IExpr)t, (IExpr)ExpTrigsFunctions.integerPartFolded2(t))));
                }
                IExpr t = AbstractFunctionEvaluator.peelOfTimes(timesAST, S.Pi);
                if (t.isPresent() && t.im().isZero()) {
                    if (t.isIntegerResult()) {
                        return F.C0;
                    }
                    IExpr temp = engine.evaluate(F.Plus(t, (IExpr)F.CN1D2));
                    if (temp.isIntegerResult()) {
                        return F.CComplexInfinity;
                    }
                }
            }
            if (arg1.isInterval()) {
                return IntervalSym.tan((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteExp(IExpr arg1, EvalEngine engine) {
            return F.Times((IExpr)F.CI, (IExpr)F.Subtract(F.Exp(F.Times((IExpr)F.CNI, arg1)), F.Exp(F.Times((IExpr)F.CI, arg1))), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Exp(F.Times((IExpr)F.CNI, arg1)), (IExpr)F.Exp(F.Times((IExpr)F.CI, arg1))), F.CN1));
        }
    }

    private static final class Sinh
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    SinhRules,
    DoubleUnaryOperator {
        private Sinh() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return Math.sinh(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.sinh((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.sinh((Apfloat)arg1));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.sinh());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(Math.sinh(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.sinh(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IAST list;
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.Sinh(negExpr));
            }
            IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CI, (IExpr)F.Sin(imPart));
            }
            if (arg1.isZero()) {
                return F.C0;
            }
            if (arg1.isPlus() && (list = AbstractFunctionEvaluator.peelOffPlusI((IAST)arg1, engine)).isPresent()) {
                IExpr k = list.arg1();
                if (k.isRational()) {
                    IRational t = (IRational)k;
                    if (t.isLT(F.C0)) {
                        return F.Sinh(F.Plus(arg1, (IExpr)F.Times(F.CN2, F.CI, S.Pi, F.IntegerPart(F.Times((IExpr)F.C1D2, (IExpr)t))), (IExpr)F.Times((IExpr)F.C2, (IExpr)F.CI, (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Times((IExpr)F.CI, (IExpr)F.Cosh(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)F.CI, (IExpr)S.Pi))));
                    }
                    if (t.isLT(F.C2)) {
                        return F.Negate(F.Sinh(F.Subtract(arg1, F.Times((IExpr)F.CI, (IExpr)S.Pi))));
                    }
                    return F.Sinh(F.Plus(arg1, (IExpr)F.Times(F.CN2, F.CI, S.Pi, F.IntegerPart(F.Times((IExpr)F.C1D2, (IExpr)t)))));
                }
                if (k.isIntegerResult()) {
                    return F.Times((IExpr)F.Power((IExpr)F.CN1, k), (IExpr)F.Sinh(F.Subtract(arg1, list.arg2())));
                }
            }
            if (arg1.isInterval()) {
                return IntervalSym.sinh((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteExp(IExpr arg1, EvalEngine engine) {
            return F.Plus(F.Negate(F.Power((IExpr)F.Times((IExpr)F.Exp(arg1), (IExpr)F.C2), F.CN1)), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Exp(arg1)));
        }
    }

    private static class Sinc
    extends AbstractTrigArg1
    implements INumeric,
    SincRules,
    DoubleUnaryOperator {
        private Sinc() {
        }

        @Override
        public double applyAsDouble(double operand) {
            if (F.isZero(operand)) {
                return 1.0;
            }
            return new org.hipparchus.analysis.function.Sinc(false).value(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            if (arg1.equals((Object)Apcomplex.ZERO)) {
                return F.num((Apfloat)Apcomplex.ONE);
            }
            return F.complexNum(ApcomplexMath.sin((Apcomplex)arg1).divide(arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            if (arg1.equals((Object)Apcomplex.ZERO)) {
                return F.num((Apfloat)Apcomplex.ONE);
            }
            return F.num(ApfloatMath.sin((Apfloat)arg1).divide(arg1));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            if (arg1.equals((Object)Complex.ZERO)) {
                return F.complexNum(Complex.ONE);
            }
            return F.complexNum(arg1.sin().divide(arg1));
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            if (F.isZero(arg1)) {
                return F.CD1;
            }
            return F.num(new org.hipparchus.analysis.function.Sinc(false).value(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            double a1 = stack[top];
            if (a1 == 0.0) {
                return 1.0;
            }
            return new org.hipparchus.analysis.function.Sinc(false).value(a1);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isZero()) {
                return F.C1;
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Sinc(negExpr);
            }
            IExpr sin = S.Sin.ofNIL(engine, arg1);
            if (sin.isPresent() && !sin.isSin()) {
                return sin.divide(arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class Sin
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    SinRules,
    DoubleUnaryOperator {
        private Sin() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return Math.sin(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.sin((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.sin((Apfloat)arg1));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.sin());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(Math.sin(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.sin(stack[top]);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            block23: {
                IExpr k;
                if (arg1.isPlus() && (k = AbstractFunctionEvaluator.peelOffPlusRational((IAST)arg1, engine)) != null) {
                    if (k.isRational()) {
                        IRational t = (IRational)k;
                        if (t.isLT(F.C0) || F.C2.isLE(t)) {
                            return F.Sin(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN2, (IExpr)S.Pi, (IExpr)F.Floor(F.Times((IExpr)F.C1D2, (IExpr)t)))));
                        }
                        if (t.isLT(F.C1D2)) {
                            IExpr temp = engine.evaluate(arg1.subtract(t.times(S.Pi)));
                            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(temp);
                            if (negExpr.isPresent()) {
                                return F.Cos(F.Subtract(F.Times((IExpr)F.C1D2, (IExpr)S.Pi), arg1));
                            }
                            break block23;
                        } else {
                            if (t.isLT(F.C1)) {
                                return F.Cos(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)S.Pi)));
                            }
                            if (t.isLT(F.C3D2)) {
                                return F.Negate(F.Sin(F.Subtract(arg1, S.Pi)));
                            }
                            return F.Negate(F.Cos(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN3D2, (IExpr)S.Pi))));
                        }
                    }
                    if (k.isIntegerResult()) {
                        return F.Times((IExpr)F.Power((IExpr)F.CN1, k), (IExpr)F.Sin(F.Subtract(arg1, F.Times(k, (IExpr)S.Pi))));
                    }
                }
            }
            if (arg1.isInterval()) {
                return IntervalSym.sin((IAST)arg1);
            }
            IExpr imPart = AbstractFunctionEvaluator.getComplexExpr(arg1, F.CNI);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CI, (IExpr)F.Sinh(imPart));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.Sin(negExpr));
            }
            if (arg1.isTimes()) {
                IExpr t;
                IAST timesAST = (IAST)arg1;
                if (timesAST.size() == 3 && timesAST.arg1().isRational() && timesAST.arg2().isPi()) {
                    t = (IRational)timesAST.arg1();
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Sin(F.Times((IExpr)F.Subtract(F.C1, t), (IExpr)S.Pi));
                    }
                    if (t.isLT(F.C3D2)) {
                        return F.Negate(F.Sin(F.Times((IExpr)F.Subtract(t, F.C1), (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C2)) {
                        return F.Negate(F.Sin(F.Times((IExpr)F.Subtract(F.C2, t), (IExpr)S.Pi)));
                    }
                    return F.Sin(F.Times((IExpr)S.Pi, (IExpr)F.Plus(t, (IExpr)ExpTrigsFunctions.integerPartFolded2((IRational)t))));
                }
                t = AbstractFunctionEvaluator.peelOfTimes(timesAST, S.Pi);
                if (t.isPresent() && t.im().isZero()) {
                    if (t.isIntegerResult()) {
                        return F.C0;
                    }
                    IExpr temp1 = engine.evaluate(F.Times((IExpr)F.C1D2, t));
                    IExpr temp2 = engine.evaluate(F.Plus(temp1, (IExpr)F.CN1D4));
                    if (temp2.isIntegerResult()) {
                        return F.C1;
                    }
                    temp2 = engine.evaluate(F.Plus(temp1, (IExpr)F.C1D4));
                    if (temp2.isIntegerResult()) {
                        return F.CN1;
                    }
                    temp2 = engine.evaluate(F.Plus(t, (IExpr)F.CN1D2));
                    if (temp2.isIntegerResult()) {
                        return F.Power((IExpr)F.CN1, temp2);
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteExp(IExpr arg1, EvalEngine engine) {
            return F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.CI), F.CN1), (IExpr)F.Exp(F.Times((IExpr)F.CN1, arg1, (IExpr)F.CI))), (IExpr)F.Times((IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.CI), F.CN1), (IExpr)F.Exp(F.Times(arg1, (IExpr)F.CI))));
        }
    }

    private static final class Sech
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    SechRules,
    DoubleUnaryOperator {
        private Sech() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return 1.0 / Math.cosh(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.inverseRoot((Apcomplex)ApcomplexMath.cosh((Apcomplex)arg1), (long)1L));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.inverseRoot((Apfloat)ApfloatMath.cosh((Apfloat)arg1), (long)1L));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.cosh().reciprocal());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(1.0 / Math.cosh(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return 1.0 / Math.cosh(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IAST list;
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Sech(negExpr);
            }
            IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1);
            if (imPart.isPresent()) {
                return F.Sec(imPart);
            }
            if (arg1.isZero()) {
                return F.C0;
            }
            if (arg1.isPlus() && (list = AbstractFunctionEvaluator.peelOffPlusI((IAST)arg1, engine)).isPresent()) {
                IExpr k = list.arg1();
                if (k.isRational()) {
                    IRational t = (IRational)k;
                    if (t.isLT(F.C0)) {
                        return F.Sech(F.Plus(arg1, (IExpr)F.Times(F.CN2, F.CI, S.Pi, F.IntegerPart(F.Times((IExpr)F.C1D2, (IExpr)t))), (IExpr)F.Times((IExpr)F.C2, (IExpr)F.CI, (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Times((IExpr)F.CNI, (IExpr)F.Csch(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)F.CI, (IExpr)S.Pi))));
                    }
                    if (t.isLT(F.C2)) {
                        return F.Negate(F.Sech(F.Subtract(arg1, F.Times((IExpr)F.CI, (IExpr)S.Pi))));
                    }
                    return F.Sech(F.Plus(arg1, (IExpr)F.Times(F.CN2, F.CI, S.Pi, F.IntegerPart(F.Times((IExpr)F.C1D2, (IExpr)t)))));
                }
                if (k.isIntegerResult()) {
                    return F.Times((IExpr)F.Power((IExpr)F.CN1, k), (IExpr)F.Sech(F.Subtract(arg1, list.arg2())));
                }
            }
            if (arg1.isInterval()) {
                return IntervalSym.sech((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteExp(IExpr arg1, EvalEngine engine) {
            return F.Times((IExpr)F.C2, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Exp(F.Negate(arg1)), (IExpr)F.Exp(arg1)), F.CN1));
        }
    }

    private static final class Sec
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    SecRules,
    DoubleUnaryOperator {
        private Sec() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return 1.0 / Math.cos(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.inverseRoot((Apcomplex)ApcomplexMath.cos((Apcomplex)arg1), (long)1L));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.inverseRoot((Apfloat)ApfloatMath.cos((Apfloat)arg1), (long)1L));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.cos().reciprocal());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(1.0 / Math.cos(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return 1.0 / Math.cos(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr imPart;
            IExpr k;
            if (arg1.isPlus() && (k = AbstractFunctionEvaluator.peelOffPlusRational((IAST)arg1, engine)) != null) {
                if (k.isRational()) {
                    IRational t = (IRational)k;
                    if (t.isLT(F.C0)) {
                        return F.Sec(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN2Pi, (IExpr)F.IntegerPart(F.Times((IExpr)F.C1D2, (IExpr)t))), (IExpr)F.C2Pi));
                    }
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Negate(F.Csc(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)S.Pi))));
                    }
                    if (t.isLT(F.C2)) {
                        return F.Negate(F.Sec(F.Plus(arg1, (IExpr)F.CNPi)));
                    }
                    return F.Sec(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN2Pi, (IExpr)F.IntegerPart(F.Times((IExpr)F.C1D2, (IExpr)t)))));
                }
                if (k.isIntegerResult()) {
                    return F.Times((IExpr)F.Power((IExpr)F.CN1, k), (IExpr)F.Sec(F.Subtract(arg1, F.Times(k, (IExpr)S.Pi))));
                }
            }
            if ((imPart = AbstractFunctionEvaluator.getComplexExpr(arg1, F.CNI)).isPresent()) {
                return F.Sech(imPart);
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Sec(negExpr);
            }
            if (arg1.isTimes()) {
                IAST timesAST = (IAST)arg1;
                if (timesAST.size() == 3 && timesAST.arg1().isRational() && timesAST.arg2().isPi()) {
                    IRational t = (IRational)timesAST.arg1();
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Negate(F.Sec(F.Times((IExpr)F.Subtract(F.C1, t), (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C2)) {
                        return F.Sec(F.Times((IExpr)F.Subtract(F.C2, t), (IExpr)S.Pi));
                    }
                    return F.Sec(F.Times((IExpr)S.Pi, (IExpr)F.Plus((IExpr)t, (IExpr)ExpTrigsFunctions.integerPartFolded2(t))));
                }
                IExpr t = AbstractFunctionEvaluator.peelOfTimes(timesAST, S.Pi);
                if (t.isPresent() && t.im().isZero()) {
                    IExpr temp1 = engine.evaluate(F.Times((IExpr)F.C1D2, t));
                    if (temp1.isIntegerResult()) {
                        return F.C1;
                    }
                    IExpr temp2 = engine.evaluate(F.Plus(temp1, (IExpr)F.CN1D2));
                    if (temp2.isIntegerResult()) {
                        return F.CN1;
                    }
                    if (t.isIntegerResult()) {
                        return F.Power((IExpr)F.CN1, t);
                    }
                    temp2 = engine.evaluate(F.Plus(t, (IExpr)F.CN1D2));
                    if (temp2.isIntegerResult()) {
                        return F.CComplexInfinity;
                    }
                }
            }
            if (arg1.isInterval()) {
                return IntervalSym.sec((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteExp(IExpr arg1, EvalEngine engine) {
            return F.Times((IExpr)F.C2, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Exp(F.Times((IExpr)F.CNI, arg1)), (IExpr)F.Exp(F.Times((IExpr)F.CI, arg1))), F.CN1));
        }
    }

    private static final class Log2
    extends AbstractArg1
    implements INumeric {
        private Log2() {
        }

        @Override
        public IExpr e1ObjArg(IExpr o) {
            return F.Log(F.C2, o);
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.log(stack[top] / 2.0);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class Log10
    extends AbstractArg1
    implements INumeric {
        private Log10() {
        }

        @Override
        public IExpr e1ObjArg(IExpr o) {
            return F.Log(F.C10, o);
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.log10(stack[top]);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class LogisticSigmoid
    extends AbstractEvaluator {
        private LogisticSigmoid() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (z.isInfinity()) {
                return F.C1;
            }
            if (z.isNegativeInfinity()) {
                return F.C0;
            }
            if (z.isNumericFunction(true)) {
                if (z.isZero()) {
                    return F.C1D2;
                }
                if (z.equals(F.Times((IExpr)F.CI, (IExpr)S.Pi))) {
                    return F.NIL;
                }
                if ((engine.isDoubleMode() || engine.isArbitraryMode()) && z.isNumber()) {
                    return F.Power.of(engine, F.Plus((IExpr)F.C1, (IExpr)F.Power((IExpr)S.E, F.Times((IExpr)F.CN1, z))), F.CN1);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class Log
    extends AbstractArg12
    implements INumeric,
    LogRules {
        private Log() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.log((Apfloat)arg1));
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.log((Apcomplex)arg1));
        }

        @Override
        public IExpr e1DblArg(INum arg1) {
            return Num.valueOf(Math.log(arg1.getRealPart()));
        }

        @Override
        public IExpr e1FraArg(IFraction f) {
            if (f.isPositive() && f.isLT(F.C1)) {
                return F.Negate(F.Log(f.inverse()));
            }
            return F.NIL;
        }

        @Override
        public IExpr e2ApfloatArg(ApfloatNum d0, ApfloatNum d1) {
            FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
            return F.complexNum(h.log(d0.apfloatValue(), d1.apfloatValue()));
        }

        @Override
        public IExpr e2ApcomplexArg(ApcomplexNum c0, ApcomplexNum c1) {
            FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
            return F.complexNum(h.log(c0.apcomplexValue(), c1.apcomplexValue()));
        }

        @Override
        public IExpr e1DblComArg(IComplexNum arg1) {
            return ExpTrigsFunctions.log(arg1);
        }

        @Override
        public IExpr e2DblArg(INum arg1, INum arg2) {
            return Num.valueOf(Math.log(arg2.getRealPart()) / Math.log(arg1.getRealPart()));
        }

        @Override
        public IExpr e2IntArg(IInteger arg1, IInteger arg2) {
            return ExpTrigsFunctions.baseBLog(arg1, arg2);
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.log(stack[top]);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr e1ObjArg(IExpr arg1) {
            if (arg1.isPower()) {
                IExpr base = arg1.base();
                IExpr exponent = arg1.exponent();
                IExpr temp = F.eval(F.Times(exponent, (IExpr)F.Log(base)));
                IExpr imTemp = F.eval(F.Im(temp));
                if (imTemp.isReal() && ((ISignedNumber)imTemp).isGT(F.num(-Math.PI)) && ((ISignedNumber)imTemp).isLT(F.num(Math.PI))) {
                    return temp;
                }
                if (AbstractAssumptions.assumePositive(base) && exponent.isRealResult()) {
                    return temp;
                }
            }
            if (arg1.isNegativeResult()) {
                return F.Plus((IExpr)F.Log(F.Negate(arg1)), (IExpr)F.Times((IExpr)F.CI, (IExpr)S.Pi));
            }
            if (arg1.isInterval()) {
                return IntervalSym.log((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IExpr e2ObjArg(IExpr o0, IExpr o1) {
            if (o0.isZero()) {
                if (o1.isZero()) {
                    return S.Indeterminate;
                }
                return F.C0;
            }
            return F.NIL;
        }
    }

    private static final class LambertW
    extends AbstractArg1 {
        private LambertW() {
        }

        @Override
        public IExpr e1ObjArg(IExpr o) {
            return F.ProductLog(o);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static final class InverseHaversine
    extends AbstractFunctionEvaluator {
        private InverseHaversine() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arcSin;
            IExpr z = ast.arg1();
            if (engine.isNumericMode()) {
                if (z.isNumber()) {
                    return F.Times.of(engine, F.C2, F.ArcSin(F.Sqrt(z)));
                }
            } else if (z.isNumericFunction() && (arcSin = S.ArcSin.ofNIL(engine, F.Sqrt(z))).isPresent()) {
                return F.Times.of(engine, F.C2, arcSin);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class InverseGudermannian
    extends AbstractFunctionEvaluator {
        private InverseGudermannian() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (engine.isNumericMode()) {
                try {
                    if (z.isNumber()) {
                        return F.Times.of(engine, F.C2, F.ArcTanh(F.Tan(F.Times((IExpr)F.C1D2, z))));
                    }
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class Haversine
    extends AbstractFunctionEvaluator {
        private Haversine() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr cos;
            IExpr z = ast.arg1();
            if (engine.isNumericMode()) {
                if (z.isNumber()) {
                    return F.Times.of(engine, F.C1D2, F.Subtract(F.C1, F.Cos(z)));
                }
            } else if (z.isNumericFunction() && (cos = S.Cos.ofNIL(engine, z)).isPresent()) {
                return F.Times.of(engine, F.C1D2, F.Subtract(F.C1, cos));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class Gudermannian
    extends AbstractFunctionEvaluator
    implements GudermannianRules {
        private Gudermannian() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (engine.isNumericMode()) {
                try {
                    if (z.isNumber()) {
                        if (((INumber)z).complexSign() >= 0) {
                            return F.Times.of(engine, F.C1D2, F.Subtract(S.Pi, F.Times((IExpr)F.C4, (IExpr)F.ArcCot(F.Power((IExpr)S.E, z)))));
                        }
                        return F.Times.of(engine, F.C2, F.ArcTan(F.Tanh(F.Times((IExpr)F.C1D2, z))));
                    }
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class Exp
    extends AbstractArg1
    implements INumeric {
        private Exp() {
        }

        @Override
        public IExpr e1ObjArg(IExpr o) {
            return F.Power((IExpr)S.E, o);
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.exp(stack[top]);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class Csch
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    CschRules,
    DoubleUnaryOperator {
        private Csch() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return 1.0 / Math.sinh(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.inverseRoot((Apcomplex)ApcomplexMath.sinh((Apcomplex)arg1), (long)1L));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.inverseRoot((Apfloat)ApfloatMath.sinh((Apfloat)arg1), (long)1L));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.sinh().reciprocal());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(1.0 / Math.sinh(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return 1.0 / Math.sinh(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IAST list;
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.Csch(negExpr));
            }
            IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CNI, (IExpr)F.Csc(imPart));
            }
            if (arg1.isZero()) {
                return F.CComplexInfinity;
            }
            if (arg1.isPlus() && (list = AbstractFunctionEvaluator.peelOffPlusI((IAST)arg1, engine)).isPresent()) {
                IExpr k = list.arg1();
                if (k.isRational()) {
                    IRational t = (IRational)k;
                    if (t.isLT(F.C0)) {
                        return F.Csch(F.Plus(arg1, (IExpr)F.Times(F.CN2, F.CI, S.Pi, F.IntegerPart(F.Times((IExpr)F.C1D2, (IExpr)t))), (IExpr)F.Times((IExpr)F.C2, (IExpr)F.CI, (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Times((IExpr)F.CNI, (IExpr)F.Sech(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)F.CI, (IExpr)S.Pi))));
                    }
                    if (t.isLT(F.C2)) {
                        return F.Negate(F.Csch(F.Subtract(arg1, F.Times((IExpr)F.CI, (IExpr)S.Pi))));
                    }
                    return F.Csch(F.Plus(arg1, (IExpr)F.Times(F.CN2, F.CI, S.Pi, F.IntegerPart(F.Times((IExpr)F.C1D2, (IExpr)t)))));
                }
                if (k.isIntegerResult()) {
                    return F.Times((IExpr)F.Power((IExpr)F.CN1, k), (IExpr)F.Csch(F.Subtract(arg1, list.arg2())));
                }
            }
            if (arg1.isInterval()) {
                return IntervalSym.csch((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteExp(IExpr arg1, EvalEngine engine) {
            return F.Times((IExpr)F.C2, (IExpr)F.Power((IExpr)F.Plus(F.Negate(F.Exp(F.Negate(arg1))), (IExpr)F.Exp(arg1)), F.CN1));
        }
    }

    private static final class Cot
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    CotRules,
    DoubleUnaryOperator {
        private Cot() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return 1.0 / Math.tan(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            Apcomplex denominator = ApcomplexMath.sin((Apcomplex)arg1);
            if (denominator.equals((Object)Apcomplex.ZERO)) {
                return F.CComplexInfinity;
            }
            return F.complexNum(ApcomplexMath.cos((Apcomplex)arg1).divide(denominator));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            Apfloat denominator = ApfloatMath.sin((Apfloat)arg1);
            if (denominator.equals((Object)Apcomplex.ZERO)) {
                return F.CComplexInfinity;
            }
            return F.num(ApfloatMath.cos((Apfloat)arg1).divide(denominator));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            Complex denominator = arg1.sin();
            if (denominator.equals((Object)Complex.ZERO)) {
                return F.CComplexInfinity;
            }
            return F.complexNum(arg1.cos().divide(denominator));
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            double denom = Math.sin(arg1);
            if (F.isZero(denom)) {
                return F.CComplexInfinity;
            }
            return F.num(Math.cos(arg1) / denom);
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return 1.0 / Math.tan(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr imPart;
            IExpr k;
            if (arg1.isPlus() && (k = AbstractFunctionEvaluator.peelOffPlusRational((IAST)arg1, engine)) != null) {
                if (k.isRational()) {
                    IRational t = (IRational)k;
                    if (t.isLT(F.C0)) {
                        return F.Cot(F.Plus(arg1, (IExpr)S.Pi, (IExpr)F.Times((IExpr)F.CN1, (IExpr)S.Pi, (IExpr)t.integerPart())));
                    }
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Negate(F.Tan(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)S.Pi))));
                    }
                    return F.Cot(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)S.Pi, (IExpr)t.integerPart())));
                }
                if (k.isIntegerResult()) {
                    return F.Cot(F.Subtract(arg1, F.Times(k, (IExpr)S.Pi)));
                }
            }
            if ((imPart = AbstractFunctionEvaluator.getComplexExpr(arg1, F.CNI)).isPresent()) {
                return F.Times((IExpr)F.CNI, (IExpr)F.Coth(imPart));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.Cot(negExpr));
            }
            if (arg1.isTimes()) {
                IAST timesAST = (IAST)arg1;
                if (timesAST.size() == 3 && timesAST.arg1().isRational() && timesAST.arg2().isPi()) {
                    IRational t = (IRational)timesAST.arg1();
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Negate(F.Cot(F.Times((IExpr)F.Subtract(F.C1, t), (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C2)) {
                        return F.Cot(F.Times((IExpr)F.Subtract(t, F.C1), (IExpr)S.Pi));
                    }
                    return F.Cot(F.Times((IExpr)S.Pi, (IExpr)F.Plus((IExpr)t, (IExpr)ExpTrigsFunctions.integerPartFolded2(t))));
                }
                IExpr t = AbstractFunctionEvaluator.peelOfTimes(timesAST, S.Pi);
                if (t.isPresent() && t.im().isZero()) {
                    if (t.isIntegerResult()) {
                        return F.CComplexInfinity;
                    }
                    IExpr temp = engine.evaluate(F.Plus(t, (IExpr)F.CN1D2));
                    if (temp.isIntegerResult()) {
                        return F.C0;
                    }
                }
            }
            if (arg1.isInterval()) {
                return IntervalSym.cot((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteExp(IExpr arg1, EvalEngine engine) {
            return F.Times(F.CN1, F.CI, F.Plus((IExpr)F.Exp(F.Times((IExpr)F.CNI, arg1)), (IExpr)F.Exp(F.Times((IExpr)F.CI, arg1))), F.Power((IExpr)F.Subtract(F.Exp(F.Times((IExpr)F.CNI, arg1)), F.Exp(F.Times((IExpr)F.CI, arg1))), F.CN1));
        }
    }

    private static final class Cosh
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    CoshRules,
    DoubleUnaryOperator {
        private Cosh() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return Math.cosh(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.cosh((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.cosh((Apfloat)arg1));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.cosh());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(Math.cosh(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.cosh(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr imPart;
            IAST list;
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Cosh(negExpr);
            }
            if (arg1.isZero()) {
                return F.C1;
            }
            if (arg1.isPlus() && (list = AbstractFunctionEvaluator.peelOffPlusI((IAST)arg1, engine)).isPresent()) {
                IExpr k = list.arg1();
                if (k.isRational()) {
                    IRational t = (IRational)k;
                    if (t.isLT(F.C0)) {
                        return F.Cosh(F.Plus(arg1, (IExpr)F.Times(F.CN2, F.CI, S.Pi, F.IntegerPart(F.Times((IExpr)F.C1D2, (IExpr)t))), (IExpr)F.Times((IExpr)F.C2, (IExpr)F.CI, (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Times((IExpr)F.CI, (IExpr)F.Sinh(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)F.CI, (IExpr)S.Pi))));
                    }
                    if (t.isLT(F.C2)) {
                        return F.Negate(F.Cosh(F.Subtract(arg1, F.Times((IExpr)F.CI, (IExpr)S.Pi))));
                    }
                    return F.Cosh(F.Plus(arg1, (IExpr)F.Times(F.CN2, F.CI, S.Pi, F.IntegerPart(F.Times((IExpr)F.C1D2, (IExpr)t)))));
                }
                if (k.isIntegerResult()) {
                    return F.Times((IExpr)F.Power((IExpr)F.CN1, k), (IExpr)F.Cosh(F.Subtract(arg1, list.arg2())));
                }
            }
            if ((imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1)).isPresent()) {
                return F.Cos(imPart);
            }
            if (arg1.isInterval()) {
                return IntervalSym.cosh((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteExp(IExpr arg1, EvalEngine engine) {
            return F.Plus((IExpr)F.Power((IExpr)F.Times((IExpr)F.Exp(arg1), (IExpr)F.C2), F.CN1), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Exp(arg1)));
        }
    }

    private static final class Csc
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    CscRules,
    DoubleUnaryOperator {
        private Csc() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return 1.0 / Math.sin(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.inverseRoot((Apcomplex)ApcomplexMath.sin((Apcomplex)arg1), (long)1L));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.inverseRoot((Apfloat)ApfloatMath.sin((Apfloat)arg1), (long)1L));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.sin().reciprocal());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(1.0 / Math.sin(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return 1.0 / Math.sin(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr imPart;
            IExpr k;
            if (arg1.isPlus() && (k = AbstractFunctionEvaluator.peelOffPlusRational((IAST)arg1, engine)) != null) {
                if (k.isRational()) {
                    IRational t = (IRational)k;
                    if (t.isLT(F.C0)) {
                        return F.Csc(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN2Pi, (IExpr)F.IntegerPart(F.Times((IExpr)F.C1D2, (IExpr)t))), (IExpr)F.C2Pi));
                    }
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Sec(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C2)) {
                        return F.Negate(F.Csc(F.Plus(arg1, (IExpr)F.CNPi)));
                    }
                    return F.Csc(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN2Pi, (IExpr)F.IntegerPart(F.Times((IExpr)F.C1D2, (IExpr)t)))));
                }
                if (k.isIntegerResult()) {
                    return F.Times((IExpr)F.Power((IExpr)F.CN1, k), (IExpr)F.Csc(F.Subtract(arg1, F.Times(k, (IExpr)S.Pi))));
                }
            }
            if ((imPart = AbstractFunctionEvaluator.getComplexExpr(arg1, F.CNI)).isPresent()) {
                return F.Times((IExpr)F.CNI, (IExpr)F.Csch(imPart));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.Csc(negExpr));
            }
            if (arg1.isTimes()) {
                IAST timesAST = (IAST)arg1;
                if (timesAST.size() == 3 && timesAST.arg1().isRational() && timesAST.arg2().isPi()) {
                    IRational t = (IRational)timesAST.arg1();
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Csc(F.Times((IExpr)F.Subtract(F.C1, t), (IExpr)S.Pi));
                    }
                    if (t.isLT(F.C2)) {
                        return F.Negate(F.Csc(F.Times((IExpr)F.Subtract(F.C2, t), (IExpr)S.Pi)));
                    }
                    return F.Csc(F.Times((IExpr)S.Pi, (IExpr)F.Plus((IExpr)t, (IExpr)ExpTrigsFunctions.integerPartFolded2(t))));
                }
                IExpr t = AbstractFunctionEvaluator.peelOfTimes(timesAST, S.Pi);
                if (t.isPresent() && t.im().isZero()) {
                    if (t.isIntegerResult()) {
                        return F.CComplexInfinity;
                    }
                    IExpr temp1 = engine.evaluate(F.Times((IExpr)F.C1D2, t));
                    IExpr temp2 = engine.evaluate(F.Plus(temp1, (IExpr)F.CN1D4));
                    if (temp2.isIntegerResult()) {
                        return F.C1;
                    }
                    temp2 = engine.evaluate(F.Plus(temp1, (IExpr)F.C1D4));
                    if (temp2.isIntegerResult()) {
                        return F.CN1;
                    }
                    temp2 = engine.evaluate(F.Plus(t, (IExpr)F.CN1D2));
                    if (temp2.isIntegerResult()) {
                        return F.Power((IExpr)F.CN1, temp2);
                    }
                }
            }
            if (arg1.isInterval()) {
                return IntervalSym.csc((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteExp(IExpr arg1, EvalEngine engine) {
            return F.Times(F.CN1, F.C2, F.CI, F.Power((IExpr)F.Subtract(F.Exp(F.Times((IExpr)F.CNI, arg1)), F.Exp(F.Times((IExpr)F.CI, arg1))), F.CN1));
        }
    }

    private static final class Coth
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    CothRules,
    DoubleUnaryOperator {
        private Coth() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return Math.cosh(operand) / Math.sinh(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.cosh((Apcomplex)arg1).divide(ApcomplexMath.sinh((Apcomplex)arg1)));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.cosh((Apfloat)arg1).divide(ApfloatMath.sinh((Apfloat)arg1)));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.cosh().divide(arg1.sinh()));
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(Math.cosh(arg1) / Math.sinh(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.cosh(stack[top]) / Math.sinh(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IAST list;
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.Coth(negExpr));
            }
            IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CNI, (IExpr)F.Cot(imPart));
            }
            if (arg1.isZero()) {
                return F.CComplexInfinity;
            }
            if (arg1.isPlus() && (list = AbstractFunctionEvaluator.peelOffPlusI((IAST)arg1, engine)).isPresent()) {
                IExpr k = list.arg1();
                if (k.isRational()) {
                    IRational t = (IRational)k;
                    if (t.isLT(F.C0)) {
                        return F.Coth(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CNI, (IExpr)S.Pi, (IExpr)t.integerPart()), (IExpr)F.Times((IExpr)F.CI, (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Tanh(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)F.CI, (IExpr)S.Pi)));
                    }
                    return F.Coth(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CNI, (IExpr)S.Pi, (IExpr)t.integerPart())));
                }
                if (k.isIntegerResult()) {
                    return F.Coth(F.Subtract(arg1, list.arg2()));
                }
            }
            if (arg1.isInterval()) {
                return IntervalSym.coth((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteExp(IExpr arg, EvalEngine engine) {
            IAST negexp = F.Exp(F.Times((IExpr)F.CN1, arg));
            IAST posexp = F.Exp(arg);
            return F.Times((IExpr)F.Plus((IExpr)posexp, (IExpr)negexp), (IExpr)F.Power((IExpr)F.Plus(F.Negate(negexp), (IExpr)posexp), F.CN1));
        }
    }

    private static final class Cos
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    CosRules,
    DoubleUnaryOperator {
        private Cos() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return Math.cos(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.cos((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.cos((Apfloat)arg1));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.cos());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(Math.cos(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.cos(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr k;
            if (arg1.isPlus() && (k = AbstractFunctionEvaluator.peelOffPlusRational((IAST)arg1, engine)) != null) {
                if (k.isRational()) {
                    IRational t = (IRational)k;
                    if (t.isLT(F.C0) || F.C2.isLE(t)) {
                        return F.Cos(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN2, (IExpr)S.Pi, (IExpr)F.Floor(F.Times((IExpr)F.C1D2, (IExpr)t)))));
                    }
                    if (t.isLT(F.C1D2)) {
                        IExpr temp = engine.evaluate(arg1.subtract(t.times(S.Pi)));
                        IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(temp);
                        if (negExpr.isPresent()) {
                            return F.Sin(F.Subtract(F.Times((IExpr)F.C1D2, (IExpr)S.Pi), arg1));
                        }
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Negate(F.Sin(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)S.Pi))));
                    }
                    if (t.isLT(F.C3D2)) {
                        return F.Negate(F.Cos(F.Subtract(arg1, S.Pi)));
                    }
                    return F.Sin(F.Plus(arg1, (IExpr)F.Times((IExpr)F.CN3D2, (IExpr)S.Pi)));
                }
                if (k.isIntegerResult()) {
                    return F.Times((IExpr)F.Power((IExpr)F.CN1, k), (IExpr)F.Cos(F.Subtract(arg1, F.Times(k, (IExpr)S.Pi))));
                }
            }
            if (arg1.isInterval()) {
                return IntervalSym.cos((IAST)arg1);
            }
            IExpr imPart = AbstractFunctionEvaluator.getComplexExpr(arg1, F.CNI);
            if (imPart.isPresent()) {
                return F.Cosh(imPart);
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Cos(negExpr);
            }
            if (arg1.isTimes()) {
                IAST timesAST = (IAST)arg1;
                if (timesAST.size() == 3 && timesAST.arg1().isRational() && timesAST.arg2().isPi()) {
                    IRational t = (IRational)timesAST.arg1();
                    if (t.isLT(F.C1D2)) {
                        return F.NIL;
                    }
                    if (t.isLT(F.C1)) {
                        return F.Negate(F.Cos(F.Times((IExpr)F.Subtract(F.C1, t), (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C3D2)) {
                        return F.Negate(F.Cos(F.Times((IExpr)F.Subtract(t, F.C1), (IExpr)S.Pi)));
                    }
                    if (t.isLT(F.C2)) {
                        return F.Cos(F.Times((IExpr)F.Subtract(F.C2, t), (IExpr)S.Pi));
                    }
                    return F.Cos(F.Times((IExpr)S.Pi, (IExpr)F.Plus((IExpr)t, (IExpr)ExpTrigsFunctions.integerPartFolded2(t))));
                }
                IExpr t = AbstractFunctionEvaluator.peelOfTimes(timesAST, S.Pi);
                if (t.isPresent() && t.im().isZero()) {
                    IExpr temp = engine.evaluate(F.Times((IExpr)F.C1D2, t));
                    if (temp.isIntegerResult()) {
                        return F.C1;
                    }
                    if ((temp = engine.evaluate(F.Subtract(temp, F.C1D2))).isIntegerResult()) {
                        return F.CN1;
                    }
                    if (t.isIntegerResult()) {
                        return F.Power((IExpr)F.CN1, t);
                    }
                    temp = engine.evaluate(F.Subtract(t, F.C1D2));
                    if (temp.isIntegerResult()) {
                        return F.C0;
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteExp(IExpr arg1, EvalEngine engine) {
            return F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Exp(F.Times(arg1, (IExpr)F.CI))), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Exp(F.Times((IExpr)F.CN1, arg1, (IExpr)F.CI))));
        }
    }

    private static class CirclePoints
    extends AbstractFunctionEvaluator {
        private CirclePoints() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isReal()) {
                if (arg1.isNegative()) {
                    return IOFunctions.printMessage(ast.topHead(), "noneg", F.list(arg1), engine);
                }
                int i = arg1.toIntDefault();
                if (i > 0) {
                    IExpr start = engine.evaluate(F.Plus((IExpr)F.Times((IExpr)F.QQ(1L, i), (IExpr)S.Pi), (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)S.Pi)));
                    IExpr angle = engine.evaluate(F.Times((IExpr)F.QQ(2L, i), (IExpr)S.Pi));
                    IASTAppendable result = F.ListAlloc(i);
                    for (int j = 0; j < i; ++j) {
                        result.append(F.AngleVector(F.Plus(start, F.ZZ(j).times(angle))));
                    }
                    return result;
                }
                if (i == 0) {
                    return F.CEmptyList;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class ArcTanh
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    ArcTanhRules,
    DoubleUnaryOperator {
        private ArcTanh() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return FastMath.atanh((double)operand);
        }

        @Override
        public IExpr e1ComplexArg(Complex z) {
            Complex temp = Complex.ONE.add(z).divide(Complex.ONE.subtract(z)).log();
            return F.complexNum(new Complex(temp.getReal() / 2.0, temp.getImaginary() / 2.0));
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.atanh((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.atanh((Apfloat)arg1));
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            double val = FastMath.atanh((double)arg1);
            if (Double.isNaN(val)) {
                return this.e1ComplexArg(new Complex(arg1));
            }
            return F.num(val);
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return FastMath.atanh((double)stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isInterval()) {
                return IntervalSym.arctanh((IAST)arg1);
            }
            IExpr imPart = AbstractFunctionEvaluator.getComplexExpr(arg1, F.CNI);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CI, (IExpr)F.ArcTan(imPart));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.ArcTanh(negExpr));
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, EvalEngine engine) {
            return F.Plus((IExpr)F.Times((IExpr)F.CN1D2, (IExpr)F.Log(F.Subtract(F.C1, arg1))), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Log(F.Plus((IExpr)F.C1, arg1))));
        }
    }

    private static final class ArcTan
    extends AbstractArg12
    implements INumeric,
    IRewrite,
    ArcTanRules {
        private ArcTan() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr e1ObjArg(IExpr arg1) {
            IExpr imPart = AbstractFunctionEvaluator.getComplexExpr(arg1, F.CNI);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CI, (IExpr)F.ArcTanh(imPart));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.ArcTan(negExpr));
            }
            if (arg1.isTan() && arg1.first().isPositive()) {
                return ExpTrigsFunctions.arcTanArcCotInverse(arg1);
            }
            if (arg1.isInterval()) {
                return IntervalSym.arctan((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IExpr e2ObjArg(IExpr x, IExpr y) {
            if (x.isZero() && y.isRealResult()) {
                if (y.isZero()) {
                    return S.Indeterminate;
                }
                if (y.isPositiveResult()) {
                    return F.CPiHalf;
                }
                if (y.isNegativeResult()) {
                    return F.CNPiHalf;
                }
                return F.NIL;
            }
            if (y.isZero() && x.isNumericFunction(true) && !x.isZero()) {
                return F.Times((IExpr)F.Subtract(F.C1, x.unitStep()), (IExpr)S.Pi);
            }
            IExpr yUnitStep = y.unitStep();
            if (x.isNumericFunction(true) && yUnitStep.isInteger()) {
                if (x.re().isNegative()) {
                    return F.Plus((IExpr)F.ArcTan(F.Divide(y, x)), (IExpr)F.Times((IExpr)F.Subtract(F.Times((IExpr)F.C2, yUnitStep), F.C1), (IExpr)S.Pi));
                }
                IExpr argX = x.complexArg();
                if (argX.isPresent() && F.evalTrue(F.And((IExpr)F.Less((IExpr)F.CNPiHalf, argX), (IExpr)F.LessEqual(argX, F.CPiHalf)))) {
                    return F.ArcTan(F.Divide(y, x));
                }
            }
            if (x.isInfinity()) {
                return F.C0;
            }
            if (x.isNegativeInfinity()) {
                return F.Times((IExpr)F.Subtract(F.Times((IExpr)F.C2, (IExpr)F.UnitStep(F.Re(y))), F.C1), (IExpr)S.Pi);
            }
            EvalEngine engine = EvalEngine.get();
            if (engine.isNumericMode()) {
                if (engine.isArbitraryMode()) {
                    x = engine.evalN(x);
                    y = engine.evalN(y);
                    if (x.isReal() && y.isReal()) {
                        Apfloat xa = ((ISignedNumber)x).apfloatValue();
                        Apfloat ya = ((ISignedNumber)y).apfloatValue();
                        return F.num(engine.apfloatHelper().atan2(ya, xa));
                    }
                    if (x.isNumber() && y.isNumber()) {
                        x = ((INumber)x).apcomplexNumValue();
                        y = ((INumber)y).apcomplexNumValue();
                        return y.atan2(x);
                    }
                    return F.NIL;
                }
                double xd = Double.NaN;
                double yd = Double.NaN;
                try {
                    xd = x.evalDouble();
                    yd = y.evalDouble();
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
                if (Double.isNaN(xd) || Double.isNaN(yd)) {
                    Complex xc = x.evalComplex();
                    Complex yc = y.evalComplex();
                    return F.complexNum(yc.atan2(xc));
                }
                return F.num(Math.atan2(yd, xd));
            }
            return F.NIL;
        }

        @Override
        public IExpr e1DblArg(INum arg1) {
            return F.num(Math.atan(arg1.getRealPart()));
        }

        @Override
        public IExpr e1DblComArg(IComplexNum val) {
            if (val instanceof ApcomplexNum) {
                return F.complexNum(ApcomplexMath.atan((Apcomplex)((ApcomplexNum)val).apcomplexValue()));
            }
            ComplexNum z = (ComplexNum)val;
            if (z.isNaN()) {
                return S.Indeterminate;
            }
            IComplexNum temp = ComplexNum.I.add((IComplexNum)z).divide(ComplexNum.I.subtract(z));
            IComplexNum logValue = ExpTrigsFunctions.log(temp.complexNumValue());
            return ComplexNum.I.multiply(logValue).divide(ComplexNum.valueOf(2.0, 0.0)).complexNumValue();
        }

        @Override
        public IExpr e2DblArg(INum x, INum y) {
            return F.num(Math.atan2(y.getRealPart(), x.getRealPart()));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.atan((Apfloat)arg1));
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.atan((Apcomplex)arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1 && size != 2) {
                throw new UnsupportedOperationException();
            }
            if (size == 2) {
                return Math.atan2(stack[top], stack[top - 1]);
            }
            return Math.atan(stack[top]);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, EvalEngine engine) {
            return F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.CI, (IExpr)F.Log(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CNI, arg1)))), (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)F.CI, (IExpr)F.Log(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CI, arg1)))));
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, IExpr arg2, EvalEngine engine) {
            return F.Times((IExpr)F.CNI, (IExpr)F.Log(F.Times((IExpr)F.Plus(arg1, (IExpr)F.Times((IExpr)F.CI, arg2)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Sqr(arg1), (IExpr)F.Sqr(arg2)), F.CN1D2))));
        }
    }

    private static final class ArcSinh
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    ArcSinhRules,
    DoubleUnaryOperator {
        private ArcSinh() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return FastMath.asinh((double)operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.asinh((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.asinh((Apfloat)arg1));
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            double val = FastMath.asinh((double)arg1);
            return F.num(val);
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return FastMath.asinh((double)stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isInterval()) {
                return IntervalSym.arcsinh((IAST)arg1);
            }
            IExpr imPart = AbstractFunctionEvaluator.getComplexExpr(arg1, F.CNI);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CI, (IExpr)F.ArcSin(imPart));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.ArcSinh(negExpr));
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, EvalEngine engine) {
            return F.Log(F.Plus(arg1, (IExpr)F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Sqr(arg1)))));
        }
    }

    private static final class ArcSin
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    ArcSinRules,
    DoubleUnaryOperator {
        private ArcSin() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return Math.asin(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.asin((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            if (arg1.compareTo((Apfloat)Apfloat.ONE) == 1 || arg1.compareTo((Apfloat)new Apint(-1L)) == -1) {
                return F.complexNum(ApcomplexMath.asin((Apcomplex)new Apcomplex(arg1)));
            }
            return F.num(ApfloatMath.asin((Apfloat)arg1));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.asin());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            if (arg1 > 1.0) {
                return F.complexNum(Complex.valueOf((double)arg1, (double)-0.0).asin());
            }
            if (arg1 < -1.0) {
                return F.complexNum(Complex.valueOf((double)arg1, (double)0.0).asin());
            }
            return F.num(Math.asin(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.asin(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr imPart = AbstractFunctionEvaluator.getComplexExpr(arg1, F.CNI);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CI, (IExpr)F.ArcSinh(imPart));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.ArcSin(negExpr));
            }
            if (arg1.isSin() && arg1.first().isPositive()) {
                return ExpTrigsFunctions.arcSinSin(arg1);
            }
            if (arg1.isInterval()) {
                return IntervalSym.arcsin((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, EvalEngine engine) {
            return F.Times((IExpr)F.CNI, (IExpr)F.Log(F.Plus((IExpr)F.Times((IExpr)F.CI, arg1), (IExpr)F.Sqrt(F.Subtract(F.C1, F.Sqr(arg1))))));
        }
    }

    private static final class ArcSec
    extends AbstractTrigArg1
    implements IRewrite,
    ArcSecRules {
        private ArcSec() {
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            if (arg1.equals((Object)Complex.ZERO)) {
                return F.CComplexInfinity;
            }
            return F.complexNum(Complex.ONE.divide(arg1).acos());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            if (F.isZero(arg1)) {
                return F.CComplexInfinity;
            }
            return F.num(Math.acos(1.0 / arg1));
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, EvalEngine engine) {
            return F.Plus((IExpr)F.CPiHalf, (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Log(F.Plus((IExpr)F.Sqrt(F.Subtract(F.C1, F.Power(arg1, F.CN2))), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Power(arg1, F.CN1))))));
        }
    }

    private static final class ArcSech
    extends AbstractTrigArg1
    implements IRewrite,
    ArcSechRules {
        private ArcSech() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr e1DblArg(double d) {
            if (F.isZero(d)) {
                return S.Indeterminate;
            }
            return F.num(Math.log((1.0 + Math.sqrt(1.0 - d * d)) / d));
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, EvalEngine engine) {
            return F.Log(F.Plus((IExpr)F.Times((IExpr)F.Sqrt(F.Plus((IExpr)F.CN1, (IExpr)F.Power(arg1, F.CN1))), (IExpr)F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Power(arg1, F.CN1)))), (IExpr)F.Power(arg1, F.CN1)));
        }
    }

    private static final class ArcCsch
    extends AbstractTrigArg1
    implements IRewrite,
    ArcCschRules {
        private ArcCsch() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr e1DblArg(double d) {
            return F.num(Math.log((1.0 + Math.sqrt(1.0 + d * d)) / d));
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr imPart = AbstractFunctionEvaluator.getComplexExpr(arg1, F.CI);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CI, (IExpr)F.ArcCsc(imPart));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.ArcCsch(negExpr));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, EvalEngine engine) {
            return F.Log(F.Plus((IExpr)F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Power(arg1, F.CN2))), (IExpr)F.Power(arg1, F.CN1)));
        }
    }

    private static final class ArcCsc
    extends AbstractTrigArg1
    implements IRewrite,
    ArcCscRules {
        private ArcCsc() {
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            if (arg1.equals((Object)Complex.ZERO)) {
                return F.CComplexInfinity;
            }
            return F.complexNum(Complex.ONE.divide(arg1).asin());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            if (F.isZero(arg1)) {
                return F.CComplexInfinity;
            }
            return F.num(Math.asin(1.0 / arg1));
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr imPart = AbstractFunctionEvaluator.getComplexExpr(arg1, F.CNI);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CNI, (IExpr)F.ArcCsch(imPart));
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.ArcCsc(negExpr));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, EvalEngine engine) {
            return F.Times((IExpr)F.CNI, (IExpr)F.Log(F.Plus((IExpr)F.Sqrt(F.Subtract(F.C1, F.Power(arg1, F.CN2))), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Power(arg1, F.CN1)))));
        }
    }

    private static final class ArcCoth
    extends AbstractTrigArg1
    implements IRewrite,
    ArcCothRules,
    DoubleUnaryOperator {
        private ArcCoth() {
        }

        @Override
        public double applyAsDouble(double operand) {
            if (F.isZero(operand)) {
                return Double.NaN;
            }
            double c = 1.0 / operand;
            return (Math.log(1.0 + c) - Math.log(1.0 - c)) / 2.0;
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
            Apcomplex c = h.inverseRoot(arg1, 1L);
            Apcomplex result = h.divide(h.subtract(h.log(Apcomplex.ONE.add(c)), h.log(Apcomplex.ONE.subtract(c))), (Apcomplex)new Apfloat(2L));
            return F.complexNum(result);
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
            if (arg1.equals((Object)Apcomplex.ZERO)) {
                return F.complexNum(h.divide(new Apcomplex((Apfloat)Apcomplex.ZERO, h.pi()), (Apcomplex)new Apfloat(2L)));
            }
            return F.num(h.atanh(h.inverseRoot(arg1, 1L)));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            Complex c = arg1.reciprocal();
            Complex result = new Complex(0.5).multiply(Complex.ONE.add(c).log().subtract(Complex.ONE.subtract(c).log()));
            return F.complexNum(result);
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            if (F.isZero(arg1)) {
                return F.complexNum(new Complex(0.0, Math.PI).divide(new Complex(2.0)));
            }
            if (F.isZero(arg1)) {
                return this.e1ComplexArg(new Complex(arg1));
            }
            double c = 1.0 / arg1;
            double val = (Math.log(1.0 + c) - Math.log(1.0 - c)) / 2.0;
            if (Double.isNaN(val)) {
                return this.e1ComplexArg(new Complex(arg1));
            }
            return F.num(val);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.ArcCoth(negExpr));
            }
            IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CNI, (IExpr)F.ArcCot(imPart));
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, EvalEngine engine) {
            return F.Plus((IExpr)F.Times((IExpr)F.CN1D2, (IExpr)F.Log(F.Subtract(F.C1, F.Power(arg1, F.CN1)))), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Log(F.Plus((IExpr)F.C1, (IExpr)F.Power(arg1, F.CN1)))));
        }
    }

    private static final class ArcCot
    extends AbstractTrigArg1
    implements IRewrite,
    ArcCotRules,
    DoubleUnaryOperator {
        private ArcCot() {
        }

        @Override
        public double applyAsDouble(double operand) {
            if (F.isZero(operand)) {
                return 1.5707963267948966;
            }
            return Math.atan(1.0 / operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            Apcomplex ac = Apcomplex.I.divide(arg1);
            Apcomplex result = Apcomplex.I.divide((Apcomplex)new Apfloat(2L)).multiply(ApcomplexMath.log((Apcomplex)Apcomplex.ONE.subtract(ac)).subtract(ApcomplexMath.log((Apcomplex)Apcomplex.ONE.add(ac))));
            return F.complexNum(result);
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            if (arg1.equals((Object)Apcomplex.ZERO)) {
                return F.num(ApfloatMath.pi((long)arg1.precision()).divide(new Apfloat(2L)));
            }
            return F.num(ApfloatMath.atan((Apfloat)ApfloatMath.inverseRoot((Apfloat)arg1, (long)1L)));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            Complex c = Complex.I.divide(arg1);
            Complex result = Complex.I.divide(new Complex(2.0)).multiply(Complex.ONE.subtract(c).log().subtract(Complex.ONE.add(c).log()));
            return F.complexNum(result);
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            if (F.isZero(arg1)) {
                return F.num(1.5707963267948966);
            }
            return F.num(Math.atan(1.0 / arg1));
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Plus(F.Negate(F.ArcCot(negExpr)));
            }
            IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1);
            if (imPart.isPresent()) {
                return F.Times((IExpr)F.CNI, (IExpr)F.ArcCoth(imPart));
            }
            if (arg1.isAST(S.Cot, 2) && arg1.first().isPositive()) {
                return ExpTrigsFunctions.arcTanArcCotInverse(arg1);
            }
            if (arg1.isInterval()) {
                return IntervalSym.arccot((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, EvalEngine engine) {
            return F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.CI, (IExpr)F.Log(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CNI, (IExpr)F.Power(arg1, F.CN1))))), (IExpr)F.Times((IExpr)F.CN1D2, (IExpr)F.CI, (IExpr)F.Log(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Power(arg1, F.CN1))))));
        }
    }

    private static final class ArcCosh
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    ArcCoshRules,
    DoubleUnaryOperator {
        private ArcCosh() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return FastMath.acosh((double)operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.acosh((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            double re = arg1.getReal();
            double im = arg1.getImaginary();
            Complex temp = new Complex(re * re - im * im - 1.0, 2.0 * re * im).sqrt();
            return F.complexNum(new Complex(temp.getReal() + re, temp.getImaginary() + im).log());
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.acosh((Apfloat)arg1));
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            double val = FastMath.acosh((double)arg1);
            if (Double.isNaN(val)) {
                return this.e1ComplexArg(new Complex(arg1));
            }
            return F.num(val);
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return FastMath.acosh((double)stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isInterval()) {
                return IntervalSym.arccosh((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, EvalEngine engine) {
            return F.Log(F.Plus(arg1, (IExpr)F.Times((IExpr)F.Sqrt(F.Plus((IExpr)F.CN1, arg1)), (IExpr)F.Sqrt(F.Plus((IExpr)F.C1, arg1)))));
        }
    }

    private static final class ArcCos
    extends AbstractTrigArg1
    implements INumeric,
    IRewrite,
    ArcCosRules,
    DoubleUnaryOperator {
        private ArcCos() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return Math.acos(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.complexNum(ApcomplexMath.acos((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            if (arg1.compareTo((Apfloat)Apfloat.ONE) == 1 || arg1.compareTo((Apfloat)new Apint(-1L)) == -1) {
                return F.complexNum(ApcomplexMath.acos((Apcomplex)new Apcomplex(arg1)));
            }
            return F.num(ApfloatMath.acos((Apfloat)arg1));
        }

        @Override
        public IExpr e1ComplexArg(Complex arg1) {
            return F.complexNum(arg1.acos());
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            if (arg1 > 1.0 || arg1 < -1.0) {
                return F.complexNum(Complex.valueOf((double)arg1).acos());
            }
            return F.num(Math.acos(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.acos(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            if (arg1.isCos() && arg1.first().isPositive()) {
                return ExpTrigsFunctions.arcCosCos(arg1);
            }
            if (arg1.isInterval()) {
                return IntervalSym.arccos((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        @Override
        public IExpr rewriteLog(IExpr arg1, EvalEngine engine) {
            return F.Plus((IExpr)F.CPiHalf, (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Log(F.Plus((IExpr)F.Times((IExpr)F.CI, arg1), (IExpr)F.Sqrt(F.Subtract(F.C1, F.Sqr(arg1)))))));
        }
    }

    private static final class AngleVector
    extends AbstractFunctionEvaluator {
        private AngleVector() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.first();
            if (ast.isAST2()) {
                IExpr arg2 = ast.second();
                if (arg1.isAST(S.List, 3)) {
                    IExpr x = arg1.first();
                    IExpr y = arg1.second();
                    if (arg2.isAST(S.List, 3)) {
                        IExpr r = arg2.first();
                        IExpr phi = arg2.second();
                        return F.list(F.Plus(x, (IExpr)F.Times(r, (IExpr)F.Cos(phi))), F.Plus(y, (IExpr)F.Times(r, (IExpr)F.Sin(phi))));
                    }
                    IExpr phi = arg2;
                    return F.list(F.Plus(x, (IExpr)F.Cos(phi)), F.Plus(y, (IExpr)F.Sin(phi)));
                }
                return F.NIL;
            }
            if (arg1.isAST(S.List, 3)) {
                IExpr r = ((IAST)arg1).arg1();
                IExpr phi = ((IAST)arg1).arg2();
                return F.list(F.Times(r, (IExpr)F.Cos(phi)), F.Times(r, (IExpr)F.Sin(phi)));
            }
            IExpr phi = arg1;
            return F.list(F.Cos(phi), F.Sin(phi));
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.AngleVector.setEvaluator(new AngleVector());
            S.ArcCos.setEvaluator(new ArcCos());
            S.ArcCosh.setEvaluator(new ArcCosh());
            S.ArcCot.setEvaluator(new ArcCot());
            S.ArcCoth.setEvaluator(new ArcCoth());
            S.ArcCsc.setEvaluator(new ArcCsc());
            S.ArcCsch.setEvaluator(new ArcCsch());
            S.ArcSec.setEvaluator(new ArcSec());
            S.ArcSech.setEvaluator(new ArcSech());
            S.ArcSin.setEvaluator(new ArcSin());
            S.ArcSinh.setEvaluator(new ArcSinh());
            S.ArcTan.setEvaluator(new ArcTan());
            S.ArcTanh.setEvaluator(new ArcTanh());
            S.CirclePoints.setEvaluator(new CirclePoints());
            S.Cos.setEvaluator(new Cos());
            S.Cosh.setEvaluator(new Cosh());
            S.Cot.setEvaluator(new Cot());
            S.Coth.setEvaluator(new Coth());
            S.Csc.setEvaluator(new Csc());
            S.Csch.setEvaluator(new Csch());
            S.Exp.setEvaluator(new Exp());
            S.Gudermannian.setEvaluator(new Gudermannian());
            S.Haversine.setEvaluator(new Haversine());
            S.InverseGudermannian.setEvaluator(new InverseGudermannian());
            S.InverseHaversine.setEvaluator(new InverseHaversine());
            S.LambertW.setEvaluator(new LambertW());
            S.Log.setEvaluator(new Log());
            S.LogisticSigmoid.setEvaluator(new LogisticSigmoid());
            S.Log10.setEvaluator(new Log10());
            S.Log2.setEvaluator(new Log2());
            S.Sec.setEvaluator(new Sec());
            S.Sech.setEvaluator(new Sech());
            S.Sin.setEvaluator(new Sin());
            S.Sinc.setEvaluator(new Sinc());
            S.Sinh.setEvaluator(new Sinh());
            S.Tan.setEvaluator(new Tan());
            S.Tanh.setEvaluator(new Tanh());
        }
    }
}

