/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.complex.Complex;
import org.hipparchus.special.elliptic.carlson.CarlsonEllipticIntegral;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.functions.EllipticFunctionsJS;
import org.matheclipse.core.builtin.functions.EllipticIntegralsJS;
import org.matheclipse.core.convert.Object2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.JacobiSCRules;
import org.matheclipse.core.reflection.system.rules.KleinInvariantJRules;

public class EllipticIntegrals {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void initialize() {
        Initializer.init();
    }

    private EllipticIntegrals() {
    }

    private static class WeierstrassPPrime
    extends AbstractFunctionEvaluator {
        private WeierstrassPPrime() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr u = ast.arg1();
            if (u.isZero()) {
                return F.CComplexInfinity;
            }
            if (ast.arg2().isList2()) {
                IAST list = (IAST)ast.arg2();
                IExpr g2 = list.arg1();
                IExpr g3 = list.arg2();
                if (g2.isZero() && g3.isZero()) {
                    return F.Times((IExpr)F.CN2, (IExpr)F.Power(u, F.CN3));
                }
                if (g2.isNumEqualInteger(F.C3) && g3.isOne()) {
                    return F.Times(F.CN3, F.Sqrt(F.C3D2), F.Cot(F.Times((IExpr)F.Sqrt(F.C3D2), u)), F.Sqr(F.Csc(F.Times((IExpr)F.Sqrt(F.C3D2), u))));
                }
                if (u.isInexactNumber() && g2.isInexactNumber() && g3.isInexactNumber()) {
                    try {
                        return F.complexNum(EllipticFunctionsJS.weierstrassPPrime(u.evalComplex(), g2.evalComplex(), g3.evalComplex()));
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static class WeierstrassP
    extends AbstractFunctionEvaluator {
        private WeierstrassP() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr u = ast.arg1();
            if (u.isZero()) {
                return F.CComplexInfinity;
            }
            if (ast.arg2().isList2()) {
                IAST list = (IAST)ast.arg2();
                IExpr g2 = list.arg1();
                IExpr g3 = list.arg2();
                if (g2.isZero() && g3.isZero()) {
                    return F.Power(u, F.CN2);
                }
                if (g2.isNumEqualInteger(F.C3) && g3.isOne()) {
                    return F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.C3D2, (IExpr)F.Sqr(F.Cot(F.Times((IExpr)F.Sqrt(F.C3D2), u)))));
                }
                if (u.isInexactNumber() && g2.isInexactNumber() && g3.isInexactNumber()) {
                    try {
                        return F.complexNum(EllipticFunctionsJS.weierstrassP(u.evalComplex(), g2.evalComplex(), g3.evalComplex()));
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static class WeierstrassInvariants
    extends AbstractFunctionEvaluator {
        private WeierstrassInvariants() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList2()) {
                IAST list = (IAST)ast.arg1();
                IExpr g2 = list.arg1();
                IExpr g3 = list.arg2();
                if (g2.isInexactNumber() && g3.isInexactNumber()) {
                    try {
                        Complex[] invariants = EllipticFunctionsJS.weierstrassInvariants(g2.evalComplex(), g3.evalComplex());
                        return Object2Expr.convertComplex(false, invariants);
                    }
                    catch (ValidateException ve) {
                        return IOFunctions.printMessage(ast.topHead(), ve, engine);
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static class WeierstrassHalfPeriods
    extends AbstractFunctionEvaluator {
        private WeierstrassHalfPeriods() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList2()) {
                IAST list = (IAST)ast.arg1();
                IExpr g2 = list.arg1();
                IExpr g3 = list.arg2();
                if (g2.isInexactNumber() && g3.isInexactNumber()) {
                    try {
                        Complex[] invariants = EllipticFunctionsJS.weierstrassHalfPeriods(g2.evalComplex(), g3.evalComplex());
                        return Object2Expr.convertComplex(false, invariants);
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static class KleinInvariantJ
    extends AbstractFunctionEvaluator
    implements KleinInvariantJRules {
        private KleinInvariantJ() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr t = ast.arg1();
            IExpr im = S.Im.of(engine, t);
            if (im.isZero()) {
                return F.NIL;
            }
            if (im.isOne()) {
                IExpr re = S.Re.of(engine, t);
                if (re.isInteger()) {
                    return F.C1;
                }
                int r = re.toIntDefault();
                if (r != Integer.MIN_VALUE) {
                    return F.C1;
                }
            }
            if (engine.isDoubleMode()) {
                try {
                    double tDouble = Double.NaN;
                    try {
                        tDouble = t.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(tDouble)) {
                        Complex tComplex = t.evalComplex();
                        return F.complexNum(EllipticIntegralsJS.kleinJ(tComplex));
                    }
                    return F.complexNum(EllipticIntegralsJS.kleinJ(tDouble));
                }
                catch (ArithmeticException ae) {
                    return F.NIL;
                }
                catch (ValidateException ve) {
                    LOGGER.debug("KleinInvariantJ.evaluate() failed", (Throwable)((Object)ve));
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class JacobiZeta
    extends AbstractFunctionEvaluator {
        private JacobiZeta() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            IExpr m = ast.arg2();
            if (m.isZero()) {
                return F.C0;
            }
            if (z.isZero()) {
                return F.C0;
            }
            if (z.equals(F.CPiHalf)) {
                return F.C0;
            }
            if (m.isOne() && engine.evalLessEqual(F.Abs(F.Re(z)), F.CPiHalf)) {
                return F.Sin(z);
            }
            if (m.isInfinity() || m.isNegativeInfinity()) {
                return F.CComplexInfinity;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class JacobiSN
    extends AbstractFunctionEvaluator {
        private JacobiSN() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            IExpr m = ast.arg2();
            if (m.isZero()) {
                return F.Sin(z);
            }
            if (m.isOne()) {
                return F.Tanh(z);
            }
            if (z.isZero()) {
                return F.C0;
            }
            if (engine.isDoubleMode()) {
                try {
                    double zDouble = Double.NaN;
                    double mDouble = Double.NaN;
                    try {
                        zDouble = z.evalDouble();
                        mDouble = m.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(zDouble) || Double.isNaN(mDouble)) {
                        return F.complexNum(EllipticFunctionsJS.jacobiSN(z.evalComplex(), m.evalComplex()));
                    }
                    return F.num(EllipticFunctionsJS.jacobiSN(zDouble, mDouble));
                }
                catch (ValidateException ve) {
                    LOGGER.debug("JacobiSN.evaluate() failed", (Throwable)((Object)ve));
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class JacobiSD
    extends AbstractFunctionEvaluator {
        private JacobiSD() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            IExpr m = ast.arg2();
            if (m.isZero()) {
                return F.Sin(z);
            }
            if (m.isOne()) {
                return F.Sinh(z);
            }
            if (z.isZero()) {
                return F.C0;
            }
            if (engine.isDoubleMode()) {
                try {
                    double zDouble = Double.NaN;
                    double mDouble = Double.NaN;
                    try {
                        zDouble = z.evalDouble();
                        mDouble = m.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(zDouble) || Double.isNaN(mDouble)) {
                        return F.complexNum(EllipticFunctionsJS.jacobiSD(z.evalComplex(), m.evalComplex()));
                    }
                    return F.num(EllipticFunctionsJS.jacobiSD(zDouble, mDouble));
                }
                catch (ValidateException ve) {
                    LOGGER.debug("JacobiSD.evaluate() failed", (Throwable)((Object)ve));
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class JacobiSC
    extends AbstractFunctionEvaluator
    implements JacobiSCRules {
        private JacobiSC() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            IExpr m = ast.arg2();
            if (m.isZero()) {
                return F.Tan(z);
            }
            if (m.isOne()) {
                return F.Sinh(z);
            }
            if (z.isZero()) {
                return F.C0;
            }
            if (engine.isDoubleMode()) {
                try {
                    double zDouble = Double.NaN;
                    double mDouble = Double.NaN;
                    try {
                        zDouble = z.evalDouble();
                        mDouble = m.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(zDouble) || Double.isNaN(mDouble)) {
                        return F.complexNum(EllipticFunctionsJS.jacobiSC(z.evalComplex(), m.evalComplex()));
                    }
                    return F.num(EllipticFunctionsJS.jacobiSC(zDouble, mDouble));
                }
                catch (ValidateException ve) {
                    LOGGER.debug("JacobiSC.evaluate() failed", (Throwable)((Object)ve));
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class JacobiDN
    extends AbstractFunctionEvaluator {
        private JacobiDN() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            IExpr m = ast.arg2();
            if (m.isZero()) {
                return F.C1;
            }
            if (m.isOne()) {
                return F.Sech(z);
            }
            if (z.isZero()) {
                return F.C1;
            }
            try {
                double zDouble = Double.NaN;
                double mDouble = Double.NaN;
                try {
                    zDouble = z.evalDouble();
                    mDouble = m.evalDouble();
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
                if (Double.isNaN(zDouble) || Double.isNaN(mDouble)) {
                    return F.complexNum(EllipticFunctionsJS.jacobiDN(z.evalComplex(), m.evalComplex()));
                }
                return F.num(EllipticFunctionsJS.jacobiDN(zDouble, mDouble));
            }
            catch (ValidateException ve) {
                LOGGER.debug("JacobiDN.evaluate() failed", (Throwable)((Object)ve));
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class JacobiCN
    extends AbstractFunctionEvaluator {
        private JacobiCN() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            IExpr m = ast.arg2();
            if (m.isZero()) {
                return F.Cos(z);
            }
            if (m.isOne()) {
                return F.Sech(z);
            }
            if (z.isZero()) {
                return F.C1;
            }
            try {
                double zDouble = Double.NaN;
                double mDouble = Double.NaN;
                try {
                    zDouble = z.evalDouble();
                    mDouble = m.evalDouble();
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
                if (Double.isNaN(zDouble) || Double.isNaN(mDouble)) {
                    return F.complexNum(EllipticFunctionsJS.jacobiCN(z.evalComplex(), m.evalComplex()));
                }
                return F.num(EllipticFunctionsJS.jacobiCN(zDouble, mDouble));
            }
            catch (ValidateException ve) {
                LOGGER.debug("JacobiCN.evaluate() failed", (Throwable)((Object)ve));
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class JacobiCD
    extends AbstractFunctionEvaluator {
        private JacobiCD() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            IExpr m = ast.arg2();
            if (m.isZero()) {
                return F.Cos(z);
            }
            if (m.isOne() || z.isZero()) {
                return F.C1;
            }
            try {
                double zDouble = Double.NaN;
                double mDouble = Double.NaN;
                try {
                    zDouble = z.evalDouble();
                    mDouble = m.evalDouble();
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
                if (Double.isNaN(zDouble) || Double.isNaN(mDouble)) {
                    return F.complexNum(EllipticFunctionsJS.jacobiCD(z.evalComplex(), m.evalComplex()));
                }
                return F.num(EllipticFunctionsJS.jacobiCD(zDouble, mDouble));
            }
            catch (ValidateException ve) {
                LOGGER.debug("JacobiCD.evaluate() failed", (Throwable)((Object)ve));
            }
            catch (RuntimeException rex) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class JacobiAmplitude
    extends AbstractFunctionEvaluator {
        private JacobiAmplitude() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            IExpr m = ast.arg2();
            if (m.isZero()) {
                return z;
            }
            if (m.isOne()) {
                return F.Plus((IExpr)F.CNPiHalf, (IExpr)F.Times(2L, F.ArcTan(F.Power((IExpr)S.E, z))));
            }
            if (z.isZero()) {
                return F.C0;
            }
            if (F.EllipticK(m).equals(z)) {
                return F.CPiHalf;
            }
            if (z.isInexactNumber() && m.isInexactNumber()) {
                try {
                    if (z.isReal() && m.isReal()) {
                        return F.complexNum(EllipticFunctionsJS.jacobiAmplitude(z.evalDouble(), m.evalDouble()));
                    }
                    return F.complexNum(EllipticFunctionsJS.jacobiAmplitude(z.evalComplex(), m.evalComplex()));
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(z);
            if (negExpr.isPresent()) {
                return F.Negate(F.JacobiAmplitude(negExpr, m));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class EllipticTheta
    extends AbstractFunctionEvaluator {
        private EllipticTheta() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            int a = n.toIntDefault();
            if (ast.isAST3()) {
                IExpr x = ast.arg2();
                IExpr m = ast.arg3();
                if (a >= 1 && a <= 4) {
                    if (m.isZero()) {
                        switch (a) {
                            case 1: 
                            case 2: {
                                return F.C0;
                            }
                            case 3: 
                            case 4: {
                                return F.C1;
                            }
                        }
                    } else if (a == 1 && (x.isZero() || x.isPi() && m.isNumEqualRational(F.C1D2))) {
                        return F.C0;
                    }
                    if (x.isReal() && m.isReal()) {
                        try {
                            return F.complexNum(EllipticFunctionsJS.jacobiTheta(a, x.evalDouble(), m.evalDouble()));
                        }
                        catch (RuntimeException rex) {
                            LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                        }
                    } else if (x.isInexactNumber() && m.isInexactNumber()) {
                        try {
                            return F.complexNum(EllipticFunctionsJS.jacobiTheta(a, x.evalComplex(), m.evalComplex()));
                        }
                        catch (ValidateException ve) {
                            return IOFunctions.printMessage(ast.topHead(), ve, engine);
                        }
                        catch (RuntimeException rex) {
                            LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                        }
                    }
                }
                return F.NIL;
            }
            IExpr m = ast.arg2();
            if (a >= 1 && a <= 4) {
                if (m.isZero()) {
                    switch (a) {
                        case 1: 
                        case 2: {
                            return F.C0;
                        }
                        case 3: 
                        case 4: {
                            return F.C1;
                        }
                    }
                }
                if (m.isReal()) {
                    try {
                        return F.complexNum(EllipticFunctionsJS.jacobiTheta(a, 0.0, m.evalDouble()));
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    }
                } else if (m.isInexactNumber()) {
                    try {
                        return F.complexNum(EllipticFunctionsJS.jacobiTheta(a, Complex.ZERO, m.evalComplex()));
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(9728);
            super.setUp(newSymbol);
        }
    }

    private static class EllipticPi
    extends AbstractFunctionEvaluator {
        private EllipticPi() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            if (ast.isAST3()) {
                IExpr z = ast.arg2();
                IExpr m = ast.arg3();
                if (engine.isDoubleMode()) {
                    try {
                        double nDouble = Double.NaN;
                        double zDouble = Double.NaN;
                        double mDouble = Double.NaN;
                        try {
                            nDouble = n.evalDouble();
                            zDouble = z.evalDouble();
                            mDouble = m.evalDouble();
                        }
                        catch (ValidateException validateException) {
                            // empty catch block
                        }
                        if (Double.isNaN(nDouble) || Double.isNaN(zDouble) || Double.isNaN(mDouble)) {
                            Complex nc = n.evalComplex();
                            Complex zc = z.evalComplex();
                            Complex mc = m.evalComplex();
                            return F.complexNum(EllipticIntegralsJS.ellipticPi(nc, zc, mc));
                        }
                        return F.complexNum(EllipticIntegralsJS.ellipticPi(nDouble, zDouble, mDouble));
                    }
                    catch (ValidateException ve) {
                        LOGGER.debug("EllipticPi.evaluate() failed", (Throwable)((Object)ve));
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                        return F.NIL;
                    }
                }
                if (z.equals(F.CPiHalf)) {
                    if (n.isZero()) {
                        return F.EllipticK(ast.arg3());
                    }
                    if (n.equals(ast.arg3())) {
                        return F.Times(F.Power((IExpr)F.Plus((IExpr)F.C1, F.Negate(n)), -1L), (IExpr)F.EllipticE(n));
                    }
                    return F.EllipticPi(n, ast.arg3());
                }
                if (n.isZero()) {
                    return F.EllipticF(z, ast.arg3());
                }
                return F.NIL;
            }
            IExpr m = ast.arg2();
            if (n.isZero()) {
                return F.EllipticK(m);
            }
            if (n.isOne()) {
                return F.CComplexInfinity;
            }
            if (m.isZero()) {
                return F.Times((IExpr)F.C1D2, (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, F.Negate(n)), F.CN1D2), (IExpr)S.Pi);
            }
            if (m.isOne()) {
                return F.Times((IExpr)F.oo, F.Power((IExpr)F.Sign(F.Plus((IExpr)F.C1, F.Negate(n))), -1L));
            }
            if (n.equals(m)) {
                return F.Times(F.Power((IExpr)F.Plus((IExpr)F.C1, F.Negate(n)), -1L), (IExpr)F.EllipticE(n));
            }
            if (engine.isDoubleMode()) {
                try {
                    double nDouble = Double.NaN;
                    double mDouble = Double.NaN;
                    try {
                        nDouble = n.evalDouble();
                        mDouble = m.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(nDouble) || Double.isNaN(mDouble)) {
                        Complex nc = n.evalComplex();
                        Complex mc = m.evalComplex();
                        return F.complexNum(EllipticIntegralsJS.ellipticPi(nc, new Complex(1.5707963267948966), mc));
                    }
                    return F.complexNum(EllipticIntegralsJS.ellipticPi(nDouble, 1.5707963267948966, mDouble));
                }
                catch (ValidateException ve) {
                    LOGGER.debug("EllipticPi.evaluate() failed", (Throwable)((Object)ve));
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class EllipticK
    extends AbstractFunctionEvaluator {
        private EllipticK() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr m = ast.arg1();
            if (m.isInfinity() || m.isNegativeInfinity() || m.isDirectedInfinity(F.CI) || m.isDirectedInfinity(F.CNI)) {
                return F.C0;
            }
            if (m.isZero()) {
                return F.CPiHalf;
            }
            if (m.isOne()) {
                return F.CComplexInfinity;
            }
            if (m.isMinusOne()) {
                return F.Times(F.C1D4, F.C1DSqrt2, F.Power((IExpr)S.Pi, F.CN1D2), F.Sqr(F.Gamma(F.C1D4)));
            }
            if (m.isNumEqualRational(F.C1D2)) {
                return F.Times((IExpr)F.C8, (IExpr)F.Power((IExpr)S.Pi, F.QQ(3L, 2L)), F.Power((IExpr)F.Gamma(F.CN1D4), -2L));
            }
            if (engine.isDoubleMode()) {
                try {
                    double mDouble = Double.NaN;
                    try {
                        mDouble = m.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(mDouble)) {
                        Complex mComplex = m.evalComplex();
                        return F.complexNum(EllipticIntegralsJS.ellipticK(mComplex));
                    }
                    return F.complexNum(EllipticIntegralsJS.ellipticK(mDouble));
                }
                catch (ValidateException ve) {
                    LOGGER.debug("EllipticK.evaluate() failed", (Throwable)((Object)ve));
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            if (m.isNumber()) {
                return F.Times((IExpr)F.C1D2, (IExpr)S.Pi, F.Power((IExpr)F.ArithmeticGeometricMean(F.C1, F.Sqrt(F.Plus((IExpr)F.C1, F.Negate(m)))), -1L));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class EllipticF
    extends AbstractFunctionEvaluator {
        private EllipticF() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr k;
            IExpr negExpr;
            IRational k2;
            IExpr z = ast.arg1();
            IExpr m = ast.arg2();
            if (z.isZero() || m.isInfinity() || m.isNegativeInfinity()) {
                return F.C0;
            }
            if (m.isZero()) {
                return z;
            }
            if (z.equals(F.CPiHalf)) {
                return F.EllipticK(m);
            }
            if (z.isTimes() && z.second().equals(S.Pi) && z.first().isRational() && (k2 = ((IRational)z.first()).multiply(F.C2).normalize()).isInteger()) {
                return F.Times((IExpr)k2, (IExpr)F.EllipticK(m));
            }
            if (m.isOne()) {
                IExpr temp = engine.evaluate(F.Abs(F.Re(z)));
                if (S.LessEqual.ofQ(engine, temp, F.CPiHalf)) {
                    return F.Log(F.Plus((IExpr)F.Sec(z), (IExpr)F.Tan(z)));
                }
                if (S.Greater.ofQ(engine, temp, F.CPiHalf)) {
                    return F.CComplexInfinity;
                }
            }
            if (engine.isDoubleMode()) {
                try {
                    double zDouble = Double.NaN;
                    double mDouble = Double.NaN;
                    try {
                        zDouble = z.evalDouble();
                        mDouble = m.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(zDouble) || Double.isNaN(mDouble)) {
                        Complex zc = z.evalComplex();
                        Complex mc = m.evalComplex();
                        return F.complexNum(EllipticIntegralsJS.ellipticF(zc, mc));
                    }
                    return F.complexNum(EllipticIntegralsJS.ellipticF(zDouble, mDouble));
                }
                catch (ValidateException ve) {
                    LOGGER.debug("EllipticF.evaluate() failed", (Throwable)((Object)ve));
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            if ((negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(z)).isPresent()) {
                return F.Negate(F.EllipticF(negExpr, m));
            }
            IAST parts = AbstractFunctionEvaluator.getPeriodicParts(z, S.Pi);
            if (parts.isPresent() && (k = parts.arg2()).isInteger()) {
                IExpr zz = parts.arg1();
                return F.Plus((IExpr)F.EllipticF(zz, m), (IExpr)F.Times((IExpr)F.C2, k, (IExpr)F.EllipticK(m)));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class EllipticE
    extends AbstractFunctionEvaluator {
        private EllipticE() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (ast.isAST2()) {
                IExpr negExpr;
                IExpr m = ast.arg2();
                if (m.isZero()) {
                    return z;
                }
                if (z.isZero()) {
                    return F.C0;
                }
                if (m.isOne() && engine.evalLessEqual(F.Abs(F.Re(z)), F.CPiHalf)) {
                    return F.Sin(z);
                }
                if (m.isInfinity() || m.isNegativeInfinity()) {
                    return F.CComplexInfinity;
                }
                if (z.equals(F.CPiHalf)) {
                    return F.EllipticE(m);
                }
                if (engine.isDoubleMode()) {
                    try {
                        double zDouble = Double.NaN;
                        double mDouble = Double.NaN;
                        try {
                            zDouble = z.evalDouble();
                            mDouble = m.evalDouble();
                        }
                        catch (ValidateException validateException) {
                            // empty catch block
                        }
                        if (Double.isNaN(zDouble) || Double.isNaN(mDouble)) {
                            Complex zc = z.evalComplex();
                            Complex mc = m.evalComplex();
                            return F.complexNum(EllipticIntegralsJS.ellipticE(zc, mc));
                        }
                        return F.complexNum(EllipticIntegralsJS.ellipticE(zDouble, mDouble));
                    }
                    catch (ValidateException ve) {
                        LOGGER.debug("EllipticE.evaluate() failed", (Throwable)((Object)ve));
                    }
                    catch (RuntimeException rex) {
                        LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                        return F.NIL;
                    }
                }
                if ((negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(z)).isPresent()) {
                    return F.Negate(F.EllipticE(negExpr, m));
                }
                return F.NIL;
            }
            if (z.isZero()) {
                return F.CPiHalf;
            }
            if (z.isOne()) {
                return F.C1;
            }
            if (z.isNumEqualRational(F.C1D2)) {
                return F.Times(F.C1D4, F.Power((IExpr)S.Pi, F.CN1D2), F.Power((IExpr)F.Gamma(F.QQ(3L, 4L)), -2L), F.Plus((IExpr)F.Sqr(S.Pi), (IExpr)F.Times((IExpr)F.C2, F.Power((IExpr)F.Gamma(F.QQ(3L, 4L)), 4L))));
            }
            if (z.isMinusOne()) {
                return F.Times(F.C1D2, F.C1DSqrt2, F.Power((IExpr)S.Pi, F.CN1D2), F.Power((IExpr)F.Gamma(F.QQ(3L, 4L)), -2L), F.Plus((IExpr)F.Sqr(S.Pi), (IExpr)F.Times((IExpr)F.C2, F.Power((IExpr)F.Gamma(F.QQ(3L, 4L)), 4L))));
            }
            if (engine.isDoubleMode()) {
                try {
                    double zDouble = Double.NaN;
                    try {
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(zDouble)) {
                        Complex zc = z.evalComplex();
                        return F.complexNum(EllipticIntegralsJS.ellipticE(new Complex(1.5707963267948966), zc));
                    }
                    return F.complexNum(EllipticIntegralsJS.ellipticE(1.5707963267948966, zDouble));
                }
                catch (ValidateException ve) {
                    LOGGER.debug("EllipticE.evaluate() failed", (Throwable)((Object)ve));
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            if (z.isInfinity() || z.isNegativeInfinity() || z.isComplexInfinity()) {
                return F.CComplexInfinity;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class CarlsonRJ
    extends AbstractFunctionEvaluator {
        private CarlsonRJ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr x = ast.arg1();
            IExpr y = ast.arg2();
            IExpr z = ast.arg3();
            IExpr p = ast.arg4();
            if (engine.isDoubleMode()) {
                try {
                    double xd = Double.NaN;
                    double yd = Double.NaN;
                    double zd = Double.NaN;
                    double pd = Double.NaN;
                    try {
                        xd = x.evalDouble();
                        yd = y.evalDouble();
                        zd = z.evalDouble();
                        pd = p.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(xd) || Double.isNaN(yd) || Double.isNaN(zd) || Double.isNaN(pd)) {
                        Complex xc = x.evalComplex();
                        Complex yc = y.evalComplex();
                        Complex zc = z.evalComplex();
                        Complex pc = p.evalComplex();
                        return F.complexNum(EllipticIntegralsJS.carlsonRJ(xc, yc, zc, pc));
                    }
                    return F.num(EllipticIntegralsJS.carlsonRJ(xd, yd, zd, pd));
                }
                catch (ValidateException ve) {
                    LOGGER.debug("CarlsonRJ.evaluate() failed", (Throwable)((Object)ve));
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_4_4;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static class CarlsonRG
    extends AbstractFunctionEvaluator {
        private CarlsonRG() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr x = ast.arg1();
            IExpr y = ast.arg2();
            IExpr z = ast.arg3();
            if (x.equals(y)) {
                if (x.equals(z)) {
                    return F.Power.of(engine, x, F.CN1D2);
                }
                return S.Times.of(engine, F.C1D2, F.Plus((IExpr)F.Sqrt(z), (IExpr)F.Times(x, (IExpr)F.CarlsonRF(x, x, z))));
            }
            if (engine.isDoubleMode()) {
                try {
                    double xd = Double.NaN;
                    double yd = Double.NaN;
                    double zd = Double.NaN;
                    try {
                        xd = x.evalDouble();
                        yd = y.evalDouble();
                        zd = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(xd) || Double.isNaN(yd) || Double.isNaN(zd)) {
                        Complex xc = x.evalComplex();
                        Complex yc = y.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(EllipticIntegralsJS.carlsonRG(xc, yc, zc));
                    }
                    return F.num(EllipticIntegralsJS.carlsonRG(xd, yd, zd));
                }
                catch (ValidateException ve) {
                    LOGGER.debug("CarlsonRG.evaluate() failed", (Throwable)((Object)ve));
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static class CarlsonRF
    extends AbstractFunctionEvaluator {
        private CarlsonRF() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr x = ast.arg1();
            IExpr y = ast.arg2();
            IExpr z = ast.arg3();
            if (x.equals(y) && x.equals(z)) {
                return F.Power.of(engine, x, F.CN1D2);
            }
            if (engine.isDoubleMode()) {
                double xd = Double.NaN;
                double yd = Double.NaN;
                double zd = Double.NaN;
                try {
                    xd = x.evalDouble();
                    yd = y.evalDouble();
                    zd = z.evalDouble();
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
                if (Double.isNaN(xd) || Double.isNaN(yd) || Double.isNaN(zd)) {
                    Complex xc = x.evalComplex();
                    Complex yc = y.evalComplex();
                    Complex zc = z.evalComplex();
                    return F.complexNum(EllipticIntegralsJS.carlsonRF(xc, yc, zc));
                }
                return F.num(EllipticIntegralsJS.carlsonRF(xd, yd, zd));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static class CarlsonRD
    extends AbstractFunctionEvaluator {
        private CarlsonRD() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr x = ast.arg1();
            IExpr y = ast.arg2();
            IExpr z = ast.arg3();
            if (engine.isDoubleMode()) {
                double xd = Double.NaN;
                double yd = Double.NaN;
                double zd = Double.NaN;
                try {
                    xd = x.evalDouble();
                    yd = y.evalDouble();
                    zd = z.evalDouble();
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
                if (Double.isNaN(xd) || Double.isNaN(yd) || Double.isNaN(zd)) {
                    Complex xc = x.evalComplex();
                    Complex yc = y.evalComplex();
                    Complex zc = z.evalComplex();
                    return F.complexNum(EllipticIntegralsJS.carlsonRD(xc, yc, zc));
                }
                return F.num(EllipticIntegralsJS.carlsonRD(xd, yd, zd));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static class CarlsonRC
    extends AbstractFunctionEvaluator {
        private CarlsonRC() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr y;
            IExpr x = ast.arg1();
            if (x.equals(y = ast.arg2())) {
                IExpr reCondition = S.LessEqual.of(engine, F.Re(x), F.C0);
                IExpr imCondition = S.Equal.of(engine, F.Im(x), F.C0);
                if (reCondition.isTrue() && imCondition.isTrue()) {
                    return F.CComplexInfinity;
                }
                if (reCondition.isFalse() || imCondition.isFalse()) {
                    return F.Power.of(engine, x, F.CN1D2);
                }
                return F.Piecewise(F.list(F.list(F.CComplexInfinity, F.And((IExpr)F.LessEqual(F.Re(x), F.C0), (IExpr)F.Equal(F.Im(x), (IExpr)F.C0)))), F.Power(x, F.CN1D2));
            }
            if (y.isZero()) {
                return F.CComplexInfinity;
            }
            if (engine.isNumericMode()) {
                if (engine.isArbitraryMode()) {
                    x = engine.evalN(x);
                    y = engine.evalN(y);
                    if (x.isNumber() && y.isNumber()) {
                        return (IExpr)CarlsonEllipticIntegral.rC((CalculusFieldElement)x, (CalculusFieldElement)y);
                    }
                    return F.NIL;
                }
                double xd = Double.NaN;
                double yd = Double.NaN;
                try {
                    xd = x.evalDouble();
                    yd = y.evalDouble();
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
                if (Double.isNaN(xd) || Double.isNaN(yd)) {
                    Complex xc = x.evalComplex();
                    Complex yc = y.evalComplex();
                    return F.complexNum(EllipticIntegralsJS.carlsonRC(xc, yc));
                }
                return F.num(EllipticIntegralsJS.carlsonRC(xd, yd));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
            super.setUp(newSymbol);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.CarlsonRC.setEvaluator(new CarlsonRC());
            S.CarlsonRD.setEvaluator(new CarlsonRD());
            S.CarlsonRF.setEvaluator(new CarlsonRF());
            S.CarlsonRG.setEvaluator(new CarlsonRG());
            S.CarlsonRJ.setEvaluator(new CarlsonRJ());
            S.EllipticE.setEvaluator(new EllipticE());
            S.EllipticF.setEvaluator(new EllipticF());
            S.EllipticK.setEvaluator(new EllipticK());
            S.EllipticPi.setEvaluator(new EllipticPi());
            S.EllipticTheta.setEvaluator(new EllipticTheta());
            S.JacobiAmplitude.setEvaluator(new JacobiAmplitude());
            S.JacobiCD.setEvaluator(new JacobiCD());
            S.JacobiCN.setEvaluator(new JacobiCN());
            S.JacobiDN.setEvaluator(new JacobiDN());
            S.JacobiSC.setEvaluator(new JacobiSC());
            S.JacobiSD.setEvaluator(new JacobiSD());
            S.JacobiSN.setEvaluator(new JacobiSN());
            S.JacobiZeta.setEvaluator(new JacobiZeta());
            S.KleinInvariantJ.setEvaluator(new KleinInvariantJ());
            S.WeierstrassHalfPeriods.setEvaluator(new WeierstrassHalfPeriods());
            S.WeierstrassInvariants.setEvaluator(new WeierstrassInvariants());
            S.WeierstrassP.setEvaluator(new WeierstrassP());
            S.WeierstrassPPrime.setEvaluator(new WeierstrassPPrime());
        }
    }
}

