/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.time.LocalDateTime;
import java.util.Calendar;
import org.apfloat.Apfloat;
import org.apfloat.Apint;
import org.apfloat.Aprational;
import org.apfloat.FixedPrecisionApfloatHelper;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.ConstantDefinitions$;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractSymbolEvaluator;
import org.matheclipse.core.eval.interfaces.ISetValueEvaluator;
import org.matheclipse.core.eval.interfaces.ISignedNumberConstant;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.DateObjectExpr;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class ConstantDefinitions {
    public static String VERSION = "?";
    public static String TIMESTAMP = "";
    private static int YEAR = Calendar.getInstance().get(1);
    private static int MONTH = Calendar.getInstance().get(2);
    private static int DAY = Calendar.getInstance().get(5);
    private static int HOUR = Calendar.getInstance().get(10);
    private static int MINUTE = Calendar.getInstance().get(12);
    private static int SECOND = Calendar.getInstance().get(13);
    public static final double EULER_GAMMA = 0.5772156649015329;

    public static void initialize() {
        Initializer.init();
    }

    private ConstantDefinitions() {
    }

    private static class Pi
    extends AbstractSymbolEvaluator
    implements ISignedNumberConstant {
        private Pi() {
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(2);
        }

        @Override
        public IExpr numericEval(ISymbol symbol, EvalEngine engine) {
            return F.num(Math.PI);
        }

        @Override
        public IExpr apfloatEval(ISymbol symbol, EvalEngine engine) {
            return F.num(engine.apfloatHelper().pi());
        }

        @Override
        public double evalReal() {
            return Math.PI;
        }
    }

    private static class Khinchin
    extends AbstractSymbolEvaluator
    implements ISignedNumberConstant {
        public static final double KHINCHIN = 2.6854520010653062;

        private Khinchin() {
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(2);
        }

        @Override
        public IExpr numericEval(ISymbol symbol, EvalEngine engine) {
            return F.num(2.6854520010653062);
        }

        @Override
        public double evalReal() {
            return 2.6854520010653062;
        }

        @Override
        public IExpr apfloatEval(ISymbol symbol, EvalEngine engine) {
            return IOFunctions.printMessage(S.Khinchin, "unsupported", F.list(S.Khinchin, F.$str("Apfloat")), engine);
        }
    }

    private static class Today
    extends AbstractSymbolEvaluator {
        private Today() {
        }

        @Override
        public IExpr evaluate(ISymbol symbol, EvalEngine engine) {
            LocalDateTime now = LocalDateTime.now();
            return DateObjectExpr.newInstance(LocalDateTime.of(now.getYear(), now.getMonth(), now.getDayOfMonth(), 0, 0));
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Now
    extends AbstractSymbolEvaluator {
        private Now() {
        }

        @Override
        public IExpr evaluate(ISymbol symbol, EvalEngine engine) {
            return DateObjectExpr.newInstance(LocalDateTime.now());
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Infinity
    extends AbstractSymbolEvaluator {
        private Infinity() {
        }

        @Override
        public IExpr evaluate(ISymbol symbol, EvalEngine engine) {
            return F.CInfinity;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class I
    extends AbstractSymbolEvaluator {
        private I() {
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(2);
        }

        @Override
        public IExpr numericEval(ISymbol symbol, EvalEngine engine) {
            return F.complexNum(0.0, 1.0);
        }

        @Override
        public IExpr evaluate(ISymbol symbol, EvalEngine engine) {
            return F.complex(F.C0, F.C1);
        }
    }

    private static class GoldenRatio
    extends AbstractSymbolEvaluator
    implements ISignedNumberConstant {
        public static final double GOLDEN_RATIO = 1.618033988749895;

        private GoldenRatio() {
        }

        @Override
        public IExpr evaluate(ISymbol symbol, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(2);
        }

        @Override
        public IExpr apfloatEval(ISymbol symbol, EvalEngine engine) {
            FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
            return F.num(h.multiply(h.add(h.sqrt(new Apfloat(5L)), (Apfloat)Apfloat.ONE), (Apfloat)new Aprational("1/2")));
        }

        @Override
        public IExpr numericEval(ISymbol symbol, EvalEngine engine) {
            return F.num(1.618033988749895);
        }

        @Override
        public double evalReal() {
            return 1.618033988749895;
        }
    }

    private static class GoldenAngle
    extends AbstractSymbolEvaluator
    implements ISignedNumberConstant {
        public static final double GOLDEN_ANGLE = 2.3999632297286535;

        private GoldenAngle() {
        }

        @Override
        public IExpr evaluate(ISymbol symbol, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(2);
        }

        @Override
        public IExpr apfloatEval(ISymbol symbol, EvalEngine engine) {
            FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
            return F.num(h.multiply(h.subtract(new Apfloat(3L), h.sqrt(new Apfloat(5L))), h.pi()));
        }

        @Override
        public IExpr numericEval(ISymbol symbol, EvalEngine engine) {
            return F.num(2.3999632297286535);
        }

        @Override
        public double evalReal() {
            return 2.3999632297286535;
        }
    }

    private static class Glaisher
    extends AbstractSymbolEvaluator
    implements ISignedNumberConstant {
        public static final double GLAISHER = 1.2824271291006226;

        private Glaisher() {
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(2);
        }

        @Override
        public IExpr numericEval(ISymbol symbol, EvalEngine engine) {
            return F.num(1.2824271291006226);
        }

        @Override
        public IExpr apfloatEval(ISymbol symbol, EvalEngine engine) {
            return IOFunctions.printMessage(S.Glaisher, "unsupported", F.list(S.Glaisher, F.$str("Apfloat")), engine);
        }

        @Override
        public double evalReal() {
            return 1.2824271291006226;
        }
    }

    private static class EulerGamma
    extends AbstractSymbolEvaluator
    implements ISignedNumberConstant {
        private EulerGamma() {
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(2);
        }

        @Override
        public IExpr numericEval(ISymbol symbol, EvalEngine engine) {
            return F.num(0.5772156649015329);
        }

        @Override
        public IExpr apfloatEval(ISymbol symbol, EvalEngine engine) {
            return F.num(engine.apfloatHelper().euler());
        }

        @Override
        public double evalReal() {
            return 0.5772156649015329;
        }
    }

    private static class E
    extends AbstractSymbolEvaluator
    implements ISignedNumberConstant {
        private E() {
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(2);
        }

        @Override
        public IExpr numericEval(ISymbol symbol, EvalEngine engine) {
            return F.num(Math.E);
        }

        @Override
        public IExpr apfloatEval(ISymbol symbol, EvalEngine engine) {
            return F.num(EvalEngine.getApfloat().exp((Apfloat)Apfloat.ONE));
        }

        @Override
        public double evalReal() {
            return Math.E;
        }
    }

    private static class Degree
    extends AbstractSymbolEvaluator
    implements ISignedNumberConstant {
        public static final double DEGREE = Math.PI / 180;

        private Degree() {
        }

        @Override
        public IExpr evaluate(ISymbol symbol, EvalEngine engine) {
            return F.Times((IExpr)S.Pi, (IExpr)F.Power((IExpr)F.ZZ(180), F.CN1));
        }

        @Override
        public IExpr apfloatEval(ISymbol symbol, EvalEngine engine) {
            Apfloat pi = engine.apfloatHelper().pi();
            return F.num(pi.divide((Apfloat)new Apint(180L)));
        }

        @Override
        public IExpr numericEval(ISymbol symbol, EvalEngine engine) {
            return F.num(Math.PI / 180);
        }

        @Override
        public double evalReal() {
            return Math.PI / 180;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(2);
        }
    }

    private static class ComplexInfinity
    extends AbstractSymbolEvaluator {
        private ComplexInfinity() {
        }

        @Override
        public IExpr evaluate(ISymbol symbol, EvalEngine engine) {
            return F.CComplexInfinity;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Catalan
    extends AbstractSymbolEvaluator
    implements ISignedNumberConstant {
        public static final double CATALAN = 0.915965594177219;

        private Catalan() {
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(2);
        }

        @Override
        public IExpr numericEval(ISymbol symbol, EvalEngine engine) {
            return F.num(0.915965594177219);
        }

        @Override
        public IExpr apfloatEval(ISymbol symbol, EvalEngine engine) {
            return IOFunctions.printMessage(S.Catalan, "unsupported", F.list(S.Catalan, F.$str("Apfloat")), engine);
        }

        @Override
        public double evalReal() {
            return 0.915965594177219;
        }
    }

    private static class WordSeparators
    extends AbstractSymbolEvaluator
    implements ISetValueEvaluator {
        private WordSeparators() {
        }

        @Override
        public IExpr evaluate(ISymbol symbol, EvalEngine engine) {
            if (symbol.hasAssignedSymbolValue()) {
                return symbol.assignedValue();
            }
            return F.NIL;
        }

        @Override
        public IExpr evaluateSet(IExpr rightHandSide, boolean setDelayed, EvalEngine engine) {
            S.WordSeparators.assignValue(rightHandSide, setDelayed);
            return rightHandSide;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            super.setUp(newSymbol);
            S.WordSeparators.assignValue(F.list(F.stringx(" "), F.stringx("\t")), false);
        }
    }

    private static class RecordSeparators
    extends AbstractSymbolEvaluator
    implements ISetValueEvaluator {
        private RecordSeparators() {
        }

        @Override
        public IExpr evaluate(ISymbol symbol, EvalEngine engine) {
            if (symbol.hasAssignedSymbolValue()) {
                return symbol.assignedValue();
            }
            return F.NIL;
        }

        @Override
        public IExpr evaluateSet(IExpr rightHandSide, boolean setDelayed, EvalEngine engine) {
            S.RecordSeparators.assignValue(rightHandSide, setDelayed);
            return rightHandSide;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            super.setUp(newSymbol);
            S.RecordSeparators.assignValue(F.list(F.stringx("\n"), F.stringx("\r\n"), F.stringx("\r")), false);
        }
    }

    private static class NILEvaluator
    extends AbstractSymbolEvaluator {
        static final NILEvaluator CONST = new NILEvaluator();

        private NILEvaluator() {
        }

        @Override
        public IExpr numericEval(ISymbol symbol, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public IExpr apfloatEval(ISymbol symbol, EvalEngine engine) {
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            String versionString = Config.getVersion();
            if (versionString != null) {
                VERSION = versionString;
            }
            S.$Assumptions.setEvaluator(new $Assumptions());
            S.$BaseDirectory.setEvaluator(new $BaseDirectory());
            S.$Context.setEvaluator(new $Context());
            S.$ContextPath.setEvaluator(new $ContextPath());
            S.$CreationDate.setEvaluator(new $CreationDate());
            S.$HistoryLength.setEvaluator(new $HistoryLength());
            S.$HomeDirectory.setEvaluator(new $HomeDirectory());
            S.$Input.setEvaluator(new $Input());
            S.$InputFileName.setEvaluator(new $InputFileName());
            S.$IterationLimit.setEvaluator(new $IterationLimit());
            S.$Line.setEvaluator(new $Line());
            S.$MachineEpsilon.setEvaluator(new $MachineEpsilon());
            S.$MachinePrecision.setEvaluator(new $MachinePrecision());
            S.$MaxMachineNumber.setEvaluator(new $MaxMachineNumber());
            S.$MinMachineNumber.setEvaluator(new $MinMachineNumber());
            S.$Notebooks.setEvaluator(new $Notebooks());
            S.$OperatingSystem.setEvaluator(new $OperatingSystem());
            S.$Packages.setEvaluator(new $Packages());
            S.$Path.setEvaluator(new $Path());
            S.$PathnameSeparator.setEvaluator(new $PathnameSeparator());
            S.$UserName.setEvaluator(new $UserName());
            S.$RecursionLimit.setEvaluator(new $RecursionLimit());
            S.$RootDirectory.setEvaluator(new $RootDirectory());
            S.$ScriptCommandLine.setEvaluator(new $ScriptCommandLine());
            S.$SystemCharacterEncoding.setEvaluator(new $SystemCharacterEncoding());
            S.$SystemMemory.setEvaluator(new $SystemMemory());
            S.$TemporaryDirectory.setEvaluator(new $TemporaryDirectory());
            S.$UserBaseDirectory.setEvaluator(new $UserBaseDirectory());
            S.$Version.setEvaluator(new $Version());
            S.RecordSeparators.setEvaluator(new RecordSeparators());
            S.WordSeparators.setEvaluator(new WordSeparators());
            S.Catalan.setEvaluator(new Catalan());
            S.ComplexInfinity.setEvaluator(new ComplexInfinity());
            S.Degree.setEvaluator(new Degree());
            S.E.setEvaluator(new E());
            S.EulerGamma.setEvaluator(new EulerGamma());
            S.Glaisher.setEvaluator(new Glaisher());
            S.GoldenAngle.setEvaluator(new GoldenAngle());
            S.GoldenRatio.setEvaluator(new GoldenRatio());
            S.I.setEvaluator(new I());
            S.Infinity.setEvaluator(new Infinity());
            S.Khinchin.setEvaluator(new Khinchin());
            S.Pi.setEvaluator(new Pi());
            S.Now.setEvaluator(new Now());
            S.Today.setEvaluator(new Today());
            S.False.setEvaluator(NILEvaluator.CONST);
            S.True.setEvaluator(NILEvaluator.CONST);
            S.Null.setEvaluator(NILEvaluator.CONST);
        }
    }
}

