/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;

public class ComputationalGeometryFunctions {
    public static void initialize() {
        Initializer.init();
    }

    private ComputationalGeometryFunctions() {
    }

    private static class CollinearPoints
    extends AbstractEvaluator {
        private CollinearPoints() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList() && ast.arg1().argSize() > 2) {
                IAST listOfPoints = (IAST)ast.arg1();
                if (ast.arg1().argSize() > 2 && listOfPoints.arg1().isList2() && listOfPoints.arg2().isList2()) {
                    IASTAppendable result = F.ast((IExpr)S.And, listOfPoints.size() - 2);
                    for (int i = 3; i < listOfPoints.size(); ++i) {
                        IAST p1 = (IAST)listOfPoints.get(i - 2);
                        IAST p2 = (IAST)listOfPoints.get(i - 1);
                        if (!listOfPoints.get(i).isList2()) {
                            return IOFunctions.printMessage(ast.topHead(), "pts", F.list(listOfPoints), engine);
                        }
                        IAST p3 = (IAST)listOfPoints.get(i);
                        IExpr temp = CollinearPoints.collinearPoints2D(p1, p2, p3, engine);
                        result.append(temp);
                    }
                    if (result.argSize() == 1) {
                        return result.arg1();
                    }
                    return result;
                }
                if (ast.arg1().argSize() > 2 && listOfPoints.arg1().isList3() && listOfPoints.arg2().isList3() && listOfPoints.arg3().isList3()) {
                    IASTAppendable result = F.ast((IExpr)S.And, listOfPoints.size() - 3);
                    for (int i = 3; i < listOfPoints.size(); ++i) {
                        IExpr temp;
                        IAST p1 = (IAST)listOfPoints.get(i - 2);
                        IAST p2 = (IAST)listOfPoints.get(i - 1);
                        if (listOfPoints.get(i).isList3()) {
                            IAST p3 = (IAST)listOfPoints.get(i);
                            temp = CollinearPoints.collinearPoints3D(p1, p2, p3, engine);
                            if (!temp.isPresent()) {
                                return F.NIL;
                            }
                        } else {
                            return IOFunctions.printMessage(ast.topHead(), "pts", F.list(listOfPoints), engine);
                        }
                        result.append(temp);
                    }
                    if (result.argSize() == 1) {
                        return result.arg1();
                    }
                    return result;
                }
            }
            return F.NIL;
        }

        private static IExpr collinearPoints2D(IAST p1, IAST p2, IAST p3, EvalEngine engine) {
            IExpr x1 = p1.arg1();
            IExpr y1 = p1.arg2();
            IExpr x2 = p2.arg1();
            IExpr y2 = p2.arg2();
            IExpr px = p3.arg1();
            IExpr py = p3.arg2();
            IAST plus1 = F.Plus(px.times(y2.subtract(y1)), x2.times(y1));
            IAST plus2 = F.Plus(py.times(x2.subtract(x1)), x1.times(y2));
            IExpr calc = F.Subtract.of(engine, plus1, plus2);
            if (calc.isZero()) {
                return S.True;
            }
            if (calc.isNumber()) {
                return S.False;
            }
            if (calc.isPlusTimesPower()) {
                calc = engine.evaluate(F.Equal((IExpr)plus1, (IExpr)plus2));
            }
            return calc;
        }

        private static IExpr collinearPoints3D(IAST p1, IAST p2, IAST p3, EvalEngine engine) {
            IExpr x1 = p1.arg1();
            IExpr y1 = p1.arg2();
            IExpr z1 = p1.arg3();
            IExpr x2 = p2.arg1();
            IExpr y2 = p2.arg2();
            IExpr z2 = p2.arg3();
            IExpr x3 = p3.arg1();
            IExpr y3 = p3.arg2();
            IExpr z3 = p3.arg3();
            IExpr x21 = x2.subtract(x1);
            IExpr y21 = y2.subtract(y1);
            IExpr z21 = z2.subtract(z1);
            IExpr x31 = x3.subtract(x1);
            IExpr y31 = y3.subtract(y1);
            IExpr z31 = z3.subtract(z1);
            IExpr fx = F.C0;
            IExpr fy = F.C0;
            IExpr fz = F.C0;
            IASTAppendable equalAST = F.ast((IExpr)S.Equal, 3);
            if (!x21.isZero()) {
                fx = x31.divide(x21);
                equalAST.append(fx);
            } else if (!x31.isZero()) {
                return S.False;
            }
            if (!y21.isZero()) {
                fy = y31.divide(y21);
                equalAST.append(fy);
            } else if (!y31.isZero()) {
                return S.False;
            }
            if (!z21.isZero()) {
                fz = z31.divide(z21);
                equalAST.append(fz);
            } else if (!z31.isZero()) {
                return S.False;
            }
            IExpr calc = engine.evaluate(equalAST);
            if (calc.isTrue()) {
                return S.True;
            }
            if (calc.isFalse()) {
                return S.False;
            }
            if (fx.isNumber() && fy.isNumber() && fz.isNumber()) {
                return S.False;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class CoplanarPoints
    extends AbstractEvaluator {
        private CoplanarPoints() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList() && ast.arg1().argSize() > 2) {
                IAST listOfPoints = (IAST)ast.arg1();
                if (listOfPoints.arg1().isList2()) {
                    for (int i = 2; i < listOfPoints.size(); ++i) {
                        if (listOfPoints.get(i).isList2()) continue;
                        return IOFunctions.printMessage(ast.topHead(), "pts", F.list(listOfPoints), engine);
                    }
                    return S.True;
                }
                if (ast.arg1().argSize() > 3 && listOfPoints.arg1().isList3() && listOfPoints.arg2().isList3() && listOfPoints.arg3().isList3()) {
                    IASTAppendable result = F.ast((IExpr)S.And, listOfPoints.size() - 3);
                    for (int i = 4; i < listOfPoints.size(); ++i) {
                        IAST p1 = (IAST)listOfPoints.get(i - 3);
                        IAST p2 = (IAST)listOfPoints.get(i - 2);
                        IAST p3 = (IAST)listOfPoints.get(i - 1);
                        if (!listOfPoints.get(i).isList3()) {
                            return IOFunctions.printMessage(ast.topHead(), "pts", F.list(listOfPoints), engine);
                        }
                        IAST p4 = (IAST)listOfPoints.get(i);
                        IExpr temp = CoplanarPoints.coplanarPoints3D(p1, p2, p3, p4, engine);
                        result.append(temp);
                    }
                    if (result.argSize() == 1) {
                        return result.arg1();
                    }
                    return result;
                }
            }
            return F.NIL;
        }

        private static IExpr coplanarPoints3D(IAST p1, IAST p2, IAST p3, IAST p4, EvalEngine engine) {
            IExpr x1 = p1.arg1();
            IExpr y1 = p1.arg2();
            IExpr z1 = p1.arg3();
            IExpr x2 = p2.arg1();
            IExpr y2 = p2.arg2();
            IExpr z2 = p2.arg3();
            IExpr x3 = p3.arg1();
            IExpr y3 = p3.arg2();
            IExpr z3 = p3.arg3();
            IExpr a1 = z1.subtract(z2);
            IExpr b1 = y2.subtract(y1);
            IExpr a22 = x1.subtract(x3);
            IExpr b2 = y3.subtract(y1);
            IExpr b22 = y1.subtract(y3);
            IExpr c1 = x1.subtract(x2);
            IExpr c2 = z3.subtract(z1);
            IExpr px = p4.arg1();
            IExpr py = p4.arg2();
            IExpr pz = p4.arg3();
            IExpr times1 = S.Times.of(engine, a1, F.Plus(F.Times(py, a22), F.Times(x3, y1), F.Times(-1L, x1, y3), F.Times(px, b2)));
            IExpr times2 = S.Times.of(engine, b1, F.Plus(F.Times(pz, a22), F.Times(x3, z1), F.Times(-1L, x1, z3), F.Times(px, c2)));
            IExpr times3 = S.Times.of(engine, c1, F.Plus(F.Times(pz, b22), F.Times(y3, z1), F.Times(-1L, y1, z3), F.Times(py, c2)));
            IExpr calc = F.Plus.of(engine, times1, times2, times3);
            if (calc.isZero()) {
                return S.True;
            }
            if (calc.isNumber()) {
                return S.False;
            }
            if (calc.isPlusTimesPower()) {
                calc = engine.evaluate(F.Equal((IExpr)F.Factor(calc), (IExpr)F.C0));
            }
            return calc;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class ConvexHullMesh
    extends AbstractEvaluator {
        private ConvexHullMesh() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList()) {
                // empty if block
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.ConvexHullMesh.setEvaluator(new ConvexHullMesh());
            S.CollinearPoints.setEvaluator(new CollinearPoints());
            S.CoplanarPoints.setEvaluator(new CoplanarPoints());
        }
    }
}

