/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.SimpleCompiler;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.basic.ToggleFeature;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.OutputFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.expression.data.CompiledFunctionExpr;
import org.matheclipse.core.form.output.JavaComplexFormFactory;
import org.matheclipse.core.form.output.JavaDoubleFormFactory;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class CompilerFunctions {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String JAVA_SOURCE_CODE = "/** Compile with <a href=\"https://github.com/janino-compiler/janino\">Janino compiler</a> */\npackage org.matheclipse.core.compile;                                      \n                                                                           \nimport java.util.ArrayList;                                                \nimport org.hipparchus.complex.Complex;                                     \nimport org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;     \nimport org.matheclipse.core.interfaces.*;                                  \nimport org.matheclipse.core.eval.EvalEngine;                               \nimport org.matheclipse.core.expression.ExprTrie;                           \nimport org.matheclipse.core.expression.S;                                  \nimport static org.matheclipse.core.expression.S.*;                         \nimport org.matheclipse.core.expression.F;                                  \nimport static org.matheclipse.core.expression.F.*;                         \n                                                                           \npublic class CompiledFunction extends AbstractFunctionEvaluator {          \n  EvalEngine engine;\n  IASTAppendable stack;\n  ExprTrie vars;\n  int top=1;\n    public IExpr evaluate(final IAST ast, EvalEngine engine){              \n        if (ast.argSize()!={$size}) { return print(ast,{$size},engine); }  \n        this.engine = engine;\n        {$variables}                                                       \n        return {$expression}\n    }                                                                      \n  public double evalDouble(IExpr expr)  { \n    return engine.evalDouble(expr); \n  }\n\n  public Complex evalComplex(IExpr expr)  { \n    return engine.evalComplex(expr); \n  }\n\n{$methods}\n}                                                                          \n";

    public static void initialize() {
        Initializer.init();
    }

    private CompilerFunctions() {
    }

    public static Class<?> loadClass(String name, Map<String, byte[]> classBytes) throws ClassNotFoundException, IOException {
        try (MemoryClassLoader classLoader = new MemoryClassLoader(classBytes);){
            Class<?> clazz = classLoader.loadClass(name);
            return clazz;
        }
    }

    public static String compilePrint(IAST ast, IAST variables, IAST types, EvalEngine engine) {
        HashMap<IExpr, String> symbolicVariables = new HashMap<IExpr, String>();
        HashMap<IExpr, String> numericVariables = new HashMap<IExpr, String>();
        int top = 1;
        StringBuilder variablesBuf = new StringBuilder();
        variablesBuf.append("stack  = F.ast(S.List, 100, true);\n");
        variablesBuf.append("vars = new ExprTrie();\n");
        int defaultNumericType = 1;
        for (int i = 1; i < variables.size(); ++i) {
            IExpr argType = types.get(i);
            IExpr variable = variables.get(i);
            if (numericVariables.get(variable) != null) {
                IOFunctions.printMessage(ast.topHead(), "fdup", F.list(variable, ast.arg1()), engine);
                return null;
            }
            if (argType.equals(S.Real)) {
                variablesBuf.append("IExpr " + variable + " = ast.get(" + i + ");\n");
                variablesBuf.append("double " + variable + "d = engine.evalDouble(" + variable + ");\n");
                symbolicVariables.put(variable, variable.toString());
                numericVariables.put(variable, "stack.get(" + top + ")");
                variablesBuf.append("stack.set(top++, F.num(" + variable + "d));\n");
                ++top;
                continue;
            }
            if (argType.equals(S.Integer)) {
                variablesBuf.append("IExpr " + variable + " = ast.get(" + i + ");\n");
                variablesBuf.append("int " + variable + "i = engine.evalInt(" + variable + ");\n");
                symbolicVariables.put(variable, variable.toString());
                numericVariables.put(variable, "stack.get(" + top + ")");
                variablesBuf.append("stack.set(top++, F.ZZ(" + variable + "i));\n");
                ++top;
                continue;
            }
            if (argType.equals(S.Complex)) {
                defaultNumericType = 2;
                variablesBuf.append("IExpr " + variable + " = ast.get(" + i + ");\n");
                variablesBuf.append("Complex " + variable + "c = engine.evalComplex(" + variable + ");\n");
                symbolicVariables.put(variable, variable.toString());
                numericVariables.put(variable, "stack.get(" + top + ")");
                variablesBuf.append("stack.set(top++, F.complexNum(" + variable + "c));\n");
                ++top;
                continue;
            }
            if (!argType.equals(S.Booleans)) continue;
            variablesBuf.append("IExpr " + variable + " = ast.get(" + i + ");\n");
            variablesBuf.append("boolean " + variable + "b = engine.evalBoolean(" + variable + ");\n");
            symbolicVariables.put(variable, variable.toString());
            numericVariables.put(variable, "stack.get(" + top + ")");
            variablesBuf.append("stack.set(top++, F.bool(" + variable + "b));\n");
            ++top;
        }
        IExpr expression = ast.arg2();
        StringBuilder buf = new StringBuilder();
        StringBuilder methods = new StringBuilder();
        OutputFunctions.VariableManager numericVars = new OutputFunctions.VariableManager(numericVariables);
        OutputFunctions.VariableManager symbolicVars = new OutputFunctions.VariableManager(symbolicVariables);
        CompileFactory cf = new CompileFactory(numericVars, symbolicVars, types, top, defaultNumericType);
        cf.convert(buf, methods, expression, true);
        buf.append(";\n");
        String source = JAVA_SOURCE_CODE.replace("{$variables}", variablesBuf.toString());
        source = source.replace("{$methods}", methods.toString());
        source = source.replace("{$expression}", buf.toString());
        source = source.replace("{$size}", Integer.toString(variables.argSize()));
        return source;
    }

    public static class CompilePrint
    extends AbstractCoreFunctionEvaluator {
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!ToggleFeature.COMPILE_PRINT) {
                return F.NIL;
            }
            if (ast.isAST3()) {
                return F.NIL;
            }
            IAST[] vars = OutputFunctions.checkIsVariableOrVariableList(ast, engine);
            if (vars == null) {
                return F.NIL;
            }
            IAST variables = vars[0];
            IAST types = vars[1];
            String source = CompilerFunctions.compilePrint(ast, variables, types, engine);
            if (source != null) {
                source = this.indentSource(source);
                return F.stringx(source, (short)6);
            }
            return F.NIL;
        }

        private String indentSource(String source) {
            String[] split = source.split("\n");
            JavaIndenter p = new JavaIndenter();
            for (int i = 0; i < split.length; ++i) {
                p.addSourceLine(split[i].trim());
            }
            source = p.indentProgram();
            return source;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return IFunctionEvaluator.ARGS_2_3;
        }
    }

    private static final class CompiledFunction
    extends AbstractCoreFunctionEvaluator {
        private CompiledFunction() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr head = ast.head();
            if (head instanceof CompiledFunctionExpr) {
                CompiledFunctionExpr compiledFunction = (CompiledFunctionExpr)head;
                IExpr result = F.NIL;
                try {
                    result = compiledFunction.evaluate(ast, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), "CompiledFunction", (Throwable)rex);
                }
                if (result.isPresent()) {
                    if ((result = engine.evaluate(result)).isIndeterminate()) {
                        IOFunctions.printMessage(S.CompiledFunction, "cfn", F.CEmptyList, engine);
                        IAST variables = compiledFunction.getVariables();
                        IExpr expr = compiledFunction.getExpr();
                        return expr.replaceAll(Functors.equalRules(variables, ast));
                    }
                    return result;
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class CompileFactory {
        int module = 1;
        public static final Map<ISymbol, IConverter> CONVERTERS = new HashMap<ISymbol, IConverter>(199);
        int defaultNumericType;
        HashSet<String> localVariables = new HashSet();
        OutputFunctions.VariableManager numericVariables;
        OutputFunctions.VariableManager variables;
        int topOfStack;
        final IAST types;
        private static final IExpr.SourceCodeProperties JAVA_FORM_PROPERTIES;

        public CompileFactory(OutputFunctions.VariableManager numericVariables, OutputFunctions.VariableManager variables, IAST types, int topOfStack, int defaultNumericType) {
            this.numericVariables = numericVariables;
            this.variables = variables;
            this.types = types;
            this.topOfStack = topOfStack;
            this.defaultNumericType = defaultNumericType;
        }

        public void convert(StringBuilder buf, StringBuilder methods, IExpr expression, boolean addEval) {
            IConverter converter;
            IAST ast;
            IExpr h;
            int type;
            if (expression.isNumericFunction(this.numericVariables) && (type = this.convertNumeric(buf, expression, this.defaultNumericType)) > 0) {
                return;
            }
            if (expression.isAST() && (h = (ast = (IAST)expression).head()).isSymbol() && (converter = CONVERTERS.get(h)) != null) {
                converter.setFactory(this);
                StringBuilder sb = new StringBuilder();
                if (converter.convert(sb, methods, ast)) {
                    buf.append((CharSequence)sb);
                    return;
                }
            }
            if (addEval) {
                buf.append("F.eval(");
                this.convertSymbolic(buf, expression);
                buf.append(")");
            } else {
                this.convertSymbolic(buf, expression);
            }
        }

        private int convertNumeric(StringBuilder parentBuffer, IExpr expression, int type) {
            try {
                if (type == 1) {
                    StringBuilder buf = new StringBuilder();
                    JavaDoubleFormFactory factory = JavaDoubleFormFactory.get(true, false);
                    buf.append("F.num(");
                    expression = F.subst(expression, x -> {
                        String str = this.numericVariables.apply((IExpr)x);
                        if (x.isSymbol() && str != null) {
                            return F.stringx("evalDouble(" + str + ")");
                        }
                        return F.NIL;
                    });
                    factory.convert(buf, expression);
                    buf.append(")");
                    parentBuffer.append((CharSequence)buf);
                    return 1;
                }
            }
            catch (RuntimeException buf) {
                // empty catch block
            }
            try {
                StringBuilder buf = new StringBuilder();
                JavaComplexFormFactory factory = JavaComplexFormFactory.get(true, false, -1, -1, true);
                buf.append("F.complexNum(");
                expression = F.subst(expression, x -> {
                    String str = this.numericVariables.apply((IExpr)x);
                    if (x.isSymbol() && str != null) {
                        return F.stringx("evalComplex(" + str + ")");
                    }
                    return F.NIL;
                });
                factory.convert(buf, expression);
                buf.append(")");
                parentBuffer.append((CharSequence)buf);
                return 2;
            }
            catch (RuntimeException runtimeException) {
                return 0;
            }
        }

        private boolean convertSymbolic(StringBuilder buf, IExpr expression) {
            try {
                buf.append(expression.internalJavaString(JAVA_FORM_PROPERTIES, -1, x -> {
                    if (this.localVariables.contains(x.toString())) {
                        return "vars.get(\"" + x.toString() + "\")";
                    }
                    return this.numericVariables.apply((IExpr)x);
                }));
                return true;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        private static void tryBegin(StringBuilder methods) {
            methods.append(" int oldTop =  top;\n try {\n");
        }

        private static void tryEnd(StringBuilder methods) {
            methods.append("} finally {top = oldTop;}\n");
        }

        static {
            CONVERTERS.put(S.CompoundExpression, new CompoundExpressionConverter());
            CONVERTERS.put(S.If, new IfConverter());
            CONVERTERS.put(S.Set, new SetConverter());
            CONVERTERS.put(S.Module, new ModuleConverter());
            JAVA_FORM_PROPERTIES = IExpr.SourceCodeProperties.of(false, false, IExpr.SourceCodeProperties.Prefix.CLASS_NAME, false);
        }

        private static class ModuleConverter
        extends AbstractConverter {
            private ModuleConverter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean convert(StringBuilder parentBuffer, StringBuilder methods, IAST f) {
                if (f.size() != 3 && f.arg1().isList()) {
                    return false;
                }
                this.fFactory.variables.push();
                this.fFactory.numericVariables.push();
                HashSet<String> oldLocalVariables = this.fFactory.localVariables;
                try {
                    StringBuilder expressions;
                    HashSet<String> localVariables = new HashSet<String>(this.fFactory.localVariables);
                    this.fFactory.localVariables = localVariables;
                    IAST variableList = (IAST)f.arg1();
                    int m = this.fFactory.module++;
                    methods.append("public IExpr moduleExpression" + m + "() {\n");
                    methods.append("ExprTrie oldVars = vars;");
                    CompileFactory.tryBegin(methods);
                    methods.append("vars = vars.copy();\n");
                    for (int i = 1; i < variableList.size(); ++i) {
                        IExpr arg = variableList.get(i);
                        if (arg.isSymbol()) {
                            methods.append("ISymbol " + arg.toString() + " = F.Dummy(\"" + arg.toString() + "\");\n");
                            localVariables.add(arg.toString());
                            methods.append("vars.put(\"" + arg.toString() + "\"," + arg.toString() + ");\n");
                            continue;
                        }
                        if (!arg.isAST(S.Set, 3) && !arg.first().isSymbol()) {
                            boolean bl = false;
                            return bl;
                        }
                        String symbolName = arg.first().toString();
                        localVariables.add(symbolName.toString());
                        methods.append("ISymbol " + symbolName + " = F.Dummy(\"" + symbolName + "\");\n");
                        localVariables.add(arg.toString());
                        methods.append("vars.put(\"" + symbolName + "\"," + symbolName + ");\n");
                        expressions = new StringBuilder();
                        this.fFactory.convert(expressions, methods, arg.second(), false);
                        methods.append("F.eval(F.Set(" + symbolName + "," + expressions.toString() + "));\n");
                    }
                    expressions = new StringBuilder();
                    StringBuilder subMethods = new StringBuilder();
                    this.fFactory.convert(expressions, subMethods, f.arg2(), true);
                    methods.append("return " + expressions.toString() + ";\n");
                    methods.append("} finally {top = oldTop; vars = oldVars;}\n");
                    methods.append("}\n\n");
                    methods.append((CharSequence)subMethods);
                    parentBuffer.append("moduleExpression" + m + "()");
                }
                finally {
                    this.fFactory.localVariables = oldLocalVariables;
                    this.fFactory.variables.pop();
                    this.fFactory.numericVariables.pop();
                }
                return true;
            }
        }

        private static class IfConverter
        extends AbstractConverter {
            private IfConverter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean convert(StringBuilder parentBuffer, StringBuilder methods, IAST f) {
                if (f.size() < 3 || f.size() > 4) {
                    return false;
                }
                this.fFactory.variables.push();
                this.fFactory.numericVariables.push();
                try {
                    int m = this.fFactory.module++;
                    methods.append("public IExpr ifExpression" + m + "() {\n");
                    StringBuilder expression = new StringBuilder();
                    StringBuilder subMethods = new StringBuilder();
                    this.fFactory.convert(expression, subMethods, f.arg1(), true);
                    methods.append("if(engine.evalTrue(" + expression.toString() + ")){\n");
                    expression = new StringBuilder();
                    this.fFactory.convert(expression, subMethods, f.arg2(), true);
                    methods.append("return ");
                    methods.append((CharSequence)expression);
                    methods.append(";\n");
                    if (f.size() == 4) {
                        methods.append("} else {\n");
                        expression = new StringBuilder();
                        this.fFactory.convert(expression, subMethods, f.arg3(), true);
                        methods.append("return ");
                        methods.append((CharSequence)expression);
                        methods.append(";\n");
                    }
                    methods.append("}\n");
                    methods.append("}\n\n");
                    methods.append((CharSequence)subMethods);
                    parentBuffer.append("ifExpression" + m + "()");
                }
                finally {
                    this.fFactory.variables.pop();
                    this.fFactory.numericVariables.pop();
                }
                return true;
            }
        }

        private static interface IConverter {
            public boolean convert(StringBuilder var1, StringBuilder var2, IAST var3);

            public void setFactory(CompileFactory var1);
        }

        private static class SetConverter
        extends AbstractConverter {
            private SetConverter() {
            }

            @Override
            public boolean convert(StringBuilder parentBuffer, StringBuilder methods, IAST f) {
                StringBuilder numericBuffer;
                int type;
                if (f.size() != 3 || !f.arg1().isVariable()) {
                    return false;
                }
                String variable = f.arg1().toString();
                if (f.arg2().isNumericFunction(this.fFactory.numericVariables) && (type = this.fFactory.convertNumeric(numericBuffer = new StringBuilder(), f.arg2(), this.fFactory.defaultNumericType)) > 0) {
                    if (type == 1) {
                        parentBuffer.append("INum " + variable + " = ");
                    } else {
                        parentBuffer.append("IComplexNum " + variable + " = ");
                    }
                    parentBuffer.append(numericBuffer + ";\n");
                    parentBuffer.append("stack.set(top++, " + variable + ")");
                    this.fFactory.numericVariables.put(f.arg1(), "stack.get(" + this.fFactory.topOfStack++ + ")");
                    return true;
                }
                parentBuffer.append("IExpr " + variable + " = ");
                this.fFactory.convert(parentBuffer, methods, f.arg2(), true);
                return true;
            }
        }

        private static class DoConverter
        extends AbstractConverter {
            private DoConverter() {
            }

            @Override
            public boolean convert(StringBuilder buf, StringBuilder methods, IAST f) {
                return true;
            }
        }

        private static class CompoundExpressionConverter
        extends AbstractConverter {
            private CompoundExpressionConverter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean convert(StringBuilder parentBuffer, StringBuilder methods, IAST f) {
                if (f.size() < 2) {
                    return false;
                }
                this.fFactory.variables.push();
                this.fFactory.numericVariables.push();
                try {
                    StringBuilder expressions;
                    int m = this.fFactory.module++;
                    methods.append("public IExpr compoundExpression" + m + "() {\n");
                    CompileFactory.tryBegin(methods);
                    StringBuilder subMethods = new StringBuilder();
                    for (int i = 1; i < f.size() - 1; ++i) {
                        expressions = new StringBuilder();
                        this.fFactory.convert(expressions, subMethods, f.get(i), true);
                        methods.append(expressions.toString() + ";\n");
                    }
                    expressions = new StringBuilder();
                    this.fFactory.convert(expressions, subMethods, f.last(), true);
                    methods.append("return " + expressions.toString() + ";\n");
                    CompileFactory.tryEnd(methods);
                    methods.append("}\n\n");
                    methods.append((CharSequence)subMethods);
                    parentBuffer.append("compoundExpression" + m + "()");
                }
                finally {
                    this.fFactory.variables.pop();
                    this.fFactory.numericVariables.pop();
                }
                return true;
            }
        }

        private static abstract class AbstractConverter
        implements IConverter {
            protected CompileFactory fFactory;

            @Override
            public void setFactory(CompileFactory factory) {
                this.fFactory = factory;
            }
        }
    }

    private static class Compile
    extends AbstractCoreFunctionEvaluator {
        private Compile() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (!ToggleFeature.COMPILE) {
                return F.NIL;
            }
            try {
                if (ast.isAST3()) {
                    return F.NIL;
                }
                IAST[] vars = OutputFunctions.checkIsVariableOrVariableList(ast, engine);
                if (vars == null) {
                    return F.NIL;
                }
                IAST variables = vars[0];
                IAST types = vars[1];
                String source = CompilerFunctions.compilePrint(ast, variables, types, engine);
                if (source != null) {
                    SimpleCompiler comp = new SimpleCompiler();
                    comp.cook(source);
                    ClassLoader loader = comp.getClassLoader();
                    Class<?> clazz = loader.loadClass("org.matheclipse.core.compile.CompiledFunction");
                    return CompiledFunctionExpr.newInstance(variables, types, ast.arg2(), clazz);
                }
                return F.NIL;
            }
            catch (ValidateException ve) {
                return IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (ClassNotFoundException | RuntimeException | CompileException e) {
                LOGGER.log(engine.getLogLevel(), "Compile", e);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return IFunctionEvaluator.ARGS_2_3;
        }
    }

    static class MemoryClassLoader
    extends URLClassLoader {
        Map<String, byte[]> classBytes = new HashMap<String, byte[]>();

        public MemoryClassLoader(Map<String, byte[]> classBytes) {
            super(new URL[0], MemoryClassLoader.class.getClassLoader());
            this.classBytes.putAll(classBytes);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] buf = this.classBytes.get(name);
            if (buf == null) {
                return super.findClass(name);
            }
            this.classBytes.remove(name);
            return this.defineClass(name, buf, 0, buf.length);
        }
    }

    private static class JavaIndenter {
        private ArrayList<JavaSourceLine> programLines = new ArrayList();

        public JavaIndenter() {
            this.programLines.clear();
        }

        public void addSourceLine(String sourceLine) {
            if (this.programLines.size() == 0) {
                this.programLines.add(new JavaSourceLine(sourceLine, 0));
                return;
            }
            JavaSourceLine previous = this.programLines.get(this.programLines.size() - 1);
            int indentation = previous.getIndentation();
            if (previous.startOfBlock()) {
                ++indentation;
            }
            this.programLines.add(new JavaSourceLine(sourceLine, indentation));
        }

        public String indentProgram() {
            Object res = "";
            for (JavaSourceLine line : this.programLines) {
                res = (String)res + line.returnIndentedLine() + "\n";
            }
            return res;
        }

        private static class JavaSourceLine {
            private String java = "";
            private int lenJava = 0;
            private int block = 0;

            public JavaSourceLine(String line, int lenJava) {
                line = line.trim();
                int PosOfComment = line.length();
                this.lenJava = lenJava;
                block5: for (int i = 0; i < line.length() && PosOfComment == line.length(); ++i) {
                    switch (line.charAt(i)) {
                        case '\"': {
                            ++i;
                            while (i < line.length() && (line.charAt(i) != '\"' || line.charAt(i - 1) == '\\')) {
                                ++i;
                            }
                            continue block5;
                        }
                        case '{': {
                            ++this.block;
                            continue block5;
                        }
                        case '}': {
                            --this.block;
                            continue block5;
                        }
                    }
                }
                if (this.block == -1) {
                    --this.lenJava;
                }
                this.java = line.substring(0, PosOfComment);
            }

            public int getIndentation() {
                return this.lenJava;
            }

            public boolean startOfBlock() {
                return this.block > 0 && this.block % 2 == 1;
            }

            public String returnIndentedLine() {
                int number = 2 * this.lenJava;
                StringBuilder buf = new StringBuilder(number + this.java.length());
                for (int i = 0; i < number; ++i) {
                    buf.append(" ");
                }
                buf.append(this.java);
                return buf.toString();
            }
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            if (!Config.FUZZY_PARSER) {
                S.Compile.setEvaluator(new Compile());
                S.CompiledFunction.setEvaluator(new CompiledFunction());
            }
            S.CompilePrint.setEvaluator(new CompilePrint());
        }
    }
}

