/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.combinatoric.KSubsets;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.IntRangeSpec;
import org.matheclipse.core.eval.util.MutableInt;
import org.matheclipse.core.eval.util.SetSpecification;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.frobenius.FrobeniusSolver;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.FrobeniusSolve;

public final class Combinatoric {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IAST checkCycles(IAST cycles, boolean quiet, EvalEngine engine) {
        if (cycles.isAST(S.Cycles, 2)) {
            return Cycles.canonicalizeCycles(cycles, quiet, engine);
        }
        return F.NIL;
    }

    public static IExpr permutationCycles(IAST permList, EvalEngine engine) {
        return Combinatoric.permutationCycles(permList, engine, S.Cycles);
    }

    public static IExpr permutationCycles(IAST permList, EvalEngine engine, IExpr head) {
        if (permList.isEmptyList()) {
            return F.Cycles(F.CEmptyList);
        }
        int[] positions = Combinatoric.isPermutationList(permList, false, engine);
        if (positions == null) {
            return F.NIL;
        }
        IASTAppendable mainList = F.ListAlloc(F.allocMin16(permList));
        IASTAppendable cycleList = F.NIL;
        int oldPosition = -1;
        int newPosition = -1;
        for (int i = 0; i < positions.length; ++i) {
            newPosition = positions[i];
            if (newPosition < 0) {
                cycleList = F.NIL;
                continue;
            }
            if (newPosition == i + 1) {
                positions[i] = -1;
                cycleList = F.NIL;
                if (head == S.Cycles) continue;
                IAST singleton = F.list(F.ZZ(newPosition));
                mainList.append(singleton);
                continue;
            }
            positions[i] = -1;
            if (!cycleList.isPresent()) {
                cycleList = F.ListAlloc(permList.argSize() < 16 ? permList.size() : 16);
                mainList.append(cycleList);
            }
            cycleList.append(newPosition);
            oldPosition = newPosition;
            while (positions[oldPosition - 1] > 0 && (newPosition = positions[oldPosition - 1]) >= 0) {
                positions[oldPosition - 1] = -1;
                if (positions[newPosition - 1] < 0) {
                    cycleList.append(1, newPosition);
                } else {
                    cycleList.append(newPosition);
                }
                oldPosition = newPosition;
            }
            cycleList = F.NIL;
        }
        return F.unaryAST1(head, mainList);
    }

    private static int[] isPermutationList(IAST permList, boolean quiet, EvalEngine engine) {
        HashSet<IExpr> set = new HashSet<IExpr>();
        int[] positions = new int[permList.argSize()];
        for (int i = 1; i < permList.size(); ++i) {
            int position;
            IExpr arg = permList.get(i);
            if (arg.isInteger()) {
                position = arg.toIntDefault();
                if (position < 1 || position > permList.argSize()) {
                    if (!quiet) {
                        IOFunctions.printMessage(S.Cycles, "permlist", F.list(permList), engine);
                    }
                    return null;
                }
                if (set.contains(arg)) {
                    if (!quiet) {
                        IOFunctions.printMessage(S.Cycles, "permlist", F.list(permList), engine);
                    }
                    return null;
                }
            } else {
                if (!quiet) {
                    IOFunctions.printMessage(S.Cycles, "perm", F.list(permList), engine);
                }
                return null;
            }
            set.add(arg);
            positions[i - 1] = position;
        }
        return positions;
    }

    public static IExpr permutationReplace(IAST list1, IAST mainList) {
        IASTMutable result = list1.copy();
        boolean changed = false;
        for (int i = 1; i < list1.size(); ++i) {
            IInteger element;
            IExpr arg = list1.get(i);
            if (!arg.isInteger() || (element = PermutationReplace.replaceSingleElement(mainList, (IInteger)arg)).equals(arg)) continue;
            result.set(i, element);
            changed = true;
        }
        return changed ? result : list1;
    }

    public static void initialize() {
        Initializer.init();
    }

    private Combinatoric() {
    }

    public static final class KPermutationsIterable
    implements Iterable<int[]> {
        private final int n;
        private final int k;
        private final int[] fPermutationsIndex;
        private final int[] y;
        private boolean first;
        private int h;
        private int i;
        private int m;
        private final int[] fCopiedResultIndex;

        public KPermutationsIterable(IAST fun, int parts, int headOffset) {
            this.n = fun.size() - headOffset;
            this.k = parts;
            if (parts > this.n || parts < 1) {
                throw new IllegalArgumentException("KPermutationsIterable: parts " + parts + " > " + this.n);
            }
            this.fPermutationsIndex = new int[this.n];
            this.y = new int[this.n];
            this.fCopiedResultIndex = new int[this.n];
            this.fPermutationsIndex[0] = 0;
            this.y[0] = 0;
            for (int a = 1; a < this.n; ++a) {
                this.fPermutationsIndex[a] = fun.get(a + headOffset).equals(fun.get(a + headOffset - 1)) ? this.fPermutationsIndex[a - 1] : a;
                this.y[a] = a;
            }
            this.m = this.k == this.n ? this.k - 1 : this.k;
            this.first = true;
            this.i = this.m - 1;
        }

        public KPermutationsIterable(int[] data, int parts) {
            this(data, data.length, parts);
        }

        public KPermutationsIterable(int[] data, int len, int parts) {
            this.n = len;
            this.k = parts;
            if (parts > this.n || parts < 1) {
                throw new IllegalArgumentException("KPermutationsIterable: parts " + parts + " > " + this.n);
            }
            this.fPermutationsIndex = new int[this.n];
            this.y = new int[this.n];
            this.fCopiedResultIndex = new int[this.n];
            for (int a = 0; a < this.n; ++a) {
                this.fPermutationsIndex[a] = data[a];
                this.y[a] = a;
            }
            this.m = this.k == this.n ? this.k - 1 : this.k;
            this.first = true;
            this.i = this.m - 1;
        }

        @Override
        public Iterator<int[]> iterator() {
            return new KPermutationsIterator();
        }

        private class KPermutationsIterator
        implements Iterator<int[]> {
            private int[] fResultIndex = this.nextBeforehand();

            private KPermutationsIterator() {
            }

            private final int[] nextBeforehand() {
                if (KPermutationsIterable.this.first) {
                    KPermutationsIterable.this.first = false;
                    return KPermutationsIterable.this.fPermutationsIndex;
                }
                do {
                    if (KPermutationsIterable.this.y[KPermutationsIterable.this.i] < KPermutationsIterable.this.n - 1) {
                        KPermutationsIterable.this.y[KPermutationsIterable.this.i] = KPermutationsIterable.this.y[KPermutationsIterable.this.i] + 1;
                        if (KPermutationsIterable.this.fPermutationsIndex[KPermutationsIterable.this.i] == KPermutationsIterable.this.fPermutationsIndex[KPermutationsIterable.this.y[KPermutationsIterable.this.i]]) continue;
                        KPermutationsIterable.this.h = KPermutationsIterable.this.fPermutationsIndex[KPermutationsIterable.this.i];
                        KPermutationsIterable.this.fPermutationsIndex[KPermutationsIterable.this.i] = KPermutationsIterable.this.fPermutationsIndex[KPermutationsIterable.this.y[KPermutationsIterable.this.i]];
                        KPermutationsIterable.this.fPermutationsIndex[KPermutationsIterable.this.y[KPermutationsIterable.this.i]] = KPermutationsIterable.this.h;
                        KPermutationsIterable.this.i = KPermutationsIterable.this.m - 1;
                        return KPermutationsIterable.this.fPermutationsIndex;
                    }
                    do {
                        KPermutationsIterable.this.h = KPermutationsIterable.this.fPermutationsIndex[KPermutationsIterable.this.i];
                        KPermutationsIterable.this.fPermutationsIndex[KPermutationsIterable.this.i] = KPermutationsIterable.this.fPermutationsIndex[KPermutationsIterable.this.y[KPermutationsIterable.this.i]];
                        KPermutationsIterable.this.fPermutationsIndex[KPermutationsIterable.this.y[KPermutationsIterable.this.i]] = KPermutationsIterable.this.h;
                        KPermutationsIterable.this.y[KPermutationsIterable.this.i] = KPermutationsIterable.this.y[KPermutationsIterable.this.i] - 1;
                    } while (KPermutationsIterable.this.y[KPermutationsIterable.this.i] > KPermutationsIterable.this.i);
                    --KPermutationsIterable.this.i;
                } while (KPermutationsIterable.this.i != -1);
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.fResultIndex != null;
            }

            @Override
            public int[] next() {
                System.arraycopy(this.fResultIndex, 0, KPermutationsIterable.this.fCopiedResultIndex, 0, this.fResultIndex.length);
                this.fResultIndex = this.nextBeforehand();
                return KPermutationsIterable.this.fCopiedResultIndex;
            }
        }
    }

    private static final class YuleDissimilarity
    extends AbstractEvaluator {
        private YuleDissimilarity() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int dim2;
            int dim1 = ast.arg1().isVector();
            if (dim1 == (dim2 = ast.arg2().isVector()) && dim1 > 0) {
                IAST u = (IAST)ast.arg1().normal(false);
                IAST v = (IAST)ast.arg2().normal(false);
                int length = u.size();
                int n10 = 0;
                int n01 = 0;
                int n00 = 0;
                int n11 = 0;
                for (int i = 1; i < length; ++i) {
                    IExpr x = u.get(i);
                    IExpr y = v.get(i);
                    if ((x.isOne() || x.isTrue()) && (y.isZero() || y.isFalse())) {
                        ++n10;
                        continue;
                    }
                    if ((x.isZero() || x.isFalse()) && (y.isOne() || y.isTrue())) {
                        ++n01;
                        continue;
                    }
                    if ((x.isZero() || x.isFalse()) && (y.isZero() || y.isFalse())) {
                        ++n00;
                        continue;
                    }
                    if ((x.isOne() || x.isTrue()) && (y.isOne() || y.isTrue())) {
                        ++n11;
                        continue;
                    }
                    if (!(!x.isZero() && !x.isFalse() && !x.isOne() && !x.isTrue() || !y.isZero() && !y.isFalse() && !y.isOne() && !y.isTrue())) continue;
                    return F.NIL;
                }
                long r = 2L * (long)n10 * (long)n01;
                if (r == 0L) {
                    return F.C0;
                }
                return F.Divide(F.ZZ(r), F.ZZ((long)n11 * (long)n00 + (long)n10 * (long)n01));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Tuples
    extends AbstractFunctionEvaluator {
        private Tuples() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int k;
            IExpr arg1 = ast.arg1();
            if (ast.isAST1() && arg1.isList()) {
                IAST list = (IAST)arg1;
                if (list.exists(x -> !x.isAST())) {
                    return F.NIL;
                }
                IASTAppendable result = F.ListAlloc(16);
                IAST temp = F.List();
                this.tuplesOfListsRecursive(list, 1, result, temp, ast, engine);
                return result;
            }
            if (ast.isAST2() && arg1.isAST() && (k = ast.arg2().toIntDefault()) >= 0) {
                IASTAppendable result = F.ListAlloc(16);
                IASTAppendable temp = F.ast(arg1.head());
                Tuples.tuples((IAST)arg1, k, result, temp, ast, engine);
                return result;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void tuples(IAST originalList, int n, IASTAppendable result, IAST subResult, IAST ast, EvalEngine engine) {
            if (n == 0) {
                result.append(subResult);
                return;
            }
            int recursionLimit = engine.getRecursionLimit();
            try {
                int counter;
                if (recursionLimit > 0 && (counter = engine.incRecursionCounter()) > recursionLimit) {
                    RecursionLimitExceeded.throwIt(counter, ast);
                }
                for (int j = 1; j < originalList.size(); ++j) {
                    IASTAppendable temp = subResult.copyAppendable();
                    temp.append(originalList.get(j));
                    Tuples.tuples(originalList, n - 1, result, temp, ast, engine);
                }
            }
            finally {
                if (recursionLimit > 0) {
                    engine.decRecursionCounter();
                }
            }
        }

        private void tuplesOfListsRecursive(IAST originalList, int k, IASTAppendable result, IAST subResult, IAST ast, EvalEngine engine) {
            int counter;
            if (k == originalList.size()) {
                result.append(subResult);
                return;
            }
            int recursionLimit = engine.getRecursionLimit();
            if (recursionLimit > 0 && (counter = engine.incRecursionCounter()) > recursionLimit) {
                RecursionLimitExceeded.throwIt(counter, ast);
            }
            IAST subAST = (IAST)originalList.get(k);
            for (int j = 1; j < subAST.size(); ++j) {
                IASTAppendable temp = subResult.copyAppendable(1);
                temp.append(subAST.get(j));
                this.tuplesOfListsRecursive(originalList, k + 1, result, temp, ast, engine);
            }
        }
    }

    private static final class Subsets
    extends AbstractFunctionEvaluator {
        private Subsets() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2;
            if (ast.isAST0()) {
                return F.NIL;
            }
            if (!ast.arg1().isAST()) return F.NIL;
            IAST f = (IAST)ast.arg1();
            int n = f.argSize();
            SetSpecification level = new SetSpecification(0, n);
            if (ast.isAST2() && (arg2 = ast.arg2()) != S.All && !arg2.isInfinity()) {
                if (arg2.isInteger()) {
                    n = arg2.toIntDefault();
                    if (n <= Integer.MIN_VALUE) return F.NIL;
                    level = new SetSpecification(0, n > f.argSize() ? f.argSize() : n);
                } else {
                    level = new SetSpecification(arg2);
                }
            }
            IASTAppendable result = F.ast(S.List);
            level.setMinCountAsCurrent();
            while (level.isInRange()) {
                int k = level.getCurrentCounter();
                if (k > f.argSize()) {
                    return F.CEmptyList;
                }
                KSubsetsList iter = Subsets.createKSubsets(f, k, F.ast(f.head()), 1);
                for (IAST part : iter) {
                    if (part == null) break;
                    result.append(part);
                }
                level.incCurrentCounter();
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_2;
        }

        public static KSubsetsList createKSubsets(IAST list, int k, IAST resultList, int offset) {
            return new KSubsetsList(list, k, resultList, offset);
        }

        public static final class KSubsetsList
        implements Iterable<IAST> {
            private final IAST fList;
            private final IAST fResultList;
            private final int fOffset;
            private final int fK;

            private KSubsetsList(IAST list, int k, IAST resultList, int offset) {
                this.fList = list;
                this.fK = k;
                this.fResultList = resultList;
                this.fOffset = offset;
            }

            @Override
            public Iterator<IAST> iterator() {
                return new KSubsetsIterator();
            }

            private class KSubsetsIterator
            implements Iterator<IAST> {
                private final Iterator<int[]> fIterable;

                private KSubsetsIterator() {
                    this.fIterable = new KSubsets.KSubsetsIterable(KSubsetsList.this.fList.size() - KSubsetsList.this.fOffset, KSubsetsList.this.fK).iterator();
                }

                @Override
                public IAST next() {
                    int[] j = this.fIterable.next();
                    if (j == null) {
                        return null;
                    }
                    IASTAppendable temp = KSubsetsList.this.fResultList.copyAppendable();
                    return temp.appendArgs(0, KSubsetsList.this.fK, i -> {
                        if (j.length > i && KSubsetsList.this.fList.size() > j[i] + KSubsetsList.this.fOffset) {
                            return KSubsetsList.this.fList.get(j[i] + KSubsetsList.this.fOffset);
                        }
                        return F.NIL;
                    });
                }

                @Override
                public boolean hasNext() {
                    return this.fIterable.hasNext();
                }
            }
        }
    }

    private static final class SokalSneathDissimilarity
    extends AbstractEvaluator {
        private SokalSneathDissimilarity() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int dim2;
            int dim1 = ast.arg1().isVector();
            if (dim1 == (dim2 = ast.arg2().isVector()) && dim1 > 0) {
                IAST u = (IAST)ast.arg1().normal(false);
                IAST v = (IAST)ast.arg2().normal(false);
                int length = u.size();
                int n10 = 0;
                int n01 = 0;
                int n11 = 0;
                for (int i = 1; i < length; ++i) {
                    IExpr x = u.get(i);
                    IExpr y = v.get(i);
                    if ((x.isOne() || x.isTrue()) && (y.isZero() || y.isFalse())) {
                        ++n10;
                        continue;
                    }
                    if ((x.isZero() || x.isFalse()) && (y.isOne() || y.isTrue())) {
                        ++n01;
                        continue;
                    }
                    if ((x.isZero() || x.isFalse()) && (y.isZero() || y.isFalse())) continue;
                    if ((x.isOne() || x.isTrue()) && (y.isOne() || y.isTrue())) {
                        ++n11;
                        continue;
                    }
                    if (!(!x.isZero() && !x.isFalse() && !x.isOne() && !x.isTrue() || !y.isZero() && !y.isFalse() && !y.isOne() && !y.isTrue())) continue;
                    return F.NIL;
                }
                long r = 2L * ((long)n10 + (long)n01);
                if (r == 0L) {
                    return F.C0;
                }
                return F.Divide(F.ZZ(r), F.ZZ((long)n11 + r));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.addAttributes(24576);
        }
    }

    private static final class Signature
    extends AbstractFunctionEvaluator {
        private Signature() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                if (list.argSize() == 1) {
                    return F.C1;
                }
                int n = 0;
                for (int i = 1; i < list.size(); ++i) {
                    for (int j = i + 1; j < list.size(); ++j) {
                        int compareTo = list.get(i).compareTo(list.get(j));
                        if (compareTo > 0) {
                            ++n;
                            continue;
                        }
                        if (compareTo != 0) continue;
                        return F.C0;
                    }
                }
                return n % 2 == 0 ? F.C1 : F.CN1;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class RussellRaoDissimilarity
    extends AbstractEvaluator {
        private RussellRaoDissimilarity() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int dim2;
            int dim1 = ast.arg1().isVector();
            if (dim1 == (dim2 = ast.arg2().isVector()) && dim1 > 0) {
                IAST u = (IAST)ast.arg1().normal(false);
                IAST v = (IAST)ast.arg2().normal(false);
                int length = u.size();
                int n10 = 0;
                int n01 = 0;
                int n00 = 0;
                for (int i = 1; i < length; ++i) {
                    IExpr x = u.get(i);
                    IExpr y = v.get(i);
                    if ((x.isOne() || x.isTrue()) && (y.isZero() || y.isFalse())) {
                        ++n10;
                        continue;
                    }
                    if ((x.isZero() || x.isFalse()) && (y.isOne() || y.isTrue())) {
                        ++n01;
                        continue;
                    }
                    if ((x.isZero() || x.isFalse()) && (y.isZero() || y.isFalse())) {
                        ++n00;
                        continue;
                    }
                    if (!(!x.isZero() && !x.isFalse() && !x.isOne() && !x.isTrue() || !y.isZero() && !y.isFalse() && !y.isOne() && !y.isTrue())) continue;
                    return F.NIL;
                }
                long r = (long)n10 + (long)n01 + (long)n00;
                if (r == 0L) {
                    return F.C0;
                }
                return F.Divide(F.ZZ(r), F.ZZ(length - 1));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class RogersTanimotoDissimilarity
    extends AbstractEvaluator {
        private RogersTanimotoDissimilarity() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int dim2;
            int dim1 = ast.arg1().isVector();
            if (dim1 == (dim2 = ast.arg2().isVector()) && dim1 > 0) {
                IAST u = (IAST)ast.arg1().normal(false);
                IAST v = (IAST)ast.arg2().normal(false);
                int length = u.size();
                int n10 = 0;
                int n01 = 0;
                int n00 = 0;
                int n11 = 0;
                for (int i = 1; i < length; ++i) {
                    IExpr x = u.get(i);
                    IExpr y = v.get(i);
                    if ((x.isOne() || x.isTrue()) && (y.isZero() || y.isFalse())) {
                        ++n10;
                        continue;
                    }
                    if ((x.isZero() || x.isFalse()) && (y.isOne() || y.isTrue())) {
                        ++n01;
                        continue;
                    }
                    if ((x.isZero() || x.isFalse()) && (y.isZero() || y.isFalse())) {
                        ++n00;
                        continue;
                    }
                    if ((x.isOne() || x.isTrue()) && (y.isOne() || y.isTrue())) {
                        ++n11;
                        continue;
                    }
                    if (!(!x.isZero() && !x.isFalse() && !x.isOne() && !x.isTrue() || !y.isZero() && !y.isFalse() && !y.isOne() && !y.isTrue())) continue;
                    return F.NIL;
                }
                long r = 2L * ((long)n10 + (long)n01);
                if (r == 0L) {
                    return F.C0;
                }
                return F.Divide(F.ZZ(r), F.ZZ((long)n11 + (long)n00 + r));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class PolygonalNumber
    extends AbstractFunctionEvaluator {
        private PolygonalNumber() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2()) {
                IExpr r = ast.arg1();
                IExpr n = ast.arg2();
                return F.Times((IExpr)F.C1D2, n, (IExpr)F.Plus((IExpr)F.C4, (IExpr)F.Times(n, (IExpr)F.Plus((IExpr)F.CN2, r)), F.Negate(r)));
            }
            IExpr n = ast.arg1();
            return F.Times((IExpr)F.C1D2, n, (IExpr)F.Plus((IExpr)F.C1, n));
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class Permutations
    extends AbstractFunctionEvaluator {
        private Permutations() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAST()) {
                IAST list = (IAST)ast.arg1();
                int parts = list.argSize();
                if (ast.isAST2()) {
                    if (ast.arg2().isInteger()) {
                        int maxPart = ast.arg2().toIntDefault();
                        if (maxPart >= 0) {
                            maxPart = maxPart < parts ? maxPart : parts;
                            IASTAppendable result = F.ListAlloc(100);
                            result.append(F.CEmptyList);
                            for (int i = 1; i <= maxPart; ++i) {
                                this.createPermutationsWithNParts(list, i, result);
                            }
                            return result;
                        }
                        return F.NIL;
                    }
                    if (ast.arg2().isList()) {
                        IAST sequence = (IAST)ast.arg2();
                        if (!sequence.isAST1() || !sequence.arg1().isInteger()) {
                            return F.NIL;
                        }
                        parts = Validate.checkIntType(S.Permutations, sequence.arg1(), 0, engine);
                        if (parts < 0 && parts > list.argSize()) {
                            return F.NIL;
                        }
                    }
                }
                if (parts < 0) {
                    return F.NIL;
                }
                if (parts > list.argSize()) {
                    return F.CEmptyList;
                }
                if (parts == 0) {
                    return F.list(F.CEmptyList);
                }
                IASTAppendable result = F.ListAlloc(100);
                return this.createPermutationsWithNParts(list, parts, result);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private IAST createPermutationsWithNParts(IAST list, int parts, IASTAppendable result) {
            if (parts == 0) {
                result.append(F.List());
                return result;
            }
            if (list.size() <= 2) {
                if (list.isAST1()) {
                    result.append(list);
                }
                return result;
            }
            KPermutationsList perm = new KPermutationsList(list, parts, F.ast(list.head()), 1);
            HashSet<IAST> set = new HashSet<IAST>();
            for (IAST temp : perm) {
                if (set.contains(temp)) continue;
                result.append(temp);
                set.add(temp);
            }
            return result;
        }

        private static final class KPermutationsList
        implements Iterable<IAST> {
            private final IAST fList;
            private final IAST fResultList;
            private final int fOffset;
            private final int fParts;

            public KPermutationsList(IAST list, int parts, IAST resultList, int offset) {
                this.fList = list;
                this.fResultList = resultList;
                this.fOffset = offset;
                this.fParts = parts;
            }

            @Override
            public Iterator<IAST> iterator() {
                return new KPermutationsIterator();
            }

            private class KPermutationsIterator
            implements Iterator<IAST> {
                private final Iterator<int[]> fIterable;

                private KPermutationsIterator() {
                    this.fIterable = new KPermutationsIterable(KPermutationsList.this.fList, KPermutationsList.this.fParts, KPermutationsList.this.fOffset).iterator();
                }

                @Override
                public IAST next() {
                    int[] permutationsIndex = this.fIterable.next();
                    if (permutationsIndex == null) {
                        return null;
                    }
                    IASTAppendable temp = KPermutationsList.this.fResultList.copyAppendable();
                    for (int i = 0; i < KPermutationsList.this.fParts; ++i) {
                        temp.append(KPermutationsList.this.fList.get(permutationsIndex[i] + KPermutationsList.this.fOffset));
                    }
                    return temp;
                }

                @Override
                public boolean hasNext() {
                    return this.fIterable.hasNext();
                }
            }
        }
    }

    private static final class PermutationReplace
    extends AbstractFunctionEvaluator {
        private PermutationReplace() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST cycles;
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg2.isList()) {
                return ((IAST)arg2).mapThread(ast, 2);
            }
            if (arg2.isAST(S.Cycles, 2) && (cycles = arg2.isEvalFlagOn(262144) ? (IAST)arg2 : Combinatoric.checkCycles((IAST)arg2, false, engine)).isPresent()) {
                IAST mainList = (IAST)cycles.arg1();
                if (arg1.isInteger()) {
                    IInteger intArg1 = (IInteger)arg1;
                    return PermutationReplace.replaceSingleElement(mainList, intArg1);
                }
                if (arg1.isList()) {
                    IAST list1 = (IAST)ast.arg1();
                    if (arg1.isListOfLists()) {
                        return list1.mapThread(ast, 1);
                    }
                    return Combinatoric.permutationReplace(list1, mainList);
                }
                return F.NIL;
            }
            return F.NIL;
        }

        private static IInteger replaceSingleElement(IAST mainList, IInteger intArg1) {
            IInteger result = intArg1;
            for (int j = 1; j < mainList.size(); ++j) {
                IAST list = (IAST)mainList.get(j);
                for (int i = 1; i < list.size(); ++i) {
                    IInteger arg = (IInteger)list.get(i);
                    if (!arg.equals(result)) continue;
                    result = i < list.size() - 1 ? (IInteger)list.get(i + 1) : (IInteger)list.arg1();
                    return result;
                }
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static final class PermutationListQ
    extends AbstractFunctionEvaluator {
        private PermutationListQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr permList = ast.arg1();
            if (permList.isList()) {
                return permList.isEmptyList() || Combinatoric.isPermutationList((IAST)permList, true, engine) != null ? S.True : S.False;
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class PermutationList
    extends AbstractFunctionEvaluator {
        private PermutationList() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST cycles;
            IExpr arg1 = ast.arg1();
            if (arg1.isAST(S.Cycles, 2) && (cycles = arg1.isEvalFlagOn(262144) ? (IAST)arg1 : Combinatoric.checkCycles((IAST)arg1, false, engine)).isPresent()) {
                IAST cyclesList = (IAST)cycles.arg1();
                if (cyclesList.isEmptyList()) {
                    return F.CEmptyList;
                }
                int permutationsListLength = PermutationList.determineLengthFromCycles(cyclesList);
                if (permutationsListLength < 1) {
                    return F.NIL;
                }
                if (ast.isAST2()) {
                    int arg2 = ast.arg2().toIntDefault();
                    if (arg2 < 1) {
                        return F.NIL;
                    }
                    if (arg2 >= permutationsListLength) {
                        permutationsListLength = arg2;
                    } else {
                        return IOFunctions.printMessage(ast.topHead(), "lowlen", F.list(ast.arg2(), F.ZZ(permutationsListLength), ast), engine);
                    }
                }
                IASTAppendable result = F.ListAlloc(permutationsListLength);
                for (int i = 1; i <= permutationsListLength; ++i) {
                    result.append(i);
                }
                return Combinatoric.permutationReplace(result, cyclesList);
            }
            return F.NIL;
        }

        private static int determineLengthFromCycles(IAST cyclesMainList) {
            int permutationsListLength = -1;
            for (int j = 1; j < cyclesMainList.size(); ++j) {
                IAST list = (IAST)cyclesMainList.get(j);
                for (int i = 1; i < list.size(); ++i) {
                    int position = list.get(i).toIntDefault();
                    if (position <= permutationsListLength) continue;
                    permutationsListLength = position;
                }
            }
            return permutationsListLength;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class PermutationCyclesQ
    extends AbstractFunctionEvaluator {
        private PermutationCyclesQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isAST(S.Cycles, 2)) {
                IAST cycles = Combinatoric.checkCycles((IAST)arg1, true, engine);
                return cycles.isPresent() ? S.True : S.False;
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class PermutationCycles
    extends AbstractFunctionEvaluator {
        private PermutationCycles() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.isAST1() && arg1.isAST(S.Cycles, 2)) {
                IAST cycles = (IAST)arg1;
                if (cycles.isEvalFlagOn(262144)) {
                    return cycles;
                }
                return Combinatoric.checkCycles(cycles, false, engine);
            }
            IExpr head = S.Cycles;
            if (ast.isAST2()) {
                head = ast.arg2();
            }
            if (arg1.isList()) {
                return Combinatoric.permutationCycles((IAST)arg1, engine, head);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class Permute
    extends AbstractFunctionEvaluator {
        private Permute() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (arg1.isAST()) {
                IAST cycles;
                if (arg2.isList()) {
                    IExpr temp = Combinatoric.permutationCycles((IAST)arg2, engine);
                    if (temp.isAST(S.Cycles, 2)) {
                        IAST mainList = (IAST)temp.first();
                        return Permute.permute((IAST)arg1, mainList, ast, engine);
                    }
                } else if (arg2.isAST(S.Cycles, 2) && (cycles = arg2.isEvalFlagOn(262144) ? (IAST)arg2 : Combinatoric.checkCycles((IAST)arg2, false, engine)).isPresent()) {
                    IAST mainList = (IAST)cycles.arg1();
                    return Permute.permute((IAST)arg1, mainList, ast, engine);
                }
            }
            return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C1, ast), engine);
        }

        private static IExpr permute(IAST list1, IAST cyclesMainList, IAST ast, EvalEngine engine) {
            IASTMutable result = list1.copy();
            boolean changed = false;
            for (int j = 1; j < cyclesMainList.size(); ++j) {
                IAST list = (IAST)cyclesMainList.get(j);
                for (int i = 1; i < list.size(); ++i) {
                    int fromPosition = list.get(i).toIntDefault();
                    if (fromPosition == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    if (fromPosition > list1.argSize()) {
                        return IOFunctions.printMessage(S.Permute, "lowlen", F.list(F.ZZ(list1.argSize()), list.get(i), ast), engine);
                    }
                    int toPosition = i < list.size() - 1 ? list.get(i + 1).toIntDefault() : list.arg1().toIntDefault();
                    if (toPosition == Integer.MIN_VALUE) {
                        return F.NIL;
                    }
                    if (toPosition > list1.argSize()) {
                        return IOFunctions.printMessage(S.Permute, "lowlen", F.list(F.ZZ(list1.argSize()), F.ZZ(toPosition), ast), engine);
                    }
                    changed = true;
                    IExpr from = list1.get(fromPosition);
                    result.set(toPosition, from);
                }
            }
            return changed ? result : list1;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class Partition
    extends AbstractFunctionEvaluator {
        private Partition() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int partitionLength;
            if (ast.arg1().isAST() && (partitionLength = ast.arg2().toIntDefault()) > 0) {
                int i = partitionLength;
                IAST f = (IAST)ast.arg1();
                if (i > f.argSize()) {
                    return F.headAST0(f.head());
                }
                int offset = partitionLength;
                if (ast.isAST3() && ast.arg3().isInteger()) {
                    offset = ast.arg3().toIntDefault();
                }
                if (offset > 0) {
                    int allocSize = f.argSize() / offset + 1;
                    IASTAppendable resultListOfPartitions = F.ast(f.head(), allocSize);
                    while (true) {
                        IASTAppendable singlePartition = F.ast(f.head());
                        for (int j = i - partitionLength; j < i; ++j) {
                            if (j + 1 < 1 || j + 1 >= f.size()) {
                                return resultListOfPartitions;
                            }
                            singlePartition.append(f.get(j + 1));
                        }
                        resultListOfPartitions.append(singlePartition);
                        if (offset > f.argSize() - i) break;
                        i += offset;
                    }
                    return resultListOfPartitions;
                }
                return IOFunctions.printMessage(ast.topHead(), "intpm", F.list(ast, F.C3), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }
    }

    private static final class MatchingDissimilarity
    extends AbstractEvaluator {
        private MatchingDissimilarity() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int dim2;
            int dim1 = ast.arg1().isVector();
            if (dim1 == (dim2 = ast.arg2().isVector()) && dim1 > 0) {
                IAST u = (IAST)ast.arg1().normal(false);
                IAST v = (IAST)ast.arg2().normal(false);
                int length = u.size();
                int n10 = 0;
                int n01 = 0;
                for (int i = 1; i < length; ++i) {
                    IExpr x = u.get(i);
                    IExpr y = v.get(i);
                    if ((x.isOne() || x.isTrue()) && (y.isZero() || y.isFalse())) {
                        ++n10;
                        continue;
                    }
                    if ((x.isZero() || x.isFalse()) && (y.isOne() || y.isTrue())) {
                        ++n01;
                        continue;
                    }
                    if (!(!x.isZero() && !x.isFalse() && !x.isOne() && !x.isTrue() || !y.isZero() && !y.isFalse() && !y.isOne() && !y.isTrue())) continue;
                    return F.NIL;
                }
                return F.Divide(F.ZZ((long)n10 + (long)n01), F.ZZ(length - 1));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class KPartitions
    extends AbstractFunctionEvaluator {
        private KPartitions() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAST() && ast.arg2().isInteger()) {
                IAST listArg0 = (IAST)ast.arg1();
                int k = ast.get(2).toIntDefault();
                if (k > 0 && k <= listArg0.argSize()) {
                    KPartitionsList iter = new KPartitionsList(listArg0, k, F.ast(S.List), 1);
                    IASTAppendable result = F.ListAlloc(16);
                    for (IAST part : iter) {
                        result.append(part);
                    }
                    return result;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        public static final class KPartitionsList
        implements Iterable<IAST> {
            private final IAST fList;
            private final IAST fResultList;
            private final int fKParts;
            private final int fOffset;

            public KPartitionsList(IAST list, int kParts, IAST resultList, int offset) {
                this.fList = list;
                this.fKParts = kParts;
                this.fResultList = resultList;
                this.fOffset = offset;
            }

            @Override
            public Iterator<IAST> iterator() {
                return new KPartitionsListIterator();
            }

            private class KPartitionsListIterator
            implements Iterator<IAST> {
                private final Iterator<int[]> fIterable;

                private KPartitionsListIterator() {
                    this.fIterable = new KPartitionsIterable(KPartitionsList.this.fList.size() - KPartitionsList.this.fOffset, KPartitionsList.this.fKParts).iterator();
                }

                @Override
                public IAST next() {
                    int m;
                    IASTAppendable temp;
                    int[] partitionsIndex = this.fIterable.next();
                    if (partitionsIndex == null) {
                        return null;
                    }
                    IASTAppendable part = KPartitionsList.this.fResultList.copyAppendable();
                    int j = 0;
                    for (int i = 1; i < partitionsIndex.length; ++i) {
                        temp = KPartitionsList.this.fResultList.copyAppendable();
                        for (m = j; m < partitionsIndex[i]; ++m) {
                            temp.append(KPartitionsList.this.fList.get(m + KPartitionsList.this.fOffset));
                        }
                        j = partitionsIndex[i];
                        part.append(temp);
                    }
                    temp = KPartitionsList.this.fResultList.copyAppendable();
                    int n = KPartitionsList.this.fList.size() - KPartitionsList.this.fOffset;
                    for (m = j; m < n; ++m) {
                        temp.append(KPartitionsList.this.fList.get(m + KPartitionsList.this.fOffset));
                    }
                    part.append(temp);
                    return part;
                }

                @Override
                public boolean hasNext() {
                    return this.fIterable.hasNext();
                }
            }
        }

        public static final class KPartitionsIterable
        implements Iterable<int[]> {
            private final int fLength;
            private final int fNumberOfParts;
            private final int[] fPartitionsIndex;
            private final int[] fCopiedResultIndex;

            public KPartitionsIterable(int length, int parts) {
                if (parts > length || parts < 1) {
                    throw new IllegalArgumentException("KPartitionsIterable: parts " + parts + " > " + length);
                }
                this.fLength = length;
                this.fNumberOfParts = parts;
                this.fPartitionsIndex = new int[this.fNumberOfParts];
                this.fCopiedResultIndex = new int[this.fNumberOfParts];
                this.fPartitionsIndex[0] = -1;
            }

            @Override
            public Iterator<int[]> iterator() {
                return new KPartitionsIterator();
            }

            private class KPartitionsIterator
            implements Iterator<int[]> {
                private int[] fResultIndex = this.nextBeforehand();

                private KPartitionsIterator() {
                }

                @Override
                public int[] next() {
                    System.arraycopy(this.fResultIndex, 0, KPartitionsIterable.this.fCopiedResultIndex, 0, this.fResultIndex.length);
                    this.fResultIndex = this.nextBeforehand();
                    return KPartitionsIterable.this.fCopiedResultIndex;
                }

                @Override
                public boolean hasNext() {
                    return this.fResultIndex != null;
                }

                private final int[] nextBeforehand() {
                    if (KPartitionsIterable.this.fPartitionsIndex[0] < 0) {
                        for (int i = 0; i < KPartitionsIterable.this.fNumberOfParts; ++i) {
                            KPartitionsIterable.this.fPartitionsIndex[i] = i;
                        }
                        return KPartitionsIterable.this.fPartitionsIndex;
                    }
                    int i = 0;
                    for (i = KPartitionsIterable.this.fNumberOfParts - 1; i >= 0 && KPartitionsIterable.this.fPartitionsIndex[i] >= KPartitionsIterable.this.fLength - KPartitionsIterable.this.fNumberOfParts + i; --i) {
                    }
                    if (i <= 0) {
                        return null;
                    }
                    int n = i;
                    KPartitionsIterable.this.fPartitionsIndex[n] = KPartitionsIterable.this.fPartitionsIndex[n] + 1;
                    for (int m = i + 1; m < KPartitionsIterable.this.fNumberOfParts; ++m) {
                        KPartitionsIterable.this.fPartitionsIndex[m] = KPartitionsIterable.this.fPartitionsIndex[m - 1] + 1;
                    }
                    return KPartitionsIterable.this.fPartitionsIndex;
                }
            }
        }
    }

    private static final class KOrderlessPartitions
    extends AbstractFunctionEvaluator {
        private KOrderlessPartitions() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int k = ast.arg2().toIntDefault();
            if (ast.arg1().isAST() && ast.arg1().size() > 1 && k > 0) {
                IAST listArg0 = (IAST)ast.arg1();
                if (k == 1) {
                    return F.list(listArg0);
                }
                int n = listArg0.argSize();
                if (k > n) {
                    return F.NIL;
                }
                ISymbol sym = listArg0.topHead();
                IASTAppendable result = F.ListAlloc(50);
                KPermutationsIterable permutationIterator = new KPermutationsIterable(listArg0, n, 1);
                for (int[] permutationsIndex : permutationIterator) {
                    KPartitions.KPartitionsIterable partitionIterator = new KPartitions.KPartitionsIterable(n, k);
                    for (int[] partitionsIndex : partitionIterator) {
                        IAST partition = this.createSinglePartition(listArg0, sym, permutationsIndex, partitionsIndex);
                        if (!partition.isPresent()) continue;
                        result.append(partition);
                    }
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        private IAST createSinglePartition(IAST listArg0, ISymbol symbol, int[] permutationsIndex, int[] partitionsIndex) {
            IASTAppendable partitionElement;
            IASTAppendable partition = F.ListAlloc(partitionsIndex.length + 1);
            int n = listArg0.argSize();
            int partitionStartIndex = 0;
            for (int i = 1; i < partitionsIndex.length; ++i) {
                partitionElement = F.ast(symbol);
                if (partitionStartIndex + 1 == partitionsIndex[i]) {
                    if (symbol.hasOneIdentityAttribute()) {
                        partition.append(listArg0.get(permutationsIndex[partitionStartIndex] + 1));
                    } else {
                        partitionElement.append(listArg0.get(permutationsIndex[partitionStartIndex] + 1));
                        partition.append(partitionElement);
                    }
                } else {
                    for (int m = partitionStartIndex; m < partitionsIndex[i]; ++m) {
                        if (m + 1 < partitionsIndex[i] && listArg0.get(permutationsIndex[m + 1] + 1).isLTOrdered(listArg0.get(permutationsIndex[m] + 1))) {
                            return F.NIL;
                        }
                        partitionElement.append(listArg0.get(permutationsIndex[m] + 1));
                    }
                    partition.append(partitionElement);
                }
                partitionStartIndex = partitionsIndex[i];
            }
            partitionElement = F.ast(symbol);
            if (partitionStartIndex + 1 == n) {
                if ((symbol.getAttributes() & 1) == 1) {
                    partition.append(listArg0.get(permutationsIndex[partitionStartIndex] + 1));
                } else {
                    partitionElement.append(listArg0.get(permutationsIndex[partitionStartIndex] + 1));
                    partition.append(partitionElement);
                }
            } else {
                for (int m = partitionStartIndex; m < n; ++m) {
                    if (m + 1 < n && listArg0.get(permutationsIndex[m + 1] + 1).isLTOrdered(listArg0.get(permutationsIndex[m] + 1))) {
                        return F.NIL;
                    }
                    partitionElement.append(listArg0.get(permutationsIndex[m] + 1));
                }
                partition.append(partitionElement);
            }
            return partition;
        }
    }

    private static class JaccardDissimilarity
    extends AbstractEvaluator {
        private JaccardDissimilarity() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int dim2;
            int dim1 = ast.arg1().isVector();
            if (dim1 == (dim2 = ast.arg2().isVector()) && dim1 > 0) {
                IAST u = (IAST)ast.arg1().normal(false);
                IAST v = (IAST)ast.arg2().normal(false);
                int length = u.size();
                int n10 = 0;
                int n01 = 0;
                int n11 = 0;
                for (int i = 1; i < length; ++i) {
                    IExpr x = u.get(i);
                    IExpr y = v.get(i);
                    if ((x.isOne() || x.isTrue()) && (y.isZero() || y.isFalse())) {
                        ++n10;
                        continue;
                    }
                    if ((x.isZero() || x.isFalse()) && (y.isOne() || y.isTrue())) {
                        ++n01;
                        continue;
                    }
                    if ((x.isOne() || x.isTrue()) && (y.isOne() || y.isTrue())) {
                        ++n11;
                        continue;
                    }
                    if (!(!x.isZero() && !x.isFalse() && !x.isOne() && !x.isTrue() || !y.isZero() && !y.isFalse() && !y.isOne() && !y.isTrue())) continue;
                    return F.NIL;
                }
                return F.Divide(F.ZZ((long)n10 + (long)n01), F.ZZ((long)n11 + (long)n10 + (long)n01));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class IntegerPartitions
    extends AbstractFunctionEvaluator {
        private IntegerPartitions() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IntRangeSpec range = IntRangeSpec.createNonNegative(ast, 2);
            if (range != null) {
                IExpr arg1 = ast.arg1();
                if (arg1.isInteger()) {
                    int n = arg1.toIntDefault(-1);
                    if (n >= 0) {
                        int max = range.maximum();
                        if (max > n) {
                            range = new IntRangeSpec(1, n);
                            max = range.maximum();
                        }
                        if (ast.isAST3()) {
                            return IntegerPartitions.frobeniusPartition(ast, engine);
                        }
                        if (n == 0) {
                            return F.list(F.CEmptyList);
                        }
                        if (n == 1) {
                            return F.list(F.list(F.C1));
                        }
                        if (range.isIncluded(0) && !range.isIncluded(1)) {
                            return F.CEmptyList;
                        }
                        NumberPartitionsIterable comb = new NumberPartitionsIterable(n, max);
                        IASTAppendable result = F.ListAlloc(50);
                        int iterationLimit = engine.getIterationLimit();
                        int iterationCounter = 0;
                        for (int[] j : comb) {
                            int i;
                            if (iterationLimit >= 0 && iterationLimit <= ++iterationCounter) {
                                IterationLimitExceeded.throwIt(iterationCounter, ast);
                            }
                            if (j.length > max && j[max] != 0) continue;
                            int count = 0;
                            for (i = 0; i < j.length; ++i) {
                                if (j[i] == 0) continue;
                                ++count;
                            }
                            if (!range.isIncluded(count)) continue;
                            IASTAppendable temp = F.ListAlloc(j.length);
                            for (i = 0; i < j.length && j[i] != 0; ++i) {
                                temp.append(j[i]);
                            }
                            result.append(temp);
                            if (max != 1) continue;
                            break;
                        }
                        return result;
                    }
                    if (arg1.isNegative()) {
                        return F.CEmptyList;
                    }
                } else if (arg1.isFraction() && ast.size() == 2) {
                    return F.CEmptyList;
                }
            }
            return F.NIL;
        }

        private static IExpr frobeniusPartition(IAST ast, EvalEngine engine) {
            if (ast.arg3().isNonEmptyList() && ast.arg1().isInteger()) {
                try {
                    int[] listInt = Validate.checkListOfInts(ast, ast.arg3(), Integer.MIN_VALUE, Integer.MAX_VALUE, engine);
                    if (listInt != null) {
                        IInteger[] solution;
                        IInteger lowerLimitOfCoins = F.C0;
                        IInteger upperLimitOfCoins = F.ZZ(Integer.MAX_VALUE);
                        if (ast.arg2().isInteger()) {
                            upperLimitOfCoins = (IInteger)ast.arg2();
                        } else if (ast.arg2().isAST(S.List, 3) && ast.arg2().first().isInteger() && ast.arg2().second().isInteger()) {
                            lowerLimitOfCoins = (IInteger)ast.arg2().first();
                            upperLimitOfCoins = (IInteger)ast.arg2().second();
                        } else if (ast.arg2() != S.All) {
                            return F.NIL;
                        }
                        FrobeniusSolver solver = FrobeniusSolve.getSolver(listInt, (IInteger)ast.arg1());
                        int numberOfSolutions = -1;
                        if (ast.size() == 5) {
                            numberOfSolutions = ast.arg5().toIntDefault(-1);
                        }
                        IASTAppendable result = F.ListAlloc(8);
                        int iterations = 0;
                        int iterationLimit = engine.getIterationLimit();
                        while ((solution = solver.take()) != null) {
                            if (iterationLimit > 0 && iterations > iterationLimit) {
                                IOFunctions.printMessage(ast.topHead(), "itlimpartial", F.list(F.ZZ(iterationLimit)), engine);
                                return result;
                            }
                            if (numberOfSolutions >= 0 && --numberOfSolutions < 0) break;
                            ++iterations;
                            if (IntegerPartitions.createFrobeniusSolution(solution, listInt, lowerLimitOfCoins, upperLimitOfCoins, result)) continue;
                            return F.NIL;
                        }
                        return result;
                    }
                }
                catch (LimitException le) {
                    throw le;
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("IntegerPartitions.frobeniusPartition() failed", (Throwable)rex);
                }
            }
            return F.NIL;
        }

        private static boolean createFrobeniusSolution(IInteger[] frobeniusSolution, int[] numberSpecification, IInteger lowerLimitOfCoins, IInteger upperLimitOfCoins, IASTAppendable result) {
            IInteger sum = F.C0;
            for (int i = 0; i < frobeniusSolution.length; ++i) {
                sum = sum.add(frobeniusSolution[i]);
            }
            if (sum.isGE(lowerLimitOfCoins) && sum.isLE(upperLimitOfCoins)) {
                IASTAppendable list = F.ListAlloc();
                for (int i = frobeniusSolution.length - 1; i >= 0; --i) {
                    int counter = frobeniusSolution[i].toIntDefault();
                    if (counter == Integer.MIN_VALUE) {
                        return false;
                    }
                    if (counter <= 0) continue;
                    IInteger value = F.ZZ(numberSpecification[i]);
                    for (int j = 0; j < counter; ++j) {
                        list.append(value);
                    }
                }
                result.append(list);
            }
            return true;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        public static final class NumberPartitionsIterable
        implements Iterable<int[]> {
            private final int n;
            private final int len;

            public NumberPartitionsIterable(int n, int l) {
                this.n = n;
                this.len = l;
                int size = n;
                if (this.len > n) {
                    size = this.len;
                }
                if (Config.MAX_AST_SIZE < size) {
                    ASTElementLimitExceeded.throwIt(size);
                }
            }

            @Override
            public Iterator<int[]> iterator() {
                return new NumberPartitionsIterator();
            }

            private class NumberPartitionsIterator
            implements Iterator<int[]> {
                private int i = 0;
                private int k = 0;
                private final int[] fPartititionsIndex;
                private final int[] fCopiedResultIndex;
                private int[] fResultIndex;

                private NumberPartitionsIterator() {
                    int size = NumberPartitionsIterable.this.n;
                    if (NumberPartitionsIterable.this.len > NumberPartitionsIterable.this.n) {
                        size = NumberPartitionsIterable.this.len;
                    }
                    this.fPartititionsIndex = new int[size];
                    this.fCopiedResultIndex = new int[size];
                    this.fResultIndex = this.nextBeforehand();
                }

                /*
                 * Exception decompiling
                 */
                private final int[] nextBeforehand() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @Override
                public int[] next() {
                    System.arraycopy(this.fResultIndex, 0, this.fCopiedResultIndex, 0, this.fResultIndex.length);
                    this.fResultIndex = this.nextBeforehand();
                    return this.fCopiedResultIndex;
                }

                @Override
                public boolean hasNext() {
                    return this.fResultIndex != null;
                }
            }
        }
    }

    private static final class FindPermutation
    extends AbstractFunctionEvaluator {
        private FindPermutation() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2;
            IExpr arg1 = ast.arg1();
            if (!arg1.isAST()) {
                return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C1, ast), engine);
            }
            IAST ast1 = (IAST)arg1;
            if (ast.isAST2()) {
                arg2 = ast.arg2();
                if (!arg2.isAST()) {
                    return IOFunctions.printMessage(ast.topHead(), "normal", F.list(F.C2, ast), engine);
                }
            } else {
                if (ast1.size() == 1) {
                    return F.Cycles(F.CEmptyList);
                }
                IExpr ordering = S.Ordering.of(engine, ast1);
                if (ordering.isList()) {
                    return Combinatoric.permutationCycles((IAST)ordering, engine);
                }
                return F.NIL;
            }
            IAST ast2 = (IAST)arg2;
            if (ast1.size() != ast2.size() || !ast1.head().equals(ast2.head())) {
                return IOFunctions.printMessage(ast.topHead(), "norel", F.list(ast1, ast2), engine);
            }
            if (ast1.size() == 1) {
                return F.Cycles(F.CEmptyList);
            }
            Map<IExpr, MutableInt> histogramMap = MutableInt.createHistogram(ast1);
            if (!MutableInt.isEqualPermutable(ast2, histogramMap)) {
                return IOFunctions.printMessage(ast.topHead(), "norel", F.list(ast1, ast2), engine);
            }
            IAST permList = FindPermutation.permutationList(ast1, ast2);
            return Combinatoric.permutationCycles(permList, engine);
        }

        private static IAST permutationList(IAST ast1, IAST ast2) {
            int[] positions = new int[ast1.size() - 1];
            for (int i = 0; i < positions.length; ++i) {
                positions[i] = i + 1;
            }
            IASTAppendable permList = F.ListAlloc(ast1.size());
            block1: for (int j = 1; j < ast1.size(); ++j) {
                IExpr expr1 = ast1.get(j);
                for (int i = 1; i < ast2.size(); ++i) {
                    if (positions[i - 1] <= 0 || !expr1.equals(ast2.get(i))) continue;
                    permList.append(i);
                    positions[i - 1] = -1;
                    continue block1;
                }
            }
            return permList;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class DiceDissimilarity
    extends AbstractEvaluator {
        private DiceDissimilarity() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int dim2;
            int dim1 = ast.arg1().isVector();
            if (dim1 == (dim2 = ast.arg2().isVector()) && dim1 > 0) {
                IAST u = (IAST)ast.arg1().normal(false);
                IAST v = (IAST)ast.arg2().normal(false);
                int length = u.size();
                int n10 = 0;
                int n01 = 0;
                int n11 = 0;
                for (int i = 1; i < length; ++i) {
                    IExpr x = u.get(i);
                    IExpr y = v.get(i);
                    if ((x.isOne() || x.isTrue()) && (y.isZero() || y.isFalse())) {
                        ++n10;
                        continue;
                    }
                    if ((x.isZero() || x.isFalse()) && (y.isOne() || y.isTrue())) {
                        ++n01;
                        continue;
                    }
                    if ((x.isOne() || x.isTrue()) && (y.isOne() || y.isTrue())) {
                        ++n11;
                        continue;
                    }
                    if (!(!x.isZero() && !x.isFalse() && !x.isOne() && !x.isTrue() || !y.isZero() && !y.isFalse() && !y.isOne() && !y.isTrue())) continue;
                    return F.NIL;
                }
                return F.Divide(F.ZZ((long)n10 + (long)n01), F.ZZ(2L * (long)n11 + (long)n10 + (long)n01));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Cycles
    extends AbstractFunctionEvaluator {
        private Cycles() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head().equals(S.Cycles)) {
                if (ast.isEvalFlagOn(262144)) {
                    return F.NIL;
                }
                IAST temp = Cycles.canonicalizeCycles(ast, false, engine);
                if (temp.equals(ast)) {
                    ast.addEvalFlags(262144);
                    return F.NIL;
                }
                return temp;
            }
            return F.NIL;
        }

        private static IAST canonicalizeCycles(IAST cycles, boolean quiet, EvalEngine engine) {
            if (cycles.arg1().isList()) {
                IAST mainList = (IAST)cycles.arg1();
                if (mainList.isEmptyList()) {
                    cycles.addEvalFlags(262144);
                    return F.NIL;
                }
                if (!mainList.isListOfLists()) {
                    IExpr temp = mainList.normal(false);
                    if (!temp.isListOfLists()) {
                        if (!quiet && temp.isAST()) {
                            IAST list = (IAST)temp;
                            for (int i = 0; i < list.size(); ++i) {
                                if (!list.get(i).isNumber()) continue;
                                return IOFunctions.printMessage(S.Cycles, "intpoint", F.list(cycles), engine);
                            }
                        }
                        return F.NIL;
                    }
                    mainList = (IAST)temp;
                }
                IASTAppendable result = F.ListAlloc(mainList.argSize());
                HashSet<IExpr> set = new HashSet<IExpr>();
                for (int j = 1; j < mainList.size(); ++j) {
                    IAST list = (IAST)mainList.get(j);
                    for (int i = 1; i < list.size(); ++i) {
                        IExpr arg = list.get(i);
                        if (arg.isInteger()) {
                            if (!arg.isPositive()) {
                                if (!quiet) {
                                    IOFunctions.printMessage(S.Cycles, "pospoint", F.list(cycles), engine);
                                }
                                return F.NIL;
                            }
                            if (set.contains(arg)) {
                                if (!quiet) {
                                    IOFunctions.printMessage(S.Cycles, "reppoint", F.list(cycles), engine);
                                }
                                return F.NIL;
                            }
                        } else {
                            if (arg.isNumber()) {
                                if (!quiet) {
                                    IOFunctions.printMessage(S.Cycles, "intpoint", F.list(cycles), engine);
                                }
                                return F.NIL;
                            }
                            return F.NIL;
                        }
                        set.add(arg);
                    }
                    if (list.size() <= 2) continue;
                    int rotateLeftPositions = 0;
                    IInteger value = (IInteger)list.get(1);
                    for (int i = 1; i < list.size(); ++i) {
                        IInteger arg = (IInteger)list.get(i);
                        if (!value.isGT(arg)) continue;
                        value = arg;
                        rotateLeftPositions = i - 1;
                    }
                    if (rotateLeftPositions > 0) {
                        IASTAppendable newList = F.ListAlloc(list.size());
                        result.append(list.rotateLeft(newList, rotateLeftPositions));
                        continue;
                    }
                    result.append(list);
                }
                EvalAttributes.sort(result);
                IAST resultCycles = F.Cycles(result);
                resultCycles.addEvalFlags(262144);
                return resultCycles;
            }
            if (!quiet) {
                IOFunctions.printMessage(S.Cycles, "intpoint", F.list(cycles), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class CartesianProduct
    extends AbstractFunctionEvaluator {
        private CartesianProduct() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            ArrayList<IAST> la = new ArrayList<IAST>(ast.argSize());
            int resultSize = 1;
            for (int i = 1; i < ast.size(); ++i) {
                if (ast.get(i).isList()) {
                    IAST subList = (IAST)ast.get(i);
                    la.add(subList);
                    resultSize *= subList.size();
                    continue;
                }
                return F.NIL;
            }
            CartesianProductList cpi = new CartesianProductList(la, F.ListAlloc(la.size()));
            IASTAppendable result = F.ListAlloc(resultSize);
            for (IAST iast : cpi) {
                result.append(iast);
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_INFINITY;
        }

        static final class CartesianProductList
        implements Iterable<IAST> {
            public final List<IAST> comps;
            private final IASTAppendable fEmptyResultList;

            public CartesianProductList(List<IAST> comps, IASTAppendable emptyResultList) {
                if (comps == null) {
                    throw new IllegalArgumentException("null components not allowed");
                }
                this.comps = comps;
                this.fEmptyResultList = emptyResultList;
            }

            @Override
            public Iterator<IAST> iterator() {
                return new CartesianProductIterator(this.comps, this.fEmptyResultList);
            }
        }

        static final class CartesianProductIterator
        implements Iterator<IAST> {
            final List<IAST> comps;
            final List<Iterator<IExpr>> compit;
            IASTAppendable current;
            boolean empty;

            public CartesianProductIterator(List<IAST> comps, IASTAppendable emptyResultList) {
                if (comps == null) {
                    throw new IllegalArgumentException("null comps not allowed");
                }
                this.comps = comps;
                this.current = emptyResultList;
                this.compit = new ArrayList<Iterator<IExpr>>(comps.size());
                this.empty = false;
                for (IAST ci : comps) {
                    Iterator<IExpr> it = ci.iterator();
                    if (!it.hasNext()) {
                        this.empty = true;
                        this.current.clear();
                        break;
                    }
                    this.current.append(it.next());
                    this.compit.add(it);
                }
            }

            @Override
            public synchronized boolean hasNext() {
                return !this.empty;
            }

            @Override
            public synchronized IAST next() {
                Iterator<IExpr> iter;
                int j;
                Iterator<IExpr> iter2;
                int i;
                if (this.empty) {
                    throw new RuntimeException("invalid call of next()");
                }
                IASTAppendable res = this.current.copyAppendable();
                for (i = this.compit.size() - 1; i >= 0 && !(iter2 = this.compit.get(i)).hasNext(); --i) {
                }
                if (i < 0) {
                    this.empty = true;
                    return res;
                }
                for (j = i + 1; j < this.compit.size(); ++j) {
                    iter = this.comps.get(j).iterator();
                    this.compit.set(j, iter);
                }
                for (j = i; j < this.compit.size(); ++j) {
                    iter = this.compit.get(j);
                    IExpr el = iter.next();
                    this.current.set(j + 1, el);
                }
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("cannnot remove tuples");
            }
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.CartesianProduct.setEvaluator(new CartesianProduct());
            S.Cycles.setEvaluator(new Cycles());
            S.DiceDissimilarity.setEvaluator(new DiceDissimilarity());
            S.FindPermutation.setEvaluator(new FindPermutation());
            S.IntegerPartitions.setEvaluator(new IntegerPartitions());
            S.JaccardDissimilarity.setEvaluator(new JaccardDissimilarity());
            S.KOrderlessPartitions.setEvaluator(new KOrderlessPartitions());
            S.KPartitions.setEvaluator(new KPartitions());
            S.MatchingDissimilarity.setEvaluator(new MatchingDissimilarity());
            S.Partition.setEvaluator(new Partition());
            S.Permute.setEvaluator(new Permute());
            S.PermutationCycles.setEvaluator(new PermutationCycles());
            S.PermutationCyclesQ.setEvaluator(new PermutationCyclesQ());
            S.PermutationList.setEvaluator(new PermutationList());
            S.PermutationListQ.setEvaluator(new PermutationListQ());
            S.PermutationReplace.setEvaluator(new PermutationReplace());
            S.Permutations.setEvaluator(new Permutations());
            S.PolygonalNumber.setEvaluator(new PolygonalNumber());
            S.RogersTanimotoDissimilarity.setEvaluator(new RogersTanimotoDissimilarity());
            S.RussellRaoDissimilarity.setEvaluator(new RussellRaoDissimilarity());
            S.Signature.setEvaluator(new Signature());
            S.SokalSneathDissimilarity.setEvaluator(new SokalSneathDissimilarity());
            S.Subsets.setEvaluator(new Subsets());
            S.Tuples.setEvaluator(new Tuples());
            S.YuleDissimilarity.setEvaluator(new YuleDissimilarity());
        }
    }
}

