/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.HashMap;
import java.util.Map;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class BoxesFunctions {
    public static void initialize() {
        Initializer.init();
    }

    private BoxesFunctions() {
    }

    private static class ToBoxes
    extends MakeBoxes {
        private ToBoxes() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return super.evaluate(ast, engine);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class MakeBoxes
    extends AbstractEvaluator {
        private static StandardFormOperator RULE = new StandardFormOperator(120, "\\[Rule]");
        private static StandardFormOperator RULE_DELAYED = new StandardFormOperator(120, "\\[RuleDelayed]");
        private static Map<ISymbol, StandardFormOperator> OPERATOR_MAP = new HashMap<ISymbol, StandardFormOperator>();

        private MakeBoxes() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr form = S.StandardForm;
            if (ast.isAST2()) {
                form = ast.arg2();
            }
            if (form == S.StandardForm) {
                return MakeBoxes.standardFormRecursive(ast.arg1(), 0);
            }
            return MakeBoxes.standardFormRecursive(ast.arg1(), 0);
        }

        private static IExpr standardFormRecursive(IExpr expr, int precedence) {
            if (expr.isAST()) {
                IAST function = (IAST)expr;
                if (function.size() > 0) {
                    IASTAppendable argsList;
                    StandardFormOperator operator;
                    if (function.isList()) {
                        IASTAppendable list = F.ListAlloc(3);
                        list.append("{");
                        IASTAppendable argsList2 = F.ListAlloc(function.size());
                        for (int i = 1; i < function.size(); ++i) {
                            argsList2.append(MakeBoxes.standardFormRecursive(function.get(i), precedence));
                            if (i >= function.size() - 1) continue;
                            argsList2.append(",");
                        }
                        list.append(F.RowBox(argsList2));
                        list.append("}");
                        return F.RowBox(list);
                    }
                    if (function.head().isSymbol() && (operator = OPERATOR_MAP.get(function.head())) != null && operator.convert(argsList = F.ListAlloc(function.size()), function, precedence)) {
                        return F.RowBox(argsList);
                    }
                    IASTAppendable list = F.ListAlloc(4);
                    list.append(MakeBoxes.standardFormRecursive(function.head(), precedence));
                    list.append("[");
                    argsList = F.ListAlloc(function.size());
                    for (int i = 1; i < function.size(); ++i) {
                        argsList.append(MakeBoxes.standardFormRecursive(function.get(i), precedence));
                        if (i >= function.size() - 1) continue;
                        argsList.append(",");
                    }
                    list.append(F.RowBox(argsList));
                    list.append("]");
                    return F.RowBox(list);
                }
            } else {
                if (expr.isSymbol()) {
                    return F.$str(expr.toString());
                }
                if (expr.isNumber()) {
                    if (expr.isInteger()) {
                        return F.$str(expr.toString());
                    }
                    if (expr.isRational()) {
                        IRational rational = (IRational)expr;
                        IInteger num = rational.numerator();
                        IInteger den = rational.denominator();
                        return F.FractionBox(F.$str(num.toString()), F.$str(den.toString()));
                    }
                    if (expr.isComplex()) {
                        IComplex complex = (IComplex)expr;
                        IRational re = complex.re();
                        IRational im = complex.im();
                        if (re.isZero()) {
                            return F.RowBox(F.list(MakeBoxes.standardFormRecursive(im, precedence), F.$str(" "), F.$str("\\[ImaginaryI]")));
                        }
                        return F.RowBox(F.list(MakeBoxes.standardFormRecursive(re, precedence), F.$str("+"), F.RowBox(F.list(MakeBoxes.standardFormRecursive(im, precedence), F.$str(" "), F.$str("\\[ImaginaryI]")))));
                    }
                    if (expr.isReal()) {
                        return F.$str(expr.toString());
                    }
                    if (expr.isComplexNumeric()) {
                        IComplexNum complex = (IComplexNum)expr;
                        ISignedNumber re = complex.re();
                        ISignedNumber im = complex.im();
                        if (re.isZero()) {
                            return F.RowBox(F.list(F.$str(im.toString()), F.$str(" "), F.$str("\\[ImaginaryI]")));
                        }
                        return F.RowBox(F.list(F.$str(re.toString()), F.$str("+"), F.RowBox(F.list(F.$str(im.toString()), F.$str(" "), F.$str("\\[ImaginaryI]")))));
                    }
                }
            }
            return F.$str(expr.toString());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262624);
            OPERATOR_MAP.put(S.Rule, RULE);
            OPERATOR_MAP.put(S.RuleDelayed, RULE_DELAYED);
            super.setUp(newSymbol);
        }

        private static class StandardFormOperator {
            protected int fPrecedence;
            protected String fOperator;

            public StandardFormOperator(int precedence, String oper) {
                this.fPrecedence = precedence;
                this.fOperator = oper;
            }

            public boolean convert(IASTAppendable list, IAST f, int precedence) {
                this.precedenceOpen(list, precedence);
                for (int i = 1; i < f.size(); ++i) {
                    list.append(MakeBoxes.standardFormRecursive(f.get(i), this.fPrecedence));
                    if (i >= f.argSize() || this.fOperator.compareTo("") == 0) continue;
                    list.append(this.fOperator);
                }
                this.precedenceClose(list, precedence);
                return true;
            }

            public void precedenceClose(IASTAppendable list, int precedence) {
                if (precedence > this.fPrecedence) {
                    list.append(")");
                }
            }

            public void precedenceOpen(IASTAppendable list, int precedence) {
                if (precedence > this.fPrecedence) {
                    list.append("(");
                }
            }
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.MakeBoxes.setEvaluator(new MakeBoxes());
            S.ToBoxes.setEvaluator(new ToBoxes());
        }
    }
}

